/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import com.topografix.gpx._1._0.Gpx;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.fibs.geotag.gpsbabel.GPSBabel;
import org.fibs.geotag.tasks.BackgroundTask;
import org.fibs.geotag.track.GpxReader;
import org.fibs.geotag.util.InputStreamGobbler;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class GPSBabelTask
extends BackgroundTask<Gpx> {
    private static final I18n i18n = I18nFactory.getI18n(GPSBabelTask.class);
    private int trackPointsReceived = 0;
    private int currentProgress;
    private int minProgress;
    private int maxProgress;
    private List<String> errorMessages = new ArrayList<String>();

    public GPSBabelTask(String name) {
        super(name);
    }

    @Override
    public int getCurrentProgress() {
        return this.currentProgress;
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Override
    public int getMinProgress() {
        return this.minProgress;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    void setCurrentProgress(int currentProgress) {
        this.currentProgress = currentProgress;
    }

    void setMinProgress(int minProgress) {
        this.minProgress = minProgress;
    }

    void setMaxProgress(int maxProgress) {
        this.maxProgress = maxProgress;
    }

    void setErrorMessages(List<String> errorMessages) {
        this.errorMessages = errorMessages;
    }

    synchronized boolean checkTerminate() {
        if (this.interruptRequested()) {
            GPSBabel.terminate();
            return true;
        }
        return false;
    }

    @Override
    protected String doInBackground() throws Exception {
        Gpx gpx;
        new Thread(){

            @Override
            public void run() {
                while (!GPSBabelTask.this.checkTerminate()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
        this.firePropertyChange("progress", null, i18n.tr("Connecting to GPS"));
        File file = GPSBabel.readTracks(new Gobbler());
        if (file != null && (gpx = GpxReader.read(file)) != null) {
            this.publish(gpx);
            List<Gpx.Trk> tracks = gpx.getTrk();
            for (Gpx.Trk trk : tracks) {
                List<Gpx.Trk.Trkseg> segments = trk.getTrkseg();
                for (Gpx.Trk.Trkseg segment : segments) {
                    this.trackPointsReceived += segment.getTrkpt().size();
                }
            }
        }
        this.interruptRequest();
        StringBuilder message = new StringBuilder();
        message.append(i18n.tr("Finished GPS transfer"));
        message.append(' ').append(this.trackPointsReceived).append(' ');
        message.append(i18n.tr("locations loaded."));
        return message.toString();
    }

    class Gobbler
    extends InputStreamGobbler {
        private static final int BUFFER_SIZE = 128;
        private String progressMessage;

        public Gobbler() {
            super((InputStream)null, (OutputStream)null);
            this.progressMessage = "";
        }

        @Override
        public void run() {
            InputStream inputStream = this.getInputStream();
            byte[] buffer = new byte[128];
            int bytesInBuffer = 0;
            try {
                int b;
                while ((b = inputStream.read()) != -1) {
                    buffer[bytesInBuffer] = (byte)b;
                    if (b != 13 && b != 10 && ++bytesInBuffer != buffer.length) continue;
                    while (bytesInBuffer > 0 && (buffer[bytesInBuffer - 1] == 13 || buffer[bytesInBuffer - 1] == 10)) {
                        --bytesInBuffer;
                    }
                    if (bytesInBuffer > 0) {
                        String line = new String(buffer, 0, bytesInBuffer);
                        this.handleGPSBabelLine(line);
                    }
                    bytesInBuffer = 0;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void handleGPSBabelLine(String line) {
            try {
                StringTokenizer tokenizer = new StringTokenizer(line, "/");
                if (tokenizer.countTokens() == 3) {
                    tokenizer.nextToken();
                    int read = Integer.parseInt(tokenizer.nextToken());
                    int expected = Integer.parseInt(tokenizer.nextToken());
                    GPSBabelTask.this.setMinProgress(1);
                    GPSBabelTask.this.setMaxProgress(expected);
                    GPSBabelTask.this.setCurrentProgress(read);
                    String message = String.valueOf(i18n.tr("Waypoint")) + ' ' + GPSBabelTask.this.getCurrentProgress() + ' ' + i18n.tr("of") + ' ' + GPSBabelTask.this.getMaxProgress();
                    GPSBabelTask.this.firePropertyChange("progress", this.progressMessage, message);
                    this.progressMessage = message;
                } else {
                    GPSBabelTask.this.getErrorMessages().add(line);
                }
            }
            catch (RuntimeException e) {
                GPSBabelTask.this.getErrorMessages().add(line);
            }
        }
    }
}

