/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.util.ArrayList;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.buffer.BufferAdapter;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.textarea.ColumnBlock;
import org.gjt.sp.jedit.textarea.Node;
import org.gjt.sp.jedit.textarea.TextArea;

public class ElasticTabStopBufferListener
extends BufferAdapter {
    private final TextArea textArea;
    private boolean handledInsertion = true;
    private boolean handledDeletion = true;
    private boolean singleTabDeleted;

    public ElasticTabStopBufferListener(TextArea textArea) {
        this.textArea = textArea;
    }

    private void fullyUpdateColumnBlocks(JEditBuffer jEditBuffer) {
        jEditBuffer.indentUsingElasticTabstops();
        this.handledInsertion = true;
        this.handledDeletion = true;
        jEditBuffer.getColumnBlock().setDirtyStatus(false);
        this.textArea.chunkCache.invalidateChunksFromPhys(0);
        this.textArea.invalidateLineRange(0, jEditBuffer.getLineCount() - 1);
    }

    @Override
    public void contentInserted(JEditBuffer jEditBuffer, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        ColumnBlock columnBlock;
        if (!jEditBuffer.elasticTabstopsOn) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (n3 == 0 && n4 == 1) {
            bl = true;
            String string = jEditBuffer.getText(n2, n4);
            if (string.equals("\t")) {
                bl2 = true;
            }
        }
        if ((columnBlock = jEditBuffer.getColumnBlock()) == null) {
            return;
        }
        ColumnBlock columnBlock2 = columnBlock.searchChildren(n);
        ColumnBlock columnBlock3 = null;
        boolean bl3 = false;
        int n7 = -1;
        if (columnBlock2 != null) {
            n7 = columnBlock.getChildren().indexOf(columnBlock2);
            n6 = n7 - 1;
            if (columnBlock2.isLineWithinThisBlock(n) == 0) {
                ++n7;
                bl3 = true;
            }
        } else {
            n7 = columnBlock.getChildren().size();
            n6 = n7 - 1;
        }
        if (n6 >= 0 && ((ColumnBlock)columnBlock.getChildren().get((int)n6)).endLine + 1 == n) {
            columnBlock3 = (ColumnBlock)columnBlock.getChildren().get(n6);
        }
        if (n3 > 0) {
            columnBlock.endLine += n3;
            for (n5 = n7; n5 < columnBlock.getChildren().size(); ++n5) {
                ((ColumnBlock)columnBlock.getChildren().get(n5)).updateLineNo(n3);
            }
        }
        n5 = -1;
        int n8 = -1;
        if (bl3) {
            ColumnBlock columnBlock4 = columnBlock2.getContainingBlock(n, n2);
            if (bl && (columnBlock4 != null || !bl2)) {
                if (columnBlock4 != null) {
                    if (!bl2) {
                        columnBlock4.updateColumnBlockLineOffset(n, n4, false);
                        n5 = columnBlock4.startLine;
                        columnBlock4.setTabSizeDirtyStatus(true, false);
                        n8 = columnBlock4.endLine;
                    } else {
                        ColumnBlock columnBlock5 = (ColumnBlock)columnBlock4.getParent();
                        n5 = columnBlock5.startLine;
                        n8 = columnBlock5.endLine;
                        columnBlock5.getChildren().removeAllElements();
                        jEditBuffer.updateColumnBlocks(n5, n8, (int)columnBlock5.columnBlockWidth, columnBlock5);
                    }
                } else {
                    n5 = n;
                    n8 = n;
                }
            }
            if (!bl || columnBlock4 == null && bl2) {
                n5 = columnBlock2.getStartLine();
                n8 = columnBlock2.getEndLine() + n3;
                columnBlock.getChildren().remove(columnBlock2);
                jEditBuffer.updateColumnBlocks(n5, n8, 0, columnBlock);
            }
        } else {
            Segment segment = new Segment();
            jEditBuffer.getText(n2, n4, segment);
            if (jEditBuffer.getTabStopPosition(segment) >= 0) {
                if (columnBlock3 != null) {
                    columnBlock.getChildren().remove(columnBlock3);
                    n5 = columnBlock3.startLine;
                } else {
                    n5 = n;
                }
                if (columnBlock2 != null && columnBlock2.startLine == n + n3 + 1) {
                    columnBlock.getChildren().remove(columnBlock2);
                    n8 = columnBlock2.endLine;
                } else {
                    n8 = n + n3;
                }
                jEditBuffer.updateColumnBlocks(n5, n8, 0, columnBlock);
            }
        }
        this.handledInsertion = true;
        columnBlock.setDirtyStatus(false);
        if (n5 != -1 && n8 != -1 && this.handledDeletion) {
            this.textArea.chunkCache.invalidateChunksFromPhys(n5);
            this.textArea.invalidateLineRange(n5, n8);
        }
    }

    @Override
    public void contentRemoved(JEditBuffer jEditBuffer, int n, int n2, int n3, int n4) {
        if (!jEditBuffer.elasticTabstopsOn) {
            return;
        }
        boolean bl = false;
        ColumnBlock columnBlock = jEditBuffer.getColumnBlock();
        if (columnBlock == null) {
            return;
        }
        if (n3 == 0 && n4 == 1) {
            bl = true;
        }
        if (!bl) {
            int n5;
            int n6;
            ColumnBlock columnBlock2 = columnBlock.searchChildren(n);
            int n7 = -1;
            int n8 = -1;
            ColumnBlock columnBlock3 = null;
            ColumnBlock columnBlock4 = null;
            ColumnBlock columnBlock5 = null;
            if (columnBlock2 != null) {
                boolean bl2;
                int n9 = columnBlock.getChildren().indexOf(columnBlock2);
                ColumnBlock columnBlock6 = null;
                n6 = 0;
                if (n9 > 0) {
                    columnBlock6 = (ColumnBlock)columnBlock.getChildren().get(n9 - 1);
                    if (columnBlock6.endLine == n - 1) {
                        n6 = 1;
                    }
                }
                boolean bl3 = (n5 = columnBlock2.isLineWithinThisBlock(n)) == 0;
                boolean bl4 = n5 < 0;
                int n10 = columnBlock2.isLineWithinThisBlock(n + n3);
                boolean bl5 = n10 == 0;
                boolean bl6 = n10 < 0;
                boolean bl7 = bl2 = n10 > 0;
                if (bl6) {
                    columnBlock3 = columnBlock2;
                    columnBlock5 = null;
                    columnBlock4 = null;
                    n8 = -1;
                    n7 = -1;
                } else if ((bl3 || bl4) && bl5) {
                    n7 = Math.min(columnBlock2.startLine, n);
                    n8 = columnBlock2.endLine - n3;
                    columnBlock4 = columnBlock5 = columnBlock2;
                    if (n6 != 0) {
                        n7 = columnBlock6.startLine;
                        columnBlock4 = columnBlock6;
                    }
                } else if (bl3 || bl4) {
                    n7 = Math.min(n, columnBlock2.startLine);
                    columnBlock4 = columnBlock2;
                    ColumnBlock columnBlock7 = columnBlock.searchChildren(n + n3);
                    int n11 = columnBlock.getChildren().indexOf(columnBlock7);
                    if (columnBlock7 != null) {
                        if (columnBlock7.isLineWithinThisBlock(n + n3) == 0) {
                            if (n6 != 0) {
                                n7 = columnBlock6.startLine;
                                columnBlock4 = columnBlock6;
                            }
                            columnBlock5 = columnBlock7;
                            n8 = columnBlock7.endLine - n3;
                        } else {
                            columnBlock5 = (ColumnBlock)columnBlock.getChildren().get(n11 - 1);
                            int n12 = n8 = bl4 ? -1 : n;
                            if (columnBlock7.startLine == n + n3 + 1 && n8 != -1) {
                                n8 = columnBlock7.endLine - n3;
                                columnBlock5 = columnBlock7;
                            }
                            if (n8 == -1) {
                                n7 = -1;
                            }
                        }
                    } else {
                        columnBlock5 = (ColumnBlock)columnBlock.getChildren().get(columnBlock.getChildren().size() - 1);
                        if (bl3) {
                            n8 = n;
                        } else {
                            n7 = -1;
                            n8 = -1;
                        }
                    }
                }
            } else {
                n7 = -1;
                n8 = -1;
                columnBlock4 = null;
                columnBlock5 = null;
            }
            ArrayList<Node> arrayList = null;
            if (columnBlock4 != null) {
                int n13 = columnBlock.getChildren().indexOf(columnBlock4);
                arrayList = new ArrayList<Node>();
                if (columnBlock5 == null) {
                    throw new IllegalArgumentException("Deletion not handled properly");
                }
                n6 = columnBlock.getChildren().indexOf(columnBlock5);
                for (n5 = n13; n5 <= n6; ++n5) {
                    arrayList.add(columnBlock.getChildren().get(n5));
                }
            }
            if (n3 > 0) {
                columnBlock.endLine -= n3;
                if (columnBlock5 != null || columnBlock3 != null) {
                    int n14;
                    if (columnBlock5 != null) {
                        n14 = columnBlock.getChildren().indexOf(columnBlock5);
                        ++n14;
                    } else {
                        n14 = columnBlock.getChildren().indexOf(columnBlock3);
                    }
                    for (n6 = n14; n6 < columnBlock.getChildren().size(); ++n6) {
                        ((ColumnBlock)columnBlock.getChildren().get(n6)).updateLineNo(-1 * n3);
                    }
                }
            }
            if (arrayList != null) {
                columnBlock.getChildren().removeAll(arrayList);
            }
            if (n7 != -1 && n8 != -1) {
                jEditBuffer.updateColumnBlocks(n7, n8, 0, columnBlock);
                columnBlock.setDirtyStatus(false);
                this.textArea.chunkCache.invalidateChunksFromPhys(n7);
                this.textArea.invalidateLineRange(n7, n8);
            }
            columnBlock.setDirtyStatus(false);
            this.handledDeletion = true;
        } else {
            int n15;
            int n16;
            ColumnBlock columnBlock8 = columnBlock.getContainingBlock(n, n2);
            if (columnBlock8 != null) {
                if (!this.singleTabDeleted) {
                    columnBlock8.updateColumnBlockLineOffset(n, -1 * n4, false);
                    n16 = columnBlock8.startLine;
                    n15 = columnBlock8.endLine;
                    columnBlock8.setTabSizeDirtyStatus(true, false);
                } else {
                    ColumnBlock columnBlock9 = (ColumnBlock)columnBlock8.getParent();
                    n16 = columnBlock8.startLine;
                    n15 = columnBlock8.endLine;
                    columnBlock9.getChildren().remove(columnBlock8);
                    jEditBuffer.updateColumnBlocks(n16, n15, (int)columnBlock9.columnBlockWidth, columnBlock9);
                }
            } else {
                n16 = n;
                n15 = n;
            }
            this.handledDeletion = true;
            columnBlock.setDirtyStatus(false);
            if (n16 != -1 && n15 != -1) {
                this.textArea.chunkCache.invalidateChunksFromPhys(n16);
                this.textArea.invalidateLineRange(n16, n15);
            }
        }
    }

    @Override
    public void transactionComplete(JEditBuffer jEditBuffer) {
        if (!jEditBuffer.getBooleanProperty("elasticTabstops")) {
            return;
        }
        if (!(!jEditBuffer.getBooleanProperty("elasticTabstops") || this.handledInsertion && this.handledDeletion)) {
            this.fullyUpdateColumnBlocks(jEditBuffer);
        }
    }

    @Override
    public void preContentInserted(JEditBuffer jEditBuffer, int n, int n2, int n3, int n4) {
        if (!jEditBuffer.elasticTabstopsOn) {
            return;
        }
        this.handledInsertion = false;
        if (jEditBuffer.getColumnBlock() != null) {
            jEditBuffer.getColumnBlock().setDirtyStatus(true);
        }
    }

    @Override
    public void preContentRemoved(JEditBuffer jEditBuffer, int n, int n2, int n3, int n4) {
        if (!jEditBuffer.elasticTabstopsOn) {
            return;
        }
        this.handledDeletion = false;
        this.singleTabDeleted = false;
        if (jEditBuffer.getColumnBlock() != null) {
            String string;
            jEditBuffer.getColumnBlock().setDirtyStatus(true);
            if (n3 == 0 && n4 == 1 && (string = jEditBuffer.getText(n2, n4)).equals("\t")) {
                this.singleTabDeleted = true;
            }
        }
    }
}

