/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0002H\u0002\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0005\u001a\n\u0010\b\u001a\u00020\u0007*\u00020\u0005\u001a\n\u0010\t\u001a\u00020\u0007*\u00020\u0005\u001a\n\u0010\n\u001a\u00020\u0007*\u00020\u0005\u001a\n\u0010\u000b\u001a\u00020\u0007*\u00020\u0005\u001a\n\u0010\f\u001a\u00020\u0007*\u00020\u0005\u001a\n\u0010\r\u001a\u00020\u0007*\u00020\u0005\u001a\n\u0010\u000e\u001a\u00020\u0007*\u00020\u0005\u001a\n\u0010\u000f\u001a\u00020\u0007*\u00020\u0005\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"PRIMITIVE_NUMBER_CLASS_IDS", "", "Lorg/jetbrains/kotlin/name/ClassId;", "PRIMITIVE_UNSIGNED_NUMBER_CLASS_IDS", "createType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "isByte", "", "isDouble", "isFloat", "isInt", "isLong", "isPrimitiveNumberOrUnsignedNumberType", "isPrimitiveNumberType", "isPrimitiveUnsignedNumberType", "isShort", "tree"})
public final class PrimitivesKt {
    private static final Set<ClassId> PRIMITIVE_NUMBER_CLASS_IDS = SetsKt.setOf(StandardClassIds.INSTANCE.getDouble(), StandardClassIds.INSTANCE.getFloat(), StandardClassIds.INSTANCE.getLong(), StandardClassIds.INSTANCE.getInt(), StandardClassIds.INSTANCE.getShort(), StandardClassIds.INSTANCE.getByte());
    private static final Set<ClassId> PRIMITIVE_UNSIGNED_NUMBER_CLASS_IDS = SetsKt.setOf(StandardClassIds.INSTANCE.getULong(), StandardClassIds.INSTANCE.getUInt(), StandardClassIds.INSTANCE.getUShort(), StandardClassIds.INSTANCE.getUByte());

    private static final ConeClassLikeType createType(ClassId $this$createType) {
        return new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl($this$createType), new ConeTypeProjection[0], false, null, 8, null);
    }

    public static final boolean isDouble(@NotNull ConeClassLikeType $this$isDouble) {
        Intrinsics.checkNotNullParameter($this$isDouble, "$this$isDouble");
        return Intrinsics.areEqual($this$isDouble.getLookupTag().getClassId(), StandardClassIds.INSTANCE.getDouble());
    }

    public static final boolean isFloat(@NotNull ConeClassLikeType $this$isFloat) {
        Intrinsics.checkNotNullParameter($this$isFloat, "$this$isFloat");
        return Intrinsics.areEqual($this$isFloat.getLookupTag().getClassId(), StandardClassIds.INSTANCE.getFloat());
    }

    public static final boolean isLong(@NotNull ConeClassLikeType $this$isLong) {
        Intrinsics.checkNotNullParameter($this$isLong, "$this$isLong");
        return Intrinsics.areEqual($this$isLong.getLookupTag().getClassId(), StandardClassIds.INSTANCE.getLong());
    }

    public static final boolean isInt(@NotNull ConeClassLikeType $this$isInt) {
        Intrinsics.checkNotNullParameter($this$isInt, "$this$isInt");
        return Intrinsics.areEqual($this$isInt.getLookupTag().getClassId(), StandardClassIds.INSTANCE.getInt());
    }

    public static final boolean isShort(@NotNull ConeClassLikeType $this$isShort) {
        Intrinsics.checkNotNullParameter($this$isShort, "$this$isShort");
        return Intrinsics.areEqual($this$isShort.getLookupTag().getClassId(), StandardClassIds.INSTANCE.getShort());
    }

    public static final boolean isByte(@NotNull ConeClassLikeType $this$isByte) {
        Intrinsics.checkNotNullParameter($this$isByte, "$this$isByte");
        return Intrinsics.areEqual($this$isByte.getLookupTag().getClassId(), StandardClassIds.INSTANCE.getByte());
    }

    public static final boolean isPrimitiveNumberType(@NotNull ConeClassLikeType $this$isPrimitiveNumberType) {
        Intrinsics.checkNotNullParameter($this$isPrimitiveNumberType, "$this$isPrimitiveNumberType");
        return PRIMITIVE_NUMBER_CLASS_IDS.contains($this$isPrimitiveNumberType.getLookupTag().getClassId());
    }

    public static final boolean isPrimitiveUnsignedNumberType(@NotNull ConeClassLikeType $this$isPrimitiveUnsignedNumberType) {
        Intrinsics.checkNotNullParameter($this$isPrimitiveUnsignedNumberType, "$this$isPrimitiveUnsignedNumberType");
        return PRIMITIVE_UNSIGNED_NUMBER_CLASS_IDS.contains($this$isPrimitiveUnsignedNumberType.getLookupTag().getClassId());
    }

    public static final boolean isPrimitiveNumberOrUnsignedNumberType(@NotNull ConeClassLikeType $this$isPrimitiveNumberOrUnsignedNumberType) {
        Intrinsics.checkNotNullParameter($this$isPrimitiveNumberOrUnsignedNumberType, "$this$isPrimitiveNumberOrUnsignedNumberType");
        return PrimitivesKt.isPrimitiveNumberType($this$isPrimitiveNumberOrUnsignedNumberType) || PrimitivesKt.isPrimitiveUnsignedNumberType($this$isPrimitiveNumberOrUnsignedNumberType);
    }

    public static final /* synthetic */ ConeClassLikeType access$createType(ClassId $this$access_u24createType) {
        return PrimitivesKt.createType($this$access_u24createType);
    }
}

