/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.LiteralFormatUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.parsing.ParseUtilsKt;
import org.jetbrains.kotlin.utils.NumberWithRadix;
import org.jetbrains.kotlin.utils.NumbersKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0017\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u000e\u001a\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0011\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0016\u001a\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"FP_LITERAL_PARTS", "Lkotlin/text/Regex;", "hasIllegalUnderscore", "", "text", "", "elementType", "Lcom/intellij/psi/tree/IElementType;", "hasLongSuffix", "hasUnsignedLongSuffix", "hasUnsignedSuffix", "parseBoolean", "parseDouble", "", "(Ljava/lang/String;)Ljava/lang/Double;", "parseFloat", "", "(Ljava/lang/String;)Ljava/lang/Float;", "parseFloatingLiteral", "", "parseLong", "", "(Ljava/lang/String;)Ljava/lang/Long;", "parseNumericLiteral", "type", "psi"})
public final class ParseUtilsKt {
    private static final Regex FP_LITERAL_PARTS;

    public static final boolean hasIllegalUnderscore(@NotNull String text2, @NotNull IElementType elementType) {
        boolean bl;
        block7: {
            List<Object> list2;
            Intrinsics.checkNotNullParameter(text2, "text");
            Intrinsics.checkNotNullParameter(elementType, "elementType");
            if (elementType == KtNodeTypes.INTEGER_CONSTANT) {
                int start = 0;
                int end = text2.length();
                if (StringsKt.startsWith(text2, "0x", true) || StringsKt.startsWith(text2, "0b", true)) {
                    start += 2;
                }
                if (StringsKt.endsWith((CharSequence)text2, 'l', true)) {
                    --end;
                }
                String string2 = text2;
                boolean bl2 = false;
                String string3 = string2.substring(start, end);
                Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                list2 = CollectionsKt.listOf(string3);
            } else {
                list2 = SequencesKt.toList(SequencesKt.flatMapIterable(Regex.findAll$default(FP_LITERAL_PARTS, text2, 0, 2, null), hasIllegalUnderscore.parts.1.INSTANCE));
            }
            List parts2 = list2;
            Iterable $this$any$iv = parts2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (!(it != null && (StringsKt.startsWith$default(it, "_", false, 2, null) || StringsKt.endsWith$default(it, "_", false, 2, null)))) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean hasLongSuffix(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        return StringsKt.endsWith$default((CharSequence)text2, 'l', false, 2, null) || StringsKt.endsWith$default((CharSequence)text2, 'L', false, 2, null);
    }

    public static final boolean hasUnsignedSuffix(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        return StringsKt.endsWith$default((CharSequence)text2, 'u', false, 2, null) || StringsKt.endsWith$default((CharSequence)text2, 'U', false, 2, null);
    }

    public static final boolean hasUnsignedLongSuffix(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        return StringsKt.endsWith$default(text2, "ul", false, 2, null) || StringsKt.endsWith$default(text2, "uL", false, 2, null) || StringsKt.endsWith$default(text2, "Ul", false, 2, null) || StringsKt.endsWith$default(text2, "UL", false, 2, null);
    }

    @Nullable
    public static final Number parseNumericLiteral(@NotNull String text2, @NotNull IElementType type2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter(type2, "type");
        String string2 = LiteralFormatUtil.removeUnderscores(text2);
        Intrinsics.checkNotNullExpressionValue(string2, "LiteralFormatUtil.removeUnderscores(text)");
        String canonicalText = string2;
        IElementType iElementType = type2;
        return Intrinsics.areEqual(iElementType, KtNodeTypes.INTEGER_CONSTANT) ? (Number)ParseUtilsKt.parseLong(canonicalText) : (Number)(Intrinsics.areEqual(iElementType, KtNodeTypes.FLOAT_CONSTANT) ? ParseUtilsKt.parseFloatingLiteral(canonicalText) : null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Long parseLong(String text2) {
        Long l;
        parseLong.1 $fun$removeSuffix$1 = parseLong.1.INSTANCE;
        try {
            void number;
            boolean isUnsigned = false;
            String numberWithoutSuffix = null;
            if (ParseUtilsKt.hasUnsignedLongSuffix(text2)) {
                isUnsigned = true;
                numberWithoutSuffix = $fun$removeSuffix$1.invoke(text2, 2);
            } else if (ParseUtilsKt.hasUnsignedSuffix(text2)) {
                isUnsigned = true;
                numberWithoutSuffix = $fun$removeSuffix$1.invoke(text2, 1);
            } else if (ParseUtilsKt.hasLongSuffix(text2)) {
                isUnsigned = false;
                numberWithoutSuffix = $fun$removeSuffix$1.invoke(text2, 1);
            } else {
                isUnsigned = false;
                numberWithoutSuffix = text2;
            }
            NumberWithRadix numberWithRadix = NumbersKt.extractRadix(numberWithoutSuffix);
            String string2 = numberWithRadix.component1();
            int radix = numberWithRadix.component2();
            l = isUnsigned ? Long.parseUnsignedLong((String)number, radix) : Long.parseLong((String)number, radix);
        }
        catch (NumberFormatException e) {
            l = null;
        }
        return l;
    }

    private static final Number parseFloatingLiteral(String text2) {
        String string2 = text2;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.String).toLowerCase()");
        if (StringsKt.endsWith$default((CharSequence)string4, 'f', false, 2, null)) {
            return ParseUtilsKt.parseFloat(text2);
        }
        return ParseUtilsKt.parseDouble(text2);
    }

    private static final Double parseDouble(String text2) {
        try {
            return Double.parseDouble(text2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static final Float parseFloat(String text2) {
        try {
            return Float.valueOf(Float.parseFloat(text2));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static final boolean parseBoolean(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        if ("true".equals(text2)) {
            return true;
        }
        if ("false".equals(text2)) {
            return false;
        }
        throw (Throwable)new IllegalStateException("Must not happen. A boolean literal has text: " + text2);
    }

    static {
        String string2 = "(?:([_\\d]*)\\.?([_\\d]*)e?[+-]?([_\\d]*))[f]?";
        boolean bl = false;
        FP_LITERAL_PARTS = new Regex(string2);
    }
}

