/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.event.ActionEvent;
import java.util.Optional;
import org.protege.editor.core.util.Recommendation;
import org.protege.editor.owl.model.hierarchy.tabbed.CreateHierarchyChangeGenerator;
import org.protege.editor.owl.model.hierarchy.tabbed.HierarchyNodeCreator;
import org.protege.editor.owl.model.hierarchy.tabbed.MakeSiblingsDisjointChangeGenerator;
import org.protege.editor.owl.ui.action.SelectedOWLObjectPropertyAction;
import org.protege.editor.owl.ui.hierarchy.creation.CreateHierarchyExecutor;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;

public class CreateSubObjectPropertyHierarchyAction
extends SelectedOWLObjectPropertyAction {
    @Override
    protected void initialiseAction() throws Exception {
    }

    public void actionPerformed(ActionEvent e) {
        OWLObjectProperty rootProperty = this.getOWLWorkspace().getOWLSelectionModel().getLastSelectedObjectProperty();
        if (rootProperty == null) {
            return;
        }
        OWLDataFactory df = this.getOWLDataFactory();
        CreateHierarchyChangeGenerator<OWLObjectProperty> hierarchyChangeGenerator = new CreateHierarchyChangeGenerator<OWLObjectProperty>(new HierarchyNodeCreator<OWLObjectProperty>(rootProperty, EntityType.OBJECT_PROPERTY, this.getOWLModelManager().getOWLEntityFinder(), this.getOWLModelManager().getOWLEntityFactory()), (child, parent) -> Optional.of(df.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)child, (OWLObjectPropertyExpression)parent)), this.getOWLModelManager().getActiveOntology());
        MakeSiblingsDisjointChangeGenerator<OWLObjectProperty> disjointsChangeGenerator = new MakeSiblingsDisjointChangeGenerator<OWLObjectProperty>(this.getOWLModelManager().getOWLHierarchyManager().getOWLObjectPropertyHierarchyProvider(), sourceSiblings -> sourceSiblings, siblings -> df.getOWLDisjointObjectPropertiesAxiom(siblings), this.getOWLModelManager().getActiveOntology());
        CreateHierarchyExecutor<OWLObjectProperty> executor = new CreateHierarchyExecutor<OWLObjectProperty>(this.getOWLEditorKit(), EntityType.OBJECT_PROPERTY, Optional.of(Recommendation.NOT_RECOMMENDED), hierarchyChangeGenerator, disjointsChangeGenerator);
        executor.showWizardAndCreateHierarchy();
    }

    @Override
    public void dispose() {
    }
}

