/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNaryBooleanClassExpression;
import org.semanticweb.owlapi.model.OWLNaryClassAxiom;
import org.semanticweb.owlapi.model.OWLNaryDataRange;
import org.semanticweb.owlapi.model.OWLNaryIndividualAxiom;
import org.semanticweb.owlapi.model.OWLNaryPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;
import org.semanticweb.owlapi.profiles.Profiles;
import org.semanticweb.owlapi.profiles.violations.CycleInDatatypeDefinition;
import org.semanticweb.owlapi.profiles.violations.DatatypeIRIAlsoUsedAsClassIRI;
import org.semanticweb.owlapi.profiles.violations.EmptyOneOfAxiom;
import org.semanticweb.owlapi.profiles.violations.IllegalPunning;
import org.semanticweb.owlapi.profiles.violations.InsufficientIndividuals;
import org.semanticweb.owlapi.profiles.violations.InsufficientOperands;
import org.semanticweb.owlapi.profiles.violations.InsufficientPropertyExpressions;
import org.semanticweb.owlapi.profiles.violations.LastPropertyInChainNotInImposedRange;
import org.semanticweb.owlapi.profiles.violations.LexicalNotInLexicalSpace;
import org.semanticweb.owlapi.profiles.violations.OntologyIRINotAbsolute;
import org.semanticweb.owlapi.profiles.violations.OntologyVersionIRINotAbsolute;
import org.semanticweb.owlapi.profiles.violations.UseOfAnonymousIndividual;
import org.semanticweb.owlapi.profiles.violations.UseOfBuiltInDatatypeInDatatypeDefinition;
import org.semanticweb.owlapi.profiles.violations.UseOfDataOneOfWithMultipleLiterals;
import org.semanticweb.owlapi.profiles.violations.UseOfDefinedDatatypeInDatatypeRestriction;
import org.semanticweb.owlapi.profiles.violations.UseOfDefinedDatatypeInLiteral;
import org.semanticweb.owlapi.profiles.violations.UseOfIllegalAxiom;
import org.semanticweb.owlapi.profiles.violations.UseOfIllegalClassExpression;
import org.semanticweb.owlapi.profiles.violations.UseOfIllegalDataRange;
import org.semanticweb.owlapi.profiles.violations.UseOfIllegalFacetRestriction;
import org.semanticweb.owlapi.profiles.violations.UseOfNonAbsoluteIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfNonAtomicClassExpression;
import org.semanticweb.owlapi.profiles.violations.UseOfNonEquivalentClassExpression;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSimplePropertyInAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSimplePropertyInCardinalityRestriction;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSimplePropertyInDisjointPropertiesAxiom;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSimplePropertyInFunctionalPropertyAxiom;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSimplePropertyInInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSimplePropertyInIrreflexivePropertyAxiom;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSimplePropertyInObjectHasSelf;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSubClassExpression;
import org.semanticweb.owlapi.profiles.violations.UseOfNonSuperClassExpression;
import org.semanticweb.owlapi.profiles.violations.UseOfObjectOneOfWithMultipleIndividuals;
import org.semanticweb.owlapi.profiles.violations.UseOfObjectPropertyInverse;
import org.semanticweb.owlapi.profiles.violations.UseOfPropertyInChainCausesCycle;
import org.semanticweb.owlapi.profiles.violations.UseOfReservedVocabularyForAnnotationPropertyIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfReservedVocabularyForClassIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfReservedVocabularyForDataPropertyIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfReservedVocabularyForIndividualIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfReservedVocabularyForObjectPropertyIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfReservedVocabularyForOntologyIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfReservedVocabularyForVersionIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfTopDataPropertyAsSubPropertyInSubPropertyAxiom;
import org.semanticweb.owlapi.profiles.violations.UseOfUndeclaredAnnotationProperty;
import org.semanticweb.owlapi.profiles.violations.UseOfUndeclaredClass;
import org.semanticweb.owlapi.profiles.violations.UseOfUndeclaredDataProperty;
import org.semanticweb.owlapi.profiles.violations.UseOfUndeclaredDatatype;
import org.semanticweb.owlapi.profiles.violations.UseOfUndeclaredObjectProperty;
import org.semanticweb.owlapi.profiles.violations.UseOfUnknownDatatype;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorExAdapter;
import org.semanticweb.owlapi.util.OWLObjectPropertyManager;
import org.semanticweb.owlapi.util.OWLOntologyWalker;
import org.semanticweb.owlapi.util.OWLOntologyWalkerVisitor;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class ProfileVisitorBase
extends OWLOntologyWalkerVisitor {
    private static final OWLClassExpressionVisitorEx<Boolean> superClassExpressionChecker = new OWLClassExpressionVisitorExAdapter<Boolean>(Boolean.FALSE){

        @Override
        public Boolean visit(OWLClass ce) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(OWLDataSomeValuesFrom ce) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(OWLObjectComplementOf ce) {
            return ProfileVisitorBase.isOWL2QLSubClassExpression(ce.getOperand());
        }

        @Override
        public Boolean visit(OWLObjectIntersectionOf ce) {
            return ce.getOperandsAsList().stream().noneMatch(e -> e.accept(this) == Boolean.FALSE);
        }

        @Override
        public Boolean visit(OWLObjectSomeValuesFrom ce) {
            return !((OWLClassExpression)ce.getFiller()).isAnonymous();
        }
    };
    private static final OWLClassExpressionVisitorEx<Boolean> subClassExpressionChecker = new OWLClassExpressionVisitorExAdapter<Boolean>(Boolean.FALSE){

        @Override
        public Boolean visit(OWLClass ce) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(OWLDataSomeValuesFrom ce) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(OWLObjectSomeValuesFrom ce) {
            return ((OWLClassExpression)ce.getFiller()).isOWLThing();
        }
    };
    static final OWLClassExpressionVisitorEx<Boolean> subClassRLExpressionChecker = new OWLClassExpressionVisitorExAdapter<Boolean>(Boolean.FALSE){

        @Override
        public Boolean visit(OWLClass ce) {
            return !ce.isOWLThing();
        }

        @Override
        public Boolean visit(OWLDataHasValue ce) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(OWLDataSomeValuesFrom ce) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(OWLObjectHasValue ce) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(OWLObjectIntersectionOf ce) {
            return ce.getOperandsAsList().stream().allMatch(op -> ProfileVisitorBase.isOWL2RLSubClassExpression(op));
        }

        @Override
        public Boolean visit(OWLObjectOneOf ce) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(OWLObjectSomeValuesFrom ce) {
            return ((OWLClassExpression)ce.getFiller()).isOWLThing() || ProfileVisitorBase.isOWL2RLSubClassExpression((OWLClassExpression)ce.getFiller());
        }

        @Override
        public Boolean visit(OWLObjectUnionOf ce) {
            return ce.getOperandsAsList().stream().allMatch(op -> ProfileVisitorBase.isOWL2RLSubClassExpression(op));
        }
    };
    static final OWLClassExpressionVisitorEx<Boolean> superClassRLExpressionChecker = new OWLClassExpressionVisitorExAdapter<Boolean>(Boolean.FALSE){

        @Override
        public Boolean visit(OWLClass ce) {
            return !ce.isOWLThing();
        }

        @Override
        public Boolean visit(OWLDataAllValuesFrom ce) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(OWLDataHasValue ce) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(OWLDataMaxCardinality ce) {
            return ce.getCardinality() == 0 || ce.getCardinality() == 1;
        }

        @Override
        public Boolean visit(OWLObjectAllValuesFrom ce) {
            return ((OWLClassExpression)ce.getFiller()).accept(this);
        }

        @Override
        public Boolean visit(OWLObjectComplementOf ce) {
            return ProfileVisitorBase.isOWL2RLSubClassExpression(ce.getOperand());
        }

        @Override
        public Boolean visit(OWLObjectHasValue ce) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(OWLObjectIntersectionOf ce) {
            return ce.getOperandsAsList().stream().allMatch(e -> e.accept(this));
        }

        @Override
        public Boolean visit(OWLObjectMaxCardinality ce) {
            return !(ce.getCardinality() != 0 && ce.getCardinality() != 1 || !((OWLClassExpression)ce.getFiller()).isOWLThing() && !ProfileVisitorBase.isOWL2RLSubClassExpression((OWLClassExpression)ce.getFiller()));
        }
    };
    static final OWLClassExpressionVisitorEx<Boolean> equivalentClassExpressionChecker = new OWLClassExpressionVisitorExAdapter<Boolean>(Boolean.FALSE){

        @Override
        public Boolean visit(OWLClass ce) {
            return !ce.isOWLThing();
        }

        @Override
        public Boolean visit(OWLDataHasValue ce) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(OWLObjectHasValue ce) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visit(OWLObjectIntersectionOf ce) {
            return ce.getOperandsAsList().stream().allMatch(e -> e.accept(this));
        }
    };
    protected static final Set<IRI> ALLOWED_RL_DATATYPES = OWL2Datatype.RL_DATATYPES.stream().map(HasIRI::getIRI).collect(Collectors.toSet());
    protected static final Set<IRI> ALLOWED_EL_DATATYPES = OWL2Datatype.EL_DATATYPES.stream().map(HasIRI::getIRI).collect(Collectors.toSet());
    protected static final Set<IRI> ALLOWED_QL_DATATYPES = OWL2Datatype.EL_DATATYPES.stream().map(HasIRI::getIRI).collect(Collectors.toSet());
    protected final Set<Profiles> validating;
    protected Collection<OWLProfileViolation> violations;
    @Nullable
    protected OWLObjectPropertyManager propertyManager = null;

    protected static boolean isOWL2QLSubClassExpression(OWLClassExpression ce) {
        return ce.accept(subClassExpressionChecker);
    }

    protected static boolean isOWL2QLSuperClassExpression(OWLClassExpression ce) {
        return ce.accept(superClassExpressionChecker);
    }

    protected static boolean isOWL2RLSubClassExpression(OWLClassExpression ce) {
        return ce.accept(subClassRLExpressionChecker);
    }

    protected static boolean isOWL2RLSuperClassExpression(OWLClassExpression ce) {
        return ce.accept(superClassRLExpressionChecker);
    }

    protected ProfileVisitorBase(OWLOntologyWalker walker, Collection<OWLProfileViolation> violations, Collection<Profiles> profiles) {
        super(walker);
        this.violations = violations;
        this.validating = new HashSet<Profiles>(profiles);
    }

    protected void dl(Runnable ... runnables) {
        if (this.validating.contains(Profiles.OWL2_DL)) {
            for (Runnable r : runnables) {
                r.run();
            }
        }
    }

    protected void ql(Runnable ... runnables) {
        if (this.validating.contains(Profiles.OWL2_QL)) {
            for (Runnable r : runnables) {
                r.run();
            }
        }
    }

    protected void el(Runnable ... runnables) {
        if (this.validating.contains(Profiles.OWL2_EL)) {
            for (Runnable r : runnables) {
                r.run();
            }
        }
    }

    protected void rl(Runnable ... runnables) {
        if (this.validating.contains(Profiles.OWL2_RL)) {
            for (Runnable r : runnables) {
                r.run();
            }
        }
    }

    protected OWLObjectPropertyManager getPropertyManager() {
        if (this.propertyManager == null) {
            this.propertyManager = new OWLObjectPropertyManager(this.getCurrentOntology().getOWLOntologyManager(), this.getCurrentOntology());
        }
        return OWLAPIPreconditions.verifyNotNull(this.propertyManager);
    }

    protected void illegalRLDatatype(OWLDatatype node) {
        if (!ALLOWED_RL_DATATYPES.contains(node.getIRI())) {
            this.illegalDataRange(node);
        }
    }

    protected void illegalQLDatatype(OWLDatatype node) {
        if (!ALLOWED_QL_DATATYPES.contains(node.getIRI())) {
            this.illegalDataRange(node);
        }
    }

    protected void nonSuperClassRL(OWLClassExpression ce) {
        if (!ProfileVisitorBase.isOWL2RLSuperClassExpression(ce)) {
            this.nonSuper(ce);
        }
    }

    protected void nonSubClassRL(OWLClassExpression ce) {
        if (!ProfileVisitorBase.isOWL2RLSubClassExpression(ce)) {
            this.nonSubclass(ce);
        }
    }

    protected void nonSuperClassQL(OWLClassExpression ce) {
        if (!ProfileVisitorBase.isOWL2QLSuperClassExpression(ce)) {
            this.nonSuper(ce);
        }
    }

    protected void nonSubClassQL(OWLSubClassOfAxiom axiom) {
        if (!ProfileVisitorBase.isOWL2QLSubClassExpression(axiom.getSubClass())) {
            this.nonSubclass(axiom.getSubClass());
        }
    }

    protected void elDataRange(OWLDatatype node) {
        if (!ALLOWED_EL_DATATYPES.contains(node.getIRI())) {
            this.illegalDataRange(node);
        }
    }

    protected void illegalClass(OWLClassExpression ce) {
        this.violations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
    }

    protected void illegalPunning(HasIRI p) {
        this.violations.add(new IllegalPunning(this.getCurrentOntology(), this.getCurrentAxiom(), p.getIRI()));
    }

    protected void insufficientOperands(OWLNaryDataRange node) {
        if (node.getOperands().size() < 2) {
            this.violations.add(new InsufficientOperands(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }
    }

    protected void insufficientOperands(OWLNaryBooleanClassExpression node) {
        if (node.getOperands().size() < 2) {
            this.violations.add(new InsufficientOperands(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }
    }

    protected void insufficientOperands(OWLDisjointUnionAxiom node) {
        if (node.getClassExpressions().size() < 2) {
            this.violations.add(new InsufficientOperands(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }
    }

    protected void insufficientOperands(OWLNaryClassAxiom node) {
        if (node.getClassExpressions().size() < 2) {
            this.violations.add(new InsufficientOperands(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }
    }

    protected void insufficientProperties(OWLNaryPropertyAxiom<?> node) {
        if (node.getProperties().size() < 2) {
            this.violations.add(new InsufficientPropertyExpressions(this.getCurrentOntology(), this.getCurrentAxiom()));
        }
    }

    protected void emptyProperties(OWLNaryPropertyAxiom<?> node) {
        if (node.getProperties().isEmpty()) {
            this.violations.add(new InsufficientPropertyExpressions(this.getCurrentOntology(), this.getCurrentAxiom()));
        }
    }

    protected void emptyProperties(OWLHasKeyAxiom node) {
        if (node.getPropertyExpressions().isEmpty()) {
            this.violations.add(new InsufficientPropertyExpressions(this.getCurrentOntology(), this.getCurrentAxiom()));
        }
    }

    protected void illegalAxiom() {
        this.violations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), OWLAPIPreconditions.verifyNotNull(this.getCurrentAxiom())));
    }

    protected void illegalDataRange(OWLDataRange node) {
        this.violations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
    }

    protected void nonSimple(OWLObjectCardinalityRestriction ce) {
        if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)ce.getProperty())) {
            this.violations.add(new UseOfNonSimplePropertyInCardinalityRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
        }
    }

    protected boolean nonSubclass(OWLClassExpression ce) {
        return this.violations.add(new UseOfNonSubClassExpression(this.getCurrentOntology(), OWLAPIPreconditions.verifyNotNull(this.getCurrentAxiom()), ce));
    }

    protected void nonSuper(OWLClassExpression ce) {
        this.violations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), OWLAPIPreconditions.verifyNotNull(this.getCurrentAxiom()), ce));
    }

    protected void chainCycle(OWLObjectPropertyExpression last) {
        this.violations.add(new UseOfPropertyInChainCausesCycle(this.getCurrentOntology(), OWLAPIPreconditions.verifyNotNull(this.getCurrentAxiom()), last));
    }

    protected void undeclaredDatatype(OWLDatatype dt) {
        if (!(dt.isTopDatatype() || dt.isBuiltIn() || this.getCurrentOntology().isDeclared(dt, Imports.INCLUDED))) {
            this.violations.add(new UseOfUndeclaredDatatype(this.getCurrentOntology(), this.getCurrentAxiom(), dt));
        }
    }

    protected boolean rangePresent(OWLClassExpression imposedRange, OWLObjectPropertyExpression lastProperty) {
        return this.getCurrentOntology().getImportsClosure().stream().flatMap(o -> o.getObjectPropertyRangeAxioms(lastProperty).stream()).anyMatch(l -> ((OWLClassExpression)l.getRange()).equals(imposedRange));
    }

    protected void anonIndividual(OWLAnonymousIndividual individual) {
        this.violations.add(new UseOfAnonymousIndividual(this.getCurrentOntology(), this.getCurrentAxiom(), individual));
    }

    protected void nonAtomic(OWLClassAssertionAxiom axiom) {
        if (axiom.getClassExpression().isAnonymous()) {
            this.violations.add(new UseOfNonAtomicClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getClassExpression()));
        }
    }

    protected boolean nonEquivalentClass(OWLClassExpression ce) {
        return this.violations.add(new UseOfNonEquivalentClassExpression(this.getCurrentOntology(), OWLAPIPreconditions.verifyNotNull(this.getCurrentAxiom()), ce));
    }

    protected void ontologyIRINotAbsolute(OWLOntologyID id) {
        if (id.getOntologyIRI().isPresent() && !((IRI)id.getOntologyIRI().get()).isAbsolute()) {
            this.violations.add(new OntologyIRINotAbsolute(this.getCurrentOntology(), id));
        }
    }

    protected void versionNotAbsolute(OWLOntologyID id) {
        if (id.getVersionIRI().isPresent() && !((IRI)id.getVersionIRI().get()).isAbsolute()) {
            this.violations.add(new OntologyVersionIRINotAbsolute(this.getCurrentOntology(), id));
        }
    }

    protected boolean definedDatatype(OWLDatatypeRestriction node) {
        return this.violations.add(new UseOfDefinedDatatypeInDatatypeRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), node));
    }

    protected void illegalFacet(OWLDatatypeRestriction node, OWLDatatype datatype, OWLFacetRestriction r) {
        OWL2Datatype dt = datatype.getBuiltInDatatype();
        if (!dt.getFacets().contains(r.getFacet())) {
            this.violations.add(new UseOfIllegalFacetRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), node, r.getFacet()));
        }
    }

    protected boolean isBuiltin(OWLLiteral node) {
        return node.getDatatype().isBuiltIn() && !node.getDatatype().getBuiltInDatatype().isInLexicalSpace(node.getLiteral());
    }

    protected void chainRange(OWLObjectPropertyRangeAxiom rngAx) {
        OWLSubPropertyChainOfAxiom axiom = (OWLSubPropertyChainOfAxiom)OWLAPIPreconditions.verifyNotNull(this.getCurrentAxiom());
        if (this.getPropertyManager().isSubPropertyOf(axiom.getSuperProperty(), (OWLObjectPropertyExpression)rngAx.getProperty())) {
            OWLObjectPropertyExpression lastProperty;
            boolean rngPresent;
            OWLClassExpression imposedRange = (OWLClassExpression)rngAx.getRange();
            List<OWLObjectPropertyExpression> chain = axiom.getPropertyChain();
            if (!chain.isEmpty() && !(rngPresent = this.rangePresent(imposedRange, lastProperty = chain.get(chain.size() - 1)))) {
                this.violations.add(new LastPropertyInChainNotInImposedRange(this.getCurrentOntology(), axiom, rngAx));
            }
        }
    }

    protected void relativeIRI(IRI iri) {
        if (!iri.isAbsolute()) {
            this.violations.add(new UseOfNonAbsoluteIRI(this.getCurrentOntology(), this.getCurrentAxiom(), iri));
        }
    }

    protected void notInLexicalSpace(OWLLiteral node) {
        if (!node.getDatatype().isBuiltIn()) {
            this.violations.add(new UseOfDefinedDatatypeInLiteral(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }
        if (this.isBuiltin(node)) {
            this.violations.add(new LexicalNotInLexicalSpace(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }
    }

    protected void multipleOneOf(OWLObjectOneOf ce) {
        if (ce.getIndividuals().size() != 1) {
            this.violations.add(new UseOfObjectOneOfWithMultipleIndividuals(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
        }
    }

    protected void multipleOneOf(OWLDataOneOf node) {
        if (node.getValues().size() != 1) {
            this.violations.add(new UseOfDataOneOfWithMultipleLiterals(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }
    }

    protected void insufficientProperties(OWLSubPropertyChainOfAxiom axiom) {
        if (axiom.getPropertyChain().size() < 2) {
            this.violations.add(new InsufficientPropertyExpressions(this.getCurrentOntology(), axiom));
        }
    }

    protected void topAsSubProperty(OWLSubDataPropertyOfAxiom axiom) {
        if (((OWLDataPropertyExpression)axiom.getSubProperty()).isOWLTopDataProperty()) {
            this.violations.add(new UseOfTopDataPropertyAsSubPropertyInSubPropertyAxiom(this.getCurrentOntology(), axiom));
        }
    }

    protected void inverse(OWLObjectInverseOf property) {
        this.violations.add(new UseOfObjectPropertyInverse(this.getCurrentOntology(), this.getCurrentAxiom(), property));
    }

    protected void insufficientIndividuals(OWLNaryIndividualAxiom axiom) {
        if (axiom.getIndividualsAsList().size() < 2) {
            this.violations.add(new InsufficientIndividuals(this.getCurrentOntology(), this.getCurrentAxiom()));
        }
    }

    protected void punningAnnotation(OWLAnnotationProperty property) {
        if (this.getCurrentOntology().containsObjectPropertyInSignature(property.getIRI(), Imports.INCLUDED)) {
            this.illegalPunning(property);
        }
        if (this.getCurrentOntology().containsDataPropertyInSignature(property.getIRI(), Imports.INCLUDED)) {
            this.illegalPunning(property);
        }
    }

    protected void undeclaredAnnotation(OWLAnnotationProperty property) {
        if (!(property.isBuiltIn() || property.getIRI().isReservedVocabulary() || this.getCurrentOntology().isDeclared(property, Imports.INCLUDED))) {
            this.violations.add(new UseOfUndeclaredAnnotationProperty(this.getCurrentOntology(), this.getCurrentAxiom(), this.getCurrentAnnotation(), property));
        }
    }

    protected void reservedForAnnotation(OWLAnnotationProperty property) {
        if (!property.isBuiltIn() && property.getIRI().isReservedVocabulary()) {
            this.violations.add(new UseOfReservedVocabularyForAnnotationPropertyIRI(this.getCurrentOntology(), this.getCurrentAxiom(), property));
        }
    }

    protected void punningDatatypeAndClass(HasIRI ce) {
        if (this.getCurrentOntology().containsClassInSignature(ce.getIRI(), Imports.INCLUDED) && this.getCurrentOntology().containsDatatypeInSignature(ce.getIRI(), Imports.INCLUDED)) {
            this.violations.add(new DatatypeIRIAlsoUsedAsClassIRI(this.getCurrentOntology(), this.getCurrentAxiom(), ce.getIRI()));
        }
    }

    protected void undeclaredClass(OWLClass ce) {
        if (!(ce.isBuiltIn() || ce.getIRI().isReservedVocabulary() || this.getCurrentOntology().isDeclared(ce, Imports.INCLUDED))) {
            this.violations.add(new UseOfUndeclaredClass(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
        }
    }

    protected void reservedForClass(OWLClass ce) {
        if (!ce.isBuiltIn() && ce.getIRI().isReservedVocabulary()) {
            this.violations.add(new UseOfReservedVocabularyForClassIRI(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
        }
    }

    protected void emptyOneOf(OWLDataOneOf node) {
        if (node.getValues().size() < 1) {
            this.violations.add(new EmptyOneOfAxiom(this.getCurrentOntology(), this.getCurrentAxiom()));
        }
    }

    protected void emptyOneOf(OWLObjectOneOf node) {
        if (node.getIndividuals().size() < 1) {
            this.violations.add(new EmptyOneOfAxiom(this.getCurrentOntology(), this.getCurrentAxiom()));
        }
    }

    protected void illegalDataPropertyPunning(OWLDataProperty property) {
        if (this.getCurrentOntology().containsObjectPropertyInSignature(property.getIRI(), Imports.INCLUDED)) {
            this.illegalPunning(property);
        }
        if (this.getCurrentOntology().containsAnnotationPropertyInSignature(property.getIRI(), Imports.INCLUDED)) {
            this.illegalPunning(property);
        }
    }

    protected void undeclaredDataProperty(OWLDataProperty property) {
        if (!(property.isBuiltIn() || property.getIRI().isReservedVocabulary() || this.getCurrentOntology().isDeclared(property, Imports.INCLUDED))) {
            this.violations.add(new UseOfUndeclaredDataProperty(this.getCurrentOntology(), this.getCurrentAxiom(), property));
        }
    }

    protected void reservedForDataProperty(OWLDataProperty property) {
        if (!property.isOWLTopDataProperty() && !property.isOWLBottomDataProperty() && property.getIRI().isReservedVocabulary()) {
            this.violations.add(new UseOfReservedVocabularyForDataPropertyIRI(this.getCurrentOntology(), this.getCurrentAxiom(), property));
        }
    }

    protected void unknownDatatype(OWLDatatype node) {
        if (!Namespaces.XSD.inNamespace(node.getIRI()) && !node.isBuiltIn() && !node.isTopDatatype() && node.getIRI().isReservedVocabulary()) {
            this.violations.add(new UseOfUnknownDatatype(this.getCurrentOntology(), this.getCurrentAxiom(), node));
        }
    }

    protected void reservedForDatatype(OWLDatatypeDefinitionAxiom axiom) {
        if (axiom.getDatatype().getIRI().isReservedVocabulary()) {
            this.violations.add(new UseOfBuiltInDatatypeInDatatypeDefinition(this.getCurrentOntology(), axiom));
        }
    }

    protected void cycleInDefinition(OWLDatatypeDefinitionAxiom axiom) {
        HashSet<OWLDatatype> datatypes = new HashSet<OWLDatatype>();
        LinkedHashSet<OWLAxiom> axioms = new LinkedHashSet<OWLAxiom>();
        axioms.add(axiom);
        this.getDatatypesInSignature(datatypes, axiom.getDataRange(), axioms);
        if (datatypes.contains(axiom.getDatatype())) {
            this.violations.add(new CycleInDatatypeDefinition(this.getCurrentOntology(), axiom));
        }
    }

    private void getDatatypesInSignature(Set<OWLDatatype> datatypes, OWLObject obj, Set<OWLAxiom> axioms) {
        Consumer<OWLDatatypeDefinitionAxiom> addAndRecurse = ax -> {
            axioms.add((OWLAxiom)ax);
            this.getDatatypesInSignature(datatypes, ax.getDataRange(), axioms);
        };
        obj.getDatatypesInSignature().stream().filter(datatypes::add).forEach(dt -> this.datatypeDefinitions((OWLDatatype)dt).forEach(addAndRecurse));
    }

    protected Stream<OWLDatatypeDefinitionAxiom> datatypeDefinitions(OWLDatatype dt) {
        return this.getCurrentOntology().getImportsClosure().stream().flatMap(o -> o.getDatatypeDefinitions(dt).stream());
    }

    protected boolean disjointNonSimple(OWLObjectPropertyExpression p) {
        return this.violations.add(new UseOfNonSimplePropertyInDisjointPropertiesAxiom(this.getCurrentOntology(), OWLAPIPreconditions.verifyNotNull(this.getCurrentAxiom()), p));
    }

    protected void functionalNonSimple(OWLFunctionalObjectPropertyAxiom axiom) {
        if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
            this.violations.add(new UseOfNonSimplePropertyInFunctionalPropertyAxiom(this.getCurrentOntology(), axiom));
        }
    }

    protected void inverseFunctionalNonSimple(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
            this.violations.add(new UseOfNonSimplePropertyInInverseFunctionalObjectPropertyAxiom(this.getCurrentOntology(), axiom));
        }
    }

    protected void irreflexiveNonSimple(OWLIrreflexiveObjectPropertyAxiom axiom) {
        if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
            this.violations.add(new UseOfNonSimplePropertyInIrreflexivePropertyAxiom(this.getCurrentOntology(), axiom));
        }
    }

    protected void reservedForIndividual(OWLNamedIndividual individual) {
        if (individual.isNamed() && individual.getIRI().isReservedVocabulary()) {
            this.violations.add(new UseOfReservedVocabularyForIndividualIRI(this.getCurrentOntology(), this.getCurrentAxiom(), individual));
        }
    }

    protected void hasSelfNonSimple(OWLObjectHasSelf ce) {
        if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)ce.getProperty())) {
            this.violations.add(new UseOfNonSimplePropertyInObjectHasSelf(this.getCurrentOntology(), this.getCurrentAxiom(), ce));
        }
    }

    protected void illegalObjectPropertyPunning(OWLObjectProperty property) {
        if (this.getCurrentOntology().containsDataPropertyInSignature(property.getIRI(), Imports.INCLUDED)) {
            this.illegalPunning(property);
        }
        if (this.getCurrentOntology().containsAnnotationPropertyInSignature(property.getIRI(), Imports.INCLUDED)) {
            this.illegalPunning(property);
        }
    }

    protected void undeclaredObjectProperty(OWLObjectProperty property) {
        if (!(property.isBuiltIn() || property.getIRI().isReservedVocabulary() || this.getCurrentOntology().isDeclared(property, Imports.INCLUDED))) {
            this.violations.add(new UseOfUndeclaredObjectProperty(this.getCurrentOntology(), this.getCurrentAxiom(), property));
        }
    }

    protected void reservedForVersionIRI(OWLOntologyID id) {
        if (id.isAnonymous()) {
            return;
        }
        Optional<IRI> vIRI = id.getVersionIRI();
        if (vIRI.isPresent() && ((IRI)vIRI.get()).isReservedVocabulary()) {
            this.violations.add(new UseOfReservedVocabularyForVersionIRI(this.getCurrentOntology()));
        }
    }

    protected void reservedForOntologyIRI(OWLOntologyID id) {
        if (id.isAnonymous()) {
            return;
        }
        Optional<IRI> oIRI = id.getOntologyIRI();
        if (oIRI.isPresent() && ((IRI)oIRI.get()).isReservedVocabulary()) {
            this.violations.add(new UseOfReservedVocabularyForOntologyIRI(this.getCurrentOntology()));
        }
    }

    protected void reservedForObjectProperty(OWLObjectProperty property) {
        if (!property.isOWLTopObjectProperty() && !property.isOWLBottomObjectProperty() && property.getIRI().isReservedVocabulary()) {
            this.violations.add(new UseOfReservedVocabularyForObjectPropertyIRI(this.getCurrentOntology(), this.getCurrentAxiom(), property));
        }
    }

    protected void chainCycle(OWLSubPropertyChainOfAxiom axiom) {
        OWLObjectPropertyExpression superProp = axiom.getSuperProperty();
        if (superProp.isOWLTopObjectProperty() || axiom.isEncodingOfTransitiveProperty()) {
            return;
        }
        List<OWLObjectPropertyExpression> chain = axiom.getPropertyChain();
        OWLObjectPropertyExpression first = chain.get(0);
        OWLObjectPropertyExpression last = chain.get(chain.size() - 1);
        this.checkCenter(superProp, chain);
        this.checkExtremes(superProp, first, last);
        this.checkExtremes(superProp, last, first);
    }

    protected void asymmetricNonSimple(OWLAsymmetricObjectPropertyAxiom axiom) {
        if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
            this.violations.add(new UseOfNonSimplePropertyInAsymmetricObjectPropertyAxiom(this.getCurrentOntology(), axiom));
        }
    }

    protected void checkCenter(OWLObjectPropertyExpression superProp, List<OWLObjectPropertyExpression> chain) {
        for (int i = 1; i < chain.size() - 1; ++i) {
            if (!this.getPropertyManager().isLessThan(superProp, chain.get(i))) continue;
            this.chainCycle(chain.get(i));
        }
    }

    protected void checkExtremes(OWLObjectPropertyExpression superProp, OWLObjectPropertyExpression first, OWLObjectPropertyExpression last) {
        if (first.equals(superProp)) {
            if (this.getPropertyManager().isLessThan(superProp, last)) {
                this.chainCycle(last);
            }
        } else if (this.getPropertyManager().isLessThan(superProp, first)) {
            this.chainCycle(first);
        }
    }
}

