/* Generated by wayland-scanner 1.18.0 */

#ifndef QT_TEXT_INPUT_METHOD_UNSTABLE_V1_CLIENT_PROTOCOL_H
#define QT_TEXT_INPUT_METHOD_UNSTABLE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_qt_text_input_method_unstable_v1 The qt_text_input_method_unstable_v1 protocol
 * @section page_ifaces_qt_text_input_method_unstable_v1 Interfaces
 * - @subpage page_iface_qt_text_input_method_v1 - text input
 * - @subpage page_iface_qt_text_input_method_manager_v1 - qt text input method manager
 * @section page_copyright_qt_text_input_method_unstable_v1 Copyright
 * <pre>
 *
 * Copyright © 2020 The Qt Company Ltd.
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct qt_text_input_method_manager_v1;
struct qt_text_input_method_v1;
struct wl_seat;
struct wl_surface;

/**
 * @page page_iface_qt_text_input_method_v1 qt_text_input_method_v1
 * @section page_iface_qt_text_input_method_v1_desc Description
 *
 * The qt_text_input_method interface represents input method events
 * associated with a seat, and is intended to exactly match the
 * internal events of the Qt framework.
 * @section page_iface_qt_text_input_method_v1_api API
 * See @ref iface_qt_text_input_method_v1.
 */
/**
 * @defgroup iface_qt_text_input_method_v1 The qt_text_input_method_v1 interface
 *
 * The qt_text_input_method interface represents input method events
 * associated with a seat, and is intended to exactly match the
 * internal events of the Qt framework.
 */
extern const struct wl_interface qt_text_input_method_v1_interface;
/**
 * @page page_iface_qt_text_input_method_manager_v1 qt_text_input_method_manager_v1
 * @section page_iface_qt_text_input_method_manager_v1_desc Description
 *
 * Manages qt_text_input_method objects.
 * @section page_iface_qt_text_input_method_manager_v1_api API
 * See @ref iface_qt_text_input_method_manager_v1.
 */
/**
 * @defgroup iface_qt_text_input_method_manager_v1 The qt_text_input_method_manager_v1 interface
 *
 * Manages qt_text_input_method objects.
 */
extern const struct wl_interface qt_text_input_method_manager_v1_interface;

/**
 * @ingroup iface_qt_text_input_method_v1
 * @struct qt_text_input_method_v1_listener
 */
struct qt_text_input_method_v1_listener {
	/**
	 * enter event
	 *
	 * Notification that this seat's text-input focus is on a certain
	 * surface.
	 *
	 * When the seat has the keyboard capability the text-input focus
	 * follows the keyboard focus.
	 */
	void (*enter)(void *data,
		      struct qt_text_input_method_v1 *qt_text_input_method_v1,
		      struct wl_surface *surface);
	/**
	 * leave event
	 *
	 * Notification that this seat's text-input focus is no longer on
	 * a certain surface.
	 *
	 * The leave notification is sent before the enter notification for
	 * the new focus.
	 *
	 * When the seat has the keyboard capability the text-input focus
	 * follows the keyboard focus.
	 */
	void (*leave)(void *data,
		      struct qt_text_input_method_v1 *qt_text_input_method_v1,
		      struct wl_surface *surface);
	/**
	 * key event
	 *
	 * A QKeyEvent has been sent from the input method.
	 */
	void (*key)(void *data,
		    struct qt_text_input_method_v1 *qt_text_input_method_v1,
		    int32_t type,
		    int32_t key,
		    int32_t modifiers,
		    int32_t auto_repeat,
		    int32_t count,
		    int32_t native_scan_code,
		    int32_t native_virtual_key,
		    int32_t native_modifiers,
		    const char *text);
	/**
	 * input method event
	 *
	 * Starts an input method event. This can be followed by any
	 * number of input_method_event_attribute events and will always be
	 * finished by an end_input_method_event.
	 */
	void (*start_input_method_event)(void *data,
					 struct qt_text_input_method_v1 *qt_text_input_method_v1,
					 uint32_t serial,
					 int32_t surrounding_text_offset);
	/**
	 * input method event attribute
	 *
	 * Appends an attribute to the input method event with the given
	 * serial. Must be preceded by a start_input_method_event and
	 * concluded by a an end_input_method_event. See documentation of
	 * QInputMethodEvent for details on the attributes.
	 */
	void (*input_method_event_attribute)(void *data,
					     struct qt_text_input_method_v1 *qt_text_input_method_v1,
					     uint32_t serial,
					     int32_t type,
					     int32_t start,
					     int32_t length,
					     const char *value);
	/**
	 * input method event end
	 *
	 * Concludes a previously started input method event. Together
	 * with the preceding input_method_event_attribute events with the
	 * same serial, this should be converted into a QInputMethodEvent.
	 */
	void (*end_input_method_event)(void *data,
				       struct qt_text_input_method_v1 *qt_text_input_method_v1,
				       uint32_t serial,
				       const char *commit_string,
				       const char *preedit_string,
				       int32_t replacement_start,
				       int32_t replacement_length);
	/**
	 * visible changed
	 *
	 * Event to notify client that the visibility of the input method
	 * has been changed.
	 */
	void (*visible_changed)(void *data,
				struct qt_text_input_method_v1 *qt_text_input_method_v1,
				int32_t visible);
	/**
	 * keyboard rectangle changed
	 *
	 * Event to notify client that the keyboard rectangle of the
	 * input method has been changed.
	 */
	void (*keyboard_rectangle_changed)(void *data,
					   struct qt_text_input_method_v1 *qt_text_input_method_v1,
					   wl_fixed_t x,
					   wl_fixed_t y,
					   wl_fixed_t width,
					   wl_fixed_t height);
	/**
	 * keyboard rectangle changed
	 *
	 * Event to notify client that the locale of the input method has
	 * been changed.
	 */
	void (*locale_changed)(void *data,
			       struct qt_text_input_method_v1 *qt_text_input_method_v1,
			       const char *locale_name);
	/**
	 * input direction changed
	 *
	 * Event to notify client that the input direction of the input
	 * method has been changed.
	 */
	void (*input_direction_changed)(void *data,
					struct qt_text_input_method_v1 *qt_text_input_method_v1,
					int32_t input_direction);
};

/**
 * @ingroup iface_qt_text_input_method_v1
 */
static inline int
qt_text_input_method_v1_add_listener(struct qt_text_input_method_v1 *qt_text_input_method_v1,
				     const struct qt_text_input_method_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) qt_text_input_method_v1,
				     (void (**)(void)) listener, data);
}

#define QT_TEXT_INPUT_METHOD_V1_DESTROY 0
#define QT_TEXT_INPUT_METHOD_V1_ENABLE 1
#define QT_TEXT_INPUT_METHOD_V1_DISABLE 2
#define QT_TEXT_INPUT_METHOD_V1_RESET 3
#define QT_TEXT_INPUT_METHOD_V1_COMMIT 4
#define QT_TEXT_INPUT_METHOD_V1_INVOKE_ACTION 5
#define QT_TEXT_INPUT_METHOD_V1_UPDATE_HINTS 6
#define QT_TEXT_INPUT_METHOD_V1_UPDATE_CURSOR_RECTANGLE 7
#define QT_TEXT_INPUT_METHOD_V1_UPDATE_CURSOR_POSITION 8
#define QT_TEXT_INPUT_METHOD_V1_UPDATE_SURROUNDING_TEXT 9
#define QT_TEXT_INPUT_METHOD_V1_UPDATE_ANCHOR_POSITION 10
#define QT_TEXT_INPUT_METHOD_V1_UPDATE_ABSOLUTE_POSITION 11
#define QT_TEXT_INPUT_METHOD_V1_UPDATE_PREFERRED_LANGUAGE 12
#define QT_TEXT_INPUT_METHOD_V1_START_UPDATE 13
#define QT_TEXT_INPUT_METHOD_V1_END_UPDATE 14
#define QT_TEXT_INPUT_METHOD_V1_SHOW_INPUT_PANEL 15
#define QT_TEXT_INPUT_METHOD_V1_HIDE_INPUT_PANEL 16
#define QT_TEXT_INPUT_METHOD_V1_ACKNOWLEDGE_INPUT_METHOD 17

/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_LEAVE_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_KEY_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_START_INPUT_METHOD_EVENT_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_INPUT_METHOD_EVENT_ATTRIBUTE_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_END_INPUT_METHOD_EVENT_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_VISIBLE_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_KEYBOARD_RECTANGLE_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_LOCALE_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_INPUT_DIRECTION_CHANGED_SINCE_VERSION 1

/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_ENABLE_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_DISABLE_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_RESET_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_COMMIT_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_INVOKE_ACTION_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_UPDATE_HINTS_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_UPDATE_CURSOR_RECTANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_UPDATE_CURSOR_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_UPDATE_SURROUNDING_TEXT_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_UPDATE_ANCHOR_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_UPDATE_ABSOLUTE_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_UPDATE_PREFERRED_LANGUAGE_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_START_UPDATE_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_END_UPDATE_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_SHOW_INPUT_PANEL_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_HIDE_INPUT_PANEL_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_v1
 */
#define QT_TEXT_INPUT_METHOD_V1_ACKNOWLEDGE_INPUT_METHOD_SINCE_VERSION 1

/** @ingroup iface_qt_text_input_method_v1 */
static inline void
qt_text_input_method_v1_set_user_data(struct qt_text_input_method_v1 *qt_text_input_method_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) qt_text_input_method_v1, user_data);
}

/** @ingroup iface_qt_text_input_method_v1 */
static inline void *
qt_text_input_method_v1_get_user_data(struct qt_text_input_method_v1 *qt_text_input_method_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) qt_text_input_method_v1);
}

static inline uint32_t
qt_text_input_method_v1_get_version(struct qt_text_input_method_v1 *qt_text_input_method_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) qt_text_input_method_v1);
}

/**
 * @ingroup iface_qt_text_input_method_v1
 *
 * Destroy the qt_text_input_method object.
 */
static inline void
qt_text_input_method_v1_destroy(struct qt_text_input_method_v1 *qt_text_input_method_v1)
{
	wl_proxy_marshal((struct wl_proxy *) qt_text_input_method_v1,
			 QT_TEXT_INPUT_METHOD_V1_DESTROY);

	wl_proxy_destroy((struct wl_proxy *) qt_text_input_method_v1);
}

/**
 * @ingroup iface_qt_text_input_method_v1
 *
 * Enable text input in a surface (usually when a text entry inside of it
 * has focus).
 *
 * This can be called before or after a surface gets text (or keyboard)
 * focus via the enter event. Text input to a surface is only active
 * when it has the current text (or keyboard) focus and is enabled.
 */
static inline void
qt_text_input_method_v1_enable(struct qt_text_input_method_v1 *qt_text_input_method_v1, struct wl_surface *surface)
{
	wl_proxy_marshal((struct wl_proxy *) qt_text_input_method_v1,
			 QT_TEXT_INPUT_METHOD_V1_ENABLE, surface);
}

/**
 * @ingroup iface_qt_text_input_method_v1
 *
 * Disable text input in a surface (typically when there is no focus on any
 * text entry inside the surface).
 */
static inline void
qt_text_input_method_v1_disable(struct qt_text_input_method_v1 *qt_text_input_method_v1, struct wl_surface *surface)
{
	wl_proxy_marshal((struct wl_proxy *) qt_text_input_method_v1,
			 QT_TEXT_INPUT_METHOD_V1_DISABLE, surface);
}

/**
 * @ingroup iface_qt_text_input_method_v1
 *
 * Request for the input method to reset. Corresponds to QInputMethod::reset().
 */
static inline void
qt_text_input_method_v1_reset(struct qt_text_input_method_v1 *qt_text_input_method_v1)
{
	wl_proxy_marshal((struct wl_proxy *) qt_text_input_method_v1,
			 QT_TEXT_INPUT_METHOD_V1_RESET);
}

/**
 * @ingroup iface_qt_text_input_method_v1
 *
 * Request for the input method to commit its current content. Corresponds to QInputMethod::commit().
 */
static inline void
qt_text_input_method_v1_commit(struct qt_text_input_method_v1 *qt_text_input_method_v1)
{
	wl_proxy_marshal((struct wl_proxy *) qt_text_input_method_v1,
			 QT_TEXT_INPUT_METHOD_V1_COMMIT);
}

/**
 * @ingroup iface_qt_text_input_method_v1
 *
 * Passes a mouse click or context menu request from the client to the server. Corresponds to QInputMethod::invokeAction().
 */
static inline void
qt_text_input_method_v1_invoke_action(struct qt_text_input_method_v1 *qt_text_input_method_v1, int32_t type, int32_t cursor_position)
{
	wl_proxy_marshal((struct wl_proxy *) qt_text_input_method_v1,
			 QT_TEXT_INPUT_METHOD_V1_INVOKE_ACTION, type, cursor_position);
}

/**
 * @ingroup iface_qt_text_input_method_v1
 *
 * Notifies the server of the client's current input method hints.
 */
static inline void
qt_text_input_method_v1_update_hints(struct qt_text_input_method_v1 *qt_text_input_method_v1, int32_t hints)
{
	wl_proxy_marshal((struct wl_proxy *) qt_text_input_method_v1,
			 QT_TEXT_INPUT_METHOD_V1_UPDATE_HINTS, hints);
}

/**
 * @ingroup iface_qt_text_input_method_v1
 *
 * Notifies the server of the client's current cursor rectangle.
 */
static inline void
qt_text_input_method_v1_update_cursor_rectangle(struct qt_text_input_method_v1 *qt_text_input_method_v1, int32_t x, int32_t y, int32_t width, int32_t height)
{
	wl_proxy_marshal((struct wl_proxy *) qt_text_input_method_v1,
			 QT_TEXT_INPUT_METHOD_V1_UPDATE_CURSOR_RECTANGLE, x, y, width, height);
}

/**
 * @ingroup iface_qt_text_input_method_v1
 *
 * Notifies the server of the client's current cursor position.
 */
static inline void
qt_text_input_method_v1_update_cursor_position(struct qt_text_input_method_v1 *qt_text_input_method_v1, int32_t cursor_position)
{
	wl_proxy_marshal((struct wl_proxy *) qt_text_input_method_v1,
			 QT_TEXT_INPUT_METHOD_V1_UPDATE_CURSOR_POSITION, cursor_position);
}

/**
 * @ingroup iface_qt_text_input_method_v1
 *
 * Notifies the server of the client's current surrounding text and its offset in the
 * complete text.
 */
static inline void
qt_text_input_method_v1_update_surrounding_text(struct qt_text_input_method_v1 *qt_text_input_method_v1, const char *surrounding_text, int32_t text_offset)
{
	wl_proxy_marshal((struct wl_proxy *) qt_text_input_method_v1,
			 QT_TEXT_INPUT_METHOD_V1_UPDATE_SURROUNDING_TEXT, surrounding_text, text_offset);
}

/**
 * @ingroup iface_qt_text_input_method_v1
 *
 * Notifies the server of the client's current anchor position.
 */
static inline void
qt_text_input_method_v1_update_anchor_position(struct qt_text_input_method_v1 *qt_text_input_method_v1, int32_t anchor_position)
{
	wl_proxy_marshal((struct wl_proxy *) qt_text_input_method_v1,
			 QT_TEXT_INPUT_METHOD_V1_UPDATE_ANCHOR_POSITION, anchor_position);
}

/**
 * @ingroup iface_qt_text_input_method_v1
 *
 * Notifies the server of the client's current absolute cursor position.
 */
static inline void
qt_text_input_method_v1_update_absolute_position(struct qt_text_input_method_v1 *qt_text_input_method_v1, int32_t absolute_position)
{
	wl_proxy_marshal((struct wl_proxy *) qt_text_input_method_v1,
			 QT_TEXT_INPUT_METHOD_V1_UPDATE_ABSOLUTE_POSITION, absolute_position);
}

/**
 * @ingroup iface_qt_text_input_method_v1
 *
 * Notifies the server of the client's current preferred language.
 */
static inline void
qt_text_input_method_v1_update_preferred_language(struct qt_text_input_method_v1 *qt_text_input_method_v1, const char *preferred_language)
{
	wl_proxy_marshal((struct wl_proxy *) qt_text_input_method_v1,
			 QT_TEXT_INPUT_METHOD_V1_UPDATE_PREFERRED_LANGUAGE, preferred_language);
}

/**
 * @ingroup iface_qt_text_input_method_v1
 *
 * Starts an update sequence to notify the server that the client's state has
 * changed. This is followed by any number of update requests for specific
 * parts of the state and concluded by an end_update request.
 */
static inline void
qt_text_input_method_v1_start_update(struct qt_text_input_method_v1 *qt_text_input_method_v1, int32_t queries)
{
	wl_proxy_marshal((struct wl_proxy *) qt_text_input_method_v1,
			 QT_TEXT_INPUT_METHOD_V1_START_UPDATE, queries);
}

/**
 * @ingroup iface_qt_text_input_method_v1
 *
 * Concludes the previously started update request.
 */
static inline void
qt_text_input_method_v1_end_update(struct qt_text_input_method_v1 *qt_text_input_method_v1)
{
	wl_proxy_marshal((struct wl_proxy *) qt_text_input_method_v1,
			 QT_TEXT_INPUT_METHOD_V1_END_UPDATE);
}

/**
 * @ingroup iface_qt_text_input_method_v1
 *
 * Requests that the input panel of the input method is visible.
 */
static inline void
qt_text_input_method_v1_show_input_panel(struct qt_text_input_method_v1 *qt_text_input_method_v1)
{
	wl_proxy_marshal((struct wl_proxy *) qt_text_input_method_v1,
			 QT_TEXT_INPUT_METHOD_V1_SHOW_INPUT_PANEL);
}

/**
 * @ingroup iface_qt_text_input_method_v1
 *
 * Requests that the input panel of the input method is not visible.
 */
static inline void
qt_text_input_method_v1_hide_input_panel(struct qt_text_input_method_v1 *qt_text_input_method_v1)
{
	wl_proxy_marshal((struct wl_proxy *) qt_text_input_method_v1,
			 QT_TEXT_INPUT_METHOD_V1_HIDE_INPUT_PANEL);
}

/**
 * @ingroup iface_qt_text_input_method_v1
 *
 * Sent on receipt of an end_input_method_event to acknowledge that
 * the client has received and handled the event.
 */
static inline void
qt_text_input_method_v1_acknowledge_input_method(struct qt_text_input_method_v1 *qt_text_input_method_v1)
{
	wl_proxy_marshal((struct wl_proxy *) qt_text_input_method_v1,
			 QT_TEXT_INPUT_METHOD_V1_ACKNOWLEDGE_INPUT_METHOD);
}

#define QT_TEXT_INPUT_METHOD_MANAGER_V1_DESTROY 0
#define QT_TEXT_INPUT_METHOD_MANAGER_V1_GET_TEXT_INPUT_METHOD 1


/**
 * @ingroup iface_qt_text_input_method_manager_v1
 */
#define QT_TEXT_INPUT_METHOD_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_qt_text_input_method_manager_v1
 */
#define QT_TEXT_INPUT_METHOD_MANAGER_V1_GET_TEXT_INPUT_METHOD_SINCE_VERSION 1

/** @ingroup iface_qt_text_input_method_manager_v1 */
static inline void
qt_text_input_method_manager_v1_set_user_data(struct qt_text_input_method_manager_v1 *qt_text_input_method_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) qt_text_input_method_manager_v1, user_data);
}

/** @ingroup iface_qt_text_input_method_manager_v1 */
static inline void *
qt_text_input_method_manager_v1_get_user_data(struct qt_text_input_method_manager_v1 *qt_text_input_method_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) qt_text_input_method_manager_v1);
}

static inline uint32_t
qt_text_input_method_manager_v1_get_version(struct qt_text_input_method_manager_v1 *qt_text_input_method_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) qt_text_input_method_manager_v1);
}

/**
 * @ingroup iface_qt_text_input_method_manager_v1
 *
 * Destroy the qt_text_input_method_manager object.
 */
static inline void
qt_text_input_method_manager_v1_destroy(struct qt_text_input_method_manager_v1 *qt_text_input_method_manager_v1)
{
	wl_proxy_marshal((struct wl_proxy *) qt_text_input_method_manager_v1,
			 QT_TEXT_INPUT_METHOD_MANAGER_V1_DESTROY);

	wl_proxy_destroy((struct wl_proxy *) qt_text_input_method_manager_v1);
}

/**
 * @ingroup iface_qt_text_input_method_manager_v1
 *
 * Creates a new text-input-method object for a given seat.
 */
static inline struct qt_text_input_method_v1 *
qt_text_input_method_manager_v1_get_text_input_method(struct qt_text_input_method_manager_v1 *qt_text_input_method_manager_v1, struct wl_seat *seat)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_constructor((struct wl_proxy *) qt_text_input_method_manager_v1,
			 QT_TEXT_INPUT_METHOD_MANAGER_V1_GET_TEXT_INPUT_METHOD, &qt_text_input_method_v1_interface, NULL, seat);

	return (struct qt_text_input_method_v1 *) id;
}

#ifdef  __cplusplus
}
#endif

#endif
