/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.deploy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.DispatcherType;
import org.apache.catalina.util.RequestUtil;

public class FilterMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int ERROR = 1;
    public static final int FORWARD = 2;
    public static final int INCLUDE = 4;
    public static final int REQUEST = 8;
    public static final int ASYNC = 16;
    private static final int NOT_SET = 0;
    private int dispatcherMapping = 0;
    private String filterName = null;
    private String[] servletNames = new String[0];
    private boolean matchAllUrlPatterns = false;
    private boolean matchAllServletNames = false;
    private String[] urlPatterns = new String[0];

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String string) {
        this.filterName = string;
    }

    public String[] getServletNames() {
        if (this.matchAllServletNames) {
            return new String[0];
        }
        return this.servletNames;
    }

    public void addServletName(String string) {
        if ("*".equals(string)) {
            this.matchAllServletNames = true;
        } else {
            String[] stringArray = new String[this.servletNames.length + 1];
            System.arraycopy(this.servletNames, 0, stringArray, 0, this.servletNames.length);
            stringArray[this.servletNames.length] = string;
            this.servletNames = stringArray;
        }
    }

    public boolean getMatchAllUrlPatterns() {
        return this.matchAllUrlPatterns;
    }

    public boolean getMatchAllServletNames() {
        return this.matchAllServletNames;
    }

    public String[] getURLPatterns() {
        if (this.matchAllUrlPatterns) {
            return new String[0];
        }
        return this.urlPatterns;
    }

    public void addURLPattern(String string) {
        if ("*".equals(string)) {
            this.matchAllUrlPatterns = true;
        } else {
            String[] stringArray = new String[this.urlPatterns.length + 1];
            System.arraycopy(this.urlPatterns, 0, stringArray, 0, this.urlPatterns.length);
            stringArray[this.urlPatterns.length] = RequestUtil.URLDecode(string);
            this.urlPatterns = stringArray;
        }
    }

    public void setDispatcher(String string) {
        String string2 = string.toUpperCase(Locale.ENGLISH);
        if (string2.equals(DispatcherType.FORWARD.name())) {
            this.dispatcherMapping |= 2;
        } else if (string2.equals(DispatcherType.INCLUDE.name())) {
            this.dispatcherMapping |= 4;
        } else if (string2.equals(DispatcherType.REQUEST.name())) {
            this.dispatcherMapping |= 8;
        } else if (string2.equals(DispatcherType.ERROR.name())) {
            this.dispatcherMapping |= 1;
        } else if (string2.equals(DispatcherType.ASYNC.name())) {
            this.dispatcherMapping |= 0x10;
        }
    }

    public int getDispatcherMapping() {
        if (this.dispatcherMapping == 0) {
            return 8;
        }
        return this.dispatcherMapping;
    }

    public String[] getDispatcherNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((this.dispatcherMapping & 2) > 0) {
            arrayList.add(DispatcherType.FORWARD.name());
        }
        if ((this.dispatcherMapping & 4) > 0) {
            arrayList.add(DispatcherType.INCLUDE.name());
        }
        if ((this.dispatcherMapping & 8) > 0) {
            arrayList.add(DispatcherType.REQUEST.name());
        }
        if ((this.dispatcherMapping & 1) > 0) {
            arrayList.add(DispatcherType.ERROR.name());
        }
        if ((this.dispatcherMapping & 0x10) > 0) {
            arrayList.add(DispatcherType.ASYNC.name());
        }
        return arrayList.toArray(new String[0]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("FilterMap[");
        stringBuilder.append("filterName=");
        stringBuilder.append(this.filterName);
        for (String string : this.servletNames) {
            stringBuilder.append(", servletName=");
            stringBuilder.append(string);
        }
        for (String string : this.urlPatterns) {
            stringBuilder.append(", urlPattern=");
            stringBuilder.append(string);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

