/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.TypeMatchingStrategy;
import com.google.javascript.refactoring.JsSourceMatcher;
import com.google.javascript.refactoring.Match;
import com.google.javascript.refactoring.NodeMetadata;
import com.google.javascript.refactoring.Scanner;
import com.google.javascript.refactoring.ScriptMetadata;
import com.google.javascript.refactoring.SuggestedFix;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public final class RefasterJsScanner
extends Scanner {
    private String templateJs = null;
    private TypeMatchingStrategy typeMatchingStrategy = TypeMatchingStrategy.SUBTYPES;
    private LinkedHashMap<JsSourceMatcher, ImmutableList<RefasterJsTemplate>> templates;
    private ImmutableList<RefasterJsTemplate> matchedTemplates;
    private static final Pattern AFTER_CHOICE_PATTERN = Pattern.compile("^after_option_(\\d*)_(.*)");

    public void loadRefasterJsTemplate(String refasterjsTemplate) throws IOException {
        Preconditions.checkState(this.templateJs == null, "Can't load RefasterJs template since a template is already loaded.");
        this.templateJs = Thread.currentThread().getContextClassLoader().getResource(refasterjsTemplate) != null ? Resources.toString(Resources.getResource(refasterjsTemplate), StandardCharsets.UTF_8) : Files.asCharSource(new File(refasterjsTemplate), StandardCharsets.UTF_8).read();
    }

    public void setTypeMatchingStrategy(TypeMatchingStrategy typeMatchingStrategy) {
        this.typeMatchingStrategy = typeMatchingStrategy;
    }

    public void loadRefasterJsTemplateFromCode(String refasterJsTemplate) throws IOException {
        Preconditions.checkState(this.templateJs == null, "Can't load RefasterJs template since a template is already loaded.");
        this.templateJs = refasterJsTemplate;
    }

    public void clearTemplates() {
        this.templates = null;
        this.matchedTemplates = null;
    }

    @Override
    public boolean matches(Node node, NodeMetadata metadata) {
        if (this.templates == null) {
            try {
                this.initialize(metadata.getCompiler());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.matchedTemplates = null;
        for (Map.Entry<JsSourceMatcher, ImmutableList<RefasterJsTemplate>> e : this.templates.entrySet()) {
            if (!e.getKey().matches(node, metadata)) continue;
            this.matchedTemplates = e.getValue();
            return true;
        }
        return false;
    }

    public ImmutableList<SuggestedFix> processMatch(Match match) {
        SuggestedFix.Builder defaultFix = null;
        for (RefasterJsTemplate matchedTemplate : this.matchedTemplates) {
            SuggestedFix.Builder fix = new SuggestedFix.Builder();
            if (matchedTemplate.beforeTemplate.getLastChild().isEquivalentTo(matchedTemplate.afterTemplate.getLastChild())) {
                return ImmutableList.of();
            }
            Node script = NodeUtil.getEnclosingScript(match.getNode());
            ScriptMetadata scriptMetadata = ScriptMetadata.create(script, match.getMetadata());
            for (String require : matchedTemplate.getGoogRequiresToAdd()) {
                if (scriptMetadata.getAlias(require) != null) continue;
                fix.addGoogRequire(match, require, scriptMetadata);
            }
            Preconditions.checkState(matchedTemplate.matcher.matches(match.getNode(), match.getMetadata()), "Matcher for %s did not match a second time", (Object)matchedTemplate.beforeTemplate);
            Node newNode = this.transformNode(matchedTemplate.afterTemplate.getLastChild(), matchedTemplate.matcher.getTemplateNodeToMatchMap(), scriptMetadata);
            Node nodeToReplace = match.getNode();
            fix.attachMatchedNodeInfo(nodeToReplace, match.getMetadata().getCompiler());
            fix.replace(nodeToReplace, newNode, match.getMetadata().getCompiler());
            Node n = match.getNode().getNext();
            int count = matchedTemplate.beforeTemplate.getLastChild().getChildCount();
            for (int i = 1; i < count; ++i) {
                Preconditions.checkNotNull(n, "Found mismatched sibling count between before template and matched node.\nTemplate: %s to %s\nMatch: %s", (Object)matchedTemplate.beforeTemplate.getLastChild(), (Object)matchedTemplate.afterTemplate.getLastChild(), (Object)match.getNode());
                fix.delete(n);
                n = n.getNext();
            }
            for (String require : matchedTemplate.getGoogRequiresToRemove()) {
                fix.removeGoogRequire(match, require);
            }
            if (defaultFix == null) {
                defaultFix = fix;
                continue;
            }
            defaultFix.addAlternative(fix.build());
        }
        return ImmutableList.of(defaultFix.build());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node transformNode(Node templateNode, Map<String, Node> templateNodeToMatchMap, ScriptMetadata scriptMetadata) {
        String alias;
        String name;
        Node clone = templateNode.cloneNode();
        if (templateNode.isName()) {
            name = templateNode.getString();
            if (templateNodeToMatchMap.containsKey(name)) {
                Node templateMatch = templateNodeToMatchMap.get(name);
                Preconditions.checkNotNull(templateMatch, "Match for %s is null", (Object)name);
                if (!templateNode.getParent().isVar()) return templateMatch.cloneTree();
                clone.setString(templateMatch.getString());
            }
        } else if (templateNode.isCall() && templateNode.getBooleanProp(Node.FREE_CALL) && templateNode.getFirstChild().isName() && templateNodeToMatchMap.containsKey(name = templateNode.getFirstChild().getString())) {
            clone.putBooleanProp(Node.FREE_CALL, false);
        }
        if (templateNode.isQualifiedName() && (alias = scriptMetadata.getAlias(name = templateNode.getQualifiedName())) != null && !name.equals(alias)) {
            return IR.name(alias);
        }
        for (Node child : templateNode.children()) {
            clone.addChildToBack(this.transformNode(child, templateNodeToMatchMap, scriptMetadata));
        }
        return clone;
    }

    void initialize(AbstractCompiler compiler) throws Exception {
        Preconditions.checkState(!Strings.isNullOrEmpty(this.templateJs), "The template JS must be loaded before the scanner is used. Make sure that the template file is not empty.");
        Node scriptRoot = new JsAst(SourceFile.fromCode("template", this.templateJs)).getAstRoot(compiler);
        LinkedHashMap<Object, Node> beforeTemplates = new LinkedHashMap<Object, Node>();
        HashMap<Object, NavigableMap<Object, Object>> afterTemplates = new HashMap<Object, NavigableMap<Object, Object>>();
        HashSet<String> hasChoices = new HashSet<String>();
        for (Node templateNode : scriptRoot.children()) {
            Object templateName;
            if (!templateNode.isFunction()) continue;
            String fnName = templateNode.getFirstChild().getQualifiedName();
            if (fnName.startsWith("before_")) {
                templateName = fnName.substring("before_".length());
                Preconditions.checkState(!beforeTemplates.containsKey(templateName), "Found existing template with the same name: %s", beforeTemplates.get(templateName));
                Preconditions.checkState(templateNode.getLastChild().hasChildren(), "Before templates are not allowed to be empty!");
                beforeTemplates.put(templateName, templateNode);
                continue;
            }
            if (fnName.startsWith("after_option_")) {
                Matcher m = AFTER_CHOICE_PATTERN.matcher(fnName);
                Preconditions.checkState(m.matches(), "Template name %s must match pattern after_option_\\d*_", (Object)fnName);
                int optionNumber = Integer.parseInt(m.group(1));
                String templateName2 = m.group(2);
                if (!afterTemplates.containsKey(templateName2)) {
                    afterTemplates.put(templateName2, new TreeMap());
                    hasChoices.add(templateName2);
                }
                Preconditions.checkState(hasChoices.contains(templateName2), "Template %s can only be mixed with other after_option_ templates");
                Preconditions.checkState(!((SortedMap)afterTemplates.get(templateName2)).containsKey(optionNumber), "Found duplicate template for %s, assign unique indexes for options", (Object)fnName);
                ((SortedMap)afterTemplates.get(templateName2)).put(optionNumber, templateNode);
                continue;
            }
            if (fnName.startsWith("after_")) {
                templateName = fnName.substring("after_".length());
                Preconditions.checkState(!afterTemplates.containsKey(templateName), "Found existing template with the same name: %s", afterTemplates.get(templateName));
                afterTemplates.put(templateName, ImmutableSortedMap.of(0, templateNode));
                continue;
            }
            if (!fnName.startsWith("do_not_change_")) continue;
            templateName = fnName.substring("do_not_change_".length());
            Preconditions.checkState(!beforeTemplates.containsKey(templateName), "Found existing template with the same name: %s", beforeTemplates.get(templateName));
            Preconditions.checkState(!afterTemplates.containsKey(templateName), "Found existing template with the same name: %s", afterTemplates.get(templateName));
            beforeTemplates.put(templateName, templateNode);
            afterTemplates.put(templateName, ImmutableSortedMap.of(0, templateNode));
        }
        Preconditions.checkState(!beforeTemplates.isEmpty(), "Did not find any RefasterJs templates! Make sure that there are 2 functions defined with the same name, one with a \"before_\" prefix and one with a \"after_\" prefix");
        this.templates = new LinkedHashMap();
        for (String templateName : beforeTemplates.keySet()) {
            Preconditions.checkState(afterTemplates.containsKey(templateName) && !((SortedMap)afterTemplates.get(templateName)).isEmpty(), "Found before template without at least one corresponding after  template. Make sure there is an after_%s or after_option_1_%s function defined.", (Object)templateName, (Object)templateName);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Node afterTemplateOption : ((SortedMap)afterTemplates.get(templateName)).values()) {
                builder.add(new RefasterJsTemplate(compiler, this.typeMatchingStrategy, (Node)beforeTemplates.get(templateName), afterTemplateOption));
            }
            ImmutableCollection afterOptions = builder.build();
            this.templates.put(((RefasterJsTemplate)afterOptions.get((int)0)).matcher, (ImmutableList<RefasterJsTemplate>)afterOptions);
        }
    }

    private static class RefasterJsTemplate {
        private static final Pattern ADD_GOOG_REQUIRE_PATTERN = Pattern.compile("\\+require\\s+\\{([^}]+)\\}");
        private static final Pattern REMOVE_GOOG_REQUIRE_PATTERN = Pattern.compile("-require\\s+\\{([^}]+)\\}");
        final JsSourceMatcher matcher;
        final Node beforeTemplate;
        final Node afterTemplate;

        RefasterJsTemplate(AbstractCompiler compiler, TypeMatchingStrategy typeMatchingStrategy, Node beforeTemplate, Node afterTemplate) {
            this.matcher = new JsSourceMatcher(compiler, beforeTemplate, typeMatchingStrategy);
            this.beforeTemplate = beforeTemplate;
            this.afterTemplate = afterTemplate;
        }

        List<String> getGoogRequiresToAdd() {
            return this.getGoogRequiresFromPattern(ADD_GOOG_REQUIRE_PATTERN);
        }

        List<String> getGoogRequiresToRemove() {
            return this.getGoogRequiresFromPattern(REMOVE_GOOG_REQUIRE_PATTERN);
        }

        private ImmutableList<String> getGoogRequiresFromPattern(Pattern pattern) {
            return Stream.concat(RefasterJsTemplate.getGoogRequiresFromNode(pattern, this.beforeTemplate).stream(), RefasterJsTemplate.getGoogRequiresFromNode(pattern, this.afterTemplate).stream()).distinct().collect(ImmutableList.toImmutableList());
        }

        private static ImmutableList<String> getGoogRequiresFromNode(Pattern pattern, Node beforeTemplate) {
            JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(beforeTemplate);
            if (jsDoc == null) {
                return ImmutableList.of();
            }
            String jsDocContent = jsDoc.getOriginalCommentString();
            if (jsDocContent == null) {
                return ImmutableList.of();
            }
            ImmutableList.Builder requires = ImmutableList.builder();
            Matcher m = pattern.matcher(jsDocContent);
            while (m.find()) {
                requires.add(m.group(1));
            }
            return requires.build();
        }
    }
}

