/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.jpeg;

import java.util.ArrayList;

public class JpegData {
    private boolean _exifDataPresent = false;
    private char _latitudeRef = '\u0000';
    private char _longitudeRef = '\u0000';
    private byte _altitudeRef = 0;
    private double[] _latitude = null;
    private double[] _longitude = null;
    private int _altitude = -1;
    private boolean _altitudePresent = false;
    private int[] _gpsTimestamp = null;
    private int[] _gpsDatestamp = null;
    private String _originalTimestamp = null;
    private String _digitizedTimestamp = null;
    private int _orientationCode = -1;
    private byte[] _thumbnail = null;
    private double _bearing = -1.0;
    private ArrayList<String> _errors = null;

    public void setExifDataPresent() {
        this._exifDataPresent = true;
    }

    public boolean getExifDataPresent() {
        return this._exifDataPresent;
    }

    public void setLatitudeRef(String string) {
        if (string != null && string.length() == 1) {
            this._latitudeRef = string.charAt(0);
        }
    }

    public void setLatitude(double[] dArray) {
        if (dArray != null && dArray.length == 3) {
            this._latitude = dArray;
        }
    }

    public void setLongitudeRef(String string) {
        if (string != null && string.length() == 1) {
            this._longitudeRef = string.charAt(0);
        }
    }

    public void setLongitude(double[] dArray) {
        if (dArray != null && dArray.length == 3) {
            this._longitude = dArray;
        }
    }

    public void setAltitudeRef(byte by) {
        this._altitudeRef = by;
    }

    public void setAltitude(int n) {
        this._altitude = n;
        this._altitudePresent = true;
    }

    public void setGpsTimestamp(int[] nArray) {
        this._gpsTimestamp = nArray;
    }

    public void setGpsDatestamp(int[] nArray) {
        this._gpsDatestamp = nArray;
    }

    public void setOriginalTimestamp(String string) {
        this._originalTimestamp = string;
    }

    public void setDigitizedTimestamp(String string) {
        this._digitizedTimestamp = string;
    }

    public void setOrientationCode(int n) {
        if (n >= 1 && n <= 8) {
            this._orientationCode = n;
        }
    }

    public void setBearing(double d) {
        this._bearing = d;
    }

    public char getLatitudeRef() {
        return this._latitudeRef;
    }

    public double[] getLatitude() {
        return this._latitude;
    }

    public char getLongitudeRef() {
        return this._longitudeRef;
    }

    public double[] getLongitude() {
        return this._longitude;
    }

    public byte getAltitudeRef() {
        return this._altitudeRef;
    }

    public boolean hasAltitude() {
        return this._altitudePresent;
    }

    public int getAltitude() {
        return this._altitude;
    }

    public int[] getGpsTimestamp() {
        return this._gpsTimestamp;
    }

    public int[] getGpsDatestamp() {
        return this._gpsDatestamp;
    }

    public int getOrientationCode() {
        return this._orientationCode;
    }

    public String getOriginalTimestamp() {
        return this._originalTimestamp;
    }

    public String getDigitizedTimestamp() {
        return this._digitizedTimestamp;
    }

    public double getBearing() {
        return this._bearing;
    }

    public void setThumbnailImage(byte[] byArray) {
        this._thumbnail = byArray;
    }

    public byte[] getThumbnailImage() {
        return this._thumbnail;
    }

    public int getRequiredRotation() {
        if (this._orientationCode <= 2) {
            return 0;
        }
        if (this._orientationCode <= 4) {
            return 2;
        }
        if (this._orientationCode <= 6) {
            return 1;
        }
        return 3;
    }

    public boolean isGpsValid() {
        return !(this._latitudeRef != 'N' && this._latitudeRef != 'n' && this._latitudeRef != 'S' && this._latitudeRef != 's' || this._latitude == null || this._longitudeRef != 'E' && this._longitudeRef != 'e' && this._longitudeRef != 'W' && this._longitudeRef != 'w' || this._longitude == null);
    }

    public void addError(String string) {
        if (this._errors == null) {
            this._errors = new ArrayList();
        }
        this._errors.add(string);
    }

    public int getNumErrors() {
        if (this._errors == null) {
            return 0;
        }
        return this._errors.size();
    }

    public boolean hasErrors() {
        return this.getNumErrors() > 0;
    }

    public ArrayList<String> getErrors() {
        return this._errors;
    }
}

