/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters.jq;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.internal.Utils;
import org.testng.reporters.Files;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.jq.BannerPanel;
import org.testng.reporters.jq.ChronologicalPanel;
import org.testng.reporters.jq.GroupPanel;
import org.testng.reporters.jq.INavigatorPanel;
import org.testng.reporters.jq.IgnoredMethodsPanel;
import org.testng.reporters.jq.Model;
import org.testng.reporters.jq.NavigatorPanel;
import org.testng.reporters.jq.ReporterPanel;
import org.testng.reporters.jq.SuitePanel;
import org.testng.reporters.jq.TestNgXmlPanel;
import org.testng.reporters.jq.TestPanel;
import org.testng.reporters.jq.TimesPanel;
import org.testng.xml.XmlSuite;

public class Main
implements IReporter {
    private static final String TESTNG_RESOURCE_PREFIX = "/org/testng/";
    private static final String[] RESOURCES = new String[]{"jquery-1.7.1.min.js", "testng-reports.css", "testng-reports.js", "passed.png", "failed.png", "skipped.png", "navigator-bullet.png", "bullet_point.png", "collapseall.gif"};
    public static final String REPORT_HEADER_FILE = "header";
    private Model m_model;
    private String m_outputDirectory;

    @Override
    public void generateReport(List<XmlSuite> list, List<ISuite> list2, String string) {
        this.m_model = new Model(list2);
        this.m_outputDirectory = string;
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer("    ");
        new BannerPanel(this.m_model).generate(xMLStringBuffer);
        List<INavigatorPanel> list3 = Arrays.asList(new TestNgXmlPanel(this.m_model), new TestPanel(this.m_model), new GroupPanel(this.m_model), new TimesPanel(this.m_model), new ReporterPanel(this.m_model), new IgnoredMethodsPanel(this.m_model), new ChronologicalPanel(this.m_model));
        new NavigatorPanel(this.m_model, list3).generate(xMLStringBuffer);
        xMLStringBuffer.push("div", "class", "wrapper");
        xMLStringBuffer.push("div", "class", "main-panel-root");
        new SuitePanel(this.m_model).generate(xMLStringBuffer);
        for (INavigatorPanel object : list3) {
            object.generate(xMLStringBuffer);
        }
        xMLStringBuffer.pop("div");
        xMLStringBuffer.pop("div");
        xMLStringBuffer.addString("  </body>\n");
        xMLStringBuffer.addString("</html>\n");
        try (InputStream iOException = this.getClass().getResourceAsStream("/org/testng/header");){
            if (iOException == null) {
                throw new RuntimeException("Couldn't find resource header");
            }
            for (String string2 : RESOURCES) {
                try (InputStream inputStream = this.getClass().getResourceAsStream(TESTNG_RESOURCE_PREFIX + string2);){
                    if (inputStream == null) {
                        throw new AssertionError((Object)("Couldn't find resource: " + string2));
                    }
                    Files.copyFile(inputStream, new File(this.m_outputDirectory, string2));
                }
            }
            String string3 = Files.readFile(iOException);
            Utils.writeUtf8File(this.m_outputDirectory, "index.html", xMLStringBuffer, string3);
        }
        catch (IOException iOException2) {
            iOException2.printStackTrace();
        }
    }
}

