/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.word2vec;

import com.hankcs.hanlp.mining.word2vec.KMeansClustering;
import com.hankcs.hanlp.mining.word2vec.VectorsReader;

public final class WordCluster {
    static void usage() {
        System.err.printf("Usage: java %s <query-file> <k> <out-file>\n", WordCluster.class.getName());
        System.err.println("\t<query-file> contains word projections in the text format\n");
        System.err.println("\t<k> number of clustering\n");
        System.err.println("\t<out-file> output file\n");
        System.exit(0);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            WordCluster.usage();
        }
        String vectorFile = args[0];
        int k = Integer.parseInt(args[1]);
        String outFile = args[2];
        VectorsReader vectorsReader = new VectorsReader(vectorFile);
        vectorsReader.readVectorFile();
        KMeansClustering kmc = new KMeansClustering(vectorsReader, k, outFile);
        kmc.clustering();
    }
}

