/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.scripting.xmltags;

import java.util.Map;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.scripting.xmltags.ExpressionEvaluator;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.session.Configuration;

public class ForEachSqlNode
implements SqlNode {
    public static final String ITEM_PREFIX = "__frch_";
    private final ExpressionEvaluator evaluator = new ExpressionEvaluator();
    private final String collectionExpression;
    private final SqlNode contents;
    private final String open;
    private final String close;
    private final String separator;
    private final String item;
    private final String index;
    private final Configuration configuration;

    public ForEachSqlNode(Configuration configuration, SqlNode contents, String collectionExpression, String index, String item, String open, String close, String separator) {
        this.collectionExpression = collectionExpression;
        this.contents = contents;
        this.open = open;
        this.close = close;
        this.separator = separator;
        this.index = index;
        this.item = item;
        this.configuration = configuration;
    }

    @Override
    public boolean apply(DynamicContext context) {
        Map<String, Object> bindings = context.getBindings();
        Iterable<?> iterable = this.evaluator.evaluateIterable(this.collectionExpression, bindings);
        if (!iterable.iterator().hasNext()) {
            return true;
        }
        boolean first = true;
        this.applyOpen(context);
        int i = 0;
        for (Object o : iterable) {
            DynamicContext oldContext = context;
            context = first || this.separator == null ? new PrefixedContext(context, "") : new PrefixedContext(context, this.separator);
            int uniqueNumber = context.getUniqueNumber();
            if (o instanceof Map.Entry) {
                Map.Entry mapEntry = (Map.Entry)o;
                this.applyIndex(context, mapEntry.getKey(), uniqueNumber);
                this.applyItem(context, mapEntry.getValue(), uniqueNumber);
            } else {
                this.applyIndex(context, i, uniqueNumber);
                this.applyItem(context, o, uniqueNumber);
            }
            this.contents.apply(new FilteredDynamicContext(this.configuration, context, this.index, this.item, uniqueNumber));
            if (first) {
                first = !((PrefixedContext)context).isPrefixApplied();
            }
            context = oldContext;
            ++i;
        }
        this.applyClose(context);
        context.getBindings().remove(this.item);
        context.getBindings().remove(this.index);
        return true;
    }

    private void applyIndex(DynamicContext context, Object o, int i) {
        if (this.index != null) {
            context.bind(this.index, o);
            context.bind(ForEachSqlNode.itemizeItem(this.index, i), o);
        }
    }

    private void applyItem(DynamicContext context, Object o, int i) {
        if (this.item != null) {
            context.bind(this.item, o);
            context.bind(ForEachSqlNode.itemizeItem(this.item, i), o);
        }
    }

    private void applyOpen(DynamicContext context) {
        if (this.open != null) {
            context.appendSql(this.open);
        }
    }

    private void applyClose(DynamicContext context) {
        if (this.close != null) {
            context.appendSql(this.close);
        }
    }

    private static String itemizeItem(String item, int i) {
        return ITEM_PREFIX + item + "_" + i;
    }

    private class PrefixedContext
    extends DynamicContext {
        private final DynamicContext delegate;
        private final String prefix;
        private boolean prefixApplied;

        public PrefixedContext(DynamicContext delegate, String prefix) {
            super(ForEachSqlNode.this.configuration, null);
            this.delegate = delegate;
            this.prefix = prefix;
            this.prefixApplied = false;
        }

        public boolean isPrefixApplied() {
            return this.prefixApplied;
        }

        @Override
        public Map<String, Object> getBindings() {
            return this.delegate.getBindings();
        }

        @Override
        public void bind(String name, Object value) {
            this.delegate.bind(name, value);
        }

        @Override
        public void appendSql(String sql) {
            if (!this.prefixApplied && sql != null && sql.trim().length() > 0) {
                this.delegate.appendSql(this.prefix);
                this.prefixApplied = true;
            }
            this.delegate.appendSql(sql);
        }

        @Override
        public String getSql() {
            return this.delegate.getSql();
        }

        @Override
        public int getUniqueNumber() {
            return this.delegate.getUniqueNumber();
        }
    }

    private static class FilteredDynamicContext
    extends DynamicContext {
        private final DynamicContext delegate;
        private final int index;
        private final String itemIndex;
        private final String item;

        public FilteredDynamicContext(Configuration configuration, DynamicContext delegate, String itemIndex, String item, int i) {
            super(configuration, null);
            this.delegate = delegate;
            this.index = i;
            this.itemIndex = itemIndex;
            this.item = item;
        }

        @Override
        public Map<String, Object> getBindings() {
            return this.delegate.getBindings();
        }

        @Override
        public void bind(String name, Object value) {
            this.delegate.bind(name, value);
        }

        @Override
        public String getSql() {
            return this.delegate.getSql();
        }

        @Override
        public void appendSql(String sql) {
            GenericTokenParser parser = new GenericTokenParser("#{", "}", content -> {
                String newContent = content.replaceFirst("^\\s*" + this.item + "(?![^.,:\\s])", ForEachSqlNode.itemizeItem(this.item, this.index));
                if (this.itemIndex != null && newContent.equals(content)) {
                    newContent = content.replaceFirst("^\\s*" + this.itemIndex + "(?![^.,:\\s])", ForEachSqlNode.itemizeItem(this.itemIndex, this.index));
                }
                return "#{" + newContent + "}";
            });
            this.delegate.appendSql(parser.parse(sql));
        }

        @Override
        public int getUniqueNumber() {
            return this.delegate.getUniqueNumber();
        }
    }
}

