/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.mindmap;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.mindmap.MindMapDiagram;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class CommandMindMapOrgmode
extends SingleLineCommand2<MindMapDiagram> {
    public CommandMindMapOrgmode() {
        super(false, CommandMindMapOrgmode.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandMindMapOrgmode.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "([ \t]*[*]+)"), new RegexOptional((IRegex)new RegexLeaf("BACKCOLOR", "\\[(#\\w+)\\]")), new RegexLeaf("SHAPE", "(_)?"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("LABEL", "([^%s].*)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(MindMapDiagram diagram, LineLocation location, RegexResult arg) {
        String type = arg.get("TYPE", 0);
        String label = arg.get("LABEL", 0);
        String stringColor = arg.get("BACKCOLOR", 0);
        HColor backColor = null;
        if (stringColor != null) {
            backColor = diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(stringColor);
        }
        int level = this.getLevel(type);
        return diagram.addIdea(backColor, level, Display.getWithNewlines(label), IdeaShape.fromDesc(arg.get("SHAPE", 0)));
    }

    private int getLevel(String type) {
        if (type.endsWith("**")) {
            type = type.replace('\t', ' ').trim();
        }
        return type.length() - 1;
    }
}

