/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.factory;

import net.sourceforge.plantuml.salt.DataSource;
import net.sourceforge.plantuml.salt.Dictionary;
import net.sourceforge.plantuml.salt.Terminated;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.element.ElementBorder;
import net.sourceforge.plantuml.salt.factory.AbstractElementFactoryComplex;

public class ElementFactoryBorder
extends AbstractElementFactoryComplex {
    public ElementFactoryBorder(DataSource dataSource, Dictionary dictionary) {
        super(dataSource, dictionary);
    }

    @Override
    public Terminated<Element> create() {
        if (!this.ready()) {
            throw new IllegalStateException();
        }
        String header = (String)((Terminated)this.getDataSource().next()).getElement();
        assert (header.startsWith("{"));
        ElementBorder result = new ElementBorder();
        block7: while (!this.getDataSource().peek(0).getElement().equals("}")) {
            String pos = (String)((Terminated)this.getDataSource().next()).getElement();
            switch (pos.charAt(0)) {
                case 'N': {
                    result.setNorth(this.getNextElement().getElement());
                    continue block7;
                }
                case 'S': {
                    result.setSouth(this.getNextElement().getElement());
                    continue block7;
                }
                case 'E': {
                    result.setEast(this.getNextElement().getElement());
                    continue block7;
                }
                case 'W': {
                    result.setWest(this.getNextElement().getElement());
                    continue block7;
                }
                case 'C': {
                    result.setCenter(this.getNextElement().getElement());
                    continue block7;
                }
            }
            throw new IllegalStateException();
        }
        Terminated next = (Terminated)this.getDataSource().next();
        return new Terminated<Element>(result, next.getTerminator());
    }

    @Override
    public boolean ready() {
        String text = this.getDataSource().peek(0).getElement();
        if (text.equals("{") || text.equals("{+") || text.equals("{#") || text.equals("{!") || text.equals("{-")) {
            String text1 = this.getDataSource().peek(1).getElement();
            return text1.matches("[NSEW]=");
        }
        return false;
    }
}

