/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response.transform;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrReturnFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChildDocTransformer
extends DocTransformer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String ANON_CHILD_KEY = "_childDocuments_";
    private final String name;
    private final BitSetProducer parentsFilter;
    private final DocSet childDocSet;
    private final int limit;
    private final boolean isNestedSchema;
    private final SolrReturnFields childReturnFields;

    ChildDocTransformer(String name, BitSetProducer parentsFilter, DocSet childDocSet, SolrReturnFields returnFields, boolean isNestedSchema, int limit) {
        this.name = name;
        this.parentsFilter = parentsFilter;
        this.childDocSet = childDocSet;
        this.limit = limit;
        this.isNestedSchema = isNestedSchema;
        this.childReturnFields = returnFields != null ? returnFields : new SolrReturnFields();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean needsSolrIndexSearcher() {
        return true;
    }

    @Override
    public void transform(SolrDocument rootDoc, int rootDocId) {
        try {
            int segPrevRootId;
            SolrIndexSearcher searcher = this.context.getSearcher();
            List leaves = searcher.getIndexReader().leaves();
            int seg = ReaderUtil.subIndex((int)rootDocId, (List)leaves);
            LeafReaderContext leafReaderContext = (LeafReaderContext)leaves.get(seg);
            int segBaseId = leafReaderContext.docBase;
            int segRootId = rootDocId - segBaseId;
            BitSet segParentsBitSet = this.parentsFilter.getBitSet(leafReaderContext);
            Bits liveDocs = leafReaderContext.reader().getLiveDocs();
            if (segParentsBitSet == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Parent filter '" + this.parentsFilter + "' doesn't match any parent documents");
            }
            int n = segPrevRootId = segRootId == 0 ? -1 : segParentsBitSet.prevSetBit(segRootId - 1);
            if (segPrevRootId == segRootId - 1) {
                return;
            }
            SortedDocValues segPathDocValues = DocValues.getSorted((LeafReader)leafReaderContext.reader(), (String)"_nest_path_");
            String rootDocPath = this.getPathByDocId(segRootId, DocValues.getSorted((LeafReader)leafReaderContext.reader(), (String)"_nest_path_"));
            HashMap<String, Multimap> pendingParentPathsToChildren = new HashMap<String, Multimap>();
            int firstChildId = segBaseId + segPrevRootId + 1;
            int matches = 0;
            for (int docId = firstChildId; docId < rootDocId; ++docId) {
                boolean isAncestor;
                int segDocId = docId - segBaseId;
                if (liveDocs != null && !liveDocs.get(segDocId)) continue;
                String fullDocPath = this.getPathByDocId(segDocId, segPathDocValues);
                if (this.isNestedSchema && !fullDocPath.startsWith(rootDocPath) || !(isAncestor = pendingParentPathsToChildren.containsKey(fullDocPath)) && this.childDocSet != null && !this.childDocSet.exists(docId) || this.limit != -1 && matches >= this.limit && !isAncestor) continue;
                ++matches;
                SolrDocument doc = searcher.getDocFetcher().solrDoc(docId, this.childReturnFields);
                if (this.childReturnFields.getTransformer() != null) {
                    if (this.childReturnFields.getTransformer().context == null) {
                        this.childReturnFields.getTransformer().setContext(this.context);
                    }
                    this.childReturnFields.getTransformer().transform(doc, docId);
                }
                if (isAncestor) {
                    ChildDocTransformer.addChildrenToParent(doc, (Multimap<String, SolrDocument>)((Multimap)pendingParentPathsToChildren.remove(fullDocPath)));
                }
                String parentDocPath = ChildDocTransformer.getParentPath(fullDocPath);
                String lastPath = ChildDocTransformer.getLastPath(fullDocPath);
                pendingParentPathsToChildren.computeIfAbsent(parentDocPath, x -> ArrayListMultimap.create()).put((Object)ChildDocTransformer.trimLastPoundIfArray(lastPath), (Object)doc);
            }
            if (pendingParentPathsToChildren.isEmpty()) {
                return;
            }
            assert (pendingParentPathsToChildren.keySet().size() == 1);
            ChildDocTransformer.addChildrenToParent(rootDoc, (Multimap<String, SolrDocument>)((Multimap)pendingParentPathsToChildren.values().iterator().next()));
        }
        catch (IOException e) {
            log.warn("Could not fetch child documents", (Throwable)e);
            rootDoc.put(this.getName(), (Object)"Could not fetch child documents");
        }
    }

    private static void addChildrenToParent(SolrDocument parent, Multimap<String, SolrDocument> children) {
        for (String childLabel : children.keySet()) {
            ChildDocTransformer.addChildrenToParent(parent, children.get((Object)childLabel), childLabel);
        }
    }

    private static void addChildrenToParent(SolrDocument parent, Collection<SolrDocument> children, String cDocsPath) {
        if (cDocsPath.equals(ANON_CHILD_KEY)) {
            parent.addChildDocuments(children);
            return;
        }
        String trimmedPath = ChildDocTransformer.trimLastPound(cDocsPath);
        if (!parent.containsKey((Object)trimmedPath) && trimmedPath == cDocsPath) {
            ArrayList<SolrDocument> list = new ArrayList<SolrDocument>(children);
            parent.setField(trimmedPath, list);
            return;
        }
        parent.setField(trimmedPath, ((List)children).get(0));
    }

    private static String getLastPath(String path) {
        int lastIndexOfPathSepChar = path.lastIndexOf(47);
        if (lastIndexOfPathSepChar == -1) {
            return path;
        }
        return path.substring(lastIndexOfPathSepChar + 1);
    }

    private static String trimLastPoundIfArray(String path) {
        int indexOfSepChar = path.lastIndexOf(35);
        if (indexOfSepChar == -1) {
            return path;
        }
        int lastIndex = path.length() - 1;
        boolean singleDocVal = indexOfSepChar == lastIndex;
        return singleDocVal ? path : path.substring(0, indexOfSepChar);
    }

    private static String trimLastPound(String path) {
        int lastIndex = path.lastIndexOf(35);
        return lastIndex == -1 ? path : path.substring(0, lastIndex);
    }

    private static String getParentPath(String currDocPath) {
        int lastPathIndex = currDocPath.lastIndexOf(47);
        return lastPathIndex == -1 ? null : currDocPath.substring(0, lastPathIndex);
    }

    private String getPathByDocId(int segDocId, SortedDocValues segPathDocValues) throws IOException {
        int numToAdvance;
        if (!this.isNestedSchema) {
            return ANON_CHILD_KEY;
        }
        int n = numToAdvance = segPathDocValues.docID() == -1 ? segDocId : segDocId - segPathDocValues.docID();
        assert (numToAdvance >= 0);
        boolean advanced = segPathDocValues.advanceExact(segDocId);
        return advanced ? segPathDocValues.binaryValue().utf8ToString() : "";
    }
}

