/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.log4j;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;

public class BufferingAppender
extends WriterAppender {
    StringWriter writer = new StringWriter();

    private BufferingAppender(StringWriter w) {
        super((Layout)new SimpleLayout(), (Writer)w);
        this.writer = w;
        super.setImmediateFlush(true);
    }

    public BufferingAppender() {
        this(new StringWriter());
    }

    public static BufferingAppender attach(String loggerName) {
        BufferingAppender appender = new BufferingAppender();
        BufferingAppender.resolve(loggerName).addAppender((Appender)appender);
        return appender;
    }

    public static BufferingAppender attachToRootLogger() {
        return BufferingAppender.attach(null);
    }

    private static Logger resolve(String loggerName) {
        if (loggerName == null || loggerName.length() == 0) {
            return Logger.getRootLogger();
        }
        return Logger.getLogger((String)loggerName);
    }

    public static void detach(String loggerName, BufferingAppender appender) {
        BufferingAppender.resolve(loggerName).removeAppender((Appender)appender);
    }

    public static void detachFromRootLogger(BufferingAppender appender) {
        BufferingAppender.detach(null, appender);
    }

    public void clear() {
        this.writer.getBuffer().setLength(0);
    }

    public String getBuffer() {
        return this.writer.toString();
    }
}

