/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryUtils;
import org.apache.lucene.search.spans.AssertingSpanQuery;
import org.apache.lucene.search.spans.SpanContainingQuery;
import org.apache.lucene.search.spans.SpanFirstQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanNotQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanPositionRangeQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.SpanWithinQuery;
import org.apache.lucene.search.spans.Spans;
import org.junit.Assert;

public class SpanTestUtil {
    public static SpanQuery spanQuery(SpanQuery query) {
        QueryUtils.check((Query)query);
        return new AssertingSpanQuery(query);
    }

    public static SpanQuery spanTermQuery(String field, String term) {
        return SpanTestUtil.spanQuery((SpanQuery)new SpanTermQuery(new Term(field, term)));
    }

    public static SpanQuery spanOrQuery(String field, String ... terms) {
        SpanQuery[] subqueries = new SpanQuery[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            subqueries[i] = SpanTestUtil.spanTermQuery(field, terms[i]);
        }
        return SpanTestUtil.spanOrQuery(subqueries);
    }

    public static SpanQuery spanOrQuery(SpanQuery ... subqueries) {
        return SpanTestUtil.spanQuery((SpanQuery)new SpanOrQuery(subqueries));
    }

    public static SpanQuery spanNotQuery(SpanQuery include, SpanQuery exclude) {
        return SpanTestUtil.spanQuery((SpanQuery)new SpanNotQuery(include, exclude));
    }

    public static SpanQuery spanNotQuery(SpanQuery include, SpanQuery exclude, int pre, int post) {
        return SpanTestUtil.spanQuery((SpanQuery)new SpanNotQuery(include, exclude, pre, post));
    }

    public static SpanQuery spanFirstQuery(SpanQuery query, int end) {
        return SpanTestUtil.spanQuery((SpanQuery)new SpanFirstQuery(query, end));
    }

    public static SpanQuery spanPositionRangeQuery(SpanQuery query, int start, int end) {
        return SpanTestUtil.spanQuery((SpanQuery)new SpanPositionRangeQuery(query, start, end));
    }

    public static SpanQuery spanContainingQuery(SpanQuery big, SpanQuery little) {
        return SpanTestUtil.spanQuery((SpanQuery)new SpanContainingQuery(big, little));
    }

    public static SpanQuery spanWithinQuery(SpanQuery big, SpanQuery little) {
        return SpanTestUtil.spanQuery((SpanQuery)new SpanWithinQuery(big, little));
    }

    public static SpanQuery spanNearOrderedQuery(String field, int slop, String ... terms) {
        SpanQuery[] subqueries = new SpanQuery[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            subqueries[i] = SpanTestUtil.spanTermQuery(field, terms[i]);
        }
        return SpanTestUtil.spanNearOrderedQuery(slop, subqueries);
    }

    public static SpanQuery spanNearOrderedQuery(int slop, SpanQuery ... subqueries) {
        return SpanTestUtil.spanQuery((SpanQuery)new SpanNearQuery(subqueries, slop, true));
    }

    public static SpanQuery spanNearUnorderedQuery(String field, int slop, String ... terms) {
        SpanNearQuery.Builder builder = SpanNearQuery.newUnorderedNearQuery((String)field);
        builder.setSlop(slop);
        for (String term : terms) {
            builder.addClause((SpanQuery)new SpanTermQuery(new Term(field, term)));
        }
        return SpanTestUtil.spanQuery((SpanQuery)builder.build());
    }

    public static SpanQuery spanNearUnorderedQuery(int slop, SpanQuery ... subqueries) {
        return SpanTestUtil.spanQuery((SpanQuery)new SpanNearQuery(subqueries, slop, false));
    }

    public static void assertNext(Spans spans, int doc, int start, int end) throws IOException {
        if (spans.docID() >= doc) {
            Assert.assertEquals((String)"docId", (long)doc, (long)spans.docID());
        } else {
            if (spans.docID() >= 0) {
                Assert.assertEquals((String)"nextStartPosition of previous doc", (long)Integer.MAX_VALUE, (long)spans.nextStartPosition());
                Assert.assertEquals((String)"endPosition of previous doc", (long)Integer.MAX_VALUE, (long)spans.endPosition());
            }
            Assert.assertEquals((String)"nextDoc", (long)doc, (long)spans.nextDoc());
            if (doc != Integer.MAX_VALUE) {
                Assert.assertEquals((String)"first startPosition", (long)-1L, (long)spans.startPosition());
                Assert.assertEquals((String)"first endPosition", (long)-1L, (long)spans.endPosition());
            }
        }
        if (doc != Integer.MAX_VALUE) {
            Assert.assertEquals((String)"nextStartPosition", (long)start, (long)spans.nextStartPosition());
            Assert.assertEquals((String)"startPosition", (long)start, (long)spans.startPosition());
            Assert.assertEquals((String)"endPosition", (long)end, (long)spans.endPosition());
        }
    }

    public static void assertFinished(Spans spans) throws Exception {
        if (spans != null) {
            SpanTestUtil.assertNext(spans, Integer.MAX_VALUE, -2, -2);
        }
    }
}

