/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.DMLWriteResultSet;
import org.apache.derby.impl.sql.execute.DeleteConstantAction;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.RISetChecker;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.impl.sql.execute.TriggerEventActivator;
import org.apache.derby.impl.sql.execute.TriggerEvents;
import org.apache.derby.impl.sql.execute.TriggerInfo;

class DeleteResultSet
extends DMLWriteResultSet {
    private TransactionController tc;
    DeleteConstantAction constants;
    protected ResultDescription resultDescription;
    protected NoPutResultSet source;
    NoPutResultSet savedSource;
    int numIndexes;
    protected RowChanger rc;
    private ExecRow row;
    protected ConglomerateController deferredBaseCC;
    protected TemporaryRowHolderImpl rowHolder;
    private int numOpens;
    private boolean firstExecute;
    private FormatableBitSet baseRowReadList;
    private int rlColumnNumber;
    protected FKInfo[] fkInfoArray;
    private TriggerInfo triggerInfo;
    private RISetChecker fkChecker;
    private TriggerEventActivator triggerActivator;
    private boolean noTriggersOrFks;
    ExecRow deferredSparseRow;
    ExecRow deferredBaseRow;
    int lockMode;
    protected boolean cascadeDelete;
    ExecRow deferredRLRow = null;
    int numberOfBaseColumns = 0;

    public ResultDescription getResultDescription() {
        return this.resultDescription;
    }

    DeleteResultSet(NoPutResultSet noPutResultSet, Activation activation) throws StandardException {
        this(noPutResultSet, activation.getConstantAction(), activation);
    }

    DeleteResultSet(NoPutResultSet noPutResultSet, ConstantAction constantAction, Activation activation) throws StandardException {
        super(activation, constantAction);
        this.source = noPutResultSet;
        this.tc = activation.getTransactionController();
        this.constants = (DeleteConstantAction)this.constantAction;
        this.fkInfoArray = this.constants.getFKInfo();
        this.triggerInfo = this.constants.getTriggerInfo();
        this.noTriggersOrFks = this.fkInfoArray == null && this.triggerInfo == null;
        this.baseRowReadList = this.constants.getBaseRowReadList();
        this.resultDescription = noPutResultSet != null ? noPutResultSet.getResultDescription() : this.constants.resultDescription;
    }

    public void open() throws StandardException {
        this.setup();
        boolean bl = this.collectAffectedRows();
        if (!bl) {
            this.activation.addWarning(StandardException.newWarning("02000"));
        }
        if (this.constants.deferred) {
            this.runFkChecker(true);
            this.fireBeforeTriggers();
            this.deleteDeferredRows();
            this.runFkChecker(false);
            this.rc.finish();
            this.fireAfterTriggers();
        }
        if (this.lcc.getRunTimeStatisticsMode()) {
            this.savedSource = this.source;
        }
        this.cleanUp();
        this.endTime = this.getCurrentTimeMillis();
    }

    void setup() throws StandardException {
        super.setup();
        this.firstExecute = this.rc == null;
        try {
            if (this.numOpens++ == 0) {
                this.source.openCore();
            } else {
                this.source.reopenCore();
            }
        }
        catch (StandardException standardException) {
            this.activation.checkStatementValidity();
            throw standardException;
        }
        this.activation.checkStatementValidity();
        if (this.firstExecute) {
            this.rc = this.lcc.getLanguageConnectionFactory().getExecutionFactory().getRowChanger(this.constants.conglomId, this.constants.heapSCOCI, this.heapDCOCI, this.constants.irgs, this.constants.indexCIDS, this.constants.indexSCOCIs, this.indexDCOCIs, this.constants.numColumns, this.tc, null, this.baseRowReadList, this.constants.getBaseRowReadMap(), this.constants.getStreamStorableHeapColIds(), this.activation);
        }
        this.lockMode = this.decodeLockMode(this.constants.lockMode);
        this.rc.open(this.lockMode);
        if (this.constants.deferred || this.cascadeDelete) {
            this.activation.clearIndexScanInfo();
        }
        this.rowCount = 0;
        if (!this.cascadeDelete) {
            this.row = this.getNextRowCore(this.source);
        }
        this.numberOfBaseColumns = this.resultDescription == null ? (this.row == null ? 0 : this.row.nColumns()) : this.resultDescription.getColumnCount();
        this.numIndexes = this.constants.irgs.length;
        if (this.constants.deferred || this.cascadeDelete) {
            Properties properties = new Properties();
            this.rc.getHeapConglomerateController().getInternalTablePropertySet(properties);
            this.deferredRLRow = RowUtil.getEmptyValueRow(1, this.lcc);
            int n = this.rlColumnNumber = this.noTriggersOrFks ? 1 : this.numberOfBaseColumns;
            this.rowHolder = this.cascadeDelete ? new TemporaryRowHolderImpl(this.activation, properties, this.resultDescription != null ? this.resultDescription.truncateColumns(this.rlColumnNumber) : null, false) : new TemporaryRowHolderImpl(this.activation, properties, this.resultDescription != null ? this.resultDescription.truncateColumns(this.rlColumnNumber) : null);
            this.rc.setRowHolder(this.rowHolder);
        }
        if (this.fkInfoArray != null) {
            if (this.fkChecker == null) {
                this.fkChecker = new RISetChecker(this.tc, this.fkInfoArray);
            } else {
                this.fkChecker.reopen();
            }
        }
    }

    boolean collectAffectedRows() throws StandardException {
        boolean bl = false;
        if (this.cascadeDelete) {
            this.row = this.getNextRowCore(this.source);
        }
        while (this.row != null) {
            bl = true;
            DataValueDescriptor dataValueDescriptor = this.row.getColumn(this.row.nColumns());
            if (this.constants.deferred || this.cascadeDelete) {
                if (this.noTriggersOrFks) {
                    this.deferredRLRow.setColumn(1, dataValueDescriptor);
                    this.rowHolder.insert(this.deferredRLRow);
                } else {
                    this.rowHolder.insert(this.row);
                }
                if (this.deferredBaseRow == null) {
                    this.deferredBaseRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns - 1, this.lcc);
                    RowUtil.copyCloneColumns(this.deferredBaseRow, this.row, this.numberOfBaseColumns - 1);
                    this.deferredSparseRow = this.makeDeferredSparseRow(this.deferredBaseRow, this.baseRowReadList, this.lcc);
                }
            } else {
                if (this.fkChecker != null) {
                    this.fkChecker.doPKCheck(this.row, false);
                }
                RowLocation rowLocation = (RowLocation)dataValueDescriptor.getObject();
                this.rc.deleteRow(this.row, rowLocation);
                this.source.markRowAsDeleted();
            }
            ++this.rowCount;
            if (this.constants.singleRowSource) {
                this.row = null;
                continue;
            }
            this.row = this.getNextRowCore(this.source);
        }
        return bl;
    }

    void fireBeforeTriggers() throws StandardException {
        if (this.triggerInfo != null) {
            if (this.triggerActivator == null) {
                this.triggerActivator = new TriggerEventActivator(this.lcc, this.tc, this.constants.targetUUID, this.triggerInfo, 2, this.activation, null);
            } else {
                this.triggerActivator.reopen();
            }
            this.triggerActivator.notifyEvent(TriggerEvents.BEFORE_DELETE, this.rowHolder.getResultSet(), null, this.constants.getBaseRowReadMap());
            this.triggerActivator.cleanup();
        }
    }

    void fireAfterTriggers() throws StandardException {
        if (this.triggerActivator != null) {
            this.triggerActivator.reopen();
            this.triggerActivator.notifyEvent(TriggerEvents.AFTER_DELETE, this.rowHolder.getResultSet(), null, this.constants.getBaseRowReadMap());
            this.triggerActivator.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteDeferredRows() throws StandardException {
        ExecRow execRow = null;
        this.deferredBaseCC = this.tc.openCompiledConglomerate(false, 4 | 0x2000, this.lockMode, 5, this.constants.heapSCOCI, this.heapDCOCI);
        CursorResultSet cursorResultSet = this.rowHolder.getResultSet();
        try {
            FormatableBitSet formatableBitSet = RowUtil.shift(this.baseRowReadList, 1);
            cursorResultSet.open();
            while ((execRow = cursorResultSet.getNextRow()) != null) {
                DataValueDescriptor dataValueDescriptor = execRow.getColumn(this.rlColumnNumber);
                RowLocation rowLocation = (RowLocation)dataValueDescriptor.getObject();
                boolean bl = this.deferredBaseCC.fetch(rowLocation, this.deferredSparseRow.getRowArray(), formatableBitSet);
                if (this.cascadeDelete && !bl) continue;
                this.rc.deleteRow(this.deferredBaseRow, rowLocation);
                this.source.markRowAsDeleted();
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            cursorResultSet.close();
            throw throwable;
        }
        cursorResultSet.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runFkChecker(boolean bl) throws StandardException {
        ExecRow execRow = null;
        if (this.fkChecker != null) {
            CursorResultSet cursorResultSet = this.rowHolder.getResultSet();
            try {
                cursorResultSet.open();
                while ((execRow = cursorResultSet.getNextRow()) != null) {
                    this.fkChecker.doPKCheck(execRow, bl);
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                cursorResultSet.close();
                throw throwable;
            }
            cursorResultSet.close();
            {
            }
        }
    }

    NoPutResultSet createDependentSource(RowChanger rowChanger) throws StandardException {
        return null;
    }

    public void cleanUp() throws StandardException {
        this.numOpens = 0;
        if (this.source != null) {
            this.source.close();
        }
        if (this.rc != null) {
            this.rc.close();
        }
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
        if (this.fkChecker != null) {
            this.fkChecker.close();
        }
        if (this.deferredBaseCC != null) {
            this.deferredBaseCC.close();
        }
        this.deferredBaseCC = null;
        if (this.rc != null) {
            this.rc.close();
        }
        super.close();
    }

    public void finish() throws StandardException {
        if (this.source != null) {
            this.source.finish();
        }
        super.finish();
    }
}

