/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mov.atoms;

import com.drew.lang.SequentialReader;
import com.drew.metadata.mov.QuickTimeContext;
import com.drew.metadata.mov.atoms.Atom;
import com.drew.metadata.mov.atoms.FullAtom;
import com.drew.metadata.mov.media.QuickTimeVideoDirectory;
import java.io.IOException;
import java.util.ArrayList;

public class TimeToSampleAtom
extends FullAtom {
    long numberOfEntries;
    ArrayList<Entry> entries;

    public TimeToSampleAtom(SequentialReader reader, Atom atom) throws IOException {
        super(reader, atom);
        this.numberOfEntries = reader.getUInt32();
        this.entries = new ArrayList();
        int i = 0;
        while ((long)i < this.numberOfEntries) {
            this.entries.add(new Entry(reader));
            ++i;
        }
    }

    public void addMetadata(QuickTimeVideoDirectory directory, QuickTimeContext context) {
        float frameRate = (float)context.timeScale.longValue() / (float)this.entries.get((int)0).sampleDuration;
        directory.setFloat(14, frameRate);
    }

    static class Entry {
        long sampleCount;
        long sampleDuration;

        public Entry(SequentialReader reader) throws IOException {
            this.sampleCount = reader.getUInt32();
            this.sampleDuration = reader.getUInt32();
        }
    }
}

