/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.wordperfect;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;

class WPInputStream
extends InputStream {
    private final DataInputStream in;

    public WPInputStream(InputStream in) {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        this.in = new DataInputStream(in);
    }

    public int readWPShort() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (ch2 << 8) + (ch1 << 0);
    }

    public long readWPLong() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read()) | (ch3 = this.in.read()) | (ch4 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    public byte readWPByte() throws IOException {
        return this.in.readByte();
    }

    public void skipWPByte(int numOfBytes) throws IOException {
        for (int i = 0; i < numOfBytes; ++i) {
            this.readWPByte();
        }
    }

    public char readWPChar() throws IOException {
        int c = this.in.read();
        if (c == -1) {
            throw new EOFException();
        }
        return (char)c;
    }

    public String readWPString(int length) throws IOException {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            int c = this.in.read();
            if (c == -1) {
                throw new EOFException();
            }
            chars[i] = (char)c;
        }
        return new String(chars);
    }

    public String readWPHexString(int numOfBytes) throws IOException {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < numOfBytes; ++i) {
            b.append(this.readWPHex());
        }
        return b.toString();
    }

    public String readWPHex() throws IOException {
        return StringUtils.leftPad((String)Integer.toString(this.readWP(), 16), (int)2, (char)'0');
    }

    public int readWP() throws IOException {
        int i = this.read();
        if (i == -1) {
            throw new EOFException();
        }
        return i;
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }
}

