/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Alpha;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransformInterpolator;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnElapsedFrames;

public class RotationInterpolator
extends TransformInterpolator {
    float minimumAngle;
    float maximumAngle;
    private Transform3D rotation = new Transform3D();
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    RotationInterpolator() {
    }

    public RotationInterpolator(Alpha alpha, TransformGroup transformGroup) {
        super(alpha, transformGroup);
        this.minimumAngle = 0.0f;
        this.maximumAngle = (float)Math.PI * 2;
    }

    public RotationInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, float f, float f2) {
        super(alpha, transformGroup, transform3D);
        this.minimumAngle = f;
        this.maximumAngle = f2;
    }

    public void setMinimumAngle(float f) {
        this.minimumAngle = f;
    }

    public float getMinimumAngle() {
        return this.minimumAngle;
    }

    public void setMaximumAngle(float f) {
        this.maximumAngle = f;
    }

    public float getMaximumAngle() {
        return this.maximumAngle;
    }

    public void setAxisOfRotation(Transform3D transform3D) {
        this.setTransformAxis(transform3D);
    }

    public Transform3D getAxisOfRotation() {
        return this.getTransformAxis();
    }

    @Override
    public void computeTransform(float f, Transform3D transform3D) {
        double d = (1.0 - (double)f) * (double)this.minimumAngle + (double)(f * this.maximumAngle);
        this.rotation.rotY(d);
        transform3D.mul(this.axis, this.rotation);
        transform3D.mul(transform3D, this.axisInverse);
    }

    @Override
    public Node cloneNode(boolean bl) {
        RotationInterpolator rotationInterpolator = new RotationInterpolator();
        rotationInterpolator.duplicateNode(this, bl);
        return rotationInterpolator;
    }

    @Override
    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        RotationInterpolator rotationInterpolator = (RotationInterpolator)node;
        this.setMinimumAngle(rotationInterpolator.getMinimumAngle());
        this.setMaximumAngle(rotationInterpolator.getMaximumAngle());
    }
}

