// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from AT91SAM9M10.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

// +build sam,at91sam9m10

// Atmel AT91SAM9M10 device: ARM926EJ Embedded Microprocessor Unit, 400MHz, DDR2/LPDDR, Video Decoder, LCD, HS USB, 10/100 Ethernet, Dual EBI, 324 Pins (refer to http://www.atmel.com/devices/SAM9M10.aspx for more)
//

package sam

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "AT91SAM9M10"
)

// Interrupt numbers.
const (
	IRQ_FIQ    = 0  // Advanced Interrupt Controller
	IRQ_PIOA   = 2  // Parallel Input/Output Controller A
	IRQ_PIOB   = 3  // Parallel Input/Output Controller B
	IRQ_PIOC   = 4  // Parallel Input/Output Controller C
	IRQ_PIOD   = 5  // Parallel Input/Output Controller D
	IRQ_TRNG   = 6  // True Random Number Generator
	IRQ_USART0 = 7  // Universal Synchronous Asynchronous Receiver Transmitter 0
	IRQ_USART1 = 8  // Universal Synchronous Asynchronous Receiver Transmitter 1
	IRQ_USART2 = 9  // Universal Synchronous Asynchronous Receiver Transmitter 2
	IRQ_USART3 = 10 // Universal Synchronous Asynchronous Receiver Transmitter 3
	IRQ_HSMCI0 = 11 // High Speed MultiMedia Card Interface 0
	IRQ_TWI0   = 12 // Two-wire Interface 0
	IRQ_TWI1   = 13 // Two-wire Interface 1
	IRQ_SPI0   = 14 // Serial Peripheral Interface 0
	IRQ_SPI1   = 15 // Serial Peripheral Interface 1
	IRQ_SSC0   = 16 // Synchronous Serial Controller 0
	IRQ_SSC1   = 17 // Synchronous Serial Controller 1
	IRQ_TC0    = 18 // Timer Counter 0
	IRQ_PWM    = 19 // Pulse Width Modulation Controller
	IRQ_TSADCC = 20 // Touch Screen ADC Controller
	IRQ_DMAC   = 21 // DMA Controller
	IRQ_LCDC   = 23 // LCD Controller
	IRQ_AC97C  = 24 // AC97 Controller
	IRQ_EMAC   = 25 // Ethernet MAC 10/100
	IRQ_ISI    = 26 // Image Sensor Interface
	IRQ_UDPHS  = 27 // USB High Speed Device Port
	IRQ_HSMCI1 = 29 // High Speed MultiMedia Card Interface 1
	IRQ_VDEC   = 30 // Video Decoder
	IRQ_IRQ    = 31 // Advanced Interrupt Controller
	IRQ_max    = 31 // Highest interrupt number on this device.
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_FIQ, "FIQ_IRQHandler")
	_ = interrupt.Register(IRQ_PIOA, "PIOA_IRQHandler")
	_ = interrupt.Register(IRQ_PIOB, "PIOB_IRQHandler")
	_ = interrupt.Register(IRQ_PIOC, "PIOC_IRQHandler")
	_ = interrupt.Register(IRQ_PIOD, "PIOD_IRQHandler")
	_ = interrupt.Register(IRQ_TRNG, "TRNG_IRQHandler")
	_ = interrupt.Register(IRQ_USART0, "USART0_IRQHandler")
	_ = interrupt.Register(IRQ_USART1, "USART1_IRQHandler")
	_ = interrupt.Register(IRQ_USART2, "USART2_IRQHandler")
	_ = interrupt.Register(IRQ_USART3, "USART3_IRQHandler")
	_ = interrupt.Register(IRQ_HSMCI0, "HSMCI0_IRQHandler")
	_ = interrupt.Register(IRQ_TWI0, "TWI0_IRQHandler")
	_ = interrupt.Register(IRQ_TWI1, "TWI1_IRQHandler")
	_ = interrupt.Register(IRQ_SPI0, "SPI0_IRQHandler")
	_ = interrupt.Register(IRQ_SPI1, "SPI1_IRQHandler")
	_ = interrupt.Register(IRQ_SSC0, "SSC0_IRQHandler")
	_ = interrupt.Register(IRQ_SSC1, "SSC1_IRQHandler")
	_ = interrupt.Register(IRQ_TC0, "TC0_IRQHandler")
	_ = interrupt.Register(IRQ_PWM, "PWM_IRQHandler")
	_ = interrupt.Register(IRQ_TSADCC, "TSADCC_IRQHandler")
	_ = interrupt.Register(IRQ_DMAC, "DMAC_IRQHandler")
	_ = interrupt.Register(IRQ_LCDC, "LCDC_IRQHandler")
	_ = interrupt.Register(IRQ_AC97C, "AC97C_IRQHandler")
	_ = interrupt.Register(IRQ_EMAC, "EMAC_IRQHandler")
	_ = interrupt.Register(IRQ_ISI, "ISI_IRQHandler")
	_ = interrupt.Register(IRQ_UDPHS, "UDPHS_IRQHandler")
	_ = interrupt.Register(IRQ_HSMCI1, "HSMCI1_IRQHandler")
	_ = interrupt.Register(IRQ_VDEC, "VDEC_IRQHandler")
	_ = interrupt.Register(IRQ_IRQ, "IRQ_IRQHandler")
)

// Peripherals.
var (
	LCDC     = (*LCDC_Type)(unsafe.Pointer(uintptr(0x500000)))      // LCD Controller
	VDEC     = (*VDEC_Type)(unsafe.Pointer(uintptr(0x900000)))      // Video Decoder
	UDPHS    = (*UDPHS_Type)(unsafe.Pointer(uintptr(0xfff78000)))   // USB High Speed Device Port
	TC0      = (*TC_Type)(unsafe.Pointer(uintptr(0xfff7c000)))      // Timer Counter 0
	HSMCI0   = (*HSMCI_Type)(unsafe.Pointer(uintptr(0xfff80000)))   // High Speed MultiMedia Card Interface 0
	TWI0     = (*TWI_Type)(unsafe.Pointer(uintptr(0xfff84000)))     // Two-wire Interface 0
	TWI1     = (*TWI_Type)(unsafe.Pointer(uintptr(0xfff88000)))     // Two-wire Interface 1
	USART0   = (*USART_Type)(unsafe.Pointer(uintptr(0xfff8c000)))   // Universal Synchronous Asynchronous Receiver Transmitter 0
	USART1   = (*USART_Type)(unsafe.Pointer(uintptr(0xfff90000)))   // Universal Synchronous Asynchronous Receiver Transmitter 1
	USART2   = (*USART_Type)(unsafe.Pointer(uintptr(0xfff94000)))   // Universal Synchronous Asynchronous Receiver Transmitter 2
	USART3   = (*USART_Type)(unsafe.Pointer(uintptr(0xfff98000)))   // Universal Synchronous Asynchronous Receiver Transmitter 3
	SSC0     = (*SSC_Type)(unsafe.Pointer(uintptr(0xfff9c000)))     // Synchronous Serial Controller 0
	SSC1     = (*SSC_Type)(unsafe.Pointer(uintptr(0xfffa0000)))     // Synchronous Serial Controller 1
	SPI0     = (*SPI_Type)(unsafe.Pointer(uintptr(0xfffa4000)))     // Serial Peripheral Interface 0
	SPI1     = (*SPI_Type)(unsafe.Pointer(uintptr(0xfffa8000)))     // Serial Peripheral Interface 1
	AC97C    = (*AC97C_Type)(unsafe.Pointer(uintptr(0xfffac000)))   // AC97 Controller
	TSADCC   = (*TSADCC_Type)(unsafe.Pointer(uintptr(0xfffb0000)))  // Touch Screen ADC Controller
	ISI      = (*ISI_Type)(unsafe.Pointer(uintptr(0xfffb4000)))     // Image Sensor Interface
	PWM      = (*PWM_Type)(unsafe.Pointer(uintptr(0xfffb8000)))     // Pulse Width Modulation Controller
	EMAC     = (*EMAC_Type)(unsafe.Pointer(uintptr(0xfffbc000)))    // Ethernet MAC 10/100
	TRNG     = (*TRNG_Type)(unsafe.Pointer(uintptr(0xfffcc000)))    // True Random Number Generator
	HSMCI1   = (*HSMCI_Type)(unsafe.Pointer(uintptr(0xfffd0000)))   // High Speed MultiMedia Card Interface 1
	TC1      = (*TC_Type)(unsafe.Pointer(uintptr(0xfffd4000)))      // Timer Counter 1
	DDRSDRC1 = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffe400)))     // DDR_SDR SDRAM Controller 1
	DDRSDRC0 = (*DDRSDRC_Type)(unsafe.Pointer(uintptr(0xffffe600))) // DDR_SDR SDRAM Controller 0
	SMC      = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffe800)))     // Static Memory Controller
	MATRIX   = (*MATRIX_Type)(unsafe.Pointer(uintptr(0xffffea00)))  // AHB Bus Matrix
	DMAC     = (*DMAC_Type)(unsafe.Pointer(uintptr(0xffffec00)))    // DMA Controller
	DBGU     = (*DBGU_Type)(unsafe.Pointer(uintptr(0xffffee00)))    // Debug Unit
	AIC      = (*AIC_Type)(unsafe.Pointer(uintptr(0xfffff000)))     // Advanced Interrupt Controller
	PIOA     = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff200)))     // Parallel Input/Output Controller A
	PIOB     = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff400)))     // Parallel Input/Output Controller B
	PIOC     = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff600)))     // Parallel Input/Output Controller C
	PIOD     = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff800)))     // Parallel Input/Output Controller D
	PIOE     = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffffa00)))     // Parallel Input/Output Controller E
	PMC      = (*PMC_Type)(unsafe.Pointer(uintptr(0xfffffc00)))     // Power Management Controller
	RSTC     = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd00)))    // Reset Controller
	SHDWC    = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd10)))    // Shutdown Controller
	RTT      = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd20)))    // Real-time Timer
	PIT      = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd30)))    // Periodic Interval Timer
	WDT      = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd40)))    // Watchdog Timer
	GPBR     = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd60)))    // General Purpose Backup Register
	RTC      = (*RTC_Type)(unsafe.Pointer(uintptr(0xfffffdb0)))     // Real-time Clock
)

// LCD Controller
type LCDC_Type struct {
	DMABADDR1    volatile.Register32 // 0x0
	DMABADDR2    volatile.Register32 // 0x4
	DMAFRMPT1    volatile.Register32 // 0x8
	DMAFRMPT2    volatile.Register32 // 0xC
	DMAFRMADD1   volatile.Register32 // 0x10
	DMAFRMADD2   volatile.Register32 // 0x14
	DMAFRMCFG    volatile.Register32 // 0x18
	DMACON       volatile.Register32 // 0x1C
	DMA2DCFG     volatile.Register32 // 0x20
	_            [2012]byte
	LCDCON1      volatile.Register32 // 0x800
	LCDCON2      volatile.Register32 // 0x804
	LCDTIM1      volatile.Register32 // 0x808
	LCDTIM2      volatile.Register32 // 0x80C
	LCDFRMCFG    volatile.Register32 // 0x810
	LCDFIFO      volatile.Register32 // 0x814
	_            [4]byte
	DP1_2        volatile.Register32 // 0x81C
	DP4_7        volatile.Register32 // 0x820
	DP3_5        volatile.Register32 // 0x824
	DP2_3        volatile.Register32 // 0x828
	DP5_7        volatile.Register32 // 0x82C
	DP3_4        volatile.Register32 // 0x830
	DP4_5        volatile.Register32 // 0x834
	DP6_7        volatile.Register32 // 0x838
	PWRCON       volatile.Register32 // 0x83C
	CONTRAST_CTR volatile.Register32 // 0x840
	CONTRAST_VAL volatile.Register32 // 0x844
	LCD_IER      volatile.Register32 // 0x848
	LCD_IDR      volatile.Register32 // 0x84C
	LCD_IMR      volatile.Register32 // 0x850
	LCD_ISR      volatile.Register32 // 0x854
	LCD_ICR      volatile.Register32 // 0x858
	_            [4]byte
	LCD_ITR      volatile.Register32 // 0x860
	LCD_IRR      volatile.Register32 // 0x864
	_            [124]byte
	LCD_WPCR     volatile.Register32 // 0x8E4
	LCD_WPSR     volatile.Register32 // 0x8E8
	_            [788]byte
	LUTENTRY     [256]volatile.Register32 // 0xC00
}

// Video Decoder
type VDEC_Type struct {
	IDR      volatile.Register32     // 0x0
	DIR      volatile.Register32     // 0x4
	DDCR     volatile.Register32     // 0x8
	CTLR0    volatile.Register32     // 0xC
	CTLR1    volatile.Register32     // 0x10
	CTLR2    volatile.Register32     // 0x14
	CTLR3    volatile.Register32     // 0x18
	CTLR4    volatile.Register32     // 0x1C
	CTLR5    volatile.Register32     // 0x20
	CTLR6    volatile.Register32     // 0x24
	DMVBA    volatile.Register32     // 0x28
	CTLR7    volatile.Register32     // 0x2C
	RLCVLCBA volatile.Register32     // 0x30
	PICTBA   volatile.Register32     // 0x34
	PIDXBA   [16]volatile.Register32 // 0x38
	PNR0     volatile.Register32     // 0x78
	PNR1     volatile.Register32     // 0x7C
	PNR2     volatile.Register32     // 0x80
	PNR3     volatile.Register32     // 0x84
	PNR4     volatile.Register32     // 0x88
	PNR5     volatile.Register32     // 0x8C
	PNR6     volatile.Register32     // 0x90
	PNR7     volatile.Register32     // 0x94
	PLTFR    volatile.Register32     // 0x98
	PVFR     volatile.Register32     // 0x9C
	SDTBA    volatile.Register32     // 0xA0
	DMMVBA   volatile.Register32     // 0xA4
	IRPLR0   volatile.Register32     // 0xA8
	IRPLR1   volatile.Register32     // 0xAC
	IRPLR2   volatile.Register32     // 0xB0
	IRPLR3   volatile.Register32     // 0xB4
	IRPLR4   volatile.Register32     // 0xB8
	IRPLR5   volatile.Register32     // 0xBC
	ECR      volatile.Register32     // 0xC0
}

// USB High Speed Device Port
type UDPHS_Type struct {
	CTRL        volatile.Register32 // 0x0
	FNUM        volatile.Register32 // 0x4
	_           [8]byte
	IEN         volatile.Register32 // 0x10
	INTSTA      volatile.Register32 // 0x14
	CLRINT      volatile.Register32 // 0x18
	EPTRST      volatile.Register32 // 0x1C
	_           [192]byte
	TST         volatile.Register32 // 0xE0
	_           [28]byte
	EPTCFG0     volatile.Register32 // 0x100
	EPTCTLENB0  volatile.Register32 // 0x104
	EPTCTLDIS0  volatile.Register32 // 0x108
	EPTCTL0     volatile.Register32 // 0x10C
	_           [4]byte
	EPTSETSTA0  volatile.Register32 // 0x114
	EPTCLRSTA0  volatile.Register32 // 0x118
	EPTSTA0     volatile.Register32 // 0x11C
	EPTCFG1     volatile.Register32 // 0x120
	EPTCTLENB1  volatile.Register32 // 0x124
	EPTCTLDIS1  volatile.Register32 // 0x128
	EPTCTL1     volatile.Register32 // 0x12C
	_           [4]byte
	EPTSETSTA1  volatile.Register32 // 0x134
	EPTCLRSTA1  volatile.Register32 // 0x138
	EPTSTA1     volatile.Register32 // 0x13C
	EPTCFG2     volatile.Register32 // 0x140
	EPTCTLENB2  volatile.Register32 // 0x144
	EPTCTLDIS2  volatile.Register32 // 0x148
	EPTCTL2     volatile.Register32 // 0x14C
	_           [4]byte
	EPTSETSTA2  volatile.Register32 // 0x154
	EPTCLRSTA2  volatile.Register32 // 0x158
	EPTSTA2     volatile.Register32 // 0x15C
	EPTCFG3     volatile.Register32 // 0x160
	EPTCTLENB3  volatile.Register32 // 0x164
	EPTCTLDIS3  volatile.Register32 // 0x168
	EPTCTL3     volatile.Register32 // 0x16C
	_           [4]byte
	EPTSETSTA3  volatile.Register32 // 0x174
	EPTCLRSTA3  volatile.Register32 // 0x178
	EPTSTA3     volatile.Register32 // 0x17C
	EPTCFG4     volatile.Register32 // 0x180
	EPTCTLENB4  volatile.Register32 // 0x184
	EPTCTLDIS4  volatile.Register32 // 0x188
	EPTCTL4     volatile.Register32 // 0x18C
	_           [4]byte
	EPTSETSTA4  volatile.Register32 // 0x194
	EPTCLRSTA4  volatile.Register32 // 0x198
	EPTSTA4     volatile.Register32 // 0x19C
	EPTCFG5     volatile.Register32 // 0x1A0
	EPTCTLENB5  volatile.Register32 // 0x1A4
	EPTCTLDIS5  volatile.Register32 // 0x1A8
	EPTCTL5     volatile.Register32 // 0x1AC
	_           [4]byte
	EPTSETSTA5  volatile.Register32 // 0x1B4
	EPTCLRSTA5  volatile.Register32 // 0x1B8
	EPTSTA5     volatile.Register32 // 0x1BC
	EPTCFG6     volatile.Register32 // 0x1C0
	EPTCTLENB6  volatile.Register32 // 0x1C4
	EPTCTLDIS6  volatile.Register32 // 0x1C8
	EPTCTL6     volatile.Register32 // 0x1CC
	_           [4]byte
	EPTSETSTA6  volatile.Register32 // 0x1D4
	EPTCLRSTA6  volatile.Register32 // 0x1D8
	EPTSTA6     volatile.Register32 // 0x1DC
	_           [288]byte
	DMANXTDSC0  volatile.Register32 // 0x300
	DMAADDRESS0 volatile.Register32 // 0x304
	DMACONTROL0 volatile.Register32 // 0x308
	DMASTATUS0  volatile.Register32 // 0x30C
	DMANXTDSC1  volatile.Register32 // 0x310
	DMAADDRESS1 volatile.Register32 // 0x314
	DMACONTROL1 volatile.Register32 // 0x318
	DMASTATUS1  volatile.Register32 // 0x31C
	DMANXTDSC2  volatile.Register32 // 0x320
	DMAADDRESS2 volatile.Register32 // 0x324
	DMACONTROL2 volatile.Register32 // 0x328
	DMASTATUS2  volatile.Register32 // 0x32C
	DMANXTDSC3  volatile.Register32 // 0x330
	DMAADDRESS3 volatile.Register32 // 0x334
	DMACONTROL3 volatile.Register32 // 0x338
	DMASTATUS3  volatile.Register32 // 0x33C
	DMANXTDSC4  volatile.Register32 // 0x340
	DMAADDRESS4 volatile.Register32 // 0x344
	DMACONTROL4 volatile.Register32 // 0x348
	DMASTATUS4  volatile.Register32 // 0x34C
	DMANXTDSC5  volatile.Register32 // 0x350
	DMAADDRESS5 volatile.Register32 // 0x354
	DMACONTROL5 volatile.Register32 // 0x358
	DMASTATUS5  volatile.Register32 // 0x35C
}

// Timer Counter 0
type TC_Type struct {
	CCR0 volatile.Register32 // 0x0
	CMR0 volatile.Register32 // 0x4
	_    [8]byte
	CV0  volatile.Register32 // 0x10
	RA0  volatile.Register32 // 0x14
	RB0  volatile.Register32 // 0x18
	RC0  volatile.Register32 // 0x1C
	SR0  volatile.Register32 // 0x20
	IER0 volatile.Register32 // 0x24
	IDR0 volatile.Register32 // 0x28
	IMR0 volatile.Register32 // 0x2C
	_    [16]byte
	CCR1 volatile.Register32 // 0x40
	CMR1 volatile.Register32 // 0x44
	_    [8]byte
	CV1  volatile.Register32 // 0x50
	RA1  volatile.Register32 // 0x54
	RB1  volatile.Register32 // 0x58
	RC1  volatile.Register32 // 0x5C
	SR1  volatile.Register32 // 0x60
	IER1 volatile.Register32 // 0x64
	IDR1 volatile.Register32 // 0x68
	IMR1 volatile.Register32 // 0x6C
	_    [16]byte
	CCR2 volatile.Register32 // 0x80
	CMR2 volatile.Register32 // 0x84
	_    [8]byte
	CV2  volatile.Register32 // 0x90
	RA2  volatile.Register32 // 0x94
	RB2  volatile.Register32 // 0x98
	RC2  volatile.Register32 // 0x9C
	SR2  volatile.Register32 // 0xA0
	IER2 volatile.Register32 // 0xA4
	IDR2 volatile.Register32 // 0xA8
	IMR2 volatile.Register32 // 0xAC
	_    [16]byte
	BCR  volatile.Register32 // 0xC0
	BMR  volatile.Register32 // 0xC4
}

// High Speed MultiMedia Card Interface 0
type HSMCI_Type struct {
	CR    volatile.Register32    // 0x0
	MR    volatile.Register32    // 0x4
	DTOR  volatile.Register32    // 0x8
	SDCR  volatile.Register32    // 0xC
	ARGR  volatile.Register32    // 0x10
	CMDR  volatile.Register32    // 0x14
	BLKR  volatile.Register32    // 0x18
	CSTOR volatile.Register32    // 0x1C
	RSPR  [4]volatile.Register32 // 0x20
	RDR   volatile.Register32    // 0x30
	TDR   volatile.Register32    // 0x34
	_     [8]byte
	SR    volatile.Register32 // 0x40
	IER   volatile.Register32 // 0x44
	IDR   volatile.Register32 // 0x48
	IMR   volatile.Register32 // 0x4C
	DMA   volatile.Register32 // 0x50
	CFG   volatile.Register32 // 0x54
	_     [140]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
}

// Two-wire Interface 0
type TWI_Type struct {
	CR   volatile.Register32 // 0x0
	MMR  volatile.Register32 // 0x4
	SMR  volatile.Register32 // 0x8
	IADR volatile.Register32 // 0xC
	CWGR volatile.Register32 // 0x10
	_    [12]byte
	SR   volatile.Register32 // 0x20
	IER  volatile.Register32 // 0x24
	IDR  volatile.Register32 // 0x28
	IMR  volatile.Register32 // 0x2C
	RHR  volatile.Register32 // 0x30
	THR  volatile.Register32 // 0x34
}

// Universal Synchronous Asynchronous Receiver Transmitter 0
type USART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	CSR  volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	RTOR volatile.Register32 // 0x24
	TTGR volatile.Register32 // 0x28
	_    [20]byte
	FIDI volatile.Register32 // 0x40
	NER  volatile.Register32 // 0x44
	_    [4]byte
	IF   volatile.Register32 // 0x4C
	MAN  volatile.Register32 // 0x50
	_    [172]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Synchronous Serial Controller 0
type SSC_Type struct {
	CR   volatile.Register32 // 0x0
	CMR  volatile.Register32 // 0x4
	_    [8]byte
	RCMR volatile.Register32 // 0x10
	RFMR volatile.Register32 // 0x14
	TCMR volatile.Register32 // 0x18
	TFMR volatile.Register32 // 0x1C
	RHR  volatile.Register32 // 0x20
	THR  volatile.Register32 // 0x24
	_    [8]byte
	RSHR volatile.Register32 // 0x30
	TSHR volatile.Register32 // 0x34
	RC0R volatile.Register32 // 0x38
	RC1R volatile.Register32 // 0x3C
	SR   volatile.Register32 // 0x40
	IER  volatile.Register32 // 0x44
	IDR  volatile.Register32 // 0x48
	IMR  volatile.Register32 // 0x4C
	_    [176]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Serial Peripheral Interface 0
type SPI_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	RDR  volatile.Register32 // 0x8
	TDR  volatile.Register32 // 0xC
	SR   volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	IDR  volatile.Register32 // 0x18
	IMR  volatile.Register32 // 0x1C
	_    [16]byte
	CSR  [4]volatile.Register32 // 0x30
	_    [192]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// AC97 Controller
type AC97C_Type struct {
	_     [8]byte
	MR    volatile.Register32 // 0x8
	_     [4]byte
	ICA   volatile.Register32 // 0x10
	OCA   volatile.Register32 // 0x14
	_     [8]byte
	CARHR volatile.Register32 // 0x20
	CATHR volatile.Register32 // 0x24
	CASR  volatile.Register32 // 0x28
	CAMR  volatile.Register32 // 0x2C
	CBRHR volatile.Register32 // 0x30
	CBTHR volatile.Register32 // 0x34
	CBSR  volatile.Register32 // 0x38
	CBMR  volatile.Register32 // 0x3C
	CORHR volatile.Register32 // 0x40
	COTHR volatile.Register32 // 0x44
	COSR  volatile.Register32 // 0x48
	COMR  volatile.Register32 // 0x4C
	SR    volatile.Register32 // 0x50
	IER   volatile.Register32 // 0x54
	IDR   volatile.Register32 // 0x58
	IMR   volatile.Register32 // 0x5C
	_     [160]byte
	RPR   volatile.Register32 // 0x100
	RCR   volatile.Register32 // 0x104
	TPR   volatile.Register32 // 0x108
	TCR   volatile.Register32 // 0x10C
	RNPR  volatile.Register32 // 0x110
	RNCR  volatile.Register32 // 0x114
	TNPR  volatile.Register32 // 0x118
	TNCR  volatile.Register32 // 0x11C
	PTCR  volatile.Register32 // 0x120
	PTSR  volatile.Register32 // 0x124
}

// Touch Screen ADC Controller
type TSADCC_Type struct {
	CR   volatile.Register32    // 0x0
	MR   volatile.Register32    // 0x4
	TRGR volatile.Register32    // 0x8
	TSR  volatile.Register32    // 0xC
	CHER volatile.Register32    // 0x10
	CHDR volatile.Register32    // 0x14
	CHSR volatile.Register32    // 0x18
	SR   volatile.Register32    // 0x1C
	LCDR volatile.Register32    // 0x20
	IER  volatile.Register32    // 0x24
	IDR  volatile.Register32    // 0x28
	IMR  volatile.Register32    // 0x2C
	CDR  [8]volatile.Register32 // 0x30
	XPDR volatile.Register32    // 0x50
	Z1DR volatile.Register32    // 0x54
	Z2DR volatile.Register32    // 0x58
	_    [4]byte
	MSCR volatile.Register32 // 0x60
	_    [128]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
	_    [20]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	_    [8]byte
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	_    [8]byte
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Image Sensor Interface
type ISI_Type struct {
	ISI_CFG1     volatile.Register32 // 0x0
	ISI_CFG2     volatile.Register32 // 0x4
	ISI_PSIZE    volatile.Register32 // 0x8
	ISI_PDECF    volatile.Register32 // 0xC
	ISI_Y2R_SET0 volatile.Register32 // 0x10
	ISI_Y2R_SET1 volatile.Register32 // 0x14
	ISI_R2Y_SET0 volatile.Register32 // 0x18
	ISI_R2Y_SET1 volatile.Register32 // 0x1C
	ISI_R2Y_SET2 volatile.Register32 // 0x20
	ISI_CR       volatile.Register32 // 0x24
	ISI_SR       volatile.Register32 // 0x28
	ISI_IER      volatile.Register32 // 0x2C
	ISI_IDR      volatile.Register32 // 0x30
	ISI_IMR      volatile.Register32 // 0x34
	DMA_CHER     volatile.Register32 // 0x38
	DMA_CHDR     volatile.Register32 // 0x3C
	DMA_CHSR     volatile.Register32 // 0x40
	DMA_P_ADDR   volatile.Register32 // 0x44
	DMA_P_CTRL   volatile.Register32 // 0x48
	DMA_P_DSCR   volatile.Register32 // 0x4C
	DMA_C_ADDR   volatile.Register32 // 0x50
	DMA_C_CTRL   volatile.Register32 // 0x54
	DMA_C_DSCR   volatile.Register32 // 0x58
	_            [136]byte
	ISI_WPCR     volatile.Register32 // 0xE4
	ISI_WPSR     volatile.Register32 // 0xE8
}

// Pulse Width Modulation Controller
type PWM_Type struct {
	MR    volatile.Register32 // 0x0
	ENA   volatile.Register32 // 0x4
	DIS   volatile.Register32 // 0x8
	SR    volatile.Register32 // 0xC
	IER   volatile.Register32 // 0x10
	IDR   volatile.Register32 // 0x14
	IMR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	_     [480]byte
	CMR0  volatile.Register32 // 0x200
	CDTY0 volatile.Register32 // 0x204
	CPRD0 volatile.Register32 // 0x208
	CCNT0 volatile.Register32 // 0x20C
	CUPD0 volatile.Register32 // 0x210
	_     [12]byte
	CMR1  volatile.Register32 // 0x220
	CDTY1 volatile.Register32 // 0x224
	CPRD1 volatile.Register32 // 0x228
	CCNT1 volatile.Register32 // 0x22C
	CUPD1 volatile.Register32 // 0x230
	_     [12]byte
	CMR2  volatile.Register32 // 0x240
	CDTY2 volatile.Register32 // 0x244
	CPRD2 volatile.Register32 // 0x248
	CCNT2 volatile.Register32 // 0x24C
	CUPD2 volatile.Register32 // 0x250
	_     [12]byte
	CMR3  volatile.Register32 // 0x260
	CDTY3 volatile.Register32 // 0x264
	CPRD3 volatile.Register32 // 0x268
	CCNT3 volatile.Register32 // 0x26C
	CUPD3 volatile.Register32 // 0x270
}

// Ethernet MAC 10/100
type EMAC_Type struct {
	NCR   volatile.Register32 // 0x0
	NCFG  volatile.Register32 // 0x4
	NSR   volatile.Register32 // 0x8
	_     [8]byte
	TSR   volatile.Register32 // 0x14
	RBQP  volatile.Register32 // 0x18
	TBQP  volatile.Register32 // 0x1C
	RSR   volatile.Register32 // 0x20
	ISR   volatile.Register32 // 0x24
	IER   volatile.Register32 // 0x28
	IDR   volatile.Register32 // 0x2C
	IMR   volatile.Register32 // 0x30
	MAN   volatile.Register32 // 0x34
	PTR   volatile.Register32 // 0x38
	PFR   volatile.Register32 // 0x3C
	FTO   volatile.Register32 // 0x40
	SCF   volatile.Register32 // 0x44
	MCF   volatile.Register32 // 0x48
	FRO   volatile.Register32 // 0x4C
	FCSE  volatile.Register32 // 0x50
	ALE   volatile.Register32 // 0x54
	DTF   volatile.Register32 // 0x58
	LCOL  volatile.Register32 // 0x5C
	ECOL  volatile.Register32 // 0x60
	TUND  volatile.Register32 // 0x64
	CSE   volatile.Register32 // 0x68
	RRE   volatile.Register32 // 0x6C
	ROV   volatile.Register32 // 0x70
	RSE   volatile.Register32 // 0x74
	ELE   volatile.Register32 // 0x78
	RJA   volatile.Register32 // 0x7C
	USF   volatile.Register32 // 0x80
	STE   volatile.Register32 // 0x84
	RLE   volatile.Register32 // 0x88
	_     [4]byte
	HRB   volatile.Register32 // 0x90
	HRT   volatile.Register32 // 0x94
	SA1B  volatile.Register32 // 0x98
	SA1T  volatile.Register32 // 0x9C
	SA2B  volatile.Register32 // 0xA0
	SA2T  volatile.Register32 // 0xA4
	SA3B  volatile.Register32 // 0xA8
	SA3T  volatile.Register32 // 0xAC
	SA4B  volatile.Register32 // 0xB0
	SA4T  volatile.Register32 // 0xB4
	TID   volatile.Register32 // 0xB8
	_     [4]byte
	USRIO volatile.Register32 // 0xC0
}

// True Random Number Generator
type TRNG_Type struct {
	CR    volatile.Register32 // 0x0
	_     [12]byte
	IER   volatile.Register32 // 0x10
	IDR   volatile.Register32 // 0x14
	IMR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	_     [48]byte
	ODATA volatile.Register32 // 0x50
}

// DDR_SDR SDRAM Controller 1
type EBI_Type struct {
	MR    volatile.Register32 // 0x0
	RTR   volatile.Register32 // 0x4
	CR    volatile.Register32 // 0x8
	TPR0  volatile.Register32 // 0xC
	TPR1  volatile.Register32 // 0x10
	TPR2  volatile.Register32 // 0x14
	_     [4]byte
	LPR   volatile.Register32 // 0x1C
	MD    volatile.Register32 // 0x20
	DLL   volatile.Register32 // 0x24
	_     [4]byte
	HS    volatile.Register32 // 0x2C
	_     [16]byte
	DELAY [4]volatile.Register32 // 0x40
	_     [148]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
}

// DDR_SDR SDRAM Controller 0
type DDRSDRC_Type struct {
	MR    volatile.Register32 // 0x0
	RTR   volatile.Register32 // 0x4
	CR    volatile.Register32 // 0x8
	TPR0  volatile.Register32 // 0xC
	TPR1  volatile.Register32 // 0x10
	TPR2  volatile.Register32 // 0x14
	_     [4]byte
	LPR   volatile.Register32 // 0x1C
	MD    volatile.Register32 // 0x20
	DLL   volatile.Register32 // 0x24
	_     [4]byte
	HS    volatile.Register32 // 0x2C
	_     [16]byte
	DELAY [4]volatile.Register32 // 0x40
	_     [148]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
}

// AHB Bus Matrix
type MATRIX_Type struct {
	MCFG  [11]volatile.Register32 // 0x0
	_     [20]byte
	SCFG  [8]volatile.Register32 // 0x40
	_     [32]byte
	PRAS0 volatile.Register32 // 0x80
	PRBS0 volatile.Register32 // 0x84
	PRAS1 volatile.Register32 // 0x88
	PRBS1 volatile.Register32 // 0x8C
	PRAS2 volatile.Register32 // 0x90
	PRBS2 volatile.Register32 // 0x94
	PRAS3 volatile.Register32 // 0x98
	PRBS3 volatile.Register32 // 0x9C
	PRAS4 volatile.Register32 // 0xA0
	PRBS4 volatile.Register32 // 0xA4
	PRAS5 volatile.Register32 // 0xA8
	PRBS5 volatile.Register32 // 0xAC
	PRAS6 volatile.Register32 // 0xB0
	PRBS6 volatile.Register32 // 0xB4
	PRAS7 volatile.Register32 // 0xB8
	PRBS7 volatile.Register32 // 0xBC
	_     [64]byte
	MRCR  volatile.Register32 // 0x100
	_     [224]byte
	WPMR  volatile.Register32 // 0x1E4
	WPSR  volatile.Register32 // 0x1E8
}

// DMA Controller
type DMAC_Type struct {
	GCFG   volatile.Register32 // 0x0
	EN     volatile.Register32 // 0x4
	SREQ   volatile.Register32 // 0x8
	CREQ   volatile.Register32 // 0xC
	LAST   volatile.Register32 // 0x10
	_      [4]byte
	EBCIER volatile.Register32 // 0x18
	EBCIDR volatile.Register32 // 0x1C
	EBCIMR volatile.Register32 // 0x20
	EBCISR volatile.Register32 // 0x24
	CHER   volatile.Register32 // 0x28
	CHDR   volatile.Register32 // 0x2C
	CHSR   volatile.Register32 // 0x30
	_      [8]byte
	SADDR0 volatile.Register32 // 0x3C
	DADDR0 volatile.Register32 // 0x40
	DSCR0  volatile.Register32 // 0x44
	CTRLA0 volatile.Register32 // 0x48
	CTRLB0 volatile.Register32 // 0x4C
	CFG0   volatile.Register32 // 0x50
	_      [16]byte
	SADDR1 volatile.Register32 // 0x64
	DADDR1 volatile.Register32 // 0x68
	DSCR1  volatile.Register32 // 0x6C
	CTRLA1 volatile.Register32 // 0x70
	CTRLB1 volatile.Register32 // 0x74
	CFG1   volatile.Register32 // 0x78
	_      [16]byte
	SADDR2 volatile.Register32 // 0x8C
	DADDR2 volatile.Register32 // 0x90
	DSCR2  volatile.Register32 // 0x94
	CTRLA2 volatile.Register32 // 0x98
	CTRLB2 volatile.Register32 // 0x9C
	CFG2   volatile.Register32 // 0xA0
	_      [16]byte
	SADDR3 volatile.Register32 // 0xB4
	DADDR3 volatile.Register32 // 0xB8
	DSCR3  volatile.Register32 // 0xBC
	CTRLA3 volatile.Register32 // 0xC0
	CTRLB3 volatile.Register32 // 0xC4
	CFG3   volatile.Register32 // 0xC8
	_      [16]byte
	SADDR4 volatile.Register32 // 0xDC
	DADDR4 volatile.Register32 // 0xE0
	DSCR4  volatile.Register32 // 0xE4
	CTRLA4 volatile.Register32 // 0xE8
	CTRLB4 volatile.Register32 // 0xEC
	CFG4   volatile.Register32 // 0xF0
	_      [16]byte
	SADDR5 volatile.Register32 // 0x104
	DADDR5 volatile.Register32 // 0x108
	DSCR5  volatile.Register32 // 0x10C
	CTRLA5 volatile.Register32 // 0x110
	CTRLB5 volatile.Register32 // 0x114
	CFG5   volatile.Register32 // 0x118
	_      [16]byte
	SADDR6 volatile.Register32 // 0x12C
	DADDR6 volatile.Register32 // 0x130
	DSCR6  volatile.Register32 // 0x134
	CTRLA6 volatile.Register32 // 0x138
	CTRLB6 volatile.Register32 // 0x13C
	CFG6   volatile.Register32 // 0x140
	_      [16]byte
	SADDR7 volatile.Register32 // 0x154
	DADDR7 volatile.Register32 // 0x158
	DSCR7  volatile.Register32 // 0x15C
	CTRLA7 volatile.Register32 // 0x160
	CTRLB7 volatile.Register32 // 0x164
	CFG7   volatile.Register32 // 0x168
	_      [120]byte
	WPMR   volatile.Register32 // 0x1E4
	WPSR   volatile.Register32 // 0x1E8
}

// Debug Unit
type DBGU_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	_    [28]byte
	CIDR volatile.Register32 // 0x40
	EXID volatile.Register32 // 0x44
	FNR  volatile.Register32 // 0x48
	_    [180]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Advanced Interrupt Controller
type AIC_Type struct {
	SMR   [32]volatile.Register32 // 0x0
	SVR   [32]volatile.Register32 // 0x80
	IVR   volatile.Register32     // 0x100
	FVR   volatile.Register32     // 0x104
	ISR   volatile.Register32     // 0x108
	IPR   volatile.Register32     // 0x10C
	IMR   volatile.Register32     // 0x110
	CISR  volatile.Register32     // 0x114
	_     [8]byte
	IECR  volatile.Register32 // 0x120
	IDCR  volatile.Register32 // 0x124
	ICCR  volatile.Register32 // 0x128
	ISCR  volatile.Register32 // 0x12C
	EOICR volatile.Register32 // 0x130
	SPU   volatile.Register32 // 0x134
	DCR   volatile.Register32 // 0x138
	_     [4]byte
	FFER  volatile.Register32 // 0x140
	FFDR  volatile.Register32 // 0x144
	FFSR  volatile.Register32 // 0x148
}

// Parallel Input/Output Controller A
type PIO_Type struct {
	PER    volatile.Register32 // 0x0
	PDR    volatile.Register32 // 0x4
	PSR    volatile.Register32 // 0x8
	_      [4]byte
	OER    volatile.Register32 // 0x10
	ODR    volatile.Register32 // 0x14
	OSR    volatile.Register32 // 0x18
	_      [4]byte
	IFER   volatile.Register32 // 0x20
	IFDR   volatile.Register32 // 0x24
	IFSR   volatile.Register32 // 0x28
	_      [4]byte
	SODR   volatile.Register32 // 0x30
	CODR   volatile.Register32 // 0x34
	ODSR   volatile.Register32 // 0x38
	PDSR   volatile.Register32 // 0x3C
	IER    volatile.Register32 // 0x40
	IDR    volatile.Register32 // 0x44
	IMR    volatile.Register32 // 0x48
	ISR    volatile.Register32 // 0x4C
	MDER   volatile.Register32 // 0x50
	MDDR   volatile.Register32 // 0x54
	MDSR   volatile.Register32 // 0x58
	_      [4]byte
	PUDR   volatile.Register32 // 0x60
	PUER   volatile.Register32 // 0x64
	PUSR   volatile.Register32 // 0x68
	_      [4]byte
	ASR    volatile.Register32 // 0x70
	BSR    volatile.Register32 // 0x74
	ABSR   volatile.Register32 // 0x78
	_      [36]byte
	OWER   volatile.Register32 // 0xA0
	OWDR   volatile.Register32 // 0xA4
	OWSR   volatile.Register32 // 0xA8
	_      [20]byte
	DELAYR [4]volatile.Register32 // 0xC0
	_      [20]byte
	WPMR   volatile.Register32 // 0xE4
	WPSR   volatile.Register32 // 0xE8
}

// Power Management Controller
type PMC_Type struct {
	PMC_SCER   volatile.Register32 // 0x0
	PMC_SCDR   volatile.Register32 // 0x4
	PMC_SCSR   volatile.Register32 // 0x8
	_          [4]byte
	PMC_PCER   volatile.Register32 // 0x10
	PMC_PCDR   volatile.Register32 // 0x14
	PMC_PCSR   volatile.Register32 // 0x18
	CKGR_UCKR  volatile.Register32 // 0x1C
	CKGR_MOR   volatile.Register32 // 0x20
	CKGR_MCFR  volatile.Register32 // 0x24
	CKGR_PLLAR volatile.Register32 // 0x28
	_          [4]byte
	PMC_MCKR   volatile.Register32 // 0x30
	_          [4]byte
	PMC_USB    volatile.Register32 // 0x38
	_          [4]byte
	PMC_PCK    [2]volatile.Register32 // 0x40
	_          [24]byte
	PMC_IER    volatile.Register32 // 0x60
	PMC_IDR    volatile.Register32 // 0x64
	PMC_SR     volatile.Register32 // 0x68
	PMC_IMR    volatile.Register32 // 0x6C
}

// Reset Controller
type SYSC_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	MR volatile.Register32 // 0x8
}

// Real-time Clock
type RTC_Type struct {
	CR     volatile.Register32 // 0x0
	MR     volatile.Register32 // 0x4
	TIMR   volatile.Register32 // 0x8
	CALR   volatile.Register32 // 0xC
	TIMALR volatile.Register32 // 0x10
	CALALR volatile.Register32 // 0x14
	SR     volatile.Register32 // 0x18
	SCCR   volatile.Register32 // 0x1C
	IER    volatile.Register32 // 0x20
	IDR    volatile.Register32 // 0x24
	IMR    volatile.Register32 // 0x28
	VER    volatile.Register32 // 0x2C
}

// Bitfields for LCDC: LCD Controller
const (
	// DMABADDR1: DMA Base Address Register 1
	LCDC_DMABADDR1_BADDR_U_Pos = 0x2        // Position of BADDR_U field.
	LCDC_DMABADDR1_BADDR_U_Msk = 0xfffffffc // Bit mask of BADDR_U field.

	// DMABADDR2: DMA Base Address Register 2
	LCDC_DMABADDR2_BADDR_L_Pos = 0x0        // Position of BADDR_L field.
	LCDC_DMABADDR2_BADDR_L_Msk = 0xffffffff // Bit mask of BADDR_L field.

	// DMAFRMPT1: DMA Frame Pointer Register 1
	LCDC_DMAFRMPT1_FRMPT_U_Pos = 0x0      // Position of FRMPT_U field.
	LCDC_DMAFRMPT1_FRMPT_U_Msk = 0x7fffff // Bit mask of FRMPT_U field.

	// DMAFRMPT2: DMA Frame Pointer Register 2
	LCDC_DMAFRMPT2_FRMPT_L_Pos = 0x0      // Position of FRMPT_L field.
	LCDC_DMAFRMPT2_FRMPT_L_Msk = 0x7fffff // Bit mask of FRMPT_L field.

	// DMAFRMADD1: DMA Frame Address Register 1
	LCDC_DMAFRMADD1_FRMADD_U_Pos = 0x0        // Position of FRMADD_U field.
	LCDC_DMAFRMADD1_FRMADD_U_Msk = 0xffffffff // Bit mask of FRMADD_U field.

	// DMAFRMADD2: DMA Frame Address Register 2
	LCDC_DMAFRMADD2_FRMADD_L_Pos = 0x0        // Position of FRMADD_L field.
	LCDC_DMAFRMADD2_FRMADD_L_Msk = 0xffffffff // Bit mask of FRMADD_L field.

	// DMAFRMCFG: DMA Frame Configuration Register
	LCDC_DMAFRMCFG_FRMSIZE_Pos = 0x0        // Position of FRMSIZE field.
	LCDC_DMAFRMCFG_FRMSIZE_Msk = 0x7fffff   // Bit mask of FRMSIZE field.
	LCDC_DMAFRMCFG_BRSTLN_Pos  = 0x18       // Position of BRSTLN field.
	LCDC_DMAFRMCFG_BRSTLN_Msk  = 0x7f000000 // Bit mask of BRSTLN field.

	// DMACON: DMA Control Register
	LCDC_DMACON_DMAEN_Pos   = 0x0  // Position of DMAEN field.
	LCDC_DMACON_DMAEN_Msk   = 0x1  // Bit mask of DMAEN field.
	LCDC_DMACON_DMAEN       = 0x1  // Bit DMAEN.
	LCDC_DMACON_DMARST_Pos  = 0x1  // Position of DMARST field.
	LCDC_DMACON_DMARST_Msk  = 0x2  // Bit mask of DMARST field.
	LCDC_DMACON_DMARST      = 0x2  // Bit DMARST.
	LCDC_DMACON_DMABUSY_Pos = 0x2  // Position of DMABUSY field.
	LCDC_DMACON_DMABUSY_Msk = 0x4  // Bit mask of DMABUSY field.
	LCDC_DMACON_DMABUSY     = 0x4  // Bit DMABUSY.
	LCDC_DMACON_DMAUPDT_Pos = 0x3  // Position of DMAUPDT field.
	LCDC_DMACON_DMAUPDT_Msk = 0x8  // Bit mask of DMAUPDT field.
	LCDC_DMACON_DMAUPDT     = 0x8  // Bit DMAUPDT.
	LCDC_DMACON_DMA2DEN_Pos = 0x4  // Position of DMA2DEN field.
	LCDC_DMACON_DMA2DEN_Msk = 0x10 // Bit mask of DMA2DEN field.
	LCDC_DMACON_DMA2DEN     = 0x10 // Bit DMA2DEN.

	// DMA2DCFG: DMA Control Register
	LCDC_DMA2DCFG_ADDRINC_Pos  = 0x0        // Position of ADDRINC field.
	LCDC_DMA2DCFG_ADDRINC_Msk  = 0xffff     // Bit mask of ADDRINC field.
	LCDC_DMA2DCFG_PIXELOFF_Pos = 0x18       // Position of PIXELOFF field.
	LCDC_DMA2DCFG_PIXELOFF_Msk = 0x1f000000 // Bit mask of PIXELOFF field.

	// LCDCON1: LCD Control Register 1
	LCDC_LCDCON1_BYPASS_Pos  = 0x0        // Position of BYPASS field.
	LCDC_LCDCON1_BYPASS_Msk  = 0x1        // Bit mask of BYPASS field.
	LCDC_LCDCON1_BYPASS      = 0x1        // Bit BYPASS.
	LCDC_LCDCON1_CLKVAL_Pos  = 0xc        // Position of CLKVAL field.
	LCDC_LCDCON1_CLKVAL_Msk  = 0x1ff000   // Bit mask of CLKVAL field.
	LCDC_LCDCON1_LINECNT_Pos = 0x15       // Position of LINECNT field.
	LCDC_LCDCON1_LINECNT_Msk = 0xffe00000 // Bit mask of LINECNT field.

	// LCDCON2: LCD Control Register 2
	LCDC_LCDCON2_DISTYPE_Pos   = 0x0        // Position of DISTYPE field.
	LCDC_LCDCON2_DISTYPE_Msk   = 0x3        // Bit mask of DISTYPE field.
	LCDC_LCDCON2_SCANMOD_Pos   = 0x2        // Position of SCANMOD field.
	LCDC_LCDCON2_SCANMOD_Msk   = 0x4        // Bit mask of SCANMOD field.
	LCDC_LCDCON2_SCANMOD       = 0x4        // Bit SCANMOD.
	LCDC_LCDCON2_IFWIDTH_Pos   = 0x3        // Position of IFWIDTH field.
	LCDC_LCDCON2_IFWIDTH_Msk   = 0x18       // Bit mask of IFWIDTH field.
	LCDC_LCDCON2_PIXELSIZE_Pos = 0x5        // Position of PIXELSIZE field.
	LCDC_LCDCON2_PIXELSIZE_Msk = 0xe0       // Bit mask of PIXELSIZE field.
	LCDC_LCDCON2_INVVD_Pos     = 0x8        // Position of INVVD field.
	LCDC_LCDCON2_INVVD_Msk     = 0x100      // Bit mask of INVVD field.
	LCDC_LCDCON2_INVVD         = 0x100      // Bit INVVD.
	LCDC_LCDCON2_INVFRAME_Pos  = 0x9        // Position of INVFRAME field.
	LCDC_LCDCON2_INVFRAME_Msk  = 0x200      // Bit mask of INVFRAME field.
	LCDC_LCDCON2_INVFRAME      = 0x200      // Bit INVFRAME.
	LCDC_LCDCON2_INVLINE_Pos   = 0xa        // Position of INVLINE field.
	LCDC_LCDCON2_INVLINE_Msk   = 0x400      // Bit mask of INVLINE field.
	LCDC_LCDCON2_INVLINE       = 0x400      // Bit INVLINE.
	LCDC_LCDCON2_INVCLK_Pos    = 0xb        // Position of INVCLK field.
	LCDC_LCDCON2_INVCLK_Msk    = 0x800      // Bit mask of INVCLK field.
	LCDC_LCDCON2_INVCLK        = 0x800      // Bit INVCLK.
	LCDC_LCDCON2_INVDVAL_Pos   = 0xc        // Position of INVDVAL field.
	LCDC_LCDCON2_INVDVAL_Msk   = 0x1000     // Bit mask of INVDVAL field.
	LCDC_LCDCON2_INVDVAL       = 0x1000     // Bit INVDVAL.
	LCDC_LCDCON2_CLKMOD_Pos    = 0xf        // Position of CLKMOD field.
	LCDC_LCDCON2_CLKMOD_Msk    = 0x8000     // Bit mask of CLKMOD field.
	LCDC_LCDCON2_CLKMOD        = 0x8000     // Bit CLKMOD.
	LCDC_LCDCON2_MEMOR_Pos     = 0x1e       // Position of MEMOR field.
	LCDC_LCDCON2_MEMOR_Msk     = 0xc0000000 // Bit mask of MEMOR field.

	// LCDTIM1: LCD Timing Register 1
	LCDC_LCDTIM1_VFP_Pos      = 0x0        // Position of VFP field.
	LCDC_LCDTIM1_VFP_Msk      = 0xff       // Bit mask of VFP field.
	LCDC_LCDTIM1_VBP_Pos      = 0x8        // Position of VBP field.
	LCDC_LCDTIM1_VBP_Msk      = 0xff00     // Bit mask of VBP field.
	LCDC_LCDTIM1_VPW_Pos      = 0x10       // Position of VPW field.
	LCDC_LCDTIM1_VPW_Msk      = 0x3f0000   // Bit mask of VPW field.
	LCDC_LCDTIM1_VHDLY_Pos    = 0x18       // Position of VHDLY field.
	LCDC_LCDTIM1_VHDLY_Msk    = 0xf000000  // Bit mask of VHDLY field.
	LCDC_LCDTIM1_STUCKTO1_Pos = 0x1f       // Position of STUCKTO1 field.
	LCDC_LCDTIM1_STUCKTO1_Msk = 0x80000000 // Bit mask of STUCKTO1 field.
	LCDC_LCDTIM1_STUCKTO1     = 0x80000000 // Bit STUCKTO1.

	// LCDTIM2: LCD Timing Register 2
	LCDC_LCDTIM2_HBP_Pos = 0x0        // Position of HBP field.
	LCDC_LCDTIM2_HBP_Msk = 0xff       // Bit mask of HBP field.
	LCDC_LCDTIM2_HPW_Pos = 0x8        // Position of HPW field.
	LCDC_LCDTIM2_HPW_Msk = 0x3f00     // Bit mask of HPW field.
	LCDC_LCDTIM2_HFP_Pos = 0x15       // Position of HFP field.
	LCDC_LCDTIM2_HFP_Msk = 0xffe00000 // Bit mask of HFP field.

	// LCDFRMCFG: LCD Frame Configuration Register
	LCDC_LCDFRMCFG_LINEVAL_Pos  = 0x0        // Position of LINEVAL field.
	LCDC_LCDFRMCFG_LINEVAL_Msk  = 0x7ff      // Bit mask of LINEVAL field.
	LCDC_LCDFRMCFG_LINESIZE_Pos = 0x15       // Position of LINESIZE field.
	LCDC_LCDFRMCFG_LINESIZE_Msk = 0xffe00000 // Bit mask of LINESIZE field.

	// LCDFIFO: LCD FIFO Register
	LCDC_LCDFIFO_FIFOTH_Pos = 0x0    // Position of FIFOTH field.
	LCDC_LCDFIFO_FIFOTH_Msk = 0xffff // Bit mask of FIFOTH field.

	// DP1_2: Dithering Pattern DP1_2
	LCDC_DP1_2_DP1_2_Pos = 0x0  // Position of DP1_2 field.
	LCDC_DP1_2_DP1_2_Msk = 0xff // Bit mask of DP1_2 field.

	// DP4_7: Dithering Pattern DP4_7
	LCDC_DP4_7_DP4_7_Pos = 0x0       // Position of DP4_7 field.
	LCDC_DP4_7_DP4_7_Msk = 0xfffffff // Bit mask of DP4_7 field.

	// DP3_5: Dithering Pattern DP3_5
	LCDC_DP3_5_DP3_5_Pos = 0x0     // Position of DP3_5 field.
	LCDC_DP3_5_DP3_5_Msk = 0xfffff // Bit mask of DP3_5 field.

	// DP2_3: Dithering Pattern DP2_3
	LCDC_DP2_3_DP2_3_Pos = 0x0   // Position of DP2_3 field.
	LCDC_DP2_3_DP2_3_Msk = 0xfff // Bit mask of DP2_3 field.

	// DP5_7: Dithering Pattern DP5_7
	LCDC_DP5_7_DP5_7_Pos = 0x0       // Position of DP5_7 field.
	LCDC_DP5_7_DP5_7_Msk = 0xfffffff // Bit mask of DP5_7 field.

	// DP3_4: Dithering Pattern DP3_4
	LCDC_DP3_4_DP3_4_Pos = 0x0    // Position of DP3_4 field.
	LCDC_DP3_4_DP3_4_Msk = 0xffff // Bit mask of DP3_4 field.

	// DP4_5: Dithering Pattern DP4_5
	LCDC_DP4_5_DP4_5_Pos = 0x0     // Position of DP4_5 field.
	LCDC_DP4_5_DP4_5_Msk = 0xfffff // Bit mask of DP4_5 field.

	// DP6_7: Dithering Pattern DP6_7
	LCDC_DP6_7_DP6_7_Pos = 0x0       // Position of DP6_7 field.
	LCDC_DP6_7_DP6_7_Msk = 0xfffffff // Bit mask of DP6_7 field.

	// PWRCON: Power Control Register
	LCDC_PWRCON_LCD_PWR_Pos    = 0x0        // Position of LCD_PWR field.
	LCDC_PWRCON_LCD_PWR_Msk    = 0x1        // Bit mask of LCD_PWR field.
	LCDC_PWRCON_LCD_PWR        = 0x1        // Bit LCD_PWR.
	LCDC_PWRCON_GUARD_TIME_Pos = 0x1        // Position of GUARD_TIME field.
	LCDC_PWRCON_GUARD_TIME_Msk = 0xfe       // Bit mask of GUARD_TIME field.
	LCDC_PWRCON_LCD_BUSY_Pos   = 0x1f       // Position of LCD_BUSY field.
	LCDC_PWRCON_LCD_BUSY_Msk   = 0x80000000 // Bit mask of LCD_BUSY field.
	LCDC_PWRCON_LCD_BUSY       = 0x80000000 // Bit LCD_BUSY.

	// CONTRAST_CTR: Contrast Control Register
	LCDC_CONTRAST_CTR_PS_Pos  = 0x0 // Position of PS field.
	LCDC_CONTRAST_CTR_PS_Msk  = 0x3 // Bit mask of PS field.
	LCDC_CONTRAST_CTR_POL_Pos = 0x2 // Position of POL field.
	LCDC_CONTRAST_CTR_POL_Msk = 0x4 // Bit mask of POL field.
	LCDC_CONTRAST_CTR_POL     = 0x4 // Bit POL.
	LCDC_CONTRAST_CTR_ENA_Pos = 0x3 // Position of ENA field.
	LCDC_CONTRAST_CTR_ENA_Msk = 0x8 // Bit mask of ENA field.
	LCDC_CONTRAST_CTR_ENA     = 0x8 // Bit ENA.

	// LCD_IER: LCD Interrupt Enable Register
	LCDC_LCD_IER_LNIE_Pos    = 0x0  // Position of LNIE field.
	LCDC_LCD_IER_LNIE_Msk    = 0x1  // Bit mask of LNIE field.
	LCDC_LCD_IER_LNIE        = 0x1  // Bit LNIE.
	LCDC_LCD_IER_LSTLNIE_Pos = 0x1  // Position of LSTLNIE field.
	LCDC_LCD_IER_LSTLNIE_Msk = 0x2  // Bit mask of LSTLNIE field.
	LCDC_LCD_IER_LSTLNIE     = 0x2  // Bit LSTLNIE.
	LCDC_LCD_IER_EOFIE_Pos   = 0x2  // Position of EOFIE field.
	LCDC_LCD_IER_EOFIE_Msk   = 0x4  // Bit mask of EOFIE field.
	LCDC_LCD_IER_EOFIE       = 0x4  // Bit EOFIE.
	LCDC_LCD_IER_UFLWIE_Pos  = 0x4  // Position of UFLWIE field.
	LCDC_LCD_IER_UFLWIE_Msk  = 0x10 // Bit mask of UFLWIE field.
	LCDC_LCD_IER_UFLWIE      = 0x10 // Bit UFLWIE.
	LCDC_LCD_IER_OWRIE_Pos   = 0x5  // Position of OWRIE field.
	LCDC_LCD_IER_OWRIE_Msk   = 0x20 // Bit mask of OWRIE field.
	LCDC_LCD_IER_OWRIE       = 0x20 // Bit OWRIE.
	LCDC_LCD_IER_MERIE_Pos   = 0x6  // Position of MERIE field.
	LCDC_LCD_IER_MERIE_Msk   = 0x40 // Bit mask of MERIE field.
	LCDC_LCD_IER_MERIE       = 0x40 // Bit MERIE.

	// LCD_IDR: LCD Interrupt Disable Register
	LCDC_LCD_IDR_LNID_Pos    = 0x0  // Position of LNID field.
	LCDC_LCD_IDR_LNID_Msk    = 0x1  // Bit mask of LNID field.
	LCDC_LCD_IDR_LNID        = 0x1  // Bit LNID.
	LCDC_LCD_IDR_LSTLNID_Pos = 0x1  // Position of LSTLNID field.
	LCDC_LCD_IDR_LSTLNID_Msk = 0x2  // Bit mask of LSTLNID field.
	LCDC_LCD_IDR_LSTLNID     = 0x2  // Bit LSTLNID.
	LCDC_LCD_IDR_EOFID_Pos   = 0x2  // Position of EOFID field.
	LCDC_LCD_IDR_EOFID_Msk   = 0x4  // Bit mask of EOFID field.
	LCDC_LCD_IDR_EOFID       = 0x4  // Bit EOFID.
	LCDC_LCD_IDR_UFLWID_Pos  = 0x4  // Position of UFLWID field.
	LCDC_LCD_IDR_UFLWID_Msk  = 0x10 // Bit mask of UFLWID field.
	LCDC_LCD_IDR_UFLWID      = 0x10 // Bit UFLWID.
	LCDC_LCD_IDR_OWRID_Pos   = 0x5  // Position of OWRID field.
	LCDC_LCD_IDR_OWRID_Msk   = 0x20 // Bit mask of OWRID field.
	LCDC_LCD_IDR_OWRID       = 0x20 // Bit OWRID.
	LCDC_LCD_IDR_MERID_Pos   = 0x6  // Position of MERID field.
	LCDC_LCD_IDR_MERID_Msk   = 0x40 // Bit mask of MERID field.
	LCDC_LCD_IDR_MERID       = 0x40 // Bit MERID.

	// LCD_IMR: LCD Interrupt Mask Register
	LCDC_LCD_IMR_LNIM_Pos    = 0x0  // Position of LNIM field.
	LCDC_LCD_IMR_LNIM_Msk    = 0x1  // Bit mask of LNIM field.
	LCDC_LCD_IMR_LNIM        = 0x1  // Bit LNIM.
	LCDC_LCD_IMR_LSTLNIM_Pos = 0x1  // Position of LSTLNIM field.
	LCDC_LCD_IMR_LSTLNIM_Msk = 0x2  // Bit mask of LSTLNIM field.
	LCDC_LCD_IMR_LSTLNIM     = 0x2  // Bit LSTLNIM.
	LCDC_LCD_IMR_EOFIM_Pos   = 0x2  // Position of EOFIM field.
	LCDC_LCD_IMR_EOFIM_Msk   = 0x4  // Bit mask of EOFIM field.
	LCDC_LCD_IMR_EOFIM       = 0x4  // Bit EOFIM.
	LCDC_LCD_IMR_UFLWIM_Pos  = 0x4  // Position of UFLWIM field.
	LCDC_LCD_IMR_UFLWIM_Msk  = 0x10 // Bit mask of UFLWIM field.
	LCDC_LCD_IMR_UFLWIM      = 0x10 // Bit UFLWIM.
	LCDC_LCD_IMR_OWRIM_Pos   = 0x5  // Position of OWRIM field.
	LCDC_LCD_IMR_OWRIM_Msk   = 0x20 // Bit mask of OWRIM field.
	LCDC_LCD_IMR_OWRIM       = 0x20 // Bit OWRIM.
	LCDC_LCD_IMR_MERIM_Pos   = 0x6  // Position of MERIM field.
	LCDC_LCD_IMR_MERIM_Msk   = 0x40 // Bit mask of MERIM field.
	LCDC_LCD_IMR_MERIM       = 0x40 // Bit MERIM.

	// LCD_ISR: LCD Interrupt Status Register
	LCDC_LCD_ISR_LNIS_Pos    = 0x0  // Position of LNIS field.
	LCDC_LCD_ISR_LNIS_Msk    = 0x1  // Bit mask of LNIS field.
	LCDC_LCD_ISR_LNIS        = 0x1  // Bit LNIS.
	LCDC_LCD_ISR_LSTLNIS_Pos = 0x1  // Position of LSTLNIS field.
	LCDC_LCD_ISR_LSTLNIS_Msk = 0x2  // Bit mask of LSTLNIS field.
	LCDC_LCD_ISR_LSTLNIS     = 0x2  // Bit LSTLNIS.
	LCDC_LCD_ISR_EOFIS_Pos   = 0x2  // Position of EOFIS field.
	LCDC_LCD_ISR_EOFIS_Msk   = 0x4  // Bit mask of EOFIS field.
	LCDC_LCD_ISR_EOFIS       = 0x4  // Bit EOFIS.
	LCDC_LCD_ISR_UFLWIS_Pos  = 0x4  // Position of UFLWIS field.
	LCDC_LCD_ISR_UFLWIS_Msk  = 0x10 // Bit mask of UFLWIS field.
	LCDC_LCD_ISR_UFLWIS      = 0x10 // Bit UFLWIS.
	LCDC_LCD_ISR_OWRIS_Pos   = 0x5  // Position of OWRIS field.
	LCDC_LCD_ISR_OWRIS_Msk   = 0x20 // Bit mask of OWRIS field.
	LCDC_LCD_ISR_OWRIS       = 0x20 // Bit OWRIS.
	LCDC_LCD_ISR_MERIS_Pos   = 0x6  // Position of MERIS field.
	LCDC_LCD_ISR_MERIS_Msk   = 0x40 // Bit mask of MERIS field.
	LCDC_LCD_ISR_MERIS       = 0x40 // Bit MERIS.

	// LCD_ICR: LCD Interrupt Clear Register
	LCDC_LCD_ICR_LNIC_Pos    = 0x0  // Position of LNIC field.
	LCDC_LCD_ICR_LNIC_Msk    = 0x1  // Bit mask of LNIC field.
	LCDC_LCD_ICR_LNIC        = 0x1  // Bit LNIC.
	LCDC_LCD_ICR_LSTLNIC_Pos = 0x1  // Position of LSTLNIC field.
	LCDC_LCD_ICR_LSTLNIC_Msk = 0x2  // Bit mask of LSTLNIC field.
	LCDC_LCD_ICR_LSTLNIC     = 0x2  // Bit LSTLNIC.
	LCDC_LCD_ICR_EOFIC_Pos   = 0x2  // Position of EOFIC field.
	LCDC_LCD_ICR_EOFIC_Msk   = 0x4  // Bit mask of EOFIC field.
	LCDC_LCD_ICR_EOFIC       = 0x4  // Bit EOFIC.
	LCDC_LCD_ICR_UFLWIC_Pos  = 0x4  // Position of UFLWIC field.
	LCDC_LCD_ICR_UFLWIC_Msk  = 0x10 // Bit mask of UFLWIC field.
	LCDC_LCD_ICR_UFLWIC      = 0x10 // Bit UFLWIC.
	LCDC_LCD_ICR_OWRIC_Pos   = 0x5  // Position of OWRIC field.
	LCDC_LCD_ICR_OWRIC_Msk   = 0x20 // Bit mask of OWRIC field.
	LCDC_LCD_ICR_OWRIC       = 0x20 // Bit OWRIC.
	LCDC_LCD_ICR_MERIC_Pos   = 0x6  // Position of MERIC field.
	LCDC_LCD_ICR_MERIC_Msk   = 0x40 // Bit mask of MERIC field.
	LCDC_LCD_ICR_MERIC       = 0x40 // Bit MERIC.

	// LCD_ITR: LCD Interrupt Test Register
	LCDC_LCD_ITR_LNIT_Pos    = 0x0  // Position of LNIT field.
	LCDC_LCD_ITR_LNIT_Msk    = 0x1  // Bit mask of LNIT field.
	LCDC_LCD_ITR_LNIT        = 0x1  // Bit LNIT.
	LCDC_LCD_ITR_LSTLNIT_Pos = 0x1  // Position of LSTLNIT field.
	LCDC_LCD_ITR_LSTLNIT_Msk = 0x2  // Bit mask of LSTLNIT field.
	LCDC_LCD_ITR_LSTLNIT     = 0x2  // Bit LSTLNIT.
	LCDC_LCD_ITR_EOFIT_Pos   = 0x2  // Position of EOFIT field.
	LCDC_LCD_ITR_EOFIT_Msk   = 0x4  // Bit mask of EOFIT field.
	LCDC_LCD_ITR_EOFIT       = 0x4  // Bit EOFIT.
	LCDC_LCD_ITR_UFLWIT_Pos  = 0x4  // Position of UFLWIT field.
	LCDC_LCD_ITR_UFLWIT_Msk  = 0x10 // Bit mask of UFLWIT field.
	LCDC_LCD_ITR_UFLWIT      = 0x10 // Bit UFLWIT.
	LCDC_LCD_ITR_OWRIT_Pos   = 0x5  // Position of OWRIT field.
	LCDC_LCD_ITR_OWRIT_Msk   = 0x20 // Bit mask of OWRIT field.
	LCDC_LCD_ITR_OWRIT       = 0x20 // Bit OWRIT.
	LCDC_LCD_ITR_MERIT_Pos   = 0x6  // Position of MERIT field.
	LCDC_LCD_ITR_MERIT_Msk   = 0x40 // Bit mask of MERIT field.
	LCDC_LCD_ITR_MERIT       = 0x40 // Bit MERIT.

	// LCD_IRR: LCD Interrupt Raw Status Register
	LCDC_LCD_IRR_LNIR_Pos    = 0x0  // Position of LNIR field.
	LCDC_LCD_IRR_LNIR_Msk    = 0x1  // Bit mask of LNIR field.
	LCDC_LCD_IRR_LNIR        = 0x1  // Bit LNIR.
	LCDC_LCD_IRR_LSTLNIR_Pos = 0x1  // Position of LSTLNIR field.
	LCDC_LCD_IRR_LSTLNIR_Msk = 0x2  // Bit mask of LSTLNIR field.
	LCDC_LCD_IRR_LSTLNIR     = 0x2  // Bit LSTLNIR.
	LCDC_LCD_IRR_EOFIR_Pos   = 0x2  // Position of EOFIR field.
	LCDC_LCD_IRR_EOFIR_Msk   = 0x4  // Bit mask of EOFIR field.
	LCDC_LCD_IRR_EOFIR       = 0x4  // Bit EOFIR.
	LCDC_LCD_IRR_UFLWIR_Pos  = 0x4  // Position of UFLWIR field.
	LCDC_LCD_IRR_UFLWIR_Msk  = 0x10 // Bit mask of UFLWIR field.
	LCDC_LCD_IRR_UFLWIR      = 0x10 // Bit UFLWIR.
	LCDC_LCD_IRR_OWRIR_Pos   = 0x5  // Position of OWRIR field.
	LCDC_LCD_IRR_OWRIR_Msk   = 0x20 // Bit mask of OWRIR field.
	LCDC_LCD_IRR_OWRIR       = 0x20 // Bit OWRIR.
	LCDC_LCD_IRR_MERIR_Pos   = 0x6  // Position of MERIR field.
	LCDC_LCD_IRR_MERIR_Msk   = 0x40 // Bit mask of MERIR field.
	LCDC_LCD_IRR_MERIR       = 0x40 // Bit MERIR.

	// LCD_WPSR: Write Protection Status Register
	LCDC_LCD_WPSR_WPVS_Pos   = 0x0      // Position of WPVS field.
	LCDC_LCD_WPSR_WPVS_Msk   = 0x1      // Bit mask of WPVS field.
	LCDC_LCD_WPSR_WPVS       = 0x1      // Bit WPVS.
	LCDC_LCD_WPSR_WPVSRC_Pos = 0x8      // Position of WPVSRC field.
	LCDC_LCD_WPSR_WPVSRC_Msk = 0xffff00 // Bit mask of WPVSRC field.
)

// Bitfields for VDEC: Video Decoder
const (
	// IDR: ID Register
	VDEC_IDR_BUILD_VER_Pos = 0x0        // Position of BUILD_VER field.
	VDEC_IDR_BUILD_VER_Msk = 0xf        // Bit mask of BUILD_VER field.
	VDEC_IDR_MINOR_VER_Pos = 0x4        // Position of MINOR_VER field.
	VDEC_IDR_MINOR_VER_Msk = 0xff0      // Bit mask of MINOR_VER field.
	VDEC_IDR_MAJOR_VER_Pos = 0xc        // Position of MAJOR_VER field.
	VDEC_IDR_MAJOR_VER_Msk = 0xf000     // Bit mask of MAJOR_VER field.
	VDEC_IDR_PROD_ID_Pos   = 0x10       // Position of PROD_ID field.
	VDEC_IDR_PROD_ID_Msk   = 0xffff0000 // Bit mask of PROD_ID field.

	// DIR: Decoder Interrupt Register
	VDEC_DIR_DE_Pos     = 0x0     // Position of DE field.
	VDEC_DIR_DE_Msk     = 0x1     // Bit mask of DE field.
	VDEC_DIR_DE         = 0x1     // Bit DE.
	VDEC_DIR_ID_Pos     = 0x4     // Position of ID field.
	VDEC_DIR_ID_Msk     = 0x10    // Bit mask of ID field.
	VDEC_DIR_ID         = 0x10    // Bit ID.
	VDEC_DIR_ISET_Pos   = 0x8     // Position of ISET field.
	VDEC_DIR_ISET_Msk   = 0x100   // Bit mask of ISET field.
	VDEC_DIR_ISET       = 0x100   // Bit ISET.
	VDEC_DIR_DR_Pos     = 0xc     // Position of DR field.
	VDEC_DIR_DR_Msk     = 0x1000  // Bit mask of DR field.
	VDEC_DIR_DR         = 0x1000  // Bit DR.
	VDEC_DIR_BE_Pos     = 0xd     // Position of BE field.
	VDEC_DIR_BE_Msk     = 0x2000  // Bit mask of BE field.
	VDEC_DIR_BE         = 0x2000  // Bit BE.
	VDEC_DIR_SBE_Pos    = 0xe     // Position of SBE field.
	VDEC_DIR_SBE_Msk    = 0x4000  // Bit mask of SBE field.
	VDEC_DIR_SBE        = 0x4000  // Bit SBE.
	VDEC_DIR_ASOD_Pos   = 0xf     // Position of ASOD field.
	VDEC_DIR_ASOD_Msk   = 0x8000  // Bit mask of ASOD field.
	VDEC_DIR_ASOD       = 0x8000  // Bit ASOD.
	VDEC_DIR_ISE_Pos    = 0x10    // Position of ISE field.
	VDEC_DIR_ISE_Msk    = 0x10000 // Bit mask of ISE field.
	VDEC_DIR_ISE        = 0x10000 // Bit ISE.
	VDEC_DIR_JPEGSD_Pos = 0x11    // Position of JPEGSD field.
	VDEC_DIR_JPEGSD_Msk = 0x20000 // Bit mask of JPEGSD field.
	VDEC_DIR_JPEGSD     = 0x20000 // Bit JPEGSD.
	VDEC_DIR_TO_Pos     = 0x12    // Position of TO field.
	VDEC_DIR_TO_Msk     = 0x40000 // Bit mask of TO field.
	VDEC_DIR_TO         = 0x40000 // Bit TO.

	// DDCR: Decoder Device Configuration Register
	VDEC_DDCR_MAX_BURST_LEN_Pos = 0x0      // Position of MAX_BURST_LEN field.
	VDEC_DDCR_MAX_BURST_LEN_Msk = 0x1f     // Bit mask of MAX_BURST_LEN field.
	VDEC_DDCR_PRIOR_Pos         = 0x5      // Position of PRIOR field.
	VDEC_DDCR_PRIOR_Msk         = 0xe0     // Bit mask of PRIOR field.
	VDEC_DDCR_DO_LE_Pos         = 0x8      // Position of DO_LE field.
	VDEC_DDCR_DO_LE_Msk         = 0x100    // Bit mask of DO_LE field.
	VDEC_DDCR_DO_LE             = 0x100    // Bit DO_LE.
	VDEC_DDCR_INTCE_LE_Pos      = 0x9      // Position of INTCE_LE field.
	VDEC_DDCR_INTCE_LE_Msk      = 0x200    // Bit mask of INTCE_LE field.
	VDEC_DDCR_INTCE_LE          = 0x200    // Bit INTCE_LE.
	VDEC_DDCR_DDCGE_Pos         = 0xa      // Position of DDCGE field.
	VDEC_DDCR_DDCGE_Msk         = 0x400    // Bit mask of DDCGE field.
	VDEC_DDCR_DDCGE             = 0x400    // Bit DDCGE.
	VDEC_DDCR_LAT_COMP_Pos      = 0xb      // Position of LAT_COMP field.
	VDEC_DDCR_LAT_COMP_Msk      = 0x1f800  // Bit mask of LAT_COMP field.
	VDEC_DDCR_DOPF_Pos          = 0x11     // Position of DOPF field.
	VDEC_DDCR_DOPF_Msk          = 0x20000  // Bit mask of DOPF field.
	VDEC_DDCR_DOPF              = 0x20000  // Bit DOPF.
	VDEC_DDCR_AHB_BURST_Pos     = 0x12     // Position of AHB_BURST field.
	VDEC_DDCR_AHB_BURST_Msk     = 0x40000  // Bit mask of AHB_BURST field.
	VDEC_DDCR_AHB_BURST         = 0x40000  // Bit AHB_BURST.
	VDEC_DDCR_DI_LE_Pos         = 0x15     // Position of DI_LE field.
	VDEC_DDCR_DI_LE_Msk         = 0x200000 // Bit mask of DI_LE field.
	VDEC_DDCR_DI_LE             = 0x200000 // Bit DI_LE.
	VDEC_DDCR_HTI_Pos           = 0x17     // Position of HTI field.
	VDEC_DDCR_HTI_Msk           = 0x800000 // Bit mask of HTI field.
	VDEC_DDCR_HTI               = 0x800000 // Bit HTI.

	// CTLR0: Decoder Control Register 0
	VDEC_CTLR0_HLOCK_Pos     = 0x8        // Position of HLOCK field.
	VDEC_CTLR0_HLOCK_Msk     = 0x100      // Bit mask of HLOCK field.
	VDEC_CTLR0_HLOCK         = 0x100      // Bit HLOCK.
	VDEC_CTLR0_REFFIRST_Pos  = 0xb        // Position of REFFIRST field.
	VDEC_CTLR0_REFFIRST_Msk  = 0x800      // Bit mask of REFFIRST field.
	VDEC_CTLR0_REFFIRST      = 0x800      // Bit REFFIRST.
	VDEC_CTLR0_MV_Pos        = 0xc        // Position of MV field.
	VDEC_CTLR0_MV_Msk        = 0x1000     // Bit mask of MV field.
	VDEC_CTLR0_MV            = 0x1000     // Bit MV.
	VDEC_CTLR0_QUANT_Pos     = 0xd        // Position of QUANT field.
	VDEC_CTLR0_QUANT_Msk     = 0x2000     // Bit mask of QUANT field.
	VDEC_CTLR0_QUANT         = 0x2000     // Bit QUANT.
	VDEC_CTLR0_FILTDIS_Pos   = 0xe        // Position of FILTDIS field.
	VDEC_CTLR0_FILTDIS_Msk   = 0x4000     // Bit mask of FILTDIS field.
	VDEC_CTLR0_FILTDIS       = 0x4000     // Bit FILTDIS.
	VDEC_CTLR0_OUTDIS_Pos    = 0xf        // Position of OUTDIS field.
	VDEC_CTLR0_OUTDIS_Msk    = 0x8000     // Bit mask of OUTDIS field.
	VDEC_CTLR0_OUTDIS        = 0x8000     // Bit OUTDIS.
	VDEC_CTLR0_REFFIELD_Pos  = 0x10       // Position of REFFIELD field.
	VDEC_CTLR0_REFFIELD_Msk  = 0x10000    // Bit mask of REFFIELD field.
	VDEC_CTLR0_REFFIELD      = 0x10000    // Bit REFFIELD.
	VDEC_CTLR0_FORWMODE_Pos  = 0x12       // Position of FORWMODE field.
	VDEC_CTLR0_FORWMODE_Msk  = 0x40000    // Bit mask of FORWMODE field.
	VDEC_CTLR0_FORWMODE      = 0x40000    // Bit FORWMODE.
	VDEC_CTLR0_PICFIELD_Pos  = 0x13       // Position of PICFIELD field.
	VDEC_CTLR0_PICFIELD_Msk  = 0x80000    // Bit mask of PICFIELD field.
	VDEC_CTLR0_PICFIELD      = 0x80000    // Bit PICFIELD.
	VDEC_CTLR0_PICTYPE_Pos   = 0x14       // Position of PICTYPE field.
	VDEC_CTLR0_PICTYPE_Msk   = 0x100000   // Bit mask of PICTYPE field.
	VDEC_CTLR0_PICTYPE       = 0x100000   // Bit PICTYPE.
	VDEC_CTLR0_PICBEN_Pos    = 0x15       // Position of PICBEN field.
	VDEC_CTLR0_PICBEN_Msk    = 0x200000   // Bit mask of PICBEN field.
	VDEC_CTLR0_PICBEN        = 0x200000   // Bit PICBEN.
	VDEC_CTLR0_PICSTRUCT_Pos = 0x16       // Position of PICSTRUCT field.
	VDEC_CTLR0_PICSTRUCT_Msk = 0x400000   // Bit mask of PICSTRUCT field.
	VDEC_CTLR0_PICSTRUCT     = 0x400000   // Bit PICSTRUCT.
	VDEC_CTLR0_PICMODE_Pos   = 0x17       // Position of PICMODE field.
	VDEC_CTLR0_PICMODE_Msk   = 0x800000   // Bit mask of PICMODE field.
	VDEC_CTLR0_PICMODE       = 0x800000   // Bit PICMODE.
	VDEC_CTLR0_RLCEN_Pos     = 0x1b       // Position of RLCEN field.
	VDEC_CTLR0_RLCEN_Msk     = 0x8000000  // Bit mask of RLCEN field.
	VDEC_CTLR0_RLCEN         = 0x8000000  // Bit RLCEN.
	VDEC_CTLR0_DEC_MODE_Pos  = 0x1c       // Position of DEC_MODE field.
	VDEC_CTLR0_DEC_MODE_Msk  = 0xf0000000 // Bit mask of DEC_MODE field.

	// CTLR1: Decoder Control Register 1
	VDEC_CTLR1_REF_FRAMES_Pos = 0x0        // Position of REF_FRAMES field.
	VDEC_CTLR1_REF_FRAMES_Msk = 0x1f       // Bit mask of REF_FRAMES field.
	VDEC_CTLR1_TOPF_Pos       = 0x5        // Position of TOPF field.
	VDEC_CTLR1_TOPF_Msk       = 0x20       // Bit mask of TOPF field.
	VDEC_CTLR1_TOPF           = 0x20       // Bit TOPF.
	VDEC_CTLR1_AVSM_Pos       = 0x6        // Position of AVSM field.
	VDEC_CTLR1_AVSM_Msk       = 0x40       // Bit mask of AVSM field.
	VDEC_CTLR1_AVSM           = 0x40       // Bit AVSM.
	VDEC_CTLR1_HEIGHT_OFF_Pos = 0x7        // Position of HEIGHT_OFF field.
	VDEC_CTLR1_HEIGHT_OFF_Msk = 0x780      // Bit mask of HEIGHT_OFF field.
	VDEC_CTLR1_PIC_HEIGHT_Pos = 0xb        // Position of PIC_HEIGHT field.
	VDEC_CTLR1_PIC_HEIGHT_Msk = 0x7f800    // Bit mask of PIC_HEIGHT field.
	VDEC_CTLR1_WIDTH_OFF_Pos  = 0x13       // Position of WIDTH_OFF field.
	VDEC_CTLR1_WIDTH_OFF_Msk  = 0x780000   // Bit mask of WIDTH_OFF field.
	VDEC_CTLR1_PIC_WIDTH_Pos  = 0x17       // Position of PIC_WIDTH field.
	VDEC_CTLR1_PIC_WIDTH_Msk  = 0xff800000 // Bit mask of PIC_WIDTH field.

	// CTLR2: Decoder Control Register 2
	VDEC_CTLR2_FIELDPIC_Pos         = 0x0        // Position of FIELDPIC field.
	VDEC_CTLR2_FIELDPIC_Msk         = 0x1        // Bit mask of FIELDPIC field.
	VDEC_CTLR2_FIELDPIC             = 0x1        // Bit FIELDPIC.
	VDEC_CTLR2_QP_FILT_CR_OFF_Pos   = 0xe        // Position of QP_FILT_CR_OFF field.
	VDEC_CTLR2_QP_FILT_CR_OFF_Msk   = 0x7c000    // Bit mask of QP_FILT_CR_OFF field.
	VDEC_CTLR2_QP_FILT_CB_OFF_Pos   = 0x13       // Position of QP_FILT_CB_OFF field.
	VDEC_CTLR2_QP_FILT_CB_OFF_Msk   = 0xf80000   // Bit mask of QP_FILT_CB_OFF field.
	VDEC_CTLR2_STREAM_START_BIT_Pos = 0x1a       // Position of STREAM_START_BIT field.
	VDEC_CTLR2_STREAM_START_BIT_Msk = 0xfc000000 // Bit mask of STREAM_START_BIT field.

	// CTLR3: Decoder Control Register 3
	VDEC_CTLR3_STREAM_LEN_Pos = 0x0        // Position of STREAM_LEN field.
	VDEC_CTLR3_STREAM_LEN_Msk = 0xffffff   // Bit mask of STREAM_LEN field.
	VDEC_CTLR3_INIT_QP_Pos    = 0x19       // Position of INIT_QP field.
	VDEC_CTLR3_INIT_QP_Msk    = 0x7e000000 // Bit mask of INIT_QP field.
	VDEC_CTLR3_ST_COD_EN_Pos  = 0x1f       // Position of ST_COD_EN field.
	VDEC_CTLR3_ST_COD_EN_Msk  = 0x80000000 // Bit mask of ST_COD_EN field.
	VDEC_CTLR3_ST_COD_EN      = 0x80000000 // Bit ST_COD_EN.

	// CTLR4: Decoder Control Register 4
	VDEC_CTLR4_FRAME_NUM_Pos     = 0x0        // Position of FRAME_NUM field.
	VDEC_CTLR4_FRAME_NUM_Msk     = 0xffff     // Bit mask of FRAME_NUM field.
	VDEC_CTLR4_FRAME_NUM_LEN_Pos = 0x10       // Position of FRAME_NUM_LEN field.
	VDEC_CTLR4_FRAME_NUM_LEN_Msk = 0x1f0000   // Bit mask of FRAME_NUM_LEN field.
	VDEC_CTLR4_W_BIPR_Pos        = 0x1a       // Position of W_BIPR field.
	VDEC_CTLR4_W_BIPR_Msk        = 0xc000000  // Bit mask of W_BIPR field.
	VDEC_CTLR4_W_PRED_Pos        = 0x1c       // Position of W_PRED field.
	VDEC_CTLR4_W_PRED_Msk        = 0x10000000 // Bit mask of W_PRED field.
	VDEC_CTLR4_W_PRED            = 0x10000000 // Bit W_PRED.
	VDEC_CTLR4_DIRMV_PRED_Pos    = 0x1d       // Position of DIRMV_PRED field.
	VDEC_CTLR4_DIRMV_PRED_Msk    = 0x20000000 // Bit mask of DIRMV_PRED field.
	VDEC_CTLR4_DIRMV_PRED        = 0x20000000 // Bit DIRMV_PRED.
	VDEC_CTLR4_BW_Pos            = 0x1e       // Position of BW field.
	VDEC_CTLR4_BW_Msk            = 0x40000000 // Bit mask of BW field.
	VDEC_CTLR4_BW                = 0x40000000 // Bit BW.
	VDEC_CTLR4_CABAC_Pos         = 0x1f       // Position of CABAC field.
	VDEC_CTLR4_CABAC_Msk         = 0x80000000 // Bit mask of CABAC field.
	VDEC_CTLR4_CABAC             = 0x80000000 // Bit CABAC.

	// CTLR5: Decoder Control Register 5
	VDEC_CTLR5_IDR_PIC_ID_Pos  = 0x0        // Position of IDR_PIC_ID field.
	VDEC_CTLR5_IDR_PIC_ID_Msk  = 0xffff     // Bit mask of IDR_PIC_ID field.
	VDEC_CTLR5_IDREN_Pos       = 0x10       // Position of IDREN field.
	VDEC_CTLR5_IDREN_Msk       = 0x10000    // Bit mask of IDREN field.
	VDEC_CTLR5_IDREN           = 0x10000    // Bit IDREN.
	VDEC_CTLR5_REF_PIC_LEN_Pos = 0x11       // Position of REF_PIC_LEN field.
	VDEC_CTLR5_REF_PIC_LEN_Msk = 0xffe0000  // Bit mask of REF_PIC_LEN field.
	VDEC_CTLR5_EIGHT58_Pos     = 0x1c       // Position of EIGHT58 field.
	VDEC_CTLR5_EIGHT58_Msk     = 0x10000000 // Bit mask of EIGHT58 field.
	VDEC_CTLR5_EIGHT58         = 0x10000000 // Bit EIGHT58.
	VDEC_CTLR5_RD_PIC_Pos      = 0x1d       // Position of RD_PIC field.
	VDEC_CTLR5_RD_PIC_Msk      = 0x20000000 // Bit mask of RD_PIC field.
	VDEC_CTLR5_RD_PIC          = 0x20000000 // Bit RD_PIC.
	VDEC_CTLR5_FILT_CTRL_Pos   = 0x1e       // Position of FILT_CTRL field.
	VDEC_CTLR5_FILT_CTRL_Msk   = 0x40000000 // Bit mask of FILT_CTRL field.
	VDEC_CTLR5_FILT_CTRL       = 0x40000000 // Bit FILT_CTRL.
	VDEC_CTLR5_CONS_INTRA_Pos  = 0x1f       // Position of CONS_INTRA field.
	VDEC_CTLR5_CONS_INTRA_Msk  = 0x80000000 // Bit mask of CONS_INTRA field.
	VDEC_CTLR5_CONS_INTRA      = 0x80000000 // Bit CONS_INTRA.

	// CTLR6: Decoder Control Register 6
	VDEC_CTLR6_POC_LEN_Pos  = 0x0        // Position of POC_LEN field.
	VDEC_CTLR6_POC_LEN_Msk  = 0xff       // Bit mask of POC_LEN field.
	VDEC_CTLR6_REF_IDX0_Pos = 0xe        // Position of REF_IDX0 field.
	VDEC_CTLR6_REF_IDX0_Msk = 0x7c000    // Bit mask of REF_IDX0 field.
	VDEC_CTLR6_REF_IDX1_Pos = 0x13       // Position of REF_IDX1 field.
	VDEC_CTLR6_REF_IDX1_Msk = 0xf80000   // Bit mask of REF_IDX1 field.
	VDEC_CTLR6_PPS_ID_Pos   = 0x18       // Position of PPS_ID field.
	VDEC_CTLR6_PPS_ID_Msk   = 0xff000000 // Bit mask of PPS_ID field.

	// DMVBA: Base Address for Differential Motion Vector
	VDEC_DMVBA_MV_CONTROL_BASE_Pos = 0x2        // Position of MV_CONTROL_BASE field.
	VDEC_DMVBA_MV_CONTROL_BASE_Msk = 0xfffffffc // Bit mask of MV_CONTROL_BASE field.

	// CTLR7: Decoder Control Register 7
	VDEC_CTLR7_BA_Pos = 0x2        // Position of BA field.
	VDEC_CTLR7_BA_Msk = 0xfffffffc // Bit mask of BA field.

	// RLCVLCBA: RLC/VLC Data Base Address
	VDEC_RLCVLCBA_BA_Pos = 0x2        // Position of BA field.
	VDEC_RLCVLCBA_BA_Msk = 0xfffffffc // Bit mask of BA field.

	// PICTBA: Decoded Picture Base Address
	VDEC_PICTBA_BA_Pos = 0x2        // Position of BA field.
	VDEC_PICTBA_BA_Msk = 0xfffffffc // Bit mask of BA field.

	// PIDXBA: Reference Picture Index 0 Base Address
	VDEC_PIDXBA_BA_Pos = 0x2        // Position of BA field.
	VDEC_PIDXBA_BA_Msk = 0xfffffffc // Bit mask of BA field.

	// PNR0: Reference Picture Numbers Register 0
	VDEC_PNR0_REFER0_Pos = 0x0        // Position of REFER0 field.
	VDEC_PNR0_REFER0_Msk = 0xffff     // Bit mask of REFER0 field.
	VDEC_PNR0_REFER1_Pos = 0x10       // Position of REFER1 field.
	VDEC_PNR0_REFER1_Msk = 0xffff0000 // Bit mask of REFER1 field.

	// PNR1: Reference Picture Numbers Register 1
	VDEC_PNR1_REFER2_Pos = 0x0        // Position of REFER2 field.
	VDEC_PNR1_REFER2_Msk = 0xffff     // Bit mask of REFER2 field.
	VDEC_PNR1_REFER3_Pos = 0x10       // Position of REFER3 field.
	VDEC_PNR1_REFER3_Msk = 0xffff0000 // Bit mask of REFER3 field.

	// PNR3: Reference Picture Numbers Register 3
	VDEC_PNR3_REFER4_Pos = 0x0        // Position of REFER4 field.
	VDEC_PNR3_REFER4_Msk = 0xffff     // Bit mask of REFER4 field.
	VDEC_PNR3_REFER5_Pos = 0x10       // Position of REFER5 field.
	VDEC_PNR3_REFER5_Msk = 0xffff0000 // Bit mask of REFER5 field.

	// PNR4: Reference Picture Numbers Register 4
	VDEC_PNR4_REFER8_Pos = 0x0        // Position of REFER8 field.
	VDEC_PNR4_REFER8_Msk = 0xffff     // Bit mask of REFER8 field.
	VDEC_PNR4_REFER9_Pos = 0x10       // Position of REFER9 field.
	VDEC_PNR4_REFER9_Msk = 0xffff0000 // Bit mask of REFER9 field.

	// PNR5: Reference Picture Numbers Register 5
	VDEC_PNR5_REFER10_Pos = 0x0        // Position of REFER10 field.
	VDEC_PNR5_REFER10_Msk = 0xffff     // Bit mask of REFER10 field.
	VDEC_PNR5_REFER11_Pos = 0x10       // Position of REFER11 field.
	VDEC_PNR5_REFER11_Msk = 0xffff0000 // Bit mask of REFER11 field.

	// PNR6: Reference Picture Numbers Register 6
	VDEC_PNR6_REFER12_Pos = 0x0        // Position of REFER12 field.
	VDEC_PNR6_REFER12_Msk = 0xffff     // Bit mask of REFER12 field.
	VDEC_PNR6_REFER13_Pos = 0x10       // Position of REFER13 field.
	VDEC_PNR6_REFER13_Msk = 0xffff0000 // Bit mask of REFER13 field.

	// PNR7: Reference Picture Numbers Register 7
	VDEC_PNR7_REFER14_Pos = 0x0        // Position of REFER14 field.
	VDEC_PNR7_REFER14_Msk = 0xffff     // Bit mask of REFER14 field.
	VDEC_PNR7_REFER15_Pos = 0x10       // Position of REFER15 field.
	VDEC_PNR7_REFER15_Msk = 0xffff0000 // Bit mask of REFER15 field.

	// PLTFR: Reference Picture Long Term Flag Register
	VDEC_PLTFR_LTF_Pos = 0x0        // Position of LTF field.
	VDEC_PLTFR_LTF_Msk = 0xffffffff // Bit mask of LTF field.

	// SDTBA: Standard Dependent Tables Base Address
	VDEC_SDTBA_BA_Pos = 0x2        // Position of BA field.
	VDEC_SDTBA_BA_Msk = 0xfffffffc // Bit mask of BA field.

	// DMMVBA: Direct Mode Motion Vector Base Address
	VDEC_DMMVBA_BA_Pos = 0x2        // Position of BA field.
	VDEC_DMMVBA_BA_Msk = 0xfffffffc // Bit mask of BA field.

	// IRPLR0: H264 Initial Reference Picture List Register 0
	VDEC_IRPLR0_IREFL_FW0_Pos = 0x0        // Position of IREFL_FW0 field.
	VDEC_IRPLR0_IREFL_FW0_Msk = 0x1f       // Bit mask of IREFL_FW0 field.
	VDEC_IRPLR0_IREFL_BW0_Pos = 0x5        // Position of IREFL_BW0 field.
	VDEC_IRPLR0_IREFL_BW0_Msk = 0x3e0      // Bit mask of IREFL_BW0 field.
	VDEC_IRPLR0_IREFL_FW1_Pos = 0xa        // Position of IREFL_FW1 field.
	VDEC_IRPLR0_IREFL_FW1_Msk = 0x7c00     // Bit mask of IREFL_FW1 field.
	VDEC_IRPLR0_IREFL_BW1_Pos = 0xf        // Position of IREFL_BW1 field.
	VDEC_IRPLR0_IREFL_BW1_Msk = 0xf8000    // Bit mask of IREFL_BW1 field.
	VDEC_IRPLR0_IREFL_FW2_Pos = 0x14       // Position of IREFL_FW2 field.
	VDEC_IRPLR0_IREFL_FW2_Msk = 0x1f00000  // Bit mask of IREFL_FW2 field.
	VDEC_IRPLR0_IREFL_BW2_Pos = 0x19       // Position of IREFL_BW2 field.
	VDEC_IRPLR0_IREFL_BW2_Msk = 0x3e000000 // Bit mask of IREFL_BW2 field.

	// IRPLR1: H264 Initial Reference Picture List Register 1
	VDEC_IRPLR1_IREFL_FW3_Pos = 0x0        // Position of IREFL_FW3 field.
	VDEC_IRPLR1_IREFL_FW3_Msk = 0x1f       // Bit mask of IREFL_FW3 field.
	VDEC_IRPLR1_IREFL_BW3_Pos = 0x5        // Position of IREFL_BW3 field.
	VDEC_IRPLR1_IREFL_BW3_Msk = 0x3e0      // Bit mask of IREFL_BW3 field.
	VDEC_IRPLR1_IREFL_FW4_Pos = 0xa        // Position of IREFL_FW4 field.
	VDEC_IRPLR1_IREFL_FW4_Msk = 0x7c00     // Bit mask of IREFL_FW4 field.
	VDEC_IRPLR1_IREFL_BW4_Pos = 0xf        // Position of IREFL_BW4 field.
	VDEC_IRPLR1_IREFL_BW4_Msk = 0xf8000    // Bit mask of IREFL_BW4 field.
	VDEC_IRPLR1_IREFL_FW5_Pos = 0x14       // Position of IREFL_FW5 field.
	VDEC_IRPLR1_IREFL_FW5_Msk = 0x1f00000  // Bit mask of IREFL_FW5 field.
	VDEC_IRPLR1_IREFL_BW5_Pos = 0x19       // Position of IREFL_BW5 field.
	VDEC_IRPLR1_IREFL_BW5_Msk = 0x3e000000 // Bit mask of IREFL_BW5 field.

	// IRPLR2: H264 Initial Reference Picture List Register 2
	VDEC_IRPLR2_IREFL_FW6_Pos = 0x0        // Position of IREFL_FW6 field.
	VDEC_IRPLR2_IREFL_FW6_Msk = 0x1f       // Bit mask of IREFL_FW6 field.
	VDEC_IRPLR2_IREFL_BW6_Pos = 0x5        // Position of IREFL_BW6 field.
	VDEC_IRPLR2_IREFL_BW6_Msk = 0x3e0      // Bit mask of IREFL_BW6 field.
	VDEC_IRPLR2_IREFL_FW7_Pos = 0xa        // Position of IREFL_FW7 field.
	VDEC_IRPLR2_IREFL_FW7_Msk = 0x7c00     // Bit mask of IREFL_FW7 field.
	VDEC_IRPLR2_IREFL_BW7_Pos = 0xf        // Position of IREFL_BW7 field.
	VDEC_IRPLR2_IREFL_BW7_Msk = 0xf8000    // Bit mask of IREFL_BW7 field.
	VDEC_IRPLR2_IREFL_FW8_Pos = 0x14       // Position of IREFL_FW8 field.
	VDEC_IRPLR2_IREFL_FW8_Msk = 0x1f00000  // Bit mask of IREFL_FW8 field.
	VDEC_IRPLR2_IREFL_BW8_Pos = 0x19       // Position of IREFL_BW8 field.
	VDEC_IRPLR2_IREFL_BW8_Msk = 0x3e000000 // Bit mask of IREFL_BW8 field.

	// IRPLR3: H264 Initial Reference Picture List Register 3
	VDEC_IRPLR3_IREFL_FW9_Pos  = 0x0        // Position of IREFL_FW9 field.
	VDEC_IRPLR3_IREFL_FW9_Msk  = 0x1f       // Bit mask of IREFL_FW9 field.
	VDEC_IRPLR3_IREFL_BW9_Pos  = 0x5        // Position of IREFL_BW9 field.
	VDEC_IRPLR3_IREFL_BW9_Msk  = 0x3e0      // Bit mask of IREFL_BW9 field.
	VDEC_IRPLR3_IREFL_FW10_Pos = 0xa        // Position of IREFL_FW10 field.
	VDEC_IRPLR3_IREFL_FW10_Msk = 0x7c00     // Bit mask of IREFL_FW10 field.
	VDEC_IRPLR3_IREFL_BW10_Pos = 0xf        // Position of IREFL_BW10 field.
	VDEC_IRPLR3_IREFL_BW10_Msk = 0xf8000    // Bit mask of IREFL_BW10 field.
	VDEC_IRPLR3_IREFL_FW11_Pos = 0x14       // Position of IREFL_FW11 field.
	VDEC_IRPLR3_IREFL_FW11_Msk = 0x1f00000  // Bit mask of IREFL_FW11 field.
	VDEC_IRPLR3_IREFL_BW11_Pos = 0x19       // Position of IREFL_BW11 field.
	VDEC_IRPLR3_IREFL_BW11_Msk = 0x3e000000 // Bit mask of IREFL_BW11 field.

	// IRPLR4: H264 Initial Reference Picture List Register 4
	VDEC_IRPLR4_IREFL_FW12_Pos = 0x0        // Position of IREFL_FW12 field.
	VDEC_IRPLR4_IREFL_FW12_Msk = 0x1f       // Bit mask of IREFL_FW12 field.
	VDEC_IRPLR4_IREFL_BW12_Pos = 0x5        // Position of IREFL_BW12 field.
	VDEC_IRPLR4_IREFL_BW12_Msk = 0x3e0      // Bit mask of IREFL_BW12 field.
	VDEC_IRPLR4_IREFL_FW13_Pos = 0xa        // Position of IREFL_FW13 field.
	VDEC_IRPLR4_IREFL_FW13_Msk = 0x7c00     // Bit mask of IREFL_FW13 field.
	VDEC_IRPLR4_IREFL_BW13_Pos = 0xf        // Position of IREFL_BW13 field.
	VDEC_IRPLR4_IREFL_BW13_Msk = 0xf8000    // Bit mask of IREFL_BW13 field.
	VDEC_IRPLR4_IREFL_FW14_Pos = 0x14       // Position of IREFL_FW14 field.
	VDEC_IRPLR4_IREFL_FW14_Msk = 0x1f00000  // Bit mask of IREFL_FW14 field.
	VDEC_IRPLR4_IREFL_BW14_Pos = 0x19       // Position of IREFL_BW14 field.
	VDEC_IRPLR4_IREFL_BW14_Msk = 0x3e000000 // Bit mask of IREFL_BW14 field.

	// IRPLR5: H264 Initial Reference Picture List Register 5
	VDEC_IRPLR5_IREFL_FW15_Pos = 0x0   // Position of IREFL_FW15 field.
	VDEC_IRPLR5_IREFL_FW15_Msk = 0x1f  // Bit mask of IREFL_FW15 field.
	VDEC_IRPLR5_IREFL_BW15_Pos = 0x5   // Position of IREFL_BW15 field.
	VDEC_IRPLR5_IREFL_BW15_Msk = 0x3e0 // Bit mask of IREFL_BW15 field.

	// ECR: Error Concealment Register
	VDEC_ECR_STARTMB_Y_Pos = 0xf        // Position of STARTMB_Y field.
	VDEC_ECR_STARTMB_Y_Msk = 0x7f8000   // Bit mask of STARTMB_Y field.
	VDEC_ECR_STARTMB_X_Pos = 0x17       // Position of STARTMB_X field.
	VDEC_ECR_STARTMB_X_Msk = 0xff800000 // Bit mask of STARTMB_X field.
)

// Bitfields for UDPHS: USB High Speed Device Port
const (
	// CTRL: UDPHS Control Register
	UDPHS_CTRL_DEV_ADDR_Pos  = 0x0   // Position of DEV_ADDR field.
	UDPHS_CTRL_DEV_ADDR_Msk  = 0x7f  // Bit mask of DEV_ADDR field.
	UDPHS_CTRL_FADDR_EN_Pos  = 0x7   // Position of FADDR_EN field.
	UDPHS_CTRL_FADDR_EN_Msk  = 0x80  // Bit mask of FADDR_EN field.
	UDPHS_CTRL_FADDR_EN      = 0x80  // Bit FADDR_EN.
	UDPHS_CTRL_EN_UDPHS_Pos  = 0x8   // Position of EN_UDPHS field.
	UDPHS_CTRL_EN_UDPHS_Msk  = 0x100 // Bit mask of EN_UDPHS field.
	UDPHS_CTRL_EN_UDPHS      = 0x100 // Bit EN_UDPHS.
	UDPHS_CTRL_DETACH_Pos    = 0x9   // Position of DETACH field.
	UDPHS_CTRL_DETACH_Msk    = 0x200 // Bit mask of DETACH field.
	UDPHS_CTRL_DETACH        = 0x200 // Bit DETACH.
	UDPHS_CTRL_REWAKEUP_Pos  = 0xa   // Position of REWAKEUP field.
	UDPHS_CTRL_REWAKEUP_Msk  = 0x400 // Bit mask of REWAKEUP field.
	UDPHS_CTRL_REWAKEUP      = 0x400 // Bit REWAKEUP.
	UDPHS_CTRL_PULLD_DIS_Pos = 0xb   // Position of PULLD_DIS field.
	UDPHS_CTRL_PULLD_DIS_Msk = 0x800 // Bit mask of PULLD_DIS field.
	UDPHS_CTRL_PULLD_DIS     = 0x800 // Bit PULLD_DIS.

	// FNUM: UDPHS Frame Number Register
	UDPHS_FNUM_MICRO_FRAME_NUM_Pos = 0x0        // Position of MICRO_FRAME_NUM field.
	UDPHS_FNUM_MICRO_FRAME_NUM_Msk = 0x7        // Bit mask of MICRO_FRAME_NUM field.
	UDPHS_FNUM_FRAME_NUMBER_Pos    = 0x3        // Position of FRAME_NUMBER field.
	UDPHS_FNUM_FRAME_NUMBER_Msk    = 0x3ff8     // Bit mask of FRAME_NUMBER field.
	UDPHS_FNUM_FNUM_ERR_Pos        = 0x1f       // Position of FNUM_ERR field.
	UDPHS_FNUM_FNUM_ERR_Msk        = 0x80000000 // Bit mask of FNUM_ERR field.
	UDPHS_FNUM_FNUM_ERR            = 0x80000000 // Bit FNUM_ERR.

	// IEN: UDPHS Interrupt Enable Register
	UDPHS_IEN_DET_SUSPD_Pos = 0x1        // Position of DET_SUSPD field.
	UDPHS_IEN_DET_SUSPD_Msk = 0x2        // Bit mask of DET_SUSPD field.
	UDPHS_IEN_DET_SUSPD     = 0x2        // Bit DET_SUSPD.
	UDPHS_IEN_MICRO_SOF_Pos = 0x2        // Position of MICRO_SOF field.
	UDPHS_IEN_MICRO_SOF_Msk = 0x4        // Bit mask of MICRO_SOF field.
	UDPHS_IEN_MICRO_SOF     = 0x4        // Bit MICRO_SOF.
	UDPHS_IEN_INT_SOF_Pos   = 0x3        // Position of INT_SOF field.
	UDPHS_IEN_INT_SOF_Msk   = 0x8        // Bit mask of INT_SOF field.
	UDPHS_IEN_INT_SOF       = 0x8        // Bit INT_SOF.
	UDPHS_IEN_ENDRESET_Pos  = 0x4        // Position of ENDRESET field.
	UDPHS_IEN_ENDRESET_Msk  = 0x10       // Bit mask of ENDRESET field.
	UDPHS_IEN_ENDRESET      = 0x10       // Bit ENDRESET.
	UDPHS_IEN_WAKE_UP_Pos   = 0x5        // Position of WAKE_UP field.
	UDPHS_IEN_WAKE_UP_Msk   = 0x20       // Bit mask of WAKE_UP field.
	UDPHS_IEN_WAKE_UP       = 0x20       // Bit WAKE_UP.
	UDPHS_IEN_ENDOFRSM_Pos  = 0x6        // Position of ENDOFRSM field.
	UDPHS_IEN_ENDOFRSM_Msk  = 0x40       // Bit mask of ENDOFRSM field.
	UDPHS_IEN_ENDOFRSM      = 0x40       // Bit ENDOFRSM.
	UDPHS_IEN_UPSTR_RES_Pos = 0x7        // Position of UPSTR_RES field.
	UDPHS_IEN_UPSTR_RES_Msk = 0x80       // Bit mask of UPSTR_RES field.
	UDPHS_IEN_UPSTR_RES     = 0x80       // Bit UPSTR_RES.
	UDPHS_IEN_EPT_0_Pos     = 0x8        // Position of EPT_0 field.
	UDPHS_IEN_EPT_0_Msk     = 0x100      // Bit mask of EPT_0 field.
	UDPHS_IEN_EPT_0         = 0x100      // Bit EPT_0.
	UDPHS_IEN_EPT_1_Pos     = 0x9        // Position of EPT_1 field.
	UDPHS_IEN_EPT_1_Msk     = 0x200      // Bit mask of EPT_1 field.
	UDPHS_IEN_EPT_1         = 0x200      // Bit EPT_1.
	UDPHS_IEN_EPT_2_Pos     = 0xa        // Position of EPT_2 field.
	UDPHS_IEN_EPT_2_Msk     = 0x400      // Bit mask of EPT_2 field.
	UDPHS_IEN_EPT_2         = 0x400      // Bit EPT_2.
	UDPHS_IEN_EPT_3_Pos     = 0xb        // Position of EPT_3 field.
	UDPHS_IEN_EPT_3_Msk     = 0x800      // Bit mask of EPT_3 field.
	UDPHS_IEN_EPT_3         = 0x800      // Bit EPT_3.
	UDPHS_IEN_EPT_4_Pos     = 0xc        // Position of EPT_4 field.
	UDPHS_IEN_EPT_4_Msk     = 0x1000     // Bit mask of EPT_4 field.
	UDPHS_IEN_EPT_4         = 0x1000     // Bit EPT_4.
	UDPHS_IEN_EPT_5_Pos     = 0xd        // Position of EPT_5 field.
	UDPHS_IEN_EPT_5_Msk     = 0x2000     // Bit mask of EPT_5 field.
	UDPHS_IEN_EPT_5         = 0x2000     // Bit EPT_5.
	UDPHS_IEN_EPT_6_Pos     = 0xe        // Position of EPT_6 field.
	UDPHS_IEN_EPT_6_Msk     = 0x4000     // Bit mask of EPT_6 field.
	UDPHS_IEN_EPT_6         = 0x4000     // Bit EPT_6.
	UDPHS_IEN_DMA_1_Pos     = 0x19       // Position of DMA_1 field.
	UDPHS_IEN_DMA_1_Msk     = 0x2000000  // Bit mask of DMA_1 field.
	UDPHS_IEN_DMA_1         = 0x2000000  // Bit DMA_1.
	UDPHS_IEN_DMA_2_Pos     = 0x1a       // Position of DMA_2 field.
	UDPHS_IEN_DMA_2_Msk     = 0x4000000  // Bit mask of DMA_2 field.
	UDPHS_IEN_DMA_2         = 0x4000000  // Bit DMA_2.
	UDPHS_IEN_DMA_3_Pos     = 0x1b       // Position of DMA_3 field.
	UDPHS_IEN_DMA_3_Msk     = 0x8000000  // Bit mask of DMA_3 field.
	UDPHS_IEN_DMA_3         = 0x8000000  // Bit DMA_3.
	UDPHS_IEN_DMA_4_Pos     = 0x1c       // Position of DMA_4 field.
	UDPHS_IEN_DMA_4_Msk     = 0x10000000 // Bit mask of DMA_4 field.
	UDPHS_IEN_DMA_4         = 0x10000000 // Bit DMA_4.
	UDPHS_IEN_DMA_5_Pos     = 0x1d       // Position of DMA_5 field.
	UDPHS_IEN_DMA_5_Msk     = 0x20000000 // Bit mask of DMA_5 field.
	UDPHS_IEN_DMA_5         = 0x20000000 // Bit DMA_5.
	UDPHS_IEN_DMA_6_Pos     = 0x1e       // Position of DMA_6 field.
	UDPHS_IEN_DMA_6_Msk     = 0x40000000 // Bit mask of DMA_6 field.
	UDPHS_IEN_DMA_6         = 0x40000000 // Bit DMA_6.

	// INTSTA: UDPHS Interrupt Status Register
	UDPHS_INTSTA_SPEED_Pos     = 0x0        // Position of SPEED field.
	UDPHS_INTSTA_SPEED_Msk     = 0x1        // Bit mask of SPEED field.
	UDPHS_INTSTA_SPEED         = 0x1        // Bit SPEED.
	UDPHS_INTSTA_DET_SUSPD_Pos = 0x1        // Position of DET_SUSPD field.
	UDPHS_INTSTA_DET_SUSPD_Msk = 0x2        // Bit mask of DET_SUSPD field.
	UDPHS_INTSTA_DET_SUSPD     = 0x2        // Bit DET_SUSPD.
	UDPHS_INTSTA_MICRO_SOF_Pos = 0x2        // Position of MICRO_SOF field.
	UDPHS_INTSTA_MICRO_SOF_Msk = 0x4        // Bit mask of MICRO_SOF field.
	UDPHS_INTSTA_MICRO_SOF     = 0x4        // Bit MICRO_SOF.
	UDPHS_INTSTA_INT_SOF_Pos   = 0x3        // Position of INT_SOF field.
	UDPHS_INTSTA_INT_SOF_Msk   = 0x8        // Bit mask of INT_SOF field.
	UDPHS_INTSTA_INT_SOF       = 0x8        // Bit INT_SOF.
	UDPHS_INTSTA_ENDRESET_Pos  = 0x4        // Position of ENDRESET field.
	UDPHS_INTSTA_ENDRESET_Msk  = 0x10       // Bit mask of ENDRESET field.
	UDPHS_INTSTA_ENDRESET      = 0x10       // Bit ENDRESET.
	UDPHS_INTSTA_WAKE_UP_Pos   = 0x5        // Position of WAKE_UP field.
	UDPHS_INTSTA_WAKE_UP_Msk   = 0x20       // Bit mask of WAKE_UP field.
	UDPHS_INTSTA_WAKE_UP       = 0x20       // Bit WAKE_UP.
	UDPHS_INTSTA_ENDOFRSM_Pos  = 0x6        // Position of ENDOFRSM field.
	UDPHS_INTSTA_ENDOFRSM_Msk  = 0x40       // Bit mask of ENDOFRSM field.
	UDPHS_INTSTA_ENDOFRSM      = 0x40       // Bit ENDOFRSM.
	UDPHS_INTSTA_UPSTR_RES_Pos = 0x7        // Position of UPSTR_RES field.
	UDPHS_INTSTA_UPSTR_RES_Msk = 0x80       // Bit mask of UPSTR_RES field.
	UDPHS_INTSTA_UPSTR_RES     = 0x80       // Bit UPSTR_RES.
	UDPHS_INTSTA_EPT_0_Pos     = 0x8        // Position of EPT_0 field.
	UDPHS_INTSTA_EPT_0_Msk     = 0x100      // Bit mask of EPT_0 field.
	UDPHS_INTSTA_EPT_0         = 0x100      // Bit EPT_0.
	UDPHS_INTSTA_EPT_1_Pos     = 0x9        // Position of EPT_1 field.
	UDPHS_INTSTA_EPT_1_Msk     = 0x200      // Bit mask of EPT_1 field.
	UDPHS_INTSTA_EPT_1         = 0x200      // Bit EPT_1.
	UDPHS_INTSTA_EPT_2_Pos     = 0xa        // Position of EPT_2 field.
	UDPHS_INTSTA_EPT_2_Msk     = 0x400      // Bit mask of EPT_2 field.
	UDPHS_INTSTA_EPT_2         = 0x400      // Bit EPT_2.
	UDPHS_INTSTA_EPT_3_Pos     = 0xb        // Position of EPT_3 field.
	UDPHS_INTSTA_EPT_3_Msk     = 0x800      // Bit mask of EPT_3 field.
	UDPHS_INTSTA_EPT_3         = 0x800      // Bit EPT_3.
	UDPHS_INTSTA_EPT_4_Pos     = 0xc        // Position of EPT_4 field.
	UDPHS_INTSTA_EPT_4_Msk     = 0x1000     // Bit mask of EPT_4 field.
	UDPHS_INTSTA_EPT_4         = 0x1000     // Bit EPT_4.
	UDPHS_INTSTA_EPT_5_Pos     = 0xd        // Position of EPT_5 field.
	UDPHS_INTSTA_EPT_5_Msk     = 0x2000     // Bit mask of EPT_5 field.
	UDPHS_INTSTA_EPT_5         = 0x2000     // Bit EPT_5.
	UDPHS_INTSTA_EPT_6_Pos     = 0xe        // Position of EPT_6 field.
	UDPHS_INTSTA_EPT_6_Msk     = 0x4000     // Bit mask of EPT_6 field.
	UDPHS_INTSTA_EPT_6         = 0x4000     // Bit EPT_6.
	UDPHS_INTSTA_DMA_1_Pos     = 0x19       // Position of DMA_1 field.
	UDPHS_INTSTA_DMA_1_Msk     = 0x2000000  // Bit mask of DMA_1 field.
	UDPHS_INTSTA_DMA_1         = 0x2000000  // Bit DMA_1.
	UDPHS_INTSTA_DMA_2_Pos     = 0x1a       // Position of DMA_2 field.
	UDPHS_INTSTA_DMA_2_Msk     = 0x4000000  // Bit mask of DMA_2 field.
	UDPHS_INTSTA_DMA_2         = 0x4000000  // Bit DMA_2.
	UDPHS_INTSTA_DMA_3_Pos     = 0x1b       // Position of DMA_3 field.
	UDPHS_INTSTA_DMA_3_Msk     = 0x8000000  // Bit mask of DMA_3 field.
	UDPHS_INTSTA_DMA_3         = 0x8000000  // Bit DMA_3.
	UDPHS_INTSTA_DMA_4_Pos     = 0x1c       // Position of DMA_4 field.
	UDPHS_INTSTA_DMA_4_Msk     = 0x10000000 // Bit mask of DMA_4 field.
	UDPHS_INTSTA_DMA_4         = 0x10000000 // Bit DMA_4.
	UDPHS_INTSTA_DMA_5_Pos     = 0x1d       // Position of DMA_5 field.
	UDPHS_INTSTA_DMA_5_Msk     = 0x20000000 // Bit mask of DMA_5 field.
	UDPHS_INTSTA_DMA_5         = 0x20000000 // Bit DMA_5.
	UDPHS_INTSTA_DMA_6_Pos     = 0x1e       // Position of DMA_6 field.
	UDPHS_INTSTA_DMA_6_Msk     = 0x40000000 // Bit mask of DMA_6 field.
	UDPHS_INTSTA_DMA_6         = 0x40000000 // Bit DMA_6.

	// CLRINT: UDPHS Clear Interrupt Register
	UDPHS_CLRINT_DET_SUSPD_Pos = 0x1  // Position of DET_SUSPD field.
	UDPHS_CLRINT_DET_SUSPD_Msk = 0x2  // Bit mask of DET_SUSPD field.
	UDPHS_CLRINT_DET_SUSPD     = 0x2  // Bit DET_SUSPD.
	UDPHS_CLRINT_MICRO_SOF_Pos = 0x2  // Position of MICRO_SOF field.
	UDPHS_CLRINT_MICRO_SOF_Msk = 0x4  // Bit mask of MICRO_SOF field.
	UDPHS_CLRINT_MICRO_SOF     = 0x4  // Bit MICRO_SOF.
	UDPHS_CLRINT_INT_SOF_Pos   = 0x3  // Position of INT_SOF field.
	UDPHS_CLRINT_INT_SOF_Msk   = 0x8  // Bit mask of INT_SOF field.
	UDPHS_CLRINT_INT_SOF       = 0x8  // Bit INT_SOF.
	UDPHS_CLRINT_ENDRESET_Pos  = 0x4  // Position of ENDRESET field.
	UDPHS_CLRINT_ENDRESET_Msk  = 0x10 // Bit mask of ENDRESET field.
	UDPHS_CLRINT_ENDRESET      = 0x10 // Bit ENDRESET.
	UDPHS_CLRINT_WAKE_UP_Pos   = 0x5  // Position of WAKE_UP field.
	UDPHS_CLRINT_WAKE_UP_Msk   = 0x20 // Bit mask of WAKE_UP field.
	UDPHS_CLRINT_WAKE_UP       = 0x20 // Bit WAKE_UP.
	UDPHS_CLRINT_ENDOFRSM_Pos  = 0x6  // Position of ENDOFRSM field.
	UDPHS_CLRINT_ENDOFRSM_Msk  = 0x40 // Bit mask of ENDOFRSM field.
	UDPHS_CLRINT_ENDOFRSM      = 0x40 // Bit ENDOFRSM.
	UDPHS_CLRINT_UPSTR_RES_Pos = 0x7  // Position of UPSTR_RES field.
	UDPHS_CLRINT_UPSTR_RES_Msk = 0x80 // Bit mask of UPSTR_RES field.
	UDPHS_CLRINT_UPSTR_RES     = 0x80 // Bit UPSTR_RES.

	// EPTRST: UDPHS Endpoints Reset Register
	UDPHS_EPTRST_EPT_0_Pos = 0x0  // Position of EPT_0 field.
	UDPHS_EPTRST_EPT_0_Msk = 0x1  // Bit mask of EPT_0 field.
	UDPHS_EPTRST_EPT_0     = 0x1  // Bit EPT_0.
	UDPHS_EPTRST_EPT_1_Pos = 0x1  // Position of EPT_1 field.
	UDPHS_EPTRST_EPT_1_Msk = 0x2  // Bit mask of EPT_1 field.
	UDPHS_EPTRST_EPT_1     = 0x2  // Bit EPT_1.
	UDPHS_EPTRST_EPT_2_Pos = 0x2  // Position of EPT_2 field.
	UDPHS_EPTRST_EPT_2_Msk = 0x4  // Bit mask of EPT_2 field.
	UDPHS_EPTRST_EPT_2     = 0x4  // Bit EPT_2.
	UDPHS_EPTRST_EPT_3_Pos = 0x3  // Position of EPT_3 field.
	UDPHS_EPTRST_EPT_3_Msk = 0x8  // Bit mask of EPT_3 field.
	UDPHS_EPTRST_EPT_3     = 0x8  // Bit EPT_3.
	UDPHS_EPTRST_EPT_4_Pos = 0x4  // Position of EPT_4 field.
	UDPHS_EPTRST_EPT_4_Msk = 0x10 // Bit mask of EPT_4 field.
	UDPHS_EPTRST_EPT_4     = 0x10 // Bit EPT_4.
	UDPHS_EPTRST_EPT_5_Pos = 0x5  // Position of EPT_5 field.
	UDPHS_EPTRST_EPT_5_Msk = 0x20 // Bit mask of EPT_5 field.
	UDPHS_EPTRST_EPT_5     = 0x20 // Bit EPT_5.
	UDPHS_EPTRST_EPT_6_Pos = 0x6  // Position of EPT_6 field.
	UDPHS_EPTRST_EPT_6_Msk = 0x40 // Bit mask of EPT_6 field.
	UDPHS_EPTRST_EPT_6     = 0x40 // Bit EPT_6.

	// TST: UDPHS Test Register
	UDPHS_TST_SPEED_CFG_Pos        = 0x0  // Position of SPEED_CFG field.
	UDPHS_TST_SPEED_CFG_Msk        = 0x3  // Bit mask of SPEED_CFG field.
	UDPHS_TST_SPEED_CFG_NORMAL     = 0x0  // Normal Mode: The macro is in Full Speed mode, ready to make a High Speed identification, if the host supports it and then to automatically switch to High Speed mode
	UDPHS_TST_SPEED_CFG_HIGH_SPEED = 0x2  // Force High Speed: Set this value to force the hardware to work in High Speed mode. Only for debug or test purpose.
	UDPHS_TST_SPEED_CFG_FULL_SPEED = 0x3  // Force Full Speed: Set this value to force the hardware to work only in Full Speed mode. In this configuration, the macro will not respond to a High Speed reset handshake.
	UDPHS_TST_TST_J_Pos            = 0x2  // Position of TST_J field.
	UDPHS_TST_TST_J_Msk            = 0x4  // Bit mask of TST_J field.
	UDPHS_TST_TST_J                = 0x4  // Bit TST_J.
	UDPHS_TST_TST_K_Pos            = 0x3  // Position of TST_K field.
	UDPHS_TST_TST_K_Msk            = 0x8  // Bit mask of TST_K field.
	UDPHS_TST_TST_K                = 0x8  // Bit TST_K.
	UDPHS_TST_TST_PKT_Pos          = 0x4  // Position of TST_PKT field.
	UDPHS_TST_TST_PKT_Msk          = 0x10 // Bit mask of TST_PKT field.
	UDPHS_TST_TST_PKT              = 0x10 // Bit TST_PKT.
	UDPHS_TST_OPMODE2_Pos          = 0x5  // Position of OPMODE2 field.
	UDPHS_TST_OPMODE2_Msk          = 0x20 // Bit mask of OPMODE2 field.
	UDPHS_TST_OPMODE2              = 0x20 // Bit OPMODE2.

	// EPTCFG0: UDPHS Endpoint Configuration Register (endpoint = 0)
	UDPHS_EPTCFG0_EPT_SIZE_Pos   = 0x0        // Position of EPT_SIZE field.
	UDPHS_EPTCFG0_EPT_SIZE_Msk   = 0x7        // Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG0_EPT_SIZE_8     = 0x0        // 8 bytes
	UDPHS_EPTCFG0_EPT_SIZE_16    = 0x1        // 16 bytes
	UDPHS_EPTCFG0_EPT_SIZE_32    = 0x2        // 32 bytes
	UDPHS_EPTCFG0_EPT_SIZE_64    = 0x3        // 64 bytes
	UDPHS_EPTCFG0_EPT_SIZE_128   = 0x4        // 128 bytes
	UDPHS_EPTCFG0_EPT_SIZE_256   = 0x5        // 256 bytes
	UDPHS_EPTCFG0_EPT_SIZE_512   = 0x6        // 512 bytes
	UDPHS_EPTCFG0_EPT_SIZE_1024  = 0x7        // 1024 bytes
	UDPHS_EPTCFG0_EPT_DIR_Pos    = 0x3        // Position of EPT_DIR field.
	UDPHS_EPTCFG0_EPT_DIR_Msk    = 0x8        // Bit mask of EPT_DIR field.
	UDPHS_EPTCFG0_EPT_DIR        = 0x8        // Bit EPT_DIR.
	UDPHS_EPTCFG0_EPT_TYPE_Pos   = 0x4        // Position of EPT_TYPE field.
	UDPHS_EPTCFG0_EPT_TYPE_Msk   = 0x30       // Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG0_EPT_TYPE_CTRL8 = 0x0        // Control endpoint
	UDPHS_EPTCFG0_EPT_TYPE_ISO   = 0x1        // Isochronous endpoint
	UDPHS_EPTCFG0_EPT_TYPE_BULK  = 0x2        // Bulk endpoint
	UDPHS_EPTCFG0_EPT_TYPE_INT   = 0x3        // Interrupt endpoint
	UDPHS_EPTCFG0_BK_NUMBER_Pos  = 0x6        // Position of BK_NUMBER field.
	UDPHS_EPTCFG0_BK_NUMBER_Msk  = 0xc0       // Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG0_BK_NUMBER_0    = 0x0        // Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG0_BK_NUMBER_1    = 0x1        // One bank (bank 0)
	UDPHS_EPTCFG0_BK_NUMBER_2    = 0x2        // Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG0_BK_NUMBER_3    = 0x3        // Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG0_NB_TRANS_Pos   = 0x8        // Position of NB_TRANS field.
	UDPHS_EPTCFG0_NB_TRANS_Msk   = 0x300      // Bit mask of NB_TRANS field.
	UDPHS_EPTCFG0_EPT_MAPD_Pos   = 0x1f       // Position of EPT_MAPD field.
	UDPHS_EPTCFG0_EPT_MAPD_Msk   = 0x80000000 // Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG0_EPT_MAPD       = 0x80000000 // Bit EPT_MAPD.

	// EPTCTLENB0: UDPHS Endpoint Control Enable Register (endpoint = 0)
	UDPHS_EPTCTLENB0_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB0_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB0_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB0_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB0_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB0_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB0_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB0_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB0_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB0_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLENB0_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB0_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLENB0_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB0_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB0_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB0_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB0_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB0_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB0_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB0_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB0_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB0_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLENB0_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLENB0_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLENB0_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLENB0_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB0_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLENB0_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLENB0_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB0_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLENB0_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLENB0_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB0_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLENB0_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLENB0_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB0_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLENB0_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB0_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB0_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB0_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB0_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB0_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLENB0_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 0)
	UDPHS_EPTCTLENB0_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB0_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB0_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB0_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB0_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB0_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB0_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB0_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB0_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB0_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLENB0_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB0_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLENB0_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLENB0_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB0_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB0_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB0_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB0_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB0_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB0_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB0_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB0_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB0_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB0_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB0_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLENB0_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB0_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB0_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB0_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB0_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB0_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS0: UDPHS Endpoint Control Disable Register (endpoint = 0)
	UDPHS_EPTCTLDIS0_EPT_DISABL_Pos = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS0_EPT_DISABL_Msk = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS0_EPT_DISABL     = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS0_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS0_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS0_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS0_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS0_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS0_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS0_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLDIS0_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS0_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLDIS0_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS0_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS0_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS0_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS0_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS0_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS0_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS0_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS0_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS0_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLDIS0_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS0_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLDIS0_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLDIS0_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS0_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLDIS0_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLDIS0_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS0_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLDIS0_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLDIS0_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS0_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLDIS0_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLDIS0_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS0_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLDIS0_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS0_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS0_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS0_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS0_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS0_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS0_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 0)
	UDPHS_EPTCTLDIS0_ISOENDPT_EPT_DISABL_Pos  = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS0_ISOENDPT_EPT_DISABL_Msk  = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS0_ISOENDPT_EPT_DISABL      = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS0_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS0_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS0_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS0_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS0_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS0_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS0_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLDIS0_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS0_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLDIS0_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLDIS0_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS0_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS0_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS0_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS0_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS0_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS0_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS0_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS0_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS0_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS0_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS0_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS0_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS0_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS0_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS0_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS0_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS0_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL0: UDPHS Endpoint Control Register (endpoint = 0)
	UDPHS_EPTCTL0_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL0_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL0_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL0_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL0_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL0_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL0_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL0_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL0_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL0_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTL0_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTL0_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTL0_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL0_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL0_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL0_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL0_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL0_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL0_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL0_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL0_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL0_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTL0_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTL0_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTL0_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTL0_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTL0_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTL0_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTL0_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTL0_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTL0_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTL0_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTL0_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTL0_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTL0_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTL0_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTL0_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL0_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL0_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL0_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL0_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL0_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL0_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 0)
	UDPHS_EPTCTL0_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL0_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL0_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL0_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL0_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL0_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL0_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL0_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL0_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL0_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTL0_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTL0_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTL0_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTL0_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTL0_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTL0_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL0_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL0_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL0_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL0_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL0_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL0_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL0_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTL0_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL0_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTL0_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL0_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTL0_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL0_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL0_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL0_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL0_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL0_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTSETSTA0: UDPHS Endpoint Set Status Register (endpoint = 0)
	UDPHS_EPTSETSTA0_FRCESTALL_Pos  = 0x5   // Position of FRCESTALL field.
	UDPHS_EPTSETSTA0_FRCESTALL_Msk  = 0x20  // Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA0_FRCESTALL      = 0x20  // Bit FRCESTALL.
	UDPHS_EPTSETSTA0_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA0_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA0_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA0_TXRDY_Pos      = 0xb   // Position of TXRDY field.
	UDPHS_EPTSETSTA0_TXRDY_Msk      = 0x800 // Bit mask of TXRDY field.
	UDPHS_EPTSETSTA0_TXRDY          = 0x800 // Bit TXRDY.

	// EPTSETSTA0_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 0)
	UDPHS_EPTSETSTA0_ISOENDPT_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA0_ISOENDPT_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA0_ISOENDPT_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA0_ISOENDPT_TXRDY_TRER_Pos = 0xb   // Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA0_ISOENDPT_TXRDY_TRER_Msk = 0x800 // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA0_ISOENDPT_TXRDY_TRER     = 0x800 // Bit TXRDY_TRER.

	// EPTCLRSTA0: UDPHS Endpoint Clear Status Register (endpoint = 0)
	UDPHS_EPTCLRSTA0_FRCESTALL_Pos  = 0x5    // Position of FRCESTALL field.
	UDPHS_EPTCLRSTA0_FRCESTALL_Msk  = 0x20   // Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA0_FRCESTALL      = 0x20   // Bit FRCESTALL.
	UDPHS_EPTCLRSTA0_TOGGLESQ_Pos   = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA0_TOGGLESQ_Msk   = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA0_TOGGLESQ       = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA0_RXRDY_TXKL_Pos = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA0_RXRDY_TXKL_Msk = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA0_RXRDY_TXKL     = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA0_TX_COMPLT_Pos  = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA0_TX_COMPLT_Msk  = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA0_TX_COMPLT      = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA0_RX_SETUP_Pos   = 0xc    // Position of RX_SETUP field.
	UDPHS_EPTCLRSTA0_RX_SETUP_Msk   = 0x1000 // Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA0_RX_SETUP       = 0x1000 // Bit RX_SETUP.
	UDPHS_EPTCLRSTA0_STALL_SNT_Pos  = 0xd    // Position of STALL_SNT field.
	UDPHS_EPTCLRSTA0_STALL_SNT_Msk  = 0x2000 // Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA0_STALL_SNT      = 0x2000 // Bit STALL_SNT.
	UDPHS_EPTCLRSTA0_NAK_IN_Pos     = 0xe    // Position of NAK_IN field.
	UDPHS_EPTCLRSTA0_NAK_IN_Msk     = 0x4000 // Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA0_NAK_IN         = 0x4000 // Bit NAK_IN.
	UDPHS_EPTCLRSTA0_NAK_OUT_Pos    = 0xf    // Position of NAK_OUT field.
	UDPHS_EPTCLRSTA0_NAK_OUT_Msk    = 0x8000 // Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA0_NAK_OUT        = 0x8000 // Bit NAK_OUT.

	// EPTCLRSTA0_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 0)
	UDPHS_EPTCLRSTA0_ISOENDPT_TOGGLESQ_Pos    = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA0_ISOENDPT_TOGGLESQ_Msk    = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA0_ISOENDPT_TOGGLESQ        = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA0_ISOENDPT_RXRDY_TXKL_Pos  = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA0_ISOENDPT_RXRDY_TXKL_Msk  = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA0_ISOENDPT_RXRDY_TXKL      = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA0_ISOENDPT_TX_COMPLT_Pos   = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA0_ISOENDPT_TX_COMPLT_Msk   = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA0_ISOENDPT_TX_COMPLT       = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FL_ISO_Pos  = 0xc    // Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000 // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FL_ISO      = 0x1000 // Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_CRC_NTR_Pos = 0xd    // Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000 // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_CRC_NTR     = 0x2000 // Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FLUSH_Pos   = 0xe    // Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FLUSH_Msk   = 0x4000 // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA0_ISOENDPT_ERR_FLUSH       = 0x4000 // Bit ERR_FLUSH.

	// EPTSTA0: UDPHS Endpoint Status Register (endpoint = 0)
	UDPHS_EPTSTA0_FRCESTALL_Pos            = 0x5        // Position of FRCESTALL field.
	UDPHS_EPTSTA0_FRCESTALL_Msk            = 0x20       // Bit mask of FRCESTALL field.
	UDPHS_EPTSTA0_FRCESTALL                = 0x20       // Bit FRCESTALL.
	UDPHS_EPTSTA0_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA0_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA0_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA0_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA0_TOGGLESQ_STA_DATA2       = 0x2        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA0_TOGGLESQ_STA_MDATA       = 0x3        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA0_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA0_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA0_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA0_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA0_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA0_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA0_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA0_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA0_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA0_TXRDY_Pos                = 0xb        // Position of TXRDY field.
	UDPHS_EPTSTA0_TXRDY_Msk                = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTSTA0_TXRDY                    = 0x800      // Bit TXRDY.
	UDPHS_EPTSTA0_RX_SETUP_Pos             = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTSTA0_RX_SETUP_Msk             = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTSTA0_RX_SETUP                 = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTSTA0_STALL_SNT_Pos            = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTSTA0_STALL_SNT_Msk            = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTSTA0_STALL_SNT                = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTSTA0_NAK_IN_Pos               = 0xe        // Position of NAK_IN field.
	UDPHS_EPTSTA0_NAK_IN_Msk               = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTSTA0_NAK_IN                   = 0x4000     // Bit NAK_IN.
	UDPHS_EPTSTA0_NAK_OUT_Pos              = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTSTA0_NAK_OUT_Msk              = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTSTA0_NAK_OUT                  = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTSTA0_CURBK_CTLDIR_Pos         = 0x10       // Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA0_CURBK_CTLDIR_Msk         = 0x30000    // Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA0_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA0_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA0_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA0_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA0_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA0_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA0_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA0_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA0_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA0_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTSTA0_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 0)
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_DATA2       = 0x2        // Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA0_ISOENDPT_TOGGLESQ_STA_MDATA       = 0x3        // MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA0_ISOENDPT_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA0_ISOENDPT_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA0_ISOENDPT_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA0_ISOENDPT_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA0_ISOENDPT_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA0_ISOENDPT_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA0_ISOENDPT_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA0_ISOENDPT_TXRDY_TRER_Pos           = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTSTA0_ISOENDPT_TXRDY_TRER_Msk           = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA0_ISOENDPT_TXRDY_TRER               = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FL_ISO_Pos           = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FL_ISO_Msk           = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FL_ISO               = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTSTA0_ISOENDPT_ERR_CRC_NTR_Pos          = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_CRC_NTR_Msk          = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_CRC_NTR              = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FLUSH_Pos            = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FLUSH_Msk            = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA0_ISOENDPT_ERR_FLUSH                = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTSTA0_ISOENDPT_CURBK_Pos                = 0x10       // Position of CURBK field.
	UDPHS_EPTSTA0_ISOENDPT_CURBK_Msk                = 0x30000    // Bit mask of CURBK field.
	UDPHS_EPTSTA0_ISOENDPT_CURBK_BANK0              = 0x0        // Bank 0 (or single bank)
	UDPHS_EPTSTA0_ISOENDPT_CURBK_BANK1              = 0x1        // Bank 1
	UDPHS_EPTSTA0_ISOENDPT_CURBK_BANK2              = 0x2        // Bank 2
	UDPHS_EPTSTA0_ISOENDPT_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA0_ISOENDPT_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA0_ISOENDPT_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA0_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA0_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA0_ISOENDPT_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA0_ISOENDPT_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA0_ISOENDPT_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA0_ISOENDPT_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA0_ISOENDPT_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTCFG1: UDPHS Endpoint Configuration Register (endpoint = 1)
	UDPHS_EPTCFG1_EPT_SIZE_Pos   = 0x0        // Position of EPT_SIZE field.
	UDPHS_EPTCFG1_EPT_SIZE_Msk   = 0x7        // Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG1_EPT_SIZE_8     = 0x0        // 8 bytes
	UDPHS_EPTCFG1_EPT_SIZE_16    = 0x1        // 16 bytes
	UDPHS_EPTCFG1_EPT_SIZE_32    = 0x2        // 32 bytes
	UDPHS_EPTCFG1_EPT_SIZE_64    = 0x3        // 64 bytes
	UDPHS_EPTCFG1_EPT_SIZE_128   = 0x4        // 128 bytes
	UDPHS_EPTCFG1_EPT_SIZE_256   = 0x5        // 256 bytes
	UDPHS_EPTCFG1_EPT_SIZE_512   = 0x6        // 512 bytes
	UDPHS_EPTCFG1_EPT_SIZE_1024  = 0x7        // 1024 bytes
	UDPHS_EPTCFG1_EPT_DIR_Pos    = 0x3        // Position of EPT_DIR field.
	UDPHS_EPTCFG1_EPT_DIR_Msk    = 0x8        // Bit mask of EPT_DIR field.
	UDPHS_EPTCFG1_EPT_DIR        = 0x8        // Bit EPT_DIR.
	UDPHS_EPTCFG1_EPT_TYPE_Pos   = 0x4        // Position of EPT_TYPE field.
	UDPHS_EPTCFG1_EPT_TYPE_Msk   = 0x30       // Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG1_EPT_TYPE_CTRL8 = 0x0        // Control endpoint
	UDPHS_EPTCFG1_EPT_TYPE_ISO   = 0x1        // Isochronous endpoint
	UDPHS_EPTCFG1_EPT_TYPE_BULK  = 0x2        // Bulk endpoint
	UDPHS_EPTCFG1_EPT_TYPE_INT   = 0x3        // Interrupt endpoint
	UDPHS_EPTCFG1_BK_NUMBER_Pos  = 0x6        // Position of BK_NUMBER field.
	UDPHS_EPTCFG1_BK_NUMBER_Msk  = 0xc0       // Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG1_BK_NUMBER_0    = 0x0        // Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG1_BK_NUMBER_1    = 0x1        // One bank (bank 0)
	UDPHS_EPTCFG1_BK_NUMBER_2    = 0x2        // Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG1_BK_NUMBER_3    = 0x3        // Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG1_NB_TRANS_Pos   = 0x8        // Position of NB_TRANS field.
	UDPHS_EPTCFG1_NB_TRANS_Msk   = 0x300      // Bit mask of NB_TRANS field.
	UDPHS_EPTCFG1_EPT_MAPD_Pos   = 0x1f       // Position of EPT_MAPD field.
	UDPHS_EPTCFG1_EPT_MAPD_Msk   = 0x80000000 // Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG1_EPT_MAPD       = 0x80000000 // Bit EPT_MAPD.

	// EPTCTLENB1: UDPHS Endpoint Control Enable Register (endpoint = 1)
	UDPHS_EPTCTLENB1_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB1_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB1_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB1_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB1_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB1_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB1_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB1_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB1_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB1_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLENB1_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB1_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLENB1_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB1_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB1_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB1_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB1_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB1_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB1_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB1_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB1_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB1_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLENB1_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLENB1_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLENB1_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLENB1_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB1_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLENB1_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLENB1_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB1_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLENB1_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLENB1_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB1_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLENB1_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLENB1_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB1_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLENB1_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB1_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB1_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB1_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB1_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB1_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLENB1_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 1)
	UDPHS_EPTCTLENB1_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB1_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB1_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB1_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB1_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB1_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB1_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB1_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB1_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB1_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLENB1_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB1_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLENB1_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLENB1_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB1_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB1_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB1_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB1_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB1_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB1_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB1_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB1_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB1_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB1_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB1_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLENB1_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB1_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB1_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB1_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB1_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB1_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS1: UDPHS Endpoint Control Disable Register (endpoint = 1)
	UDPHS_EPTCTLDIS1_EPT_DISABL_Pos = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS1_EPT_DISABL_Msk = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS1_EPT_DISABL     = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS1_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS1_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS1_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS1_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS1_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS1_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS1_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLDIS1_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS1_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLDIS1_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS1_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS1_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS1_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS1_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS1_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS1_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS1_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS1_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS1_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLDIS1_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS1_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLDIS1_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLDIS1_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS1_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLDIS1_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLDIS1_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS1_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLDIS1_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLDIS1_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS1_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLDIS1_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLDIS1_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS1_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLDIS1_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS1_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS1_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS1_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS1_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS1_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS1_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 1)
	UDPHS_EPTCTLDIS1_ISOENDPT_EPT_DISABL_Pos  = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS1_ISOENDPT_EPT_DISABL_Msk  = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS1_ISOENDPT_EPT_DISABL      = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS1_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS1_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS1_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS1_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS1_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS1_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS1_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLDIS1_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS1_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLDIS1_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLDIS1_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS1_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS1_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS1_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS1_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS1_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS1_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS1_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS1_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS1_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS1_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS1_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS1_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS1_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS1_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS1_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS1_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS1_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL1: UDPHS Endpoint Control Register (endpoint = 1)
	UDPHS_EPTCTL1_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL1_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL1_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL1_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL1_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL1_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL1_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL1_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL1_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL1_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTL1_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTL1_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTL1_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL1_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL1_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL1_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL1_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL1_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL1_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL1_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL1_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL1_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTL1_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTL1_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTL1_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTL1_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTL1_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTL1_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTL1_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTL1_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTL1_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTL1_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTL1_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTL1_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTL1_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTL1_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTL1_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL1_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL1_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL1_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL1_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL1_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL1_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 1)
	UDPHS_EPTCTL1_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL1_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL1_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL1_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL1_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL1_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL1_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL1_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL1_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL1_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTL1_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTL1_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTL1_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTL1_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTL1_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTL1_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL1_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL1_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL1_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL1_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL1_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL1_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL1_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTL1_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL1_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTL1_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL1_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTL1_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL1_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL1_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL1_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL1_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL1_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTSETSTA1: UDPHS Endpoint Set Status Register (endpoint = 1)
	UDPHS_EPTSETSTA1_FRCESTALL_Pos  = 0x5   // Position of FRCESTALL field.
	UDPHS_EPTSETSTA1_FRCESTALL_Msk  = 0x20  // Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA1_FRCESTALL      = 0x20  // Bit FRCESTALL.
	UDPHS_EPTSETSTA1_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA1_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA1_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA1_TXRDY_Pos      = 0xb   // Position of TXRDY field.
	UDPHS_EPTSETSTA1_TXRDY_Msk      = 0x800 // Bit mask of TXRDY field.
	UDPHS_EPTSETSTA1_TXRDY          = 0x800 // Bit TXRDY.

	// EPTSETSTA1_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 1)
	UDPHS_EPTSETSTA1_ISOENDPT_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA1_ISOENDPT_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA1_ISOENDPT_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA1_ISOENDPT_TXRDY_TRER_Pos = 0xb   // Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA1_ISOENDPT_TXRDY_TRER_Msk = 0x800 // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA1_ISOENDPT_TXRDY_TRER     = 0x800 // Bit TXRDY_TRER.

	// EPTCLRSTA1: UDPHS Endpoint Clear Status Register (endpoint = 1)
	UDPHS_EPTCLRSTA1_FRCESTALL_Pos  = 0x5    // Position of FRCESTALL field.
	UDPHS_EPTCLRSTA1_FRCESTALL_Msk  = 0x20   // Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA1_FRCESTALL      = 0x20   // Bit FRCESTALL.
	UDPHS_EPTCLRSTA1_TOGGLESQ_Pos   = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA1_TOGGLESQ_Msk   = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA1_TOGGLESQ       = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA1_RXRDY_TXKL_Pos = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA1_RXRDY_TXKL_Msk = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA1_RXRDY_TXKL     = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA1_TX_COMPLT_Pos  = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA1_TX_COMPLT_Msk  = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA1_TX_COMPLT      = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA1_RX_SETUP_Pos   = 0xc    // Position of RX_SETUP field.
	UDPHS_EPTCLRSTA1_RX_SETUP_Msk   = 0x1000 // Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA1_RX_SETUP       = 0x1000 // Bit RX_SETUP.
	UDPHS_EPTCLRSTA1_STALL_SNT_Pos  = 0xd    // Position of STALL_SNT field.
	UDPHS_EPTCLRSTA1_STALL_SNT_Msk  = 0x2000 // Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA1_STALL_SNT      = 0x2000 // Bit STALL_SNT.
	UDPHS_EPTCLRSTA1_NAK_IN_Pos     = 0xe    // Position of NAK_IN field.
	UDPHS_EPTCLRSTA1_NAK_IN_Msk     = 0x4000 // Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA1_NAK_IN         = 0x4000 // Bit NAK_IN.
	UDPHS_EPTCLRSTA1_NAK_OUT_Pos    = 0xf    // Position of NAK_OUT field.
	UDPHS_EPTCLRSTA1_NAK_OUT_Msk    = 0x8000 // Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA1_NAK_OUT        = 0x8000 // Bit NAK_OUT.

	// EPTCLRSTA1_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 1)
	UDPHS_EPTCLRSTA1_ISOENDPT_TOGGLESQ_Pos    = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA1_ISOENDPT_TOGGLESQ_Msk    = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA1_ISOENDPT_TOGGLESQ        = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA1_ISOENDPT_RXRDY_TXKL_Pos  = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA1_ISOENDPT_RXRDY_TXKL_Msk  = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA1_ISOENDPT_RXRDY_TXKL      = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA1_ISOENDPT_TX_COMPLT_Pos   = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA1_ISOENDPT_TX_COMPLT_Msk   = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA1_ISOENDPT_TX_COMPLT       = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FL_ISO_Pos  = 0xc    // Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000 // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FL_ISO      = 0x1000 // Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_CRC_NTR_Pos = 0xd    // Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000 // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_CRC_NTR     = 0x2000 // Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FLUSH_Pos   = 0xe    // Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FLUSH_Msk   = 0x4000 // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA1_ISOENDPT_ERR_FLUSH       = 0x4000 // Bit ERR_FLUSH.

	// EPTSTA1: UDPHS Endpoint Status Register (endpoint = 1)
	UDPHS_EPTSTA1_FRCESTALL_Pos            = 0x5        // Position of FRCESTALL field.
	UDPHS_EPTSTA1_FRCESTALL_Msk            = 0x20       // Bit mask of FRCESTALL field.
	UDPHS_EPTSTA1_FRCESTALL                = 0x20       // Bit FRCESTALL.
	UDPHS_EPTSTA1_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA1_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA1_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA1_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA1_TOGGLESQ_STA_DATA2       = 0x2        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA1_TOGGLESQ_STA_MDATA       = 0x3        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA1_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA1_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA1_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA1_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA1_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA1_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA1_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA1_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA1_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA1_TXRDY_Pos                = 0xb        // Position of TXRDY field.
	UDPHS_EPTSTA1_TXRDY_Msk                = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTSTA1_TXRDY                    = 0x800      // Bit TXRDY.
	UDPHS_EPTSTA1_RX_SETUP_Pos             = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTSTA1_RX_SETUP_Msk             = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTSTA1_RX_SETUP                 = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTSTA1_STALL_SNT_Pos            = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTSTA1_STALL_SNT_Msk            = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTSTA1_STALL_SNT                = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTSTA1_NAK_IN_Pos               = 0xe        // Position of NAK_IN field.
	UDPHS_EPTSTA1_NAK_IN_Msk               = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTSTA1_NAK_IN                   = 0x4000     // Bit NAK_IN.
	UDPHS_EPTSTA1_NAK_OUT_Pos              = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTSTA1_NAK_OUT_Msk              = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTSTA1_NAK_OUT                  = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTSTA1_CURBK_CTLDIR_Pos         = 0x10       // Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA1_CURBK_CTLDIR_Msk         = 0x30000    // Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA1_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA1_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA1_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA1_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA1_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA1_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA1_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA1_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA1_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA1_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTSTA1_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 1)
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_DATA2       = 0x2        // Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA1_ISOENDPT_TOGGLESQ_STA_MDATA       = 0x3        // MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA1_ISOENDPT_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA1_ISOENDPT_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA1_ISOENDPT_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA1_ISOENDPT_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA1_ISOENDPT_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA1_ISOENDPT_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA1_ISOENDPT_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA1_ISOENDPT_TXRDY_TRER_Pos           = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTSTA1_ISOENDPT_TXRDY_TRER_Msk           = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA1_ISOENDPT_TXRDY_TRER               = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FL_ISO_Pos           = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FL_ISO_Msk           = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FL_ISO               = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTSTA1_ISOENDPT_ERR_CRC_NTR_Pos          = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_CRC_NTR_Msk          = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_CRC_NTR              = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FLUSH_Pos            = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FLUSH_Msk            = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA1_ISOENDPT_ERR_FLUSH                = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTSTA1_ISOENDPT_CURBK_Pos                = 0x10       // Position of CURBK field.
	UDPHS_EPTSTA1_ISOENDPT_CURBK_Msk                = 0x30000    // Bit mask of CURBK field.
	UDPHS_EPTSTA1_ISOENDPT_CURBK_BANK0              = 0x0        // Bank 0 (or single bank)
	UDPHS_EPTSTA1_ISOENDPT_CURBK_BANK1              = 0x1        // Bank 1
	UDPHS_EPTSTA1_ISOENDPT_CURBK_BANK2              = 0x2        // Bank 2
	UDPHS_EPTSTA1_ISOENDPT_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA1_ISOENDPT_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA1_ISOENDPT_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA1_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA1_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA1_ISOENDPT_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA1_ISOENDPT_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA1_ISOENDPT_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA1_ISOENDPT_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA1_ISOENDPT_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTCFG2: UDPHS Endpoint Configuration Register (endpoint = 2)
	UDPHS_EPTCFG2_EPT_SIZE_Pos   = 0x0        // Position of EPT_SIZE field.
	UDPHS_EPTCFG2_EPT_SIZE_Msk   = 0x7        // Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG2_EPT_SIZE_8     = 0x0        // 8 bytes
	UDPHS_EPTCFG2_EPT_SIZE_16    = 0x1        // 16 bytes
	UDPHS_EPTCFG2_EPT_SIZE_32    = 0x2        // 32 bytes
	UDPHS_EPTCFG2_EPT_SIZE_64    = 0x3        // 64 bytes
	UDPHS_EPTCFG2_EPT_SIZE_128   = 0x4        // 128 bytes
	UDPHS_EPTCFG2_EPT_SIZE_256   = 0x5        // 256 bytes
	UDPHS_EPTCFG2_EPT_SIZE_512   = 0x6        // 512 bytes
	UDPHS_EPTCFG2_EPT_SIZE_1024  = 0x7        // 1024 bytes
	UDPHS_EPTCFG2_EPT_DIR_Pos    = 0x3        // Position of EPT_DIR field.
	UDPHS_EPTCFG2_EPT_DIR_Msk    = 0x8        // Bit mask of EPT_DIR field.
	UDPHS_EPTCFG2_EPT_DIR        = 0x8        // Bit EPT_DIR.
	UDPHS_EPTCFG2_EPT_TYPE_Pos   = 0x4        // Position of EPT_TYPE field.
	UDPHS_EPTCFG2_EPT_TYPE_Msk   = 0x30       // Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG2_EPT_TYPE_CTRL8 = 0x0        // Control endpoint
	UDPHS_EPTCFG2_EPT_TYPE_ISO   = 0x1        // Isochronous endpoint
	UDPHS_EPTCFG2_EPT_TYPE_BULK  = 0x2        // Bulk endpoint
	UDPHS_EPTCFG2_EPT_TYPE_INT   = 0x3        // Interrupt endpoint
	UDPHS_EPTCFG2_BK_NUMBER_Pos  = 0x6        // Position of BK_NUMBER field.
	UDPHS_EPTCFG2_BK_NUMBER_Msk  = 0xc0       // Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG2_BK_NUMBER_0    = 0x0        // Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG2_BK_NUMBER_1    = 0x1        // One bank (bank 0)
	UDPHS_EPTCFG2_BK_NUMBER_2    = 0x2        // Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG2_BK_NUMBER_3    = 0x3        // Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG2_NB_TRANS_Pos   = 0x8        // Position of NB_TRANS field.
	UDPHS_EPTCFG2_NB_TRANS_Msk   = 0x300      // Bit mask of NB_TRANS field.
	UDPHS_EPTCFG2_EPT_MAPD_Pos   = 0x1f       // Position of EPT_MAPD field.
	UDPHS_EPTCFG2_EPT_MAPD_Msk   = 0x80000000 // Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG2_EPT_MAPD       = 0x80000000 // Bit EPT_MAPD.

	// EPTCTLENB2: UDPHS Endpoint Control Enable Register (endpoint = 2)
	UDPHS_EPTCTLENB2_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB2_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB2_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB2_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB2_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB2_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB2_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB2_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB2_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB2_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLENB2_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB2_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLENB2_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB2_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB2_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB2_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB2_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB2_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB2_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB2_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB2_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB2_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLENB2_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLENB2_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLENB2_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLENB2_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB2_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLENB2_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLENB2_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB2_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLENB2_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLENB2_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB2_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLENB2_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLENB2_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB2_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLENB2_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB2_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB2_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB2_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB2_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB2_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLENB2_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 2)
	UDPHS_EPTCTLENB2_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB2_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB2_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB2_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB2_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB2_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB2_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB2_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB2_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB2_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLENB2_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB2_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLENB2_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLENB2_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB2_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB2_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB2_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB2_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB2_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB2_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB2_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB2_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB2_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB2_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB2_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLENB2_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB2_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB2_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB2_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB2_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB2_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS2: UDPHS Endpoint Control Disable Register (endpoint = 2)
	UDPHS_EPTCTLDIS2_EPT_DISABL_Pos = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS2_EPT_DISABL_Msk = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS2_EPT_DISABL     = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS2_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS2_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS2_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS2_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS2_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS2_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS2_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLDIS2_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS2_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLDIS2_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS2_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS2_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS2_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS2_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS2_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS2_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS2_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS2_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS2_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLDIS2_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS2_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLDIS2_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLDIS2_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS2_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLDIS2_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLDIS2_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS2_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLDIS2_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLDIS2_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS2_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLDIS2_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLDIS2_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS2_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLDIS2_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS2_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS2_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS2_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS2_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS2_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS2_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 2)
	UDPHS_EPTCTLDIS2_ISOENDPT_EPT_DISABL_Pos  = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS2_ISOENDPT_EPT_DISABL_Msk  = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS2_ISOENDPT_EPT_DISABL      = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS2_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS2_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS2_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS2_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS2_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS2_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS2_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLDIS2_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS2_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLDIS2_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLDIS2_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS2_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS2_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS2_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS2_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS2_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS2_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS2_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS2_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS2_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS2_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS2_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS2_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS2_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS2_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS2_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS2_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS2_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL2: UDPHS Endpoint Control Register (endpoint = 2)
	UDPHS_EPTCTL2_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL2_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL2_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL2_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL2_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL2_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL2_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL2_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL2_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL2_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTL2_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTL2_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTL2_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL2_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL2_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL2_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL2_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL2_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL2_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL2_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL2_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL2_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTL2_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTL2_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTL2_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTL2_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTL2_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTL2_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTL2_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTL2_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTL2_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTL2_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTL2_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTL2_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTL2_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTL2_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTL2_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL2_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL2_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL2_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL2_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL2_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL2_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 2)
	UDPHS_EPTCTL2_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL2_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL2_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL2_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL2_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL2_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL2_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL2_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL2_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL2_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTL2_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTL2_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTL2_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTL2_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTL2_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTL2_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL2_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL2_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL2_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL2_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL2_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL2_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL2_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTL2_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL2_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTL2_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL2_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTL2_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL2_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL2_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL2_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL2_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL2_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTSETSTA2: UDPHS Endpoint Set Status Register (endpoint = 2)
	UDPHS_EPTSETSTA2_FRCESTALL_Pos  = 0x5   // Position of FRCESTALL field.
	UDPHS_EPTSETSTA2_FRCESTALL_Msk  = 0x20  // Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA2_FRCESTALL      = 0x20  // Bit FRCESTALL.
	UDPHS_EPTSETSTA2_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA2_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA2_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA2_TXRDY_Pos      = 0xb   // Position of TXRDY field.
	UDPHS_EPTSETSTA2_TXRDY_Msk      = 0x800 // Bit mask of TXRDY field.
	UDPHS_EPTSETSTA2_TXRDY          = 0x800 // Bit TXRDY.

	// EPTSETSTA2_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 2)
	UDPHS_EPTSETSTA2_ISOENDPT_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA2_ISOENDPT_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA2_ISOENDPT_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA2_ISOENDPT_TXRDY_TRER_Pos = 0xb   // Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA2_ISOENDPT_TXRDY_TRER_Msk = 0x800 // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA2_ISOENDPT_TXRDY_TRER     = 0x800 // Bit TXRDY_TRER.

	// EPTCLRSTA2: UDPHS Endpoint Clear Status Register (endpoint = 2)
	UDPHS_EPTCLRSTA2_FRCESTALL_Pos  = 0x5    // Position of FRCESTALL field.
	UDPHS_EPTCLRSTA2_FRCESTALL_Msk  = 0x20   // Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA2_FRCESTALL      = 0x20   // Bit FRCESTALL.
	UDPHS_EPTCLRSTA2_TOGGLESQ_Pos   = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA2_TOGGLESQ_Msk   = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA2_TOGGLESQ       = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA2_RXRDY_TXKL_Pos = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA2_RXRDY_TXKL_Msk = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA2_RXRDY_TXKL     = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA2_TX_COMPLT_Pos  = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA2_TX_COMPLT_Msk  = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA2_TX_COMPLT      = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA2_RX_SETUP_Pos   = 0xc    // Position of RX_SETUP field.
	UDPHS_EPTCLRSTA2_RX_SETUP_Msk   = 0x1000 // Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA2_RX_SETUP       = 0x1000 // Bit RX_SETUP.
	UDPHS_EPTCLRSTA2_STALL_SNT_Pos  = 0xd    // Position of STALL_SNT field.
	UDPHS_EPTCLRSTA2_STALL_SNT_Msk  = 0x2000 // Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA2_STALL_SNT      = 0x2000 // Bit STALL_SNT.
	UDPHS_EPTCLRSTA2_NAK_IN_Pos     = 0xe    // Position of NAK_IN field.
	UDPHS_EPTCLRSTA2_NAK_IN_Msk     = 0x4000 // Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA2_NAK_IN         = 0x4000 // Bit NAK_IN.
	UDPHS_EPTCLRSTA2_NAK_OUT_Pos    = 0xf    // Position of NAK_OUT field.
	UDPHS_EPTCLRSTA2_NAK_OUT_Msk    = 0x8000 // Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA2_NAK_OUT        = 0x8000 // Bit NAK_OUT.

	// EPTCLRSTA2_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 2)
	UDPHS_EPTCLRSTA2_ISOENDPT_TOGGLESQ_Pos    = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA2_ISOENDPT_TOGGLESQ_Msk    = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA2_ISOENDPT_TOGGLESQ        = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA2_ISOENDPT_RXRDY_TXKL_Pos  = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA2_ISOENDPT_RXRDY_TXKL_Msk  = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA2_ISOENDPT_RXRDY_TXKL      = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA2_ISOENDPT_TX_COMPLT_Pos   = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA2_ISOENDPT_TX_COMPLT_Msk   = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA2_ISOENDPT_TX_COMPLT       = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FL_ISO_Pos  = 0xc    // Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000 // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FL_ISO      = 0x1000 // Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_CRC_NTR_Pos = 0xd    // Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000 // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_CRC_NTR     = 0x2000 // Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FLUSH_Pos   = 0xe    // Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FLUSH_Msk   = 0x4000 // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA2_ISOENDPT_ERR_FLUSH       = 0x4000 // Bit ERR_FLUSH.

	// EPTSTA2: UDPHS Endpoint Status Register (endpoint = 2)
	UDPHS_EPTSTA2_FRCESTALL_Pos            = 0x5        // Position of FRCESTALL field.
	UDPHS_EPTSTA2_FRCESTALL_Msk            = 0x20       // Bit mask of FRCESTALL field.
	UDPHS_EPTSTA2_FRCESTALL                = 0x20       // Bit FRCESTALL.
	UDPHS_EPTSTA2_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA2_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA2_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA2_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA2_TOGGLESQ_STA_DATA2       = 0x2        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA2_TOGGLESQ_STA_MDATA       = 0x3        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA2_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA2_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA2_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA2_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA2_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA2_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA2_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA2_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA2_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA2_TXRDY_Pos                = 0xb        // Position of TXRDY field.
	UDPHS_EPTSTA2_TXRDY_Msk                = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTSTA2_TXRDY                    = 0x800      // Bit TXRDY.
	UDPHS_EPTSTA2_RX_SETUP_Pos             = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTSTA2_RX_SETUP_Msk             = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTSTA2_RX_SETUP                 = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTSTA2_STALL_SNT_Pos            = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTSTA2_STALL_SNT_Msk            = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTSTA2_STALL_SNT                = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTSTA2_NAK_IN_Pos               = 0xe        // Position of NAK_IN field.
	UDPHS_EPTSTA2_NAK_IN_Msk               = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTSTA2_NAK_IN                   = 0x4000     // Bit NAK_IN.
	UDPHS_EPTSTA2_NAK_OUT_Pos              = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTSTA2_NAK_OUT_Msk              = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTSTA2_NAK_OUT                  = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTSTA2_CURBK_CTLDIR_Pos         = 0x10       // Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA2_CURBK_CTLDIR_Msk         = 0x30000    // Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA2_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA2_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA2_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA2_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA2_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA2_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA2_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA2_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA2_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA2_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTSTA2_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 2)
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_DATA2       = 0x2        // Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA2_ISOENDPT_TOGGLESQ_STA_MDATA       = 0x3        // MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA2_ISOENDPT_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA2_ISOENDPT_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA2_ISOENDPT_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA2_ISOENDPT_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA2_ISOENDPT_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA2_ISOENDPT_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA2_ISOENDPT_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA2_ISOENDPT_TXRDY_TRER_Pos           = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTSTA2_ISOENDPT_TXRDY_TRER_Msk           = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA2_ISOENDPT_TXRDY_TRER               = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FL_ISO_Pos           = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FL_ISO_Msk           = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FL_ISO               = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTSTA2_ISOENDPT_ERR_CRC_NTR_Pos          = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_CRC_NTR_Msk          = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_CRC_NTR              = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FLUSH_Pos            = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FLUSH_Msk            = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA2_ISOENDPT_ERR_FLUSH                = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTSTA2_ISOENDPT_CURBK_Pos                = 0x10       // Position of CURBK field.
	UDPHS_EPTSTA2_ISOENDPT_CURBK_Msk                = 0x30000    // Bit mask of CURBK field.
	UDPHS_EPTSTA2_ISOENDPT_CURBK_BANK0              = 0x0        // Bank 0 (or single bank)
	UDPHS_EPTSTA2_ISOENDPT_CURBK_BANK1              = 0x1        // Bank 1
	UDPHS_EPTSTA2_ISOENDPT_CURBK_BANK2              = 0x2        // Bank 2
	UDPHS_EPTSTA2_ISOENDPT_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA2_ISOENDPT_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA2_ISOENDPT_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA2_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA2_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA2_ISOENDPT_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA2_ISOENDPT_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA2_ISOENDPT_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA2_ISOENDPT_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA2_ISOENDPT_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTCFG3: UDPHS Endpoint Configuration Register (endpoint = 3)
	UDPHS_EPTCFG3_EPT_SIZE_Pos   = 0x0        // Position of EPT_SIZE field.
	UDPHS_EPTCFG3_EPT_SIZE_Msk   = 0x7        // Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG3_EPT_SIZE_8     = 0x0        // 8 bytes
	UDPHS_EPTCFG3_EPT_SIZE_16    = 0x1        // 16 bytes
	UDPHS_EPTCFG3_EPT_SIZE_32    = 0x2        // 32 bytes
	UDPHS_EPTCFG3_EPT_SIZE_64    = 0x3        // 64 bytes
	UDPHS_EPTCFG3_EPT_SIZE_128   = 0x4        // 128 bytes
	UDPHS_EPTCFG3_EPT_SIZE_256   = 0x5        // 256 bytes
	UDPHS_EPTCFG3_EPT_SIZE_512   = 0x6        // 512 bytes
	UDPHS_EPTCFG3_EPT_SIZE_1024  = 0x7        // 1024 bytes
	UDPHS_EPTCFG3_EPT_DIR_Pos    = 0x3        // Position of EPT_DIR field.
	UDPHS_EPTCFG3_EPT_DIR_Msk    = 0x8        // Bit mask of EPT_DIR field.
	UDPHS_EPTCFG3_EPT_DIR        = 0x8        // Bit EPT_DIR.
	UDPHS_EPTCFG3_EPT_TYPE_Pos   = 0x4        // Position of EPT_TYPE field.
	UDPHS_EPTCFG3_EPT_TYPE_Msk   = 0x30       // Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG3_EPT_TYPE_CTRL8 = 0x0        // Control endpoint
	UDPHS_EPTCFG3_EPT_TYPE_ISO   = 0x1        // Isochronous endpoint
	UDPHS_EPTCFG3_EPT_TYPE_BULK  = 0x2        // Bulk endpoint
	UDPHS_EPTCFG3_EPT_TYPE_INT   = 0x3        // Interrupt endpoint
	UDPHS_EPTCFG3_BK_NUMBER_Pos  = 0x6        // Position of BK_NUMBER field.
	UDPHS_EPTCFG3_BK_NUMBER_Msk  = 0xc0       // Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG3_BK_NUMBER_0    = 0x0        // Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG3_BK_NUMBER_1    = 0x1        // One bank (bank 0)
	UDPHS_EPTCFG3_BK_NUMBER_2    = 0x2        // Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG3_BK_NUMBER_3    = 0x3        // Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG3_NB_TRANS_Pos   = 0x8        // Position of NB_TRANS field.
	UDPHS_EPTCFG3_NB_TRANS_Msk   = 0x300      // Bit mask of NB_TRANS field.
	UDPHS_EPTCFG3_EPT_MAPD_Pos   = 0x1f       // Position of EPT_MAPD field.
	UDPHS_EPTCFG3_EPT_MAPD_Msk   = 0x80000000 // Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG3_EPT_MAPD       = 0x80000000 // Bit EPT_MAPD.

	// EPTCTLENB3: UDPHS Endpoint Control Enable Register (endpoint = 3)
	UDPHS_EPTCTLENB3_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB3_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB3_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB3_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB3_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB3_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB3_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB3_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB3_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB3_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLENB3_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB3_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLENB3_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB3_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB3_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB3_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB3_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB3_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB3_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB3_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB3_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB3_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLENB3_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLENB3_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLENB3_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLENB3_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB3_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLENB3_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLENB3_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB3_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLENB3_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLENB3_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB3_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLENB3_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLENB3_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB3_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLENB3_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB3_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB3_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB3_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB3_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB3_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLENB3_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 3)
	UDPHS_EPTCTLENB3_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB3_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB3_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB3_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB3_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB3_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB3_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB3_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB3_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB3_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLENB3_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB3_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLENB3_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLENB3_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB3_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB3_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB3_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB3_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB3_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB3_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB3_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB3_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB3_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB3_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB3_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLENB3_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB3_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB3_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB3_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB3_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB3_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS3: UDPHS Endpoint Control Disable Register (endpoint = 3)
	UDPHS_EPTCTLDIS3_EPT_DISABL_Pos = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS3_EPT_DISABL_Msk = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS3_EPT_DISABL     = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS3_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS3_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS3_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS3_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS3_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS3_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS3_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLDIS3_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS3_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLDIS3_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS3_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS3_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS3_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS3_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS3_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS3_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS3_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS3_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS3_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLDIS3_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS3_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLDIS3_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLDIS3_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS3_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLDIS3_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLDIS3_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS3_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLDIS3_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLDIS3_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS3_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLDIS3_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLDIS3_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS3_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLDIS3_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS3_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS3_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS3_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS3_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS3_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS3_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 3)
	UDPHS_EPTCTLDIS3_ISOENDPT_EPT_DISABL_Pos  = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS3_ISOENDPT_EPT_DISABL_Msk  = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS3_ISOENDPT_EPT_DISABL      = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS3_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS3_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS3_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS3_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS3_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS3_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS3_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLDIS3_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS3_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLDIS3_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLDIS3_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS3_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS3_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS3_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS3_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS3_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS3_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS3_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS3_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS3_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS3_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS3_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS3_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS3_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS3_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS3_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS3_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS3_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL3: UDPHS Endpoint Control Register (endpoint = 3)
	UDPHS_EPTCTL3_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL3_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL3_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL3_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL3_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL3_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL3_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL3_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL3_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL3_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTL3_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTL3_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTL3_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL3_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL3_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL3_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL3_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL3_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL3_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL3_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL3_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL3_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTL3_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTL3_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTL3_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTL3_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTL3_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTL3_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTL3_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTL3_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTL3_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTL3_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTL3_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTL3_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTL3_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTL3_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTL3_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL3_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL3_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL3_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL3_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL3_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL3_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 3)
	UDPHS_EPTCTL3_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL3_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL3_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL3_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL3_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL3_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL3_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL3_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL3_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL3_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTL3_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTL3_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTL3_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTL3_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTL3_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTL3_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL3_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL3_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL3_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL3_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL3_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL3_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL3_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTL3_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL3_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTL3_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL3_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTL3_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL3_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL3_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL3_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL3_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL3_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTSETSTA3: UDPHS Endpoint Set Status Register (endpoint = 3)
	UDPHS_EPTSETSTA3_FRCESTALL_Pos  = 0x5   // Position of FRCESTALL field.
	UDPHS_EPTSETSTA3_FRCESTALL_Msk  = 0x20  // Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA3_FRCESTALL      = 0x20  // Bit FRCESTALL.
	UDPHS_EPTSETSTA3_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA3_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA3_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA3_TXRDY_Pos      = 0xb   // Position of TXRDY field.
	UDPHS_EPTSETSTA3_TXRDY_Msk      = 0x800 // Bit mask of TXRDY field.
	UDPHS_EPTSETSTA3_TXRDY          = 0x800 // Bit TXRDY.

	// EPTSETSTA3_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 3)
	UDPHS_EPTSETSTA3_ISOENDPT_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA3_ISOENDPT_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA3_ISOENDPT_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA3_ISOENDPT_TXRDY_TRER_Pos = 0xb   // Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA3_ISOENDPT_TXRDY_TRER_Msk = 0x800 // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA3_ISOENDPT_TXRDY_TRER     = 0x800 // Bit TXRDY_TRER.

	// EPTCLRSTA3: UDPHS Endpoint Clear Status Register (endpoint = 3)
	UDPHS_EPTCLRSTA3_FRCESTALL_Pos  = 0x5    // Position of FRCESTALL field.
	UDPHS_EPTCLRSTA3_FRCESTALL_Msk  = 0x20   // Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA3_FRCESTALL      = 0x20   // Bit FRCESTALL.
	UDPHS_EPTCLRSTA3_TOGGLESQ_Pos   = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA3_TOGGLESQ_Msk   = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA3_TOGGLESQ       = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA3_RXRDY_TXKL_Pos = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA3_RXRDY_TXKL_Msk = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA3_RXRDY_TXKL     = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA3_TX_COMPLT_Pos  = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA3_TX_COMPLT_Msk  = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA3_TX_COMPLT      = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA3_RX_SETUP_Pos   = 0xc    // Position of RX_SETUP field.
	UDPHS_EPTCLRSTA3_RX_SETUP_Msk   = 0x1000 // Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA3_RX_SETUP       = 0x1000 // Bit RX_SETUP.
	UDPHS_EPTCLRSTA3_STALL_SNT_Pos  = 0xd    // Position of STALL_SNT field.
	UDPHS_EPTCLRSTA3_STALL_SNT_Msk  = 0x2000 // Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA3_STALL_SNT      = 0x2000 // Bit STALL_SNT.
	UDPHS_EPTCLRSTA3_NAK_IN_Pos     = 0xe    // Position of NAK_IN field.
	UDPHS_EPTCLRSTA3_NAK_IN_Msk     = 0x4000 // Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA3_NAK_IN         = 0x4000 // Bit NAK_IN.
	UDPHS_EPTCLRSTA3_NAK_OUT_Pos    = 0xf    // Position of NAK_OUT field.
	UDPHS_EPTCLRSTA3_NAK_OUT_Msk    = 0x8000 // Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA3_NAK_OUT        = 0x8000 // Bit NAK_OUT.

	// EPTCLRSTA3_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 3)
	UDPHS_EPTCLRSTA3_ISOENDPT_TOGGLESQ_Pos    = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA3_ISOENDPT_TOGGLESQ_Msk    = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA3_ISOENDPT_TOGGLESQ        = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA3_ISOENDPT_RXRDY_TXKL_Pos  = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA3_ISOENDPT_RXRDY_TXKL_Msk  = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA3_ISOENDPT_RXRDY_TXKL      = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA3_ISOENDPT_TX_COMPLT_Pos   = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA3_ISOENDPT_TX_COMPLT_Msk   = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA3_ISOENDPT_TX_COMPLT       = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FL_ISO_Pos  = 0xc    // Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000 // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FL_ISO      = 0x1000 // Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_CRC_NTR_Pos = 0xd    // Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000 // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_CRC_NTR     = 0x2000 // Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FLUSH_Pos   = 0xe    // Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FLUSH_Msk   = 0x4000 // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA3_ISOENDPT_ERR_FLUSH       = 0x4000 // Bit ERR_FLUSH.

	// EPTSTA3: UDPHS Endpoint Status Register (endpoint = 3)
	UDPHS_EPTSTA3_FRCESTALL_Pos            = 0x5        // Position of FRCESTALL field.
	UDPHS_EPTSTA3_FRCESTALL_Msk            = 0x20       // Bit mask of FRCESTALL field.
	UDPHS_EPTSTA3_FRCESTALL                = 0x20       // Bit FRCESTALL.
	UDPHS_EPTSTA3_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA3_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA3_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA3_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA3_TOGGLESQ_STA_DATA2       = 0x2        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA3_TOGGLESQ_STA_MDATA       = 0x3        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA3_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA3_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA3_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA3_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA3_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA3_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA3_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA3_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA3_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA3_TXRDY_Pos                = 0xb        // Position of TXRDY field.
	UDPHS_EPTSTA3_TXRDY_Msk                = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTSTA3_TXRDY                    = 0x800      // Bit TXRDY.
	UDPHS_EPTSTA3_RX_SETUP_Pos             = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTSTA3_RX_SETUP_Msk             = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTSTA3_RX_SETUP                 = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTSTA3_STALL_SNT_Pos            = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTSTA3_STALL_SNT_Msk            = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTSTA3_STALL_SNT                = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTSTA3_NAK_IN_Pos               = 0xe        // Position of NAK_IN field.
	UDPHS_EPTSTA3_NAK_IN_Msk               = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTSTA3_NAK_IN                   = 0x4000     // Bit NAK_IN.
	UDPHS_EPTSTA3_NAK_OUT_Pos              = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTSTA3_NAK_OUT_Msk              = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTSTA3_NAK_OUT                  = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTSTA3_CURBK_CTLDIR_Pos         = 0x10       // Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA3_CURBK_CTLDIR_Msk         = 0x30000    // Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA3_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA3_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA3_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA3_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA3_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA3_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA3_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA3_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA3_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA3_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTSTA3_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 3)
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_DATA2       = 0x2        // Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA3_ISOENDPT_TOGGLESQ_STA_MDATA       = 0x3        // MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA3_ISOENDPT_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA3_ISOENDPT_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA3_ISOENDPT_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA3_ISOENDPT_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA3_ISOENDPT_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA3_ISOENDPT_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA3_ISOENDPT_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA3_ISOENDPT_TXRDY_TRER_Pos           = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTSTA3_ISOENDPT_TXRDY_TRER_Msk           = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA3_ISOENDPT_TXRDY_TRER               = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FL_ISO_Pos           = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FL_ISO_Msk           = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FL_ISO               = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTSTA3_ISOENDPT_ERR_CRC_NTR_Pos          = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_CRC_NTR_Msk          = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_CRC_NTR              = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FLUSH_Pos            = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FLUSH_Msk            = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA3_ISOENDPT_ERR_FLUSH                = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTSTA3_ISOENDPT_CURBK_Pos                = 0x10       // Position of CURBK field.
	UDPHS_EPTSTA3_ISOENDPT_CURBK_Msk                = 0x30000    // Bit mask of CURBK field.
	UDPHS_EPTSTA3_ISOENDPT_CURBK_BANK0              = 0x0        // Bank 0 (or single bank)
	UDPHS_EPTSTA3_ISOENDPT_CURBK_BANK1              = 0x1        // Bank 1
	UDPHS_EPTSTA3_ISOENDPT_CURBK_BANK2              = 0x2        // Bank 2
	UDPHS_EPTSTA3_ISOENDPT_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA3_ISOENDPT_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA3_ISOENDPT_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA3_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA3_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA3_ISOENDPT_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA3_ISOENDPT_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA3_ISOENDPT_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA3_ISOENDPT_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA3_ISOENDPT_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTCFG4: UDPHS Endpoint Configuration Register (endpoint = 4)
	UDPHS_EPTCFG4_EPT_SIZE_Pos   = 0x0        // Position of EPT_SIZE field.
	UDPHS_EPTCFG4_EPT_SIZE_Msk   = 0x7        // Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG4_EPT_SIZE_8     = 0x0        // 8 bytes
	UDPHS_EPTCFG4_EPT_SIZE_16    = 0x1        // 16 bytes
	UDPHS_EPTCFG4_EPT_SIZE_32    = 0x2        // 32 bytes
	UDPHS_EPTCFG4_EPT_SIZE_64    = 0x3        // 64 bytes
	UDPHS_EPTCFG4_EPT_SIZE_128   = 0x4        // 128 bytes
	UDPHS_EPTCFG4_EPT_SIZE_256   = 0x5        // 256 bytes
	UDPHS_EPTCFG4_EPT_SIZE_512   = 0x6        // 512 bytes
	UDPHS_EPTCFG4_EPT_SIZE_1024  = 0x7        // 1024 bytes
	UDPHS_EPTCFG4_EPT_DIR_Pos    = 0x3        // Position of EPT_DIR field.
	UDPHS_EPTCFG4_EPT_DIR_Msk    = 0x8        // Bit mask of EPT_DIR field.
	UDPHS_EPTCFG4_EPT_DIR        = 0x8        // Bit EPT_DIR.
	UDPHS_EPTCFG4_EPT_TYPE_Pos   = 0x4        // Position of EPT_TYPE field.
	UDPHS_EPTCFG4_EPT_TYPE_Msk   = 0x30       // Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG4_EPT_TYPE_CTRL8 = 0x0        // Control endpoint
	UDPHS_EPTCFG4_EPT_TYPE_ISO   = 0x1        // Isochronous endpoint
	UDPHS_EPTCFG4_EPT_TYPE_BULK  = 0x2        // Bulk endpoint
	UDPHS_EPTCFG4_EPT_TYPE_INT   = 0x3        // Interrupt endpoint
	UDPHS_EPTCFG4_BK_NUMBER_Pos  = 0x6        // Position of BK_NUMBER field.
	UDPHS_EPTCFG4_BK_NUMBER_Msk  = 0xc0       // Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG4_BK_NUMBER_0    = 0x0        // Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG4_BK_NUMBER_1    = 0x1        // One bank (bank 0)
	UDPHS_EPTCFG4_BK_NUMBER_2    = 0x2        // Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG4_BK_NUMBER_3    = 0x3        // Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG4_NB_TRANS_Pos   = 0x8        // Position of NB_TRANS field.
	UDPHS_EPTCFG4_NB_TRANS_Msk   = 0x300      // Bit mask of NB_TRANS field.
	UDPHS_EPTCFG4_EPT_MAPD_Pos   = 0x1f       // Position of EPT_MAPD field.
	UDPHS_EPTCFG4_EPT_MAPD_Msk   = 0x80000000 // Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG4_EPT_MAPD       = 0x80000000 // Bit EPT_MAPD.

	// EPTCTLENB4: UDPHS Endpoint Control Enable Register (endpoint = 4)
	UDPHS_EPTCTLENB4_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB4_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB4_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB4_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB4_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB4_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB4_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB4_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB4_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB4_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLENB4_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB4_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLENB4_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB4_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB4_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB4_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB4_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB4_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB4_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB4_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB4_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB4_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLENB4_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLENB4_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLENB4_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLENB4_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB4_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLENB4_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLENB4_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB4_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLENB4_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLENB4_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB4_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLENB4_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLENB4_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB4_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLENB4_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB4_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB4_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB4_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB4_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB4_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLENB4_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 4)
	UDPHS_EPTCTLENB4_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB4_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB4_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB4_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB4_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB4_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB4_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB4_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB4_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB4_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLENB4_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB4_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLENB4_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLENB4_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB4_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB4_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB4_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB4_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB4_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB4_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB4_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB4_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB4_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB4_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB4_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLENB4_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB4_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB4_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB4_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB4_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB4_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS4: UDPHS Endpoint Control Disable Register (endpoint = 4)
	UDPHS_EPTCTLDIS4_EPT_DISABL_Pos = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS4_EPT_DISABL_Msk = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS4_EPT_DISABL     = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS4_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS4_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS4_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS4_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS4_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS4_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS4_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLDIS4_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS4_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLDIS4_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS4_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS4_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS4_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS4_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS4_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS4_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS4_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS4_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS4_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLDIS4_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS4_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLDIS4_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLDIS4_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS4_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLDIS4_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLDIS4_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS4_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLDIS4_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLDIS4_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS4_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLDIS4_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLDIS4_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS4_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLDIS4_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS4_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS4_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS4_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS4_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS4_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS4_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 4)
	UDPHS_EPTCTLDIS4_ISOENDPT_EPT_DISABL_Pos  = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS4_ISOENDPT_EPT_DISABL_Msk  = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS4_ISOENDPT_EPT_DISABL      = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS4_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS4_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS4_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS4_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS4_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS4_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS4_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLDIS4_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS4_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLDIS4_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLDIS4_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS4_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS4_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS4_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS4_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS4_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS4_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS4_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS4_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS4_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS4_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS4_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS4_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS4_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS4_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS4_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS4_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS4_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL4: UDPHS Endpoint Control Register (endpoint = 4)
	UDPHS_EPTCTL4_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL4_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL4_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL4_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL4_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL4_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL4_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL4_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL4_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL4_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTL4_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTL4_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTL4_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL4_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL4_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL4_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL4_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL4_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL4_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL4_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL4_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL4_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTL4_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTL4_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTL4_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTL4_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTL4_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTL4_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTL4_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTL4_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTL4_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTL4_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTL4_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTL4_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTL4_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTL4_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTL4_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL4_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL4_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL4_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL4_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL4_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL4_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 4)
	UDPHS_EPTCTL4_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL4_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL4_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL4_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL4_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL4_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL4_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL4_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL4_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL4_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTL4_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTL4_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTL4_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTL4_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTL4_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTL4_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL4_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL4_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL4_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL4_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL4_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL4_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL4_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTL4_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL4_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTL4_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL4_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTL4_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL4_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL4_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL4_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL4_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL4_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTSETSTA4: UDPHS Endpoint Set Status Register (endpoint = 4)
	UDPHS_EPTSETSTA4_FRCESTALL_Pos  = 0x5   // Position of FRCESTALL field.
	UDPHS_EPTSETSTA4_FRCESTALL_Msk  = 0x20  // Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA4_FRCESTALL      = 0x20  // Bit FRCESTALL.
	UDPHS_EPTSETSTA4_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA4_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA4_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA4_TXRDY_Pos      = 0xb   // Position of TXRDY field.
	UDPHS_EPTSETSTA4_TXRDY_Msk      = 0x800 // Bit mask of TXRDY field.
	UDPHS_EPTSETSTA4_TXRDY          = 0x800 // Bit TXRDY.

	// EPTSETSTA4_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 4)
	UDPHS_EPTSETSTA4_ISOENDPT_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA4_ISOENDPT_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA4_ISOENDPT_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA4_ISOENDPT_TXRDY_TRER_Pos = 0xb   // Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA4_ISOENDPT_TXRDY_TRER_Msk = 0x800 // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA4_ISOENDPT_TXRDY_TRER     = 0x800 // Bit TXRDY_TRER.

	// EPTCLRSTA4: UDPHS Endpoint Clear Status Register (endpoint = 4)
	UDPHS_EPTCLRSTA4_FRCESTALL_Pos  = 0x5    // Position of FRCESTALL field.
	UDPHS_EPTCLRSTA4_FRCESTALL_Msk  = 0x20   // Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA4_FRCESTALL      = 0x20   // Bit FRCESTALL.
	UDPHS_EPTCLRSTA4_TOGGLESQ_Pos   = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA4_TOGGLESQ_Msk   = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA4_TOGGLESQ       = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA4_RXRDY_TXKL_Pos = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA4_RXRDY_TXKL_Msk = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA4_RXRDY_TXKL     = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA4_TX_COMPLT_Pos  = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA4_TX_COMPLT_Msk  = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA4_TX_COMPLT      = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA4_RX_SETUP_Pos   = 0xc    // Position of RX_SETUP field.
	UDPHS_EPTCLRSTA4_RX_SETUP_Msk   = 0x1000 // Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA4_RX_SETUP       = 0x1000 // Bit RX_SETUP.
	UDPHS_EPTCLRSTA4_STALL_SNT_Pos  = 0xd    // Position of STALL_SNT field.
	UDPHS_EPTCLRSTA4_STALL_SNT_Msk  = 0x2000 // Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA4_STALL_SNT      = 0x2000 // Bit STALL_SNT.
	UDPHS_EPTCLRSTA4_NAK_IN_Pos     = 0xe    // Position of NAK_IN field.
	UDPHS_EPTCLRSTA4_NAK_IN_Msk     = 0x4000 // Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA4_NAK_IN         = 0x4000 // Bit NAK_IN.
	UDPHS_EPTCLRSTA4_NAK_OUT_Pos    = 0xf    // Position of NAK_OUT field.
	UDPHS_EPTCLRSTA4_NAK_OUT_Msk    = 0x8000 // Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA4_NAK_OUT        = 0x8000 // Bit NAK_OUT.

	// EPTCLRSTA4_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 4)
	UDPHS_EPTCLRSTA4_ISOENDPT_TOGGLESQ_Pos    = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA4_ISOENDPT_TOGGLESQ_Msk    = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA4_ISOENDPT_TOGGLESQ        = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA4_ISOENDPT_RXRDY_TXKL_Pos  = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA4_ISOENDPT_RXRDY_TXKL_Msk  = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA4_ISOENDPT_RXRDY_TXKL      = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA4_ISOENDPT_TX_COMPLT_Pos   = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA4_ISOENDPT_TX_COMPLT_Msk   = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA4_ISOENDPT_TX_COMPLT       = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FL_ISO_Pos  = 0xc    // Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000 // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FL_ISO      = 0x1000 // Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_CRC_NTR_Pos = 0xd    // Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000 // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_CRC_NTR     = 0x2000 // Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FLUSH_Pos   = 0xe    // Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FLUSH_Msk   = 0x4000 // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA4_ISOENDPT_ERR_FLUSH       = 0x4000 // Bit ERR_FLUSH.

	// EPTSTA4: UDPHS Endpoint Status Register (endpoint = 4)
	UDPHS_EPTSTA4_FRCESTALL_Pos            = 0x5        // Position of FRCESTALL field.
	UDPHS_EPTSTA4_FRCESTALL_Msk            = 0x20       // Bit mask of FRCESTALL field.
	UDPHS_EPTSTA4_FRCESTALL                = 0x20       // Bit FRCESTALL.
	UDPHS_EPTSTA4_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA4_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA4_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA4_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA4_TOGGLESQ_STA_DATA2       = 0x2        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA4_TOGGLESQ_STA_MDATA       = 0x3        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA4_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA4_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA4_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA4_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA4_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA4_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA4_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA4_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA4_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA4_TXRDY_Pos                = 0xb        // Position of TXRDY field.
	UDPHS_EPTSTA4_TXRDY_Msk                = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTSTA4_TXRDY                    = 0x800      // Bit TXRDY.
	UDPHS_EPTSTA4_RX_SETUP_Pos             = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTSTA4_RX_SETUP_Msk             = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTSTA4_RX_SETUP                 = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTSTA4_STALL_SNT_Pos            = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTSTA4_STALL_SNT_Msk            = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTSTA4_STALL_SNT                = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTSTA4_NAK_IN_Pos               = 0xe        // Position of NAK_IN field.
	UDPHS_EPTSTA4_NAK_IN_Msk               = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTSTA4_NAK_IN                   = 0x4000     // Bit NAK_IN.
	UDPHS_EPTSTA4_NAK_OUT_Pos              = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTSTA4_NAK_OUT_Msk              = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTSTA4_NAK_OUT                  = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTSTA4_CURBK_CTLDIR_Pos         = 0x10       // Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA4_CURBK_CTLDIR_Msk         = 0x30000    // Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA4_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA4_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA4_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA4_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA4_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA4_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA4_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA4_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA4_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA4_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTSTA4_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 4)
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_DATA2       = 0x2        // Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA4_ISOENDPT_TOGGLESQ_STA_MDATA       = 0x3        // MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA4_ISOENDPT_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA4_ISOENDPT_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA4_ISOENDPT_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA4_ISOENDPT_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA4_ISOENDPT_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA4_ISOENDPT_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA4_ISOENDPT_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA4_ISOENDPT_TXRDY_TRER_Pos           = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTSTA4_ISOENDPT_TXRDY_TRER_Msk           = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA4_ISOENDPT_TXRDY_TRER               = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FL_ISO_Pos           = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FL_ISO_Msk           = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FL_ISO               = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTSTA4_ISOENDPT_ERR_CRC_NTR_Pos          = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_CRC_NTR_Msk          = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_CRC_NTR              = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FLUSH_Pos            = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FLUSH_Msk            = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA4_ISOENDPT_ERR_FLUSH                = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTSTA4_ISOENDPT_CURBK_Pos                = 0x10       // Position of CURBK field.
	UDPHS_EPTSTA4_ISOENDPT_CURBK_Msk                = 0x30000    // Bit mask of CURBK field.
	UDPHS_EPTSTA4_ISOENDPT_CURBK_BANK0              = 0x0        // Bank 0 (or single bank)
	UDPHS_EPTSTA4_ISOENDPT_CURBK_BANK1              = 0x1        // Bank 1
	UDPHS_EPTSTA4_ISOENDPT_CURBK_BANK2              = 0x2        // Bank 2
	UDPHS_EPTSTA4_ISOENDPT_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA4_ISOENDPT_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA4_ISOENDPT_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA4_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA4_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA4_ISOENDPT_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA4_ISOENDPT_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA4_ISOENDPT_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA4_ISOENDPT_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA4_ISOENDPT_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTCFG5: UDPHS Endpoint Configuration Register (endpoint = 5)
	UDPHS_EPTCFG5_EPT_SIZE_Pos   = 0x0        // Position of EPT_SIZE field.
	UDPHS_EPTCFG5_EPT_SIZE_Msk   = 0x7        // Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG5_EPT_SIZE_8     = 0x0        // 8 bytes
	UDPHS_EPTCFG5_EPT_SIZE_16    = 0x1        // 16 bytes
	UDPHS_EPTCFG5_EPT_SIZE_32    = 0x2        // 32 bytes
	UDPHS_EPTCFG5_EPT_SIZE_64    = 0x3        // 64 bytes
	UDPHS_EPTCFG5_EPT_SIZE_128   = 0x4        // 128 bytes
	UDPHS_EPTCFG5_EPT_SIZE_256   = 0x5        // 256 bytes
	UDPHS_EPTCFG5_EPT_SIZE_512   = 0x6        // 512 bytes
	UDPHS_EPTCFG5_EPT_SIZE_1024  = 0x7        // 1024 bytes
	UDPHS_EPTCFG5_EPT_DIR_Pos    = 0x3        // Position of EPT_DIR field.
	UDPHS_EPTCFG5_EPT_DIR_Msk    = 0x8        // Bit mask of EPT_DIR field.
	UDPHS_EPTCFG5_EPT_DIR        = 0x8        // Bit EPT_DIR.
	UDPHS_EPTCFG5_EPT_TYPE_Pos   = 0x4        // Position of EPT_TYPE field.
	UDPHS_EPTCFG5_EPT_TYPE_Msk   = 0x30       // Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG5_EPT_TYPE_CTRL8 = 0x0        // Control endpoint
	UDPHS_EPTCFG5_EPT_TYPE_ISO   = 0x1        // Isochronous endpoint
	UDPHS_EPTCFG5_EPT_TYPE_BULK  = 0x2        // Bulk endpoint
	UDPHS_EPTCFG5_EPT_TYPE_INT   = 0x3        // Interrupt endpoint
	UDPHS_EPTCFG5_BK_NUMBER_Pos  = 0x6        // Position of BK_NUMBER field.
	UDPHS_EPTCFG5_BK_NUMBER_Msk  = 0xc0       // Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG5_BK_NUMBER_0    = 0x0        // Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG5_BK_NUMBER_1    = 0x1        // One bank (bank 0)
	UDPHS_EPTCFG5_BK_NUMBER_2    = 0x2        // Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG5_BK_NUMBER_3    = 0x3        // Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG5_NB_TRANS_Pos   = 0x8        // Position of NB_TRANS field.
	UDPHS_EPTCFG5_NB_TRANS_Msk   = 0x300      // Bit mask of NB_TRANS field.
	UDPHS_EPTCFG5_EPT_MAPD_Pos   = 0x1f       // Position of EPT_MAPD field.
	UDPHS_EPTCFG5_EPT_MAPD_Msk   = 0x80000000 // Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG5_EPT_MAPD       = 0x80000000 // Bit EPT_MAPD.

	// EPTCTLENB5: UDPHS Endpoint Control Enable Register (endpoint = 5)
	UDPHS_EPTCTLENB5_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB5_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB5_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB5_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB5_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB5_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB5_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB5_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB5_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB5_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLENB5_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB5_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLENB5_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB5_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB5_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB5_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB5_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB5_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB5_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB5_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB5_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB5_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLENB5_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLENB5_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLENB5_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLENB5_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB5_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLENB5_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLENB5_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB5_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLENB5_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLENB5_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB5_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLENB5_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLENB5_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB5_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLENB5_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB5_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB5_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB5_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB5_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB5_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLENB5_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 5)
	UDPHS_EPTCTLENB5_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB5_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB5_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB5_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB5_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB5_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB5_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB5_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB5_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB5_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLENB5_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB5_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLENB5_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLENB5_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB5_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB5_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB5_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB5_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB5_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB5_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB5_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB5_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB5_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB5_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB5_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLENB5_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB5_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB5_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB5_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB5_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB5_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS5: UDPHS Endpoint Control Disable Register (endpoint = 5)
	UDPHS_EPTCTLDIS5_EPT_DISABL_Pos = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS5_EPT_DISABL_Msk = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS5_EPT_DISABL     = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS5_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS5_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS5_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS5_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS5_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS5_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS5_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLDIS5_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS5_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLDIS5_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS5_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS5_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS5_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS5_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS5_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS5_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS5_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS5_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS5_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLDIS5_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS5_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLDIS5_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLDIS5_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS5_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLDIS5_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLDIS5_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS5_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLDIS5_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLDIS5_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS5_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLDIS5_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLDIS5_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS5_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLDIS5_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS5_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS5_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS5_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS5_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS5_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS5_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 5)
	UDPHS_EPTCTLDIS5_ISOENDPT_EPT_DISABL_Pos  = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS5_ISOENDPT_EPT_DISABL_Msk  = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS5_ISOENDPT_EPT_DISABL      = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS5_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS5_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS5_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS5_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS5_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS5_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS5_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLDIS5_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS5_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLDIS5_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLDIS5_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS5_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS5_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS5_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS5_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS5_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS5_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS5_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS5_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS5_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS5_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS5_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS5_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS5_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS5_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS5_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS5_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS5_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL5: UDPHS Endpoint Control Register (endpoint = 5)
	UDPHS_EPTCTL5_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL5_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL5_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL5_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL5_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL5_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL5_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL5_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL5_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL5_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTL5_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTL5_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTL5_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL5_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL5_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL5_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL5_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL5_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL5_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL5_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL5_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL5_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTL5_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTL5_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTL5_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTL5_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTL5_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTL5_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTL5_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTL5_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTL5_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTL5_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTL5_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTL5_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTL5_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTL5_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTL5_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL5_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL5_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL5_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL5_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL5_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL5_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 5)
	UDPHS_EPTCTL5_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL5_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL5_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL5_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL5_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL5_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL5_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL5_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL5_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL5_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTL5_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTL5_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTL5_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTL5_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTL5_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTL5_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL5_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL5_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL5_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL5_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL5_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL5_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL5_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTL5_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL5_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTL5_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL5_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTL5_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL5_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL5_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL5_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL5_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL5_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTSETSTA5: UDPHS Endpoint Set Status Register (endpoint = 5)
	UDPHS_EPTSETSTA5_FRCESTALL_Pos  = 0x5   // Position of FRCESTALL field.
	UDPHS_EPTSETSTA5_FRCESTALL_Msk  = 0x20  // Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA5_FRCESTALL      = 0x20  // Bit FRCESTALL.
	UDPHS_EPTSETSTA5_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA5_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA5_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA5_TXRDY_Pos      = 0xb   // Position of TXRDY field.
	UDPHS_EPTSETSTA5_TXRDY_Msk      = 0x800 // Bit mask of TXRDY field.
	UDPHS_EPTSETSTA5_TXRDY          = 0x800 // Bit TXRDY.

	// EPTSETSTA5_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 5)
	UDPHS_EPTSETSTA5_ISOENDPT_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA5_ISOENDPT_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA5_ISOENDPT_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA5_ISOENDPT_TXRDY_TRER_Pos = 0xb   // Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA5_ISOENDPT_TXRDY_TRER_Msk = 0x800 // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA5_ISOENDPT_TXRDY_TRER     = 0x800 // Bit TXRDY_TRER.

	// EPTCLRSTA5: UDPHS Endpoint Clear Status Register (endpoint = 5)
	UDPHS_EPTCLRSTA5_FRCESTALL_Pos  = 0x5    // Position of FRCESTALL field.
	UDPHS_EPTCLRSTA5_FRCESTALL_Msk  = 0x20   // Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA5_FRCESTALL      = 0x20   // Bit FRCESTALL.
	UDPHS_EPTCLRSTA5_TOGGLESQ_Pos   = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA5_TOGGLESQ_Msk   = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA5_TOGGLESQ       = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA5_RXRDY_TXKL_Pos = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA5_RXRDY_TXKL_Msk = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA5_RXRDY_TXKL     = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA5_TX_COMPLT_Pos  = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA5_TX_COMPLT_Msk  = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA5_TX_COMPLT      = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA5_RX_SETUP_Pos   = 0xc    // Position of RX_SETUP field.
	UDPHS_EPTCLRSTA5_RX_SETUP_Msk   = 0x1000 // Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA5_RX_SETUP       = 0x1000 // Bit RX_SETUP.
	UDPHS_EPTCLRSTA5_STALL_SNT_Pos  = 0xd    // Position of STALL_SNT field.
	UDPHS_EPTCLRSTA5_STALL_SNT_Msk  = 0x2000 // Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA5_STALL_SNT      = 0x2000 // Bit STALL_SNT.
	UDPHS_EPTCLRSTA5_NAK_IN_Pos     = 0xe    // Position of NAK_IN field.
	UDPHS_EPTCLRSTA5_NAK_IN_Msk     = 0x4000 // Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA5_NAK_IN         = 0x4000 // Bit NAK_IN.
	UDPHS_EPTCLRSTA5_NAK_OUT_Pos    = 0xf    // Position of NAK_OUT field.
	UDPHS_EPTCLRSTA5_NAK_OUT_Msk    = 0x8000 // Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA5_NAK_OUT        = 0x8000 // Bit NAK_OUT.

	// EPTCLRSTA5_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 5)
	UDPHS_EPTCLRSTA5_ISOENDPT_TOGGLESQ_Pos    = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA5_ISOENDPT_TOGGLESQ_Msk    = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA5_ISOENDPT_TOGGLESQ        = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA5_ISOENDPT_RXRDY_TXKL_Pos  = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA5_ISOENDPT_RXRDY_TXKL_Msk  = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA5_ISOENDPT_RXRDY_TXKL      = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA5_ISOENDPT_TX_COMPLT_Pos   = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA5_ISOENDPT_TX_COMPLT_Msk   = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA5_ISOENDPT_TX_COMPLT       = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FL_ISO_Pos  = 0xc    // Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000 // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FL_ISO      = 0x1000 // Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_CRC_NTR_Pos = 0xd    // Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000 // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_CRC_NTR     = 0x2000 // Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FLUSH_Pos   = 0xe    // Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FLUSH_Msk   = 0x4000 // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA5_ISOENDPT_ERR_FLUSH       = 0x4000 // Bit ERR_FLUSH.

	// EPTSTA5: UDPHS Endpoint Status Register (endpoint = 5)
	UDPHS_EPTSTA5_FRCESTALL_Pos            = 0x5        // Position of FRCESTALL field.
	UDPHS_EPTSTA5_FRCESTALL_Msk            = 0x20       // Bit mask of FRCESTALL field.
	UDPHS_EPTSTA5_FRCESTALL                = 0x20       // Bit FRCESTALL.
	UDPHS_EPTSTA5_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA5_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA5_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA5_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA5_TOGGLESQ_STA_DATA2       = 0x2        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA5_TOGGLESQ_STA_MDATA       = 0x3        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA5_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA5_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA5_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA5_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA5_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA5_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA5_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA5_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA5_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA5_TXRDY_Pos                = 0xb        // Position of TXRDY field.
	UDPHS_EPTSTA5_TXRDY_Msk                = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTSTA5_TXRDY                    = 0x800      // Bit TXRDY.
	UDPHS_EPTSTA5_RX_SETUP_Pos             = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTSTA5_RX_SETUP_Msk             = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTSTA5_RX_SETUP                 = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTSTA5_STALL_SNT_Pos            = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTSTA5_STALL_SNT_Msk            = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTSTA5_STALL_SNT                = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTSTA5_NAK_IN_Pos               = 0xe        // Position of NAK_IN field.
	UDPHS_EPTSTA5_NAK_IN_Msk               = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTSTA5_NAK_IN                   = 0x4000     // Bit NAK_IN.
	UDPHS_EPTSTA5_NAK_OUT_Pos              = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTSTA5_NAK_OUT_Msk              = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTSTA5_NAK_OUT                  = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTSTA5_CURBK_CTLDIR_Pos         = 0x10       // Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA5_CURBK_CTLDIR_Msk         = 0x30000    // Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA5_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA5_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA5_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA5_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA5_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA5_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA5_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA5_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA5_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA5_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTSTA5_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 5)
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_DATA2       = 0x2        // Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA5_ISOENDPT_TOGGLESQ_STA_MDATA       = 0x3        // MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA5_ISOENDPT_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA5_ISOENDPT_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA5_ISOENDPT_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA5_ISOENDPT_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA5_ISOENDPT_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA5_ISOENDPT_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA5_ISOENDPT_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA5_ISOENDPT_TXRDY_TRER_Pos           = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTSTA5_ISOENDPT_TXRDY_TRER_Msk           = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA5_ISOENDPT_TXRDY_TRER               = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FL_ISO_Pos           = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FL_ISO_Msk           = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FL_ISO               = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTSTA5_ISOENDPT_ERR_CRC_NTR_Pos          = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_CRC_NTR_Msk          = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_CRC_NTR              = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FLUSH_Pos            = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FLUSH_Msk            = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA5_ISOENDPT_ERR_FLUSH                = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTSTA5_ISOENDPT_CURBK_Pos                = 0x10       // Position of CURBK field.
	UDPHS_EPTSTA5_ISOENDPT_CURBK_Msk                = 0x30000    // Bit mask of CURBK field.
	UDPHS_EPTSTA5_ISOENDPT_CURBK_BANK0              = 0x0        // Bank 0 (or single bank)
	UDPHS_EPTSTA5_ISOENDPT_CURBK_BANK1              = 0x1        // Bank 1
	UDPHS_EPTSTA5_ISOENDPT_CURBK_BANK2              = 0x2        // Bank 2
	UDPHS_EPTSTA5_ISOENDPT_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA5_ISOENDPT_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA5_ISOENDPT_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA5_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA5_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA5_ISOENDPT_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA5_ISOENDPT_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA5_ISOENDPT_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA5_ISOENDPT_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA5_ISOENDPT_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTCFG6: UDPHS Endpoint Configuration Register (endpoint = 6)
	UDPHS_EPTCFG6_EPT_SIZE_Pos   = 0x0        // Position of EPT_SIZE field.
	UDPHS_EPTCFG6_EPT_SIZE_Msk   = 0x7        // Bit mask of EPT_SIZE field.
	UDPHS_EPTCFG6_EPT_SIZE_8     = 0x0        // 8 bytes
	UDPHS_EPTCFG6_EPT_SIZE_16    = 0x1        // 16 bytes
	UDPHS_EPTCFG6_EPT_SIZE_32    = 0x2        // 32 bytes
	UDPHS_EPTCFG6_EPT_SIZE_64    = 0x3        // 64 bytes
	UDPHS_EPTCFG6_EPT_SIZE_128   = 0x4        // 128 bytes
	UDPHS_EPTCFG6_EPT_SIZE_256   = 0x5        // 256 bytes
	UDPHS_EPTCFG6_EPT_SIZE_512   = 0x6        // 512 bytes
	UDPHS_EPTCFG6_EPT_SIZE_1024  = 0x7        // 1024 bytes
	UDPHS_EPTCFG6_EPT_DIR_Pos    = 0x3        // Position of EPT_DIR field.
	UDPHS_EPTCFG6_EPT_DIR_Msk    = 0x8        // Bit mask of EPT_DIR field.
	UDPHS_EPTCFG6_EPT_DIR        = 0x8        // Bit EPT_DIR.
	UDPHS_EPTCFG6_EPT_TYPE_Pos   = 0x4        // Position of EPT_TYPE field.
	UDPHS_EPTCFG6_EPT_TYPE_Msk   = 0x30       // Bit mask of EPT_TYPE field.
	UDPHS_EPTCFG6_EPT_TYPE_CTRL8 = 0x0        // Control endpoint
	UDPHS_EPTCFG6_EPT_TYPE_ISO   = 0x1        // Isochronous endpoint
	UDPHS_EPTCFG6_EPT_TYPE_BULK  = 0x2        // Bulk endpoint
	UDPHS_EPTCFG6_EPT_TYPE_INT   = 0x3        // Interrupt endpoint
	UDPHS_EPTCFG6_BK_NUMBER_Pos  = 0x6        // Position of BK_NUMBER field.
	UDPHS_EPTCFG6_BK_NUMBER_Msk  = 0xc0       // Bit mask of BK_NUMBER field.
	UDPHS_EPTCFG6_BK_NUMBER_0    = 0x0        // Zero bank, the endpoint is not mapped in memory
	UDPHS_EPTCFG6_BK_NUMBER_1    = 0x1        // One bank (bank 0)
	UDPHS_EPTCFG6_BK_NUMBER_2    = 0x2        // Double bank (Ping-Pong: bank0/bank1)
	UDPHS_EPTCFG6_BK_NUMBER_3    = 0x3        // Triple bank (bank0/bank1/bank2)
	UDPHS_EPTCFG6_NB_TRANS_Pos   = 0x8        // Position of NB_TRANS field.
	UDPHS_EPTCFG6_NB_TRANS_Msk   = 0x300      // Bit mask of NB_TRANS field.
	UDPHS_EPTCFG6_EPT_MAPD_Pos   = 0x1f       // Position of EPT_MAPD field.
	UDPHS_EPTCFG6_EPT_MAPD_Msk   = 0x80000000 // Bit mask of EPT_MAPD field.
	UDPHS_EPTCFG6_EPT_MAPD       = 0x80000000 // Bit EPT_MAPD.

	// EPTCTLENB6: UDPHS Endpoint Control Enable Register (endpoint = 6)
	UDPHS_EPTCTLENB6_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB6_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB6_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB6_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB6_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB6_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB6_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB6_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB6_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB6_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLENB6_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLENB6_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLENB6_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB6_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB6_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB6_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB6_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB6_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB6_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB6_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB6_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB6_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLENB6_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLENB6_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLENB6_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLENB6_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLENB6_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLENB6_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLENB6_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLENB6_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLENB6_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLENB6_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLENB6_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLENB6_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLENB6_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLENB6_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLENB6_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB6_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB6_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB6_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB6_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB6_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLENB6_ISOENDPT: UDPHS Endpoint Control Enable Register (endpoint = 6)
	UDPHS_EPTCTLENB6_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTLENB6_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTLENB6_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTLENB6_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLENB6_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLENB6_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLENB6_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLENB6_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLENB6_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLENB6_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLENB6_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLENB6_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLENB6_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLENB6_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLENB6_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLENB6_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLENB6_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLENB6_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLENB6_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLENB6_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLENB6_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLENB6_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLENB6_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLENB6_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLENB6_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLENB6_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLENB6_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLENB6_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLENB6_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLENB6_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLENB6_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS6: UDPHS Endpoint Control Disable Register (endpoint = 6)
	UDPHS_EPTCTLDIS6_EPT_DISABL_Pos = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS6_EPT_DISABL_Msk = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS6_EPT_DISABL     = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS6_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS6_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS6_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS6_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS6_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS6_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS6_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTLDIS6_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTLDIS6_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTLDIS6_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS6_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS6_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS6_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS6_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS6_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS6_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS6_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS6_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS6_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTLDIS6_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTLDIS6_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTLDIS6_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTLDIS6_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTLDIS6_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTLDIS6_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTLDIS6_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTLDIS6_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTLDIS6_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTLDIS6_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTLDIS6_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTLDIS6_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTLDIS6_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTLDIS6_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTLDIS6_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS6_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS6_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS6_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS6_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS6_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTLDIS6_ISOENDPT: UDPHS Endpoint Control Disable Register (endpoint = 6)
	UDPHS_EPTCTLDIS6_ISOENDPT_EPT_DISABL_Pos  = 0x0        // Position of EPT_DISABL field.
	UDPHS_EPTCTLDIS6_ISOENDPT_EPT_DISABL_Msk  = 0x1        // Bit mask of EPT_DISABL field.
	UDPHS_EPTCTLDIS6_ISOENDPT_EPT_DISABL      = 0x1        // Bit EPT_DISABL.
	UDPHS_EPTCTLDIS6_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTLDIS6_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTLDIS6_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTLDIS6_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTLDIS6_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTLDIS6_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTLDIS6_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTLDIS6_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTLDIS6_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTLDIS6_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTLDIS6_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTLDIS6_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTLDIS6_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS6_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTLDIS6_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTLDIS6_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTLDIS6_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTLDIS6_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTLDIS6_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTLDIS6_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTLDIS6_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTLDIS6_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTLDIS6_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTLDIS6_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTLDIS6_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTLDIS6_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTLDIS6_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTLDIS6_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL6: UDPHS Endpoint Control Register (endpoint = 6)
	UDPHS_EPTCTL6_EPT_ENABL_Pos  = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL6_EPT_ENABL_Msk  = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL6_EPT_ENABL      = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL6_AUTO_VALID_Pos = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL6_AUTO_VALID_Msk = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL6_AUTO_VALID     = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL6_INTDIS_DMA_Pos = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL6_INTDIS_DMA_Msk = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL6_INTDIS_DMA     = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL6_NYET_DIS_Pos   = 0x4        // Position of NYET_DIS field.
	UDPHS_EPTCTL6_NYET_DIS_Msk   = 0x10       // Bit mask of NYET_DIS field.
	UDPHS_EPTCTL6_NYET_DIS       = 0x10       // Bit NYET_DIS.
	UDPHS_EPTCTL6_ERR_OVFLW_Pos  = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL6_ERR_OVFLW_Msk  = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL6_ERR_OVFLW      = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL6_RXRDY_TXKL_Pos = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL6_RXRDY_TXKL_Msk = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL6_RXRDY_TXKL     = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL6_TX_COMPLT_Pos  = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL6_TX_COMPLT_Msk  = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL6_TX_COMPLT      = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL6_TXRDY_Pos      = 0xb        // Position of TXRDY field.
	UDPHS_EPTCTL6_TXRDY_Msk      = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTCTL6_TXRDY          = 0x800      // Bit TXRDY.
	UDPHS_EPTCTL6_RX_SETUP_Pos   = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTCTL6_RX_SETUP_Msk   = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTCTL6_RX_SETUP       = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTCTL6_STALL_SNT_Pos  = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTCTL6_STALL_SNT_Msk  = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTCTL6_STALL_SNT      = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTCTL6_NAK_IN_Pos     = 0xe        // Position of NAK_IN field.
	UDPHS_EPTCTL6_NAK_IN_Msk     = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTCTL6_NAK_IN         = 0x4000     // Bit NAK_IN.
	UDPHS_EPTCTL6_NAK_OUT_Pos    = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTCTL6_NAK_OUT_Msk    = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTCTL6_NAK_OUT        = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTCTL6_BUSY_BANK_Pos  = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL6_BUSY_BANK_Msk  = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL6_BUSY_BANK      = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL6_SHRT_PCKT_Pos  = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL6_SHRT_PCKT_Msk  = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL6_SHRT_PCKT      = 0x80000000 // Bit SHRT_PCKT.

	// EPTCTL6_ISOENDPT: UDPHS Endpoint Control Register (endpoint = 6)
	UDPHS_EPTCTL6_ISOENDPT_EPT_ENABL_Pos   = 0x0        // Position of EPT_ENABL field.
	UDPHS_EPTCTL6_ISOENDPT_EPT_ENABL_Msk   = 0x1        // Bit mask of EPT_ENABL field.
	UDPHS_EPTCTL6_ISOENDPT_EPT_ENABL       = 0x1        // Bit EPT_ENABL.
	UDPHS_EPTCTL6_ISOENDPT_AUTO_VALID_Pos  = 0x1        // Position of AUTO_VALID field.
	UDPHS_EPTCTL6_ISOENDPT_AUTO_VALID_Msk  = 0x2        // Bit mask of AUTO_VALID field.
	UDPHS_EPTCTL6_ISOENDPT_AUTO_VALID      = 0x2        // Bit AUTO_VALID.
	UDPHS_EPTCTL6_ISOENDPT_INTDIS_DMA_Pos  = 0x3        // Position of INTDIS_DMA field.
	UDPHS_EPTCTL6_ISOENDPT_INTDIS_DMA_Msk  = 0x8        // Bit mask of INTDIS_DMA field.
	UDPHS_EPTCTL6_ISOENDPT_INTDIS_DMA      = 0x8        // Bit INTDIS_DMA.
	UDPHS_EPTCTL6_ISOENDPT_DATAX_RX_Pos    = 0x6        // Position of DATAX_RX field.
	UDPHS_EPTCTL6_ISOENDPT_DATAX_RX_Msk    = 0x40       // Bit mask of DATAX_RX field.
	UDPHS_EPTCTL6_ISOENDPT_DATAX_RX        = 0x40       // Bit DATAX_RX.
	UDPHS_EPTCTL6_ISOENDPT_MDATA_RX_Pos    = 0x7        // Position of MDATA_RX field.
	UDPHS_EPTCTL6_ISOENDPT_MDATA_RX_Msk    = 0x80       // Bit mask of MDATA_RX field.
	UDPHS_EPTCTL6_ISOENDPT_MDATA_RX        = 0x80       // Bit MDATA_RX.
	UDPHS_EPTCTL6_ISOENDPT_ERR_OVFLW_Pos   = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_OVFLW_Msk   = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_OVFLW       = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTCTL6_ISOENDPT_RXRDY_TXKL_Pos  = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTCTL6_ISOENDPT_RXRDY_TXKL_Msk  = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCTL6_ISOENDPT_RXRDY_TXKL      = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTCTL6_ISOENDPT_TX_COMPLT_Pos   = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTCTL6_ISOENDPT_TX_COMPLT_Msk   = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTCTL6_ISOENDPT_TX_COMPLT       = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTCTL6_ISOENDPT_TXRDY_TRER_Pos  = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTCTL6_ISOENDPT_TXRDY_TRER_Msk  = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTCTL6_ISOENDPT_TXRDY_TRER      = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FL_ISO_Pos  = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FL_ISO      = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTCTL6_ISOENDPT_ERR_CRC_NTR_Pos = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_CRC_NTR     = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FLUSH_Pos   = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FLUSH_Msk   = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCTL6_ISOENDPT_ERR_FLUSH       = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTCTL6_ISOENDPT_BUSY_BANK_Pos   = 0x12       // Position of BUSY_BANK field.
	UDPHS_EPTCTL6_ISOENDPT_BUSY_BANK_Msk   = 0x40000    // Bit mask of BUSY_BANK field.
	UDPHS_EPTCTL6_ISOENDPT_BUSY_BANK       = 0x40000    // Bit BUSY_BANK.
	UDPHS_EPTCTL6_ISOENDPT_SHRT_PCKT_Pos   = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTCTL6_ISOENDPT_SHRT_PCKT_Msk   = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTCTL6_ISOENDPT_SHRT_PCKT       = 0x80000000 // Bit SHRT_PCKT.

	// EPTSETSTA6: UDPHS Endpoint Set Status Register (endpoint = 6)
	UDPHS_EPTSETSTA6_FRCESTALL_Pos  = 0x5   // Position of FRCESTALL field.
	UDPHS_EPTSETSTA6_FRCESTALL_Msk  = 0x20  // Bit mask of FRCESTALL field.
	UDPHS_EPTSETSTA6_FRCESTALL      = 0x20  // Bit FRCESTALL.
	UDPHS_EPTSETSTA6_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA6_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA6_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA6_TXRDY_Pos      = 0xb   // Position of TXRDY field.
	UDPHS_EPTSETSTA6_TXRDY_Msk      = 0x800 // Bit mask of TXRDY field.
	UDPHS_EPTSETSTA6_TXRDY          = 0x800 // Bit TXRDY.

	// EPTSETSTA6_ISOENDPT: UDPHS Endpoint Set Status Register (endpoint = 6)
	UDPHS_EPTSETSTA6_ISOENDPT_RXRDY_TXKL_Pos = 0x9   // Position of RXRDY_TXKL field.
	UDPHS_EPTSETSTA6_ISOENDPT_RXRDY_TXKL_Msk = 0x200 // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSETSTA6_ISOENDPT_RXRDY_TXKL     = 0x200 // Bit RXRDY_TXKL.
	UDPHS_EPTSETSTA6_ISOENDPT_TXRDY_TRER_Pos = 0xb   // Position of TXRDY_TRER field.
	UDPHS_EPTSETSTA6_ISOENDPT_TXRDY_TRER_Msk = 0x800 // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSETSTA6_ISOENDPT_TXRDY_TRER     = 0x800 // Bit TXRDY_TRER.

	// EPTCLRSTA6: UDPHS Endpoint Clear Status Register (endpoint = 6)
	UDPHS_EPTCLRSTA6_FRCESTALL_Pos  = 0x5    // Position of FRCESTALL field.
	UDPHS_EPTCLRSTA6_FRCESTALL_Msk  = 0x20   // Bit mask of FRCESTALL field.
	UDPHS_EPTCLRSTA6_FRCESTALL      = 0x20   // Bit FRCESTALL.
	UDPHS_EPTCLRSTA6_TOGGLESQ_Pos   = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA6_TOGGLESQ_Msk   = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA6_TOGGLESQ       = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA6_RXRDY_TXKL_Pos = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA6_RXRDY_TXKL_Msk = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA6_RXRDY_TXKL     = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA6_TX_COMPLT_Pos  = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA6_TX_COMPLT_Msk  = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA6_TX_COMPLT      = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA6_RX_SETUP_Pos   = 0xc    // Position of RX_SETUP field.
	UDPHS_EPTCLRSTA6_RX_SETUP_Msk   = 0x1000 // Bit mask of RX_SETUP field.
	UDPHS_EPTCLRSTA6_RX_SETUP       = 0x1000 // Bit RX_SETUP.
	UDPHS_EPTCLRSTA6_STALL_SNT_Pos  = 0xd    // Position of STALL_SNT field.
	UDPHS_EPTCLRSTA6_STALL_SNT_Msk  = 0x2000 // Bit mask of STALL_SNT field.
	UDPHS_EPTCLRSTA6_STALL_SNT      = 0x2000 // Bit STALL_SNT.
	UDPHS_EPTCLRSTA6_NAK_IN_Pos     = 0xe    // Position of NAK_IN field.
	UDPHS_EPTCLRSTA6_NAK_IN_Msk     = 0x4000 // Bit mask of NAK_IN field.
	UDPHS_EPTCLRSTA6_NAK_IN         = 0x4000 // Bit NAK_IN.
	UDPHS_EPTCLRSTA6_NAK_OUT_Pos    = 0xf    // Position of NAK_OUT field.
	UDPHS_EPTCLRSTA6_NAK_OUT_Msk    = 0x8000 // Bit mask of NAK_OUT field.
	UDPHS_EPTCLRSTA6_NAK_OUT        = 0x8000 // Bit NAK_OUT.

	// EPTCLRSTA6_ISOENDPT: UDPHS Endpoint Clear Status Register (endpoint = 6)
	UDPHS_EPTCLRSTA6_ISOENDPT_TOGGLESQ_Pos    = 0x6    // Position of TOGGLESQ field.
	UDPHS_EPTCLRSTA6_ISOENDPT_TOGGLESQ_Msk    = 0x40   // Bit mask of TOGGLESQ field.
	UDPHS_EPTCLRSTA6_ISOENDPT_TOGGLESQ        = 0x40   // Bit TOGGLESQ.
	UDPHS_EPTCLRSTA6_ISOENDPT_RXRDY_TXKL_Pos  = 0x9    // Position of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA6_ISOENDPT_RXRDY_TXKL_Msk  = 0x200  // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTCLRSTA6_ISOENDPT_RXRDY_TXKL      = 0x200  // Bit RXRDY_TXKL.
	UDPHS_EPTCLRSTA6_ISOENDPT_TX_COMPLT_Pos   = 0xa    // Position of TX_COMPLT field.
	UDPHS_EPTCLRSTA6_ISOENDPT_TX_COMPLT_Msk   = 0x400  // Bit mask of TX_COMPLT field.
	UDPHS_EPTCLRSTA6_ISOENDPT_TX_COMPLT       = 0x400  // Bit TX_COMPLT.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FL_ISO_Pos  = 0xc    // Position of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FL_ISO_Msk  = 0x1000 // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FL_ISO      = 0x1000 // Bit ERR_FL_ISO.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_CRC_NTR_Pos = 0xd    // Position of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_CRC_NTR_Msk = 0x2000 // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_CRC_NTR     = 0x2000 // Bit ERR_CRC_NTR.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FLUSH_Pos   = 0xe    // Position of ERR_FLUSH field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FLUSH_Msk   = 0x4000 // Bit mask of ERR_FLUSH field.
	UDPHS_EPTCLRSTA6_ISOENDPT_ERR_FLUSH       = 0x4000 // Bit ERR_FLUSH.

	// EPTSTA6: UDPHS Endpoint Status Register (endpoint = 6)
	UDPHS_EPTSTA6_FRCESTALL_Pos            = 0x5        // Position of FRCESTALL field.
	UDPHS_EPTSTA6_FRCESTALL_Msk            = 0x20       // Bit mask of FRCESTALL field.
	UDPHS_EPTSTA6_FRCESTALL                = 0x20       // Bit FRCESTALL.
	UDPHS_EPTSTA6_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA6_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA6_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA6_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA6_TOGGLESQ_STA_DATA2       = 0x2        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA6_TOGGLESQ_STA_MDATA       = 0x3        // Reserved for High Bandwidth Isochronous Endpoint
	UDPHS_EPTSTA6_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA6_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA6_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA6_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA6_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA6_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA6_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA6_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA6_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA6_TXRDY_Pos                = 0xb        // Position of TXRDY field.
	UDPHS_EPTSTA6_TXRDY_Msk                = 0x800      // Bit mask of TXRDY field.
	UDPHS_EPTSTA6_TXRDY                    = 0x800      // Bit TXRDY.
	UDPHS_EPTSTA6_RX_SETUP_Pos             = 0xc        // Position of RX_SETUP field.
	UDPHS_EPTSTA6_RX_SETUP_Msk             = 0x1000     // Bit mask of RX_SETUP field.
	UDPHS_EPTSTA6_RX_SETUP                 = 0x1000     // Bit RX_SETUP.
	UDPHS_EPTSTA6_STALL_SNT_Pos            = 0xd        // Position of STALL_SNT field.
	UDPHS_EPTSTA6_STALL_SNT_Msk            = 0x2000     // Bit mask of STALL_SNT field.
	UDPHS_EPTSTA6_STALL_SNT                = 0x2000     // Bit STALL_SNT.
	UDPHS_EPTSTA6_NAK_IN_Pos               = 0xe        // Position of NAK_IN field.
	UDPHS_EPTSTA6_NAK_IN_Msk               = 0x4000     // Bit mask of NAK_IN field.
	UDPHS_EPTSTA6_NAK_IN                   = 0x4000     // Bit NAK_IN.
	UDPHS_EPTSTA6_NAK_OUT_Pos              = 0xf        // Position of NAK_OUT field.
	UDPHS_EPTSTA6_NAK_OUT_Msk              = 0x8000     // Bit mask of NAK_OUT field.
	UDPHS_EPTSTA6_NAK_OUT                  = 0x8000     // Bit NAK_OUT.
	UDPHS_EPTSTA6_CURBK_CTLDIR_Pos         = 0x10       // Position of CURBK_CTLDIR field.
	UDPHS_EPTSTA6_CURBK_CTLDIR_Msk         = 0x30000    // Bit mask of CURBK_CTLDIR field.
	UDPHS_EPTSTA6_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA6_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA6_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA6_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA6_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA6_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA6_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA6_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA6_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA6_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// EPTSTA6_ISOENDPT: UDPHS Endpoint Status Register (endpoint = 6)
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_Pos         = 0x6        // Position of TOGGLESQ_STA field.
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_Msk         = 0xc0       // Bit mask of TOGGLESQ_STA field.
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_DATA0       = 0x0        // DATA0
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_DATA1       = 0x1        // DATA1
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_DATA2       = 0x2        // Data2 (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA6_ISOENDPT_TOGGLESQ_STA_MDATA       = 0x3        // MData (only for High Bandwidth Isochronous Endpoint)
	UDPHS_EPTSTA6_ISOENDPT_ERR_OVFLW_Pos            = 0x8        // Position of ERR_OVFLW field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_OVFLW_Msk            = 0x100      // Bit mask of ERR_OVFLW field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_OVFLW                = 0x100      // Bit ERR_OVFLW.
	UDPHS_EPTSTA6_ISOENDPT_RXRDY_TXKL_Pos           = 0x9        // Position of RXRDY_TXKL field.
	UDPHS_EPTSTA6_ISOENDPT_RXRDY_TXKL_Msk           = 0x200      // Bit mask of RXRDY_TXKL field.
	UDPHS_EPTSTA6_ISOENDPT_RXRDY_TXKL               = 0x200      // Bit RXRDY_TXKL.
	UDPHS_EPTSTA6_ISOENDPT_TX_COMPLT_Pos            = 0xa        // Position of TX_COMPLT field.
	UDPHS_EPTSTA6_ISOENDPT_TX_COMPLT_Msk            = 0x400      // Bit mask of TX_COMPLT field.
	UDPHS_EPTSTA6_ISOENDPT_TX_COMPLT                = 0x400      // Bit TX_COMPLT.
	UDPHS_EPTSTA6_ISOENDPT_TXRDY_TRER_Pos           = 0xb        // Position of TXRDY_TRER field.
	UDPHS_EPTSTA6_ISOENDPT_TXRDY_TRER_Msk           = 0x800      // Bit mask of TXRDY_TRER field.
	UDPHS_EPTSTA6_ISOENDPT_TXRDY_TRER               = 0x800      // Bit TXRDY_TRER.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FL_ISO_Pos           = 0xc        // Position of ERR_FL_ISO field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FL_ISO_Msk           = 0x1000     // Bit mask of ERR_FL_ISO field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FL_ISO               = 0x1000     // Bit ERR_FL_ISO.
	UDPHS_EPTSTA6_ISOENDPT_ERR_CRC_NTR_Pos          = 0xd        // Position of ERR_CRC_NTR field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_CRC_NTR_Msk          = 0x2000     // Bit mask of ERR_CRC_NTR field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_CRC_NTR              = 0x2000     // Bit ERR_CRC_NTR.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FLUSH_Pos            = 0xe        // Position of ERR_FLUSH field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FLUSH_Msk            = 0x4000     // Bit mask of ERR_FLUSH field.
	UDPHS_EPTSTA6_ISOENDPT_ERR_FLUSH                = 0x4000     // Bit ERR_FLUSH.
	UDPHS_EPTSTA6_ISOENDPT_CURBK_Pos                = 0x10       // Position of CURBK field.
	UDPHS_EPTSTA6_ISOENDPT_CURBK_Msk                = 0x30000    // Bit mask of CURBK field.
	UDPHS_EPTSTA6_ISOENDPT_CURBK_BANK0              = 0x0        // Bank 0 (or single bank)
	UDPHS_EPTSTA6_ISOENDPT_CURBK_BANK1              = 0x1        // Bank 1
	UDPHS_EPTSTA6_ISOENDPT_CURBK_BANK2              = 0x2        // Bank 2
	UDPHS_EPTSTA6_ISOENDPT_BUSY_BANK_STA_Pos        = 0x12       // Position of BUSY_BANK_STA field.
	UDPHS_EPTSTA6_ISOENDPT_BUSY_BANK_STA_Msk        = 0xc0000    // Bit mask of BUSY_BANK_STA field.
	UDPHS_EPTSTA6_ISOENDPT_BUSY_BANK_STA_1BUSYBANK  = 0x0        // 1 busy bank
	UDPHS_EPTSTA6_ISOENDPT_BUSY_BANK_STA_2BUSYBANKS = 0x1        // 2 busy banks
	UDPHS_EPTSTA6_ISOENDPT_BUSY_BANK_STA_3BUSYBANKS = 0x2        // 3 busy banks
	UDPHS_EPTSTA6_ISOENDPT_BYTE_COUNT_Pos           = 0x14       // Position of BYTE_COUNT field.
	UDPHS_EPTSTA6_ISOENDPT_BYTE_COUNT_Msk           = 0x7ff00000 // Bit mask of BYTE_COUNT field.
	UDPHS_EPTSTA6_ISOENDPT_SHRT_PCKT_Pos            = 0x1f       // Position of SHRT_PCKT field.
	UDPHS_EPTSTA6_ISOENDPT_SHRT_PCKT_Msk            = 0x80000000 // Bit mask of SHRT_PCKT field.
	UDPHS_EPTSTA6_ISOENDPT_SHRT_PCKT                = 0x80000000 // Bit SHRT_PCKT.

	// DMANXTDSC0: UDPHS DMA Next Descriptor Address Register (channel = 0)
	UDPHS_DMANXTDSC0_NXT_DSC_ADD_Pos = 0x0        // Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC0_NXT_DSC_ADD_Msk = 0xffffffff // Bit mask of NXT_DSC_ADD field.

	// DMAADDRESS0: UDPHS DMA Channel Address Register (channel = 0)
	UDPHS_DMAADDRESS0_BUFF_ADD_Pos = 0x0        // Position of BUFF_ADD field.
	UDPHS_DMAADDRESS0_BUFF_ADD_Msk = 0xffffffff // Bit mask of BUFF_ADD field.

	// DMACONTROL0: UDPHS DMA Channel Control Register (channel = 0)
	UDPHS_DMACONTROL0_CHANN_ENB_Pos   = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMACONTROL0_CHANN_ENB_Msk   = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL0_CHANN_ENB       = 0x1        // Bit CHANN_ENB.
	UDPHS_DMACONTROL0_LDNXT_DSC_Pos   = 0x1        // Position of LDNXT_DSC field.
	UDPHS_DMACONTROL0_LDNXT_DSC_Msk   = 0x2        // Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL0_LDNXT_DSC       = 0x2        // Bit LDNXT_DSC.
	UDPHS_DMACONTROL0_END_TR_EN_Pos   = 0x2        // Position of END_TR_EN field.
	UDPHS_DMACONTROL0_END_TR_EN_Msk   = 0x4        // Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL0_END_TR_EN       = 0x4        // Bit END_TR_EN.
	UDPHS_DMACONTROL0_END_B_EN_Pos    = 0x3        // Position of END_B_EN field.
	UDPHS_DMACONTROL0_END_B_EN_Msk    = 0x8        // Bit mask of END_B_EN field.
	UDPHS_DMACONTROL0_END_B_EN        = 0x8        // Bit END_B_EN.
	UDPHS_DMACONTROL0_END_TR_IT_Pos   = 0x4        // Position of END_TR_IT field.
	UDPHS_DMACONTROL0_END_TR_IT_Msk   = 0x10       // Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL0_END_TR_IT       = 0x10       // Bit END_TR_IT.
	UDPHS_DMACONTROL0_END_BUFFIT_Pos  = 0x5        // Position of END_BUFFIT field.
	UDPHS_DMACONTROL0_END_BUFFIT_Msk  = 0x20       // Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL0_END_BUFFIT      = 0x20       // Bit END_BUFFIT.
	UDPHS_DMACONTROL0_DESC_LD_IT_Pos  = 0x6        // Position of DESC_LD_IT field.
	UDPHS_DMACONTROL0_DESC_LD_IT_Msk  = 0x40       // Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL0_DESC_LD_IT      = 0x40       // Bit DESC_LD_IT.
	UDPHS_DMACONTROL0_BURST_LCK_Pos   = 0x7        // Position of BURST_LCK field.
	UDPHS_DMACONTROL0_BURST_LCK_Msk   = 0x80       // Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL0_BURST_LCK       = 0x80       // Bit BURST_LCK.
	UDPHS_DMACONTROL0_BUFF_LENGTH_Pos = 0x10       // Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL0_BUFF_LENGTH_Msk = 0xffff0000 // Bit mask of BUFF_LENGTH field.

	// DMASTATUS0: UDPHS DMA Channel Status Register (channel = 0)
	UDPHS_DMASTATUS0_CHANN_ENB_Pos  = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMASTATUS0_CHANN_ENB_Msk  = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS0_CHANN_ENB      = 0x1        // Bit CHANN_ENB.
	UDPHS_DMASTATUS0_CHANN_ACT_Pos  = 0x1        // Position of CHANN_ACT field.
	UDPHS_DMASTATUS0_CHANN_ACT_Msk  = 0x2        // Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS0_CHANN_ACT      = 0x2        // Bit CHANN_ACT.
	UDPHS_DMASTATUS0_END_TR_ST_Pos  = 0x4        // Position of END_TR_ST field.
	UDPHS_DMASTATUS0_END_TR_ST_Msk  = 0x10       // Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS0_END_TR_ST      = 0x10       // Bit END_TR_ST.
	UDPHS_DMASTATUS0_END_BF_ST_Pos  = 0x5        // Position of END_BF_ST field.
	UDPHS_DMASTATUS0_END_BF_ST_Msk  = 0x20       // Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS0_END_BF_ST      = 0x20       // Bit END_BF_ST.
	UDPHS_DMASTATUS0_DESC_LDST_Pos  = 0x6        // Position of DESC_LDST field.
	UDPHS_DMASTATUS0_DESC_LDST_Msk  = 0x40       // Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS0_DESC_LDST      = 0x40       // Bit DESC_LDST.
	UDPHS_DMASTATUS0_BUFF_COUNT_Pos = 0x10       // Position of BUFF_COUNT field.
	UDPHS_DMASTATUS0_BUFF_COUNT_Msk = 0xffff0000 // Bit mask of BUFF_COUNT field.

	// DMANXTDSC1: UDPHS DMA Next Descriptor Address Register (channel = 1)
	UDPHS_DMANXTDSC1_NXT_DSC_ADD_Pos = 0x0        // Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC1_NXT_DSC_ADD_Msk = 0xffffffff // Bit mask of NXT_DSC_ADD field.

	// DMAADDRESS1: UDPHS DMA Channel Address Register (channel = 1)
	UDPHS_DMAADDRESS1_BUFF_ADD_Pos = 0x0        // Position of BUFF_ADD field.
	UDPHS_DMAADDRESS1_BUFF_ADD_Msk = 0xffffffff // Bit mask of BUFF_ADD field.

	// DMACONTROL1: UDPHS DMA Channel Control Register (channel = 1)
	UDPHS_DMACONTROL1_CHANN_ENB_Pos   = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMACONTROL1_CHANN_ENB_Msk   = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL1_CHANN_ENB       = 0x1        // Bit CHANN_ENB.
	UDPHS_DMACONTROL1_LDNXT_DSC_Pos   = 0x1        // Position of LDNXT_DSC field.
	UDPHS_DMACONTROL1_LDNXT_DSC_Msk   = 0x2        // Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL1_LDNXT_DSC       = 0x2        // Bit LDNXT_DSC.
	UDPHS_DMACONTROL1_END_TR_EN_Pos   = 0x2        // Position of END_TR_EN field.
	UDPHS_DMACONTROL1_END_TR_EN_Msk   = 0x4        // Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL1_END_TR_EN       = 0x4        // Bit END_TR_EN.
	UDPHS_DMACONTROL1_END_B_EN_Pos    = 0x3        // Position of END_B_EN field.
	UDPHS_DMACONTROL1_END_B_EN_Msk    = 0x8        // Bit mask of END_B_EN field.
	UDPHS_DMACONTROL1_END_B_EN        = 0x8        // Bit END_B_EN.
	UDPHS_DMACONTROL1_END_TR_IT_Pos   = 0x4        // Position of END_TR_IT field.
	UDPHS_DMACONTROL1_END_TR_IT_Msk   = 0x10       // Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL1_END_TR_IT       = 0x10       // Bit END_TR_IT.
	UDPHS_DMACONTROL1_END_BUFFIT_Pos  = 0x5        // Position of END_BUFFIT field.
	UDPHS_DMACONTROL1_END_BUFFIT_Msk  = 0x20       // Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL1_END_BUFFIT      = 0x20       // Bit END_BUFFIT.
	UDPHS_DMACONTROL1_DESC_LD_IT_Pos  = 0x6        // Position of DESC_LD_IT field.
	UDPHS_DMACONTROL1_DESC_LD_IT_Msk  = 0x40       // Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL1_DESC_LD_IT      = 0x40       // Bit DESC_LD_IT.
	UDPHS_DMACONTROL1_BURST_LCK_Pos   = 0x7        // Position of BURST_LCK field.
	UDPHS_DMACONTROL1_BURST_LCK_Msk   = 0x80       // Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL1_BURST_LCK       = 0x80       // Bit BURST_LCK.
	UDPHS_DMACONTROL1_BUFF_LENGTH_Pos = 0x10       // Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL1_BUFF_LENGTH_Msk = 0xffff0000 // Bit mask of BUFF_LENGTH field.

	// DMASTATUS1: UDPHS DMA Channel Status Register (channel = 1)
	UDPHS_DMASTATUS1_CHANN_ENB_Pos  = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMASTATUS1_CHANN_ENB_Msk  = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS1_CHANN_ENB      = 0x1        // Bit CHANN_ENB.
	UDPHS_DMASTATUS1_CHANN_ACT_Pos  = 0x1        // Position of CHANN_ACT field.
	UDPHS_DMASTATUS1_CHANN_ACT_Msk  = 0x2        // Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS1_CHANN_ACT      = 0x2        // Bit CHANN_ACT.
	UDPHS_DMASTATUS1_END_TR_ST_Pos  = 0x4        // Position of END_TR_ST field.
	UDPHS_DMASTATUS1_END_TR_ST_Msk  = 0x10       // Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS1_END_TR_ST      = 0x10       // Bit END_TR_ST.
	UDPHS_DMASTATUS1_END_BF_ST_Pos  = 0x5        // Position of END_BF_ST field.
	UDPHS_DMASTATUS1_END_BF_ST_Msk  = 0x20       // Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS1_END_BF_ST      = 0x20       // Bit END_BF_ST.
	UDPHS_DMASTATUS1_DESC_LDST_Pos  = 0x6        // Position of DESC_LDST field.
	UDPHS_DMASTATUS1_DESC_LDST_Msk  = 0x40       // Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS1_DESC_LDST      = 0x40       // Bit DESC_LDST.
	UDPHS_DMASTATUS1_BUFF_COUNT_Pos = 0x10       // Position of BUFF_COUNT field.
	UDPHS_DMASTATUS1_BUFF_COUNT_Msk = 0xffff0000 // Bit mask of BUFF_COUNT field.

	// DMANXTDSC2: UDPHS DMA Next Descriptor Address Register (channel = 2)
	UDPHS_DMANXTDSC2_NXT_DSC_ADD_Pos = 0x0        // Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC2_NXT_DSC_ADD_Msk = 0xffffffff // Bit mask of NXT_DSC_ADD field.

	// DMAADDRESS2: UDPHS DMA Channel Address Register (channel = 2)
	UDPHS_DMAADDRESS2_BUFF_ADD_Pos = 0x0        // Position of BUFF_ADD field.
	UDPHS_DMAADDRESS2_BUFF_ADD_Msk = 0xffffffff // Bit mask of BUFF_ADD field.

	// DMACONTROL2: UDPHS DMA Channel Control Register (channel = 2)
	UDPHS_DMACONTROL2_CHANN_ENB_Pos   = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMACONTROL2_CHANN_ENB_Msk   = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL2_CHANN_ENB       = 0x1        // Bit CHANN_ENB.
	UDPHS_DMACONTROL2_LDNXT_DSC_Pos   = 0x1        // Position of LDNXT_DSC field.
	UDPHS_DMACONTROL2_LDNXT_DSC_Msk   = 0x2        // Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL2_LDNXT_DSC       = 0x2        // Bit LDNXT_DSC.
	UDPHS_DMACONTROL2_END_TR_EN_Pos   = 0x2        // Position of END_TR_EN field.
	UDPHS_DMACONTROL2_END_TR_EN_Msk   = 0x4        // Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL2_END_TR_EN       = 0x4        // Bit END_TR_EN.
	UDPHS_DMACONTROL2_END_B_EN_Pos    = 0x3        // Position of END_B_EN field.
	UDPHS_DMACONTROL2_END_B_EN_Msk    = 0x8        // Bit mask of END_B_EN field.
	UDPHS_DMACONTROL2_END_B_EN        = 0x8        // Bit END_B_EN.
	UDPHS_DMACONTROL2_END_TR_IT_Pos   = 0x4        // Position of END_TR_IT field.
	UDPHS_DMACONTROL2_END_TR_IT_Msk   = 0x10       // Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL2_END_TR_IT       = 0x10       // Bit END_TR_IT.
	UDPHS_DMACONTROL2_END_BUFFIT_Pos  = 0x5        // Position of END_BUFFIT field.
	UDPHS_DMACONTROL2_END_BUFFIT_Msk  = 0x20       // Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL2_END_BUFFIT      = 0x20       // Bit END_BUFFIT.
	UDPHS_DMACONTROL2_DESC_LD_IT_Pos  = 0x6        // Position of DESC_LD_IT field.
	UDPHS_DMACONTROL2_DESC_LD_IT_Msk  = 0x40       // Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL2_DESC_LD_IT      = 0x40       // Bit DESC_LD_IT.
	UDPHS_DMACONTROL2_BURST_LCK_Pos   = 0x7        // Position of BURST_LCK field.
	UDPHS_DMACONTROL2_BURST_LCK_Msk   = 0x80       // Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL2_BURST_LCK       = 0x80       // Bit BURST_LCK.
	UDPHS_DMACONTROL2_BUFF_LENGTH_Pos = 0x10       // Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL2_BUFF_LENGTH_Msk = 0xffff0000 // Bit mask of BUFF_LENGTH field.

	// DMASTATUS2: UDPHS DMA Channel Status Register (channel = 2)
	UDPHS_DMASTATUS2_CHANN_ENB_Pos  = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMASTATUS2_CHANN_ENB_Msk  = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS2_CHANN_ENB      = 0x1        // Bit CHANN_ENB.
	UDPHS_DMASTATUS2_CHANN_ACT_Pos  = 0x1        // Position of CHANN_ACT field.
	UDPHS_DMASTATUS2_CHANN_ACT_Msk  = 0x2        // Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS2_CHANN_ACT      = 0x2        // Bit CHANN_ACT.
	UDPHS_DMASTATUS2_END_TR_ST_Pos  = 0x4        // Position of END_TR_ST field.
	UDPHS_DMASTATUS2_END_TR_ST_Msk  = 0x10       // Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS2_END_TR_ST      = 0x10       // Bit END_TR_ST.
	UDPHS_DMASTATUS2_END_BF_ST_Pos  = 0x5        // Position of END_BF_ST field.
	UDPHS_DMASTATUS2_END_BF_ST_Msk  = 0x20       // Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS2_END_BF_ST      = 0x20       // Bit END_BF_ST.
	UDPHS_DMASTATUS2_DESC_LDST_Pos  = 0x6        // Position of DESC_LDST field.
	UDPHS_DMASTATUS2_DESC_LDST_Msk  = 0x40       // Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS2_DESC_LDST      = 0x40       // Bit DESC_LDST.
	UDPHS_DMASTATUS2_BUFF_COUNT_Pos = 0x10       // Position of BUFF_COUNT field.
	UDPHS_DMASTATUS2_BUFF_COUNT_Msk = 0xffff0000 // Bit mask of BUFF_COUNT field.

	// DMANXTDSC3: UDPHS DMA Next Descriptor Address Register (channel = 3)
	UDPHS_DMANXTDSC3_NXT_DSC_ADD_Pos = 0x0        // Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC3_NXT_DSC_ADD_Msk = 0xffffffff // Bit mask of NXT_DSC_ADD field.

	// DMAADDRESS3: UDPHS DMA Channel Address Register (channel = 3)
	UDPHS_DMAADDRESS3_BUFF_ADD_Pos = 0x0        // Position of BUFF_ADD field.
	UDPHS_DMAADDRESS3_BUFF_ADD_Msk = 0xffffffff // Bit mask of BUFF_ADD field.

	// DMACONTROL3: UDPHS DMA Channel Control Register (channel = 3)
	UDPHS_DMACONTROL3_CHANN_ENB_Pos   = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMACONTROL3_CHANN_ENB_Msk   = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL3_CHANN_ENB       = 0x1        // Bit CHANN_ENB.
	UDPHS_DMACONTROL3_LDNXT_DSC_Pos   = 0x1        // Position of LDNXT_DSC field.
	UDPHS_DMACONTROL3_LDNXT_DSC_Msk   = 0x2        // Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL3_LDNXT_DSC       = 0x2        // Bit LDNXT_DSC.
	UDPHS_DMACONTROL3_END_TR_EN_Pos   = 0x2        // Position of END_TR_EN field.
	UDPHS_DMACONTROL3_END_TR_EN_Msk   = 0x4        // Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL3_END_TR_EN       = 0x4        // Bit END_TR_EN.
	UDPHS_DMACONTROL3_END_B_EN_Pos    = 0x3        // Position of END_B_EN field.
	UDPHS_DMACONTROL3_END_B_EN_Msk    = 0x8        // Bit mask of END_B_EN field.
	UDPHS_DMACONTROL3_END_B_EN        = 0x8        // Bit END_B_EN.
	UDPHS_DMACONTROL3_END_TR_IT_Pos   = 0x4        // Position of END_TR_IT field.
	UDPHS_DMACONTROL3_END_TR_IT_Msk   = 0x10       // Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL3_END_TR_IT       = 0x10       // Bit END_TR_IT.
	UDPHS_DMACONTROL3_END_BUFFIT_Pos  = 0x5        // Position of END_BUFFIT field.
	UDPHS_DMACONTROL3_END_BUFFIT_Msk  = 0x20       // Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL3_END_BUFFIT      = 0x20       // Bit END_BUFFIT.
	UDPHS_DMACONTROL3_DESC_LD_IT_Pos  = 0x6        // Position of DESC_LD_IT field.
	UDPHS_DMACONTROL3_DESC_LD_IT_Msk  = 0x40       // Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL3_DESC_LD_IT      = 0x40       // Bit DESC_LD_IT.
	UDPHS_DMACONTROL3_BURST_LCK_Pos   = 0x7        // Position of BURST_LCK field.
	UDPHS_DMACONTROL3_BURST_LCK_Msk   = 0x80       // Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL3_BURST_LCK       = 0x80       // Bit BURST_LCK.
	UDPHS_DMACONTROL3_BUFF_LENGTH_Pos = 0x10       // Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL3_BUFF_LENGTH_Msk = 0xffff0000 // Bit mask of BUFF_LENGTH field.

	// DMASTATUS3: UDPHS DMA Channel Status Register (channel = 3)
	UDPHS_DMASTATUS3_CHANN_ENB_Pos  = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMASTATUS3_CHANN_ENB_Msk  = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS3_CHANN_ENB      = 0x1        // Bit CHANN_ENB.
	UDPHS_DMASTATUS3_CHANN_ACT_Pos  = 0x1        // Position of CHANN_ACT field.
	UDPHS_DMASTATUS3_CHANN_ACT_Msk  = 0x2        // Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS3_CHANN_ACT      = 0x2        // Bit CHANN_ACT.
	UDPHS_DMASTATUS3_END_TR_ST_Pos  = 0x4        // Position of END_TR_ST field.
	UDPHS_DMASTATUS3_END_TR_ST_Msk  = 0x10       // Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS3_END_TR_ST      = 0x10       // Bit END_TR_ST.
	UDPHS_DMASTATUS3_END_BF_ST_Pos  = 0x5        // Position of END_BF_ST field.
	UDPHS_DMASTATUS3_END_BF_ST_Msk  = 0x20       // Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS3_END_BF_ST      = 0x20       // Bit END_BF_ST.
	UDPHS_DMASTATUS3_DESC_LDST_Pos  = 0x6        // Position of DESC_LDST field.
	UDPHS_DMASTATUS3_DESC_LDST_Msk  = 0x40       // Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS3_DESC_LDST      = 0x40       // Bit DESC_LDST.
	UDPHS_DMASTATUS3_BUFF_COUNT_Pos = 0x10       // Position of BUFF_COUNT field.
	UDPHS_DMASTATUS3_BUFF_COUNT_Msk = 0xffff0000 // Bit mask of BUFF_COUNT field.

	// DMANXTDSC4: UDPHS DMA Next Descriptor Address Register (channel = 4)
	UDPHS_DMANXTDSC4_NXT_DSC_ADD_Pos = 0x0        // Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC4_NXT_DSC_ADD_Msk = 0xffffffff // Bit mask of NXT_DSC_ADD field.

	// DMAADDRESS4: UDPHS DMA Channel Address Register (channel = 4)
	UDPHS_DMAADDRESS4_BUFF_ADD_Pos = 0x0        // Position of BUFF_ADD field.
	UDPHS_DMAADDRESS4_BUFF_ADD_Msk = 0xffffffff // Bit mask of BUFF_ADD field.

	// DMACONTROL4: UDPHS DMA Channel Control Register (channel = 4)
	UDPHS_DMACONTROL4_CHANN_ENB_Pos   = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMACONTROL4_CHANN_ENB_Msk   = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL4_CHANN_ENB       = 0x1        // Bit CHANN_ENB.
	UDPHS_DMACONTROL4_LDNXT_DSC_Pos   = 0x1        // Position of LDNXT_DSC field.
	UDPHS_DMACONTROL4_LDNXT_DSC_Msk   = 0x2        // Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL4_LDNXT_DSC       = 0x2        // Bit LDNXT_DSC.
	UDPHS_DMACONTROL4_END_TR_EN_Pos   = 0x2        // Position of END_TR_EN field.
	UDPHS_DMACONTROL4_END_TR_EN_Msk   = 0x4        // Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL4_END_TR_EN       = 0x4        // Bit END_TR_EN.
	UDPHS_DMACONTROL4_END_B_EN_Pos    = 0x3        // Position of END_B_EN field.
	UDPHS_DMACONTROL4_END_B_EN_Msk    = 0x8        // Bit mask of END_B_EN field.
	UDPHS_DMACONTROL4_END_B_EN        = 0x8        // Bit END_B_EN.
	UDPHS_DMACONTROL4_END_TR_IT_Pos   = 0x4        // Position of END_TR_IT field.
	UDPHS_DMACONTROL4_END_TR_IT_Msk   = 0x10       // Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL4_END_TR_IT       = 0x10       // Bit END_TR_IT.
	UDPHS_DMACONTROL4_END_BUFFIT_Pos  = 0x5        // Position of END_BUFFIT field.
	UDPHS_DMACONTROL4_END_BUFFIT_Msk  = 0x20       // Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL4_END_BUFFIT      = 0x20       // Bit END_BUFFIT.
	UDPHS_DMACONTROL4_DESC_LD_IT_Pos  = 0x6        // Position of DESC_LD_IT field.
	UDPHS_DMACONTROL4_DESC_LD_IT_Msk  = 0x40       // Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL4_DESC_LD_IT      = 0x40       // Bit DESC_LD_IT.
	UDPHS_DMACONTROL4_BURST_LCK_Pos   = 0x7        // Position of BURST_LCK field.
	UDPHS_DMACONTROL4_BURST_LCK_Msk   = 0x80       // Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL4_BURST_LCK       = 0x80       // Bit BURST_LCK.
	UDPHS_DMACONTROL4_BUFF_LENGTH_Pos = 0x10       // Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL4_BUFF_LENGTH_Msk = 0xffff0000 // Bit mask of BUFF_LENGTH field.

	// DMASTATUS4: UDPHS DMA Channel Status Register (channel = 4)
	UDPHS_DMASTATUS4_CHANN_ENB_Pos  = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMASTATUS4_CHANN_ENB_Msk  = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS4_CHANN_ENB      = 0x1        // Bit CHANN_ENB.
	UDPHS_DMASTATUS4_CHANN_ACT_Pos  = 0x1        // Position of CHANN_ACT field.
	UDPHS_DMASTATUS4_CHANN_ACT_Msk  = 0x2        // Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS4_CHANN_ACT      = 0x2        // Bit CHANN_ACT.
	UDPHS_DMASTATUS4_END_TR_ST_Pos  = 0x4        // Position of END_TR_ST field.
	UDPHS_DMASTATUS4_END_TR_ST_Msk  = 0x10       // Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS4_END_TR_ST      = 0x10       // Bit END_TR_ST.
	UDPHS_DMASTATUS4_END_BF_ST_Pos  = 0x5        // Position of END_BF_ST field.
	UDPHS_DMASTATUS4_END_BF_ST_Msk  = 0x20       // Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS4_END_BF_ST      = 0x20       // Bit END_BF_ST.
	UDPHS_DMASTATUS4_DESC_LDST_Pos  = 0x6        // Position of DESC_LDST field.
	UDPHS_DMASTATUS4_DESC_LDST_Msk  = 0x40       // Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS4_DESC_LDST      = 0x40       // Bit DESC_LDST.
	UDPHS_DMASTATUS4_BUFF_COUNT_Pos = 0x10       // Position of BUFF_COUNT field.
	UDPHS_DMASTATUS4_BUFF_COUNT_Msk = 0xffff0000 // Bit mask of BUFF_COUNT field.

	// DMANXTDSC5: UDPHS DMA Next Descriptor Address Register (channel = 5)
	UDPHS_DMANXTDSC5_NXT_DSC_ADD_Pos = 0x0        // Position of NXT_DSC_ADD field.
	UDPHS_DMANXTDSC5_NXT_DSC_ADD_Msk = 0xffffffff // Bit mask of NXT_DSC_ADD field.

	// DMAADDRESS5: UDPHS DMA Channel Address Register (channel = 5)
	UDPHS_DMAADDRESS5_BUFF_ADD_Pos = 0x0        // Position of BUFF_ADD field.
	UDPHS_DMAADDRESS5_BUFF_ADD_Msk = 0xffffffff // Bit mask of BUFF_ADD field.

	// DMACONTROL5: UDPHS DMA Channel Control Register (channel = 5)
	UDPHS_DMACONTROL5_CHANN_ENB_Pos   = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMACONTROL5_CHANN_ENB_Msk   = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMACONTROL5_CHANN_ENB       = 0x1        // Bit CHANN_ENB.
	UDPHS_DMACONTROL5_LDNXT_DSC_Pos   = 0x1        // Position of LDNXT_DSC field.
	UDPHS_DMACONTROL5_LDNXT_DSC_Msk   = 0x2        // Bit mask of LDNXT_DSC field.
	UDPHS_DMACONTROL5_LDNXT_DSC       = 0x2        // Bit LDNXT_DSC.
	UDPHS_DMACONTROL5_END_TR_EN_Pos   = 0x2        // Position of END_TR_EN field.
	UDPHS_DMACONTROL5_END_TR_EN_Msk   = 0x4        // Bit mask of END_TR_EN field.
	UDPHS_DMACONTROL5_END_TR_EN       = 0x4        // Bit END_TR_EN.
	UDPHS_DMACONTROL5_END_B_EN_Pos    = 0x3        // Position of END_B_EN field.
	UDPHS_DMACONTROL5_END_B_EN_Msk    = 0x8        // Bit mask of END_B_EN field.
	UDPHS_DMACONTROL5_END_B_EN        = 0x8        // Bit END_B_EN.
	UDPHS_DMACONTROL5_END_TR_IT_Pos   = 0x4        // Position of END_TR_IT field.
	UDPHS_DMACONTROL5_END_TR_IT_Msk   = 0x10       // Bit mask of END_TR_IT field.
	UDPHS_DMACONTROL5_END_TR_IT       = 0x10       // Bit END_TR_IT.
	UDPHS_DMACONTROL5_END_BUFFIT_Pos  = 0x5        // Position of END_BUFFIT field.
	UDPHS_DMACONTROL5_END_BUFFIT_Msk  = 0x20       // Bit mask of END_BUFFIT field.
	UDPHS_DMACONTROL5_END_BUFFIT      = 0x20       // Bit END_BUFFIT.
	UDPHS_DMACONTROL5_DESC_LD_IT_Pos  = 0x6        // Position of DESC_LD_IT field.
	UDPHS_DMACONTROL5_DESC_LD_IT_Msk  = 0x40       // Bit mask of DESC_LD_IT field.
	UDPHS_DMACONTROL5_DESC_LD_IT      = 0x40       // Bit DESC_LD_IT.
	UDPHS_DMACONTROL5_BURST_LCK_Pos   = 0x7        // Position of BURST_LCK field.
	UDPHS_DMACONTROL5_BURST_LCK_Msk   = 0x80       // Bit mask of BURST_LCK field.
	UDPHS_DMACONTROL5_BURST_LCK       = 0x80       // Bit BURST_LCK.
	UDPHS_DMACONTROL5_BUFF_LENGTH_Pos = 0x10       // Position of BUFF_LENGTH field.
	UDPHS_DMACONTROL5_BUFF_LENGTH_Msk = 0xffff0000 // Bit mask of BUFF_LENGTH field.

	// DMASTATUS5: UDPHS DMA Channel Status Register (channel = 5)
	UDPHS_DMASTATUS5_CHANN_ENB_Pos  = 0x0        // Position of CHANN_ENB field.
	UDPHS_DMASTATUS5_CHANN_ENB_Msk  = 0x1        // Bit mask of CHANN_ENB field.
	UDPHS_DMASTATUS5_CHANN_ENB      = 0x1        // Bit CHANN_ENB.
	UDPHS_DMASTATUS5_CHANN_ACT_Pos  = 0x1        // Position of CHANN_ACT field.
	UDPHS_DMASTATUS5_CHANN_ACT_Msk  = 0x2        // Bit mask of CHANN_ACT field.
	UDPHS_DMASTATUS5_CHANN_ACT      = 0x2        // Bit CHANN_ACT.
	UDPHS_DMASTATUS5_END_TR_ST_Pos  = 0x4        // Position of END_TR_ST field.
	UDPHS_DMASTATUS5_END_TR_ST_Msk  = 0x10       // Bit mask of END_TR_ST field.
	UDPHS_DMASTATUS5_END_TR_ST      = 0x10       // Bit END_TR_ST.
	UDPHS_DMASTATUS5_END_BF_ST_Pos  = 0x5        // Position of END_BF_ST field.
	UDPHS_DMASTATUS5_END_BF_ST_Msk  = 0x20       // Bit mask of END_BF_ST field.
	UDPHS_DMASTATUS5_END_BF_ST      = 0x20       // Bit END_BF_ST.
	UDPHS_DMASTATUS5_DESC_LDST_Pos  = 0x6        // Position of DESC_LDST field.
	UDPHS_DMASTATUS5_DESC_LDST_Msk  = 0x40       // Bit mask of DESC_LDST field.
	UDPHS_DMASTATUS5_DESC_LDST      = 0x40       // Bit DESC_LDST.
	UDPHS_DMASTATUS5_BUFF_COUNT_Pos = 0x10       // Position of BUFF_COUNT field.
	UDPHS_DMASTATUS5_BUFF_COUNT_Msk = 0xffff0000 // Bit mask of BUFF_COUNT field.
)

// Bitfields for TC0: Timer Counter 0
const (
	// CCR0: Channel Control Register (channel = 0)
	TC_CCR0_CLKEN_Pos  = 0x0 // Position of CLKEN field.
	TC_CCR0_CLKEN_Msk  = 0x1 // Bit mask of CLKEN field.
	TC_CCR0_CLKEN      = 0x1 // Bit CLKEN.
	TC_CCR0_CLKDIS_Pos = 0x1 // Position of CLKDIS field.
	TC_CCR0_CLKDIS_Msk = 0x2 // Bit mask of CLKDIS field.
	TC_CCR0_CLKDIS     = 0x2 // Bit CLKDIS.
	TC_CCR0_SWTRG_Pos  = 0x2 // Position of SWTRG field.
	TC_CCR0_SWTRG_Msk  = 0x4 // Bit mask of SWTRG field.
	TC_CCR0_SWTRG      = 0x4 // Bit SWTRG.

	// CMR0: Channel Mode Register (channel = 0)
	TC_CMR0_TCCLKS_Pos          = 0x0     // Position of TCCLKS field.
	TC_CMR0_TCCLKS_Msk          = 0x7     // Bit mask of TCCLKS field.
	TC_CMR0_TCCLKS_TIMER_CLOCK1 = 0x0     // Clock selected: TCLK1
	TC_CMR0_TCCLKS_TIMER_CLOCK2 = 0x1     // Clock selected: TCLK2
	TC_CMR0_TCCLKS_TIMER_CLOCK3 = 0x2     // Clock selected: TCLK3
	TC_CMR0_TCCLKS_TIMER_CLOCK4 = 0x3     // Clock selected: TCLK4
	TC_CMR0_TCCLKS_TIMER_CLOCK5 = 0x4     // Clock selected: TCLK5
	TC_CMR0_TCCLKS_XC0          = 0x5     // Clock selected: XC0
	TC_CMR0_TCCLKS_XC1          = 0x6     // Clock selected: XC1
	TC_CMR0_TCCLKS_XC2          = 0x7     // Clock selected: XC2
	TC_CMR0_CLKI_Pos            = 0x3     // Position of CLKI field.
	TC_CMR0_CLKI_Msk            = 0x8     // Bit mask of CLKI field.
	TC_CMR0_CLKI                = 0x8     // Bit CLKI.
	TC_CMR0_BURST_Pos           = 0x4     // Position of BURST field.
	TC_CMR0_BURST_Msk           = 0x30    // Bit mask of BURST field.
	TC_CMR0_BURST_NONE          = 0x0     // The clock is not gated by an external signal.
	TC_CMR0_BURST_XC0           = 0x1     // XC0 is ANDed with the selected clock.
	TC_CMR0_BURST_XC1           = 0x2     // XC1 is ANDed with the selected clock.
	TC_CMR0_BURST_XC2           = 0x3     // XC2 is ANDed with the selected clock.
	TC_CMR0_LDBSTOP_Pos         = 0x6     // Position of LDBSTOP field.
	TC_CMR0_LDBSTOP_Msk         = 0x40    // Bit mask of LDBSTOP field.
	TC_CMR0_LDBSTOP             = 0x40    // Bit LDBSTOP.
	TC_CMR0_LDBDIS_Pos          = 0x7     // Position of LDBDIS field.
	TC_CMR0_LDBDIS_Msk          = 0x80    // Bit mask of LDBDIS field.
	TC_CMR0_LDBDIS              = 0x80    // Bit LDBDIS.
	TC_CMR0_ETRGEDG_Pos         = 0x8     // Position of ETRGEDG field.
	TC_CMR0_ETRGEDG_Msk         = 0x300   // Bit mask of ETRGEDG field.
	TC_CMR0_ETRGEDG_NONE        = 0x0     // The clock is not gated by an external signal.
	TC_CMR0_ETRGEDG_RISING      = 0x1     // Rising edge
	TC_CMR0_ETRGEDG_FALLING     = 0x2     // Falling edge
	TC_CMR0_ETRGEDG_EDGE        = 0x3     // Each edge
	TC_CMR0_ABETRG_Pos          = 0xa     // Position of ABETRG field.
	TC_CMR0_ABETRG_Msk          = 0x400   // Bit mask of ABETRG field.
	TC_CMR0_ABETRG              = 0x400   // Bit ABETRG.
	TC_CMR0_CPCTRG_Pos          = 0xe     // Position of CPCTRG field.
	TC_CMR0_CPCTRG_Msk          = 0x4000  // Bit mask of CPCTRG field.
	TC_CMR0_CPCTRG              = 0x4000  // Bit CPCTRG.
	TC_CMR0_WAVE_Pos            = 0xf     // Position of WAVE field.
	TC_CMR0_WAVE_Msk            = 0x8000  // Bit mask of WAVE field.
	TC_CMR0_WAVE                = 0x8000  // Bit WAVE.
	TC_CMR0_LDRA_Pos            = 0x10    // Position of LDRA field.
	TC_CMR0_LDRA_Msk            = 0x30000 // Bit mask of LDRA field.
	TC_CMR0_LDRA_NONE           = 0x0     // None
	TC_CMR0_LDRA_RISING         = 0x1     // Rising edge of TIOA
	TC_CMR0_LDRA_FALLING        = 0x2     // Falling edge of TIOA
	TC_CMR0_LDRA_EDGE           = 0x3     // Each edge of TIOA
	TC_CMR0_LDRB_Pos            = 0x12    // Position of LDRB field.
	TC_CMR0_LDRB_Msk            = 0xc0000 // Bit mask of LDRB field.
	TC_CMR0_LDRB_NONE           = 0x0     // None
	TC_CMR0_LDRB_RISING         = 0x1     // Rising edge of TIOA
	TC_CMR0_LDRB_FALLING        = 0x2     // Falling edge of TIOA
	TC_CMR0_LDRB_EDGE           = 0x3     // Each edge of TIOA

	// CMR0_WAVE_EQ_1: Channel Mode Register (channel = 0)
	TC_CMR0_WAVE_EQ_1_TCCLKS_Pos          = 0x0        // Position of TCCLKS field.
	TC_CMR0_WAVE_EQ_1_TCCLKS_Msk          = 0x7        // Bit mask of TCCLKS field.
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0        // Clock selected: TCLK1
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1        // Clock selected: TCLK2
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2        // Clock selected: TCLK3
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3        // Clock selected: TCLK4
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4        // Clock selected: TCLK5
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC0          = 0x5        // Clock selected: XC0
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC1          = 0x6        // Clock selected: XC1
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC2          = 0x7        // Clock selected: XC2
	TC_CMR0_WAVE_EQ_1_CLKI_Pos            = 0x3        // Position of CLKI field.
	TC_CMR0_WAVE_EQ_1_CLKI_Msk            = 0x8        // Bit mask of CLKI field.
	TC_CMR0_WAVE_EQ_1_CLKI                = 0x8        // Bit CLKI.
	TC_CMR0_WAVE_EQ_1_BURST_Pos           = 0x4        // Position of BURST field.
	TC_CMR0_WAVE_EQ_1_BURST_Msk           = 0x30       // Bit mask of BURST field.
	TC_CMR0_WAVE_EQ_1_BURST_NONE          = 0x0        // The clock is not gated by an external signal.
	TC_CMR0_WAVE_EQ_1_BURST_XC0           = 0x1        // XC0 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_BURST_XC1           = 0x2        // XC1 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_BURST_XC2           = 0x3        // XC2 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_CPCSTOP_Pos         = 0x6        // Position of CPCSTOP field.
	TC_CMR0_WAVE_EQ_1_CPCSTOP_Msk         = 0x40       // Bit mask of CPCSTOP field.
	TC_CMR0_WAVE_EQ_1_CPCSTOP             = 0x40       // Bit CPCSTOP.
	TC_CMR0_WAVE_EQ_1_CPCDIS_Pos          = 0x7        // Position of CPCDIS field.
	TC_CMR0_WAVE_EQ_1_CPCDIS_Msk          = 0x80       // Bit mask of CPCDIS field.
	TC_CMR0_WAVE_EQ_1_CPCDIS              = 0x80       // Bit CPCDIS.
	TC_CMR0_WAVE_EQ_1_EEVTEDG_Pos         = 0x8        // Position of EEVTEDG field.
	TC_CMR0_WAVE_EQ_1_EEVTEDG_Msk         = 0x300      // Bit mask of EEVTEDG field.
	TC_CMR0_WAVE_EQ_1_EEVTEDG_NONE        = 0x0        // None
	TC_CMR0_WAVE_EQ_1_EEVTEDG_RISING      = 0x1        // Rising edge
	TC_CMR0_WAVE_EQ_1_EEVTEDG_FALLING     = 0x2        // Falling edge
	TC_CMR0_WAVE_EQ_1_EEVTEDG_EDGE        = 0x3        // Each edge
	TC_CMR0_WAVE_EQ_1_EEVT_Pos            = 0xa        // Position of EEVT field.
	TC_CMR0_WAVE_EQ_1_EEVT_Msk            = 0xc00      // Bit mask of EEVT field.
	TC_CMR0_WAVE_EQ_1_EEVT_TIOB           = 0x0        // TIOB
	TC_CMR0_WAVE_EQ_1_EEVT_XC0            = 0x1        // XC0
	TC_CMR0_WAVE_EQ_1_EEVT_XC1            = 0x2        // XC1
	TC_CMR0_WAVE_EQ_1_EEVT_XC2            = 0x3        // XC2
	TC_CMR0_WAVE_EQ_1_ENETRG_Pos          = 0xc        // Position of ENETRG field.
	TC_CMR0_WAVE_EQ_1_ENETRG_Msk          = 0x1000     // Bit mask of ENETRG field.
	TC_CMR0_WAVE_EQ_1_ENETRG              = 0x1000     // Bit ENETRG.
	TC_CMR0_WAVE_EQ_1_WAVSEL_Pos          = 0xd        // Position of WAVSEL field.
	TC_CMR0_WAVE_EQ_1_WAVSEL_Msk          = 0x6000     // Bit mask of WAVSEL field.
	TC_CMR0_WAVE_EQ_1_WAVSEL_UP           = 0x0        // UP mode without automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UP_RC        = 0x1        // UP mode with automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UPDOWN       = 0x2        // UPDOWN mode without automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UPDOWN_RC    = 0x3        // UPDOWN mode with automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVE_Pos            = 0xf        // Position of WAVE field.
	TC_CMR0_WAVE_EQ_1_WAVE_Msk            = 0x8000     // Bit mask of WAVE field.
	TC_CMR0_WAVE_EQ_1_WAVE                = 0x8000     // Bit WAVE.
	TC_CMR0_WAVE_EQ_1_ACPA_Pos            = 0x10       // Position of ACPA field.
	TC_CMR0_WAVE_EQ_1_ACPA_Msk            = 0x30000    // Bit mask of ACPA field.
	TC_CMR0_WAVE_EQ_1_ACPA_NONE           = 0x0        // None
	TC_CMR0_WAVE_EQ_1_ACPA_SET            = 0x1        // Set
	TC_CMR0_WAVE_EQ_1_ACPA_CLEAR          = 0x2        // Clear
	TC_CMR0_WAVE_EQ_1_ACPA_TOGGLE         = 0x3        // Toggle
	TC_CMR0_WAVE_EQ_1_ACPC_Pos            = 0x12       // Position of ACPC field.
	TC_CMR0_WAVE_EQ_1_ACPC_Msk            = 0xc0000    // Bit mask of ACPC field.
	TC_CMR0_WAVE_EQ_1_ACPC_NONE           = 0x0        // None
	TC_CMR0_WAVE_EQ_1_ACPC_SET            = 0x1        // Set
	TC_CMR0_WAVE_EQ_1_ACPC_CLEAR          = 0x2        // Clear
	TC_CMR0_WAVE_EQ_1_ACPC_TOGGLE         = 0x3        // Toggle
	TC_CMR0_WAVE_EQ_1_AEEVT_Pos           = 0x14       // Position of AEEVT field.
	TC_CMR0_WAVE_EQ_1_AEEVT_Msk           = 0x300000   // Bit mask of AEEVT field.
	TC_CMR0_WAVE_EQ_1_AEEVT_NONE          = 0x0        // None
	TC_CMR0_WAVE_EQ_1_AEEVT_SET           = 0x1        // Set
	TC_CMR0_WAVE_EQ_1_AEEVT_CLEAR         = 0x2        // Clear
	TC_CMR0_WAVE_EQ_1_AEEVT_TOGGLE        = 0x3        // Toggle
	TC_CMR0_WAVE_EQ_1_ASWTRG_Pos          = 0x16       // Position of ASWTRG field.
	TC_CMR0_WAVE_EQ_1_ASWTRG_Msk          = 0xc00000   // Bit mask of ASWTRG field.
	TC_CMR0_WAVE_EQ_1_ASWTRG_NONE         = 0x0        // None
	TC_CMR0_WAVE_EQ_1_ASWTRG_SET          = 0x1        // Set
	TC_CMR0_WAVE_EQ_1_ASWTRG_CLEAR        = 0x2        // Clear
	TC_CMR0_WAVE_EQ_1_ASWTRG_TOGGLE       = 0x3        // Toggle
	TC_CMR0_WAVE_EQ_1_BCPB_Pos            = 0x18       // Position of BCPB field.
	TC_CMR0_WAVE_EQ_1_BCPB_Msk            = 0x3000000  // Bit mask of BCPB field.
	TC_CMR0_WAVE_EQ_1_BCPB_NONE           = 0x0        // None
	TC_CMR0_WAVE_EQ_1_BCPB_SET            = 0x1        // Set
	TC_CMR0_WAVE_EQ_1_BCPB_CLEAR          = 0x2        // Clear
	TC_CMR0_WAVE_EQ_1_BCPB_TOGGLE         = 0x3        // Toggle
	TC_CMR0_WAVE_EQ_1_BCPC_Pos            = 0x1a       // Position of BCPC field.
	TC_CMR0_WAVE_EQ_1_BCPC_Msk            = 0xc000000  // Bit mask of BCPC field.
	TC_CMR0_WAVE_EQ_1_BCPC_NONE           = 0x0        // None
	TC_CMR0_WAVE_EQ_1_BCPC_SET            = 0x1        // Set
	TC_CMR0_WAVE_EQ_1_BCPC_CLEAR          = 0x2        // Clear
	TC_CMR0_WAVE_EQ_1_BCPC_TOGGLE         = 0x3        // Toggle
	TC_CMR0_WAVE_EQ_1_BEEVT_Pos           = 0x1c       // Position of BEEVT field.
	TC_CMR0_WAVE_EQ_1_BEEVT_Msk           = 0x30000000 // Bit mask of BEEVT field.
	TC_CMR0_WAVE_EQ_1_BEEVT_NONE          = 0x0        // None
	TC_CMR0_WAVE_EQ_1_BEEVT_SET           = 0x1        // Set
	TC_CMR0_WAVE_EQ_1_BEEVT_CLEAR         = 0x2        // Clear
	TC_CMR0_WAVE_EQ_1_BEEVT_TOGGLE        = 0x3        // Toggle
	TC_CMR0_WAVE_EQ_1_BSWTRG_Pos          = 0x1e       // Position of BSWTRG field.
	TC_CMR0_WAVE_EQ_1_BSWTRG_Msk          = 0xc0000000 // Bit mask of BSWTRG field.
	TC_CMR0_WAVE_EQ_1_BSWTRG_NONE         = 0x0        // None
	TC_CMR0_WAVE_EQ_1_BSWTRG_SET          = 0x1        // Set
	TC_CMR0_WAVE_EQ_1_BSWTRG_CLEAR        = 0x2        // Clear
	TC_CMR0_WAVE_EQ_1_BSWTRG_TOGGLE       = 0x3        // Toggle

	// CV0: Counter Value (channel = 0)
	TC_CV0_CV_Pos = 0x0    // Position of CV field.
	TC_CV0_CV_Msk = 0xffff // Bit mask of CV field.

	// RA0: Register A (channel = 0)
	TC_RA0_RA_Pos = 0x0    // Position of RA field.
	TC_RA0_RA_Msk = 0xffff // Bit mask of RA field.

	// RB0: Register B (channel = 0)
	TC_RB0_RB_Pos = 0x0    // Position of RB field.
	TC_RB0_RB_Msk = 0xffff // Bit mask of RB field.

	// RC0: Register C (channel = 0)
	TC_RC0_RC_Pos = 0x0    // Position of RC field.
	TC_RC0_RC_Msk = 0xffff // Bit mask of RC field.

	// SR0: Status Register (channel = 0)
	TC_SR0_COVFS_Pos  = 0x0     // Position of COVFS field.
	TC_SR0_COVFS_Msk  = 0x1     // Bit mask of COVFS field.
	TC_SR0_COVFS      = 0x1     // Bit COVFS.
	TC_SR0_LOVRS_Pos  = 0x1     // Position of LOVRS field.
	TC_SR0_LOVRS_Msk  = 0x2     // Bit mask of LOVRS field.
	TC_SR0_LOVRS      = 0x2     // Bit LOVRS.
	TC_SR0_CPAS_Pos   = 0x2     // Position of CPAS field.
	TC_SR0_CPAS_Msk   = 0x4     // Bit mask of CPAS field.
	TC_SR0_CPAS       = 0x4     // Bit CPAS.
	TC_SR0_CPBS_Pos   = 0x3     // Position of CPBS field.
	TC_SR0_CPBS_Msk   = 0x8     // Bit mask of CPBS field.
	TC_SR0_CPBS       = 0x8     // Bit CPBS.
	TC_SR0_CPCS_Pos   = 0x4     // Position of CPCS field.
	TC_SR0_CPCS_Msk   = 0x10    // Bit mask of CPCS field.
	TC_SR0_CPCS       = 0x10    // Bit CPCS.
	TC_SR0_LDRAS_Pos  = 0x5     // Position of LDRAS field.
	TC_SR0_LDRAS_Msk  = 0x20    // Bit mask of LDRAS field.
	TC_SR0_LDRAS      = 0x20    // Bit LDRAS.
	TC_SR0_LDRBS_Pos  = 0x6     // Position of LDRBS field.
	TC_SR0_LDRBS_Msk  = 0x40    // Bit mask of LDRBS field.
	TC_SR0_LDRBS      = 0x40    // Bit LDRBS.
	TC_SR0_ETRGS_Pos  = 0x7     // Position of ETRGS field.
	TC_SR0_ETRGS_Msk  = 0x80    // Bit mask of ETRGS field.
	TC_SR0_ETRGS      = 0x80    // Bit ETRGS.
	TC_SR0_CLKSTA_Pos = 0x10    // Position of CLKSTA field.
	TC_SR0_CLKSTA_Msk = 0x10000 // Bit mask of CLKSTA field.
	TC_SR0_CLKSTA     = 0x10000 // Bit CLKSTA.
	TC_SR0_MTIOA_Pos  = 0x11    // Position of MTIOA field.
	TC_SR0_MTIOA_Msk  = 0x20000 // Bit mask of MTIOA field.
	TC_SR0_MTIOA      = 0x20000 // Bit MTIOA.
	TC_SR0_MTIOB_Pos  = 0x12    // Position of MTIOB field.
	TC_SR0_MTIOB_Msk  = 0x40000 // Bit mask of MTIOB field.
	TC_SR0_MTIOB      = 0x40000 // Bit MTIOB.

	// IER0: Interrupt Enable Register (channel = 0)
	TC_IER0_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IER0_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IER0_COVFS     = 0x1  // Bit COVFS.
	TC_IER0_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IER0_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IER0_LOVRS     = 0x2  // Bit LOVRS.
	TC_IER0_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IER0_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IER0_CPAS      = 0x4  // Bit CPAS.
	TC_IER0_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IER0_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IER0_CPBS      = 0x8  // Bit CPBS.
	TC_IER0_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IER0_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IER0_CPCS      = 0x10 // Bit CPCS.
	TC_IER0_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IER0_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IER0_LDRAS     = 0x20 // Bit LDRAS.
	TC_IER0_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IER0_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IER0_LDRBS     = 0x40 // Bit LDRBS.
	TC_IER0_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IER0_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IER0_ETRGS     = 0x80 // Bit ETRGS.

	// IDR0: Interrupt Disable Register (channel = 0)
	TC_IDR0_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IDR0_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IDR0_COVFS     = 0x1  // Bit COVFS.
	TC_IDR0_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IDR0_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IDR0_LOVRS     = 0x2  // Bit LOVRS.
	TC_IDR0_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IDR0_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IDR0_CPAS      = 0x4  // Bit CPAS.
	TC_IDR0_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IDR0_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IDR0_CPBS      = 0x8  // Bit CPBS.
	TC_IDR0_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IDR0_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IDR0_CPCS      = 0x10 // Bit CPCS.
	TC_IDR0_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IDR0_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IDR0_LDRAS     = 0x20 // Bit LDRAS.
	TC_IDR0_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IDR0_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IDR0_LDRBS     = 0x40 // Bit LDRBS.
	TC_IDR0_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IDR0_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IDR0_ETRGS     = 0x80 // Bit ETRGS.

	// IMR0: Interrupt Mask Register (channel = 0)
	TC_IMR0_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IMR0_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IMR0_COVFS     = 0x1  // Bit COVFS.
	TC_IMR0_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IMR0_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IMR0_LOVRS     = 0x2  // Bit LOVRS.
	TC_IMR0_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IMR0_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IMR0_CPAS      = 0x4  // Bit CPAS.
	TC_IMR0_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IMR0_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IMR0_CPBS      = 0x8  // Bit CPBS.
	TC_IMR0_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IMR0_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IMR0_CPCS      = 0x10 // Bit CPCS.
	TC_IMR0_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IMR0_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IMR0_LDRAS     = 0x20 // Bit LDRAS.
	TC_IMR0_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IMR0_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IMR0_LDRBS     = 0x40 // Bit LDRBS.
	TC_IMR0_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IMR0_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IMR0_ETRGS     = 0x80 // Bit ETRGS.

	// CCR1: Channel Control Register (channel = 1)
	TC_CCR1_CLKEN_Pos  = 0x0 // Position of CLKEN field.
	TC_CCR1_CLKEN_Msk  = 0x1 // Bit mask of CLKEN field.
	TC_CCR1_CLKEN      = 0x1 // Bit CLKEN.
	TC_CCR1_CLKDIS_Pos = 0x1 // Position of CLKDIS field.
	TC_CCR1_CLKDIS_Msk = 0x2 // Bit mask of CLKDIS field.
	TC_CCR1_CLKDIS     = 0x2 // Bit CLKDIS.
	TC_CCR1_SWTRG_Pos  = 0x2 // Position of SWTRG field.
	TC_CCR1_SWTRG_Msk  = 0x4 // Bit mask of SWTRG field.
	TC_CCR1_SWTRG      = 0x4 // Bit SWTRG.

	// CMR1: Channel Mode Register (channel = 1)
	TC_CMR1_TCCLKS_Pos          = 0x0     // Position of TCCLKS field.
	TC_CMR1_TCCLKS_Msk          = 0x7     // Bit mask of TCCLKS field.
	TC_CMR1_TCCLKS_TIMER_CLOCK1 = 0x0     // Clock selected: TCLK1
	TC_CMR1_TCCLKS_TIMER_CLOCK2 = 0x1     // Clock selected: TCLK2
	TC_CMR1_TCCLKS_TIMER_CLOCK3 = 0x2     // Clock selected: TCLK3
	TC_CMR1_TCCLKS_TIMER_CLOCK4 = 0x3     // Clock selected: TCLK4
	TC_CMR1_TCCLKS_TIMER_CLOCK5 = 0x4     // Clock selected: TCLK5
	TC_CMR1_TCCLKS_XC0          = 0x5     // Clock selected: XC0
	TC_CMR1_TCCLKS_XC1          = 0x6     // Clock selected: XC1
	TC_CMR1_TCCLKS_XC2          = 0x7     // Clock selected: XC2
	TC_CMR1_CLKI_Pos            = 0x3     // Position of CLKI field.
	TC_CMR1_CLKI_Msk            = 0x8     // Bit mask of CLKI field.
	TC_CMR1_CLKI                = 0x8     // Bit CLKI.
	TC_CMR1_BURST_Pos           = 0x4     // Position of BURST field.
	TC_CMR1_BURST_Msk           = 0x30    // Bit mask of BURST field.
	TC_CMR1_BURST_NONE          = 0x0     // The clock is not gated by an external signal.
	TC_CMR1_BURST_XC0           = 0x1     // XC0 is ANDed with the selected clock.
	TC_CMR1_BURST_XC1           = 0x2     // XC1 is ANDed with the selected clock.
	TC_CMR1_BURST_XC2           = 0x3     // XC2 is ANDed with the selected clock.
	TC_CMR1_LDBSTOP_Pos         = 0x6     // Position of LDBSTOP field.
	TC_CMR1_LDBSTOP_Msk         = 0x40    // Bit mask of LDBSTOP field.
	TC_CMR1_LDBSTOP             = 0x40    // Bit LDBSTOP.
	TC_CMR1_LDBDIS_Pos          = 0x7     // Position of LDBDIS field.
	TC_CMR1_LDBDIS_Msk          = 0x80    // Bit mask of LDBDIS field.
	TC_CMR1_LDBDIS              = 0x80    // Bit LDBDIS.
	TC_CMR1_ETRGEDG_Pos         = 0x8     // Position of ETRGEDG field.
	TC_CMR1_ETRGEDG_Msk         = 0x300   // Bit mask of ETRGEDG field.
	TC_CMR1_ETRGEDG_NONE        = 0x0     // The clock is not gated by an external signal.
	TC_CMR1_ETRGEDG_RISING      = 0x1     // Rising edge
	TC_CMR1_ETRGEDG_FALLING     = 0x2     // Falling edge
	TC_CMR1_ETRGEDG_EDGE        = 0x3     // Each edge
	TC_CMR1_ABETRG_Pos          = 0xa     // Position of ABETRG field.
	TC_CMR1_ABETRG_Msk          = 0x400   // Bit mask of ABETRG field.
	TC_CMR1_ABETRG              = 0x400   // Bit ABETRG.
	TC_CMR1_CPCTRG_Pos          = 0xe     // Position of CPCTRG field.
	TC_CMR1_CPCTRG_Msk          = 0x4000  // Bit mask of CPCTRG field.
	TC_CMR1_CPCTRG              = 0x4000  // Bit CPCTRG.
	TC_CMR1_WAVE_Pos            = 0xf     // Position of WAVE field.
	TC_CMR1_WAVE_Msk            = 0x8000  // Bit mask of WAVE field.
	TC_CMR1_WAVE                = 0x8000  // Bit WAVE.
	TC_CMR1_LDRA_Pos            = 0x10    // Position of LDRA field.
	TC_CMR1_LDRA_Msk            = 0x30000 // Bit mask of LDRA field.
	TC_CMR1_LDRA_NONE           = 0x0     // None
	TC_CMR1_LDRA_RISING         = 0x1     // Rising edge of TIOA
	TC_CMR1_LDRA_FALLING        = 0x2     // Falling edge of TIOA
	TC_CMR1_LDRA_EDGE           = 0x3     // Each edge of TIOA
	TC_CMR1_LDRB_Pos            = 0x12    // Position of LDRB field.
	TC_CMR1_LDRB_Msk            = 0xc0000 // Bit mask of LDRB field.
	TC_CMR1_LDRB_NONE           = 0x0     // None
	TC_CMR1_LDRB_RISING         = 0x1     // Rising edge of TIOA
	TC_CMR1_LDRB_FALLING        = 0x2     // Falling edge of TIOA
	TC_CMR1_LDRB_EDGE           = 0x3     // Each edge of TIOA

	// CMR1_WAVE_EQ_1: Channel Mode Register (channel = 1)
	TC_CMR1_WAVE_EQ_1_TCCLKS_Pos          = 0x0        // Position of TCCLKS field.
	TC_CMR1_WAVE_EQ_1_TCCLKS_Msk          = 0x7        // Bit mask of TCCLKS field.
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0        // Clock selected: TCLK1
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1        // Clock selected: TCLK2
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2        // Clock selected: TCLK3
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3        // Clock selected: TCLK4
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4        // Clock selected: TCLK5
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC0          = 0x5        // Clock selected: XC0
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC1          = 0x6        // Clock selected: XC1
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC2          = 0x7        // Clock selected: XC2
	TC_CMR1_WAVE_EQ_1_CLKI_Pos            = 0x3        // Position of CLKI field.
	TC_CMR1_WAVE_EQ_1_CLKI_Msk            = 0x8        // Bit mask of CLKI field.
	TC_CMR1_WAVE_EQ_1_CLKI                = 0x8        // Bit CLKI.
	TC_CMR1_WAVE_EQ_1_BURST_Pos           = 0x4        // Position of BURST field.
	TC_CMR1_WAVE_EQ_1_BURST_Msk           = 0x30       // Bit mask of BURST field.
	TC_CMR1_WAVE_EQ_1_BURST_NONE          = 0x0        // The clock is not gated by an external signal.
	TC_CMR1_WAVE_EQ_1_BURST_XC0           = 0x1        // XC0 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_BURST_XC1           = 0x2        // XC1 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_BURST_XC2           = 0x3        // XC2 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_CPCSTOP_Pos         = 0x6        // Position of CPCSTOP field.
	TC_CMR1_WAVE_EQ_1_CPCSTOP_Msk         = 0x40       // Bit mask of CPCSTOP field.
	TC_CMR1_WAVE_EQ_1_CPCSTOP             = 0x40       // Bit CPCSTOP.
	TC_CMR1_WAVE_EQ_1_CPCDIS_Pos          = 0x7        // Position of CPCDIS field.
	TC_CMR1_WAVE_EQ_1_CPCDIS_Msk          = 0x80       // Bit mask of CPCDIS field.
	TC_CMR1_WAVE_EQ_1_CPCDIS              = 0x80       // Bit CPCDIS.
	TC_CMR1_WAVE_EQ_1_EEVTEDG_Pos         = 0x8        // Position of EEVTEDG field.
	TC_CMR1_WAVE_EQ_1_EEVTEDG_Msk         = 0x300      // Bit mask of EEVTEDG field.
	TC_CMR1_WAVE_EQ_1_EEVTEDG_NONE        = 0x0        // None
	TC_CMR1_WAVE_EQ_1_EEVTEDG_RISING      = 0x1        // Rising edge
	TC_CMR1_WAVE_EQ_1_EEVTEDG_FALLING     = 0x2        // Falling edge
	TC_CMR1_WAVE_EQ_1_EEVTEDG_EDGE        = 0x3        // Each edge
	TC_CMR1_WAVE_EQ_1_EEVT_Pos            = 0xa        // Position of EEVT field.
	TC_CMR1_WAVE_EQ_1_EEVT_Msk            = 0xc00      // Bit mask of EEVT field.
	TC_CMR1_WAVE_EQ_1_EEVT_TIOB           = 0x0        // TIOB
	TC_CMR1_WAVE_EQ_1_EEVT_XC0            = 0x1        // XC0
	TC_CMR1_WAVE_EQ_1_EEVT_XC1            = 0x2        // XC1
	TC_CMR1_WAVE_EQ_1_EEVT_XC2            = 0x3        // XC2
	TC_CMR1_WAVE_EQ_1_ENETRG_Pos          = 0xc        // Position of ENETRG field.
	TC_CMR1_WAVE_EQ_1_ENETRG_Msk          = 0x1000     // Bit mask of ENETRG field.
	TC_CMR1_WAVE_EQ_1_ENETRG              = 0x1000     // Bit ENETRG.
	TC_CMR1_WAVE_EQ_1_WAVSEL_Pos          = 0xd        // Position of WAVSEL field.
	TC_CMR1_WAVE_EQ_1_WAVSEL_Msk          = 0x6000     // Bit mask of WAVSEL field.
	TC_CMR1_WAVE_EQ_1_WAVSEL_UP           = 0x0        // UP mode without automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UP_RC        = 0x1        // UP mode with automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UPDOWN       = 0x2        // UPDOWN mode without automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UPDOWN_RC    = 0x3        // UPDOWN mode with automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVE_Pos            = 0xf        // Position of WAVE field.
	TC_CMR1_WAVE_EQ_1_WAVE_Msk            = 0x8000     // Bit mask of WAVE field.
	TC_CMR1_WAVE_EQ_1_WAVE                = 0x8000     // Bit WAVE.
	TC_CMR1_WAVE_EQ_1_ACPA_Pos            = 0x10       // Position of ACPA field.
	TC_CMR1_WAVE_EQ_1_ACPA_Msk            = 0x30000    // Bit mask of ACPA field.
	TC_CMR1_WAVE_EQ_1_ACPA_NONE           = 0x0        // None
	TC_CMR1_WAVE_EQ_1_ACPA_SET            = 0x1        // Set
	TC_CMR1_WAVE_EQ_1_ACPA_CLEAR          = 0x2        // Clear
	TC_CMR1_WAVE_EQ_1_ACPA_TOGGLE         = 0x3        // Toggle
	TC_CMR1_WAVE_EQ_1_ACPC_Pos            = 0x12       // Position of ACPC field.
	TC_CMR1_WAVE_EQ_1_ACPC_Msk            = 0xc0000    // Bit mask of ACPC field.
	TC_CMR1_WAVE_EQ_1_ACPC_NONE           = 0x0        // None
	TC_CMR1_WAVE_EQ_1_ACPC_SET            = 0x1        // Set
	TC_CMR1_WAVE_EQ_1_ACPC_CLEAR          = 0x2        // Clear
	TC_CMR1_WAVE_EQ_1_ACPC_TOGGLE         = 0x3        // Toggle
	TC_CMR1_WAVE_EQ_1_AEEVT_Pos           = 0x14       // Position of AEEVT field.
	TC_CMR1_WAVE_EQ_1_AEEVT_Msk           = 0x300000   // Bit mask of AEEVT field.
	TC_CMR1_WAVE_EQ_1_AEEVT_NONE          = 0x0        // None
	TC_CMR1_WAVE_EQ_1_AEEVT_SET           = 0x1        // Set
	TC_CMR1_WAVE_EQ_1_AEEVT_CLEAR         = 0x2        // Clear
	TC_CMR1_WAVE_EQ_1_AEEVT_TOGGLE        = 0x3        // Toggle
	TC_CMR1_WAVE_EQ_1_ASWTRG_Pos          = 0x16       // Position of ASWTRG field.
	TC_CMR1_WAVE_EQ_1_ASWTRG_Msk          = 0xc00000   // Bit mask of ASWTRG field.
	TC_CMR1_WAVE_EQ_1_ASWTRG_NONE         = 0x0        // None
	TC_CMR1_WAVE_EQ_1_ASWTRG_SET          = 0x1        // Set
	TC_CMR1_WAVE_EQ_1_ASWTRG_CLEAR        = 0x2        // Clear
	TC_CMR1_WAVE_EQ_1_ASWTRG_TOGGLE       = 0x3        // Toggle
	TC_CMR1_WAVE_EQ_1_BCPB_Pos            = 0x18       // Position of BCPB field.
	TC_CMR1_WAVE_EQ_1_BCPB_Msk            = 0x3000000  // Bit mask of BCPB field.
	TC_CMR1_WAVE_EQ_1_BCPB_NONE           = 0x0        // None
	TC_CMR1_WAVE_EQ_1_BCPB_SET            = 0x1        // Set
	TC_CMR1_WAVE_EQ_1_BCPB_CLEAR          = 0x2        // Clear
	TC_CMR1_WAVE_EQ_1_BCPB_TOGGLE         = 0x3        // Toggle
	TC_CMR1_WAVE_EQ_1_BCPC_Pos            = 0x1a       // Position of BCPC field.
	TC_CMR1_WAVE_EQ_1_BCPC_Msk            = 0xc000000  // Bit mask of BCPC field.
	TC_CMR1_WAVE_EQ_1_BCPC_NONE           = 0x0        // None
	TC_CMR1_WAVE_EQ_1_BCPC_SET            = 0x1        // Set
	TC_CMR1_WAVE_EQ_1_BCPC_CLEAR          = 0x2        // Clear
	TC_CMR1_WAVE_EQ_1_BCPC_TOGGLE         = 0x3        // Toggle
	TC_CMR1_WAVE_EQ_1_BEEVT_Pos           = 0x1c       // Position of BEEVT field.
	TC_CMR1_WAVE_EQ_1_BEEVT_Msk           = 0x30000000 // Bit mask of BEEVT field.
	TC_CMR1_WAVE_EQ_1_BEEVT_NONE          = 0x0        // None
	TC_CMR1_WAVE_EQ_1_BEEVT_SET           = 0x1        // Set
	TC_CMR1_WAVE_EQ_1_BEEVT_CLEAR         = 0x2        // Clear
	TC_CMR1_WAVE_EQ_1_BEEVT_TOGGLE        = 0x3        // Toggle
	TC_CMR1_WAVE_EQ_1_BSWTRG_Pos          = 0x1e       // Position of BSWTRG field.
	TC_CMR1_WAVE_EQ_1_BSWTRG_Msk          = 0xc0000000 // Bit mask of BSWTRG field.
	TC_CMR1_WAVE_EQ_1_BSWTRG_NONE         = 0x0        // None
	TC_CMR1_WAVE_EQ_1_BSWTRG_SET          = 0x1        // Set
	TC_CMR1_WAVE_EQ_1_BSWTRG_CLEAR        = 0x2        // Clear
	TC_CMR1_WAVE_EQ_1_BSWTRG_TOGGLE       = 0x3        // Toggle

	// CV1: Counter Value (channel = 1)
	TC_CV1_CV_Pos = 0x0    // Position of CV field.
	TC_CV1_CV_Msk = 0xffff // Bit mask of CV field.

	// RA1: Register A (channel = 1)
	TC_RA1_RA_Pos = 0x0    // Position of RA field.
	TC_RA1_RA_Msk = 0xffff // Bit mask of RA field.

	// RB1: Register B (channel = 1)
	TC_RB1_RB_Pos = 0x0    // Position of RB field.
	TC_RB1_RB_Msk = 0xffff // Bit mask of RB field.

	// RC1: Register C (channel = 1)
	TC_RC1_RC_Pos = 0x0    // Position of RC field.
	TC_RC1_RC_Msk = 0xffff // Bit mask of RC field.

	// SR1: Status Register (channel = 1)
	TC_SR1_COVFS_Pos  = 0x0     // Position of COVFS field.
	TC_SR1_COVFS_Msk  = 0x1     // Bit mask of COVFS field.
	TC_SR1_COVFS      = 0x1     // Bit COVFS.
	TC_SR1_LOVRS_Pos  = 0x1     // Position of LOVRS field.
	TC_SR1_LOVRS_Msk  = 0x2     // Bit mask of LOVRS field.
	TC_SR1_LOVRS      = 0x2     // Bit LOVRS.
	TC_SR1_CPAS_Pos   = 0x2     // Position of CPAS field.
	TC_SR1_CPAS_Msk   = 0x4     // Bit mask of CPAS field.
	TC_SR1_CPAS       = 0x4     // Bit CPAS.
	TC_SR1_CPBS_Pos   = 0x3     // Position of CPBS field.
	TC_SR1_CPBS_Msk   = 0x8     // Bit mask of CPBS field.
	TC_SR1_CPBS       = 0x8     // Bit CPBS.
	TC_SR1_CPCS_Pos   = 0x4     // Position of CPCS field.
	TC_SR1_CPCS_Msk   = 0x10    // Bit mask of CPCS field.
	TC_SR1_CPCS       = 0x10    // Bit CPCS.
	TC_SR1_LDRAS_Pos  = 0x5     // Position of LDRAS field.
	TC_SR1_LDRAS_Msk  = 0x20    // Bit mask of LDRAS field.
	TC_SR1_LDRAS      = 0x20    // Bit LDRAS.
	TC_SR1_LDRBS_Pos  = 0x6     // Position of LDRBS field.
	TC_SR1_LDRBS_Msk  = 0x40    // Bit mask of LDRBS field.
	TC_SR1_LDRBS      = 0x40    // Bit LDRBS.
	TC_SR1_ETRGS_Pos  = 0x7     // Position of ETRGS field.
	TC_SR1_ETRGS_Msk  = 0x80    // Bit mask of ETRGS field.
	TC_SR1_ETRGS      = 0x80    // Bit ETRGS.
	TC_SR1_CLKSTA_Pos = 0x10    // Position of CLKSTA field.
	TC_SR1_CLKSTA_Msk = 0x10000 // Bit mask of CLKSTA field.
	TC_SR1_CLKSTA     = 0x10000 // Bit CLKSTA.
	TC_SR1_MTIOA_Pos  = 0x11    // Position of MTIOA field.
	TC_SR1_MTIOA_Msk  = 0x20000 // Bit mask of MTIOA field.
	TC_SR1_MTIOA      = 0x20000 // Bit MTIOA.
	TC_SR1_MTIOB_Pos  = 0x12    // Position of MTIOB field.
	TC_SR1_MTIOB_Msk  = 0x40000 // Bit mask of MTIOB field.
	TC_SR1_MTIOB      = 0x40000 // Bit MTIOB.

	// IER1: Interrupt Enable Register (channel = 1)
	TC_IER1_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IER1_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IER1_COVFS     = 0x1  // Bit COVFS.
	TC_IER1_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IER1_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IER1_LOVRS     = 0x2  // Bit LOVRS.
	TC_IER1_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IER1_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IER1_CPAS      = 0x4  // Bit CPAS.
	TC_IER1_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IER1_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IER1_CPBS      = 0x8  // Bit CPBS.
	TC_IER1_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IER1_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IER1_CPCS      = 0x10 // Bit CPCS.
	TC_IER1_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IER1_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IER1_LDRAS     = 0x20 // Bit LDRAS.
	TC_IER1_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IER1_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IER1_LDRBS     = 0x40 // Bit LDRBS.
	TC_IER1_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IER1_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IER1_ETRGS     = 0x80 // Bit ETRGS.

	// IDR1: Interrupt Disable Register (channel = 1)
	TC_IDR1_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IDR1_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IDR1_COVFS     = 0x1  // Bit COVFS.
	TC_IDR1_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IDR1_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IDR1_LOVRS     = 0x2  // Bit LOVRS.
	TC_IDR1_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IDR1_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IDR1_CPAS      = 0x4  // Bit CPAS.
	TC_IDR1_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IDR1_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IDR1_CPBS      = 0x8  // Bit CPBS.
	TC_IDR1_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IDR1_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IDR1_CPCS      = 0x10 // Bit CPCS.
	TC_IDR1_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IDR1_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IDR1_LDRAS     = 0x20 // Bit LDRAS.
	TC_IDR1_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IDR1_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IDR1_LDRBS     = 0x40 // Bit LDRBS.
	TC_IDR1_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IDR1_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IDR1_ETRGS     = 0x80 // Bit ETRGS.

	// IMR1: Interrupt Mask Register (channel = 1)
	TC_IMR1_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IMR1_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IMR1_COVFS     = 0x1  // Bit COVFS.
	TC_IMR1_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IMR1_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IMR1_LOVRS     = 0x2  // Bit LOVRS.
	TC_IMR1_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IMR1_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IMR1_CPAS      = 0x4  // Bit CPAS.
	TC_IMR1_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IMR1_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IMR1_CPBS      = 0x8  // Bit CPBS.
	TC_IMR1_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IMR1_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IMR1_CPCS      = 0x10 // Bit CPCS.
	TC_IMR1_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IMR1_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IMR1_LDRAS     = 0x20 // Bit LDRAS.
	TC_IMR1_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IMR1_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IMR1_LDRBS     = 0x40 // Bit LDRBS.
	TC_IMR1_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IMR1_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IMR1_ETRGS     = 0x80 // Bit ETRGS.

	// CCR2: Channel Control Register (channel = 2)
	TC_CCR2_CLKEN_Pos  = 0x0 // Position of CLKEN field.
	TC_CCR2_CLKEN_Msk  = 0x1 // Bit mask of CLKEN field.
	TC_CCR2_CLKEN      = 0x1 // Bit CLKEN.
	TC_CCR2_CLKDIS_Pos = 0x1 // Position of CLKDIS field.
	TC_CCR2_CLKDIS_Msk = 0x2 // Bit mask of CLKDIS field.
	TC_CCR2_CLKDIS     = 0x2 // Bit CLKDIS.
	TC_CCR2_SWTRG_Pos  = 0x2 // Position of SWTRG field.
	TC_CCR2_SWTRG_Msk  = 0x4 // Bit mask of SWTRG field.
	TC_CCR2_SWTRG      = 0x4 // Bit SWTRG.

	// CMR2: Channel Mode Register (channel = 2)
	TC_CMR2_TCCLKS_Pos          = 0x0     // Position of TCCLKS field.
	TC_CMR2_TCCLKS_Msk          = 0x7     // Bit mask of TCCLKS field.
	TC_CMR2_TCCLKS_TIMER_CLOCK1 = 0x0     // Clock selected: TCLK1
	TC_CMR2_TCCLKS_TIMER_CLOCK2 = 0x1     // Clock selected: TCLK2
	TC_CMR2_TCCLKS_TIMER_CLOCK3 = 0x2     // Clock selected: TCLK3
	TC_CMR2_TCCLKS_TIMER_CLOCK4 = 0x3     // Clock selected: TCLK4
	TC_CMR2_TCCLKS_TIMER_CLOCK5 = 0x4     // Clock selected: TCLK5
	TC_CMR2_TCCLKS_XC0          = 0x5     // Clock selected: XC0
	TC_CMR2_TCCLKS_XC1          = 0x6     // Clock selected: XC1
	TC_CMR2_TCCLKS_XC2          = 0x7     // Clock selected: XC2
	TC_CMR2_CLKI_Pos            = 0x3     // Position of CLKI field.
	TC_CMR2_CLKI_Msk            = 0x8     // Bit mask of CLKI field.
	TC_CMR2_CLKI                = 0x8     // Bit CLKI.
	TC_CMR2_BURST_Pos           = 0x4     // Position of BURST field.
	TC_CMR2_BURST_Msk           = 0x30    // Bit mask of BURST field.
	TC_CMR2_BURST_NONE          = 0x0     // The clock is not gated by an external signal.
	TC_CMR2_BURST_XC0           = 0x1     // XC0 is ANDed with the selected clock.
	TC_CMR2_BURST_XC1           = 0x2     // XC1 is ANDed with the selected clock.
	TC_CMR2_BURST_XC2           = 0x3     // XC2 is ANDed with the selected clock.
	TC_CMR2_LDBSTOP_Pos         = 0x6     // Position of LDBSTOP field.
	TC_CMR2_LDBSTOP_Msk         = 0x40    // Bit mask of LDBSTOP field.
	TC_CMR2_LDBSTOP             = 0x40    // Bit LDBSTOP.
	TC_CMR2_LDBDIS_Pos          = 0x7     // Position of LDBDIS field.
	TC_CMR2_LDBDIS_Msk          = 0x80    // Bit mask of LDBDIS field.
	TC_CMR2_LDBDIS              = 0x80    // Bit LDBDIS.
	TC_CMR2_ETRGEDG_Pos         = 0x8     // Position of ETRGEDG field.
	TC_CMR2_ETRGEDG_Msk         = 0x300   // Bit mask of ETRGEDG field.
	TC_CMR2_ETRGEDG_NONE        = 0x0     // The clock is not gated by an external signal.
	TC_CMR2_ETRGEDG_RISING      = 0x1     // Rising edge
	TC_CMR2_ETRGEDG_FALLING     = 0x2     // Falling edge
	TC_CMR2_ETRGEDG_EDGE        = 0x3     // Each edge
	TC_CMR2_ABETRG_Pos          = 0xa     // Position of ABETRG field.
	TC_CMR2_ABETRG_Msk          = 0x400   // Bit mask of ABETRG field.
	TC_CMR2_ABETRG              = 0x400   // Bit ABETRG.
	TC_CMR2_CPCTRG_Pos          = 0xe     // Position of CPCTRG field.
	TC_CMR2_CPCTRG_Msk          = 0x4000  // Bit mask of CPCTRG field.
	TC_CMR2_CPCTRG              = 0x4000  // Bit CPCTRG.
	TC_CMR2_WAVE_Pos            = 0xf     // Position of WAVE field.
	TC_CMR2_WAVE_Msk            = 0x8000  // Bit mask of WAVE field.
	TC_CMR2_WAVE                = 0x8000  // Bit WAVE.
	TC_CMR2_LDRA_Pos            = 0x10    // Position of LDRA field.
	TC_CMR2_LDRA_Msk            = 0x30000 // Bit mask of LDRA field.
	TC_CMR2_LDRA_NONE           = 0x0     // None
	TC_CMR2_LDRA_RISING         = 0x1     // Rising edge of TIOA
	TC_CMR2_LDRA_FALLING        = 0x2     // Falling edge of TIOA
	TC_CMR2_LDRA_EDGE           = 0x3     // Each edge of TIOA
	TC_CMR2_LDRB_Pos            = 0x12    // Position of LDRB field.
	TC_CMR2_LDRB_Msk            = 0xc0000 // Bit mask of LDRB field.
	TC_CMR2_LDRB_NONE           = 0x0     // None
	TC_CMR2_LDRB_RISING         = 0x1     // Rising edge of TIOA
	TC_CMR2_LDRB_FALLING        = 0x2     // Falling edge of TIOA
	TC_CMR2_LDRB_EDGE           = 0x3     // Each edge of TIOA

	// CMR2_WAVE_EQ_1: Channel Mode Register (channel = 2)
	TC_CMR2_WAVE_EQ_1_TCCLKS_Pos          = 0x0        // Position of TCCLKS field.
	TC_CMR2_WAVE_EQ_1_TCCLKS_Msk          = 0x7        // Bit mask of TCCLKS field.
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0        // Clock selected: TCLK1
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1        // Clock selected: TCLK2
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2        // Clock selected: TCLK3
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3        // Clock selected: TCLK4
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4        // Clock selected: TCLK5
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC0          = 0x5        // Clock selected: XC0
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC1          = 0x6        // Clock selected: XC1
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC2          = 0x7        // Clock selected: XC2
	TC_CMR2_WAVE_EQ_1_CLKI_Pos            = 0x3        // Position of CLKI field.
	TC_CMR2_WAVE_EQ_1_CLKI_Msk            = 0x8        // Bit mask of CLKI field.
	TC_CMR2_WAVE_EQ_1_CLKI                = 0x8        // Bit CLKI.
	TC_CMR2_WAVE_EQ_1_BURST_Pos           = 0x4        // Position of BURST field.
	TC_CMR2_WAVE_EQ_1_BURST_Msk           = 0x30       // Bit mask of BURST field.
	TC_CMR2_WAVE_EQ_1_BURST_NONE          = 0x0        // The clock is not gated by an external signal.
	TC_CMR2_WAVE_EQ_1_BURST_XC0           = 0x1        // XC0 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_BURST_XC1           = 0x2        // XC1 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_BURST_XC2           = 0x3        // XC2 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_CPCSTOP_Pos         = 0x6        // Position of CPCSTOP field.
	TC_CMR2_WAVE_EQ_1_CPCSTOP_Msk         = 0x40       // Bit mask of CPCSTOP field.
	TC_CMR2_WAVE_EQ_1_CPCSTOP             = 0x40       // Bit CPCSTOP.
	TC_CMR2_WAVE_EQ_1_CPCDIS_Pos          = 0x7        // Position of CPCDIS field.
	TC_CMR2_WAVE_EQ_1_CPCDIS_Msk          = 0x80       // Bit mask of CPCDIS field.
	TC_CMR2_WAVE_EQ_1_CPCDIS              = 0x80       // Bit CPCDIS.
	TC_CMR2_WAVE_EQ_1_EEVTEDG_Pos         = 0x8        // Position of EEVTEDG field.
	TC_CMR2_WAVE_EQ_1_EEVTEDG_Msk         = 0x300      // Bit mask of EEVTEDG field.
	TC_CMR2_WAVE_EQ_1_EEVTEDG_NONE        = 0x0        // None
	TC_CMR2_WAVE_EQ_1_EEVTEDG_RISING      = 0x1        // Rising edge
	TC_CMR2_WAVE_EQ_1_EEVTEDG_FALLING     = 0x2        // Falling edge
	TC_CMR2_WAVE_EQ_1_EEVTEDG_EDGE        = 0x3        // Each edge
	TC_CMR2_WAVE_EQ_1_EEVT_Pos            = 0xa        // Position of EEVT field.
	TC_CMR2_WAVE_EQ_1_EEVT_Msk            = 0xc00      // Bit mask of EEVT field.
	TC_CMR2_WAVE_EQ_1_EEVT_TIOB           = 0x0        // TIOB
	TC_CMR2_WAVE_EQ_1_EEVT_XC0            = 0x1        // XC0
	TC_CMR2_WAVE_EQ_1_EEVT_XC1            = 0x2        // XC1
	TC_CMR2_WAVE_EQ_1_EEVT_XC2            = 0x3        // XC2
	TC_CMR2_WAVE_EQ_1_ENETRG_Pos          = 0xc        // Position of ENETRG field.
	TC_CMR2_WAVE_EQ_1_ENETRG_Msk          = 0x1000     // Bit mask of ENETRG field.
	TC_CMR2_WAVE_EQ_1_ENETRG              = 0x1000     // Bit ENETRG.
	TC_CMR2_WAVE_EQ_1_WAVSEL_Pos          = 0xd        // Position of WAVSEL field.
	TC_CMR2_WAVE_EQ_1_WAVSEL_Msk          = 0x6000     // Bit mask of WAVSEL field.
	TC_CMR2_WAVE_EQ_1_WAVSEL_UP           = 0x0        // UP mode without automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UP_RC        = 0x1        // UP mode with automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UPDOWN       = 0x2        // UPDOWN mode without automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UPDOWN_RC    = 0x3        // UPDOWN mode with automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVE_Pos            = 0xf        // Position of WAVE field.
	TC_CMR2_WAVE_EQ_1_WAVE_Msk            = 0x8000     // Bit mask of WAVE field.
	TC_CMR2_WAVE_EQ_1_WAVE                = 0x8000     // Bit WAVE.
	TC_CMR2_WAVE_EQ_1_ACPA_Pos            = 0x10       // Position of ACPA field.
	TC_CMR2_WAVE_EQ_1_ACPA_Msk            = 0x30000    // Bit mask of ACPA field.
	TC_CMR2_WAVE_EQ_1_ACPA_NONE           = 0x0        // None
	TC_CMR2_WAVE_EQ_1_ACPA_SET            = 0x1        // Set
	TC_CMR2_WAVE_EQ_1_ACPA_CLEAR          = 0x2        // Clear
	TC_CMR2_WAVE_EQ_1_ACPA_TOGGLE         = 0x3        // Toggle
	TC_CMR2_WAVE_EQ_1_ACPC_Pos            = 0x12       // Position of ACPC field.
	TC_CMR2_WAVE_EQ_1_ACPC_Msk            = 0xc0000    // Bit mask of ACPC field.
	TC_CMR2_WAVE_EQ_1_ACPC_NONE           = 0x0        // None
	TC_CMR2_WAVE_EQ_1_ACPC_SET            = 0x1        // Set
	TC_CMR2_WAVE_EQ_1_ACPC_CLEAR          = 0x2        // Clear
	TC_CMR2_WAVE_EQ_1_ACPC_TOGGLE         = 0x3        // Toggle
	TC_CMR2_WAVE_EQ_1_AEEVT_Pos           = 0x14       // Position of AEEVT field.
	TC_CMR2_WAVE_EQ_1_AEEVT_Msk           = 0x300000   // Bit mask of AEEVT field.
	TC_CMR2_WAVE_EQ_1_AEEVT_NONE          = 0x0        // None
	TC_CMR2_WAVE_EQ_1_AEEVT_SET           = 0x1        // Set
	TC_CMR2_WAVE_EQ_1_AEEVT_CLEAR         = 0x2        // Clear
	TC_CMR2_WAVE_EQ_1_AEEVT_TOGGLE        = 0x3        // Toggle
	TC_CMR2_WAVE_EQ_1_ASWTRG_Pos          = 0x16       // Position of ASWTRG field.
	TC_CMR2_WAVE_EQ_1_ASWTRG_Msk          = 0xc00000   // Bit mask of ASWTRG field.
	TC_CMR2_WAVE_EQ_1_ASWTRG_NONE         = 0x0        // None
	TC_CMR2_WAVE_EQ_1_ASWTRG_SET          = 0x1        // Set
	TC_CMR2_WAVE_EQ_1_ASWTRG_CLEAR        = 0x2        // Clear
	TC_CMR2_WAVE_EQ_1_ASWTRG_TOGGLE       = 0x3        // Toggle
	TC_CMR2_WAVE_EQ_1_BCPB_Pos            = 0x18       // Position of BCPB field.
	TC_CMR2_WAVE_EQ_1_BCPB_Msk            = 0x3000000  // Bit mask of BCPB field.
	TC_CMR2_WAVE_EQ_1_BCPB_NONE           = 0x0        // None
	TC_CMR2_WAVE_EQ_1_BCPB_SET            = 0x1        // Set
	TC_CMR2_WAVE_EQ_1_BCPB_CLEAR          = 0x2        // Clear
	TC_CMR2_WAVE_EQ_1_BCPB_TOGGLE         = 0x3        // Toggle
	TC_CMR2_WAVE_EQ_1_BCPC_Pos            = 0x1a       // Position of BCPC field.
	TC_CMR2_WAVE_EQ_1_BCPC_Msk            = 0xc000000  // Bit mask of BCPC field.
	TC_CMR2_WAVE_EQ_1_BCPC_NONE           = 0x0        // None
	TC_CMR2_WAVE_EQ_1_BCPC_SET            = 0x1        // Set
	TC_CMR2_WAVE_EQ_1_BCPC_CLEAR          = 0x2        // Clear
	TC_CMR2_WAVE_EQ_1_BCPC_TOGGLE         = 0x3        // Toggle
	TC_CMR2_WAVE_EQ_1_BEEVT_Pos           = 0x1c       // Position of BEEVT field.
	TC_CMR2_WAVE_EQ_1_BEEVT_Msk           = 0x30000000 // Bit mask of BEEVT field.
	TC_CMR2_WAVE_EQ_1_BEEVT_NONE          = 0x0        // None
	TC_CMR2_WAVE_EQ_1_BEEVT_SET           = 0x1        // Set
	TC_CMR2_WAVE_EQ_1_BEEVT_CLEAR         = 0x2        // Clear
	TC_CMR2_WAVE_EQ_1_BEEVT_TOGGLE        = 0x3        // Toggle
	TC_CMR2_WAVE_EQ_1_BSWTRG_Pos          = 0x1e       // Position of BSWTRG field.
	TC_CMR2_WAVE_EQ_1_BSWTRG_Msk          = 0xc0000000 // Bit mask of BSWTRG field.
	TC_CMR2_WAVE_EQ_1_BSWTRG_NONE         = 0x0        // None
	TC_CMR2_WAVE_EQ_1_BSWTRG_SET          = 0x1        // Set
	TC_CMR2_WAVE_EQ_1_BSWTRG_CLEAR        = 0x2        // Clear
	TC_CMR2_WAVE_EQ_1_BSWTRG_TOGGLE       = 0x3        // Toggle

	// CV2: Counter Value (channel = 2)
	TC_CV2_CV_Pos = 0x0    // Position of CV field.
	TC_CV2_CV_Msk = 0xffff // Bit mask of CV field.

	// RA2: Register A (channel = 2)
	TC_RA2_RA_Pos = 0x0    // Position of RA field.
	TC_RA2_RA_Msk = 0xffff // Bit mask of RA field.

	// RB2: Register B (channel = 2)
	TC_RB2_RB_Pos = 0x0    // Position of RB field.
	TC_RB2_RB_Msk = 0xffff // Bit mask of RB field.

	// RC2: Register C (channel = 2)
	TC_RC2_RC_Pos = 0x0    // Position of RC field.
	TC_RC2_RC_Msk = 0xffff // Bit mask of RC field.

	// SR2: Status Register (channel = 2)
	TC_SR2_COVFS_Pos  = 0x0     // Position of COVFS field.
	TC_SR2_COVFS_Msk  = 0x1     // Bit mask of COVFS field.
	TC_SR2_COVFS      = 0x1     // Bit COVFS.
	TC_SR2_LOVRS_Pos  = 0x1     // Position of LOVRS field.
	TC_SR2_LOVRS_Msk  = 0x2     // Bit mask of LOVRS field.
	TC_SR2_LOVRS      = 0x2     // Bit LOVRS.
	TC_SR2_CPAS_Pos   = 0x2     // Position of CPAS field.
	TC_SR2_CPAS_Msk   = 0x4     // Bit mask of CPAS field.
	TC_SR2_CPAS       = 0x4     // Bit CPAS.
	TC_SR2_CPBS_Pos   = 0x3     // Position of CPBS field.
	TC_SR2_CPBS_Msk   = 0x8     // Bit mask of CPBS field.
	TC_SR2_CPBS       = 0x8     // Bit CPBS.
	TC_SR2_CPCS_Pos   = 0x4     // Position of CPCS field.
	TC_SR2_CPCS_Msk   = 0x10    // Bit mask of CPCS field.
	TC_SR2_CPCS       = 0x10    // Bit CPCS.
	TC_SR2_LDRAS_Pos  = 0x5     // Position of LDRAS field.
	TC_SR2_LDRAS_Msk  = 0x20    // Bit mask of LDRAS field.
	TC_SR2_LDRAS      = 0x20    // Bit LDRAS.
	TC_SR2_LDRBS_Pos  = 0x6     // Position of LDRBS field.
	TC_SR2_LDRBS_Msk  = 0x40    // Bit mask of LDRBS field.
	TC_SR2_LDRBS      = 0x40    // Bit LDRBS.
	TC_SR2_ETRGS_Pos  = 0x7     // Position of ETRGS field.
	TC_SR2_ETRGS_Msk  = 0x80    // Bit mask of ETRGS field.
	TC_SR2_ETRGS      = 0x80    // Bit ETRGS.
	TC_SR2_CLKSTA_Pos = 0x10    // Position of CLKSTA field.
	TC_SR2_CLKSTA_Msk = 0x10000 // Bit mask of CLKSTA field.
	TC_SR2_CLKSTA     = 0x10000 // Bit CLKSTA.
	TC_SR2_MTIOA_Pos  = 0x11    // Position of MTIOA field.
	TC_SR2_MTIOA_Msk  = 0x20000 // Bit mask of MTIOA field.
	TC_SR2_MTIOA      = 0x20000 // Bit MTIOA.
	TC_SR2_MTIOB_Pos  = 0x12    // Position of MTIOB field.
	TC_SR2_MTIOB_Msk  = 0x40000 // Bit mask of MTIOB field.
	TC_SR2_MTIOB      = 0x40000 // Bit MTIOB.

	// IER2: Interrupt Enable Register (channel = 2)
	TC_IER2_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IER2_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IER2_COVFS     = 0x1  // Bit COVFS.
	TC_IER2_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IER2_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IER2_LOVRS     = 0x2  // Bit LOVRS.
	TC_IER2_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IER2_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IER2_CPAS      = 0x4  // Bit CPAS.
	TC_IER2_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IER2_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IER2_CPBS      = 0x8  // Bit CPBS.
	TC_IER2_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IER2_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IER2_CPCS      = 0x10 // Bit CPCS.
	TC_IER2_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IER2_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IER2_LDRAS     = 0x20 // Bit LDRAS.
	TC_IER2_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IER2_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IER2_LDRBS     = 0x40 // Bit LDRBS.
	TC_IER2_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IER2_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IER2_ETRGS     = 0x80 // Bit ETRGS.

	// IDR2: Interrupt Disable Register (channel = 2)
	TC_IDR2_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IDR2_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IDR2_COVFS     = 0x1  // Bit COVFS.
	TC_IDR2_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IDR2_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IDR2_LOVRS     = 0x2  // Bit LOVRS.
	TC_IDR2_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IDR2_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IDR2_CPAS      = 0x4  // Bit CPAS.
	TC_IDR2_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IDR2_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IDR2_CPBS      = 0x8  // Bit CPBS.
	TC_IDR2_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IDR2_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IDR2_CPCS      = 0x10 // Bit CPCS.
	TC_IDR2_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IDR2_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IDR2_LDRAS     = 0x20 // Bit LDRAS.
	TC_IDR2_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IDR2_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IDR2_LDRBS     = 0x40 // Bit LDRBS.
	TC_IDR2_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IDR2_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IDR2_ETRGS     = 0x80 // Bit ETRGS.

	// IMR2: Interrupt Mask Register (channel = 2)
	TC_IMR2_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IMR2_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IMR2_COVFS     = 0x1  // Bit COVFS.
	TC_IMR2_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IMR2_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IMR2_LOVRS     = 0x2  // Bit LOVRS.
	TC_IMR2_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IMR2_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IMR2_CPAS      = 0x4  // Bit CPAS.
	TC_IMR2_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IMR2_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IMR2_CPBS      = 0x8  // Bit CPBS.
	TC_IMR2_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IMR2_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IMR2_CPCS      = 0x10 // Bit CPCS.
	TC_IMR2_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IMR2_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IMR2_LDRAS     = 0x20 // Bit LDRAS.
	TC_IMR2_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IMR2_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IMR2_LDRBS     = 0x40 // Bit LDRBS.
	TC_IMR2_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IMR2_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IMR2_ETRGS     = 0x80 // Bit ETRGS.

	// BCR: Block Control Register
	TC_BCR_SYNC_Pos = 0x0 // Position of SYNC field.
	TC_BCR_SYNC_Msk = 0x1 // Bit mask of SYNC field.
	TC_BCR_SYNC     = 0x1 // Bit SYNC.

	// BMR: Block Mode Register
	TC_BMR_TC0XC0S_Pos   = 0x0  // Position of TC0XC0S field.
	TC_BMR_TC0XC0S_Msk   = 0x3  // Bit mask of TC0XC0S field.
	TC_BMR_TC0XC0S_TCLK0 = 0x0  // Signal connected to XC0: TCLK0
	TC_BMR_TC0XC0S_TCLK1 = 0x2  // Signal connected to XC0: TCLK1
	TC_BMR_TC0XC0S_TCLK2 = 0x3  // Signal connected to XC0: TCLK2
	TC_BMR_TC1XC1S_Pos   = 0x2  // Position of TC1XC1S field.
	TC_BMR_TC1XC1S_Msk   = 0xc  // Bit mask of TC1XC1S field.
	TC_BMR_TC1XC1S_TCLK0 = 0x0  // Signal connected to XC1: TCLK0
	TC_BMR_TC1XC1S_TCLK1 = 0x2  // Signal connected to XC1: TCLK1
	TC_BMR_TC1XC1S_TCLK2 = 0x3  // Signal connected to XC1: TCLK2
	TC_BMR_TC2XC2S_Pos   = 0x4  // Position of TC2XC2S field.
	TC_BMR_TC2XC2S_Msk   = 0x30 // Bit mask of TC2XC2S field.
	TC_BMR_TC2XC2S_TCLK0 = 0x0  // Signal connected to XC2: TCLK0
	TC_BMR_TC2XC2S_TCLK1 = 0x2  // Signal connected to XC2: TCLK1
	TC_BMR_TC2XC2S_TCLK2 = 0x3  // Signal connected to XC2: TCLK2
)

// Bitfields for HSMCI0: High Speed MultiMedia Card Interface 0
const (
	// CR: Control Register
	HSMCI_CR_MCIEN_Pos  = 0x0  // Position of MCIEN field.
	HSMCI_CR_MCIEN_Msk  = 0x1  // Bit mask of MCIEN field.
	HSMCI_CR_MCIEN      = 0x1  // Bit MCIEN.
	HSMCI_CR_MCIDIS_Pos = 0x1  // Position of MCIDIS field.
	HSMCI_CR_MCIDIS_Msk = 0x2  // Bit mask of MCIDIS field.
	HSMCI_CR_MCIDIS     = 0x2  // Bit MCIDIS.
	HSMCI_CR_PWSEN_Pos  = 0x2  // Position of PWSEN field.
	HSMCI_CR_PWSEN_Msk  = 0x4  // Bit mask of PWSEN field.
	HSMCI_CR_PWSEN      = 0x4  // Bit PWSEN.
	HSMCI_CR_PWSDIS_Pos = 0x3  // Position of PWSDIS field.
	HSMCI_CR_PWSDIS_Msk = 0x8  // Bit mask of PWSDIS field.
	HSMCI_CR_PWSDIS     = 0x8  // Bit PWSDIS.
	HSMCI_CR_SWRST_Pos  = 0x7  // Position of SWRST field.
	HSMCI_CR_SWRST_Msk  = 0x80 // Bit mask of SWRST field.
	HSMCI_CR_SWRST      = 0x80 // Bit SWRST.

	// MR: Mode Register
	HSMCI_MR_CLKDIV_Pos  = 0x0        // Position of CLKDIV field.
	HSMCI_MR_CLKDIV_Msk  = 0xff       // Bit mask of CLKDIV field.
	HSMCI_MR_PWSDIV_Pos  = 0x8        // Position of PWSDIV field.
	HSMCI_MR_PWSDIV_Msk  = 0x700      // Bit mask of PWSDIV field.
	HSMCI_MR_RDPROOF_Pos = 0xb        // Position of RDPROOF field.
	HSMCI_MR_RDPROOF_Msk = 0x800      // Bit mask of RDPROOF field.
	HSMCI_MR_RDPROOF     = 0x800      // Bit RDPROOF.
	HSMCI_MR_WRPROOF_Pos = 0xc        // Position of WRPROOF field.
	HSMCI_MR_WRPROOF_Msk = 0x1000     // Bit mask of WRPROOF field.
	HSMCI_MR_WRPROOF     = 0x1000     // Bit WRPROOF.
	HSMCI_MR_FBYTE_Pos   = 0xd        // Position of FBYTE field.
	HSMCI_MR_FBYTE_Msk   = 0x2000     // Bit mask of FBYTE field.
	HSMCI_MR_FBYTE       = 0x2000     // Bit FBYTE.
	HSMCI_MR_PADV_Pos    = 0xe        // Position of PADV field.
	HSMCI_MR_PADV_Msk    = 0x4000     // Bit mask of PADV field.
	HSMCI_MR_PADV        = 0x4000     // Bit PADV.
	HSMCI_MR_BLKLEN_Pos  = 0x10       // Position of BLKLEN field.
	HSMCI_MR_BLKLEN_Msk  = 0xffff0000 // Bit mask of BLKLEN field.

	// DTOR: Data Timeout Register
	HSMCI_DTOR_DTOCYC_Pos     = 0x0  // Position of DTOCYC field.
	HSMCI_DTOR_DTOCYC_Msk     = 0xf  // Bit mask of DTOCYC field.
	HSMCI_DTOR_DTOMUL_Pos     = 0x4  // Position of DTOMUL field.
	HSMCI_DTOR_DTOMUL_Msk     = 0x70 // Bit mask of DTOMUL field.
	HSMCI_DTOR_DTOMUL_1       = 0x0  // DTOCYC
	HSMCI_DTOR_DTOMUL_16      = 0x1  // DTOCYC x 16
	HSMCI_DTOR_DTOMUL_128     = 0x2  // DTOCYC x 128
	HSMCI_DTOR_DTOMUL_256     = 0x3  // DTOCYC x 256
	HSMCI_DTOR_DTOMUL_1024    = 0x4  // DTOCYC x 1024
	HSMCI_DTOR_DTOMUL_4096    = 0x5  // DTOCYC x 4096
	HSMCI_DTOR_DTOMUL_65536   = 0x6  // DTOCYC x 65536
	HSMCI_DTOR_DTOMUL_1048576 = 0x7  // DTOCYC x 1048576

	// SDCR: SD/SDIO Card Register
	HSMCI_SDCR_SDCSEL_Pos   = 0x0  // Position of SDCSEL field.
	HSMCI_SDCR_SDCSEL_Msk   = 0x3  // Bit mask of SDCSEL field.
	HSMCI_SDCR_SDCSEL_SLOTA = 0x0  // Slot A is selected.
	HSMCI_SDCR_SDCSEL_SLOTB = 0x1  // -
	HSMCI_SDCR_SDCSEL_SLOTC = 0x2  // -
	HSMCI_SDCR_SDCSEL_SLOTD = 0x3  // -
	HSMCI_SDCR_SDCBUS_Pos   = 0x6  // Position of SDCBUS field.
	HSMCI_SDCR_SDCBUS_Msk   = 0xc0 // Bit mask of SDCBUS field.
	HSMCI_SDCR_SDCBUS_1     = 0x0  // 1 bit
	HSMCI_SDCR_SDCBUS_4     = 0x1  // 4 bit
	HSMCI_SDCR_SDCBUS_8     = 0x2  // 8 bit

	// ARGR: Argument Register
	HSMCI_ARGR_ARG_Pos = 0x0        // Position of ARG field.
	HSMCI_ARGR_ARG_Msk = 0xffffffff // Bit mask of ARG field.

	// CMDR: Command Register
	HSMCI_CMDR_CMDNB_Pos        = 0x0       // Position of CMDNB field.
	HSMCI_CMDR_CMDNB_Msk        = 0x3f      // Bit mask of CMDNB field.
	HSMCI_CMDR_RSPTYP_Pos       = 0x6       // Position of RSPTYP field.
	HSMCI_CMDR_RSPTYP_Msk       = 0xc0      // Bit mask of RSPTYP field.
	HSMCI_CMDR_RSPTYP_NORESP    = 0x0       // No response.
	HSMCI_CMDR_RSPTYP_48_BIT    = 0x1       // 48-bit response.
	HSMCI_CMDR_RSPTYP_136_BIT   = 0x2       // 136-bit response.
	HSMCI_CMDR_RSPTYP_R1B       = 0x3       // R1b response type
	HSMCI_CMDR_SPCMD_Pos        = 0x8       // Position of SPCMD field.
	HSMCI_CMDR_SPCMD_Msk        = 0x700     // Bit mask of SPCMD field.
	HSMCI_CMDR_SPCMD_STD        = 0x0       // Not a special CMD.
	HSMCI_CMDR_SPCMD_INIT       = 0x1       // Initialization CMD:74 clock cycles for initialization sequence.
	HSMCI_CMDR_SPCMD_SYNC       = 0x2       // Synchronized CMD:Wait for the end of the current data block transfer before sending the pending command.
	HSMCI_CMDR_SPCMD_CE_ATA     = 0x3       // CE-ATA Completion Signal disable Command.The host cancels the ability for the device to return a command completion signal on the command line.
	HSMCI_CMDR_SPCMD_IT_CMD     = 0x4       // Interrupt command:Corresponds to the Interrupt Mode (CMD40).
	HSMCI_CMDR_SPCMD_IT_RESP    = 0x5       // Interrupt response:Corresponds to the Interrupt Mode (CMD40).
	HSMCI_CMDR_SPCMD_BOR        = 0x6       // Boot Operation Request.Start a boot operation mode, the host processor can read boot data from the MMC device directly.
	HSMCI_CMDR_SPCMD_EBO        = 0x7       // End Boot Operation.This command allows the host processor to terminate the boot operation mode.
	HSMCI_CMDR_OPDCMD_Pos       = 0xb       // Position of OPDCMD field.
	HSMCI_CMDR_OPDCMD_Msk       = 0x800     // Bit mask of OPDCMD field.
	HSMCI_CMDR_OPDCMD           = 0x800     // Bit OPDCMD.
	HSMCI_CMDR_OPDCMD_PUSHPULL  = 0x0       // Push pull command.
	HSMCI_CMDR_OPDCMD_OPENDRAIN = 0x1       // Open drain command.
	HSMCI_CMDR_MAXLAT_Pos       = 0xc       // Position of MAXLAT field.
	HSMCI_CMDR_MAXLAT_Msk       = 0x1000    // Bit mask of MAXLAT field.
	HSMCI_CMDR_MAXLAT           = 0x1000    // Bit MAXLAT.
	HSMCI_CMDR_MAXLAT_5         = 0x0       // 5-cycle max latency.
	HSMCI_CMDR_MAXLAT_64        = 0x1       // 64-cycle max latency.
	HSMCI_CMDR_TRCMD_Pos        = 0x10      // Position of TRCMD field.
	HSMCI_CMDR_TRCMD_Msk        = 0x30000   // Bit mask of TRCMD field.
	HSMCI_CMDR_TRCMD_NO_DATA    = 0x0       // No data transfer
	HSMCI_CMDR_TRCMD_START_DATA = 0x1       // Start data transfer
	HSMCI_CMDR_TRCMD_STOP_DATA  = 0x2       // Stop data transfer
	HSMCI_CMDR_TRDIR_Pos        = 0x12      // Position of TRDIR field.
	HSMCI_CMDR_TRDIR_Msk        = 0x40000   // Bit mask of TRDIR field.
	HSMCI_CMDR_TRDIR            = 0x40000   // Bit TRDIR.
	HSMCI_CMDR_TRDIR_WRITE      = 0x0       // Write.
	HSMCI_CMDR_TRDIR_READ       = 0x1       // Read.
	HSMCI_CMDR_TRTYP_Pos        = 0x13      // Position of TRTYP field.
	HSMCI_CMDR_TRTYP_Msk        = 0x380000  // Bit mask of TRTYP field.
	HSMCI_CMDR_TRTYP_SINGLE     = 0x0       // MMC/SDCard Single Block
	HSMCI_CMDR_TRTYP_MULTIPLE   = 0x1       // MMC/SDCard Multiple Block
	HSMCI_CMDR_TRTYP_STREAM     = 0x2       // MMC Stream
	HSMCI_CMDR_TRTYP_BYTE       = 0x4       // SDIO Byte
	HSMCI_CMDR_TRTYP_BLOCK      = 0x5       // SDIO Block
	HSMCI_CMDR_IOSPCMD_Pos      = 0x18      // Position of IOSPCMD field.
	HSMCI_CMDR_IOSPCMD_Msk      = 0x3000000 // Bit mask of IOSPCMD field.
	HSMCI_CMDR_IOSPCMD_STD      = 0x0       // Not an SDIO Special Command
	HSMCI_CMDR_IOSPCMD_SUSPEND  = 0x1       // SDIO Suspend Command
	HSMCI_CMDR_IOSPCMD_RESUME   = 0x2       // SDIO Resume Command
	HSMCI_CMDR_ATACS_Pos        = 0x1a      // Position of ATACS field.
	HSMCI_CMDR_ATACS_Msk        = 0x4000000 // Bit mask of ATACS field.
	HSMCI_CMDR_ATACS            = 0x4000000 // Bit ATACS.
	HSMCI_CMDR_ATACS_NORMAL     = 0x0       // Normal operation mode.
	HSMCI_CMDR_ATACS_COMPLETION = 0x1       // This bit indicates that a completion signal is expected within a programmed amount of time (HSMCI_CSTOR).
	HSMCI_CMDR_BOOT_ACK_Pos     = 0x1b      // Position of BOOT_ACK field.
	HSMCI_CMDR_BOOT_ACK_Msk     = 0x8000000 // Bit mask of BOOT_ACK field.
	HSMCI_CMDR_BOOT_ACK         = 0x8000000 // Bit BOOT_ACK.

	// BLKR: Block Register
	HSMCI_BLKR_BCNT_Pos      = 0x0        // Position of BCNT field.
	HSMCI_BLKR_BCNT_Msk      = 0xffff     // Bit mask of BCNT field.
	HSMCI_BLKR_BCNT_MULTIPLE = 0x0        // MMC/SDCARD Multiple BlockFrom 1 to 65635: Value 0 corresponds to an infinite block transfer.
	HSMCI_BLKR_BCNT_BYTE     = 0x4        // SDIO ByteFrom 1 to 512 bytes: Value 0 corresponds to a 512-byte transfer.Values from 0x200 to 0xFFFF are forbidden.
	HSMCI_BLKR_BCNT_BLOCK    = 0x5        // SDIO BlockFrom 1 to 511 blocks: Value 0 corresponds to an infinite block transfer.Values from 0x200 to 0xFFFF are forbidden.
	HSMCI_BLKR_BLKLEN_Pos    = 0x10       // Position of BLKLEN field.
	HSMCI_BLKR_BLKLEN_Msk    = 0xffff0000 // Bit mask of BLKLEN field.

	// CSTOR: Completion Signal Timeout Register
	HSMCI_CSTOR_CSTOCYC_Pos     = 0x0  // Position of CSTOCYC field.
	HSMCI_CSTOR_CSTOCYC_Msk     = 0xf  // Bit mask of CSTOCYC field.
	HSMCI_CSTOR_CSTOMUL_Pos     = 0x4  // Position of CSTOMUL field.
	HSMCI_CSTOR_CSTOMUL_Msk     = 0x70 // Bit mask of CSTOMUL field.
	HSMCI_CSTOR_CSTOMUL_1       = 0x0  // CSTOCYC x 1
	HSMCI_CSTOR_CSTOMUL_16      = 0x1  // CSTOCYC x 16
	HSMCI_CSTOR_CSTOMUL_128     = 0x2  // CSTOCYC x 128
	HSMCI_CSTOR_CSTOMUL_256     = 0x3  // CSTOCYC x 256
	HSMCI_CSTOR_CSTOMUL_1024    = 0x4  // CSTOCYC x 1024
	HSMCI_CSTOR_CSTOMUL_4096    = 0x5  // CSTOCYC x 4096
	HSMCI_CSTOR_CSTOMUL_65536   = 0x6  // CSTOCYC x 65536
	HSMCI_CSTOR_CSTOMUL_1048576 = 0x7  // CSTOCYC x 1048576

	// RSPR: Response Register
	HSMCI_RSPR_RSP_Pos = 0x0        // Position of RSP field.
	HSMCI_RSPR_RSP_Msk = 0xffffffff // Bit mask of RSP field.

	// RDR: Receive Data Register
	HSMCI_RDR_DATA_Pos = 0x0        // Position of DATA field.
	HSMCI_RDR_DATA_Msk = 0xffffffff // Bit mask of DATA field.

	// TDR: Transmit Data Register
	HSMCI_TDR_DATA_Pos = 0x0        // Position of DATA field.
	HSMCI_TDR_DATA_Msk = 0xffffffff // Bit mask of DATA field.

	// SR: Status Register
	HSMCI_SR_CMDRDY_Pos       = 0x0        // Position of CMDRDY field.
	HSMCI_SR_CMDRDY_Msk       = 0x1        // Bit mask of CMDRDY field.
	HSMCI_SR_CMDRDY           = 0x1        // Bit CMDRDY.
	HSMCI_SR_RXRDY_Pos        = 0x1        // Position of RXRDY field.
	HSMCI_SR_RXRDY_Msk        = 0x2        // Bit mask of RXRDY field.
	HSMCI_SR_RXRDY            = 0x2        // Bit RXRDY.
	HSMCI_SR_TXRDY_Pos        = 0x2        // Position of TXRDY field.
	HSMCI_SR_TXRDY_Msk        = 0x4        // Bit mask of TXRDY field.
	HSMCI_SR_TXRDY            = 0x4        // Bit TXRDY.
	HSMCI_SR_BLKE_Pos         = 0x3        // Position of BLKE field.
	HSMCI_SR_BLKE_Msk         = 0x8        // Bit mask of BLKE field.
	HSMCI_SR_BLKE             = 0x8        // Bit BLKE.
	HSMCI_SR_DTIP_Pos         = 0x4        // Position of DTIP field.
	HSMCI_SR_DTIP_Msk         = 0x10       // Bit mask of DTIP field.
	HSMCI_SR_DTIP             = 0x10       // Bit DTIP.
	HSMCI_SR_NOTBUSY_Pos      = 0x5        // Position of NOTBUSY field.
	HSMCI_SR_NOTBUSY_Msk      = 0x20       // Bit mask of NOTBUSY field.
	HSMCI_SR_NOTBUSY          = 0x20       // Bit NOTBUSY.
	HSMCI_SR_MCI_SDIOIRQA_Pos = 0x8        // Position of MCI_SDIOIRQA field.
	HSMCI_SR_MCI_SDIOIRQA_Msk = 0x100      // Bit mask of MCI_SDIOIRQA field.
	HSMCI_SR_MCI_SDIOIRQA     = 0x100      // Bit MCI_SDIOIRQA.
	HSMCI_SR_SDIOWAIT_Pos     = 0xc        // Position of SDIOWAIT field.
	HSMCI_SR_SDIOWAIT_Msk     = 0x1000     // Bit mask of SDIOWAIT field.
	HSMCI_SR_SDIOWAIT         = 0x1000     // Bit SDIOWAIT.
	HSMCI_SR_CSRCV_Pos        = 0xd        // Position of CSRCV field.
	HSMCI_SR_CSRCV_Msk        = 0x2000     // Bit mask of CSRCV field.
	HSMCI_SR_CSRCV            = 0x2000     // Bit CSRCV.
	HSMCI_SR_RINDE_Pos        = 0x10       // Position of RINDE field.
	HSMCI_SR_RINDE_Msk        = 0x10000    // Bit mask of RINDE field.
	HSMCI_SR_RINDE            = 0x10000    // Bit RINDE.
	HSMCI_SR_RDIRE_Pos        = 0x11       // Position of RDIRE field.
	HSMCI_SR_RDIRE_Msk        = 0x20000    // Bit mask of RDIRE field.
	HSMCI_SR_RDIRE            = 0x20000    // Bit RDIRE.
	HSMCI_SR_RCRCE_Pos        = 0x12       // Position of RCRCE field.
	HSMCI_SR_RCRCE_Msk        = 0x40000    // Bit mask of RCRCE field.
	HSMCI_SR_RCRCE            = 0x40000    // Bit RCRCE.
	HSMCI_SR_RENDE_Pos        = 0x13       // Position of RENDE field.
	HSMCI_SR_RENDE_Msk        = 0x80000    // Bit mask of RENDE field.
	HSMCI_SR_RENDE            = 0x80000    // Bit RENDE.
	HSMCI_SR_RTOE_Pos         = 0x14       // Position of RTOE field.
	HSMCI_SR_RTOE_Msk         = 0x100000   // Bit mask of RTOE field.
	HSMCI_SR_RTOE             = 0x100000   // Bit RTOE.
	HSMCI_SR_DCRCE_Pos        = 0x15       // Position of DCRCE field.
	HSMCI_SR_DCRCE_Msk        = 0x200000   // Bit mask of DCRCE field.
	HSMCI_SR_DCRCE            = 0x200000   // Bit DCRCE.
	HSMCI_SR_DTOE_Pos         = 0x16       // Position of DTOE field.
	HSMCI_SR_DTOE_Msk         = 0x400000   // Bit mask of DTOE field.
	HSMCI_SR_DTOE             = 0x400000   // Bit DTOE.
	HSMCI_SR_CSTOE_Pos        = 0x17       // Position of CSTOE field.
	HSMCI_SR_CSTOE_Msk        = 0x800000   // Bit mask of CSTOE field.
	HSMCI_SR_CSTOE            = 0x800000   // Bit CSTOE.
	HSMCI_SR_BLKOVRE_Pos      = 0x18       // Position of BLKOVRE field.
	HSMCI_SR_BLKOVRE_Msk      = 0x1000000  // Bit mask of BLKOVRE field.
	HSMCI_SR_BLKOVRE          = 0x1000000  // Bit BLKOVRE.
	HSMCI_SR_DMADONE_Pos      = 0x19       // Position of DMADONE field.
	HSMCI_SR_DMADONE_Msk      = 0x2000000  // Bit mask of DMADONE field.
	HSMCI_SR_DMADONE          = 0x2000000  // Bit DMADONE.
	HSMCI_SR_FIFOEMPTY_Pos    = 0x1a       // Position of FIFOEMPTY field.
	HSMCI_SR_FIFOEMPTY_Msk    = 0x4000000  // Bit mask of FIFOEMPTY field.
	HSMCI_SR_FIFOEMPTY        = 0x4000000  // Bit FIFOEMPTY.
	HSMCI_SR_XFRDONE_Pos      = 0x1b       // Position of XFRDONE field.
	HSMCI_SR_XFRDONE_Msk      = 0x8000000  // Bit mask of XFRDONE field.
	HSMCI_SR_XFRDONE          = 0x8000000  // Bit XFRDONE.
	HSMCI_SR_ACKRCV_Pos       = 0x1c       // Position of ACKRCV field.
	HSMCI_SR_ACKRCV_Msk       = 0x10000000 // Bit mask of ACKRCV field.
	HSMCI_SR_ACKRCV           = 0x10000000 // Bit ACKRCV.
	HSMCI_SR_ACKRCVE_Pos      = 0x1d       // Position of ACKRCVE field.
	HSMCI_SR_ACKRCVE_Msk      = 0x20000000 // Bit mask of ACKRCVE field.
	HSMCI_SR_ACKRCVE          = 0x20000000 // Bit ACKRCVE.
	HSMCI_SR_OVRE_Pos         = 0x1e       // Position of OVRE field.
	HSMCI_SR_OVRE_Msk         = 0x40000000 // Bit mask of OVRE field.
	HSMCI_SR_OVRE             = 0x40000000 // Bit OVRE.
	HSMCI_SR_UNRE_Pos         = 0x1f       // Position of UNRE field.
	HSMCI_SR_UNRE_Msk         = 0x80000000 // Bit mask of UNRE field.
	HSMCI_SR_UNRE             = 0x80000000 // Bit UNRE.

	// IER: Interrupt Enable Register
	HSMCI_IER_CMDRDY_Pos       = 0x0        // Position of CMDRDY field.
	HSMCI_IER_CMDRDY_Msk       = 0x1        // Bit mask of CMDRDY field.
	HSMCI_IER_CMDRDY           = 0x1        // Bit CMDRDY.
	HSMCI_IER_RXRDY_Pos        = 0x1        // Position of RXRDY field.
	HSMCI_IER_RXRDY_Msk        = 0x2        // Bit mask of RXRDY field.
	HSMCI_IER_RXRDY            = 0x2        // Bit RXRDY.
	HSMCI_IER_TXRDY_Pos        = 0x2        // Position of TXRDY field.
	HSMCI_IER_TXRDY_Msk        = 0x4        // Bit mask of TXRDY field.
	HSMCI_IER_TXRDY            = 0x4        // Bit TXRDY.
	HSMCI_IER_BLKE_Pos         = 0x3        // Position of BLKE field.
	HSMCI_IER_BLKE_Msk         = 0x8        // Bit mask of BLKE field.
	HSMCI_IER_BLKE             = 0x8        // Bit BLKE.
	HSMCI_IER_DTIP_Pos         = 0x4        // Position of DTIP field.
	HSMCI_IER_DTIP_Msk         = 0x10       // Bit mask of DTIP field.
	HSMCI_IER_DTIP             = 0x10       // Bit DTIP.
	HSMCI_IER_NOTBUSY_Pos      = 0x5        // Position of NOTBUSY field.
	HSMCI_IER_NOTBUSY_Msk      = 0x20       // Bit mask of NOTBUSY field.
	HSMCI_IER_NOTBUSY          = 0x20       // Bit NOTBUSY.
	HSMCI_IER_MCI_SDIOIRQA_Pos = 0x8        // Position of MCI_SDIOIRQA field.
	HSMCI_IER_MCI_SDIOIRQA_Msk = 0x100      // Bit mask of MCI_SDIOIRQA field.
	HSMCI_IER_MCI_SDIOIRQA     = 0x100      // Bit MCI_SDIOIRQA.
	HSMCI_IER_SDIOWAIT_Pos     = 0xc        // Position of SDIOWAIT field.
	HSMCI_IER_SDIOWAIT_Msk     = 0x1000     // Bit mask of SDIOWAIT field.
	HSMCI_IER_SDIOWAIT         = 0x1000     // Bit SDIOWAIT.
	HSMCI_IER_CSRCV_Pos        = 0xd        // Position of CSRCV field.
	HSMCI_IER_CSRCV_Msk        = 0x2000     // Bit mask of CSRCV field.
	HSMCI_IER_CSRCV            = 0x2000     // Bit CSRCV.
	HSMCI_IER_RINDE_Pos        = 0x10       // Position of RINDE field.
	HSMCI_IER_RINDE_Msk        = 0x10000    // Bit mask of RINDE field.
	HSMCI_IER_RINDE            = 0x10000    // Bit RINDE.
	HSMCI_IER_RDIRE_Pos        = 0x11       // Position of RDIRE field.
	HSMCI_IER_RDIRE_Msk        = 0x20000    // Bit mask of RDIRE field.
	HSMCI_IER_RDIRE            = 0x20000    // Bit RDIRE.
	HSMCI_IER_RCRCE_Pos        = 0x12       // Position of RCRCE field.
	HSMCI_IER_RCRCE_Msk        = 0x40000    // Bit mask of RCRCE field.
	HSMCI_IER_RCRCE            = 0x40000    // Bit RCRCE.
	HSMCI_IER_RENDE_Pos        = 0x13       // Position of RENDE field.
	HSMCI_IER_RENDE_Msk        = 0x80000    // Bit mask of RENDE field.
	HSMCI_IER_RENDE            = 0x80000    // Bit RENDE.
	HSMCI_IER_RTOE_Pos         = 0x14       // Position of RTOE field.
	HSMCI_IER_RTOE_Msk         = 0x100000   // Bit mask of RTOE field.
	HSMCI_IER_RTOE             = 0x100000   // Bit RTOE.
	HSMCI_IER_DCRCE_Pos        = 0x15       // Position of DCRCE field.
	HSMCI_IER_DCRCE_Msk        = 0x200000   // Bit mask of DCRCE field.
	HSMCI_IER_DCRCE            = 0x200000   // Bit DCRCE.
	HSMCI_IER_DTOE_Pos         = 0x16       // Position of DTOE field.
	HSMCI_IER_DTOE_Msk         = 0x400000   // Bit mask of DTOE field.
	HSMCI_IER_DTOE             = 0x400000   // Bit DTOE.
	HSMCI_IER_CSTOE_Pos        = 0x17       // Position of CSTOE field.
	HSMCI_IER_CSTOE_Msk        = 0x800000   // Bit mask of CSTOE field.
	HSMCI_IER_CSTOE            = 0x800000   // Bit CSTOE.
	HSMCI_IER_BLKOVRE_Pos      = 0x18       // Position of BLKOVRE field.
	HSMCI_IER_BLKOVRE_Msk      = 0x1000000  // Bit mask of BLKOVRE field.
	HSMCI_IER_BLKOVRE          = 0x1000000  // Bit BLKOVRE.
	HSMCI_IER_DMADONE_Pos      = 0x19       // Position of DMADONE field.
	HSMCI_IER_DMADONE_Msk      = 0x2000000  // Bit mask of DMADONE field.
	HSMCI_IER_DMADONE          = 0x2000000  // Bit DMADONE.
	HSMCI_IER_FIFOEMPTY_Pos    = 0x1a       // Position of FIFOEMPTY field.
	HSMCI_IER_FIFOEMPTY_Msk    = 0x4000000  // Bit mask of FIFOEMPTY field.
	HSMCI_IER_FIFOEMPTY        = 0x4000000  // Bit FIFOEMPTY.
	HSMCI_IER_XFRDONE_Pos      = 0x1b       // Position of XFRDONE field.
	HSMCI_IER_XFRDONE_Msk      = 0x8000000  // Bit mask of XFRDONE field.
	HSMCI_IER_XFRDONE          = 0x8000000  // Bit XFRDONE.
	HSMCI_IER_ACKRCV_Pos       = 0x1c       // Position of ACKRCV field.
	HSMCI_IER_ACKRCV_Msk       = 0x10000000 // Bit mask of ACKRCV field.
	HSMCI_IER_ACKRCV           = 0x10000000 // Bit ACKRCV.
	HSMCI_IER_ACKRCVE_Pos      = 0x1d       // Position of ACKRCVE field.
	HSMCI_IER_ACKRCVE_Msk      = 0x20000000 // Bit mask of ACKRCVE field.
	HSMCI_IER_ACKRCVE          = 0x20000000 // Bit ACKRCVE.
	HSMCI_IER_OVRE_Pos         = 0x1e       // Position of OVRE field.
	HSMCI_IER_OVRE_Msk         = 0x40000000 // Bit mask of OVRE field.
	HSMCI_IER_OVRE             = 0x40000000 // Bit OVRE.
	HSMCI_IER_UNRE_Pos         = 0x1f       // Position of UNRE field.
	HSMCI_IER_UNRE_Msk         = 0x80000000 // Bit mask of UNRE field.
	HSMCI_IER_UNRE             = 0x80000000 // Bit UNRE.

	// IDR: Interrupt Disable Register
	HSMCI_IDR_CMDRDY_Pos       = 0x0        // Position of CMDRDY field.
	HSMCI_IDR_CMDRDY_Msk       = 0x1        // Bit mask of CMDRDY field.
	HSMCI_IDR_CMDRDY           = 0x1        // Bit CMDRDY.
	HSMCI_IDR_RXRDY_Pos        = 0x1        // Position of RXRDY field.
	HSMCI_IDR_RXRDY_Msk        = 0x2        // Bit mask of RXRDY field.
	HSMCI_IDR_RXRDY            = 0x2        // Bit RXRDY.
	HSMCI_IDR_TXRDY_Pos        = 0x2        // Position of TXRDY field.
	HSMCI_IDR_TXRDY_Msk        = 0x4        // Bit mask of TXRDY field.
	HSMCI_IDR_TXRDY            = 0x4        // Bit TXRDY.
	HSMCI_IDR_BLKE_Pos         = 0x3        // Position of BLKE field.
	HSMCI_IDR_BLKE_Msk         = 0x8        // Bit mask of BLKE field.
	HSMCI_IDR_BLKE             = 0x8        // Bit BLKE.
	HSMCI_IDR_DTIP_Pos         = 0x4        // Position of DTIP field.
	HSMCI_IDR_DTIP_Msk         = 0x10       // Bit mask of DTIP field.
	HSMCI_IDR_DTIP             = 0x10       // Bit DTIP.
	HSMCI_IDR_NOTBUSY_Pos      = 0x5        // Position of NOTBUSY field.
	HSMCI_IDR_NOTBUSY_Msk      = 0x20       // Bit mask of NOTBUSY field.
	HSMCI_IDR_NOTBUSY          = 0x20       // Bit NOTBUSY.
	HSMCI_IDR_MCI_SDIOIRQA_Pos = 0x8        // Position of MCI_SDIOIRQA field.
	HSMCI_IDR_MCI_SDIOIRQA_Msk = 0x100      // Bit mask of MCI_SDIOIRQA field.
	HSMCI_IDR_MCI_SDIOIRQA     = 0x100      // Bit MCI_SDIOIRQA.
	HSMCI_IDR_SDIOWAIT_Pos     = 0xc        // Position of SDIOWAIT field.
	HSMCI_IDR_SDIOWAIT_Msk     = 0x1000     // Bit mask of SDIOWAIT field.
	HSMCI_IDR_SDIOWAIT         = 0x1000     // Bit SDIOWAIT.
	HSMCI_IDR_CSRCV_Pos        = 0xd        // Position of CSRCV field.
	HSMCI_IDR_CSRCV_Msk        = 0x2000     // Bit mask of CSRCV field.
	HSMCI_IDR_CSRCV            = 0x2000     // Bit CSRCV.
	HSMCI_IDR_RINDE_Pos        = 0x10       // Position of RINDE field.
	HSMCI_IDR_RINDE_Msk        = 0x10000    // Bit mask of RINDE field.
	HSMCI_IDR_RINDE            = 0x10000    // Bit RINDE.
	HSMCI_IDR_RDIRE_Pos        = 0x11       // Position of RDIRE field.
	HSMCI_IDR_RDIRE_Msk        = 0x20000    // Bit mask of RDIRE field.
	HSMCI_IDR_RDIRE            = 0x20000    // Bit RDIRE.
	HSMCI_IDR_RCRCE_Pos        = 0x12       // Position of RCRCE field.
	HSMCI_IDR_RCRCE_Msk        = 0x40000    // Bit mask of RCRCE field.
	HSMCI_IDR_RCRCE            = 0x40000    // Bit RCRCE.
	HSMCI_IDR_RENDE_Pos        = 0x13       // Position of RENDE field.
	HSMCI_IDR_RENDE_Msk        = 0x80000    // Bit mask of RENDE field.
	HSMCI_IDR_RENDE            = 0x80000    // Bit RENDE.
	HSMCI_IDR_RTOE_Pos         = 0x14       // Position of RTOE field.
	HSMCI_IDR_RTOE_Msk         = 0x100000   // Bit mask of RTOE field.
	HSMCI_IDR_RTOE             = 0x100000   // Bit RTOE.
	HSMCI_IDR_DCRCE_Pos        = 0x15       // Position of DCRCE field.
	HSMCI_IDR_DCRCE_Msk        = 0x200000   // Bit mask of DCRCE field.
	HSMCI_IDR_DCRCE            = 0x200000   // Bit DCRCE.
	HSMCI_IDR_DTOE_Pos         = 0x16       // Position of DTOE field.
	HSMCI_IDR_DTOE_Msk         = 0x400000   // Bit mask of DTOE field.
	HSMCI_IDR_DTOE             = 0x400000   // Bit DTOE.
	HSMCI_IDR_CSTOE_Pos        = 0x17       // Position of CSTOE field.
	HSMCI_IDR_CSTOE_Msk        = 0x800000   // Bit mask of CSTOE field.
	HSMCI_IDR_CSTOE            = 0x800000   // Bit CSTOE.
	HSMCI_IDR_BLKOVRE_Pos      = 0x18       // Position of BLKOVRE field.
	HSMCI_IDR_BLKOVRE_Msk      = 0x1000000  // Bit mask of BLKOVRE field.
	HSMCI_IDR_BLKOVRE          = 0x1000000  // Bit BLKOVRE.
	HSMCI_IDR_DMADONE_Pos      = 0x19       // Position of DMADONE field.
	HSMCI_IDR_DMADONE_Msk      = 0x2000000  // Bit mask of DMADONE field.
	HSMCI_IDR_DMADONE          = 0x2000000  // Bit DMADONE.
	HSMCI_IDR_FIFOEMPTY_Pos    = 0x1a       // Position of FIFOEMPTY field.
	HSMCI_IDR_FIFOEMPTY_Msk    = 0x4000000  // Bit mask of FIFOEMPTY field.
	HSMCI_IDR_FIFOEMPTY        = 0x4000000  // Bit FIFOEMPTY.
	HSMCI_IDR_XFRDONE_Pos      = 0x1b       // Position of XFRDONE field.
	HSMCI_IDR_XFRDONE_Msk      = 0x8000000  // Bit mask of XFRDONE field.
	HSMCI_IDR_XFRDONE          = 0x8000000  // Bit XFRDONE.
	HSMCI_IDR_ACKRCV_Pos       = 0x1c       // Position of ACKRCV field.
	HSMCI_IDR_ACKRCV_Msk       = 0x10000000 // Bit mask of ACKRCV field.
	HSMCI_IDR_ACKRCV           = 0x10000000 // Bit ACKRCV.
	HSMCI_IDR_ACKRCVE_Pos      = 0x1d       // Position of ACKRCVE field.
	HSMCI_IDR_ACKRCVE_Msk      = 0x20000000 // Bit mask of ACKRCVE field.
	HSMCI_IDR_ACKRCVE          = 0x20000000 // Bit ACKRCVE.
	HSMCI_IDR_OVRE_Pos         = 0x1e       // Position of OVRE field.
	HSMCI_IDR_OVRE_Msk         = 0x40000000 // Bit mask of OVRE field.
	HSMCI_IDR_OVRE             = 0x40000000 // Bit OVRE.
	HSMCI_IDR_UNRE_Pos         = 0x1f       // Position of UNRE field.
	HSMCI_IDR_UNRE_Msk         = 0x80000000 // Bit mask of UNRE field.
	HSMCI_IDR_UNRE             = 0x80000000 // Bit UNRE.

	// IMR: Interrupt Mask Register
	HSMCI_IMR_CMDRDY_Pos       = 0x0        // Position of CMDRDY field.
	HSMCI_IMR_CMDRDY_Msk       = 0x1        // Bit mask of CMDRDY field.
	HSMCI_IMR_CMDRDY           = 0x1        // Bit CMDRDY.
	HSMCI_IMR_RXRDY_Pos        = 0x1        // Position of RXRDY field.
	HSMCI_IMR_RXRDY_Msk        = 0x2        // Bit mask of RXRDY field.
	HSMCI_IMR_RXRDY            = 0x2        // Bit RXRDY.
	HSMCI_IMR_TXRDY_Pos        = 0x2        // Position of TXRDY field.
	HSMCI_IMR_TXRDY_Msk        = 0x4        // Bit mask of TXRDY field.
	HSMCI_IMR_TXRDY            = 0x4        // Bit TXRDY.
	HSMCI_IMR_BLKE_Pos         = 0x3        // Position of BLKE field.
	HSMCI_IMR_BLKE_Msk         = 0x8        // Bit mask of BLKE field.
	HSMCI_IMR_BLKE             = 0x8        // Bit BLKE.
	HSMCI_IMR_DTIP_Pos         = 0x4        // Position of DTIP field.
	HSMCI_IMR_DTIP_Msk         = 0x10       // Bit mask of DTIP field.
	HSMCI_IMR_DTIP             = 0x10       // Bit DTIP.
	HSMCI_IMR_NOTBUSY_Pos      = 0x5        // Position of NOTBUSY field.
	HSMCI_IMR_NOTBUSY_Msk      = 0x20       // Bit mask of NOTBUSY field.
	HSMCI_IMR_NOTBUSY          = 0x20       // Bit NOTBUSY.
	HSMCI_IMR_MCI_SDIOIRQA_Pos = 0x8        // Position of MCI_SDIOIRQA field.
	HSMCI_IMR_MCI_SDIOIRQA_Msk = 0x100      // Bit mask of MCI_SDIOIRQA field.
	HSMCI_IMR_MCI_SDIOIRQA     = 0x100      // Bit MCI_SDIOIRQA.
	HSMCI_IMR_SDIOWAIT_Pos     = 0xc        // Position of SDIOWAIT field.
	HSMCI_IMR_SDIOWAIT_Msk     = 0x1000     // Bit mask of SDIOWAIT field.
	HSMCI_IMR_SDIOWAIT         = 0x1000     // Bit SDIOWAIT.
	HSMCI_IMR_CSRCV_Pos        = 0xd        // Position of CSRCV field.
	HSMCI_IMR_CSRCV_Msk        = 0x2000     // Bit mask of CSRCV field.
	HSMCI_IMR_CSRCV            = 0x2000     // Bit CSRCV.
	HSMCI_IMR_RINDE_Pos        = 0x10       // Position of RINDE field.
	HSMCI_IMR_RINDE_Msk        = 0x10000    // Bit mask of RINDE field.
	HSMCI_IMR_RINDE            = 0x10000    // Bit RINDE.
	HSMCI_IMR_RDIRE_Pos        = 0x11       // Position of RDIRE field.
	HSMCI_IMR_RDIRE_Msk        = 0x20000    // Bit mask of RDIRE field.
	HSMCI_IMR_RDIRE            = 0x20000    // Bit RDIRE.
	HSMCI_IMR_RCRCE_Pos        = 0x12       // Position of RCRCE field.
	HSMCI_IMR_RCRCE_Msk        = 0x40000    // Bit mask of RCRCE field.
	HSMCI_IMR_RCRCE            = 0x40000    // Bit RCRCE.
	HSMCI_IMR_RENDE_Pos        = 0x13       // Position of RENDE field.
	HSMCI_IMR_RENDE_Msk        = 0x80000    // Bit mask of RENDE field.
	HSMCI_IMR_RENDE            = 0x80000    // Bit RENDE.
	HSMCI_IMR_RTOE_Pos         = 0x14       // Position of RTOE field.
	HSMCI_IMR_RTOE_Msk         = 0x100000   // Bit mask of RTOE field.
	HSMCI_IMR_RTOE             = 0x100000   // Bit RTOE.
	HSMCI_IMR_DCRCE_Pos        = 0x15       // Position of DCRCE field.
	HSMCI_IMR_DCRCE_Msk        = 0x200000   // Bit mask of DCRCE field.
	HSMCI_IMR_DCRCE            = 0x200000   // Bit DCRCE.
	HSMCI_IMR_DTOE_Pos         = 0x16       // Position of DTOE field.
	HSMCI_IMR_DTOE_Msk         = 0x400000   // Bit mask of DTOE field.
	HSMCI_IMR_DTOE             = 0x400000   // Bit DTOE.
	HSMCI_IMR_CSTOE_Pos        = 0x17       // Position of CSTOE field.
	HSMCI_IMR_CSTOE_Msk        = 0x800000   // Bit mask of CSTOE field.
	HSMCI_IMR_CSTOE            = 0x800000   // Bit CSTOE.
	HSMCI_IMR_BLKOVRE_Pos      = 0x18       // Position of BLKOVRE field.
	HSMCI_IMR_BLKOVRE_Msk      = 0x1000000  // Bit mask of BLKOVRE field.
	HSMCI_IMR_BLKOVRE          = 0x1000000  // Bit BLKOVRE.
	HSMCI_IMR_DMADONE_Pos      = 0x19       // Position of DMADONE field.
	HSMCI_IMR_DMADONE_Msk      = 0x2000000  // Bit mask of DMADONE field.
	HSMCI_IMR_DMADONE          = 0x2000000  // Bit DMADONE.
	HSMCI_IMR_FIFOEMPTY_Pos    = 0x1a       // Position of FIFOEMPTY field.
	HSMCI_IMR_FIFOEMPTY_Msk    = 0x4000000  // Bit mask of FIFOEMPTY field.
	HSMCI_IMR_FIFOEMPTY        = 0x4000000  // Bit FIFOEMPTY.
	HSMCI_IMR_XFRDONE_Pos      = 0x1b       // Position of XFRDONE field.
	HSMCI_IMR_XFRDONE_Msk      = 0x8000000  // Bit mask of XFRDONE field.
	HSMCI_IMR_XFRDONE          = 0x8000000  // Bit XFRDONE.
	HSMCI_IMR_ACKRCV_Pos       = 0x1c       // Position of ACKRCV field.
	HSMCI_IMR_ACKRCV_Msk       = 0x10000000 // Bit mask of ACKRCV field.
	HSMCI_IMR_ACKRCV           = 0x10000000 // Bit ACKRCV.
	HSMCI_IMR_ACKRCVE_Pos      = 0x1d       // Position of ACKRCVE field.
	HSMCI_IMR_ACKRCVE_Msk      = 0x20000000 // Bit mask of ACKRCVE field.
	HSMCI_IMR_ACKRCVE          = 0x20000000 // Bit ACKRCVE.
	HSMCI_IMR_OVRE_Pos         = 0x1e       // Position of OVRE field.
	HSMCI_IMR_OVRE_Msk         = 0x40000000 // Bit mask of OVRE field.
	HSMCI_IMR_OVRE             = 0x40000000 // Bit OVRE.
	HSMCI_IMR_UNRE_Pos         = 0x1f       // Position of UNRE field.
	HSMCI_IMR_UNRE_Msk         = 0x80000000 // Bit mask of UNRE field.
	HSMCI_IMR_UNRE             = 0x80000000 // Bit UNRE.

	// DMA: DMA Configuration Register
	HSMCI_DMA_OFFSET_Pos  = 0x0    // Position of OFFSET field.
	HSMCI_DMA_OFFSET_Msk  = 0x3    // Bit mask of OFFSET field.
	HSMCI_DMA_CHKSIZE_Pos = 0x4    // Position of CHKSIZE field.
	HSMCI_DMA_CHKSIZE_Msk = 0x30   // Bit mask of CHKSIZE field.
	HSMCI_DMA_CHKSIZE_1   = 0x0    // 1 data available
	HSMCI_DMA_CHKSIZE_4   = 0x1    // 4 data available
	HSMCI_DMA_CHKSIZE_8   = 0x2    // 8 data available
	HSMCI_DMA_CHKSIZE_16  = 0x3    // 16 data available
	HSMCI_DMA_DMAEN_Pos   = 0x8    // Position of DMAEN field.
	HSMCI_DMA_DMAEN_Msk   = 0x100  // Bit mask of DMAEN field.
	HSMCI_DMA_DMAEN       = 0x100  // Bit DMAEN.
	HSMCI_DMA_ROPT_Pos    = 0xc    // Position of ROPT field.
	HSMCI_DMA_ROPT_Msk    = 0x1000 // Bit mask of ROPT field.
	HSMCI_DMA_ROPT        = 0x1000 // Bit ROPT.

	// CFG: Configuration Register
	HSMCI_CFG_FIFOMODE_Pos = 0x0    // Position of FIFOMODE field.
	HSMCI_CFG_FIFOMODE_Msk = 0x1    // Bit mask of FIFOMODE field.
	HSMCI_CFG_FIFOMODE     = 0x1    // Bit FIFOMODE.
	HSMCI_CFG_FERRCTRL_Pos = 0x4    // Position of FERRCTRL field.
	HSMCI_CFG_FERRCTRL_Msk = 0x10   // Bit mask of FERRCTRL field.
	HSMCI_CFG_FERRCTRL     = 0x10   // Bit FERRCTRL.
	HSMCI_CFG_HSMODE_Pos   = 0x8    // Position of HSMODE field.
	HSMCI_CFG_HSMODE_Msk   = 0x100  // Bit mask of HSMODE field.
	HSMCI_CFG_HSMODE       = 0x100  // Bit HSMODE.
	HSMCI_CFG_LSYNC_Pos    = 0xc    // Position of LSYNC field.
	HSMCI_CFG_LSYNC_Msk    = 0x1000 // Bit mask of LSYNC field.
	HSMCI_CFG_LSYNC        = 0x1000 // Bit LSYNC.

	// WPMR: Write Protection Mode Register
	HSMCI_WPMR_WP_EN_Pos  = 0x0        // Position of WP_EN field.
	HSMCI_WPMR_WP_EN_Msk  = 0x1        // Bit mask of WP_EN field.
	HSMCI_WPMR_WP_EN      = 0x1        // Bit WP_EN.
	HSMCI_WPMR_WP_KEY_Pos = 0x8        // Position of WP_KEY field.
	HSMCI_WPMR_WP_KEY_Msk = 0xffffff00 // Bit mask of WP_KEY field.

	// WPSR: Write Protection Status Register
	HSMCI_WPSR_WP_VS_Pos   = 0x0      // Position of WP_VS field.
	HSMCI_WPSR_WP_VS_Msk   = 0xf      // Bit mask of WP_VS field.
	HSMCI_WPSR_WP_VS_NONE  = 0x0      // No Write Protection Violation occurred since the last read of this register (WP_SR)
	HSMCI_WPSR_WP_VS_WRITE = 0x1      // Write Protection detected unauthorized attempt to write a control register had occurred (since the last read.)
	HSMCI_WPSR_WP_VS_RESET = 0x2      // Software reset had been performed while Write Protection was enabled (since the last read).
	HSMCI_WPSR_WP_VS_BOTH  = 0x3      // Both Write Protection violation and software reset with Write Protection enabled have occurred since the last read.
	HSMCI_WPSR_WP_VSRC_Pos = 0x8      // Position of WP_VSRC field.
	HSMCI_WPSR_WP_VSRC_Msk = 0xffff00 // Bit mask of WP_VSRC field.
)

// Bitfields for TWI0: Two-wire Interface 0
const (
	// CR: Control Register
	TWI_CR_START_Pos = 0x0  // Position of START field.
	TWI_CR_START_Msk = 0x1  // Bit mask of START field.
	TWI_CR_START     = 0x1  // Bit START.
	TWI_CR_STOP_Pos  = 0x1  // Position of STOP field.
	TWI_CR_STOP_Msk  = 0x2  // Bit mask of STOP field.
	TWI_CR_STOP      = 0x2  // Bit STOP.
	TWI_CR_MSEN_Pos  = 0x2  // Position of MSEN field.
	TWI_CR_MSEN_Msk  = 0x4  // Bit mask of MSEN field.
	TWI_CR_MSEN      = 0x4  // Bit MSEN.
	TWI_CR_MSDIS_Pos = 0x3  // Position of MSDIS field.
	TWI_CR_MSDIS_Msk = 0x8  // Bit mask of MSDIS field.
	TWI_CR_MSDIS     = 0x8  // Bit MSDIS.
	TWI_CR_SVEN_Pos  = 0x4  // Position of SVEN field.
	TWI_CR_SVEN_Msk  = 0x10 // Bit mask of SVEN field.
	TWI_CR_SVEN      = 0x10 // Bit SVEN.
	TWI_CR_SVDIS_Pos = 0x5  // Position of SVDIS field.
	TWI_CR_SVDIS_Msk = 0x20 // Bit mask of SVDIS field.
	TWI_CR_SVDIS     = 0x20 // Bit SVDIS.
	TWI_CR_QUICK_Pos = 0x6  // Position of QUICK field.
	TWI_CR_QUICK_Msk = 0x40 // Bit mask of QUICK field.
	TWI_CR_QUICK     = 0x40 // Bit QUICK.
	TWI_CR_SWRST_Pos = 0x7  // Position of SWRST field.
	TWI_CR_SWRST_Msk = 0x80 // Bit mask of SWRST field.
	TWI_CR_SWRST     = 0x80 // Bit SWRST.

	// MMR: Master Mode Register
	TWI_MMR_IADRSZ_Pos    = 0x8      // Position of IADRSZ field.
	TWI_MMR_IADRSZ_Msk    = 0x300    // Bit mask of IADRSZ field.
	TWI_MMR_IADRSZ_NONE   = 0x0      // No internal device address
	TWI_MMR_IADRSZ_1_BYTE = 0x1      // One-byte internal device address
	TWI_MMR_IADRSZ_2_BYTE = 0x2      // Two-byte internal device address
	TWI_MMR_IADRSZ_3_BYTE = 0x3      // Three-byte internal device address
	TWI_MMR_MREAD_Pos     = 0xc      // Position of MREAD field.
	TWI_MMR_MREAD_Msk     = 0x1000   // Bit mask of MREAD field.
	TWI_MMR_MREAD         = 0x1000   // Bit MREAD.
	TWI_MMR_DADR_Pos      = 0x10     // Position of DADR field.
	TWI_MMR_DADR_Msk      = 0x7f0000 // Bit mask of DADR field.

	// SMR: Slave Mode Register
	TWI_SMR_SADR_Pos = 0x10     // Position of SADR field.
	TWI_SMR_SADR_Msk = 0x7f0000 // Bit mask of SADR field.

	// IADR: Internal Address Register
	TWI_IADR_IADR_Pos = 0x0      // Position of IADR field.
	TWI_IADR_IADR_Msk = 0xffffff // Bit mask of IADR field.

	// CWGR: Clock Waveform Generator Register
	TWI_CWGR_CLDIV_Pos = 0x0     // Position of CLDIV field.
	TWI_CWGR_CLDIV_Msk = 0xff    // Bit mask of CLDIV field.
	TWI_CWGR_CHDIV_Pos = 0x8     // Position of CHDIV field.
	TWI_CWGR_CHDIV_Msk = 0xff00  // Bit mask of CHDIV field.
	TWI_CWGR_CKDIV_Pos = 0x10    // Position of CKDIV field.
	TWI_CWGR_CKDIV_Msk = 0x70000 // Bit mask of CKDIV field.

	// SR: Status Register
	TWI_SR_TXCOMP_Pos = 0x0   // Position of TXCOMP field.
	TWI_SR_TXCOMP_Msk = 0x1   // Bit mask of TXCOMP field.
	TWI_SR_TXCOMP     = 0x1   // Bit TXCOMP.
	TWI_SR_RXRDY_Pos  = 0x1   // Position of RXRDY field.
	TWI_SR_RXRDY_Msk  = 0x2   // Bit mask of RXRDY field.
	TWI_SR_RXRDY      = 0x2   // Bit RXRDY.
	TWI_SR_TXRDY_Pos  = 0x2   // Position of TXRDY field.
	TWI_SR_TXRDY_Msk  = 0x4   // Bit mask of TXRDY field.
	TWI_SR_TXRDY      = 0x4   // Bit TXRDY.
	TWI_SR_SVREAD_Pos = 0x3   // Position of SVREAD field.
	TWI_SR_SVREAD_Msk = 0x8   // Bit mask of SVREAD field.
	TWI_SR_SVREAD     = 0x8   // Bit SVREAD.
	TWI_SR_SVACC_Pos  = 0x4   // Position of SVACC field.
	TWI_SR_SVACC_Msk  = 0x10  // Bit mask of SVACC field.
	TWI_SR_SVACC      = 0x10  // Bit SVACC.
	TWI_SR_GACC_Pos   = 0x5   // Position of GACC field.
	TWI_SR_GACC_Msk   = 0x20  // Bit mask of GACC field.
	TWI_SR_GACC       = 0x20  // Bit GACC.
	TWI_SR_OVRE_Pos   = 0x6   // Position of OVRE field.
	TWI_SR_OVRE_Msk   = 0x40  // Bit mask of OVRE field.
	TWI_SR_OVRE       = 0x40  // Bit OVRE.
	TWI_SR_NACK_Pos   = 0x8   // Position of NACK field.
	TWI_SR_NACK_Msk   = 0x100 // Bit mask of NACK field.
	TWI_SR_NACK       = 0x100 // Bit NACK.
	TWI_SR_ARBLST_Pos = 0x9   // Position of ARBLST field.
	TWI_SR_ARBLST_Msk = 0x200 // Bit mask of ARBLST field.
	TWI_SR_ARBLST     = 0x200 // Bit ARBLST.
	TWI_SR_SCLWS_Pos  = 0xa   // Position of SCLWS field.
	TWI_SR_SCLWS_Msk  = 0x400 // Bit mask of SCLWS field.
	TWI_SR_SCLWS      = 0x400 // Bit SCLWS.
	TWI_SR_EOSACC_Pos = 0xb   // Position of EOSACC field.
	TWI_SR_EOSACC_Msk = 0x800 // Bit mask of EOSACC field.
	TWI_SR_EOSACC     = 0x800 // Bit EOSACC.

	// IER: Interrupt Enable Register
	TWI_IER_TXCOMP_Pos = 0x0   // Position of TXCOMP field.
	TWI_IER_TXCOMP_Msk = 0x1   // Bit mask of TXCOMP field.
	TWI_IER_TXCOMP     = 0x1   // Bit TXCOMP.
	TWI_IER_RXRDY_Pos  = 0x1   // Position of RXRDY field.
	TWI_IER_RXRDY_Msk  = 0x2   // Bit mask of RXRDY field.
	TWI_IER_RXRDY      = 0x2   // Bit RXRDY.
	TWI_IER_TXRDY_Pos  = 0x2   // Position of TXRDY field.
	TWI_IER_TXRDY_Msk  = 0x4   // Bit mask of TXRDY field.
	TWI_IER_TXRDY      = 0x4   // Bit TXRDY.
	TWI_IER_SVACC_Pos  = 0x4   // Position of SVACC field.
	TWI_IER_SVACC_Msk  = 0x10  // Bit mask of SVACC field.
	TWI_IER_SVACC      = 0x10  // Bit SVACC.
	TWI_IER_GACC_Pos   = 0x5   // Position of GACC field.
	TWI_IER_GACC_Msk   = 0x20  // Bit mask of GACC field.
	TWI_IER_GACC       = 0x20  // Bit GACC.
	TWI_IER_OVRE_Pos   = 0x6   // Position of OVRE field.
	TWI_IER_OVRE_Msk   = 0x40  // Bit mask of OVRE field.
	TWI_IER_OVRE       = 0x40  // Bit OVRE.
	TWI_IER_NACK_Pos   = 0x8   // Position of NACK field.
	TWI_IER_NACK_Msk   = 0x100 // Bit mask of NACK field.
	TWI_IER_NACK       = 0x100 // Bit NACK.
	TWI_IER_ARBLST_Pos = 0x9   // Position of ARBLST field.
	TWI_IER_ARBLST_Msk = 0x200 // Bit mask of ARBLST field.
	TWI_IER_ARBLST     = 0x200 // Bit ARBLST.
	TWI_IER_SCL_WS_Pos = 0xa   // Position of SCL_WS field.
	TWI_IER_SCL_WS_Msk = 0x400 // Bit mask of SCL_WS field.
	TWI_IER_SCL_WS     = 0x400 // Bit SCL_WS.
	TWI_IER_EOSACC_Pos = 0xb   // Position of EOSACC field.
	TWI_IER_EOSACC_Msk = 0x800 // Bit mask of EOSACC field.
	TWI_IER_EOSACC     = 0x800 // Bit EOSACC.

	// IDR: Interrupt Disable Register
	TWI_IDR_TXCOMP_Pos = 0x0   // Position of TXCOMP field.
	TWI_IDR_TXCOMP_Msk = 0x1   // Bit mask of TXCOMP field.
	TWI_IDR_TXCOMP     = 0x1   // Bit TXCOMP.
	TWI_IDR_RXRDY_Pos  = 0x1   // Position of RXRDY field.
	TWI_IDR_RXRDY_Msk  = 0x2   // Bit mask of RXRDY field.
	TWI_IDR_RXRDY      = 0x2   // Bit RXRDY.
	TWI_IDR_TXRDY_Pos  = 0x2   // Position of TXRDY field.
	TWI_IDR_TXRDY_Msk  = 0x4   // Bit mask of TXRDY field.
	TWI_IDR_TXRDY      = 0x4   // Bit TXRDY.
	TWI_IDR_SVACC_Pos  = 0x4   // Position of SVACC field.
	TWI_IDR_SVACC_Msk  = 0x10  // Bit mask of SVACC field.
	TWI_IDR_SVACC      = 0x10  // Bit SVACC.
	TWI_IDR_GACC_Pos   = 0x5   // Position of GACC field.
	TWI_IDR_GACC_Msk   = 0x20  // Bit mask of GACC field.
	TWI_IDR_GACC       = 0x20  // Bit GACC.
	TWI_IDR_OVRE_Pos   = 0x6   // Position of OVRE field.
	TWI_IDR_OVRE_Msk   = 0x40  // Bit mask of OVRE field.
	TWI_IDR_OVRE       = 0x40  // Bit OVRE.
	TWI_IDR_NACK_Pos   = 0x8   // Position of NACK field.
	TWI_IDR_NACK_Msk   = 0x100 // Bit mask of NACK field.
	TWI_IDR_NACK       = 0x100 // Bit NACK.
	TWI_IDR_ARBLST_Pos = 0x9   // Position of ARBLST field.
	TWI_IDR_ARBLST_Msk = 0x200 // Bit mask of ARBLST field.
	TWI_IDR_ARBLST     = 0x200 // Bit ARBLST.
	TWI_IDR_SCL_WS_Pos = 0xa   // Position of SCL_WS field.
	TWI_IDR_SCL_WS_Msk = 0x400 // Bit mask of SCL_WS field.
	TWI_IDR_SCL_WS     = 0x400 // Bit SCL_WS.
	TWI_IDR_EOSACC_Pos = 0xb   // Position of EOSACC field.
	TWI_IDR_EOSACC_Msk = 0x800 // Bit mask of EOSACC field.
	TWI_IDR_EOSACC     = 0x800 // Bit EOSACC.

	// IMR: Interrupt Mask Register
	TWI_IMR_TXCOMP_Pos = 0x0   // Position of TXCOMP field.
	TWI_IMR_TXCOMP_Msk = 0x1   // Bit mask of TXCOMP field.
	TWI_IMR_TXCOMP     = 0x1   // Bit TXCOMP.
	TWI_IMR_RXRDY_Pos  = 0x1   // Position of RXRDY field.
	TWI_IMR_RXRDY_Msk  = 0x2   // Bit mask of RXRDY field.
	TWI_IMR_RXRDY      = 0x2   // Bit RXRDY.
	TWI_IMR_TXRDY_Pos  = 0x2   // Position of TXRDY field.
	TWI_IMR_TXRDY_Msk  = 0x4   // Bit mask of TXRDY field.
	TWI_IMR_TXRDY      = 0x4   // Bit TXRDY.
	TWI_IMR_SVACC_Pos  = 0x4   // Position of SVACC field.
	TWI_IMR_SVACC_Msk  = 0x10  // Bit mask of SVACC field.
	TWI_IMR_SVACC      = 0x10  // Bit SVACC.
	TWI_IMR_GACC_Pos   = 0x5   // Position of GACC field.
	TWI_IMR_GACC_Msk   = 0x20  // Bit mask of GACC field.
	TWI_IMR_GACC       = 0x20  // Bit GACC.
	TWI_IMR_OVRE_Pos   = 0x6   // Position of OVRE field.
	TWI_IMR_OVRE_Msk   = 0x40  // Bit mask of OVRE field.
	TWI_IMR_OVRE       = 0x40  // Bit OVRE.
	TWI_IMR_NACK_Pos   = 0x8   // Position of NACK field.
	TWI_IMR_NACK_Msk   = 0x100 // Bit mask of NACK field.
	TWI_IMR_NACK       = 0x100 // Bit NACK.
	TWI_IMR_ARBLST_Pos = 0x9   // Position of ARBLST field.
	TWI_IMR_ARBLST_Msk = 0x200 // Bit mask of ARBLST field.
	TWI_IMR_ARBLST     = 0x200 // Bit ARBLST.
	TWI_IMR_SCL_WS_Pos = 0xa   // Position of SCL_WS field.
	TWI_IMR_SCL_WS_Msk = 0x400 // Bit mask of SCL_WS field.
	TWI_IMR_SCL_WS     = 0x400 // Bit SCL_WS.
	TWI_IMR_EOSACC_Pos = 0xb   // Position of EOSACC field.
	TWI_IMR_EOSACC_Msk = 0x800 // Bit mask of EOSACC field.
	TWI_IMR_EOSACC     = 0x800 // Bit EOSACC.

	// RHR: Receive Holding Register
	TWI_RHR_RXDATA_Pos = 0x0  // Position of RXDATA field.
	TWI_RHR_RXDATA_Msk = 0xff // Bit mask of RXDATA field.

	// THR: Transmit Holding Register
	TWI_THR_TXDATA_Pos = 0x0  // Position of TXDATA field.
	TWI_THR_TXDATA_Msk = 0xff // Bit mask of TXDATA field.
)

// Bitfields for USART0: Universal Synchronous Asynchronous Receiver Transmitter 0
const (
	// CR: Control Register
	USART_CR_RSTRX_Pos   = 0x2     // Position of RSTRX field.
	USART_CR_RSTRX_Msk   = 0x4     // Bit mask of RSTRX field.
	USART_CR_RSTRX       = 0x4     // Bit RSTRX.
	USART_CR_RSTTX_Pos   = 0x3     // Position of RSTTX field.
	USART_CR_RSTTX_Msk   = 0x8     // Bit mask of RSTTX field.
	USART_CR_RSTTX       = 0x8     // Bit RSTTX.
	USART_CR_RXEN_Pos    = 0x4     // Position of RXEN field.
	USART_CR_RXEN_Msk    = 0x10    // Bit mask of RXEN field.
	USART_CR_RXEN        = 0x10    // Bit RXEN.
	USART_CR_RXDIS_Pos   = 0x5     // Position of RXDIS field.
	USART_CR_RXDIS_Msk   = 0x20    // Bit mask of RXDIS field.
	USART_CR_RXDIS       = 0x20    // Bit RXDIS.
	USART_CR_TXEN_Pos    = 0x6     // Position of TXEN field.
	USART_CR_TXEN_Msk    = 0x40    // Bit mask of TXEN field.
	USART_CR_TXEN        = 0x40    // Bit TXEN.
	USART_CR_TXDIS_Pos   = 0x7     // Position of TXDIS field.
	USART_CR_TXDIS_Msk   = 0x80    // Bit mask of TXDIS field.
	USART_CR_TXDIS       = 0x80    // Bit TXDIS.
	USART_CR_RSTSTA_Pos  = 0x8     // Position of RSTSTA field.
	USART_CR_RSTSTA_Msk  = 0x100   // Bit mask of RSTSTA field.
	USART_CR_RSTSTA      = 0x100   // Bit RSTSTA.
	USART_CR_STTBRK_Pos  = 0x9     // Position of STTBRK field.
	USART_CR_STTBRK_Msk  = 0x200   // Bit mask of STTBRK field.
	USART_CR_STTBRK      = 0x200   // Bit STTBRK.
	USART_CR_STPBRK_Pos  = 0xa     // Position of STPBRK field.
	USART_CR_STPBRK_Msk  = 0x400   // Bit mask of STPBRK field.
	USART_CR_STPBRK      = 0x400   // Bit STPBRK.
	USART_CR_STTTO_Pos   = 0xb     // Position of STTTO field.
	USART_CR_STTTO_Msk   = 0x800   // Bit mask of STTTO field.
	USART_CR_STTTO       = 0x800   // Bit STTTO.
	USART_CR_SENDA_Pos   = 0xc     // Position of SENDA field.
	USART_CR_SENDA_Msk   = 0x1000  // Bit mask of SENDA field.
	USART_CR_SENDA       = 0x1000  // Bit SENDA.
	USART_CR_RSTIT_Pos   = 0xd     // Position of RSTIT field.
	USART_CR_RSTIT_Msk   = 0x2000  // Bit mask of RSTIT field.
	USART_CR_RSTIT       = 0x2000  // Bit RSTIT.
	USART_CR_RSTNACK_Pos = 0xe     // Position of RSTNACK field.
	USART_CR_RSTNACK_Msk = 0x4000  // Bit mask of RSTNACK field.
	USART_CR_RSTNACK     = 0x4000  // Bit RSTNACK.
	USART_CR_RETTO_Pos   = 0xf     // Position of RETTO field.
	USART_CR_RETTO_Msk   = 0x8000  // Bit mask of RETTO field.
	USART_CR_RETTO       = 0x8000  // Bit RETTO.
	USART_CR_RTSEN_Pos   = 0x12    // Position of RTSEN field.
	USART_CR_RTSEN_Msk   = 0x40000 // Bit mask of RTSEN field.
	USART_CR_RTSEN       = 0x40000 // Bit RTSEN.
	USART_CR_RTSDIS_Pos  = 0x13    // Position of RTSDIS field.
	USART_CR_RTSDIS_Msk  = 0x80000 // Bit mask of RTSDIS field.
	USART_CR_RTSDIS      = 0x80000 // Bit RTSDIS.

	// CR_SPI_MODE: Control Register
	USART_CR_SPI_MODE_RSTRX_Pos  = 0x2     // Position of RSTRX field.
	USART_CR_SPI_MODE_RSTRX_Msk  = 0x4     // Bit mask of RSTRX field.
	USART_CR_SPI_MODE_RSTRX      = 0x4     // Bit RSTRX.
	USART_CR_SPI_MODE_RSTTX_Pos  = 0x3     // Position of RSTTX field.
	USART_CR_SPI_MODE_RSTTX_Msk  = 0x8     // Bit mask of RSTTX field.
	USART_CR_SPI_MODE_RSTTX      = 0x8     // Bit RSTTX.
	USART_CR_SPI_MODE_RXEN_Pos   = 0x4     // Position of RXEN field.
	USART_CR_SPI_MODE_RXEN_Msk   = 0x10    // Bit mask of RXEN field.
	USART_CR_SPI_MODE_RXEN       = 0x10    // Bit RXEN.
	USART_CR_SPI_MODE_RXDIS_Pos  = 0x5     // Position of RXDIS field.
	USART_CR_SPI_MODE_RXDIS_Msk  = 0x20    // Bit mask of RXDIS field.
	USART_CR_SPI_MODE_RXDIS      = 0x20    // Bit RXDIS.
	USART_CR_SPI_MODE_TXEN_Pos   = 0x6     // Position of TXEN field.
	USART_CR_SPI_MODE_TXEN_Msk   = 0x40    // Bit mask of TXEN field.
	USART_CR_SPI_MODE_TXEN       = 0x40    // Bit TXEN.
	USART_CR_SPI_MODE_TXDIS_Pos  = 0x7     // Position of TXDIS field.
	USART_CR_SPI_MODE_TXDIS_Msk  = 0x80    // Bit mask of TXDIS field.
	USART_CR_SPI_MODE_TXDIS      = 0x80    // Bit TXDIS.
	USART_CR_SPI_MODE_RSTSTA_Pos = 0x8     // Position of RSTSTA field.
	USART_CR_SPI_MODE_RSTSTA_Msk = 0x100   // Bit mask of RSTSTA field.
	USART_CR_SPI_MODE_RSTSTA     = 0x100   // Bit RSTSTA.
	USART_CR_SPI_MODE_FCS_Pos    = 0x12    // Position of FCS field.
	USART_CR_SPI_MODE_FCS_Msk    = 0x40000 // Bit mask of FCS field.
	USART_CR_SPI_MODE_FCS        = 0x40000 // Bit FCS.
	USART_CR_SPI_MODE_RCS_Pos    = 0x13    // Position of RCS field.
	USART_CR_SPI_MODE_RCS_Msk    = 0x80000 // Bit mask of RCS field.
	USART_CR_SPI_MODE_RCS        = 0x80000 // Bit RCS.

	// MR: Mode Register
	USART_MR_USART_MODE_Pos            = 0x0        // Position of USART_MODE field.
	USART_MR_USART_MODE_Msk            = 0xf        // Bit mask of USART_MODE field.
	USART_MR_USART_MODE_NORMAL         = 0x0        // Normal mode
	USART_MR_USART_MODE_RS485          = 0x1        // RS485
	USART_MR_USART_MODE_HW_HANDSHAKING = 0x2        // Hardware Handshaking
	USART_MR_USART_MODE_IS07816_T_0    = 0x4        // IS07816 Protocol: T = 0
	USART_MR_USART_MODE_IS07816_T_1    = 0x6        // IS07816 Protocol: T = 1
	USART_MR_USART_MODE_IRDA           = 0x8        // IrDA
	USART_MR_USART_MODE_SPI_MASTER     = 0xe        // SPI Master
	USART_MR_USART_MODE_SPI_SLAVE      = 0xf        // SPI Slave
	USART_MR_USCLKS_Pos                = 0x4        // Position of USCLKS field.
	USART_MR_USCLKS_Msk                = 0x30       // Bit mask of USCLKS field.
	USART_MR_USCLKS_MCK                = 0x0        // Master Clock MCK is selected
	USART_MR_USCLKS_DIV                = 0x1        // Internal Clock Divided MCK/DIV (DIV=8) is selected
	USART_MR_USCLKS_SCK                = 0x3        // Serial Clock SLK is selected
	USART_MR_CHRL_Pos                  = 0x6        // Position of CHRL field.
	USART_MR_CHRL_Msk                  = 0xc0       // Bit mask of CHRL field.
	USART_MR_CHRL_5_BIT                = 0x0        // Character length is 5 bits
	USART_MR_CHRL_6_BIT                = 0x1        // Character length is 6 bits
	USART_MR_CHRL_7_BIT                = 0x2        // Character length is 7 bits
	USART_MR_CHRL_8_BIT                = 0x3        // Character length is 8 bits
	USART_MR_SYNC_Pos                  = 0x8        // Position of SYNC field.
	USART_MR_SYNC_Msk                  = 0x100      // Bit mask of SYNC field.
	USART_MR_SYNC                      = 0x100      // Bit SYNC.
	USART_MR_PAR_Pos                   = 0x9        // Position of PAR field.
	USART_MR_PAR_Msk                   = 0xe00      // Bit mask of PAR field.
	USART_MR_PAR_EVEN                  = 0x0        // Even parity
	USART_MR_PAR_ODD                   = 0x1        // Odd parity
	USART_MR_PAR_SPACE                 = 0x2        // Parity forced to 0 (Space)
	USART_MR_PAR_MARK                  = 0x3        // Parity forced to 1 (Mark)
	USART_MR_PAR_NO                    = 0x4        // No parity
	USART_MR_PAR_MULTIDROP             = 0x6        // Multidrop mode
	USART_MR_NBSTOP_Pos                = 0xc        // Position of NBSTOP field.
	USART_MR_NBSTOP_Msk                = 0x3000     // Bit mask of NBSTOP field.
	USART_MR_NBSTOP_1_BIT              = 0x0        // 1 stop bit
	USART_MR_NBSTOP_1_5_BIT            = 0x1        // 1.5 stop bit (SYNC = 0) or reserved (SYNC = 1)
	USART_MR_NBSTOP_2_BIT              = 0x2        // 2 stop bits
	USART_MR_CHMODE_Pos                = 0xe        // Position of CHMODE field.
	USART_MR_CHMODE_Msk                = 0xc000     // Bit mask of CHMODE field.
	USART_MR_CHMODE_NORMAL             = 0x0        // Normal Mode
	USART_MR_CHMODE_AUTOMATIC          = 0x1        // Automatic Echo. Receiver input is connected to the TXD pin.
	USART_MR_CHMODE_LOCAL_LOOPBACK     = 0x2        // Local Loopback. Transmitter output is connected to the Receiver Input.
	USART_MR_CHMODE_REMOTE_LOOPBACK    = 0x3        // Remote Loopback. RXD pin is internally connected to the TXD pin.
	USART_MR_MSBF_Pos                  = 0x10       // Position of MSBF field.
	USART_MR_MSBF_Msk                  = 0x10000    // Bit mask of MSBF field.
	USART_MR_MSBF                      = 0x10000    // Bit MSBF.
	USART_MR_MODE9_Pos                 = 0x11       // Position of MODE9 field.
	USART_MR_MODE9_Msk                 = 0x20000    // Bit mask of MODE9 field.
	USART_MR_MODE9                     = 0x20000    // Bit MODE9.
	USART_MR_CLKO_Pos                  = 0x12       // Position of CLKO field.
	USART_MR_CLKO_Msk                  = 0x40000    // Bit mask of CLKO field.
	USART_MR_CLKO                      = 0x40000    // Bit CLKO.
	USART_MR_OVER_Pos                  = 0x13       // Position of OVER field.
	USART_MR_OVER_Msk                  = 0x80000    // Bit mask of OVER field.
	USART_MR_OVER                      = 0x80000    // Bit OVER.
	USART_MR_INACK_Pos                 = 0x14       // Position of INACK field.
	USART_MR_INACK_Msk                 = 0x100000   // Bit mask of INACK field.
	USART_MR_INACK                     = 0x100000   // Bit INACK.
	USART_MR_DSNACK_Pos                = 0x15       // Position of DSNACK field.
	USART_MR_DSNACK_Msk                = 0x200000   // Bit mask of DSNACK field.
	USART_MR_DSNACK                    = 0x200000   // Bit DSNACK.
	USART_MR_VAR_SYNC_Pos              = 0x16       // Position of VAR_SYNC field.
	USART_MR_VAR_SYNC_Msk              = 0x400000   // Bit mask of VAR_SYNC field.
	USART_MR_VAR_SYNC                  = 0x400000   // Bit VAR_SYNC.
	USART_MR_MAX_ITERATION_Pos         = 0x18       // Position of MAX_ITERATION field.
	USART_MR_MAX_ITERATION_Msk         = 0x7000000  // Bit mask of MAX_ITERATION field.
	USART_MR_FILTER_Pos                = 0x1c       // Position of FILTER field.
	USART_MR_FILTER_Msk                = 0x10000000 // Bit mask of FILTER field.
	USART_MR_FILTER                    = 0x10000000 // Bit FILTER.
	USART_MR_MAN_Pos                   = 0x1d       // Position of MAN field.
	USART_MR_MAN_Msk                   = 0x20000000 // Bit mask of MAN field.
	USART_MR_MAN                       = 0x20000000 // Bit MAN.
	USART_MR_MODSYNC_Pos               = 0x1e       // Position of MODSYNC field.
	USART_MR_MODSYNC_Msk               = 0x40000000 // Bit mask of MODSYNC field.
	USART_MR_MODSYNC                   = 0x40000000 // Bit MODSYNC.
	USART_MR_ONEBIT_Pos                = 0x1f       // Position of ONEBIT field.
	USART_MR_ONEBIT_Msk                = 0x80000000 // Bit mask of ONEBIT field.
	USART_MR_ONEBIT                    = 0x80000000 // Bit ONEBIT.

	// MR_SPI_MODE: Mode Register
	USART_MR_SPI_MODE_USART_MODE_Pos        = 0x0      // Position of USART_MODE field.
	USART_MR_SPI_MODE_USART_MODE_Msk        = 0xf      // Bit mask of USART_MODE field.
	USART_MR_SPI_MODE_USART_MODE_SPI_MASTER = 0xe      // SPI Master
	USART_MR_SPI_MODE_USART_MODE_SPI_SLAVE  = 0xf      // SPI Slave
	USART_MR_SPI_MODE_USCLKS_Pos            = 0x4      // Position of USCLKS field.
	USART_MR_SPI_MODE_USCLKS_Msk            = 0x30     // Bit mask of USCLKS field.
	USART_MR_SPI_MODE_USCLKS_MCK            = 0x0      // Master Clock MCK is selected
	USART_MR_SPI_MODE_USCLKS_DIV            = 0x1      // Internal Clock Divided MCK/DIV (DIV=8) is selected
	USART_MR_SPI_MODE_USCLKS_SCK            = 0x3      // Serial Clock SLK is selected
	USART_MR_SPI_MODE_CHRL_Pos              = 0x6      // Position of CHRL field.
	USART_MR_SPI_MODE_CHRL_Msk              = 0xc0     // Bit mask of CHRL field.
	USART_MR_SPI_MODE_CHRL_8_BIT            = 0x3      // Character length is 8 bits
	USART_MR_SPI_MODE_CPHA_Pos              = 0x8      // Position of CPHA field.
	USART_MR_SPI_MODE_CPHA_Msk              = 0x100    // Bit mask of CPHA field.
	USART_MR_SPI_MODE_CPHA                  = 0x100    // Bit CPHA.
	USART_MR_SPI_MODE_CPOL_Pos              = 0x10     // Position of CPOL field.
	USART_MR_SPI_MODE_CPOL_Msk              = 0x10000  // Bit mask of CPOL field.
	USART_MR_SPI_MODE_CPOL                  = 0x10000  // Bit CPOL.
	USART_MR_SPI_MODE_WRDBT_Pos             = 0x14     // Position of WRDBT field.
	USART_MR_SPI_MODE_WRDBT_Msk             = 0x100000 // Bit mask of WRDBT field.
	USART_MR_SPI_MODE_WRDBT                 = 0x100000 // Bit WRDBT.

	// IER: Interrupt Enable Register
	USART_IER_RXRDY_Pos   = 0x0       // Position of RXRDY field.
	USART_IER_RXRDY_Msk   = 0x1       // Bit mask of RXRDY field.
	USART_IER_RXRDY       = 0x1       // Bit RXRDY.
	USART_IER_TXRDY_Pos   = 0x1       // Position of TXRDY field.
	USART_IER_TXRDY_Msk   = 0x2       // Bit mask of TXRDY field.
	USART_IER_TXRDY       = 0x2       // Bit TXRDY.
	USART_IER_RXBRK_Pos   = 0x2       // Position of RXBRK field.
	USART_IER_RXBRK_Msk   = 0x4       // Bit mask of RXBRK field.
	USART_IER_RXBRK       = 0x4       // Bit RXBRK.
	USART_IER_ENDRX_Pos   = 0x3       // Position of ENDRX field.
	USART_IER_ENDRX_Msk   = 0x8       // Bit mask of ENDRX field.
	USART_IER_ENDRX       = 0x8       // Bit ENDRX.
	USART_IER_ENDTX_Pos   = 0x4       // Position of ENDTX field.
	USART_IER_ENDTX_Msk   = 0x10      // Bit mask of ENDTX field.
	USART_IER_ENDTX       = 0x10      // Bit ENDTX.
	USART_IER_OVRE_Pos    = 0x5       // Position of OVRE field.
	USART_IER_OVRE_Msk    = 0x20      // Bit mask of OVRE field.
	USART_IER_OVRE        = 0x20      // Bit OVRE.
	USART_IER_FRAME_Pos   = 0x6       // Position of FRAME field.
	USART_IER_FRAME_Msk   = 0x40      // Bit mask of FRAME field.
	USART_IER_FRAME       = 0x40      // Bit FRAME.
	USART_IER_PARE_Pos    = 0x7       // Position of PARE field.
	USART_IER_PARE_Msk    = 0x80      // Bit mask of PARE field.
	USART_IER_PARE        = 0x80      // Bit PARE.
	USART_IER_TIMEOUT_Pos = 0x8       // Position of TIMEOUT field.
	USART_IER_TIMEOUT_Msk = 0x100     // Bit mask of TIMEOUT field.
	USART_IER_TIMEOUT     = 0x100     // Bit TIMEOUT.
	USART_IER_TXEMPTY_Pos = 0x9       // Position of TXEMPTY field.
	USART_IER_TXEMPTY_Msk = 0x200     // Bit mask of TXEMPTY field.
	USART_IER_TXEMPTY     = 0x200     // Bit TXEMPTY.
	USART_IER_ITER_Pos    = 0xa       // Position of ITER field.
	USART_IER_ITER_Msk    = 0x400     // Bit mask of ITER field.
	USART_IER_ITER        = 0x400     // Bit ITER.
	USART_IER_TXBUFE_Pos  = 0xb       // Position of TXBUFE field.
	USART_IER_TXBUFE_Msk  = 0x800     // Bit mask of TXBUFE field.
	USART_IER_TXBUFE      = 0x800     // Bit TXBUFE.
	USART_IER_RXBUFF_Pos  = 0xc       // Position of RXBUFF field.
	USART_IER_RXBUFF_Msk  = 0x1000    // Bit mask of RXBUFF field.
	USART_IER_RXBUFF      = 0x1000    // Bit RXBUFF.
	USART_IER_NACK_Pos    = 0xd       // Position of NACK field.
	USART_IER_NACK_Msk    = 0x2000    // Bit mask of NACK field.
	USART_IER_NACK        = 0x2000    // Bit NACK.
	USART_IER_CTSIC_Pos   = 0x13      // Position of CTSIC field.
	USART_IER_CTSIC_Msk   = 0x80000   // Bit mask of CTSIC field.
	USART_IER_CTSIC       = 0x80000   // Bit CTSIC.
	USART_IER_MANE_Pos    = 0x18      // Position of MANE field.
	USART_IER_MANE_Msk    = 0x1000000 // Bit mask of MANE field.
	USART_IER_MANE        = 0x1000000 // Bit MANE.

	// IER_SPI_MODE: Interrupt Enable Register
	USART_IER_SPI_MODE_RXRDY_Pos   = 0x0   // Position of RXRDY field.
	USART_IER_SPI_MODE_RXRDY_Msk   = 0x1   // Bit mask of RXRDY field.
	USART_IER_SPI_MODE_RXRDY       = 0x1   // Bit RXRDY.
	USART_IER_SPI_MODE_TXRDY_Pos   = 0x1   // Position of TXRDY field.
	USART_IER_SPI_MODE_TXRDY_Msk   = 0x2   // Bit mask of TXRDY field.
	USART_IER_SPI_MODE_TXRDY       = 0x2   // Bit TXRDY.
	USART_IER_SPI_MODE_OVRE_Pos    = 0x5   // Position of OVRE field.
	USART_IER_SPI_MODE_OVRE_Msk    = 0x20  // Bit mask of OVRE field.
	USART_IER_SPI_MODE_OVRE        = 0x20  // Bit OVRE.
	USART_IER_SPI_MODE_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	USART_IER_SPI_MODE_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	USART_IER_SPI_MODE_TXEMPTY     = 0x200 // Bit TXEMPTY.
	USART_IER_SPI_MODE_UNRE_Pos    = 0xa   // Position of UNRE field.
	USART_IER_SPI_MODE_UNRE_Msk    = 0x400 // Bit mask of UNRE field.
	USART_IER_SPI_MODE_UNRE        = 0x400 // Bit UNRE.

	// IDR: Interrupt Disable Register
	USART_IDR_RXRDY_Pos   = 0x0       // Position of RXRDY field.
	USART_IDR_RXRDY_Msk   = 0x1       // Bit mask of RXRDY field.
	USART_IDR_RXRDY       = 0x1       // Bit RXRDY.
	USART_IDR_TXRDY_Pos   = 0x1       // Position of TXRDY field.
	USART_IDR_TXRDY_Msk   = 0x2       // Bit mask of TXRDY field.
	USART_IDR_TXRDY       = 0x2       // Bit TXRDY.
	USART_IDR_RXBRK_Pos   = 0x2       // Position of RXBRK field.
	USART_IDR_RXBRK_Msk   = 0x4       // Bit mask of RXBRK field.
	USART_IDR_RXBRK       = 0x4       // Bit RXBRK.
	USART_IDR_ENDRX_Pos   = 0x3       // Position of ENDRX field.
	USART_IDR_ENDRX_Msk   = 0x8       // Bit mask of ENDRX field.
	USART_IDR_ENDRX       = 0x8       // Bit ENDRX.
	USART_IDR_ENDTX_Pos   = 0x4       // Position of ENDTX field.
	USART_IDR_ENDTX_Msk   = 0x10      // Bit mask of ENDTX field.
	USART_IDR_ENDTX       = 0x10      // Bit ENDTX.
	USART_IDR_OVRE_Pos    = 0x5       // Position of OVRE field.
	USART_IDR_OVRE_Msk    = 0x20      // Bit mask of OVRE field.
	USART_IDR_OVRE        = 0x20      // Bit OVRE.
	USART_IDR_FRAME_Pos   = 0x6       // Position of FRAME field.
	USART_IDR_FRAME_Msk   = 0x40      // Bit mask of FRAME field.
	USART_IDR_FRAME       = 0x40      // Bit FRAME.
	USART_IDR_PARE_Pos    = 0x7       // Position of PARE field.
	USART_IDR_PARE_Msk    = 0x80      // Bit mask of PARE field.
	USART_IDR_PARE        = 0x80      // Bit PARE.
	USART_IDR_TIMEOUT_Pos = 0x8       // Position of TIMEOUT field.
	USART_IDR_TIMEOUT_Msk = 0x100     // Bit mask of TIMEOUT field.
	USART_IDR_TIMEOUT     = 0x100     // Bit TIMEOUT.
	USART_IDR_TXEMPTY_Pos = 0x9       // Position of TXEMPTY field.
	USART_IDR_TXEMPTY_Msk = 0x200     // Bit mask of TXEMPTY field.
	USART_IDR_TXEMPTY     = 0x200     // Bit TXEMPTY.
	USART_IDR_ITER_Pos    = 0xa       // Position of ITER field.
	USART_IDR_ITER_Msk    = 0x400     // Bit mask of ITER field.
	USART_IDR_ITER        = 0x400     // Bit ITER.
	USART_IDR_TXBUFE_Pos  = 0xb       // Position of TXBUFE field.
	USART_IDR_TXBUFE_Msk  = 0x800     // Bit mask of TXBUFE field.
	USART_IDR_TXBUFE      = 0x800     // Bit TXBUFE.
	USART_IDR_RXBUFF_Pos  = 0xc       // Position of RXBUFF field.
	USART_IDR_RXBUFF_Msk  = 0x1000    // Bit mask of RXBUFF field.
	USART_IDR_RXBUFF      = 0x1000    // Bit RXBUFF.
	USART_IDR_NACK_Pos    = 0xd       // Position of NACK field.
	USART_IDR_NACK_Msk    = 0x2000    // Bit mask of NACK field.
	USART_IDR_NACK        = 0x2000    // Bit NACK.
	USART_IDR_CTSIC_Pos   = 0x13      // Position of CTSIC field.
	USART_IDR_CTSIC_Msk   = 0x80000   // Bit mask of CTSIC field.
	USART_IDR_CTSIC       = 0x80000   // Bit CTSIC.
	USART_IDR_MANE_Pos    = 0x18      // Position of MANE field.
	USART_IDR_MANE_Msk    = 0x1000000 // Bit mask of MANE field.
	USART_IDR_MANE        = 0x1000000 // Bit MANE.

	// IDR_SPI_MODE: Interrupt Disable Register
	USART_IDR_SPI_MODE_RXRDY_Pos   = 0x0   // Position of RXRDY field.
	USART_IDR_SPI_MODE_RXRDY_Msk   = 0x1   // Bit mask of RXRDY field.
	USART_IDR_SPI_MODE_RXRDY       = 0x1   // Bit RXRDY.
	USART_IDR_SPI_MODE_TXRDY_Pos   = 0x1   // Position of TXRDY field.
	USART_IDR_SPI_MODE_TXRDY_Msk   = 0x2   // Bit mask of TXRDY field.
	USART_IDR_SPI_MODE_TXRDY       = 0x2   // Bit TXRDY.
	USART_IDR_SPI_MODE_OVRE_Pos    = 0x5   // Position of OVRE field.
	USART_IDR_SPI_MODE_OVRE_Msk    = 0x20  // Bit mask of OVRE field.
	USART_IDR_SPI_MODE_OVRE        = 0x20  // Bit OVRE.
	USART_IDR_SPI_MODE_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	USART_IDR_SPI_MODE_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	USART_IDR_SPI_MODE_TXEMPTY     = 0x200 // Bit TXEMPTY.
	USART_IDR_SPI_MODE_UNRE_Pos    = 0xa   // Position of UNRE field.
	USART_IDR_SPI_MODE_UNRE_Msk    = 0x400 // Bit mask of UNRE field.
	USART_IDR_SPI_MODE_UNRE        = 0x400 // Bit UNRE.

	// IMR: Interrupt Mask Register
	USART_IMR_RXRDY_Pos   = 0x0       // Position of RXRDY field.
	USART_IMR_RXRDY_Msk   = 0x1       // Bit mask of RXRDY field.
	USART_IMR_RXRDY       = 0x1       // Bit RXRDY.
	USART_IMR_TXRDY_Pos   = 0x1       // Position of TXRDY field.
	USART_IMR_TXRDY_Msk   = 0x2       // Bit mask of TXRDY field.
	USART_IMR_TXRDY       = 0x2       // Bit TXRDY.
	USART_IMR_RXBRK_Pos   = 0x2       // Position of RXBRK field.
	USART_IMR_RXBRK_Msk   = 0x4       // Bit mask of RXBRK field.
	USART_IMR_RXBRK       = 0x4       // Bit RXBRK.
	USART_IMR_ENDRX_Pos   = 0x3       // Position of ENDRX field.
	USART_IMR_ENDRX_Msk   = 0x8       // Bit mask of ENDRX field.
	USART_IMR_ENDRX       = 0x8       // Bit ENDRX.
	USART_IMR_ENDTX_Pos   = 0x4       // Position of ENDTX field.
	USART_IMR_ENDTX_Msk   = 0x10      // Bit mask of ENDTX field.
	USART_IMR_ENDTX       = 0x10      // Bit ENDTX.
	USART_IMR_OVRE_Pos    = 0x5       // Position of OVRE field.
	USART_IMR_OVRE_Msk    = 0x20      // Bit mask of OVRE field.
	USART_IMR_OVRE        = 0x20      // Bit OVRE.
	USART_IMR_FRAME_Pos   = 0x6       // Position of FRAME field.
	USART_IMR_FRAME_Msk   = 0x40      // Bit mask of FRAME field.
	USART_IMR_FRAME       = 0x40      // Bit FRAME.
	USART_IMR_PARE_Pos    = 0x7       // Position of PARE field.
	USART_IMR_PARE_Msk    = 0x80      // Bit mask of PARE field.
	USART_IMR_PARE        = 0x80      // Bit PARE.
	USART_IMR_TIMEOUT_Pos = 0x8       // Position of TIMEOUT field.
	USART_IMR_TIMEOUT_Msk = 0x100     // Bit mask of TIMEOUT field.
	USART_IMR_TIMEOUT     = 0x100     // Bit TIMEOUT.
	USART_IMR_TXEMPTY_Pos = 0x9       // Position of TXEMPTY field.
	USART_IMR_TXEMPTY_Msk = 0x200     // Bit mask of TXEMPTY field.
	USART_IMR_TXEMPTY     = 0x200     // Bit TXEMPTY.
	USART_IMR_ITER_Pos    = 0xa       // Position of ITER field.
	USART_IMR_ITER_Msk    = 0x400     // Bit mask of ITER field.
	USART_IMR_ITER        = 0x400     // Bit ITER.
	USART_IMR_TXBUFE_Pos  = 0xb       // Position of TXBUFE field.
	USART_IMR_TXBUFE_Msk  = 0x800     // Bit mask of TXBUFE field.
	USART_IMR_TXBUFE      = 0x800     // Bit TXBUFE.
	USART_IMR_RXBUFF_Pos  = 0xc       // Position of RXBUFF field.
	USART_IMR_RXBUFF_Msk  = 0x1000    // Bit mask of RXBUFF field.
	USART_IMR_RXBUFF      = 0x1000    // Bit RXBUFF.
	USART_IMR_NACK_Pos    = 0xd       // Position of NACK field.
	USART_IMR_NACK_Msk    = 0x2000    // Bit mask of NACK field.
	USART_IMR_NACK        = 0x2000    // Bit NACK.
	USART_IMR_CTSIC_Pos   = 0x13      // Position of CTSIC field.
	USART_IMR_CTSIC_Msk   = 0x80000   // Bit mask of CTSIC field.
	USART_IMR_CTSIC       = 0x80000   // Bit CTSIC.
	USART_IMR_MANE_Pos    = 0x18      // Position of MANE field.
	USART_IMR_MANE_Msk    = 0x1000000 // Bit mask of MANE field.
	USART_IMR_MANE        = 0x1000000 // Bit MANE.

	// IMR_SPI_MODE: Interrupt Mask Register
	USART_IMR_SPI_MODE_RXRDY_Pos   = 0x0   // Position of RXRDY field.
	USART_IMR_SPI_MODE_RXRDY_Msk   = 0x1   // Bit mask of RXRDY field.
	USART_IMR_SPI_MODE_RXRDY       = 0x1   // Bit RXRDY.
	USART_IMR_SPI_MODE_TXRDY_Pos   = 0x1   // Position of TXRDY field.
	USART_IMR_SPI_MODE_TXRDY_Msk   = 0x2   // Bit mask of TXRDY field.
	USART_IMR_SPI_MODE_TXRDY       = 0x2   // Bit TXRDY.
	USART_IMR_SPI_MODE_OVRE_Pos    = 0x5   // Position of OVRE field.
	USART_IMR_SPI_MODE_OVRE_Msk    = 0x20  // Bit mask of OVRE field.
	USART_IMR_SPI_MODE_OVRE        = 0x20  // Bit OVRE.
	USART_IMR_SPI_MODE_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	USART_IMR_SPI_MODE_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	USART_IMR_SPI_MODE_TXEMPTY     = 0x200 // Bit TXEMPTY.
	USART_IMR_SPI_MODE_UNRE_Pos    = 0xa   // Position of UNRE field.
	USART_IMR_SPI_MODE_UNRE_Msk    = 0x400 // Bit mask of UNRE field.
	USART_IMR_SPI_MODE_UNRE        = 0x400 // Bit UNRE.

	// CSR: Channel Status Register
	USART_CSR_RXRDY_Pos   = 0x0       // Position of RXRDY field.
	USART_CSR_RXRDY_Msk   = 0x1       // Bit mask of RXRDY field.
	USART_CSR_RXRDY       = 0x1       // Bit RXRDY.
	USART_CSR_TXRDY_Pos   = 0x1       // Position of TXRDY field.
	USART_CSR_TXRDY_Msk   = 0x2       // Bit mask of TXRDY field.
	USART_CSR_TXRDY       = 0x2       // Bit TXRDY.
	USART_CSR_RXBRK_Pos   = 0x2       // Position of RXBRK field.
	USART_CSR_RXBRK_Msk   = 0x4       // Bit mask of RXBRK field.
	USART_CSR_RXBRK       = 0x4       // Bit RXBRK.
	USART_CSR_ENDRX_Pos   = 0x3       // Position of ENDRX field.
	USART_CSR_ENDRX_Msk   = 0x8       // Bit mask of ENDRX field.
	USART_CSR_ENDRX       = 0x8       // Bit ENDRX.
	USART_CSR_ENDTX_Pos   = 0x4       // Position of ENDTX field.
	USART_CSR_ENDTX_Msk   = 0x10      // Bit mask of ENDTX field.
	USART_CSR_ENDTX       = 0x10      // Bit ENDTX.
	USART_CSR_OVRE_Pos    = 0x5       // Position of OVRE field.
	USART_CSR_OVRE_Msk    = 0x20      // Bit mask of OVRE field.
	USART_CSR_OVRE        = 0x20      // Bit OVRE.
	USART_CSR_FRAME_Pos   = 0x6       // Position of FRAME field.
	USART_CSR_FRAME_Msk   = 0x40      // Bit mask of FRAME field.
	USART_CSR_FRAME       = 0x40      // Bit FRAME.
	USART_CSR_PARE_Pos    = 0x7       // Position of PARE field.
	USART_CSR_PARE_Msk    = 0x80      // Bit mask of PARE field.
	USART_CSR_PARE        = 0x80      // Bit PARE.
	USART_CSR_TIMEOUT_Pos = 0x8       // Position of TIMEOUT field.
	USART_CSR_TIMEOUT_Msk = 0x100     // Bit mask of TIMEOUT field.
	USART_CSR_TIMEOUT     = 0x100     // Bit TIMEOUT.
	USART_CSR_TXEMPTY_Pos = 0x9       // Position of TXEMPTY field.
	USART_CSR_TXEMPTY_Msk = 0x200     // Bit mask of TXEMPTY field.
	USART_CSR_TXEMPTY     = 0x200     // Bit TXEMPTY.
	USART_CSR_ITER_Pos    = 0xa       // Position of ITER field.
	USART_CSR_ITER_Msk    = 0x400     // Bit mask of ITER field.
	USART_CSR_ITER        = 0x400     // Bit ITER.
	USART_CSR_TXBUFE_Pos  = 0xb       // Position of TXBUFE field.
	USART_CSR_TXBUFE_Msk  = 0x800     // Bit mask of TXBUFE field.
	USART_CSR_TXBUFE      = 0x800     // Bit TXBUFE.
	USART_CSR_RXBUFF_Pos  = 0xc       // Position of RXBUFF field.
	USART_CSR_RXBUFF_Msk  = 0x1000    // Bit mask of RXBUFF field.
	USART_CSR_RXBUFF      = 0x1000    // Bit RXBUFF.
	USART_CSR_NACK_Pos    = 0xd       // Position of NACK field.
	USART_CSR_NACK_Msk    = 0x2000    // Bit mask of NACK field.
	USART_CSR_NACK        = 0x2000    // Bit NACK.
	USART_CSR_CTSIC_Pos   = 0x13      // Position of CTSIC field.
	USART_CSR_CTSIC_Msk   = 0x80000   // Bit mask of CTSIC field.
	USART_CSR_CTSIC       = 0x80000   // Bit CTSIC.
	USART_CSR_CTS_Pos     = 0x17      // Position of CTS field.
	USART_CSR_CTS_Msk     = 0x800000  // Bit mask of CTS field.
	USART_CSR_CTS         = 0x800000  // Bit CTS.
	USART_CSR_MANERR_Pos  = 0x18      // Position of MANERR field.
	USART_CSR_MANERR_Msk  = 0x1000000 // Bit mask of MANERR field.
	USART_CSR_MANERR      = 0x1000000 // Bit MANERR.

	// CSR_SPI_MODE: Channel Status Register
	USART_CSR_SPI_MODE_RXRDY_Pos   = 0x0   // Position of RXRDY field.
	USART_CSR_SPI_MODE_RXRDY_Msk   = 0x1   // Bit mask of RXRDY field.
	USART_CSR_SPI_MODE_RXRDY       = 0x1   // Bit RXRDY.
	USART_CSR_SPI_MODE_TXRDY_Pos   = 0x1   // Position of TXRDY field.
	USART_CSR_SPI_MODE_TXRDY_Msk   = 0x2   // Bit mask of TXRDY field.
	USART_CSR_SPI_MODE_TXRDY       = 0x2   // Bit TXRDY.
	USART_CSR_SPI_MODE_OVRE_Pos    = 0x5   // Position of OVRE field.
	USART_CSR_SPI_MODE_OVRE_Msk    = 0x20  // Bit mask of OVRE field.
	USART_CSR_SPI_MODE_OVRE        = 0x20  // Bit OVRE.
	USART_CSR_SPI_MODE_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	USART_CSR_SPI_MODE_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	USART_CSR_SPI_MODE_TXEMPTY     = 0x200 // Bit TXEMPTY.
	USART_CSR_SPI_MODE_UNRE_Pos    = 0xa   // Position of UNRE field.
	USART_CSR_SPI_MODE_UNRE_Msk    = 0x400 // Bit mask of UNRE field.
	USART_CSR_SPI_MODE_UNRE        = 0x400 // Bit UNRE.

	// RHR: Receiver Holding Register
	USART_RHR_RXCHR_Pos  = 0x0    // Position of RXCHR field.
	USART_RHR_RXCHR_Msk  = 0x1ff  // Bit mask of RXCHR field.
	USART_RHR_RXSYNH_Pos = 0xf    // Position of RXSYNH field.
	USART_RHR_RXSYNH_Msk = 0x8000 // Bit mask of RXSYNH field.
	USART_RHR_RXSYNH     = 0x8000 // Bit RXSYNH.

	// THR: Transmitter Holding Register
	USART_THR_TXCHR_Pos  = 0x0    // Position of TXCHR field.
	USART_THR_TXCHR_Msk  = 0x1ff  // Bit mask of TXCHR field.
	USART_THR_TXSYNH_Pos = 0xf    // Position of TXSYNH field.
	USART_THR_TXSYNH_Msk = 0x8000 // Bit mask of TXSYNH field.
	USART_THR_TXSYNH     = 0x8000 // Bit TXSYNH.

	// BRGR: Baud Rate Generator Register
	USART_BRGR_CD_Pos = 0x0     // Position of CD field.
	USART_BRGR_CD_Msk = 0xffff  // Bit mask of CD field.
	USART_BRGR_FP_Pos = 0x10    // Position of FP field.
	USART_BRGR_FP_Msk = 0x70000 // Bit mask of FP field.

	// RTOR: Receiver Time-out Register
	USART_RTOR_TO_Pos = 0x0    // Position of TO field.
	USART_RTOR_TO_Msk = 0xffff // Bit mask of TO field.

	// TTGR: Transmitter Timeguard Register
	USART_TTGR_TG_Pos = 0x0  // Position of TG field.
	USART_TTGR_TG_Msk = 0xff // Bit mask of TG field.

	// FIDI: FI DI Ratio Register
	USART_FIDI_FI_DI_RATIO_Pos = 0x0   // Position of FI_DI_RATIO field.
	USART_FIDI_FI_DI_RATIO_Msk = 0x7ff // Bit mask of FI_DI_RATIO field.

	// NER: Number of Errors Register
	USART_NER_NB_ERRORS_Pos = 0x0  // Position of NB_ERRORS field.
	USART_NER_NB_ERRORS_Msk = 0xff // Bit mask of NB_ERRORS field.

	// IF: IrDA Filter Register
	USART_IF_IRDA_FILTER_Pos = 0x0  // Position of IRDA_FILTER field.
	USART_IF_IRDA_FILTER_Msk = 0xff // Bit mask of IRDA_FILTER field.

	// MAN: Manchester Encoder Decoder Register
	USART_MAN_TX_PL_Pos      = 0x0        // Position of TX_PL field.
	USART_MAN_TX_PL_Msk      = 0xf        // Bit mask of TX_PL field.
	USART_MAN_TX_PP_Pos      = 0x8        // Position of TX_PP field.
	USART_MAN_TX_PP_Msk      = 0x300      // Bit mask of TX_PP field.
	USART_MAN_TX_PP_ALL_ONE  = 0x0        // The preamble is composed of '1's
	USART_MAN_TX_PP_ALL_ZERO = 0x1        // The preamble is composed of '0's
	USART_MAN_TX_PP_ZERO_ONE = 0x2        // The preamble is composed of '01's
	USART_MAN_TX_PP_ONE_ZERO = 0x3        // The preamble is composed of '10's
	USART_MAN_TX_MPOL_Pos    = 0xc        // Position of TX_MPOL field.
	USART_MAN_TX_MPOL_Msk    = 0x1000     // Bit mask of TX_MPOL field.
	USART_MAN_TX_MPOL        = 0x1000     // Bit TX_MPOL.
	USART_MAN_RX_PL_Pos      = 0x10       // Position of RX_PL field.
	USART_MAN_RX_PL_Msk      = 0xf0000    // Bit mask of RX_PL field.
	USART_MAN_RX_PP_Pos      = 0x18       // Position of RX_PP field.
	USART_MAN_RX_PP_Msk      = 0x3000000  // Bit mask of RX_PP field.
	USART_MAN_RX_PP_ALL_ONE  = 0x0        // The preamble is composed of '1's
	USART_MAN_RX_PP_ALL_ZERO = 0x1        // The preamble is composed of '0's
	USART_MAN_RX_PP_ZERO_ONE = 0x2        // The preamble is composed of '01's
	USART_MAN_RX_PP_ONE_ZERO = 0x3        // The preamble is composed of '10's
	USART_MAN_RX_MPOL_Pos    = 0x1c       // Position of RX_MPOL field.
	USART_MAN_RX_MPOL_Msk    = 0x10000000 // Bit mask of RX_MPOL field.
	USART_MAN_RX_MPOL        = 0x10000000 // Bit RX_MPOL.
	USART_MAN_ONE_Pos        = 0x1d       // Position of ONE field.
	USART_MAN_ONE_Msk        = 0x20000000 // Bit mask of ONE field.
	USART_MAN_ONE            = 0x20000000 // Bit ONE.
	USART_MAN_DRIFT_Pos      = 0x1e       // Position of DRIFT field.
	USART_MAN_DRIFT_Msk      = 0x40000000 // Bit mask of DRIFT field.
	USART_MAN_DRIFT          = 0x40000000 // Bit DRIFT.

	// RPR: Receive Pointer Register
	USART_RPR_RXPTR_Pos = 0x0        // Position of RXPTR field.
	USART_RPR_RXPTR_Msk = 0xffffffff // Bit mask of RXPTR field.

	// RCR: Receive Counter Register
	USART_RCR_RXCTR_Pos = 0x0    // Position of RXCTR field.
	USART_RCR_RXCTR_Msk = 0xffff // Bit mask of RXCTR field.

	// TPR: Transmit Pointer Register
	USART_TPR_TXPTR_Pos = 0x0        // Position of TXPTR field.
	USART_TPR_TXPTR_Msk = 0xffffffff // Bit mask of TXPTR field.

	// TCR: Transmit Counter Register
	USART_TCR_TXCTR_Pos = 0x0    // Position of TXCTR field.
	USART_TCR_TXCTR_Msk = 0xffff // Bit mask of TXCTR field.

	// RNPR: Receive Next Pointer Register
	USART_RNPR_RXNPTR_Pos = 0x0        // Position of RXNPTR field.
	USART_RNPR_RXNPTR_Msk = 0xffffffff // Bit mask of RXNPTR field.

	// RNCR: Receive Next Counter Register
	USART_RNCR_RXNCTR_Pos = 0x0    // Position of RXNCTR field.
	USART_RNCR_RXNCTR_Msk = 0xffff // Bit mask of RXNCTR field.

	// TNPR: Transmit Next Pointer Register
	USART_TNPR_TXNPTR_Pos = 0x0        // Position of TXNPTR field.
	USART_TNPR_TXNPTR_Msk = 0xffffffff // Bit mask of TXNPTR field.

	// TNCR: Transmit Next Counter Register
	USART_TNCR_TXNCTR_Pos = 0x0    // Position of TXNCTR field.
	USART_TNCR_TXNCTR_Msk = 0xffff // Bit mask of TXNCTR field.

	// PTCR: Transfer Control Register
	USART_PTCR_RXTEN_Pos  = 0x0   // Position of RXTEN field.
	USART_PTCR_RXTEN_Msk  = 0x1   // Bit mask of RXTEN field.
	USART_PTCR_RXTEN      = 0x1   // Bit RXTEN.
	USART_PTCR_RXTDIS_Pos = 0x1   // Position of RXTDIS field.
	USART_PTCR_RXTDIS_Msk = 0x2   // Bit mask of RXTDIS field.
	USART_PTCR_RXTDIS     = 0x2   // Bit RXTDIS.
	USART_PTCR_TXTEN_Pos  = 0x8   // Position of TXTEN field.
	USART_PTCR_TXTEN_Msk  = 0x100 // Bit mask of TXTEN field.
	USART_PTCR_TXTEN      = 0x100 // Bit TXTEN.
	USART_PTCR_TXTDIS_Pos = 0x9   // Position of TXTDIS field.
	USART_PTCR_TXTDIS_Msk = 0x200 // Bit mask of TXTDIS field.
	USART_PTCR_TXTDIS     = 0x200 // Bit TXTDIS.

	// PTSR: Transfer Status Register
	USART_PTSR_RXTEN_Pos = 0x0   // Position of RXTEN field.
	USART_PTSR_RXTEN_Msk = 0x1   // Bit mask of RXTEN field.
	USART_PTSR_RXTEN     = 0x1   // Bit RXTEN.
	USART_PTSR_TXTEN_Pos = 0x8   // Position of TXTEN field.
	USART_PTSR_TXTEN_Msk = 0x100 // Bit mask of TXTEN field.
	USART_PTSR_TXTEN     = 0x100 // Bit TXTEN.
)

// Bitfields for SSC0: Synchronous Serial Controller 0
const (
	// CR: Control Register
	SSC_CR_RXEN_Pos  = 0x0    // Position of RXEN field.
	SSC_CR_RXEN_Msk  = 0x1    // Bit mask of RXEN field.
	SSC_CR_RXEN      = 0x1    // Bit RXEN.
	SSC_CR_RXDIS_Pos = 0x1    // Position of RXDIS field.
	SSC_CR_RXDIS_Msk = 0x2    // Bit mask of RXDIS field.
	SSC_CR_RXDIS     = 0x2    // Bit RXDIS.
	SSC_CR_TXEN_Pos  = 0x8    // Position of TXEN field.
	SSC_CR_TXEN_Msk  = 0x100  // Bit mask of TXEN field.
	SSC_CR_TXEN      = 0x100  // Bit TXEN.
	SSC_CR_TXDIS_Pos = 0x9    // Position of TXDIS field.
	SSC_CR_TXDIS_Msk = 0x200  // Bit mask of TXDIS field.
	SSC_CR_TXDIS     = 0x200  // Bit TXDIS.
	SSC_CR_SWRST_Pos = 0xf    // Position of SWRST field.
	SSC_CR_SWRST_Msk = 0x8000 // Bit mask of SWRST field.
	SSC_CR_SWRST     = 0x8000 // Bit SWRST.

	// CMR: Clock Mode Register
	SSC_CMR_DIV_Pos = 0x0   // Position of DIV field.
	SSC_CMR_DIV_Msk = 0xfff // Bit mask of DIV field.

	// RCMR: Receive Clock Mode Register
	SSC_RCMR_CKS_Pos          = 0x0        // Position of CKS field.
	SSC_RCMR_CKS_Msk          = 0x3        // Bit mask of CKS field.
	SSC_RCMR_CKS_MCK          = 0x0        // Divided Clock
	SSC_RCMR_CKS_TK           = 0x1        // TK Clock signal
	SSC_RCMR_CKS_RK           = 0x2        // RK pin
	SSC_RCMR_CKO_Pos          = 0x2        // Position of CKO field.
	SSC_RCMR_CKO_Msk          = 0x1c       // Bit mask of CKO field.
	SSC_RCMR_CKO_NONE         = 0x0        // None
	SSC_RCMR_CKO_CONTINUOUS   = 0x1        // Continuous Receive Clock
	SSC_RCMR_CKO_TRANSFER     = 0x2        // Receive Clock only during data transfers
	SSC_RCMR_CKI_Pos          = 0x5        // Position of CKI field.
	SSC_RCMR_CKI_Msk          = 0x20       // Bit mask of CKI field.
	SSC_RCMR_CKI              = 0x20       // Bit CKI.
	SSC_RCMR_CKG_Pos          = 0x6        // Position of CKG field.
	SSC_RCMR_CKG_Msk          = 0xc0       // Bit mask of CKG field.
	SSC_RCMR_CKG_NONE         = 0x0        // None
	SSC_RCMR_CKG_CONTINUOUS   = 0x1        // Continuous Receive Clock
	SSC_RCMR_CKG_TRANSFER     = 0x2        // Receive Clock only during data transfers
	SSC_RCMR_START_Pos        = 0x8        // Position of START field.
	SSC_RCMR_START_Msk        = 0xf00      // Bit mask of START field.
	SSC_RCMR_START_CONTINUOUS = 0x0        // Continuous, as soon as the receiver is enabled, and immediately after the end of transfer of the previous data.
	SSC_RCMR_START_TRANSMIT   = 0x1        // Transmit start
	SSC_RCMR_START_RF_LOW     = 0x2        // Detection of a low level on RF signal
	SSC_RCMR_START_RF_HIGH    = 0x3        // Detection of a high level on RF signal
	SSC_RCMR_START_RF_FALLING = 0x4        // Detection of a falling edge on RF signal
	SSC_RCMR_START_RF_RISING  = 0x5        // Detection of a rising edge on RF signal
	SSC_RCMR_START_RF_LEVEL   = 0x6        // Detection of any level change on RF signal
	SSC_RCMR_START_RF_EDGE    = 0x7        // Detection of any edge on RF signal
	SSC_RCMR_START_CMP_0      = 0x8        // Compare 0
	SSC_RCMR_STOP_Pos         = 0xc        // Position of STOP field.
	SSC_RCMR_STOP_Msk         = 0x1000     // Bit mask of STOP field.
	SSC_RCMR_STOP             = 0x1000     // Bit STOP.
	SSC_RCMR_STTDLY_Pos       = 0x10       // Position of STTDLY field.
	SSC_RCMR_STTDLY_Msk       = 0xff0000   // Bit mask of STTDLY field.
	SSC_RCMR_PERIOD_Pos       = 0x18       // Position of PERIOD field.
	SSC_RCMR_PERIOD_Msk       = 0xff000000 // Bit mask of PERIOD field.

	// RFMR: Receive Frame Mode Register
	SSC_RFMR_DATLEN_Pos      = 0x0        // Position of DATLEN field.
	SSC_RFMR_DATLEN_Msk      = 0x1f       // Bit mask of DATLEN field.
	SSC_RFMR_LOOP_Pos        = 0x5        // Position of LOOP field.
	SSC_RFMR_LOOP_Msk        = 0x20       // Bit mask of LOOP field.
	SSC_RFMR_LOOP            = 0x20       // Bit LOOP.
	SSC_RFMR_MSBF_Pos        = 0x7        // Position of MSBF field.
	SSC_RFMR_MSBF_Msk        = 0x80       // Bit mask of MSBF field.
	SSC_RFMR_MSBF            = 0x80       // Bit MSBF.
	SSC_RFMR_DATNB_Pos       = 0x8        // Position of DATNB field.
	SSC_RFMR_DATNB_Msk       = 0xf00      // Bit mask of DATNB field.
	SSC_RFMR_FSLEN_Pos       = 0x10       // Position of FSLEN field.
	SSC_RFMR_FSLEN_Msk       = 0xf0000    // Bit mask of FSLEN field.
	SSC_RFMR_FSOS_Pos        = 0x14       // Position of FSOS field.
	SSC_RFMR_FSOS_Msk        = 0x700000   // Bit mask of FSOS field.
	SSC_RFMR_FSOS_NONE       = 0x0        // None
	SSC_RFMR_FSOS_NEGATIVE   = 0x1        // Negative Pulse
	SSC_RFMR_FSOS_POSITIVE   = 0x2        // Positive Pulse
	SSC_RFMR_FSOS_LOW        = 0x3        // Driven Low during data transfer
	SSC_RFMR_FSOS_HIGH       = 0x4        // Driven High during data transfer
	SSC_RFMR_FSOS_TOGGLING   = 0x5        // Toggling at each start of data transfer
	SSC_RFMR_FSEDGE_Pos      = 0x18       // Position of FSEDGE field.
	SSC_RFMR_FSEDGE_Msk      = 0x1000000  // Bit mask of FSEDGE field.
	SSC_RFMR_FSEDGE          = 0x1000000  // Bit FSEDGE.
	SSC_RFMR_FSEDGE_POSITIVE = 0x0        // Positive Edge Detection
	SSC_RFMR_FSEDGE_NEGATIVE = 0x1        // Negative Edge Detection
	SSC_RFMR_FSLEN_EXT_Pos   = 0x1c       // Position of FSLEN_EXT field.
	SSC_RFMR_FSLEN_EXT_Msk   = 0xf0000000 // Bit mask of FSLEN_EXT field.

	// TCMR: Transmit Clock Mode Register
	SSC_TCMR_CKS_Pos          = 0x0        // Position of CKS field.
	SSC_TCMR_CKS_Msk          = 0x3        // Bit mask of CKS field.
	SSC_TCMR_CKS_MCK          = 0x0        // Divided Clock
	SSC_TCMR_CKS_TK           = 0x1        // TK Clock signal
	SSC_TCMR_CKS_RK           = 0x2        // RK pin
	SSC_TCMR_CKO_Pos          = 0x2        // Position of CKO field.
	SSC_TCMR_CKO_Msk          = 0x1c       // Bit mask of CKO field.
	SSC_TCMR_CKO_NONE         = 0x0        // None
	SSC_TCMR_CKO_CONTINUOUS   = 0x1        // Continuous Receive Clock
	SSC_TCMR_CKO_TRANSFER     = 0x2        // Transmit Clock only during data transfers
	SSC_TCMR_CKI_Pos          = 0x5        // Position of CKI field.
	SSC_TCMR_CKI_Msk          = 0x20       // Bit mask of CKI field.
	SSC_TCMR_CKI              = 0x20       // Bit CKI.
	SSC_TCMR_CKG_Pos          = 0x6        // Position of CKG field.
	SSC_TCMR_CKG_Msk          = 0xc0       // Bit mask of CKG field.
	SSC_TCMR_CKG_NONE         = 0x0        // None
	SSC_TCMR_CKG_CONTINUOUS   = 0x1        // Transmit Clock enabled only if TF Low
	SSC_TCMR_CKG_TRANSFER     = 0x2        // Transmit Clock enabled only if TF High
	SSC_TCMR_START_Pos        = 0x8        // Position of START field.
	SSC_TCMR_START_Msk        = 0xf00      // Bit mask of START field.
	SSC_TCMR_START_CONTINUOUS = 0x0        // Continuous, as soon as a word is written in the SSC_THR Register (if Transmit is enabled), and immediately after the end of transfer of the previous data.
	SSC_TCMR_START_RECEIVE    = 0x1        // Receive start
	SSC_TCMR_START_RF_LOW     = 0x2        // Detection of a low level on TF signal
	SSC_TCMR_START_RF_HIGH    = 0x3        // Detection of a high level on TF signal
	SSC_TCMR_START_RF_FALLING = 0x4        // Detection of a falling edge on TF signal
	SSC_TCMR_START_RF_RISING  = 0x5        // Detection of a rising edge on TF signal
	SSC_TCMR_START_RF_LEVEL   = 0x6        // Detection of any level change on TF signal
	SSC_TCMR_START_RF_EDGE    = 0x7        // Detection of any edge on TF signal
	SSC_TCMR_START_CMP_0      = 0x8        // Compare 0
	SSC_TCMR_STTDLY_Pos       = 0x10       // Position of STTDLY field.
	SSC_TCMR_STTDLY_Msk       = 0xff0000   // Bit mask of STTDLY field.
	SSC_TCMR_PERIOD_Pos       = 0x18       // Position of PERIOD field.
	SSC_TCMR_PERIOD_Msk       = 0xff000000 // Bit mask of PERIOD field.

	// TFMR: Transmit Frame Mode Register
	SSC_TFMR_DATLEN_Pos      = 0x0        // Position of DATLEN field.
	SSC_TFMR_DATLEN_Msk      = 0x1f       // Bit mask of DATLEN field.
	SSC_TFMR_DATDEF_Pos      = 0x5        // Position of DATDEF field.
	SSC_TFMR_DATDEF_Msk      = 0x20       // Bit mask of DATDEF field.
	SSC_TFMR_DATDEF          = 0x20       // Bit DATDEF.
	SSC_TFMR_MSBF_Pos        = 0x7        // Position of MSBF field.
	SSC_TFMR_MSBF_Msk        = 0x80       // Bit mask of MSBF field.
	SSC_TFMR_MSBF            = 0x80       // Bit MSBF.
	SSC_TFMR_DATNB_Pos       = 0x8        // Position of DATNB field.
	SSC_TFMR_DATNB_Msk       = 0xf00      // Bit mask of DATNB field.
	SSC_TFMR_FSLEN_Pos       = 0x10       // Position of FSLEN field.
	SSC_TFMR_FSLEN_Msk       = 0xf0000    // Bit mask of FSLEN field.
	SSC_TFMR_FSOS_Pos        = 0x14       // Position of FSOS field.
	SSC_TFMR_FSOS_Msk        = 0x700000   // Bit mask of FSOS field.
	SSC_TFMR_FSOS_NONE       = 0x0        // None
	SSC_TFMR_FSOS_NEGATIVE   = 0x1        // Negative Pulse
	SSC_TFMR_FSOS_POSITIVE   = 0x2        // Positive Pulse
	SSC_TFMR_FSOS_LOW        = 0x3        // Driven Low during data transfer
	SSC_TFMR_FSOS_HIGH       = 0x4        // Driven High during data transfer
	SSC_TFMR_FSOS_TOGGLING   = 0x5        // Toggling at each start of data transfer
	SSC_TFMR_FSDEN_Pos       = 0x17       // Position of FSDEN field.
	SSC_TFMR_FSDEN_Msk       = 0x800000   // Bit mask of FSDEN field.
	SSC_TFMR_FSDEN           = 0x800000   // Bit FSDEN.
	SSC_TFMR_FSEDGE_Pos      = 0x18       // Position of FSEDGE field.
	SSC_TFMR_FSEDGE_Msk      = 0x1000000  // Bit mask of FSEDGE field.
	SSC_TFMR_FSEDGE          = 0x1000000  // Bit FSEDGE.
	SSC_TFMR_FSEDGE_POSITIVE = 0x0        // Positive Edge Detection
	SSC_TFMR_FSEDGE_NEGATIVE = 0x1        // Negative Edge Detection
	SSC_TFMR_FSLEN_EXT_Pos   = 0x1c       // Position of FSLEN_EXT field.
	SSC_TFMR_FSLEN_EXT_Msk   = 0xf0000000 // Bit mask of FSLEN_EXT field.

	// RHR: Receive Holding Register
	SSC_RHR_RDAT_Pos = 0x0        // Position of RDAT field.
	SSC_RHR_RDAT_Msk = 0xffffffff // Bit mask of RDAT field.

	// THR: Transmit Holding Register
	SSC_THR_TDAT_Pos = 0x0        // Position of TDAT field.
	SSC_THR_TDAT_Msk = 0xffffffff // Bit mask of TDAT field.

	// RSHR: Receive Sync. Holding Register
	SSC_RSHR_RSDAT_Pos = 0x0    // Position of RSDAT field.
	SSC_RSHR_RSDAT_Msk = 0xffff // Bit mask of RSDAT field.

	// TSHR: Transmit Sync. Holding Register
	SSC_TSHR_TSDAT_Pos = 0x0    // Position of TSDAT field.
	SSC_TSHR_TSDAT_Msk = 0xffff // Bit mask of TSDAT field.

	// RC0R: Receive Compare 0 Register
	SSC_RC0R_CP0_Pos = 0x0    // Position of CP0 field.
	SSC_RC0R_CP0_Msk = 0xffff // Bit mask of CP0 field.

	// RC1R: Receive Compare 1 Register
	SSC_RC1R_CP1_Pos = 0x0    // Position of CP1 field.
	SSC_RC1R_CP1_Msk = 0xffff // Bit mask of CP1 field.

	// SR: Status Register
	SSC_SR_TXRDY_Pos   = 0x0     // Position of TXRDY field.
	SSC_SR_TXRDY_Msk   = 0x1     // Bit mask of TXRDY field.
	SSC_SR_TXRDY       = 0x1     // Bit TXRDY.
	SSC_SR_TXEMPTY_Pos = 0x1     // Position of TXEMPTY field.
	SSC_SR_TXEMPTY_Msk = 0x2     // Bit mask of TXEMPTY field.
	SSC_SR_TXEMPTY     = 0x2     // Bit TXEMPTY.
	SSC_SR_ENDTX_Pos   = 0x2     // Position of ENDTX field.
	SSC_SR_ENDTX_Msk   = 0x4     // Bit mask of ENDTX field.
	SSC_SR_ENDTX       = 0x4     // Bit ENDTX.
	SSC_SR_TXBUFE_Pos  = 0x3     // Position of TXBUFE field.
	SSC_SR_TXBUFE_Msk  = 0x8     // Bit mask of TXBUFE field.
	SSC_SR_TXBUFE      = 0x8     // Bit TXBUFE.
	SSC_SR_RXRDY_Pos   = 0x4     // Position of RXRDY field.
	SSC_SR_RXRDY_Msk   = 0x10    // Bit mask of RXRDY field.
	SSC_SR_RXRDY       = 0x10    // Bit RXRDY.
	SSC_SR_OVRUN_Pos   = 0x5     // Position of OVRUN field.
	SSC_SR_OVRUN_Msk   = 0x20    // Bit mask of OVRUN field.
	SSC_SR_OVRUN       = 0x20    // Bit OVRUN.
	SSC_SR_ENDRX_Pos   = 0x6     // Position of ENDRX field.
	SSC_SR_ENDRX_Msk   = 0x40    // Bit mask of ENDRX field.
	SSC_SR_ENDRX       = 0x40    // Bit ENDRX.
	SSC_SR_RXBUFF_Pos  = 0x7     // Position of RXBUFF field.
	SSC_SR_RXBUFF_Msk  = 0x80    // Bit mask of RXBUFF field.
	SSC_SR_RXBUFF      = 0x80    // Bit RXBUFF.
	SSC_SR_CP0_Pos     = 0x8     // Position of CP0 field.
	SSC_SR_CP0_Msk     = 0x100   // Bit mask of CP0 field.
	SSC_SR_CP0         = 0x100   // Bit CP0.
	SSC_SR_CP1_Pos     = 0x9     // Position of CP1 field.
	SSC_SR_CP1_Msk     = 0x200   // Bit mask of CP1 field.
	SSC_SR_CP1         = 0x200   // Bit CP1.
	SSC_SR_TXSYN_Pos   = 0xa     // Position of TXSYN field.
	SSC_SR_TXSYN_Msk   = 0x400   // Bit mask of TXSYN field.
	SSC_SR_TXSYN       = 0x400   // Bit TXSYN.
	SSC_SR_RXSYN_Pos   = 0xb     // Position of RXSYN field.
	SSC_SR_RXSYN_Msk   = 0x800   // Bit mask of RXSYN field.
	SSC_SR_RXSYN       = 0x800   // Bit RXSYN.
	SSC_SR_TXEN_Pos    = 0x10    // Position of TXEN field.
	SSC_SR_TXEN_Msk    = 0x10000 // Bit mask of TXEN field.
	SSC_SR_TXEN        = 0x10000 // Bit TXEN.
	SSC_SR_RXEN_Pos    = 0x11    // Position of RXEN field.
	SSC_SR_RXEN_Msk    = 0x20000 // Bit mask of RXEN field.
	SSC_SR_RXEN        = 0x20000 // Bit RXEN.

	// IER: Interrupt Enable Register
	SSC_IER_TXRDY_Pos   = 0x0   // Position of TXRDY field.
	SSC_IER_TXRDY_Msk   = 0x1   // Bit mask of TXRDY field.
	SSC_IER_TXRDY       = 0x1   // Bit TXRDY.
	SSC_IER_TXEMPTY_Pos = 0x1   // Position of TXEMPTY field.
	SSC_IER_TXEMPTY_Msk = 0x2   // Bit mask of TXEMPTY field.
	SSC_IER_TXEMPTY     = 0x2   // Bit TXEMPTY.
	SSC_IER_ENDTX_Pos   = 0x2   // Position of ENDTX field.
	SSC_IER_ENDTX_Msk   = 0x4   // Bit mask of ENDTX field.
	SSC_IER_ENDTX       = 0x4   // Bit ENDTX.
	SSC_IER_TXBUFE_Pos  = 0x3   // Position of TXBUFE field.
	SSC_IER_TXBUFE_Msk  = 0x8   // Bit mask of TXBUFE field.
	SSC_IER_TXBUFE      = 0x8   // Bit TXBUFE.
	SSC_IER_RXRDY_Pos   = 0x4   // Position of RXRDY field.
	SSC_IER_RXRDY_Msk   = 0x10  // Bit mask of RXRDY field.
	SSC_IER_RXRDY       = 0x10  // Bit RXRDY.
	SSC_IER_OVRUN_Pos   = 0x5   // Position of OVRUN field.
	SSC_IER_OVRUN_Msk   = 0x20  // Bit mask of OVRUN field.
	SSC_IER_OVRUN       = 0x20  // Bit OVRUN.
	SSC_IER_ENDRX_Pos   = 0x6   // Position of ENDRX field.
	SSC_IER_ENDRX_Msk   = 0x40  // Bit mask of ENDRX field.
	SSC_IER_ENDRX       = 0x40  // Bit ENDRX.
	SSC_IER_RXBUFF_Pos  = 0x7   // Position of RXBUFF field.
	SSC_IER_RXBUFF_Msk  = 0x80  // Bit mask of RXBUFF field.
	SSC_IER_RXBUFF      = 0x80  // Bit RXBUFF.
	SSC_IER_CP0_Pos     = 0x8   // Position of CP0 field.
	SSC_IER_CP0_Msk     = 0x100 // Bit mask of CP0 field.
	SSC_IER_CP0         = 0x100 // Bit CP0.
	SSC_IER_CP1_Pos     = 0x9   // Position of CP1 field.
	SSC_IER_CP1_Msk     = 0x200 // Bit mask of CP1 field.
	SSC_IER_CP1         = 0x200 // Bit CP1.
	SSC_IER_TXSYN_Pos   = 0xa   // Position of TXSYN field.
	SSC_IER_TXSYN_Msk   = 0x400 // Bit mask of TXSYN field.
	SSC_IER_TXSYN       = 0x400 // Bit TXSYN.
	SSC_IER_RXSYN_Pos   = 0xb   // Position of RXSYN field.
	SSC_IER_RXSYN_Msk   = 0x800 // Bit mask of RXSYN field.
	SSC_IER_RXSYN       = 0x800 // Bit RXSYN.

	// IDR: Interrupt Disable Register
	SSC_IDR_TXRDY_Pos   = 0x0   // Position of TXRDY field.
	SSC_IDR_TXRDY_Msk   = 0x1   // Bit mask of TXRDY field.
	SSC_IDR_TXRDY       = 0x1   // Bit TXRDY.
	SSC_IDR_TXEMPTY_Pos = 0x1   // Position of TXEMPTY field.
	SSC_IDR_TXEMPTY_Msk = 0x2   // Bit mask of TXEMPTY field.
	SSC_IDR_TXEMPTY     = 0x2   // Bit TXEMPTY.
	SSC_IDR_ENDTX_Pos   = 0x2   // Position of ENDTX field.
	SSC_IDR_ENDTX_Msk   = 0x4   // Bit mask of ENDTX field.
	SSC_IDR_ENDTX       = 0x4   // Bit ENDTX.
	SSC_IDR_TXBUFE_Pos  = 0x3   // Position of TXBUFE field.
	SSC_IDR_TXBUFE_Msk  = 0x8   // Bit mask of TXBUFE field.
	SSC_IDR_TXBUFE      = 0x8   // Bit TXBUFE.
	SSC_IDR_RXRDY_Pos   = 0x4   // Position of RXRDY field.
	SSC_IDR_RXRDY_Msk   = 0x10  // Bit mask of RXRDY field.
	SSC_IDR_RXRDY       = 0x10  // Bit RXRDY.
	SSC_IDR_OVRUN_Pos   = 0x5   // Position of OVRUN field.
	SSC_IDR_OVRUN_Msk   = 0x20  // Bit mask of OVRUN field.
	SSC_IDR_OVRUN       = 0x20  // Bit OVRUN.
	SSC_IDR_ENDRX_Pos   = 0x6   // Position of ENDRX field.
	SSC_IDR_ENDRX_Msk   = 0x40  // Bit mask of ENDRX field.
	SSC_IDR_ENDRX       = 0x40  // Bit ENDRX.
	SSC_IDR_RXBUFF_Pos  = 0x7   // Position of RXBUFF field.
	SSC_IDR_RXBUFF_Msk  = 0x80  // Bit mask of RXBUFF field.
	SSC_IDR_RXBUFF      = 0x80  // Bit RXBUFF.
	SSC_IDR_CP0_Pos     = 0x8   // Position of CP0 field.
	SSC_IDR_CP0_Msk     = 0x100 // Bit mask of CP0 field.
	SSC_IDR_CP0         = 0x100 // Bit CP0.
	SSC_IDR_CP1_Pos     = 0x9   // Position of CP1 field.
	SSC_IDR_CP1_Msk     = 0x200 // Bit mask of CP1 field.
	SSC_IDR_CP1         = 0x200 // Bit CP1.
	SSC_IDR_TXSYN_Pos   = 0xa   // Position of TXSYN field.
	SSC_IDR_TXSYN_Msk   = 0x400 // Bit mask of TXSYN field.
	SSC_IDR_TXSYN       = 0x400 // Bit TXSYN.
	SSC_IDR_RXSYN_Pos   = 0xb   // Position of RXSYN field.
	SSC_IDR_RXSYN_Msk   = 0x800 // Bit mask of RXSYN field.
	SSC_IDR_RXSYN       = 0x800 // Bit RXSYN.

	// IMR: Interrupt Mask Register
	SSC_IMR_TXRDY_Pos   = 0x0   // Position of TXRDY field.
	SSC_IMR_TXRDY_Msk   = 0x1   // Bit mask of TXRDY field.
	SSC_IMR_TXRDY       = 0x1   // Bit TXRDY.
	SSC_IMR_TXEMPTY_Pos = 0x1   // Position of TXEMPTY field.
	SSC_IMR_TXEMPTY_Msk = 0x2   // Bit mask of TXEMPTY field.
	SSC_IMR_TXEMPTY     = 0x2   // Bit TXEMPTY.
	SSC_IMR_ENDTX_Pos   = 0x2   // Position of ENDTX field.
	SSC_IMR_ENDTX_Msk   = 0x4   // Bit mask of ENDTX field.
	SSC_IMR_ENDTX       = 0x4   // Bit ENDTX.
	SSC_IMR_TXBUFE_Pos  = 0x3   // Position of TXBUFE field.
	SSC_IMR_TXBUFE_Msk  = 0x8   // Bit mask of TXBUFE field.
	SSC_IMR_TXBUFE      = 0x8   // Bit TXBUFE.
	SSC_IMR_RXRDY_Pos   = 0x4   // Position of RXRDY field.
	SSC_IMR_RXRDY_Msk   = 0x10  // Bit mask of RXRDY field.
	SSC_IMR_RXRDY       = 0x10  // Bit RXRDY.
	SSC_IMR_OVRUN_Pos   = 0x5   // Position of OVRUN field.
	SSC_IMR_OVRUN_Msk   = 0x20  // Bit mask of OVRUN field.
	SSC_IMR_OVRUN       = 0x20  // Bit OVRUN.
	SSC_IMR_ENDRX_Pos   = 0x6   // Position of ENDRX field.
	SSC_IMR_ENDRX_Msk   = 0x40  // Bit mask of ENDRX field.
	SSC_IMR_ENDRX       = 0x40  // Bit ENDRX.
	SSC_IMR_RXBUFF_Pos  = 0x7   // Position of RXBUFF field.
	SSC_IMR_RXBUFF_Msk  = 0x80  // Bit mask of RXBUFF field.
	SSC_IMR_RXBUFF      = 0x80  // Bit RXBUFF.
	SSC_IMR_CP0_Pos     = 0x8   // Position of CP0 field.
	SSC_IMR_CP0_Msk     = 0x100 // Bit mask of CP0 field.
	SSC_IMR_CP0         = 0x100 // Bit CP0.
	SSC_IMR_CP1_Pos     = 0x9   // Position of CP1 field.
	SSC_IMR_CP1_Msk     = 0x200 // Bit mask of CP1 field.
	SSC_IMR_CP1         = 0x200 // Bit CP1.
	SSC_IMR_TXSYN_Pos   = 0xa   // Position of TXSYN field.
	SSC_IMR_TXSYN_Msk   = 0x400 // Bit mask of TXSYN field.
	SSC_IMR_TXSYN       = 0x400 // Bit TXSYN.
	SSC_IMR_RXSYN_Pos   = 0xb   // Position of RXSYN field.
	SSC_IMR_RXSYN_Msk   = 0x800 // Bit mask of RXSYN field.
	SSC_IMR_RXSYN       = 0x800 // Bit RXSYN.

	// RPR: Receive Pointer Register
	SSC_RPR_RXPTR_Pos = 0x0        // Position of RXPTR field.
	SSC_RPR_RXPTR_Msk = 0xffffffff // Bit mask of RXPTR field.

	// RCR: Receive Counter Register
	SSC_RCR_RXCTR_Pos = 0x0    // Position of RXCTR field.
	SSC_RCR_RXCTR_Msk = 0xffff // Bit mask of RXCTR field.

	// TPR: Transmit Pointer Register
	SSC_TPR_TXPTR_Pos = 0x0        // Position of TXPTR field.
	SSC_TPR_TXPTR_Msk = 0xffffffff // Bit mask of TXPTR field.

	// TCR: Transmit Counter Register
	SSC_TCR_TXCTR_Pos = 0x0    // Position of TXCTR field.
	SSC_TCR_TXCTR_Msk = 0xffff // Bit mask of TXCTR field.

	// RNPR: Receive Next Pointer Register
	SSC_RNPR_RXNPTR_Pos = 0x0        // Position of RXNPTR field.
	SSC_RNPR_RXNPTR_Msk = 0xffffffff // Bit mask of RXNPTR field.

	// RNCR: Receive Next Counter Register
	SSC_RNCR_RXNCTR_Pos = 0x0    // Position of RXNCTR field.
	SSC_RNCR_RXNCTR_Msk = 0xffff // Bit mask of RXNCTR field.

	// TNPR: Transmit Next Pointer Register
	SSC_TNPR_TXNPTR_Pos = 0x0        // Position of TXNPTR field.
	SSC_TNPR_TXNPTR_Msk = 0xffffffff // Bit mask of TXNPTR field.

	// TNCR: Transmit Next Counter Register
	SSC_TNCR_TXNCTR_Pos = 0x0    // Position of TXNCTR field.
	SSC_TNCR_TXNCTR_Msk = 0xffff // Bit mask of TXNCTR field.

	// PTCR: Transfer Control Register
	SSC_PTCR_RXTEN_Pos  = 0x0   // Position of RXTEN field.
	SSC_PTCR_RXTEN_Msk  = 0x1   // Bit mask of RXTEN field.
	SSC_PTCR_RXTEN      = 0x1   // Bit RXTEN.
	SSC_PTCR_RXTDIS_Pos = 0x1   // Position of RXTDIS field.
	SSC_PTCR_RXTDIS_Msk = 0x2   // Bit mask of RXTDIS field.
	SSC_PTCR_RXTDIS     = 0x2   // Bit RXTDIS.
	SSC_PTCR_TXTEN_Pos  = 0x8   // Position of TXTEN field.
	SSC_PTCR_TXTEN_Msk  = 0x100 // Bit mask of TXTEN field.
	SSC_PTCR_TXTEN      = 0x100 // Bit TXTEN.
	SSC_PTCR_TXTDIS_Pos = 0x9   // Position of TXTDIS field.
	SSC_PTCR_TXTDIS_Msk = 0x200 // Bit mask of TXTDIS field.
	SSC_PTCR_TXTDIS     = 0x200 // Bit TXTDIS.

	// PTSR: Transfer Status Register
	SSC_PTSR_RXTEN_Pos = 0x0   // Position of RXTEN field.
	SSC_PTSR_RXTEN_Msk = 0x1   // Bit mask of RXTEN field.
	SSC_PTSR_RXTEN     = 0x1   // Bit RXTEN.
	SSC_PTSR_TXTEN_Pos = 0x8   // Position of TXTEN field.
	SSC_PTSR_TXTEN_Msk = 0x100 // Bit mask of TXTEN field.
	SSC_PTSR_TXTEN     = 0x100 // Bit TXTEN.
)

// Bitfields for SPI0: Serial Peripheral Interface 0
const (
	// CR: Control Register
	SPI_CR_SPIEN_Pos    = 0x0       // Position of SPIEN field.
	SPI_CR_SPIEN_Msk    = 0x1       // Bit mask of SPIEN field.
	SPI_CR_SPIEN        = 0x1       // Bit SPIEN.
	SPI_CR_SPIDIS_Pos   = 0x1       // Position of SPIDIS field.
	SPI_CR_SPIDIS_Msk   = 0x2       // Bit mask of SPIDIS field.
	SPI_CR_SPIDIS       = 0x2       // Bit SPIDIS.
	SPI_CR_SWRST_Pos    = 0x7       // Position of SWRST field.
	SPI_CR_SWRST_Msk    = 0x80      // Bit mask of SWRST field.
	SPI_CR_SWRST        = 0x80      // Bit SWRST.
	SPI_CR_LASTXFER_Pos = 0x18      // Position of LASTXFER field.
	SPI_CR_LASTXFER_Msk = 0x1000000 // Bit mask of LASTXFER field.
	SPI_CR_LASTXFER     = 0x1000000 // Bit LASTXFER.

	// MR: Mode Register
	SPI_MR_MSTR_Pos    = 0x0        // Position of MSTR field.
	SPI_MR_MSTR_Msk    = 0x1        // Bit mask of MSTR field.
	SPI_MR_MSTR        = 0x1        // Bit MSTR.
	SPI_MR_PS_Pos      = 0x1        // Position of PS field.
	SPI_MR_PS_Msk      = 0x2        // Bit mask of PS field.
	SPI_MR_PS          = 0x2        // Bit PS.
	SPI_MR_PCSDEC_Pos  = 0x2        // Position of PCSDEC field.
	SPI_MR_PCSDEC_Msk  = 0x4        // Bit mask of PCSDEC field.
	SPI_MR_PCSDEC      = 0x4        // Bit PCSDEC.
	SPI_MR_MODFDIS_Pos = 0x4        // Position of MODFDIS field.
	SPI_MR_MODFDIS_Msk = 0x10       // Bit mask of MODFDIS field.
	SPI_MR_MODFDIS     = 0x10       // Bit MODFDIS.
	SPI_MR_WDRBT_Pos   = 0x5        // Position of WDRBT field.
	SPI_MR_WDRBT_Msk   = 0x20       // Bit mask of WDRBT field.
	SPI_MR_WDRBT       = 0x20       // Bit WDRBT.
	SPI_MR_LLB_Pos     = 0x7        // Position of LLB field.
	SPI_MR_LLB_Msk     = 0x80       // Bit mask of LLB field.
	SPI_MR_LLB         = 0x80       // Bit LLB.
	SPI_MR_PCS_Pos     = 0x10       // Position of PCS field.
	SPI_MR_PCS_Msk     = 0xf0000    // Bit mask of PCS field.
	SPI_MR_DLYBCS_Pos  = 0x18       // Position of DLYBCS field.
	SPI_MR_DLYBCS_Msk  = 0xff000000 // Bit mask of DLYBCS field.

	// RDR: Receive Data Register
	SPI_RDR_RD_Pos  = 0x0     // Position of RD field.
	SPI_RDR_RD_Msk  = 0xffff  // Bit mask of RD field.
	SPI_RDR_PCS_Pos = 0x10    // Position of PCS field.
	SPI_RDR_PCS_Msk = 0xf0000 // Bit mask of PCS field.

	// TDR: Transmit Data Register
	SPI_TDR_TD_Pos       = 0x0       // Position of TD field.
	SPI_TDR_TD_Msk       = 0xffff    // Bit mask of TD field.
	SPI_TDR_PCS_Pos      = 0x10      // Position of PCS field.
	SPI_TDR_PCS_Msk      = 0xf0000   // Bit mask of PCS field.
	SPI_TDR_LASTXFER_Pos = 0x18      // Position of LASTXFER field.
	SPI_TDR_LASTXFER_Msk = 0x1000000 // Bit mask of LASTXFER field.
	SPI_TDR_LASTXFER     = 0x1000000 // Bit LASTXFER.

	// SR: Status Register
	SPI_SR_RDRF_Pos    = 0x0     // Position of RDRF field.
	SPI_SR_RDRF_Msk    = 0x1     // Bit mask of RDRF field.
	SPI_SR_RDRF        = 0x1     // Bit RDRF.
	SPI_SR_TDRE_Pos    = 0x1     // Position of TDRE field.
	SPI_SR_TDRE_Msk    = 0x2     // Bit mask of TDRE field.
	SPI_SR_TDRE        = 0x2     // Bit TDRE.
	SPI_SR_MODF_Pos    = 0x2     // Position of MODF field.
	SPI_SR_MODF_Msk    = 0x4     // Bit mask of MODF field.
	SPI_SR_MODF        = 0x4     // Bit MODF.
	SPI_SR_OVRES_Pos   = 0x3     // Position of OVRES field.
	SPI_SR_OVRES_Msk   = 0x8     // Bit mask of OVRES field.
	SPI_SR_OVRES       = 0x8     // Bit OVRES.
	SPI_SR_ENDRX_Pos   = 0x4     // Position of ENDRX field.
	SPI_SR_ENDRX_Msk   = 0x10    // Bit mask of ENDRX field.
	SPI_SR_ENDRX       = 0x10    // Bit ENDRX.
	SPI_SR_ENDTX_Pos   = 0x5     // Position of ENDTX field.
	SPI_SR_ENDTX_Msk   = 0x20    // Bit mask of ENDTX field.
	SPI_SR_ENDTX       = 0x20    // Bit ENDTX.
	SPI_SR_RXBUFF_Pos  = 0x6     // Position of RXBUFF field.
	SPI_SR_RXBUFF_Msk  = 0x40    // Bit mask of RXBUFF field.
	SPI_SR_RXBUFF      = 0x40    // Bit RXBUFF.
	SPI_SR_TXBUFE_Pos  = 0x7     // Position of TXBUFE field.
	SPI_SR_TXBUFE_Msk  = 0x80    // Bit mask of TXBUFE field.
	SPI_SR_TXBUFE      = 0x80    // Bit TXBUFE.
	SPI_SR_NSSR_Pos    = 0x8     // Position of NSSR field.
	SPI_SR_NSSR_Msk    = 0x100   // Bit mask of NSSR field.
	SPI_SR_NSSR        = 0x100   // Bit NSSR.
	SPI_SR_TXEMPTY_Pos = 0x9     // Position of TXEMPTY field.
	SPI_SR_TXEMPTY_Msk = 0x200   // Bit mask of TXEMPTY field.
	SPI_SR_TXEMPTY     = 0x200   // Bit TXEMPTY.
	SPI_SR_SPIENS_Pos  = 0x10    // Position of SPIENS field.
	SPI_SR_SPIENS_Msk  = 0x10000 // Bit mask of SPIENS field.
	SPI_SR_SPIENS      = 0x10000 // Bit SPIENS.

	// IER: Interrupt Enable Register
	SPI_IER_RDRF_Pos    = 0x0   // Position of RDRF field.
	SPI_IER_RDRF_Msk    = 0x1   // Bit mask of RDRF field.
	SPI_IER_RDRF        = 0x1   // Bit RDRF.
	SPI_IER_TDRE_Pos    = 0x1   // Position of TDRE field.
	SPI_IER_TDRE_Msk    = 0x2   // Bit mask of TDRE field.
	SPI_IER_TDRE        = 0x2   // Bit TDRE.
	SPI_IER_MODF_Pos    = 0x2   // Position of MODF field.
	SPI_IER_MODF_Msk    = 0x4   // Bit mask of MODF field.
	SPI_IER_MODF        = 0x4   // Bit MODF.
	SPI_IER_OVRES_Pos   = 0x3   // Position of OVRES field.
	SPI_IER_OVRES_Msk   = 0x8   // Bit mask of OVRES field.
	SPI_IER_OVRES       = 0x8   // Bit OVRES.
	SPI_IER_ENDRX_Pos   = 0x4   // Position of ENDRX field.
	SPI_IER_ENDRX_Msk   = 0x10  // Bit mask of ENDRX field.
	SPI_IER_ENDRX       = 0x10  // Bit ENDRX.
	SPI_IER_ENDTX_Pos   = 0x5   // Position of ENDTX field.
	SPI_IER_ENDTX_Msk   = 0x20  // Bit mask of ENDTX field.
	SPI_IER_ENDTX       = 0x20  // Bit ENDTX.
	SPI_IER_RXBUFF_Pos  = 0x6   // Position of RXBUFF field.
	SPI_IER_RXBUFF_Msk  = 0x40  // Bit mask of RXBUFF field.
	SPI_IER_RXBUFF      = 0x40  // Bit RXBUFF.
	SPI_IER_TXBUFE_Pos  = 0x7   // Position of TXBUFE field.
	SPI_IER_TXBUFE_Msk  = 0x80  // Bit mask of TXBUFE field.
	SPI_IER_TXBUFE      = 0x80  // Bit TXBUFE.
	SPI_IER_NSSR_Pos    = 0x8   // Position of NSSR field.
	SPI_IER_NSSR_Msk    = 0x100 // Bit mask of NSSR field.
	SPI_IER_NSSR        = 0x100 // Bit NSSR.
	SPI_IER_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	SPI_IER_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	SPI_IER_TXEMPTY     = 0x200 // Bit TXEMPTY.

	// IDR: Interrupt Disable Register
	SPI_IDR_RDRF_Pos    = 0x0   // Position of RDRF field.
	SPI_IDR_RDRF_Msk    = 0x1   // Bit mask of RDRF field.
	SPI_IDR_RDRF        = 0x1   // Bit RDRF.
	SPI_IDR_TDRE_Pos    = 0x1   // Position of TDRE field.
	SPI_IDR_TDRE_Msk    = 0x2   // Bit mask of TDRE field.
	SPI_IDR_TDRE        = 0x2   // Bit TDRE.
	SPI_IDR_MODF_Pos    = 0x2   // Position of MODF field.
	SPI_IDR_MODF_Msk    = 0x4   // Bit mask of MODF field.
	SPI_IDR_MODF        = 0x4   // Bit MODF.
	SPI_IDR_OVRES_Pos   = 0x3   // Position of OVRES field.
	SPI_IDR_OVRES_Msk   = 0x8   // Bit mask of OVRES field.
	SPI_IDR_OVRES       = 0x8   // Bit OVRES.
	SPI_IDR_ENDRX_Pos   = 0x4   // Position of ENDRX field.
	SPI_IDR_ENDRX_Msk   = 0x10  // Bit mask of ENDRX field.
	SPI_IDR_ENDRX       = 0x10  // Bit ENDRX.
	SPI_IDR_ENDTX_Pos   = 0x5   // Position of ENDTX field.
	SPI_IDR_ENDTX_Msk   = 0x20  // Bit mask of ENDTX field.
	SPI_IDR_ENDTX       = 0x20  // Bit ENDTX.
	SPI_IDR_RXBUFF_Pos  = 0x6   // Position of RXBUFF field.
	SPI_IDR_RXBUFF_Msk  = 0x40  // Bit mask of RXBUFF field.
	SPI_IDR_RXBUFF      = 0x40  // Bit RXBUFF.
	SPI_IDR_TXBUFE_Pos  = 0x7   // Position of TXBUFE field.
	SPI_IDR_TXBUFE_Msk  = 0x80  // Bit mask of TXBUFE field.
	SPI_IDR_TXBUFE      = 0x80  // Bit TXBUFE.
	SPI_IDR_NSSR_Pos    = 0x8   // Position of NSSR field.
	SPI_IDR_NSSR_Msk    = 0x100 // Bit mask of NSSR field.
	SPI_IDR_NSSR        = 0x100 // Bit NSSR.
	SPI_IDR_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	SPI_IDR_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	SPI_IDR_TXEMPTY     = 0x200 // Bit TXEMPTY.

	// IMR: Interrupt Mask Register
	SPI_IMR_RDRF_Pos    = 0x0   // Position of RDRF field.
	SPI_IMR_RDRF_Msk    = 0x1   // Bit mask of RDRF field.
	SPI_IMR_RDRF        = 0x1   // Bit RDRF.
	SPI_IMR_TDRE_Pos    = 0x1   // Position of TDRE field.
	SPI_IMR_TDRE_Msk    = 0x2   // Bit mask of TDRE field.
	SPI_IMR_TDRE        = 0x2   // Bit TDRE.
	SPI_IMR_MODF_Pos    = 0x2   // Position of MODF field.
	SPI_IMR_MODF_Msk    = 0x4   // Bit mask of MODF field.
	SPI_IMR_MODF        = 0x4   // Bit MODF.
	SPI_IMR_OVRES_Pos   = 0x3   // Position of OVRES field.
	SPI_IMR_OVRES_Msk   = 0x8   // Bit mask of OVRES field.
	SPI_IMR_OVRES       = 0x8   // Bit OVRES.
	SPI_IMR_ENDRX_Pos   = 0x4   // Position of ENDRX field.
	SPI_IMR_ENDRX_Msk   = 0x10  // Bit mask of ENDRX field.
	SPI_IMR_ENDRX       = 0x10  // Bit ENDRX.
	SPI_IMR_ENDTX_Pos   = 0x5   // Position of ENDTX field.
	SPI_IMR_ENDTX_Msk   = 0x20  // Bit mask of ENDTX field.
	SPI_IMR_ENDTX       = 0x20  // Bit ENDTX.
	SPI_IMR_RXBUFF_Pos  = 0x6   // Position of RXBUFF field.
	SPI_IMR_RXBUFF_Msk  = 0x40  // Bit mask of RXBUFF field.
	SPI_IMR_RXBUFF      = 0x40  // Bit RXBUFF.
	SPI_IMR_TXBUFE_Pos  = 0x7   // Position of TXBUFE field.
	SPI_IMR_TXBUFE_Msk  = 0x80  // Bit mask of TXBUFE field.
	SPI_IMR_TXBUFE      = 0x80  // Bit TXBUFE.
	SPI_IMR_NSSR_Pos    = 0x8   // Position of NSSR field.
	SPI_IMR_NSSR_Msk    = 0x100 // Bit mask of NSSR field.
	SPI_IMR_NSSR        = 0x100 // Bit NSSR.
	SPI_IMR_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	SPI_IMR_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	SPI_IMR_TXEMPTY     = 0x200 // Bit TXEMPTY.

	// CSR: Chip Select Register
	SPI_CSR_CPOL_Pos    = 0x0        // Position of CPOL field.
	SPI_CSR_CPOL_Msk    = 0x1        // Bit mask of CPOL field.
	SPI_CSR_CPOL        = 0x1        // Bit CPOL.
	SPI_CSR_NCPHA_Pos   = 0x1        // Position of NCPHA field.
	SPI_CSR_NCPHA_Msk   = 0x2        // Bit mask of NCPHA field.
	SPI_CSR_NCPHA       = 0x2        // Bit NCPHA.
	SPI_CSR_CSAAT_Pos   = 0x3        // Position of CSAAT field.
	SPI_CSR_CSAAT_Msk   = 0x8        // Bit mask of CSAAT field.
	SPI_CSR_CSAAT       = 0x8        // Bit CSAAT.
	SPI_CSR_BITS_Pos    = 0x4        // Position of BITS field.
	SPI_CSR_BITS_Msk    = 0xf0       // Bit mask of BITS field.
	SPI_CSR_BITS_8_BIT  = 0x0        // 8 bits for transfer
	SPI_CSR_BITS_9_BIT  = 0x1        // 9 bits for transfer
	SPI_CSR_BITS_10_BIT = 0x2        // 10 bits for transfer
	SPI_CSR_BITS_11_BIT = 0x3        // 11 bits for transfer
	SPI_CSR_BITS_12_BIT = 0x4        // 12 bits for transfer
	SPI_CSR_BITS_13_BIT = 0x5        // 13 bits for transfer
	SPI_CSR_BITS_14_BIT = 0x6        // 14 bits for transfer
	SPI_CSR_BITS_15_BIT = 0x7        // 15 bits for transfer
	SPI_CSR_BITS_16_BIT = 0x8        // 16 bits for transfer
	SPI_CSR_SCBR_Pos    = 0x8        // Position of SCBR field.
	SPI_CSR_SCBR_Msk    = 0xff00     // Bit mask of SCBR field.
	SPI_CSR_DLYBS_Pos   = 0x10       // Position of DLYBS field.
	SPI_CSR_DLYBS_Msk   = 0xff0000   // Bit mask of DLYBS field.
	SPI_CSR_DLYBCT_Pos  = 0x18       // Position of DLYBCT field.
	SPI_CSR_DLYBCT_Msk  = 0xff000000 // Bit mask of DLYBCT field.

	// RPR: Receive Pointer Register
	SPI_RPR_RXPTR_Pos = 0x0        // Position of RXPTR field.
	SPI_RPR_RXPTR_Msk = 0xffffffff // Bit mask of RXPTR field.

	// RCR: Receive Counter Register
	SPI_RCR_RXCTR_Pos = 0x0    // Position of RXCTR field.
	SPI_RCR_RXCTR_Msk = 0xffff // Bit mask of RXCTR field.

	// TPR: Transmit Pointer Register
	SPI_TPR_TXPTR_Pos = 0x0        // Position of TXPTR field.
	SPI_TPR_TXPTR_Msk = 0xffffffff // Bit mask of TXPTR field.

	// TCR: Transmit Counter Register
	SPI_TCR_TXCTR_Pos = 0x0    // Position of TXCTR field.
	SPI_TCR_TXCTR_Msk = 0xffff // Bit mask of TXCTR field.

	// RNPR: Receive Next Pointer Register
	SPI_RNPR_RXNPTR_Pos = 0x0        // Position of RXNPTR field.
	SPI_RNPR_RXNPTR_Msk = 0xffffffff // Bit mask of RXNPTR field.

	// RNCR: Receive Next Counter Register
	SPI_RNCR_RXNCTR_Pos = 0x0    // Position of RXNCTR field.
	SPI_RNCR_RXNCTR_Msk = 0xffff // Bit mask of RXNCTR field.

	// TNPR: Transmit Next Pointer Register
	SPI_TNPR_TXNPTR_Pos = 0x0        // Position of TXNPTR field.
	SPI_TNPR_TXNPTR_Msk = 0xffffffff // Bit mask of TXNPTR field.

	// TNCR: Transmit Next Counter Register
	SPI_TNCR_TXNCTR_Pos = 0x0    // Position of TXNCTR field.
	SPI_TNCR_TXNCTR_Msk = 0xffff // Bit mask of TXNCTR field.

	// PTCR: Transfer Control Register
	SPI_PTCR_RXTEN_Pos  = 0x0   // Position of RXTEN field.
	SPI_PTCR_RXTEN_Msk  = 0x1   // Bit mask of RXTEN field.
	SPI_PTCR_RXTEN      = 0x1   // Bit RXTEN.
	SPI_PTCR_RXTDIS_Pos = 0x1   // Position of RXTDIS field.
	SPI_PTCR_RXTDIS_Msk = 0x2   // Bit mask of RXTDIS field.
	SPI_PTCR_RXTDIS     = 0x2   // Bit RXTDIS.
	SPI_PTCR_TXTEN_Pos  = 0x8   // Position of TXTEN field.
	SPI_PTCR_TXTEN_Msk  = 0x100 // Bit mask of TXTEN field.
	SPI_PTCR_TXTEN      = 0x100 // Bit TXTEN.
	SPI_PTCR_TXTDIS_Pos = 0x9   // Position of TXTDIS field.
	SPI_PTCR_TXTDIS_Msk = 0x200 // Bit mask of TXTDIS field.
	SPI_PTCR_TXTDIS     = 0x200 // Bit TXTDIS.

	// PTSR: Transfer Status Register
	SPI_PTSR_RXTEN_Pos = 0x0   // Position of RXTEN field.
	SPI_PTSR_RXTEN_Msk = 0x1   // Bit mask of RXTEN field.
	SPI_PTSR_RXTEN     = 0x1   // Bit RXTEN.
	SPI_PTSR_TXTEN_Pos = 0x8   // Position of TXTEN field.
	SPI_PTSR_TXTEN_Msk = 0x100 // Bit mask of TXTEN field.
	SPI_PTSR_TXTEN     = 0x100 // Bit TXTEN.
)

// Bitfields for AC97C: AC97 Controller
const (
	// MR: Mode Register
	AC97C_MR_ENA_Pos  = 0x0 // Position of ENA field.
	AC97C_MR_ENA_Msk  = 0x1 // Bit mask of ENA field.
	AC97C_MR_ENA      = 0x1 // Bit ENA.
	AC97C_MR_WRST_Pos = 0x1 // Position of WRST field.
	AC97C_MR_WRST_Msk = 0x2 // Bit mask of WRST field.
	AC97C_MR_WRST     = 0x2 // Bit WRST.
	AC97C_MR_VRA_Pos  = 0x2 // Position of VRA field.
	AC97C_MR_VRA_Msk  = 0x4 // Bit mask of VRA field.
	AC97C_MR_VRA      = 0x4 // Bit VRA.

	// ICA: Input Channel Assignment Register
	AC97C_ICA_CHID3_Pos  = 0x0        // Position of CHID3 field.
	AC97C_ICA_CHID3_Msk  = 0x7        // Bit mask of CHID3 field.
	AC97C_ICA_CHID4_Pos  = 0x3        // Position of CHID4 field.
	AC97C_ICA_CHID4_Msk  = 0x38       // Bit mask of CHID4 field.
	AC97C_ICA_CHID5_Pos  = 0x6        // Position of CHID5 field.
	AC97C_ICA_CHID5_Msk  = 0x1c0      // Bit mask of CHID5 field.
	AC97C_ICA_CHID6_Pos  = 0x9        // Position of CHID6 field.
	AC97C_ICA_CHID6_Msk  = 0xe00      // Bit mask of CHID6 field.
	AC97C_ICA_CHID7_Pos  = 0xc        // Position of CHID7 field.
	AC97C_ICA_CHID7_Msk  = 0x7000     // Bit mask of CHID7 field.
	AC97C_ICA_CHID8_Pos  = 0xf        // Position of CHID8 field.
	AC97C_ICA_CHID8_Msk  = 0x38000    // Bit mask of CHID8 field.
	AC97C_ICA_CHID9_Pos  = 0x12       // Position of CHID9 field.
	AC97C_ICA_CHID9_Msk  = 0x1c0000   // Bit mask of CHID9 field.
	AC97C_ICA_CHID10_Pos = 0x15       // Position of CHID10 field.
	AC97C_ICA_CHID10_Msk = 0xe00000   // Bit mask of CHID10 field.
	AC97C_ICA_CHID11_Pos = 0x18       // Position of CHID11 field.
	AC97C_ICA_CHID11_Msk = 0x7000000  // Bit mask of CHID11 field.
	AC97C_ICA_CHID12_Pos = 0x1b       // Position of CHID12 field.
	AC97C_ICA_CHID12_Msk = 0x38000000 // Bit mask of CHID12 field.

	// OCA: Output Channel Assignment Register
	AC97C_OCA_CHID3_Pos  = 0x0        // Position of CHID3 field.
	AC97C_OCA_CHID3_Msk  = 0x7        // Bit mask of CHID3 field.
	AC97C_OCA_CHID4_Pos  = 0x3        // Position of CHID4 field.
	AC97C_OCA_CHID4_Msk  = 0x38       // Bit mask of CHID4 field.
	AC97C_OCA_CHID5_Pos  = 0x6        // Position of CHID5 field.
	AC97C_OCA_CHID5_Msk  = 0x1c0      // Bit mask of CHID5 field.
	AC97C_OCA_CHID6_Pos  = 0x9        // Position of CHID6 field.
	AC97C_OCA_CHID6_Msk  = 0xe00      // Bit mask of CHID6 field.
	AC97C_OCA_CHID7_Pos  = 0xc        // Position of CHID7 field.
	AC97C_OCA_CHID7_Msk  = 0x7000     // Bit mask of CHID7 field.
	AC97C_OCA_CHID8_Pos  = 0xf        // Position of CHID8 field.
	AC97C_OCA_CHID8_Msk  = 0x38000    // Bit mask of CHID8 field.
	AC97C_OCA_CHID9_Pos  = 0x12       // Position of CHID9 field.
	AC97C_OCA_CHID9_Msk  = 0x1c0000   // Bit mask of CHID9 field.
	AC97C_OCA_CHID10_Pos = 0x15       // Position of CHID10 field.
	AC97C_OCA_CHID10_Msk = 0xe00000   // Bit mask of CHID10 field.
	AC97C_OCA_CHID11_Pos = 0x18       // Position of CHID11 field.
	AC97C_OCA_CHID11_Msk = 0x7000000  // Bit mask of CHID11 field.
	AC97C_OCA_CHID12_Pos = 0x1b       // Position of CHID12 field.
	AC97C_OCA_CHID12_Msk = 0x38000000 // Bit mask of CHID12 field.

	// CARHR: Channel A Receive Holding Register
	AC97C_CARHR_RDATA_Pos = 0x0     // Position of RDATA field.
	AC97C_CARHR_RDATA_Msk = 0xfffff // Bit mask of RDATA field.

	// CATHR: Channel A Transmit Holding Register
	AC97C_CATHR_TDATA_Pos = 0x0     // Position of TDATA field.
	AC97C_CATHR_TDATA_Msk = 0xfffff // Bit mask of TDATA field.

	// CASR: Channel A Status Register
	AC97C_CASR_TXRDY_Pos   = 0x0    // Position of TXRDY field.
	AC97C_CASR_TXRDY_Msk   = 0x1    // Bit mask of TXRDY field.
	AC97C_CASR_TXRDY       = 0x1    // Bit TXRDY.
	AC97C_CASR_TXEMPTY_Pos = 0x1    // Position of TXEMPTY field.
	AC97C_CASR_TXEMPTY_Msk = 0x2    // Bit mask of TXEMPTY field.
	AC97C_CASR_TXEMPTY     = 0x2    // Bit TXEMPTY.
	AC97C_CASR_UNRUN_Pos   = 0x2    // Position of UNRUN field.
	AC97C_CASR_UNRUN_Msk   = 0x4    // Bit mask of UNRUN field.
	AC97C_CASR_UNRUN       = 0x4    // Bit UNRUN.
	AC97C_CASR_RXRDY_Pos   = 0x4    // Position of RXRDY field.
	AC97C_CASR_RXRDY_Msk   = 0x10   // Bit mask of RXRDY field.
	AC97C_CASR_RXRDY       = 0x10   // Bit RXRDY.
	AC97C_CASR_OVRUN_Pos   = 0x5    // Position of OVRUN field.
	AC97C_CASR_OVRUN_Msk   = 0x20   // Bit mask of OVRUN field.
	AC97C_CASR_OVRUN       = 0x20   // Bit OVRUN.
	AC97C_CASR_ENDTX_Pos   = 0xa    // Position of ENDTX field.
	AC97C_CASR_ENDTX_Msk   = 0x400  // Bit mask of ENDTX field.
	AC97C_CASR_ENDTX       = 0x400  // Bit ENDTX.
	AC97C_CASR_TXBUFE_Pos  = 0xb    // Position of TXBUFE field.
	AC97C_CASR_TXBUFE_Msk  = 0x800  // Bit mask of TXBUFE field.
	AC97C_CASR_TXBUFE      = 0x800  // Bit TXBUFE.
	AC97C_CASR_ENDRX_Pos   = 0xe    // Position of ENDRX field.
	AC97C_CASR_ENDRX_Msk   = 0x4000 // Bit mask of ENDRX field.
	AC97C_CASR_ENDRX       = 0x4000 // Bit ENDRX.
	AC97C_CASR_RXBUFF_Pos  = 0xf    // Position of RXBUFF field.
	AC97C_CASR_RXBUFF_Msk  = 0x8000 // Bit mask of RXBUFF field.
	AC97C_CASR_RXBUFF      = 0x8000 // Bit RXBUFF.

	// CAMR: Channel A Mode Register
	AC97C_CAMR_TXRDY_Pos   = 0x0      // Position of TXRDY field.
	AC97C_CAMR_TXRDY_Msk   = 0x1      // Bit mask of TXRDY field.
	AC97C_CAMR_TXRDY       = 0x1      // Bit TXRDY.
	AC97C_CAMR_TXEMPTY_Pos = 0x1      // Position of TXEMPTY field.
	AC97C_CAMR_TXEMPTY_Msk = 0x2      // Bit mask of TXEMPTY field.
	AC97C_CAMR_TXEMPTY     = 0x2      // Bit TXEMPTY.
	AC97C_CAMR_UNRUN_Pos   = 0x2      // Position of UNRUN field.
	AC97C_CAMR_UNRUN_Msk   = 0x4      // Bit mask of UNRUN field.
	AC97C_CAMR_UNRUN       = 0x4      // Bit UNRUN.
	AC97C_CAMR_RXRDY_Pos   = 0x4      // Position of RXRDY field.
	AC97C_CAMR_RXRDY_Msk   = 0x10     // Bit mask of RXRDY field.
	AC97C_CAMR_RXRDY       = 0x10     // Bit RXRDY.
	AC97C_CAMR_OVRUN_Pos   = 0x5      // Position of OVRUN field.
	AC97C_CAMR_OVRUN_Msk   = 0x20     // Bit mask of OVRUN field.
	AC97C_CAMR_OVRUN       = 0x20     // Bit OVRUN.
	AC97C_CAMR_ENDTX_Pos   = 0xa      // Position of ENDTX field.
	AC97C_CAMR_ENDTX_Msk   = 0x400    // Bit mask of ENDTX field.
	AC97C_CAMR_ENDTX       = 0x400    // Bit ENDTX.
	AC97C_CAMR_TXBUFE_Pos  = 0xb      // Position of TXBUFE field.
	AC97C_CAMR_TXBUFE_Msk  = 0x800    // Bit mask of TXBUFE field.
	AC97C_CAMR_TXBUFE      = 0x800    // Bit TXBUFE.
	AC97C_CAMR_ENDRX_Pos   = 0xe      // Position of ENDRX field.
	AC97C_CAMR_ENDRX_Msk   = 0x4000   // Bit mask of ENDRX field.
	AC97C_CAMR_ENDRX       = 0x4000   // Bit ENDRX.
	AC97C_CAMR_RXBUFF_Pos  = 0xf      // Position of RXBUFF field.
	AC97C_CAMR_RXBUFF_Msk  = 0x8000   // Bit mask of RXBUFF field.
	AC97C_CAMR_RXBUFF      = 0x8000   // Bit RXBUFF.
	AC97C_CAMR_SIZE_Pos    = 0x10     // Position of SIZE field.
	AC97C_CAMR_SIZE_Msk    = 0x30000  // Bit mask of SIZE field.
	AC97C_CAMR_CEM_Pos     = 0x12     // Position of CEM field.
	AC97C_CAMR_CEM_Msk     = 0x40000  // Bit mask of CEM field.
	AC97C_CAMR_CEM         = 0x40000  // Bit CEM.
	AC97C_CAMR_CEN_Pos     = 0x15     // Position of CEN field.
	AC97C_CAMR_CEN_Msk     = 0x200000 // Bit mask of CEN field.
	AC97C_CAMR_CEN         = 0x200000 // Bit CEN.
	AC97C_CAMR_PDCEN_Pos   = 0x16     // Position of PDCEN field.
	AC97C_CAMR_PDCEN_Msk   = 0x400000 // Bit mask of PDCEN field.
	AC97C_CAMR_PDCEN       = 0x400000 // Bit PDCEN.

	// CBRHR: Channel B Receive Holding Register
	AC97C_CBRHR_RDATA_Pos = 0x0     // Position of RDATA field.
	AC97C_CBRHR_RDATA_Msk = 0xfffff // Bit mask of RDATA field.

	// CBTHR: Channel B Transmit Holding Register
	AC97C_CBTHR_TDATA_Pos = 0x0     // Position of TDATA field.
	AC97C_CBTHR_TDATA_Msk = 0xfffff // Bit mask of TDATA field.

	// CBSR: Channel B Status Register
	AC97C_CBSR_TXRDY_Pos   = 0x0    // Position of TXRDY field.
	AC97C_CBSR_TXRDY_Msk   = 0x1    // Bit mask of TXRDY field.
	AC97C_CBSR_TXRDY       = 0x1    // Bit TXRDY.
	AC97C_CBSR_TXEMPTY_Pos = 0x1    // Position of TXEMPTY field.
	AC97C_CBSR_TXEMPTY_Msk = 0x2    // Bit mask of TXEMPTY field.
	AC97C_CBSR_TXEMPTY     = 0x2    // Bit TXEMPTY.
	AC97C_CBSR_UNRUN_Pos   = 0x2    // Position of UNRUN field.
	AC97C_CBSR_UNRUN_Msk   = 0x4    // Bit mask of UNRUN field.
	AC97C_CBSR_UNRUN       = 0x4    // Bit UNRUN.
	AC97C_CBSR_RXRDY_Pos   = 0x4    // Position of RXRDY field.
	AC97C_CBSR_RXRDY_Msk   = 0x10   // Bit mask of RXRDY field.
	AC97C_CBSR_RXRDY       = 0x10   // Bit RXRDY.
	AC97C_CBSR_OVRUN_Pos   = 0x5    // Position of OVRUN field.
	AC97C_CBSR_OVRUN_Msk   = 0x20   // Bit mask of OVRUN field.
	AC97C_CBSR_OVRUN       = 0x20   // Bit OVRUN.
	AC97C_CBSR_ENDTX_Pos   = 0x9    // Position of ENDTX field.
	AC97C_CBSR_ENDTX_Msk   = 0x200  // Bit mask of ENDTX field.
	AC97C_CBSR_ENDTX       = 0x200  // Bit ENDTX.
	AC97C_CBSR_TXBUFE_Pos  = 0xa    // Position of TXBUFE field.
	AC97C_CBSR_TXBUFE_Msk  = 0x400  // Bit mask of TXBUFE field.
	AC97C_CBSR_TXBUFE      = 0x400  // Bit TXBUFE.
	AC97C_CBSR_ENDRX_Pos   = 0xe    // Position of ENDRX field.
	AC97C_CBSR_ENDRX_Msk   = 0x4000 // Bit mask of ENDRX field.
	AC97C_CBSR_ENDRX       = 0x4000 // Bit ENDRX.
	AC97C_CBSR_RXBUFF_Pos  = 0xf    // Position of RXBUFF field.
	AC97C_CBSR_RXBUFF_Msk  = 0x8000 // Bit mask of RXBUFF field.
	AC97C_CBSR_RXBUFF      = 0x8000 // Bit RXBUFF.

	// CBMR: Channel B Mode Register
	AC97C_CBMR_TXRDY_Pos   = 0x0      // Position of TXRDY field.
	AC97C_CBMR_TXRDY_Msk   = 0x1      // Bit mask of TXRDY field.
	AC97C_CBMR_TXRDY       = 0x1      // Bit TXRDY.
	AC97C_CBMR_TXEMPTY_Pos = 0x1      // Position of TXEMPTY field.
	AC97C_CBMR_TXEMPTY_Msk = 0x2      // Bit mask of TXEMPTY field.
	AC97C_CBMR_TXEMPTY     = 0x2      // Bit TXEMPTY.
	AC97C_CBMR_UNRUN_Pos   = 0x2      // Position of UNRUN field.
	AC97C_CBMR_UNRUN_Msk   = 0x4      // Bit mask of UNRUN field.
	AC97C_CBMR_UNRUN       = 0x4      // Bit UNRUN.
	AC97C_CBMR_RXRDY_Pos   = 0x4      // Position of RXRDY field.
	AC97C_CBMR_RXRDY_Msk   = 0x10     // Bit mask of RXRDY field.
	AC97C_CBMR_RXRDY       = 0x10     // Bit RXRDY.
	AC97C_CBMR_OVRUN_Pos   = 0x5      // Position of OVRUN field.
	AC97C_CBMR_OVRUN_Msk   = 0x20     // Bit mask of OVRUN field.
	AC97C_CBMR_OVRUN       = 0x20     // Bit OVRUN.
	AC97C_CBMR_ENDTX_Pos   = 0xa      // Position of ENDTX field.
	AC97C_CBMR_ENDTX_Msk   = 0x400    // Bit mask of ENDTX field.
	AC97C_CBMR_ENDTX       = 0x400    // Bit ENDTX.
	AC97C_CBMR_TXBUFE_Pos  = 0xb      // Position of TXBUFE field.
	AC97C_CBMR_TXBUFE_Msk  = 0x800    // Bit mask of TXBUFE field.
	AC97C_CBMR_TXBUFE      = 0x800    // Bit TXBUFE.
	AC97C_CBMR_ENDRX_Pos   = 0xe      // Position of ENDRX field.
	AC97C_CBMR_ENDRX_Msk   = 0x4000   // Bit mask of ENDRX field.
	AC97C_CBMR_ENDRX       = 0x4000   // Bit ENDRX.
	AC97C_CBMR_RXBUFF_Pos  = 0xf      // Position of RXBUFF field.
	AC97C_CBMR_RXBUFF_Msk  = 0x8000   // Bit mask of RXBUFF field.
	AC97C_CBMR_RXBUFF      = 0x8000   // Bit RXBUFF.
	AC97C_CBMR_SIZE_Pos    = 0x10     // Position of SIZE field.
	AC97C_CBMR_SIZE_Msk    = 0x30000  // Bit mask of SIZE field.
	AC97C_CBMR_CEM_Pos     = 0x12     // Position of CEM field.
	AC97C_CBMR_CEM_Msk     = 0x40000  // Bit mask of CEM field.
	AC97C_CBMR_CEM         = 0x40000  // Bit CEM.
	AC97C_CBMR_CEN_Pos     = 0x15     // Position of CEN field.
	AC97C_CBMR_CEN_Msk     = 0x200000 // Bit mask of CEN field.
	AC97C_CBMR_CEN         = 0x200000 // Bit CEN.
	AC97C_CBMR_PDCEN_Pos   = 0x16     // Position of PDCEN field.
	AC97C_CBMR_PDCEN_Msk   = 0x400000 // Bit mask of PDCEN field.
	AC97C_CBMR_PDCEN       = 0x400000 // Bit PDCEN.

	// CORHR: Codec Channel Receive Holding Register
	AC97C_CORHR_SDATA_Pos = 0x0    // Position of SDATA field.
	AC97C_CORHR_SDATA_Msk = 0xffff // Bit mask of SDATA field.

	// COTHR: Codec Channel Transmit Holding Register
	AC97C_COTHR_CDATA_Pos = 0x0      // Position of CDATA field.
	AC97C_COTHR_CDATA_Msk = 0xffff   // Bit mask of CDATA field.
	AC97C_COTHR_CADDR_Pos = 0x10     // Position of CADDR field.
	AC97C_COTHR_CADDR_Msk = 0x7f0000 // Bit mask of CADDR field.
	AC97C_COTHR_READ_Pos  = 0x17     // Position of READ field.
	AC97C_COTHR_READ_Msk  = 0x800000 // Bit mask of READ field.
	AC97C_COTHR_READ      = 0x800000 // Bit READ.

	// COSR: Codec Status Register
	AC97C_COSR_TXRDY_Pos   = 0x0  // Position of TXRDY field.
	AC97C_COSR_TXRDY_Msk   = 0x1  // Bit mask of TXRDY field.
	AC97C_COSR_TXRDY       = 0x1  // Bit TXRDY.
	AC97C_COSR_TXEMPTY_Pos = 0x1  // Position of TXEMPTY field.
	AC97C_COSR_TXEMPTY_Msk = 0x2  // Bit mask of TXEMPTY field.
	AC97C_COSR_TXEMPTY     = 0x2  // Bit TXEMPTY.
	AC97C_COSR_UNRUN_Pos   = 0x2  // Position of UNRUN field.
	AC97C_COSR_UNRUN_Msk   = 0x4  // Bit mask of UNRUN field.
	AC97C_COSR_UNRUN       = 0x4  // Bit UNRUN.
	AC97C_COSR_RXRDY_Pos   = 0x4  // Position of RXRDY field.
	AC97C_COSR_RXRDY_Msk   = 0x10 // Bit mask of RXRDY field.
	AC97C_COSR_RXRDY       = 0x10 // Bit RXRDY.
	AC97C_COSR_OVRUN_Pos   = 0x5  // Position of OVRUN field.
	AC97C_COSR_OVRUN_Msk   = 0x20 // Bit mask of OVRUN field.
	AC97C_COSR_OVRUN       = 0x20 // Bit OVRUN.

	// COMR: Codec Mode Register
	AC97C_COMR_TXRDY_Pos   = 0x0  // Position of TXRDY field.
	AC97C_COMR_TXRDY_Msk   = 0x1  // Bit mask of TXRDY field.
	AC97C_COMR_TXRDY       = 0x1  // Bit TXRDY.
	AC97C_COMR_TXEMPTY_Pos = 0x1  // Position of TXEMPTY field.
	AC97C_COMR_TXEMPTY_Msk = 0x2  // Bit mask of TXEMPTY field.
	AC97C_COMR_TXEMPTY     = 0x2  // Bit TXEMPTY.
	AC97C_COMR_UNRUN_Pos   = 0x2  // Position of UNRUN field.
	AC97C_COMR_UNRUN_Msk   = 0x4  // Bit mask of UNRUN field.
	AC97C_COMR_UNRUN       = 0x4  // Bit UNRUN.
	AC97C_COMR_RXRDY_Pos   = 0x4  // Position of RXRDY field.
	AC97C_COMR_RXRDY_Msk   = 0x10 // Bit mask of RXRDY field.
	AC97C_COMR_RXRDY       = 0x10 // Bit RXRDY.
	AC97C_COMR_OVRUN_Pos   = 0x5  // Position of OVRUN field.
	AC97C_COMR_OVRUN_Msk   = 0x20 // Bit mask of OVRUN field.
	AC97C_COMR_OVRUN       = 0x20 // Bit OVRUN.

	// SR: Status Register
	AC97C_SR_SOF_Pos   = 0x0  // Position of SOF field.
	AC97C_SR_SOF_Msk   = 0x1  // Bit mask of SOF field.
	AC97C_SR_SOF       = 0x1  // Bit SOF.
	AC97C_SR_WKUP_Pos  = 0x1  // Position of WKUP field.
	AC97C_SR_WKUP_Msk  = 0x2  // Bit mask of WKUP field.
	AC97C_SR_WKUP      = 0x2  // Bit WKUP.
	AC97C_SR_COEVT_Pos = 0x2  // Position of COEVT field.
	AC97C_SR_COEVT_Msk = 0x4  // Bit mask of COEVT field.
	AC97C_SR_COEVT     = 0x4  // Bit COEVT.
	AC97C_SR_CAEVT_Pos = 0x3  // Position of CAEVT field.
	AC97C_SR_CAEVT_Msk = 0x8  // Bit mask of CAEVT field.
	AC97C_SR_CAEVT     = 0x8  // Bit CAEVT.
	AC97C_SR_CBEVT_Pos = 0x4  // Position of CBEVT field.
	AC97C_SR_CBEVT_Msk = 0x10 // Bit mask of CBEVT field.
	AC97C_SR_CBEVT     = 0x10 // Bit CBEVT.

	// IER: Interrupt Enable Register
	AC97C_IER_SOF_Pos   = 0x0  // Position of SOF field.
	AC97C_IER_SOF_Msk   = 0x1  // Bit mask of SOF field.
	AC97C_IER_SOF       = 0x1  // Bit SOF.
	AC97C_IER_WKUP_Pos  = 0x1  // Position of WKUP field.
	AC97C_IER_WKUP_Msk  = 0x2  // Bit mask of WKUP field.
	AC97C_IER_WKUP      = 0x2  // Bit WKUP.
	AC97C_IER_COEVT_Pos = 0x2  // Position of COEVT field.
	AC97C_IER_COEVT_Msk = 0x4  // Bit mask of COEVT field.
	AC97C_IER_COEVT     = 0x4  // Bit COEVT.
	AC97C_IER_CAEVT_Pos = 0x3  // Position of CAEVT field.
	AC97C_IER_CAEVT_Msk = 0x8  // Bit mask of CAEVT field.
	AC97C_IER_CAEVT     = 0x8  // Bit CAEVT.
	AC97C_IER_CBEVT_Pos = 0x4  // Position of CBEVT field.
	AC97C_IER_CBEVT_Msk = 0x10 // Bit mask of CBEVT field.
	AC97C_IER_CBEVT     = 0x10 // Bit CBEVT.

	// IDR: Interrupt Disable Register
	AC97C_IDR_SOF_Pos   = 0x0  // Position of SOF field.
	AC97C_IDR_SOF_Msk   = 0x1  // Bit mask of SOF field.
	AC97C_IDR_SOF       = 0x1  // Bit SOF.
	AC97C_IDR_WKUP_Pos  = 0x1  // Position of WKUP field.
	AC97C_IDR_WKUP_Msk  = 0x2  // Bit mask of WKUP field.
	AC97C_IDR_WKUP      = 0x2  // Bit WKUP.
	AC97C_IDR_COEVT_Pos = 0x2  // Position of COEVT field.
	AC97C_IDR_COEVT_Msk = 0x4  // Bit mask of COEVT field.
	AC97C_IDR_COEVT     = 0x4  // Bit COEVT.
	AC97C_IDR_CAEVT_Pos = 0x3  // Position of CAEVT field.
	AC97C_IDR_CAEVT_Msk = 0x8  // Bit mask of CAEVT field.
	AC97C_IDR_CAEVT     = 0x8  // Bit CAEVT.
	AC97C_IDR_CBEVT_Pos = 0x4  // Position of CBEVT field.
	AC97C_IDR_CBEVT_Msk = 0x10 // Bit mask of CBEVT field.
	AC97C_IDR_CBEVT     = 0x10 // Bit CBEVT.

	// IMR: Interrupt Mask Register
	AC97C_IMR_SOF_Pos   = 0x0  // Position of SOF field.
	AC97C_IMR_SOF_Msk   = 0x1  // Bit mask of SOF field.
	AC97C_IMR_SOF       = 0x1  // Bit SOF.
	AC97C_IMR_WKUP_Pos  = 0x1  // Position of WKUP field.
	AC97C_IMR_WKUP_Msk  = 0x2  // Bit mask of WKUP field.
	AC97C_IMR_WKUP      = 0x2  // Bit WKUP.
	AC97C_IMR_COEVT_Pos = 0x2  // Position of COEVT field.
	AC97C_IMR_COEVT_Msk = 0x4  // Bit mask of COEVT field.
	AC97C_IMR_COEVT     = 0x4  // Bit COEVT.
	AC97C_IMR_CAEVT_Pos = 0x3  // Position of CAEVT field.
	AC97C_IMR_CAEVT_Msk = 0x8  // Bit mask of CAEVT field.
	AC97C_IMR_CAEVT     = 0x8  // Bit CAEVT.
	AC97C_IMR_CBEVT_Pos = 0x4  // Position of CBEVT field.
	AC97C_IMR_CBEVT_Msk = 0x10 // Bit mask of CBEVT field.
	AC97C_IMR_CBEVT     = 0x10 // Bit CBEVT.

	// RPR: Receive Pointer Register
	AC97C_RPR_RXPTR_Pos = 0x0        // Position of RXPTR field.
	AC97C_RPR_RXPTR_Msk = 0xffffffff // Bit mask of RXPTR field.

	// RCR: Receive Counter Register
	AC97C_RCR_RXCTR_Pos = 0x0    // Position of RXCTR field.
	AC97C_RCR_RXCTR_Msk = 0xffff // Bit mask of RXCTR field.

	// TPR: Transmit Pointer Register
	AC97C_TPR_TXPTR_Pos = 0x0        // Position of TXPTR field.
	AC97C_TPR_TXPTR_Msk = 0xffffffff // Bit mask of TXPTR field.

	// TCR: Transmit Counter Register
	AC97C_TCR_TXCTR_Pos = 0x0    // Position of TXCTR field.
	AC97C_TCR_TXCTR_Msk = 0xffff // Bit mask of TXCTR field.

	// RNPR: Receive Next Pointer Register
	AC97C_RNPR_RXNPTR_Pos = 0x0        // Position of RXNPTR field.
	AC97C_RNPR_RXNPTR_Msk = 0xffffffff // Bit mask of RXNPTR field.

	// RNCR: Receive Next Counter Register
	AC97C_RNCR_RXNCTR_Pos = 0x0    // Position of RXNCTR field.
	AC97C_RNCR_RXNCTR_Msk = 0xffff // Bit mask of RXNCTR field.

	// TNPR: Transmit Next Pointer Register
	AC97C_TNPR_TXNPTR_Pos = 0x0        // Position of TXNPTR field.
	AC97C_TNPR_TXNPTR_Msk = 0xffffffff // Bit mask of TXNPTR field.

	// TNCR: Transmit Next Counter Register
	AC97C_TNCR_TXNCTR_Pos = 0x0    // Position of TXNCTR field.
	AC97C_TNCR_TXNCTR_Msk = 0xffff // Bit mask of TXNCTR field.

	// PTCR: Transfer Control Register
	AC97C_PTCR_RXTEN_Pos  = 0x0   // Position of RXTEN field.
	AC97C_PTCR_RXTEN_Msk  = 0x1   // Bit mask of RXTEN field.
	AC97C_PTCR_RXTEN      = 0x1   // Bit RXTEN.
	AC97C_PTCR_RXTDIS_Pos = 0x1   // Position of RXTDIS field.
	AC97C_PTCR_RXTDIS_Msk = 0x2   // Bit mask of RXTDIS field.
	AC97C_PTCR_RXTDIS     = 0x2   // Bit RXTDIS.
	AC97C_PTCR_TXTEN_Pos  = 0x8   // Position of TXTEN field.
	AC97C_PTCR_TXTEN_Msk  = 0x100 // Bit mask of TXTEN field.
	AC97C_PTCR_TXTEN      = 0x100 // Bit TXTEN.
	AC97C_PTCR_TXTDIS_Pos = 0x9   // Position of TXTDIS field.
	AC97C_PTCR_TXTDIS_Msk = 0x200 // Bit mask of TXTDIS field.
	AC97C_PTCR_TXTDIS     = 0x200 // Bit TXTDIS.

	// PTSR: Transfer Status Register
	AC97C_PTSR_RXTEN_Pos = 0x0   // Position of RXTEN field.
	AC97C_PTSR_RXTEN_Msk = 0x1   // Bit mask of RXTEN field.
	AC97C_PTSR_RXTEN     = 0x1   // Bit RXTEN.
	AC97C_PTSR_TXTEN_Pos = 0x8   // Position of TXTEN field.
	AC97C_PTSR_TXTEN_Msk = 0x100 // Bit mask of TXTEN field.
	AC97C_PTSR_TXTEN     = 0x100 // Bit TXTEN.
)

// Bitfields for TSADCC: Touch Screen ADC Controller
const (
	// CR: Control Register
	TSADCC_CR_SWRST_Pos = 0x0 // Position of SWRST field.
	TSADCC_CR_SWRST_Msk = 0x1 // Bit mask of SWRST field.
	TSADCC_CR_SWRST     = 0x1 // Bit SWRST.
	TSADCC_CR_START_Pos = 0x1 // Position of START field.
	TSADCC_CR_START_Msk = 0x2 // Bit mask of START field.
	TSADCC_CR_START     = 0x2 // Bit START.

	// MR: Mode Register
	TSADCC_MR_TSAMOD_Pos  = 0x0        // Position of TSAMOD field.
	TSADCC_MR_TSAMOD_Msk  = 0x3        // Bit mask of TSAMOD field.
	TSADCC_MR_PDCEN_Pos   = 0x3        // Position of PDCEN field.
	TSADCC_MR_PDCEN_Msk   = 0x8        // Bit mask of PDCEN field.
	TSADCC_MR_PDCEN       = 0x8        // Bit PDCEN.
	TSADCC_MR_LOWRES_Pos  = 0x4        // Position of LOWRES field.
	TSADCC_MR_LOWRES_Msk  = 0x10       // Bit mask of LOWRES field.
	TSADCC_MR_LOWRES      = 0x10       // Bit LOWRES.
	TSADCC_MR_SLEEP_Pos   = 0x5        // Position of SLEEP field.
	TSADCC_MR_SLEEP_Msk   = 0x20       // Bit mask of SLEEP field.
	TSADCC_MR_SLEEP       = 0x20       // Bit SLEEP.
	TSADCC_MR_PENDET_Pos  = 0x6        // Position of PENDET field.
	TSADCC_MR_PENDET_Msk  = 0x40       // Bit mask of PENDET field.
	TSADCC_MR_PENDET      = 0x40       // Bit PENDET.
	TSADCC_MR_PRES_Pos    = 0x7        // Position of PRES field.
	TSADCC_MR_PRES_Msk    = 0x80       // Bit mask of PRES field.
	TSADCC_MR_PRES        = 0x80       // Bit PRES.
	TSADCC_MR_PRESCAL_Pos = 0x8        // Position of PRESCAL field.
	TSADCC_MR_PRESCAL_Msk = 0xff00     // Bit mask of PRESCAL field.
	TSADCC_MR_STARTUP_Pos = 0x10       // Position of STARTUP field.
	TSADCC_MR_STARTUP_Msk = 0x7f0000   // Bit mask of STARTUP field.
	TSADCC_MR_SHTIM_Pos   = 0x18       // Position of SHTIM field.
	TSADCC_MR_SHTIM_Msk   = 0xf000000  // Bit mask of SHTIM field.
	TSADCC_MR_PENDBC_Pos  = 0x1c       // Position of PENDBC field.
	TSADCC_MR_PENDBC_Msk  = 0xf0000000 // Bit mask of PENDBC field.

	// TRGR: Trigger Register
	TSADCC_TRGR_TRGMOD_Pos = 0x0        // Position of TRGMOD field.
	TSADCC_TRGR_TRGMOD_Msk = 0x7        // Bit mask of TRGMOD field.
	TSADCC_TRGR_TRGPER_Pos = 0x10       // Position of TRGPER field.
	TSADCC_TRGR_TRGPER_Msk = 0xffff0000 // Bit mask of TRGPER field.

	// TSR: Touch Screen Register
	TSADCC_TSR_TSFREQ_Pos  = 0x0       // Position of TSFREQ field.
	TSADCC_TSR_TSFREQ_Msk  = 0xf       // Bit mask of TSFREQ field.
	TSADCC_TSR_TSSHTIM_Pos = 0x18      // Position of TSSHTIM field.
	TSADCC_TSR_TSSHTIM_Msk = 0xf000000 // Bit mask of TSSHTIM field.

	// CHER: Channel Enable Register
	TSADCC_CHER_CH0_Pos = 0x0  // Position of CH0 field.
	TSADCC_CHER_CH0_Msk = 0x1  // Bit mask of CH0 field.
	TSADCC_CHER_CH0     = 0x1  // Bit CH0.
	TSADCC_CHER_CH1_Pos = 0x1  // Position of CH1 field.
	TSADCC_CHER_CH1_Msk = 0x2  // Bit mask of CH1 field.
	TSADCC_CHER_CH1     = 0x2  // Bit CH1.
	TSADCC_CHER_CH2_Pos = 0x2  // Position of CH2 field.
	TSADCC_CHER_CH2_Msk = 0x4  // Bit mask of CH2 field.
	TSADCC_CHER_CH2     = 0x4  // Bit CH2.
	TSADCC_CHER_CH3_Pos = 0x3  // Position of CH3 field.
	TSADCC_CHER_CH3_Msk = 0x8  // Bit mask of CH3 field.
	TSADCC_CHER_CH3     = 0x8  // Bit CH3.
	TSADCC_CHER_CH4_Pos = 0x4  // Position of CH4 field.
	TSADCC_CHER_CH4_Msk = 0x10 // Bit mask of CH4 field.
	TSADCC_CHER_CH4     = 0x10 // Bit CH4.
	TSADCC_CHER_CH5_Pos = 0x5  // Position of CH5 field.
	TSADCC_CHER_CH5_Msk = 0x20 // Bit mask of CH5 field.
	TSADCC_CHER_CH5     = 0x20 // Bit CH5.
	TSADCC_CHER_CH6_Pos = 0x6  // Position of CH6 field.
	TSADCC_CHER_CH6_Msk = 0x40 // Bit mask of CH6 field.
	TSADCC_CHER_CH6     = 0x40 // Bit CH6.
	TSADCC_CHER_CH7_Pos = 0x7  // Position of CH7 field.
	TSADCC_CHER_CH7_Msk = 0x80 // Bit mask of CH7 field.
	TSADCC_CHER_CH7     = 0x80 // Bit CH7.

	// CHDR: Channel Disable Register
	TSADCC_CHDR_CH0_Pos = 0x0  // Position of CH0 field.
	TSADCC_CHDR_CH0_Msk = 0x1  // Bit mask of CH0 field.
	TSADCC_CHDR_CH0     = 0x1  // Bit CH0.
	TSADCC_CHDR_CH1_Pos = 0x1  // Position of CH1 field.
	TSADCC_CHDR_CH1_Msk = 0x2  // Bit mask of CH1 field.
	TSADCC_CHDR_CH1     = 0x2  // Bit CH1.
	TSADCC_CHDR_CH2_Pos = 0x2  // Position of CH2 field.
	TSADCC_CHDR_CH2_Msk = 0x4  // Bit mask of CH2 field.
	TSADCC_CHDR_CH2     = 0x4  // Bit CH2.
	TSADCC_CHDR_CH3_Pos = 0x3  // Position of CH3 field.
	TSADCC_CHDR_CH3_Msk = 0x8  // Bit mask of CH3 field.
	TSADCC_CHDR_CH3     = 0x8  // Bit CH3.
	TSADCC_CHDR_CH4_Pos = 0x4  // Position of CH4 field.
	TSADCC_CHDR_CH4_Msk = 0x10 // Bit mask of CH4 field.
	TSADCC_CHDR_CH4     = 0x10 // Bit CH4.
	TSADCC_CHDR_CH5_Pos = 0x5  // Position of CH5 field.
	TSADCC_CHDR_CH5_Msk = 0x20 // Bit mask of CH5 field.
	TSADCC_CHDR_CH5     = 0x20 // Bit CH5.
	TSADCC_CHDR_CH6_Pos = 0x6  // Position of CH6 field.
	TSADCC_CHDR_CH6_Msk = 0x40 // Bit mask of CH6 field.
	TSADCC_CHDR_CH6     = 0x40 // Bit CH6.
	TSADCC_CHDR_CH7_Pos = 0x7  // Position of CH7 field.
	TSADCC_CHDR_CH7_Msk = 0x80 // Bit mask of CH7 field.
	TSADCC_CHDR_CH7     = 0x80 // Bit CH7.

	// CHSR: Channel Status Register
	TSADCC_CHSR_CH0_Pos = 0x0  // Position of CH0 field.
	TSADCC_CHSR_CH0_Msk = 0x1  // Bit mask of CH0 field.
	TSADCC_CHSR_CH0     = 0x1  // Bit CH0.
	TSADCC_CHSR_CH1_Pos = 0x1  // Position of CH1 field.
	TSADCC_CHSR_CH1_Msk = 0x2  // Bit mask of CH1 field.
	TSADCC_CHSR_CH1     = 0x2  // Bit CH1.
	TSADCC_CHSR_CH2_Pos = 0x2  // Position of CH2 field.
	TSADCC_CHSR_CH2_Msk = 0x4  // Bit mask of CH2 field.
	TSADCC_CHSR_CH2     = 0x4  // Bit CH2.
	TSADCC_CHSR_CH3_Pos = 0x3  // Position of CH3 field.
	TSADCC_CHSR_CH3_Msk = 0x8  // Bit mask of CH3 field.
	TSADCC_CHSR_CH3     = 0x8  // Bit CH3.
	TSADCC_CHSR_CH4_Pos = 0x4  // Position of CH4 field.
	TSADCC_CHSR_CH4_Msk = 0x10 // Bit mask of CH4 field.
	TSADCC_CHSR_CH4     = 0x10 // Bit CH4.
	TSADCC_CHSR_CH5_Pos = 0x5  // Position of CH5 field.
	TSADCC_CHSR_CH5_Msk = 0x20 // Bit mask of CH5 field.
	TSADCC_CHSR_CH5     = 0x20 // Bit CH5.
	TSADCC_CHSR_CH6_Pos = 0x6  // Position of CH6 field.
	TSADCC_CHSR_CH6_Msk = 0x40 // Bit mask of CH6 field.
	TSADCC_CHSR_CH6     = 0x40 // Bit CH6.
	TSADCC_CHSR_CH7_Pos = 0x7  // Position of CH7 field.
	TSADCC_CHSR_CH7_Msk = 0x80 // Bit mask of CH7 field.
	TSADCC_CHSR_CH7     = 0x80 // Bit CH7.

	// SR: Status Register
	TSADCC_SR_EOC0_Pos   = 0x0        // Position of EOC0 field.
	TSADCC_SR_EOC0_Msk   = 0x1        // Bit mask of EOC0 field.
	TSADCC_SR_EOC0       = 0x1        // Bit EOC0.
	TSADCC_SR_EOC1_Pos   = 0x1        // Position of EOC1 field.
	TSADCC_SR_EOC1_Msk   = 0x2        // Bit mask of EOC1 field.
	TSADCC_SR_EOC1       = 0x2        // Bit EOC1.
	TSADCC_SR_EOC2_Pos   = 0x2        // Position of EOC2 field.
	TSADCC_SR_EOC2_Msk   = 0x4        // Bit mask of EOC2 field.
	TSADCC_SR_EOC2       = 0x4        // Bit EOC2.
	TSADCC_SR_EOC3_Pos   = 0x3        // Position of EOC3 field.
	TSADCC_SR_EOC3_Msk   = 0x8        // Bit mask of EOC3 field.
	TSADCC_SR_EOC3       = 0x8        // Bit EOC3.
	TSADCC_SR_EOC4_Pos   = 0x4        // Position of EOC4 field.
	TSADCC_SR_EOC4_Msk   = 0x10       // Bit mask of EOC4 field.
	TSADCC_SR_EOC4       = 0x10       // Bit EOC4.
	TSADCC_SR_EOC5_Pos   = 0x5        // Position of EOC5 field.
	TSADCC_SR_EOC5_Msk   = 0x20       // Bit mask of EOC5 field.
	TSADCC_SR_EOC5       = 0x20       // Bit EOC5.
	TSADCC_SR_EOC6_Pos   = 0x6        // Position of EOC6 field.
	TSADCC_SR_EOC6_Msk   = 0x40       // Bit mask of EOC6 field.
	TSADCC_SR_EOC6       = 0x40       // Bit EOC6.
	TSADCC_SR_EOC7_Pos   = 0x7        // Position of EOC7 field.
	TSADCC_SR_EOC7_Msk   = 0x80       // Bit mask of EOC7 field.
	TSADCC_SR_EOC7       = 0x80       // Bit EOC7.
	TSADCC_SR_OVRE0_Pos  = 0x8        // Position of OVRE0 field.
	TSADCC_SR_OVRE0_Msk  = 0x100      // Bit mask of OVRE0 field.
	TSADCC_SR_OVRE0      = 0x100      // Bit OVRE0.
	TSADCC_SR_OVRE1_Pos  = 0x9        // Position of OVRE1 field.
	TSADCC_SR_OVRE1_Msk  = 0x200      // Bit mask of OVRE1 field.
	TSADCC_SR_OVRE1      = 0x200      // Bit OVRE1.
	TSADCC_SR_OVRE2_Pos  = 0xa        // Position of OVRE2 field.
	TSADCC_SR_OVRE2_Msk  = 0x400      // Bit mask of OVRE2 field.
	TSADCC_SR_OVRE2      = 0x400      // Bit OVRE2.
	TSADCC_SR_OVRE3_Pos  = 0xb        // Position of OVRE3 field.
	TSADCC_SR_OVRE3_Msk  = 0x800      // Bit mask of OVRE3 field.
	TSADCC_SR_OVRE3      = 0x800      // Bit OVRE3.
	TSADCC_SR_OVRE4_Pos  = 0xc        // Position of OVRE4 field.
	TSADCC_SR_OVRE4_Msk  = 0x1000     // Bit mask of OVRE4 field.
	TSADCC_SR_OVRE4      = 0x1000     // Bit OVRE4.
	TSADCC_SR_OVRE5_Pos  = 0xd        // Position of OVRE5 field.
	TSADCC_SR_OVRE5_Msk  = 0x2000     // Bit mask of OVRE5 field.
	TSADCC_SR_OVRE5      = 0x2000     // Bit OVRE5.
	TSADCC_SR_OVRE6_Pos  = 0xe        // Position of OVRE6 field.
	TSADCC_SR_OVRE6_Msk  = 0x4000     // Bit mask of OVRE6 field.
	TSADCC_SR_OVRE6      = 0x4000     // Bit OVRE6.
	TSADCC_SR_OVRE7_Pos  = 0xf        // Position of OVRE7 field.
	TSADCC_SR_OVRE7_Msk  = 0x8000     // Bit mask of OVRE7 field.
	TSADCC_SR_OVRE7      = 0x8000     // Bit OVRE7.
	TSADCC_SR_DRDY_Pos   = 0x10       // Position of DRDY field.
	TSADCC_SR_DRDY_Msk   = 0x10000    // Bit mask of DRDY field.
	TSADCC_SR_DRDY       = 0x10000    // Bit DRDY.
	TSADCC_SR_GOVRE_Pos  = 0x11       // Position of GOVRE field.
	TSADCC_SR_GOVRE_Msk  = 0x20000    // Bit mask of GOVRE field.
	TSADCC_SR_GOVRE      = 0x20000    // Bit GOVRE.
	TSADCC_SR_ENDRX_Pos  = 0x12       // Position of ENDRX field.
	TSADCC_SR_ENDRX_Msk  = 0x40000    // Bit mask of ENDRX field.
	TSADCC_SR_ENDRX      = 0x40000    // Bit ENDRX.
	TSADCC_SR_RXBUFF_Pos = 0x13       // Position of RXBUFF field.
	TSADCC_SR_RXBUFF_Msk = 0x80000    // Bit mask of RXBUFF field.
	TSADCC_SR_RXBUFF     = 0x80000    // Bit RXBUFF.
	TSADCC_SR_PENCNT_Pos = 0x14       // Position of PENCNT field.
	TSADCC_SR_PENCNT_Msk = 0x100000   // Bit mask of PENCNT field.
	TSADCC_SR_PENCNT     = 0x100000   // Bit PENCNT.
	TSADCC_SR_NOCNT_Pos  = 0x15       // Position of NOCNT field.
	TSADCC_SR_NOCNT_Msk  = 0x200000   // Bit mask of NOCNT field.
	TSADCC_SR_NOCNT      = 0x200000   // Bit NOCNT.
	TSADCC_SR_EOCXP_Pos  = 0x18       // Position of EOCXP field.
	TSADCC_SR_EOCXP_Msk  = 0x1000000  // Bit mask of EOCXP field.
	TSADCC_SR_EOCXP      = 0x1000000  // Bit EOCXP.
	TSADCC_SR_EOCZ1_Pos  = 0x19       // Position of EOCZ1 field.
	TSADCC_SR_EOCZ1_Msk  = 0x2000000  // Bit mask of EOCZ1 field.
	TSADCC_SR_EOCZ1      = 0x2000000  // Bit EOCZ1.
	TSADCC_SR_EOCZ2_Pos  = 0x1a       // Position of EOCZ2 field.
	TSADCC_SR_EOCZ2_Msk  = 0x4000000  // Bit mask of EOCZ2 field.
	TSADCC_SR_EOCZ2      = 0x4000000  // Bit EOCZ2.
	TSADCC_SR_OVREXP_Pos = 0x1c       // Position of OVREXP field.
	TSADCC_SR_OVREXP_Msk = 0x10000000 // Bit mask of OVREXP field.
	TSADCC_SR_OVREXP     = 0x10000000 // Bit OVREXP.
	TSADCC_SR_OVREZ1_Pos = 0x1d       // Position of OVREZ1 field.
	TSADCC_SR_OVREZ1_Msk = 0x20000000 // Bit mask of OVREZ1 field.
	TSADCC_SR_OVREZ1     = 0x20000000 // Bit OVREZ1.
	TSADCC_SR_OVREZ2_Pos = 0x1e       // Position of OVREZ2 field.
	TSADCC_SR_OVREZ2_Msk = 0x40000000 // Bit mask of OVREZ2 field.
	TSADCC_SR_OVREZ2     = 0x40000000 // Bit OVREZ2.

	// LCDR: Last Converted Data Register
	TSADCC_LCDR_LDATA_Pos = 0x0   // Position of LDATA field.
	TSADCC_LCDR_LDATA_Msk = 0x3ff // Bit mask of LDATA field.

	// IER: Interrupt Enable Register
	TSADCC_IER_EOC0_Pos   = 0x0        // Position of EOC0 field.
	TSADCC_IER_EOC0_Msk   = 0x1        // Bit mask of EOC0 field.
	TSADCC_IER_EOC0       = 0x1        // Bit EOC0.
	TSADCC_IER_EOC1_Pos   = 0x1        // Position of EOC1 field.
	TSADCC_IER_EOC1_Msk   = 0x2        // Bit mask of EOC1 field.
	TSADCC_IER_EOC1       = 0x2        // Bit EOC1.
	TSADCC_IER_EOC2_Pos   = 0x2        // Position of EOC2 field.
	TSADCC_IER_EOC2_Msk   = 0x4        // Bit mask of EOC2 field.
	TSADCC_IER_EOC2       = 0x4        // Bit EOC2.
	TSADCC_IER_EOC3_Pos   = 0x3        // Position of EOC3 field.
	TSADCC_IER_EOC3_Msk   = 0x8        // Bit mask of EOC3 field.
	TSADCC_IER_EOC3       = 0x8        // Bit EOC3.
	TSADCC_IER_EOC4_Pos   = 0x4        // Position of EOC4 field.
	TSADCC_IER_EOC4_Msk   = 0x10       // Bit mask of EOC4 field.
	TSADCC_IER_EOC4       = 0x10       // Bit EOC4.
	TSADCC_IER_EOC5_Pos   = 0x5        // Position of EOC5 field.
	TSADCC_IER_EOC5_Msk   = 0x20       // Bit mask of EOC5 field.
	TSADCC_IER_EOC5       = 0x20       // Bit EOC5.
	TSADCC_IER_EOC6_Pos   = 0x6        // Position of EOC6 field.
	TSADCC_IER_EOC6_Msk   = 0x40       // Bit mask of EOC6 field.
	TSADCC_IER_EOC6       = 0x40       // Bit EOC6.
	TSADCC_IER_EOC7_Pos   = 0x7        // Position of EOC7 field.
	TSADCC_IER_EOC7_Msk   = 0x80       // Bit mask of EOC7 field.
	TSADCC_IER_EOC7       = 0x80       // Bit EOC7.
	TSADCC_IER_OVRE0_Pos  = 0x8        // Position of OVRE0 field.
	TSADCC_IER_OVRE0_Msk  = 0x100      // Bit mask of OVRE0 field.
	TSADCC_IER_OVRE0      = 0x100      // Bit OVRE0.
	TSADCC_IER_OVRE1_Pos  = 0x9        // Position of OVRE1 field.
	TSADCC_IER_OVRE1_Msk  = 0x200      // Bit mask of OVRE1 field.
	TSADCC_IER_OVRE1      = 0x200      // Bit OVRE1.
	TSADCC_IER_OVRE2_Pos  = 0xa        // Position of OVRE2 field.
	TSADCC_IER_OVRE2_Msk  = 0x400      // Bit mask of OVRE2 field.
	TSADCC_IER_OVRE2      = 0x400      // Bit OVRE2.
	TSADCC_IER_OVRE3_Pos  = 0xb        // Position of OVRE3 field.
	TSADCC_IER_OVRE3_Msk  = 0x800      // Bit mask of OVRE3 field.
	TSADCC_IER_OVRE3      = 0x800      // Bit OVRE3.
	TSADCC_IER_OVRE4_Pos  = 0xc        // Position of OVRE4 field.
	TSADCC_IER_OVRE4_Msk  = 0x1000     // Bit mask of OVRE4 field.
	TSADCC_IER_OVRE4      = 0x1000     // Bit OVRE4.
	TSADCC_IER_OVRE5_Pos  = 0xd        // Position of OVRE5 field.
	TSADCC_IER_OVRE5_Msk  = 0x2000     // Bit mask of OVRE5 field.
	TSADCC_IER_OVRE5      = 0x2000     // Bit OVRE5.
	TSADCC_IER_OVRE6_Pos  = 0xe        // Position of OVRE6 field.
	TSADCC_IER_OVRE6_Msk  = 0x4000     // Bit mask of OVRE6 field.
	TSADCC_IER_OVRE6      = 0x4000     // Bit OVRE6.
	TSADCC_IER_OVRE7_Pos  = 0xf        // Position of OVRE7 field.
	TSADCC_IER_OVRE7_Msk  = 0x8000     // Bit mask of OVRE7 field.
	TSADCC_IER_OVRE7      = 0x8000     // Bit OVRE7.
	TSADCC_IER_DRDY_Pos   = 0x10       // Position of DRDY field.
	TSADCC_IER_DRDY_Msk   = 0x10000    // Bit mask of DRDY field.
	TSADCC_IER_DRDY       = 0x10000    // Bit DRDY.
	TSADCC_IER_GOVRE_Pos  = 0x11       // Position of GOVRE field.
	TSADCC_IER_GOVRE_Msk  = 0x20000    // Bit mask of GOVRE field.
	TSADCC_IER_GOVRE      = 0x20000    // Bit GOVRE.
	TSADCC_IER_ENDRX_Pos  = 0x12       // Position of ENDRX field.
	TSADCC_IER_ENDRX_Msk  = 0x40000    // Bit mask of ENDRX field.
	TSADCC_IER_ENDRX      = 0x40000    // Bit ENDRX.
	TSADCC_IER_RXBUFF_Pos = 0x13       // Position of RXBUFF field.
	TSADCC_IER_RXBUFF_Msk = 0x80000    // Bit mask of RXBUFF field.
	TSADCC_IER_RXBUFF     = 0x80000    // Bit RXBUFF.
	TSADCC_IER_PENCNT_Pos = 0x14       // Position of PENCNT field.
	TSADCC_IER_PENCNT_Msk = 0x100000   // Bit mask of PENCNT field.
	TSADCC_IER_PENCNT     = 0x100000   // Bit PENCNT.
	TSADCC_IER_NOCNT_Pos  = 0x15       // Position of NOCNT field.
	TSADCC_IER_NOCNT_Msk  = 0x200000   // Bit mask of NOCNT field.
	TSADCC_IER_NOCNT      = 0x200000   // Bit NOCNT.
	TSADCC_IER_EOCXP_Pos  = 0x18       // Position of EOCXP field.
	TSADCC_IER_EOCXP_Msk  = 0x1000000  // Bit mask of EOCXP field.
	TSADCC_IER_EOCXP      = 0x1000000  // Bit EOCXP.
	TSADCC_IER_EOCZ1_Pos  = 0x19       // Position of EOCZ1 field.
	TSADCC_IER_EOCZ1_Msk  = 0x2000000  // Bit mask of EOCZ1 field.
	TSADCC_IER_EOCZ1      = 0x2000000  // Bit EOCZ1.
	TSADCC_IER_EOCZ2_Pos  = 0x1a       // Position of EOCZ2 field.
	TSADCC_IER_EOCZ2_Msk  = 0x4000000  // Bit mask of EOCZ2 field.
	TSADCC_IER_EOCZ2      = 0x4000000  // Bit EOCZ2.
	TSADCC_IER_OVREXP_Pos = 0x1c       // Position of OVREXP field.
	TSADCC_IER_OVREXP_Msk = 0x10000000 // Bit mask of OVREXP field.
	TSADCC_IER_OVREXP     = 0x10000000 // Bit OVREXP.
	TSADCC_IER_OVREZ1_Pos = 0x1d       // Position of OVREZ1 field.
	TSADCC_IER_OVREZ1_Msk = 0x20000000 // Bit mask of OVREZ1 field.
	TSADCC_IER_OVREZ1     = 0x20000000 // Bit OVREZ1.
	TSADCC_IER_OVREZ2_Pos = 0x1e       // Position of OVREZ2 field.
	TSADCC_IER_OVREZ2_Msk = 0x40000000 // Bit mask of OVREZ2 field.
	TSADCC_IER_OVREZ2     = 0x40000000 // Bit OVREZ2.

	// IDR: Interrupt Disable Register
	TSADCC_IDR_EOC0_Pos   = 0x0        // Position of EOC0 field.
	TSADCC_IDR_EOC0_Msk   = 0x1        // Bit mask of EOC0 field.
	TSADCC_IDR_EOC0       = 0x1        // Bit EOC0.
	TSADCC_IDR_EOC1_Pos   = 0x1        // Position of EOC1 field.
	TSADCC_IDR_EOC1_Msk   = 0x2        // Bit mask of EOC1 field.
	TSADCC_IDR_EOC1       = 0x2        // Bit EOC1.
	TSADCC_IDR_EOC2_Pos   = 0x2        // Position of EOC2 field.
	TSADCC_IDR_EOC2_Msk   = 0x4        // Bit mask of EOC2 field.
	TSADCC_IDR_EOC2       = 0x4        // Bit EOC2.
	TSADCC_IDR_EOC3_Pos   = 0x3        // Position of EOC3 field.
	TSADCC_IDR_EOC3_Msk   = 0x8        // Bit mask of EOC3 field.
	TSADCC_IDR_EOC3       = 0x8        // Bit EOC3.
	TSADCC_IDR_EOC4_Pos   = 0x4        // Position of EOC4 field.
	TSADCC_IDR_EOC4_Msk   = 0x10       // Bit mask of EOC4 field.
	TSADCC_IDR_EOC4       = 0x10       // Bit EOC4.
	TSADCC_IDR_EOC5_Pos   = 0x5        // Position of EOC5 field.
	TSADCC_IDR_EOC5_Msk   = 0x20       // Bit mask of EOC5 field.
	TSADCC_IDR_EOC5       = 0x20       // Bit EOC5.
	TSADCC_IDR_EOC6_Pos   = 0x6        // Position of EOC6 field.
	TSADCC_IDR_EOC6_Msk   = 0x40       // Bit mask of EOC6 field.
	TSADCC_IDR_EOC6       = 0x40       // Bit EOC6.
	TSADCC_IDR_EOC7_Pos   = 0x7        // Position of EOC7 field.
	TSADCC_IDR_EOC7_Msk   = 0x80       // Bit mask of EOC7 field.
	TSADCC_IDR_EOC7       = 0x80       // Bit EOC7.
	TSADCC_IDR_OVRE0_Pos  = 0x8        // Position of OVRE0 field.
	TSADCC_IDR_OVRE0_Msk  = 0x100      // Bit mask of OVRE0 field.
	TSADCC_IDR_OVRE0      = 0x100      // Bit OVRE0.
	TSADCC_IDR_OVRE1_Pos  = 0x9        // Position of OVRE1 field.
	TSADCC_IDR_OVRE1_Msk  = 0x200      // Bit mask of OVRE1 field.
	TSADCC_IDR_OVRE1      = 0x200      // Bit OVRE1.
	TSADCC_IDR_OVRE2_Pos  = 0xa        // Position of OVRE2 field.
	TSADCC_IDR_OVRE2_Msk  = 0x400      // Bit mask of OVRE2 field.
	TSADCC_IDR_OVRE2      = 0x400      // Bit OVRE2.
	TSADCC_IDR_OVRE3_Pos  = 0xb        // Position of OVRE3 field.
	TSADCC_IDR_OVRE3_Msk  = 0x800      // Bit mask of OVRE3 field.
	TSADCC_IDR_OVRE3      = 0x800      // Bit OVRE3.
	TSADCC_IDR_OVRE4_Pos  = 0xc        // Position of OVRE4 field.
	TSADCC_IDR_OVRE4_Msk  = 0x1000     // Bit mask of OVRE4 field.
	TSADCC_IDR_OVRE4      = 0x1000     // Bit OVRE4.
	TSADCC_IDR_OVRE5_Pos  = 0xd        // Position of OVRE5 field.
	TSADCC_IDR_OVRE5_Msk  = 0x2000     // Bit mask of OVRE5 field.
	TSADCC_IDR_OVRE5      = 0x2000     // Bit OVRE5.
	TSADCC_IDR_OVRE6_Pos  = 0xe        // Position of OVRE6 field.
	TSADCC_IDR_OVRE6_Msk  = 0x4000     // Bit mask of OVRE6 field.
	TSADCC_IDR_OVRE6      = 0x4000     // Bit OVRE6.
	TSADCC_IDR_OVRE7_Pos  = 0xf        // Position of OVRE7 field.
	TSADCC_IDR_OVRE7_Msk  = 0x8000     // Bit mask of OVRE7 field.
	TSADCC_IDR_OVRE7      = 0x8000     // Bit OVRE7.
	TSADCC_IDR_DRDY_Pos   = 0x10       // Position of DRDY field.
	TSADCC_IDR_DRDY_Msk   = 0x10000    // Bit mask of DRDY field.
	TSADCC_IDR_DRDY       = 0x10000    // Bit DRDY.
	TSADCC_IDR_GOVRE_Pos  = 0x11       // Position of GOVRE field.
	TSADCC_IDR_GOVRE_Msk  = 0x20000    // Bit mask of GOVRE field.
	TSADCC_IDR_GOVRE      = 0x20000    // Bit GOVRE.
	TSADCC_IDR_ENDRX_Pos  = 0x12       // Position of ENDRX field.
	TSADCC_IDR_ENDRX_Msk  = 0x40000    // Bit mask of ENDRX field.
	TSADCC_IDR_ENDRX      = 0x40000    // Bit ENDRX.
	TSADCC_IDR_RXBUFF_Pos = 0x13       // Position of RXBUFF field.
	TSADCC_IDR_RXBUFF_Msk = 0x80000    // Bit mask of RXBUFF field.
	TSADCC_IDR_RXBUFF     = 0x80000    // Bit RXBUFF.
	TSADCC_IDR_PENCNT_Pos = 0x14       // Position of PENCNT field.
	TSADCC_IDR_PENCNT_Msk = 0x100000   // Bit mask of PENCNT field.
	TSADCC_IDR_PENCNT     = 0x100000   // Bit PENCNT.
	TSADCC_IDR_NOCNT_Pos  = 0x15       // Position of NOCNT field.
	TSADCC_IDR_NOCNT_Msk  = 0x200000   // Bit mask of NOCNT field.
	TSADCC_IDR_NOCNT      = 0x200000   // Bit NOCNT.
	TSADCC_IDR_EOCXP_Pos  = 0x18       // Position of EOCXP field.
	TSADCC_IDR_EOCXP_Msk  = 0x1000000  // Bit mask of EOCXP field.
	TSADCC_IDR_EOCXP      = 0x1000000  // Bit EOCXP.
	TSADCC_IDR_EOCZ1_Pos  = 0x19       // Position of EOCZ1 field.
	TSADCC_IDR_EOCZ1_Msk  = 0x2000000  // Bit mask of EOCZ1 field.
	TSADCC_IDR_EOCZ1      = 0x2000000  // Bit EOCZ1.
	TSADCC_IDR_EOCZ2_Pos  = 0x1a       // Position of EOCZ2 field.
	TSADCC_IDR_EOCZ2_Msk  = 0x4000000  // Bit mask of EOCZ2 field.
	TSADCC_IDR_EOCZ2      = 0x4000000  // Bit EOCZ2.
	TSADCC_IDR_OVREXP_Pos = 0x1c       // Position of OVREXP field.
	TSADCC_IDR_OVREXP_Msk = 0x10000000 // Bit mask of OVREXP field.
	TSADCC_IDR_OVREXP     = 0x10000000 // Bit OVREXP.
	TSADCC_IDR_OVREZ1_Pos = 0x1d       // Position of OVREZ1 field.
	TSADCC_IDR_OVREZ1_Msk = 0x20000000 // Bit mask of OVREZ1 field.
	TSADCC_IDR_OVREZ1     = 0x20000000 // Bit OVREZ1.
	TSADCC_IDR_OVREZ2_Pos = 0x1e       // Position of OVREZ2 field.
	TSADCC_IDR_OVREZ2_Msk = 0x40000000 // Bit mask of OVREZ2 field.
	TSADCC_IDR_OVREZ2     = 0x40000000 // Bit OVREZ2.

	// IMR: Interrupt Mask Register
	TSADCC_IMR_EOC0_Pos   = 0x0        // Position of EOC0 field.
	TSADCC_IMR_EOC0_Msk   = 0x1        // Bit mask of EOC0 field.
	TSADCC_IMR_EOC0       = 0x1        // Bit EOC0.
	TSADCC_IMR_EOC1_Pos   = 0x1        // Position of EOC1 field.
	TSADCC_IMR_EOC1_Msk   = 0x2        // Bit mask of EOC1 field.
	TSADCC_IMR_EOC1       = 0x2        // Bit EOC1.
	TSADCC_IMR_EOC2_Pos   = 0x2        // Position of EOC2 field.
	TSADCC_IMR_EOC2_Msk   = 0x4        // Bit mask of EOC2 field.
	TSADCC_IMR_EOC2       = 0x4        // Bit EOC2.
	TSADCC_IMR_EOC3_Pos   = 0x3        // Position of EOC3 field.
	TSADCC_IMR_EOC3_Msk   = 0x8        // Bit mask of EOC3 field.
	TSADCC_IMR_EOC3       = 0x8        // Bit EOC3.
	TSADCC_IMR_EOC4_Pos   = 0x4        // Position of EOC4 field.
	TSADCC_IMR_EOC4_Msk   = 0x10       // Bit mask of EOC4 field.
	TSADCC_IMR_EOC4       = 0x10       // Bit EOC4.
	TSADCC_IMR_EOC5_Pos   = 0x5        // Position of EOC5 field.
	TSADCC_IMR_EOC5_Msk   = 0x20       // Bit mask of EOC5 field.
	TSADCC_IMR_EOC5       = 0x20       // Bit EOC5.
	TSADCC_IMR_EOC6_Pos   = 0x6        // Position of EOC6 field.
	TSADCC_IMR_EOC6_Msk   = 0x40       // Bit mask of EOC6 field.
	TSADCC_IMR_EOC6       = 0x40       // Bit EOC6.
	TSADCC_IMR_EOC7_Pos   = 0x7        // Position of EOC7 field.
	TSADCC_IMR_EOC7_Msk   = 0x80       // Bit mask of EOC7 field.
	TSADCC_IMR_EOC7       = 0x80       // Bit EOC7.
	TSADCC_IMR_OVRE0_Pos  = 0x8        // Position of OVRE0 field.
	TSADCC_IMR_OVRE0_Msk  = 0x100      // Bit mask of OVRE0 field.
	TSADCC_IMR_OVRE0      = 0x100      // Bit OVRE0.
	TSADCC_IMR_OVRE1_Pos  = 0x9        // Position of OVRE1 field.
	TSADCC_IMR_OVRE1_Msk  = 0x200      // Bit mask of OVRE1 field.
	TSADCC_IMR_OVRE1      = 0x200      // Bit OVRE1.
	TSADCC_IMR_OVRE2_Pos  = 0xa        // Position of OVRE2 field.
	TSADCC_IMR_OVRE2_Msk  = 0x400      // Bit mask of OVRE2 field.
	TSADCC_IMR_OVRE2      = 0x400      // Bit OVRE2.
	TSADCC_IMR_OVRE3_Pos  = 0xb        // Position of OVRE3 field.
	TSADCC_IMR_OVRE3_Msk  = 0x800      // Bit mask of OVRE3 field.
	TSADCC_IMR_OVRE3      = 0x800      // Bit OVRE3.
	TSADCC_IMR_OVRE4_Pos  = 0xc        // Position of OVRE4 field.
	TSADCC_IMR_OVRE4_Msk  = 0x1000     // Bit mask of OVRE4 field.
	TSADCC_IMR_OVRE4      = 0x1000     // Bit OVRE4.
	TSADCC_IMR_OVRE5_Pos  = 0xd        // Position of OVRE5 field.
	TSADCC_IMR_OVRE5_Msk  = 0x2000     // Bit mask of OVRE5 field.
	TSADCC_IMR_OVRE5      = 0x2000     // Bit OVRE5.
	TSADCC_IMR_OVRE6_Pos  = 0xe        // Position of OVRE6 field.
	TSADCC_IMR_OVRE6_Msk  = 0x4000     // Bit mask of OVRE6 field.
	TSADCC_IMR_OVRE6      = 0x4000     // Bit OVRE6.
	TSADCC_IMR_OVRE7_Pos  = 0xf        // Position of OVRE7 field.
	TSADCC_IMR_OVRE7_Msk  = 0x8000     // Bit mask of OVRE7 field.
	TSADCC_IMR_OVRE7      = 0x8000     // Bit OVRE7.
	TSADCC_IMR_DRDY_Pos   = 0x10       // Position of DRDY field.
	TSADCC_IMR_DRDY_Msk   = 0x10000    // Bit mask of DRDY field.
	TSADCC_IMR_DRDY       = 0x10000    // Bit DRDY.
	TSADCC_IMR_GOVRE_Pos  = 0x11       // Position of GOVRE field.
	TSADCC_IMR_GOVRE_Msk  = 0x20000    // Bit mask of GOVRE field.
	TSADCC_IMR_GOVRE      = 0x20000    // Bit GOVRE.
	TSADCC_IMR_ENDRX_Pos  = 0x12       // Position of ENDRX field.
	TSADCC_IMR_ENDRX_Msk  = 0x40000    // Bit mask of ENDRX field.
	TSADCC_IMR_ENDRX      = 0x40000    // Bit ENDRX.
	TSADCC_IMR_RXBUFF_Pos = 0x13       // Position of RXBUFF field.
	TSADCC_IMR_RXBUFF_Msk = 0x80000    // Bit mask of RXBUFF field.
	TSADCC_IMR_RXBUFF     = 0x80000    // Bit RXBUFF.
	TSADCC_IMR_PENCNT_Pos = 0x14       // Position of PENCNT field.
	TSADCC_IMR_PENCNT_Msk = 0x100000   // Bit mask of PENCNT field.
	TSADCC_IMR_PENCNT     = 0x100000   // Bit PENCNT.
	TSADCC_IMR_NOCNT_Pos  = 0x15       // Position of NOCNT field.
	TSADCC_IMR_NOCNT_Msk  = 0x200000   // Bit mask of NOCNT field.
	TSADCC_IMR_NOCNT      = 0x200000   // Bit NOCNT.
	TSADCC_IMR_EOCXP_Pos  = 0x18       // Position of EOCXP field.
	TSADCC_IMR_EOCXP_Msk  = 0x1000000  // Bit mask of EOCXP field.
	TSADCC_IMR_EOCXP      = 0x1000000  // Bit EOCXP.
	TSADCC_IMR_EOCZ1_Pos  = 0x19       // Position of EOCZ1 field.
	TSADCC_IMR_EOCZ1_Msk  = 0x2000000  // Bit mask of EOCZ1 field.
	TSADCC_IMR_EOCZ1      = 0x2000000  // Bit EOCZ1.
	TSADCC_IMR_EOCZ2_Pos  = 0x1a       // Position of EOCZ2 field.
	TSADCC_IMR_EOCZ2_Msk  = 0x4000000  // Bit mask of EOCZ2 field.
	TSADCC_IMR_EOCZ2      = 0x4000000  // Bit EOCZ2.
	TSADCC_IMR_OVREXP_Pos = 0x1c       // Position of OVREXP field.
	TSADCC_IMR_OVREXP_Msk = 0x10000000 // Bit mask of OVREXP field.
	TSADCC_IMR_OVREXP     = 0x10000000 // Bit OVREXP.
	TSADCC_IMR_OVREZ1_Pos = 0x1d       // Position of OVREZ1 field.
	TSADCC_IMR_OVREZ1_Msk = 0x20000000 // Bit mask of OVREZ1 field.
	TSADCC_IMR_OVREZ1     = 0x20000000 // Bit OVREZ1.
	TSADCC_IMR_OVREZ2_Pos = 0x1e       // Position of OVREZ2 field.
	TSADCC_IMR_OVREZ2_Msk = 0x40000000 // Bit mask of OVREZ2 field.
	TSADCC_IMR_OVREZ2     = 0x40000000 // Bit OVREZ2.

	// CDR: Channel Data Register
	TSADCC_CDR_DATA_Pos = 0x0   // Position of DATA field.
	TSADCC_CDR_DATA_Msk = 0x3ff // Bit mask of DATA field.

	// XPDR: X Position Data Register
	TSADCC_XPDR_DATA_Pos = 0x0   // Position of DATA field.
	TSADCC_XPDR_DATA_Msk = 0x3ff // Bit mask of DATA field.

	// Z1DR: Z1 Data Register
	TSADCC_Z1DR_DATA_Pos = 0x0   // Position of DATA field.
	TSADCC_Z1DR_DATA_Msk = 0x3ff // Bit mask of DATA field.

	// Z2DR: Z2 Data Register
	TSADCC_Z2DR_Z2_Pos = 0x0   // Position of Z2 field.
	TSADCC_Z2DR_Z2_Msk = 0x3ff // Bit mask of Z2 field.

	// MSCR: Manual Switch Command Register
	TSADCC_MSCR_XP_Pos = 0x0 // Position of XP field.
	TSADCC_MSCR_XP_Msk = 0x1 // Bit mask of XP field.
	TSADCC_MSCR_XP     = 0x1 // Bit XP.
	TSADCC_MSCR_XM_Pos = 0x1 // Position of XM field.
	TSADCC_MSCR_XM_Msk = 0x2 // Bit mask of XM field.
	TSADCC_MSCR_XM     = 0x2 // Bit XM.
	TSADCC_MSCR_YP_Pos = 0x2 // Position of YP field.
	TSADCC_MSCR_YP_Msk = 0x4 // Bit mask of YP field.
	TSADCC_MSCR_YP     = 0x4 // Bit YP.
	TSADCC_MSCR_YM_Pos = 0x3 // Position of YM field.
	TSADCC_MSCR_YM_Msk = 0x8 // Bit mask of YM field.
	TSADCC_MSCR_YM     = 0x8 // Bit YM.

	// WPMR: Write Protection Mode Register
	TSADCC_WPMR_WPEN_Pos = 0x0        // Position of WPEN field.
	TSADCC_WPMR_WPEN_Msk = 0x1        // Bit mask of WPEN field.
	TSADCC_WPMR_WPEN     = 0x1        // Bit WPEN.
	TSADCC_WPMR_KEY_Pos  = 0x8        // Position of KEY field.
	TSADCC_WPMR_KEY_Msk  = 0xffffff00 // Bit mask of KEY field.

	// WPSR: Write Protection Status Register
	TSADCC_WPSR_WPS_Pos        = 0x0        // Position of WPS field.
	TSADCC_WPSR_WPS_Msk        = 0x1        // Bit mask of WPS field.
	TSADCC_WPSR_WPS            = 0x1        // Bit WPS.
	TSADCC_WPSR_OFFSET_ERR_Pos = 0x8        // Position of OFFSET_ERR field.
	TSADCC_WPSR_OFFSET_ERR_Msk = 0xffffff00 // Bit mask of OFFSET_ERR field.

	// RPR: Receive Pointer Register
	TSADCC_RPR_RXPTR_Pos = 0x0        // Position of RXPTR field.
	TSADCC_RPR_RXPTR_Msk = 0xffffffff // Bit mask of RXPTR field.

	// RCR: Receive Counter Register
	TSADCC_RCR_RXCTR_Pos = 0x0    // Position of RXCTR field.
	TSADCC_RCR_RXCTR_Msk = 0xffff // Bit mask of RXCTR field.

	// RNPR: Receive Next Pointer Register
	TSADCC_RNPR_RXNPTR_Pos = 0x0        // Position of RXNPTR field.
	TSADCC_RNPR_RXNPTR_Msk = 0xffffffff // Bit mask of RXNPTR field.

	// RNCR: Receive Next Counter Register
	TSADCC_RNCR_RXNCTR_Pos = 0x0    // Position of RXNCTR field.
	TSADCC_RNCR_RXNCTR_Msk = 0xffff // Bit mask of RXNCTR field.

	// PTCR: Transfer Control Register
	TSADCC_PTCR_RXTEN_Pos  = 0x0   // Position of RXTEN field.
	TSADCC_PTCR_RXTEN_Msk  = 0x1   // Bit mask of RXTEN field.
	TSADCC_PTCR_RXTEN      = 0x1   // Bit RXTEN.
	TSADCC_PTCR_RXTDIS_Pos = 0x1   // Position of RXTDIS field.
	TSADCC_PTCR_RXTDIS_Msk = 0x2   // Bit mask of RXTDIS field.
	TSADCC_PTCR_RXTDIS     = 0x2   // Bit RXTDIS.
	TSADCC_PTCR_TXTEN_Pos  = 0x8   // Position of TXTEN field.
	TSADCC_PTCR_TXTEN_Msk  = 0x100 // Bit mask of TXTEN field.
	TSADCC_PTCR_TXTEN      = 0x100 // Bit TXTEN.
	TSADCC_PTCR_TXTDIS_Pos = 0x9   // Position of TXTDIS field.
	TSADCC_PTCR_TXTDIS_Msk = 0x200 // Bit mask of TXTDIS field.
	TSADCC_PTCR_TXTDIS     = 0x200 // Bit TXTDIS.

	// PTSR: Transfer Status Register
	TSADCC_PTSR_RXTEN_Pos = 0x0   // Position of RXTEN field.
	TSADCC_PTSR_RXTEN_Msk = 0x1   // Bit mask of RXTEN field.
	TSADCC_PTSR_RXTEN     = 0x1   // Bit RXTEN.
	TSADCC_PTSR_TXTEN_Pos = 0x8   // Position of TXTEN field.
	TSADCC_PTSR_TXTEN_Msk = 0x100 // Bit mask of TXTEN field.
	TSADCC_PTSR_TXTEN     = 0x100 // Bit TXTEN.
)

// Bitfields for ISI: Image Sensor Interface
const (
	// ISI_CFG1: ISI Configuration 1 Register
	ISI_ISI_CFG1_HSYNC_POL_Pos  = 0x2        // Position of HSYNC_POL field.
	ISI_ISI_CFG1_HSYNC_POL_Msk  = 0x4        // Bit mask of HSYNC_POL field.
	ISI_ISI_CFG1_HSYNC_POL      = 0x4        // Bit HSYNC_POL.
	ISI_ISI_CFG1_VSYNC_POL_Pos  = 0x3        // Position of VSYNC_POL field.
	ISI_ISI_CFG1_VSYNC_POL_Msk  = 0x8        // Bit mask of VSYNC_POL field.
	ISI_ISI_CFG1_VSYNC_POL      = 0x8        // Bit VSYNC_POL.
	ISI_ISI_CFG1_PIXCLK_POL_Pos = 0x4        // Position of PIXCLK_POL field.
	ISI_ISI_CFG1_PIXCLK_POL_Msk = 0x10       // Bit mask of PIXCLK_POL field.
	ISI_ISI_CFG1_PIXCLK_POL     = 0x10       // Bit PIXCLK_POL.
	ISI_ISI_CFG1_EMB_SYNC_Pos   = 0x6        // Position of EMB_SYNC field.
	ISI_ISI_CFG1_EMB_SYNC_Msk   = 0x40       // Bit mask of EMB_SYNC field.
	ISI_ISI_CFG1_EMB_SYNC       = 0x40       // Bit EMB_SYNC.
	ISI_ISI_CFG1_CRC_SYNC_Pos   = 0x7        // Position of CRC_SYNC field.
	ISI_ISI_CFG1_CRC_SYNC_Msk   = 0x80       // Bit mask of CRC_SYNC field.
	ISI_ISI_CFG1_CRC_SYNC       = 0x80       // Bit CRC_SYNC.
	ISI_ISI_CFG1_FRATE_Pos      = 0x8        // Position of FRATE field.
	ISI_ISI_CFG1_FRATE_Msk      = 0x700      // Bit mask of FRATE field.
	ISI_ISI_CFG1_DISCR_Pos      = 0xb        // Position of DISCR field.
	ISI_ISI_CFG1_DISCR_Msk      = 0x800      // Bit mask of DISCR field.
	ISI_ISI_CFG1_DISCR          = 0x800      // Bit DISCR.
	ISI_ISI_CFG1_FULL_Pos       = 0xc        // Position of FULL field.
	ISI_ISI_CFG1_FULL_Msk       = 0x1000     // Bit mask of FULL field.
	ISI_ISI_CFG1_FULL           = 0x1000     // Bit FULL.
	ISI_ISI_CFG1_THMASK_Pos     = 0xd        // Position of THMASK field.
	ISI_ISI_CFG1_THMASK_Msk     = 0x6000     // Bit mask of THMASK field.
	ISI_ISI_CFG1_SLD_Pos        = 0x10       // Position of SLD field.
	ISI_ISI_CFG1_SLD_Msk        = 0xff0000   // Bit mask of SLD field.
	ISI_ISI_CFG1_SFD_Pos        = 0x18       // Position of SFD field.
	ISI_ISI_CFG1_SFD_Msk        = 0xff000000 // Bit mask of SFD field.

	// ISI_CFG2: ISI Configuration 2 Register
	ISI_ISI_CFG2_IM_VSIZE_Pos  = 0x0        // Position of IM_VSIZE field.
	ISI_ISI_CFG2_IM_VSIZE_Msk  = 0x7ff      // Bit mask of IM_VSIZE field.
	ISI_ISI_CFG2_GS_MODE_Pos   = 0xb        // Position of GS_MODE field.
	ISI_ISI_CFG2_GS_MODE_Msk   = 0x800      // Bit mask of GS_MODE field.
	ISI_ISI_CFG2_GS_MODE       = 0x800      // Bit GS_MODE.
	ISI_ISI_CFG2_RGB_MODE_Pos  = 0xc        // Position of RGB_MODE field.
	ISI_ISI_CFG2_RGB_MODE_Msk  = 0x1000     // Bit mask of RGB_MODE field.
	ISI_ISI_CFG2_RGB_MODE      = 0x1000     // Bit RGB_MODE.
	ISI_ISI_CFG2_GRAYSCALE_Pos = 0xd        // Position of GRAYSCALE field.
	ISI_ISI_CFG2_GRAYSCALE_Msk = 0x2000     // Bit mask of GRAYSCALE field.
	ISI_ISI_CFG2_GRAYSCALE     = 0x2000     // Bit GRAYSCALE.
	ISI_ISI_CFG2_RGB_SWAP_Pos  = 0xe        // Position of RGB_SWAP field.
	ISI_ISI_CFG2_RGB_SWAP_Msk  = 0x4000     // Bit mask of RGB_SWAP field.
	ISI_ISI_CFG2_RGB_SWAP      = 0x4000     // Bit RGB_SWAP.
	ISI_ISI_CFG2_COL_SPACE_Pos = 0xf        // Position of COL_SPACE field.
	ISI_ISI_CFG2_COL_SPACE_Msk = 0x8000     // Bit mask of COL_SPACE field.
	ISI_ISI_CFG2_COL_SPACE     = 0x8000     // Bit COL_SPACE.
	ISI_ISI_CFG2_IM_HSIZE_Pos  = 0x10       // Position of IM_HSIZE field.
	ISI_ISI_CFG2_IM_HSIZE_Msk  = 0x7ff0000  // Bit mask of IM_HSIZE field.
	ISI_ISI_CFG2_YCC_SWAP_Pos  = 0x1c       // Position of YCC_SWAP field.
	ISI_ISI_CFG2_YCC_SWAP_Msk  = 0x30000000 // Bit mask of YCC_SWAP field.
	ISI_ISI_CFG2_RGB_CFG_Pos   = 0x1e       // Position of RGB_CFG field.
	ISI_ISI_CFG2_RGB_CFG_Msk   = 0xc0000000 // Bit mask of RGB_CFG field.

	// ISI_PSIZE: ISI Preview Size Register
	ISI_ISI_PSIZE_PREV_VSIZE_Pos = 0x0       // Position of PREV_VSIZE field.
	ISI_ISI_PSIZE_PREV_VSIZE_Msk = 0x3ff     // Bit mask of PREV_VSIZE field.
	ISI_ISI_PSIZE_PREV_HSIZE_Pos = 0x10      // Position of PREV_HSIZE field.
	ISI_ISI_PSIZE_PREV_HSIZE_Msk = 0x3ff0000 // Bit mask of PREV_HSIZE field.

	// ISI_PDECF: ISI Preview Decimation Factor Register
	ISI_ISI_PDECF_DEC_FACTOR_Pos = 0x0  // Position of DEC_FACTOR field.
	ISI_ISI_PDECF_DEC_FACTOR_Msk = 0xff // Bit mask of DEC_FACTOR field.

	// ISI_Y2R_SET0: ISI CSC YCrCb To RGB Set 0 Register
	ISI_ISI_Y2R_SET0_C0_Pos = 0x0        // Position of C0 field.
	ISI_ISI_Y2R_SET0_C0_Msk = 0xff       // Bit mask of C0 field.
	ISI_ISI_Y2R_SET0_C1_Pos = 0x8        // Position of C1 field.
	ISI_ISI_Y2R_SET0_C1_Msk = 0xff00     // Bit mask of C1 field.
	ISI_ISI_Y2R_SET0_C2_Pos = 0x10       // Position of C2 field.
	ISI_ISI_Y2R_SET0_C2_Msk = 0xff0000   // Bit mask of C2 field.
	ISI_ISI_Y2R_SET0_C3_Pos = 0x18       // Position of C3 field.
	ISI_ISI_Y2R_SET0_C3_Msk = 0xff000000 // Bit mask of C3 field.

	// ISI_Y2R_SET1: ISI CSC YCrCb To RGB Set 1 Register
	ISI_ISI_Y2R_SET1_C4_Pos    = 0x0    // Position of C4 field.
	ISI_ISI_Y2R_SET1_C4_Msk    = 0x1ff  // Bit mask of C4 field.
	ISI_ISI_Y2R_SET1_Yoff_Pos  = 0xc    // Position of Yoff field.
	ISI_ISI_Y2R_SET1_Yoff_Msk  = 0x1000 // Bit mask of Yoff field.
	ISI_ISI_Y2R_SET1_Yoff      = 0x1000 // Bit Yoff.
	ISI_ISI_Y2R_SET1_Croff_Pos = 0xd    // Position of Croff field.
	ISI_ISI_Y2R_SET1_Croff_Msk = 0x2000 // Bit mask of Croff field.
	ISI_ISI_Y2R_SET1_Croff     = 0x2000 // Bit Croff.
	ISI_ISI_Y2R_SET1_Cboff_Pos = 0xe    // Position of Cboff field.
	ISI_ISI_Y2R_SET1_Cboff_Msk = 0x4000 // Bit mask of Cboff field.
	ISI_ISI_Y2R_SET1_Cboff     = 0x4000 // Bit Cboff.

	// ISI_R2Y_SET0: ISI CSC RGB To YCrCb Set 0 Register
	ISI_ISI_R2Y_SET0_C0_Pos   = 0x0       // Position of C0 field.
	ISI_ISI_R2Y_SET0_C0_Msk   = 0xff      // Bit mask of C0 field.
	ISI_ISI_R2Y_SET0_C1_Pos   = 0x8       // Position of C1 field.
	ISI_ISI_R2Y_SET0_C1_Msk   = 0xff00    // Bit mask of C1 field.
	ISI_ISI_R2Y_SET0_C2_Pos   = 0x10      // Position of C2 field.
	ISI_ISI_R2Y_SET0_C2_Msk   = 0xff0000  // Bit mask of C2 field.
	ISI_ISI_R2Y_SET0_Roff_Pos = 0x18      // Position of Roff field.
	ISI_ISI_R2Y_SET0_Roff_Msk = 0x1000000 // Bit mask of Roff field.
	ISI_ISI_R2Y_SET0_Roff     = 0x1000000 // Bit Roff.

	// ISI_R2Y_SET1: ISI CSC RGB To YCrCb Set 1 Register
	ISI_ISI_R2Y_SET1_C3_Pos   = 0x0       // Position of C3 field.
	ISI_ISI_R2Y_SET1_C3_Msk   = 0xff      // Bit mask of C3 field.
	ISI_ISI_R2Y_SET1_C4_Pos   = 0x8       // Position of C4 field.
	ISI_ISI_R2Y_SET1_C4_Msk   = 0xff00    // Bit mask of C4 field.
	ISI_ISI_R2Y_SET1_C5_Pos   = 0x10      // Position of C5 field.
	ISI_ISI_R2Y_SET1_C5_Msk   = 0xff0000  // Bit mask of C5 field.
	ISI_ISI_R2Y_SET1_Goff_Pos = 0x18      // Position of Goff field.
	ISI_ISI_R2Y_SET1_Goff_Msk = 0x1000000 // Bit mask of Goff field.
	ISI_ISI_R2Y_SET1_Goff     = 0x1000000 // Bit Goff.

	// ISI_R2Y_SET2: ISI CSC RGB To YCrCb Set 2 Register
	ISI_ISI_R2Y_SET2_C6_Pos   = 0x0       // Position of C6 field.
	ISI_ISI_R2Y_SET2_C6_Msk   = 0xff      // Bit mask of C6 field.
	ISI_ISI_R2Y_SET2_C7_Pos   = 0x8       // Position of C7 field.
	ISI_ISI_R2Y_SET2_C7_Msk   = 0xff00    // Bit mask of C7 field.
	ISI_ISI_R2Y_SET2_C8_Pos   = 0x10      // Position of C8 field.
	ISI_ISI_R2Y_SET2_C8_Msk   = 0xff0000  // Bit mask of C8 field.
	ISI_ISI_R2Y_SET2_Boff_Pos = 0x18      // Position of Boff field.
	ISI_ISI_R2Y_SET2_Boff_Msk = 0x1000000 // Bit mask of Boff field.
	ISI_ISI_R2Y_SET2_Boff     = 0x1000000 // Bit Boff.

	// ISI_CR: ISI Control Register
	ISI_ISI_CR_ISI_EN_Pos   = 0x0   // Position of ISI_EN field.
	ISI_ISI_CR_ISI_EN_Msk   = 0x1   // Bit mask of ISI_EN field.
	ISI_ISI_CR_ISI_EN       = 0x1   // Bit ISI_EN.
	ISI_ISI_CR_ISI_DIS_Pos  = 0x1   // Position of ISI_DIS field.
	ISI_ISI_CR_ISI_DIS_Msk  = 0x2   // Bit mask of ISI_DIS field.
	ISI_ISI_CR_ISI_DIS      = 0x2   // Bit ISI_DIS.
	ISI_ISI_CR_ISI_SRST_Pos = 0x2   // Position of ISI_SRST field.
	ISI_ISI_CR_ISI_SRST_Msk = 0x4   // Bit mask of ISI_SRST field.
	ISI_ISI_CR_ISI_SRST     = 0x4   // Bit ISI_SRST.
	ISI_ISI_CR_ISI_CDC_Pos  = 0x8   // Position of ISI_CDC field.
	ISI_ISI_CR_ISI_CDC_Msk  = 0x100 // Bit mask of ISI_CDC field.
	ISI_ISI_CR_ISI_CDC      = 0x100 // Bit ISI_CDC.

	// ISI_SR: ISI Status Register
	ISI_ISI_SR_ENABLE_Pos    = 0x0       // Position of ENABLE field.
	ISI_ISI_SR_ENABLE_Msk    = 0x1       // Bit mask of ENABLE field.
	ISI_ISI_SR_ENABLE        = 0x1       // Bit ENABLE.
	ISI_ISI_SR_DIS_DONE_Pos  = 0x1       // Position of DIS_DONE field.
	ISI_ISI_SR_DIS_DONE_Msk  = 0x2       // Bit mask of DIS_DONE field.
	ISI_ISI_SR_DIS_DONE      = 0x2       // Bit DIS_DONE.
	ISI_ISI_SR_SRST_Pos      = 0x2       // Position of SRST field.
	ISI_ISI_SR_SRST_Msk      = 0x4       // Bit mask of SRST field.
	ISI_ISI_SR_SRST          = 0x4       // Bit SRST.
	ISI_ISI_SR_CDC_PND_Pos   = 0x8       // Position of CDC_PND field.
	ISI_ISI_SR_CDC_PND_Msk   = 0x100     // Bit mask of CDC_PND field.
	ISI_ISI_SR_CDC_PND       = 0x100     // Bit CDC_PND.
	ISI_ISI_SR_VSYNC_Pos     = 0xa       // Position of VSYNC field.
	ISI_ISI_SR_VSYNC_Msk     = 0x400     // Bit mask of VSYNC field.
	ISI_ISI_SR_VSYNC         = 0x400     // Bit VSYNC.
	ISI_ISI_SR_PXFR_DONE_Pos = 0x10      // Position of PXFR_DONE field.
	ISI_ISI_SR_PXFR_DONE_Msk = 0x10000   // Bit mask of PXFR_DONE field.
	ISI_ISI_SR_PXFR_DONE     = 0x10000   // Bit PXFR_DONE.
	ISI_ISI_SR_CXFR_DONE_Pos = 0x11      // Position of CXFR_DONE field.
	ISI_ISI_SR_CXFR_DONE_Msk = 0x20000   // Bit mask of CXFR_DONE field.
	ISI_ISI_SR_CXFR_DONE     = 0x20000   // Bit CXFR_DONE.
	ISI_ISI_SR_SIP_Pos       = 0x13      // Position of SIP field.
	ISI_ISI_SR_SIP_Msk       = 0x80000   // Bit mask of SIP field.
	ISI_ISI_SR_SIP           = 0x80000   // Bit SIP.
	ISI_ISI_SR_P_OVR_Pos     = 0x18      // Position of P_OVR field.
	ISI_ISI_SR_P_OVR_Msk     = 0x1000000 // Bit mask of P_OVR field.
	ISI_ISI_SR_P_OVR         = 0x1000000 // Bit P_OVR.
	ISI_ISI_SR_C_OVR_Pos     = 0x19      // Position of C_OVR field.
	ISI_ISI_SR_C_OVR_Msk     = 0x2000000 // Bit mask of C_OVR field.
	ISI_ISI_SR_C_OVR         = 0x2000000 // Bit C_OVR.
	ISI_ISI_SR_CRC_ERR_Pos   = 0x1a      // Position of CRC_ERR field.
	ISI_ISI_SR_CRC_ERR_Msk   = 0x4000000 // Bit mask of CRC_ERR field.
	ISI_ISI_SR_CRC_ERR       = 0x4000000 // Bit CRC_ERR.
	ISI_ISI_SR_FR_OVR_Pos    = 0x1b      // Position of FR_OVR field.
	ISI_ISI_SR_FR_OVR_Msk    = 0x8000000 // Bit mask of FR_OVR field.
	ISI_ISI_SR_FR_OVR        = 0x8000000 // Bit FR_OVR.

	// ISI_IER: ISI Interrupt Enable Register
	ISI_ISI_IER_DIS_DONE_Pos  = 0x1       // Position of DIS_DONE field.
	ISI_ISI_IER_DIS_DONE_Msk  = 0x2       // Bit mask of DIS_DONE field.
	ISI_ISI_IER_DIS_DONE      = 0x2       // Bit DIS_DONE.
	ISI_ISI_IER_SRST_Pos      = 0x2       // Position of SRST field.
	ISI_ISI_IER_SRST_Msk      = 0x4       // Bit mask of SRST field.
	ISI_ISI_IER_SRST          = 0x4       // Bit SRST.
	ISI_ISI_IER_VSYNC_Pos     = 0xa       // Position of VSYNC field.
	ISI_ISI_IER_VSYNC_Msk     = 0x400     // Bit mask of VSYNC field.
	ISI_ISI_IER_VSYNC         = 0x400     // Bit VSYNC.
	ISI_ISI_IER_PXFR_DONE_Pos = 0x10      // Position of PXFR_DONE field.
	ISI_ISI_IER_PXFR_DONE_Msk = 0x10000   // Bit mask of PXFR_DONE field.
	ISI_ISI_IER_PXFR_DONE     = 0x10000   // Bit PXFR_DONE.
	ISI_ISI_IER_CXFR_DONE_Pos = 0x11      // Position of CXFR_DONE field.
	ISI_ISI_IER_CXFR_DONE_Msk = 0x20000   // Bit mask of CXFR_DONE field.
	ISI_ISI_IER_CXFR_DONE     = 0x20000   // Bit CXFR_DONE.
	ISI_ISI_IER_P_OVR_Pos     = 0x18      // Position of P_OVR field.
	ISI_ISI_IER_P_OVR_Msk     = 0x1000000 // Bit mask of P_OVR field.
	ISI_ISI_IER_P_OVR         = 0x1000000 // Bit P_OVR.
	ISI_ISI_IER_C_OVR_Pos     = 0x19      // Position of C_OVR field.
	ISI_ISI_IER_C_OVR_Msk     = 0x2000000 // Bit mask of C_OVR field.
	ISI_ISI_IER_C_OVR         = 0x2000000 // Bit C_OVR.
	ISI_ISI_IER_CRC_ERR_Pos   = 0x1a      // Position of CRC_ERR field.
	ISI_ISI_IER_CRC_ERR_Msk   = 0x4000000 // Bit mask of CRC_ERR field.
	ISI_ISI_IER_CRC_ERR       = 0x4000000 // Bit CRC_ERR.
	ISI_ISI_IER_FR_OVR_Pos    = 0x1b      // Position of FR_OVR field.
	ISI_ISI_IER_FR_OVR_Msk    = 0x8000000 // Bit mask of FR_OVR field.
	ISI_ISI_IER_FR_OVR        = 0x8000000 // Bit FR_OVR.

	// ISI_IDR: ISI Interrupt Disable Register
	ISI_ISI_IDR_DIS_DONE_Pos  = 0x1       // Position of DIS_DONE field.
	ISI_ISI_IDR_DIS_DONE_Msk  = 0x2       // Bit mask of DIS_DONE field.
	ISI_ISI_IDR_DIS_DONE      = 0x2       // Bit DIS_DONE.
	ISI_ISI_IDR_SRST_Pos      = 0x2       // Position of SRST field.
	ISI_ISI_IDR_SRST_Msk      = 0x4       // Bit mask of SRST field.
	ISI_ISI_IDR_SRST          = 0x4       // Bit SRST.
	ISI_ISI_IDR_VSYNC_Pos     = 0xa       // Position of VSYNC field.
	ISI_ISI_IDR_VSYNC_Msk     = 0x400     // Bit mask of VSYNC field.
	ISI_ISI_IDR_VSYNC         = 0x400     // Bit VSYNC.
	ISI_ISI_IDR_PXFR_DONE_Pos = 0x10      // Position of PXFR_DONE field.
	ISI_ISI_IDR_PXFR_DONE_Msk = 0x10000   // Bit mask of PXFR_DONE field.
	ISI_ISI_IDR_PXFR_DONE     = 0x10000   // Bit PXFR_DONE.
	ISI_ISI_IDR_CXFR_DONE_Pos = 0x11      // Position of CXFR_DONE field.
	ISI_ISI_IDR_CXFR_DONE_Msk = 0x20000   // Bit mask of CXFR_DONE field.
	ISI_ISI_IDR_CXFR_DONE     = 0x20000   // Bit CXFR_DONE.
	ISI_ISI_IDR_P_OVR_Pos     = 0x18      // Position of P_OVR field.
	ISI_ISI_IDR_P_OVR_Msk     = 0x1000000 // Bit mask of P_OVR field.
	ISI_ISI_IDR_P_OVR         = 0x1000000 // Bit P_OVR.
	ISI_ISI_IDR_C_OVR_Pos     = 0x19      // Position of C_OVR field.
	ISI_ISI_IDR_C_OVR_Msk     = 0x2000000 // Bit mask of C_OVR field.
	ISI_ISI_IDR_C_OVR         = 0x2000000 // Bit C_OVR.
	ISI_ISI_IDR_CRC_ERR_Pos   = 0x1a      // Position of CRC_ERR field.
	ISI_ISI_IDR_CRC_ERR_Msk   = 0x4000000 // Bit mask of CRC_ERR field.
	ISI_ISI_IDR_CRC_ERR       = 0x4000000 // Bit CRC_ERR.
	ISI_ISI_IDR_FR_OVR_Pos    = 0x1b      // Position of FR_OVR field.
	ISI_ISI_IDR_FR_OVR_Msk    = 0x8000000 // Bit mask of FR_OVR field.
	ISI_ISI_IDR_FR_OVR        = 0x8000000 // Bit FR_OVR.

	// ISI_IMR: ISI Interrupt Mask Register
	ISI_ISI_IMR_DIS_DONE_Pos  = 0x1       // Position of DIS_DONE field.
	ISI_ISI_IMR_DIS_DONE_Msk  = 0x2       // Bit mask of DIS_DONE field.
	ISI_ISI_IMR_DIS_DONE      = 0x2       // Bit DIS_DONE.
	ISI_ISI_IMR_SRST_Pos      = 0x2       // Position of SRST field.
	ISI_ISI_IMR_SRST_Msk      = 0x4       // Bit mask of SRST field.
	ISI_ISI_IMR_SRST          = 0x4       // Bit SRST.
	ISI_ISI_IMR_VSYNC_Pos     = 0xa       // Position of VSYNC field.
	ISI_ISI_IMR_VSYNC_Msk     = 0x400     // Bit mask of VSYNC field.
	ISI_ISI_IMR_VSYNC         = 0x400     // Bit VSYNC.
	ISI_ISI_IMR_PXFR_DONE_Pos = 0x10      // Position of PXFR_DONE field.
	ISI_ISI_IMR_PXFR_DONE_Msk = 0x10000   // Bit mask of PXFR_DONE field.
	ISI_ISI_IMR_PXFR_DONE     = 0x10000   // Bit PXFR_DONE.
	ISI_ISI_IMR_CXFR_DONE_Pos = 0x11      // Position of CXFR_DONE field.
	ISI_ISI_IMR_CXFR_DONE_Msk = 0x20000   // Bit mask of CXFR_DONE field.
	ISI_ISI_IMR_CXFR_DONE     = 0x20000   // Bit CXFR_DONE.
	ISI_ISI_IMR_P_OVR_Pos     = 0x18      // Position of P_OVR field.
	ISI_ISI_IMR_P_OVR_Msk     = 0x1000000 // Bit mask of P_OVR field.
	ISI_ISI_IMR_P_OVR         = 0x1000000 // Bit P_OVR.
	ISI_ISI_IMR_C_OVR_Pos     = 0x19      // Position of C_OVR field.
	ISI_ISI_IMR_C_OVR_Msk     = 0x2000000 // Bit mask of C_OVR field.
	ISI_ISI_IMR_C_OVR         = 0x2000000 // Bit C_OVR.
	ISI_ISI_IMR_CRC_ERR_Pos   = 0x1a      // Position of CRC_ERR field.
	ISI_ISI_IMR_CRC_ERR_Msk   = 0x4000000 // Bit mask of CRC_ERR field.
	ISI_ISI_IMR_CRC_ERR       = 0x4000000 // Bit CRC_ERR.
	ISI_ISI_IMR_FR_OVR_Pos    = 0x1b      // Position of FR_OVR field.
	ISI_ISI_IMR_FR_OVR_Msk    = 0x8000000 // Bit mask of FR_OVR field.
	ISI_ISI_IMR_FR_OVR        = 0x8000000 // Bit FR_OVR.

	// DMA_CHER: DMA Channel Enable Register
	ISI_DMA_CHER_P_CH_EN_Pos = 0x0 // Position of P_CH_EN field.
	ISI_DMA_CHER_P_CH_EN_Msk = 0x1 // Bit mask of P_CH_EN field.
	ISI_DMA_CHER_P_CH_EN     = 0x1 // Bit P_CH_EN.
	ISI_DMA_CHER_C_CH_EN_Pos = 0x1 // Position of C_CH_EN field.
	ISI_DMA_CHER_C_CH_EN_Msk = 0x2 // Bit mask of C_CH_EN field.
	ISI_DMA_CHER_C_CH_EN     = 0x2 // Bit C_CH_EN.

	// DMA_CHDR: DMA Channel Disable Register
	ISI_DMA_CHDR_P_CH_DIS_Pos = 0x0 // Position of P_CH_DIS field.
	ISI_DMA_CHDR_P_CH_DIS_Msk = 0x1 // Bit mask of P_CH_DIS field.
	ISI_DMA_CHDR_P_CH_DIS     = 0x1 // Bit P_CH_DIS.
	ISI_DMA_CHDR_C_CH_DIS_Pos = 0x1 // Position of C_CH_DIS field.
	ISI_DMA_CHDR_C_CH_DIS_Msk = 0x2 // Bit mask of C_CH_DIS field.
	ISI_DMA_CHDR_C_CH_DIS     = 0x2 // Bit C_CH_DIS.

	// DMA_CHSR: DMA Channel Status Register
	ISI_DMA_CHSR_P_CH_S_Pos = 0x0 // Position of P_CH_S field.
	ISI_DMA_CHSR_P_CH_S_Msk = 0x1 // Bit mask of P_CH_S field.
	ISI_DMA_CHSR_P_CH_S     = 0x1 // Bit P_CH_S.
	ISI_DMA_CHSR_C_CH_S_Pos = 0x1 // Position of C_CH_S field.
	ISI_DMA_CHSR_C_CH_S_Msk = 0x2 // Bit mask of C_CH_S field.
	ISI_DMA_CHSR_C_CH_S     = 0x2 // Bit C_CH_S.

	// DMA_P_ADDR: DMA Preview Base Address Register
	ISI_DMA_P_ADDR_P_ADDR_Pos = 0x2        // Position of P_ADDR field.
	ISI_DMA_P_ADDR_P_ADDR_Msk = 0xfffffffc // Bit mask of P_ADDR field.

	// DMA_P_CTRL: DMA Preview Control Register
	ISI_DMA_P_CTRL_P_FETCH_Pos = 0x0 // Position of P_FETCH field.
	ISI_DMA_P_CTRL_P_FETCH_Msk = 0x1 // Bit mask of P_FETCH field.
	ISI_DMA_P_CTRL_P_FETCH     = 0x1 // Bit P_FETCH.
	ISI_DMA_P_CTRL_P_WB_Pos    = 0x1 // Position of P_WB field.
	ISI_DMA_P_CTRL_P_WB_Msk    = 0x2 // Bit mask of P_WB field.
	ISI_DMA_P_CTRL_P_WB        = 0x2 // Bit P_WB.
	ISI_DMA_P_CTRL_P_IEN_Pos   = 0x2 // Position of P_IEN field.
	ISI_DMA_P_CTRL_P_IEN_Msk   = 0x4 // Bit mask of P_IEN field.
	ISI_DMA_P_CTRL_P_IEN       = 0x4 // Bit P_IEN.
	ISI_DMA_P_CTRL_P_DONE_Pos  = 0x3 // Position of P_DONE field.
	ISI_DMA_P_CTRL_P_DONE_Msk  = 0x8 // Bit mask of P_DONE field.
	ISI_DMA_P_CTRL_P_DONE      = 0x8 // Bit P_DONE.

	// DMA_P_DSCR: DMA Preview Descriptor Address Register
	ISI_DMA_P_DSCR_P_DSCR_Pos = 0x2        // Position of P_DSCR field.
	ISI_DMA_P_DSCR_P_DSCR_Msk = 0xfffffffc // Bit mask of P_DSCR field.

	// DMA_C_ADDR: DMA Codec Base Address Register
	ISI_DMA_C_ADDR_C_ADDR_Pos = 0x2        // Position of C_ADDR field.
	ISI_DMA_C_ADDR_C_ADDR_Msk = 0xfffffffc // Bit mask of C_ADDR field.

	// DMA_C_CTRL: DMA Codec Control Register
	ISI_DMA_C_CTRL_C_FETCH_Pos = 0x0 // Position of C_FETCH field.
	ISI_DMA_C_CTRL_C_FETCH_Msk = 0x1 // Bit mask of C_FETCH field.
	ISI_DMA_C_CTRL_C_FETCH     = 0x1 // Bit C_FETCH.
	ISI_DMA_C_CTRL_C_WB_Pos    = 0x1 // Position of C_WB field.
	ISI_DMA_C_CTRL_C_WB_Msk    = 0x2 // Bit mask of C_WB field.
	ISI_DMA_C_CTRL_C_WB        = 0x2 // Bit C_WB.
	ISI_DMA_C_CTRL_C_IEN_Pos   = 0x2 // Position of C_IEN field.
	ISI_DMA_C_CTRL_C_IEN_Msk   = 0x4 // Bit mask of C_IEN field.
	ISI_DMA_C_CTRL_C_IEN       = 0x4 // Bit C_IEN.
	ISI_DMA_C_CTRL_C_DONE_Pos  = 0x3 // Position of C_DONE field.
	ISI_DMA_C_CTRL_C_DONE_Msk  = 0x8 // Bit mask of C_DONE field.
	ISI_DMA_C_CTRL_C_DONE      = 0x8 // Bit C_DONE.

	// DMA_C_DSCR: DMA Codec Descriptor Address Register
	ISI_DMA_C_DSCR_C_DSCR_Pos = 0x2        // Position of C_DSCR field.
	ISI_DMA_C_DSCR_C_DSCR_Msk = 0xfffffffc // Bit mask of C_DSCR field.

	// ISI_WPCR: Write Protection Control Register
	ISI_ISI_WPCR_WP_EN_Pos  = 0x0        // Position of WP_EN field.
	ISI_ISI_WPCR_WP_EN_Msk  = 0x1        // Bit mask of WP_EN field.
	ISI_ISI_WPCR_WP_EN      = 0x1        // Bit WP_EN.
	ISI_ISI_WPCR_WP_KEY_Pos = 0x8        // Position of WP_KEY field.
	ISI_ISI_WPCR_WP_KEY_Msk = 0xffffff00 // Bit mask of WP_KEY field.

	// ISI_WPSR: Write Protection Status Register
	ISI_ISI_WPSR_WP_VS_Pos   = 0x0      // Position of WP_VS field.
	ISI_ISI_WPSR_WP_VS_Msk   = 0xf      // Bit mask of WP_VS field.
	ISI_ISI_WPSR_WP_VSRC_Pos = 0x8      // Position of WP_VSRC field.
	ISI_ISI_WPSR_WP_VSRC_Msk = 0xffff00 // Bit mask of WP_VSRC field.
)

// Bitfields for PWM: Pulse Width Modulation Controller
const (
	// MR: PWM Mode Register
	PWM_MR_DIVA_Pos        = 0x0       // Position of DIVA field.
	PWM_MR_DIVA_Msk        = 0xff      // Bit mask of DIVA field.
	PWM_MR_DIVA_CLK_OFF    = 0x0       // CLKA, CLKB clock is turned off
	PWM_MR_DIVA_CLK_DIV1   = 0x1       // CLKA, CLKB clock is clock selected by PREA, PREB
	PWM_MR_PREA_Pos        = 0x8       // Position of PREA field.
	PWM_MR_PREA_Msk        = 0xf00     // Bit mask of PREA field.
	PWM_MR_PREA_MCK        = 0x0       // Master Clock
	PWM_MR_PREA_MCKDIV2    = 0x1       // Master Clock divided by 2
	PWM_MR_PREA_MCKDIV4    = 0x2       // Master Clock divided by 4
	PWM_MR_PREA_MCKDIV8    = 0x3       // Master Clock divided by 8
	PWM_MR_PREA_MCKDIV16   = 0x4       // Master Clock divided by 16
	PWM_MR_PREA_MCKDIV32   = 0x5       // Master Clock divided by 32
	PWM_MR_PREA_MCKDIV64   = 0x6       // Master Clock divided by 64
	PWM_MR_PREA_MCKDIV128  = 0x7       // Master Clock divided by 128
	PWM_MR_PREA_MCKDIV256  = 0x8       // Master Clock divided by 256
	PWM_MR_PREA_MCKDIV512  = 0x9       // Master Clock divided by 512
	PWM_MR_PREA_MCKDIV1024 = 0xa       // Master Clock divided by 1024
	PWM_MR_DIVB_Pos        = 0x10      // Position of DIVB field.
	PWM_MR_DIVB_Msk        = 0xff0000  // Bit mask of DIVB field.
	PWM_MR_DIVB_CLK_OFF    = 0x0       // CLKA, CLKB clock is turned off
	PWM_MR_DIVB_CLK_DIV1   = 0x1       // CLKA, CLKB clock is clock selected by PREA, PREB
	PWM_MR_PREB_Pos        = 0x18      // Position of PREB field.
	PWM_MR_PREB_Msk        = 0xf000000 // Bit mask of PREB field.
	PWM_MR_PREB_MCK        = 0x0       // Master Clock
	PWM_MR_PREB_MCKDIV2    = 0x1       // Master Clock divided by 2
	PWM_MR_PREB_MCKDIV4    = 0x2       // Master Clock divided by 4
	PWM_MR_PREB_MCKDIV8    = 0x3       // Master Clock divided by 8
	PWM_MR_PREB_MCKDIV16   = 0x4       // Master Clock divided by 16
	PWM_MR_PREB_MCKDIV32   = 0x5       // Master Clock divided by 32
	PWM_MR_PREB_MCKDIV64   = 0x6       // Master Clock divided by 64
	PWM_MR_PREB_MCKDIV128  = 0x7       // Master Clock divided by 128
	PWM_MR_PREB_MCKDIV256  = 0x8       // Master Clock divided by 256
	PWM_MR_PREB_MCKDIV512  = 0x9       // Master Clock divided by 512
	PWM_MR_PREB_MCKDIV1024 = 0xa       // Master Clock divided by 1024

	// ENA: PWM Enable Register
	PWM_ENA_CHID0_Pos = 0x0 // Position of CHID0 field.
	PWM_ENA_CHID0_Msk = 0x1 // Bit mask of CHID0 field.
	PWM_ENA_CHID0     = 0x1 // Bit CHID0.
	PWM_ENA_CHID1_Pos = 0x1 // Position of CHID1 field.
	PWM_ENA_CHID1_Msk = 0x2 // Bit mask of CHID1 field.
	PWM_ENA_CHID1     = 0x2 // Bit CHID1.
	PWM_ENA_CHID2_Pos = 0x2 // Position of CHID2 field.
	PWM_ENA_CHID2_Msk = 0x4 // Bit mask of CHID2 field.
	PWM_ENA_CHID2     = 0x4 // Bit CHID2.
	PWM_ENA_CHID3_Pos = 0x3 // Position of CHID3 field.
	PWM_ENA_CHID3_Msk = 0x8 // Bit mask of CHID3 field.
	PWM_ENA_CHID3     = 0x8 // Bit CHID3.

	// DIS: PWM Disable Register
	PWM_DIS_CHID0_Pos = 0x0 // Position of CHID0 field.
	PWM_DIS_CHID0_Msk = 0x1 // Bit mask of CHID0 field.
	PWM_DIS_CHID0     = 0x1 // Bit CHID0.
	PWM_DIS_CHID1_Pos = 0x1 // Position of CHID1 field.
	PWM_DIS_CHID1_Msk = 0x2 // Bit mask of CHID1 field.
	PWM_DIS_CHID1     = 0x2 // Bit CHID1.
	PWM_DIS_CHID2_Pos = 0x2 // Position of CHID2 field.
	PWM_DIS_CHID2_Msk = 0x4 // Bit mask of CHID2 field.
	PWM_DIS_CHID2     = 0x4 // Bit CHID2.
	PWM_DIS_CHID3_Pos = 0x3 // Position of CHID3 field.
	PWM_DIS_CHID3_Msk = 0x8 // Bit mask of CHID3 field.
	PWM_DIS_CHID3     = 0x8 // Bit CHID3.

	// SR: PWM Status Register
	PWM_SR_CHID0_Pos = 0x0 // Position of CHID0 field.
	PWM_SR_CHID0_Msk = 0x1 // Bit mask of CHID0 field.
	PWM_SR_CHID0     = 0x1 // Bit CHID0.
	PWM_SR_CHID1_Pos = 0x1 // Position of CHID1 field.
	PWM_SR_CHID1_Msk = 0x2 // Bit mask of CHID1 field.
	PWM_SR_CHID1     = 0x2 // Bit CHID1.
	PWM_SR_CHID2_Pos = 0x2 // Position of CHID2 field.
	PWM_SR_CHID2_Msk = 0x4 // Bit mask of CHID2 field.
	PWM_SR_CHID2     = 0x4 // Bit CHID2.
	PWM_SR_CHID3_Pos = 0x3 // Position of CHID3 field.
	PWM_SR_CHID3_Msk = 0x8 // Bit mask of CHID3 field.
	PWM_SR_CHID3     = 0x8 // Bit CHID3.

	// IER: PWM Interrupt Enable Register
	PWM_IER_CHID0_Pos = 0x0 // Position of CHID0 field.
	PWM_IER_CHID0_Msk = 0x1 // Bit mask of CHID0 field.
	PWM_IER_CHID0     = 0x1 // Bit CHID0.
	PWM_IER_CHID1_Pos = 0x1 // Position of CHID1 field.
	PWM_IER_CHID1_Msk = 0x2 // Bit mask of CHID1 field.
	PWM_IER_CHID1     = 0x2 // Bit CHID1.
	PWM_IER_CHID2_Pos = 0x2 // Position of CHID2 field.
	PWM_IER_CHID2_Msk = 0x4 // Bit mask of CHID2 field.
	PWM_IER_CHID2     = 0x4 // Bit CHID2.
	PWM_IER_CHID3_Pos = 0x3 // Position of CHID3 field.
	PWM_IER_CHID3_Msk = 0x8 // Bit mask of CHID3 field.
	PWM_IER_CHID3     = 0x8 // Bit CHID3.

	// IDR: PWM Interrupt Disable Register
	PWM_IDR_CHID0_Pos = 0x0 // Position of CHID0 field.
	PWM_IDR_CHID0_Msk = 0x1 // Bit mask of CHID0 field.
	PWM_IDR_CHID0     = 0x1 // Bit CHID0.
	PWM_IDR_CHID1_Pos = 0x1 // Position of CHID1 field.
	PWM_IDR_CHID1_Msk = 0x2 // Bit mask of CHID1 field.
	PWM_IDR_CHID1     = 0x2 // Bit CHID1.
	PWM_IDR_CHID2_Pos = 0x2 // Position of CHID2 field.
	PWM_IDR_CHID2_Msk = 0x4 // Bit mask of CHID2 field.
	PWM_IDR_CHID2     = 0x4 // Bit CHID2.
	PWM_IDR_CHID3_Pos = 0x3 // Position of CHID3 field.
	PWM_IDR_CHID3_Msk = 0x8 // Bit mask of CHID3 field.
	PWM_IDR_CHID3     = 0x8 // Bit CHID3.

	// IMR: PWM Interrupt Mask Register
	PWM_IMR_CHID0_Pos = 0x0 // Position of CHID0 field.
	PWM_IMR_CHID0_Msk = 0x1 // Bit mask of CHID0 field.
	PWM_IMR_CHID0     = 0x1 // Bit CHID0.
	PWM_IMR_CHID1_Pos = 0x1 // Position of CHID1 field.
	PWM_IMR_CHID1_Msk = 0x2 // Bit mask of CHID1 field.
	PWM_IMR_CHID1     = 0x2 // Bit CHID1.
	PWM_IMR_CHID2_Pos = 0x2 // Position of CHID2 field.
	PWM_IMR_CHID2_Msk = 0x4 // Bit mask of CHID2 field.
	PWM_IMR_CHID2     = 0x4 // Bit CHID2.
	PWM_IMR_CHID3_Pos = 0x3 // Position of CHID3 field.
	PWM_IMR_CHID3_Msk = 0x8 // Bit mask of CHID3 field.
	PWM_IMR_CHID3     = 0x8 // Bit CHID3.

	// ISR: PWM Interrupt Status Register
	PWM_ISR_CHID0_Pos = 0x0 // Position of CHID0 field.
	PWM_ISR_CHID0_Msk = 0x1 // Bit mask of CHID0 field.
	PWM_ISR_CHID0     = 0x1 // Bit CHID0.
	PWM_ISR_CHID1_Pos = 0x1 // Position of CHID1 field.
	PWM_ISR_CHID1_Msk = 0x2 // Bit mask of CHID1 field.
	PWM_ISR_CHID1     = 0x2 // Bit CHID1.
	PWM_ISR_CHID2_Pos = 0x2 // Position of CHID2 field.
	PWM_ISR_CHID2_Msk = 0x4 // Bit mask of CHID2 field.
	PWM_ISR_CHID2     = 0x4 // Bit CHID2.
	PWM_ISR_CHID3_Pos = 0x3 // Position of CHID3 field.
	PWM_ISR_CHID3_Msk = 0x8 // Bit mask of CHID3 field.
	PWM_ISR_CHID3     = 0x8 // Bit CHID3.

	// CMR0: PWM Channel Mode Register (ch_num = 0)
	PWM_CMR0_CPRE_Pos        = 0x0   // Position of CPRE field.
	PWM_CMR0_CPRE_Msk        = 0xf   // Bit mask of CPRE field.
	PWM_CMR0_CPRE_MCK        = 0x0   // Master Clock
	PWM_CMR0_CPRE_MCKDIV2    = 0x1   // Master Clock divided by 2
	PWM_CMR0_CPRE_MCKDIV4    = 0x2   // Master Clock divided by 4
	PWM_CMR0_CPRE_MCKDIV8    = 0x3   // Master Clock divided by 8
	PWM_CMR0_CPRE_MCKDIV16   = 0x4   // Master Clock divided by 16
	PWM_CMR0_CPRE_MCKDIV32   = 0x5   // Master Clock divided by 32
	PWM_CMR0_CPRE_MCKDIV64   = 0x6   // Master Clock divided by 64
	PWM_CMR0_CPRE_MCKDIV128  = 0x7   // Master Clock divided by 128
	PWM_CMR0_CPRE_MCKDIV256  = 0x8   // Master Clock divided by 256
	PWM_CMR0_CPRE_MCKDIV512  = 0x9   // Master Clock divided by 512
	PWM_CMR0_CPRE_MCKDIV1024 = 0xa   // Master Clock divided by 1024
	PWM_CMR0_CPRE_CLKA       = 0xb   // Clock A
	PWM_CMR0_CPRE_CLKB       = 0xc   // Clock B
	PWM_CMR0_CALG_Pos        = 0x8   // Position of CALG field.
	PWM_CMR0_CALG_Msk        = 0x100 // Bit mask of CALG field.
	PWM_CMR0_CALG            = 0x100 // Bit CALG.
	PWM_CMR0_CPOL_Pos        = 0x9   // Position of CPOL field.
	PWM_CMR0_CPOL_Msk        = 0x200 // Bit mask of CPOL field.
	PWM_CMR0_CPOL            = 0x200 // Bit CPOL.
	PWM_CMR0_CPD_Pos         = 0xa   // Position of CPD field.
	PWM_CMR0_CPD_Msk         = 0x400 // Bit mask of CPD field.
	PWM_CMR0_CPD             = 0x400 // Bit CPD.

	// CDTY0: PWM Channel Duty Cycle Register (ch_num = 0)
	PWM_CDTY0_CDTY_Pos = 0x0        // Position of CDTY field.
	PWM_CDTY0_CDTY_Msk = 0xffffffff // Bit mask of CDTY field.

	// CPRD0: PWM Channel Period Register (ch_num = 0)
	PWM_CPRD0_CPRD_Pos = 0x0        // Position of CPRD field.
	PWM_CPRD0_CPRD_Msk = 0xffffffff // Bit mask of CPRD field.

	// CCNT0: PWM Channel Counter Register (ch_num = 0)
	PWM_CCNT0_CNT_Pos = 0x0        // Position of CNT field.
	PWM_CCNT0_CNT_Msk = 0xffffffff // Bit mask of CNT field.

	// CUPD0: PWM Channel Update Register (ch_num = 0)
	PWM_CUPD0_CUPD_Pos = 0x0        // Position of CUPD field.
	PWM_CUPD0_CUPD_Msk = 0xffffffff // Bit mask of CUPD field.

	// CMR1: PWM Channel Mode Register (ch_num = 1)
	PWM_CMR1_CPRE_Pos        = 0x0   // Position of CPRE field.
	PWM_CMR1_CPRE_Msk        = 0xf   // Bit mask of CPRE field.
	PWM_CMR1_CPRE_MCK        = 0x0   // Master Clock
	PWM_CMR1_CPRE_MCKDIV2    = 0x1   // Master Clock divided by 2
	PWM_CMR1_CPRE_MCKDIV4    = 0x2   // Master Clock divided by 4
	PWM_CMR1_CPRE_MCKDIV8    = 0x3   // Master Clock divided by 8
	PWM_CMR1_CPRE_MCKDIV16   = 0x4   // Master Clock divided by 16
	PWM_CMR1_CPRE_MCKDIV32   = 0x5   // Master Clock divided by 32
	PWM_CMR1_CPRE_MCKDIV64   = 0x6   // Master Clock divided by 64
	PWM_CMR1_CPRE_MCKDIV128  = 0x7   // Master Clock divided by 128
	PWM_CMR1_CPRE_MCKDIV256  = 0x8   // Master Clock divided by 256
	PWM_CMR1_CPRE_MCKDIV512  = 0x9   // Master Clock divided by 512
	PWM_CMR1_CPRE_MCKDIV1024 = 0xa   // Master Clock divided by 1024
	PWM_CMR1_CPRE_CLKA       = 0xb   // Clock A
	PWM_CMR1_CPRE_CLKB       = 0xc   // Clock B
	PWM_CMR1_CALG_Pos        = 0x8   // Position of CALG field.
	PWM_CMR1_CALG_Msk        = 0x100 // Bit mask of CALG field.
	PWM_CMR1_CALG            = 0x100 // Bit CALG.
	PWM_CMR1_CPOL_Pos        = 0x9   // Position of CPOL field.
	PWM_CMR1_CPOL_Msk        = 0x200 // Bit mask of CPOL field.
	PWM_CMR1_CPOL            = 0x200 // Bit CPOL.
	PWM_CMR1_CPD_Pos         = 0xa   // Position of CPD field.
	PWM_CMR1_CPD_Msk         = 0x400 // Bit mask of CPD field.
	PWM_CMR1_CPD             = 0x400 // Bit CPD.

	// CDTY1: PWM Channel Duty Cycle Register (ch_num = 1)
	PWM_CDTY1_CDTY_Pos = 0x0        // Position of CDTY field.
	PWM_CDTY1_CDTY_Msk = 0xffffffff // Bit mask of CDTY field.

	// CPRD1: PWM Channel Period Register (ch_num = 1)
	PWM_CPRD1_CPRD_Pos = 0x0        // Position of CPRD field.
	PWM_CPRD1_CPRD_Msk = 0xffffffff // Bit mask of CPRD field.

	// CCNT1: PWM Channel Counter Register (ch_num = 1)
	PWM_CCNT1_CNT_Pos = 0x0        // Position of CNT field.
	PWM_CCNT1_CNT_Msk = 0xffffffff // Bit mask of CNT field.

	// CUPD1: PWM Channel Update Register (ch_num = 1)
	PWM_CUPD1_CUPD_Pos = 0x0        // Position of CUPD field.
	PWM_CUPD1_CUPD_Msk = 0xffffffff // Bit mask of CUPD field.

	// CMR2: PWM Channel Mode Register (ch_num = 2)
	PWM_CMR2_CPRE_Pos        = 0x0   // Position of CPRE field.
	PWM_CMR2_CPRE_Msk        = 0xf   // Bit mask of CPRE field.
	PWM_CMR2_CPRE_MCK        = 0x0   // Master Clock
	PWM_CMR2_CPRE_MCKDIV2    = 0x1   // Master Clock divided by 2
	PWM_CMR2_CPRE_MCKDIV4    = 0x2   // Master Clock divided by 4
	PWM_CMR2_CPRE_MCKDIV8    = 0x3   // Master Clock divided by 8
	PWM_CMR2_CPRE_MCKDIV16   = 0x4   // Master Clock divided by 16
	PWM_CMR2_CPRE_MCKDIV32   = 0x5   // Master Clock divided by 32
	PWM_CMR2_CPRE_MCKDIV64   = 0x6   // Master Clock divided by 64
	PWM_CMR2_CPRE_MCKDIV128  = 0x7   // Master Clock divided by 128
	PWM_CMR2_CPRE_MCKDIV256  = 0x8   // Master Clock divided by 256
	PWM_CMR2_CPRE_MCKDIV512  = 0x9   // Master Clock divided by 512
	PWM_CMR2_CPRE_MCKDIV1024 = 0xa   // Master Clock divided by 1024
	PWM_CMR2_CPRE_CLKA       = 0xb   // Clock A
	PWM_CMR2_CPRE_CLKB       = 0xc   // Clock B
	PWM_CMR2_CALG_Pos        = 0x8   // Position of CALG field.
	PWM_CMR2_CALG_Msk        = 0x100 // Bit mask of CALG field.
	PWM_CMR2_CALG            = 0x100 // Bit CALG.
	PWM_CMR2_CPOL_Pos        = 0x9   // Position of CPOL field.
	PWM_CMR2_CPOL_Msk        = 0x200 // Bit mask of CPOL field.
	PWM_CMR2_CPOL            = 0x200 // Bit CPOL.
	PWM_CMR2_CPD_Pos         = 0xa   // Position of CPD field.
	PWM_CMR2_CPD_Msk         = 0x400 // Bit mask of CPD field.
	PWM_CMR2_CPD             = 0x400 // Bit CPD.

	// CDTY2: PWM Channel Duty Cycle Register (ch_num = 2)
	PWM_CDTY2_CDTY_Pos = 0x0        // Position of CDTY field.
	PWM_CDTY2_CDTY_Msk = 0xffffffff // Bit mask of CDTY field.

	// CPRD2: PWM Channel Period Register (ch_num = 2)
	PWM_CPRD2_CPRD_Pos = 0x0        // Position of CPRD field.
	PWM_CPRD2_CPRD_Msk = 0xffffffff // Bit mask of CPRD field.

	// CCNT2: PWM Channel Counter Register (ch_num = 2)
	PWM_CCNT2_CNT_Pos = 0x0        // Position of CNT field.
	PWM_CCNT2_CNT_Msk = 0xffffffff // Bit mask of CNT field.

	// CUPD2: PWM Channel Update Register (ch_num = 2)
	PWM_CUPD2_CUPD_Pos = 0x0        // Position of CUPD field.
	PWM_CUPD2_CUPD_Msk = 0xffffffff // Bit mask of CUPD field.

	// CMR3: PWM Channel Mode Register (ch_num = 3)
	PWM_CMR3_CPRE_Pos        = 0x0   // Position of CPRE field.
	PWM_CMR3_CPRE_Msk        = 0xf   // Bit mask of CPRE field.
	PWM_CMR3_CPRE_MCK        = 0x0   // Master Clock
	PWM_CMR3_CPRE_MCKDIV2    = 0x1   // Master Clock divided by 2
	PWM_CMR3_CPRE_MCKDIV4    = 0x2   // Master Clock divided by 4
	PWM_CMR3_CPRE_MCKDIV8    = 0x3   // Master Clock divided by 8
	PWM_CMR3_CPRE_MCKDIV16   = 0x4   // Master Clock divided by 16
	PWM_CMR3_CPRE_MCKDIV32   = 0x5   // Master Clock divided by 32
	PWM_CMR3_CPRE_MCKDIV64   = 0x6   // Master Clock divided by 64
	PWM_CMR3_CPRE_MCKDIV128  = 0x7   // Master Clock divided by 128
	PWM_CMR3_CPRE_MCKDIV256  = 0x8   // Master Clock divided by 256
	PWM_CMR3_CPRE_MCKDIV512  = 0x9   // Master Clock divided by 512
	PWM_CMR3_CPRE_MCKDIV1024 = 0xa   // Master Clock divided by 1024
	PWM_CMR3_CPRE_CLKA       = 0xb   // Clock A
	PWM_CMR3_CPRE_CLKB       = 0xc   // Clock B
	PWM_CMR3_CALG_Pos        = 0x8   // Position of CALG field.
	PWM_CMR3_CALG_Msk        = 0x100 // Bit mask of CALG field.
	PWM_CMR3_CALG            = 0x100 // Bit CALG.
	PWM_CMR3_CPOL_Pos        = 0x9   // Position of CPOL field.
	PWM_CMR3_CPOL_Msk        = 0x200 // Bit mask of CPOL field.
	PWM_CMR3_CPOL            = 0x200 // Bit CPOL.
	PWM_CMR3_CPD_Pos         = 0xa   // Position of CPD field.
	PWM_CMR3_CPD_Msk         = 0x400 // Bit mask of CPD field.
	PWM_CMR3_CPD             = 0x400 // Bit CPD.

	// CDTY3: PWM Channel Duty Cycle Register (ch_num = 3)
	PWM_CDTY3_CDTY_Pos = 0x0        // Position of CDTY field.
	PWM_CDTY3_CDTY_Msk = 0xffffffff // Bit mask of CDTY field.

	// CPRD3: PWM Channel Period Register (ch_num = 3)
	PWM_CPRD3_CPRD_Pos = 0x0        // Position of CPRD field.
	PWM_CPRD3_CPRD_Msk = 0xffffffff // Bit mask of CPRD field.

	// CCNT3: PWM Channel Counter Register (ch_num = 3)
	PWM_CCNT3_CNT_Pos = 0x0        // Position of CNT field.
	PWM_CCNT3_CNT_Msk = 0xffffffff // Bit mask of CNT field.

	// CUPD3: PWM Channel Update Register (ch_num = 3)
	PWM_CUPD3_CUPD_Pos = 0x0        // Position of CUPD field.
	PWM_CUPD3_CUPD_Msk = 0xffffffff // Bit mask of CUPD field.
)

// Bitfields for EMAC: Ethernet MAC 10/100
const (
	// NCR: Network Control Register
	EMAC_NCR_LB_Pos      = 0x0   // Position of LB field.
	EMAC_NCR_LB_Msk      = 0x1   // Bit mask of LB field.
	EMAC_NCR_LB          = 0x1   // Bit LB.
	EMAC_NCR_LLB_Pos     = 0x1   // Position of LLB field.
	EMAC_NCR_LLB_Msk     = 0x2   // Bit mask of LLB field.
	EMAC_NCR_LLB         = 0x2   // Bit LLB.
	EMAC_NCR_RE_Pos      = 0x2   // Position of RE field.
	EMAC_NCR_RE_Msk      = 0x4   // Bit mask of RE field.
	EMAC_NCR_RE          = 0x4   // Bit RE.
	EMAC_NCR_TE_Pos      = 0x3   // Position of TE field.
	EMAC_NCR_TE_Msk      = 0x8   // Bit mask of TE field.
	EMAC_NCR_TE          = 0x8   // Bit TE.
	EMAC_NCR_MPE_Pos     = 0x4   // Position of MPE field.
	EMAC_NCR_MPE_Msk     = 0x10  // Bit mask of MPE field.
	EMAC_NCR_MPE         = 0x10  // Bit MPE.
	EMAC_NCR_CLRSTAT_Pos = 0x5   // Position of CLRSTAT field.
	EMAC_NCR_CLRSTAT_Msk = 0x20  // Bit mask of CLRSTAT field.
	EMAC_NCR_CLRSTAT     = 0x20  // Bit CLRSTAT.
	EMAC_NCR_INCSTAT_Pos = 0x6   // Position of INCSTAT field.
	EMAC_NCR_INCSTAT_Msk = 0x40  // Bit mask of INCSTAT field.
	EMAC_NCR_INCSTAT     = 0x40  // Bit INCSTAT.
	EMAC_NCR_WESTAT_Pos  = 0x7   // Position of WESTAT field.
	EMAC_NCR_WESTAT_Msk  = 0x80  // Bit mask of WESTAT field.
	EMAC_NCR_WESTAT      = 0x80  // Bit WESTAT.
	EMAC_NCR_BP_Pos      = 0x8   // Position of BP field.
	EMAC_NCR_BP_Msk      = 0x100 // Bit mask of BP field.
	EMAC_NCR_BP          = 0x100 // Bit BP.
	EMAC_NCR_TSTART_Pos  = 0x9   // Position of TSTART field.
	EMAC_NCR_TSTART_Msk  = 0x200 // Bit mask of TSTART field.
	EMAC_NCR_TSTART      = 0x200 // Bit TSTART.
	EMAC_NCR_THALT_Pos   = 0xa   // Position of THALT field.
	EMAC_NCR_THALT_Msk   = 0x400 // Bit mask of THALT field.
	EMAC_NCR_THALT       = 0x400 // Bit THALT.

	// NCFG: Network Configuration Register
	EMAC_NCFG_SPD_Pos    = 0x0     // Position of SPD field.
	EMAC_NCFG_SPD_Msk    = 0x1     // Bit mask of SPD field.
	EMAC_NCFG_SPD        = 0x1     // Bit SPD.
	EMAC_NCFG_FD_Pos     = 0x1     // Position of FD field.
	EMAC_NCFG_FD_Msk     = 0x2     // Bit mask of FD field.
	EMAC_NCFG_FD         = 0x2     // Bit FD.
	EMAC_NCFG_JFRAME_Pos = 0x3     // Position of JFRAME field.
	EMAC_NCFG_JFRAME_Msk = 0x8     // Bit mask of JFRAME field.
	EMAC_NCFG_JFRAME     = 0x8     // Bit JFRAME.
	EMAC_NCFG_CAF_Pos    = 0x4     // Position of CAF field.
	EMAC_NCFG_CAF_Msk    = 0x10    // Bit mask of CAF field.
	EMAC_NCFG_CAF        = 0x10    // Bit CAF.
	EMAC_NCFG_NBC_Pos    = 0x5     // Position of NBC field.
	EMAC_NCFG_NBC_Msk    = 0x20    // Bit mask of NBC field.
	EMAC_NCFG_NBC        = 0x20    // Bit NBC.
	EMAC_NCFG_MTI_Pos    = 0x6     // Position of MTI field.
	EMAC_NCFG_MTI_Msk    = 0x40    // Bit mask of MTI field.
	EMAC_NCFG_MTI        = 0x40    // Bit MTI.
	EMAC_NCFG_UNI_Pos    = 0x7     // Position of UNI field.
	EMAC_NCFG_UNI_Msk    = 0x80    // Bit mask of UNI field.
	EMAC_NCFG_UNI        = 0x80    // Bit UNI.
	EMAC_NCFG_BIG_Pos    = 0x8     // Position of BIG field.
	EMAC_NCFG_BIG_Msk    = 0x100   // Bit mask of BIG field.
	EMAC_NCFG_BIG        = 0x100   // Bit BIG.
	EMAC_NCFG_CLK_Pos    = 0xa     // Position of CLK field.
	EMAC_NCFG_CLK_Msk    = 0xc00   // Bit mask of CLK field.
	EMAC_NCFG_RTY_Pos    = 0xc     // Position of RTY field.
	EMAC_NCFG_RTY_Msk    = 0x1000  // Bit mask of RTY field.
	EMAC_NCFG_RTY        = 0x1000  // Bit RTY.
	EMAC_NCFG_PAE_Pos    = 0xd     // Position of PAE field.
	EMAC_NCFG_PAE_Msk    = 0x2000  // Bit mask of PAE field.
	EMAC_NCFG_PAE        = 0x2000  // Bit PAE.
	EMAC_NCFG_RBOF_Pos   = 0xe     // Position of RBOF field.
	EMAC_NCFG_RBOF_Msk   = 0xc000  // Bit mask of RBOF field.
	EMAC_NCFG_RLCE_Pos   = 0x10    // Position of RLCE field.
	EMAC_NCFG_RLCE_Msk   = 0x10000 // Bit mask of RLCE field.
	EMAC_NCFG_RLCE       = 0x10000 // Bit RLCE.
	EMAC_NCFG_DRFCS_Pos  = 0x11    // Position of DRFCS field.
	EMAC_NCFG_DRFCS_Msk  = 0x20000 // Bit mask of DRFCS field.
	EMAC_NCFG_DRFCS      = 0x20000 // Bit DRFCS.
	EMAC_NCFG_EFRHD_Pos  = 0x12    // Position of EFRHD field.
	EMAC_NCFG_EFRHD_Msk  = 0x40000 // Bit mask of EFRHD field.
	EMAC_NCFG_EFRHD      = 0x40000 // Bit EFRHD.
	EMAC_NCFG_IRXFCS_Pos = 0x13    // Position of IRXFCS field.
	EMAC_NCFG_IRXFCS_Msk = 0x80000 // Bit mask of IRXFCS field.
	EMAC_NCFG_IRXFCS     = 0x80000 // Bit IRXFCS.

	// NSR: Network Status Register
	EMAC_NSR_MDIO_Pos = 0x1 // Position of MDIO field.
	EMAC_NSR_MDIO_Msk = 0x2 // Bit mask of MDIO field.
	EMAC_NSR_MDIO     = 0x2 // Bit MDIO.
	EMAC_NSR_IDLE_Pos = 0x2 // Position of IDLE field.
	EMAC_NSR_IDLE_Msk = 0x4 // Bit mask of IDLE field.
	EMAC_NSR_IDLE     = 0x4 // Bit IDLE.

	// TSR: Transmit Status Register
	EMAC_TSR_UBR_Pos  = 0x0  // Position of UBR field.
	EMAC_TSR_UBR_Msk  = 0x1  // Bit mask of UBR field.
	EMAC_TSR_UBR      = 0x1  // Bit UBR.
	EMAC_TSR_COL_Pos  = 0x1  // Position of COL field.
	EMAC_TSR_COL_Msk  = 0x2  // Bit mask of COL field.
	EMAC_TSR_COL      = 0x2  // Bit COL.
	EMAC_TSR_RLE_Pos  = 0x2  // Position of RLE field.
	EMAC_TSR_RLE_Msk  = 0x4  // Bit mask of RLE field.
	EMAC_TSR_RLE      = 0x4  // Bit RLE.
	EMAC_TSR_TGO_Pos  = 0x3  // Position of TGO field.
	EMAC_TSR_TGO_Msk  = 0x8  // Bit mask of TGO field.
	EMAC_TSR_TGO      = 0x8  // Bit TGO.
	EMAC_TSR_BEX_Pos  = 0x4  // Position of BEX field.
	EMAC_TSR_BEX_Msk  = 0x10 // Bit mask of BEX field.
	EMAC_TSR_BEX      = 0x10 // Bit BEX.
	EMAC_TSR_COMP_Pos = 0x5  // Position of COMP field.
	EMAC_TSR_COMP_Msk = 0x20 // Bit mask of COMP field.
	EMAC_TSR_COMP     = 0x20 // Bit COMP.
	EMAC_TSR_UND_Pos  = 0x6  // Position of UND field.
	EMAC_TSR_UND_Msk  = 0x40 // Bit mask of UND field.
	EMAC_TSR_UND      = 0x40 // Bit UND.

	// RBQP: Receive Buffer Queue Pointer Register
	EMAC_RBQP_ADDR_Pos = 0x2        // Position of ADDR field.
	EMAC_RBQP_ADDR_Msk = 0xfffffffc // Bit mask of ADDR field.

	// TBQP: Transmit Buffer Queue Pointer Register
	EMAC_TBQP_ADDR_Pos = 0x2        // Position of ADDR field.
	EMAC_TBQP_ADDR_Msk = 0xfffffffc // Bit mask of ADDR field.

	// RSR: Receive Status Register
	EMAC_RSR_BNA_Pos = 0x0 // Position of BNA field.
	EMAC_RSR_BNA_Msk = 0x1 // Bit mask of BNA field.
	EMAC_RSR_BNA     = 0x1 // Bit BNA.
	EMAC_RSR_REC_Pos = 0x1 // Position of REC field.
	EMAC_RSR_REC_Msk = 0x2 // Bit mask of REC field.
	EMAC_RSR_REC     = 0x2 // Bit REC.
	EMAC_RSR_OVR_Pos = 0x2 // Position of OVR field.
	EMAC_RSR_OVR_Msk = 0x4 // Bit mask of OVR field.
	EMAC_RSR_OVR     = 0x4 // Bit OVR.

	// ISR: Interrupt Status Register
	EMAC_ISR_MFD_Pos   = 0x0    // Position of MFD field.
	EMAC_ISR_MFD_Msk   = 0x1    // Bit mask of MFD field.
	EMAC_ISR_MFD       = 0x1    // Bit MFD.
	EMAC_ISR_RCOMP_Pos = 0x1    // Position of RCOMP field.
	EMAC_ISR_RCOMP_Msk = 0x2    // Bit mask of RCOMP field.
	EMAC_ISR_RCOMP     = 0x2    // Bit RCOMP.
	EMAC_ISR_RXUBR_Pos = 0x2    // Position of RXUBR field.
	EMAC_ISR_RXUBR_Msk = 0x4    // Bit mask of RXUBR field.
	EMAC_ISR_RXUBR     = 0x4    // Bit RXUBR.
	EMAC_ISR_TXUBR_Pos = 0x3    // Position of TXUBR field.
	EMAC_ISR_TXUBR_Msk = 0x8    // Bit mask of TXUBR field.
	EMAC_ISR_TXUBR     = 0x8    // Bit TXUBR.
	EMAC_ISR_TUND_Pos  = 0x4    // Position of TUND field.
	EMAC_ISR_TUND_Msk  = 0x10   // Bit mask of TUND field.
	EMAC_ISR_TUND      = 0x10   // Bit TUND.
	EMAC_ISR_RLE_Pos   = 0x5    // Position of RLE field.
	EMAC_ISR_RLE_Msk   = 0x20   // Bit mask of RLE field.
	EMAC_ISR_RLE       = 0x20   // Bit RLE.
	EMAC_ISR_TXERR_Pos = 0x6    // Position of TXERR field.
	EMAC_ISR_TXERR_Msk = 0x40   // Bit mask of TXERR field.
	EMAC_ISR_TXERR     = 0x40   // Bit TXERR.
	EMAC_ISR_TCOMP_Pos = 0x7    // Position of TCOMP field.
	EMAC_ISR_TCOMP_Msk = 0x80   // Bit mask of TCOMP field.
	EMAC_ISR_TCOMP     = 0x80   // Bit TCOMP.
	EMAC_ISR_ROVR_Pos  = 0xa    // Position of ROVR field.
	EMAC_ISR_ROVR_Msk  = 0x400  // Bit mask of ROVR field.
	EMAC_ISR_ROVR      = 0x400  // Bit ROVR.
	EMAC_ISR_HRESP_Pos = 0xb    // Position of HRESP field.
	EMAC_ISR_HRESP_Msk = 0x800  // Bit mask of HRESP field.
	EMAC_ISR_HRESP     = 0x800  // Bit HRESP.
	EMAC_ISR_PFR_Pos   = 0xc    // Position of PFR field.
	EMAC_ISR_PFR_Msk   = 0x1000 // Bit mask of PFR field.
	EMAC_ISR_PFR       = 0x1000 // Bit PFR.
	EMAC_ISR_PTZ_Pos   = 0xd    // Position of PTZ field.
	EMAC_ISR_PTZ_Msk   = 0x2000 // Bit mask of PTZ field.
	EMAC_ISR_PTZ       = 0x2000 // Bit PTZ.

	// IER: Interrupt Enable Register
	EMAC_IER_MFD_Pos   = 0x0    // Position of MFD field.
	EMAC_IER_MFD_Msk   = 0x1    // Bit mask of MFD field.
	EMAC_IER_MFD       = 0x1    // Bit MFD.
	EMAC_IER_RCOMP_Pos = 0x1    // Position of RCOMP field.
	EMAC_IER_RCOMP_Msk = 0x2    // Bit mask of RCOMP field.
	EMAC_IER_RCOMP     = 0x2    // Bit RCOMP.
	EMAC_IER_RXUBR_Pos = 0x2    // Position of RXUBR field.
	EMAC_IER_RXUBR_Msk = 0x4    // Bit mask of RXUBR field.
	EMAC_IER_RXUBR     = 0x4    // Bit RXUBR.
	EMAC_IER_TXUBR_Pos = 0x3    // Position of TXUBR field.
	EMAC_IER_TXUBR_Msk = 0x8    // Bit mask of TXUBR field.
	EMAC_IER_TXUBR     = 0x8    // Bit TXUBR.
	EMAC_IER_TUND_Pos  = 0x4    // Position of TUND field.
	EMAC_IER_TUND_Msk  = 0x10   // Bit mask of TUND field.
	EMAC_IER_TUND      = 0x10   // Bit TUND.
	EMAC_IER_RLE_Pos   = 0x5    // Position of RLE field.
	EMAC_IER_RLE_Msk   = 0x20   // Bit mask of RLE field.
	EMAC_IER_RLE       = 0x20   // Bit RLE.
	EMAC_IER_TXERR_Pos = 0x6    // Position of TXERR field.
	EMAC_IER_TXERR_Msk = 0x40   // Bit mask of TXERR field.
	EMAC_IER_TXERR     = 0x40   // Bit TXERR.
	EMAC_IER_TCOMP_Pos = 0x7    // Position of TCOMP field.
	EMAC_IER_TCOMP_Msk = 0x80   // Bit mask of TCOMP field.
	EMAC_IER_TCOMP     = 0x80   // Bit TCOMP.
	EMAC_IER_ROVR_Pos  = 0xa    // Position of ROVR field.
	EMAC_IER_ROVR_Msk  = 0x400  // Bit mask of ROVR field.
	EMAC_IER_ROVR      = 0x400  // Bit ROVR.
	EMAC_IER_HRESP_Pos = 0xb    // Position of HRESP field.
	EMAC_IER_HRESP_Msk = 0x800  // Bit mask of HRESP field.
	EMAC_IER_HRESP     = 0x800  // Bit HRESP.
	EMAC_IER_PFR_Pos   = 0xc    // Position of PFR field.
	EMAC_IER_PFR_Msk   = 0x1000 // Bit mask of PFR field.
	EMAC_IER_PFR       = 0x1000 // Bit PFR.
	EMAC_IER_PTZ_Pos   = 0xd    // Position of PTZ field.
	EMAC_IER_PTZ_Msk   = 0x2000 // Bit mask of PTZ field.
	EMAC_IER_PTZ       = 0x2000 // Bit PTZ.

	// IDR: Interrupt Disable Register
	EMAC_IDR_MFD_Pos   = 0x0    // Position of MFD field.
	EMAC_IDR_MFD_Msk   = 0x1    // Bit mask of MFD field.
	EMAC_IDR_MFD       = 0x1    // Bit MFD.
	EMAC_IDR_RCOMP_Pos = 0x1    // Position of RCOMP field.
	EMAC_IDR_RCOMP_Msk = 0x2    // Bit mask of RCOMP field.
	EMAC_IDR_RCOMP     = 0x2    // Bit RCOMP.
	EMAC_IDR_RXUBR_Pos = 0x2    // Position of RXUBR field.
	EMAC_IDR_RXUBR_Msk = 0x4    // Bit mask of RXUBR field.
	EMAC_IDR_RXUBR     = 0x4    // Bit RXUBR.
	EMAC_IDR_TXUBR_Pos = 0x3    // Position of TXUBR field.
	EMAC_IDR_TXUBR_Msk = 0x8    // Bit mask of TXUBR field.
	EMAC_IDR_TXUBR     = 0x8    // Bit TXUBR.
	EMAC_IDR_TUND_Pos  = 0x4    // Position of TUND field.
	EMAC_IDR_TUND_Msk  = 0x10   // Bit mask of TUND field.
	EMAC_IDR_TUND      = 0x10   // Bit TUND.
	EMAC_IDR_RLE_Pos   = 0x5    // Position of RLE field.
	EMAC_IDR_RLE_Msk   = 0x20   // Bit mask of RLE field.
	EMAC_IDR_RLE       = 0x20   // Bit RLE.
	EMAC_IDR_TXERR_Pos = 0x6    // Position of TXERR field.
	EMAC_IDR_TXERR_Msk = 0x40   // Bit mask of TXERR field.
	EMAC_IDR_TXERR     = 0x40   // Bit TXERR.
	EMAC_IDR_TCOMP_Pos = 0x7    // Position of TCOMP field.
	EMAC_IDR_TCOMP_Msk = 0x80   // Bit mask of TCOMP field.
	EMAC_IDR_TCOMP     = 0x80   // Bit TCOMP.
	EMAC_IDR_ROVR_Pos  = 0xa    // Position of ROVR field.
	EMAC_IDR_ROVR_Msk  = 0x400  // Bit mask of ROVR field.
	EMAC_IDR_ROVR      = 0x400  // Bit ROVR.
	EMAC_IDR_HRESP_Pos = 0xb    // Position of HRESP field.
	EMAC_IDR_HRESP_Msk = 0x800  // Bit mask of HRESP field.
	EMAC_IDR_HRESP     = 0x800  // Bit HRESP.
	EMAC_IDR_PFR_Pos   = 0xc    // Position of PFR field.
	EMAC_IDR_PFR_Msk   = 0x1000 // Bit mask of PFR field.
	EMAC_IDR_PFR       = 0x1000 // Bit PFR.
	EMAC_IDR_PTZ_Pos   = 0xd    // Position of PTZ field.
	EMAC_IDR_PTZ_Msk   = 0x2000 // Bit mask of PTZ field.
	EMAC_IDR_PTZ       = 0x2000 // Bit PTZ.

	// IMR: Interrupt Mask Register
	EMAC_IMR_MFD_Pos   = 0x0    // Position of MFD field.
	EMAC_IMR_MFD_Msk   = 0x1    // Bit mask of MFD field.
	EMAC_IMR_MFD       = 0x1    // Bit MFD.
	EMAC_IMR_RCOMP_Pos = 0x1    // Position of RCOMP field.
	EMAC_IMR_RCOMP_Msk = 0x2    // Bit mask of RCOMP field.
	EMAC_IMR_RCOMP     = 0x2    // Bit RCOMP.
	EMAC_IMR_RXUBR_Pos = 0x2    // Position of RXUBR field.
	EMAC_IMR_RXUBR_Msk = 0x4    // Bit mask of RXUBR field.
	EMAC_IMR_RXUBR     = 0x4    // Bit RXUBR.
	EMAC_IMR_TXUBR_Pos = 0x3    // Position of TXUBR field.
	EMAC_IMR_TXUBR_Msk = 0x8    // Bit mask of TXUBR field.
	EMAC_IMR_TXUBR     = 0x8    // Bit TXUBR.
	EMAC_IMR_TUND_Pos  = 0x4    // Position of TUND field.
	EMAC_IMR_TUND_Msk  = 0x10   // Bit mask of TUND field.
	EMAC_IMR_TUND      = 0x10   // Bit TUND.
	EMAC_IMR_RLE_Pos   = 0x5    // Position of RLE field.
	EMAC_IMR_RLE_Msk   = 0x20   // Bit mask of RLE field.
	EMAC_IMR_RLE       = 0x20   // Bit RLE.
	EMAC_IMR_TXERR_Pos = 0x6    // Position of TXERR field.
	EMAC_IMR_TXERR_Msk = 0x40   // Bit mask of TXERR field.
	EMAC_IMR_TXERR     = 0x40   // Bit TXERR.
	EMAC_IMR_TCOMP_Pos = 0x7    // Position of TCOMP field.
	EMAC_IMR_TCOMP_Msk = 0x80   // Bit mask of TCOMP field.
	EMAC_IMR_TCOMP     = 0x80   // Bit TCOMP.
	EMAC_IMR_ROVR_Pos  = 0xa    // Position of ROVR field.
	EMAC_IMR_ROVR_Msk  = 0x400  // Bit mask of ROVR field.
	EMAC_IMR_ROVR      = 0x400  // Bit ROVR.
	EMAC_IMR_HRESP_Pos = 0xb    // Position of HRESP field.
	EMAC_IMR_HRESP_Msk = 0x800  // Bit mask of HRESP field.
	EMAC_IMR_HRESP     = 0x800  // Bit HRESP.
	EMAC_IMR_PFR_Pos   = 0xc    // Position of PFR field.
	EMAC_IMR_PFR_Msk   = 0x1000 // Bit mask of PFR field.
	EMAC_IMR_PFR       = 0x1000 // Bit PFR.
	EMAC_IMR_PTZ_Pos   = 0xd    // Position of PTZ field.
	EMAC_IMR_PTZ_Msk   = 0x2000 // Bit mask of PTZ field.
	EMAC_IMR_PTZ       = 0x2000 // Bit PTZ.

	// MAN: Phy Maintenance Register
	EMAC_MAN_DATA_Pos = 0x0        // Position of DATA field.
	EMAC_MAN_DATA_Msk = 0xffff     // Bit mask of DATA field.
	EMAC_MAN_CODE_Pos = 0x10       // Position of CODE field.
	EMAC_MAN_CODE_Msk = 0x30000    // Bit mask of CODE field.
	EMAC_MAN_REGA_Pos = 0x12       // Position of REGA field.
	EMAC_MAN_REGA_Msk = 0x7c0000   // Bit mask of REGA field.
	EMAC_MAN_PHYA_Pos = 0x17       // Position of PHYA field.
	EMAC_MAN_PHYA_Msk = 0xf800000  // Bit mask of PHYA field.
	EMAC_MAN_RW_Pos   = 0x1c       // Position of RW field.
	EMAC_MAN_RW_Msk   = 0x30000000 // Bit mask of RW field.
	EMAC_MAN_SOF_Pos  = 0x1e       // Position of SOF field.
	EMAC_MAN_SOF_Msk  = 0xc0000000 // Bit mask of SOF field.

	// PTR: Pause Time Register
	EMAC_PTR_PTIME_Pos = 0x0    // Position of PTIME field.
	EMAC_PTR_PTIME_Msk = 0xffff // Bit mask of PTIME field.

	// PFR: Pause Frames Received Register
	EMAC_PFR_FROK_Pos = 0x0    // Position of FROK field.
	EMAC_PFR_FROK_Msk = 0xffff // Bit mask of FROK field.

	// FTO: Frames Transmitted Ok Register
	EMAC_FTO_FTOK_Pos = 0x0      // Position of FTOK field.
	EMAC_FTO_FTOK_Msk = 0xffffff // Bit mask of FTOK field.

	// SCF: Single Collision Frames Register
	EMAC_SCF_SCF_Pos = 0x0    // Position of SCF field.
	EMAC_SCF_SCF_Msk = 0xffff // Bit mask of SCF field.

	// MCF: Multiple Collision Frames Register
	EMAC_MCF_MCF_Pos = 0x0    // Position of MCF field.
	EMAC_MCF_MCF_Msk = 0xffff // Bit mask of MCF field.

	// FRO: Frames Received Ok Register
	EMAC_FRO_FROK_Pos = 0x0      // Position of FROK field.
	EMAC_FRO_FROK_Msk = 0xffffff // Bit mask of FROK field.

	// FCSE: Frame Check Sequence Errors Register
	EMAC_FCSE_FCSE_Pos = 0x0  // Position of FCSE field.
	EMAC_FCSE_FCSE_Msk = 0xff // Bit mask of FCSE field.

	// ALE: Alignment Errors Register
	EMAC_ALE_ALE_Pos = 0x0  // Position of ALE field.
	EMAC_ALE_ALE_Msk = 0xff // Bit mask of ALE field.

	// DTF: Deferred Transmission Frames Register
	EMAC_DTF_DTF_Pos = 0x0    // Position of DTF field.
	EMAC_DTF_DTF_Msk = 0xffff // Bit mask of DTF field.

	// LCOL: Late Collisions Register
	EMAC_LCOL_LCOL_Pos = 0x0  // Position of LCOL field.
	EMAC_LCOL_LCOL_Msk = 0xff // Bit mask of LCOL field.

	// ECOL: Excessive Collisions Register
	EMAC_ECOL_EXCOL_Pos = 0x0  // Position of EXCOL field.
	EMAC_ECOL_EXCOL_Msk = 0xff // Bit mask of EXCOL field.

	// TUND: Transmit Underrun Errors Register
	EMAC_TUND_TUND_Pos = 0x0  // Position of TUND field.
	EMAC_TUND_TUND_Msk = 0xff // Bit mask of TUND field.

	// CSE: Carrier Sense Errors Register
	EMAC_CSE_CSE_Pos = 0x0  // Position of CSE field.
	EMAC_CSE_CSE_Msk = 0xff // Bit mask of CSE field.

	// RRE: Receive Resource Errors Register
	EMAC_RRE_RRE_Pos = 0x0    // Position of RRE field.
	EMAC_RRE_RRE_Msk = 0xffff // Bit mask of RRE field.

	// ROV: Receive Overrun Errors Register
	EMAC_ROV_ROVR_Pos = 0x0  // Position of ROVR field.
	EMAC_ROV_ROVR_Msk = 0xff // Bit mask of ROVR field.

	// RSE: Receive Symbol Errors Register
	EMAC_RSE_RSE_Pos = 0x0  // Position of RSE field.
	EMAC_RSE_RSE_Msk = 0xff // Bit mask of RSE field.

	// ELE: Excessive Length Errors Register
	EMAC_ELE_EXL_Pos = 0x0  // Position of EXL field.
	EMAC_ELE_EXL_Msk = 0xff // Bit mask of EXL field.

	// RJA: Receive Jabbers Register
	EMAC_RJA_RJB_Pos = 0x0  // Position of RJB field.
	EMAC_RJA_RJB_Msk = 0xff // Bit mask of RJB field.

	// USF: Undersize Frames Register
	EMAC_USF_USF_Pos = 0x0  // Position of USF field.
	EMAC_USF_USF_Msk = 0xff // Bit mask of USF field.

	// STE: SQE Test Errors Register
	EMAC_STE_SQER_Pos = 0x0  // Position of SQER field.
	EMAC_STE_SQER_Msk = 0xff // Bit mask of SQER field.

	// RLE: Received Length Field Mismatch Register
	EMAC_RLE_RLFM_Pos = 0x0  // Position of RLFM field.
	EMAC_RLE_RLFM_Msk = 0xff // Bit mask of RLFM field.

	// HRB: Hash Register Bottom [31:0] Register
	EMAC_HRB_ADDR_Pos = 0x0        // Position of ADDR field.
	EMAC_HRB_ADDR_Msk = 0xffffffff // Bit mask of ADDR field.

	// HRT: Hash Register Top [63:32] Register
	EMAC_HRT_ADDR_Pos = 0x0        // Position of ADDR field.
	EMAC_HRT_ADDR_Msk = 0xffffffff // Bit mask of ADDR field.

	// SA1B: Specific Address 1 Bottom Register
	EMAC_SA1B_ADDR_Pos = 0x0        // Position of ADDR field.
	EMAC_SA1B_ADDR_Msk = 0xffffffff // Bit mask of ADDR field.

	// SA1T: Specific Address 1 Top Register
	EMAC_SA1T_ADDR_Pos = 0x0    // Position of ADDR field.
	EMAC_SA1T_ADDR_Msk = 0xffff // Bit mask of ADDR field.

	// SA2B: Specific Address 2 Bottom Register
	EMAC_SA2B_ADDR_Pos = 0x0        // Position of ADDR field.
	EMAC_SA2B_ADDR_Msk = 0xffffffff // Bit mask of ADDR field.

	// SA2T: Specific Address 2 Top Register
	EMAC_SA2T_ADDR_Pos = 0x0    // Position of ADDR field.
	EMAC_SA2T_ADDR_Msk = 0xffff // Bit mask of ADDR field.

	// SA3B: Specific Address 3 Bottom Register
	EMAC_SA3B_ADDR_Pos = 0x0        // Position of ADDR field.
	EMAC_SA3B_ADDR_Msk = 0xffffffff // Bit mask of ADDR field.

	// SA3T: Specific Address 3 Top Register
	EMAC_SA3T_ADDR_Pos = 0x0    // Position of ADDR field.
	EMAC_SA3T_ADDR_Msk = 0xffff // Bit mask of ADDR field.

	// SA4B: Specific Address 4 Bottom Register
	EMAC_SA4B_ADDR_Pos = 0x0        // Position of ADDR field.
	EMAC_SA4B_ADDR_Msk = 0xffffffff // Bit mask of ADDR field.

	// SA4T: Specific Address 4 Top Register
	EMAC_SA4T_ADDR_Pos = 0x0    // Position of ADDR field.
	EMAC_SA4T_ADDR_Msk = 0xffff // Bit mask of ADDR field.

	// TID: Type ID Checking Register
	EMAC_TID_TID_Pos = 0x0    // Position of TID field.
	EMAC_TID_TID_Msk = 0xffff // Bit mask of TID field.

	// USRIO: User Input/Output Register
	EMAC_USRIO_RMII_Pos  = 0x0 // Position of RMII field.
	EMAC_USRIO_RMII_Msk  = 0x1 // Bit mask of RMII field.
	EMAC_USRIO_RMII      = 0x1 // Bit RMII.
	EMAC_USRIO_CLKEN_Pos = 0x1 // Position of CLKEN field.
	EMAC_USRIO_CLKEN_Msk = 0x2 // Bit mask of CLKEN field.
	EMAC_USRIO_CLKEN     = 0x2 // Bit CLKEN.
)

// Bitfields for TRNG: True Random Number Generator
const (
	// CR: Control Register
	TRNG_CR_ENABLE_Pos = 0x0 // Position of ENABLE field.
	TRNG_CR_ENABLE_Msk = 0x1 // Bit mask of ENABLE field.
	TRNG_CR_ENABLE     = 0x1 // Bit ENABLE.

	// IER: Interrupt Enable Register
	TRNG_IER_DATRDY_Pos = 0x0 // Position of DATRDY field.
	TRNG_IER_DATRDY_Msk = 0x1 // Bit mask of DATRDY field.
	TRNG_IER_DATRDY     = 0x1 // Bit DATRDY.

	// IDR: Interrupt Disable Register
	TRNG_IDR_DATRDY_Pos = 0x0 // Position of DATRDY field.
	TRNG_IDR_DATRDY_Msk = 0x1 // Bit mask of DATRDY field.
	TRNG_IDR_DATRDY     = 0x1 // Bit DATRDY.

	// IMR: Interrupt Mask Register
	TRNG_IMR_DATRDY_Pos = 0x0 // Position of DATRDY field.
	TRNG_IMR_DATRDY_Msk = 0x1 // Bit mask of DATRDY field.
	TRNG_IMR_DATRDY     = 0x1 // Bit DATRDY.

	// ISR: Interrupt Status Register
	TRNG_ISR_DATRDY_Pos = 0x0 // Position of DATRDY field.
	TRNG_ISR_DATRDY_Msk = 0x1 // Bit mask of DATRDY field.
	TRNG_ISR_DATRDY     = 0x1 // Bit DATRDY.

	// ODATA: Output Data Register
	TRNG_ODATA_ODATA_Pos = 0x0        // Position of ODATA field.
	TRNG_ODATA_ODATA_Msk = 0xffffffff // Bit mask of ODATA field.
)

// Bitfields for DDRSDRC1: DDR_SDR SDRAM Controller 1
const (
	// MR: DDRSDRC Mode Register
	EBI_MR_MODE_Pos = 0x0 // Position of MODE field.
	EBI_MR_MODE_Msk = 0x7 // Bit mask of MODE field.

	// RTR: DDRSDRC Refresh Timer Register
	EBI_RTR_COUNT_Pos = 0x0   // Position of COUNT field.
	EBI_RTR_COUNT_Msk = 0xfff // Bit mask of COUNT field.

	// CR: DDRSDRC Configuration Register
	EBI_CR_NC_Pos       = 0x0     // Position of NC field.
	EBI_CR_NC_Msk       = 0x3     // Bit mask of NC field.
	EBI_CR_NR_Pos       = 0x2     // Position of NR field.
	EBI_CR_NR_Msk       = 0xc     // Bit mask of NR field.
	EBI_CR_CAS_Pos      = 0x4     // Position of CAS field.
	EBI_CR_CAS_Msk      = 0x70    // Bit mask of CAS field.
	EBI_CR_DLL_Pos      = 0x7     // Position of DLL field.
	EBI_CR_DLL_Msk      = 0x80    // Bit mask of DLL field.
	EBI_CR_DLL          = 0x80    // Bit DLL.
	EBI_CR_DIC_Pos      = 0x8     // Position of DIC field.
	EBI_CR_DIC_Msk      = 0x100   // Bit mask of DIC field.
	EBI_CR_DIC          = 0x100   // Bit DIC.
	EBI_CR_DIS_DLL_Pos  = 0x9     // Position of DIS_DLL field.
	EBI_CR_DIS_DLL_Msk  = 0x200   // Bit mask of DIS_DLL field.
	EBI_CR_DIS_DLL      = 0x200   // Bit DIS_DLL.
	EBI_CR_OCD_Pos      = 0xc     // Position of OCD field.
	EBI_CR_OCD_Msk      = 0x7000  // Bit mask of OCD field.
	EBI_CR_EBISHARE_Pos = 0x10    // Position of EBISHARE field.
	EBI_CR_EBISHARE_Msk = 0x10000 // Bit mask of EBISHARE field.
	EBI_CR_EBISHARE     = 0x10000 // Bit EBISHARE.
	EBI_CR_ACTBST_Pos   = 0x12    // Position of ACTBST field.
	EBI_CR_ACTBST_Msk   = 0x40000 // Bit mask of ACTBST field.
	EBI_CR_ACTBST       = 0x40000 // Bit ACTBST.

	// TPR0: DDRSDRC Timing Parameter 0 Register
	EBI_TPR0_TRAS_Pos        = 0x0        // Position of TRAS field.
	EBI_TPR0_TRAS_Msk        = 0xf        // Bit mask of TRAS field.
	EBI_TPR0_TRCD_Pos        = 0x4        // Position of TRCD field.
	EBI_TPR0_TRCD_Msk        = 0xf0       // Bit mask of TRCD field.
	EBI_TPR0_TWR_Pos         = 0x8        // Position of TWR field.
	EBI_TPR0_TWR_Msk         = 0xf00      // Bit mask of TWR field.
	EBI_TPR0_TRC_Pos         = 0xc        // Position of TRC field.
	EBI_TPR0_TRC_Msk         = 0xf000     // Bit mask of TRC field.
	EBI_TPR0_TRP_Pos         = 0x10       // Position of TRP field.
	EBI_TPR0_TRP_Msk         = 0xf0000    // Bit mask of TRP field.
	EBI_TPR0_TRRD_Pos        = 0x14       // Position of TRRD field.
	EBI_TPR0_TRRD_Msk        = 0xf00000   // Bit mask of TRRD field.
	EBI_TPR0_TWTR_Pos        = 0x18       // Position of TWTR field.
	EBI_TPR0_TWTR_Msk        = 0x7000000  // Bit mask of TWTR field.
	EBI_TPR0_REDUCE_WRRD_Pos = 0x1b       // Position of REDUCE_WRRD field.
	EBI_TPR0_REDUCE_WRRD_Msk = 0x8000000  // Bit mask of REDUCE_WRRD field.
	EBI_TPR0_REDUCE_WRRD     = 0x8000000  // Bit REDUCE_WRRD.
	EBI_TPR0_TMRD_Pos        = 0x1c       // Position of TMRD field.
	EBI_TPR0_TMRD_Msk        = 0xf0000000 // Bit mask of TMRD field.

	// TPR1: DDRSDRC Timing Parameter 1 Register
	EBI_TPR1_TRFC_Pos  = 0x0       // Position of TRFC field.
	EBI_TPR1_TRFC_Msk  = 0x1f      // Bit mask of TRFC field.
	EBI_TPR1_TXSNR_Pos = 0x8       // Position of TXSNR field.
	EBI_TPR1_TXSNR_Msk = 0xff00    // Bit mask of TXSNR field.
	EBI_TPR1_TXSRD_Pos = 0x10      // Position of TXSRD field.
	EBI_TPR1_TXSRD_Msk = 0xff0000  // Bit mask of TXSRD field.
	EBI_TPR1_TXP_Pos   = 0x18      // Position of TXP field.
	EBI_TPR1_TXP_Msk   = 0xf000000 // Bit mask of TXP field.

	// TPR2: DDRSDRC Timing Parameter 2 Register
	EBI_TPR2_TXARD_Pos  = 0x0    // Position of TXARD field.
	EBI_TPR2_TXARD_Msk  = 0xf    // Bit mask of TXARD field.
	EBI_TPR2_TXARDS_Pos = 0x4    // Position of TXARDS field.
	EBI_TPR2_TXARDS_Msk = 0xf0   // Bit mask of TXARDS field.
	EBI_TPR2_TRPA_Pos   = 0x8    // Position of TRPA field.
	EBI_TPR2_TRPA_Msk   = 0xf00  // Bit mask of TRPA field.
	EBI_TPR2_TRTP_Pos   = 0xc    // Position of TRTP field.
	EBI_TPR2_TRTP_Msk   = 0x7000 // Bit mask of TRTP field.

	// LPR: DDRSDRC Low-power Register
	EBI_LPR_LPCB_Pos    = 0x0      // Position of LPCB field.
	EBI_LPR_LPCB_Msk    = 0x3      // Bit mask of LPCB field.
	EBI_LPR_CLK_FR_Pos  = 0x2      // Position of CLK_FR field.
	EBI_LPR_CLK_FR_Msk  = 0x4      // Bit mask of CLK_FR field.
	EBI_LPR_CLK_FR      = 0x4      // Bit CLK_FR.
	EBI_LPR_PASR_Pos    = 0x4      // Position of PASR field.
	EBI_LPR_PASR_Msk    = 0x70     // Bit mask of PASR field.
	EBI_LPR_TCR_Pos     = 0x8      // Position of TCR field.
	EBI_LPR_TCR_Msk     = 0x300    // Bit mask of TCR field.
	EBI_LPR_DS_Pos      = 0xa      // Position of DS field.
	EBI_LPR_DS_Msk      = 0xc00    // Bit mask of DS field.
	EBI_LPR_TIMEOUT_Pos = 0xc      // Position of TIMEOUT field.
	EBI_LPR_TIMEOUT_Msk = 0x3000   // Bit mask of TIMEOUT field.
	EBI_LPR_APDE_Pos    = 0x10     // Position of APDE field.
	EBI_LPR_APDE_Msk    = 0x10000  // Bit mask of APDE field.
	EBI_LPR_APDE        = 0x10000  // Bit APDE.
	EBI_LPR_UPD_MR_Pos  = 0x14     // Position of UPD_MR field.
	EBI_LPR_UPD_MR_Msk  = 0x300000 // Bit mask of UPD_MR field.

	// MD: DDRSDRC Memory Device Register
	EBI_MD_MD_Pos  = 0x0  // Position of MD field.
	EBI_MD_MD_Msk  = 0x7  // Bit mask of MD field.
	EBI_MD_DBW_Pos = 0x4  // Position of DBW field.
	EBI_MD_DBW_Msk = 0x10 // Bit mask of DBW field.
	EBI_MD_DBW     = 0x10 // Bit DBW.

	// DLL: DDRSDRC DLL Information Register
	EBI_DLL_MDINC_Pos = 0x0    // Position of MDINC field.
	EBI_DLL_MDINC_Msk = 0x1    // Bit mask of MDINC field.
	EBI_DLL_MDINC     = 0x1    // Bit MDINC.
	EBI_DLL_MDDEC_Pos = 0x1    // Position of MDDEC field.
	EBI_DLL_MDDEC_Msk = 0x2    // Bit mask of MDDEC field.
	EBI_DLL_MDDEC     = 0x2    // Bit MDDEC.
	EBI_DLL_MDOVF_Pos = 0x2    // Position of MDOVF field.
	EBI_DLL_MDOVF_Msk = 0x4    // Bit mask of MDOVF field.
	EBI_DLL_MDOVF     = 0x4    // Bit MDOVF.
	EBI_DLL_MDVAL_Pos = 0x8    // Position of MDVAL field.
	EBI_DLL_MDVAL_Msk = 0xff00 // Bit mask of MDVAL field.

	// HS: DDRSDRC High Speed Register
	EBI_HS_DIS_ANTICIP_READ_Pos = 0x2 // Position of DIS_ANTICIP_READ field.
	EBI_HS_DIS_ANTICIP_READ_Msk = 0x4 // Bit mask of DIS_ANTICIP_READ field.
	EBI_HS_DIS_ANTICIP_READ     = 0x4 // Bit DIS_ANTICIP_READ.

	// DELAY: DDRSDRC Delay I/O Register
	EBI_DELAY_DELAY1_Pos = 0x0        // Position of DELAY1 field.
	EBI_DELAY_DELAY1_Msk = 0xf        // Bit mask of DELAY1 field.
	EBI_DELAY_DELAY2_Pos = 0x4        // Position of DELAY2 field.
	EBI_DELAY_DELAY2_Msk = 0xf0       // Bit mask of DELAY2 field.
	EBI_DELAY_DELAY3_Pos = 0x8        // Position of DELAY3 field.
	EBI_DELAY_DELAY3_Msk = 0xf00      // Bit mask of DELAY3 field.
	EBI_DELAY_DELAY4_Pos = 0xc        // Position of DELAY4 field.
	EBI_DELAY_DELAY4_Msk = 0xf000     // Bit mask of DELAY4 field.
	EBI_DELAY_DELAY5_Pos = 0x10       // Position of DELAY5 field.
	EBI_DELAY_DELAY5_Msk = 0xf0000    // Bit mask of DELAY5 field.
	EBI_DELAY_DELAY6_Pos = 0x14       // Position of DELAY6 field.
	EBI_DELAY_DELAY6_Msk = 0xf00000   // Bit mask of DELAY6 field.
	EBI_DELAY_DELAY7_Pos = 0x18       // Position of DELAY7 field.
	EBI_DELAY_DELAY7_Msk = 0xf000000  // Bit mask of DELAY7 field.
	EBI_DELAY_DELAY8_Pos = 0x1c       // Position of DELAY8 field.
	EBI_DELAY_DELAY8_Msk = 0xf0000000 // Bit mask of DELAY8 field.

	// WPMR: DDRSDRC Write Protect Mode Register
	EBI_WPMR_WPEN_Pos  = 0x0        // Position of WPEN field.
	EBI_WPMR_WPEN_Msk  = 0x1        // Bit mask of WPEN field.
	EBI_WPMR_WPEN      = 0x1        // Bit WPEN.
	EBI_WPMR_WPKEY_Pos = 0x8        // Position of WPKEY field.
	EBI_WPMR_WPKEY_Msk = 0xffffff00 // Bit mask of WPKEY field.

	// WPSR: DDRSDRC Write Protect Status Register
	EBI_WPSR_WPVS_Pos   = 0x0      // Position of WPVS field.
	EBI_WPSR_WPVS_Msk   = 0x1      // Bit mask of WPVS field.
	EBI_WPSR_WPVS       = 0x1      // Bit WPVS.
	EBI_WPSR_WPVSRC_Pos = 0x8      // Position of WPVSRC field.
	EBI_WPSR_WPVSRC_Msk = 0xffff00 // Bit mask of WPVSRC field.
)

// Bitfields for DDRSDRC0: DDR_SDR SDRAM Controller 0
const (
	// MR: DDRSDRC Mode Register
	DDRSDRC_MR_MODE_Pos = 0x0 // Position of MODE field.
	DDRSDRC_MR_MODE_Msk = 0x7 // Bit mask of MODE field.

	// RTR: DDRSDRC Refresh Timer Register
	DDRSDRC_RTR_COUNT_Pos = 0x0   // Position of COUNT field.
	DDRSDRC_RTR_COUNT_Msk = 0xfff // Bit mask of COUNT field.

	// CR: DDRSDRC Configuration Register
	DDRSDRC_CR_NC_Pos       = 0x0     // Position of NC field.
	DDRSDRC_CR_NC_Msk       = 0x3     // Bit mask of NC field.
	DDRSDRC_CR_NR_Pos       = 0x2     // Position of NR field.
	DDRSDRC_CR_NR_Msk       = 0xc     // Bit mask of NR field.
	DDRSDRC_CR_CAS_Pos      = 0x4     // Position of CAS field.
	DDRSDRC_CR_CAS_Msk      = 0x70    // Bit mask of CAS field.
	DDRSDRC_CR_DLL_Pos      = 0x7     // Position of DLL field.
	DDRSDRC_CR_DLL_Msk      = 0x80    // Bit mask of DLL field.
	DDRSDRC_CR_DLL          = 0x80    // Bit DLL.
	DDRSDRC_CR_DIC_Pos      = 0x8     // Position of DIC field.
	DDRSDRC_CR_DIC_Msk      = 0x100   // Bit mask of DIC field.
	DDRSDRC_CR_DIC          = 0x100   // Bit DIC.
	DDRSDRC_CR_DIS_DLL_Pos  = 0x9     // Position of DIS_DLL field.
	DDRSDRC_CR_DIS_DLL_Msk  = 0x200   // Bit mask of DIS_DLL field.
	DDRSDRC_CR_DIS_DLL      = 0x200   // Bit DIS_DLL.
	DDRSDRC_CR_OCD_Pos      = 0xc     // Position of OCD field.
	DDRSDRC_CR_OCD_Msk      = 0x7000  // Bit mask of OCD field.
	DDRSDRC_CR_EBISHARE_Pos = 0x10    // Position of EBISHARE field.
	DDRSDRC_CR_EBISHARE_Msk = 0x10000 // Bit mask of EBISHARE field.
	DDRSDRC_CR_EBISHARE     = 0x10000 // Bit EBISHARE.
	DDRSDRC_CR_ACTBST_Pos   = 0x12    // Position of ACTBST field.
	DDRSDRC_CR_ACTBST_Msk   = 0x40000 // Bit mask of ACTBST field.
	DDRSDRC_CR_ACTBST       = 0x40000 // Bit ACTBST.

	// TPR0: DDRSDRC Timing Parameter 0 Register
	DDRSDRC_TPR0_TRAS_Pos        = 0x0        // Position of TRAS field.
	DDRSDRC_TPR0_TRAS_Msk        = 0xf        // Bit mask of TRAS field.
	DDRSDRC_TPR0_TRCD_Pos        = 0x4        // Position of TRCD field.
	DDRSDRC_TPR0_TRCD_Msk        = 0xf0       // Bit mask of TRCD field.
	DDRSDRC_TPR0_TWR_Pos         = 0x8        // Position of TWR field.
	DDRSDRC_TPR0_TWR_Msk         = 0xf00      // Bit mask of TWR field.
	DDRSDRC_TPR0_TRC_Pos         = 0xc        // Position of TRC field.
	DDRSDRC_TPR0_TRC_Msk         = 0xf000     // Bit mask of TRC field.
	DDRSDRC_TPR0_TRP_Pos         = 0x10       // Position of TRP field.
	DDRSDRC_TPR0_TRP_Msk         = 0xf0000    // Bit mask of TRP field.
	DDRSDRC_TPR0_TRRD_Pos        = 0x14       // Position of TRRD field.
	DDRSDRC_TPR0_TRRD_Msk        = 0xf00000   // Bit mask of TRRD field.
	DDRSDRC_TPR0_TWTR_Pos        = 0x18       // Position of TWTR field.
	DDRSDRC_TPR0_TWTR_Msk        = 0x7000000  // Bit mask of TWTR field.
	DDRSDRC_TPR0_REDUCE_WRRD_Pos = 0x1b       // Position of REDUCE_WRRD field.
	DDRSDRC_TPR0_REDUCE_WRRD_Msk = 0x8000000  // Bit mask of REDUCE_WRRD field.
	DDRSDRC_TPR0_REDUCE_WRRD     = 0x8000000  // Bit REDUCE_WRRD.
	DDRSDRC_TPR0_TMRD_Pos        = 0x1c       // Position of TMRD field.
	DDRSDRC_TPR0_TMRD_Msk        = 0xf0000000 // Bit mask of TMRD field.

	// TPR1: DDRSDRC Timing Parameter 1 Register
	DDRSDRC_TPR1_TRFC_Pos  = 0x0       // Position of TRFC field.
	DDRSDRC_TPR1_TRFC_Msk  = 0x1f      // Bit mask of TRFC field.
	DDRSDRC_TPR1_TXSNR_Pos = 0x8       // Position of TXSNR field.
	DDRSDRC_TPR1_TXSNR_Msk = 0xff00    // Bit mask of TXSNR field.
	DDRSDRC_TPR1_TXSRD_Pos = 0x10      // Position of TXSRD field.
	DDRSDRC_TPR1_TXSRD_Msk = 0xff0000  // Bit mask of TXSRD field.
	DDRSDRC_TPR1_TXP_Pos   = 0x18      // Position of TXP field.
	DDRSDRC_TPR1_TXP_Msk   = 0xf000000 // Bit mask of TXP field.

	// TPR2: DDRSDRC Timing Parameter 2 Register
	DDRSDRC_TPR2_TXARD_Pos  = 0x0    // Position of TXARD field.
	DDRSDRC_TPR2_TXARD_Msk  = 0xf    // Bit mask of TXARD field.
	DDRSDRC_TPR2_TXARDS_Pos = 0x4    // Position of TXARDS field.
	DDRSDRC_TPR2_TXARDS_Msk = 0xf0   // Bit mask of TXARDS field.
	DDRSDRC_TPR2_TRPA_Pos   = 0x8    // Position of TRPA field.
	DDRSDRC_TPR2_TRPA_Msk   = 0xf00  // Bit mask of TRPA field.
	DDRSDRC_TPR2_TRTP_Pos   = 0xc    // Position of TRTP field.
	DDRSDRC_TPR2_TRTP_Msk   = 0x7000 // Bit mask of TRTP field.

	// LPR: DDRSDRC Low-power Register
	DDRSDRC_LPR_LPCB_Pos    = 0x0      // Position of LPCB field.
	DDRSDRC_LPR_LPCB_Msk    = 0x3      // Bit mask of LPCB field.
	DDRSDRC_LPR_CLK_FR_Pos  = 0x2      // Position of CLK_FR field.
	DDRSDRC_LPR_CLK_FR_Msk  = 0x4      // Bit mask of CLK_FR field.
	DDRSDRC_LPR_CLK_FR      = 0x4      // Bit CLK_FR.
	DDRSDRC_LPR_PASR_Pos    = 0x4      // Position of PASR field.
	DDRSDRC_LPR_PASR_Msk    = 0x70     // Bit mask of PASR field.
	DDRSDRC_LPR_TCR_Pos     = 0x8      // Position of TCR field.
	DDRSDRC_LPR_TCR_Msk     = 0x300    // Bit mask of TCR field.
	DDRSDRC_LPR_DS_Pos      = 0xa      // Position of DS field.
	DDRSDRC_LPR_DS_Msk      = 0xc00    // Bit mask of DS field.
	DDRSDRC_LPR_TIMEOUT_Pos = 0xc      // Position of TIMEOUT field.
	DDRSDRC_LPR_TIMEOUT_Msk = 0x3000   // Bit mask of TIMEOUT field.
	DDRSDRC_LPR_APDE_Pos    = 0x10     // Position of APDE field.
	DDRSDRC_LPR_APDE_Msk    = 0x10000  // Bit mask of APDE field.
	DDRSDRC_LPR_APDE        = 0x10000  // Bit APDE.
	DDRSDRC_LPR_UPD_MR_Pos  = 0x14     // Position of UPD_MR field.
	DDRSDRC_LPR_UPD_MR_Msk  = 0x300000 // Bit mask of UPD_MR field.

	// MD: DDRSDRC Memory Device Register
	DDRSDRC_MD_MD_Pos  = 0x0  // Position of MD field.
	DDRSDRC_MD_MD_Msk  = 0x7  // Bit mask of MD field.
	DDRSDRC_MD_DBW_Pos = 0x4  // Position of DBW field.
	DDRSDRC_MD_DBW_Msk = 0x10 // Bit mask of DBW field.
	DDRSDRC_MD_DBW     = 0x10 // Bit DBW.

	// DLL: DDRSDRC DLL Information Register
	DDRSDRC_DLL_MDINC_Pos = 0x0    // Position of MDINC field.
	DDRSDRC_DLL_MDINC_Msk = 0x1    // Bit mask of MDINC field.
	DDRSDRC_DLL_MDINC     = 0x1    // Bit MDINC.
	DDRSDRC_DLL_MDDEC_Pos = 0x1    // Position of MDDEC field.
	DDRSDRC_DLL_MDDEC_Msk = 0x2    // Bit mask of MDDEC field.
	DDRSDRC_DLL_MDDEC     = 0x2    // Bit MDDEC.
	DDRSDRC_DLL_MDOVF_Pos = 0x2    // Position of MDOVF field.
	DDRSDRC_DLL_MDOVF_Msk = 0x4    // Bit mask of MDOVF field.
	DDRSDRC_DLL_MDOVF     = 0x4    // Bit MDOVF.
	DDRSDRC_DLL_MDVAL_Pos = 0x8    // Position of MDVAL field.
	DDRSDRC_DLL_MDVAL_Msk = 0xff00 // Bit mask of MDVAL field.

	// HS: DDRSDRC High Speed Register
	DDRSDRC_HS_DIS_ANTICIP_READ_Pos = 0x2 // Position of DIS_ANTICIP_READ field.
	DDRSDRC_HS_DIS_ANTICIP_READ_Msk = 0x4 // Bit mask of DIS_ANTICIP_READ field.
	DDRSDRC_HS_DIS_ANTICIP_READ     = 0x4 // Bit DIS_ANTICIP_READ.

	// DELAY: DDRSDRC Delay I/O Register
	DDRSDRC_DELAY_DELAY1_Pos = 0x0        // Position of DELAY1 field.
	DDRSDRC_DELAY_DELAY1_Msk = 0xf        // Bit mask of DELAY1 field.
	DDRSDRC_DELAY_DELAY2_Pos = 0x4        // Position of DELAY2 field.
	DDRSDRC_DELAY_DELAY2_Msk = 0xf0       // Bit mask of DELAY2 field.
	DDRSDRC_DELAY_DELAY3_Pos = 0x8        // Position of DELAY3 field.
	DDRSDRC_DELAY_DELAY3_Msk = 0xf00      // Bit mask of DELAY3 field.
	DDRSDRC_DELAY_DELAY4_Pos = 0xc        // Position of DELAY4 field.
	DDRSDRC_DELAY_DELAY4_Msk = 0xf000     // Bit mask of DELAY4 field.
	DDRSDRC_DELAY_DELAY5_Pos = 0x10       // Position of DELAY5 field.
	DDRSDRC_DELAY_DELAY5_Msk = 0xf0000    // Bit mask of DELAY5 field.
	DDRSDRC_DELAY_DELAY6_Pos = 0x14       // Position of DELAY6 field.
	DDRSDRC_DELAY_DELAY6_Msk = 0xf00000   // Bit mask of DELAY6 field.
	DDRSDRC_DELAY_DELAY7_Pos = 0x18       // Position of DELAY7 field.
	DDRSDRC_DELAY_DELAY7_Msk = 0xf000000  // Bit mask of DELAY7 field.
	DDRSDRC_DELAY_DELAY8_Pos = 0x1c       // Position of DELAY8 field.
	DDRSDRC_DELAY_DELAY8_Msk = 0xf0000000 // Bit mask of DELAY8 field.

	// WPMR: DDRSDRC Write Protect Mode Register
	DDRSDRC_WPMR_WPEN_Pos  = 0x0        // Position of WPEN field.
	DDRSDRC_WPMR_WPEN_Msk  = 0x1        // Bit mask of WPEN field.
	DDRSDRC_WPMR_WPEN      = 0x1        // Bit WPEN.
	DDRSDRC_WPMR_WPKEY_Pos = 0x8        // Position of WPKEY field.
	DDRSDRC_WPMR_WPKEY_Msk = 0xffffff00 // Bit mask of WPKEY field.

	// WPSR: DDRSDRC Write Protect Status Register
	DDRSDRC_WPSR_WPVS_Pos   = 0x0      // Position of WPVS field.
	DDRSDRC_WPSR_WPVS_Msk   = 0x1      // Bit mask of WPVS field.
	DDRSDRC_WPSR_WPVS       = 0x1      // Bit WPVS.
	DDRSDRC_WPSR_WPVSRC_Pos = 0x8      // Position of WPVSRC field.
	DDRSDRC_WPSR_WPVSRC_Msk = 0xffff00 // Bit mask of WPVSRC field.
)

// Bitfields for MATRIX: AHB Bus Matrix
const (
	// MCFG: Master Configuration Register
	MATRIX_MCFG_ULBT_Pos = 0x0 // Position of ULBT field.
	MATRIX_MCFG_ULBT_Msk = 0x7 // Bit mask of ULBT field.

	// SCFG: Slave Configuration Register
	MATRIX_SCFG_SLOT_CYCLE_Pos    = 0x0      // Position of SLOT_CYCLE field.
	MATRIX_SCFG_SLOT_CYCLE_Msk    = 0x1ff    // Bit mask of SLOT_CYCLE field.
	MATRIX_SCFG_DEFMSTR_TYPE_Pos  = 0x10     // Position of DEFMSTR_TYPE field.
	MATRIX_SCFG_DEFMSTR_TYPE_Msk  = 0x30000  // Bit mask of DEFMSTR_TYPE field.
	MATRIX_SCFG_FIXED_DEFMSTR_Pos = 0x12     // Position of FIXED_DEFMSTR field.
	MATRIX_SCFG_FIXED_DEFMSTR_Msk = 0x3c0000 // Bit mask of FIXED_DEFMSTR field.

	// PRAS0: Priority Register A for Slave 0
	MATRIX_PRAS0_M0PR_Pos = 0x0        // Position of M0PR field.
	MATRIX_PRAS0_M0PR_Msk = 0x3        // Bit mask of M0PR field.
	MATRIX_PRAS0_M1PR_Pos = 0x4        // Position of M1PR field.
	MATRIX_PRAS0_M1PR_Msk = 0x30       // Bit mask of M1PR field.
	MATRIX_PRAS0_M2PR_Pos = 0x8        // Position of M2PR field.
	MATRIX_PRAS0_M2PR_Msk = 0x300      // Bit mask of M2PR field.
	MATRIX_PRAS0_M3PR_Pos = 0xc        // Position of M3PR field.
	MATRIX_PRAS0_M3PR_Msk = 0x3000     // Bit mask of M3PR field.
	MATRIX_PRAS0_M4PR_Pos = 0x10       // Position of M4PR field.
	MATRIX_PRAS0_M4PR_Msk = 0x30000    // Bit mask of M4PR field.
	MATRIX_PRAS0_M5PR_Pos = 0x14       // Position of M5PR field.
	MATRIX_PRAS0_M5PR_Msk = 0x300000   // Bit mask of M5PR field.
	MATRIX_PRAS0_M6PR_Pos = 0x18       // Position of M6PR field.
	MATRIX_PRAS0_M6PR_Msk = 0x3000000  // Bit mask of M6PR field.
	MATRIX_PRAS0_M7PR_Pos = 0x1c       // Position of M7PR field.
	MATRIX_PRAS0_M7PR_Msk = 0x30000000 // Bit mask of M7PR field.

	// PRBS0: Priority Register B for Slave 0
	MATRIX_PRBS0_M8PR_Pos  = 0x0   // Position of M8PR field.
	MATRIX_PRBS0_M8PR_Msk  = 0x3   // Bit mask of M8PR field.
	MATRIX_PRBS0_M9PR_Pos  = 0x4   // Position of M9PR field.
	MATRIX_PRBS0_M9PR_Msk  = 0x30  // Bit mask of M9PR field.
	MATRIX_PRBS0_M10PR_Pos = 0x8   // Position of M10PR field.
	MATRIX_PRBS0_M10PR_Msk = 0x300 // Bit mask of M10PR field.

	// PRAS1: Priority Register A for Slave 1
	MATRIX_PRAS1_M0PR_Pos = 0x0        // Position of M0PR field.
	MATRIX_PRAS1_M0PR_Msk = 0x3        // Bit mask of M0PR field.
	MATRIX_PRAS1_M1PR_Pos = 0x4        // Position of M1PR field.
	MATRIX_PRAS1_M1PR_Msk = 0x30       // Bit mask of M1PR field.
	MATRIX_PRAS1_M2PR_Pos = 0x8        // Position of M2PR field.
	MATRIX_PRAS1_M2PR_Msk = 0x300      // Bit mask of M2PR field.
	MATRIX_PRAS1_M3PR_Pos = 0xc        // Position of M3PR field.
	MATRIX_PRAS1_M3PR_Msk = 0x3000     // Bit mask of M3PR field.
	MATRIX_PRAS1_M4PR_Pos = 0x10       // Position of M4PR field.
	MATRIX_PRAS1_M4PR_Msk = 0x30000    // Bit mask of M4PR field.
	MATRIX_PRAS1_M5PR_Pos = 0x14       // Position of M5PR field.
	MATRIX_PRAS1_M5PR_Msk = 0x300000   // Bit mask of M5PR field.
	MATRIX_PRAS1_M6PR_Pos = 0x18       // Position of M6PR field.
	MATRIX_PRAS1_M6PR_Msk = 0x3000000  // Bit mask of M6PR field.
	MATRIX_PRAS1_M7PR_Pos = 0x1c       // Position of M7PR field.
	MATRIX_PRAS1_M7PR_Msk = 0x30000000 // Bit mask of M7PR field.

	// PRBS1: Priority Register B for Slave 1
	MATRIX_PRBS1_M8PR_Pos  = 0x0   // Position of M8PR field.
	MATRIX_PRBS1_M8PR_Msk  = 0x3   // Bit mask of M8PR field.
	MATRIX_PRBS1_M9PR_Pos  = 0x4   // Position of M9PR field.
	MATRIX_PRBS1_M9PR_Msk  = 0x30  // Bit mask of M9PR field.
	MATRIX_PRBS1_M10PR_Pos = 0x8   // Position of M10PR field.
	MATRIX_PRBS1_M10PR_Msk = 0x300 // Bit mask of M10PR field.

	// PRAS2: Priority Register A for Slave 2
	MATRIX_PRAS2_M0PR_Pos = 0x0        // Position of M0PR field.
	MATRIX_PRAS2_M0PR_Msk = 0x3        // Bit mask of M0PR field.
	MATRIX_PRAS2_M1PR_Pos = 0x4        // Position of M1PR field.
	MATRIX_PRAS2_M1PR_Msk = 0x30       // Bit mask of M1PR field.
	MATRIX_PRAS2_M2PR_Pos = 0x8        // Position of M2PR field.
	MATRIX_PRAS2_M2PR_Msk = 0x300      // Bit mask of M2PR field.
	MATRIX_PRAS2_M3PR_Pos = 0xc        // Position of M3PR field.
	MATRIX_PRAS2_M3PR_Msk = 0x3000     // Bit mask of M3PR field.
	MATRIX_PRAS2_M4PR_Pos = 0x10       // Position of M4PR field.
	MATRIX_PRAS2_M4PR_Msk = 0x30000    // Bit mask of M4PR field.
	MATRIX_PRAS2_M5PR_Pos = 0x14       // Position of M5PR field.
	MATRIX_PRAS2_M5PR_Msk = 0x300000   // Bit mask of M5PR field.
	MATRIX_PRAS2_M6PR_Pos = 0x18       // Position of M6PR field.
	MATRIX_PRAS2_M6PR_Msk = 0x3000000  // Bit mask of M6PR field.
	MATRIX_PRAS2_M7PR_Pos = 0x1c       // Position of M7PR field.
	MATRIX_PRAS2_M7PR_Msk = 0x30000000 // Bit mask of M7PR field.

	// PRBS2: Priority Register B for Slave 2
	MATRIX_PRBS2_M8PR_Pos  = 0x0   // Position of M8PR field.
	MATRIX_PRBS2_M8PR_Msk  = 0x3   // Bit mask of M8PR field.
	MATRIX_PRBS2_M9PR_Pos  = 0x4   // Position of M9PR field.
	MATRIX_PRBS2_M9PR_Msk  = 0x30  // Bit mask of M9PR field.
	MATRIX_PRBS2_M10PR_Pos = 0x8   // Position of M10PR field.
	MATRIX_PRBS2_M10PR_Msk = 0x300 // Bit mask of M10PR field.

	// PRAS3: Priority Register A for Slave 3
	MATRIX_PRAS3_M0PR_Pos = 0x0        // Position of M0PR field.
	MATRIX_PRAS3_M0PR_Msk = 0x3        // Bit mask of M0PR field.
	MATRIX_PRAS3_M1PR_Pos = 0x4        // Position of M1PR field.
	MATRIX_PRAS3_M1PR_Msk = 0x30       // Bit mask of M1PR field.
	MATRIX_PRAS3_M2PR_Pos = 0x8        // Position of M2PR field.
	MATRIX_PRAS3_M2PR_Msk = 0x300      // Bit mask of M2PR field.
	MATRIX_PRAS3_M3PR_Pos = 0xc        // Position of M3PR field.
	MATRIX_PRAS3_M3PR_Msk = 0x3000     // Bit mask of M3PR field.
	MATRIX_PRAS3_M4PR_Pos = 0x10       // Position of M4PR field.
	MATRIX_PRAS3_M4PR_Msk = 0x30000    // Bit mask of M4PR field.
	MATRIX_PRAS3_M5PR_Pos = 0x14       // Position of M5PR field.
	MATRIX_PRAS3_M5PR_Msk = 0x300000   // Bit mask of M5PR field.
	MATRIX_PRAS3_M6PR_Pos = 0x18       // Position of M6PR field.
	MATRIX_PRAS3_M6PR_Msk = 0x3000000  // Bit mask of M6PR field.
	MATRIX_PRAS3_M7PR_Pos = 0x1c       // Position of M7PR field.
	MATRIX_PRAS3_M7PR_Msk = 0x30000000 // Bit mask of M7PR field.

	// PRBS3: Priority Register B for Slave 3
	MATRIX_PRBS3_M8PR_Pos  = 0x0   // Position of M8PR field.
	MATRIX_PRBS3_M8PR_Msk  = 0x3   // Bit mask of M8PR field.
	MATRIX_PRBS3_M9PR_Pos  = 0x4   // Position of M9PR field.
	MATRIX_PRBS3_M9PR_Msk  = 0x30  // Bit mask of M9PR field.
	MATRIX_PRBS3_M10PR_Pos = 0x8   // Position of M10PR field.
	MATRIX_PRBS3_M10PR_Msk = 0x300 // Bit mask of M10PR field.

	// PRAS4: Priority Register A for Slave 4
	MATRIX_PRAS4_M0PR_Pos = 0x0        // Position of M0PR field.
	MATRIX_PRAS4_M0PR_Msk = 0x3        // Bit mask of M0PR field.
	MATRIX_PRAS4_M1PR_Pos = 0x4        // Position of M1PR field.
	MATRIX_PRAS4_M1PR_Msk = 0x30       // Bit mask of M1PR field.
	MATRIX_PRAS4_M2PR_Pos = 0x8        // Position of M2PR field.
	MATRIX_PRAS4_M2PR_Msk = 0x300      // Bit mask of M2PR field.
	MATRIX_PRAS4_M3PR_Pos = 0xc        // Position of M3PR field.
	MATRIX_PRAS4_M3PR_Msk = 0x3000     // Bit mask of M3PR field.
	MATRIX_PRAS4_M4PR_Pos = 0x10       // Position of M4PR field.
	MATRIX_PRAS4_M4PR_Msk = 0x30000    // Bit mask of M4PR field.
	MATRIX_PRAS4_M5PR_Pos = 0x14       // Position of M5PR field.
	MATRIX_PRAS4_M5PR_Msk = 0x300000   // Bit mask of M5PR field.
	MATRIX_PRAS4_M6PR_Pos = 0x18       // Position of M6PR field.
	MATRIX_PRAS4_M6PR_Msk = 0x3000000  // Bit mask of M6PR field.
	MATRIX_PRAS4_M7PR_Pos = 0x1c       // Position of M7PR field.
	MATRIX_PRAS4_M7PR_Msk = 0x30000000 // Bit mask of M7PR field.

	// PRBS4: Priority Register B for Slave 4
	MATRIX_PRBS4_M8PR_Pos  = 0x0   // Position of M8PR field.
	MATRIX_PRBS4_M8PR_Msk  = 0x3   // Bit mask of M8PR field.
	MATRIX_PRBS4_M9PR_Pos  = 0x4   // Position of M9PR field.
	MATRIX_PRBS4_M9PR_Msk  = 0x30  // Bit mask of M9PR field.
	MATRIX_PRBS4_M10PR_Pos = 0x8   // Position of M10PR field.
	MATRIX_PRBS4_M10PR_Msk = 0x300 // Bit mask of M10PR field.

	// PRAS5: Priority Register A for Slave 5
	MATRIX_PRAS5_M0PR_Pos = 0x0        // Position of M0PR field.
	MATRIX_PRAS5_M0PR_Msk = 0x3        // Bit mask of M0PR field.
	MATRIX_PRAS5_M1PR_Pos = 0x4        // Position of M1PR field.
	MATRIX_PRAS5_M1PR_Msk = 0x30       // Bit mask of M1PR field.
	MATRIX_PRAS5_M2PR_Pos = 0x8        // Position of M2PR field.
	MATRIX_PRAS5_M2PR_Msk = 0x300      // Bit mask of M2PR field.
	MATRIX_PRAS5_M3PR_Pos = 0xc        // Position of M3PR field.
	MATRIX_PRAS5_M3PR_Msk = 0x3000     // Bit mask of M3PR field.
	MATRIX_PRAS5_M4PR_Pos = 0x10       // Position of M4PR field.
	MATRIX_PRAS5_M4PR_Msk = 0x30000    // Bit mask of M4PR field.
	MATRIX_PRAS5_M5PR_Pos = 0x14       // Position of M5PR field.
	MATRIX_PRAS5_M5PR_Msk = 0x300000   // Bit mask of M5PR field.
	MATRIX_PRAS5_M6PR_Pos = 0x18       // Position of M6PR field.
	MATRIX_PRAS5_M6PR_Msk = 0x3000000  // Bit mask of M6PR field.
	MATRIX_PRAS5_M7PR_Pos = 0x1c       // Position of M7PR field.
	MATRIX_PRAS5_M7PR_Msk = 0x30000000 // Bit mask of M7PR field.

	// PRBS5: Priority Register B for Slave 5
	MATRIX_PRBS5_M8PR_Pos  = 0x0   // Position of M8PR field.
	MATRIX_PRBS5_M8PR_Msk  = 0x3   // Bit mask of M8PR field.
	MATRIX_PRBS5_M9PR_Pos  = 0x4   // Position of M9PR field.
	MATRIX_PRBS5_M9PR_Msk  = 0x30  // Bit mask of M9PR field.
	MATRIX_PRBS5_M10PR_Pos = 0x8   // Position of M10PR field.
	MATRIX_PRBS5_M10PR_Msk = 0x300 // Bit mask of M10PR field.

	// PRAS6: Priority Register A for Slave 6
	MATRIX_PRAS6_M0PR_Pos = 0x0        // Position of M0PR field.
	MATRIX_PRAS6_M0PR_Msk = 0x3        // Bit mask of M0PR field.
	MATRIX_PRAS6_M1PR_Pos = 0x4        // Position of M1PR field.
	MATRIX_PRAS6_M1PR_Msk = 0x30       // Bit mask of M1PR field.
	MATRIX_PRAS6_M2PR_Pos = 0x8        // Position of M2PR field.
	MATRIX_PRAS6_M2PR_Msk = 0x300      // Bit mask of M2PR field.
	MATRIX_PRAS6_M3PR_Pos = 0xc        // Position of M3PR field.
	MATRIX_PRAS6_M3PR_Msk = 0x3000     // Bit mask of M3PR field.
	MATRIX_PRAS6_M4PR_Pos = 0x10       // Position of M4PR field.
	MATRIX_PRAS6_M4PR_Msk = 0x30000    // Bit mask of M4PR field.
	MATRIX_PRAS6_M5PR_Pos = 0x14       // Position of M5PR field.
	MATRIX_PRAS6_M5PR_Msk = 0x300000   // Bit mask of M5PR field.
	MATRIX_PRAS6_M6PR_Pos = 0x18       // Position of M6PR field.
	MATRIX_PRAS6_M6PR_Msk = 0x3000000  // Bit mask of M6PR field.
	MATRIX_PRAS6_M7PR_Pos = 0x1c       // Position of M7PR field.
	MATRIX_PRAS6_M7PR_Msk = 0x30000000 // Bit mask of M7PR field.

	// PRBS6: Priority Register B for Slave 6
	MATRIX_PRBS6_M8PR_Pos  = 0x0   // Position of M8PR field.
	MATRIX_PRBS6_M8PR_Msk  = 0x3   // Bit mask of M8PR field.
	MATRIX_PRBS6_M9PR_Pos  = 0x4   // Position of M9PR field.
	MATRIX_PRBS6_M9PR_Msk  = 0x30  // Bit mask of M9PR field.
	MATRIX_PRBS6_M10PR_Pos = 0x8   // Position of M10PR field.
	MATRIX_PRBS6_M10PR_Msk = 0x300 // Bit mask of M10PR field.

	// PRAS7: Priority Register A for Slave 7
	MATRIX_PRAS7_M0PR_Pos = 0x0        // Position of M0PR field.
	MATRIX_PRAS7_M0PR_Msk = 0x3        // Bit mask of M0PR field.
	MATRIX_PRAS7_M1PR_Pos = 0x4        // Position of M1PR field.
	MATRIX_PRAS7_M1PR_Msk = 0x30       // Bit mask of M1PR field.
	MATRIX_PRAS7_M2PR_Pos = 0x8        // Position of M2PR field.
	MATRIX_PRAS7_M2PR_Msk = 0x300      // Bit mask of M2PR field.
	MATRIX_PRAS7_M3PR_Pos = 0xc        // Position of M3PR field.
	MATRIX_PRAS7_M3PR_Msk = 0x3000     // Bit mask of M3PR field.
	MATRIX_PRAS7_M4PR_Pos = 0x10       // Position of M4PR field.
	MATRIX_PRAS7_M4PR_Msk = 0x30000    // Bit mask of M4PR field.
	MATRIX_PRAS7_M5PR_Pos = 0x14       // Position of M5PR field.
	MATRIX_PRAS7_M5PR_Msk = 0x300000   // Bit mask of M5PR field.
	MATRIX_PRAS7_M6PR_Pos = 0x18       // Position of M6PR field.
	MATRIX_PRAS7_M6PR_Msk = 0x3000000  // Bit mask of M6PR field.
	MATRIX_PRAS7_M7PR_Pos = 0x1c       // Position of M7PR field.
	MATRIX_PRAS7_M7PR_Msk = 0x30000000 // Bit mask of M7PR field.

	// PRBS7: Priority Register B for Slave 7
	MATRIX_PRBS7_M8PR_Pos  = 0x0   // Position of M8PR field.
	MATRIX_PRBS7_M8PR_Msk  = 0x3   // Bit mask of M8PR field.
	MATRIX_PRBS7_M9PR_Pos  = 0x4   // Position of M9PR field.
	MATRIX_PRBS7_M9PR_Msk  = 0x30  // Bit mask of M9PR field.
	MATRIX_PRBS7_M10PR_Pos = 0x8   // Position of M10PR field.
	MATRIX_PRBS7_M10PR_Msk = 0x300 // Bit mask of M10PR field.

	// MRCR: Master Remap Control Register
	MATRIX_MRCR_RCB0_Pos  = 0x0   // Position of RCB0 field.
	MATRIX_MRCR_RCB0_Msk  = 0x1   // Bit mask of RCB0 field.
	MATRIX_MRCR_RCB0      = 0x1   // Bit RCB0.
	MATRIX_MRCR_RCB1_Pos  = 0x1   // Position of RCB1 field.
	MATRIX_MRCR_RCB1_Msk  = 0x2   // Bit mask of RCB1 field.
	MATRIX_MRCR_RCB1      = 0x2   // Bit RCB1.
	MATRIX_MRCR_RCB2_Pos  = 0x2   // Position of RCB2 field.
	MATRIX_MRCR_RCB2_Msk  = 0x4   // Bit mask of RCB2 field.
	MATRIX_MRCR_RCB2      = 0x4   // Bit RCB2.
	MATRIX_MRCR_RCB3_Pos  = 0x3   // Position of RCB3 field.
	MATRIX_MRCR_RCB3_Msk  = 0x8   // Bit mask of RCB3 field.
	MATRIX_MRCR_RCB3      = 0x8   // Bit RCB3.
	MATRIX_MRCR_RCB4_Pos  = 0x4   // Position of RCB4 field.
	MATRIX_MRCR_RCB4_Msk  = 0x10  // Bit mask of RCB4 field.
	MATRIX_MRCR_RCB4      = 0x10  // Bit RCB4.
	MATRIX_MRCR_RCB5_Pos  = 0x5   // Position of RCB5 field.
	MATRIX_MRCR_RCB5_Msk  = 0x20  // Bit mask of RCB5 field.
	MATRIX_MRCR_RCB5      = 0x20  // Bit RCB5.
	MATRIX_MRCR_RCB6_Pos  = 0x6   // Position of RCB6 field.
	MATRIX_MRCR_RCB6_Msk  = 0x40  // Bit mask of RCB6 field.
	MATRIX_MRCR_RCB6      = 0x40  // Bit RCB6.
	MATRIX_MRCR_RCB7_Pos  = 0x7   // Position of RCB7 field.
	MATRIX_MRCR_RCB7_Msk  = 0x80  // Bit mask of RCB7 field.
	MATRIX_MRCR_RCB7      = 0x80  // Bit RCB7.
	MATRIX_MRCR_RCB8_Pos  = 0x8   // Position of RCB8 field.
	MATRIX_MRCR_RCB8_Msk  = 0x100 // Bit mask of RCB8 field.
	MATRIX_MRCR_RCB8      = 0x100 // Bit RCB8.
	MATRIX_MRCR_RCB9_Pos  = 0x9   // Position of RCB9 field.
	MATRIX_MRCR_RCB9_Msk  = 0x200 // Bit mask of RCB9 field.
	MATRIX_MRCR_RCB9      = 0x200 // Bit RCB9.
	MATRIX_MRCR_RCB10_Pos = 0xa   // Position of RCB10 field.
	MATRIX_MRCR_RCB10_Msk = 0x400 // Bit mask of RCB10 field.
	MATRIX_MRCR_RCB10     = 0x400 // Bit RCB10.

	// WPMR: Write Protect Mode Register
	MATRIX_WPMR_WPEN_Pos  = 0x0        // Position of WPEN field.
	MATRIX_WPMR_WPEN_Msk  = 0x1        // Bit mask of WPEN field.
	MATRIX_WPMR_WPEN      = 0x1        // Bit WPEN.
	MATRIX_WPMR_WPKEY_Pos = 0x8        // Position of WPKEY field.
	MATRIX_WPMR_WPKEY_Msk = 0xffffff00 // Bit mask of WPKEY field.

	// WPSR: Write Protect Status Register
	MATRIX_WPSR_WPVS_Pos   = 0x0      // Position of WPVS field.
	MATRIX_WPSR_WPVS_Msk   = 0x1      // Bit mask of WPVS field.
	MATRIX_WPSR_WPVS       = 0x1      // Bit WPVS.
	MATRIX_WPSR_WPVSRC_Pos = 0x8      // Position of WPVSRC field.
	MATRIX_WPSR_WPVSRC_Msk = 0xffff00 // Bit mask of WPVSRC field.
)

// Bitfields for DMAC: DMA Controller
const (
	// GCFG: DMAC Global Configuration Register
	DMAC_GCFG_ARB_CFG_Pos = 0x4  // Position of ARB_CFG field.
	DMAC_GCFG_ARB_CFG_Msk = 0x10 // Bit mask of ARB_CFG field.
	DMAC_GCFG_ARB_CFG     = 0x10 // Bit ARB_CFG.

	// EN: DMAC Enable Register
	DMAC_EN_ENABLE_Pos = 0x0 // Position of ENABLE field.
	DMAC_EN_ENABLE_Msk = 0x1 // Bit mask of ENABLE field.
	DMAC_EN_ENABLE     = 0x1 // Bit ENABLE.

	// SREQ: DMAC Software Single Request Register
	DMAC_SREQ_SSREQ0_Pos = 0x0    // Position of SSREQ0 field.
	DMAC_SREQ_SSREQ0_Msk = 0x1    // Bit mask of SSREQ0 field.
	DMAC_SREQ_SSREQ0     = 0x1    // Bit SSREQ0.
	DMAC_SREQ_DSREQ0_Pos = 0x1    // Position of DSREQ0 field.
	DMAC_SREQ_DSREQ0_Msk = 0x2    // Bit mask of DSREQ0 field.
	DMAC_SREQ_DSREQ0     = 0x2    // Bit DSREQ0.
	DMAC_SREQ_SSREQ1_Pos = 0x2    // Position of SSREQ1 field.
	DMAC_SREQ_SSREQ1_Msk = 0x4    // Bit mask of SSREQ1 field.
	DMAC_SREQ_SSREQ1     = 0x4    // Bit SSREQ1.
	DMAC_SREQ_DSREQ1_Pos = 0x3    // Position of DSREQ1 field.
	DMAC_SREQ_DSREQ1_Msk = 0x8    // Bit mask of DSREQ1 field.
	DMAC_SREQ_DSREQ1     = 0x8    // Bit DSREQ1.
	DMAC_SREQ_SSREQ2_Pos = 0x4    // Position of SSREQ2 field.
	DMAC_SREQ_SSREQ2_Msk = 0x10   // Bit mask of SSREQ2 field.
	DMAC_SREQ_SSREQ2     = 0x10   // Bit SSREQ2.
	DMAC_SREQ_DSREQ2_Pos = 0x5    // Position of DSREQ2 field.
	DMAC_SREQ_DSREQ2_Msk = 0x20   // Bit mask of DSREQ2 field.
	DMAC_SREQ_DSREQ2     = 0x20   // Bit DSREQ2.
	DMAC_SREQ_SSREQ3_Pos = 0x6    // Position of SSREQ3 field.
	DMAC_SREQ_SSREQ3_Msk = 0x40   // Bit mask of SSREQ3 field.
	DMAC_SREQ_SSREQ3     = 0x40   // Bit SSREQ3.
	DMAC_SREQ_DSREQ3_Pos = 0x7    // Position of DSREQ3 field.
	DMAC_SREQ_DSREQ3_Msk = 0x80   // Bit mask of DSREQ3 field.
	DMAC_SREQ_DSREQ3     = 0x80   // Bit DSREQ3.
	DMAC_SREQ_SSREQ4_Pos = 0x8    // Position of SSREQ4 field.
	DMAC_SREQ_SSREQ4_Msk = 0x100  // Bit mask of SSREQ4 field.
	DMAC_SREQ_SSREQ4     = 0x100  // Bit SSREQ4.
	DMAC_SREQ_DSREQ4_Pos = 0x9    // Position of DSREQ4 field.
	DMAC_SREQ_DSREQ4_Msk = 0x200  // Bit mask of DSREQ4 field.
	DMAC_SREQ_DSREQ4     = 0x200  // Bit DSREQ4.
	DMAC_SREQ_SSREQ5_Pos = 0xa    // Position of SSREQ5 field.
	DMAC_SREQ_SSREQ5_Msk = 0x400  // Bit mask of SSREQ5 field.
	DMAC_SREQ_SSREQ5     = 0x400  // Bit SSREQ5.
	DMAC_SREQ_DSREQ5_Pos = 0xb    // Position of DSREQ5 field.
	DMAC_SREQ_DSREQ5_Msk = 0x800  // Bit mask of DSREQ5 field.
	DMAC_SREQ_DSREQ5     = 0x800  // Bit DSREQ5.
	DMAC_SREQ_SSREQ6_Pos = 0xc    // Position of SSREQ6 field.
	DMAC_SREQ_SSREQ6_Msk = 0x1000 // Bit mask of SSREQ6 field.
	DMAC_SREQ_SSREQ6     = 0x1000 // Bit SSREQ6.
	DMAC_SREQ_DSREQ6_Pos = 0xd    // Position of DSREQ6 field.
	DMAC_SREQ_DSREQ6_Msk = 0x2000 // Bit mask of DSREQ6 field.
	DMAC_SREQ_DSREQ6     = 0x2000 // Bit DSREQ6.
	DMAC_SREQ_SSREQ7_Pos = 0xe    // Position of SSREQ7 field.
	DMAC_SREQ_SSREQ7_Msk = 0x4000 // Bit mask of SSREQ7 field.
	DMAC_SREQ_SSREQ7     = 0x4000 // Bit SSREQ7.
	DMAC_SREQ_DSREQ7_Pos = 0xf    // Position of DSREQ7 field.
	DMAC_SREQ_DSREQ7_Msk = 0x8000 // Bit mask of DSREQ7 field.
	DMAC_SREQ_DSREQ7     = 0x8000 // Bit DSREQ7.

	// CREQ: DMAC Software Chunk Transfer Request Register
	DMAC_CREQ_SCREQ0_Pos = 0x0    // Position of SCREQ0 field.
	DMAC_CREQ_SCREQ0_Msk = 0x1    // Bit mask of SCREQ0 field.
	DMAC_CREQ_SCREQ0     = 0x1    // Bit SCREQ0.
	DMAC_CREQ_DCREQ0_Pos = 0x1    // Position of DCREQ0 field.
	DMAC_CREQ_DCREQ0_Msk = 0x2    // Bit mask of DCREQ0 field.
	DMAC_CREQ_DCREQ0     = 0x2    // Bit DCREQ0.
	DMAC_CREQ_SCREQ1_Pos = 0x2    // Position of SCREQ1 field.
	DMAC_CREQ_SCREQ1_Msk = 0x4    // Bit mask of SCREQ1 field.
	DMAC_CREQ_SCREQ1     = 0x4    // Bit SCREQ1.
	DMAC_CREQ_DCREQ1_Pos = 0x3    // Position of DCREQ1 field.
	DMAC_CREQ_DCREQ1_Msk = 0x8    // Bit mask of DCREQ1 field.
	DMAC_CREQ_DCREQ1     = 0x8    // Bit DCREQ1.
	DMAC_CREQ_SCREQ2_Pos = 0x4    // Position of SCREQ2 field.
	DMAC_CREQ_SCREQ2_Msk = 0x10   // Bit mask of SCREQ2 field.
	DMAC_CREQ_SCREQ2     = 0x10   // Bit SCREQ2.
	DMAC_CREQ_DCREQ2_Pos = 0x5    // Position of DCREQ2 field.
	DMAC_CREQ_DCREQ2_Msk = 0x20   // Bit mask of DCREQ2 field.
	DMAC_CREQ_DCREQ2     = 0x20   // Bit DCREQ2.
	DMAC_CREQ_SCREQ3_Pos = 0x6    // Position of SCREQ3 field.
	DMAC_CREQ_SCREQ3_Msk = 0x40   // Bit mask of SCREQ3 field.
	DMAC_CREQ_SCREQ3     = 0x40   // Bit SCREQ3.
	DMAC_CREQ_DCREQ3_Pos = 0x7    // Position of DCREQ3 field.
	DMAC_CREQ_DCREQ3_Msk = 0x80   // Bit mask of DCREQ3 field.
	DMAC_CREQ_DCREQ3     = 0x80   // Bit DCREQ3.
	DMAC_CREQ_SCREQ4_Pos = 0x8    // Position of SCREQ4 field.
	DMAC_CREQ_SCREQ4_Msk = 0x100  // Bit mask of SCREQ4 field.
	DMAC_CREQ_SCREQ4     = 0x100  // Bit SCREQ4.
	DMAC_CREQ_DCREQ4_Pos = 0x9    // Position of DCREQ4 field.
	DMAC_CREQ_DCREQ4_Msk = 0x200  // Bit mask of DCREQ4 field.
	DMAC_CREQ_DCREQ4     = 0x200  // Bit DCREQ4.
	DMAC_CREQ_SCREQ5_Pos = 0xa    // Position of SCREQ5 field.
	DMAC_CREQ_SCREQ5_Msk = 0x400  // Bit mask of SCREQ5 field.
	DMAC_CREQ_SCREQ5     = 0x400  // Bit SCREQ5.
	DMAC_CREQ_DCREQ5_Pos = 0xb    // Position of DCREQ5 field.
	DMAC_CREQ_DCREQ5_Msk = 0x800  // Bit mask of DCREQ5 field.
	DMAC_CREQ_DCREQ5     = 0x800  // Bit DCREQ5.
	DMAC_CREQ_SCREQ6_Pos = 0xc    // Position of SCREQ6 field.
	DMAC_CREQ_SCREQ6_Msk = 0x1000 // Bit mask of SCREQ6 field.
	DMAC_CREQ_SCREQ6     = 0x1000 // Bit SCREQ6.
	DMAC_CREQ_DCREQ6_Pos = 0xd    // Position of DCREQ6 field.
	DMAC_CREQ_DCREQ6_Msk = 0x2000 // Bit mask of DCREQ6 field.
	DMAC_CREQ_DCREQ6     = 0x2000 // Bit DCREQ6.
	DMAC_CREQ_SCREQ7_Pos = 0xe    // Position of SCREQ7 field.
	DMAC_CREQ_SCREQ7_Msk = 0x4000 // Bit mask of SCREQ7 field.
	DMAC_CREQ_SCREQ7     = 0x4000 // Bit SCREQ7.
	DMAC_CREQ_DCREQ7_Pos = 0xf    // Position of DCREQ7 field.
	DMAC_CREQ_DCREQ7_Msk = 0x8000 // Bit mask of DCREQ7 field.
	DMAC_CREQ_DCREQ7     = 0x8000 // Bit DCREQ7.

	// LAST: DMAC Software Last Transfer Flag Register
	DMAC_LAST_SLAST0_Pos = 0x0    // Position of SLAST0 field.
	DMAC_LAST_SLAST0_Msk = 0x1    // Bit mask of SLAST0 field.
	DMAC_LAST_SLAST0     = 0x1    // Bit SLAST0.
	DMAC_LAST_DLAST0_Pos = 0x1    // Position of DLAST0 field.
	DMAC_LAST_DLAST0_Msk = 0x2    // Bit mask of DLAST0 field.
	DMAC_LAST_DLAST0     = 0x2    // Bit DLAST0.
	DMAC_LAST_SLAST1_Pos = 0x2    // Position of SLAST1 field.
	DMAC_LAST_SLAST1_Msk = 0x4    // Bit mask of SLAST1 field.
	DMAC_LAST_SLAST1     = 0x4    // Bit SLAST1.
	DMAC_LAST_DLAST1_Pos = 0x3    // Position of DLAST1 field.
	DMAC_LAST_DLAST1_Msk = 0x8    // Bit mask of DLAST1 field.
	DMAC_LAST_DLAST1     = 0x8    // Bit DLAST1.
	DMAC_LAST_SLAST2_Pos = 0x4    // Position of SLAST2 field.
	DMAC_LAST_SLAST2_Msk = 0x10   // Bit mask of SLAST2 field.
	DMAC_LAST_SLAST2     = 0x10   // Bit SLAST2.
	DMAC_LAST_DLAST2_Pos = 0x5    // Position of DLAST2 field.
	DMAC_LAST_DLAST2_Msk = 0x20   // Bit mask of DLAST2 field.
	DMAC_LAST_DLAST2     = 0x20   // Bit DLAST2.
	DMAC_LAST_SLAST3_Pos = 0x6    // Position of SLAST3 field.
	DMAC_LAST_SLAST3_Msk = 0x40   // Bit mask of SLAST3 field.
	DMAC_LAST_SLAST3     = 0x40   // Bit SLAST3.
	DMAC_LAST_DLAST3_Pos = 0x7    // Position of DLAST3 field.
	DMAC_LAST_DLAST3_Msk = 0x80   // Bit mask of DLAST3 field.
	DMAC_LAST_DLAST3     = 0x80   // Bit DLAST3.
	DMAC_LAST_SLAST4_Pos = 0x8    // Position of SLAST4 field.
	DMAC_LAST_SLAST4_Msk = 0x100  // Bit mask of SLAST4 field.
	DMAC_LAST_SLAST4     = 0x100  // Bit SLAST4.
	DMAC_LAST_DLAST4_Pos = 0x9    // Position of DLAST4 field.
	DMAC_LAST_DLAST4_Msk = 0x200  // Bit mask of DLAST4 field.
	DMAC_LAST_DLAST4     = 0x200  // Bit DLAST4.
	DMAC_LAST_SLAST5_Pos = 0xa    // Position of SLAST5 field.
	DMAC_LAST_SLAST5_Msk = 0x400  // Bit mask of SLAST5 field.
	DMAC_LAST_SLAST5     = 0x400  // Bit SLAST5.
	DMAC_LAST_DLAST5_Pos = 0xb    // Position of DLAST5 field.
	DMAC_LAST_DLAST5_Msk = 0x800  // Bit mask of DLAST5 field.
	DMAC_LAST_DLAST5     = 0x800  // Bit DLAST5.
	DMAC_LAST_SLAST6_Pos = 0xc    // Position of SLAST6 field.
	DMAC_LAST_SLAST6_Msk = 0x1000 // Bit mask of SLAST6 field.
	DMAC_LAST_SLAST6     = 0x1000 // Bit SLAST6.
	DMAC_LAST_DLAST6_Pos = 0xd    // Position of DLAST6 field.
	DMAC_LAST_DLAST6_Msk = 0x2000 // Bit mask of DLAST6 field.
	DMAC_LAST_DLAST6     = 0x2000 // Bit DLAST6.
	DMAC_LAST_SLAST7_Pos = 0xe    // Position of SLAST7 field.
	DMAC_LAST_SLAST7_Msk = 0x4000 // Bit mask of SLAST7 field.
	DMAC_LAST_SLAST7     = 0x4000 // Bit SLAST7.
	DMAC_LAST_DLAST7_Pos = 0xf    // Position of DLAST7 field.
	DMAC_LAST_DLAST7_Msk = 0x8000 // Bit mask of DLAST7 field.
	DMAC_LAST_DLAST7     = 0x8000 // Bit DLAST7.

	// EBCIER: DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Interrupt Enable register.
	DMAC_EBCIER_BTC0_Pos  = 0x0      // Position of BTC0 field.
	DMAC_EBCIER_BTC0_Msk  = 0x1      // Bit mask of BTC0 field.
	DMAC_EBCIER_BTC0      = 0x1      // Bit BTC0.
	DMAC_EBCIER_BTC1_Pos  = 0x1      // Position of BTC1 field.
	DMAC_EBCIER_BTC1_Msk  = 0x2      // Bit mask of BTC1 field.
	DMAC_EBCIER_BTC1      = 0x2      // Bit BTC1.
	DMAC_EBCIER_BTC2_Pos  = 0x2      // Position of BTC2 field.
	DMAC_EBCIER_BTC2_Msk  = 0x4      // Bit mask of BTC2 field.
	DMAC_EBCIER_BTC2      = 0x4      // Bit BTC2.
	DMAC_EBCIER_BTC3_Pos  = 0x3      // Position of BTC3 field.
	DMAC_EBCIER_BTC3_Msk  = 0x8      // Bit mask of BTC3 field.
	DMAC_EBCIER_BTC3      = 0x8      // Bit BTC3.
	DMAC_EBCIER_BTC4_Pos  = 0x4      // Position of BTC4 field.
	DMAC_EBCIER_BTC4_Msk  = 0x10     // Bit mask of BTC4 field.
	DMAC_EBCIER_BTC4      = 0x10     // Bit BTC4.
	DMAC_EBCIER_BTC5_Pos  = 0x5      // Position of BTC5 field.
	DMAC_EBCIER_BTC5_Msk  = 0x20     // Bit mask of BTC5 field.
	DMAC_EBCIER_BTC5      = 0x20     // Bit BTC5.
	DMAC_EBCIER_BTC6_Pos  = 0x6      // Position of BTC6 field.
	DMAC_EBCIER_BTC6_Msk  = 0x40     // Bit mask of BTC6 field.
	DMAC_EBCIER_BTC6      = 0x40     // Bit BTC6.
	DMAC_EBCIER_BTC7_Pos  = 0x7      // Position of BTC7 field.
	DMAC_EBCIER_BTC7_Msk  = 0x80     // Bit mask of BTC7 field.
	DMAC_EBCIER_BTC7      = 0x80     // Bit BTC7.
	DMAC_EBCIER_CBTC0_Pos = 0x8      // Position of CBTC0 field.
	DMAC_EBCIER_CBTC0_Msk = 0x100    // Bit mask of CBTC0 field.
	DMAC_EBCIER_CBTC0     = 0x100    // Bit CBTC0.
	DMAC_EBCIER_CBTC1_Pos = 0x9      // Position of CBTC1 field.
	DMAC_EBCIER_CBTC1_Msk = 0x200    // Bit mask of CBTC1 field.
	DMAC_EBCIER_CBTC1     = 0x200    // Bit CBTC1.
	DMAC_EBCIER_CBTC2_Pos = 0xa      // Position of CBTC2 field.
	DMAC_EBCIER_CBTC2_Msk = 0x400    // Bit mask of CBTC2 field.
	DMAC_EBCIER_CBTC2     = 0x400    // Bit CBTC2.
	DMAC_EBCIER_CBTC3_Pos = 0xb      // Position of CBTC3 field.
	DMAC_EBCIER_CBTC3_Msk = 0x800    // Bit mask of CBTC3 field.
	DMAC_EBCIER_CBTC3     = 0x800    // Bit CBTC3.
	DMAC_EBCIER_CBTC4_Pos = 0xc      // Position of CBTC4 field.
	DMAC_EBCIER_CBTC4_Msk = 0x1000   // Bit mask of CBTC4 field.
	DMAC_EBCIER_CBTC4     = 0x1000   // Bit CBTC4.
	DMAC_EBCIER_CBTC5_Pos = 0xd      // Position of CBTC5 field.
	DMAC_EBCIER_CBTC5_Msk = 0x2000   // Bit mask of CBTC5 field.
	DMAC_EBCIER_CBTC5     = 0x2000   // Bit CBTC5.
	DMAC_EBCIER_CBTC6_Pos = 0xe      // Position of CBTC6 field.
	DMAC_EBCIER_CBTC6_Msk = 0x4000   // Bit mask of CBTC6 field.
	DMAC_EBCIER_CBTC6     = 0x4000   // Bit CBTC6.
	DMAC_EBCIER_CBTC7_Pos = 0xf      // Position of CBTC7 field.
	DMAC_EBCIER_CBTC7_Msk = 0x8000   // Bit mask of CBTC7 field.
	DMAC_EBCIER_CBTC7     = 0x8000   // Bit CBTC7.
	DMAC_EBCIER_ERR0_Pos  = 0x10     // Position of ERR0 field.
	DMAC_EBCIER_ERR0_Msk  = 0x10000  // Bit mask of ERR0 field.
	DMAC_EBCIER_ERR0      = 0x10000  // Bit ERR0.
	DMAC_EBCIER_ERR1_Pos  = 0x11     // Position of ERR1 field.
	DMAC_EBCIER_ERR1_Msk  = 0x20000  // Bit mask of ERR1 field.
	DMAC_EBCIER_ERR1      = 0x20000  // Bit ERR1.
	DMAC_EBCIER_ERR2_Pos  = 0x12     // Position of ERR2 field.
	DMAC_EBCIER_ERR2_Msk  = 0x40000  // Bit mask of ERR2 field.
	DMAC_EBCIER_ERR2      = 0x40000  // Bit ERR2.
	DMAC_EBCIER_ERR3_Pos  = 0x13     // Position of ERR3 field.
	DMAC_EBCIER_ERR3_Msk  = 0x80000  // Bit mask of ERR3 field.
	DMAC_EBCIER_ERR3      = 0x80000  // Bit ERR3.
	DMAC_EBCIER_ERR4_Pos  = 0x14     // Position of ERR4 field.
	DMAC_EBCIER_ERR4_Msk  = 0x100000 // Bit mask of ERR4 field.
	DMAC_EBCIER_ERR4      = 0x100000 // Bit ERR4.
	DMAC_EBCIER_ERR5_Pos  = 0x15     // Position of ERR5 field.
	DMAC_EBCIER_ERR5_Msk  = 0x200000 // Bit mask of ERR5 field.
	DMAC_EBCIER_ERR5      = 0x200000 // Bit ERR5.
	DMAC_EBCIER_ERR6_Pos  = 0x16     // Position of ERR6 field.
	DMAC_EBCIER_ERR6_Msk  = 0x400000 // Bit mask of ERR6 field.
	DMAC_EBCIER_ERR6      = 0x400000 // Bit ERR6.
	DMAC_EBCIER_ERR7_Pos  = 0x17     // Position of ERR7 field.
	DMAC_EBCIER_ERR7_Msk  = 0x800000 // Bit mask of ERR7 field.
	DMAC_EBCIER_ERR7      = 0x800000 // Bit ERR7.

	// EBCIDR: DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Interrupt Disable register.
	DMAC_EBCIDR_BTC0_Pos  = 0x0      // Position of BTC0 field.
	DMAC_EBCIDR_BTC0_Msk  = 0x1      // Bit mask of BTC0 field.
	DMAC_EBCIDR_BTC0      = 0x1      // Bit BTC0.
	DMAC_EBCIDR_BTC1_Pos  = 0x1      // Position of BTC1 field.
	DMAC_EBCIDR_BTC1_Msk  = 0x2      // Bit mask of BTC1 field.
	DMAC_EBCIDR_BTC1      = 0x2      // Bit BTC1.
	DMAC_EBCIDR_BTC2_Pos  = 0x2      // Position of BTC2 field.
	DMAC_EBCIDR_BTC2_Msk  = 0x4      // Bit mask of BTC2 field.
	DMAC_EBCIDR_BTC2      = 0x4      // Bit BTC2.
	DMAC_EBCIDR_BTC3_Pos  = 0x3      // Position of BTC3 field.
	DMAC_EBCIDR_BTC3_Msk  = 0x8      // Bit mask of BTC3 field.
	DMAC_EBCIDR_BTC3      = 0x8      // Bit BTC3.
	DMAC_EBCIDR_BTC4_Pos  = 0x4      // Position of BTC4 field.
	DMAC_EBCIDR_BTC4_Msk  = 0x10     // Bit mask of BTC4 field.
	DMAC_EBCIDR_BTC4      = 0x10     // Bit BTC4.
	DMAC_EBCIDR_BTC5_Pos  = 0x5      // Position of BTC5 field.
	DMAC_EBCIDR_BTC5_Msk  = 0x20     // Bit mask of BTC5 field.
	DMAC_EBCIDR_BTC5      = 0x20     // Bit BTC5.
	DMAC_EBCIDR_BTC6_Pos  = 0x6      // Position of BTC6 field.
	DMAC_EBCIDR_BTC6_Msk  = 0x40     // Bit mask of BTC6 field.
	DMAC_EBCIDR_BTC6      = 0x40     // Bit BTC6.
	DMAC_EBCIDR_BTC7_Pos  = 0x7      // Position of BTC7 field.
	DMAC_EBCIDR_BTC7_Msk  = 0x80     // Bit mask of BTC7 field.
	DMAC_EBCIDR_BTC7      = 0x80     // Bit BTC7.
	DMAC_EBCIDR_CBTC0_Pos = 0x8      // Position of CBTC0 field.
	DMAC_EBCIDR_CBTC0_Msk = 0x100    // Bit mask of CBTC0 field.
	DMAC_EBCIDR_CBTC0     = 0x100    // Bit CBTC0.
	DMAC_EBCIDR_CBTC1_Pos = 0x9      // Position of CBTC1 field.
	DMAC_EBCIDR_CBTC1_Msk = 0x200    // Bit mask of CBTC1 field.
	DMAC_EBCIDR_CBTC1     = 0x200    // Bit CBTC1.
	DMAC_EBCIDR_CBTC2_Pos = 0xa      // Position of CBTC2 field.
	DMAC_EBCIDR_CBTC2_Msk = 0x400    // Bit mask of CBTC2 field.
	DMAC_EBCIDR_CBTC2     = 0x400    // Bit CBTC2.
	DMAC_EBCIDR_CBTC3_Pos = 0xb      // Position of CBTC3 field.
	DMAC_EBCIDR_CBTC3_Msk = 0x800    // Bit mask of CBTC3 field.
	DMAC_EBCIDR_CBTC3     = 0x800    // Bit CBTC3.
	DMAC_EBCIDR_CBTC4_Pos = 0xc      // Position of CBTC4 field.
	DMAC_EBCIDR_CBTC4_Msk = 0x1000   // Bit mask of CBTC4 field.
	DMAC_EBCIDR_CBTC4     = 0x1000   // Bit CBTC4.
	DMAC_EBCIDR_CBTC5_Pos = 0xd      // Position of CBTC5 field.
	DMAC_EBCIDR_CBTC5_Msk = 0x2000   // Bit mask of CBTC5 field.
	DMAC_EBCIDR_CBTC5     = 0x2000   // Bit CBTC5.
	DMAC_EBCIDR_CBTC6_Pos = 0xe      // Position of CBTC6 field.
	DMAC_EBCIDR_CBTC6_Msk = 0x4000   // Bit mask of CBTC6 field.
	DMAC_EBCIDR_CBTC6     = 0x4000   // Bit CBTC6.
	DMAC_EBCIDR_CBTC7_Pos = 0xf      // Position of CBTC7 field.
	DMAC_EBCIDR_CBTC7_Msk = 0x8000   // Bit mask of CBTC7 field.
	DMAC_EBCIDR_CBTC7     = 0x8000   // Bit CBTC7.
	DMAC_EBCIDR_ERR0_Pos  = 0x10     // Position of ERR0 field.
	DMAC_EBCIDR_ERR0_Msk  = 0x10000  // Bit mask of ERR0 field.
	DMAC_EBCIDR_ERR0      = 0x10000  // Bit ERR0.
	DMAC_EBCIDR_ERR1_Pos  = 0x11     // Position of ERR1 field.
	DMAC_EBCIDR_ERR1_Msk  = 0x20000  // Bit mask of ERR1 field.
	DMAC_EBCIDR_ERR1      = 0x20000  // Bit ERR1.
	DMAC_EBCIDR_ERR2_Pos  = 0x12     // Position of ERR2 field.
	DMAC_EBCIDR_ERR2_Msk  = 0x40000  // Bit mask of ERR2 field.
	DMAC_EBCIDR_ERR2      = 0x40000  // Bit ERR2.
	DMAC_EBCIDR_ERR3_Pos  = 0x13     // Position of ERR3 field.
	DMAC_EBCIDR_ERR3_Msk  = 0x80000  // Bit mask of ERR3 field.
	DMAC_EBCIDR_ERR3      = 0x80000  // Bit ERR3.
	DMAC_EBCIDR_ERR4_Pos  = 0x14     // Position of ERR4 field.
	DMAC_EBCIDR_ERR4_Msk  = 0x100000 // Bit mask of ERR4 field.
	DMAC_EBCIDR_ERR4      = 0x100000 // Bit ERR4.
	DMAC_EBCIDR_ERR5_Pos  = 0x15     // Position of ERR5 field.
	DMAC_EBCIDR_ERR5_Msk  = 0x200000 // Bit mask of ERR5 field.
	DMAC_EBCIDR_ERR5      = 0x200000 // Bit ERR5.
	DMAC_EBCIDR_ERR6_Pos  = 0x16     // Position of ERR6 field.
	DMAC_EBCIDR_ERR6_Msk  = 0x400000 // Bit mask of ERR6 field.
	DMAC_EBCIDR_ERR6      = 0x400000 // Bit ERR6.
	DMAC_EBCIDR_ERR7_Pos  = 0x17     // Position of ERR7 field.
	DMAC_EBCIDR_ERR7_Msk  = 0x800000 // Bit mask of ERR7 field.
	DMAC_EBCIDR_ERR7      = 0x800000 // Bit ERR7.

	// EBCIMR: DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Mask Register.
	DMAC_EBCIMR_BTC0_Pos  = 0x0      // Position of BTC0 field.
	DMAC_EBCIMR_BTC0_Msk  = 0x1      // Bit mask of BTC0 field.
	DMAC_EBCIMR_BTC0      = 0x1      // Bit BTC0.
	DMAC_EBCIMR_BTC1_Pos  = 0x1      // Position of BTC1 field.
	DMAC_EBCIMR_BTC1_Msk  = 0x2      // Bit mask of BTC1 field.
	DMAC_EBCIMR_BTC1      = 0x2      // Bit BTC1.
	DMAC_EBCIMR_BTC2_Pos  = 0x2      // Position of BTC2 field.
	DMAC_EBCIMR_BTC2_Msk  = 0x4      // Bit mask of BTC2 field.
	DMAC_EBCIMR_BTC2      = 0x4      // Bit BTC2.
	DMAC_EBCIMR_BTC3_Pos  = 0x3      // Position of BTC3 field.
	DMAC_EBCIMR_BTC3_Msk  = 0x8      // Bit mask of BTC3 field.
	DMAC_EBCIMR_BTC3      = 0x8      // Bit BTC3.
	DMAC_EBCIMR_BTC4_Pos  = 0x4      // Position of BTC4 field.
	DMAC_EBCIMR_BTC4_Msk  = 0x10     // Bit mask of BTC4 field.
	DMAC_EBCIMR_BTC4      = 0x10     // Bit BTC4.
	DMAC_EBCIMR_BTC5_Pos  = 0x5      // Position of BTC5 field.
	DMAC_EBCIMR_BTC5_Msk  = 0x20     // Bit mask of BTC5 field.
	DMAC_EBCIMR_BTC5      = 0x20     // Bit BTC5.
	DMAC_EBCIMR_BTC6_Pos  = 0x6      // Position of BTC6 field.
	DMAC_EBCIMR_BTC6_Msk  = 0x40     // Bit mask of BTC6 field.
	DMAC_EBCIMR_BTC6      = 0x40     // Bit BTC6.
	DMAC_EBCIMR_BTC7_Pos  = 0x7      // Position of BTC7 field.
	DMAC_EBCIMR_BTC7_Msk  = 0x80     // Bit mask of BTC7 field.
	DMAC_EBCIMR_BTC7      = 0x80     // Bit BTC7.
	DMAC_EBCIMR_CBTC0_Pos = 0x8      // Position of CBTC0 field.
	DMAC_EBCIMR_CBTC0_Msk = 0x100    // Bit mask of CBTC0 field.
	DMAC_EBCIMR_CBTC0     = 0x100    // Bit CBTC0.
	DMAC_EBCIMR_CBTC1_Pos = 0x9      // Position of CBTC1 field.
	DMAC_EBCIMR_CBTC1_Msk = 0x200    // Bit mask of CBTC1 field.
	DMAC_EBCIMR_CBTC1     = 0x200    // Bit CBTC1.
	DMAC_EBCIMR_CBTC2_Pos = 0xa      // Position of CBTC2 field.
	DMAC_EBCIMR_CBTC2_Msk = 0x400    // Bit mask of CBTC2 field.
	DMAC_EBCIMR_CBTC2     = 0x400    // Bit CBTC2.
	DMAC_EBCIMR_CBTC3_Pos = 0xb      // Position of CBTC3 field.
	DMAC_EBCIMR_CBTC3_Msk = 0x800    // Bit mask of CBTC3 field.
	DMAC_EBCIMR_CBTC3     = 0x800    // Bit CBTC3.
	DMAC_EBCIMR_CBTC4_Pos = 0xc      // Position of CBTC4 field.
	DMAC_EBCIMR_CBTC4_Msk = 0x1000   // Bit mask of CBTC4 field.
	DMAC_EBCIMR_CBTC4     = 0x1000   // Bit CBTC4.
	DMAC_EBCIMR_CBTC5_Pos = 0xd      // Position of CBTC5 field.
	DMAC_EBCIMR_CBTC5_Msk = 0x2000   // Bit mask of CBTC5 field.
	DMAC_EBCIMR_CBTC5     = 0x2000   // Bit CBTC5.
	DMAC_EBCIMR_CBTC6_Pos = 0xe      // Position of CBTC6 field.
	DMAC_EBCIMR_CBTC6_Msk = 0x4000   // Bit mask of CBTC6 field.
	DMAC_EBCIMR_CBTC6     = 0x4000   // Bit CBTC6.
	DMAC_EBCIMR_CBTC7_Pos = 0xf      // Position of CBTC7 field.
	DMAC_EBCIMR_CBTC7_Msk = 0x8000   // Bit mask of CBTC7 field.
	DMAC_EBCIMR_CBTC7     = 0x8000   // Bit CBTC7.
	DMAC_EBCIMR_ERR0_Pos  = 0x10     // Position of ERR0 field.
	DMAC_EBCIMR_ERR0_Msk  = 0x10000  // Bit mask of ERR0 field.
	DMAC_EBCIMR_ERR0      = 0x10000  // Bit ERR0.
	DMAC_EBCIMR_ERR1_Pos  = 0x11     // Position of ERR1 field.
	DMAC_EBCIMR_ERR1_Msk  = 0x20000  // Bit mask of ERR1 field.
	DMAC_EBCIMR_ERR1      = 0x20000  // Bit ERR1.
	DMAC_EBCIMR_ERR2_Pos  = 0x12     // Position of ERR2 field.
	DMAC_EBCIMR_ERR2_Msk  = 0x40000  // Bit mask of ERR2 field.
	DMAC_EBCIMR_ERR2      = 0x40000  // Bit ERR2.
	DMAC_EBCIMR_ERR3_Pos  = 0x13     // Position of ERR3 field.
	DMAC_EBCIMR_ERR3_Msk  = 0x80000  // Bit mask of ERR3 field.
	DMAC_EBCIMR_ERR3      = 0x80000  // Bit ERR3.
	DMAC_EBCIMR_ERR4_Pos  = 0x14     // Position of ERR4 field.
	DMAC_EBCIMR_ERR4_Msk  = 0x100000 // Bit mask of ERR4 field.
	DMAC_EBCIMR_ERR4      = 0x100000 // Bit ERR4.
	DMAC_EBCIMR_ERR5_Pos  = 0x15     // Position of ERR5 field.
	DMAC_EBCIMR_ERR5_Msk  = 0x200000 // Bit mask of ERR5 field.
	DMAC_EBCIMR_ERR5      = 0x200000 // Bit ERR5.
	DMAC_EBCIMR_ERR6_Pos  = 0x16     // Position of ERR6 field.
	DMAC_EBCIMR_ERR6_Msk  = 0x400000 // Bit mask of ERR6 field.
	DMAC_EBCIMR_ERR6      = 0x400000 // Bit ERR6.
	DMAC_EBCIMR_ERR7_Pos  = 0x17     // Position of ERR7 field.
	DMAC_EBCIMR_ERR7_Msk  = 0x800000 // Bit mask of ERR7 field.
	DMAC_EBCIMR_ERR7      = 0x800000 // Bit ERR7.

	// EBCISR: DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Status Register.
	DMAC_EBCISR_BTC0_Pos  = 0x0      // Position of BTC0 field.
	DMAC_EBCISR_BTC0_Msk  = 0x1      // Bit mask of BTC0 field.
	DMAC_EBCISR_BTC0      = 0x1      // Bit BTC0.
	DMAC_EBCISR_BTC1_Pos  = 0x1      // Position of BTC1 field.
	DMAC_EBCISR_BTC1_Msk  = 0x2      // Bit mask of BTC1 field.
	DMAC_EBCISR_BTC1      = 0x2      // Bit BTC1.
	DMAC_EBCISR_BTC2_Pos  = 0x2      // Position of BTC2 field.
	DMAC_EBCISR_BTC2_Msk  = 0x4      // Bit mask of BTC2 field.
	DMAC_EBCISR_BTC2      = 0x4      // Bit BTC2.
	DMAC_EBCISR_BTC3_Pos  = 0x3      // Position of BTC3 field.
	DMAC_EBCISR_BTC3_Msk  = 0x8      // Bit mask of BTC3 field.
	DMAC_EBCISR_BTC3      = 0x8      // Bit BTC3.
	DMAC_EBCISR_BTC4_Pos  = 0x4      // Position of BTC4 field.
	DMAC_EBCISR_BTC4_Msk  = 0x10     // Bit mask of BTC4 field.
	DMAC_EBCISR_BTC4      = 0x10     // Bit BTC4.
	DMAC_EBCISR_BTC5_Pos  = 0x5      // Position of BTC5 field.
	DMAC_EBCISR_BTC5_Msk  = 0x20     // Bit mask of BTC5 field.
	DMAC_EBCISR_BTC5      = 0x20     // Bit BTC5.
	DMAC_EBCISR_BTC6_Pos  = 0x6      // Position of BTC6 field.
	DMAC_EBCISR_BTC6_Msk  = 0x40     // Bit mask of BTC6 field.
	DMAC_EBCISR_BTC6      = 0x40     // Bit BTC6.
	DMAC_EBCISR_BTC7_Pos  = 0x7      // Position of BTC7 field.
	DMAC_EBCISR_BTC7_Msk  = 0x80     // Bit mask of BTC7 field.
	DMAC_EBCISR_BTC7      = 0x80     // Bit BTC7.
	DMAC_EBCISR_CBTC0_Pos = 0x8      // Position of CBTC0 field.
	DMAC_EBCISR_CBTC0_Msk = 0x100    // Bit mask of CBTC0 field.
	DMAC_EBCISR_CBTC0     = 0x100    // Bit CBTC0.
	DMAC_EBCISR_CBTC1_Pos = 0x9      // Position of CBTC1 field.
	DMAC_EBCISR_CBTC1_Msk = 0x200    // Bit mask of CBTC1 field.
	DMAC_EBCISR_CBTC1     = 0x200    // Bit CBTC1.
	DMAC_EBCISR_CBTC2_Pos = 0xa      // Position of CBTC2 field.
	DMAC_EBCISR_CBTC2_Msk = 0x400    // Bit mask of CBTC2 field.
	DMAC_EBCISR_CBTC2     = 0x400    // Bit CBTC2.
	DMAC_EBCISR_CBTC3_Pos = 0xb      // Position of CBTC3 field.
	DMAC_EBCISR_CBTC3_Msk = 0x800    // Bit mask of CBTC3 field.
	DMAC_EBCISR_CBTC3     = 0x800    // Bit CBTC3.
	DMAC_EBCISR_CBTC4_Pos = 0xc      // Position of CBTC4 field.
	DMAC_EBCISR_CBTC4_Msk = 0x1000   // Bit mask of CBTC4 field.
	DMAC_EBCISR_CBTC4     = 0x1000   // Bit CBTC4.
	DMAC_EBCISR_CBTC5_Pos = 0xd      // Position of CBTC5 field.
	DMAC_EBCISR_CBTC5_Msk = 0x2000   // Bit mask of CBTC5 field.
	DMAC_EBCISR_CBTC5     = 0x2000   // Bit CBTC5.
	DMAC_EBCISR_CBTC6_Pos = 0xe      // Position of CBTC6 field.
	DMAC_EBCISR_CBTC6_Msk = 0x4000   // Bit mask of CBTC6 field.
	DMAC_EBCISR_CBTC6     = 0x4000   // Bit CBTC6.
	DMAC_EBCISR_CBTC7_Pos = 0xf      // Position of CBTC7 field.
	DMAC_EBCISR_CBTC7_Msk = 0x8000   // Bit mask of CBTC7 field.
	DMAC_EBCISR_CBTC7     = 0x8000   // Bit CBTC7.
	DMAC_EBCISR_ERR0_Pos  = 0x10     // Position of ERR0 field.
	DMAC_EBCISR_ERR0_Msk  = 0x10000  // Bit mask of ERR0 field.
	DMAC_EBCISR_ERR0      = 0x10000  // Bit ERR0.
	DMAC_EBCISR_ERR1_Pos  = 0x11     // Position of ERR1 field.
	DMAC_EBCISR_ERR1_Msk  = 0x20000  // Bit mask of ERR1 field.
	DMAC_EBCISR_ERR1      = 0x20000  // Bit ERR1.
	DMAC_EBCISR_ERR2_Pos  = 0x12     // Position of ERR2 field.
	DMAC_EBCISR_ERR2_Msk  = 0x40000  // Bit mask of ERR2 field.
	DMAC_EBCISR_ERR2      = 0x40000  // Bit ERR2.
	DMAC_EBCISR_ERR3_Pos  = 0x13     // Position of ERR3 field.
	DMAC_EBCISR_ERR3_Msk  = 0x80000  // Bit mask of ERR3 field.
	DMAC_EBCISR_ERR3      = 0x80000  // Bit ERR3.
	DMAC_EBCISR_ERR4_Pos  = 0x14     // Position of ERR4 field.
	DMAC_EBCISR_ERR4_Msk  = 0x100000 // Bit mask of ERR4 field.
	DMAC_EBCISR_ERR4      = 0x100000 // Bit ERR4.
	DMAC_EBCISR_ERR5_Pos  = 0x15     // Position of ERR5 field.
	DMAC_EBCISR_ERR5_Msk  = 0x200000 // Bit mask of ERR5 field.
	DMAC_EBCISR_ERR5      = 0x200000 // Bit ERR5.
	DMAC_EBCISR_ERR6_Pos  = 0x16     // Position of ERR6 field.
	DMAC_EBCISR_ERR6_Msk  = 0x400000 // Bit mask of ERR6 field.
	DMAC_EBCISR_ERR6      = 0x400000 // Bit ERR6.
	DMAC_EBCISR_ERR7_Pos  = 0x17     // Position of ERR7 field.
	DMAC_EBCISR_ERR7_Msk  = 0x800000 // Bit mask of ERR7 field.
	DMAC_EBCISR_ERR7      = 0x800000 // Bit ERR7.

	// CHER: DMAC Channel Handler Enable Register
	DMAC_CHER_ENA0_Pos  = 0x0        // Position of ENA0 field.
	DMAC_CHER_ENA0_Msk  = 0x1        // Bit mask of ENA0 field.
	DMAC_CHER_ENA0      = 0x1        // Bit ENA0.
	DMAC_CHER_ENA1_Pos  = 0x1        // Position of ENA1 field.
	DMAC_CHER_ENA1_Msk  = 0x2        // Bit mask of ENA1 field.
	DMAC_CHER_ENA1      = 0x2        // Bit ENA1.
	DMAC_CHER_ENA2_Pos  = 0x2        // Position of ENA2 field.
	DMAC_CHER_ENA2_Msk  = 0x4        // Bit mask of ENA2 field.
	DMAC_CHER_ENA2      = 0x4        // Bit ENA2.
	DMAC_CHER_ENA3_Pos  = 0x3        // Position of ENA3 field.
	DMAC_CHER_ENA3_Msk  = 0x8        // Bit mask of ENA3 field.
	DMAC_CHER_ENA3      = 0x8        // Bit ENA3.
	DMAC_CHER_ENA4_Pos  = 0x4        // Position of ENA4 field.
	DMAC_CHER_ENA4_Msk  = 0x10       // Bit mask of ENA4 field.
	DMAC_CHER_ENA4      = 0x10       // Bit ENA4.
	DMAC_CHER_ENA5_Pos  = 0x5        // Position of ENA5 field.
	DMAC_CHER_ENA5_Msk  = 0x20       // Bit mask of ENA5 field.
	DMAC_CHER_ENA5      = 0x20       // Bit ENA5.
	DMAC_CHER_ENA6_Pos  = 0x6        // Position of ENA6 field.
	DMAC_CHER_ENA6_Msk  = 0x40       // Bit mask of ENA6 field.
	DMAC_CHER_ENA6      = 0x40       // Bit ENA6.
	DMAC_CHER_ENA7_Pos  = 0x7        // Position of ENA7 field.
	DMAC_CHER_ENA7_Msk  = 0x80       // Bit mask of ENA7 field.
	DMAC_CHER_ENA7      = 0x80       // Bit ENA7.
	DMAC_CHER_SUSP0_Pos = 0x8        // Position of SUSP0 field.
	DMAC_CHER_SUSP0_Msk = 0x100      // Bit mask of SUSP0 field.
	DMAC_CHER_SUSP0     = 0x100      // Bit SUSP0.
	DMAC_CHER_SUSP1_Pos = 0x9        // Position of SUSP1 field.
	DMAC_CHER_SUSP1_Msk = 0x200      // Bit mask of SUSP1 field.
	DMAC_CHER_SUSP1     = 0x200      // Bit SUSP1.
	DMAC_CHER_SUSP2_Pos = 0xa        // Position of SUSP2 field.
	DMAC_CHER_SUSP2_Msk = 0x400      // Bit mask of SUSP2 field.
	DMAC_CHER_SUSP2     = 0x400      // Bit SUSP2.
	DMAC_CHER_SUSP3_Pos = 0xb        // Position of SUSP3 field.
	DMAC_CHER_SUSP3_Msk = 0x800      // Bit mask of SUSP3 field.
	DMAC_CHER_SUSP3     = 0x800      // Bit SUSP3.
	DMAC_CHER_SUSP4_Pos = 0xc        // Position of SUSP4 field.
	DMAC_CHER_SUSP4_Msk = 0x1000     // Bit mask of SUSP4 field.
	DMAC_CHER_SUSP4     = 0x1000     // Bit SUSP4.
	DMAC_CHER_SUSP5_Pos = 0xd        // Position of SUSP5 field.
	DMAC_CHER_SUSP5_Msk = 0x2000     // Bit mask of SUSP5 field.
	DMAC_CHER_SUSP5     = 0x2000     // Bit SUSP5.
	DMAC_CHER_SUSP6_Pos = 0xe        // Position of SUSP6 field.
	DMAC_CHER_SUSP6_Msk = 0x4000     // Bit mask of SUSP6 field.
	DMAC_CHER_SUSP6     = 0x4000     // Bit SUSP6.
	DMAC_CHER_SUSP7_Pos = 0xf        // Position of SUSP7 field.
	DMAC_CHER_SUSP7_Msk = 0x8000     // Bit mask of SUSP7 field.
	DMAC_CHER_SUSP7     = 0x8000     // Bit SUSP7.
	DMAC_CHER_KEEP0_Pos = 0x18       // Position of KEEP0 field.
	DMAC_CHER_KEEP0_Msk = 0x1000000  // Bit mask of KEEP0 field.
	DMAC_CHER_KEEP0     = 0x1000000  // Bit KEEP0.
	DMAC_CHER_KEEP1_Pos = 0x19       // Position of KEEP1 field.
	DMAC_CHER_KEEP1_Msk = 0x2000000  // Bit mask of KEEP1 field.
	DMAC_CHER_KEEP1     = 0x2000000  // Bit KEEP1.
	DMAC_CHER_KEEP2_Pos = 0x1a       // Position of KEEP2 field.
	DMAC_CHER_KEEP2_Msk = 0x4000000  // Bit mask of KEEP2 field.
	DMAC_CHER_KEEP2     = 0x4000000  // Bit KEEP2.
	DMAC_CHER_KEEP3_Pos = 0x1b       // Position of KEEP3 field.
	DMAC_CHER_KEEP3_Msk = 0x8000000  // Bit mask of KEEP3 field.
	DMAC_CHER_KEEP3     = 0x8000000  // Bit KEEP3.
	DMAC_CHER_KEEP4_Pos = 0x1c       // Position of KEEP4 field.
	DMAC_CHER_KEEP4_Msk = 0x10000000 // Bit mask of KEEP4 field.
	DMAC_CHER_KEEP4     = 0x10000000 // Bit KEEP4.
	DMAC_CHER_KEEP5_Pos = 0x1d       // Position of KEEP5 field.
	DMAC_CHER_KEEP5_Msk = 0x20000000 // Bit mask of KEEP5 field.
	DMAC_CHER_KEEP5     = 0x20000000 // Bit KEEP5.
	DMAC_CHER_KEEP6_Pos = 0x1e       // Position of KEEP6 field.
	DMAC_CHER_KEEP6_Msk = 0x40000000 // Bit mask of KEEP6 field.
	DMAC_CHER_KEEP6     = 0x40000000 // Bit KEEP6.
	DMAC_CHER_KEEP7_Pos = 0x1f       // Position of KEEP7 field.
	DMAC_CHER_KEEP7_Msk = 0x80000000 // Bit mask of KEEP7 field.
	DMAC_CHER_KEEP7     = 0x80000000 // Bit KEEP7.

	// CHDR: DMAC Channel Handler Disable Register
	DMAC_CHDR_DIS0_Pos = 0x0    // Position of DIS0 field.
	DMAC_CHDR_DIS0_Msk = 0x1    // Bit mask of DIS0 field.
	DMAC_CHDR_DIS0     = 0x1    // Bit DIS0.
	DMAC_CHDR_DIS1_Pos = 0x1    // Position of DIS1 field.
	DMAC_CHDR_DIS1_Msk = 0x2    // Bit mask of DIS1 field.
	DMAC_CHDR_DIS1     = 0x2    // Bit DIS1.
	DMAC_CHDR_DIS2_Pos = 0x2    // Position of DIS2 field.
	DMAC_CHDR_DIS2_Msk = 0x4    // Bit mask of DIS2 field.
	DMAC_CHDR_DIS2     = 0x4    // Bit DIS2.
	DMAC_CHDR_DIS3_Pos = 0x3    // Position of DIS3 field.
	DMAC_CHDR_DIS3_Msk = 0x8    // Bit mask of DIS3 field.
	DMAC_CHDR_DIS3     = 0x8    // Bit DIS3.
	DMAC_CHDR_DIS4_Pos = 0x4    // Position of DIS4 field.
	DMAC_CHDR_DIS4_Msk = 0x10   // Bit mask of DIS4 field.
	DMAC_CHDR_DIS4     = 0x10   // Bit DIS4.
	DMAC_CHDR_DIS5_Pos = 0x5    // Position of DIS5 field.
	DMAC_CHDR_DIS5_Msk = 0x20   // Bit mask of DIS5 field.
	DMAC_CHDR_DIS5     = 0x20   // Bit DIS5.
	DMAC_CHDR_DIS6_Pos = 0x6    // Position of DIS6 field.
	DMAC_CHDR_DIS6_Msk = 0x40   // Bit mask of DIS6 field.
	DMAC_CHDR_DIS6     = 0x40   // Bit DIS6.
	DMAC_CHDR_DIS7_Pos = 0x7    // Position of DIS7 field.
	DMAC_CHDR_DIS7_Msk = 0x80   // Bit mask of DIS7 field.
	DMAC_CHDR_DIS7     = 0x80   // Bit DIS7.
	DMAC_CHDR_RES0_Pos = 0x8    // Position of RES0 field.
	DMAC_CHDR_RES0_Msk = 0x100  // Bit mask of RES0 field.
	DMAC_CHDR_RES0     = 0x100  // Bit RES0.
	DMAC_CHDR_RES1_Pos = 0x9    // Position of RES1 field.
	DMAC_CHDR_RES1_Msk = 0x200  // Bit mask of RES1 field.
	DMAC_CHDR_RES1     = 0x200  // Bit RES1.
	DMAC_CHDR_RES2_Pos = 0xa    // Position of RES2 field.
	DMAC_CHDR_RES2_Msk = 0x400  // Bit mask of RES2 field.
	DMAC_CHDR_RES2     = 0x400  // Bit RES2.
	DMAC_CHDR_RES3_Pos = 0xb    // Position of RES3 field.
	DMAC_CHDR_RES3_Msk = 0x800  // Bit mask of RES3 field.
	DMAC_CHDR_RES3     = 0x800  // Bit RES3.
	DMAC_CHDR_RES4_Pos = 0xc    // Position of RES4 field.
	DMAC_CHDR_RES4_Msk = 0x1000 // Bit mask of RES4 field.
	DMAC_CHDR_RES4     = 0x1000 // Bit RES4.
	DMAC_CHDR_RES5_Pos = 0xd    // Position of RES5 field.
	DMAC_CHDR_RES5_Msk = 0x2000 // Bit mask of RES5 field.
	DMAC_CHDR_RES5     = 0x2000 // Bit RES5.
	DMAC_CHDR_RES6_Pos = 0xe    // Position of RES6 field.
	DMAC_CHDR_RES6_Msk = 0x4000 // Bit mask of RES6 field.
	DMAC_CHDR_RES6     = 0x4000 // Bit RES6.
	DMAC_CHDR_RES7_Pos = 0xf    // Position of RES7 field.
	DMAC_CHDR_RES7_Msk = 0x8000 // Bit mask of RES7 field.
	DMAC_CHDR_RES7     = 0x8000 // Bit RES7.

	// CHSR: DMAC Channel Handler Status Register
	DMAC_CHSR_ENA0_Pos  = 0x0        // Position of ENA0 field.
	DMAC_CHSR_ENA0_Msk  = 0x1        // Bit mask of ENA0 field.
	DMAC_CHSR_ENA0      = 0x1        // Bit ENA0.
	DMAC_CHSR_ENA1_Pos  = 0x1        // Position of ENA1 field.
	DMAC_CHSR_ENA1_Msk  = 0x2        // Bit mask of ENA1 field.
	DMAC_CHSR_ENA1      = 0x2        // Bit ENA1.
	DMAC_CHSR_ENA2_Pos  = 0x2        // Position of ENA2 field.
	DMAC_CHSR_ENA2_Msk  = 0x4        // Bit mask of ENA2 field.
	DMAC_CHSR_ENA2      = 0x4        // Bit ENA2.
	DMAC_CHSR_ENA3_Pos  = 0x3        // Position of ENA3 field.
	DMAC_CHSR_ENA3_Msk  = 0x8        // Bit mask of ENA3 field.
	DMAC_CHSR_ENA3      = 0x8        // Bit ENA3.
	DMAC_CHSR_ENA4_Pos  = 0x4        // Position of ENA4 field.
	DMAC_CHSR_ENA4_Msk  = 0x10       // Bit mask of ENA4 field.
	DMAC_CHSR_ENA4      = 0x10       // Bit ENA4.
	DMAC_CHSR_ENA5_Pos  = 0x5        // Position of ENA5 field.
	DMAC_CHSR_ENA5_Msk  = 0x20       // Bit mask of ENA5 field.
	DMAC_CHSR_ENA5      = 0x20       // Bit ENA5.
	DMAC_CHSR_ENA6_Pos  = 0x6        // Position of ENA6 field.
	DMAC_CHSR_ENA6_Msk  = 0x40       // Bit mask of ENA6 field.
	DMAC_CHSR_ENA6      = 0x40       // Bit ENA6.
	DMAC_CHSR_ENA7_Pos  = 0x7        // Position of ENA7 field.
	DMAC_CHSR_ENA7_Msk  = 0x80       // Bit mask of ENA7 field.
	DMAC_CHSR_ENA7      = 0x80       // Bit ENA7.
	DMAC_CHSR_SUSP0_Pos = 0x8        // Position of SUSP0 field.
	DMAC_CHSR_SUSP0_Msk = 0x100      // Bit mask of SUSP0 field.
	DMAC_CHSR_SUSP0     = 0x100      // Bit SUSP0.
	DMAC_CHSR_SUSP1_Pos = 0x9        // Position of SUSP1 field.
	DMAC_CHSR_SUSP1_Msk = 0x200      // Bit mask of SUSP1 field.
	DMAC_CHSR_SUSP1     = 0x200      // Bit SUSP1.
	DMAC_CHSR_SUSP2_Pos = 0xa        // Position of SUSP2 field.
	DMAC_CHSR_SUSP2_Msk = 0x400      // Bit mask of SUSP2 field.
	DMAC_CHSR_SUSP2     = 0x400      // Bit SUSP2.
	DMAC_CHSR_SUSP3_Pos = 0xb        // Position of SUSP3 field.
	DMAC_CHSR_SUSP3_Msk = 0x800      // Bit mask of SUSP3 field.
	DMAC_CHSR_SUSP3     = 0x800      // Bit SUSP3.
	DMAC_CHSR_SUSP4_Pos = 0xc        // Position of SUSP4 field.
	DMAC_CHSR_SUSP4_Msk = 0x1000     // Bit mask of SUSP4 field.
	DMAC_CHSR_SUSP4     = 0x1000     // Bit SUSP4.
	DMAC_CHSR_SUSP5_Pos = 0xd        // Position of SUSP5 field.
	DMAC_CHSR_SUSP5_Msk = 0x2000     // Bit mask of SUSP5 field.
	DMAC_CHSR_SUSP5     = 0x2000     // Bit SUSP5.
	DMAC_CHSR_SUSP6_Pos = 0xe        // Position of SUSP6 field.
	DMAC_CHSR_SUSP6_Msk = 0x4000     // Bit mask of SUSP6 field.
	DMAC_CHSR_SUSP6     = 0x4000     // Bit SUSP6.
	DMAC_CHSR_SUSP7_Pos = 0xf        // Position of SUSP7 field.
	DMAC_CHSR_SUSP7_Msk = 0x8000     // Bit mask of SUSP7 field.
	DMAC_CHSR_SUSP7     = 0x8000     // Bit SUSP7.
	DMAC_CHSR_EMPT0_Pos = 0x10       // Position of EMPT0 field.
	DMAC_CHSR_EMPT0_Msk = 0x10000    // Bit mask of EMPT0 field.
	DMAC_CHSR_EMPT0     = 0x10000    // Bit EMPT0.
	DMAC_CHSR_EMPT1_Pos = 0x11       // Position of EMPT1 field.
	DMAC_CHSR_EMPT1_Msk = 0x20000    // Bit mask of EMPT1 field.
	DMAC_CHSR_EMPT1     = 0x20000    // Bit EMPT1.
	DMAC_CHSR_EMPT2_Pos = 0x12       // Position of EMPT2 field.
	DMAC_CHSR_EMPT2_Msk = 0x40000    // Bit mask of EMPT2 field.
	DMAC_CHSR_EMPT2     = 0x40000    // Bit EMPT2.
	DMAC_CHSR_EMPT3_Pos = 0x13       // Position of EMPT3 field.
	DMAC_CHSR_EMPT3_Msk = 0x80000    // Bit mask of EMPT3 field.
	DMAC_CHSR_EMPT3     = 0x80000    // Bit EMPT3.
	DMAC_CHSR_EMPT4_Pos = 0x14       // Position of EMPT4 field.
	DMAC_CHSR_EMPT4_Msk = 0x100000   // Bit mask of EMPT4 field.
	DMAC_CHSR_EMPT4     = 0x100000   // Bit EMPT4.
	DMAC_CHSR_EMPT5_Pos = 0x15       // Position of EMPT5 field.
	DMAC_CHSR_EMPT5_Msk = 0x200000   // Bit mask of EMPT5 field.
	DMAC_CHSR_EMPT5     = 0x200000   // Bit EMPT5.
	DMAC_CHSR_EMPT6_Pos = 0x16       // Position of EMPT6 field.
	DMAC_CHSR_EMPT6_Msk = 0x400000   // Bit mask of EMPT6 field.
	DMAC_CHSR_EMPT6     = 0x400000   // Bit EMPT6.
	DMAC_CHSR_EMPT7_Pos = 0x17       // Position of EMPT7 field.
	DMAC_CHSR_EMPT7_Msk = 0x800000   // Bit mask of EMPT7 field.
	DMAC_CHSR_EMPT7     = 0x800000   // Bit EMPT7.
	DMAC_CHSR_STAL0_Pos = 0x18       // Position of STAL0 field.
	DMAC_CHSR_STAL0_Msk = 0x1000000  // Bit mask of STAL0 field.
	DMAC_CHSR_STAL0     = 0x1000000  // Bit STAL0.
	DMAC_CHSR_STAL1_Pos = 0x19       // Position of STAL1 field.
	DMAC_CHSR_STAL1_Msk = 0x2000000  // Bit mask of STAL1 field.
	DMAC_CHSR_STAL1     = 0x2000000  // Bit STAL1.
	DMAC_CHSR_STAL2_Pos = 0x1a       // Position of STAL2 field.
	DMAC_CHSR_STAL2_Msk = 0x4000000  // Bit mask of STAL2 field.
	DMAC_CHSR_STAL2     = 0x4000000  // Bit STAL2.
	DMAC_CHSR_STAL3_Pos = 0x1b       // Position of STAL3 field.
	DMAC_CHSR_STAL3_Msk = 0x8000000  // Bit mask of STAL3 field.
	DMAC_CHSR_STAL3     = 0x8000000  // Bit STAL3.
	DMAC_CHSR_STAL4_Pos = 0x1c       // Position of STAL4 field.
	DMAC_CHSR_STAL4_Msk = 0x10000000 // Bit mask of STAL4 field.
	DMAC_CHSR_STAL4     = 0x10000000 // Bit STAL4.
	DMAC_CHSR_STAL5_Pos = 0x1d       // Position of STAL5 field.
	DMAC_CHSR_STAL5_Msk = 0x20000000 // Bit mask of STAL5 field.
	DMAC_CHSR_STAL5     = 0x20000000 // Bit STAL5.
	DMAC_CHSR_STAL6_Pos = 0x1e       // Position of STAL6 field.
	DMAC_CHSR_STAL6_Msk = 0x40000000 // Bit mask of STAL6 field.
	DMAC_CHSR_STAL6     = 0x40000000 // Bit STAL6.
	DMAC_CHSR_STAL7_Pos = 0x1f       // Position of STAL7 field.
	DMAC_CHSR_STAL7_Msk = 0x80000000 // Bit mask of STAL7 field.
	DMAC_CHSR_STAL7     = 0x80000000 // Bit STAL7.

	// SADDR0: DMAC Channel Source Address Register (ch_num = 0)
	DMAC_SADDR0_SADDR_Pos = 0x0        // Position of SADDR field.
	DMAC_SADDR0_SADDR_Msk = 0xffffffff // Bit mask of SADDR field.

	// DADDR0: DMAC Channel Destination Address Register (ch_num = 0)
	DMAC_DADDR0_DADDR_Pos = 0x0        // Position of DADDR field.
	DMAC_DADDR0_DADDR_Msk = 0xffffffff // Bit mask of DADDR field.

	// DSCR0: DMAC Channel Descriptor Address Register (ch_num = 0)
	DMAC_DSCR0_DSCR_IF_Pos     = 0x0        // Position of DSCR_IF field.
	DMAC_DSCR0_DSCR_IF_Msk     = 0x3        // Bit mask of DSCR_IF field.
	DMAC_DSCR0_DSCR_IF_AHB_IFO = 0x0        // The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR0_DSCR_IF_AHB_IF1 = 0x1        // The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR0_DSCR_IF_AHB_IF2 = 0x2        // The buffer transfer descriptor is fetched via AHB-Lite Interface 2
	DMAC_DSCR0_DSCR_Pos        = 0x2        // Position of DSCR field.
	DMAC_DSCR0_DSCR_Msk        = 0xfffffffc // Bit mask of DSCR field.

	// CTRLA0: DMAC Channel Control A Register (ch_num = 0)
	DMAC_CTRLA0_BTSIZE_Pos          = 0x0        // Position of BTSIZE field.
	DMAC_CTRLA0_BTSIZE_Msk          = 0xffff     // Bit mask of BTSIZE field.
	DMAC_CTRLA0_SCSIZE_Pos          = 0x10       // Position of SCSIZE field.
	DMAC_CTRLA0_SCSIZE_Msk          = 0x70000    // Bit mask of SCSIZE field.
	DMAC_CTRLA0_SCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA0_SCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA0_SCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA0_SCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA0_SCSIZE_CHK_32       = 0x4        // 32 data transferred
	DMAC_CTRLA0_SCSIZE_CHK_64       = 0x5        // 64 data transferred
	DMAC_CTRLA0_SCSIZE_CHK_128      = 0x6        // 128 data transferred
	DMAC_CTRLA0_SCSIZE_CHK_256      = 0x7        // 256 data transferred
	DMAC_CTRLA0_DCSIZE_Pos          = 0x14       // Position of DCSIZE field.
	DMAC_CTRLA0_DCSIZE_Msk          = 0x700000   // Bit mask of DCSIZE field.
	DMAC_CTRLA0_DCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA0_DCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA0_DCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA0_DCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA0_DCSIZE_CHK_32       = 0x4        // 32 data transferred
	DMAC_CTRLA0_DCSIZE_CHK_64       = 0x5        // 64 data transferred
	DMAC_CTRLA0_DCSIZE_CHK_128      = 0x6        // 128 data transferred
	DMAC_CTRLA0_DCSIZE_CHK_256      = 0x7        // 256 data transferred
	DMAC_CTRLA0_SRC_WIDTH_Pos       = 0x18       // Position of SRC_WIDTH field.
	DMAC_CTRLA0_SRC_WIDTH_Msk       = 0x3000000  // Bit mask of SRC_WIDTH field.
	DMAC_CTRLA0_SRC_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA0_SRC_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA0_SRC_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA0_DST_WIDTH_Pos       = 0x1c       // Position of DST_WIDTH field.
	DMAC_CTRLA0_DST_WIDTH_Msk       = 0x30000000 // Bit mask of DST_WIDTH field.
	DMAC_CTRLA0_DST_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA0_DST_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA0_DST_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA0_DONE_Pos            = 0x1f       // Position of DONE field.
	DMAC_CTRLA0_DONE_Msk            = 0x80000000 // Bit mask of DONE field.
	DMAC_CTRLA0_DONE                = 0x80000000 // Bit DONE.

	// CTRLB0: DMAC Channel Control B Register (ch_num = 0)
	DMAC_CTRLB0_SIF_Pos               = 0x0        // Position of SIF field.
	DMAC_CTRLB0_SIF_Msk               = 0x3        // Bit mask of SIF field.
	DMAC_CTRLB0_SIF_AHB_IFO           = 0x0        // The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB0_SIF_AHB_IF1           = 0x1        // The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB0_SIF_AHB_IF2           = 0x2        // The source transfer is done via AHB-Lite Interface 2
	DMAC_CTRLB0_DIF_Pos               = 0x4        // Position of DIF field.
	DMAC_CTRLB0_DIF_Msk               = 0x30       // Bit mask of DIF field.
	DMAC_CTRLB0_DIF_AHB_IFO           = 0x0        // The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB0_DIF_AHB_IF1           = 0x1        // The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB0_DIF_AHB_IF2           = 0x2        // The destination transfer is done via AHB-Lite Interface 2
	DMAC_CTRLB0_SRC_DSCR_Pos          = 0x10       // Position of SRC_DSCR field.
	DMAC_CTRLB0_SRC_DSCR_Msk          = 0x10000    // Bit mask of SRC_DSCR field.
	DMAC_CTRLB0_SRC_DSCR              = 0x10000    // Bit SRC_DSCR.
	DMAC_CTRLB0_DST_DSCR_Pos          = 0x14       // Position of DST_DSCR field.
	DMAC_CTRLB0_DST_DSCR_Msk          = 0x100000   // Bit mask of DST_DSCR field.
	DMAC_CTRLB0_DST_DSCR              = 0x100000   // Bit DST_DSCR.
	DMAC_CTRLB0_FC_Pos                = 0x15       // Position of FC field.
	DMAC_CTRLB0_FC_Msk                = 0xe00000   // Bit mask of FC field.
	DMAC_CTRLB0_FC_MEM2MEM_DMA_FC     = 0x0        // Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB0_FC_MEM2PER_DMA_FC     = 0x1        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB0_FC_PER2MEM_DMA_FC     = 0x2        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB0_FC_PER2PER_DMA_FC     = 0x3        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB0_FC_PER2MEM_PER_FC     = 0x4        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB0_FC_MEM2PER_PER_FC     = 0x5        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB0_FC_PER2PER_SPER_FC    = 0x6        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB0_FC_PER2PER_DPER_FC    = 0x7        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB0_SRC_INCR_Pos          = 0x18       // Position of SRC_INCR field.
	DMAC_CTRLB0_SRC_INCR_Msk          = 0x3000000  // Bit mask of SRC_INCR field.
	DMAC_CTRLB0_SRC_INCR_INCREMENTING = 0x0        // The source address is incremented
	DMAC_CTRLB0_SRC_INCR_DECREMENTING = 0x1        // The source address is decremented
	DMAC_CTRLB0_SRC_INCR_FIXED        = 0x2        // The source address remains unchanged
	DMAC_CTRLB0_DST_INCR_Pos          = 0x1c       // Position of DST_INCR field.
	DMAC_CTRLB0_DST_INCR_Msk          = 0x30000000 // Bit mask of DST_INCR field.
	DMAC_CTRLB0_DST_INCR_INCREMENTING = 0x0        // The destination address is incremented
	DMAC_CTRLB0_DST_INCR_DECREMENTING = 0x1        // The destination address is decremented
	DMAC_CTRLB0_DST_INCR_FIXED        = 0x2        // The destination address remains unchanged
	DMAC_CTRLB0_IEN_Pos               = 0x1e       // Position of IEN field.
	DMAC_CTRLB0_IEN_Msk               = 0x40000000 // Bit mask of IEN field.
	DMAC_CTRLB0_IEN                   = 0x40000000 // Bit IEN.
	DMAC_CTRLB0_AUTO_Pos              = 0x1f       // Position of AUTO field.
	DMAC_CTRLB0_AUTO_Msk              = 0x80000000 // Bit mask of AUTO field.
	DMAC_CTRLB0_AUTO                  = 0x80000000 // Bit AUTO.

	// CFG0: DMAC Channel Configuration Register (ch_num = 0)
	DMAC_CFG0_SRC_PER_Pos      = 0x0        // Position of SRC_PER field.
	DMAC_CFG0_SRC_PER_Msk      = 0xf        // Bit mask of SRC_PER field.
	DMAC_CFG0_DST_PER_Pos      = 0x4        // Position of DST_PER field.
	DMAC_CFG0_DST_PER_Msk      = 0xf0       // Bit mask of DST_PER field.
	DMAC_CFG0_SRC_REP_Pos      = 0x8        // Position of SRC_REP field.
	DMAC_CFG0_SRC_REP_Msk      = 0x100      // Bit mask of SRC_REP field.
	DMAC_CFG0_SRC_REP          = 0x100      // Bit SRC_REP.
	DMAC_CFG0_SRC_H2SEL_Pos    = 0x9        // Position of SRC_H2SEL field.
	DMAC_CFG0_SRC_H2SEL_Msk    = 0x200      // Bit mask of SRC_H2SEL field.
	DMAC_CFG0_SRC_H2SEL        = 0x200      // Bit SRC_H2SEL.
	DMAC_CFG0_DST_REP_Pos      = 0xc        // Position of DST_REP field.
	DMAC_CFG0_DST_REP_Msk      = 0x1000     // Bit mask of DST_REP field.
	DMAC_CFG0_DST_REP          = 0x1000     // Bit DST_REP.
	DMAC_CFG0_DST_H2SEL_Pos    = 0xd        // Position of DST_H2SEL field.
	DMAC_CFG0_DST_H2SEL_Msk    = 0x2000     // Bit mask of DST_H2SEL field.
	DMAC_CFG0_DST_H2SEL        = 0x2000     // Bit DST_H2SEL.
	DMAC_CFG0_SOD_Pos          = 0x10       // Position of SOD field.
	DMAC_CFG0_SOD_Msk          = 0x10000    // Bit mask of SOD field.
	DMAC_CFG0_SOD              = 0x10000    // Bit SOD.
	DMAC_CFG0_LOCK_IF_Pos      = 0x14       // Position of LOCK_IF field.
	DMAC_CFG0_LOCK_IF_Msk      = 0x100000   // Bit mask of LOCK_IF field.
	DMAC_CFG0_LOCK_IF          = 0x100000   // Bit LOCK_IF.
	DMAC_CFG0_LOCK_B_Pos       = 0x15       // Position of LOCK_B field.
	DMAC_CFG0_LOCK_B_Msk       = 0x200000   // Bit mask of LOCK_B field.
	DMAC_CFG0_LOCK_B           = 0x200000   // Bit LOCK_B.
	DMAC_CFG0_LOCK_IF_L_Pos    = 0x16       // Position of LOCK_IF_L field.
	DMAC_CFG0_LOCK_IF_L_Msk    = 0x400000   // Bit mask of LOCK_IF_L field.
	DMAC_CFG0_LOCK_IF_L        = 0x400000   // Bit LOCK_IF_L.
	DMAC_CFG0_AHB_PROT_Pos     = 0x18       // Position of AHB_PROT field.
	DMAC_CFG0_AHB_PROT_Msk     = 0x7000000  // Bit mask of AHB_PROT field.
	DMAC_CFG0_FIFOCFG_Pos      = 0x1c       // Position of FIFOCFG field.
	DMAC_CFG0_FIFOCFG_Msk      = 0x30000000 // Bit mask of FIFOCFG field.
	DMAC_CFG0_FIFOCFG_ALAP_CFG = 0x0        // The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG0_FIFOCFG_HALF_CFG = 0x1        // When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG0_FIFOCFG_ASAP_CFG = 0x2        // When there is enough space/data available to perform a single AHB access, then the request is serviced.

	// SADDR1: DMAC Channel Source Address Register (ch_num = 1)
	DMAC_SADDR1_SADDR_Pos = 0x0        // Position of SADDR field.
	DMAC_SADDR1_SADDR_Msk = 0xffffffff // Bit mask of SADDR field.

	// DADDR1: DMAC Channel Destination Address Register (ch_num = 1)
	DMAC_DADDR1_DADDR_Pos = 0x0        // Position of DADDR field.
	DMAC_DADDR1_DADDR_Msk = 0xffffffff // Bit mask of DADDR field.

	// DSCR1: DMAC Channel Descriptor Address Register (ch_num = 1)
	DMAC_DSCR1_DSCR_IF_Pos     = 0x0        // Position of DSCR_IF field.
	DMAC_DSCR1_DSCR_IF_Msk     = 0x3        // Bit mask of DSCR_IF field.
	DMAC_DSCR1_DSCR_IF_AHB_IFO = 0x0        // The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR1_DSCR_IF_AHB_IF1 = 0x1        // The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR1_DSCR_IF_AHB_IF2 = 0x2        // The buffer transfer descriptor is fetched via AHB-Lite Interface 2
	DMAC_DSCR1_DSCR_Pos        = 0x2        // Position of DSCR field.
	DMAC_DSCR1_DSCR_Msk        = 0xfffffffc // Bit mask of DSCR field.

	// CTRLA1: DMAC Channel Control A Register (ch_num = 1)
	DMAC_CTRLA1_BTSIZE_Pos          = 0x0        // Position of BTSIZE field.
	DMAC_CTRLA1_BTSIZE_Msk          = 0xffff     // Bit mask of BTSIZE field.
	DMAC_CTRLA1_SCSIZE_Pos          = 0x10       // Position of SCSIZE field.
	DMAC_CTRLA1_SCSIZE_Msk          = 0x70000    // Bit mask of SCSIZE field.
	DMAC_CTRLA1_SCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA1_SCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA1_SCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA1_SCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA1_SCSIZE_CHK_32       = 0x4        // 32 data transferred
	DMAC_CTRLA1_SCSIZE_CHK_64       = 0x5        // 64 data transferred
	DMAC_CTRLA1_SCSIZE_CHK_128      = 0x6        // 128 data transferred
	DMAC_CTRLA1_SCSIZE_CHK_256      = 0x7        // 256 data transferred
	DMAC_CTRLA1_DCSIZE_Pos          = 0x14       // Position of DCSIZE field.
	DMAC_CTRLA1_DCSIZE_Msk          = 0x700000   // Bit mask of DCSIZE field.
	DMAC_CTRLA1_DCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA1_DCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA1_DCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA1_DCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA1_DCSIZE_CHK_32       = 0x4        // 32 data transferred
	DMAC_CTRLA1_DCSIZE_CHK_64       = 0x5        // 64 data transferred
	DMAC_CTRLA1_DCSIZE_CHK_128      = 0x6        // 128 data transferred
	DMAC_CTRLA1_DCSIZE_CHK_256      = 0x7        // 256 data transferred
	DMAC_CTRLA1_SRC_WIDTH_Pos       = 0x18       // Position of SRC_WIDTH field.
	DMAC_CTRLA1_SRC_WIDTH_Msk       = 0x3000000  // Bit mask of SRC_WIDTH field.
	DMAC_CTRLA1_SRC_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA1_SRC_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA1_SRC_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA1_DST_WIDTH_Pos       = 0x1c       // Position of DST_WIDTH field.
	DMAC_CTRLA1_DST_WIDTH_Msk       = 0x30000000 // Bit mask of DST_WIDTH field.
	DMAC_CTRLA1_DST_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA1_DST_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA1_DST_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA1_DONE_Pos            = 0x1f       // Position of DONE field.
	DMAC_CTRLA1_DONE_Msk            = 0x80000000 // Bit mask of DONE field.
	DMAC_CTRLA1_DONE                = 0x80000000 // Bit DONE.

	// CTRLB1: DMAC Channel Control B Register (ch_num = 1)
	DMAC_CTRLB1_SIF_Pos               = 0x0        // Position of SIF field.
	DMAC_CTRLB1_SIF_Msk               = 0x3        // Bit mask of SIF field.
	DMAC_CTRLB1_SIF_AHB_IFO           = 0x0        // The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB1_SIF_AHB_IF1           = 0x1        // The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB1_SIF_AHB_IF2           = 0x2        // The source transfer is done via AHB-Lite Interface 2
	DMAC_CTRLB1_DIF_Pos               = 0x4        // Position of DIF field.
	DMAC_CTRLB1_DIF_Msk               = 0x30       // Bit mask of DIF field.
	DMAC_CTRLB1_DIF_AHB_IFO           = 0x0        // The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB1_DIF_AHB_IF1           = 0x1        // The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB1_DIF_AHB_IF2           = 0x2        // The destination transfer is done via AHB-Lite Interface 2
	DMAC_CTRLB1_SRC_DSCR_Pos          = 0x10       // Position of SRC_DSCR field.
	DMAC_CTRLB1_SRC_DSCR_Msk          = 0x10000    // Bit mask of SRC_DSCR field.
	DMAC_CTRLB1_SRC_DSCR              = 0x10000    // Bit SRC_DSCR.
	DMAC_CTRLB1_DST_DSCR_Pos          = 0x14       // Position of DST_DSCR field.
	DMAC_CTRLB1_DST_DSCR_Msk          = 0x100000   // Bit mask of DST_DSCR field.
	DMAC_CTRLB1_DST_DSCR              = 0x100000   // Bit DST_DSCR.
	DMAC_CTRLB1_FC_Pos                = 0x15       // Position of FC field.
	DMAC_CTRLB1_FC_Msk                = 0xe00000   // Bit mask of FC field.
	DMAC_CTRLB1_FC_MEM2MEM_DMA_FC     = 0x0        // Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB1_FC_MEM2PER_DMA_FC     = 0x1        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB1_FC_PER2MEM_DMA_FC     = 0x2        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB1_FC_PER2PER_DMA_FC     = 0x3        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB1_FC_PER2MEM_PER_FC     = 0x4        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB1_FC_MEM2PER_PER_FC     = 0x5        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB1_FC_PER2PER_SPER_FC    = 0x6        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB1_FC_PER2PER_DPER_FC    = 0x7        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB1_SRC_INCR_Pos          = 0x18       // Position of SRC_INCR field.
	DMAC_CTRLB1_SRC_INCR_Msk          = 0x3000000  // Bit mask of SRC_INCR field.
	DMAC_CTRLB1_SRC_INCR_INCREMENTING = 0x0        // The source address is incremented
	DMAC_CTRLB1_SRC_INCR_DECREMENTING = 0x1        // The source address is decremented
	DMAC_CTRLB1_SRC_INCR_FIXED        = 0x2        // The source address remains unchanged
	DMAC_CTRLB1_DST_INCR_Pos          = 0x1c       // Position of DST_INCR field.
	DMAC_CTRLB1_DST_INCR_Msk          = 0x30000000 // Bit mask of DST_INCR field.
	DMAC_CTRLB1_DST_INCR_INCREMENTING = 0x0        // The destination address is incremented
	DMAC_CTRLB1_DST_INCR_DECREMENTING = 0x1        // The destination address is decremented
	DMAC_CTRLB1_DST_INCR_FIXED        = 0x2        // The destination address remains unchanged
	DMAC_CTRLB1_IEN_Pos               = 0x1e       // Position of IEN field.
	DMAC_CTRLB1_IEN_Msk               = 0x40000000 // Bit mask of IEN field.
	DMAC_CTRLB1_IEN                   = 0x40000000 // Bit IEN.
	DMAC_CTRLB1_AUTO_Pos              = 0x1f       // Position of AUTO field.
	DMAC_CTRLB1_AUTO_Msk              = 0x80000000 // Bit mask of AUTO field.
	DMAC_CTRLB1_AUTO                  = 0x80000000 // Bit AUTO.

	// CFG1: DMAC Channel Configuration Register (ch_num = 1)
	DMAC_CFG1_SRC_PER_Pos      = 0x0        // Position of SRC_PER field.
	DMAC_CFG1_SRC_PER_Msk      = 0xf        // Bit mask of SRC_PER field.
	DMAC_CFG1_DST_PER_Pos      = 0x4        // Position of DST_PER field.
	DMAC_CFG1_DST_PER_Msk      = 0xf0       // Bit mask of DST_PER field.
	DMAC_CFG1_SRC_REP_Pos      = 0x8        // Position of SRC_REP field.
	DMAC_CFG1_SRC_REP_Msk      = 0x100      // Bit mask of SRC_REP field.
	DMAC_CFG1_SRC_REP          = 0x100      // Bit SRC_REP.
	DMAC_CFG1_SRC_H2SEL_Pos    = 0x9        // Position of SRC_H2SEL field.
	DMAC_CFG1_SRC_H2SEL_Msk    = 0x200      // Bit mask of SRC_H2SEL field.
	DMAC_CFG1_SRC_H2SEL        = 0x200      // Bit SRC_H2SEL.
	DMAC_CFG1_DST_REP_Pos      = 0xc        // Position of DST_REP field.
	DMAC_CFG1_DST_REP_Msk      = 0x1000     // Bit mask of DST_REP field.
	DMAC_CFG1_DST_REP          = 0x1000     // Bit DST_REP.
	DMAC_CFG1_DST_H2SEL_Pos    = 0xd        // Position of DST_H2SEL field.
	DMAC_CFG1_DST_H2SEL_Msk    = 0x2000     // Bit mask of DST_H2SEL field.
	DMAC_CFG1_DST_H2SEL        = 0x2000     // Bit DST_H2SEL.
	DMAC_CFG1_SOD_Pos          = 0x10       // Position of SOD field.
	DMAC_CFG1_SOD_Msk          = 0x10000    // Bit mask of SOD field.
	DMAC_CFG1_SOD              = 0x10000    // Bit SOD.
	DMAC_CFG1_LOCK_IF_Pos      = 0x14       // Position of LOCK_IF field.
	DMAC_CFG1_LOCK_IF_Msk      = 0x100000   // Bit mask of LOCK_IF field.
	DMAC_CFG1_LOCK_IF          = 0x100000   // Bit LOCK_IF.
	DMAC_CFG1_LOCK_B_Pos       = 0x15       // Position of LOCK_B field.
	DMAC_CFG1_LOCK_B_Msk       = 0x200000   // Bit mask of LOCK_B field.
	DMAC_CFG1_LOCK_B           = 0x200000   // Bit LOCK_B.
	DMAC_CFG1_LOCK_IF_L_Pos    = 0x16       // Position of LOCK_IF_L field.
	DMAC_CFG1_LOCK_IF_L_Msk    = 0x400000   // Bit mask of LOCK_IF_L field.
	DMAC_CFG1_LOCK_IF_L        = 0x400000   // Bit LOCK_IF_L.
	DMAC_CFG1_AHB_PROT_Pos     = 0x18       // Position of AHB_PROT field.
	DMAC_CFG1_AHB_PROT_Msk     = 0x7000000  // Bit mask of AHB_PROT field.
	DMAC_CFG1_FIFOCFG_Pos      = 0x1c       // Position of FIFOCFG field.
	DMAC_CFG1_FIFOCFG_Msk      = 0x30000000 // Bit mask of FIFOCFG field.
	DMAC_CFG1_FIFOCFG_ALAP_CFG = 0x0        // The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG1_FIFOCFG_HALF_CFG = 0x1        // When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG1_FIFOCFG_ASAP_CFG = 0x2        // When there is enough space/data available to perform a single AHB access, then the request is serviced.

	// SADDR2: DMAC Channel Source Address Register (ch_num = 2)
	DMAC_SADDR2_SADDR_Pos = 0x0        // Position of SADDR field.
	DMAC_SADDR2_SADDR_Msk = 0xffffffff // Bit mask of SADDR field.

	// DADDR2: DMAC Channel Destination Address Register (ch_num = 2)
	DMAC_DADDR2_DADDR_Pos = 0x0        // Position of DADDR field.
	DMAC_DADDR2_DADDR_Msk = 0xffffffff // Bit mask of DADDR field.

	// DSCR2: DMAC Channel Descriptor Address Register (ch_num = 2)
	DMAC_DSCR2_DSCR_IF_Pos     = 0x0        // Position of DSCR_IF field.
	DMAC_DSCR2_DSCR_IF_Msk     = 0x3        // Bit mask of DSCR_IF field.
	DMAC_DSCR2_DSCR_IF_AHB_IFO = 0x0        // The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR2_DSCR_IF_AHB_IF1 = 0x1        // The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR2_DSCR_IF_AHB_IF2 = 0x2        // The buffer transfer descriptor is fetched via AHB-Lite Interface 2
	DMAC_DSCR2_DSCR_Pos        = 0x2        // Position of DSCR field.
	DMAC_DSCR2_DSCR_Msk        = 0xfffffffc // Bit mask of DSCR field.

	// CTRLA2: DMAC Channel Control A Register (ch_num = 2)
	DMAC_CTRLA2_BTSIZE_Pos          = 0x0        // Position of BTSIZE field.
	DMAC_CTRLA2_BTSIZE_Msk          = 0xffff     // Bit mask of BTSIZE field.
	DMAC_CTRLA2_SCSIZE_Pos          = 0x10       // Position of SCSIZE field.
	DMAC_CTRLA2_SCSIZE_Msk          = 0x70000    // Bit mask of SCSIZE field.
	DMAC_CTRLA2_SCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA2_SCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA2_SCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA2_SCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA2_SCSIZE_CHK_32       = 0x4        // 32 data transferred
	DMAC_CTRLA2_SCSIZE_CHK_64       = 0x5        // 64 data transferred
	DMAC_CTRLA2_SCSIZE_CHK_128      = 0x6        // 128 data transferred
	DMAC_CTRLA2_SCSIZE_CHK_256      = 0x7        // 256 data transferred
	DMAC_CTRLA2_DCSIZE_Pos          = 0x14       // Position of DCSIZE field.
	DMAC_CTRLA2_DCSIZE_Msk          = 0x700000   // Bit mask of DCSIZE field.
	DMAC_CTRLA2_DCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA2_DCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA2_DCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA2_DCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA2_DCSIZE_CHK_32       = 0x4        // 32 data transferred
	DMAC_CTRLA2_DCSIZE_CHK_64       = 0x5        // 64 data transferred
	DMAC_CTRLA2_DCSIZE_CHK_128      = 0x6        // 128 data transferred
	DMAC_CTRLA2_DCSIZE_CHK_256      = 0x7        // 256 data transferred
	DMAC_CTRLA2_SRC_WIDTH_Pos       = 0x18       // Position of SRC_WIDTH field.
	DMAC_CTRLA2_SRC_WIDTH_Msk       = 0x3000000  // Bit mask of SRC_WIDTH field.
	DMAC_CTRLA2_SRC_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA2_SRC_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA2_SRC_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA2_DST_WIDTH_Pos       = 0x1c       // Position of DST_WIDTH field.
	DMAC_CTRLA2_DST_WIDTH_Msk       = 0x30000000 // Bit mask of DST_WIDTH field.
	DMAC_CTRLA2_DST_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA2_DST_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA2_DST_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA2_DONE_Pos            = 0x1f       // Position of DONE field.
	DMAC_CTRLA2_DONE_Msk            = 0x80000000 // Bit mask of DONE field.
	DMAC_CTRLA2_DONE                = 0x80000000 // Bit DONE.

	// CTRLB2: DMAC Channel Control B Register (ch_num = 2)
	DMAC_CTRLB2_SIF_Pos               = 0x0        // Position of SIF field.
	DMAC_CTRLB2_SIF_Msk               = 0x3        // Bit mask of SIF field.
	DMAC_CTRLB2_SIF_AHB_IFO           = 0x0        // The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB2_SIF_AHB_IF1           = 0x1        // The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB2_SIF_AHB_IF2           = 0x2        // The source transfer is done via AHB-Lite Interface 2
	DMAC_CTRLB2_DIF_Pos               = 0x4        // Position of DIF field.
	DMAC_CTRLB2_DIF_Msk               = 0x30       // Bit mask of DIF field.
	DMAC_CTRLB2_DIF_AHB_IFO           = 0x0        // The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB2_DIF_AHB_IF1           = 0x1        // The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB2_DIF_AHB_IF2           = 0x2        // The destination transfer is done via AHB-Lite Interface 2
	DMAC_CTRLB2_SRC_DSCR_Pos          = 0x10       // Position of SRC_DSCR field.
	DMAC_CTRLB2_SRC_DSCR_Msk          = 0x10000    // Bit mask of SRC_DSCR field.
	DMAC_CTRLB2_SRC_DSCR              = 0x10000    // Bit SRC_DSCR.
	DMAC_CTRLB2_DST_DSCR_Pos          = 0x14       // Position of DST_DSCR field.
	DMAC_CTRLB2_DST_DSCR_Msk          = 0x100000   // Bit mask of DST_DSCR field.
	DMAC_CTRLB2_DST_DSCR              = 0x100000   // Bit DST_DSCR.
	DMAC_CTRLB2_FC_Pos                = 0x15       // Position of FC field.
	DMAC_CTRLB2_FC_Msk                = 0xe00000   // Bit mask of FC field.
	DMAC_CTRLB2_FC_MEM2MEM_DMA_FC     = 0x0        // Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB2_FC_MEM2PER_DMA_FC     = 0x1        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB2_FC_PER2MEM_DMA_FC     = 0x2        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB2_FC_PER2PER_DMA_FC     = 0x3        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB2_FC_PER2MEM_PER_FC     = 0x4        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB2_FC_MEM2PER_PER_FC     = 0x5        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB2_FC_PER2PER_SPER_FC    = 0x6        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB2_FC_PER2PER_DPER_FC    = 0x7        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB2_SRC_INCR_Pos          = 0x18       // Position of SRC_INCR field.
	DMAC_CTRLB2_SRC_INCR_Msk          = 0x3000000  // Bit mask of SRC_INCR field.
	DMAC_CTRLB2_SRC_INCR_INCREMENTING = 0x0        // The source address is incremented
	DMAC_CTRLB2_SRC_INCR_DECREMENTING = 0x1        // The source address is decremented
	DMAC_CTRLB2_SRC_INCR_FIXED        = 0x2        // The source address remains unchanged
	DMAC_CTRLB2_DST_INCR_Pos          = 0x1c       // Position of DST_INCR field.
	DMAC_CTRLB2_DST_INCR_Msk          = 0x30000000 // Bit mask of DST_INCR field.
	DMAC_CTRLB2_DST_INCR_INCREMENTING = 0x0        // The destination address is incremented
	DMAC_CTRLB2_DST_INCR_DECREMENTING = 0x1        // The destination address is decremented
	DMAC_CTRLB2_DST_INCR_FIXED        = 0x2        // The destination address remains unchanged
	DMAC_CTRLB2_IEN_Pos               = 0x1e       // Position of IEN field.
	DMAC_CTRLB2_IEN_Msk               = 0x40000000 // Bit mask of IEN field.
	DMAC_CTRLB2_IEN                   = 0x40000000 // Bit IEN.
	DMAC_CTRLB2_AUTO_Pos              = 0x1f       // Position of AUTO field.
	DMAC_CTRLB2_AUTO_Msk              = 0x80000000 // Bit mask of AUTO field.
	DMAC_CTRLB2_AUTO                  = 0x80000000 // Bit AUTO.

	// CFG2: DMAC Channel Configuration Register (ch_num = 2)
	DMAC_CFG2_SRC_PER_Pos      = 0x0        // Position of SRC_PER field.
	DMAC_CFG2_SRC_PER_Msk      = 0xf        // Bit mask of SRC_PER field.
	DMAC_CFG2_DST_PER_Pos      = 0x4        // Position of DST_PER field.
	DMAC_CFG2_DST_PER_Msk      = 0xf0       // Bit mask of DST_PER field.
	DMAC_CFG2_SRC_REP_Pos      = 0x8        // Position of SRC_REP field.
	DMAC_CFG2_SRC_REP_Msk      = 0x100      // Bit mask of SRC_REP field.
	DMAC_CFG2_SRC_REP          = 0x100      // Bit SRC_REP.
	DMAC_CFG2_SRC_H2SEL_Pos    = 0x9        // Position of SRC_H2SEL field.
	DMAC_CFG2_SRC_H2SEL_Msk    = 0x200      // Bit mask of SRC_H2SEL field.
	DMAC_CFG2_SRC_H2SEL        = 0x200      // Bit SRC_H2SEL.
	DMAC_CFG2_DST_REP_Pos      = 0xc        // Position of DST_REP field.
	DMAC_CFG2_DST_REP_Msk      = 0x1000     // Bit mask of DST_REP field.
	DMAC_CFG2_DST_REP          = 0x1000     // Bit DST_REP.
	DMAC_CFG2_DST_H2SEL_Pos    = 0xd        // Position of DST_H2SEL field.
	DMAC_CFG2_DST_H2SEL_Msk    = 0x2000     // Bit mask of DST_H2SEL field.
	DMAC_CFG2_DST_H2SEL        = 0x2000     // Bit DST_H2SEL.
	DMAC_CFG2_SOD_Pos          = 0x10       // Position of SOD field.
	DMAC_CFG2_SOD_Msk          = 0x10000    // Bit mask of SOD field.
	DMAC_CFG2_SOD              = 0x10000    // Bit SOD.
	DMAC_CFG2_LOCK_IF_Pos      = 0x14       // Position of LOCK_IF field.
	DMAC_CFG2_LOCK_IF_Msk      = 0x100000   // Bit mask of LOCK_IF field.
	DMAC_CFG2_LOCK_IF          = 0x100000   // Bit LOCK_IF.
	DMAC_CFG2_LOCK_B_Pos       = 0x15       // Position of LOCK_B field.
	DMAC_CFG2_LOCK_B_Msk       = 0x200000   // Bit mask of LOCK_B field.
	DMAC_CFG2_LOCK_B           = 0x200000   // Bit LOCK_B.
	DMAC_CFG2_LOCK_IF_L_Pos    = 0x16       // Position of LOCK_IF_L field.
	DMAC_CFG2_LOCK_IF_L_Msk    = 0x400000   // Bit mask of LOCK_IF_L field.
	DMAC_CFG2_LOCK_IF_L        = 0x400000   // Bit LOCK_IF_L.
	DMAC_CFG2_AHB_PROT_Pos     = 0x18       // Position of AHB_PROT field.
	DMAC_CFG2_AHB_PROT_Msk     = 0x7000000  // Bit mask of AHB_PROT field.
	DMAC_CFG2_FIFOCFG_Pos      = 0x1c       // Position of FIFOCFG field.
	DMAC_CFG2_FIFOCFG_Msk      = 0x30000000 // Bit mask of FIFOCFG field.
	DMAC_CFG2_FIFOCFG_ALAP_CFG = 0x0        // The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG2_FIFOCFG_HALF_CFG = 0x1        // When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG2_FIFOCFG_ASAP_CFG = 0x2        // When there is enough space/data available to perform a single AHB access, then the request is serviced.

	// SADDR3: DMAC Channel Source Address Register (ch_num = 3)
	DMAC_SADDR3_SADDR_Pos = 0x0        // Position of SADDR field.
	DMAC_SADDR3_SADDR_Msk = 0xffffffff // Bit mask of SADDR field.

	// DADDR3: DMAC Channel Destination Address Register (ch_num = 3)
	DMAC_DADDR3_DADDR_Pos = 0x0        // Position of DADDR field.
	DMAC_DADDR3_DADDR_Msk = 0xffffffff // Bit mask of DADDR field.

	// DSCR3: DMAC Channel Descriptor Address Register (ch_num = 3)
	DMAC_DSCR3_DSCR_IF_Pos     = 0x0        // Position of DSCR_IF field.
	DMAC_DSCR3_DSCR_IF_Msk     = 0x3        // Bit mask of DSCR_IF field.
	DMAC_DSCR3_DSCR_IF_AHB_IFO = 0x0        // The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR3_DSCR_IF_AHB_IF1 = 0x1        // The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR3_DSCR_IF_AHB_IF2 = 0x2        // The buffer transfer descriptor is fetched via AHB-Lite Interface 2
	DMAC_DSCR3_DSCR_Pos        = 0x2        // Position of DSCR field.
	DMAC_DSCR3_DSCR_Msk        = 0xfffffffc // Bit mask of DSCR field.

	// CTRLA3: DMAC Channel Control A Register (ch_num = 3)
	DMAC_CTRLA3_BTSIZE_Pos          = 0x0        // Position of BTSIZE field.
	DMAC_CTRLA3_BTSIZE_Msk          = 0xffff     // Bit mask of BTSIZE field.
	DMAC_CTRLA3_SCSIZE_Pos          = 0x10       // Position of SCSIZE field.
	DMAC_CTRLA3_SCSIZE_Msk          = 0x70000    // Bit mask of SCSIZE field.
	DMAC_CTRLA3_SCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA3_SCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA3_SCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA3_SCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA3_SCSIZE_CHK_32       = 0x4        // 32 data transferred
	DMAC_CTRLA3_SCSIZE_CHK_64       = 0x5        // 64 data transferred
	DMAC_CTRLA3_SCSIZE_CHK_128      = 0x6        // 128 data transferred
	DMAC_CTRLA3_SCSIZE_CHK_256      = 0x7        // 256 data transferred
	DMAC_CTRLA3_DCSIZE_Pos          = 0x14       // Position of DCSIZE field.
	DMAC_CTRLA3_DCSIZE_Msk          = 0x700000   // Bit mask of DCSIZE field.
	DMAC_CTRLA3_DCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA3_DCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA3_DCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA3_DCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA3_DCSIZE_CHK_32       = 0x4        // 32 data transferred
	DMAC_CTRLA3_DCSIZE_CHK_64       = 0x5        // 64 data transferred
	DMAC_CTRLA3_DCSIZE_CHK_128      = 0x6        // 128 data transferred
	DMAC_CTRLA3_DCSIZE_CHK_256      = 0x7        // 256 data transferred
	DMAC_CTRLA3_SRC_WIDTH_Pos       = 0x18       // Position of SRC_WIDTH field.
	DMAC_CTRLA3_SRC_WIDTH_Msk       = 0x3000000  // Bit mask of SRC_WIDTH field.
	DMAC_CTRLA3_SRC_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA3_SRC_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA3_SRC_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA3_DST_WIDTH_Pos       = 0x1c       // Position of DST_WIDTH field.
	DMAC_CTRLA3_DST_WIDTH_Msk       = 0x30000000 // Bit mask of DST_WIDTH field.
	DMAC_CTRLA3_DST_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA3_DST_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA3_DST_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA3_DONE_Pos            = 0x1f       // Position of DONE field.
	DMAC_CTRLA3_DONE_Msk            = 0x80000000 // Bit mask of DONE field.
	DMAC_CTRLA3_DONE                = 0x80000000 // Bit DONE.

	// CTRLB3: DMAC Channel Control B Register (ch_num = 3)
	DMAC_CTRLB3_SIF_Pos               = 0x0        // Position of SIF field.
	DMAC_CTRLB3_SIF_Msk               = 0x3        // Bit mask of SIF field.
	DMAC_CTRLB3_SIF_AHB_IFO           = 0x0        // The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB3_SIF_AHB_IF1           = 0x1        // The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB3_SIF_AHB_IF2           = 0x2        // The source transfer is done via AHB-Lite Interface 2
	DMAC_CTRLB3_DIF_Pos               = 0x4        // Position of DIF field.
	DMAC_CTRLB3_DIF_Msk               = 0x30       // Bit mask of DIF field.
	DMAC_CTRLB3_DIF_AHB_IFO           = 0x0        // The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB3_DIF_AHB_IF1           = 0x1        // The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB3_DIF_AHB_IF2           = 0x2        // The destination transfer is done via AHB-Lite Interface 2
	DMAC_CTRLB3_SRC_DSCR_Pos          = 0x10       // Position of SRC_DSCR field.
	DMAC_CTRLB3_SRC_DSCR_Msk          = 0x10000    // Bit mask of SRC_DSCR field.
	DMAC_CTRLB3_SRC_DSCR              = 0x10000    // Bit SRC_DSCR.
	DMAC_CTRLB3_DST_DSCR_Pos          = 0x14       // Position of DST_DSCR field.
	DMAC_CTRLB3_DST_DSCR_Msk          = 0x100000   // Bit mask of DST_DSCR field.
	DMAC_CTRLB3_DST_DSCR              = 0x100000   // Bit DST_DSCR.
	DMAC_CTRLB3_FC_Pos                = 0x15       // Position of FC field.
	DMAC_CTRLB3_FC_Msk                = 0xe00000   // Bit mask of FC field.
	DMAC_CTRLB3_FC_MEM2MEM_DMA_FC     = 0x0        // Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB3_FC_MEM2PER_DMA_FC     = 0x1        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB3_FC_PER2MEM_DMA_FC     = 0x2        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB3_FC_PER2PER_DMA_FC     = 0x3        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB3_FC_PER2MEM_PER_FC     = 0x4        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB3_FC_MEM2PER_PER_FC     = 0x5        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB3_FC_PER2PER_SPER_FC    = 0x6        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB3_FC_PER2PER_DPER_FC    = 0x7        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB3_SRC_INCR_Pos          = 0x18       // Position of SRC_INCR field.
	DMAC_CTRLB3_SRC_INCR_Msk          = 0x3000000  // Bit mask of SRC_INCR field.
	DMAC_CTRLB3_SRC_INCR_INCREMENTING = 0x0        // The source address is incremented
	DMAC_CTRLB3_SRC_INCR_DECREMENTING = 0x1        // The source address is decremented
	DMAC_CTRLB3_SRC_INCR_FIXED        = 0x2        // The source address remains unchanged
	DMAC_CTRLB3_DST_INCR_Pos          = 0x1c       // Position of DST_INCR field.
	DMAC_CTRLB3_DST_INCR_Msk          = 0x30000000 // Bit mask of DST_INCR field.
	DMAC_CTRLB3_DST_INCR_INCREMENTING = 0x0        // The destination address is incremented
	DMAC_CTRLB3_DST_INCR_DECREMENTING = 0x1        // The destination address is decremented
	DMAC_CTRLB3_DST_INCR_FIXED        = 0x2        // The destination address remains unchanged
	DMAC_CTRLB3_IEN_Pos               = 0x1e       // Position of IEN field.
	DMAC_CTRLB3_IEN_Msk               = 0x40000000 // Bit mask of IEN field.
	DMAC_CTRLB3_IEN                   = 0x40000000 // Bit IEN.
	DMAC_CTRLB3_AUTO_Pos              = 0x1f       // Position of AUTO field.
	DMAC_CTRLB3_AUTO_Msk              = 0x80000000 // Bit mask of AUTO field.
	DMAC_CTRLB3_AUTO                  = 0x80000000 // Bit AUTO.

	// CFG3: DMAC Channel Configuration Register (ch_num = 3)
	DMAC_CFG3_SRC_PER_Pos      = 0x0        // Position of SRC_PER field.
	DMAC_CFG3_SRC_PER_Msk      = 0xf        // Bit mask of SRC_PER field.
	DMAC_CFG3_DST_PER_Pos      = 0x4        // Position of DST_PER field.
	DMAC_CFG3_DST_PER_Msk      = 0xf0       // Bit mask of DST_PER field.
	DMAC_CFG3_SRC_REP_Pos      = 0x8        // Position of SRC_REP field.
	DMAC_CFG3_SRC_REP_Msk      = 0x100      // Bit mask of SRC_REP field.
	DMAC_CFG3_SRC_REP          = 0x100      // Bit SRC_REP.
	DMAC_CFG3_SRC_H2SEL_Pos    = 0x9        // Position of SRC_H2SEL field.
	DMAC_CFG3_SRC_H2SEL_Msk    = 0x200      // Bit mask of SRC_H2SEL field.
	DMAC_CFG3_SRC_H2SEL        = 0x200      // Bit SRC_H2SEL.
	DMAC_CFG3_DST_REP_Pos      = 0xc        // Position of DST_REP field.
	DMAC_CFG3_DST_REP_Msk      = 0x1000     // Bit mask of DST_REP field.
	DMAC_CFG3_DST_REP          = 0x1000     // Bit DST_REP.
	DMAC_CFG3_DST_H2SEL_Pos    = 0xd        // Position of DST_H2SEL field.
	DMAC_CFG3_DST_H2SEL_Msk    = 0x2000     // Bit mask of DST_H2SEL field.
	DMAC_CFG3_DST_H2SEL        = 0x2000     // Bit DST_H2SEL.
	DMAC_CFG3_SOD_Pos          = 0x10       // Position of SOD field.
	DMAC_CFG3_SOD_Msk          = 0x10000    // Bit mask of SOD field.
	DMAC_CFG3_SOD              = 0x10000    // Bit SOD.
	DMAC_CFG3_LOCK_IF_Pos      = 0x14       // Position of LOCK_IF field.
	DMAC_CFG3_LOCK_IF_Msk      = 0x100000   // Bit mask of LOCK_IF field.
	DMAC_CFG3_LOCK_IF          = 0x100000   // Bit LOCK_IF.
	DMAC_CFG3_LOCK_B_Pos       = 0x15       // Position of LOCK_B field.
	DMAC_CFG3_LOCK_B_Msk       = 0x200000   // Bit mask of LOCK_B field.
	DMAC_CFG3_LOCK_B           = 0x200000   // Bit LOCK_B.
	DMAC_CFG3_LOCK_IF_L_Pos    = 0x16       // Position of LOCK_IF_L field.
	DMAC_CFG3_LOCK_IF_L_Msk    = 0x400000   // Bit mask of LOCK_IF_L field.
	DMAC_CFG3_LOCK_IF_L        = 0x400000   // Bit LOCK_IF_L.
	DMAC_CFG3_AHB_PROT_Pos     = 0x18       // Position of AHB_PROT field.
	DMAC_CFG3_AHB_PROT_Msk     = 0x7000000  // Bit mask of AHB_PROT field.
	DMAC_CFG3_FIFOCFG_Pos      = 0x1c       // Position of FIFOCFG field.
	DMAC_CFG3_FIFOCFG_Msk      = 0x30000000 // Bit mask of FIFOCFG field.
	DMAC_CFG3_FIFOCFG_ALAP_CFG = 0x0        // The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG3_FIFOCFG_HALF_CFG = 0x1        // When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG3_FIFOCFG_ASAP_CFG = 0x2        // When there is enough space/data available to perform a single AHB access, then the request is serviced.

	// SADDR4: DMAC Channel Source Address Register (ch_num = 4)
	DMAC_SADDR4_SADDR_Pos = 0x0        // Position of SADDR field.
	DMAC_SADDR4_SADDR_Msk = 0xffffffff // Bit mask of SADDR field.

	// DADDR4: DMAC Channel Destination Address Register (ch_num = 4)
	DMAC_DADDR4_DADDR_Pos = 0x0        // Position of DADDR field.
	DMAC_DADDR4_DADDR_Msk = 0xffffffff // Bit mask of DADDR field.

	// DSCR4: DMAC Channel Descriptor Address Register (ch_num = 4)
	DMAC_DSCR4_DSCR_IF_Pos     = 0x0        // Position of DSCR_IF field.
	DMAC_DSCR4_DSCR_IF_Msk     = 0x3        // Bit mask of DSCR_IF field.
	DMAC_DSCR4_DSCR_IF_AHB_IFO = 0x0        // The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR4_DSCR_IF_AHB_IF1 = 0x1        // The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR4_DSCR_IF_AHB_IF2 = 0x2        // The buffer transfer descriptor is fetched via AHB-Lite Interface 2
	DMAC_DSCR4_DSCR_Pos        = 0x2        // Position of DSCR field.
	DMAC_DSCR4_DSCR_Msk        = 0xfffffffc // Bit mask of DSCR field.

	// CTRLA4: DMAC Channel Control A Register (ch_num = 4)
	DMAC_CTRLA4_BTSIZE_Pos          = 0x0        // Position of BTSIZE field.
	DMAC_CTRLA4_BTSIZE_Msk          = 0xffff     // Bit mask of BTSIZE field.
	DMAC_CTRLA4_SCSIZE_Pos          = 0x10       // Position of SCSIZE field.
	DMAC_CTRLA4_SCSIZE_Msk          = 0x70000    // Bit mask of SCSIZE field.
	DMAC_CTRLA4_SCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA4_SCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA4_SCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA4_SCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA4_SCSIZE_CHK_32       = 0x4        // 32 data transferred
	DMAC_CTRLA4_SCSIZE_CHK_64       = 0x5        // 64 data transferred
	DMAC_CTRLA4_SCSIZE_CHK_128      = 0x6        // 128 data transferred
	DMAC_CTRLA4_SCSIZE_CHK_256      = 0x7        // 256 data transferred
	DMAC_CTRLA4_DCSIZE_Pos          = 0x14       // Position of DCSIZE field.
	DMAC_CTRLA4_DCSIZE_Msk          = 0x700000   // Bit mask of DCSIZE field.
	DMAC_CTRLA4_DCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA4_DCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA4_DCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA4_DCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA4_DCSIZE_CHK_32       = 0x4        // 32 data transferred
	DMAC_CTRLA4_DCSIZE_CHK_64       = 0x5        // 64 data transferred
	DMAC_CTRLA4_DCSIZE_CHK_128      = 0x6        // 128 data transferred
	DMAC_CTRLA4_DCSIZE_CHK_256      = 0x7        // 256 data transferred
	DMAC_CTRLA4_SRC_WIDTH_Pos       = 0x18       // Position of SRC_WIDTH field.
	DMAC_CTRLA4_SRC_WIDTH_Msk       = 0x3000000  // Bit mask of SRC_WIDTH field.
	DMAC_CTRLA4_SRC_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA4_SRC_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA4_SRC_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA4_DST_WIDTH_Pos       = 0x1c       // Position of DST_WIDTH field.
	DMAC_CTRLA4_DST_WIDTH_Msk       = 0x30000000 // Bit mask of DST_WIDTH field.
	DMAC_CTRLA4_DST_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA4_DST_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA4_DST_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA4_DONE_Pos            = 0x1f       // Position of DONE field.
	DMAC_CTRLA4_DONE_Msk            = 0x80000000 // Bit mask of DONE field.
	DMAC_CTRLA4_DONE                = 0x80000000 // Bit DONE.

	// CTRLB4: DMAC Channel Control B Register (ch_num = 4)
	DMAC_CTRLB4_SIF_Pos               = 0x0        // Position of SIF field.
	DMAC_CTRLB4_SIF_Msk               = 0x3        // Bit mask of SIF field.
	DMAC_CTRLB4_SIF_AHB_IFO           = 0x0        // The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB4_SIF_AHB_IF1           = 0x1        // The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB4_SIF_AHB_IF2           = 0x2        // The source transfer is done via AHB-Lite Interface 2
	DMAC_CTRLB4_DIF_Pos               = 0x4        // Position of DIF field.
	DMAC_CTRLB4_DIF_Msk               = 0x30       // Bit mask of DIF field.
	DMAC_CTRLB4_DIF_AHB_IFO           = 0x0        // The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB4_DIF_AHB_IF1           = 0x1        // The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB4_DIF_AHB_IF2           = 0x2        // The destination transfer is done via AHB-Lite Interface 2
	DMAC_CTRLB4_SRC_DSCR_Pos          = 0x10       // Position of SRC_DSCR field.
	DMAC_CTRLB4_SRC_DSCR_Msk          = 0x10000    // Bit mask of SRC_DSCR field.
	DMAC_CTRLB4_SRC_DSCR              = 0x10000    // Bit SRC_DSCR.
	DMAC_CTRLB4_DST_DSCR_Pos          = 0x14       // Position of DST_DSCR field.
	DMAC_CTRLB4_DST_DSCR_Msk          = 0x100000   // Bit mask of DST_DSCR field.
	DMAC_CTRLB4_DST_DSCR              = 0x100000   // Bit DST_DSCR.
	DMAC_CTRLB4_FC_Pos                = 0x15       // Position of FC field.
	DMAC_CTRLB4_FC_Msk                = 0xe00000   // Bit mask of FC field.
	DMAC_CTRLB4_FC_MEM2MEM_DMA_FC     = 0x0        // Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB4_FC_MEM2PER_DMA_FC     = 0x1        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB4_FC_PER2MEM_DMA_FC     = 0x2        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB4_FC_PER2PER_DMA_FC     = 0x3        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB4_FC_PER2MEM_PER_FC     = 0x4        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB4_FC_MEM2PER_PER_FC     = 0x5        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB4_FC_PER2PER_SPER_FC    = 0x6        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB4_FC_PER2PER_DPER_FC    = 0x7        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB4_SRC_INCR_Pos          = 0x18       // Position of SRC_INCR field.
	DMAC_CTRLB4_SRC_INCR_Msk          = 0x3000000  // Bit mask of SRC_INCR field.
	DMAC_CTRLB4_SRC_INCR_INCREMENTING = 0x0        // The source address is incremented
	DMAC_CTRLB4_SRC_INCR_DECREMENTING = 0x1        // The source address is decremented
	DMAC_CTRLB4_SRC_INCR_FIXED        = 0x2        // The source address remains unchanged
	DMAC_CTRLB4_DST_INCR_Pos          = 0x1c       // Position of DST_INCR field.
	DMAC_CTRLB4_DST_INCR_Msk          = 0x30000000 // Bit mask of DST_INCR field.
	DMAC_CTRLB4_DST_INCR_INCREMENTING = 0x0        // The destination address is incremented
	DMAC_CTRLB4_DST_INCR_DECREMENTING = 0x1        // The destination address is decremented
	DMAC_CTRLB4_DST_INCR_FIXED        = 0x2        // The destination address remains unchanged
	DMAC_CTRLB4_IEN_Pos               = 0x1e       // Position of IEN field.
	DMAC_CTRLB4_IEN_Msk               = 0x40000000 // Bit mask of IEN field.
	DMAC_CTRLB4_IEN                   = 0x40000000 // Bit IEN.
	DMAC_CTRLB4_AUTO_Pos              = 0x1f       // Position of AUTO field.
	DMAC_CTRLB4_AUTO_Msk              = 0x80000000 // Bit mask of AUTO field.
	DMAC_CTRLB4_AUTO                  = 0x80000000 // Bit AUTO.

	// CFG4: DMAC Channel Configuration Register (ch_num = 4)
	DMAC_CFG4_SRC_PER_Pos      = 0x0        // Position of SRC_PER field.
	DMAC_CFG4_SRC_PER_Msk      = 0xf        // Bit mask of SRC_PER field.
	DMAC_CFG4_DST_PER_Pos      = 0x4        // Position of DST_PER field.
	DMAC_CFG4_DST_PER_Msk      = 0xf0       // Bit mask of DST_PER field.
	DMAC_CFG4_SRC_REP_Pos      = 0x8        // Position of SRC_REP field.
	DMAC_CFG4_SRC_REP_Msk      = 0x100      // Bit mask of SRC_REP field.
	DMAC_CFG4_SRC_REP          = 0x100      // Bit SRC_REP.
	DMAC_CFG4_SRC_H2SEL_Pos    = 0x9        // Position of SRC_H2SEL field.
	DMAC_CFG4_SRC_H2SEL_Msk    = 0x200      // Bit mask of SRC_H2SEL field.
	DMAC_CFG4_SRC_H2SEL        = 0x200      // Bit SRC_H2SEL.
	DMAC_CFG4_DST_REP_Pos      = 0xc        // Position of DST_REP field.
	DMAC_CFG4_DST_REP_Msk      = 0x1000     // Bit mask of DST_REP field.
	DMAC_CFG4_DST_REP          = 0x1000     // Bit DST_REP.
	DMAC_CFG4_DST_H2SEL_Pos    = 0xd        // Position of DST_H2SEL field.
	DMAC_CFG4_DST_H2SEL_Msk    = 0x2000     // Bit mask of DST_H2SEL field.
	DMAC_CFG4_DST_H2SEL        = 0x2000     // Bit DST_H2SEL.
	DMAC_CFG4_SOD_Pos          = 0x10       // Position of SOD field.
	DMAC_CFG4_SOD_Msk          = 0x10000    // Bit mask of SOD field.
	DMAC_CFG4_SOD              = 0x10000    // Bit SOD.
	DMAC_CFG4_LOCK_IF_Pos      = 0x14       // Position of LOCK_IF field.
	DMAC_CFG4_LOCK_IF_Msk      = 0x100000   // Bit mask of LOCK_IF field.
	DMAC_CFG4_LOCK_IF          = 0x100000   // Bit LOCK_IF.
	DMAC_CFG4_LOCK_B_Pos       = 0x15       // Position of LOCK_B field.
	DMAC_CFG4_LOCK_B_Msk       = 0x200000   // Bit mask of LOCK_B field.
	DMAC_CFG4_LOCK_B           = 0x200000   // Bit LOCK_B.
	DMAC_CFG4_LOCK_IF_L_Pos    = 0x16       // Position of LOCK_IF_L field.
	DMAC_CFG4_LOCK_IF_L_Msk    = 0x400000   // Bit mask of LOCK_IF_L field.
	DMAC_CFG4_LOCK_IF_L        = 0x400000   // Bit LOCK_IF_L.
	DMAC_CFG4_AHB_PROT_Pos     = 0x18       // Position of AHB_PROT field.
	DMAC_CFG4_AHB_PROT_Msk     = 0x7000000  // Bit mask of AHB_PROT field.
	DMAC_CFG4_FIFOCFG_Pos      = 0x1c       // Position of FIFOCFG field.
	DMAC_CFG4_FIFOCFG_Msk      = 0x30000000 // Bit mask of FIFOCFG field.
	DMAC_CFG4_FIFOCFG_ALAP_CFG = 0x0        // The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG4_FIFOCFG_HALF_CFG = 0x1        // When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG4_FIFOCFG_ASAP_CFG = 0x2        // When there is enough space/data available to perform a single AHB access, then the request is serviced.

	// SADDR5: DMAC Channel Source Address Register (ch_num = 5)
	DMAC_SADDR5_SADDR_Pos = 0x0        // Position of SADDR field.
	DMAC_SADDR5_SADDR_Msk = 0xffffffff // Bit mask of SADDR field.

	// DADDR5: DMAC Channel Destination Address Register (ch_num = 5)
	DMAC_DADDR5_DADDR_Pos = 0x0        // Position of DADDR field.
	DMAC_DADDR5_DADDR_Msk = 0xffffffff // Bit mask of DADDR field.

	// DSCR5: DMAC Channel Descriptor Address Register (ch_num = 5)
	DMAC_DSCR5_DSCR_IF_Pos     = 0x0        // Position of DSCR_IF field.
	DMAC_DSCR5_DSCR_IF_Msk     = 0x3        // Bit mask of DSCR_IF field.
	DMAC_DSCR5_DSCR_IF_AHB_IFO = 0x0        // The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR5_DSCR_IF_AHB_IF1 = 0x1        // The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR5_DSCR_IF_AHB_IF2 = 0x2        // The buffer transfer descriptor is fetched via AHB-Lite Interface 2
	DMAC_DSCR5_DSCR_Pos        = 0x2        // Position of DSCR field.
	DMAC_DSCR5_DSCR_Msk        = 0xfffffffc // Bit mask of DSCR field.

	// CTRLA5: DMAC Channel Control A Register (ch_num = 5)
	DMAC_CTRLA5_BTSIZE_Pos          = 0x0        // Position of BTSIZE field.
	DMAC_CTRLA5_BTSIZE_Msk          = 0xffff     // Bit mask of BTSIZE field.
	DMAC_CTRLA5_SCSIZE_Pos          = 0x10       // Position of SCSIZE field.
	DMAC_CTRLA5_SCSIZE_Msk          = 0x70000    // Bit mask of SCSIZE field.
	DMAC_CTRLA5_SCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA5_SCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA5_SCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA5_SCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA5_SCSIZE_CHK_32       = 0x4        // 32 data transferred
	DMAC_CTRLA5_SCSIZE_CHK_64       = 0x5        // 64 data transferred
	DMAC_CTRLA5_SCSIZE_CHK_128      = 0x6        // 128 data transferred
	DMAC_CTRLA5_SCSIZE_CHK_256      = 0x7        // 256 data transferred
	DMAC_CTRLA5_DCSIZE_Pos          = 0x14       // Position of DCSIZE field.
	DMAC_CTRLA5_DCSIZE_Msk          = 0x700000   // Bit mask of DCSIZE field.
	DMAC_CTRLA5_DCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA5_DCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA5_DCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA5_DCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA5_DCSIZE_CHK_32       = 0x4        // 32 data transferred
	DMAC_CTRLA5_DCSIZE_CHK_64       = 0x5        // 64 data transferred
	DMAC_CTRLA5_DCSIZE_CHK_128      = 0x6        // 128 data transferred
	DMAC_CTRLA5_DCSIZE_CHK_256      = 0x7        // 256 data transferred
	DMAC_CTRLA5_SRC_WIDTH_Pos       = 0x18       // Position of SRC_WIDTH field.
	DMAC_CTRLA5_SRC_WIDTH_Msk       = 0x3000000  // Bit mask of SRC_WIDTH field.
	DMAC_CTRLA5_SRC_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA5_SRC_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA5_SRC_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA5_DST_WIDTH_Pos       = 0x1c       // Position of DST_WIDTH field.
	DMAC_CTRLA5_DST_WIDTH_Msk       = 0x30000000 // Bit mask of DST_WIDTH field.
	DMAC_CTRLA5_DST_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA5_DST_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA5_DST_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA5_DONE_Pos            = 0x1f       // Position of DONE field.
	DMAC_CTRLA5_DONE_Msk            = 0x80000000 // Bit mask of DONE field.
	DMAC_CTRLA5_DONE                = 0x80000000 // Bit DONE.

	// CTRLB5: DMAC Channel Control B Register (ch_num = 5)
	DMAC_CTRLB5_SIF_Pos               = 0x0        // Position of SIF field.
	DMAC_CTRLB5_SIF_Msk               = 0x3        // Bit mask of SIF field.
	DMAC_CTRLB5_SIF_AHB_IFO           = 0x0        // The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB5_SIF_AHB_IF1           = 0x1        // The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB5_SIF_AHB_IF2           = 0x2        // The source transfer is done via AHB-Lite Interface 2
	DMAC_CTRLB5_DIF_Pos               = 0x4        // Position of DIF field.
	DMAC_CTRLB5_DIF_Msk               = 0x30       // Bit mask of DIF field.
	DMAC_CTRLB5_DIF_AHB_IFO           = 0x0        // The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB5_DIF_AHB_IF1           = 0x1        // The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB5_DIF_AHB_IF2           = 0x2        // The destination transfer is done via AHB-Lite Interface 2
	DMAC_CTRLB5_SRC_DSCR_Pos          = 0x10       // Position of SRC_DSCR field.
	DMAC_CTRLB5_SRC_DSCR_Msk          = 0x10000    // Bit mask of SRC_DSCR field.
	DMAC_CTRLB5_SRC_DSCR              = 0x10000    // Bit SRC_DSCR.
	DMAC_CTRLB5_DST_DSCR_Pos          = 0x14       // Position of DST_DSCR field.
	DMAC_CTRLB5_DST_DSCR_Msk          = 0x100000   // Bit mask of DST_DSCR field.
	DMAC_CTRLB5_DST_DSCR              = 0x100000   // Bit DST_DSCR.
	DMAC_CTRLB5_FC_Pos                = 0x15       // Position of FC field.
	DMAC_CTRLB5_FC_Msk                = 0xe00000   // Bit mask of FC field.
	DMAC_CTRLB5_FC_MEM2MEM_DMA_FC     = 0x0        // Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB5_FC_MEM2PER_DMA_FC     = 0x1        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB5_FC_PER2MEM_DMA_FC     = 0x2        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB5_FC_PER2PER_DMA_FC     = 0x3        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB5_FC_PER2MEM_PER_FC     = 0x4        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB5_FC_MEM2PER_PER_FC     = 0x5        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB5_FC_PER2PER_SPER_FC    = 0x6        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB5_FC_PER2PER_DPER_FC    = 0x7        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB5_SRC_INCR_Pos          = 0x18       // Position of SRC_INCR field.
	DMAC_CTRLB5_SRC_INCR_Msk          = 0x3000000  // Bit mask of SRC_INCR field.
	DMAC_CTRLB5_SRC_INCR_INCREMENTING = 0x0        // The source address is incremented
	DMAC_CTRLB5_SRC_INCR_DECREMENTING = 0x1        // The source address is decremented
	DMAC_CTRLB5_SRC_INCR_FIXED        = 0x2        // The source address remains unchanged
	DMAC_CTRLB5_DST_INCR_Pos          = 0x1c       // Position of DST_INCR field.
	DMAC_CTRLB5_DST_INCR_Msk          = 0x30000000 // Bit mask of DST_INCR field.
	DMAC_CTRLB5_DST_INCR_INCREMENTING = 0x0        // The destination address is incremented
	DMAC_CTRLB5_DST_INCR_DECREMENTING = 0x1        // The destination address is decremented
	DMAC_CTRLB5_DST_INCR_FIXED        = 0x2        // The destination address remains unchanged
	DMAC_CTRLB5_IEN_Pos               = 0x1e       // Position of IEN field.
	DMAC_CTRLB5_IEN_Msk               = 0x40000000 // Bit mask of IEN field.
	DMAC_CTRLB5_IEN                   = 0x40000000 // Bit IEN.
	DMAC_CTRLB5_AUTO_Pos              = 0x1f       // Position of AUTO field.
	DMAC_CTRLB5_AUTO_Msk              = 0x80000000 // Bit mask of AUTO field.
	DMAC_CTRLB5_AUTO                  = 0x80000000 // Bit AUTO.

	// CFG5: DMAC Channel Configuration Register (ch_num = 5)
	DMAC_CFG5_SRC_PER_Pos      = 0x0        // Position of SRC_PER field.
	DMAC_CFG5_SRC_PER_Msk      = 0xf        // Bit mask of SRC_PER field.
	DMAC_CFG5_DST_PER_Pos      = 0x4        // Position of DST_PER field.
	DMAC_CFG5_DST_PER_Msk      = 0xf0       // Bit mask of DST_PER field.
	DMAC_CFG5_SRC_REP_Pos      = 0x8        // Position of SRC_REP field.
	DMAC_CFG5_SRC_REP_Msk      = 0x100      // Bit mask of SRC_REP field.
	DMAC_CFG5_SRC_REP          = 0x100      // Bit SRC_REP.
	DMAC_CFG5_SRC_H2SEL_Pos    = 0x9        // Position of SRC_H2SEL field.
	DMAC_CFG5_SRC_H2SEL_Msk    = 0x200      // Bit mask of SRC_H2SEL field.
	DMAC_CFG5_SRC_H2SEL        = 0x200      // Bit SRC_H2SEL.
	DMAC_CFG5_DST_REP_Pos      = 0xc        // Position of DST_REP field.
	DMAC_CFG5_DST_REP_Msk      = 0x1000     // Bit mask of DST_REP field.
	DMAC_CFG5_DST_REP          = 0x1000     // Bit DST_REP.
	DMAC_CFG5_DST_H2SEL_Pos    = 0xd        // Position of DST_H2SEL field.
	DMAC_CFG5_DST_H2SEL_Msk    = 0x2000     // Bit mask of DST_H2SEL field.
	DMAC_CFG5_DST_H2SEL        = 0x2000     // Bit DST_H2SEL.
	DMAC_CFG5_SOD_Pos          = 0x10       // Position of SOD field.
	DMAC_CFG5_SOD_Msk          = 0x10000    // Bit mask of SOD field.
	DMAC_CFG5_SOD              = 0x10000    // Bit SOD.
	DMAC_CFG5_LOCK_IF_Pos      = 0x14       // Position of LOCK_IF field.
	DMAC_CFG5_LOCK_IF_Msk      = 0x100000   // Bit mask of LOCK_IF field.
	DMAC_CFG5_LOCK_IF          = 0x100000   // Bit LOCK_IF.
	DMAC_CFG5_LOCK_B_Pos       = 0x15       // Position of LOCK_B field.
	DMAC_CFG5_LOCK_B_Msk       = 0x200000   // Bit mask of LOCK_B field.
	DMAC_CFG5_LOCK_B           = 0x200000   // Bit LOCK_B.
	DMAC_CFG5_LOCK_IF_L_Pos    = 0x16       // Position of LOCK_IF_L field.
	DMAC_CFG5_LOCK_IF_L_Msk    = 0x400000   // Bit mask of LOCK_IF_L field.
	DMAC_CFG5_LOCK_IF_L        = 0x400000   // Bit LOCK_IF_L.
	DMAC_CFG5_AHB_PROT_Pos     = 0x18       // Position of AHB_PROT field.
	DMAC_CFG5_AHB_PROT_Msk     = 0x7000000  // Bit mask of AHB_PROT field.
	DMAC_CFG5_FIFOCFG_Pos      = 0x1c       // Position of FIFOCFG field.
	DMAC_CFG5_FIFOCFG_Msk      = 0x30000000 // Bit mask of FIFOCFG field.
	DMAC_CFG5_FIFOCFG_ALAP_CFG = 0x0        // The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG5_FIFOCFG_HALF_CFG = 0x1        // When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG5_FIFOCFG_ASAP_CFG = 0x2        // When there is enough space/data available to perform a single AHB access, then the request is serviced.

	// SADDR6: DMAC Channel Source Address Register (ch_num = 6)
	DMAC_SADDR6_SADDR_Pos = 0x0        // Position of SADDR field.
	DMAC_SADDR6_SADDR_Msk = 0xffffffff // Bit mask of SADDR field.

	// DADDR6: DMAC Channel Destination Address Register (ch_num = 6)
	DMAC_DADDR6_DADDR_Pos = 0x0        // Position of DADDR field.
	DMAC_DADDR6_DADDR_Msk = 0xffffffff // Bit mask of DADDR field.

	// DSCR6: DMAC Channel Descriptor Address Register (ch_num = 6)
	DMAC_DSCR6_DSCR_IF_Pos     = 0x0        // Position of DSCR_IF field.
	DMAC_DSCR6_DSCR_IF_Msk     = 0x3        // Bit mask of DSCR_IF field.
	DMAC_DSCR6_DSCR_IF_AHB_IFO = 0x0        // The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR6_DSCR_IF_AHB_IF1 = 0x1        // The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR6_DSCR_IF_AHB_IF2 = 0x2        // The buffer transfer descriptor is fetched via AHB-Lite Interface 2
	DMAC_DSCR6_DSCR_Pos        = 0x2        // Position of DSCR field.
	DMAC_DSCR6_DSCR_Msk        = 0xfffffffc // Bit mask of DSCR field.

	// CTRLA6: DMAC Channel Control A Register (ch_num = 6)
	DMAC_CTRLA6_BTSIZE_Pos          = 0x0        // Position of BTSIZE field.
	DMAC_CTRLA6_BTSIZE_Msk          = 0xffff     // Bit mask of BTSIZE field.
	DMAC_CTRLA6_SCSIZE_Pos          = 0x10       // Position of SCSIZE field.
	DMAC_CTRLA6_SCSIZE_Msk          = 0x70000    // Bit mask of SCSIZE field.
	DMAC_CTRLA6_SCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA6_SCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA6_SCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA6_SCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA6_SCSIZE_CHK_32       = 0x4        // 32 data transferred
	DMAC_CTRLA6_SCSIZE_CHK_64       = 0x5        // 64 data transferred
	DMAC_CTRLA6_SCSIZE_CHK_128      = 0x6        // 128 data transferred
	DMAC_CTRLA6_SCSIZE_CHK_256      = 0x7        // 256 data transferred
	DMAC_CTRLA6_DCSIZE_Pos          = 0x14       // Position of DCSIZE field.
	DMAC_CTRLA6_DCSIZE_Msk          = 0x700000   // Bit mask of DCSIZE field.
	DMAC_CTRLA6_DCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA6_DCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA6_DCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA6_DCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA6_DCSIZE_CHK_32       = 0x4        // 32 data transferred
	DMAC_CTRLA6_DCSIZE_CHK_64       = 0x5        // 64 data transferred
	DMAC_CTRLA6_DCSIZE_CHK_128      = 0x6        // 128 data transferred
	DMAC_CTRLA6_DCSIZE_CHK_256      = 0x7        // 256 data transferred
	DMAC_CTRLA6_SRC_WIDTH_Pos       = 0x18       // Position of SRC_WIDTH field.
	DMAC_CTRLA6_SRC_WIDTH_Msk       = 0x3000000  // Bit mask of SRC_WIDTH field.
	DMAC_CTRLA6_SRC_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA6_SRC_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA6_SRC_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA6_DST_WIDTH_Pos       = 0x1c       // Position of DST_WIDTH field.
	DMAC_CTRLA6_DST_WIDTH_Msk       = 0x30000000 // Bit mask of DST_WIDTH field.
	DMAC_CTRLA6_DST_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA6_DST_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA6_DST_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA6_DONE_Pos            = 0x1f       // Position of DONE field.
	DMAC_CTRLA6_DONE_Msk            = 0x80000000 // Bit mask of DONE field.
	DMAC_CTRLA6_DONE                = 0x80000000 // Bit DONE.

	// CTRLB6: DMAC Channel Control B Register (ch_num = 6)
	DMAC_CTRLB6_SIF_Pos               = 0x0        // Position of SIF field.
	DMAC_CTRLB6_SIF_Msk               = 0x3        // Bit mask of SIF field.
	DMAC_CTRLB6_SIF_AHB_IFO           = 0x0        // The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB6_SIF_AHB_IF1           = 0x1        // The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB6_SIF_AHB_IF2           = 0x2        // The source transfer is done via AHB-Lite Interface 2
	DMAC_CTRLB6_DIF_Pos               = 0x4        // Position of DIF field.
	DMAC_CTRLB6_DIF_Msk               = 0x30       // Bit mask of DIF field.
	DMAC_CTRLB6_DIF_AHB_IFO           = 0x0        // The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB6_DIF_AHB_IF1           = 0x1        // The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB6_DIF_AHB_IF2           = 0x2        // The destination transfer is done via AHB-Lite Interface 2
	DMAC_CTRLB6_SRC_DSCR_Pos          = 0x10       // Position of SRC_DSCR field.
	DMAC_CTRLB6_SRC_DSCR_Msk          = 0x10000    // Bit mask of SRC_DSCR field.
	DMAC_CTRLB6_SRC_DSCR              = 0x10000    // Bit SRC_DSCR.
	DMAC_CTRLB6_DST_DSCR_Pos          = 0x14       // Position of DST_DSCR field.
	DMAC_CTRLB6_DST_DSCR_Msk          = 0x100000   // Bit mask of DST_DSCR field.
	DMAC_CTRLB6_DST_DSCR              = 0x100000   // Bit DST_DSCR.
	DMAC_CTRLB6_FC_Pos                = 0x15       // Position of FC field.
	DMAC_CTRLB6_FC_Msk                = 0xe00000   // Bit mask of FC field.
	DMAC_CTRLB6_FC_MEM2MEM_DMA_FC     = 0x0        // Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB6_FC_MEM2PER_DMA_FC     = 0x1        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB6_FC_PER2MEM_DMA_FC     = 0x2        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB6_FC_PER2PER_DMA_FC     = 0x3        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB6_FC_PER2MEM_PER_FC     = 0x4        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB6_FC_MEM2PER_PER_FC     = 0x5        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB6_FC_PER2PER_SPER_FC    = 0x6        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB6_FC_PER2PER_DPER_FC    = 0x7        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB6_SRC_INCR_Pos          = 0x18       // Position of SRC_INCR field.
	DMAC_CTRLB6_SRC_INCR_Msk          = 0x3000000  // Bit mask of SRC_INCR field.
	DMAC_CTRLB6_SRC_INCR_INCREMENTING = 0x0        // The source address is incremented
	DMAC_CTRLB6_SRC_INCR_DECREMENTING = 0x1        // The source address is decremented
	DMAC_CTRLB6_SRC_INCR_FIXED        = 0x2        // The source address remains unchanged
	DMAC_CTRLB6_DST_INCR_Pos          = 0x1c       // Position of DST_INCR field.
	DMAC_CTRLB6_DST_INCR_Msk          = 0x30000000 // Bit mask of DST_INCR field.
	DMAC_CTRLB6_DST_INCR_INCREMENTING = 0x0        // The destination address is incremented
	DMAC_CTRLB6_DST_INCR_DECREMENTING = 0x1        // The destination address is decremented
	DMAC_CTRLB6_DST_INCR_FIXED        = 0x2        // The destination address remains unchanged
	DMAC_CTRLB6_IEN_Pos               = 0x1e       // Position of IEN field.
	DMAC_CTRLB6_IEN_Msk               = 0x40000000 // Bit mask of IEN field.
	DMAC_CTRLB6_IEN                   = 0x40000000 // Bit IEN.
	DMAC_CTRLB6_AUTO_Pos              = 0x1f       // Position of AUTO field.
	DMAC_CTRLB6_AUTO_Msk              = 0x80000000 // Bit mask of AUTO field.
	DMAC_CTRLB6_AUTO                  = 0x80000000 // Bit AUTO.

	// CFG6: DMAC Channel Configuration Register (ch_num = 6)
	DMAC_CFG6_SRC_PER_Pos      = 0x0        // Position of SRC_PER field.
	DMAC_CFG6_SRC_PER_Msk      = 0xf        // Bit mask of SRC_PER field.
	DMAC_CFG6_DST_PER_Pos      = 0x4        // Position of DST_PER field.
	DMAC_CFG6_DST_PER_Msk      = 0xf0       // Bit mask of DST_PER field.
	DMAC_CFG6_SRC_REP_Pos      = 0x8        // Position of SRC_REP field.
	DMAC_CFG6_SRC_REP_Msk      = 0x100      // Bit mask of SRC_REP field.
	DMAC_CFG6_SRC_REP          = 0x100      // Bit SRC_REP.
	DMAC_CFG6_SRC_H2SEL_Pos    = 0x9        // Position of SRC_H2SEL field.
	DMAC_CFG6_SRC_H2SEL_Msk    = 0x200      // Bit mask of SRC_H2SEL field.
	DMAC_CFG6_SRC_H2SEL        = 0x200      // Bit SRC_H2SEL.
	DMAC_CFG6_DST_REP_Pos      = 0xc        // Position of DST_REP field.
	DMAC_CFG6_DST_REP_Msk      = 0x1000     // Bit mask of DST_REP field.
	DMAC_CFG6_DST_REP          = 0x1000     // Bit DST_REP.
	DMAC_CFG6_DST_H2SEL_Pos    = 0xd        // Position of DST_H2SEL field.
	DMAC_CFG6_DST_H2SEL_Msk    = 0x2000     // Bit mask of DST_H2SEL field.
	DMAC_CFG6_DST_H2SEL        = 0x2000     // Bit DST_H2SEL.
	DMAC_CFG6_SOD_Pos          = 0x10       // Position of SOD field.
	DMAC_CFG6_SOD_Msk          = 0x10000    // Bit mask of SOD field.
	DMAC_CFG6_SOD              = 0x10000    // Bit SOD.
	DMAC_CFG6_LOCK_IF_Pos      = 0x14       // Position of LOCK_IF field.
	DMAC_CFG6_LOCK_IF_Msk      = 0x100000   // Bit mask of LOCK_IF field.
	DMAC_CFG6_LOCK_IF          = 0x100000   // Bit LOCK_IF.
	DMAC_CFG6_LOCK_B_Pos       = 0x15       // Position of LOCK_B field.
	DMAC_CFG6_LOCK_B_Msk       = 0x200000   // Bit mask of LOCK_B field.
	DMAC_CFG6_LOCK_B           = 0x200000   // Bit LOCK_B.
	DMAC_CFG6_LOCK_IF_L_Pos    = 0x16       // Position of LOCK_IF_L field.
	DMAC_CFG6_LOCK_IF_L_Msk    = 0x400000   // Bit mask of LOCK_IF_L field.
	DMAC_CFG6_LOCK_IF_L        = 0x400000   // Bit LOCK_IF_L.
	DMAC_CFG6_AHB_PROT_Pos     = 0x18       // Position of AHB_PROT field.
	DMAC_CFG6_AHB_PROT_Msk     = 0x7000000  // Bit mask of AHB_PROT field.
	DMAC_CFG6_FIFOCFG_Pos      = 0x1c       // Position of FIFOCFG field.
	DMAC_CFG6_FIFOCFG_Msk      = 0x30000000 // Bit mask of FIFOCFG field.
	DMAC_CFG6_FIFOCFG_ALAP_CFG = 0x0        // The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG6_FIFOCFG_HALF_CFG = 0x1        // When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG6_FIFOCFG_ASAP_CFG = 0x2        // When there is enough space/data available to perform a single AHB access, then the request is serviced.

	// SADDR7: DMAC Channel Source Address Register (ch_num = 7)
	DMAC_SADDR7_SADDR_Pos = 0x0        // Position of SADDR field.
	DMAC_SADDR7_SADDR_Msk = 0xffffffff // Bit mask of SADDR field.

	// DADDR7: DMAC Channel Destination Address Register (ch_num = 7)
	DMAC_DADDR7_DADDR_Pos = 0x0        // Position of DADDR field.
	DMAC_DADDR7_DADDR_Msk = 0xffffffff // Bit mask of DADDR field.

	// DSCR7: DMAC Channel Descriptor Address Register (ch_num = 7)
	DMAC_DSCR7_DSCR_IF_Pos     = 0x0        // Position of DSCR_IF field.
	DMAC_DSCR7_DSCR_IF_Msk     = 0x3        // Bit mask of DSCR_IF field.
	DMAC_DSCR7_DSCR_IF_AHB_IFO = 0x0        // The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR7_DSCR_IF_AHB_IF1 = 0x1        // The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR7_DSCR_IF_AHB_IF2 = 0x2        // The buffer transfer descriptor is fetched via AHB-Lite Interface 2
	DMAC_DSCR7_DSCR_Pos        = 0x2        // Position of DSCR field.
	DMAC_DSCR7_DSCR_Msk        = 0xfffffffc // Bit mask of DSCR field.

	// CTRLA7: DMAC Channel Control A Register (ch_num = 7)
	DMAC_CTRLA7_BTSIZE_Pos          = 0x0        // Position of BTSIZE field.
	DMAC_CTRLA7_BTSIZE_Msk          = 0xffff     // Bit mask of BTSIZE field.
	DMAC_CTRLA7_SCSIZE_Pos          = 0x10       // Position of SCSIZE field.
	DMAC_CTRLA7_SCSIZE_Msk          = 0x70000    // Bit mask of SCSIZE field.
	DMAC_CTRLA7_SCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA7_SCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA7_SCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA7_SCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA7_SCSIZE_CHK_32       = 0x4        // 32 data transferred
	DMAC_CTRLA7_SCSIZE_CHK_64       = 0x5        // 64 data transferred
	DMAC_CTRLA7_SCSIZE_CHK_128      = 0x6        // 128 data transferred
	DMAC_CTRLA7_SCSIZE_CHK_256      = 0x7        // 256 data transferred
	DMAC_CTRLA7_DCSIZE_Pos          = 0x14       // Position of DCSIZE field.
	DMAC_CTRLA7_DCSIZE_Msk          = 0x700000   // Bit mask of DCSIZE field.
	DMAC_CTRLA7_DCSIZE_CHK_1        = 0x0        // 1 data transferred
	DMAC_CTRLA7_DCSIZE_CHK_4        = 0x1        // 4 data transferred
	DMAC_CTRLA7_DCSIZE_CHK_8        = 0x2        // 8 data transferred
	DMAC_CTRLA7_DCSIZE_CHK_16       = 0x3        // 16 data transferred
	DMAC_CTRLA7_DCSIZE_CHK_32       = 0x4        // 32 data transferred
	DMAC_CTRLA7_DCSIZE_CHK_64       = 0x5        // 64 data transferred
	DMAC_CTRLA7_DCSIZE_CHK_128      = 0x6        // 128 data transferred
	DMAC_CTRLA7_DCSIZE_CHK_256      = 0x7        // 256 data transferred
	DMAC_CTRLA7_SRC_WIDTH_Pos       = 0x18       // Position of SRC_WIDTH field.
	DMAC_CTRLA7_SRC_WIDTH_Msk       = 0x3000000  // Bit mask of SRC_WIDTH field.
	DMAC_CTRLA7_SRC_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA7_SRC_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA7_SRC_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA7_DST_WIDTH_Pos       = 0x1c       // Position of DST_WIDTH field.
	DMAC_CTRLA7_DST_WIDTH_Msk       = 0x30000000 // Bit mask of DST_WIDTH field.
	DMAC_CTRLA7_DST_WIDTH_BYTE      = 0x0        // the transfer size is set to 8-bit width
	DMAC_CTRLA7_DST_WIDTH_HALF_WORD = 0x1        // the transfer size is set to 16-bit width
	DMAC_CTRLA7_DST_WIDTH_WORD      = 0x2        // the transfer size is set to 32-bit width
	DMAC_CTRLA7_DONE_Pos            = 0x1f       // Position of DONE field.
	DMAC_CTRLA7_DONE_Msk            = 0x80000000 // Bit mask of DONE field.
	DMAC_CTRLA7_DONE                = 0x80000000 // Bit DONE.

	// CTRLB7: DMAC Channel Control B Register (ch_num = 7)
	DMAC_CTRLB7_SIF_Pos               = 0x0        // Position of SIF field.
	DMAC_CTRLB7_SIF_Msk               = 0x3        // Bit mask of SIF field.
	DMAC_CTRLB7_SIF_AHB_IFO           = 0x0        // The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB7_SIF_AHB_IF1           = 0x1        // The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB7_SIF_AHB_IF2           = 0x2        // The source transfer is done via AHB-Lite Interface 2
	DMAC_CTRLB7_DIF_Pos               = 0x4        // Position of DIF field.
	DMAC_CTRLB7_DIF_Msk               = 0x30       // Bit mask of DIF field.
	DMAC_CTRLB7_DIF_AHB_IFO           = 0x0        // The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB7_DIF_AHB_IF1           = 0x1        // The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB7_DIF_AHB_IF2           = 0x2        // The destination transfer is done via AHB-Lite Interface 2
	DMAC_CTRLB7_SRC_DSCR_Pos          = 0x10       // Position of SRC_DSCR field.
	DMAC_CTRLB7_SRC_DSCR_Msk          = 0x10000    // Bit mask of SRC_DSCR field.
	DMAC_CTRLB7_SRC_DSCR              = 0x10000    // Bit SRC_DSCR.
	DMAC_CTRLB7_DST_DSCR_Pos          = 0x14       // Position of DST_DSCR field.
	DMAC_CTRLB7_DST_DSCR_Msk          = 0x100000   // Bit mask of DST_DSCR field.
	DMAC_CTRLB7_DST_DSCR              = 0x100000   // Bit DST_DSCR.
	DMAC_CTRLB7_FC_Pos                = 0x15       // Position of FC field.
	DMAC_CTRLB7_FC_Msk                = 0xe00000   // Bit mask of FC field.
	DMAC_CTRLB7_FC_MEM2MEM_DMA_FC     = 0x0        // Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB7_FC_MEM2PER_DMA_FC     = 0x1        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB7_FC_PER2MEM_DMA_FC     = 0x2        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB7_FC_PER2PER_DMA_FC     = 0x3        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB7_FC_PER2MEM_PER_FC     = 0x4        // Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB7_FC_MEM2PER_PER_FC     = 0x5        // Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB7_FC_PER2PER_SPER_FC    = 0x6        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB7_FC_PER2PER_DPER_FC    = 0x7        // Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB7_SRC_INCR_Pos          = 0x18       // Position of SRC_INCR field.
	DMAC_CTRLB7_SRC_INCR_Msk          = 0x3000000  // Bit mask of SRC_INCR field.
	DMAC_CTRLB7_SRC_INCR_INCREMENTING = 0x0        // The source address is incremented
	DMAC_CTRLB7_SRC_INCR_DECREMENTING = 0x1        // The source address is decremented
	DMAC_CTRLB7_SRC_INCR_FIXED        = 0x2        // The source address remains unchanged
	DMAC_CTRLB7_DST_INCR_Pos          = 0x1c       // Position of DST_INCR field.
	DMAC_CTRLB7_DST_INCR_Msk          = 0x30000000 // Bit mask of DST_INCR field.
	DMAC_CTRLB7_DST_INCR_INCREMENTING = 0x0        // The destination address is incremented
	DMAC_CTRLB7_DST_INCR_DECREMENTING = 0x1        // The destination address is decremented
	DMAC_CTRLB7_DST_INCR_FIXED        = 0x2        // The destination address remains unchanged
	DMAC_CTRLB7_IEN_Pos               = 0x1e       // Position of IEN field.
	DMAC_CTRLB7_IEN_Msk               = 0x40000000 // Bit mask of IEN field.
	DMAC_CTRLB7_IEN                   = 0x40000000 // Bit IEN.
	DMAC_CTRLB7_AUTO_Pos              = 0x1f       // Position of AUTO field.
	DMAC_CTRLB7_AUTO_Msk              = 0x80000000 // Bit mask of AUTO field.
	DMAC_CTRLB7_AUTO                  = 0x80000000 // Bit AUTO.

	// CFG7: DMAC Channel Configuration Register (ch_num = 7)
	DMAC_CFG7_SRC_PER_Pos      = 0x0        // Position of SRC_PER field.
	DMAC_CFG7_SRC_PER_Msk      = 0xf        // Bit mask of SRC_PER field.
	DMAC_CFG7_DST_PER_Pos      = 0x4        // Position of DST_PER field.
	DMAC_CFG7_DST_PER_Msk      = 0xf0       // Bit mask of DST_PER field.
	DMAC_CFG7_SRC_REP_Pos      = 0x8        // Position of SRC_REP field.
	DMAC_CFG7_SRC_REP_Msk      = 0x100      // Bit mask of SRC_REP field.
	DMAC_CFG7_SRC_REP          = 0x100      // Bit SRC_REP.
	DMAC_CFG7_SRC_H2SEL_Pos    = 0x9        // Position of SRC_H2SEL field.
	DMAC_CFG7_SRC_H2SEL_Msk    = 0x200      // Bit mask of SRC_H2SEL field.
	DMAC_CFG7_SRC_H2SEL        = 0x200      // Bit SRC_H2SEL.
	DMAC_CFG7_DST_REP_Pos      = 0xc        // Position of DST_REP field.
	DMAC_CFG7_DST_REP_Msk      = 0x1000     // Bit mask of DST_REP field.
	DMAC_CFG7_DST_REP          = 0x1000     // Bit DST_REP.
	DMAC_CFG7_DST_H2SEL_Pos    = 0xd        // Position of DST_H2SEL field.
	DMAC_CFG7_DST_H2SEL_Msk    = 0x2000     // Bit mask of DST_H2SEL field.
	DMAC_CFG7_DST_H2SEL        = 0x2000     // Bit DST_H2SEL.
	DMAC_CFG7_SOD_Pos          = 0x10       // Position of SOD field.
	DMAC_CFG7_SOD_Msk          = 0x10000    // Bit mask of SOD field.
	DMAC_CFG7_SOD              = 0x10000    // Bit SOD.
	DMAC_CFG7_LOCK_IF_Pos      = 0x14       // Position of LOCK_IF field.
	DMAC_CFG7_LOCK_IF_Msk      = 0x100000   // Bit mask of LOCK_IF field.
	DMAC_CFG7_LOCK_IF          = 0x100000   // Bit LOCK_IF.
	DMAC_CFG7_LOCK_B_Pos       = 0x15       // Position of LOCK_B field.
	DMAC_CFG7_LOCK_B_Msk       = 0x200000   // Bit mask of LOCK_B field.
	DMAC_CFG7_LOCK_B           = 0x200000   // Bit LOCK_B.
	DMAC_CFG7_LOCK_IF_L_Pos    = 0x16       // Position of LOCK_IF_L field.
	DMAC_CFG7_LOCK_IF_L_Msk    = 0x400000   // Bit mask of LOCK_IF_L field.
	DMAC_CFG7_LOCK_IF_L        = 0x400000   // Bit LOCK_IF_L.
	DMAC_CFG7_AHB_PROT_Pos     = 0x18       // Position of AHB_PROT field.
	DMAC_CFG7_AHB_PROT_Msk     = 0x7000000  // Bit mask of AHB_PROT field.
	DMAC_CFG7_FIFOCFG_Pos      = 0x1c       // Position of FIFOCFG field.
	DMAC_CFG7_FIFOCFG_Msk      = 0x30000000 // Bit mask of FIFOCFG field.
	DMAC_CFG7_FIFOCFG_ALAP_CFG = 0x0        // The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG7_FIFOCFG_HALF_CFG = 0x1        // When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG7_FIFOCFG_ASAP_CFG = 0x2        // When there is enough space/data available to perform a single AHB access, then the request is serviced.

	// WPMR: Write Protect Mode Register
	DMAC_WPMR_WPEN_Pos  = 0x0        // Position of WPEN field.
	DMAC_WPMR_WPEN_Msk  = 0x1        // Bit mask of WPEN field.
	DMAC_WPMR_WPEN      = 0x1        // Bit WPEN.
	DMAC_WPMR_WPKEY_Pos = 0x8        // Position of WPKEY field.
	DMAC_WPMR_WPKEY_Msk = 0xffffff00 // Bit mask of WPKEY field.

	// WPSR: Write Protect Status Register
	DMAC_WPSR_WPVS_Pos   = 0x0      // Position of WPVS field.
	DMAC_WPSR_WPVS_Msk   = 0x1      // Bit mask of WPVS field.
	DMAC_WPSR_WPVS       = 0x1      // Bit WPVS.
	DMAC_WPSR_WPVSRC_Pos = 0x8      // Position of WPVSRC field.
	DMAC_WPSR_WPVSRC_Msk = 0xffff00 // Bit mask of WPVSRC field.
)

// Bitfields for DBGU: Debug Unit
const (
	// CR: Control Register
	DBGU_CR_RSTRX_Pos  = 0x2   // Position of RSTRX field.
	DBGU_CR_RSTRX_Msk  = 0x4   // Bit mask of RSTRX field.
	DBGU_CR_RSTRX      = 0x4   // Bit RSTRX.
	DBGU_CR_RSTTX_Pos  = 0x3   // Position of RSTTX field.
	DBGU_CR_RSTTX_Msk  = 0x8   // Bit mask of RSTTX field.
	DBGU_CR_RSTTX      = 0x8   // Bit RSTTX.
	DBGU_CR_RXEN_Pos   = 0x4   // Position of RXEN field.
	DBGU_CR_RXEN_Msk   = 0x10  // Bit mask of RXEN field.
	DBGU_CR_RXEN       = 0x10  // Bit RXEN.
	DBGU_CR_RXDIS_Pos  = 0x5   // Position of RXDIS field.
	DBGU_CR_RXDIS_Msk  = 0x20  // Bit mask of RXDIS field.
	DBGU_CR_RXDIS      = 0x20  // Bit RXDIS.
	DBGU_CR_TXEN_Pos   = 0x6   // Position of TXEN field.
	DBGU_CR_TXEN_Msk   = 0x40  // Bit mask of TXEN field.
	DBGU_CR_TXEN       = 0x40  // Bit TXEN.
	DBGU_CR_TXDIS_Pos  = 0x7   // Position of TXDIS field.
	DBGU_CR_TXDIS_Msk  = 0x80  // Bit mask of TXDIS field.
	DBGU_CR_TXDIS      = 0x80  // Bit TXDIS.
	DBGU_CR_RSTSTA_Pos = 0x8   // Position of RSTSTA field.
	DBGU_CR_RSTSTA_Msk = 0x100 // Bit mask of RSTSTA field.
	DBGU_CR_RSTSTA     = 0x100 // Bit RSTSTA.

	// MR: Mode Register
	DBGU_MR_PAR_Pos    = 0x9    // Position of PAR field.
	DBGU_MR_PAR_Msk    = 0xe00  // Bit mask of PAR field.
	DBGU_MR_CHMODE_Pos = 0xe    // Position of CHMODE field.
	DBGU_MR_CHMODE_Msk = 0xc000 // Bit mask of CHMODE field.

	// IER: Interrupt Enable Register
	DBGU_IER_RXRDY_Pos   = 0x0        // Position of RXRDY field.
	DBGU_IER_RXRDY_Msk   = 0x1        // Bit mask of RXRDY field.
	DBGU_IER_RXRDY       = 0x1        // Bit RXRDY.
	DBGU_IER_TXRDY_Pos   = 0x1        // Position of TXRDY field.
	DBGU_IER_TXRDY_Msk   = 0x2        // Bit mask of TXRDY field.
	DBGU_IER_TXRDY       = 0x2        // Bit TXRDY.
	DBGU_IER_ENDRX_Pos   = 0x3        // Position of ENDRX field.
	DBGU_IER_ENDRX_Msk   = 0x8        // Bit mask of ENDRX field.
	DBGU_IER_ENDRX       = 0x8        // Bit ENDRX.
	DBGU_IER_ENDTX_Pos   = 0x4        // Position of ENDTX field.
	DBGU_IER_ENDTX_Msk   = 0x10       // Bit mask of ENDTX field.
	DBGU_IER_ENDTX       = 0x10       // Bit ENDTX.
	DBGU_IER_OVRE_Pos    = 0x5        // Position of OVRE field.
	DBGU_IER_OVRE_Msk    = 0x20       // Bit mask of OVRE field.
	DBGU_IER_OVRE        = 0x20       // Bit OVRE.
	DBGU_IER_FRAME_Pos   = 0x6        // Position of FRAME field.
	DBGU_IER_FRAME_Msk   = 0x40       // Bit mask of FRAME field.
	DBGU_IER_FRAME       = 0x40       // Bit FRAME.
	DBGU_IER_PARE_Pos    = 0x7        // Position of PARE field.
	DBGU_IER_PARE_Msk    = 0x80       // Bit mask of PARE field.
	DBGU_IER_PARE        = 0x80       // Bit PARE.
	DBGU_IER_TXEMPTY_Pos = 0x9        // Position of TXEMPTY field.
	DBGU_IER_TXEMPTY_Msk = 0x200      // Bit mask of TXEMPTY field.
	DBGU_IER_TXEMPTY     = 0x200      // Bit TXEMPTY.
	DBGU_IER_TXBUFE_Pos  = 0xb        // Position of TXBUFE field.
	DBGU_IER_TXBUFE_Msk  = 0x800      // Bit mask of TXBUFE field.
	DBGU_IER_TXBUFE      = 0x800      // Bit TXBUFE.
	DBGU_IER_RXBUFF_Pos  = 0xc        // Position of RXBUFF field.
	DBGU_IER_RXBUFF_Msk  = 0x1000     // Bit mask of RXBUFF field.
	DBGU_IER_RXBUFF      = 0x1000     // Bit RXBUFF.
	DBGU_IER_COMMTX_Pos  = 0x1e       // Position of COMMTX field.
	DBGU_IER_COMMTX_Msk  = 0x40000000 // Bit mask of COMMTX field.
	DBGU_IER_COMMTX      = 0x40000000 // Bit COMMTX.
	DBGU_IER_COMMRX_Pos  = 0x1f       // Position of COMMRX field.
	DBGU_IER_COMMRX_Msk  = 0x80000000 // Bit mask of COMMRX field.
	DBGU_IER_COMMRX      = 0x80000000 // Bit COMMRX.

	// IDR: Interrupt Disable Register
	DBGU_IDR_RXRDY_Pos   = 0x0        // Position of RXRDY field.
	DBGU_IDR_RXRDY_Msk   = 0x1        // Bit mask of RXRDY field.
	DBGU_IDR_RXRDY       = 0x1        // Bit RXRDY.
	DBGU_IDR_TXRDY_Pos   = 0x1        // Position of TXRDY field.
	DBGU_IDR_TXRDY_Msk   = 0x2        // Bit mask of TXRDY field.
	DBGU_IDR_TXRDY       = 0x2        // Bit TXRDY.
	DBGU_IDR_ENDRX_Pos   = 0x3        // Position of ENDRX field.
	DBGU_IDR_ENDRX_Msk   = 0x8        // Bit mask of ENDRX field.
	DBGU_IDR_ENDRX       = 0x8        // Bit ENDRX.
	DBGU_IDR_ENDTX_Pos   = 0x4        // Position of ENDTX field.
	DBGU_IDR_ENDTX_Msk   = 0x10       // Bit mask of ENDTX field.
	DBGU_IDR_ENDTX       = 0x10       // Bit ENDTX.
	DBGU_IDR_OVRE_Pos    = 0x5        // Position of OVRE field.
	DBGU_IDR_OVRE_Msk    = 0x20       // Bit mask of OVRE field.
	DBGU_IDR_OVRE        = 0x20       // Bit OVRE.
	DBGU_IDR_FRAME_Pos   = 0x6        // Position of FRAME field.
	DBGU_IDR_FRAME_Msk   = 0x40       // Bit mask of FRAME field.
	DBGU_IDR_FRAME       = 0x40       // Bit FRAME.
	DBGU_IDR_PARE_Pos    = 0x7        // Position of PARE field.
	DBGU_IDR_PARE_Msk    = 0x80       // Bit mask of PARE field.
	DBGU_IDR_PARE        = 0x80       // Bit PARE.
	DBGU_IDR_TXEMPTY_Pos = 0x9        // Position of TXEMPTY field.
	DBGU_IDR_TXEMPTY_Msk = 0x200      // Bit mask of TXEMPTY field.
	DBGU_IDR_TXEMPTY     = 0x200      // Bit TXEMPTY.
	DBGU_IDR_TXBUFE_Pos  = 0xb        // Position of TXBUFE field.
	DBGU_IDR_TXBUFE_Msk  = 0x800      // Bit mask of TXBUFE field.
	DBGU_IDR_TXBUFE      = 0x800      // Bit TXBUFE.
	DBGU_IDR_RXBUFF_Pos  = 0xc        // Position of RXBUFF field.
	DBGU_IDR_RXBUFF_Msk  = 0x1000     // Bit mask of RXBUFF field.
	DBGU_IDR_RXBUFF      = 0x1000     // Bit RXBUFF.
	DBGU_IDR_COMMTX_Pos  = 0x1e       // Position of COMMTX field.
	DBGU_IDR_COMMTX_Msk  = 0x40000000 // Bit mask of COMMTX field.
	DBGU_IDR_COMMTX      = 0x40000000 // Bit COMMTX.
	DBGU_IDR_COMMRX_Pos  = 0x1f       // Position of COMMRX field.
	DBGU_IDR_COMMRX_Msk  = 0x80000000 // Bit mask of COMMRX field.
	DBGU_IDR_COMMRX      = 0x80000000 // Bit COMMRX.

	// IMR: Interrupt Mask Register
	DBGU_IMR_RXRDY_Pos   = 0x0        // Position of RXRDY field.
	DBGU_IMR_RXRDY_Msk   = 0x1        // Bit mask of RXRDY field.
	DBGU_IMR_RXRDY       = 0x1        // Bit RXRDY.
	DBGU_IMR_TXRDY_Pos   = 0x1        // Position of TXRDY field.
	DBGU_IMR_TXRDY_Msk   = 0x2        // Bit mask of TXRDY field.
	DBGU_IMR_TXRDY       = 0x2        // Bit TXRDY.
	DBGU_IMR_ENDRX_Pos   = 0x3        // Position of ENDRX field.
	DBGU_IMR_ENDRX_Msk   = 0x8        // Bit mask of ENDRX field.
	DBGU_IMR_ENDRX       = 0x8        // Bit ENDRX.
	DBGU_IMR_ENDTX_Pos   = 0x4        // Position of ENDTX field.
	DBGU_IMR_ENDTX_Msk   = 0x10       // Bit mask of ENDTX field.
	DBGU_IMR_ENDTX       = 0x10       // Bit ENDTX.
	DBGU_IMR_OVRE_Pos    = 0x5        // Position of OVRE field.
	DBGU_IMR_OVRE_Msk    = 0x20       // Bit mask of OVRE field.
	DBGU_IMR_OVRE        = 0x20       // Bit OVRE.
	DBGU_IMR_FRAME_Pos   = 0x6        // Position of FRAME field.
	DBGU_IMR_FRAME_Msk   = 0x40       // Bit mask of FRAME field.
	DBGU_IMR_FRAME       = 0x40       // Bit FRAME.
	DBGU_IMR_PARE_Pos    = 0x7        // Position of PARE field.
	DBGU_IMR_PARE_Msk    = 0x80       // Bit mask of PARE field.
	DBGU_IMR_PARE        = 0x80       // Bit PARE.
	DBGU_IMR_TXEMPTY_Pos = 0x9        // Position of TXEMPTY field.
	DBGU_IMR_TXEMPTY_Msk = 0x200      // Bit mask of TXEMPTY field.
	DBGU_IMR_TXEMPTY     = 0x200      // Bit TXEMPTY.
	DBGU_IMR_TXBUFE_Pos  = 0xb        // Position of TXBUFE field.
	DBGU_IMR_TXBUFE_Msk  = 0x800      // Bit mask of TXBUFE field.
	DBGU_IMR_TXBUFE      = 0x800      // Bit TXBUFE.
	DBGU_IMR_RXBUFF_Pos  = 0xc        // Position of RXBUFF field.
	DBGU_IMR_RXBUFF_Msk  = 0x1000     // Bit mask of RXBUFF field.
	DBGU_IMR_RXBUFF      = 0x1000     // Bit RXBUFF.
	DBGU_IMR_COMMTX_Pos  = 0x1e       // Position of COMMTX field.
	DBGU_IMR_COMMTX_Msk  = 0x40000000 // Bit mask of COMMTX field.
	DBGU_IMR_COMMTX      = 0x40000000 // Bit COMMTX.
	DBGU_IMR_COMMRX_Pos  = 0x1f       // Position of COMMRX field.
	DBGU_IMR_COMMRX_Msk  = 0x80000000 // Bit mask of COMMRX field.
	DBGU_IMR_COMMRX      = 0x80000000 // Bit COMMRX.

	// SR: Status Register
	DBGU_SR_RXRDY_Pos   = 0x0        // Position of RXRDY field.
	DBGU_SR_RXRDY_Msk   = 0x1        // Bit mask of RXRDY field.
	DBGU_SR_RXRDY       = 0x1        // Bit RXRDY.
	DBGU_SR_TXRDY_Pos   = 0x1        // Position of TXRDY field.
	DBGU_SR_TXRDY_Msk   = 0x2        // Bit mask of TXRDY field.
	DBGU_SR_TXRDY       = 0x2        // Bit TXRDY.
	DBGU_SR_ENDRX_Pos   = 0x3        // Position of ENDRX field.
	DBGU_SR_ENDRX_Msk   = 0x8        // Bit mask of ENDRX field.
	DBGU_SR_ENDRX       = 0x8        // Bit ENDRX.
	DBGU_SR_ENDTX_Pos   = 0x4        // Position of ENDTX field.
	DBGU_SR_ENDTX_Msk   = 0x10       // Bit mask of ENDTX field.
	DBGU_SR_ENDTX       = 0x10       // Bit ENDTX.
	DBGU_SR_OVRE_Pos    = 0x5        // Position of OVRE field.
	DBGU_SR_OVRE_Msk    = 0x20       // Bit mask of OVRE field.
	DBGU_SR_OVRE        = 0x20       // Bit OVRE.
	DBGU_SR_FRAME_Pos   = 0x6        // Position of FRAME field.
	DBGU_SR_FRAME_Msk   = 0x40       // Bit mask of FRAME field.
	DBGU_SR_FRAME       = 0x40       // Bit FRAME.
	DBGU_SR_PARE_Pos    = 0x7        // Position of PARE field.
	DBGU_SR_PARE_Msk    = 0x80       // Bit mask of PARE field.
	DBGU_SR_PARE        = 0x80       // Bit PARE.
	DBGU_SR_TXEMPTY_Pos = 0x9        // Position of TXEMPTY field.
	DBGU_SR_TXEMPTY_Msk = 0x200      // Bit mask of TXEMPTY field.
	DBGU_SR_TXEMPTY     = 0x200      // Bit TXEMPTY.
	DBGU_SR_TXBUFE_Pos  = 0xb        // Position of TXBUFE field.
	DBGU_SR_TXBUFE_Msk  = 0x800      // Bit mask of TXBUFE field.
	DBGU_SR_TXBUFE      = 0x800      // Bit TXBUFE.
	DBGU_SR_RXBUFF_Pos  = 0xc        // Position of RXBUFF field.
	DBGU_SR_RXBUFF_Msk  = 0x1000     // Bit mask of RXBUFF field.
	DBGU_SR_RXBUFF      = 0x1000     // Bit RXBUFF.
	DBGU_SR_COMMTX_Pos  = 0x1e       // Position of COMMTX field.
	DBGU_SR_COMMTX_Msk  = 0x40000000 // Bit mask of COMMTX field.
	DBGU_SR_COMMTX      = 0x40000000 // Bit COMMTX.
	DBGU_SR_COMMRX_Pos  = 0x1f       // Position of COMMRX field.
	DBGU_SR_COMMRX_Msk  = 0x80000000 // Bit mask of COMMRX field.
	DBGU_SR_COMMRX      = 0x80000000 // Bit COMMRX.

	// RHR: Receive Holding Register
	DBGU_RHR_RXCHR_Pos = 0x0  // Position of RXCHR field.
	DBGU_RHR_RXCHR_Msk = 0xff // Bit mask of RXCHR field.

	// THR: Transmit Holding Register
	DBGU_THR_TXCHR_Pos = 0x0  // Position of TXCHR field.
	DBGU_THR_TXCHR_Msk = 0xff // Bit mask of TXCHR field.

	// BRGR: Baud Rate Generator Register
	DBGU_BRGR_CD_Pos = 0x0    // Position of CD field.
	DBGU_BRGR_CD_Msk = 0xffff // Bit mask of CD field.

	// CIDR: Chip ID Register
	DBGU_CIDR_VERSION_Pos = 0x0        // Position of VERSION field.
	DBGU_CIDR_VERSION_Msk = 0x1f       // Bit mask of VERSION field.
	DBGU_CIDR_EPROC_Pos   = 0x5        // Position of EPROC field.
	DBGU_CIDR_EPROC_Msk   = 0xe0       // Bit mask of EPROC field.
	DBGU_CIDR_NVPSIZ_Pos  = 0x8        // Position of NVPSIZ field.
	DBGU_CIDR_NVPSIZ_Msk  = 0xf00      // Bit mask of NVPSIZ field.
	DBGU_CIDR_NVPSIZ2_Pos = 0xc        // Position of NVPSIZ2 field.
	DBGU_CIDR_NVPSIZ2_Msk = 0xf000     // Bit mask of NVPSIZ2 field.
	DBGU_CIDR_SRAMSIZ_Pos = 0x10       // Position of SRAMSIZ field.
	DBGU_CIDR_SRAMSIZ_Msk = 0xf0000    // Bit mask of SRAMSIZ field.
	DBGU_CIDR_ARCH_Pos    = 0x14       // Position of ARCH field.
	DBGU_CIDR_ARCH_Msk    = 0xff00000  // Bit mask of ARCH field.
	DBGU_CIDR_NVPTYP_Pos  = 0x1c       // Position of NVPTYP field.
	DBGU_CIDR_NVPTYP_Msk  = 0x70000000 // Bit mask of NVPTYP field.
	DBGU_CIDR_EXT_Pos     = 0x1f       // Position of EXT field.
	DBGU_CIDR_EXT_Msk     = 0x80000000 // Bit mask of EXT field.
	DBGU_CIDR_EXT         = 0x80000000 // Bit EXT.

	// EXID: Chip ID Extension Register
	DBGU_EXID_EXID_Pos = 0x0        // Position of EXID field.
	DBGU_EXID_EXID_Msk = 0xffffffff // Bit mask of EXID field.

	// FNR: Force NTRST Register
	DBGU_FNR_FNTRST_Pos = 0x0 // Position of FNTRST field.
	DBGU_FNR_FNTRST_Msk = 0x1 // Bit mask of FNTRST field.
	DBGU_FNR_FNTRST     = 0x1 // Bit FNTRST.

	// RPR: Receive Pointer Register
	DBGU_RPR_RXPTR_Pos = 0x0        // Position of RXPTR field.
	DBGU_RPR_RXPTR_Msk = 0xffffffff // Bit mask of RXPTR field.

	// RCR: Receive Counter Register
	DBGU_RCR_RXCTR_Pos = 0x0    // Position of RXCTR field.
	DBGU_RCR_RXCTR_Msk = 0xffff // Bit mask of RXCTR field.

	// TPR: Transmit Pointer Register
	DBGU_TPR_TXPTR_Pos = 0x0        // Position of TXPTR field.
	DBGU_TPR_TXPTR_Msk = 0xffffffff // Bit mask of TXPTR field.

	// TCR: Transmit Counter Register
	DBGU_TCR_TXCTR_Pos = 0x0    // Position of TXCTR field.
	DBGU_TCR_TXCTR_Msk = 0xffff // Bit mask of TXCTR field.

	// RNPR: Receive Next Pointer Register
	DBGU_RNPR_RXNPTR_Pos = 0x0        // Position of RXNPTR field.
	DBGU_RNPR_RXNPTR_Msk = 0xffffffff // Bit mask of RXNPTR field.

	// RNCR: Receive Next Counter Register
	DBGU_RNCR_RXNCTR_Pos = 0x0    // Position of RXNCTR field.
	DBGU_RNCR_RXNCTR_Msk = 0xffff // Bit mask of RXNCTR field.

	// TNPR: Transmit Next Pointer Register
	DBGU_TNPR_TXNPTR_Pos = 0x0        // Position of TXNPTR field.
	DBGU_TNPR_TXNPTR_Msk = 0xffffffff // Bit mask of TXNPTR field.

	// TNCR: Transmit Next Counter Register
	DBGU_TNCR_TXNCTR_Pos = 0x0    // Position of TXNCTR field.
	DBGU_TNCR_TXNCTR_Msk = 0xffff // Bit mask of TXNCTR field.

	// PTCR: Transfer Control Register
	DBGU_PTCR_RXTEN_Pos  = 0x0   // Position of RXTEN field.
	DBGU_PTCR_RXTEN_Msk  = 0x1   // Bit mask of RXTEN field.
	DBGU_PTCR_RXTEN      = 0x1   // Bit RXTEN.
	DBGU_PTCR_RXTDIS_Pos = 0x1   // Position of RXTDIS field.
	DBGU_PTCR_RXTDIS_Msk = 0x2   // Bit mask of RXTDIS field.
	DBGU_PTCR_RXTDIS     = 0x2   // Bit RXTDIS.
	DBGU_PTCR_TXTEN_Pos  = 0x8   // Position of TXTEN field.
	DBGU_PTCR_TXTEN_Msk  = 0x100 // Bit mask of TXTEN field.
	DBGU_PTCR_TXTEN      = 0x100 // Bit TXTEN.
	DBGU_PTCR_TXTDIS_Pos = 0x9   // Position of TXTDIS field.
	DBGU_PTCR_TXTDIS_Msk = 0x200 // Bit mask of TXTDIS field.
	DBGU_PTCR_TXTDIS     = 0x200 // Bit TXTDIS.

	// PTSR: Transfer Status Register
	DBGU_PTSR_RXTEN_Pos = 0x0   // Position of RXTEN field.
	DBGU_PTSR_RXTEN_Msk = 0x1   // Bit mask of RXTEN field.
	DBGU_PTSR_RXTEN     = 0x1   // Bit RXTEN.
	DBGU_PTSR_TXTEN_Pos = 0x8   // Position of TXTEN field.
	DBGU_PTSR_TXTEN_Msk = 0x100 // Bit mask of TXTEN field.
	DBGU_PTSR_TXTEN     = 0x100 // Bit TXTEN.
)

// Bitfields for AIC: Advanced Interrupt Controller
const (
	// SMR: Source Mode Register
	AIC_SMR_PRIOR_Pos   = 0x0  // Position of PRIOR field.
	AIC_SMR_PRIOR_Msk   = 0x7  // Bit mask of PRIOR field.
	AIC_SMR_SRCTYPE_Pos = 0x5  // Position of SRCTYPE field.
	AIC_SMR_SRCTYPE_Msk = 0x60 // Bit mask of SRCTYPE field.

	// SVR: Source Vector Register
	AIC_SVR_VECTOR_Pos = 0x0        // Position of VECTOR field.
	AIC_SVR_VECTOR_Msk = 0xffffffff // Bit mask of VECTOR field.

	// IVR: Interrupt Vector Register
	AIC_IVR_IRQV_Pos = 0x0        // Position of IRQV field.
	AIC_IVR_IRQV_Msk = 0xffffffff // Bit mask of IRQV field.

	// FVR: FIQ Interrupt Vector Register
	AIC_FVR_FIQV_Pos = 0x0        // Position of FIQV field.
	AIC_FVR_FIQV_Msk = 0xffffffff // Bit mask of FIQV field.

	// ISR: Interrupt Status Register
	AIC_ISR_IRQID_Pos = 0x0  // Position of IRQID field.
	AIC_ISR_IRQID_Msk = 0x1f // Bit mask of IRQID field.

	// IPR: Interrupt Pending Register
	AIC_IPR_FIQ_Pos   = 0x0        // Position of FIQ field.
	AIC_IPR_FIQ_Msk   = 0x1        // Bit mask of FIQ field.
	AIC_IPR_FIQ       = 0x1        // Bit FIQ.
	AIC_IPR_SYS_Pos   = 0x1        // Position of SYS field.
	AIC_IPR_SYS_Msk   = 0x2        // Bit mask of SYS field.
	AIC_IPR_SYS       = 0x2        // Bit SYS.
	AIC_IPR_PID2_Pos  = 0x2        // Position of PID2 field.
	AIC_IPR_PID2_Msk  = 0x4        // Bit mask of PID2 field.
	AIC_IPR_PID2      = 0x4        // Bit PID2.
	AIC_IPR_PID3_Pos  = 0x3        // Position of PID3 field.
	AIC_IPR_PID3_Msk  = 0x8        // Bit mask of PID3 field.
	AIC_IPR_PID3      = 0x8        // Bit PID3.
	AIC_IPR_PID4_Pos  = 0x4        // Position of PID4 field.
	AIC_IPR_PID4_Msk  = 0x10       // Bit mask of PID4 field.
	AIC_IPR_PID4      = 0x10       // Bit PID4.
	AIC_IPR_PID5_Pos  = 0x5        // Position of PID5 field.
	AIC_IPR_PID5_Msk  = 0x20       // Bit mask of PID5 field.
	AIC_IPR_PID5      = 0x20       // Bit PID5.
	AIC_IPR_PID6_Pos  = 0x6        // Position of PID6 field.
	AIC_IPR_PID6_Msk  = 0x40       // Bit mask of PID6 field.
	AIC_IPR_PID6      = 0x40       // Bit PID6.
	AIC_IPR_PID7_Pos  = 0x7        // Position of PID7 field.
	AIC_IPR_PID7_Msk  = 0x80       // Bit mask of PID7 field.
	AIC_IPR_PID7      = 0x80       // Bit PID7.
	AIC_IPR_PID8_Pos  = 0x8        // Position of PID8 field.
	AIC_IPR_PID8_Msk  = 0x100      // Bit mask of PID8 field.
	AIC_IPR_PID8      = 0x100      // Bit PID8.
	AIC_IPR_PID9_Pos  = 0x9        // Position of PID9 field.
	AIC_IPR_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	AIC_IPR_PID9      = 0x200      // Bit PID9.
	AIC_IPR_PID10_Pos = 0xa        // Position of PID10 field.
	AIC_IPR_PID10_Msk = 0x400      // Bit mask of PID10 field.
	AIC_IPR_PID10     = 0x400      // Bit PID10.
	AIC_IPR_PID11_Pos = 0xb        // Position of PID11 field.
	AIC_IPR_PID11_Msk = 0x800      // Bit mask of PID11 field.
	AIC_IPR_PID11     = 0x800      // Bit PID11.
	AIC_IPR_PID12_Pos = 0xc        // Position of PID12 field.
	AIC_IPR_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	AIC_IPR_PID12     = 0x1000     // Bit PID12.
	AIC_IPR_PID13_Pos = 0xd        // Position of PID13 field.
	AIC_IPR_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	AIC_IPR_PID13     = 0x2000     // Bit PID13.
	AIC_IPR_PID14_Pos = 0xe        // Position of PID14 field.
	AIC_IPR_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	AIC_IPR_PID14     = 0x4000     // Bit PID14.
	AIC_IPR_PID15_Pos = 0xf        // Position of PID15 field.
	AIC_IPR_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	AIC_IPR_PID15     = 0x8000     // Bit PID15.
	AIC_IPR_PID16_Pos = 0x10       // Position of PID16 field.
	AIC_IPR_PID16_Msk = 0x10000    // Bit mask of PID16 field.
	AIC_IPR_PID16     = 0x10000    // Bit PID16.
	AIC_IPR_PID17_Pos = 0x11       // Position of PID17 field.
	AIC_IPR_PID17_Msk = 0x20000    // Bit mask of PID17 field.
	AIC_IPR_PID17     = 0x20000    // Bit PID17.
	AIC_IPR_PID18_Pos = 0x12       // Position of PID18 field.
	AIC_IPR_PID18_Msk = 0x40000    // Bit mask of PID18 field.
	AIC_IPR_PID18     = 0x40000    // Bit PID18.
	AIC_IPR_PID19_Pos = 0x13       // Position of PID19 field.
	AIC_IPR_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	AIC_IPR_PID19     = 0x80000    // Bit PID19.
	AIC_IPR_PID20_Pos = 0x14       // Position of PID20 field.
	AIC_IPR_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	AIC_IPR_PID20     = 0x100000   // Bit PID20.
	AIC_IPR_PID21_Pos = 0x15       // Position of PID21 field.
	AIC_IPR_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	AIC_IPR_PID21     = 0x200000   // Bit PID21.
	AIC_IPR_PID22_Pos = 0x16       // Position of PID22 field.
	AIC_IPR_PID22_Msk = 0x400000   // Bit mask of PID22 field.
	AIC_IPR_PID22     = 0x400000   // Bit PID22.
	AIC_IPR_PID23_Pos = 0x17       // Position of PID23 field.
	AIC_IPR_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	AIC_IPR_PID23     = 0x800000   // Bit PID23.
	AIC_IPR_PID24_Pos = 0x18       // Position of PID24 field.
	AIC_IPR_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	AIC_IPR_PID24     = 0x1000000  // Bit PID24.
	AIC_IPR_PID25_Pos = 0x19       // Position of PID25 field.
	AIC_IPR_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	AIC_IPR_PID25     = 0x2000000  // Bit PID25.
	AIC_IPR_PID26_Pos = 0x1a       // Position of PID26 field.
	AIC_IPR_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	AIC_IPR_PID26     = 0x4000000  // Bit PID26.
	AIC_IPR_PID27_Pos = 0x1b       // Position of PID27 field.
	AIC_IPR_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	AIC_IPR_PID27     = 0x8000000  // Bit PID27.
	AIC_IPR_PID28_Pos = 0x1c       // Position of PID28 field.
	AIC_IPR_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	AIC_IPR_PID28     = 0x10000000 // Bit PID28.
	AIC_IPR_PID29_Pos = 0x1d       // Position of PID29 field.
	AIC_IPR_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	AIC_IPR_PID29     = 0x20000000 // Bit PID29.
	AIC_IPR_PID30_Pos = 0x1e       // Position of PID30 field.
	AIC_IPR_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	AIC_IPR_PID30     = 0x40000000 // Bit PID30.
	AIC_IPR_PID31_Pos = 0x1f       // Position of PID31 field.
	AIC_IPR_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	AIC_IPR_PID31     = 0x80000000 // Bit PID31.

	// IMR: Interrupt Mask Register
	AIC_IMR_FIQ_Pos   = 0x0        // Position of FIQ field.
	AIC_IMR_FIQ_Msk   = 0x1        // Bit mask of FIQ field.
	AIC_IMR_FIQ       = 0x1        // Bit FIQ.
	AIC_IMR_SYS_Pos   = 0x1        // Position of SYS field.
	AIC_IMR_SYS_Msk   = 0x2        // Bit mask of SYS field.
	AIC_IMR_SYS       = 0x2        // Bit SYS.
	AIC_IMR_PID2_Pos  = 0x2        // Position of PID2 field.
	AIC_IMR_PID2_Msk  = 0x4        // Bit mask of PID2 field.
	AIC_IMR_PID2      = 0x4        // Bit PID2.
	AIC_IMR_PID3_Pos  = 0x3        // Position of PID3 field.
	AIC_IMR_PID3_Msk  = 0x8        // Bit mask of PID3 field.
	AIC_IMR_PID3      = 0x8        // Bit PID3.
	AIC_IMR_PID4_Pos  = 0x4        // Position of PID4 field.
	AIC_IMR_PID4_Msk  = 0x10       // Bit mask of PID4 field.
	AIC_IMR_PID4      = 0x10       // Bit PID4.
	AIC_IMR_PID5_Pos  = 0x5        // Position of PID5 field.
	AIC_IMR_PID5_Msk  = 0x20       // Bit mask of PID5 field.
	AIC_IMR_PID5      = 0x20       // Bit PID5.
	AIC_IMR_PID6_Pos  = 0x6        // Position of PID6 field.
	AIC_IMR_PID6_Msk  = 0x40       // Bit mask of PID6 field.
	AIC_IMR_PID6      = 0x40       // Bit PID6.
	AIC_IMR_PID7_Pos  = 0x7        // Position of PID7 field.
	AIC_IMR_PID7_Msk  = 0x80       // Bit mask of PID7 field.
	AIC_IMR_PID7      = 0x80       // Bit PID7.
	AIC_IMR_PID8_Pos  = 0x8        // Position of PID8 field.
	AIC_IMR_PID8_Msk  = 0x100      // Bit mask of PID8 field.
	AIC_IMR_PID8      = 0x100      // Bit PID8.
	AIC_IMR_PID9_Pos  = 0x9        // Position of PID9 field.
	AIC_IMR_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	AIC_IMR_PID9      = 0x200      // Bit PID9.
	AIC_IMR_PID10_Pos = 0xa        // Position of PID10 field.
	AIC_IMR_PID10_Msk = 0x400      // Bit mask of PID10 field.
	AIC_IMR_PID10     = 0x400      // Bit PID10.
	AIC_IMR_PID11_Pos = 0xb        // Position of PID11 field.
	AIC_IMR_PID11_Msk = 0x800      // Bit mask of PID11 field.
	AIC_IMR_PID11     = 0x800      // Bit PID11.
	AIC_IMR_PID12_Pos = 0xc        // Position of PID12 field.
	AIC_IMR_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	AIC_IMR_PID12     = 0x1000     // Bit PID12.
	AIC_IMR_PID13_Pos = 0xd        // Position of PID13 field.
	AIC_IMR_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	AIC_IMR_PID13     = 0x2000     // Bit PID13.
	AIC_IMR_PID14_Pos = 0xe        // Position of PID14 field.
	AIC_IMR_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	AIC_IMR_PID14     = 0x4000     // Bit PID14.
	AIC_IMR_PID15_Pos = 0xf        // Position of PID15 field.
	AIC_IMR_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	AIC_IMR_PID15     = 0x8000     // Bit PID15.
	AIC_IMR_PID16_Pos = 0x10       // Position of PID16 field.
	AIC_IMR_PID16_Msk = 0x10000    // Bit mask of PID16 field.
	AIC_IMR_PID16     = 0x10000    // Bit PID16.
	AIC_IMR_PID17_Pos = 0x11       // Position of PID17 field.
	AIC_IMR_PID17_Msk = 0x20000    // Bit mask of PID17 field.
	AIC_IMR_PID17     = 0x20000    // Bit PID17.
	AIC_IMR_PID18_Pos = 0x12       // Position of PID18 field.
	AIC_IMR_PID18_Msk = 0x40000    // Bit mask of PID18 field.
	AIC_IMR_PID18     = 0x40000    // Bit PID18.
	AIC_IMR_PID19_Pos = 0x13       // Position of PID19 field.
	AIC_IMR_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	AIC_IMR_PID19     = 0x80000    // Bit PID19.
	AIC_IMR_PID20_Pos = 0x14       // Position of PID20 field.
	AIC_IMR_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	AIC_IMR_PID20     = 0x100000   // Bit PID20.
	AIC_IMR_PID21_Pos = 0x15       // Position of PID21 field.
	AIC_IMR_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	AIC_IMR_PID21     = 0x200000   // Bit PID21.
	AIC_IMR_PID22_Pos = 0x16       // Position of PID22 field.
	AIC_IMR_PID22_Msk = 0x400000   // Bit mask of PID22 field.
	AIC_IMR_PID22     = 0x400000   // Bit PID22.
	AIC_IMR_PID23_Pos = 0x17       // Position of PID23 field.
	AIC_IMR_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	AIC_IMR_PID23     = 0x800000   // Bit PID23.
	AIC_IMR_PID24_Pos = 0x18       // Position of PID24 field.
	AIC_IMR_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	AIC_IMR_PID24     = 0x1000000  // Bit PID24.
	AIC_IMR_PID25_Pos = 0x19       // Position of PID25 field.
	AIC_IMR_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	AIC_IMR_PID25     = 0x2000000  // Bit PID25.
	AIC_IMR_PID26_Pos = 0x1a       // Position of PID26 field.
	AIC_IMR_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	AIC_IMR_PID26     = 0x4000000  // Bit PID26.
	AIC_IMR_PID27_Pos = 0x1b       // Position of PID27 field.
	AIC_IMR_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	AIC_IMR_PID27     = 0x8000000  // Bit PID27.
	AIC_IMR_PID28_Pos = 0x1c       // Position of PID28 field.
	AIC_IMR_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	AIC_IMR_PID28     = 0x10000000 // Bit PID28.
	AIC_IMR_PID29_Pos = 0x1d       // Position of PID29 field.
	AIC_IMR_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	AIC_IMR_PID29     = 0x20000000 // Bit PID29.
	AIC_IMR_PID30_Pos = 0x1e       // Position of PID30 field.
	AIC_IMR_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	AIC_IMR_PID30     = 0x40000000 // Bit PID30.
	AIC_IMR_PID31_Pos = 0x1f       // Position of PID31 field.
	AIC_IMR_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	AIC_IMR_PID31     = 0x80000000 // Bit PID31.

	// CISR: Core Interrupt Status Register
	AIC_CISR_NFIQ_Pos = 0x0 // Position of NFIQ field.
	AIC_CISR_NFIQ_Msk = 0x1 // Bit mask of NFIQ field.
	AIC_CISR_NFIQ     = 0x1 // Bit NFIQ.
	AIC_CISR_NIRQ_Pos = 0x1 // Position of NIRQ field.
	AIC_CISR_NIRQ_Msk = 0x2 // Bit mask of NIRQ field.
	AIC_CISR_NIRQ     = 0x2 // Bit NIRQ.

	// IECR: Interrupt Enable Command Register
	AIC_IECR_FIQ_Pos   = 0x0        // Position of FIQ field.
	AIC_IECR_FIQ_Msk   = 0x1        // Bit mask of FIQ field.
	AIC_IECR_FIQ       = 0x1        // Bit FIQ.
	AIC_IECR_SYS_Pos   = 0x1        // Position of SYS field.
	AIC_IECR_SYS_Msk   = 0x2        // Bit mask of SYS field.
	AIC_IECR_SYS       = 0x2        // Bit SYS.
	AIC_IECR_PID2_Pos  = 0x2        // Position of PID2 field.
	AIC_IECR_PID2_Msk  = 0x4        // Bit mask of PID2 field.
	AIC_IECR_PID2      = 0x4        // Bit PID2.
	AIC_IECR_PID3_Pos  = 0x3        // Position of PID3 field.
	AIC_IECR_PID3_Msk  = 0x8        // Bit mask of PID3 field.
	AIC_IECR_PID3      = 0x8        // Bit PID3.
	AIC_IECR_PID4_Pos  = 0x4        // Position of PID4 field.
	AIC_IECR_PID4_Msk  = 0x10       // Bit mask of PID4 field.
	AIC_IECR_PID4      = 0x10       // Bit PID4.
	AIC_IECR_PID5_Pos  = 0x5        // Position of PID5 field.
	AIC_IECR_PID5_Msk  = 0x20       // Bit mask of PID5 field.
	AIC_IECR_PID5      = 0x20       // Bit PID5.
	AIC_IECR_PID6_Pos  = 0x6        // Position of PID6 field.
	AIC_IECR_PID6_Msk  = 0x40       // Bit mask of PID6 field.
	AIC_IECR_PID6      = 0x40       // Bit PID6.
	AIC_IECR_PID7_Pos  = 0x7        // Position of PID7 field.
	AIC_IECR_PID7_Msk  = 0x80       // Bit mask of PID7 field.
	AIC_IECR_PID7      = 0x80       // Bit PID7.
	AIC_IECR_PID8_Pos  = 0x8        // Position of PID8 field.
	AIC_IECR_PID8_Msk  = 0x100      // Bit mask of PID8 field.
	AIC_IECR_PID8      = 0x100      // Bit PID8.
	AIC_IECR_PID9_Pos  = 0x9        // Position of PID9 field.
	AIC_IECR_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	AIC_IECR_PID9      = 0x200      // Bit PID9.
	AIC_IECR_PID10_Pos = 0xa        // Position of PID10 field.
	AIC_IECR_PID10_Msk = 0x400      // Bit mask of PID10 field.
	AIC_IECR_PID10     = 0x400      // Bit PID10.
	AIC_IECR_PID11_Pos = 0xb        // Position of PID11 field.
	AIC_IECR_PID11_Msk = 0x800      // Bit mask of PID11 field.
	AIC_IECR_PID11     = 0x800      // Bit PID11.
	AIC_IECR_PID12_Pos = 0xc        // Position of PID12 field.
	AIC_IECR_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	AIC_IECR_PID12     = 0x1000     // Bit PID12.
	AIC_IECR_PID13_Pos = 0xd        // Position of PID13 field.
	AIC_IECR_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	AIC_IECR_PID13     = 0x2000     // Bit PID13.
	AIC_IECR_PID14_Pos = 0xe        // Position of PID14 field.
	AIC_IECR_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	AIC_IECR_PID14     = 0x4000     // Bit PID14.
	AIC_IECR_PID15_Pos = 0xf        // Position of PID15 field.
	AIC_IECR_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	AIC_IECR_PID15     = 0x8000     // Bit PID15.
	AIC_IECR_PID16_Pos = 0x10       // Position of PID16 field.
	AIC_IECR_PID16_Msk = 0x10000    // Bit mask of PID16 field.
	AIC_IECR_PID16     = 0x10000    // Bit PID16.
	AIC_IECR_PID17_Pos = 0x11       // Position of PID17 field.
	AIC_IECR_PID17_Msk = 0x20000    // Bit mask of PID17 field.
	AIC_IECR_PID17     = 0x20000    // Bit PID17.
	AIC_IECR_PID18_Pos = 0x12       // Position of PID18 field.
	AIC_IECR_PID18_Msk = 0x40000    // Bit mask of PID18 field.
	AIC_IECR_PID18     = 0x40000    // Bit PID18.
	AIC_IECR_PID19_Pos = 0x13       // Position of PID19 field.
	AIC_IECR_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	AIC_IECR_PID19     = 0x80000    // Bit PID19.
	AIC_IECR_PID20_Pos = 0x14       // Position of PID20 field.
	AIC_IECR_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	AIC_IECR_PID20     = 0x100000   // Bit PID20.
	AIC_IECR_PID21_Pos = 0x15       // Position of PID21 field.
	AIC_IECR_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	AIC_IECR_PID21     = 0x200000   // Bit PID21.
	AIC_IECR_PID22_Pos = 0x16       // Position of PID22 field.
	AIC_IECR_PID22_Msk = 0x400000   // Bit mask of PID22 field.
	AIC_IECR_PID22     = 0x400000   // Bit PID22.
	AIC_IECR_PID23_Pos = 0x17       // Position of PID23 field.
	AIC_IECR_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	AIC_IECR_PID23     = 0x800000   // Bit PID23.
	AIC_IECR_PID24_Pos = 0x18       // Position of PID24 field.
	AIC_IECR_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	AIC_IECR_PID24     = 0x1000000  // Bit PID24.
	AIC_IECR_PID25_Pos = 0x19       // Position of PID25 field.
	AIC_IECR_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	AIC_IECR_PID25     = 0x2000000  // Bit PID25.
	AIC_IECR_PID26_Pos = 0x1a       // Position of PID26 field.
	AIC_IECR_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	AIC_IECR_PID26     = 0x4000000  // Bit PID26.
	AIC_IECR_PID27_Pos = 0x1b       // Position of PID27 field.
	AIC_IECR_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	AIC_IECR_PID27     = 0x8000000  // Bit PID27.
	AIC_IECR_PID28_Pos = 0x1c       // Position of PID28 field.
	AIC_IECR_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	AIC_IECR_PID28     = 0x10000000 // Bit PID28.
	AIC_IECR_PID29_Pos = 0x1d       // Position of PID29 field.
	AIC_IECR_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	AIC_IECR_PID29     = 0x20000000 // Bit PID29.
	AIC_IECR_PID30_Pos = 0x1e       // Position of PID30 field.
	AIC_IECR_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	AIC_IECR_PID30     = 0x40000000 // Bit PID30.
	AIC_IECR_PID31_Pos = 0x1f       // Position of PID31 field.
	AIC_IECR_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	AIC_IECR_PID31     = 0x80000000 // Bit PID31.

	// IDCR: Interrupt Disable Command Register
	AIC_IDCR_FIQ_Pos   = 0x0        // Position of FIQ field.
	AIC_IDCR_FIQ_Msk   = 0x1        // Bit mask of FIQ field.
	AIC_IDCR_FIQ       = 0x1        // Bit FIQ.
	AIC_IDCR_SYS_Pos   = 0x1        // Position of SYS field.
	AIC_IDCR_SYS_Msk   = 0x2        // Bit mask of SYS field.
	AIC_IDCR_SYS       = 0x2        // Bit SYS.
	AIC_IDCR_PID2_Pos  = 0x2        // Position of PID2 field.
	AIC_IDCR_PID2_Msk  = 0x4        // Bit mask of PID2 field.
	AIC_IDCR_PID2      = 0x4        // Bit PID2.
	AIC_IDCR_PID3_Pos  = 0x3        // Position of PID3 field.
	AIC_IDCR_PID3_Msk  = 0x8        // Bit mask of PID3 field.
	AIC_IDCR_PID3      = 0x8        // Bit PID3.
	AIC_IDCR_PID4_Pos  = 0x4        // Position of PID4 field.
	AIC_IDCR_PID4_Msk  = 0x10       // Bit mask of PID4 field.
	AIC_IDCR_PID4      = 0x10       // Bit PID4.
	AIC_IDCR_PID5_Pos  = 0x5        // Position of PID5 field.
	AIC_IDCR_PID5_Msk  = 0x20       // Bit mask of PID5 field.
	AIC_IDCR_PID5      = 0x20       // Bit PID5.
	AIC_IDCR_PID6_Pos  = 0x6        // Position of PID6 field.
	AIC_IDCR_PID6_Msk  = 0x40       // Bit mask of PID6 field.
	AIC_IDCR_PID6      = 0x40       // Bit PID6.
	AIC_IDCR_PID7_Pos  = 0x7        // Position of PID7 field.
	AIC_IDCR_PID7_Msk  = 0x80       // Bit mask of PID7 field.
	AIC_IDCR_PID7      = 0x80       // Bit PID7.
	AIC_IDCR_PID8_Pos  = 0x8        // Position of PID8 field.
	AIC_IDCR_PID8_Msk  = 0x100      // Bit mask of PID8 field.
	AIC_IDCR_PID8      = 0x100      // Bit PID8.
	AIC_IDCR_PID9_Pos  = 0x9        // Position of PID9 field.
	AIC_IDCR_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	AIC_IDCR_PID9      = 0x200      // Bit PID9.
	AIC_IDCR_PID10_Pos = 0xa        // Position of PID10 field.
	AIC_IDCR_PID10_Msk = 0x400      // Bit mask of PID10 field.
	AIC_IDCR_PID10     = 0x400      // Bit PID10.
	AIC_IDCR_PID11_Pos = 0xb        // Position of PID11 field.
	AIC_IDCR_PID11_Msk = 0x800      // Bit mask of PID11 field.
	AIC_IDCR_PID11     = 0x800      // Bit PID11.
	AIC_IDCR_PID12_Pos = 0xc        // Position of PID12 field.
	AIC_IDCR_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	AIC_IDCR_PID12     = 0x1000     // Bit PID12.
	AIC_IDCR_PID13_Pos = 0xd        // Position of PID13 field.
	AIC_IDCR_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	AIC_IDCR_PID13     = 0x2000     // Bit PID13.
	AIC_IDCR_PID14_Pos = 0xe        // Position of PID14 field.
	AIC_IDCR_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	AIC_IDCR_PID14     = 0x4000     // Bit PID14.
	AIC_IDCR_PID15_Pos = 0xf        // Position of PID15 field.
	AIC_IDCR_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	AIC_IDCR_PID15     = 0x8000     // Bit PID15.
	AIC_IDCR_PID16_Pos = 0x10       // Position of PID16 field.
	AIC_IDCR_PID16_Msk = 0x10000    // Bit mask of PID16 field.
	AIC_IDCR_PID16     = 0x10000    // Bit PID16.
	AIC_IDCR_PID17_Pos = 0x11       // Position of PID17 field.
	AIC_IDCR_PID17_Msk = 0x20000    // Bit mask of PID17 field.
	AIC_IDCR_PID17     = 0x20000    // Bit PID17.
	AIC_IDCR_PID18_Pos = 0x12       // Position of PID18 field.
	AIC_IDCR_PID18_Msk = 0x40000    // Bit mask of PID18 field.
	AIC_IDCR_PID18     = 0x40000    // Bit PID18.
	AIC_IDCR_PID19_Pos = 0x13       // Position of PID19 field.
	AIC_IDCR_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	AIC_IDCR_PID19     = 0x80000    // Bit PID19.
	AIC_IDCR_PID20_Pos = 0x14       // Position of PID20 field.
	AIC_IDCR_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	AIC_IDCR_PID20     = 0x100000   // Bit PID20.
	AIC_IDCR_PID21_Pos = 0x15       // Position of PID21 field.
	AIC_IDCR_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	AIC_IDCR_PID21     = 0x200000   // Bit PID21.
	AIC_IDCR_PID22_Pos = 0x16       // Position of PID22 field.
	AIC_IDCR_PID22_Msk = 0x400000   // Bit mask of PID22 field.
	AIC_IDCR_PID22     = 0x400000   // Bit PID22.
	AIC_IDCR_PID23_Pos = 0x17       // Position of PID23 field.
	AIC_IDCR_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	AIC_IDCR_PID23     = 0x800000   // Bit PID23.
	AIC_IDCR_PID24_Pos = 0x18       // Position of PID24 field.
	AIC_IDCR_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	AIC_IDCR_PID24     = 0x1000000  // Bit PID24.
	AIC_IDCR_PID25_Pos = 0x19       // Position of PID25 field.
	AIC_IDCR_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	AIC_IDCR_PID25     = 0x2000000  // Bit PID25.
	AIC_IDCR_PID26_Pos = 0x1a       // Position of PID26 field.
	AIC_IDCR_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	AIC_IDCR_PID26     = 0x4000000  // Bit PID26.
	AIC_IDCR_PID27_Pos = 0x1b       // Position of PID27 field.
	AIC_IDCR_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	AIC_IDCR_PID27     = 0x8000000  // Bit PID27.
	AIC_IDCR_PID28_Pos = 0x1c       // Position of PID28 field.
	AIC_IDCR_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	AIC_IDCR_PID28     = 0x10000000 // Bit PID28.
	AIC_IDCR_PID29_Pos = 0x1d       // Position of PID29 field.
	AIC_IDCR_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	AIC_IDCR_PID29     = 0x20000000 // Bit PID29.
	AIC_IDCR_PID30_Pos = 0x1e       // Position of PID30 field.
	AIC_IDCR_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	AIC_IDCR_PID30     = 0x40000000 // Bit PID30.
	AIC_IDCR_PID31_Pos = 0x1f       // Position of PID31 field.
	AIC_IDCR_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	AIC_IDCR_PID31     = 0x80000000 // Bit PID31.

	// ICCR: Interrupt Clear Command Register
	AIC_ICCR_FIQ_Pos   = 0x0        // Position of FIQ field.
	AIC_ICCR_FIQ_Msk   = 0x1        // Bit mask of FIQ field.
	AIC_ICCR_FIQ       = 0x1        // Bit FIQ.
	AIC_ICCR_SYS_Pos   = 0x1        // Position of SYS field.
	AIC_ICCR_SYS_Msk   = 0x2        // Bit mask of SYS field.
	AIC_ICCR_SYS       = 0x2        // Bit SYS.
	AIC_ICCR_PID2_Pos  = 0x2        // Position of PID2 field.
	AIC_ICCR_PID2_Msk  = 0x4        // Bit mask of PID2 field.
	AIC_ICCR_PID2      = 0x4        // Bit PID2.
	AIC_ICCR_PID3_Pos  = 0x3        // Position of PID3 field.
	AIC_ICCR_PID3_Msk  = 0x8        // Bit mask of PID3 field.
	AIC_ICCR_PID3      = 0x8        // Bit PID3.
	AIC_ICCR_PID4_Pos  = 0x4        // Position of PID4 field.
	AIC_ICCR_PID4_Msk  = 0x10       // Bit mask of PID4 field.
	AIC_ICCR_PID4      = 0x10       // Bit PID4.
	AIC_ICCR_PID5_Pos  = 0x5        // Position of PID5 field.
	AIC_ICCR_PID5_Msk  = 0x20       // Bit mask of PID5 field.
	AIC_ICCR_PID5      = 0x20       // Bit PID5.
	AIC_ICCR_PID6_Pos  = 0x6        // Position of PID6 field.
	AIC_ICCR_PID6_Msk  = 0x40       // Bit mask of PID6 field.
	AIC_ICCR_PID6      = 0x40       // Bit PID6.
	AIC_ICCR_PID7_Pos  = 0x7        // Position of PID7 field.
	AIC_ICCR_PID7_Msk  = 0x80       // Bit mask of PID7 field.
	AIC_ICCR_PID7      = 0x80       // Bit PID7.
	AIC_ICCR_PID8_Pos  = 0x8        // Position of PID8 field.
	AIC_ICCR_PID8_Msk  = 0x100      // Bit mask of PID8 field.
	AIC_ICCR_PID8      = 0x100      // Bit PID8.
	AIC_ICCR_PID9_Pos  = 0x9        // Position of PID9 field.
	AIC_ICCR_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	AIC_ICCR_PID9      = 0x200      // Bit PID9.
	AIC_ICCR_PID10_Pos = 0xa        // Position of PID10 field.
	AIC_ICCR_PID10_Msk = 0x400      // Bit mask of PID10 field.
	AIC_ICCR_PID10     = 0x400      // Bit PID10.
	AIC_ICCR_PID11_Pos = 0xb        // Position of PID11 field.
	AIC_ICCR_PID11_Msk = 0x800      // Bit mask of PID11 field.
	AIC_ICCR_PID11     = 0x800      // Bit PID11.
	AIC_ICCR_PID12_Pos = 0xc        // Position of PID12 field.
	AIC_ICCR_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	AIC_ICCR_PID12     = 0x1000     // Bit PID12.
	AIC_ICCR_PID13_Pos = 0xd        // Position of PID13 field.
	AIC_ICCR_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	AIC_ICCR_PID13     = 0x2000     // Bit PID13.
	AIC_ICCR_PID14_Pos = 0xe        // Position of PID14 field.
	AIC_ICCR_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	AIC_ICCR_PID14     = 0x4000     // Bit PID14.
	AIC_ICCR_PID15_Pos = 0xf        // Position of PID15 field.
	AIC_ICCR_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	AIC_ICCR_PID15     = 0x8000     // Bit PID15.
	AIC_ICCR_PID16_Pos = 0x10       // Position of PID16 field.
	AIC_ICCR_PID16_Msk = 0x10000    // Bit mask of PID16 field.
	AIC_ICCR_PID16     = 0x10000    // Bit PID16.
	AIC_ICCR_PID17_Pos = 0x11       // Position of PID17 field.
	AIC_ICCR_PID17_Msk = 0x20000    // Bit mask of PID17 field.
	AIC_ICCR_PID17     = 0x20000    // Bit PID17.
	AIC_ICCR_PID18_Pos = 0x12       // Position of PID18 field.
	AIC_ICCR_PID18_Msk = 0x40000    // Bit mask of PID18 field.
	AIC_ICCR_PID18     = 0x40000    // Bit PID18.
	AIC_ICCR_PID19_Pos = 0x13       // Position of PID19 field.
	AIC_ICCR_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	AIC_ICCR_PID19     = 0x80000    // Bit PID19.
	AIC_ICCR_PID20_Pos = 0x14       // Position of PID20 field.
	AIC_ICCR_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	AIC_ICCR_PID20     = 0x100000   // Bit PID20.
	AIC_ICCR_PID21_Pos = 0x15       // Position of PID21 field.
	AIC_ICCR_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	AIC_ICCR_PID21     = 0x200000   // Bit PID21.
	AIC_ICCR_PID22_Pos = 0x16       // Position of PID22 field.
	AIC_ICCR_PID22_Msk = 0x400000   // Bit mask of PID22 field.
	AIC_ICCR_PID22     = 0x400000   // Bit PID22.
	AIC_ICCR_PID23_Pos = 0x17       // Position of PID23 field.
	AIC_ICCR_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	AIC_ICCR_PID23     = 0x800000   // Bit PID23.
	AIC_ICCR_PID24_Pos = 0x18       // Position of PID24 field.
	AIC_ICCR_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	AIC_ICCR_PID24     = 0x1000000  // Bit PID24.
	AIC_ICCR_PID25_Pos = 0x19       // Position of PID25 field.
	AIC_ICCR_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	AIC_ICCR_PID25     = 0x2000000  // Bit PID25.
	AIC_ICCR_PID26_Pos = 0x1a       // Position of PID26 field.
	AIC_ICCR_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	AIC_ICCR_PID26     = 0x4000000  // Bit PID26.
	AIC_ICCR_PID27_Pos = 0x1b       // Position of PID27 field.
	AIC_ICCR_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	AIC_ICCR_PID27     = 0x8000000  // Bit PID27.
	AIC_ICCR_PID28_Pos = 0x1c       // Position of PID28 field.
	AIC_ICCR_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	AIC_ICCR_PID28     = 0x10000000 // Bit PID28.
	AIC_ICCR_PID29_Pos = 0x1d       // Position of PID29 field.
	AIC_ICCR_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	AIC_ICCR_PID29     = 0x20000000 // Bit PID29.
	AIC_ICCR_PID30_Pos = 0x1e       // Position of PID30 field.
	AIC_ICCR_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	AIC_ICCR_PID30     = 0x40000000 // Bit PID30.
	AIC_ICCR_PID31_Pos = 0x1f       // Position of PID31 field.
	AIC_ICCR_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	AIC_ICCR_PID31     = 0x80000000 // Bit PID31.

	// ISCR: Interrupt Set Command Register
	AIC_ISCR_FIQ_Pos   = 0x0        // Position of FIQ field.
	AIC_ISCR_FIQ_Msk   = 0x1        // Bit mask of FIQ field.
	AIC_ISCR_FIQ       = 0x1        // Bit FIQ.
	AIC_ISCR_SYS_Pos   = 0x1        // Position of SYS field.
	AIC_ISCR_SYS_Msk   = 0x2        // Bit mask of SYS field.
	AIC_ISCR_SYS       = 0x2        // Bit SYS.
	AIC_ISCR_PID2_Pos  = 0x2        // Position of PID2 field.
	AIC_ISCR_PID2_Msk  = 0x4        // Bit mask of PID2 field.
	AIC_ISCR_PID2      = 0x4        // Bit PID2.
	AIC_ISCR_PID3_Pos  = 0x3        // Position of PID3 field.
	AIC_ISCR_PID3_Msk  = 0x8        // Bit mask of PID3 field.
	AIC_ISCR_PID3      = 0x8        // Bit PID3.
	AIC_ISCR_PID4_Pos  = 0x4        // Position of PID4 field.
	AIC_ISCR_PID4_Msk  = 0x10       // Bit mask of PID4 field.
	AIC_ISCR_PID4      = 0x10       // Bit PID4.
	AIC_ISCR_PID5_Pos  = 0x5        // Position of PID5 field.
	AIC_ISCR_PID5_Msk  = 0x20       // Bit mask of PID5 field.
	AIC_ISCR_PID5      = 0x20       // Bit PID5.
	AIC_ISCR_PID6_Pos  = 0x6        // Position of PID6 field.
	AIC_ISCR_PID6_Msk  = 0x40       // Bit mask of PID6 field.
	AIC_ISCR_PID6      = 0x40       // Bit PID6.
	AIC_ISCR_PID7_Pos  = 0x7        // Position of PID7 field.
	AIC_ISCR_PID7_Msk  = 0x80       // Bit mask of PID7 field.
	AIC_ISCR_PID7      = 0x80       // Bit PID7.
	AIC_ISCR_PID8_Pos  = 0x8        // Position of PID8 field.
	AIC_ISCR_PID8_Msk  = 0x100      // Bit mask of PID8 field.
	AIC_ISCR_PID8      = 0x100      // Bit PID8.
	AIC_ISCR_PID9_Pos  = 0x9        // Position of PID9 field.
	AIC_ISCR_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	AIC_ISCR_PID9      = 0x200      // Bit PID9.
	AIC_ISCR_PID10_Pos = 0xa        // Position of PID10 field.
	AIC_ISCR_PID10_Msk = 0x400      // Bit mask of PID10 field.
	AIC_ISCR_PID10     = 0x400      // Bit PID10.
	AIC_ISCR_PID11_Pos = 0xb        // Position of PID11 field.
	AIC_ISCR_PID11_Msk = 0x800      // Bit mask of PID11 field.
	AIC_ISCR_PID11     = 0x800      // Bit PID11.
	AIC_ISCR_PID12_Pos = 0xc        // Position of PID12 field.
	AIC_ISCR_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	AIC_ISCR_PID12     = 0x1000     // Bit PID12.
	AIC_ISCR_PID13_Pos = 0xd        // Position of PID13 field.
	AIC_ISCR_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	AIC_ISCR_PID13     = 0x2000     // Bit PID13.
	AIC_ISCR_PID14_Pos = 0xe        // Position of PID14 field.
	AIC_ISCR_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	AIC_ISCR_PID14     = 0x4000     // Bit PID14.
	AIC_ISCR_PID15_Pos = 0xf        // Position of PID15 field.
	AIC_ISCR_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	AIC_ISCR_PID15     = 0x8000     // Bit PID15.
	AIC_ISCR_PID16_Pos = 0x10       // Position of PID16 field.
	AIC_ISCR_PID16_Msk = 0x10000    // Bit mask of PID16 field.
	AIC_ISCR_PID16     = 0x10000    // Bit PID16.
	AIC_ISCR_PID17_Pos = 0x11       // Position of PID17 field.
	AIC_ISCR_PID17_Msk = 0x20000    // Bit mask of PID17 field.
	AIC_ISCR_PID17     = 0x20000    // Bit PID17.
	AIC_ISCR_PID18_Pos = 0x12       // Position of PID18 field.
	AIC_ISCR_PID18_Msk = 0x40000    // Bit mask of PID18 field.
	AIC_ISCR_PID18     = 0x40000    // Bit PID18.
	AIC_ISCR_PID19_Pos = 0x13       // Position of PID19 field.
	AIC_ISCR_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	AIC_ISCR_PID19     = 0x80000    // Bit PID19.
	AIC_ISCR_PID20_Pos = 0x14       // Position of PID20 field.
	AIC_ISCR_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	AIC_ISCR_PID20     = 0x100000   // Bit PID20.
	AIC_ISCR_PID21_Pos = 0x15       // Position of PID21 field.
	AIC_ISCR_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	AIC_ISCR_PID21     = 0x200000   // Bit PID21.
	AIC_ISCR_PID22_Pos = 0x16       // Position of PID22 field.
	AIC_ISCR_PID22_Msk = 0x400000   // Bit mask of PID22 field.
	AIC_ISCR_PID22     = 0x400000   // Bit PID22.
	AIC_ISCR_PID23_Pos = 0x17       // Position of PID23 field.
	AIC_ISCR_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	AIC_ISCR_PID23     = 0x800000   // Bit PID23.
	AIC_ISCR_PID24_Pos = 0x18       // Position of PID24 field.
	AIC_ISCR_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	AIC_ISCR_PID24     = 0x1000000  // Bit PID24.
	AIC_ISCR_PID25_Pos = 0x19       // Position of PID25 field.
	AIC_ISCR_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	AIC_ISCR_PID25     = 0x2000000  // Bit PID25.
	AIC_ISCR_PID26_Pos = 0x1a       // Position of PID26 field.
	AIC_ISCR_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	AIC_ISCR_PID26     = 0x4000000  // Bit PID26.
	AIC_ISCR_PID27_Pos = 0x1b       // Position of PID27 field.
	AIC_ISCR_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	AIC_ISCR_PID27     = 0x8000000  // Bit PID27.
	AIC_ISCR_PID28_Pos = 0x1c       // Position of PID28 field.
	AIC_ISCR_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	AIC_ISCR_PID28     = 0x10000000 // Bit PID28.
	AIC_ISCR_PID29_Pos = 0x1d       // Position of PID29 field.
	AIC_ISCR_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	AIC_ISCR_PID29     = 0x20000000 // Bit PID29.
	AIC_ISCR_PID30_Pos = 0x1e       // Position of PID30 field.
	AIC_ISCR_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	AIC_ISCR_PID30     = 0x40000000 // Bit PID30.
	AIC_ISCR_PID31_Pos = 0x1f       // Position of PID31 field.
	AIC_ISCR_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	AIC_ISCR_PID31     = 0x80000000 // Bit PID31.

	// SPU: Spurious Interrupt Vector Register
	AIC_SPU_SIVR_Pos = 0x0        // Position of SIVR field.
	AIC_SPU_SIVR_Msk = 0xffffffff // Bit mask of SIVR field.

	// DCR: Debug Control Register
	AIC_DCR_PROT_Pos = 0x0 // Position of PROT field.
	AIC_DCR_PROT_Msk = 0x1 // Bit mask of PROT field.
	AIC_DCR_PROT     = 0x1 // Bit PROT.
	AIC_DCR_GMSK_Pos = 0x1 // Position of GMSK field.
	AIC_DCR_GMSK_Msk = 0x2 // Bit mask of GMSK field.
	AIC_DCR_GMSK     = 0x2 // Bit GMSK.

	// FFER: Fast Forcing Enable Register
	AIC_FFER_SYS_Pos   = 0x1        // Position of SYS field.
	AIC_FFER_SYS_Msk   = 0x2        // Bit mask of SYS field.
	AIC_FFER_SYS       = 0x2        // Bit SYS.
	AIC_FFER_PID2_Pos  = 0x2        // Position of PID2 field.
	AIC_FFER_PID2_Msk  = 0x4        // Bit mask of PID2 field.
	AIC_FFER_PID2      = 0x4        // Bit PID2.
	AIC_FFER_PID3_Pos  = 0x3        // Position of PID3 field.
	AIC_FFER_PID3_Msk  = 0x8        // Bit mask of PID3 field.
	AIC_FFER_PID3      = 0x8        // Bit PID3.
	AIC_FFER_PID4_Pos  = 0x4        // Position of PID4 field.
	AIC_FFER_PID4_Msk  = 0x10       // Bit mask of PID4 field.
	AIC_FFER_PID4      = 0x10       // Bit PID4.
	AIC_FFER_PID5_Pos  = 0x5        // Position of PID5 field.
	AIC_FFER_PID5_Msk  = 0x20       // Bit mask of PID5 field.
	AIC_FFER_PID5      = 0x20       // Bit PID5.
	AIC_FFER_PID6_Pos  = 0x6        // Position of PID6 field.
	AIC_FFER_PID6_Msk  = 0x40       // Bit mask of PID6 field.
	AIC_FFER_PID6      = 0x40       // Bit PID6.
	AIC_FFER_PID7_Pos  = 0x7        // Position of PID7 field.
	AIC_FFER_PID7_Msk  = 0x80       // Bit mask of PID7 field.
	AIC_FFER_PID7      = 0x80       // Bit PID7.
	AIC_FFER_PID8_Pos  = 0x8        // Position of PID8 field.
	AIC_FFER_PID8_Msk  = 0x100      // Bit mask of PID8 field.
	AIC_FFER_PID8      = 0x100      // Bit PID8.
	AIC_FFER_PID9_Pos  = 0x9        // Position of PID9 field.
	AIC_FFER_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	AIC_FFER_PID9      = 0x200      // Bit PID9.
	AIC_FFER_PID10_Pos = 0xa        // Position of PID10 field.
	AIC_FFER_PID10_Msk = 0x400      // Bit mask of PID10 field.
	AIC_FFER_PID10     = 0x400      // Bit PID10.
	AIC_FFER_PID11_Pos = 0xb        // Position of PID11 field.
	AIC_FFER_PID11_Msk = 0x800      // Bit mask of PID11 field.
	AIC_FFER_PID11     = 0x800      // Bit PID11.
	AIC_FFER_PID12_Pos = 0xc        // Position of PID12 field.
	AIC_FFER_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	AIC_FFER_PID12     = 0x1000     // Bit PID12.
	AIC_FFER_PID13_Pos = 0xd        // Position of PID13 field.
	AIC_FFER_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	AIC_FFER_PID13     = 0x2000     // Bit PID13.
	AIC_FFER_PID14_Pos = 0xe        // Position of PID14 field.
	AIC_FFER_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	AIC_FFER_PID14     = 0x4000     // Bit PID14.
	AIC_FFER_PID15_Pos = 0xf        // Position of PID15 field.
	AIC_FFER_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	AIC_FFER_PID15     = 0x8000     // Bit PID15.
	AIC_FFER_PID16_Pos = 0x10       // Position of PID16 field.
	AIC_FFER_PID16_Msk = 0x10000    // Bit mask of PID16 field.
	AIC_FFER_PID16     = 0x10000    // Bit PID16.
	AIC_FFER_PID17_Pos = 0x11       // Position of PID17 field.
	AIC_FFER_PID17_Msk = 0x20000    // Bit mask of PID17 field.
	AIC_FFER_PID17     = 0x20000    // Bit PID17.
	AIC_FFER_PID18_Pos = 0x12       // Position of PID18 field.
	AIC_FFER_PID18_Msk = 0x40000    // Bit mask of PID18 field.
	AIC_FFER_PID18     = 0x40000    // Bit PID18.
	AIC_FFER_PID19_Pos = 0x13       // Position of PID19 field.
	AIC_FFER_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	AIC_FFER_PID19     = 0x80000    // Bit PID19.
	AIC_FFER_PID20_Pos = 0x14       // Position of PID20 field.
	AIC_FFER_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	AIC_FFER_PID20     = 0x100000   // Bit PID20.
	AIC_FFER_PID21_Pos = 0x15       // Position of PID21 field.
	AIC_FFER_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	AIC_FFER_PID21     = 0x200000   // Bit PID21.
	AIC_FFER_PID22_Pos = 0x16       // Position of PID22 field.
	AIC_FFER_PID22_Msk = 0x400000   // Bit mask of PID22 field.
	AIC_FFER_PID22     = 0x400000   // Bit PID22.
	AIC_FFER_PID23_Pos = 0x17       // Position of PID23 field.
	AIC_FFER_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	AIC_FFER_PID23     = 0x800000   // Bit PID23.
	AIC_FFER_PID24_Pos = 0x18       // Position of PID24 field.
	AIC_FFER_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	AIC_FFER_PID24     = 0x1000000  // Bit PID24.
	AIC_FFER_PID25_Pos = 0x19       // Position of PID25 field.
	AIC_FFER_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	AIC_FFER_PID25     = 0x2000000  // Bit PID25.
	AIC_FFER_PID26_Pos = 0x1a       // Position of PID26 field.
	AIC_FFER_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	AIC_FFER_PID26     = 0x4000000  // Bit PID26.
	AIC_FFER_PID27_Pos = 0x1b       // Position of PID27 field.
	AIC_FFER_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	AIC_FFER_PID27     = 0x8000000  // Bit PID27.
	AIC_FFER_PID28_Pos = 0x1c       // Position of PID28 field.
	AIC_FFER_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	AIC_FFER_PID28     = 0x10000000 // Bit PID28.
	AIC_FFER_PID29_Pos = 0x1d       // Position of PID29 field.
	AIC_FFER_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	AIC_FFER_PID29     = 0x20000000 // Bit PID29.
	AIC_FFER_PID30_Pos = 0x1e       // Position of PID30 field.
	AIC_FFER_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	AIC_FFER_PID30     = 0x40000000 // Bit PID30.
	AIC_FFER_PID31_Pos = 0x1f       // Position of PID31 field.
	AIC_FFER_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	AIC_FFER_PID31     = 0x80000000 // Bit PID31.

	// FFDR: Fast Forcing Disable Register
	AIC_FFDR_SYS_Pos   = 0x1        // Position of SYS field.
	AIC_FFDR_SYS_Msk   = 0x2        // Bit mask of SYS field.
	AIC_FFDR_SYS       = 0x2        // Bit SYS.
	AIC_FFDR_PID2_Pos  = 0x2        // Position of PID2 field.
	AIC_FFDR_PID2_Msk  = 0x4        // Bit mask of PID2 field.
	AIC_FFDR_PID2      = 0x4        // Bit PID2.
	AIC_FFDR_PID3_Pos  = 0x3        // Position of PID3 field.
	AIC_FFDR_PID3_Msk  = 0x8        // Bit mask of PID3 field.
	AIC_FFDR_PID3      = 0x8        // Bit PID3.
	AIC_FFDR_PID4_Pos  = 0x4        // Position of PID4 field.
	AIC_FFDR_PID4_Msk  = 0x10       // Bit mask of PID4 field.
	AIC_FFDR_PID4      = 0x10       // Bit PID4.
	AIC_FFDR_PID5_Pos  = 0x5        // Position of PID5 field.
	AIC_FFDR_PID5_Msk  = 0x20       // Bit mask of PID5 field.
	AIC_FFDR_PID5      = 0x20       // Bit PID5.
	AIC_FFDR_PID6_Pos  = 0x6        // Position of PID6 field.
	AIC_FFDR_PID6_Msk  = 0x40       // Bit mask of PID6 field.
	AIC_FFDR_PID6      = 0x40       // Bit PID6.
	AIC_FFDR_PID7_Pos  = 0x7        // Position of PID7 field.
	AIC_FFDR_PID7_Msk  = 0x80       // Bit mask of PID7 field.
	AIC_FFDR_PID7      = 0x80       // Bit PID7.
	AIC_FFDR_PID8_Pos  = 0x8        // Position of PID8 field.
	AIC_FFDR_PID8_Msk  = 0x100      // Bit mask of PID8 field.
	AIC_FFDR_PID8      = 0x100      // Bit PID8.
	AIC_FFDR_PID9_Pos  = 0x9        // Position of PID9 field.
	AIC_FFDR_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	AIC_FFDR_PID9      = 0x200      // Bit PID9.
	AIC_FFDR_PID10_Pos = 0xa        // Position of PID10 field.
	AIC_FFDR_PID10_Msk = 0x400      // Bit mask of PID10 field.
	AIC_FFDR_PID10     = 0x400      // Bit PID10.
	AIC_FFDR_PID11_Pos = 0xb        // Position of PID11 field.
	AIC_FFDR_PID11_Msk = 0x800      // Bit mask of PID11 field.
	AIC_FFDR_PID11     = 0x800      // Bit PID11.
	AIC_FFDR_PID12_Pos = 0xc        // Position of PID12 field.
	AIC_FFDR_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	AIC_FFDR_PID12     = 0x1000     // Bit PID12.
	AIC_FFDR_PID13_Pos = 0xd        // Position of PID13 field.
	AIC_FFDR_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	AIC_FFDR_PID13     = 0x2000     // Bit PID13.
	AIC_FFDR_PID14_Pos = 0xe        // Position of PID14 field.
	AIC_FFDR_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	AIC_FFDR_PID14     = 0x4000     // Bit PID14.
	AIC_FFDR_PID15_Pos = 0xf        // Position of PID15 field.
	AIC_FFDR_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	AIC_FFDR_PID15     = 0x8000     // Bit PID15.
	AIC_FFDR_PID16_Pos = 0x10       // Position of PID16 field.
	AIC_FFDR_PID16_Msk = 0x10000    // Bit mask of PID16 field.
	AIC_FFDR_PID16     = 0x10000    // Bit PID16.
	AIC_FFDR_PID17_Pos = 0x11       // Position of PID17 field.
	AIC_FFDR_PID17_Msk = 0x20000    // Bit mask of PID17 field.
	AIC_FFDR_PID17     = 0x20000    // Bit PID17.
	AIC_FFDR_PID18_Pos = 0x12       // Position of PID18 field.
	AIC_FFDR_PID18_Msk = 0x40000    // Bit mask of PID18 field.
	AIC_FFDR_PID18     = 0x40000    // Bit PID18.
	AIC_FFDR_PID19_Pos = 0x13       // Position of PID19 field.
	AIC_FFDR_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	AIC_FFDR_PID19     = 0x80000    // Bit PID19.
	AIC_FFDR_PID20_Pos = 0x14       // Position of PID20 field.
	AIC_FFDR_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	AIC_FFDR_PID20     = 0x100000   // Bit PID20.
	AIC_FFDR_PID21_Pos = 0x15       // Position of PID21 field.
	AIC_FFDR_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	AIC_FFDR_PID21     = 0x200000   // Bit PID21.
	AIC_FFDR_PID22_Pos = 0x16       // Position of PID22 field.
	AIC_FFDR_PID22_Msk = 0x400000   // Bit mask of PID22 field.
	AIC_FFDR_PID22     = 0x400000   // Bit PID22.
	AIC_FFDR_PID23_Pos = 0x17       // Position of PID23 field.
	AIC_FFDR_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	AIC_FFDR_PID23     = 0x800000   // Bit PID23.
	AIC_FFDR_PID24_Pos = 0x18       // Position of PID24 field.
	AIC_FFDR_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	AIC_FFDR_PID24     = 0x1000000  // Bit PID24.
	AIC_FFDR_PID25_Pos = 0x19       // Position of PID25 field.
	AIC_FFDR_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	AIC_FFDR_PID25     = 0x2000000  // Bit PID25.
	AIC_FFDR_PID26_Pos = 0x1a       // Position of PID26 field.
	AIC_FFDR_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	AIC_FFDR_PID26     = 0x4000000  // Bit PID26.
	AIC_FFDR_PID27_Pos = 0x1b       // Position of PID27 field.
	AIC_FFDR_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	AIC_FFDR_PID27     = 0x8000000  // Bit PID27.
	AIC_FFDR_PID28_Pos = 0x1c       // Position of PID28 field.
	AIC_FFDR_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	AIC_FFDR_PID28     = 0x10000000 // Bit PID28.
	AIC_FFDR_PID29_Pos = 0x1d       // Position of PID29 field.
	AIC_FFDR_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	AIC_FFDR_PID29     = 0x20000000 // Bit PID29.
	AIC_FFDR_PID30_Pos = 0x1e       // Position of PID30 field.
	AIC_FFDR_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	AIC_FFDR_PID30     = 0x40000000 // Bit PID30.
	AIC_FFDR_PID31_Pos = 0x1f       // Position of PID31 field.
	AIC_FFDR_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	AIC_FFDR_PID31     = 0x80000000 // Bit PID31.

	// FFSR: Fast Forcing Status Register
	AIC_FFSR_SYS_Pos   = 0x1        // Position of SYS field.
	AIC_FFSR_SYS_Msk   = 0x2        // Bit mask of SYS field.
	AIC_FFSR_SYS       = 0x2        // Bit SYS.
	AIC_FFSR_PID2_Pos  = 0x2        // Position of PID2 field.
	AIC_FFSR_PID2_Msk  = 0x4        // Bit mask of PID2 field.
	AIC_FFSR_PID2      = 0x4        // Bit PID2.
	AIC_FFSR_PID3_Pos  = 0x3        // Position of PID3 field.
	AIC_FFSR_PID3_Msk  = 0x8        // Bit mask of PID3 field.
	AIC_FFSR_PID3      = 0x8        // Bit PID3.
	AIC_FFSR_PID4_Pos  = 0x4        // Position of PID4 field.
	AIC_FFSR_PID4_Msk  = 0x10       // Bit mask of PID4 field.
	AIC_FFSR_PID4      = 0x10       // Bit PID4.
	AIC_FFSR_PID5_Pos  = 0x5        // Position of PID5 field.
	AIC_FFSR_PID5_Msk  = 0x20       // Bit mask of PID5 field.
	AIC_FFSR_PID5      = 0x20       // Bit PID5.
	AIC_FFSR_PID6_Pos  = 0x6        // Position of PID6 field.
	AIC_FFSR_PID6_Msk  = 0x40       // Bit mask of PID6 field.
	AIC_FFSR_PID6      = 0x40       // Bit PID6.
	AIC_FFSR_PID7_Pos  = 0x7        // Position of PID7 field.
	AIC_FFSR_PID7_Msk  = 0x80       // Bit mask of PID7 field.
	AIC_FFSR_PID7      = 0x80       // Bit PID7.
	AIC_FFSR_PID8_Pos  = 0x8        // Position of PID8 field.
	AIC_FFSR_PID8_Msk  = 0x100      // Bit mask of PID8 field.
	AIC_FFSR_PID8      = 0x100      // Bit PID8.
	AIC_FFSR_PID9_Pos  = 0x9        // Position of PID9 field.
	AIC_FFSR_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	AIC_FFSR_PID9      = 0x200      // Bit PID9.
	AIC_FFSR_PID10_Pos = 0xa        // Position of PID10 field.
	AIC_FFSR_PID10_Msk = 0x400      // Bit mask of PID10 field.
	AIC_FFSR_PID10     = 0x400      // Bit PID10.
	AIC_FFSR_PID11_Pos = 0xb        // Position of PID11 field.
	AIC_FFSR_PID11_Msk = 0x800      // Bit mask of PID11 field.
	AIC_FFSR_PID11     = 0x800      // Bit PID11.
	AIC_FFSR_PID12_Pos = 0xc        // Position of PID12 field.
	AIC_FFSR_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	AIC_FFSR_PID12     = 0x1000     // Bit PID12.
	AIC_FFSR_PID13_Pos = 0xd        // Position of PID13 field.
	AIC_FFSR_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	AIC_FFSR_PID13     = 0x2000     // Bit PID13.
	AIC_FFSR_PID14_Pos = 0xe        // Position of PID14 field.
	AIC_FFSR_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	AIC_FFSR_PID14     = 0x4000     // Bit PID14.
	AIC_FFSR_PID15_Pos = 0xf        // Position of PID15 field.
	AIC_FFSR_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	AIC_FFSR_PID15     = 0x8000     // Bit PID15.
	AIC_FFSR_PID16_Pos = 0x10       // Position of PID16 field.
	AIC_FFSR_PID16_Msk = 0x10000    // Bit mask of PID16 field.
	AIC_FFSR_PID16     = 0x10000    // Bit PID16.
	AIC_FFSR_PID17_Pos = 0x11       // Position of PID17 field.
	AIC_FFSR_PID17_Msk = 0x20000    // Bit mask of PID17 field.
	AIC_FFSR_PID17     = 0x20000    // Bit PID17.
	AIC_FFSR_PID18_Pos = 0x12       // Position of PID18 field.
	AIC_FFSR_PID18_Msk = 0x40000    // Bit mask of PID18 field.
	AIC_FFSR_PID18     = 0x40000    // Bit PID18.
	AIC_FFSR_PID19_Pos = 0x13       // Position of PID19 field.
	AIC_FFSR_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	AIC_FFSR_PID19     = 0x80000    // Bit PID19.
	AIC_FFSR_PID20_Pos = 0x14       // Position of PID20 field.
	AIC_FFSR_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	AIC_FFSR_PID20     = 0x100000   // Bit PID20.
	AIC_FFSR_PID21_Pos = 0x15       // Position of PID21 field.
	AIC_FFSR_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	AIC_FFSR_PID21     = 0x200000   // Bit PID21.
	AIC_FFSR_PID22_Pos = 0x16       // Position of PID22 field.
	AIC_FFSR_PID22_Msk = 0x400000   // Bit mask of PID22 field.
	AIC_FFSR_PID22     = 0x400000   // Bit PID22.
	AIC_FFSR_PID23_Pos = 0x17       // Position of PID23 field.
	AIC_FFSR_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	AIC_FFSR_PID23     = 0x800000   // Bit PID23.
	AIC_FFSR_PID24_Pos = 0x18       // Position of PID24 field.
	AIC_FFSR_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	AIC_FFSR_PID24     = 0x1000000  // Bit PID24.
	AIC_FFSR_PID25_Pos = 0x19       // Position of PID25 field.
	AIC_FFSR_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	AIC_FFSR_PID25     = 0x2000000  // Bit PID25.
	AIC_FFSR_PID26_Pos = 0x1a       // Position of PID26 field.
	AIC_FFSR_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	AIC_FFSR_PID26     = 0x4000000  // Bit PID26.
	AIC_FFSR_PID27_Pos = 0x1b       // Position of PID27 field.
	AIC_FFSR_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	AIC_FFSR_PID27     = 0x8000000  // Bit PID27.
	AIC_FFSR_PID28_Pos = 0x1c       // Position of PID28 field.
	AIC_FFSR_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	AIC_FFSR_PID28     = 0x10000000 // Bit PID28.
	AIC_FFSR_PID29_Pos = 0x1d       // Position of PID29 field.
	AIC_FFSR_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	AIC_FFSR_PID29     = 0x20000000 // Bit PID29.
	AIC_FFSR_PID30_Pos = 0x1e       // Position of PID30 field.
	AIC_FFSR_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	AIC_FFSR_PID30     = 0x40000000 // Bit PID30.
	AIC_FFSR_PID31_Pos = 0x1f       // Position of PID31 field.
	AIC_FFSR_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	AIC_FFSR_PID31     = 0x80000000 // Bit PID31.
)

// Bitfields for PIOA: Parallel Input/Output Controller A
const (
	// PER: PIO Enable Register
	PIO_PER_P0_Pos  = 0x0        // Position of P0 field.
	PIO_PER_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_PER_P0      = 0x1        // Bit P0.
	PIO_PER_P1_Pos  = 0x1        // Position of P1 field.
	PIO_PER_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_PER_P1      = 0x2        // Bit P1.
	PIO_PER_P2_Pos  = 0x2        // Position of P2 field.
	PIO_PER_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_PER_P2      = 0x4        // Bit P2.
	PIO_PER_P3_Pos  = 0x3        // Position of P3 field.
	PIO_PER_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_PER_P3      = 0x8        // Bit P3.
	PIO_PER_P4_Pos  = 0x4        // Position of P4 field.
	PIO_PER_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_PER_P4      = 0x10       // Bit P4.
	PIO_PER_P5_Pos  = 0x5        // Position of P5 field.
	PIO_PER_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_PER_P5      = 0x20       // Bit P5.
	PIO_PER_P6_Pos  = 0x6        // Position of P6 field.
	PIO_PER_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_PER_P6      = 0x40       // Bit P6.
	PIO_PER_P7_Pos  = 0x7        // Position of P7 field.
	PIO_PER_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_PER_P7      = 0x80       // Bit P7.
	PIO_PER_P8_Pos  = 0x8        // Position of P8 field.
	PIO_PER_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_PER_P8      = 0x100      // Bit P8.
	PIO_PER_P9_Pos  = 0x9        // Position of P9 field.
	PIO_PER_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_PER_P9      = 0x200      // Bit P9.
	PIO_PER_P10_Pos = 0xa        // Position of P10 field.
	PIO_PER_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_PER_P10     = 0x400      // Bit P10.
	PIO_PER_P11_Pos = 0xb        // Position of P11 field.
	PIO_PER_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_PER_P11     = 0x800      // Bit P11.
	PIO_PER_P12_Pos = 0xc        // Position of P12 field.
	PIO_PER_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_PER_P12     = 0x1000     // Bit P12.
	PIO_PER_P13_Pos = 0xd        // Position of P13 field.
	PIO_PER_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_PER_P13     = 0x2000     // Bit P13.
	PIO_PER_P14_Pos = 0xe        // Position of P14 field.
	PIO_PER_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_PER_P14     = 0x4000     // Bit P14.
	PIO_PER_P15_Pos = 0xf        // Position of P15 field.
	PIO_PER_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_PER_P15     = 0x8000     // Bit P15.
	PIO_PER_P16_Pos = 0x10       // Position of P16 field.
	PIO_PER_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_PER_P16     = 0x10000    // Bit P16.
	PIO_PER_P17_Pos = 0x11       // Position of P17 field.
	PIO_PER_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_PER_P17     = 0x20000    // Bit P17.
	PIO_PER_P18_Pos = 0x12       // Position of P18 field.
	PIO_PER_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_PER_P18     = 0x40000    // Bit P18.
	PIO_PER_P19_Pos = 0x13       // Position of P19 field.
	PIO_PER_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_PER_P19     = 0x80000    // Bit P19.
	PIO_PER_P20_Pos = 0x14       // Position of P20 field.
	PIO_PER_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_PER_P20     = 0x100000   // Bit P20.
	PIO_PER_P21_Pos = 0x15       // Position of P21 field.
	PIO_PER_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_PER_P21     = 0x200000   // Bit P21.
	PIO_PER_P22_Pos = 0x16       // Position of P22 field.
	PIO_PER_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_PER_P22     = 0x400000   // Bit P22.
	PIO_PER_P23_Pos = 0x17       // Position of P23 field.
	PIO_PER_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_PER_P23     = 0x800000   // Bit P23.
	PIO_PER_P24_Pos = 0x18       // Position of P24 field.
	PIO_PER_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_PER_P24     = 0x1000000  // Bit P24.
	PIO_PER_P25_Pos = 0x19       // Position of P25 field.
	PIO_PER_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_PER_P25     = 0x2000000  // Bit P25.
	PIO_PER_P26_Pos = 0x1a       // Position of P26 field.
	PIO_PER_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_PER_P26     = 0x4000000  // Bit P26.
	PIO_PER_P27_Pos = 0x1b       // Position of P27 field.
	PIO_PER_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_PER_P27     = 0x8000000  // Bit P27.
	PIO_PER_P28_Pos = 0x1c       // Position of P28 field.
	PIO_PER_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_PER_P28     = 0x10000000 // Bit P28.
	PIO_PER_P29_Pos = 0x1d       // Position of P29 field.
	PIO_PER_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_PER_P29     = 0x20000000 // Bit P29.
	PIO_PER_P30_Pos = 0x1e       // Position of P30 field.
	PIO_PER_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_PER_P30     = 0x40000000 // Bit P30.
	PIO_PER_P31_Pos = 0x1f       // Position of P31 field.
	PIO_PER_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_PER_P31     = 0x80000000 // Bit P31.

	// PDR: PIO Disable Register
	PIO_PDR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_PDR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_PDR_P0      = 0x1        // Bit P0.
	PIO_PDR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_PDR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_PDR_P1      = 0x2        // Bit P1.
	PIO_PDR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_PDR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_PDR_P2      = 0x4        // Bit P2.
	PIO_PDR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_PDR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_PDR_P3      = 0x8        // Bit P3.
	PIO_PDR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_PDR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_PDR_P4      = 0x10       // Bit P4.
	PIO_PDR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_PDR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_PDR_P5      = 0x20       // Bit P5.
	PIO_PDR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_PDR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_PDR_P6      = 0x40       // Bit P6.
	PIO_PDR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_PDR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_PDR_P7      = 0x80       // Bit P7.
	PIO_PDR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_PDR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_PDR_P8      = 0x100      // Bit P8.
	PIO_PDR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_PDR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_PDR_P9      = 0x200      // Bit P9.
	PIO_PDR_P10_Pos = 0xa        // Position of P10 field.
	PIO_PDR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_PDR_P10     = 0x400      // Bit P10.
	PIO_PDR_P11_Pos = 0xb        // Position of P11 field.
	PIO_PDR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_PDR_P11     = 0x800      // Bit P11.
	PIO_PDR_P12_Pos = 0xc        // Position of P12 field.
	PIO_PDR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_PDR_P12     = 0x1000     // Bit P12.
	PIO_PDR_P13_Pos = 0xd        // Position of P13 field.
	PIO_PDR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_PDR_P13     = 0x2000     // Bit P13.
	PIO_PDR_P14_Pos = 0xe        // Position of P14 field.
	PIO_PDR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_PDR_P14     = 0x4000     // Bit P14.
	PIO_PDR_P15_Pos = 0xf        // Position of P15 field.
	PIO_PDR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_PDR_P15     = 0x8000     // Bit P15.
	PIO_PDR_P16_Pos = 0x10       // Position of P16 field.
	PIO_PDR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_PDR_P16     = 0x10000    // Bit P16.
	PIO_PDR_P17_Pos = 0x11       // Position of P17 field.
	PIO_PDR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_PDR_P17     = 0x20000    // Bit P17.
	PIO_PDR_P18_Pos = 0x12       // Position of P18 field.
	PIO_PDR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_PDR_P18     = 0x40000    // Bit P18.
	PIO_PDR_P19_Pos = 0x13       // Position of P19 field.
	PIO_PDR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_PDR_P19     = 0x80000    // Bit P19.
	PIO_PDR_P20_Pos = 0x14       // Position of P20 field.
	PIO_PDR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_PDR_P20     = 0x100000   // Bit P20.
	PIO_PDR_P21_Pos = 0x15       // Position of P21 field.
	PIO_PDR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_PDR_P21     = 0x200000   // Bit P21.
	PIO_PDR_P22_Pos = 0x16       // Position of P22 field.
	PIO_PDR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_PDR_P22     = 0x400000   // Bit P22.
	PIO_PDR_P23_Pos = 0x17       // Position of P23 field.
	PIO_PDR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_PDR_P23     = 0x800000   // Bit P23.
	PIO_PDR_P24_Pos = 0x18       // Position of P24 field.
	PIO_PDR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_PDR_P24     = 0x1000000  // Bit P24.
	PIO_PDR_P25_Pos = 0x19       // Position of P25 field.
	PIO_PDR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_PDR_P25     = 0x2000000  // Bit P25.
	PIO_PDR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_PDR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_PDR_P26     = 0x4000000  // Bit P26.
	PIO_PDR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_PDR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_PDR_P27     = 0x8000000  // Bit P27.
	PIO_PDR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_PDR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_PDR_P28     = 0x10000000 // Bit P28.
	PIO_PDR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_PDR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_PDR_P29     = 0x20000000 // Bit P29.
	PIO_PDR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_PDR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_PDR_P30     = 0x40000000 // Bit P30.
	PIO_PDR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_PDR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_PDR_P31     = 0x80000000 // Bit P31.

	// PSR: PIO Status Register
	PIO_PSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_PSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_PSR_P0      = 0x1        // Bit P0.
	PIO_PSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_PSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_PSR_P1      = 0x2        // Bit P1.
	PIO_PSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_PSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_PSR_P2      = 0x4        // Bit P2.
	PIO_PSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_PSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_PSR_P3      = 0x8        // Bit P3.
	PIO_PSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_PSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_PSR_P4      = 0x10       // Bit P4.
	PIO_PSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_PSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_PSR_P5      = 0x20       // Bit P5.
	PIO_PSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_PSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_PSR_P6      = 0x40       // Bit P6.
	PIO_PSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_PSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_PSR_P7      = 0x80       // Bit P7.
	PIO_PSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_PSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_PSR_P8      = 0x100      // Bit P8.
	PIO_PSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_PSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_PSR_P9      = 0x200      // Bit P9.
	PIO_PSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_PSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_PSR_P10     = 0x400      // Bit P10.
	PIO_PSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_PSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_PSR_P11     = 0x800      // Bit P11.
	PIO_PSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_PSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_PSR_P12     = 0x1000     // Bit P12.
	PIO_PSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_PSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_PSR_P13     = 0x2000     // Bit P13.
	PIO_PSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_PSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_PSR_P14     = 0x4000     // Bit P14.
	PIO_PSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_PSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_PSR_P15     = 0x8000     // Bit P15.
	PIO_PSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_PSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_PSR_P16     = 0x10000    // Bit P16.
	PIO_PSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_PSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_PSR_P17     = 0x20000    // Bit P17.
	PIO_PSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_PSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_PSR_P18     = 0x40000    // Bit P18.
	PIO_PSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_PSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_PSR_P19     = 0x80000    // Bit P19.
	PIO_PSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_PSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_PSR_P20     = 0x100000   // Bit P20.
	PIO_PSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_PSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_PSR_P21     = 0x200000   // Bit P21.
	PIO_PSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_PSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_PSR_P22     = 0x400000   // Bit P22.
	PIO_PSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_PSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_PSR_P23     = 0x800000   // Bit P23.
	PIO_PSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_PSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_PSR_P24     = 0x1000000  // Bit P24.
	PIO_PSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_PSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_PSR_P25     = 0x2000000  // Bit P25.
	PIO_PSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_PSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_PSR_P26     = 0x4000000  // Bit P26.
	PIO_PSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_PSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_PSR_P27     = 0x8000000  // Bit P27.
	PIO_PSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_PSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_PSR_P28     = 0x10000000 // Bit P28.
	PIO_PSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_PSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_PSR_P29     = 0x20000000 // Bit P29.
	PIO_PSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_PSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_PSR_P30     = 0x40000000 // Bit P30.
	PIO_PSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_PSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_PSR_P31     = 0x80000000 // Bit P31.

	// OER: Output Enable Register
	PIO_OER_P0_Pos  = 0x0        // Position of P0 field.
	PIO_OER_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_OER_P0      = 0x1        // Bit P0.
	PIO_OER_P1_Pos  = 0x1        // Position of P1 field.
	PIO_OER_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_OER_P1      = 0x2        // Bit P1.
	PIO_OER_P2_Pos  = 0x2        // Position of P2 field.
	PIO_OER_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_OER_P2      = 0x4        // Bit P2.
	PIO_OER_P3_Pos  = 0x3        // Position of P3 field.
	PIO_OER_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_OER_P3      = 0x8        // Bit P3.
	PIO_OER_P4_Pos  = 0x4        // Position of P4 field.
	PIO_OER_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_OER_P4      = 0x10       // Bit P4.
	PIO_OER_P5_Pos  = 0x5        // Position of P5 field.
	PIO_OER_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_OER_P5      = 0x20       // Bit P5.
	PIO_OER_P6_Pos  = 0x6        // Position of P6 field.
	PIO_OER_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_OER_P6      = 0x40       // Bit P6.
	PIO_OER_P7_Pos  = 0x7        // Position of P7 field.
	PIO_OER_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_OER_P7      = 0x80       // Bit P7.
	PIO_OER_P8_Pos  = 0x8        // Position of P8 field.
	PIO_OER_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_OER_P8      = 0x100      // Bit P8.
	PIO_OER_P9_Pos  = 0x9        // Position of P9 field.
	PIO_OER_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_OER_P9      = 0x200      // Bit P9.
	PIO_OER_P10_Pos = 0xa        // Position of P10 field.
	PIO_OER_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_OER_P10     = 0x400      // Bit P10.
	PIO_OER_P11_Pos = 0xb        // Position of P11 field.
	PIO_OER_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_OER_P11     = 0x800      // Bit P11.
	PIO_OER_P12_Pos = 0xc        // Position of P12 field.
	PIO_OER_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_OER_P12     = 0x1000     // Bit P12.
	PIO_OER_P13_Pos = 0xd        // Position of P13 field.
	PIO_OER_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_OER_P13     = 0x2000     // Bit P13.
	PIO_OER_P14_Pos = 0xe        // Position of P14 field.
	PIO_OER_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_OER_P14     = 0x4000     // Bit P14.
	PIO_OER_P15_Pos = 0xf        // Position of P15 field.
	PIO_OER_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_OER_P15     = 0x8000     // Bit P15.
	PIO_OER_P16_Pos = 0x10       // Position of P16 field.
	PIO_OER_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_OER_P16     = 0x10000    // Bit P16.
	PIO_OER_P17_Pos = 0x11       // Position of P17 field.
	PIO_OER_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_OER_P17     = 0x20000    // Bit P17.
	PIO_OER_P18_Pos = 0x12       // Position of P18 field.
	PIO_OER_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_OER_P18     = 0x40000    // Bit P18.
	PIO_OER_P19_Pos = 0x13       // Position of P19 field.
	PIO_OER_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_OER_P19     = 0x80000    // Bit P19.
	PIO_OER_P20_Pos = 0x14       // Position of P20 field.
	PIO_OER_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_OER_P20     = 0x100000   // Bit P20.
	PIO_OER_P21_Pos = 0x15       // Position of P21 field.
	PIO_OER_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_OER_P21     = 0x200000   // Bit P21.
	PIO_OER_P22_Pos = 0x16       // Position of P22 field.
	PIO_OER_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_OER_P22     = 0x400000   // Bit P22.
	PIO_OER_P23_Pos = 0x17       // Position of P23 field.
	PIO_OER_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_OER_P23     = 0x800000   // Bit P23.
	PIO_OER_P24_Pos = 0x18       // Position of P24 field.
	PIO_OER_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_OER_P24     = 0x1000000  // Bit P24.
	PIO_OER_P25_Pos = 0x19       // Position of P25 field.
	PIO_OER_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_OER_P25     = 0x2000000  // Bit P25.
	PIO_OER_P26_Pos = 0x1a       // Position of P26 field.
	PIO_OER_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_OER_P26     = 0x4000000  // Bit P26.
	PIO_OER_P27_Pos = 0x1b       // Position of P27 field.
	PIO_OER_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_OER_P27     = 0x8000000  // Bit P27.
	PIO_OER_P28_Pos = 0x1c       // Position of P28 field.
	PIO_OER_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_OER_P28     = 0x10000000 // Bit P28.
	PIO_OER_P29_Pos = 0x1d       // Position of P29 field.
	PIO_OER_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_OER_P29     = 0x20000000 // Bit P29.
	PIO_OER_P30_Pos = 0x1e       // Position of P30 field.
	PIO_OER_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_OER_P30     = 0x40000000 // Bit P30.
	PIO_OER_P31_Pos = 0x1f       // Position of P31 field.
	PIO_OER_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_OER_P31     = 0x80000000 // Bit P31.

	// ODR: Output Disable Register
	PIO_ODR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_ODR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_ODR_P0      = 0x1        // Bit P0.
	PIO_ODR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_ODR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_ODR_P1      = 0x2        // Bit P1.
	PIO_ODR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_ODR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_ODR_P2      = 0x4        // Bit P2.
	PIO_ODR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_ODR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_ODR_P3      = 0x8        // Bit P3.
	PIO_ODR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_ODR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_ODR_P4      = 0x10       // Bit P4.
	PIO_ODR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_ODR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_ODR_P5      = 0x20       // Bit P5.
	PIO_ODR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_ODR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_ODR_P6      = 0x40       // Bit P6.
	PIO_ODR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_ODR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_ODR_P7      = 0x80       // Bit P7.
	PIO_ODR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_ODR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_ODR_P8      = 0x100      // Bit P8.
	PIO_ODR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_ODR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_ODR_P9      = 0x200      // Bit P9.
	PIO_ODR_P10_Pos = 0xa        // Position of P10 field.
	PIO_ODR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_ODR_P10     = 0x400      // Bit P10.
	PIO_ODR_P11_Pos = 0xb        // Position of P11 field.
	PIO_ODR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_ODR_P11     = 0x800      // Bit P11.
	PIO_ODR_P12_Pos = 0xc        // Position of P12 field.
	PIO_ODR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_ODR_P12     = 0x1000     // Bit P12.
	PIO_ODR_P13_Pos = 0xd        // Position of P13 field.
	PIO_ODR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_ODR_P13     = 0x2000     // Bit P13.
	PIO_ODR_P14_Pos = 0xe        // Position of P14 field.
	PIO_ODR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_ODR_P14     = 0x4000     // Bit P14.
	PIO_ODR_P15_Pos = 0xf        // Position of P15 field.
	PIO_ODR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_ODR_P15     = 0x8000     // Bit P15.
	PIO_ODR_P16_Pos = 0x10       // Position of P16 field.
	PIO_ODR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_ODR_P16     = 0x10000    // Bit P16.
	PIO_ODR_P17_Pos = 0x11       // Position of P17 field.
	PIO_ODR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_ODR_P17     = 0x20000    // Bit P17.
	PIO_ODR_P18_Pos = 0x12       // Position of P18 field.
	PIO_ODR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_ODR_P18     = 0x40000    // Bit P18.
	PIO_ODR_P19_Pos = 0x13       // Position of P19 field.
	PIO_ODR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_ODR_P19     = 0x80000    // Bit P19.
	PIO_ODR_P20_Pos = 0x14       // Position of P20 field.
	PIO_ODR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_ODR_P20     = 0x100000   // Bit P20.
	PIO_ODR_P21_Pos = 0x15       // Position of P21 field.
	PIO_ODR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_ODR_P21     = 0x200000   // Bit P21.
	PIO_ODR_P22_Pos = 0x16       // Position of P22 field.
	PIO_ODR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_ODR_P22     = 0x400000   // Bit P22.
	PIO_ODR_P23_Pos = 0x17       // Position of P23 field.
	PIO_ODR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_ODR_P23     = 0x800000   // Bit P23.
	PIO_ODR_P24_Pos = 0x18       // Position of P24 field.
	PIO_ODR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_ODR_P24     = 0x1000000  // Bit P24.
	PIO_ODR_P25_Pos = 0x19       // Position of P25 field.
	PIO_ODR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_ODR_P25     = 0x2000000  // Bit P25.
	PIO_ODR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_ODR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_ODR_P26     = 0x4000000  // Bit P26.
	PIO_ODR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_ODR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_ODR_P27     = 0x8000000  // Bit P27.
	PIO_ODR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_ODR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_ODR_P28     = 0x10000000 // Bit P28.
	PIO_ODR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_ODR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_ODR_P29     = 0x20000000 // Bit P29.
	PIO_ODR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_ODR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_ODR_P30     = 0x40000000 // Bit P30.
	PIO_ODR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_ODR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_ODR_P31     = 0x80000000 // Bit P31.

	// OSR: Output Status Register
	PIO_OSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_OSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_OSR_P0      = 0x1        // Bit P0.
	PIO_OSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_OSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_OSR_P1      = 0x2        // Bit P1.
	PIO_OSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_OSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_OSR_P2      = 0x4        // Bit P2.
	PIO_OSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_OSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_OSR_P3      = 0x8        // Bit P3.
	PIO_OSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_OSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_OSR_P4      = 0x10       // Bit P4.
	PIO_OSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_OSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_OSR_P5      = 0x20       // Bit P5.
	PIO_OSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_OSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_OSR_P6      = 0x40       // Bit P6.
	PIO_OSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_OSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_OSR_P7      = 0x80       // Bit P7.
	PIO_OSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_OSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_OSR_P8      = 0x100      // Bit P8.
	PIO_OSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_OSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_OSR_P9      = 0x200      // Bit P9.
	PIO_OSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_OSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_OSR_P10     = 0x400      // Bit P10.
	PIO_OSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_OSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_OSR_P11     = 0x800      // Bit P11.
	PIO_OSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_OSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_OSR_P12     = 0x1000     // Bit P12.
	PIO_OSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_OSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_OSR_P13     = 0x2000     // Bit P13.
	PIO_OSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_OSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_OSR_P14     = 0x4000     // Bit P14.
	PIO_OSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_OSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_OSR_P15     = 0x8000     // Bit P15.
	PIO_OSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_OSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_OSR_P16     = 0x10000    // Bit P16.
	PIO_OSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_OSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_OSR_P17     = 0x20000    // Bit P17.
	PIO_OSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_OSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_OSR_P18     = 0x40000    // Bit P18.
	PIO_OSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_OSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_OSR_P19     = 0x80000    // Bit P19.
	PIO_OSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_OSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_OSR_P20     = 0x100000   // Bit P20.
	PIO_OSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_OSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_OSR_P21     = 0x200000   // Bit P21.
	PIO_OSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_OSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_OSR_P22     = 0x400000   // Bit P22.
	PIO_OSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_OSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_OSR_P23     = 0x800000   // Bit P23.
	PIO_OSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_OSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_OSR_P24     = 0x1000000  // Bit P24.
	PIO_OSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_OSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_OSR_P25     = 0x2000000  // Bit P25.
	PIO_OSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_OSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_OSR_P26     = 0x4000000  // Bit P26.
	PIO_OSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_OSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_OSR_P27     = 0x8000000  // Bit P27.
	PIO_OSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_OSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_OSR_P28     = 0x10000000 // Bit P28.
	PIO_OSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_OSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_OSR_P29     = 0x20000000 // Bit P29.
	PIO_OSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_OSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_OSR_P30     = 0x40000000 // Bit P30.
	PIO_OSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_OSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_OSR_P31     = 0x80000000 // Bit P31.

	// IFER: Glitch Input Filter Enable Register
	PIO_IFER_P0_Pos  = 0x0        // Position of P0 field.
	PIO_IFER_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_IFER_P0      = 0x1        // Bit P0.
	PIO_IFER_P1_Pos  = 0x1        // Position of P1 field.
	PIO_IFER_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_IFER_P1      = 0x2        // Bit P1.
	PIO_IFER_P2_Pos  = 0x2        // Position of P2 field.
	PIO_IFER_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_IFER_P2      = 0x4        // Bit P2.
	PIO_IFER_P3_Pos  = 0x3        // Position of P3 field.
	PIO_IFER_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_IFER_P3      = 0x8        // Bit P3.
	PIO_IFER_P4_Pos  = 0x4        // Position of P4 field.
	PIO_IFER_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_IFER_P4      = 0x10       // Bit P4.
	PIO_IFER_P5_Pos  = 0x5        // Position of P5 field.
	PIO_IFER_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_IFER_P5      = 0x20       // Bit P5.
	PIO_IFER_P6_Pos  = 0x6        // Position of P6 field.
	PIO_IFER_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_IFER_P6      = 0x40       // Bit P6.
	PIO_IFER_P7_Pos  = 0x7        // Position of P7 field.
	PIO_IFER_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_IFER_P7      = 0x80       // Bit P7.
	PIO_IFER_P8_Pos  = 0x8        // Position of P8 field.
	PIO_IFER_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_IFER_P8      = 0x100      // Bit P8.
	PIO_IFER_P9_Pos  = 0x9        // Position of P9 field.
	PIO_IFER_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_IFER_P9      = 0x200      // Bit P9.
	PIO_IFER_P10_Pos = 0xa        // Position of P10 field.
	PIO_IFER_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_IFER_P10     = 0x400      // Bit P10.
	PIO_IFER_P11_Pos = 0xb        // Position of P11 field.
	PIO_IFER_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_IFER_P11     = 0x800      // Bit P11.
	PIO_IFER_P12_Pos = 0xc        // Position of P12 field.
	PIO_IFER_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_IFER_P12     = 0x1000     // Bit P12.
	PIO_IFER_P13_Pos = 0xd        // Position of P13 field.
	PIO_IFER_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_IFER_P13     = 0x2000     // Bit P13.
	PIO_IFER_P14_Pos = 0xe        // Position of P14 field.
	PIO_IFER_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_IFER_P14     = 0x4000     // Bit P14.
	PIO_IFER_P15_Pos = 0xf        // Position of P15 field.
	PIO_IFER_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_IFER_P15     = 0x8000     // Bit P15.
	PIO_IFER_P16_Pos = 0x10       // Position of P16 field.
	PIO_IFER_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_IFER_P16     = 0x10000    // Bit P16.
	PIO_IFER_P17_Pos = 0x11       // Position of P17 field.
	PIO_IFER_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_IFER_P17     = 0x20000    // Bit P17.
	PIO_IFER_P18_Pos = 0x12       // Position of P18 field.
	PIO_IFER_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_IFER_P18     = 0x40000    // Bit P18.
	PIO_IFER_P19_Pos = 0x13       // Position of P19 field.
	PIO_IFER_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_IFER_P19     = 0x80000    // Bit P19.
	PIO_IFER_P20_Pos = 0x14       // Position of P20 field.
	PIO_IFER_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_IFER_P20     = 0x100000   // Bit P20.
	PIO_IFER_P21_Pos = 0x15       // Position of P21 field.
	PIO_IFER_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_IFER_P21     = 0x200000   // Bit P21.
	PIO_IFER_P22_Pos = 0x16       // Position of P22 field.
	PIO_IFER_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_IFER_P22     = 0x400000   // Bit P22.
	PIO_IFER_P23_Pos = 0x17       // Position of P23 field.
	PIO_IFER_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_IFER_P23     = 0x800000   // Bit P23.
	PIO_IFER_P24_Pos = 0x18       // Position of P24 field.
	PIO_IFER_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_IFER_P24     = 0x1000000  // Bit P24.
	PIO_IFER_P25_Pos = 0x19       // Position of P25 field.
	PIO_IFER_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_IFER_P25     = 0x2000000  // Bit P25.
	PIO_IFER_P26_Pos = 0x1a       // Position of P26 field.
	PIO_IFER_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_IFER_P26     = 0x4000000  // Bit P26.
	PIO_IFER_P27_Pos = 0x1b       // Position of P27 field.
	PIO_IFER_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_IFER_P27     = 0x8000000  // Bit P27.
	PIO_IFER_P28_Pos = 0x1c       // Position of P28 field.
	PIO_IFER_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_IFER_P28     = 0x10000000 // Bit P28.
	PIO_IFER_P29_Pos = 0x1d       // Position of P29 field.
	PIO_IFER_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_IFER_P29     = 0x20000000 // Bit P29.
	PIO_IFER_P30_Pos = 0x1e       // Position of P30 field.
	PIO_IFER_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_IFER_P30     = 0x40000000 // Bit P30.
	PIO_IFER_P31_Pos = 0x1f       // Position of P31 field.
	PIO_IFER_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_IFER_P31     = 0x80000000 // Bit P31.

	// IFDR: Glitch Input Filter Disable Register
	PIO_IFDR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_IFDR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_IFDR_P0      = 0x1        // Bit P0.
	PIO_IFDR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_IFDR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_IFDR_P1      = 0x2        // Bit P1.
	PIO_IFDR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_IFDR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_IFDR_P2      = 0x4        // Bit P2.
	PIO_IFDR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_IFDR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_IFDR_P3      = 0x8        // Bit P3.
	PIO_IFDR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_IFDR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_IFDR_P4      = 0x10       // Bit P4.
	PIO_IFDR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_IFDR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_IFDR_P5      = 0x20       // Bit P5.
	PIO_IFDR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_IFDR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_IFDR_P6      = 0x40       // Bit P6.
	PIO_IFDR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_IFDR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_IFDR_P7      = 0x80       // Bit P7.
	PIO_IFDR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_IFDR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_IFDR_P8      = 0x100      // Bit P8.
	PIO_IFDR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_IFDR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_IFDR_P9      = 0x200      // Bit P9.
	PIO_IFDR_P10_Pos = 0xa        // Position of P10 field.
	PIO_IFDR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_IFDR_P10     = 0x400      // Bit P10.
	PIO_IFDR_P11_Pos = 0xb        // Position of P11 field.
	PIO_IFDR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_IFDR_P11     = 0x800      // Bit P11.
	PIO_IFDR_P12_Pos = 0xc        // Position of P12 field.
	PIO_IFDR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_IFDR_P12     = 0x1000     // Bit P12.
	PIO_IFDR_P13_Pos = 0xd        // Position of P13 field.
	PIO_IFDR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_IFDR_P13     = 0x2000     // Bit P13.
	PIO_IFDR_P14_Pos = 0xe        // Position of P14 field.
	PIO_IFDR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_IFDR_P14     = 0x4000     // Bit P14.
	PIO_IFDR_P15_Pos = 0xf        // Position of P15 field.
	PIO_IFDR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_IFDR_P15     = 0x8000     // Bit P15.
	PIO_IFDR_P16_Pos = 0x10       // Position of P16 field.
	PIO_IFDR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_IFDR_P16     = 0x10000    // Bit P16.
	PIO_IFDR_P17_Pos = 0x11       // Position of P17 field.
	PIO_IFDR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_IFDR_P17     = 0x20000    // Bit P17.
	PIO_IFDR_P18_Pos = 0x12       // Position of P18 field.
	PIO_IFDR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_IFDR_P18     = 0x40000    // Bit P18.
	PIO_IFDR_P19_Pos = 0x13       // Position of P19 field.
	PIO_IFDR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_IFDR_P19     = 0x80000    // Bit P19.
	PIO_IFDR_P20_Pos = 0x14       // Position of P20 field.
	PIO_IFDR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_IFDR_P20     = 0x100000   // Bit P20.
	PIO_IFDR_P21_Pos = 0x15       // Position of P21 field.
	PIO_IFDR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_IFDR_P21     = 0x200000   // Bit P21.
	PIO_IFDR_P22_Pos = 0x16       // Position of P22 field.
	PIO_IFDR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_IFDR_P22     = 0x400000   // Bit P22.
	PIO_IFDR_P23_Pos = 0x17       // Position of P23 field.
	PIO_IFDR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_IFDR_P23     = 0x800000   // Bit P23.
	PIO_IFDR_P24_Pos = 0x18       // Position of P24 field.
	PIO_IFDR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_IFDR_P24     = 0x1000000  // Bit P24.
	PIO_IFDR_P25_Pos = 0x19       // Position of P25 field.
	PIO_IFDR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_IFDR_P25     = 0x2000000  // Bit P25.
	PIO_IFDR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_IFDR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_IFDR_P26     = 0x4000000  // Bit P26.
	PIO_IFDR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_IFDR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_IFDR_P27     = 0x8000000  // Bit P27.
	PIO_IFDR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_IFDR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_IFDR_P28     = 0x10000000 // Bit P28.
	PIO_IFDR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_IFDR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_IFDR_P29     = 0x20000000 // Bit P29.
	PIO_IFDR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_IFDR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_IFDR_P30     = 0x40000000 // Bit P30.
	PIO_IFDR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_IFDR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_IFDR_P31     = 0x80000000 // Bit P31.

	// IFSR: Glitch Input Filter Status Register
	PIO_IFSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_IFSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_IFSR_P0      = 0x1        // Bit P0.
	PIO_IFSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_IFSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_IFSR_P1      = 0x2        // Bit P1.
	PIO_IFSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_IFSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_IFSR_P2      = 0x4        // Bit P2.
	PIO_IFSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_IFSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_IFSR_P3      = 0x8        // Bit P3.
	PIO_IFSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_IFSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_IFSR_P4      = 0x10       // Bit P4.
	PIO_IFSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_IFSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_IFSR_P5      = 0x20       // Bit P5.
	PIO_IFSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_IFSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_IFSR_P6      = 0x40       // Bit P6.
	PIO_IFSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_IFSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_IFSR_P7      = 0x80       // Bit P7.
	PIO_IFSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_IFSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_IFSR_P8      = 0x100      // Bit P8.
	PIO_IFSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_IFSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_IFSR_P9      = 0x200      // Bit P9.
	PIO_IFSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_IFSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_IFSR_P10     = 0x400      // Bit P10.
	PIO_IFSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_IFSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_IFSR_P11     = 0x800      // Bit P11.
	PIO_IFSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_IFSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_IFSR_P12     = 0x1000     // Bit P12.
	PIO_IFSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_IFSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_IFSR_P13     = 0x2000     // Bit P13.
	PIO_IFSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_IFSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_IFSR_P14     = 0x4000     // Bit P14.
	PIO_IFSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_IFSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_IFSR_P15     = 0x8000     // Bit P15.
	PIO_IFSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_IFSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_IFSR_P16     = 0x10000    // Bit P16.
	PIO_IFSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_IFSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_IFSR_P17     = 0x20000    // Bit P17.
	PIO_IFSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_IFSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_IFSR_P18     = 0x40000    // Bit P18.
	PIO_IFSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_IFSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_IFSR_P19     = 0x80000    // Bit P19.
	PIO_IFSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_IFSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_IFSR_P20     = 0x100000   // Bit P20.
	PIO_IFSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_IFSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_IFSR_P21     = 0x200000   // Bit P21.
	PIO_IFSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_IFSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_IFSR_P22     = 0x400000   // Bit P22.
	PIO_IFSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_IFSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_IFSR_P23     = 0x800000   // Bit P23.
	PIO_IFSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_IFSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_IFSR_P24     = 0x1000000  // Bit P24.
	PIO_IFSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_IFSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_IFSR_P25     = 0x2000000  // Bit P25.
	PIO_IFSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_IFSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_IFSR_P26     = 0x4000000  // Bit P26.
	PIO_IFSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_IFSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_IFSR_P27     = 0x8000000  // Bit P27.
	PIO_IFSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_IFSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_IFSR_P28     = 0x10000000 // Bit P28.
	PIO_IFSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_IFSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_IFSR_P29     = 0x20000000 // Bit P29.
	PIO_IFSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_IFSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_IFSR_P30     = 0x40000000 // Bit P30.
	PIO_IFSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_IFSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_IFSR_P31     = 0x80000000 // Bit P31.

	// SODR: Set Output Data Register
	PIO_SODR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_SODR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_SODR_P0      = 0x1        // Bit P0.
	PIO_SODR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_SODR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_SODR_P1      = 0x2        // Bit P1.
	PIO_SODR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_SODR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_SODR_P2      = 0x4        // Bit P2.
	PIO_SODR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_SODR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_SODR_P3      = 0x8        // Bit P3.
	PIO_SODR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_SODR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_SODR_P4      = 0x10       // Bit P4.
	PIO_SODR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_SODR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_SODR_P5      = 0x20       // Bit P5.
	PIO_SODR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_SODR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_SODR_P6      = 0x40       // Bit P6.
	PIO_SODR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_SODR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_SODR_P7      = 0x80       // Bit P7.
	PIO_SODR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_SODR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_SODR_P8      = 0x100      // Bit P8.
	PIO_SODR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_SODR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_SODR_P9      = 0x200      // Bit P9.
	PIO_SODR_P10_Pos = 0xa        // Position of P10 field.
	PIO_SODR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_SODR_P10     = 0x400      // Bit P10.
	PIO_SODR_P11_Pos = 0xb        // Position of P11 field.
	PIO_SODR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_SODR_P11     = 0x800      // Bit P11.
	PIO_SODR_P12_Pos = 0xc        // Position of P12 field.
	PIO_SODR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_SODR_P12     = 0x1000     // Bit P12.
	PIO_SODR_P13_Pos = 0xd        // Position of P13 field.
	PIO_SODR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_SODR_P13     = 0x2000     // Bit P13.
	PIO_SODR_P14_Pos = 0xe        // Position of P14 field.
	PIO_SODR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_SODR_P14     = 0x4000     // Bit P14.
	PIO_SODR_P15_Pos = 0xf        // Position of P15 field.
	PIO_SODR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_SODR_P15     = 0x8000     // Bit P15.
	PIO_SODR_P16_Pos = 0x10       // Position of P16 field.
	PIO_SODR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_SODR_P16     = 0x10000    // Bit P16.
	PIO_SODR_P17_Pos = 0x11       // Position of P17 field.
	PIO_SODR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_SODR_P17     = 0x20000    // Bit P17.
	PIO_SODR_P18_Pos = 0x12       // Position of P18 field.
	PIO_SODR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_SODR_P18     = 0x40000    // Bit P18.
	PIO_SODR_P19_Pos = 0x13       // Position of P19 field.
	PIO_SODR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_SODR_P19     = 0x80000    // Bit P19.
	PIO_SODR_P20_Pos = 0x14       // Position of P20 field.
	PIO_SODR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_SODR_P20     = 0x100000   // Bit P20.
	PIO_SODR_P21_Pos = 0x15       // Position of P21 field.
	PIO_SODR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_SODR_P21     = 0x200000   // Bit P21.
	PIO_SODR_P22_Pos = 0x16       // Position of P22 field.
	PIO_SODR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_SODR_P22     = 0x400000   // Bit P22.
	PIO_SODR_P23_Pos = 0x17       // Position of P23 field.
	PIO_SODR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_SODR_P23     = 0x800000   // Bit P23.
	PIO_SODR_P24_Pos = 0x18       // Position of P24 field.
	PIO_SODR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_SODR_P24     = 0x1000000  // Bit P24.
	PIO_SODR_P25_Pos = 0x19       // Position of P25 field.
	PIO_SODR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_SODR_P25     = 0x2000000  // Bit P25.
	PIO_SODR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_SODR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_SODR_P26     = 0x4000000  // Bit P26.
	PIO_SODR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_SODR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_SODR_P27     = 0x8000000  // Bit P27.
	PIO_SODR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_SODR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_SODR_P28     = 0x10000000 // Bit P28.
	PIO_SODR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_SODR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_SODR_P29     = 0x20000000 // Bit P29.
	PIO_SODR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_SODR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_SODR_P30     = 0x40000000 // Bit P30.
	PIO_SODR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_SODR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_SODR_P31     = 0x80000000 // Bit P31.

	// CODR: Clear Output Data Register
	PIO_CODR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_CODR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_CODR_P0      = 0x1        // Bit P0.
	PIO_CODR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_CODR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_CODR_P1      = 0x2        // Bit P1.
	PIO_CODR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_CODR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_CODR_P2      = 0x4        // Bit P2.
	PIO_CODR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_CODR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_CODR_P3      = 0x8        // Bit P3.
	PIO_CODR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_CODR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_CODR_P4      = 0x10       // Bit P4.
	PIO_CODR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_CODR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_CODR_P5      = 0x20       // Bit P5.
	PIO_CODR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_CODR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_CODR_P6      = 0x40       // Bit P6.
	PIO_CODR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_CODR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_CODR_P7      = 0x80       // Bit P7.
	PIO_CODR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_CODR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_CODR_P8      = 0x100      // Bit P8.
	PIO_CODR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_CODR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_CODR_P9      = 0x200      // Bit P9.
	PIO_CODR_P10_Pos = 0xa        // Position of P10 field.
	PIO_CODR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_CODR_P10     = 0x400      // Bit P10.
	PIO_CODR_P11_Pos = 0xb        // Position of P11 field.
	PIO_CODR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_CODR_P11     = 0x800      // Bit P11.
	PIO_CODR_P12_Pos = 0xc        // Position of P12 field.
	PIO_CODR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_CODR_P12     = 0x1000     // Bit P12.
	PIO_CODR_P13_Pos = 0xd        // Position of P13 field.
	PIO_CODR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_CODR_P13     = 0x2000     // Bit P13.
	PIO_CODR_P14_Pos = 0xe        // Position of P14 field.
	PIO_CODR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_CODR_P14     = 0x4000     // Bit P14.
	PIO_CODR_P15_Pos = 0xf        // Position of P15 field.
	PIO_CODR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_CODR_P15     = 0x8000     // Bit P15.
	PIO_CODR_P16_Pos = 0x10       // Position of P16 field.
	PIO_CODR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_CODR_P16     = 0x10000    // Bit P16.
	PIO_CODR_P17_Pos = 0x11       // Position of P17 field.
	PIO_CODR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_CODR_P17     = 0x20000    // Bit P17.
	PIO_CODR_P18_Pos = 0x12       // Position of P18 field.
	PIO_CODR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_CODR_P18     = 0x40000    // Bit P18.
	PIO_CODR_P19_Pos = 0x13       // Position of P19 field.
	PIO_CODR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_CODR_P19     = 0x80000    // Bit P19.
	PIO_CODR_P20_Pos = 0x14       // Position of P20 field.
	PIO_CODR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_CODR_P20     = 0x100000   // Bit P20.
	PIO_CODR_P21_Pos = 0x15       // Position of P21 field.
	PIO_CODR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_CODR_P21     = 0x200000   // Bit P21.
	PIO_CODR_P22_Pos = 0x16       // Position of P22 field.
	PIO_CODR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_CODR_P22     = 0x400000   // Bit P22.
	PIO_CODR_P23_Pos = 0x17       // Position of P23 field.
	PIO_CODR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_CODR_P23     = 0x800000   // Bit P23.
	PIO_CODR_P24_Pos = 0x18       // Position of P24 field.
	PIO_CODR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_CODR_P24     = 0x1000000  // Bit P24.
	PIO_CODR_P25_Pos = 0x19       // Position of P25 field.
	PIO_CODR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_CODR_P25     = 0x2000000  // Bit P25.
	PIO_CODR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_CODR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_CODR_P26     = 0x4000000  // Bit P26.
	PIO_CODR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_CODR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_CODR_P27     = 0x8000000  // Bit P27.
	PIO_CODR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_CODR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_CODR_P28     = 0x10000000 // Bit P28.
	PIO_CODR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_CODR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_CODR_P29     = 0x20000000 // Bit P29.
	PIO_CODR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_CODR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_CODR_P30     = 0x40000000 // Bit P30.
	PIO_CODR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_CODR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_CODR_P31     = 0x80000000 // Bit P31.

	// ODSR: Output Data Status Register
	PIO_ODSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_ODSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_ODSR_P0      = 0x1        // Bit P0.
	PIO_ODSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_ODSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_ODSR_P1      = 0x2        // Bit P1.
	PIO_ODSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_ODSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_ODSR_P2      = 0x4        // Bit P2.
	PIO_ODSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_ODSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_ODSR_P3      = 0x8        // Bit P3.
	PIO_ODSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_ODSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_ODSR_P4      = 0x10       // Bit P4.
	PIO_ODSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_ODSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_ODSR_P5      = 0x20       // Bit P5.
	PIO_ODSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_ODSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_ODSR_P6      = 0x40       // Bit P6.
	PIO_ODSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_ODSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_ODSR_P7      = 0x80       // Bit P7.
	PIO_ODSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_ODSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_ODSR_P8      = 0x100      // Bit P8.
	PIO_ODSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_ODSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_ODSR_P9      = 0x200      // Bit P9.
	PIO_ODSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_ODSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_ODSR_P10     = 0x400      // Bit P10.
	PIO_ODSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_ODSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_ODSR_P11     = 0x800      // Bit P11.
	PIO_ODSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_ODSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_ODSR_P12     = 0x1000     // Bit P12.
	PIO_ODSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_ODSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_ODSR_P13     = 0x2000     // Bit P13.
	PIO_ODSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_ODSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_ODSR_P14     = 0x4000     // Bit P14.
	PIO_ODSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_ODSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_ODSR_P15     = 0x8000     // Bit P15.
	PIO_ODSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_ODSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_ODSR_P16     = 0x10000    // Bit P16.
	PIO_ODSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_ODSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_ODSR_P17     = 0x20000    // Bit P17.
	PIO_ODSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_ODSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_ODSR_P18     = 0x40000    // Bit P18.
	PIO_ODSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_ODSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_ODSR_P19     = 0x80000    // Bit P19.
	PIO_ODSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_ODSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_ODSR_P20     = 0x100000   // Bit P20.
	PIO_ODSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_ODSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_ODSR_P21     = 0x200000   // Bit P21.
	PIO_ODSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_ODSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_ODSR_P22     = 0x400000   // Bit P22.
	PIO_ODSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_ODSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_ODSR_P23     = 0x800000   // Bit P23.
	PIO_ODSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_ODSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_ODSR_P24     = 0x1000000  // Bit P24.
	PIO_ODSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_ODSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_ODSR_P25     = 0x2000000  // Bit P25.
	PIO_ODSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_ODSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_ODSR_P26     = 0x4000000  // Bit P26.
	PIO_ODSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_ODSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_ODSR_P27     = 0x8000000  // Bit P27.
	PIO_ODSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_ODSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_ODSR_P28     = 0x10000000 // Bit P28.
	PIO_ODSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_ODSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_ODSR_P29     = 0x20000000 // Bit P29.
	PIO_ODSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_ODSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_ODSR_P30     = 0x40000000 // Bit P30.
	PIO_ODSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_ODSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_ODSR_P31     = 0x80000000 // Bit P31.

	// PDSR: Pin Data Status Register
	PIO_PDSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_PDSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_PDSR_P0      = 0x1        // Bit P0.
	PIO_PDSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_PDSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_PDSR_P1      = 0x2        // Bit P1.
	PIO_PDSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_PDSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_PDSR_P2      = 0x4        // Bit P2.
	PIO_PDSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_PDSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_PDSR_P3      = 0x8        // Bit P3.
	PIO_PDSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_PDSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_PDSR_P4      = 0x10       // Bit P4.
	PIO_PDSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_PDSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_PDSR_P5      = 0x20       // Bit P5.
	PIO_PDSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_PDSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_PDSR_P6      = 0x40       // Bit P6.
	PIO_PDSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_PDSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_PDSR_P7      = 0x80       // Bit P7.
	PIO_PDSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_PDSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_PDSR_P8      = 0x100      // Bit P8.
	PIO_PDSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_PDSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_PDSR_P9      = 0x200      // Bit P9.
	PIO_PDSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_PDSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_PDSR_P10     = 0x400      // Bit P10.
	PIO_PDSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_PDSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_PDSR_P11     = 0x800      // Bit P11.
	PIO_PDSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_PDSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_PDSR_P12     = 0x1000     // Bit P12.
	PIO_PDSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_PDSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_PDSR_P13     = 0x2000     // Bit P13.
	PIO_PDSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_PDSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_PDSR_P14     = 0x4000     // Bit P14.
	PIO_PDSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_PDSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_PDSR_P15     = 0x8000     // Bit P15.
	PIO_PDSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_PDSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_PDSR_P16     = 0x10000    // Bit P16.
	PIO_PDSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_PDSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_PDSR_P17     = 0x20000    // Bit P17.
	PIO_PDSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_PDSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_PDSR_P18     = 0x40000    // Bit P18.
	PIO_PDSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_PDSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_PDSR_P19     = 0x80000    // Bit P19.
	PIO_PDSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_PDSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_PDSR_P20     = 0x100000   // Bit P20.
	PIO_PDSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_PDSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_PDSR_P21     = 0x200000   // Bit P21.
	PIO_PDSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_PDSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_PDSR_P22     = 0x400000   // Bit P22.
	PIO_PDSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_PDSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_PDSR_P23     = 0x800000   // Bit P23.
	PIO_PDSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_PDSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_PDSR_P24     = 0x1000000  // Bit P24.
	PIO_PDSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_PDSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_PDSR_P25     = 0x2000000  // Bit P25.
	PIO_PDSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_PDSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_PDSR_P26     = 0x4000000  // Bit P26.
	PIO_PDSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_PDSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_PDSR_P27     = 0x8000000  // Bit P27.
	PIO_PDSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_PDSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_PDSR_P28     = 0x10000000 // Bit P28.
	PIO_PDSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_PDSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_PDSR_P29     = 0x20000000 // Bit P29.
	PIO_PDSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_PDSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_PDSR_P30     = 0x40000000 // Bit P30.
	PIO_PDSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_PDSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_PDSR_P31     = 0x80000000 // Bit P31.

	// IER: Interrupt Enable Register
	PIO_IER_P0_Pos  = 0x0        // Position of P0 field.
	PIO_IER_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_IER_P0      = 0x1        // Bit P0.
	PIO_IER_P1_Pos  = 0x1        // Position of P1 field.
	PIO_IER_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_IER_P1      = 0x2        // Bit P1.
	PIO_IER_P2_Pos  = 0x2        // Position of P2 field.
	PIO_IER_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_IER_P2      = 0x4        // Bit P2.
	PIO_IER_P3_Pos  = 0x3        // Position of P3 field.
	PIO_IER_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_IER_P3      = 0x8        // Bit P3.
	PIO_IER_P4_Pos  = 0x4        // Position of P4 field.
	PIO_IER_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_IER_P4      = 0x10       // Bit P4.
	PIO_IER_P5_Pos  = 0x5        // Position of P5 field.
	PIO_IER_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_IER_P5      = 0x20       // Bit P5.
	PIO_IER_P6_Pos  = 0x6        // Position of P6 field.
	PIO_IER_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_IER_P6      = 0x40       // Bit P6.
	PIO_IER_P7_Pos  = 0x7        // Position of P7 field.
	PIO_IER_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_IER_P7      = 0x80       // Bit P7.
	PIO_IER_P8_Pos  = 0x8        // Position of P8 field.
	PIO_IER_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_IER_P8      = 0x100      // Bit P8.
	PIO_IER_P9_Pos  = 0x9        // Position of P9 field.
	PIO_IER_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_IER_P9      = 0x200      // Bit P9.
	PIO_IER_P10_Pos = 0xa        // Position of P10 field.
	PIO_IER_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_IER_P10     = 0x400      // Bit P10.
	PIO_IER_P11_Pos = 0xb        // Position of P11 field.
	PIO_IER_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_IER_P11     = 0x800      // Bit P11.
	PIO_IER_P12_Pos = 0xc        // Position of P12 field.
	PIO_IER_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_IER_P12     = 0x1000     // Bit P12.
	PIO_IER_P13_Pos = 0xd        // Position of P13 field.
	PIO_IER_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_IER_P13     = 0x2000     // Bit P13.
	PIO_IER_P14_Pos = 0xe        // Position of P14 field.
	PIO_IER_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_IER_P14     = 0x4000     // Bit P14.
	PIO_IER_P15_Pos = 0xf        // Position of P15 field.
	PIO_IER_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_IER_P15     = 0x8000     // Bit P15.
	PIO_IER_P16_Pos = 0x10       // Position of P16 field.
	PIO_IER_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_IER_P16     = 0x10000    // Bit P16.
	PIO_IER_P17_Pos = 0x11       // Position of P17 field.
	PIO_IER_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_IER_P17     = 0x20000    // Bit P17.
	PIO_IER_P18_Pos = 0x12       // Position of P18 field.
	PIO_IER_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_IER_P18     = 0x40000    // Bit P18.
	PIO_IER_P19_Pos = 0x13       // Position of P19 field.
	PIO_IER_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_IER_P19     = 0x80000    // Bit P19.
	PIO_IER_P20_Pos = 0x14       // Position of P20 field.
	PIO_IER_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_IER_P20     = 0x100000   // Bit P20.
	PIO_IER_P21_Pos = 0x15       // Position of P21 field.
	PIO_IER_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_IER_P21     = 0x200000   // Bit P21.
	PIO_IER_P22_Pos = 0x16       // Position of P22 field.
	PIO_IER_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_IER_P22     = 0x400000   // Bit P22.
	PIO_IER_P23_Pos = 0x17       // Position of P23 field.
	PIO_IER_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_IER_P23     = 0x800000   // Bit P23.
	PIO_IER_P24_Pos = 0x18       // Position of P24 field.
	PIO_IER_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_IER_P24     = 0x1000000  // Bit P24.
	PIO_IER_P25_Pos = 0x19       // Position of P25 field.
	PIO_IER_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_IER_P25     = 0x2000000  // Bit P25.
	PIO_IER_P26_Pos = 0x1a       // Position of P26 field.
	PIO_IER_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_IER_P26     = 0x4000000  // Bit P26.
	PIO_IER_P27_Pos = 0x1b       // Position of P27 field.
	PIO_IER_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_IER_P27     = 0x8000000  // Bit P27.
	PIO_IER_P28_Pos = 0x1c       // Position of P28 field.
	PIO_IER_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_IER_P28     = 0x10000000 // Bit P28.
	PIO_IER_P29_Pos = 0x1d       // Position of P29 field.
	PIO_IER_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_IER_P29     = 0x20000000 // Bit P29.
	PIO_IER_P30_Pos = 0x1e       // Position of P30 field.
	PIO_IER_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_IER_P30     = 0x40000000 // Bit P30.
	PIO_IER_P31_Pos = 0x1f       // Position of P31 field.
	PIO_IER_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_IER_P31     = 0x80000000 // Bit P31.

	// IDR: Interrupt Disable Register
	PIO_IDR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_IDR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_IDR_P0      = 0x1        // Bit P0.
	PIO_IDR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_IDR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_IDR_P1      = 0x2        // Bit P1.
	PIO_IDR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_IDR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_IDR_P2      = 0x4        // Bit P2.
	PIO_IDR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_IDR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_IDR_P3      = 0x8        // Bit P3.
	PIO_IDR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_IDR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_IDR_P4      = 0x10       // Bit P4.
	PIO_IDR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_IDR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_IDR_P5      = 0x20       // Bit P5.
	PIO_IDR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_IDR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_IDR_P6      = 0x40       // Bit P6.
	PIO_IDR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_IDR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_IDR_P7      = 0x80       // Bit P7.
	PIO_IDR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_IDR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_IDR_P8      = 0x100      // Bit P8.
	PIO_IDR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_IDR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_IDR_P9      = 0x200      // Bit P9.
	PIO_IDR_P10_Pos = 0xa        // Position of P10 field.
	PIO_IDR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_IDR_P10     = 0x400      // Bit P10.
	PIO_IDR_P11_Pos = 0xb        // Position of P11 field.
	PIO_IDR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_IDR_P11     = 0x800      // Bit P11.
	PIO_IDR_P12_Pos = 0xc        // Position of P12 field.
	PIO_IDR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_IDR_P12     = 0x1000     // Bit P12.
	PIO_IDR_P13_Pos = 0xd        // Position of P13 field.
	PIO_IDR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_IDR_P13     = 0x2000     // Bit P13.
	PIO_IDR_P14_Pos = 0xe        // Position of P14 field.
	PIO_IDR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_IDR_P14     = 0x4000     // Bit P14.
	PIO_IDR_P15_Pos = 0xf        // Position of P15 field.
	PIO_IDR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_IDR_P15     = 0x8000     // Bit P15.
	PIO_IDR_P16_Pos = 0x10       // Position of P16 field.
	PIO_IDR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_IDR_P16     = 0x10000    // Bit P16.
	PIO_IDR_P17_Pos = 0x11       // Position of P17 field.
	PIO_IDR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_IDR_P17     = 0x20000    // Bit P17.
	PIO_IDR_P18_Pos = 0x12       // Position of P18 field.
	PIO_IDR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_IDR_P18     = 0x40000    // Bit P18.
	PIO_IDR_P19_Pos = 0x13       // Position of P19 field.
	PIO_IDR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_IDR_P19     = 0x80000    // Bit P19.
	PIO_IDR_P20_Pos = 0x14       // Position of P20 field.
	PIO_IDR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_IDR_P20     = 0x100000   // Bit P20.
	PIO_IDR_P21_Pos = 0x15       // Position of P21 field.
	PIO_IDR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_IDR_P21     = 0x200000   // Bit P21.
	PIO_IDR_P22_Pos = 0x16       // Position of P22 field.
	PIO_IDR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_IDR_P22     = 0x400000   // Bit P22.
	PIO_IDR_P23_Pos = 0x17       // Position of P23 field.
	PIO_IDR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_IDR_P23     = 0x800000   // Bit P23.
	PIO_IDR_P24_Pos = 0x18       // Position of P24 field.
	PIO_IDR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_IDR_P24     = 0x1000000  // Bit P24.
	PIO_IDR_P25_Pos = 0x19       // Position of P25 field.
	PIO_IDR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_IDR_P25     = 0x2000000  // Bit P25.
	PIO_IDR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_IDR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_IDR_P26     = 0x4000000  // Bit P26.
	PIO_IDR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_IDR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_IDR_P27     = 0x8000000  // Bit P27.
	PIO_IDR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_IDR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_IDR_P28     = 0x10000000 // Bit P28.
	PIO_IDR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_IDR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_IDR_P29     = 0x20000000 // Bit P29.
	PIO_IDR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_IDR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_IDR_P30     = 0x40000000 // Bit P30.
	PIO_IDR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_IDR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_IDR_P31     = 0x80000000 // Bit P31.

	// IMR: Interrupt Mask Register
	PIO_IMR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_IMR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_IMR_P0      = 0x1        // Bit P0.
	PIO_IMR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_IMR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_IMR_P1      = 0x2        // Bit P1.
	PIO_IMR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_IMR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_IMR_P2      = 0x4        // Bit P2.
	PIO_IMR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_IMR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_IMR_P3      = 0x8        // Bit P3.
	PIO_IMR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_IMR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_IMR_P4      = 0x10       // Bit P4.
	PIO_IMR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_IMR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_IMR_P5      = 0x20       // Bit P5.
	PIO_IMR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_IMR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_IMR_P6      = 0x40       // Bit P6.
	PIO_IMR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_IMR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_IMR_P7      = 0x80       // Bit P7.
	PIO_IMR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_IMR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_IMR_P8      = 0x100      // Bit P8.
	PIO_IMR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_IMR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_IMR_P9      = 0x200      // Bit P9.
	PIO_IMR_P10_Pos = 0xa        // Position of P10 field.
	PIO_IMR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_IMR_P10     = 0x400      // Bit P10.
	PIO_IMR_P11_Pos = 0xb        // Position of P11 field.
	PIO_IMR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_IMR_P11     = 0x800      // Bit P11.
	PIO_IMR_P12_Pos = 0xc        // Position of P12 field.
	PIO_IMR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_IMR_P12     = 0x1000     // Bit P12.
	PIO_IMR_P13_Pos = 0xd        // Position of P13 field.
	PIO_IMR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_IMR_P13     = 0x2000     // Bit P13.
	PIO_IMR_P14_Pos = 0xe        // Position of P14 field.
	PIO_IMR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_IMR_P14     = 0x4000     // Bit P14.
	PIO_IMR_P15_Pos = 0xf        // Position of P15 field.
	PIO_IMR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_IMR_P15     = 0x8000     // Bit P15.
	PIO_IMR_P16_Pos = 0x10       // Position of P16 field.
	PIO_IMR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_IMR_P16     = 0x10000    // Bit P16.
	PIO_IMR_P17_Pos = 0x11       // Position of P17 field.
	PIO_IMR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_IMR_P17     = 0x20000    // Bit P17.
	PIO_IMR_P18_Pos = 0x12       // Position of P18 field.
	PIO_IMR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_IMR_P18     = 0x40000    // Bit P18.
	PIO_IMR_P19_Pos = 0x13       // Position of P19 field.
	PIO_IMR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_IMR_P19     = 0x80000    // Bit P19.
	PIO_IMR_P20_Pos = 0x14       // Position of P20 field.
	PIO_IMR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_IMR_P20     = 0x100000   // Bit P20.
	PIO_IMR_P21_Pos = 0x15       // Position of P21 field.
	PIO_IMR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_IMR_P21     = 0x200000   // Bit P21.
	PIO_IMR_P22_Pos = 0x16       // Position of P22 field.
	PIO_IMR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_IMR_P22     = 0x400000   // Bit P22.
	PIO_IMR_P23_Pos = 0x17       // Position of P23 field.
	PIO_IMR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_IMR_P23     = 0x800000   // Bit P23.
	PIO_IMR_P24_Pos = 0x18       // Position of P24 field.
	PIO_IMR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_IMR_P24     = 0x1000000  // Bit P24.
	PIO_IMR_P25_Pos = 0x19       // Position of P25 field.
	PIO_IMR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_IMR_P25     = 0x2000000  // Bit P25.
	PIO_IMR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_IMR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_IMR_P26     = 0x4000000  // Bit P26.
	PIO_IMR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_IMR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_IMR_P27     = 0x8000000  // Bit P27.
	PIO_IMR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_IMR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_IMR_P28     = 0x10000000 // Bit P28.
	PIO_IMR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_IMR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_IMR_P29     = 0x20000000 // Bit P29.
	PIO_IMR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_IMR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_IMR_P30     = 0x40000000 // Bit P30.
	PIO_IMR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_IMR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_IMR_P31     = 0x80000000 // Bit P31.

	// ISR: Interrupt Status Register
	PIO_ISR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_ISR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_ISR_P0      = 0x1        // Bit P0.
	PIO_ISR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_ISR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_ISR_P1      = 0x2        // Bit P1.
	PIO_ISR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_ISR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_ISR_P2      = 0x4        // Bit P2.
	PIO_ISR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_ISR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_ISR_P3      = 0x8        // Bit P3.
	PIO_ISR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_ISR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_ISR_P4      = 0x10       // Bit P4.
	PIO_ISR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_ISR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_ISR_P5      = 0x20       // Bit P5.
	PIO_ISR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_ISR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_ISR_P6      = 0x40       // Bit P6.
	PIO_ISR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_ISR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_ISR_P7      = 0x80       // Bit P7.
	PIO_ISR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_ISR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_ISR_P8      = 0x100      // Bit P8.
	PIO_ISR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_ISR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_ISR_P9      = 0x200      // Bit P9.
	PIO_ISR_P10_Pos = 0xa        // Position of P10 field.
	PIO_ISR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_ISR_P10     = 0x400      // Bit P10.
	PIO_ISR_P11_Pos = 0xb        // Position of P11 field.
	PIO_ISR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_ISR_P11     = 0x800      // Bit P11.
	PIO_ISR_P12_Pos = 0xc        // Position of P12 field.
	PIO_ISR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_ISR_P12     = 0x1000     // Bit P12.
	PIO_ISR_P13_Pos = 0xd        // Position of P13 field.
	PIO_ISR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_ISR_P13     = 0x2000     // Bit P13.
	PIO_ISR_P14_Pos = 0xe        // Position of P14 field.
	PIO_ISR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_ISR_P14     = 0x4000     // Bit P14.
	PIO_ISR_P15_Pos = 0xf        // Position of P15 field.
	PIO_ISR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_ISR_P15     = 0x8000     // Bit P15.
	PIO_ISR_P16_Pos = 0x10       // Position of P16 field.
	PIO_ISR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_ISR_P16     = 0x10000    // Bit P16.
	PIO_ISR_P17_Pos = 0x11       // Position of P17 field.
	PIO_ISR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_ISR_P17     = 0x20000    // Bit P17.
	PIO_ISR_P18_Pos = 0x12       // Position of P18 field.
	PIO_ISR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_ISR_P18     = 0x40000    // Bit P18.
	PIO_ISR_P19_Pos = 0x13       // Position of P19 field.
	PIO_ISR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_ISR_P19     = 0x80000    // Bit P19.
	PIO_ISR_P20_Pos = 0x14       // Position of P20 field.
	PIO_ISR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_ISR_P20     = 0x100000   // Bit P20.
	PIO_ISR_P21_Pos = 0x15       // Position of P21 field.
	PIO_ISR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_ISR_P21     = 0x200000   // Bit P21.
	PIO_ISR_P22_Pos = 0x16       // Position of P22 field.
	PIO_ISR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_ISR_P22     = 0x400000   // Bit P22.
	PIO_ISR_P23_Pos = 0x17       // Position of P23 field.
	PIO_ISR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_ISR_P23     = 0x800000   // Bit P23.
	PIO_ISR_P24_Pos = 0x18       // Position of P24 field.
	PIO_ISR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_ISR_P24     = 0x1000000  // Bit P24.
	PIO_ISR_P25_Pos = 0x19       // Position of P25 field.
	PIO_ISR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_ISR_P25     = 0x2000000  // Bit P25.
	PIO_ISR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_ISR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_ISR_P26     = 0x4000000  // Bit P26.
	PIO_ISR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_ISR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_ISR_P27     = 0x8000000  // Bit P27.
	PIO_ISR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_ISR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_ISR_P28     = 0x10000000 // Bit P28.
	PIO_ISR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_ISR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_ISR_P29     = 0x20000000 // Bit P29.
	PIO_ISR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_ISR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_ISR_P30     = 0x40000000 // Bit P30.
	PIO_ISR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_ISR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_ISR_P31     = 0x80000000 // Bit P31.

	// MDER: Multi-driver Enable Register
	PIO_MDER_P0_Pos  = 0x0        // Position of P0 field.
	PIO_MDER_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_MDER_P0      = 0x1        // Bit P0.
	PIO_MDER_P1_Pos  = 0x1        // Position of P1 field.
	PIO_MDER_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_MDER_P1      = 0x2        // Bit P1.
	PIO_MDER_P2_Pos  = 0x2        // Position of P2 field.
	PIO_MDER_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_MDER_P2      = 0x4        // Bit P2.
	PIO_MDER_P3_Pos  = 0x3        // Position of P3 field.
	PIO_MDER_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_MDER_P3      = 0x8        // Bit P3.
	PIO_MDER_P4_Pos  = 0x4        // Position of P4 field.
	PIO_MDER_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_MDER_P4      = 0x10       // Bit P4.
	PIO_MDER_P5_Pos  = 0x5        // Position of P5 field.
	PIO_MDER_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_MDER_P5      = 0x20       // Bit P5.
	PIO_MDER_P6_Pos  = 0x6        // Position of P6 field.
	PIO_MDER_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_MDER_P6      = 0x40       // Bit P6.
	PIO_MDER_P7_Pos  = 0x7        // Position of P7 field.
	PIO_MDER_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_MDER_P7      = 0x80       // Bit P7.
	PIO_MDER_P8_Pos  = 0x8        // Position of P8 field.
	PIO_MDER_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_MDER_P8      = 0x100      // Bit P8.
	PIO_MDER_P9_Pos  = 0x9        // Position of P9 field.
	PIO_MDER_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_MDER_P9      = 0x200      // Bit P9.
	PIO_MDER_P10_Pos = 0xa        // Position of P10 field.
	PIO_MDER_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_MDER_P10     = 0x400      // Bit P10.
	PIO_MDER_P11_Pos = 0xb        // Position of P11 field.
	PIO_MDER_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_MDER_P11     = 0x800      // Bit P11.
	PIO_MDER_P12_Pos = 0xc        // Position of P12 field.
	PIO_MDER_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_MDER_P12     = 0x1000     // Bit P12.
	PIO_MDER_P13_Pos = 0xd        // Position of P13 field.
	PIO_MDER_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_MDER_P13     = 0x2000     // Bit P13.
	PIO_MDER_P14_Pos = 0xe        // Position of P14 field.
	PIO_MDER_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_MDER_P14     = 0x4000     // Bit P14.
	PIO_MDER_P15_Pos = 0xf        // Position of P15 field.
	PIO_MDER_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_MDER_P15     = 0x8000     // Bit P15.
	PIO_MDER_P16_Pos = 0x10       // Position of P16 field.
	PIO_MDER_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_MDER_P16     = 0x10000    // Bit P16.
	PIO_MDER_P17_Pos = 0x11       // Position of P17 field.
	PIO_MDER_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_MDER_P17     = 0x20000    // Bit P17.
	PIO_MDER_P18_Pos = 0x12       // Position of P18 field.
	PIO_MDER_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_MDER_P18     = 0x40000    // Bit P18.
	PIO_MDER_P19_Pos = 0x13       // Position of P19 field.
	PIO_MDER_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_MDER_P19     = 0x80000    // Bit P19.
	PIO_MDER_P20_Pos = 0x14       // Position of P20 field.
	PIO_MDER_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_MDER_P20     = 0x100000   // Bit P20.
	PIO_MDER_P21_Pos = 0x15       // Position of P21 field.
	PIO_MDER_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_MDER_P21     = 0x200000   // Bit P21.
	PIO_MDER_P22_Pos = 0x16       // Position of P22 field.
	PIO_MDER_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_MDER_P22     = 0x400000   // Bit P22.
	PIO_MDER_P23_Pos = 0x17       // Position of P23 field.
	PIO_MDER_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_MDER_P23     = 0x800000   // Bit P23.
	PIO_MDER_P24_Pos = 0x18       // Position of P24 field.
	PIO_MDER_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_MDER_P24     = 0x1000000  // Bit P24.
	PIO_MDER_P25_Pos = 0x19       // Position of P25 field.
	PIO_MDER_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_MDER_P25     = 0x2000000  // Bit P25.
	PIO_MDER_P26_Pos = 0x1a       // Position of P26 field.
	PIO_MDER_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_MDER_P26     = 0x4000000  // Bit P26.
	PIO_MDER_P27_Pos = 0x1b       // Position of P27 field.
	PIO_MDER_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_MDER_P27     = 0x8000000  // Bit P27.
	PIO_MDER_P28_Pos = 0x1c       // Position of P28 field.
	PIO_MDER_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_MDER_P28     = 0x10000000 // Bit P28.
	PIO_MDER_P29_Pos = 0x1d       // Position of P29 field.
	PIO_MDER_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_MDER_P29     = 0x20000000 // Bit P29.
	PIO_MDER_P30_Pos = 0x1e       // Position of P30 field.
	PIO_MDER_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_MDER_P30     = 0x40000000 // Bit P30.
	PIO_MDER_P31_Pos = 0x1f       // Position of P31 field.
	PIO_MDER_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_MDER_P31     = 0x80000000 // Bit P31.

	// MDDR: Multi-driver Disable Register
	PIO_MDDR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_MDDR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_MDDR_P0      = 0x1        // Bit P0.
	PIO_MDDR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_MDDR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_MDDR_P1      = 0x2        // Bit P1.
	PIO_MDDR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_MDDR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_MDDR_P2      = 0x4        // Bit P2.
	PIO_MDDR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_MDDR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_MDDR_P3      = 0x8        // Bit P3.
	PIO_MDDR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_MDDR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_MDDR_P4      = 0x10       // Bit P4.
	PIO_MDDR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_MDDR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_MDDR_P5      = 0x20       // Bit P5.
	PIO_MDDR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_MDDR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_MDDR_P6      = 0x40       // Bit P6.
	PIO_MDDR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_MDDR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_MDDR_P7      = 0x80       // Bit P7.
	PIO_MDDR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_MDDR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_MDDR_P8      = 0x100      // Bit P8.
	PIO_MDDR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_MDDR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_MDDR_P9      = 0x200      // Bit P9.
	PIO_MDDR_P10_Pos = 0xa        // Position of P10 field.
	PIO_MDDR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_MDDR_P10     = 0x400      // Bit P10.
	PIO_MDDR_P11_Pos = 0xb        // Position of P11 field.
	PIO_MDDR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_MDDR_P11     = 0x800      // Bit P11.
	PIO_MDDR_P12_Pos = 0xc        // Position of P12 field.
	PIO_MDDR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_MDDR_P12     = 0x1000     // Bit P12.
	PIO_MDDR_P13_Pos = 0xd        // Position of P13 field.
	PIO_MDDR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_MDDR_P13     = 0x2000     // Bit P13.
	PIO_MDDR_P14_Pos = 0xe        // Position of P14 field.
	PIO_MDDR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_MDDR_P14     = 0x4000     // Bit P14.
	PIO_MDDR_P15_Pos = 0xf        // Position of P15 field.
	PIO_MDDR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_MDDR_P15     = 0x8000     // Bit P15.
	PIO_MDDR_P16_Pos = 0x10       // Position of P16 field.
	PIO_MDDR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_MDDR_P16     = 0x10000    // Bit P16.
	PIO_MDDR_P17_Pos = 0x11       // Position of P17 field.
	PIO_MDDR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_MDDR_P17     = 0x20000    // Bit P17.
	PIO_MDDR_P18_Pos = 0x12       // Position of P18 field.
	PIO_MDDR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_MDDR_P18     = 0x40000    // Bit P18.
	PIO_MDDR_P19_Pos = 0x13       // Position of P19 field.
	PIO_MDDR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_MDDR_P19     = 0x80000    // Bit P19.
	PIO_MDDR_P20_Pos = 0x14       // Position of P20 field.
	PIO_MDDR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_MDDR_P20     = 0x100000   // Bit P20.
	PIO_MDDR_P21_Pos = 0x15       // Position of P21 field.
	PIO_MDDR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_MDDR_P21     = 0x200000   // Bit P21.
	PIO_MDDR_P22_Pos = 0x16       // Position of P22 field.
	PIO_MDDR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_MDDR_P22     = 0x400000   // Bit P22.
	PIO_MDDR_P23_Pos = 0x17       // Position of P23 field.
	PIO_MDDR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_MDDR_P23     = 0x800000   // Bit P23.
	PIO_MDDR_P24_Pos = 0x18       // Position of P24 field.
	PIO_MDDR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_MDDR_P24     = 0x1000000  // Bit P24.
	PIO_MDDR_P25_Pos = 0x19       // Position of P25 field.
	PIO_MDDR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_MDDR_P25     = 0x2000000  // Bit P25.
	PIO_MDDR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_MDDR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_MDDR_P26     = 0x4000000  // Bit P26.
	PIO_MDDR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_MDDR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_MDDR_P27     = 0x8000000  // Bit P27.
	PIO_MDDR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_MDDR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_MDDR_P28     = 0x10000000 // Bit P28.
	PIO_MDDR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_MDDR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_MDDR_P29     = 0x20000000 // Bit P29.
	PIO_MDDR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_MDDR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_MDDR_P30     = 0x40000000 // Bit P30.
	PIO_MDDR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_MDDR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_MDDR_P31     = 0x80000000 // Bit P31.

	// MDSR: Multi-driver Status Register
	PIO_MDSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_MDSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_MDSR_P0      = 0x1        // Bit P0.
	PIO_MDSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_MDSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_MDSR_P1      = 0x2        // Bit P1.
	PIO_MDSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_MDSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_MDSR_P2      = 0x4        // Bit P2.
	PIO_MDSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_MDSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_MDSR_P3      = 0x8        // Bit P3.
	PIO_MDSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_MDSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_MDSR_P4      = 0x10       // Bit P4.
	PIO_MDSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_MDSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_MDSR_P5      = 0x20       // Bit P5.
	PIO_MDSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_MDSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_MDSR_P6      = 0x40       // Bit P6.
	PIO_MDSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_MDSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_MDSR_P7      = 0x80       // Bit P7.
	PIO_MDSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_MDSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_MDSR_P8      = 0x100      // Bit P8.
	PIO_MDSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_MDSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_MDSR_P9      = 0x200      // Bit P9.
	PIO_MDSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_MDSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_MDSR_P10     = 0x400      // Bit P10.
	PIO_MDSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_MDSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_MDSR_P11     = 0x800      // Bit P11.
	PIO_MDSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_MDSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_MDSR_P12     = 0x1000     // Bit P12.
	PIO_MDSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_MDSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_MDSR_P13     = 0x2000     // Bit P13.
	PIO_MDSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_MDSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_MDSR_P14     = 0x4000     // Bit P14.
	PIO_MDSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_MDSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_MDSR_P15     = 0x8000     // Bit P15.
	PIO_MDSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_MDSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_MDSR_P16     = 0x10000    // Bit P16.
	PIO_MDSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_MDSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_MDSR_P17     = 0x20000    // Bit P17.
	PIO_MDSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_MDSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_MDSR_P18     = 0x40000    // Bit P18.
	PIO_MDSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_MDSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_MDSR_P19     = 0x80000    // Bit P19.
	PIO_MDSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_MDSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_MDSR_P20     = 0x100000   // Bit P20.
	PIO_MDSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_MDSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_MDSR_P21     = 0x200000   // Bit P21.
	PIO_MDSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_MDSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_MDSR_P22     = 0x400000   // Bit P22.
	PIO_MDSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_MDSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_MDSR_P23     = 0x800000   // Bit P23.
	PIO_MDSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_MDSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_MDSR_P24     = 0x1000000  // Bit P24.
	PIO_MDSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_MDSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_MDSR_P25     = 0x2000000  // Bit P25.
	PIO_MDSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_MDSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_MDSR_P26     = 0x4000000  // Bit P26.
	PIO_MDSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_MDSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_MDSR_P27     = 0x8000000  // Bit P27.
	PIO_MDSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_MDSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_MDSR_P28     = 0x10000000 // Bit P28.
	PIO_MDSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_MDSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_MDSR_P29     = 0x20000000 // Bit P29.
	PIO_MDSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_MDSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_MDSR_P30     = 0x40000000 // Bit P30.
	PIO_MDSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_MDSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_MDSR_P31     = 0x80000000 // Bit P31.

	// PUDR: Pull-up Disable Register
	PIO_PUDR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_PUDR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_PUDR_P0      = 0x1        // Bit P0.
	PIO_PUDR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_PUDR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_PUDR_P1      = 0x2        // Bit P1.
	PIO_PUDR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_PUDR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_PUDR_P2      = 0x4        // Bit P2.
	PIO_PUDR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_PUDR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_PUDR_P3      = 0x8        // Bit P3.
	PIO_PUDR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_PUDR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_PUDR_P4      = 0x10       // Bit P4.
	PIO_PUDR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_PUDR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_PUDR_P5      = 0x20       // Bit P5.
	PIO_PUDR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_PUDR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_PUDR_P6      = 0x40       // Bit P6.
	PIO_PUDR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_PUDR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_PUDR_P7      = 0x80       // Bit P7.
	PIO_PUDR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_PUDR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_PUDR_P8      = 0x100      // Bit P8.
	PIO_PUDR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_PUDR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_PUDR_P9      = 0x200      // Bit P9.
	PIO_PUDR_P10_Pos = 0xa        // Position of P10 field.
	PIO_PUDR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_PUDR_P10     = 0x400      // Bit P10.
	PIO_PUDR_P11_Pos = 0xb        // Position of P11 field.
	PIO_PUDR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_PUDR_P11     = 0x800      // Bit P11.
	PIO_PUDR_P12_Pos = 0xc        // Position of P12 field.
	PIO_PUDR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_PUDR_P12     = 0x1000     // Bit P12.
	PIO_PUDR_P13_Pos = 0xd        // Position of P13 field.
	PIO_PUDR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_PUDR_P13     = 0x2000     // Bit P13.
	PIO_PUDR_P14_Pos = 0xe        // Position of P14 field.
	PIO_PUDR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_PUDR_P14     = 0x4000     // Bit P14.
	PIO_PUDR_P15_Pos = 0xf        // Position of P15 field.
	PIO_PUDR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_PUDR_P15     = 0x8000     // Bit P15.
	PIO_PUDR_P16_Pos = 0x10       // Position of P16 field.
	PIO_PUDR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_PUDR_P16     = 0x10000    // Bit P16.
	PIO_PUDR_P17_Pos = 0x11       // Position of P17 field.
	PIO_PUDR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_PUDR_P17     = 0x20000    // Bit P17.
	PIO_PUDR_P18_Pos = 0x12       // Position of P18 field.
	PIO_PUDR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_PUDR_P18     = 0x40000    // Bit P18.
	PIO_PUDR_P19_Pos = 0x13       // Position of P19 field.
	PIO_PUDR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_PUDR_P19     = 0x80000    // Bit P19.
	PIO_PUDR_P20_Pos = 0x14       // Position of P20 field.
	PIO_PUDR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_PUDR_P20     = 0x100000   // Bit P20.
	PIO_PUDR_P21_Pos = 0x15       // Position of P21 field.
	PIO_PUDR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_PUDR_P21     = 0x200000   // Bit P21.
	PIO_PUDR_P22_Pos = 0x16       // Position of P22 field.
	PIO_PUDR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_PUDR_P22     = 0x400000   // Bit P22.
	PIO_PUDR_P23_Pos = 0x17       // Position of P23 field.
	PIO_PUDR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_PUDR_P23     = 0x800000   // Bit P23.
	PIO_PUDR_P24_Pos = 0x18       // Position of P24 field.
	PIO_PUDR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_PUDR_P24     = 0x1000000  // Bit P24.
	PIO_PUDR_P25_Pos = 0x19       // Position of P25 field.
	PIO_PUDR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_PUDR_P25     = 0x2000000  // Bit P25.
	PIO_PUDR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_PUDR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_PUDR_P26     = 0x4000000  // Bit P26.
	PIO_PUDR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_PUDR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_PUDR_P27     = 0x8000000  // Bit P27.
	PIO_PUDR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_PUDR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_PUDR_P28     = 0x10000000 // Bit P28.
	PIO_PUDR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_PUDR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_PUDR_P29     = 0x20000000 // Bit P29.
	PIO_PUDR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_PUDR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_PUDR_P30     = 0x40000000 // Bit P30.
	PIO_PUDR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_PUDR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_PUDR_P31     = 0x80000000 // Bit P31.

	// PUER: Pull-up Enable Register
	PIO_PUER_P0_Pos  = 0x0        // Position of P0 field.
	PIO_PUER_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_PUER_P0      = 0x1        // Bit P0.
	PIO_PUER_P1_Pos  = 0x1        // Position of P1 field.
	PIO_PUER_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_PUER_P1      = 0x2        // Bit P1.
	PIO_PUER_P2_Pos  = 0x2        // Position of P2 field.
	PIO_PUER_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_PUER_P2      = 0x4        // Bit P2.
	PIO_PUER_P3_Pos  = 0x3        // Position of P3 field.
	PIO_PUER_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_PUER_P3      = 0x8        // Bit P3.
	PIO_PUER_P4_Pos  = 0x4        // Position of P4 field.
	PIO_PUER_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_PUER_P4      = 0x10       // Bit P4.
	PIO_PUER_P5_Pos  = 0x5        // Position of P5 field.
	PIO_PUER_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_PUER_P5      = 0x20       // Bit P5.
	PIO_PUER_P6_Pos  = 0x6        // Position of P6 field.
	PIO_PUER_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_PUER_P6      = 0x40       // Bit P6.
	PIO_PUER_P7_Pos  = 0x7        // Position of P7 field.
	PIO_PUER_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_PUER_P7      = 0x80       // Bit P7.
	PIO_PUER_P8_Pos  = 0x8        // Position of P8 field.
	PIO_PUER_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_PUER_P8      = 0x100      // Bit P8.
	PIO_PUER_P9_Pos  = 0x9        // Position of P9 field.
	PIO_PUER_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_PUER_P9      = 0x200      // Bit P9.
	PIO_PUER_P10_Pos = 0xa        // Position of P10 field.
	PIO_PUER_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_PUER_P10     = 0x400      // Bit P10.
	PIO_PUER_P11_Pos = 0xb        // Position of P11 field.
	PIO_PUER_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_PUER_P11     = 0x800      // Bit P11.
	PIO_PUER_P12_Pos = 0xc        // Position of P12 field.
	PIO_PUER_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_PUER_P12     = 0x1000     // Bit P12.
	PIO_PUER_P13_Pos = 0xd        // Position of P13 field.
	PIO_PUER_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_PUER_P13     = 0x2000     // Bit P13.
	PIO_PUER_P14_Pos = 0xe        // Position of P14 field.
	PIO_PUER_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_PUER_P14     = 0x4000     // Bit P14.
	PIO_PUER_P15_Pos = 0xf        // Position of P15 field.
	PIO_PUER_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_PUER_P15     = 0x8000     // Bit P15.
	PIO_PUER_P16_Pos = 0x10       // Position of P16 field.
	PIO_PUER_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_PUER_P16     = 0x10000    // Bit P16.
	PIO_PUER_P17_Pos = 0x11       // Position of P17 field.
	PIO_PUER_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_PUER_P17     = 0x20000    // Bit P17.
	PIO_PUER_P18_Pos = 0x12       // Position of P18 field.
	PIO_PUER_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_PUER_P18     = 0x40000    // Bit P18.
	PIO_PUER_P19_Pos = 0x13       // Position of P19 field.
	PIO_PUER_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_PUER_P19     = 0x80000    // Bit P19.
	PIO_PUER_P20_Pos = 0x14       // Position of P20 field.
	PIO_PUER_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_PUER_P20     = 0x100000   // Bit P20.
	PIO_PUER_P21_Pos = 0x15       // Position of P21 field.
	PIO_PUER_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_PUER_P21     = 0x200000   // Bit P21.
	PIO_PUER_P22_Pos = 0x16       // Position of P22 field.
	PIO_PUER_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_PUER_P22     = 0x400000   // Bit P22.
	PIO_PUER_P23_Pos = 0x17       // Position of P23 field.
	PIO_PUER_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_PUER_P23     = 0x800000   // Bit P23.
	PIO_PUER_P24_Pos = 0x18       // Position of P24 field.
	PIO_PUER_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_PUER_P24     = 0x1000000  // Bit P24.
	PIO_PUER_P25_Pos = 0x19       // Position of P25 field.
	PIO_PUER_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_PUER_P25     = 0x2000000  // Bit P25.
	PIO_PUER_P26_Pos = 0x1a       // Position of P26 field.
	PIO_PUER_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_PUER_P26     = 0x4000000  // Bit P26.
	PIO_PUER_P27_Pos = 0x1b       // Position of P27 field.
	PIO_PUER_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_PUER_P27     = 0x8000000  // Bit P27.
	PIO_PUER_P28_Pos = 0x1c       // Position of P28 field.
	PIO_PUER_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_PUER_P28     = 0x10000000 // Bit P28.
	PIO_PUER_P29_Pos = 0x1d       // Position of P29 field.
	PIO_PUER_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_PUER_P29     = 0x20000000 // Bit P29.
	PIO_PUER_P30_Pos = 0x1e       // Position of P30 field.
	PIO_PUER_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_PUER_P30     = 0x40000000 // Bit P30.
	PIO_PUER_P31_Pos = 0x1f       // Position of P31 field.
	PIO_PUER_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_PUER_P31     = 0x80000000 // Bit P31.

	// PUSR: Pad Pull-up Status Register
	PIO_PUSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_PUSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_PUSR_P0      = 0x1        // Bit P0.
	PIO_PUSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_PUSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_PUSR_P1      = 0x2        // Bit P1.
	PIO_PUSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_PUSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_PUSR_P2      = 0x4        // Bit P2.
	PIO_PUSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_PUSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_PUSR_P3      = 0x8        // Bit P3.
	PIO_PUSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_PUSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_PUSR_P4      = 0x10       // Bit P4.
	PIO_PUSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_PUSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_PUSR_P5      = 0x20       // Bit P5.
	PIO_PUSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_PUSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_PUSR_P6      = 0x40       // Bit P6.
	PIO_PUSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_PUSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_PUSR_P7      = 0x80       // Bit P7.
	PIO_PUSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_PUSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_PUSR_P8      = 0x100      // Bit P8.
	PIO_PUSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_PUSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_PUSR_P9      = 0x200      // Bit P9.
	PIO_PUSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_PUSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_PUSR_P10     = 0x400      // Bit P10.
	PIO_PUSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_PUSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_PUSR_P11     = 0x800      // Bit P11.
	PIO_PUSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_PUSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_PUSR_P12     = 0x1000     // Bit P12.
	PIO_PUSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_PUSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_PUSR_P13     = 0x2000     // Bit P13.
	PIO_PUSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_PUSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_PUSR_P14     = 0x4000     // Bit P14.
	PIO_PUSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_PUSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_PUSR_P15     = 0x8000     // Bit P15.
	PIO_PUSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_PUSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_PUSR_P16     = 0x10000    // Bit P16.
	PIO_PUSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_PUSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_PUSR_P17     = 0x20000    // Bit P17.
	PIO_PUSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_PUSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_PUSR_P18     = 0x40000    // Bit P18.
	PIO_PUSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_PUSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_PUSR_P19     = 0x80000    // Bit P19.
	PIO_PUSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_PUSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_PUSR_P20     = 0x100000   // Bit P20.
	PIO_PUSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_PUSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_PUSR_P21     = 0x200000   // Bit P21.
	PIO_PUSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_PUSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_PUSR_P22     = 0x400000   // Bit P22.
	PIO_PUSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_PUSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_PUSR_P23     = 0x800000   // Bit P23.
	PIO_PUSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_PUSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_PUSR_P24     = 0x1000000  // Bit P24.
	PIO_PUSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_PUSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_PUSR_P25     = 0x2000000  // Bit P25.
	PIO_PUSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_PUSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_PUSR_P26     = 0x4000000  // Bit P26.
	PIO_PUSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_PUSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_PUSR_P27     = 0x8000000  // Bit P27.
	PIO_PUSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_PUSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_PUSR_P28     = 0x10000000 // Bit P28.
	PIO_PUSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_PUSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_PUSR_P29     = 0x20000000 // Bit P29.
	PIO_PUSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_PUSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_PUSR_P30     = 0x40000000 // Bit P30.
	PIO_PUSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_PUSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_PUSR_P31     = 0x80000000 // Bit P31.

	// ASR: Peripheral A Select Register
	PIO_ASR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_ASR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_ASR_P0      = 0x1        // Bit P0.
	PIO_ASR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_ASR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_ASR_P1      = 0x2        // Bit P1.
	PIO_ASR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_ASR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_ASR_P2      = 0x4        // Bit P2.
	PIO_ASR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_ASR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_ASR_P3      = 0x8        // Bit P3.
	PIO_ASR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_ASR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_ASR_P4      = 0x10       // Bit P4.
	PIO_ASR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_ASR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_ASR_P5      = 0x20       // Bit P5.
	PIO_ASR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_ASR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_ASR_P6      = 0x40       // Bit P6.
	PIO_ASR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_ASR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_ASR_P7      = 0x80       // Bit P7.
	PIO_ASR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_ASR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_ASR_P8      = 0x100      // Bit P8.
	PIO_ASR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_ASR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_ASR_P9      = 0x200      // Bit P9.
	PIO_ASR_P10_Pos = 0xa        // Position of P10 field.
	PIO_ASR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_ASR_P10     = 0x400      // Bit P10.
	PIO_ASR_P11_Pos = 0xb        // Position of P11 field.
	PIO_ASR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_ASR_P11     = 0x800      // Bit P11.
	PIO_ASR_P12_Pos = 0xc        // Position of P12 field.
	PIO_ASR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_ASR_P12     = 0x1000     // Bit P12.
	PIO_ASR_P13_Pos = 0xd        // Position of P13 field.
	PIO_ASR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_ASR_P13     = 0x2000     // Bit P13.
	PIO_ASR_P14_Pos = 0xe        // Position of P14 field.
	PIO_ASR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_ASR_P14     = 0x4000     // Bit P14.
	PIO_ASR_P15_Pos = 0xf        // Position of P15 field.
	PIO_ASR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_ASR_P15     = 0x8000     // Bit P15.
	PIO_ASR_P16_Pos = 0x10       // Position of P16 field.
	PIO_ASR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_ASR_P16     = 0x10000    // Bit P16.
	PIO_ASR_P17_Pos = 0x11       // Position of P17 field.
	PIO_ASR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_ASR_P17     = 0x20000    // Bit P17.
	PIO_ASR_P18_Pos = 0x12       // Position of P18 field.
	PIO_ASR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_ASR_P18     = 0x40000    // Bit P18.
	PIO_ASR_P19_Pos = 0x13       // Position of P19 field.
	PIO_ASR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_ASR_P19     = 0x80000    // Bit P19.
	PIO_ASR_P20_Pos = 0x14       // Position of P20 field.
	PIO_ASR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_ASR_P20     = 0x100000   // Bit P20.
	PIO_ASR_P21_Pos = 0x15       // Position of P21 field.
	PIO_ASR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_ASR_P21     = 0x200000   // Bit P21.
	PIO_ASR_P22_Pos = 0x16       // Position of P22 field.
	PIO_ASR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_ASR_P22     = 0x400000   // Bit P22.
	PIO_ASR_P23_Pos = 0x17       // Position of P23 field.
	PIO_ASR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_ASR_P23     = 0x800000   // Bit P23.
	PIO_ASR_P24_Pos = 0x18       // Position of P24 field.
	PIO_ASR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_ASR_P24     = 0x1000000  // Bit P24.
	PIO_ASR_P25_Pos = 0x19       // Position of P25 field.
	PIO_ASR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_ASR_P25     = 0x2000000  // Bit P25.
	PIO_ASR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_ASR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_ASR_P26     = 0x4000000  // Bit P26.
	PIO_ASR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_ASR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_ASR_P27     = 0x8000000  // Bit P27.
	PIO_ASR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_ASR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_ASR_P28     = 0x10000000 // Bit P28.
	PIO_ASR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_ASR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_ASR_P29     = 0x20000000 // Bit P29.
	PIO_ASR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_ASR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_ASR_P30     = 0x40000000 // Bit P30.
	PIO_ASR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_ASR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_ASR_P31     = 0x80000000 // Bit P31.

	// BSR: Peripheral B Select Register
	PIO_BSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_BSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_BSR_P0      = 0x1        // Bit P0.
	PIO_BSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_BSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_BSR_P1      = 0x2        // Bit P1.
	PIO_BSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_BSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_BSR_P2      = 0x4        // Bit P2.
	PIO_BSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_BSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_BSR_P3      = 0x8        // Bit P3.
	PIO_BSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_BSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_BSR_P4      = 0x10       // Bit P4.
	PIO_BSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_BSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_BSR_P5      = 0x20       // Bit P5.
	PIO_BSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_BSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_BSR_P6      = 0x40       // Bit P6.
	PIO_BSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_BSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_BSR_P7      = 0x80       // Bit P7.
	PIO_BSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_BSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_BSR_P8      = 0x100      // Bit P8.
	PIO_BSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_BSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_BSR_P9      = 0x200      // Bit P9.
	PIO_BSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_BSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_BSR_P10     = 0x400      // Bit P10.
	PIO_BSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_BSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_BSR_P11     = 0x800      // Bit P11.
	PIO_BSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_BSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_BSR_P12     = 0x1000     // Bit P12.
	PIO_BSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_BSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_BSR_P13     = 0x2000     // Bit P13.
	PIO_BSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_BSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_BSR_P14     = 0x4000     // Bit P14.
	PIO_BSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_BSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_BSR_P15     = 0x8000     // Bit P15.
	PIO_BSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_BSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_BSR_P16     = 0x10000    // Bit P16.
	PIO_BSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_BSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_BSR_P17     = 0x20000    // Bit P17.
	PIO_BSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_BSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_BSR_P18     = 0x40000    // Bit P18.
	PIO_BSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_BSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_BSR_P19     = 0x80000    // Bit P19.
	PIO_BSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_BSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_BSR_P20     = 0x100000   // Bit P20.
	PIO_BSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_BSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_BSR_P21     = 0x200000   // Bit P21.
	PIO_BSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_BSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_BSR_P22     = 0x400000   // Bit P22.
	PIO_BSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_BSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_BSR_P23     = 0x800000   // Bit P23.
	PIO_BSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_BSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_BSR_P24     = 0x1000000  // Bit P24.
	PIO_BSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_BSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_BSR_P25     = 0x2000000  // Bit P25.
	PIO_BSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_BSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_BSR_P26     = 0x4000000  // Bit P26.
	PIO_BSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_BSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_BSR_P27     = 0x8000000  // Bit P27.
	PIO_BSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_BSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_BSR_P28     = 0x10000000 // Bit P28.
	PIO_BSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_BSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_BSR_P29     = 0x20000000 // Bit P29.
	PIO_BSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_BSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_BSR_P30     = 0x40000000 // Bit P30.
	PIO_BSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_BSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_BSR_P31     = 0x80000000 // Bit P31.

	// ABSR: AB Status Register
	PIO_ABSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_ABSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_ABSR_P0      = 0x1        // Bit P0.
	PIO_ABSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_ABSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_ABSR_P1      = 0x2        // Bit P1.
	PIO_ABSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_ABSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_ABSR_P2      = 0x4        // Bit P2.
	PIO_ABSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_ABSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_ABSR_P3      = 0x8        // Bit P3.
	PIO_ABSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_ABSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_ABSR_P4      = 0x10       // Bit P4.
	PIO_ABSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_ABSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_ABSR_P5      = 0x20       // Bit P5.
	PIO_ABSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_ABSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_ABSR_P6      = 0x40       // Bit P6.
	PIO_ABSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_ABSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_ABSR_P7      = 0x80       // Bit P7.
	PIO_ABSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_ABSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_ABSR_P8      = 0x100      // Bit P8.
	PIO_ABSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_ABSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_ABSR_P9      = 0x200      // Bit P9.
	PIO_ABSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_ABSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_ABSR_P10     = 0x400      // Bit P10.
	PIO_ABSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_ABSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_ABSR_P11     = 0x800      // Bit P11.
	PIO_ABSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_ABSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_ABSR_P12     = 0x1000     // Bit P12.
	PIO_ABSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_ABSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_ABSR_P13     = 0x2000     // Bit P13.
	PIO_ABSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_ABSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_ABSR_P14     = 0x4000     // Bit P14.
	PIO_ABSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_ABSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_ABSR_P15     = 0x8000     // Bit P15.
	PIO_ABSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_ABSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_ABSR_P16     = 0x10000    // Bit P16.
	PIO_ABSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_ABSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_ABSR_P17     = 0x20000    // Bit P17.
	PIO_ABSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_ABSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_ABSR_P18     = 0x40000    // Bit P18.
	PIO_ABSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_ABSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_ABSR_P19     = 0x80000    // Bit P19.
	PIO_ABSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_ABSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_ABSR_P20     = 0x100000   // Bit P20.
	PIO_ABSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_ABSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_ABSR_P21     = 0x200000   // Bit P21.
	PIO_ABSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_ABSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_ABSR_P22     = 0x400000   // Bit P22.
	PIO_ABSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_ABSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_ABSR_P23     = 0x800000   // Bit P23.
	PIO_ABSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_ABSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_ABSR_P24     = 0x1000000  // Bit P24.
	PIO_ABSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_ABSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_ABSR_P25     = 0x2000000  // Bit P25.
	PIO_ABSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_ABSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_ABSR_P26     = 0x4000000  // Bit P26.
	PIO_ABSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_ABSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_ABSR_P27     = 0x8000000  // Bit P27.
	PIO_ABSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_ABSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_ABSR_P28     = 0x10000000 // Bit P28.
	PIO_ABSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_ABSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_ABSR_P29     = 0x20000000 // Bit P29.
	PIO_ABSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_ABSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_ABSR_P30     = 0x40000000 // Bit P30.
	PIO_ABSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_ABSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_ABSR_P31     = 0x80000000 // Bit P31.

	// OWER: Output Write Enable
	PIO_OWER_P0_Pos  = 0x0        // Position of P0 field.
	PIO_OWER_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_OWER_P0      = 0x1        // Bit P0.
	PIO_OWER_P1_Pos  = 0x1        // Position of P1 field.
	PIO_OWER_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_OWER_P1      = 0x2        // Bit P1.
	PIO_OWER_P2_Pos  = 0x2        // Position of P2 field.
	PIO_OWER_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_OWER_P2      = 0x4        // Bit P2.
	PIO_OWER_P3_Pos  = 0x3        // Position of P3 field.
	PIO_OWER_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_OWER_P3      = 0x8        // Bit P3.
	PIO_OWER_P4_Pos  = 0x4        // Position of P4 field.
	PIO_OWER_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_OWER_P4      = 0x10       // Bit P4.
	PIO_OWER_P5_Pos  = 0x5        // Position of P5 field.
	PIO_OWER_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_OWER_P5      = 0x20       // Bit P5.
	PIO_OWER_P6_Pos  = 0x6        // Position of P6 field.
	PIO_OWER_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_OWER_P6      = 0x40       // Bit P6.
	PIO_OWER_P7_Pos  = 0x7        // Position of P7 field.
	PIO_OWER_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_OWER_P7      = 0x80       // Bit P7.
	PIO_OWER_P8_Pos  = 0x8        // Position of P8 field.
	PIO_OWER_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_OWER_P8      = 0x100      // Bit P8.
	PIO_OWER_P9_Pos  = 0x9        // Position of P9 field.
	PIO_OWER_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_OWER_P9      = 0x200      // Bit P9.
	PIO_OWER_P10_Pos = 0xa        // Position of P10 field.
	PIO_OWER_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_OWER_P10     = 0x400      // Bit P10.
	PIO_OWER_P11_Pos = 0xb        // Position of P11 field.
	PIO_OWER_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_OWER_P11     = 0x800      // Bit P11.
	PIO_OWER_P12_Pos = 0xc        // Position of P12 field.
	PIO_OWER_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_OWER_P12     = 0x1000     // Bit P12.
	PIO_OWER_P13_Pos = 0xd        // Position of P13 field.
	PIO_OWER_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_OWER_P13     = 0x2000     // Bit P13.
	PIO_OWER_P14_Pos = 0xe        // Position of P14 field.
	PIO_OWER_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_OWER_P14     = 0x4000     // Bit P14.
	PIO_OWER_P15_Pos = 0xf        // Position of P15 field.
	PIO_OWER_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_OWER_P15     = 0x8000     // Bit P15.
	PIO_OWER_P16_Pos = 0x10       // Position of P16 field.
	PIO_OWER_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_OWER_P16     = 0x10000    // Bit P16.
	PIO_OWER_P17_Pos = 0x11       // Position of P17 field.
	PIO_OWER_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_OWER_P17     = 0x20000    // Bit P17.
	PIO_OWER_P18_Pos = 0x12       // Position of P18 field.
	PIO_OWER_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_OWER_P18     = 0x40000    // Bit P18.
	PIO_OWER_P19_Pos = 0x13       // Position of P19 field.
	PIO_OWER_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_OWER_P19     = 0x80000    // Bit P19.
	PIO_OWER_P20_Pos = 0x14       // Position of P20 field.
	PIO_OWER_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_OWER_P20     = 0x100000   // Bit P20.
	PIO_OWER_P21_Pos = 0x15       // Position of P21 field.
	PIO_OWER_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_OWER_P21     = 0x200000   // Bit P21.
	PIO_OWER_P22_Pos = 0x16       // Position of P22 field.
	PIO_OWER_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_OWER_P22     = 0x400000   // Bit P22.
	PIO_OWER_P23_Pos = 0x17       // Position of P23 field.
	PIO_OWER_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_OWER_P23     = 0x800000   // Bit P23.
	PIO_OWER_P24_Pos = 0x18       // Position of P24 field.
	PIO_OWER_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_OWER_P24     = 0x1000000  // Bit P24.
	PIO_OWER_P25_Pos = 0x19       // Position of P25 field.
	PIO_OWER_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_OWER_P25     = 0x2000000  // Bit P25.
	PIO_OWER_P26_Pos = 0x1a       // Position of P26 field.
	PIO_OWER_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_OWER_P26     = 0x4000000  // Bit P26.
	PIO_OWER_P27_Pos = 0x1b       // Position of P27 field.
	PIO_OWER_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_OWER_P27     = 0x8000000  // Bit P27.
	PIO_OWER_P28_Pos = 0x1c       // Position of P28 field.
	PIO_OWER_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_OWER_P28     = 0x10000000 // Bit P28.
	PIO_OWER_P29_Pos = 0x1d       // Position of P29 field.
	PIO_OWER_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_OWER_P29     = 0x20000000 // Bit P29.
	PIO_OWER_P30_Pos = 0x1e       // Position of P30 field.
	PIO_OWER_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_OWER_P30     = 0x40000000 // Bit P30.
	PIO_OWER_P31_Pos = 0x1f       // Position of P31 field.
	PIO_OWER_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_OWER_P31     = 0x80000000 // Bit P31.

	// OWDR: Output Write Disable
	PIO_OWDR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_OWDR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_OWDR_P0      = 0x1        // Bit P0.
	PIO_OWDR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_OWDR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_OWDR_P1      = 0x2        // Bit P1.
	PIO_OWDR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_OWDR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_OWDR_P2      = 0x4        // Bit P2.
	PIO_OWDR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_OWDR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_OWDR_P3      = 0x8        // Bit P3.
	PIO_OWDR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_OWDR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_OWDR_P4      = 0x10       // Bit P4.
	PIO_OWDR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_OWDR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_OWDR_P5      = 0x20       // Bit P5.
	PIO_OWDR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_OWDR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_OWDR_P6      = 0x40       // Bit P6.
	PIO_OWDR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_OWDR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_OWDR_P7      = 0x80       // Bit P7.
	PIO_OWDR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_OWDR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_OWDR_P8      = 0x100      // Bit P8.
	PIO_OWDR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_OWDR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_OWDR_P9      = 0x200      // Bit P9.
	PIO_OWDR_P10_Pos = 0xa        // Position of P10 field.
	PIO_OWDR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_OWDR_P10     = 0x400      // Bit P10.
	PIO_OWDR_P11_Pos = 0xb        // Position of P11 field.
	PIO_OWDR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_OWDR_P11     = 0x800      // Bit P11.
	PIO_OWDR_P12_Pos = 0xc        // Position of P12 field.
	PIO_OWDR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_OWDR_P12     = 0x1000     // Bit P12.
	PIO_OWDR_P13_Pos = 0xd        // Position of P13 field.
	PIO_OWDR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_OWDR_P13     = 0x2000     // Bit P13.
	PIO_OWDR_P14_Pos = 0xe        // Position of P14 field.
	PIO_OWDR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_OWDR_P14     = 0x4000     // Bit P14.
	PIO_OWDR_P15_Pos = 0xf        // Position of P15 field.
	PIO_OWDR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_OWDR_P15     = 0x8000     // Bit P15.
	PIO_OWDR_P16_Pos = 0x10       // Position of P16 field.
	PIO_OWDR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_OWDR_P16     = 0x10000    // Bit P16.
	PIO_OWDR_P17_Pos = 0x11       // Position of P17 field.
	PIO_OWDR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_OWDR_P17     = 0x20000    // Bit P17.
	PIO_OWDR_P18_Pos = 0x12       // Position of P18 field.
	PIO_OWDR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_OWDR_P18     = 0x40000    // Bit P18.
	PIO_OWDR_P19_Pos = 0x13       // Position of P19 field.
	PIO_OWDR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_OWDR_P19     = 0x80000    // Bit P19.
	PIO_OWDR_P20_Pos = 0x14       // Position of P20 field.
	PIO_OWDR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_OWDR_P20     = 0x100000   // Bit P20.
	PIO_OWDR_P21_Pos = 0x15       // Position of P21 field.
	PIO_OWDR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_OWDR_P21     = 0x200000   // Bit P21.
	PIO_OWDR_P22_Pos = 0x16       // Position of P22 field.
	PIO_OWDR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_OWDR_P22     = 0x400000   // Bit P22.
	PIO_OWDR_P23_Pos = 0x17       // Position of P23 field.
	PIO_OWDR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_OWDR_P23     = 0x800000   // Bit P23.
	PIO_OWDR_P24_Pos = 0x18       // Position of P24 field.
	PIO_OWDR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_OWDR_P24     = 0x1000000  // Bit P24.
	PIO_OWDR_P25_Pos = 0x19       // Position of P25 field.
	PIO_OWDR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_OWDR_P25     = 0x2000000  // Bit P25.
	PIO_OWDR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_OWDR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_OWDR_P26     = 0x4000000  // Bit P26.
	PIO_OWDR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_OWDR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_OWDR_P27     = 0x8000000  // Bit P27.
	PIO_OWDR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_OWDR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_OWDR_P28     = 0x10000000 // Bit P28.
	PIO_OWDR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_OWDR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_OWDR_P29     = 0x20000000 // Bit P29.
	PIO_OWDR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_OWDR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_OWDR_P30     = 0x40000000 // Bit P30.
	PIO_OWDR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_OWDR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_OWDR_P31     = 0x80000000 // Bit P31.

	// OWSR: Output Write Status Register
	PIO_OWSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_OWSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_OWSR_P0      = 0x1        // Bit P0.
	PIO_OWSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_OWSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_OWSR_P1      = 0x2        // Bit P1.
	PIO_OWSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_OWSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_OWSR_P2      = 0x4        // Bit P2.
	PIO_OWSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_OWSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_OWSR_P3      = 0x8        // Bit P3.
	PIO_OWSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_OWSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_OWSR_P4      = 0x10       // Bit P4.
	PIO_OWSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_OWSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_OWSR_P5      = 0x20       // Bit P5.
	PIO_OWSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_OWSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_OWSR_P6      = 0x40       // Bit P6.
	PIO_OWSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_OWSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_OWSR_P7      = 0x80       // Bit P7.
	PIO_OWSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_OWSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_OWSR_P8      = 0x100      // Bit P8.
	PIO_OWSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_OWSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_OWSR_P9      = 0x200      // Bit P9.
	PIO_OWSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_OWSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_OWSR_P10     = 0x400      // Bit P10.
	PIO_OWSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_OWSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_OWSR_P11     = 0x800      // Bit P11.
	PIO_OWSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_OWSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_OWSR_P12     = 0x1000     // Bit P12.
	PIO_OWSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_OWSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_OWSR_P13     = 0x2000     // Bit P13.
	PIO_OWSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_OWSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_OWSR_P14     = 0x4000     // Bit P14.
	PIO_OWSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_OWSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_OWSR_P15     = 0x8000     // Bit P15.
	PIO_OWSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_OWSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_OWSR_P16     = 0x10000    // Bit P16.
	PIO_OWSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_OWSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_OWSR_P17     = 0x20000    // Bit P17.
	PIO_OWSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_OWSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_OWSR_P18     = 0x40000    // Bit P18.
	PIO_OWSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_OWSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_OWSR_P19     = 0x80000    // Bit P19.
	PIO_OWSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_OWSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_OWSR_P20     = 0x100000   // Bit P20.
	PIO_OWSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_OWSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_OWSR_P21     = 0x200000   // Bit P21.
	PIO_OWSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_OWSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_OWSR_P22     = 0x400000   // Bit P22.
	PIO_OWSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_OWSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_OWSR_P23     = 0x800000   // Bit P23.
	PIO_OWSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_OWSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_OWSR_P24     = 0x1000000  // Bit P24.
	PIO_OWSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_OWSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_OWSR_P25     = 0x2000000  // Bit P25.
	PIO_OWSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_OWSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_OWSR_P26     = 0x4000000  // Bit P26.
	PIO_OWSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_OWSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_OWSR_P27     = 0x8000000  // Bit P27.
	PIO_OWSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_OWSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_OWSR_P28     = 0x10000000 // Bit P28.
	PIO_OWSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_OWSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_OWSR_P29     = 0x20000000 // Bit P29.
	PIO_OWSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_OWSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_OWSR_P30     = 0x40000000 // Bit P30.
	PIO_OWSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_OWSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_OWSR_P31     = 0x80000000 // Bit P31.

	// DELAYR: I/O Delay Register
	PIO_DELAYR_Delay0_Pos = 0x0        // Position of Delay0 field.
	PIO_DELAYR_Delay0_Msk = 0xf        // Bit mask of Delay0 field.
	PIO_DELAYR_Delay1_Pos = 0x4        // Position of Delay1 field.
	PIO_DELAYR_Delay1_Msk = 0xf0       // Bit mask of Delay1 field.
	PIO_DELAYR_Delay2_Pos = 0x8        // Position of Delay2 field.
	PIO_DELAYR_Delay2_Msk = 0xf00      // Bit mask of Delay2 field.
	PIO_DELAYR_Delay3_Pos = 0xc        // Position of Delay3 field.
	PIO_DELAYR_Delay3_Msk = 0xf000     // Bit mask of Delay3 field.
	PIO_DELAYR_Delay4_Pos = 0x10       // Position of Delay4 field.
	PIO_DELAYR_Delay4_Msk = 0xf0000    // Bit mask of Delay4 field.
	PIO_DELAYR_Delay5_Pos = 0x14       // Position of Delay5 field.
	PIO_DELAYR_Delay5_Msk = 0xf00000   // Bit mask of Delay5 field.
	PIO_DELAYR_Delay6_Pos = 0x18       // Position of Delay6 field.
	PIO_DELAYR_Delay6_Msk = 0xf000000  // Bit mask of Delay6 field.
	PIO_DELAYR_Delay7_Pos = 0x1c       // Position of Delay7 field.
	PIO_DELAYR_Delay7_Msk = 0xf0000000 // Bit mask of Delay7 field.

	// WPMR: Write Protect Mode Register
	PIO_WPMR_WPEN_Pos  = 0x0        // Position of WPEN field.
	PIO_WPMR_WPEN_Msk  = 0x1        // Bit mask of WPEN field.
	PIO_WPMR_WPEN      = 0x1        // Bit WPEN.
	PIO_WPMR_WPKEY_Pos = 0x8        // Position of WPKEY field.
	PIO_WPMR_WPKEY_Msk = 0xffffff00 // Bit mask of WPKEY field.

	// WPSR: Write Protect Status Register
	PIO_WPSR_WPVS_Pos   = 0x0      // Position of WPVS field.
	PIO_WPSR_WPVS_Msk   = 0x1      // Bit mask of WPVS field.
	PIO_WPSR_WPVS       = 0x1      // Bit WPVS.
	PIO_WPSR_WPVSRC_Pos = 0x8      // Position of WPVSRC field.
	PIO_WPSR_WPVSRC_Msk = 0xffff00 // Bit mask of WPVSRC field.
)

// Bitfields for PMC: Power Management Controller
const (
	// PMC_SCER: System Clock Enable Register
	PMC_PMC_SCER_DDRCK_Pos = 0x2   // Position of DDRCK field.
	PMC_PMC_SCER_DDRCK_Msk = 0x4   // Bit mask of DDRCK field.
	PMC_PMC_SCER_DDRCK     = 0x4   // Bit DDRCK.
	PMC_PMC_SCER_UHP_Pos   = 0x6   // Position of UHP field.
	PMC_PMC_SCER_UHP_Msk   = 0x40  // Bit mask of UHP field.
	PMC_PMC_SCER_UHP       = 0x40  // Bit UHP.
	PMC_PMC_SCER_PCK0_Pos  = 0x8   // Position of PCK0 field.
	PMC_PMC_SCER_PCK0_Msk  = 0x100 // Bit mask of PCK0 field.
	PMC_PMC_SCER_PCK0      = 0x100 // Bit PCK0.
	PMC_PMC_SCER_PCK1_Pos  = 0x9   // Position of PCK1 field.
	PMC_PMC_SCER_PCK1_Msk  = 0x200 // Bit mask of PCK1 field.
	PMC_PMC_SCER_PCK1      = 0x200 // Bit PCK1.

	// PMC_SCDR: System Clock Disable Register
	PMC_PMC_SCDR_PCK_Pos   = 0x0   // Position of PCK field.
	PMC_PMC_SCDR_PCK_Msk   = 0x1   // Bit mask of PCK field.
	PMC_PMC_SCDR_PCK       = 0x1   // Bit PCK.
	PMC_PMC_SCDR_DDRCK_Pos = 0x2   // Position of DDRCK field.
	PMC_PMC_SCDR_DDRCK_Msk = 0x4   // Bit mask of DDRCK field.
	PMC_PMC_SCDR_DDRCK     = 0x4   // Bit DDRCK.
	PMC_PMC_SCDR_UHP_Pos   = 0x6   // Position of UHP field.
	PMC_PMC_SCDR_UHP_Msk   = 0x40  // Bit mask of UHP field.
	PMC_PMC_SCDR_UHP       = 0x40  // Bit UHP.
	PMC_PMC_SCDR_PCK0_Pos  = 0x8   // Position of PCK0 field.
	PMC_PMC_SCDR_PCK0_Msk  = 0x100 // Bit mask of PCK0 field.
	PMC_PMC_SCDR_PCK0      = 0x100 // Bit PCK0.
	PMC_PMC_SCDR_PCK1_Pos  = 0x9   // Position of PCK1 field.
	PMC_PMC_SCDR_PCK1_Msk  = 0x200 // Bit mask of PCK1 field.
	PMC_PMC_SCDR_PCK1      = 0x200 // Bit PCK1.

	// PMC_SCSR: System Clock Status Register
	PMC_PMC_SCSR_PCK_Pos   = 0x0   // Position of PCK field.
	PMC_PMC_SCSR_PCK_Msk   = 0x1   // Bit mask of PCK field.
	PMC_PMC_SCSR_PCK       = 0x1   // Bit PCK.
	PMC_PMC_SCSR_DDRCK_Pos = 0x2   // Position of DDRCK field.
	PMC_PMC_SCSR_DDRCK_Msk = 0x4   // Bit mask of DDRCK field.
	PMC_PMC_SCSR_DDRCK     = 0x4   // Bit DDRCK.
	PMC_PMC_SCSR_UHP_Pos   = 0x6   // Position of UHP field.
	PMC_PMC_SCSR_UHP_Msk   = 0x40  // Bit mask of UHP field.
	PMC_PMC_SCSR_UHP       = 0x40  // Bit UHP.
	PMC_PMC_SCSR_PCK0_Pos  = 0x8   // Position of PCK0 field.
	PMC_PMC_SCSR_PCK0_Msk  = 0x100 // Bit mask of PCK0 field.
	PMC_PMC_SCSR_PCK0      = 0x100 // Bit PCK0.
	PMC_PMC_SCSR_PCK1_Pos  = 0x9   // Position of PCK1 field.
	PMC_PMC_SCSR_PCK1_Msk  = 0x200 // Bit mask of PCK1 field.
	PMC_PMC_SCSR_PCK1      = 0x200 // Bit PCK1.

	// PMC_PCER: Peripheral Clock Enable Register
	PMC_PMC_PCER_PID2_Pos  = 0x2        // Position of PID2 field.
	PMC_PMC_PCER_PID2_Msk  = 0x4        // Bit mask of PID2 field.
	PMC_PMC_PCER_PID2      = 0x4        // Bit PID2.
	PMC_PMC_PCER_PID3_Pos  = 0x3        // Position of PID3 field.
	PMC_PMC_PCER_PID3_Msk  = 0x8        // Bit mask of PID3 field.
	PMC_PMC_PCER_PID3      = 0x8        // Bit PID3.
	PMC_PMC_PCER_PID4_Pos  = 0x4        // Position of PID4 field.
	PMC_PMC_PCER_PID4_Msk  = 0x10       // Bit mask of PID4 field.
	PMC_PMC_PCER_PID4      = 0x10       // Bit PID4.
	PMC_PMC_PCER_PID5_Pos  = 0x5        // Position of PID5 field.
	PMC_PMC_PCER_PID5_Msk  = 0x20       // Bit mask of PID5 field.
	PMC_PMC_PCER_PID5      = 0x20       // Bit PID5.
	PMC_PMC_PCER_PID6_Pos  = 0x6        // Position of PID6 field.
	PMC_PMC_PCER_PID6_Msk  = 0x40       // Bit mask of PID6 field.
	PMC_PMC_PCER_PID6      = 0x40       // Bit PID6.
	PMC_PMC_PCER_PID7_Pos  = 0x7        // Position of PID7 field.
	PMC_PMC_PCER_PID7_Msk  = 0x80       // Bit mask of PID7 field.
	PMC_PMC_PCER_PID7      = 0x80       // Bit PID7.
	PMC_PMC_PCER_PID8_Pos  = 0x8        // Position of PID8 field.
	PMC_PMC_PCER_PID8_Msk  = 0x100      // Bit mask of PID8 field.
	PMC_PMC_PCER_PID8      = 0x100      // Bit PID8.
	PMC_PMC_PCER_PID9_Pos  = 0x9        // Position of PID9 field.
	PMC_PMC_PCER_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	PMC_PMC_PCER_PID9      = 0x200      // Bit PID9.
	PMC_PMC_PCER_PID10_Pos = 0xa        // Position of PID10 field.
	PMC_PMC_PCER_PID10_Msk = 0x400      // Bit mask of PID10 field.
	PMC_PMC_PCER_PID10     = 0x400      // Bit PID10.
	PMC_PMC_PCER_PID11_Pos = 0xb        // Position of PID11 field.
	PMC_PMC_PCER_PID11_Msk = 0x800      // Bit mask of PID11 field.
	PMC_PMC_PCER_PID11     = 0x800      // Bit PID11.
	PMC_PMC_PCER_PID12_Pos = 0xc        // Position of PID12 field.
	PMC_PMC_PCER_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	PMC_PMC_PCER_PID12     = 0x1000     // Bit PID12.
	PMC_PMC_PCER_PID13_Pos = 0xd        // Position of PID13 field.
	PMC_PMC_PCER_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	PMC_PMC_PCER_PID13     = 0x2000     // Bit PID13.
	PMC_PMC_PCER_PID14_Pos = 0xe        // Position of PID14 field.
	PMC_PMC_PCER_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	PMC_PMC_PCER_PID14     = 0x4000     // Bit PID14.
	PMC_PMC_PCER_PID15_Pos = 0xf        // Position of PID15 field.
	PMC_PMC_PCER_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	PMC_PMC_PCER_PID15     = 0x8000     // Bit PID15.
	PMC_PMC_PCER_PID16_Pos = 0x10       // Position of PID16 field.
	PMC_PMC_PCER_PID16_Msk = 0x10000    // Bit mask of PID16 field.
	PMC_PMC_PCER_PID16     = 0x10000    // Bit PID16.
	PMC_PMC_PCER_PID17_Pos = 0x11       // Position of PID17 field.
	PMC_PMC_PCER_PID17_Msk = 0x20000    // Bit mask of PID17 field.
	PMC_PMC_PCER_PID17     = 0x20000    // Bit PID17.
	PMC_PMC_PCER_PID18_Pos = 0x12       // Position of PID18 field.
	PMC_PMC_PCER_PID18_Msk = 0x40000    // Bit mask of PID18 field.
	PMC_PMC_PCER_PID18     = 0x40000    // Bit PID18.
	PMC_PMC_PCER_PID19_Pos = 0x13       // Position of PID19 field.
	PMC_PMC_PCER_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	PMC_PMC_PCER_PID19     = 0x80000    // Bit PID19.
	PMC_PMC_PCER_PID20_Pos = 0x14       // Position of PID20 field.
	PMC_PMC_PCER_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	PMC_PMC_PCER_PID20     = 0x100000   // Bit PID20.
	PMC_PMC_PCER_PID21_Pos = 0x15       // Position of PID21 field.
	PMC_PMC_PCER_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	PMC_PMC_PCER_PID21     = 0x200000   // Bit PID21.
	PMC_PMC_PCER_PID22_Pos = 0x16       // Position of PID22 field.
	PMC_PMC_PCER_PID22_Msk = 0x400000   // Bit mask of PID22 field.
	PMC_PMC_PCER_PID22     = 0x400000   // Bit PID22.
	PMC_PMC_PCER_PID23_Pos = 0x17       // Position of PID23 field.
	PMC_PMC_PCER_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	PMC_PMC_PCER_PID23     = 0x800000   // Bit PID23.
	PMC_PMC_PCER_PID24_Pos = 0x18       // Position of PID24 field.
	PMC_PMC_PCER_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	PMC_PMC_PCER_PID24     = 0x1000000  // Bit PID24.
	PMC_PMC_PCER_PID25_Pos = 0x19       // Position of PID25 field.
	PMC_PMC_PCER_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	PMC_PMC_PCER_PID25     = 0x2000000  // Bit PID25.
	PMC_PMC_PCER_PID26_Pos = 0x1a       // Position of PID26 field.
	PMC_PMC_PCER_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	PMC_PMC_PCER_PID26     = 0x4000000  // Bit PID26.
	PMC_PMC_PCER_PID27_Pos = 0x1b       // Position of PID27 field.
	PMC_PMC_PCER_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	PMC_PMC_PCER_PID27     = 0x8000000  // Bit PID27.
	PMC_PMC_PCER_PID28_Pos = 0x1c       // Position of PID28 field.
	PMC_PMC_PCER_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	PMC_PMC_PCER_PID28     = 0x10000000 // Bit PID28.
	PMC_PMC_PCER_PID29_Pos = 0x1d       // Position of PID29 field.
	PMC_PMC_PCER_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	PMC_PMC_PCER_PID29     = 0x20000000 // Bit PID29.
	PMC_PMC_PCER_PID30_Pos = 0x1e       // Position of PID30 field.
	PMC_PMC_PCER_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	PMC_PMC_PCER_PID30     = 0x40000000 // Bit PID30.
	PMC_PMC_PCER_PID31_Pos = 0x1f       // Position of PID31 field.
	PMC_PMC_PCER_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	PMC_PMC_PCER_PID31     = 0x80000000 // Bit PID31.

	// PMC_PCDR: Peripheral Clock Disable Register
	PMC_PMC_PCDR_PID2_Pos  = 0x2        // Position of PID2 field.
	PMC_PMC_PCDR_PID2_Msk  = 0x4        // Bit mask of PID2 field.
	PMC_PMC_PCDR_PID2      = 0x4        // Bit PID2.
	PMC_PMC_PCDR_PID3_Pos  = 0x3        // Position of PID3 field.
	PMC_PMC_PCDR_PID3_Msk  = 0x8        // Bit mask of PID3 field.
	PMC_PMC_PCDR_PID3      = 0x8        // Bit PID3.
	PMC_PMC_PCDR_PID4_Pos  = 0x4        // Position of PID4 field.
	PMC_PMC_PCDR_PID4_Msk  = 0x10       // Bit mask of PID4 field.
	PMC_PMC_PCDR_PID4      = 0x10       // Bit PID4.
	PMC_PMC_PCDR_PID5_Pos  = 0x5        // Position of PID5 field.
	PMC_PMC_PCDR_PID5_Msk  = 0x20       // Bit mask of PID5 field.
	PMC_PMC_PCDR_PID5      = 0x20       // Bit PID5.
	PMC_PMC_PCDR_PID6_Pos  = 0x6        // Position of PID6 field.
	PMC_PMC_PCDR_PID6_Msk  = 0x40       // Bit mask of PID6 field.
	PMC_PMC_PCDR_PID6      = 0x40       // Bit PID6.
	PMC_PMC_PCDR_PID7_Pos  = 0x7        // Position of PID7 field.
	PMC_PMC_PCDR_PID7_Msk  = 0x80       // Bit mask of PID7 field.
	PMC_PMC_PCDR_PID7      = 0x80       // Bit PID7.
	PMC_PMC_PCDR_PID8_Pos  = 0x8        // Position of PID8 field.
	PMC_PMC_PCDR_PID8_Msk  = 0x100      // Bit mask of PID8 field.
	PMC_PMC_PCDR_PID8      = 0x100      // Bit PID8.
	PMC_PMC_PCDR_PID9_Pos  = 0x9        // Position of PID9 field.
	PMC_PMC_PCDR_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	PMC_PMC_PCDR_PID9      = 0x200      // Bit PID9.
	PMC_PMC_PCDR_PID10_Pos = 0xa        // Position of PID10 field.
	PMC_PMC_PCDR_PID10_Msk = 0x400      // Bit mask of PID10 field.
	PMC_PMC_PCDR_PID10     = 0x400      // Bit PID10.
	PMC_PMC_PCDR_PID11_Pos = 0xb        // Position of PID11 field.
	PMC_PMC_PCDR_PID11_Msk = 0x800      // Bit mask of PID11 field.
	PMC_PMC_PCDR_PID11     = 0x800      // Bit PID11.
	PMC_PMC_PCDR_PID12_Pos = 0xc        // Position of PID12 field.
	PMC_PMC_PCDR_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	PMC_PMC_PCDR_PID12     = 0x1000     // Bit PID12.
	PMC_PMC_PCDR_PID13_Pos = 0xd        // Position of PID13 field.
	PMC_PMC_PCDR_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	PMC_PMC_PCDR_PID13     = 0x2000     // Bit PID13.
	PMC_PMC_PCDR_PID14_Pos = 0xe        // Position of PID14 field.
	PMC_PMC_PCDR_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	PMC_PMC_PCDR_PID14     = 0x4000     // Bit PID14.
	PMC_PMC_PCDR_PID15_Pos = 0xf        // Position of PID15 field.
	PMC_PMC_PCDR_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	PMC_PMC_PCDR_PID15     = 0x8000     // Bit PID15.
	PMC_PMC_PCDR_PID16_Pos = 0x10       // Position of PID16 field.
	PMC_PMC_PCDR_PID16_Msk = 0x10000    // Bit mask of PID16 field.
	PMC_PMC_PCDR_PID16     = 0x10000    // Bit PID16.
	PMC_PMC_PCDR_PID17_Pos = 0x11       // Position of PID17 field.
	PMC_PMC_PCDR_PID17_Msk = 0x20000    // Bit mask of PID17 field.
	PMC_PMC_PCDR_PID17     = 0x20000    // Bit PID17.
	PMC_PMC_PCDR_PID18_Pos = 0x12       // Position of PID18 field.
	PMC_PMC_PCDR_PID18_Msk = 0x40000    // Bit mask of PID18 field.
	PMC_PMC_PCDR_PID18     = 0x40000    // Bit PID18.
	PMC_PMC_PCDR_PID19_Pos = 0x13       // Position of PID19 field.
	PMC_PMC_PCDR_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	PMC_PMC_PCDR_PID19     = 0x80000    // Bit PID19.
	PMC_PMC_PCDR_PID20_Pos = 0x14       // Position of PID20 field.
	PMC_PMC_PCDR_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	PMC_PMC_PCDR_PID20     = 0x100000   // Bit PID20.
	PMC_PMC_PCDR_PID21_Pos = 0x15       // Position of PID21 field.
	PMC_PMC_PCDR_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	PMC_PMC_PCDR_PID21     = 0x200000   // Bit PID21.
	PMC_PMC_PCDR_PID22_Pos = 0x16       // Position of PID22 field.
	PMC_PMC_PCDR_PID22_Msk = 0x400000   // Bit mask of PID22 field.
	PMC_PMC_PCDR_PID22     = 0x400000   // Bit PID22.
	PMC_PMC_PCDR_PID23_Pos = 0x17       // Position of PID23 field.
	PMC_PMC_PCDR_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	PMC_PMC_PCDR_PID23     = 0x800000   // Bit PID23.
	PMC_PMC_PCDR_PID24_Pos = 0x18       // Position of PID24 field.
	PMC_PMC_PCDR_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	PMC_PMC_PCDR_PID24     = 0x1000000  // Bit PID24.
	PMC_PMC_PCDR_PID25_Pos = 0x19       // Position of PID25 field.
	PMC_PMC_PCDR_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	PMC_PMC_PCDR_PID25     = 0x2000000  // Bit PID25.
	PMC_PMC_PCDR_PID26_Pos = 0x1a       // Position of PID26 field.
	PMC_PMC_PCDR_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	PMC_PMC_PCDR_PID26     = 0x4000000  // Bit PID26.
	PMC_PMC_PCDR_PID27_Pos = 0x1b       // Position of PID27 field.
	PMC_PMC_PCDR_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	PMC_PMC_PCDR_PID27     = 0x8000000  // Bit PID27.
	PMC_PMC_PCDR_PID28_Pos = 0x1c       // Position of PID28 field.
	PMC_PMC_PCDR_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	PMC_PMC_PCDR_PID28     = 0x10000000 // Bit PID28.
	PMC_PMC_PCDR_PID29_Pos = 0x1d       // Position of PID29 field.
	PMC_PMC_PCDR_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	PMC_PMC_PCDR_PID29     = 0x20000000 // Bit PID29.
	PMC_PMC_PCDR_PID30_Pos = 0x1e       // Position of PID30 field.
	PMC_PMC_PCDR_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	PMC_PMC_PCDR_PID30     = 0x40000000 // Bit PID30.
	PMC_PMC_PCDR_PID31_Pos = 0x1f       // Position of PID31 field.
	PMC_PMC_PCDR_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	PMC_PMC_PCDR_PID31     = 0x80000000 // Bit PID31.

	// PMC_PCSR: Peripheral Clock Status Register
	PMC_PMC_PCSR_PID2_Pos  = 0x2        // Position of PID2 field.
	PMC_PMC_PCSR_PID2_Msk  = 0x4        // Bit mask of PID2 field.
	PMC_PMC_PCSR_PID2      = 0x4        // Bit PID2.
	PMC_PMC_PCSR_PID3_Pos  = 0x3        // Position of PID3 field.
	PMC_PMC_PCSR_PID3_Msk  = 0x8        // Bit mask of PID3 field.
	PMC_PMC_PCSR_PID3      = 0x8        // Bit PID3.
	PMC_PMC_PCSR_PID4_Pos  = 0x4        // Position of PID4 field.
	PMC_PMC_PCSR_PID4_Msk  = 0x10       // Bit mask of PID4 field.
	PMC_PMC_PCSR_PID4      = 0x10       // Bit PID4.
	PMC_PMC_PCSR_PID5_Pos  = 0x5        // Position of PID5 field.
	PMC_PMC_PCSR_PID5_Msk  = 0x20       // Bit mask of PID5 field.
	PMC_PMC_PCSR_PID5      = 0x20       // Bit PID5.
	PMC_PMC_PCSR_PID6_Pos  = 0x6        // Position of PID6 field.
	PMC_PMC_PCSR_PID6_Msk  = 0x40       // Bit mask of PID6 field.
	PMC_PMC_PCSR_PID6      = 0x40       // Bit PID6.
	PMC_PMC_PCSR_PID7_Pos  = 0x7        // Position of PID7 field.
	PMC_PMC_PCSR_PID7_Msk  = 0x80       // Bit mask of PID7 field.
	PMC_PMC_PCSR_PID7      = 0x80       // Bit PID7.
	PMC_PMC_PCSR_PID8_Pos  = 0x8        // Position of PID8 field.
	PMC_PMC_PCSR_PID8_Msk  = 0x100      // Bit mask of PID8 field.
	PMC_PMC_PCSR_PID8      = 0x100      // Bit PID8.
	PMC_PMC_PCSR_PID9_Pos  = 0x9        // Position of PID9 field.
	PMC_PMC_PCSR_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	PMC_PMC_PCSR_PID9      = 0x200      // Bit PID9.
	PMC_PMC_PCSR_PID10_Pos = 0xa        // Position of PID10 field.
	PMC_PMC_PCSR_PID10_Msk = 0x400      // Bit mask of PID10 field.
	PMC_PMC_PCSR_PID10     = 0x400      // Bit PID10.
	PMC_PMC_PCSR_PID11_Pos = 0xb        // Position of PID11 field.
	PMC_PMC_PCSR_PID11_Msk = 0x800      // Bit mask of PID11 field.
	PMC_PMC_PCSR_PID11     = 0x800      // Bit PID11.
	PMC_PMC_PCSR_PID12_Pos = 0xc        // Position of PID12 field.
	PMC_PMC_PCSR_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	PMC_PMC_PCSR_PID12     = 0x1000     // Bit PID12.
	PMC_PMC_PCSR_PID13_Pos = 0xd        // Position of PID13 field.
	PMC_PMC_PCSR_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	PMC_PMC_PCSR_PID13     = 0x2000     // Bit PID13.
	PMC_PMC_PCSR_PID14_Pos = 0xe        // Position of PID14 field.
	PMC_PMC_PCSR_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	PMC_PMC_PCSR_PID14     = 0x4000     // Bit PID14.
	PMC_PMC_PCSR_PID15_Pos = 0xf        // Position of PID15 field.
	PMC_PMC_PCSR_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	PMC_PMC_PCSR_PID15     = 0x8000     // Bit PID15.
	PMC_PMC_PCSR_PID16_Pos = 0x10       // Position of PID16 field.
	PMC_PMC_PCSR_PID16_Msk = 0x10000    // Bit mask of PID16 field.
	PMC_PMC_PCSR_PID16     = 0x10000    // Bit PID16.
	PMC_PMC_PCSR_PID17_Pos = 0x11       // Position of PID17 field.
	PMC_PMC_PCSR_PID17_Msk = 0x20000    // Bit mask of PID17 field.
	PMC_PMC_PCSR_PID17     = 0x20000    // Bit PID17.
	PMC_PMC_PCSR_PID18_Pos = 0x12       // Position of PID18 field.
	PMC_PMC_PCSR_PID18_Msk = 0x40000    // Bit mask of PID18 field.
	PMC_PMC_PCSR_PID18     = 0x40000    // Bit PID18.
	PMC_PMC_PCSR_PID19_Pos = 0x13       // Position of PID19 field.
	PMC_PMC_PCSR_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	PMC_PMC_PCSR_PID19     = 0x80000    // Bit PID19.
	PMC_PMC_PCSR_PID20_Pos = 0x14       // Position of PID20 field.
	PMC_PMC_PCSR_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	PMC_PMC_PCSR_PID20     = 0x100000   // Bit PID20.
	PMC_PMC_PCSR_PID21_Pos = 0x15       // Position of PID21 field.
	PMC_PMC_PCSR_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	PMC_PMC_PCSR_PID21     = 0x200000   // Bit PID21.
	PMC_PMC_PCSR_PID22_Pos = 0x16       // Position of PID22 field.
	PMC_PMC_PCSR_PID22_Msk = 0x400000   // Bit mask of PID22 field.
	PMC_PMC_PCSR_PID22     = 0x400000   // Bit PID22.
	PMC_PMC_PCSR_PID23_Pos = 0x17       // Position of PID23 field.
	PMC_PMC_PCSR_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	PMC_PMC_PCSR_PID23     = 0x800000   // Bit PID23.
	PMC_PMC_PCSR_PID24_Pos = 0x18       // Position of PID24 field.
	PMC_PMC_PCSR_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	PMC_PMC_PCSR_PID24     = 0x1000000  // Bit PID24.
	PMC_PMC_PCSR_PID25_Pos = 0x19       // Position of PID25 field.
	PMC_PMC_PCSR_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	PMC_PMC_PCSR_PID25     = 0x2000000  // Bit PID25.
	PMC_PMC_PCSR_PID26_Pos = 0x1a       // Position of PID26 field.
	PMC_PMC_PCSR_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	PMC_PMC_PCSR_PID26     = 0x4000000  // Bit PID26.
	PMC_PMC_PCSR_PID27_Pos = 0x1b       // Position of PID27 field.
	PMC_PMC_PCSR_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	PMC_PMC_PCSR_PID27     = 0x8000000  // Bit PID27.
	PMC_PMC_PCSR_PID28_Pos = 0x1c       // Position of PID28 field.
	PMC_PMC_PCSR_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	PMC_PMC_PCSR_PID28     = 0x10000000 // Bit PID28.
	PMC_PMC_PCSR_PID29_Pos = 0x1d       // Position of PID29 field.
	PMC_PMC_PCSR_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	PMC_PMC_PCSR_PID29     = 0x20000000 // Bit PID29.
	PMC_PMC_PCSR_PID30_Pos = 0x1e       // Position of PID30 field.
	PMC_PMC_PCSR_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	PMC_PMC_PCSR_PID30     = 0x40000000 // Bit PID30.
	PMC_PMC_PCSR_PID31_Pos = 0x1f       // Position of PID31 field.
	PMC_PMC_PCSR_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	PMC_PMC_PCSR_PID31     = 0x80000000 // Bit PID31.

	// CKGR_UCKR: UTMI Clock Register
	PMC_CKGR_UCKR_UPLLEN_Pos    = 0x10       // Position of UPLLEN field.
	PMC_CKGR_UCKR_UPLLEN_Msk    = 0x10000    // Bit mask of UPLLEN field.
	PMC_CKGR_UCKR_UPLLEN        = 0x10000    // Bit UPLLEN.
	PMC_CKGR_UCKR_PLLCOUNT_Pos  = 0x14       // Position of PLLCOUNT field.
	PMC_CKGR_UCKR_PLLCOUNT_Msk  = 0xf00000   // Bit mask of PLLCOUNT field.
	PMC_CKGR_UCKR_BIASEN_Pos    = 0x18       // Position of BIASEN field.
	PMC_CKGR_UCKR_BIASEN_Msk    = 0x1000000  // Bit mask of BIASEN field.
	PMC_CKGR_UCKR_BIASEN        = 0x1000000  // Bit BIASEN.
	PMC_CKGR_UCKR_BIASCOUNT_Pos = 0x1c       // Position of BIASCOUNT field.
	PMC_CKGR_UCKR_BIASCOUNT_Msk = 0xf0000000 // Bit mask of BIASCOUNT field.

	// CKGR_MOR: Main Oscillator Register
	PMC_CKGR_MOR_MOSCEN_Pos    = 0x0    // Position of MOSCEN field.
	PMC_CKGR_MOR_MOSCEN_Msk    = 0x1    // Bit mask of MOSCEN field.
	PMC_CKGR_MOR_MOSCEN        = 0x1    // Bit MOSCEN.
	PMC_CKGR_MOR_OSCBYPASS_Pos = 0x1    // Position of OSCBYPASS field.
	PMC_CKGR_MOR_OSCBYPASS_Msk = 0x2    // Bit mask of OSCBYPASS field.
	PMC_CKGR_MOR_OSCBYPASS     = 0x2    // Bit OSCBYPASS.
	PMC_CKGR_MOR_OSCOUNT_Pos   = 0x8    // Position of OSCOUNT field.
	PMC_CKGR_MOR_OSCOUNT_Msk   = 0xff00 // Bit mask of OSCOUNT field.

	// CKGR_MCFR: Main Clock Frequency Register
	PMC_CKGR_MCFR_MAINF_Pos   = 0x0     // Position of MAINF field.
	PMC_CKGR_MCFR_MAINF_Msk   = 0xffff  // Bit mask of MAINF field.
	PMC_CKGR_MCFR_MAINRDY_Pos = 0x10    // Position of MAINRDY field.
	PMC_CKGR_MCFR_MAINRDY_Msk = 0x10000 // Bit mask of MAINRDY field.
	PMC_CKGR_MCFR_MAINRDY     = 0x10000 // Bit MAINRDY.

	// CKGR_PLLAR: PLLA Register
	PMC_CKGR_PLLAR_DIVA_Pos      = 0x0        // Position of DIVA field.
	PMC_CKGR_PLLAR_DIVA_Msk      = 0xff       // Bit mask of DIVA field.
	PMC_CKGR_PLLAR_PLLACOUNT_Pos = 0x8        // Position of PLLACOUNT field.
	PMC_CKGR_PLLAR_PLLACOUNT_Msk = 0x3f00     // Bit mask of PLLACOUNT field.
	PMC_CKGR_PLLAR_OUTA_Pos      = 0xe        // Position of OUTA field.
	PMC_CKGR_PLLAR_OUTA_Msk      = 0xc000     // Bit mask of OUTA field.
	PMC_CKGR_PLLAR_MULA_Pos      = 0x10       // Position of MULA field.
	PMC_CKGR_PLLAR_MULA_Msk      = 0xff0000   // Bit mask of MULA field.
	PMC_CKGR_PLLAR_STUCKTO1_Pos  = 0x1d       // Position of STUCKTO1 field.
	PMC_CKGR_PLLAR_STUCKTO1_Msk  = 0x20000000 // Bit mask of STUCKTO1 field.
	PMC_CKGR_PLLAR_STUCKTO1      = 0x20000000 // Bit STUCKTO1.

	// PMC_MCKR: Master Clock Register
	PMC_PMC_MCKR_CSS_Pos      = 0x0    // Position of CSS field.
	PMC_PMC_MCKR_CSS_Msk      = 0x3    // Bit mask of CSS field.
	PMC_PMC_MCKR_PRES_Pos     = 0x2    // Position of PRES field.
	PMC_PMC_MCKR_PRES_Msk     = 0x1c   // Bit mask of PRES field.
	PMC_PMC_MCKR_MDIV_Pos     = 0x8    // Position of MDIV field.
	PMC_PMC_MCKR_MDIV_Msk     = 0x300  // Bit mask of MDIV field.
	PMC_PMC_MCKR_PLLADIV2_Pos = 0xc    // Position of PLLADIV2 field.
	PMC_PMC_MCKR_PLLADIV2_Msk = 0x1000 // Bit mask of PLLADIV2 field.
	PMC_PMC_MCKR_PLLADIV2     = 0x1000 // Bit PLLADIV2.

	// PMC_USB: USB Clock Register
	PMC_PMC_USB_USBS_Pos   = 0x0   // Position of USBS field.
	PMC_PMC_USB_USBS_Msk   = 0x1   // Bit mask of USBS field.
	PMC_PMC_USB_USBS       = 0x1   // Bit USBS.
	PMC_PMC_USB_USBDIV_Pos = 0x8   // Position of USBDIV field.
	PMC_PMC_USB_USBDIV_Msk = 0xf00 // Bit mask of USBDIV field.

	// PMC_PCK: Programmable Clock 0 Register
	PMC_PMC_PCK_CSS_Pos     = 0x0   // Position of CSS field.
	PMC_PMC_PCK_CSS_Msk     = 0x3   // Bit mask of CSS field.
	PMC_PMC_PCK_PRES_Pos    = 0x2   // Position of PRES field.
	PMC_PMC_PCK_PRES_Msk    = 0x1c  // Bit mask of PRES field.
	PMC_PMC_PCK_SLCKMCK_Pos = 0x8   // Position of SLCKMCK field.
	PMC_PMC_PCK_SLCKMCK_Msk = 0x100 // Bit mask of SLCKMCK field.
	PMC_PMC_PCK_SLCKMCK     = 0x100 // Bit SLCKMCK.

	// PMC_IER: Interrupt Enable Register
	PMC_PMC_IER_MOSCS_Pos   = 0x0   // Position of MOSCS field.
	PMC_PMC_IER_MOSCS_Msk   = 0x1   // Bit mask of MOSCS field.
	PMC_PMC_IER_MOSCS       = 0x1   // Bit MOSCS.
	PMC_PMC_IER_LOCKA_Pos   = 0x1   // Position of LOCKA field.
	PMC_PMC_IER_LOCKA_Msk   = 0x2   // Bit mask of LOCKA field.
	PMC_PMC_IER_LOCKA       = 0x2   // Bit LOCKA.
	PMC_PMC_IER_MCKRDY_Pos  = 0x3   // Position of MCKRDY field.
	PMC_PMC_IER_MCKRDY_Msk  = 0x8   // Bit mask of MCKRDY field.
	PMC_PMC_IER_MCKRDY      = 0x8   // Bit MCKRDY.
	PMC_PMC_IER_LOCKU_Pos   = 0x6   // Position of LOCKU field.
	PMC_PMC_IER_LOCKU_Msk   = 0x40  // Bit mask of LOCKU field.
	PMC_PMC_IER_LOCKU       = 0x40  // Bit LOCKU.
	PMC_PMC_IER_PCKRDY0_Pos = 0x8   // Position of PCKRDY0 field.
	PMC_PMC_IER_PCKRDY0_Msk = 0x100 // Bit mask of PCKRDY0 field.
	PMC_PMC_IER_PCKRDY0     = 0x100 // Bit PCKRDY0.
	PMC_PMC_IER_PCKRDY1_Pos = 0x9   // Position of PCKRDY1 field.
	PMC_PMC_IER_PCKRDY1_Msk = 0x200 // Bit mask of PCKRDY1 field.
	PMC_PMC_IER_PCKRDY1     = 0x200 // Bit PCKRDY1.

	// PMC_IDR: Interrupt Disable Register
	PMC_PMC_IDR_MOSCS_Pos   = 0x0   // Position of MOSCS field.
	PMC_PMC_IDR_MOSCS_Msk   = 0x1   // Bit mask of MOSCS field.
	PMC_PMC_IDR_MOSCS       = 0x1   // Bit MOSCS.
	PMC_PMC_IDR_LOCKA_Pos   = 0x1   // Position of LOCKA field.
	PMC_PMC_IDR_LOCKA_Msk   = 0x2   // Bit mask of LOCKA field.
	PMC_PMC_IDR_LOCKA       = 0x2   // Bit LOCKA.
	PMC_PMC_IDR_MCKRDY_Pos  = 0x3   // Position of MCKRDY field.
	PMC_PMC_IDR_MCKRDY_Msk  = 0x8   // Bit mask of MCKRDY field.
	PMC_PMC_IDR_MCKRDY      = 0x8   // Bit MCKRDY.
	PMC_PMC_IDR_LOCKU_Pos   = 0x6   // Position of LOCKU field.
	PMC_PMC_IDR_LOCKU_Msk   = 0x40  // Bit mask of LOCKU field.
	PMC_PMC_IDR_LOCKU       = 0x40  // Bit LOCKU.
	PMC_PMC_IDR_PCKRDY0_Pos = 0x8   // Position of PCKRDY0 field.
	PMC_PMC_IDR_PCKRDY0_Msk = 0x100 // Bit mask of PCKRDY0 field.
	PMC_PMC_IDR_PCKRDY0     = 0x100 // Bit PCKRDY0.
	PMC_PMC_IDR_PCKRDY1_Pos = 0x9   // Position of PCKRDY1 field.
	PMC_PMC_IDR_PCKRDY1_Msk = 0x200 // Bit mask of PCKRDY1 field.
	PMC_PMC_IDR_PCKRDY1     = 0x200 // Bit PCKRDY1.

	// PMC_SR: Status Register
	PMC_PMC_SR_MOSCS_Pos   = 0x0   // Position of MOSCS field.
	PMC_PMC_SR_MOSCS_Msk   = 0x1   // Bit mask of MOSCS field.
	PMC_PMC_SR_MOSCS       = 0x1   // Bit MOSCS.
	PMC_PMC_SR_LOCKA_Pos   = 0x1   // Position of LOCKA field.
	PMC_PMC_SR_LOCKA_Msk   = 0x2   // Bit mask of LOCKA field.
	PMC_PMC_SR_LOCKA       = 0x2   // Bit LOCKA.
	PMC_PMC_SR_MCKRDY_Pos  = 0x3   // Position of MCKRDY field.
	PMC_PMC_SR_MCKRDY_Msk  = 0x8   // Bit mask of 