// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from STM32L0x1.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/STMicro

// +build stm32,stm32l0x1

// STM32L0x1
//

package stm32

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "STM32L0x1"
)

// Interrupt numbers.
const (
	IRQ_WWDG            = 0  // System window watchdog
	IRQ_PVD             = 1  // External interrupt/event controller
	IRQ_RTC             = 2  // Real-time clock
	IRQ_FLASH           = 3  // Flash
	IRQ_RCC             = 4  // Reset and clock control
	IRQ_EXTI0_1         = 5  // External interrupt/event controller
	IRQ_EXTI2_3         = 6  // External interrupt/event controller
	IRQ_EXTI4_15        = 7  // External interrupt/event controller
	IRQ_DMA1_Channel1   = 9  // Direct memory access controller
	IRQ_DMA1_Channel2_3 = 10 // Direct memory access controller
	IRQ_DMA1_Channel4_7 = 11 // Direct memory access controller
	IRQ_ADC_COMP        = 12 // Analog-to-digital converter
	IRQ_LPTIM1          = 13 // Low power timer
	IRQ_USART4_USART5   = 14 //
	IRQ_TIM2            = 15 // General-purpose-timers
	IRQ_TIM3            = 16 //
	IRQ_TIM6            = 17 // Basic-timers
	IRQ_TIM7            = 18 //
	IRQ_TIM21           = 20 // General-purpose-timers
	IRQ_I2C3            = 21 //
	IRQ_TIM22           = 22 // General-purpose-timers
	IRQ_I2C1            = 23 // Inter-integrated circuit
	IRQ_I2C2            = 24 //
	IRQ_SPI1            = 25 // Serial peripheral interface
	IRQ_SPI2            = 26 //
	IRQ_USART1          = 27 // Universal synchronous asynchronous receiver transmitter
	IRQ_USART2          = 28 //
	IRQ_AES_RNG_LPUART1 = 29 // Advanced encryption standard hardware accelerator
	IRQ_max             = 29 // Highest interrupt number on this device.
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_WWDG, "WWDG_IRQHandler")
	_ = interrupt.Register(IRQ_PVD, "PVD_IRQHandler")
	_ = interrupt.Register(IRQ_RTC, "RTC_IRQHandler")
	_ = interrupt.Register(IRQ_FLASH, "FLASH_IRQHandler")
	_ = interrupt.Register(IRQ_RCC, "RCC_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI0_1, "EXTI0_1_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI2_3, "EXTI2_3_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI4_15, "EXTI4_15_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel1, "DMA1_Channel1_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel2_3, "DMA1_Channel2_3_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel4_7, "DMA1_Channel4_7_IRQHandler")
	_ = interrupt.Register(IRQ_ADC_COMP, "ADC_COMP_IRQHandler")
	_ = interrupt.Register(IRQ_LPTIM1, "LPTIM1_IRQHandler")
	_ = interrupt.Register(IRQ_USART4_USART5, "USART4_USART5_IRQHandler")
	_ = interrupt.Register(IRQ_TIM2, "TIM2_IRQHandler")
	_ = interrupt.Register(IRQ_TIM3, "TIM3_IRQHandler")
	_ = interrupt.Register(IRQ_TIM6, "TIM6_IRQHandler")
	_ = interrupt.Register(IRQ_TIM7, "TIM7_IRQHandler")
	_ = interrupt.Register(IRQ_TIM21, "TIM21_IRQHandler")
	_ = interrupt.Register(IRQ_I2C3, "I2C3_IRQHandler")
	_ = interrupt.Register(IRQ_TIM22, "TIM22_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1, "I2C1_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2, "I2C2_IRQHandler")
	_ = interrupt.Register(IRQ_SPI1, "SPI1_IRQHandler")
	_ = interrupt.Register(IRQ_SPI2, "SPI2_IRQHandler")
	_ = interrupt.Register(IRQ_USART1, "USART1_IRQHandler")
	_ = interrupt.Register(IRQ_USART2, "USART2_IRQHandler")
	_ = interrupt.Register(IRQ_AES_RNG_LPUART1, "AES_RNG_LPUART1_IRQHandler")
)

// Peripherals.
var (
	AES         = (*AES_Type)(unsafe.Pointer(uintptr(0x40026000)))      // Advanced encryption standard hardware accelerator
	DMA1        = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020000)))      // Direct memory access controller
	CRC         = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))      // Cyclic redundancy check calculation unit
	GPIOA       = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000000)))     // General-purpose I/Os
	GPIOB       = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000400)))     // General-purpose I/Os
	LPTIM       = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40007c00)))    // Low power timer
	RTC         = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))      // Real-time clock
	USART1      = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800)))    // Universal synchronous asynchronous receiver transmitter
	IWDG        = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))     // Independent watchdog
	WWDG        = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))     // System window watchdog
	Firewall    = (*Firewall_Type)(unsafe.Pointer(uintptr(0x40011c00))) // Firewall
	RCC         = (*RCC_Type)(unsafe.Pointer(uintptr(0x40021000)))      // Reset and clock control
	SYSCFG_COMP = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40010000)))   // System configuration controller and COMP register
	SPI1        = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))      // Serial peripheral interface
	I2C1        = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))      // Inter-integrated circuit
	PWR         = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))      // Power control
	Flash       = (*Flash_Type)(unsafe.Pointer(uintptr(0x40022000)))    // Flash
	EXTI        = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40010400)))     // External interrupt/event controller
	ADC         = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012400)))      // Analog-to-digital converter
	DBG         = (*DBGMCU_Type)(unsafe.Pointer(uintptr(0x40015800)))   // Debug support
	TIM2        = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))      // General-purpose-timers
	TIM6        = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))      // Basic-timers
	TIM21       = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010800)))      // General-purpose-timers
	TIM22       = (*TIM_Type)(unsafe.Pointer(uintptr(0x40011400)))      // General-purpose-timers
	LPUART1     = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))    // Lower power Universal asynchronous receiver transmitter
	NVIC        = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))     // Nested Vectored Interrupt Controller
	MPU         = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))      // Memory protection unit
	STK         = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))      // SysTick timer
	SCB         = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))      // System control block
	GPIOC       = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000800)))     // General-purpose I/Os
	GPIOD       = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000c00)))     // General-purpose I/Os
	GPIOH       = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50001c00)))     // General-purpose I/Os
	GPIOE       = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50001000)))     // General-purpose I/Os
	USART2      = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))    // Universal synchronous asynchronous receiver transmitter
	USART4      = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))    // Universal synchronous asynchronous receiver transmitter
	USART5      = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000)))    // Universal synchronous asynchronous receiver transmitter
	SPI2        = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))      // Serial peripheral interface
	I2C2        = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))      // Inter-integrated circuit
	I2C3        = (*I2C_Type)(unsafe.Pointer(uintptr(0x40007800)))      // Inter-integrated circuit
	TIM3        = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))      // General-purpose-timers
	TIM7        = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))      // Basic-timers
)

// Advanced encryption standard hardware accelerator
type AES_Type struct {
	CR    volatile.Register32 // 0x0
	SR    volatile.Register32 // 0x4
	DINR  volatile.Register32 // 0x8
	DOUTR volatile.Register32 // 0xC
	KEYR0 volatile.Register32 // 0x10
	KEYR1 volatile.Register32 // 0x14
	KEYR2 volatile.Register32 // 0x18
	KEYR3 volatile.Register32 // 0x1C
	IVR0  volatile.Register32 // 0x20
	IVR1  volatile.Register32 // 0x24
	IVR2  volatile.Register32 // 0x28
	IVR3  volatile.Register32 // 0x2C
}

// Direct memory access controller
type DMA_Type struct {
	ISR    volatile.Register32 // 0x0
	IFCR   volatile.Register32 // 0x4
	CCR1   volatile.Register32 // 0x8
	CNDTR1 volatile.Register32 // 0xC
	CPAR1  volatile.Register32 // 0x10
	CMAR1  volatile.Register32 // 0x14
	_      [4]byte
	CCR2   volatile.Register32 // 0x1C
	CNDTR2 volatile.Register32 // 0x20
	CPAR2  volatile.Register32 // 0x24
	CMAR2  volatile.Register32 // 0x28
	_      [4]byte
	CCR3   volatile.Register32 // 0x30
	CNDTR3 volatile.Register32 // 0x34
	CPAR3  volatile.Register32 // 0x38
	CMAR3  volatile.Register32 // 0x3C
	_      [4]byte
	CCR4   volatile.Register32 // 0x44
	CNDTR4 volatile.Register32 // 0x48
	CPAR4  volatile.Register32 // 0x4C
	CMAR4  volatile.Register32 // 0x50
	_      [4]byte
	CCR5   volatile.Register32 // 0x58
	CNDTR5 volatile.Register32 // 0x5C
	CPAR5  volatile.Register32 // 0x60
	CMAR5  volatile.Register32 // 0x64
	_      [4]byte
	CCR6   volatile.Register32 // 0x6C
	CNDTR6 volatile.Register32 // 0x70
	CPAR6  volatile.Register32 // 0x74
	CMAR6  volatile.Register32 // 0x78
	_      [4]byte
	CCR7   volatile.Register32 // 0x80
	CNDTR7 volatile.Register32 // 0x84
	CPAR7  volatile.Register32 // 0x88
	CMAR7  volatile.Register32 // 0x8C
	_      [24]byte
	CSELR  volatile.Register32 // 0xA8
}

// Cyclic redundancy check calculation unit
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	_    [4]byte
	INIT volatile.Register32 // 0x10
	POL  volatile.Register32 // 0x14
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
	BRR     volatile.Register32 // 0x28
}

// Low power timer
type LPTIM_Type struct {
	ISR  volatile.Register32 // 0x0
	ICR  volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	CFGR volatile.Register32 // 0xC
	CR   volatile.Register32 // 0x10
	CMP  volatile.Register32 // 0x14
	ARR  volatile.Register32 // 0x18
	CNT  volatile.Register32 // 0x1C
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	ISR      volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	_        [4]byte
	ALRMAR   volatile.Register32 // 0x1C
	ALRMBR   volatile.Register32 // 0x20
	WPR      volatile.Register32 // 0x24
	SSR      volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	CALR     volatile.Register32 // 0x3C
	TAMPCR   volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBSSR volatile.Register32 // 0x48
	OR       volatile.Register32 // 0x4C
	BKP0R    volatile.Register32 // 0x50
	BKP1R    volatile.Register32 // 0x54
	BKP2R    volatile.Register32 // 0x58
	BKP3R    volatile.Register32 // 0x5C
	BKP4R    volatile.Register32 // 0x60
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	CR1  volatile.Register32 // 0x0
	CR2  volatile.Register32 // 0x4
	CR3  volatile.Register32 // 0x8
	BRR  volatile.Register32 // 0xC
	GTPR volatile.Register32 // 0x10
	RTOR volatile.Register32 // 0x14
	RQR  volatile.Register32 // 0x18
	ISR  volatile.Register32 // 0x1C
	ICR  volatile.Register32 // 0x20
	RDR  volatile.Register32 // 0x24
	TDR  volatile.Register32 // 0x28
}

// Independent watchdog
type IWDG_Type struct {
	KR   volatile.Register32 // 0x0
	PR   volatile.Register32 // 0x4
	RLR  volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	WINR volatile.Register32 // 0x10
}

// System window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// Firewall
type Firewall_Type struct {
	FIREWALL_CSSA   volatile.Register32 // 0x0
	FIREWALL_CSL    volatile.Register32 // 0x4
	FIREWALL_NVDSSA volatile.Register32 // 0x8
	FIREWALL_NVDSL  volatile.Register32 // 0xC
	FIREWALL_VDSSA  volatile.Register32 // 0x10
	FIREWALL_VDSL   volatile.Register32 // 0x14
	_               [8]byte
	FIREWALL_CR     volatile.Register32 // 0x20
}

// Reset and clock control
type RCC_Type struct {
	CR        volatile.Register32 // 0x0
	ICSCR     volatile.Register32 // 0x4
	_         [4]byte
	CFGR      volatile.Register32 // 0xC
	CIER      volatile.Register32 // 0x10
	CIFR      volatile.Register32 // 0x14
	CICR      volatile.Register32 // 0x18
	IOPRSTR   volatile.Register32 // 0x1C
	AHBRSTR   volatile.Register32 // 0x20
	APB2RSTR  volatile.Register32 // 0x24
	APB1RSTR  volatile.Register32 // 0x28
	IOPENR    volatile.Register32 // 0x2C
	AHBENR    volatile.Register32 // 0x30
	APB2ENR   volatile.Register32 // 0x34
	APB1ENR   volatile.Register32 // 0x38
	IOPSMEN   volatile.Register32 // 0x3C
	AHBSMENR  volatile.Register32 // 0x40
	APB2SMENR volatile.Register32 // 0x44
	APB1SMENR volatile.Register32 // 0x48
	CCIPR     volatile.Register32 // 0x4C
	CSR       volatile.Register32 // 0x50
}

// System configuration controller and COMP register
type SYSCFG_Type struct {
	CFGR1      volatile.Register32 // 0x0
	CFGR2      volatile.Register32 // 0x4
	EXTICR1    volatile.Register32 // 0x8
	EXTICR2    volatile.Register32 // 0xC
	EXTICR3    volatile.Register32 // 0x10
	EXTICR4    volatile.Register32 // 0x14
	COMP1_CTRL volatile.Register32 // 0x18
	COMP2_CTRL volatile.Register32 // 0x1C
	CFGR3      volatile.Register32 // 0x20
}

// Serial peripheral interface
type SPI_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	SR      volatile.Register32 // 0x8
	DR      volatile.Register32 // 0xC
	CRCPR   volatile.Register32 // 0x10
	RXCRCR  volatile.Register32 // 0x14
	TXCRCR  volatile.Register32 // 0x18
	I2SCFGR volatile.Register32 // 0x1C
	I2SPR   volatile.Register32 // 0x20
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// Power control
type PWR_Type struct {
	CR  volatile.Register32 // 0x0
	CSR volatile.Register32 // 0x4
}

// Flash
type Flash_Type struct {
	ACR     volatile.Register32 // 0x0
	PECR    volatile.Register32 // 0x4
	PDKEYR  volatile.Register32 // 0x8
	PEKEYR  volatile.Register32 // 0xC
	PRGKEYR volatile.Register32 // 0x10
	OPTKEYR volatile.Register32 // 0x14
	SR      volatile.Register32 // 0x18
	OBR     volatile.Register32 // 0x1C
	WRPR    volatile.Register32 // 0x20
}

// External interrupt/event controller
type EXTI_Type struct {
	IMR   volatile.Register32 // 0x0
	EMR   volatile.Register32 // 0x4
	RTSR  volatile.Register32 // 0x8
	FTSR  volatile.Register32 // 0xC
	SWIER volatile.Register32 // 0x10
	PR    volatile.Register32 // 0x14
}

// Analog-to-digital converter
type ADC_Type struct {
	ISR     volatile.Register32 // 0x0
	IER     volatile.Register32 // 0x4
	CR      volatile.Register32 // 0x8
	CFGR1   volatile.Register32 // 0xC
	CFGR2   volatile.Register32 // 0x10
	SMPR    volatile.Register32 // 0x14
	_       [8]byte
	TR      volatile.Register32 // 0x20
	_       [4]byte
	CHSELR  volatile.Register32 // 0x28
	_       [20]byte
	DR      volatile.Register32 // 0x40
	_       [112]byte
	CALFACT volatile.Register32 // 0xB4
	_       [592]byte
	CCR     volatile.Register32 // 0x308
}

// Debug support
type DBGMCU_Type struct {
	IDCODE  volatile.Register32 // 0x0
	CR      volatile.Register32 // 0x4
	APB1_FZ volatile.Register32 // 0x8
	APB2_FZ volatile.Register32 // 0xC
}

// General-purpose-timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	_            [4]byte
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	_            [4]byte
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
	OR           volatile.Register32 // 0x50
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER volatile.Register32 // 0x0
	_    [124]byte
	ICER volatile.Register32 // 0x80
	_    [124]byte
	ISPR volatile.Register32 // 0x100
	_    [124]byte
	ICPR volatile.Register32 // 0x180
	_    [380]byte
	IPR0 volatile.Register32 // 0x300
	IPR1 volatile.Register32 // 0x304
	IPR2 volatile.Register32 // 0x308
	IPR3 volatile.Register32 // 0x30C
	IPR4 volatile.Register32 // 0x310
	IPR5 volatile.Register32 // 0x314
	IPR6 volatile.Register32 // 0x318
	IPR7 volatile.Register32 // 0x31C
}

// Memory protection unit
type MPU_Type struct {
	MPU_TYPER volatile.Register32 // 0x0
	MPU_CTRL  volatile.Register32 // 0x4
	MPU_RNR   volatile.Register32 // 0x8
	MPU_RBAR  volatile.Register32 // 0xC
	MPU_RASR  volatile.Register32 // 0x10
}

// SysTick timer
type STK_Type struct {
	CSR   volatile.Register32 // 0x0
	RVR   volatile.Register32 // 0x4
	CVR   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// System control block
type SCB_Type struct {
	CPUID volatile.Register32 // 0x0
	ICSR  volatile.Register32 // 0x4
	VTOR  volatile.Register32 // 0x8
	AIRCR volatile.Register32 // 0xC
	SCR   volatile.Register32 // 0x10
	CCR   volatile.Register32 // 0x14
	_     [4]byte
	SHPR2 volatile.Register32 // 0x1C
	SHPR3 volatile.Register32 // 0x20
}

// Bitfields for AES: Advanced encryption standard hardware accelerator
const (
	// CR: control register
	AES_CR_DMAOUTEN_Pos = 0xc    // Position of DMAOUTEN field.
	AES_CR_DMAOUTEN_Msk = 0x1000 // Bit mask of DMAOUTEN field.
	AES_CR_DMAOUTEN     = 0x1000 // Bit DMAOUTEN.
	AES_CR_DMAINEN_Pos  = 0xb    // Position of DMAINEN field.
	AES_CR_DMAINEN_Msk  = 0x800  // Bit mask of DMAINEN field.
	AES_CR_DMAINEN      = 0x800  // Bit DMAINEN.
	AES_CR_ERRIE_Pos    = 0xa    // Position of ERRIE field.
	AES_CR_ERRIE_Msk    = 0x400  // Bit mask of ERRIE field.
	AES_CR_ERRIE        = 0x400  // Bit ERRIE.
	AES_CR_CCFIE_Pos    = 0x9    // Position of CCFIE field.
	AES_CR_CCFIE_Msk    = 0x200  // Bit mask of CCFIE field.
	AES_CR_CCFIE        = 0x200  // Bit CCFIE.
	AES_CR_ERRC_Pos     = 0x8    // Position of ERRC field.
	AES_CR_ERRC_Msk     = 0x100  // Bit mask of ERRC field.
	AES_CR_ERRC         = 0x100  // Bit ERRC.
	AES_CR_CCFC_Pos     = 0x7    // Position of CCFC field.
	AES_CR_CCFC_Msk     = 0x80   // Bit mask of CCFC field.
	AES_CR_CCFC         = 0x80   // Bit CCFC.
	AES_CR_CHMOD_Pos    = 0x5    // Position of CHMOD field.
	AES_CR_CHMOD_Msk    = 0x60   // Bit mask of CHMOD field.
	AES_CR_MODE_Pos     = 0x3    // Position of MODE field.
	AES_CR_MODE_Msk     = 0x18   // Bit mask of MODE field.
	AES_CR_DATATYPE_Pos = 0x1    // Position of DATATYPE field.
	AES_CR_DATATYPE_Msk = 0x6    // Bit mask of DATATYPE field.
	AES_CR_EN_Pos       = 0x0    // Position of EN field.
	AES_CR_EN_Msk       = 0x1    // Bit mask of EN field.
	AES_CR_EN           = 0x1    // Bit EN.

	// SR: status register
	AES_SR_WRERR_Pos = 0x2 // Position of WRERR field.
	AES_SR_WRERR_Msk = 0x4 // Bit mask of WRERR field.
	AES_SR_WRERR     = 0x4 // Bit WRERR.
	AES_SR_RDERR_Pos = 0x1 // Position of RDERR field.
	AES_SR_RDERR_Msk = 0x2 // Bit mask of RDERR field.
	AES_SR_RDERR     = 0x2 // Bit RDERR.
	AES_SR_CCF_Pos   = 0x0 // Position of CCF field.
	AES_SR_CCF_Msk   = 0x1 // Bit mask of CCF field.
	AES_SR_CCF       = 0x1 // Bit CCF.

	// DINR: data input register
	AES_DINR_AES_DINR_Pos = 0x0        // Position of AES_DINR field.
	AES_DINR_AES_DINR_Msk = 0xffffffff // Bit mask of AES_DINR field.

	// DOUTR: data output register
	AES_DOUTR_AES_DOUTR_Pos = 0x0        // Position of AES_DOUTR field.
	AES_DOUTR_AES_DOUTR_Msk = 0xffffffff // Bit mask of AES_DOUTR field.

	// KEYR0: key register 0
	AES_KEYR0_AES_KEYR0_Pos = 0x0        // Position of AES_KEYR0 field.
	AES_KEYR0_AES_KEYR0_Msk = 0xffffffff // Bit mask of AES_KEYR0 field.

	// KEYR1: key register 1
	AES_KEYR1_AES_KEYR1_Pos = 0x0        // Position of AES_KEYR1 field.
	AES_KEYR1_AES_KEYR1_Msk = 0xffffffff // Bit mask of AES_KEYR1 field.

	// KEYR2: key register 2
	AES_KEYR2_AES_KEYR2_Pos = 0x0        // Position of AES_KEYR2 field.
	AES_KEYR2_AES_KEYR2_Msk = 0xffffffff // Bit mask of AES_KEYR2 field.

	// KEYR3: key register 3
	AES_KEYR3_AES_KEYR3_Pos = 0x0        // Position of AES_KEYR3 field.
	AES_KEYR3_AES_KEYR3_Msk = 0xffffffff // Bit mask of AES_KEYR3 field.

	// IVR0: initialization vector register           0
	AES_IVR0_AES_IVR0_Pos = 0x0        // Position of AES_IVR0 field.
	AES_IVR0_AES_IVR0_Msk = 0xffffffff // Bit mask of AES_IVR0 field.

	// IVR1: initialization vector register           1
	AES_IVR1_AES_IVR1_Pos = 0x0        // Position of AES_IVR1 field.
	AES_IVR1_AES_IVR1_Msk = 0xffffffff // Bit mask of AES_IVR1 field.

	// IVR2: initialization vector register           2
	AES_IVR2_AES_IVR2_Pos = 0x0        // Position of AES_IVR2 field.
	AES_IVR2_AES_IVR2_Msk = 0xffffffff // Bit mask of AES_IVR2 field.

	// IVR3: initialization vector register           3
	AES_IVR3_AES_IVR3_Pos = 0x0        // Position of AES_IVR3 field.
	AES_IVR3_AES_IVR3_Msk = 0xffffffff // Bit mask of AES_IVR3 field.
)

// Bitfields for DMA1: Direct memory access controller
const (
	// ISR: interrupt status register
	DMA_ISR_TEIF7_Pos = 0x1b      // Position of TEIF7 field.
	DMA_ISR_TEIF7_Msk = 0x8000000 // Bit mask of TEIF7 field.
	DMA_ISR_TEIF7     = 0x8000000 // Bit TEIF7.
	DMA_ISR_HTIF7_Pos = 0x1a      // Position of HTIF7 field.
	DMA_ISR_HTIF7_Msk = 0x4000000 // Bit mask of HTIF7 field.
	DMA_ISR_HTIF7     = 0x4000000 // Bit HTIF7.
	DMA_ISR_TCIF7_Pos = 0x19      // Position of TCIF7 field.
	DMA_ISR_TCIF7_Msk = 0x2000000 // Bit mask of TCIF7 field.
	DMA_ISR_TCIF7     = 0x2000000 // Bit TCIF7.
	DMA_ISR_GIF7_Pos  = 0x18      // Position of GIF7 field.
	DMA_ISR_GIF7_Msk  = 0x1000000 // Bit mask of GIF7 field.
	DMA_ISR_GIF7      = 0x1000000 // Bit GIF7.
	DMA_ISR_TEIF6_Pos = 0x17      // Position of TEIF6 field.
	DMA_ISR_TEIF6_Msk = 0x800000  // Bit mask of TEIF6 field.
	DMA_ISR_TEIF6     = 0x800000  // Bit TEIF6.
	DMA_ISR_HTIF6_Pos = 0x16      // Position of HTIF6 field.
	DMA_ISR_HTIF6_Msk = 0x400000  // Bit mask of HTIF6 field.
	DMA_ISR_HTIF6     = 0x400000  // Bit HTIF6.
	DMA_ISR_TCIF6_Pos = 0x15      // Position of TCIF6 field.
	DMA_ISR_TCIF6_Msk = 0x200000  // Bit mask of TCIF6 field.
	DMA_ISR_TCIF6     = 0x200000  // Bit TCIF6.
	DMA_ISR_GIF6_Pos  = 0x14      // Position of GIF6 field.
	DMA_ISR_GIF6_Msk  = 0x100000  // Bit mask of GIF6 field.
	DMA_ISR_GIF6      = 0x100000  // Bit GIF6.
	DMA_ISR_TEIF5_Pos = 0x13      // Position of TEIF5 field.
	DMA_ISR_TEIF5_Msk = 0x80000   // Bit mask of TEIF5 field.
	DMA_ISR_TEIF5     = 0x80000   // Bit TEIF5.
	DMA_ISR_HTIF5_Pos = 0x12      // Position of HTIF5 field.
	DMA_ISR_HTIF5_Msk = 0x40000   // Bit mask of HTIF5 field.
	DMA_ISR_HTIF5     = 0x40000   // Bit HTIF5.
	DMA_ISR_TCIF5_Pos = 0x11      // Position of TCIF5 field.
	DMA_ISR_TCIF5_Msk = 0x20000   // Bit mask of TCIF5 field.
	DMA_ISR_TCIF5     = 0x20000   // Bit TCIF5.
	DMA_ISR_GIF5_Pos  = 0x10      // Position of GIF5 field.
	DMA_ISR_GIF5_Msk  = 0x10000   // Bit mask of GIF5 field.
	DMA_ISR_GIF5      = 0x10000   // Bit GIF5.
	DMA_ISR_TEIF4_Pos = 0xf       // Position of TEIF4 field.
	DMA_ISR_TEIF4_Msk = 0x8000    // Bit mask of TEIF4 field.
	DMA_ISR_TEIF4     = 0x8000    // Bit TEIF4.
	DMA_ISR_HTIF4_Pos = 0xe       // Position of HTIF4 field.
	DMA_ISR_HTIF4_Msk = 0x4000    // Bit mask of HTIF4 field.
	DMA_ISR_HTIF4     = 0x4000    // Bit HTIF4.
	DMA_ISR_TCIF4_Pos = 0xd       // Position of TCIF4 field.
	DMA_ISR_TCIF4_Msk = 0x2000    // Bit mask of TCIF4 field.
	DMA_ISR_TCIF4     = 0x2000    // Bit TCIF4.
	DMA_ISR_GIF4_Pos  = 0xc       // Position of GIF4 field.
	DMA_ISR_GIF4_Msk  = 0x1000    // Bit mask of GIF4 field.
	DMA_ISR_GIF4      = 0x1000    // Bit GIF4.
	DMA_ISR_TEIF3_Pos = 0xb       // Position of TEIF3 field.
	DMA_ISR_TEIF3_Msk = 0x800     // Bit mask of TEIF3 field.
	DMA_ISR_TEIF3     = 0x800     // Bit TEIF3.
	DMA_ISR_HTIF3_Pos = 0xa       // Position of HTIF3 field.
	DMA_ISR_HTIF3_Msk = 0x400     // Bit mask of HTIF3 field.
	DMA_ISR_HTIF3     = 0x400     // Bit HTIF3.
	DMA_ISR_TCIF3_Pos = 0x9       // Position of TCIF3 field.
	DMA_ISR_TCIF3_Msk = 0x200     // Bit mask of TCIF3 field.
	DMA_ISR_TCIF3     = 0x200     // Bit TCIF3.
	DMA_ISR_GIF3_Pos  = 0x8       // Position of GIF3 field.
	DMA_ISR_GIF3_Msk  = 0x100     // Bit mask of GIF3 field.
	DMA_ISR_GIF3      = 0x100     // Bit GIF3.
	DMA_ISR_TEIF2_Pos = 0x7       // Position of TEIF2 field.
	DMA_ISR_TEIF2_Msk = 0x80      // Bit mask of TEIF2 field.
	DMA_ISR_TEIF2     = 0x80      // Bit TEIF2.
	DMA_ISR_HTIF2_Pos = 0x6       // Position of HTIF2 field.
	DMA_ISR_HTIF2_Msk = 0x40      // Bit mask of HTIF2 field.
	DMA_ISR_HTIF2     = 0x40      // Bit HTIF2.
	DMA_ISR_TCIF2_Pos = 0x5       // Position of TCIF2 field.
	DMA_ISR_TCIF2_Msk = 0x20      // Bit mask of TCIF2 field.
	DMA_ISR_TCIF2     = 0x20      // Bit TCIF2.
	DMA_ISR_GIF2_Pos  = 0x4       // Position of GIF2 field.
	DMA_ISR_GIF2_Msk  = 0x10      // Bit mask of GIF2 field.
	DMA_ISR_GIF2      = 0x10      // Bit GIF2.
	DMA_ISR_TEIF1_Pos = 0x3       // Position of TEIF1 field.
	DMA_ISR_TEIF1_Msk = 0x8       // Bit mask of TEIF1 field.
	DMA_ISR_TEIF1     = 0x8       // Bit TEIF1.
	DMA_ISR_HTIF1_Pos = 0x2       // Position of HTIF1 field.
	DMA_ISR_HTIF1_Msk = 0x4       // Bit mask of HTIF1 field.
	DMA_ISR_HTIF1     = 0x4       // Bit HTIF1.
	DMA_ISR_TCIF1_Pos = 0x1       // Position of TCIF1 field.
	DMA_ISR_TCIF1_Msk = 0x2       // Bit mask of TCIF1 field.
	DMA_ISR_TCIF1     = 0x2       // Bit TCIF1.
	DMA_ISR_GIF1_Pos  = 0x0       // Position of GIF1 field.
	DMA_ISR_GIF1_Msk  = 0x1       // Bit mask of GIF1 field.
	DMA_ISR_GIF1      = 0x1       // Bit GIF1.

	// IFCR: interrupt flag clear register
	DMA_IFCR_CTEIF7_Pos = 0x1b      // Position of CTEIF7 field.
	DMA_IFCR_CTEIF7_Msk = 0x8000000 // Bit mask of CTEIF7 field.
	DMA_IFCR_CTEIF7     = 0x8000000 // Bit CTEIF7.
	DMA_IFCR_CHTIF7_Pos = 0x1a      // Position of CHTIF7 field.
	DMA_IFCR_CHTIF7_Msk = 0x4000000 // Bit mask of CHTIF7 field.
	DMA_IFCR_CHTIF7     = 0x4000000 // Bit CHTIF7.
	DMA_IFCR_CTCIF7_Pos = 0x19      // Position of CTCIF7 field.
	DMA_IFCR_CTCIF7_Msk = 0x2000000 // Bit mask of CTCIF7 field.
	DMA_IFCR_CTCIF7     = 0x2000000 // Bit CTCIF7.
	DMA_IFCR_CGIF7_Pos  = 0x18      // Position of CGIF7 field.
	DMA_IFCR_CGIF7_Msk  = 0x1000000 // Bit mask of CGIF7 field.
	DMA_IFCR_CGIF7      = 0x1000000 // Bit CGIF7.
	DMA_IFCR_CTEIF6_Pos = 0x17      // Position of CTEIF6 field.
	DMA_IFCR_CTEIF6_Msk = 0x800000  // Bit mask of CTEIF6 field.
	DMA_IFCR_CTEIF6     = 0x800000  // Bit CTEIF6.
	DMA_IFCR_CHTIF6_Pos = 0x16      // Position of CHTIF6 field.
	DMA_IFCR_CHTIF6_Msk = 0x400000  // Bit mask of CHTIF6 field.
	DMA_IFCR_CHTIF6     = 0x400000  // Bit CHTIF6.
	DMA_IFCR_CTCIF6_Pos = 0x15      // Position of CTCIF6 field.
	DMA_IFCR_CTCIF6_Msk = 0x200000  // Bit mask of CTCIF6 field.
	DMA_IFCR_CTCIF6     = 0x200000  // Bit CTCIF6.
	DMA_IFCR_CGIF6_Pos  = 0x14      // Position of CGIF6 field.
	DMA_IFCR_CGIF6_Msk  = 0x100000  // Bit mask of CGIF6 field.
	DMA_IFCR_CGIF6      = 0x100000  // Bit CGIF6.
	DMA_IFCR_CTEIF5_Pos = 0x13      // Position of CTEIF5 field.
	DMA_IFCR_CTEIF5_Msk = 0x80000   // Bit mask of CTEIF5 field.
	DMA_IFCR_CTEIF5     = 0x80000   // Bit CTEIF5.
	DMA_IFCR_CHTIF5_Pos = 0x12      // Position of CHTIF5 field.
	DMA_IFCR_CHTIF5_Msk = 0x40000   // Bit mask of CHTIF5 field.
	DMA_IFCR_CHTIF5     = 0x40000   // Bit CHTIF5.
	DMA_IFCR_CTCIF5_Pos = 0x11      // Position of CTCIF5 field.
	DMA_IFCR_CTCIF5_Msk = 0x20000   // Bit mask of CTCIF5 field.
	DMA_IFCR_CTCIF5     = 0x20000   // Bit CTCIF5.
	DMA_IFCR_CGIF5_Pos  = 0x10      // Position of CGIF5 field.
	DMA_IFCR_CGIF5_Msk  = 0x10000   // Bit mask of CGIF5 field.
	DMA_IFCR_CGIF5      = 0x10000   // Bit CGIF5.
	DMA_IFCR_CTEIF4_Pos = 0xf       // Position of CTEIF4 field.
	DMA_IFCR_CTEIF4_Msk = 0x8000    // Bit mask of CTEIF4 field.
	DMA_IFCR_CTEIF4     = 0x8000    // Bit CTEIF4.
	DMA_IFCR_CHTIF4_Pos = 0xe       // Position of CHTIF4 field.
	DMA_IFCR_CHTIF4_Msk = 0x4000    // Bit mask of CHTIF4 field.
	DMA_IFCR_CHTIF4     = 0x4000    // Bit CHTIF4.
	DMA_IFCR_CTCIF4_Pos = 0xd       // Position of CTCIF4 field.
	DMA_IFCR_CTCIF4_Msk = 0x2000    // Bit mask of CTCIF4 field.
	DMA_IFCR_CTCIF4     = 0x2000    // Bit CTCIF4.
	DMA_IFCR_CGIF4_Pos  = 0xc       // Position of CGIF4 field.
	DMA_IFCR_CGIF4_Msk  = 0x1000    // Bit mask of CGIF4 field.
	DMA_IFCR_CGIF4      = 0x1000    // Bit CGIF4.
	DMA_IFCR_CTEIF3_Pos = 0xb       // Position of CTEIF3 field.
	DMA_IFCR_CTEIF3_Msk = 0x800     // Bit mask of CTEIF3 field.
	DMA_IFCR_CTEIF3     = 0x800     // Bit CTEIF3.
	DMA_IFCR_CHTIF3_Pos = 0xa       // Position of CHTIF3 field.
	DMA_IFCR_CHTIF3_Msk = 0x400     // Bit mask of CHTIF3 field.
	DMA_IFCR_CHTIF3     = 0x400     // Bit CHTIF3.
	DMA_IFCR_CTCIF3_Pos = 0x9       // Position of CTCIF3 field.
	DMA_IFCR_CTCIF3_Msk = 0x200     // Bit mask of CTCIF3 field.
	DMA_IFCR_CTCIF3     = 0x200     // Bit CTCIF3.
	DMA_IFCR_CGIF3_Pos  = 0x8       // Position of CGIF3 field.
	DMA_IFCR_CGIF3_Msk  = 0x100     // Bit mask of CGIF3 field.
	DMA_IFCR_CGIF3      = 0x100     // Bit CGIF3.
	DMA_IFCR_CTEIF2_Pos = 0x7       // Position of CTEIF2 field.
	DMA_IFCR_CTEIF2_Msk = 0x80      // Bit mask of CTEIF2 field.
	DMA_IFCR_CTEIF2     = 0x80      // Bit CTEIF2.
	DMA_IFCR_CHTIF2_Pos = 0x6       // Position of CHTIF2 field.
	DMA_IFCR_CHTIF2_Msk = 0x40      // Bit mask of CHTIF2 field.
	DMA_IFCR_CHTIF2     = 0x40      // Bit CHTIF2.
	DMA_IFCR_CTCIF2_Pos = 0x5       // Position of CTCIF2 field.
	DMA_IFCR_CTCIF2_Msk = 0x20      // Bit mask of CTCIF2 field.
	DMA_IFCR_CTCIF2     = 0x20      // Bit CTCIF2.
	DMA_IFCR_CGIF2_Pos  = 0x4       // Position of CGIF2 field.
	DMA_IFCR_CGIF2_Msk  = 0x10      // Bit mask of CGIF2 field.
	DMA_IFCR_CGIF2      = 0x10      // Bit CGIF2.
	DMA_IFCR_CTEIF1_Pos = 0x3       // Position of CTEIF1 field.
	DMA_IFCR_CTEIF1_Msk = 0x8       // Bit mask of CTEIF1 field.
	DMA_IFCR_CTEIF1     = 0x8       // Bit CTEIF1.
	DMA_IFCR_CHTIF1_Pos = 0x2       // Position of CHTIF1 field.
	DMA_IFCR_CHTIF1_Msk = 0x4       // Bit mask of CHTIF1 field.
	DMA_IFCR_CHTIF1     = 0x4       // Bit CHTIF1.
	DMA_IFCR_CTCIF1_Pos = 0x1       // Position of CTCIF1 field.
	DMA_IFCR_CTCIF1_Msk = 0x2       // Bit mask of CTCIF1 field.
	DMA_IFCR_CTCIF1     = 0x2       // Bit CTCIF1.
	DMA_IFCR_CGIF1_Pos  = 0x0       // Position of CGIF1 field.
	DMA_IFCR_CGIF1_Msk  = 0x1       // Bit mask of CGIF1 field.
	DMA_IFCR_CGIF1      = 0x1       // Bit CGIF1.

	// CCR1: channel x configuration           register
	DMA_CCR1_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR1_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR1_MEM2MEM     = 0x4000 // Bit MEM2MEM.
	DMA_CCR1_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR1_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR1_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR1_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR1_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR1_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR1_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR1_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR1_MINC        = 0x80   // Bit MINC.
	DMA_CCR1_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR1_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR1_PINC        = 0x40   // Bit PINC.
	DMA_CCR1_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR1_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR1_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR1_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR1_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR1_DIR         = 0x10   // Bit DIR.
	DMA_CCR1_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR1_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR1_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR1_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR1_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR1_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR1_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR1_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR1_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR1_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR1_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR1_EN          = 0x1    // Bit EN.

	// CNDTR1: channel x number of data           register
	DMA_CNDTR1_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR1_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR1: channel x peripheral address           register
	DMA_CPAR1_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR1_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR1: channel x memory address           register
	DMA_CMAR1_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR1_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR2: channel x configuration           register
	DMA_CCR2_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR2_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR2_MEM2MEM     = 0x4000 // Bit MEM2MEM.
	DMA_CCR2_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR2_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR2_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR2_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR2_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR2_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR2_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR2_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR2_MINC        = 0x80   // Bit MINC.
	DMA_CCR2_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR2_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR2_PINC        = 0x40   // Bit PINC.
	DMA_CCR2_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR2_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR2_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR2_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR2_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR2_DIR         = 0x10   // Bit DIR.
	DMA_CCR2_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR2_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR2_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR2_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR2_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR2_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR2_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR2_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR2_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR2_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR2_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR2_EN          = 0x1    // Bit EN.

	// CNDTR2: channel x number of data           register
	DMA_CNDTR2_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR2_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR2: channel x peripheral address           register
	DMA_CPAR2_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR2_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR2: channel x memory address           register
	DMA_CMAR2_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR2_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR3: channel x configuration           register
	DMA_CCR3_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR3_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR3_MEM2MEM     = 0x4000 // Bit MEM2MEM.
	DMA_CCR3_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR3_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR3_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR3_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR3_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR3_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR3_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR3_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR3_MINC        = 0x80   // Bit MINC.
	DMA_CCR3_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR3_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR3_PINC        = 0x40   // Bit PINC.
	DMA_CCR3_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR3_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR3_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR3_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR3_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR3_DIR         = 0x10   // Bit DIR.
	DMA_CCR3_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR3_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR3_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR3_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR3_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR3_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR3_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR3_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR3_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR3_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR3_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR3_EN          = 0x1    // Bit EN.

	// CNDTR3: channel x number of data           register
	DMA_CNDTR3_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR3_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR3: channel x peripheral address           register
	DMA_CPAR3_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR3_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR3: channel x memory address           register
	DMA_CMAR3_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR3_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR4: channel x configuration           register
	DMA_CCR4_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR4_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR4_MEM2MEM     = 0x4000 // Bit MEM2MEM.
	DMA_CCR4_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR4_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR4_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR4_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR4_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR4_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR4_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR4_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR4_MINC        = 0x80   // Bit MINC.
	DMA_CCR4_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR4_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR4_PINC        = 0x40   // Bit PINC.
	DMA_CCR4_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR4_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR4_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR4_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR4_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR4_DIR         = 0x10   // Bit DIR.
	DMA_CCR4_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR4_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR4_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR4_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR4_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR4_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR4_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR4_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR4_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR4_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR4_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR4_EN          = 0x1    // Bit EN.

	// CNDTR4: channel x number of data           register
	DMA_CNDTR4_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR4_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR4: channel x peripheral address           register
	DMA_CPAR4_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR4_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR4: channel x memory address           register
	DMA_CMAR4_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR4_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR5: channel x configuration           register
	DMA_CCR5_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR5_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR5_MEM2MEM     = 0x4000 // Bit MEM2MEM.
	DMA_CCR5_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR5_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR5_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR5_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR5_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR5_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR5_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR5_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR5_MINC        = 0x80   // Bit MINC.
	DMA_CCR5_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR5_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR5_PINC        = 0x40   // Bit PINC.
	DMA_CCR5_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR5_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR5_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR5_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR5_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR5_DIR         = 0x10   // Bit DIR.
	DMA_CCR5_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR5_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR5_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR5_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR5_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR5_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR5_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR5_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR5_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR5_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR5_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR5_EN          = 0x1    // Bit EN.

	// CNDTR5: channel x number of data           register
	DMA_CNDTR5_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR5_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR5: channel x peripheral address           register
	DMA_CPAR5_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR5_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR5: channel x memory address           register
	DMA_CMAR5_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR5_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR6: channel x configuration           register
	DMA_CCR6_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR6_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR6_MEM2MEM     = 0x4000 // Bit MEM2MEM.
	DMA_CCR6_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR6_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR6_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR6_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR6_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR6_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR6_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR6_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR6_MINC        = 0x80   // Bit MINC.
	DMA_CCR6_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR6_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR6_PINC        = 0x40   // Bit PINC.
	DMA_CCR6_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR6_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR6_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR6_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR6_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR6_DIR         = 0x10   // Bit DIR.
	DMA_CCR6_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR6_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR6_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR6_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR6_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR6_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR6_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR6_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR6_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR6_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR6_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR6_EN          = 0x1    // Bit EN.

	// CNDTR6: channel x number of data           register
	DMA_CNDTR6_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR6_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR6: channel x peripheral address           register
	DMA_CPAR6_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR6_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR6: channel x memory address           register
	DMA_CMAR6_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR6_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR7: channel x configuration           register
	DMA_CCR7_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR7_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR7_MEM2MEM     = 0x4000 // Bit MEM2MEM.
	DMA_CCR7_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR7_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR7_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR7_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR7_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR7_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR7_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR7_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR7_MINC        = 0x80   // Bit MINC.
	DMA_CCR7_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR7_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR7_PINC        = 0x40   // Bit PINC.
	DMA_CCR7_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR7_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR7_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR7_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR7_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR7_DIR         = 0x10   // Bit DIR.
	DMA_CCR7_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR7_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR7_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR7_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR7_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR7_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR7_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR7_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR7_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR7_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR7_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR7_EN          = 0x1    // Bit EN.

	// CNDTR7: channel x number of data           register
	DMA_CNDTR7_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR7_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR7: channel x peripheral address           register
	DMA_CPAR7_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR7_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR7: channel x memory address           register
	DMA_CMAR7_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR7_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CSELR: channel selection register
	DMA_CSELR_C7S_Pos = 0x18      // Position of C7S field.
	DMA_CSELR_C7S_Msk = 0xf000000 // Bit mask of C7S field.
	DMA_CSELR_C6S_Pos = 0x14      // Position of C6S field.
	DMA_CSELR_C6S_Msk = 0xf00000  // Bit mask of C6S field.
	DMA_CSELR_C5S_Pos = 0x10      // Position of C5S field.
	DMA_CSELR_C5S_Msk = 0xf0000   // Bit mask of C5S field.
	DMA_CSELR_C4S_Pos = 0xc       // Position of C4S field.
	DMA_CSELR_C4S_Msk = 0xf000    // Bit mask of C4S field.
	DMA_CSELR_C3S_Pos = 0x8       // Position of C3S field.
	DMA_CSELR_C3S_Msk = 0xf00     // Bit mask of C3S field.
	DMA_CSELR_C2S_Pos = 0x4       // Position of C2S field.
	DMA_CSELR_C2S_Msk = 0xf0      // Bit mask of C2S field.
	DMA_CSELR_C1S_Pos = 0x0       // Position of C1S field.
	DMA_CSELR_C1S_Msk = 0xf       // Bit mask of C1S field.
)

// Bitfields for CRC: Cyclic redundancy check calculation unit
const (
	// DR: Data register
	CRC_DR_DR_Pos = 0x0        // Position of DR field.
	CRC_DR_DR_Msk = 0xffffffff // Bit mask of DR field.

	// IDR: Independent data register
	CRC_IDR_IDR_Pos = 0x0  // Position of IDR field.
	CRC_IDR_IDR_Msk = 0xff // Bit mask of IDR field.

	// CR: Control register
	CRC_CR_REV_OUT_Pos  = 0x7  // Position of REV_OUT field.
	CRC_CR_REV_OUT_Msk  = 0x80 // Bit mask of REV_OUT field.
	CRC_CR_REV_OUT      = 0x80 // Bit REV_OUT.
	CRC_CR_REV_IN_Pos   = 0x5  // Position of REV_IN field.
	CRC_CR_REV_IN_Msk   = 0x60 // Bit mask of REV_IN field.
	CRC_CR_POLYSIZE_Pos = 0x3  // Position of POLYSIZE field.
	CRC_CR_POLYSIZE_Msk = 0x18 // Bit mask of POLYSIZE field.
	CRC_CR_RESET_Pos    = 0x0  // Position of RESET field.
	CRC_CR_RESET_Msk    = 0x1  // Bit mask of RESET field.
	CRC_CR_RESET        = 0x1  // Bit RESET.

	// INIT: Initial CRC value
	CRC_INIT_CRC_INIT_Pos = 0x0        // Position of CRC_INIT field.
	CRC_INIT_CRC_INIT_Msk = 0xffffffff // Bit mask of CRC_INIT field.

	// POL: polynomial
	CRC_POL_Polynomialcoefficients_Pos = 0x0        // Position of Polynomialcoefficients field.
	CRC_POL_Polynomialcoefficients_Msk = 0xffffffff // Bit mask of Polynomialcoefficients field.
)

// Bitfields for GPIOA: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	GPIO_MODER_MODE0_Pos  = 0x0        // Position of MODE0 field.
	GPIO_MODER_MODE0_Msk  = 0x3        // Bit mask of MODE0 field.
	GPIO_MODER_MODE1_Pos  = 0x2        // Position of MODE1 field.
	GPIO_MODER_MODE1_Msk  = 0xc        // Bit mask of MODE1 field.
	GPIO_MODER_MODE2_Pos  = 0x4        // Position of MODE2 field.
	GPIO_MODER_MODE2_Msk  = 0x30       // Bit mask of MODE2 field.
	GPIO_MODER_MODE3_Pos  = 0x6        // Position of MODE3 field.
	GPIO_MODER_MODE3_Msk  = 0xc0       // Bit mask of MODE3 field.
	GPIO_MODER_MODE4_Pos  = 0x8        // Position of MODE4 field.
	GPIO_MODER_MODE4_Msk  = 0x300      // Bit mask of MODE4 field.
	GPIO_MODER_MODE5_Pos  = 0xa        // Position of MODE5 field.
	GPIO_MODER_MODE5_Msk  = 0xc00      // Bit mask of MODE5 field.
	GPIO_MODER_MODE6_Pos  = 0xc        // Position of MODE6 field.
	GPIO_MODER_MODE6_Msk  = 0x3000     // Bit mask of MODE6 field.
	GPIO_MODER_MODE7_Pos  = 0xe        // Position of MODE7 field.
	GPIO_MODER_MODE7_Msk  = 0xc000     // Bit mask of MODE7 field.
	GPIO_MODER_MODE8_Pos  = 0x10       // Position of MODE8 field.
	GPIO_MODER_MODE8_Msk  = 0x30000    // Bit mask of MODE8 field.
	GPIO_MODER_MODE9_Pos  = 0x12       // Position of MODE9 field.
	GPIO_MODER_MODE9_Msk  = 0xc0000    // Bit mask of MODE9 field.
	GPIO_MODER_MODE10_Pos = 0x14       // Position of MODE10 field.
	GPIO_MODER_MODE10_Msk = 0x300000   // Bit mask of MODE10 field.
	GPIO_MODER_MODE11_Pos = 0x16       // Position of MODE11 field.
	GPIO_MODER_MODE11_Msk = 0xc00000   // Bit mask of MODE11 field.
	GPIO_MODER_MODE12_Pos = 0x18       // Position of MODE12 field.
	GPIO_MODER_MODE12_Msk = 0x3000000  // Bit mask of MODE12 field.
	GPIO_MODER_MODE13_Pos = 0x1a       // Position of MODE13 field.
	GPIO_MODER_MODE13_Msk = 0xc000000  // Bit mask of MODE13 field.
	GPIO_MODER_MODE14_Pos = 0x1c       // Position of MODE14 field.
	GPIO_MODER_MODE14_Msk = 0x30000000 // Bit mask of MODE14 field.
	GPIO_MODER_MODE15_Pos = 0x1e       // Position of MODE15 field.
	GPIO_MODER_MODE15_Msk = 0xc0000000 // Bit mask of MODE15 field.

	// OTYPER: GPIO port output type register
	GPIO_OTYPER_OT15_Pos = 0xf    // Position of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000 // Bit mask of OT15 field.
	GPIO_OTYPER_OT15     = 0x8000 // Bit OT15.
	GPIO_OTYPER_OT14_Pos = 0xe    // Position of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000 // Bit mask of OT14 field.
	GPIO_OTYPER_OT14     = 0x4000 // Bit OT14.
	GPIO_OTYPER_OT13_Pos = 0xd    // Position of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000 // Bit mask of OT13 field.
	GPIO_OTYPER_OT13     = 0x2000 // Bit OT13.
	GPIO_OTYPER_OT12_Pos = 0xc    // Position of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000 // Bit mask of OT12 field.
	GPIO_OTYPER_OT12     = 0x1000 // Bit OT12.
	GPIO_OTYPER_OT11_Pos = 0xb    // Position of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800  // Bit mask of OT11 field.
	GPIO_OTYPER_OT11     = 0x800  // Bit OT11.
	GPIO_OTYPER_OT10_Pos = 0xa    // Position of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400  // Bit mask of OT10 field.
	GPIO_OTYPER_OT10     = 0x400  // Bit OT10.
	GPIO_OTYPER_OT9_Pos  = 0x9    // Position of OT9 field.
	GPIO_OTYPER_OT9_Msk  = 0x200  // Bit mask of OT9 field.
	GPIO_OTYPER_OT9      = 0x200  // Bit OT9.
	GPIO_OTYPER_OT8_Pos  = 0x8    // Position of OT8 field.
	GPIO_OTYPER_OT8_Msk  = 0x100  // Bit mask of OT8 field.
	GPIO_OTYPER_OT8      = 0x100  // Bit OT8.
	GPIO_OTYPER_OT7_Pos  = 0x7    // Position of OT7 field.
	GPIO_OTYPER_OT7_Msk  = 0x80   // Bit mask of OT7 field.
	GPIO_OTYPER_OT7      = 0x80   // Bit OT7.
	GPIO_OTYPER_OT6_Pos  = 0x6    // Position of OT6 field.
	GPIO_OTYPER_OT6_Msk  = 0x40   // Bit mask of OT6 field.
	GPIO_OTYPER_OT6      = 0x40   // Bit OT6.
	GPIO_OTYPER_OT5_Pos  = 0x5    // Position of OT5 field.
	GPIO_OTYPER_OT5_Msk  = 0x20   // Bit mask of OT5 field.
	GPIO_OTYPER_OT5      = 0x20   // Bit OT5.
	GPIO_OTYPER_OT4_Pos  = 0x4    // Position of OT4 field.
	GPIO_OTYPER_OT4_Msk  = 0x10   // Bit mask of OT4 field.
	GPIO_OTYPER_OT4      = 0x10   // Bit OT4.
	GPIO_OTYPER_OT3_Pos  = 0x3    // Position of OT3 field.
	GPIO_OTYPER_OT3_Msk  = 0x8    // Bit mask of OT3 field.
	GPIO_OTYPER_OT3      = 0x8    // Bit OT3.
	GPIO_OTYPER_OT2_Pos  = 0x2    // Position of OT2 field.
	GPIO_OTYPER_OT2_Msk  = 0x4    // Bit mask of OT2 field.
	GPIO_OTYPER_OT2      = 0x4    // Bit OT2.
	GPIO_OTYPER_OT1_Pos  = 0x1    // Position of OT1 field.
	GPIO_OTYPER_OT1_Msk  = 0x2    // Bit mask of OT1 field.
	GPIO_OTYPER_OT1      = 0x2    // Bit OT1.
	GPIO_OTYPER_OT0_Pos  = 0x0    // Position of OT0 field.
	GPIO_OTYPER_OT0_Msk  = 0x1    // Bit mask of OT0 field.
	GPIO_OTYPER_OT0      = 0x1    // Bit OT0.

	// OSPEEDR: GPIO port output speed           register
	GPIO_OSPEEDR_OSPEED15_Pos = 0x1e       // Position of OSPEED15 field.
	GPIO_OSPEEDR_OSPEED15_Msk = 0xc0000000 // Bit mask of OSPEED15 field.
	GPIO_OSPEEDR_OSPEED14_Pos = 0x1c       // Position of OSPEED14 field.
	GPIO_OSPEEDR_OSPEED14_Msk = 0x30000000 // Bit mask of OSPEED14 field.
	GPIO_OSPEEDR_OSPEED13_Pos = 0x1a       // Position of OSPEED13 field.
	GPIO_OSPEEDR_OSPEED13_Msk = 0xc000000  // Bit mask of OSPEED13 field.
	GPIO_OSPEEDR_OSPEED12_Pos = 0x18       // Position of OSPEED12 field.
	GPIO_OSPEEDR_OSPEED12_Msk = 0x3000000  // Bit mask of OSPEED12 field.
	GPIO_OSPEEDR_OSPEED11_Pos = 0x16       // Position of OSPEED11 field.
	GPIO_OSPEEDR_OSPEED11_Msk = 0xc00000   // Bit mask of OSPEED11 field.
	GPIO_OSPEEDR_OSPEED10_Pos = 0x14       // Position of OSPEED10 field.
	GPIO_OSPEEDR_OSPEED10_Msk = 0x300000   // Bit mask of OSPEED10 field.
	GPIO_OSPEEDR_OSPEED9_Pos  = 0x12       // Position of OSPEED9 field.
	GPIO_OSPEEDR_OSPEED9_Msk  = 0xc0000    // Bit mask of OSPEED9 field.
	GPIO_OSPEEDR_OSPEED8_Pos  = 0x10       // Position of OSPEED8 field.
	GPIO_OSPEEDR_OSPEED8_Msk  = 0x30000    // Bit mask of OSPEED8 field.
	GPIO_OSPEEDR_OSPEED7_Pos  = 0xe        // Position of OSPEED7 field.
	GPIO_OSPEEDR_OSPEED7_Msk  = 0xc000     // Bit mask of OSPEED7 field.
	GPIO_OSPEEDR_OSPEED6_Pos  = 0xc        // Position of OSPEED6 field.
	GPIO_OSPEEDR_OSPEED6_Msk  = 0x3000     // Bit mask of OSPEED6 field.
	GPIO_OSPEEDR_OSPEED5_Pos  = 0xa        // Position of OSPEED5 field.
	GPIO_OSPEEDR_OSPEED5_Msk  = 0xc00      // Bit mask of OSPEED5 field.
	GPIO_OSPEEDR_OSPEED4_Pos  = 0x8        // Position of OSPEED4 field.
	GPIO_OSPEEDR_OSPEED4_Msk  = 0x300      // Bit mask of OSPEED4 field.
	GPIO_OSPEEDR_OSPEED3_Pos  = 0x6        // Position of OSPEED3 field.
	GPIO_OSPEEDR_OSPEED3_Msk  = 0xc0       // Bit mask of OSPEED3 field.
	GPIO_OSPEEDR_OSPEED2_Pos  = 0x4        // Position of OSPEED2 field.
	GPIO_OSPEEDR_OSPEED2_Msk  = 0x30       // Bit mask of OSPEED2 field.
	GPIO_OSPEEDR_OSPEED1_Pos  = 0x2        // Position of OSPEED1 field.
	GPIO_OSPEEDR_OSPEED1_Msk  = 0xc        // Bit mask of OSPEED1 field.
	GPIO_OSPEEDR_OSPEED0_Pos  = 0x0        // Position of OSPEED0 field.
	GPIO_OSPEEDR_OSPEED0_Msk  = 0x3        // Bit mask of OSPEED0 field.

	// PUPDR: GPIO port pull-up/pull-down           register
	GPIO_PUPDR_PUPD15_Pos = 0x1e       // Position of PUPD15 field.
	GPIO_PUPDR_PUPD15_Msk = 0xc0000000 // Bit mask of PUPD15 field.
	GPIO_PUPDR_PUPD14_Pos = 0x1c       // Position of PUPD14 field.
	GPIO_PUPDR_PUPD14_Msk = 0x30000000 // Bit mask of PUPD14 field.
	GPIO_PUPDR_PUPD13_Pos = 0x1a       // Position of PUPD13 field.
	GPIO_PUPDR_PUPD13_Msk = 0xc000000  // Bit mask of PUPD13 field.
	GPIO_PUPDR_PUPD12_Pos = 0x18       // Position of PUPD12 field.
	GPIO_PUPDR_PUPD12_Msk = 0x3000000  // Bit mask of PUPD12 field.
	GPIO_PUPDR_PUPD11_Pos = 0x16       // Position of PUPD11 field.
	GPIO_PUPDR_PUPD11_Msk = 0xc00000   // Bit mask of PUPD11 field.
	GPIO_PUPDR_PUPD10_Pos = 0x14       // Position of PUPD10 field.
	GPIO_PUPDR_PUPD10_Msk = 0x300000   // Bit mask of PUPD10 field.
	GPIO_PUPDR_PUPD9_Pos  = 0x12       // Position of PUPD9 field.
	GPIO_PUPDR_PUPD9_Msk  = 0xc0000    // Bit mask of PUPD9 field.
	GPIO_PUPDR_PUPD8_Pos  = 0x10       // Position of PUPD8 field.
	GPIO_PUPDR_PUPD8_Msk  = 0x30000    // Bit mask of PUPD8 field.
	GPIO_PUPDR_PUPD7_Pos  = 0xe        // Position of PUPD7 field.
	GPIO_PUPDR_PUPD7_Msk  = 0xc000     // Bit mask of PUPD7 field.
	GPIO_PUPDR_PUPD6_Pos  = 0xc        // Position of PUPD6 field.
	GPIO_PUPDR_PUPD6_Msk  = 0x3000     // Bit mask of PUPD6 field.
	GPIO_PUPDR_PUPD5_Pos  = 0xa        // Position of PUPD5 field.
	GPIO_PUPDR_PUPD5_Msk  = 0xc00      // Bit mask of PUPD5 field.
	GPIO_PUPDR_PUPD4_Pos  = 0x8        // Position of PUPD4 field.
	GPIO_PUPDR_PUPD4_Msk  = 0x300      // Bit mask of PUPD4 field.
	GPIO_PUPDR_PUPD3_Pos  = 0x6        // Position of PUPD3 field.
	GPIO_PUPDR_PUPD3_Msk  = 0xc0       // Bit mask of PUPD3 field.
	GPIO_PUPDR_PUPD2_Pos  = 0x4        // Position of PUPD2 field.
	GPIO_PUPDR_PUPD2_Msk  = 0x30       // Bit mask of PUPD2 field.
	GPIO_PUPDR_PUPD1_Pos  = 0x2        // Position of PUPD1 field.
	GPIO_PUPDR_PUPD1_Msk  = 0xc        // Bit mask of PUPD1 field.
	GPIO_PUPDR_PUPD0_Pos  = 0x0        // Position of PUPD0 field.
	GPIO_PUPDR_PUPD0_Msk  = 0x3        // Bit mask of PUPD0 field.

	// IDR: GPIO port input data register
	GPIO_IDR_ID15_Pos = 0xf    // Position of ID15 field.
	GPIO_IDR_ID15_Msk = 0x8000 // Bit mask of ID15 field.
	GPIO_IDR_ID15     = 0x8000 // Bit ID15.
	GPIO_IDR_ID14_Pos = 0xe    // Position of ID14 field.
	GPIO_IDR_ID14_Msk = 0x4000 // Bit mask of ID14 field.
	GPIO_IDR_ID14     = 0x4000 // Bit ID14.
	GPIO_IDR_ID13_Pos = 0xd    // Position of ID13 field.
	GPIO_IDR_ID13_Msk = 0x2000 // Bit mask of ID13 field.
	GPIO_IDR_ID13     = 0x2000 // Bit ID13.
	GPIO_IDR_ID12_Pos = 0xc    // Position of ID12 field.
	GPIO_IDR_ID12_Msk = 0x1000 // Bit mask of ID12 field.
	GPIO_IDR_ID12     = 0x1000 // Bit ID12.
	GPIO_IDR_ID11_Pos = 0xb    // Position of ID11 field.
	GPIO_IDR_ID11_Msk = 0x800  // Bit mask of ID11 field.
	GPIO_IDR_ID11     = 0x800  // Bit ID11.
	GPIO_IDR_ID10_Pos = 0xa    // Position of ID10 field.
	GPIO_IDR_ID10_Msk = 0x400  // Bit mask of ID10 field.
	GPIO_IDR_ID10     = 0x400  // Bit ID10.
	GPIO_IDR_ID9_Pos  = 0x9    // Position of ID9 field.
	GPIO_IDR_ID9_Msk  = 0x200  // Bit mask of ID9 field.
	GPIO_IDR_ID9      = 0x200  // Bit ID9.
	GPIO_IDR_ID8_Pos  = 0x8    // Position of ID8 field.
	GPIO_IDR_ID8_Msk  = 0x100  // Bit mask of ID8 field.
	GPIO_IDR_ID8      = 0x100  // Bit ID8.
	GPIO_IDR_ID7_Pos  = 0x7    // Position of ID7 field.
	GPIO_IDR_ID7_Msk  = 0x80   // Bit mask of ID7 field.
	GPIO_IDR_ID7      = 0x80   // Bit ID7.
	GPIO_IDR_ID6_Pos  = 0x6    // Position of ID6 field.
	GPIO_IDR_ID6_Msk  = 0x40   // Bit mask of ID6 field.
	GPIO_IDR_ID6      = 0x40   // Bit ID6.
	GPIO_IDR_ID5_Pos  = 0x5    // Position of ID5 field.
	GPIO_IDR_ID5_Msk  = 0x20   // Bit mask of ID5 field.
	GPIO_IDR_ID5      = 0x20   // Bit ID5.
	GPIO_IDR_ID4_Pos  = 0x4    // Position of ID4 field.
	GPIO_IDR_ID4_Msk  = 0x10   // Bit mask of ID4 field.
	GPIO_IDR_ID4      = 0x10   // Bit ID4.
	GPIO_IDR_ID3_Pos  = 0x3    // Position of ID3 field.
	GPIO_IDR_ID3_Msk  = 0x8    // Bit mask of ID3 field.
	GPIO_IDR_ID3      = 0x8    // Bit ID3.
	GPIO_IDR_ID2_Pos  = 0x2    // Position of ID2 field.
	GPIO_IDR_ID2_Msk  = 0x4    // Bit mask of ID2 field.
	GPIO_IDR_ID2      = 0x4    // Bit ID2.
	GPIO_IDR_ID1_Pos  = 0x1    // Position of ID1 field.
	GPIO_IDR_ID1_Msk  = 0x2    // Bit mask of ID1 field.
	GPIO_IDR_ID1      = 0x2    // Bit ID1.
	GPIO_IDR_ID0_Pos  = 0x0    // Position of ID0 field.
	GPIO_IDR_ID0_Msk  = 0x1    // Bit mask of ID0 field.
	GPIO_IDR_ID0      = 0x1    // Bit ID0.

	// ODR: GPIO port output data register
	GPIO_ODR_OD15_Pos = 0xf    // Position of OD15 field.
	GPIO_ODR_OD15_Msk = 0x8000 // Bit mask of OD15 field.
	GPIO_ODR_OD15     = 0x8000 // Bit OD15.
	GPIO_ODR_OD14_Pos = 0xe    // Position of OD14 field.
	GPIO_ODR_OD14_Msk = 0x4000 // Bit mask of OD14 field.
	GPIO_ODR_OD14     = 0x4000 // Bit OD14.
	GPIO_ODR_OD13_Pos = 0xd    // Position of OD13 field.
	GPIO_ODR_OD13_Msk = 0x2000 // Bit mask of OD13 field.
	GPIO_ODR_OD13     = 0x2000 // Bit OD13.
	GPIO_ODR_OD12_Pos = 0xc    // Position of OD12 field.
	GPIO_ODR_OD12_Msk = 0x1000 // Bit mask of OD12 field.
	GPIO_ODR_OD12     = 0x1000 // Bit OD12.
	GPIO_ODR_OD11_Pos = 0xb    // Position of OD11 field.
	GPIO_ODR_OD11_Msk = 0x800  // Bit mask of OD11 field.
	GPIO_ODR_OD11     = 0x800  // Bit OD11.
	GPIO_ODR_OD10_Pos = 0xa    // Position of OD10 field.
	GPIO_ODR_OD10_Msk = 0x400  // Bit mask of OD10 field.
	GPIO_ODR_OD10     = 0x400  // Bit OD10.
	GPIO_ODR_OD9_Pos  = 0x9    // Position of OD9 field.
	GPIO_ODR_OD9_Msk  = 0x200  // Bit mask of OD9 field.
	GPIO_ODR_OD9      = 0x200  // Bit OD9.
	GPIO_ODR_OD8_Pos  = 0x8    // Position of OD8 field.
	GPIO_ODR_OD8_Msk  = 0x100  // Bit mask of OD8 field.
	GPIO_ODR_OD8      = 0x100  // Bit OD8.
	GPIO_ODR_OD7_Pos  = 0x7    // Position of OD7 field.
	GPIO_ODR_OD7_Msk  = 0x80   // Bit mask of OD7 field.
	GPIO_ODR_OD7      = 0x80   // Bit OD7.
	GPIO_ODR_OD6_Pos  = 0x6    // Position of OD6 field.
	GPIO_ODR_OD6_Msk  = 0x40   // Bit mask of OD6 field.
	GPIO_ODR_OD6      = 0x40   // Bit OD6.
	GPIO_ODR_OD5_Pos  = 0x5    // Position of OD5 field.
	GPIO_ODR_OD5_Msk  = 0x20   // Bit mask of OD5 field.
	GPIO_ODR_OD5      = 0x20   // Bit OD5.
	GPIO_ODR_OD4_Pos  = 0x4    // Position of OD4 field.
	GPIO_ODR_OD4_Msk  = 0x10   // Bit mask of OD4 field.
	GPIO_ODR_OD4      = 0x10   // Bit OD4.
	GPIO_ODR_OD3_Pos  = 0x3    // Position of OD3 field.
	GPIO_ODR_OD3_Msk  = 0x8    // Bit mask of OD3 field.
	GPIO_ODR_OD3      = 0x8    // Bit OD3.
	GPIO_ODR_OD2_Pos  = 0x2    // Position of OD2 field.
	GPIO_ODR_OD2_Msk  = 0x4    // Bit mask of OD2 field.
	GPIO_ODR_OD2      = 0x4    // Bit OD2.
	GPIO_ODR_OD1_Pos  = 0x1    // Position of OD1 field.
	GPIO_ODR_OD1_Msk  = 0x2    // Bit mask of OD1 field.
	GPIO_ODR_OD1      = 0x2    // Bit OD1.
	GPIO_ODR_OD0_Pos  = 0x0    // Position of OD0 field.
	GPIO_ODR_OD0_Msk  = 0x1    // Bit mask of OD0 field.
	GPIO_ODR_OD0      = 0x1    // Bit OD0.

	// BSRR: GPIO port bit set/reset           register
	GPIO_BSRR_BR15_Pos = 0x1f       // Position of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000 // Bit mask of BR15 field.
	GPIO_BSRR_BR15     = 0x80000000 // Bit BR15.
	GPIO_BSRR_BR14_Pos = 0x1e       // Position of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000 // Bit mask of BR14 field.
	GPIO_BSRR_BR14     = 0x40000000 // Bit BR14.
	GPIO_BSRR_BR13_Pos = 0x1d       // Position of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000 // Bit mask of BR13 field.
	GPIO_BSRR_BR13     = 0x20000000 // Bit BR13.
	GPIO_BSRR_BR12_Pos = 0x1c       // Position of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000 // Bit mask of BR12 field.
	GPIO_BSRR_BR12     = 0x10000000 // Bit BR12.
	GPIO_BSRR_BR11_Pos = 0x1b       // Position of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000  // Bit mask of BR11 field.
	GPIO_BSRR_BR11     = 0x8000000  // Bit BR11.
	GPIO_BSRR_BR10_Pos = 0x1a       // Position of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000  // Bit mask of BR10 field.
	GPIO_BSRR_BR10     = 0x4000000  // Bit BR10.
	GPIO_BSRR_BR9_Pos  = 0x19       // Position of BR9 field.
	GPIO_BSRR_BR9_Msk  = 0x2000000  // Bit mask of BR9 field.
	GPIO_BSRR_BR9      = 0x2000000  // Bit BR9.
	GPIO_BSRR_BR8_Pos  = 0x18       // Position of BR8 field.
	GPIO_BSRR_BR8_Msk  = 0x1000000  // Bit mask of BR8 field.
	GPIO_BSRR_BR8      = 0x1000000  // Bit BR8.
	GPIO_BSRR_BR7_Pos  = 0x17       // Position of BR7 field.
	GPIO_BSRR_BR7_Msk  = 0x800000   // Bit mask of BR7 field.
	GPIO_BSRR_BR7      = 0x800000   // Bit BR7.
	GPIO_BSRR_BR6_Pos  = 0x16       // Position of BR6 field.
	GPIO_BSRR_BR6_Msk  = 0x400000   // Bit mask of BR6 field.
	GPIO_BSRR_BR6      = 0x400000   // Bit BR6.
	GPIO_BSRR_BR5_Pos  = 0x15       // Position of BR5 field.
	GPIO_BSRR_BR5_Msk  = 0x200000   // Bit mask of BR5 field.
	GPIO_BSRR_BR5      = 0x200000   // Bit BR5.
	GPIO_BSRR_BR4_Pos  = 0x14       // Position of BR4 field.
	GPIO_BSRR_BR4_Msk  = 0x100000   // Bit mask of BR4 field.
	GPIO_BSRR_BR4      = 0x100000   // Bit BR4.
	GPIO_BSRR_BR3_Pos  = 0x13       // Position of BR3 field.
	GPIO_BSRR_BR3_Msk  = 0x80000    // Bit mask of BR3 field.
	GPIO_BSRR_BR3      = 0x80000    // Bit BR3.
	GPIO_BSRR_BR2_Pos  = 0x12       // Position of BR2 field.
	GPIO_BSRR_BR2_Msk  = 0x40000    // Bit mask of BR2 field.
	GPIO_BSRR_BR2      = 0x40000    // Bit BR2.
	GPIO_BSRR_BR1_Pos  = 0x11       // Position of BR1 field.
	GPIO_BSRR_BR1_Msk  = 0x20000    // Bit mask of BR1 field.
	GPIO_BSRR_BR1      = 0x20000    // Bit BR1.
	GPIO_BSRR_BR0_Pos  = 0x10       // Position of BR0 field.
	GPIO_BSRR_BR0_Msk  = 0x10000    // Bit mask of BR0 field.
	GPIO_BSRR_BR0      = 0x10000    // Bit BR0.
	GPIO_BSRR_BS15_Pos = 0xf        // Position of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000     // Bit mask of BS15 field.
	GPIO_BSRR_BS15     = 0x8000     // Bit BS15.
	GPIO_BSRR_BS14_Pos = 0xe        // Position of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000     // Bit mask of BS14 field.
	GPIO_BSRR_BS14     = 0x4000     // Bit BS14.
	GPIO_BSRR_BS13_Pos = 0xd        // Position of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000     // Bit mask of BS13 field.
	GPIO_BSRR_BS13     = 0x2000     // Bit BS13.
	GPIO_BSRR_BS12_Pos = 0xc        // Position of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000     // Bit mask of BS12 field.
	GPIO_BSRR_BS12     = 0x1000     // Bit BS12.
	GPIO_BSRR_BS11_Pos = 0xb        // Position of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800      // Bit mask of BS11 field.
	GPIO_BSRR_BS11     = 0x800      // Bit BS11.
	GPIO_BSRR_BS10_Pos = 0xa        // Position of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400      // Bit mask of BS10 field.
	GPIO_BSRR_BS10     = 0x400      // Bit BS10.
	GPIO_BSRR_BS9_Pos  = 0x9        // Position of BS9 field.
	GPIO_BSRR_BS9_Msk  = 0x200      // Bit mask of BS9 field.
	GPIO_BSRR_BS9      = 0x200      // Bit BS9.
	GPIO_BSRR_BS8_Pos  = 0x8        // Position of BS8 field.
	GPIO_BSRR_BS8_Msk  = 0x100      // Bit mask of BS8 field.
	GPIO_BSRR_BS8      = 0x100      // Bit BS8.
	GPIO_BSRR_BS7_Pos  = 0x7        // Position of BS7 field.
	GPIO_BSRR_BS7_Msk  = 0x80       // Bit mask of BS7 field.
	GPIO_BSRR_BS7      = 0x80       // Bit BS7.
	GPIO_BSRR_BS6_Pos  = 0x6        // Position of BS6 field.
	GPIO_BSRR_BS6_Msk  = 0x40       // Bit mask of BS6 field.
	GPIO_BSRR_BS6      = 0x40       // Bit BS6.
	GPIO_BSRR_BS5_Pos  = 0x5        // Position of BS5 field.
	GPIO_BSRR_BS5_Msk  = 0x20       // Bit mask of BS5 field.
	GPIO_BSRR_BS5      = 0x20       // Bit BS5.
	GPIO_BSRR_BS4_Pos  = 0x4        // Position of BS4 field.
	GPIO_BSRR_BS4_Msk  = 0x10       // Bit mask of BS4 field.
	GPIO_BSRR_BS4      = 0x10       // Bit BS4.
	GPIO_BSRR_BS3_Pos  = 0x3        // Position of BS3 field.
	GPIO_BSRR_BS3_Msk  = 0x8        // Bit mask of BS3 field.
	GPIO_BSRR_BS3      = 0x8        // Bit BS3.
	GPIO_BSRR_BS2_Pos  = 0x2        // Position of BS2 field.
	GPIO_BSRR_BS2_Msk  = 0x4        // Bit mask of BS2 field.
	GPIO_BSRR_BS2      = 0x4        // Bit BS2.
	GPIO_BSRR_BS1_Pos  = 0x1        // Position of BS1 field.
	GPIO_BSRR_BS1_Msk  = 0x2        // Bit mask of BS1 field.
	GPIO_BSRR_BS1      = 0x2        // Bit BS1.
	GPIO_BSRR_BS0_Pos  = 0x0        // Position of BS0 field.
	GPIO_BSRR_BS0_Msk  = 0x1        // Bit mask of BS0 field.
	GPIO_BSRR_BS0      = 0x1        // Bit BS0.

	// LCKR: GPIO port configuration lock           register
	GPIO_LCKR_LCKK_Pos  = 0x10    // Position of LCKK field.
	GPIO_LCKR_LCKK_Msk  = 0x10000 // Bit mask of LCKK field.
	GPIO_LCKR_LCKK      = 0x10000 // Bit LCKK.
	GPIO_LCKR_LCK15_Pos = 0xf     // Position of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000  // Bit mask of LCK15 field.
	GPIO_LCKR_LCK15     = 0x8000  // Bit LCK15.
	GPIO_LCKR_LCK14_Pos = 0xe     // Position of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000  // Bit mask of LCK14 field.
	GPIO_LCKR_LCK14     = 0x4000  // Bit LCK14.
	GPIO_LCKR_LCK13_Pos = 0xd     // Position of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000  // Bit mask of LCK13 field.
	GPIO_LCKR_LCK13     = 0x2000  // Bit LCK13.
	GPIO_LCKR_LCK12_Pos = 0xc     // Position of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000  // Bit mask of LCK12 field.
	GPIO_LCKR_LCK12     = 0x1000  // Bit LCK12.
	GPIO_LCKR_LCK11_Pos = 0xb     // Position of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800   // Bit mask of LCK11 field.
	GPIO_LCKR_LCK11     = 0x800   // Bit LCK11.
	GPIO_LCKR_LCK10_Pos = 0xa     // Position of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400   // Bit mask of LCK10 field.
	GPIO_LCKR_LCK10     = 0x400   // Bit LCK10.
	GPIO_LCKR_LCK9_Pos  = 0x9     // Position of LCK9 field.
	GPIO_LCKR_LCK9_Msk  = 0x200   // Bit mask of LCK9 field.
	GPIO_LCKR_LCK9      = 0x200   // Bit LCK9.
	GPIO_LCKR_LCK8_Pos  = 0x8     // Position of LCK8 field.
	GPIO_LCKR_LCK8_Msk  = 0x100   // Bit mask of LCK8 field.
	GPIO_LCKR_LCK8      = 0x100   // Bit LCK8.
	GPIO_LCKR_LCK7_Pos  = 0x7     // Position of LCK7 field.
	GPIO_LCKR_LCK7_Msk  = 0x80    // Bit mask of LCK7 field.
	GPIO_LCKR_LCK7      = 0x80    // Bit LCK7.
	GPIO_LCKR_LCK6_Pos  = 0x6     // Position of LCK6 field.
	GPIO_LCKR_LCK6_Msk  = 0x40    // Bit mask of LCK6 field.
	GPIO_LCKR_LCK6      = 0x40    // Bit LCK6.
	GPIO_LCKR_LCK5_Pos  = 0x5     // Position of LCK5 field.
	GPIO_LCKR_LCK5_Msk  = 0x20    // Bit mask of LCK5 field.
	GPIO_LCKR_LCK5      = 0x20    // Bit LCK5.
	GPIO_LCKR_LCK4_Pos  = 0x4     // Position of LCK4 field.
	GPIO_LCKR_LCK4_Msk  = 0x10    // Bit mask of LCK4 field.
	GPIO_LCKR_LCK4      = 0x10    // Bit LCK4.
	GPIO_LCKR_LCK3_Pos  = 0x3     // Position of LCK3 field.
	GPIO_LCKR_LCK3_Msk  = 0x8     // Bit mask of LCK3 field.
	GPIO_LCKR_LCK3      = 0x8     // Bit LCK3.
	GPIO_LCKR_LCK2_Pos  = 0x2     // Position of LCK2 field.
	GPIO_LCKR_LCK2_Msk  = 0x4     // Bit mask of LCK2 field.
	GPIO_LCKR_LCK2      = 0x4     // Bit LCK2.
	GPIO_LCKR_LCK1_Pos  = 0x1     // Position of LCK1 field.
	GPIO_LCKR_LCK1_Msk  = 0x2     // Bit mask of LCK1 field.
	GPIO_LCKR_LCK1      = 0x2     // Bit LCK1.
	GPIO_LCKR_LCK0_Pos  = 0x0     // Position of LCK0 field.
	GPIO_LCKR_LCK0_Msk  = 0x1     // Bit mask of LCK0 field.
	GPIO_LCKR_LCK0      = 0x1     // Bit LCK0.

	// AFRL: GPIO alternate function low           register
	GPIO_AFRL_AFSEL7_Pos = 0x1c       // Position of AFSEL7 field.
	GPIO_AFRL_AFSEL7_Msk = 0xf0000000 // Bit mask of AFSEL7 field.
	GPIO_AFRL_AFSEL6_Pos = 0x18       // Position of AFSEL6 field.
	GPIO_AFRL_AFSEL6_Msk = 0xf000000  // Bit mask of AFSEL6 field.
	GPIO_AFRL_AFSEL5_Pos = 0x14       // Position of AFSEL5 field.
	GPIO_AFRL_AFSEL5_Msk = 0xf00000   // Bit mask of AFSEL5 field.
	GPIO_AFRL_AFSEL4_Pos = 0x10       // Position of AFSEL4 field.
	GPIO_AFRL_AFSEL4_Msk = 0xf0000    // Bit mask of AFSEL4 field.
	GPIO_AFRL_AFSEL3_Pos = 0xc        // Position of AFSEL3 field.
	GPIO_AFRL_AFSEL3_Msk = 0xf000     // Bit mask of AFSEL3 field.
	GPIO_AFRL_AFSEL2_Pos = 0x8        // Position of AFSEL2 field.
	GPIO_AFRL_AFSEL2_Msk = 0xf00      // Bit mask of AFSEL2 field.
	GPIO_AFRL_AFSEL1_Pos = 0x4        // Position of AFSEL1 field.
	GPIO_AFRL_AFSEL1_Msk = 0xf0       // Bit mask of AFSEL1 field.
	GPIO_AFRL_AFSEL0_Pos = 0x0        // Position of AFSEL0 field.
	GPIO_AFRL_AFSEL0_Msk = 0xf        // Bit mask of AFSEL0 field.

	// AFRH: GPIO alternate function high           register
	GPIO_AFRH_AFSEL15_Pos = 0x1c       // Position of AFSEL15 field.
	GPIO_AFRH_AFSEL15_Msk = 0xf0000000 // Bit mask of AFSEL15 field.
	GPIO_AFRH_AFSEL14_Pos = 0x18       // Position of AFSEL14 field.
	GPIO_AFRH_AFSEL14_Msk = 0xf000000  // Bit mask of AFSEL14 field.
	GPIO_AFRH_AFSEL13_Pos = 0x14       // Position of AFSEL13 field.
	GPIO_AFRH_AFSEL13_Msk = 0xf00000   // Bit mask of AFSEL13 field.
	GPIO_AFRH_AFSEL12_Pos = 0x10       // Position of AFSEL12 field.
	GPIO_AFRH_AFSEL12_Msk = 0xf0000    // Bit mask of AFSEL12 field.
	GPIO_AFRH_AFSEL11_Pos = 0xc        // Position of AFSEL11 field.
	GPIO_AFRH_AFSEL11_Msk = 0xf000     // Bit mask of AFSEL11 field.
	GPIO_AFRH_AFSEL10_Pos = 0x8        // Position of AFSEL10 field.
	GPIO_AFRH_AFSEL10_Msk = 0xf00      // Bit mask of AFSEL10 field.
	GPIO_AFRH_AFSEL9_Pos  = 0x4        // Position of AFSEL9 field.
	GPIO_AFRH_AFSEL9_Msk  = 0xf0       // Bit mask of AFSEL9 field.
	GPIO_AFRH_AFSEL8_Pos  = 0x0        // Position of AFSEL8 field.
	GPIO_AFRH_AFSEL8_Msk  = 0xf        // Bit mask of AFSEL8 field.

	// BRR: GPIO port bit reset register
	GPIO_BRR_BR15_Pos = 0xf    // Position of BR15 field.
	GPIO_BRR_BR15_Msk = 0x8000 // Bit mask of BR15 field.
	GPIO_BRR_BR15     = 0x8000 // Bit BR15.
	GPIO_BRR_BR14_Pos = 0xe    // Position of BR14 field.
	GPIO_BRR_BR14_Msk = 0x4000 // Bit mask of BR14 field.
	GPIO_BRR_BR14     = 0x4000 // Bit BR14.
	GPIO_BRR_BR13_Pos = 0xd    // Position of BR13 field.
	GPIO_BRR_BR13_Msk = 0x2000 // Bit mask of BR13 field.
	GPIO_BRR_BR13     = 0x2000 // Bit BR13.
	GPIO_BRR_BR12_Pos = 0xc    // Position of BR12 field.
	GPIO_BRR_BR12_Msk = 0x1000 // Bit mask of BR12 field.
	GPIO_BRR_BR12     = 0x1000 // Bit BR12.
	GPIO_BRR_BR11_Pos = 0xb    // Position of BR11 field.
	GPIO_BRR_BR11_Msk = 0x800  // Bit mask of BR11 field.
	GPIO_BRR_BR11     = 0x800  // Bit BR11.
	GPIO_BRR_BR10_Pos = 0xa    // Position of BR10 field.
	GPIO_BRR_BR10_Msk = 0x400  // Bit mask of BR10 field.
	GPIO_BRR_BR10     = 0x400  // Bit BR10.
	GPIO_BRR_BR9_Pos  = 0x9    // Position of BR9 field.
	GPIO_BRR_BR9_Msk  = 0x200  // Bit mask of BR9 field.
	GPIO_BRR_BR9      = 0x200  // Bit BR9.
	GPIO_BRR_BR8_Pos  = 0x8    // Position of BR8 field.
	GPIO_BRR_BR8_Msk  = 0x100  // Bit mask of BR8 field.
	GPIO_BRR_BR8      = 0x100  // Bit BR8.
	GPIO_BRR_BR7_Pos  = 0x7    // Position of BR7 field.
	GPIO_BRR_BR7_Msk  = 0x80   // Bit mask of BR7 field.
	GPIO_BRR_BR7      = 0x80   // Bit BR7.
	GPIO_BRR_BR6_Pos  = 0x6    // Position of BR6 field.
	GPIO_BRR_BR6_Msk  = 0x40   // Bit mask of BR6 field.
	GPIO_BRR_BR6      = 0x40   // Bit BR6.
	GPIO_BRR_BR5_Pos  = 0x5    // Position of BR5 field.
	GPIO_BRR_BR5_Msk  = 0x20   // Bit mask of BR5 field.
	GPIO_BRR_BR5      = 0x20   // Bit BR5.
	GPIO_BRR_BR4_Pos  = 0x4    // Position of BR4 field.
	GPIO_BRR_BR4_Msk  = 0x10   // Bit mask of BR4 field.
	GPIO_BRR_BR4      = 0x10   // Bit BR4.
	GPIO_BRR_BR3_Pos  = 0x3    // Position of BR3 field.
	GPIO_BRR_BR3_Msk  = 0x8    // Bit mask of BR3 field.
	GPIO_BRR_BR3      = 0x8    // Bit BR3.
	GPIO_BRR_BR2_Pos  = 0x2    // Position of BR2 field.
	GPIO_BRR_BR2_Msk  = 0x4    // Bit mask of BR2 field.
	GPIO_BRR_BR2      = 0x4    // Bit BR2.
	GPIO_BRR_BR1_Pos  = 0x1    // Position of BR1 field.
	GPIO_BRR_BR1_Msk  = 0x2    // Bit mask of BR1 field.
	GPIO_BRR_BR1      = 0x2    // Bit BR1.
	GPIO_BRR_BR0_Pos  = 0x0    // Position of BR0 field.
	GPIO_BRR_BR0_Msk  = 0x1    // Bit mask of BR0 field.
	GPIO_BRR_BR0      = 0x1    // Bit BR0.
)

// Bitfields for LPTIM: Low power timer
const (
	// ISR: Interrupt and Status Register
	LPTIM_ISR_DOWN_Pos    = 0x6  // Position of DOWN field.
	LPTIM_ISR_DOWN_Msk    = 0x40 // Bit mask of DOWN field.
	LPTIM_ISR_DOWN        = 0x40 // Bit DOWN.
	LPTIM_ISR_UP_Pos      = 0x5  // Position of UP field.
	LPTIM_ISR_UP_Msk      = 0x20 // Bit mask of UP field.
	LPTIM_ISR_UP          = 0x20 // Bit UP.
	LPTIM_ISR_ARROK_Pos   = 0x4  // Position of ARROK field.
	LPTIM_ISR_ARROK_Msk   = 0x10 // Bit mask of ARROK field.
	LPTIM_ISR_ARROK       = 0x10 // Bit ARROK.
	LPTIM_ISR_CMPOK_Pos   = 0x3  // Position of CMPOK field.
	LPTIM_ISR_CMPOK_Msk   = 0x8  // Bit mask of CMPOK field.
	LPTIM_ISR_CMPOK       = 0x8  // Bit CMPOK.
	LPTIM_ISR_EXTTRIG_Pos = 0x2  // Position of EXTTRIG field.
	LPTIM_ISR_EXTTRIG_Msk = 0x4  // Bit mask of EXTTRIG field.
	LPTIM_ISR_EXTTRIG     = 0x4  // Bit EXTTRIG.
	LPTIM_ISR_ARRM_Pos    = 0x1  // Position of ARRM field.
	LPTIM_ISR_ARRM_Msk    = 0x2  // Bit mask of ARRM field.
	LPTIM_ISR_ARRM        = 0x2  // Bit ARRM.
	LPTIM_ISR_CMPM_Pos    = 0x0  // Position of CMPM field.
	LPTIM_ISR_CMPM_Msk    = 0x1  // Bit mask of CMPM field.
	LPTIM_ISR_CMPM        = 0x1  // Bit CMPM.

	// ICR: Interrupt Clear Register
	LPTIM_ICR_DOWNCF_Pos    = 0x6  // Position of DOWNCF field.
	LPTIM_ICR_DOWNCF_Msk    = 0x40 // Bit mask of DOWNCF field.
	LPTIM_ICR_DOWNCF        = 0x40 // Bit DOWNCF.
	LPTIM_ICR_UPCF_Pos      = 0x5  // Position of UPCF field.
	LPTIM_ICR_UPCF_Msk      = 0x20 // Bit mask of UPCF field.
	LPTIM_ICR_UPCF          = 0x20 // Bit UPCF.
	LPTIM_ICR_ARROKCF_Pos   = 0x4  // Position of ARROKCF field.
	LPTIM_ICR_ARROKCF_Msk   = 0x10 // Bit mask of ARROKCF field.
	LPTIM_ICR_ARROKCF       = 0x10 // Bit ARROKCF.
	LPTIM_ICR_CMPOKCF_Pos   = 0x3  // Position of CMPOKCF field.
	LPTIM_ICR_CMPOKCF_Msk   = 0x8  // Bit mask of CMPOKCF field.
	LPTIM_ICR_CMPOKCF       = 0x8  // Bit CMPOKCF.
	LPTIM_ICR_EXTTRIGCF_Pos = 0x2  // Position of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF_Msk = 0x4  // Bit mask of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF     = 0x4  // Bit EXTTRIGCF.
	LPTIM_ICR_ARRMCF_Pos    = 0x1  // Position of ARRMCF field.
	LPTIM_ICR_ARRMCF_Msk    = 0x2  // Bit mask of ARRMCF field.
	LPTIM_ICR_ARRMCF        = 0x2  // Bit ARRMCF.
	LPTIM_ICR_CMPMCF_Pos    = 0x0  // Position of CMPMCF field.
	LPTIM_ICR_CMPMCF_Msk    = 0x1  // Bit mask of CMPMCF field.
	LPTIM_ICR_CMPMCF        = 0x1  // Bit CMPMCF.

	// IER: Interrupt Enable Register
	LPTIM_IER_DOWNIE_Pos    = 0x6  // Position of DOWNIE field.
	LPTIM_IER_DOWNIE_Msk    = 0x40 // Bit mask of DOWNIE field.
	LPTIM_IER_DOWNIE        = 0x40 // Bit DOWNIE.
	LPTIM_IER_UPIE_Pos      = 0x5  // Position of UPIE field.
	LPTIM_IER_UPIE_Msk      = 0x20 // Bit mask of UPIE field.
	LPTIM_IER_UPIE          = 0x20 // Bit UPIE.
	LPTIM_IER_ARROKIE_Pos   = 0x4  // Position of ARROKIE field.
	LPTIM_IER_ARROKIE_Msk   = 0x10 // Bit mask of ARROKIE field.
	LPTIM_IER_ARROKIE       = 0x10 // Bit ARROKIE.
	LPTIM_IER_CMPOKIE_Pos   = 0x3  // Position of CMPOKIE field.
	LPTIM_IER_CMPOKIE_Msk   = 0x8  // Bit mask of CMPOKIE field.
	LPTIM_IER_CMPOKIE       = 0x8  // Bit CMPOKIE.
	LPTIM_IER_EXTTRIGIE_Pos = 0x2  // Position of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE_Msk = 0x4  // Bit mask of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE     = 0x4  // Bit EXTTRIGIE.
	LPTIM_IER_ARRMIE_Pos    = 0x1  // Position of ARRMIE field.
	LPTIM_IER_ARRMIE_Msk    = 0x2  // Bit mask of ARRMIE field.
	LPTIM_IER_ARRMIE        = 0x2  // Bit ARRMIE.
	LPTIM_IER_CMPMIE_Pos    = 0x0  // Position of CMPMIE field.
	LPTIM_IER_CMPMIE_Msk    = 0x1  // Bit mask of CMPMIE field.
	LPTIM_IER_CMPMIE        = 0x1  // Bit CMPMIE.

	// CFGR: Configuration Register
	LPTIM_CFGR_ENC_Pos       = 0x18      // Position of ENC field.
	LPTIM_CFGR_ENC_Msk       = 0x1000000 // Bit mask of ENC field.
	LPTIM_CFGR_ENC           = 0x1000000 // Bit ENC.
	LPTIM_CFGR_COUNTMODE_Pos = 0x17      // Position of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE_Msk = 0x800000  // Bit mask of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE     = 0x800000  // Bit COUNTMODE.
	LPTIM_CFGR_PRELOAD_Pos   = 0x16      // Position of PRELOAD field.
	LPTIM_CFGR_PRELOAD_Msk   = 0x400000  // Bit mask of PRELOAD field.
	LPTIM_CFGR_PRELOAD       = 0x400000  // Bit PRELOAD.
	LPTIM_CFGR_WAVPOL_Pos    = 0x15      // Position of WAVPOL field.
	LPTIM_CFGR_WAVPOL_Msk    = 0x200000  // Bit mask of WAVPOL field.
	LPTIM_CFGR_WAVPOL        = 0x200000  // Bit WAVPOL.
	LPTIM_CFGR_WAVE_Pos      = 0x14      // Position of WAVE field.
	LPTIM_CFGR_WAVE_Msk      = 0x100000  // Bit mask of WAVE field.
	LPTIM_CFGR_WAVE          = 0x100000  // Bit WAVE.
	LPTIM_CFGR_TIMOUT_Pos    = 0x13      // Position of TIMOUT field.
	LPTIM_CFGR_TIMOUT_Msk    = 0x80000   // Bit mask of TIMOUT field.
	LPTIM_CFGR_TIMOUT        = 0x80000   // Bit TIMOUT.
	LPTIM_CFGR_TRIGEN_Pos    = 0x11      // Position of TRIGEN field.
	LPTIM_CFGR_TRIGEN_Msk    = 0x60000   // Bit mask of TRIGEN field.
	LPTIM_CFGR_TRIGSEL_Pos   = 0xd       // Position of TRIGSEL field.
	LPTIM_CFGR_TRIGSEL_Msk   = 0xe000    // Bit mask of TRIGSEL field.
	LPTIM_CFGR_PRESC_Pos     = 0x9       // Position of PRESC field.
	LPTIM_CFGR_PRESC_Msk     = 0xe00     // Bit mask of PRESC field.
	LPTIM_CFGR_TRGFLT_Pos    = 0x6       // Position of TRGFLT field.
	LPTIM_CFGR_TRGFLT_Msk    = 0xc0      // Bit mask of TRGFLT field.
	LPTIM_CFGR_CKFLT_Pos     = 0x3       // Position of CKFLT field.
	LPTIM_CFGR_CKFLT_Msk     = 0x18      // Bit mask of CKFLT field.
	LPTIM_CFGR_CKPOL_Pos     = 0x1       // Position of CKPOL field.
	LPTIM_CFGR_CKPOL_Msk     = 0x6       // Bit mask of CKPOL field.
	LPTIM_CFGR_CKSEL_Pos     = 0x0       // Position of CKSEL field.
	LPTIM_CFGR_CKSEL_Msk     = 0x1       // Bit mask of CKSEL field.
	LPTIM_CFGR_CKSEL         = 0x1       // Bit CKSEL.

	// CR: Control Register
	LPTIM_CR_CNTSTRT_Pos = 0x2 // Position of CNTSTRT field.
	LPTIM_CR_CNTSTRT_Msk = 0x4 // Bit mask of CNTSTRT field.
	LPTIM_CR_CNTSTRT     = 0x4 // Bit CNTSTRT.
	LPTIM_CR_SNGSTRT_Pos = 0x1 // Position of SNGSTRT field.
	LPTIM_CR_SNGSTRT_Msk = 0x2 // Bit mask of SNGSTRT field.
	LPTIM_CR_SNGSTRT     = 0x2 // Bit SNGSTRT.
	LPTIM_CR_ENABLE_Pos  = 0x0 // Position of ENABLE field.
	LPTIM_CR_ENABLE_Msk  = 0x1 // Bit mask of ENABLE field.
	LPTIM_CR_ENABLE      = 0x1 // Bit ENABLE.

	// CMP: Compare Register
	LPTIM_CMP_CMP_Pos = 0x0    // Position of CMP field.
	LPTIM_CMP_CMP_Msk = 0xffff // Bit mask of CMP field.

	// ARR: Autoreload Register
	LPTIM_ARR_ARR_Pos = 0x0    // Position of ARR field.
	LPTIM_ARR_ARR_Msk = 0xffff // Bit mask of ARR field.

	// CNT: Counter Register
	LPTIM_CNT_CNT_Pos = 0x0    // Position of CNT field.
	LPTIM_CNT_CNT_Msk = 0xffff // Bit mask of CNT field.
)

// Bitfields for RTC: Real-time clock
const (
	// TR: RTC time register
	RTC_TR_PM_Pos  = 0x16     // Position of PM field.
	RTC_TR_PM_Msk  = 0x400000 // Bit mask of PM field.
	RTC_TR_PM      = 0x400000 // Bit PM.
	RTC_TR_HT_Pos  = 0x14     // Position of HT field.
	RTC_TR_HT_Msk  = 0x300000 // Bit mask of HT field.
	RTC_TR_HU_Pos  = 0x10     // Position of HU field.
	RTC_TR_HU_Msk  = 0xf0000  // Bit mask of HU field.
	RTC_TR_MNT_Pos = 0xc      // Position of MNT field.
	RTC_TR_MNT_Msk = 0x7000   // Bit mask of MNT field.
	RTC_TR_MNU_Pos = 0x8      // Position of MNU field.
	RTC_TR_MNU_Msk = 0xf00    // Bit mask of MNU field.
	RTC_TR_ST_Pos  = 0x4      // Position of ST field.
	RTC_TR_ST_Msk  = 0x70     // Bit mask of ST field.
	RTC_TR_SU_Pos  = 0x0      // Position of SU field.
	RTC_TR_SU_Msk  = 0xf      // Bit mask of SU field.

	// DR: RTC date register
	RTC_DR_YT_Pos  = 0x14     // Position of YT field.
	RTC_DR_YT_Msk  = 0xf00000 // Bit mask of YT field.
	RTC_DR_YU_Pos  = 0x10     // Position of YU field.
	RTC_DR_YU_Msk  = 0xf0000  // Bit mask of YU field.
	RTC_DR_WDU_Pos = 0xd      // Position of WDU field.
	RTC_DR_WDU_Msk = 0xe000   // Bit mask of WDU field.
	RTC_DR_MT_Pos  = 0xc      // Position of MT field.
	RTC_DR_MT_Msk  = 0x1000   // Bit mask of MT field.
	RTC_DR_MT      = 0x1000   // Bit MT.
	RTC_DR_MU_Pos  = 0x8      // Position of MU field.
	RTC_DR_MU_Msk  = 0xf00    // Bit mask of MU field.
	RTC_DR_DT_Pos  = 0x4      // Position of DT field.
	RTC_DR_DT_Msk  = 0x30     // Bit mask of DT field.
	RTC_DR_DU_Pos  = 0x0      // Position of DU field.
	RTC_DR_DU_Msk  = 0xf      // Bit mask of DU field.

	// CR: RTC control register
	RTC_CR_COE_Pos     = 0x17     // Position of COE field.
	RTC_CR_COE_Msk     = 0x800000 // Bit mask of COE field.
	RTC_CR_COE         = 0x800000 // Bit COE.
	RTC_CR_OSEL_Pos    = 0x15     // Position of OSEL field.
	RTC_CR_OSEL_Msk    = 0x600000 // Bit mask of OSEL field.
	RTC_CR_POL_Pos     = 0x14     // Position of POL field.
	RTC_CR_POL_Msk     = 0x100000 // Bit mask of POL field.
	RTC_CR_POL         = 0x100000 // Bit POL.
	RTC_CR_COSEL_Pos   = 0x13     // Position of COSEL field.
	RTC_CR_COSEL_Msk   = 0x80000  // Bit mask of COSEL field.
	RTC_CR_COSEL       = 0x80000  // Bit COSEL.
	RTC_CR_BKP_Pos     = 0x12     // Position of BKP field.
	RTC_CR_BKP_Msk     = 0x40000  // Bit mask of BKP field.
	RTC_CR_BKP         = 0x40000  // Bit BKP.
	RTC_CR_SUB1H_Pos   = 0x11     // Position of SUB1H field.
	RTC_CR_SUB1H_Msk   = 0x20000  // Bit mask of SUB1H field.
	RTC_CR_SUB1H       = 0x20000  // Bit SUB1H.
	RTC_CR_ADD1H_Pos   = 0x10     // Position of ADD1H field.
	RTC_CR_ADD1H_Msk   = 0x10000  // Bit mask of ADD1H field.
	RTC_CR_ADD1H       = 0x10000  // Bit ADD1H.
	RTC_CR_TSIE_Pos    = 0xf      // Position of TSIE field.
	RTC_CR_TSIE_Msk    = 0x8000   // Bit mask of TSIE field.
	RTC_CR_TSIE        = 0x8000   // Bit TSIE.
	RTC_CR_WUTIE_Pos   = 0xe      // Position of WUTIE field.
	RTC_CR_WUTIE_Msk   = 0x4000   // Bit mask of WUTIE field.
	RTC_CR_WUTIE       = 0x4000   // Bit WUTIE.
	RTC_CR_ALRBIE_Pos  = 0xd      // Position of ALRBIE field.
	RTC_CR_ALRBIE_Msk  = 0x2000   // Bit mask of ALRBIE field.
	RTC_CR_ALRBIE      = 0x2000   // Bit ALRBIE.
	RTC_CR_ALRAIE_Pos  = 0xc      // Position of ALRAIE field.
	RTC_CR_ALRAIE_Msk  = 0x1000   // Bit mask of ALRAIE field.
	RTC_CR_ALRAIE      = 0x1000   // Bit ALRAIE.
	RTC_CR_TSE_Pos     = 0xb      // Position of TSE field.
	RTC_CR_TSE_Msk     = 0x800    // Bit mask of TSE field.
	RTC_CR_TSE         = 0x800    // Bit TSE.
	RTC_CR_WUTE_Pos    = 0xa      // Position of WUTE field.
	RTC_CR_WUTE_Msk    = 0x400    // Bit mask of WUTE field.
	RTC_CR_WUTE        = 0x400    // Bit WUTE.
	RTC_CR_ALRBE_Pos   = 0x9      // Position of ALRBE field.
	RTC_CR_ALRBE_Msk   = 0x200    // Bit mask of ALRBE field.
	RTC_CR_ALRBE       = 0x200    // Bit ALRBE.
	RTC_CR_ALRAE_Pos   = 0x8      // Position of ALRAE field.
	RTC_CR_ALRAE_Msk   = 0x100    // Bit mask of ALRAE field.
	RTC_CR_ALRAE       = 0x100    // Bit ALRAE.
	RTC_CR_FMT_Pos     = 0x6      // Position of FMT field.
	RTC_CR_FMT_Msk     = 0x40     // Bit mask of FMT field.
	RTC_CR_FMT         = 0x40     // Bit FMT.
	RTC_CR_BYPSHAD_Pos = 0x5      // Position of BYPSHAD field.
	RTC_CR_BYPSHAD_Msk = 0x20     // Bit mask of BYPSHAD field.
	RTC_CR_BYPSHAD     = 0x20     // Bit BYPSHAD.
	RTC_CR_REFCKON_Pos = 0x4      // Position of REFCKON field.
	RTC_CR_REFCKON_Msk = 0x10     // Bit mask of REFCKON field.
	RTC_CR_REFCKON     = 0x10     // Bit REFCKON.
	RTC_CR_TSEDGE_Pos  = 0x3      // Position of TSEDGE field.
	RTC_CR_TSEDGE_Msk  = 0x8      // Bit mask of TSEDGE field.
	RTC_CR_TSEDGE      = 0x8      // Bit TSEDGE.
	RTC_CR_WUCKSEL_Pos = 0x0      // Position of WUCKSEL field.
	RTC_CR_WUCKSEL_Msk = 0x7      // Bit mask of WUCKSEL field.

	// ISR: RTC initialization and status           register
	RTC_ISR_TAMP2F_Pos = 0xe    // Position of TAMP2F field.
	RTC_ISR_TAMP2F_Msk = 0x4000 // Bit mask of TAMP2F field.
	RTC_ISR_TAMP2F     = 0x4000 // Bit TAMP2F.
	RTC_ISR_TAMP1F_Pos = 0xd    // Position of TAMP1F field.
	RTC_ISR_TAMP1F_Msk = 0x2000 // Bit mask of TAMP1F field.
	RTC_ISR_TAMP1F     = 0x2000 // Bit TAMP1F.
	RTC_ISR_TSOVF_Pos  = 0xc    // Position of TSOVF field.
	RTC_ISR_TSOVF_Msk  = 0x1000 // Bit mask of TSOVF field.
	RTC_ISR_TSOVF      = 0x1000 // Bit TSOVF.
	RTC_ISR_TSF_Pos    = 0xb    // Position of TSF field.
	RTC_ISR_TSF_Msk    = 0x800  // Bit mask of TSF field.
	RTC_ISR_TSF        = 0x800  // Bit TSF.
	RTC_ISR_WUTF_Pos   = 0xa    // Position of WUTF field.
	RTC_ISR_WUTF_Msk   = 0x400  // Bit mask of WUTF field.
	RTC_ISR_WUTF       = 0x400  // Bit WUTF.
	RTC_ISR_ALRBF_Pos  = 0x9    // Position of ALRBF field.
	RTC_ISR_ALRBF_Msk  = 0x200  // Bit mask of ALRBF field.
	RTC_ISR_ALRBF      = 0x200  // Bit ALRBF.
	RTC_ISR_ALRAF_Pos  = 0x8    // Position of ALRAF field.
	RTC_ISR_ALRAF_Msk  = 0x100  // Bit mask of ALRAF field.
	RTC_ISR_ALRAF      = 0x100  // Bit ALRAF.
	RTC_ISR_INIT_Pos   = 0x7    // Position of INIT field.
	RTC_ISR_INIT_Msk   = 0x80   // Bit mask of INIT field.
	RTC_ISR_INIT       = 0x80   // Bit INIT.
	RTC_ISR_INITF_Pos  = 0x6    // Position of INITF field.
	RTC_ISR_INITF_Msk  = 0x40   // Bit mask of INITF field.
	RTC_ISR_INITF      = 0x40   // Bit INITF.
	RTC_ISR_RSF_Pos    = 0x5    // Position of RSF field.
	RTC_ISR_RSF_Msk    = 0x20   // Bit mask of RSF field.
	RTC_ISR_RSF        = 0x20   // Bit RSF.
	RTC_ISR_INITS_Pos  = 0x4    // Position of INITS field.
	RTC_ISR_INITS_Msk  = 0x10   // Bit mask of INITS field.
	RTC_ISR_INITS      = 0x10   // Bit INITS.
	RTC_ISR_SHPF_Pos   = 0x3    // Position of SHPF field.
	RTC_ISR_SHPF_Msk   = 0x8    // Bit mask of SHPF field.
	RTC_ISR_SHPF       = 0x8    // Bit SHPF.
	RTC_ISR_WUTWF_Pos  = 0x2    // Position of WUTWF field.
	RTC_ISR_WUTWF_Msk  = 0x4    // Bit mask of WUTWF field.
	RTC_ISR_WUTWF      = 0x4    // Bit WUTWF.
	RTC_ISR_ALRBWF_Pos = 0x1    // Position of ALRBWF field.
	RTC_ISR_ALRBWF_Msk = 0x2    // Bit mask of ALRBWF field.
	RTC_ISR_ALRBWF     = 0x2    // Bit ALRBWF.
	RTC_ISR_ALRAWF_Pos = 0x0    // Position of ALRAWF field.
	RTC_ISR_ALRAWF_Msk = 0x1    // Bit mask of ALRAWF field.
	RTC_ISR_ALRAWF     = 0x1    // Bit ALRAWF.

	// PRER: RTC prescaler register
	RTC_PRER_PREDIV_A_Pos = 0x10     // Position of PREDIV_A field.
	RTC_PRER_PREDIV_A_Msk = 0x7f0000 // Bit mask of PREDIV_A field.
	RTC_PRER_PREDIV_S_Pos = 0x0      // Position of PREDIV_S field.
	RTC_PRER_PREDIV_S_Msk = 0xffff   // Bit mask of PREDIV_S field.

	// WUTR: RTC wakeup timer register
	RTC_WUTR_WUT_Pos = 0x0    // Position of WUT field.
	RTC_WUTR_WUT_Msk = 0xffff // Bit mask of WUT field.

	// ALRMAR: RTC alarm A register
	RTC_ALRMAR_MSK4_Pos  = 0x1f       // Position of MSK4 field.
	RTC_ALRMAR_MSK4_Msk  = 0x80000000 // Bit mask of MSK4 field.
	RTC_ALRMAR_MSK4      = 0x80000000 // Bit MSK4.
	RTC_ALRMAR_WDSEL_Pos = 0x1e       // Position of WDSEL field.
	RTC_ALRMAR_WDSEL_Msk = 0x40000000 // Bit mask of WDSEL field.
	RTC_ALRMAR_WDSEL     = 0x40000000 // Bit WDSEL.
	RTC_ALRMAR_DT_Pos    = 0x1c       // Position of DT field.
	RTC_ALRMAR_DT_Msk    = 0x30000000 // Bit mask of DT field.
	RTC_ALRMAR_DU_Pos    = 0x18       // Position of DU field.
	RTC_ALRMAR_DU_Msk    = 0xf000000  // Bit mask of DU field.
	RTC_ALRMAR_MSK3_Pos  = 0x17       // Position of MSK3 field.
	RTC_ALRMAR_MSK3_Msk  = 0x800000   // Bit mask of MSK3 field.
	RTC_ALRMAR_MSK3      = 0x800000   // Bit MSK3.
	RTC_ALRMAR_PM_Pos    = 0x16       // Position of PM field.
	RTC_ALRMAR_PM_Msk    = 0x400000   // Bit mask of PM field.
	RTC_ALRMAR_PM        = 0x400000   // Bit PM.
	RTC_ALRMAR_HT_Pos    = 0x14       // Position of HT field.
	RTC_ALRMAR_HT_Msk    = 0x300000   // Bit mask of HT field.
	RTC_ALRMAR_HU_Pos    = 0x10       // Position of HU field.
	RTC_ALRMAR_HU_Msk    = 0xf0000    // Bit mask of HU field.
	RTC_ALRMAR_MSK2_Pos  = 0xf        // Position of MSK2 field.
	RTC_ALRMAR_MSK2_Msk  = 0x8000     // Bit mask of MSK2 field.
	RTC_ALRMAR_MSK2      = 0x8000     // Bit MSK2.
	RTC_ALRMAR_MNT_Pos   = 0xc        // Position of MNT field.
	RTC_ALRMAR_MNT_Msk   = 0x7000     // Bit mask of MNT field.
	RTC_ALRMAR_MNU_Pos   = 0x8        // Position of MNU field.
	RTC_ALRMAR_MNU_Msk   = 0xf00      // Bit mask of MNU field.
	RTC_ALRMAR_MSK1_Pos  = 0x7        // Position of MSK1 field.
	RTC_ALRMAR_MSK1_Msk  = 0x80       // Bit mask of MSK1 field.
	RTC_ALRMAR_MSK1      = 0x80       // Bit MSK1.
	RTC_ALRMAR_ST_Pos    = 0x4        // Position of ST field.
	RTC_ALRMAR_ST_Msk    = 0x70       // Bit mask of ST field.
	RTC_ALRMAR_SU_Pos    = 0x0        // Position of SU field.
	RTC_ALRMAR_SU_Msk    = 0xf        // Bit mask of SU field.

	// ALRMBR: RTC alarm B register
	RTC_ALRMBR_MSK4_Pos  = 0x1f       // Position of MSK4 field.
	RTC_ALRMBR_MSK4_Msk  = 0x80000000 // Bit mask of MSK4 field.
	RTC_ALRMBR_MSK4      = 0x80000000 // Bit MSK4.
	RTC_ALRMBR_WDSEL_Pos = 0x1e       // Position of WDSEL field.
	RTC_ALRMBR_WDSEL_Msk = 0x40000000 // Bit mask of WDSEL field.
	RTC_ALRMBR_WDSEL     = 0x40000000 // Bit WDSEL.
	RTC_ALRMBR_DT_Pos    = 0x1c       // Position of DT field.
	RTC_ALRMBR_DT_Msk    = 0x30000000 // Bit mask of DT field.
	RTC_ALRMBR_DU_Pos    = 0x18       // Position of DU field.
	RTC_ALRMBR_DU_Msk    = 0xf000000  // Bit mask of DU field.
	RTC_ALRMBR_MSK3_Pos  = 0x17       // Position of MSK3 field.
	RTC_ALRMBR_MSK3_Msk  = 0x800000   // Bit mask of MSK3 field.
	RTC_ALRMBR_MSK3      = 0x800000   // Bit MSK3.
	RTC_ALRMBR_PM_Pos    = 0x16       // Position of PM field.
	RTC_ALRMBR_PM_Msk    = 0x400000   // Bit mask of PM field.
	RTC_ALRMBR_PM        = 0x400000   // Bit PM.
	RTC_ALRMBR_HT_Pos    = 0x14       // Position of HT field.
	RTC_ALRMBR_HT_Msk    = 0x300000   // Bit mask of HT field.
	RTC_ALRMBR_HU_Pos    = 0x10       // Position of HU field.
	RTC_ALRMBR_HU_Msk    = 0xf0000    // Bit mask of HU field.
	RTC_ALRMBR_MSK2_Pos  = 0xf        // Position of MSK2 field.
	RTC_ALRMBR_MSK2_Msk  = 0x8000     // Bit mask of MSK2 field.
	RTC_ALRMBR_MSK2      = 0x8000     // Bit MSK2.
	RTC_ALRMBR_MNT_Pos   = 0xc        // Position of MNT field.
	RTC_ALRMBR_MNT_Msk   = 0x7000     // Bit mask of MNT field.
	RTC_ALRMBR_MNU_Pos   = 0x8        // Position of MNU field.
	RTC_ALRMBR_MNU_Msk   = 0xf00      // Bit mask of MNU field.
	RTC_ALRMBR_MSK1_Pos  = 0x7        // Position of MSK1 field.
	RTC_ALRMBR_MSK1_Msk  = 0x80       // Bit mask of MSK1 field.
	RTC_ALRMBR_MSK1      = 0x80       // Bit MSK1.
	RTC_ALRMBR_ST_Pos    = 0x4        // Position of ST field.
	RTC_ALRMBR_ST_Msk    = 0x70       // Bit mask of ST field.
	RTC_ALRMBR_SU_Pos    = 0x0        // Position of SU field.
	RTC_ALRMBR_SU_Msk    = 0xf        // Bit mask of SU field.

	// WPR: write protection register
	RTC_WPR_KEY_Pos = 0x0  // Position of KEY field.
	RTC_WPR_KEY_Msk = 0xff // Bit mask of KEY field.

	// SSR: RTC sub second register
	RTC_SSR_SS_Pos = 0x0    // Position of SS field.
	RTC_SSR_SS_Msk = 0xffff // Bit mask of SS field.

	// SHIFTR: RTC shift control register
	RTC_SHIFTR_ADD1S_Pos = 0x1f       // Position of ADD1S field.
	RTC_SHIFTR_ADD1S_Msk = 0x80000000 // Bit mask of ADD1S field.
	RTC_SHIFTR_ADD1S     = 0x80000000 // Bit ADD1S.
	RTC_SHIFTR_SUBFS_Pos = 0x0        // Position of SUBFS field.
	RTC_SHIFTR_SUBFS_Msk = 0x7fff     // Bit mask of SUBFS field.

	// TSTR: RTC timestamp time register
	RTC_TSTR_PM_Pos  = 0x16     // Position of PM field.
	RTC_TSTR_PM_Msk  = 0x400000 // Bit mask of PM field.
	RTC_TSTR_PM      = 0x400000 // Bit PM.
	RTC_TSTR_HT_Pos  = 0x14     // Position of HT field.
	RTC_TSTR_HT_Msk  = 0x300000 // Bit mask of HT field.
	RTC_TSTR_HU_Pos  = 0x10     // Position of HU field.
	RTC_TSTR_HU_Msk  = 0xf0000  // Bit mask of HU field.
	RTC_TSTR_MNT_Pos = 0xc      // Position of MNT field.
	RTC_TSTR_MNT_Msk = 0x7000   // Bit mask of MNT field.
	RTC_TSTR_MNU_Pos = 0x8      // Position of MNU field.
	RTC_TSTR_MNU_Msk = 0xf00    // Bit mask of MNU field.
	RTC_TSTR_ST_Pos  = 0x4      // Position of ST field.
	RTC_TSTR_ST_Msk  = 0x70     // Bit mask of ST field.
	RTC_TSTR_SU_Pos  = 0x0      // Position of SU field.
	RTC_TSTR_SU_Msk  = 0xf      // Bit mask of SU field.

	// TSDR: RTC timestamp date register
	RTC_TSDR_WDU_Pos = 0xd    // Position of WDU field.
	RTC_TSDR_WDU_Msk = 0xe000 // Bit mask of WDU field.
	RTC_TSDR_MT_Pos  = 0xc    // Position of MT field.
	RTC_TSDR_MT_Msk  = 0x1000 // Bit mask of MT field.
	RTC_TSDR_MT      = 0x1000 // Bit MT.
	RTC_TSDR_MU_Pos  = 0x8    // Position of MU field.
	RTC_TSDR_MU_Msk  = 0xf00  // Bit mask of MU field.
	RTC_TSDR_DT_Pos  = 0x4    // Position of DT field.
	RTC_TSDR_DT_Msk  = 0x30   // Bit mask of DT field.
	RTC_TSDR_DU_Pos  = 0x0    // Position of DU field.
	RTC_TSDR_DU_Msk  = 0xf    // Bit mask of DU field.

	// TSSSR: RTC time-stamp sub second           register
	RTC_TSSSR_SS_Pos = 0x0    // Position of SS field.
	RTC_TSSSR_SS_Msk = 0xffff // Bit mask of SS field.

	// CALR: RTC calibration register
	RTC_CALR_CALP_Pos   = 0xf    // Position of CALP field.
	RTC_CALR_CALP_Msk   = 0x8000 // Bit mask of CALP field.
	RTC_CALR_CALP       = 0x8000 // Bit CALP.
	RTC_CALR_CALW8_Pos  = 0xe    // Position of CALW8 field.
	RTC_CALR_CALW8_Msk  = 0x4000 // Bit mask of CALW8 field.
	RTC_CALR_CALW8      = 0x4000 // Bit CALW8.
	RTC_CALR_CALW16_Pos = 0xd    // Position of CALW16 field.
	RTC_CALR_CALW16_Msk = 0x2000 // Bit mask of CALW16 field.
	RTC_CALR_CALW16     = 0x2000 // Bit CALW16.
	RTC_CALR_CALM_Pos   = 0x0    // Position of CALM field.
	RTC_CALR_CALM_Msk   = 0x1ff  // Bit mask of CALM field.

	// TAMPCR: RTC tamper configuration           register
	RTC_TAMPCR_TAMP2MF_Pos      = 0x15     // Position of TAMP2MF field.
	RTC_TAMPCR_TAMP2MF_Msk      = 0x200000 // Bit mask of TAMP2MF field.
	RTC_TAMPCR_TAMP2MF          = 0x200000 // Bit TAMP2MF.
	RTC_TAMPCR_TAMP2NOERASE_Pos = 0x14     // Position of TAMP2NOERASE field.
	RTC_TAMPCR_TAMP2NOERASE_Msk = 0x100000 // Bit mask of TAMP2NOERASE field.
	RTC_TAMPCR_TAMP2NOERASE     = 0x100000 // Bit TAMP2NOERASE.
	RTC_TAMPCR_TAMP2IE_Pos      = 0x13     // Position of TAMP2IE field.
	RTC_TAMPCR_TAMP2IE_Msk      = 0x80000  // Bit mask of TAMP2IE field.
	RTC_TAMPCR_TAMP2IE          = 0x80000  // Bit TAMP2IE.
	RTC_TAMPCR_TAMP1MF_Pos      = 0x12     // Position of TAMP1MF field.
	RTC_TAMPCR_TAMP1MF_Msk      = 0x40000  // Bit mask of TAMP1MF field.
	RTC_TAMPCR_TAMP1MF          = 0x40000  // Bit TAMP1MF.
	RTC_TAMPCR_TAMP1NOERASE_Pos = 0x11     // Position of TAMP1NOERASE field.
	RTC_TAMPCR_TAMP1NOERASE_Msk = 0x20000  // Bit mask of TAMP1NOERASE field.
	RTC_TAMPCR_TAMP1NOERASE     = 0x20000  // Bit TAMP1NOERASE.
	RTC_TAMPCR_TAMP1IE_Pos      = 0x10     // Position of TAMP1IE field.
	RTC_TAMPCR_TAMP1IE_Msk      = 0x10000  // Bit mask of TAMP1IE field.
	RTC_TAMPCR_TAMP1IE          = 0x10000  // Bit TAMP1IE.
	RTC_TAMPCR_TAMPPUDIS_Pos    = 0xf      // Position of TAMPPUDIS field.
	RTC_TAMPCR_TAMPPUDIS_Msk    = 0x8000   // Bit mask of TAMPPUDIS field.
	RTC_TAMPCR_TAMPPUDIS        = 0x8000   // Bit TAMPPUDIS.
	RTC_TAMPCR_TAMPPRCH_Pos     = 0xd      // Position of TAMPPRCH field.
	RTC_TAMPCR_TAMPPRCH_Msk     = 0x6000   // Bit mask of TAMPPRCH field.
	RTC_TAMPCR_TAMPFLT_Pos      = 0xb      // Position of TAMPFLT field.
	RTC_TAMPCR_TAMPFLT_Msk      = 0x1800   // Bit mask of TAMPFLT field.
	RTC_TAMPCR_TAMPFREQ_Pos     = 0x8      // Position of TAMPFREQ field.
	RTC_TAMPCR_TAMPFREQ_Msk     = 0x700    // Bit mask of TAMPFREQ field.
	RTC_TAMPCR_TAMPTS_Pos       = 0x7      // Position of TAMPTS field.
	RTC_TAMPCR_TAMPTS_Msk       = 0x80     // Bit mask of TAMPTS field.
	RTC_TAMPCR_TAMPTS           = 0x80     // Bit TAMPTS.
	RTC_TAMPCR_TAMP2_TRG_Pos    = 0x4      // Position of TAMP2_TRG field.
	RTC_TAMPCR_TAMP2_TRG_Msk    = 0x10     // Bit mask of TAMP2_TRG field.
	RTC_TAMPCR_TAMP2_TRG        = 0x10     // Bit TAMP2_TRG.
	RTC_TAMPCR_TAMP2E_Pos       = 0x3      // Position of TAMP2E field.
	RTC_TAMPCR_TAMP2E_Msk       = 0x8      // Bit mask of TAMP2E field.
	RTC_TAMPCR_TAMP2E           = 0x8      // Bit TAMP2E.
	RTC_TAMPCR_TAMPIE_Pos       = 0x2      // Position of TAMPIE field.
	RTC_TAMPCR_TAMPIE_Msk       = 0x4      // Bit mask of TAMPIE field.
	RTC_TAMPCR_TAMPIE           = 0x4      // Bit TAMPIE.
	RTC_TAMPCR_TAMP1TRG_Pos     = 0x1      // Position of TAMP1TRG field.
	RTC_TAMPCR_TAMP1TRG_Msk     = 0x2      // Bit mask of TAMP1TRG field.
	RTC_TAMPCR_TAMP1TRG         = 0x2      // Bit TAMP1TRG.
	RTC_TAMPCR_TAMP1E_Pos       = 0x0      // Position of TAMP1E field.
	RTC_TAMPCR_TAMP1E_Msk       = 0x1      // Bit mask of TAMP1E field.
	RTC_TAMPCR_TAMP1E           = 0x1      // Bit TAMP1E.

	// ALRMASSR: RTC alarm A sub second           register
	RTC_ALRMASSR_MASKSS_Pos = 0x18      // Position of MASKSS field.
	RTC_ALRMASSR_MASKSS_Msk = 0xf000000 // Bit mask of MASKSS field.
	RTC_ALRMASSR_SS_Pos     = 0x0       // Position of SS field.
	RTC_ALRMASSR_SS_Msk     = 0x7fff    // Bit mask of SS field.

	// ALRMBSSR: RTC alarm B sub second           register
	RTC_ALRMBSSR_MASKSS_Pos = 0x18      // Position of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Msk = 0xf000000 // Bit mask of MASKSS field.
	RTC_ALRMBSSR_SS_Pos     = 0x0       // Position of SS field.
	RTC_ALRMBSSR_SS_Msk     = 0x7fff    // Bit mask of SS field.

	// OR: option register
	RTC_OR_RTC_OUT_RMP_Pos    = 0x1 // Position of RTC_OUT_RMP field.
	RTC_OR_RTC_OUT_RMP_Msk    = 0x2 // Bit mask of RTC_OUT_RMP field.
	RTC_OR_RTC_OUT_RMP        = 0x2 // Bit RTC_OUT_RMP.
	RTC_OR_RTC_ALARM_TYPE_Pos = 0x0 // Position of RTC_ALARM_TYPE field.
	RTC_OR_RTC_ALARM_TYPE_Msk = 0x1 // Bit mask of RTC_ALARM_TYPE field.
	RTC_OR_RTC_ALARM_TYPE     = 0x1 // Bit RTC_ALARM_TYPE.

	// BKP0R: RTC backup registers
	RTC_BKP0R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP0R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP1R: RTC backup registers
	RTC_BKP1R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP1R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP2R: RTC backup registers
	RTC_BKP2R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP2R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP3R: RTC backup registers
	RTC_BKP3R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP3R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP4R: RTC backup registers
	RTC_BKP4R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP4R_BKP_Msk = 0xffffffff // Bit mask of BKP field.
)

// Bitfields for USART1: Universal synchronous asynchronous receiver transmitter
const (
	// CR1: Control register 1
	USART_CR1_M1_Pos     = 0x1c       // Position of M1 field.
	USART_CR1_M1_Msk     = 0x10000000 // Bit mask of M1 field.
	USART_CR1_M1         = 0x10000000 // Bit M1.
	USART_CR1_EOBIE_Pos  = 0x1b       // Position of EOBIE field.
	USART_CR1_EOBIE_Msk  = 0x8000000  // Bit mask of EOBIE field.
	USART_CR1_EOBIE      = 0x8000000  // Bit EOBIE.
	USART_CR1_RTOIE_Pos  = 0x1a       // Position of RTOIE field.
	USART_CR1_RTOIE_Msk  = 0x4000000  // Bit mask of RTOIE field.
	USART_CR1_RTOIE      = 0x4000000  // Bit RTOIE.
	USART_CR1_DEAT4_Pos  = 0x19       // Position of DEAT4 field.
	USART_CR1_DEAT4_Msk  = 0x2000000  // Bit mask of DEAT4 field.
	USART_CR1_DEAT4      = 0x2000000  // Bit DEAT4.
	USART_CR1_DEAT3_Pos  = 0x18       // Position of DEAT3 field.
	USART_CR1_DEAT3_Msk  = 0x1000000  // Bit mask of DEAT3 field.
	USART_CR1_DEAT3      = 0x1000000  // Bit DEAT3.
	USART_CR1_DEAT2_Pos  = 0x17       // Position of DEAT2 field.
	USART_CR1_DEAT2_Msk  = 0x800000   // Bit mask of DEAT2 field.
	USART_CR1_DEAT2      = 0x800000   // Bit DEAT2.
	USART_CR1_DEAT1_Pos  = 0x16       // Position of DEAT1 field.
	USART_CR1_DEAT1_Msk  = 0x400000   // Bit mask of DEAT1 field.
	USART_CR1_DEAT1      = 0x400000   // Bit DEAT1.
	USART_CR1_DEAT0_Pos  = 0x15       // Position of DEAT0 field.
	USART_CR1_DEAT0_Msk  = 0x200000   // Bit mask of DEAT0 field.
	USART_CR1_DEAT0      = 0x200000   // Bit DEAT0.
	USART_CR1_DEDT4_Pos  = 0x14       // Position of DEDT4 field.
	USART_CR1_DEDT4_Msk  = 0x100000   // Bit mask of DEDT4 field.
	USART_CR1_DEDT4      = 0x100000   // Bit DEDT4.
	USART_CR1_DEDT3_Pos  = 0x13       // Position of DEDT3 field.
	USART_CR1_DEDT3_Msk  = 0x80000    // Bit mask of DEDT3 field.
	USART_CR1_DEDT3      = 0x80000    // Bit DEDT3.
	USART_CR1_DEDT2_Pos  = 0x12       // Position of DEDT2 field.
	USART_CR1_DEDT2_Msk  = 0x40000    // Bit mask of DEDT2 field.
	USART_CR1_DEDT2      = 0x40000    // Bit DEDT2.
	USART_CR1_DEDT1_Pos  = 0x11       // Position of DEDT1 field.
	USART_CR1_DEDT1_Msk  = 0x20000    // Bit mask of DEDT1 field.
	USART_CR1_DEDT1      = 0x20000    // Bit DEDT1.
	USART_CR1_DEDT0_Pos  = 0x10       // Position of DEDT0 field.
	USART_CR1_DEDT0_Msk  = 0x10000    // Bit mask of DEDT0 field.
	USART_CR1_DEDT0      = 0x10000    // Bit DEDT0.
	USART_CR1_OVER8_Pos  = 0xf        // Position of OVER8 field.
	USART_CR1_OVER8_Msk  = 0x8000     // Bit mask of OVER8 field.
	USART_CR1_OVER8      = 0x8000     // Bit OVER8.
	USART_CR1_CMIE_Pos   = 0xe        // Position of CMIE field.
	USART_CR1_CMIE_Msk   = 0x4000     // Bit mask of CMIE field.
	USART_CR1_CMIE       = 0x4000     // Bit CMIE.
	USART_CR1_MME_Pos    = 0xd        // Position of MME field.
	USART_CR1_MME_Msk    = 0x2000     // Bit mask of MME field.
	USART_CR1_MME        = 0x2000     // Bit MME.
	USART_CR1_M0_Pos     = 0xc        // Position of M0 field.
	USART_CR1_M0_Msk     = 0x1000     // Bit mask of M0 field.
	USART_CR1_M0         = 0x1000     // Bit M0.
	USART_CR1_WAKE_Pos   = 0xb        // Position of WAKE field.
	USART_CR1_WAKE_Msk   = 0x800      // Bit mask of WAKE field.
	USART_CR1_WAKE       = 0x800      // Bit WAKE.
	USART_CR1_PCE_Pos    = 0xa        // Position of PCE field.
	USART_CR1_PCE_Msk    = 0x400      // Bit mask of PCE field.
	USART_CR1_PCE        = 0x400      // Bit PCE.
	USART_CR1_PS_Pos     = 0x9        // Position of PS field.
	USART_CR1_PS_Msk     = 0x200      // Bit mask of PS field.
	USART_CR1_PS         = 0x200      // Bit PS.
	USART_CR1_PEIE_Pos   = 0x8        // Position of PEIE field.
	USART_CR1_PEIE_Msk   = 0x100      // Bit mask of PEIE field.
	USART_CR1_PEIE       = 0x100      // Bit PEIE.
	USART_CR1_TXEIE_Pos  = 0x7        // Position of TXEIE field.
	USART_CR1_TXEIE_Msk  = 0x80       // Bit mask of TXEIE field.
	USART_CR1_TXEIE      = 0x80       // Bit TXEIE.
	USART_CR1_TCIE_Pos   = 0x6        // Position of TCIE field.
	USART_CR1_TCIE_Msk   = 0x40       // Bit mask of TCIE field.
	USART_CR1_TCIE       = 0x40       // Bit TCIE.
	USART_CR1_RXNEIE_Pos = 0x5        // Position of RXNEIE field.
	USART_CR1_RXNEIE_Msk = 0x20       // Bit mask of RXNEIE field.
	USART_CR1_RXNEIE     = 0x20       // Bit RXNEIE.
	USART_CR1_IDLEIE_Pos = 0x4        // Position of IDLEIE field.
	USART_CR1_IDLEIE_Msk = 0x10       // Bit mask of IDLEIE field.
	USART_CR1_IDLEIE     = 0x10       // Bit IDLEIE.
	USART_CR1_TE_Pos     = 0x3        // Position of TE field.
	USART_CR1_TE_Msk     = 0x8        // Bit mask of TE field.
	USART_CR1_TE         = 0x8        // Bit TE.
	USART_CR1_RE_Pos     = 0x2        // Position of RE field.
	USART_CR1_RE_Msk     = 0x4        // Bit mask of RE field.
	USART_CR1_RE         = 0x4        // Bit RE.
	USART_CR1_UESM_Pos   = 0x1        // Position of UESM field.
	USART_CR1_UESM_Msk   = 0x2        // Bit mask of UESM field.
	USART_CR1_UESM       = 0x2        // Bit UESM.
	USART_CR1_UE_Pos     = 0x0        // Position of UE field.
	USART_CR1_UE_Msk     = 0x1        // Bit mask of UE field.
	USART_CR1_UE         = 0x1        // Bit UE.

	// CR2: Control register 2
	USART_CR2_ADD4_7_Pos   = 0x1c       // Position of ADD4_7 field.
	USART_CR2_ADD4_7_Msk   = 0xf0000000 // Bit mask of ADD4_7 field.
	USART_CR2_ADD0_3_Pos   = 0x18       // Position of ADD0_3 field.
	USART_CR2_ADD0_3_Msk   = 0xf000000  // Bit mask of ADD0_3 field.
	USART_CR2_RTOEN_Pos    = 0x17       // Position of RTOEN field.
	USART_CR2_RTOEN_Msk    = 0x800000   // Bit mask of RTOEN field.
	USART_CR2_RTOEN        = 0x800000   // Bit RTOEN.
	USART_CR2_ABRMOD1_Pos  = 0x16       // Position of ABRMOD1 field.
	USART_CR2_ABRMOD1_Msk  = 0x400000   // Bit mask of ABRMOD1 field.
	USART_CR2_ABRMOD1      = 0x400000   // Bit ABRMOD1.
	USART_CR2_ABRMOD0_Pos  = 0x15       // Position of ABRMOD0 field.
	USART_CR2_ABRMOD0_Msk  = 0x200000   // Bit mask of ABRMOD0 field.
	USART_CR2_ABRMOD0      = 0x200000   // Bit ABRMOD0.
	USART_CR2_ABREN_Pos    = 0x14       // Position of ABREN field.
	USART_CR2_ABREN_Msk    = 0x100000   // Bit mask of ABREN field.
	USART_CR2_ABREN        = 0x100000   // Bit ABREN.
	USART_CR2_MSBFIRST_Pos = 0x13       // Position of MSBFIRST field.
	USART_CR2_MSBFIRST_Msk = 0x80000    // Bit mask of MSBFIRST field.
	USART_CR2_MSBFIRST     = 0x80000    // Bit MSBFIRST.
	USART_CR2_TAINV_Pos    = 0x12       // Position of TAINV field.
	USART_CR2_TAINV_Msk    = 0x40000    // Bit mask of TAINV field.
	USART_CR2_TAINV        = 0x40000    // Bit TAINV.
	USART_CR2_TXINV_Pos    = 0x11       // Position of TXINV field.
	USART_CR2_TXINV_Msk    = 0x20000    // Bit mask of TXINV field.
	USART_CR2_TXINV        = 0x20000    // Bit TXINV.
	USART_CR2_RXINV_Pos    = 0x10       // Position of RXINV field.
	USART_CR2_RXINV_Msk    = 0x10000    // Bit mask of RXINV field.
	USART_CR2_RXINV        = 0x10000    // Bit RXINV.
	USART_CR2_SWAP_Pos     = 0xf        // Position of SWAP field.
	USART_CR2_SWAP_Msk     = 0x8000     // Bit mask of SWAP field.
	USART_CR2_SWAP         = 0x8000     // Bit SWAP.
	USART_CR2_LINEN_Pos    = 0xe        // Position of LINEN field.
	USART_CR2_LINEN_Msk    = 0x4000     // Bit mask of LINEN field.
	USART_CR2_LINEN        = 0x4000     // Bit LINEN.
	USART_CR2_STOP_Pos     = 0xc        // Position of STOP field.
	USART_CR2_STOP_Msk     = 0x3000     // Bit mask of STOP field.
	USART_CR2_CLKEN_Pos    = 0xb        // Position of CLKEN field.
	USART_CR2_CLKEN_Msk    = 0x800      // Bit mask of CLKEN field.
	USART_CR2_CLKEN        = 0x800      // Bit CLKEN.
	USART_CR2_CPOL_Pos     = 0xa        // Position of CPOL field.
	USART_CR2_CPOL_Msk     = 0x400      // Bit mask of CPOL field.
	USART_CR2_CPOL         = 0x400      // Bit CPOL.
	USART_CR2_CPHA_Pos     = 0x9        // Position of CPHA field.
	USART_CR2_CPHA_Msk     = 0x200      // Bit mask of CPHA field.
	USART_CR2_CPHA         = 0x200      // Bit CPHA.
	USART_CR2_LBCL_Pos     = 0x8        // Position of LBCL field.
	USART_CR2_LBCL_Msk     = 0x100      // Bit mask of LBCL field.
	USART_CR2_LBCL         = 0x100      // Bit LBCL.
	USART_CR2_LBDIE_Pos    = 0x6        // Position of LBDIE field.
	USART_CR2_LBDIE_Msk    = 0x40       // Bit mask of LBDIE field.
	USART_CR2_LBDIE        = 0x40       // Bit LBDIE.
	USART_CR2_LBDL_Pos     = 0x5        // Position of LBDL field.
	USART_CR2_LBDL_Msk     = 0x20       // Bit mask of LBDL field.
	USART_CR2_LBDL         = 0x20       // Bit LBDL.
	USART_CR2_ADDM7_Pos    = 0x4        // Position of ADDM7 field.
	USART_CR2_ADDM7_Msk    = 0x10       // Bit mask of ADDM7 field.
	USART_CR2_ADDM7        = 0x10       // Bit ADDM7.

	// CR3: Control register 3
	USART_CR3_WUFIE_Pos   = 0x16     // Position of WUFIE field.
	USART_CR3_WUFIE_Msk   = 0x400000 // Bit mask of WUFIE field.
	USART_CR3_WUFIE       = 0x400000 // Bit WUFIE.
	USART_CR3_WUS_Pos     = 0x14     // Position of WUS field.
	USART_CR3_WUS_Msk     = 0x300000 // Bit mask of WUS field.
	USART_CR3_SCARCNT_Pos = 0x11     // Position of SCARCNT field.
	USART_CR3_SCARCNT_Msk = 0xe0000  // Bit mask of SCARCNT field.
	USART_CR3_DEP_Pos     = 0xf      // Position of DEP field.
	USART_CR3_DEP_Msk     = 0x8000   // Bit mask of DEP field.
	USART_CR3_DEP         = 0x8000   // Bit DEP.
	USART_CR3_DEM_Pos     = 0xe      // Position of DEM field.
	USART_CR3_DEM_Msk     = 0x4000   // Bit mask of DEM field.
	USART_CR3_DEM         = 0x4000   // Bit DEM.
	USART_CR3_DDRE_Pos    = 0xd      // Position of DDRE field.
	USART_CR3_DDRE_Msk    = 0x2000   // Bit mask of DDRE field.
	USART_CR3_DDRE        = 0x2000   // Bit DDRE.
	USART_CR3_OVRDIS_Pos  = 0xc      // Position of OVRDIS field.
	USART_CR3_OVRDIS_Msk  = 0x1000   // Bit mask of OVRDIS field.
	USART_CR3_OVRDIS      = 0x1000   // Bit OVRDIS.
	USART_CR3_ONEBIT_Pos  = 0xb      // Position of ONEBIT field.
	USART_CR3_ONEBIT_Msk  = 0x800    // Bit mask of ONEBIT field.
	USART_CR3_ONEBIT      = 0x800    // Bit ONEBIT.
	USART_CR3_CTSIE_Pos   = 0xa      // Position of CTSIE field.
	USART_CR3_CTSIE_Msk   = 0x400    // Bit mask of CTSIE field.
	USART_CR3_CTSIE       = 0x400    // Bit CTSIE.
	USART_CR3_CTSE_Pos    = 0x9      // Position of CTSE field.
	USART_CR3_CTSE_Msk    = 0x200    // Bit mask of CTSE field.
	USART_CR3_CTSE        = 0x200    // Bit CTSE.
	USART_CR3_RTSE_Pos    = 0x8      // Position of RTSE field.
	USART_CR3_RTSE_Msk    = 0x100    // Bit mask of RTSE field.
	USART_CR3_RTSE        = 0x100    // Bit RTSE.
	USART_CR3_DMAT_Pos    = 0x7      // Position of DMAT field.
	USART_CR3_DMAT_Msk    = 0x80     // Bit mask of DMAT field.
	USART_CR3_DMAT        = 0x80     // Bit DMAT.
	USART_CR3_DMAR_Pos    = 0x6      // Position of DMAR field.
	USART_CR3_DMAR_Msk    = 0x40     // Bit mask of DMAR field.
	USART_CR3_DMAR        = 0x40     // Bit DMAR.
	USART_CR3_SCEN_Pos    = 0x5      // Position of SCEN field.
	USART_CR3_SCEN_Msk    = 0x20     // Bit mask of SCEN field.
	USART_CR3_SCEN        = 0x20     // Bit SCEN.
	USART_CR3_NACK_Pos    = 0x4      // Position of NACK field.
	USART_CR3_NACK_Msk    = 0x10     // Bit mask of NACK field.
	USART_CR3_NACK        = 0x10     // Bit NACK.
	USART_CR3_HDSEL_Pos   = 0x3      // Position of HDSEL field.
	USART_CR3_HDSEL_Msk   = 0x8      // Bit mask of HDSEL field.
	USART_CR3_HDSEL       = 0x8      // Bit HDSEL.
	USART_CR3_IRLP_Pos    = 0x2      // Position of IRLP field.
	USART_CR3_IRLP_Msk    = 0x4      // Bit mask of IRLP field.
	USART_CR3_IRLP        = 0x4      // Bit IRLP.
	USART_CR3_IREN_Pos    = 0x1      // Position of IREN field.
	USART_CR3_IREN_Msk    = 0x2      // Bit mask of IREN field.
	USART_CR3_IREN        = 0x2      // Bit IREN.
	USART_CR3_EIE_Pos     = 0x0      // Position of EIE field.
	USART_CR3_EIE_Msk     = 0x1      // Bit mask of EIE field.
	USART_CR3_EIE         = 0x1      // Bit EIE.

	// BRR: Baud rate register
	USART_BRR_DIV_Mantissa_Pos = 0x4    // Position of DIV_Mantissa field.
	USART_BRR_DIV_Mantissa_Msk = 0xfff0 // Bit mask of DIV_Mantissa field.
	USART_BRR_DIV_Fraction_Pos = 0x0    // Position of DIV_Fraction field.
	USART_BRR_DIV_Fraction_Msk = 0xf    // Bit mask of DIV_Fraction field.

	// GTPR: Guard time and prescaler           register
	USART_GTPR_GT_Pos  = 0x8    // Position of GT field.
	USART_GTPR_GT_Msk  = 0xff00 // Bit mask of GT field.
	USART_GTPR_PSC_Pos = 0x0    // Position of PSC field.
	USART_GTPR_PSC_Msk = 0xff   // Bit mask of PSC field.

	// RTOR: Receiver timeout register
	USART_RTOR_BLEN_Pos = 0x18       // Position of BLEN field.
	USART_RTOR_BLEN_Msk = 0xff000000 // Bit mask of BLEN field.
	USART_RTOR_RTO_Pos  = 0x0        // Position of RTO field.
	USART_RTOR_RTO_Msk  = 0xffffff   // Bit mask of RTO field.

	// RQR: Request register
	USART_RQR_TXFRQ_Pos = 0x4  // Position of TXFRQ field.
	USART_RQR_TXFRQ_Msk = 0x10 // Bit mask of TXFRQ field.
	USART_RQR_TXFRQ     = 0x10 // Bit TXFRQ.
	USART_RQR_RXFRQ_Pos = 0x3  // Position of RXFRQ field.
	USART_RQR_RXFRQ_Msk = 0x8  // Bit mask of RXFRQ field.
	USART_RQR_RXFRQ     = 0x8  // Bit RXFRQ.
	USART_RQR_MMRQ_Pos  = 0x2  // Position of MMRQ field.
	USART_RQR_MMRQ_Msk  = 0x4  // Bit mask of MMRQ field.
	USART_RQR_MMRQ      = 0x4  // Bit MMRQ.
	USART_RQR_SBKRQ_Pos = 0x1  // Position of SBKRQ field.
	USART_RQR_SBKRQ_Msk = 0x2  // Bit mask of SBKRQ field.
	USART_RQR_SBKRQ     = 0x2  // Bit SBKRQ.
	USART_RQR_ABRRQ_Pos = 0x0  // Position of ABRRQ field.
	USART_RQR_ABRRQ_Msk = 0x1  // Bit mask of ABRRQ field.
	USART_RQR_ABRRQ     = 0x1  // Bit ABRRQ.

	// ISR: Interrupt & status           register
	USART_ISR_REACK_Pos = 0x16     // Position of REACK field.
	USART_ISR_REACK_Msk = 0x400000 // Bit mask of REACK field.
	USART_ISR_REACK     = 0x400000 // Bit REACK.
	USART_ISR_TEACK_Pos = 0x15     // Position of TEACK field.
	USART_ISR_TEACK_Msk = 0x200000 // Bit mask of TEACK field.
	USART_ISR_TEACK     = 0x200000 // Bit TEACK.
	USART_ISR_WUF_Pos   = 0x14     // Position of WUF field.
	USART_ISR_WUF_Msk   = 0x100000 // Bit mask of WUF field.
	USART_ISR_WUF       = 0x100000 // Bit WUF.
	USART_ISR_RWU_Pos   = 0x13     // Position of RWU field.
	USART_ISR_RWU_Msk   = 0x80000  // Bit mask of RWU field.
	USART_ISR_RWU       = 0x80000  // Bit RWU.
	USART_ISR_SBKF_Pos  = 0x12     // Position of SBKF field.
	USART_ISR_SBKF_Msk  = 0x40000  // Bit mask of SBKF field.
	USART_ISR_SBKF      = 0x40000  // Bit SBKF.
	USART_ISR_CMF_Pos   = 0x11     // Position of CMF field.
	USART_ISR_CMF_Msk   = 0x20000  // Bit mask of CMF field.
	USART_ISR_CMF       = 0x20000  // Bit CMF.
	USART_ISR_BUSY_Pos  = 0x10     // Position of BUSY field.
	USART_ISR_BUSY_Msk  = 0x10000  // Bit mask of BUSY field.
	USART_ISR_BUSY      = 0x10000  // Bit BUSY.
	USART_ISR_ABRF_Pos  = 0xf      // Position of ABRF field.
	USART_ISR_ABRF_Msk  = 0x8000   // Bit mask of ABRF field.
	USART_ISR_ABRF      = 0x8000   // Bit ABRF.
	USART_ISR_ABRE_Pos  = 0xe      // Position of ABRE field.
	USART_ISR_ABRE_Msk  = 0x4000   // Bit mask of ABRE field.
	USART_ISR_ABRE      = 0x4000   // Bit ABRE.
	USART_ISR_EOBF_Pos  = 0xc      // Position of EOBF field.
	USART_ISR_EOBF_Msk  = 0x1000   // Bit mask of EOBF field.
	USART_ISR_EOBF      = 0x1000   // Bit EOBF.
	USART_ISR_RTOF_Pos  = 0xb      // Position of RTOF field.
	USART_ISR_RTOF_Msk  = 0x800    // Bit mask of RTOF field.
	USART_ISR_RTOF      = 0x800    // Bit RTOF.
	USART_ISR_CTS_Pos   = 0xa      // Position of CTS field.
	USART_ISR_CTS_Msk   = 0x400    // Bit mask of CTS field.
	USART_ISR_CTS       = 0x400    // Bit CTS.
	USART_ISR_CTSIF_Pos = 0x9      // Position of CTSIF field.
	USART_ISR_CTSIF_Msk = 0x200    // Bit mask of CTSIF field.
	USART_ISR_CTSIF     = 0x200    // Bit CTSIF.
	USART_ISR_LBDF_Pos  = 0x8      // Position of LBDF field.
	USART_ISR_LBDF_Msk  = 0x100    // Bit mask of LBDF field.
	USART_ISR_LBDF      = 0x100    // Bit LBDF.
	USART_ISR_TXE_Pos   = 0x7      // Position of TXE field.
	USART_ISR_TXE_Msk   = 0x80     // Bit mask of TXE field.
	USART_ISR_TXE       = 0x80     // Bit TXE.
	USART_ISR_TC_Pos    = 0x6      // Position of TC field.
	USART_ISR_TC_Msk    = 0x40     // Bit mask of TC field.
	USART_ISR_TC        = 0x40     // Bit TC.
	USART_ISR_RXNE_Pos  = 0x5      // Position of RXNE field.
	USART_ISR_RXNE_Msk  = 0x20     // Bit mask of RXNE field.
	USART_ISR_RXNE      = 0x20     // Bit RXNE.
	USART_ISR_IDLE_Pos  = 0x4      // Position of IDLE field.
	USART_ISR_IDLE_Msk  = 0x10     // Bit mask of IDLE field.
	USART_ISR_IDLE      = 0x10     // Bit IDLE.
	USART_ISR_ORE_Pos   = 0x3      // Position of ORE field.
	USART_ISR_ORE_Msk   = 0x8      // Bit mask of ORE field.
	USART_ISR_ORE       = 0x8      // Bit ORE.
	USART_ISR_NF_Pos    = 0x2      // Position of NF field.
	USART_ISR_NF_Msk    = 0x4      // Bit mask of NF field.
	USART_ISR_NF        = 0x4      // Bit NF.
	USART_ISR_FE_Pos    = 0x1      // Position of FE field.
	USART_ISR_FE_Msk    = 0x2      // Bit mask of FE field.
	USART_ISR_FE        = 0x2      // Bit FE.
	USART_ISR_PE_Pos    = 0x0      // Position of PE field.
	USART_ISR_PE_Msk    = 0x1      // Bit mask of PE field.
	USART_ISR_PE        = 0x1      // Bit PE.

	// ICR: Interrupt flag clear register
	USART_ICR_WUCF_Pos   = 0x14     // Position of WUCF field.
	USART_ICR_WUCF_Msk   = 0x100000 // Bit mask of WUCF field.
	USART_ICR_WUCF       = 0x100000 // Bit WUCF.
	USART_ICR_CMCF_Pos   = 0x11     // Position of CMCF field.
	USART_ICR_CMCF_Msk   = 0x20000  // Bit mask of CMCF field.
	USART_ICR_CMCF       = 0x20000  // Bit CMCF.
	USART_ICR_EOBCF_Pos  = 0xc      // Position of EOBCF field.
	USART_ICR_EOBCF_Msk  = 0x1000   // Bit mask of EOBCF field.
	USART_ICR_EOBCF      = 0x1000   // Bit EOBCF.
	USART_ICR_RTOCF_Pos  = 0xb      // Position of RTOCF field.
	USART_ICR_RTOCF_Msk  = 0x800    // Bit mask of RTOCF field.
	USART_ICR_RTOCF      = 0x800    // Bit RTOCF.
	USART_ICR_CTSCF_Pos  = 0x9      // Position of CTSCF field.
	USART_ICR_CTSCF_Msk  = 0x200    // Bit mask of CTSCF field.
	USART_ICR_CTSCF      = 0x200    // Bit CTSCF.
	USART_ICR_LBDCF_Pos  = 0x8      // Position of LBDCF field.
	USART_ICR_LBDCF_Msk  = 0x100    // Bit mask of LBDCF field.
	USART_ICR_LBDCF      = 0x100    // Bit LBDCF.
	USART_ICR_TCCF_Pos   = 0x6      // Position of TCCF field.
	USART_ICR_TCCF_Msk   = 0x40     // Bit mask of TCCF field.
	USART_ICR_TCCF       = 0x40     // Bit TCCF.
	USART_ICR_IDLECF_Pos = 0x4      // Position of IDLECF field.
	USART_ICR_IDLECF_Msk = 0x10     // Bit mask of IDLECF field.
	USART_ICR_IDLECF     = 0x10     // Bit IDLECF.
	USART_ICR_ORECF_Pos  = 0x3      // Position of ORECF field.
	USART_ICR_ORECF_Msk  = 0x8      // Bit mask of ORECF field.
	USART_ICR_ORECF      = 0x8      // Bit ORECF.
	USART_ICR_NCF_Pos    = 0x2      // Position of NCF field.
	USART_ICR_NCF_Msk    = 0x4      // Bit mask of NCF field.
	USART_ICR_NCF        = 0x4      // Bit NCF.
	USART_ICR_FECF_Pos   = 0x1      // Position of FECF field.
	USART_ICR_FECF_Msk   = 0x2      // Bit mask of FECF field.
	USART_ICR_FECF       = 0x2      // Bit FECF.
	USART_ICR_PECF_Pos   = 0x0      // Position of PECF field.
	USART_ICR_PECF_Msk   = 0x1      // Bit mask of PECF field.
	USART_ICR_PECF       = 0x1      // Bit PECF.

	// RDR: Receive data register
	USART_RDR_RDR_Pos = 0x0   // Position of RDR field.
	USART_RDR_RDR_Msk = 0x1ff // Bit mask of RDR field.

	// TDR: Transmit data register
	USART_TDR_TDR_Pos = 0x0   // Position of TDR field.
	USART_TDR_TDR_Msk = 0x1ff // Bit mask of TDR field.
)

// Bitfields for IWDG: Independent watchdog
const (
	// KR: Key register
	IWDG_KR_KEY_Pos = 0x0    // Position of KEY field.
	IWDG_KR_KEY_Msk = 0xffff // Bit mask of KEY field.

	// PR: Prescaler register
	IWDG_PR_PR_Pos = 0x0 // Position of PR field.
	IWDG_PR_PR_Msk = 0x7 // Bit mask of PR field.

	// RLR: Reload register
	IWDG_RLR_RL_Pos = 0x0   // Position of RL field.
	IWDG_RLR_RL_Msk = 0xfff // Bit mask of RL field.

	// SR: Status register
	IWDG_SR_WVU_Pos = 0x2 // Position of WVU field.
	IWDG_SR_WVU_Msk = 0x4 // Bit mask of WVU field.
	IWDG_SR_WVU     = 0x4 // Bit WVU.
	IWDG_SR_RVU_Pos = 0x1 // Position of RVU field.
	IWDG_SR_RVU_Msk = 0x2 // Bit mask of RVU field.
	IWDG_SR_RVU     = 0x2 // Bit RVU.
	IWDG_SR_PVU_Pos = 0x0 // Position of PVU field.
	IWDG_SR_PVU_Msk = 0x1 // Bit mask of PVU field.
	IWDG_SR_PVU     = 0x1 // Bit PVU.

	// WINR: Window register
	IWDG_WINR_WIN_Pos = 0x0   // Position of WIN field.
	IWDG_WINR_WIN_Msk = 0xfff // Bit mask of WIN field.
)

// Bitfields for WWDG: System window watchdog
const (
	// CR: Control register
	WWDG_CR_WDGA_Pos = 0x7  // Position of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80 // Bit mask of WDGA field.
	WWDG_CR_WDGA     = 0x80 // Bit WDGA.
	WWDG_CR_T_Pos    = 0x0  // Position of T field.
	WWDG_CR_T_Msk    = 0x7f // Bit mask of T field.

	// CFR: Configuration register
	WWDG_CFR_EWI_Pos    = 0x9   // Position of EWI field.
	WWDG_CFR_EWI_Msk    = 0x200 // Bit mask of EWI field.
	WWDG_CFR_EWI        = 0x200 // Bit EWI.
	WWDG_CFR_WDGTB1_Pos = 0x8   // Position of WDGTB1 field.
	WWDG_CFR_WDGTB1_Msk = 0x100 // Bit mask of WDGTB1 field.
	WWDG_CFR_WDGTB1     = 0x100 // Bit WDGTB1.
	WWDG_CFR_WDGTB0_Pos = 0x7   // Position of WDGTB0 field.
	WWDG_CFR_WDGTB0_Msk = 0x80  // Bit mask of WDGTB0 field.
	WWDG_CFR_WDGTB0     = 0x80  // Bit WDGTB0.
	WWDG_CFR_W_Pos      = 0x0   // Position of W field.
	WWDG_CFR_W_Msk      = 0x7f  // Bit mask of W field.

	// SR: Status register
	WWDG_SR_EWIF_Pos = 0x0 // Position of EWIF field.
	WWDG_SR_EWIF_Msk = 0x1 // Bit mask of EWIF field.
	WWDG_SR_EWIF     = 0x1 // Bit EWIF.
)

// Bitfields for Firewall: Firewall
const (
	// FIREWALL_CSSA: Code segment start address
	Firewall_FIREWALL_CSSA_ADD_Pos = 0x8      // Position of ADD field.
	Firewall_FIREWALL_CSSA_ADD_Msk = 0xffff00 // Bit mask of ADD field.

	// FIREWALL_CSL: Code segment length
	Firewall_FIREWALL_CSL_LENG_Pos = 0x8      // Position of LENG field.
	Firewall_FIREWALL_CSL_LENG_Msk = 0x3fff00 // Bit mask of LENG field.

	// FIREWALL_NVDSSA: Non-volatile data segment start           address
	Firewall_FIREWALL_NVDSSA_ADD_Pos = 0x8      // Position of ADD field.
	Firewall_FIREWALL_NVDSSA_ADD_Msk = 0xffff00 // Bit mask of ADD field.

	// FIREWALL_NVDSL: Non-volatile data segment           length
	Firewall_FIREWALL_NVDSL_LENG_Pos = 0x8      // Position of LENG field.
	Firewall_FIREWALL_NVDSL_LENG_Msk = 0x3fff00 // Bit mask of LENG field.

	// FIREWALL_VDSSA: Volatile data segment start           address
	Firewall_FIREWALL_VDSSA_ADD_Pos = 0x6    // Position of ADD field.
	Firewall_FIREWALL_VDSSA_ADD_Msk = 0xffc0 // Bit mask of ADD field.

	// FIREWALL_VDSL: Volatile data segment length
	Firewall_FIREWALL_VDSL_LENG_Pos = 0x6    // Position of LENG field.
	Firewall_FIREWALL_VDSL_LENG_Msk = 0xffc0 // Bit mask of LENG field.

	// FIREWALL_CR: Configuration register
	Firewall_FIREWALL_CR_VDE_Pos = 0x2 // Position of VDE field.
	Firewall_FIREWALL_CR_VDE_Msk = 0x4 // Bit mask of VDE field.
	Firewall_FIREWALL_CR_VDE     = 0x4 // Bit VDE.
	Firewall_FIREWALL_CR_VDS_Pos = 0x1 // Position of VDS field.
	Firewall_FIREWALL_CR_VDS_Msk = 0x2 // Bit mask of VDS field.
	Firewall_FIREWALL_CR_VDS     = 0x2 // Bit VDS.
	Firewall_FIREWALL_CR_FPA_Pos = 0x0 // Position of FPA field.
	Firewall_FIREWALL_CR_FPA_Msk = 0x1 // Bit mask of FPA field.
	Firewall_FIREWALL_CR_FPA     = 0x1 // Bit FPA.
)

// Bitfields for RCC: Reset and clock control
const (
	// CR: Clock control register
	RCC_CR_PLLRDY_Pos     = 0x19      // Position of PLLRDY field.
	RCC_CR_PLLRDY_Msk     = 0x2000000 // Bit mask of PLLRDY field.
	RCC_CR_PLLRDY         = 0x2000000 // Bit PLLRDY.
	RCC_CR_PLLON_Pos      = 0x18      // Position of PLLON field.
	RCC_CR_PLLON_Msk      = 0x1000000 // Bit mask of PLLON field.
	RCC_CR_PLLON          = 0x1000000 // Bit PLLON.
	RCC_CR_RTCPRE_Pos     = 0x14      // Position of RTCPRE field.
	RCC_CR_RTCPRE_Msk     = 0x300000  // Bit mask of RTCPRE field.
	RCC_CR_CSSLSEON_Pos   = 0x13      // Position of CSSLSEON field.
	RCC_CR_CSSLSEON_Msk   = 0x80000   // Bit mask of CSSLSEON field.
	RCC_CR_CSSLSEON       = 0x80000   // Bit CSSLSEON.
	RCC_CR_HSEBYP_Pos     = 0x12      // Position of HSEBYP field.
	RCC_CR_HSEBYP_Msk     = 0x40000   // Bit mask of HSEBYP field.
	RCC_CR_HSEBYP         = 0x40000   // Bit HSEBYP.
	RCC_CR_HSERDY_Pos     = 0x11      // Position of HSERDY field.
	RCC_CR_HSERDY_Msk     = 0x20000   // Bit mask of HSERDY field.
	RCC_CR_HSERDY         = 0x20000   // Bit HSERDY.
	RCC_CR_HSEON_Pos      = 0x10      // Position of HSEON field.
	RCC_CR_HSEON_Msk      = 0x10000   // Bit mask of HSEON field.
	RCC_CR_HSEON          = 0x10000   // Bit HSEON.
	RCC_CR_MSIRDY_Pos     = 0x9       // Position of MSIRDY field.
	RCC_CR_MSIRDY_Msk     = 0x200     // Bit mask of MSIRDY field.
	RCC_CR_MSIRDY         = 0x200     // Bit MSIRDY.
	RCC_CR_MSION_Pos      = 0x8       // Position of MSION field.
	RCC_CR_MSION_Msk      = 0x100     // Bit mask of MSION field.
	RCC_CR_MSION          = 0x100     // Bit MSION.
	RCC_CR_HSI16DIVF_Pos  = 0x4       // Position of HSI16DIVF field.
	RCC_CR_HSI16DIVF_Msk  = 0x10      // Bit mask of HSI16DIVF field.
	RCC_CR_HSI16DIVF      = 0x10      // Bit HSI16DIVF.
	RCC_CR_HSI16DIVEN_Pos = 0x3       // Position of HSI16DIVEN field.
	RCC_CR_HSI16DIVEN_Msk = 0x8       // Bit mask of HSI16DIVEN field.
	RCC_CR_HSI16DIVEN     = 0x8       // Bit HSI16DIVEN.
	RCC_CR_HSI16RDYF_Pos  = 0x2       // Position of HSI16RDYF field.
	RCC_CR_HSI16RDYF_Msk  = 0x4       // Bit mask of HSI16RDYF field.
	RCC_CR_HSI16RDYF      = 0x4       // Bit HSI16RDYF.
	RCC_CR_HSI16KERON_Pos = 0x1       // Position of HSI16KERON field.
	RCC_CR_HSI16KERON_Msk = 0x2       // Bit mask of HSI16KERON field.
	RCC_CR_HSI16KERON     = 0x2       // Bit HSI16KERON.
	RCC_CR_HSI16ON_Pos    = 0x0       // Position of HSI16ON field.
	RCC_CR_HSI16ON_Msk    = 0x1       // Bit mask of HSI16ON field.
	RCC_CR_HSI16ON        = 0x1       // Bit HSI16ON.
	RCC_CR_HSI16OUTEN_Pos = 0x5       // Position of HSI16OUTEN field.
	RCC_CR_HSI16OUTEN_Msk = 0x20      // Bit mask of HSI16OUTEN field.
	RCC_CR_HSI16OUTEN     = 0x20      // Bit HSI16OUTEN.

	// ICSCR: Internal clock sources calibration           register
	RCC_ICSCR_MSITRIM_Pos   = 0x18       // Position of MSITRIM field.
	RCC_ICSCR_MSITRIM_Msk   = 0xff000000 // Bit mask of MSITRIM field.
	RCC_ICSCR_MSICAL_Pos    = 0x10       // Position of MSICAL field.
	RCC_ICSCR_MSICAL_Msk    = 0xff0000   // Bit mask of MSICAL field.
	RCC_ICSCR_MSIRANGE_Pos  = 0xd        // Position of MSIRANGE field.
	RCC_ICSCR_MSIRANGE_Msk  = 0xe000     // Bit mask of MSIRANGE field.
	RCC_ICSCR_HSI16TRIM_Pos = 0x8        // Position of HSI16TRIM field.
	RCC_ICSCR_HSI16TRIM_Msk = 0x1f00     // Bit mask of HSI16TRIM field.
	RCC_ICSCR_HSI16CAL_Pos  = 0x0        // Position of HSI16CAL field.
	RCC_ICSCR_HSI16CAL_Msk  = 0xff       // Bit mask of HSI16CAL field.

	// CFGR: Clock configuration register
	RCC_CFGR_MCOPRE_Pos   = 0x1c       // Position of MCOPRE field.
	RCC_CFGR_MCOPRE_Msk   = 0x70000000 // Bit mask of MCOPRE field.
	RCC_CFGR_MCOSEL_Pos   = 0x18       // Position of MCOSEL field.
	RCC_CFGR_MCOSEL_Msk   = 0x7000000  // Bit mask of MCOSEL field.
	RCC_CFGR_PLLDIV_Pos   = 0x16       // Position of PLLDIV field.
	RCC_CFGR_PLLDIV_Msk   = 0xc00000   // Bit mask of PLLDIV field.
	RCC_CFGR_PLLMUL_Pos   = 0x12       // Position of PLLMUL field.
	RCC_CFGR_PLLMUL_Msk   = 0x3c0000   // Bit mask of PLLMUL field.
	RCC_CFGR_PLLSRC_Pos   = 0x10       // Position of PLLSRC field.
	RCC_CFGR_PLLSRC_Msk   = 0x10000    // Bit mask of PLLSRC field.
	RCC_CFGR_PLLSRC       = 0x10000    // Bit PLLSRC.
	RCC_CFGR_STOPWUCK_Pos = 0xf        // Position of STOPWUCK field.
	RCC_CFGR_STOPWUCK_Msk = 0x8000     // Bit mask of STOPWUCK field.
	RCC_CFGR_STOPWUCK     = 0x8000     // Bit STOPWUCK.
	RCC_CFGR_PPRE2_Pos    = 0xb        // Position of PPRE2 field.
	RCC_CFGR_PPRE2_Msk    = 0x3800     // Bit mask of PPRE2 field.
	RCC_CFGR_PPRE1_Pos    = 0x8        // Position of PPRE1 field.
	RCC_CFGR_PPRE1_Msk    = 0x700      // Bit mask of PPRE1 field.
	RCC_CFGR_HPRE_Pos     = 0x4        // Position of HPRE field.
	RCC_CFGR_HPRE_Msk     = 0xf0       // Bit mask of HPRE field.
	RCC_CFGR_SWS_Pos      = 0x2        // Position of SWS field.
	RCC_CFGR_SWS_Msk      = 0xc        // Bit mask of SWS field.
	RCC_CFGR_SW_Pos       = 0x0        // Position of SW field.
	RCC_CFGR_SW_Msk       = 0x3        // Bit mask of SW field.

	// CIER: Clock interrupt enable           register
	RCC_CIER_CSSLSE_Pos     = 0x7  // Position of CSSLSE field.
	RCC_CIER_CSSLSE_Msk     = 0x80 // Bit mask of CSSLSE field.
	RCC_CIER_CSSLSE         = 0x80 // Bit CSSLSE.
	RCC_CIER_MSIRDYIE_Pos   = 0x5  // Position of MSIRDYIE field.
	RCC_CIER_MSIRDYIE_Msk   = 0x20 // Bit mask of MSIRDYIE field.
	RCC_CIER_MSIRDYIE       = 0x20 // Bit MSIRDYIE.
	RCC_CIER_PLLRDYIE_Pos   = 0x4  // Position of PLLRDYIE field.
	RCC_CIER_PLLRDYIE_Msk   = 0x10 // Bit mask of PLLRDYIE field.
	RCC_CIER_PLLRDYIE       = 0x10 // Bit PLLRDYIE.
	RCC_CIER_HSERDYIE_Pos   = 0x3  // Position of HSERDYIE field.
	RCC_CIER_HSERDYIE_Msk   = 0x8  // Bit mask of HSERDYIE field.
	RCC_CIER_HSERDYIE       = 0x8  // Bit HSERDYIE.
	RCC_CIER_HSI16RDYIE_Pos = 0x2  // Position of HSI16RDYIE field.
	RCC_CIER_HSI16RDYIE_Msk = 0x4  // Bit mask of HSI16RDYIE field.
	RCC_CIER_HSI16RDYIE     = 0x4  // Bit HSI16RDYIE.
	RCC_CIER_LSERDYIE_Pos   = 0x1  // Position of LSERDYIE field.
	RCC_CIER_LSERDYIE_Msk   = 0x2  // Bit mask of LSERDYIE field.
	RCC_CIER_LSERDYIE       = 0x2  // Bit LSERDYIE.
	RCC_CIER_LSIRDYIE_Pos   = 0x0  // Position of LSIRDYIE field.
	RCC_CIER_LSIRDYIE_Msk   = 0x1  // Bit mask of LSIRDYIE field.
	RCC_CIER_LSIRDYIE       = 0x1  // Bit LSIRDYIE.

	// CIFR: Clock interrupt flag register
	RCC_CIFR_CSSHSEF_Pos   = 0x8   // Position of CSSHSEF field.
	RCC_CIFR_CSSHSEF_Msk   = 0x100 // Bit mask of CSSHSEF field.
	RCC_CIFR_CSSHSEF       = 0x100 // Bit CSSHSEF.
	RCC_CIFR_CSSLSEF_Pos   = 0x7   // Position of CSSLSEF field.
	RCC_CIFR_CSSLSEF_Msk   = 0x80  // Bit mask of CSSLSEF field.
	RCC_CIFR_CSSLSEF       = 0x80  // Bit CSSLSEF.
	RCC_CIFR_MSIRDYF_Pos   = 0x5   // Position of MSIRDYF field.
	RCC_CIFR_MSIRDYF_Msk   = 0x20  // Bit mask of MSIRDYF field.
	RCC_CIFR_MSIRDYF       = 0x20  // Bit MSIRDYF.
	RCC_CIFR_PLLRDYF_Pos   = 0x4   // Position of PLLRDYF field.
	RCC_CIFR_PLLRDYF_Msk   = 0x10  // Bit mask of PLLRDYF field.
	RCC_CIFR_PLLRDYF       = 0x10  // Bit PLLRDYF.
	RCC_CIFR_HSERDYF_Pos   = 0x3   // Position of HSERDYF field.
	RCC_CIFR_HSERDYF_Msk   = 0x8   // Bit mask of HSERDYF field.
	RCC_CIFR_HSERDYF       = 0x8   // Bit HSERDYF.
	RCC_CIFR_HSI16RDYF_Pos = 0x2   // Position of HSI16RDYF field.
	RCC_CIFR_HSI16RDYF_Msk = 0x4   // Bit mask of HSI16RDYF field.
	RCC_CIFR_HSI16RDYF     = 0x4   // Bit HSI16RDYF.
	RCC_CIFR_LSERDYF_Pos   = 0x1   // Position of LSERDYF field.
	RCC_CIFR_LSERDYF_Msk   = 0x2   // Bit mask of LSERDYF field.
	RCC_CIFR_LSERDYF       = 0x2   // Bit LSERDYF.
	RCC_CIFR_LSIRDYF_Pos   = 0x0   // Position of LSIRDYF field.
	RCC_CIFR_LSIRDYF_Msk   = 0x1   // Bit mask of LSIRDYF field.
	RCC_CIFR_LSIRDYF       = 0x1   // Bit LSIRDYF.

	// CICR: Clock interrupt clear register
	RCC_CICR_CSSHSEC_Pos   = 0x8   // Position of CSSHSEC field.
	RCC_CICR_CSSHSEC_Msk   = 0x100 // Bit mask of CSSHSEC field.
	RCC_CICR_CSSHSEC       = 0x100 // Bit CSSHSEC.
	RCC_CICR_CSSLSEC_Pos   = 0x7   // Position of CSSLSEC field.
	RCC_CICR_CSSLSEC_Msk   = 0x80  // Bit mask of CSSLSEC field.
	RCC_CICR_CSSLSEC       = 0x80  // Bit CSSLSEC.
	RCC_CICR_MSIRDYC_Pos   = 0x5   // Position of MSIRDYC field.
	RCC_CICR_MSIRDYC_Msk   = 0x20  // Bit mask of MSIRDYC field.
	RCC_CICR_MSIRDYC       = 0x20  // Bit MSIRDYC.
	RCC_CICR_PLLRDYC_Pos   = 0x4   // Position of PLLRDYC field.
	RCC_CICR_PLLRDYC_Msk   = 0x10  // Bit mask of PLLRDYC field.
	RCC_CICR_PLLRDYC       = 0x10  // Bit PLLRDYC.
	RCC_CICR_HSERDYC_Pos   = 0x3   // Position of HSERDYC field.
	RCC_CICR_HSERDYC_Msk   = 0x8   // Bit mask of HSERDYC field.
	RCC_CICR_HSERDYC       = 0x8   // Bit HSERDYC.
	RCC_CICR_HSI16RDYC_Pos = 0x2   // Position of HSI16RDYC field.
	RCC_CICR_HSI16RDYC_Msk = 0x4   // Bit mask of HSI16RDYC field.
	RCC_CICR_HSI16RDYC     = 0x4   // Bit HSI16RDYC.
	RCC_CICR_LSERDYC_Pos   = 0x1   // Position of LSERDYC field.
	RCC_CICR_LSERDYC_Msk   = 0x2   // Bit mask of LSERDYC field.
	RCC_CICR_LSERDYC       = 0x2   // Bit LSERDYC.
	RCC_CICR_LSIRDYC_Pos   = 0x0   // Position of LSIRDYC field.
	RCC_CICR_LSIRDYC_Msk   = 0x1   // Bit mask of LSIRDYC field.
	RCC_CICR_LSIRDYC       = 0x1   // Bit LSIRDYC.

	// IOPRSTR: GPIO reset register
	RCC_IOPRSTR_IOPHRST_Pos = 0x7  // Position of IOPHRST field.
	RCC_IOPRSTR_IOPHRST_Msk = 0x80 // Bit mask of IOPHRST field.
	RCC_IOPRSTR_IOPHRST     = 0x80 // Bit IOPHRST.
	RCC_IOPRSTR_IOPDRST_Pos = 0x3  // Position of IOPDRST field.
	RCC_IOPRSTR_IOPDRST_Msk = 0x8  // Bit mask of IOPDRST field.
	RCC_IOPRSTR_IOPDRST     = 0x8  // Bit IOPDRST.
	RCC_IOPRSTR_IOPCRST_Pos = 0x2  // Position of IOPCRST field.
	RCC_IOPRSTR_IOPCRST_Msk = 0x4  // Bit mask of IOPCRST field.
	RCC_IOPRSTR_IOPCRST     = 0x4  // Bit IOPCRST.
	RCC_IOPRSTR_IOPBRST_Pos = 0x1  // Position of IOPBRST field.
	RCC_IOPRSTR_IOPBRST_Msk = 0x2  // Bit mask of IOPBRST field.
	RCC_IOPRSTR_IOPBRST     = 0x2  // Bit IOPBRST.
	RCC_IOPRSTR_IOPARST_Pos = 0x0  // Position of IOPARST field.
	RCC_IOPRSTR_IOPARST_Msk = 0x1  // Bit mask of IOPARST field.
	RCC_IOPRSTR_IOPARST     = 0x1  // Bit IOPARST.
	RCC_IOPRSTR_IOPERST_Pos = 0x4  // Position of IOPERST field.
	RCC_IOPRSTR_IOPERST_Msk = 0x10 // Bit mask of IOPERST field.
	RCC_IOPRSTR_IOPERST     = 0x10 // Bit IOPERST.

	// AHBRSTR: AHB peripheral reset register
	RCC_AHBRSTR_CRYPRST_Pos = 0x18      // Position of CRYPRST field.
	RCC_AHBRSTR_CRYPRST_Msk = 0x1000000 // Bit mask of CRYPRST field.
	RCC_AHBRSTR_CRYPRST     = 0x1000000 // Bit CRYPRST.
	RCC_AHBRSTR_CRCRST_Pos  = 0xc       // Position of CRCRST field.
	RCC_AHBRSTR_CRCRST_Msk  = 0x1000    // Bit mask of CRCRST field.
	RCC_AHBRSTR_CRCRST      = 0x1000    // Bit CRCRST.
	RCC_AHBRSTR_MIFRST_Pos  = 0x8       // Position of MIFRST field.
	RCC_AHBRSTR_MIFRST_Msk  = 0x100     // Bit mask of MIFRST field.
	RCC_AHBRSTR_MIFRST      = 0x100     // Bit MIFRST.
	RCC_AHBRSTR_DMARST_Pos  = 0x0       // Position of DMARST field.
	RCC_AHBRSTR_DMARST_Msk  = 0x1       // Bit mask of DMARST field.
	RCC_AHBRSTR_DMARST      = 0x1       // Bit DMARST.

	// APB2RSTR: APB2 peripheral reset register
	RCC_APB2RSTR_DBGRST_Pos    = 0x16     // Position of DBGRST field.
	RCC_APB2RSTR_DBGRST_Msk    = 0x400000 // Bit mask of DBGRST field.
	RCC_APB2RSTR_DBGRST        = 0x400000 // Bit DBGRST.
	RCC_APB2RSTR_USART1RST_Pos = 0xe      // Position of USART1RST field.
	RCC_APB2RSTR_USART1RST_Msk = 0x4000   // Bit mask of USART1RST field.
	RCC_APB2RSTR_USART1RST     = 0x4000   // Bit USART1RST.
	RCC_APB2RSTR_SPI1RST_Pos   = 0xc      // Position of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Msk   = 0x1000   // Bit mask of SPI1RST field.
	RCC_APB2RSTR_SPI1RST       = 0x1000   // Bit SPI1RST.
	RCC_APB2RSTR_ADCRST_Pos    = 0x9      // Position of ADCRST field.
	RCC_APB2RSTR_ADCRST_Msk    = 0x200    // Bit mask of ADCRST field.
	RCC_APB2RSTR_ADCRST        = 0x200    // Bit ADCRST.
	RCC_APB2RSTR_TIM22RST_Pos  = 0x5      // Position of TIM22RST field.
	RCC_APB2RSTR_TIM22RST_Msk  = 0x20     // Bit mask of TIM22RST field.
	RCC_APB2RSTR_TIM22RST      = 0x20     // Bit TIM22RST.
	RCC_APB2RSTR_TIM21RST_Pos  = 0x2      // Position of TIM21RST field.
	RCC_APB2RSTR_TIM21RST_Msk  = 0x4      // Bit mask of TIM21RST field.
	RCC_APB2RSTR_TIM21RST      = 0x4      // Bit TIM21RST.
	RCC_APB2RSTR_SYSCFGRST_Pos = 0x0      // Position of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Msk = 0x1      // Bit mask of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST     = 0x1      // Bit SYSCFGRST.

	// APB1RSTR: APB1 peripheral reset register
	RCC_APB1RSTR_LPTIM1RST_Pos  = 0x1f       // Position of LPTIM1RST field.
	RCC_APB1RSTR_LPTIM1RST_Msk  = 0x80000000 // Bit mask of LPTIM1RST field.
	RCC_APB1RSTR_LPTIM1RST      = 0x80000000 // Bit LPTIM1RST.
	RCC_APB1RSTR_PWRRST_Pos     = 0x1c       // Position of PWRRST field.
	RCC_APB1RSTR_PWRRST_Msk     = 0x10000000 // Bit mask of PWRRST field.
	RCC_APB1RSTR_PWRRST         = 0x10000000 // Bit PWRRST.
	RCC_APB1RSTR_I2C2RST_Pos    = 0x16       // Position of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Msk    = 0x400000   // Bit mask of I2C2RST field.
	RCC_APB1RSTR_I2C2RST        = 0x400000   // Bit I2C2RST.
	RCC_APB1RSTR_I2C1RST_Pos    = 0x15       // Position of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Msk    = 0x200000   // Bit mask of I2C1RST field.
	RCC_APB1RSTR_I2C1RST        = 0x200000   // Bit I2C1RST.
	RCC_APB1RSTR_LPUART1RST_Pos = 0x12       // Position of LPUART1RST field.
	RCC_APB1RSTR_LPUART1RST_Msk = 0x40000    // Bit mask of LPUART1RST field.
	RCC_APB1RSTR_LPUART1RST     = 0x40000    // Bit LPUART1RST.
	RCC_APB1RSTR_USART2RST_Pos  = 0x11       // Position of USART2RST field.
	RCC_APB1RSTR_USART2RST_Msk  = 0x20000    // Bit mask of USART2RST field.
	RCC_APB1RSTR_USART2RST      = 0x20000    // Bit USART2RST.
	RCC_APB1RSTR_SPI2RST_Pos    = 0xe        // Position of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Msk    = 0x4000     // Bit mask of SPI2RST field.
	RCC_APB1RSTR_SPI2RST        = 0x4000     // Bit SPI2RST.
	RCC_APB1RSTR_WWDGRST_Pos    = 0xb        // Position of WWDGRST field.
	RCC_APB1RSTR_WWDGRST_Msk    = 0x800      // Bit mask of WWDGRST field.
	RCC_APB1RSTR_WWDGRST        = 0x800      // Bit WWDGRST.
	RCC_APB1RSTR_TIM6RST_Pos    = 0x4        // Position of TIM6RST field.
	RCC_APB1RSTR_TIM6RST_Msk    = 0x10       // Bit mask of TIM6RST field.
	RCC_APB1RSTR_TIM6RST        = 0x10       // Bit TIM6RST.
	RCC_APB1RSTR_TIM2RST_Pos    = 0x0        // Position of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Msk    = 0x1        // Bit mask of TIM2RST field.
	RCC_APB1RSTR_TIM2RST        = 0x1        // Bit TIM2RST.
	RCC_APB1RSTR_TIM3RST_Pos    = 0x1        // Position of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Msk    = 0x2        // Bit mask of TIM3RST field.
	RCC_APB1RSTR_TIM3RST        = 0x2        // Bit TIM3RST.
	RCC_APB1RSTR_TIM7RST_Pos    = 0x5        // Position of TIM7RST field.
	RCC_APB1RSTR_TIM7RST_Msk    = 0x20       // Bit mask of TIM7RST field.
	RCC_APB1RSTR_TIM7RST        = 0x20       // Bit TIM7RST.
	RCC_APB1RSTR_USART4RST_Pos  = 0x13       // Position of USART4RST field.
	RCC_APB1RSTR_USART4RST_Msk  = 0x80000    // Bit mask of USART4RST field.
	RCC_APB1RSTR_USART4RST      = 0x80000    // Bit USART4RST.
	RCC_APB1RSTR_USART5RST_Pos  = 0x14       // Position of USART5RST field.
	RCC_APB1RSTR_USART5RST_Msk  = 0x100000   // Bit mask of USART5RST field.
	RCC_APB1RSTR_USART5RST      = 0x100000   // Bit USART5RST.
	RCC_APB1RSTR_CRCRST_Pos     = 0x1b       // Position of CRCRST field.
	RCC_APB1RSTR_CRCRST_Msk     = 0x8000000  // Bit mask of CRCRST field.
	RCC_APB1RSTR_CRCRST         = 0x8000000  // Bit CRCRST.
	RCC_APB1RSTR_I2C3_Pos       = 0x1e       // Position of I2C3 field.
	RCC_APB1RSTR_I2C3_Msk       = 0x40000000 // Bit mask of I2C3 field.
	RCC_APB1RSTR_I2C3           = 0x40000000 // Bit I2C3.

	// IOPENR: GPIO clock enable register
	RCC_IOPENR_IOPHEN_Pos = 0x7  // Position of IOPHEN field.
	RCC_IOPENR_IOPHEN_Msk = 0x80 // Bit mask of IOPHEN field.
	RCC_IOPENR_IOPHEN     = 0x80 // Bit IOPHEN.
	RCC_IOPENR_IOPDEN_Pos = 0x3  // Position of IOPDEN field.
	RCC_IOPENR_IOPDEN_Msk = 0x8  // Bit mask of IOPDEN field.
	RCC_IOPENR_IOPDEN     = 0x8  // Bit IOPDEN.
	RCC_IOPENR_IOPCEN_Pos = 0x2  // Position of IOPCEN field.
	RCC_IOPENR_IOPCEN_Msk = 0x4  // Bit mask of IOPCEN field.
	RCC_IOPENR_IOPCEN     = 0x4  // Bit IOPCEN.
	RCC_IOPENR_IOPBEN_Pos = 0x1  // Position of IOPBEN field.
	RCC_IOPENR_IOPBEN_Msk = 0x2  // Bit mask of IOPBEN field.
	RCC_IOPENR_IOPBEN     = 0x2  // Bit IOPBEN.
	RCC_IOPENR_IOPAEN_Pos = 0x0  // Position of IOPAEN field.
	RCC_IOPENR_IOPAEN_Msk = 0x1  // Bit mask of IOPAEN field.
	RCC_IOPENR_IOPAEN     = 0x1  // Bit IOPAEN.
	RCC_IOPENR_IOPEEN_Pos = 0x4  // Position of IOPEEN field.
	RCC_IOPENR_IOPEEN_Msk = 0x10 // Bit mask of IOPEEN field.
	RCC_IOPENR_IOPEEN     = 0x10 // Bit IOPEEN.

	// AHBENR: AHB peripheral clock enable           register
	RCC_AHBENR_CRYPEN_Pos = 0x18      // Position of CRYPEN field.
	RCC_AHBENR_CRYPEN_Msk = 0x1000000 // Bit mask of CRYPEN field.
	RCC_AHBENR_CRYPEN     = 0x1000000 // Bit CRYPEN.
	RCC_AHBENR_CRCEN_Pos  = 0xc       // Position of CRCEN field.
	RCC_AHBENR_CRCEN_Msk  = 0x1000    // Bit mask of CRCEN field.
	RCC_AHBENR_CRCEN      = 0x1000    // Bit CRCEN.
	RCC_AHBENR_MIFEN_Pos  = 0x8       // Position of MIFEN field.
	RCC_AHBENR_MIFEN_Msk  = 0x100     // Bit mask of MIFEN field.
	RCC_AHBENR_MIFEN      = 0x100     // Bit MIFEN.
	RCC_AHBENR_DMAEN_Pos  = 0x0       // Position of DMAEN field.
	RCC_AHBENR_DMAEN_Msk  = 0x1       // Bit mask of DMAEN field.
	RCC_AHBENR_DMAEN      = 0x1       // Bit DMAEN.

	// APB2ENR: APB2 peripheral clock enable           register
	RCC_APB2ENR_DBGEN_Pos    = 0x16     // Position of DBGEN field.
	RCC_APB2ENR_DBGEN_Msk    = 0x400000 // Bit mask of DBGEN field.
	RCC_APB2ENR_DBGEN        = 0x400000 // Bit DBGEN.
	RCC_APB2ENR_USART1EN_Pos = 0xe      // Position of USART1EN field.
	RCC_APB2ENR_USART1EN_Msk = 0x4000   // Bit mask of USART1EN field.
	RCC_APB2ENR_USART1EN     = 0x4000   // Bit USART1EN.
	RCC_APB2ENR_SPI1EN_Pos   = 0xc      // Position of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Msk   = 0x1000   // Bit mask of SPI1EN field.
	RCC_APB2ENR_SPI1EN       = 0x1000   // Bit SPI1EN.
	RCC_APB2ENR_ADCEN_Pos    = 0x9      // Position of ADCEN field.
	RCC_APB2ENR_ADCEN_Msk    = 0x200    // Bit mask of ADCEN field.
	RCC_APB2ENR_ADCEN        = 0x200    // Bit ADCEN.
	RCC_APB2ENR_FWEN_Pos     = 0x7      // Position of FWEN field.
	RCC_APB2ENR_FWEN_Msk     = 0x80     // Bit mask of FWEN field.
	RCC_APB2ENR_FWEN         = 0x80     // Bit FWEN.
	RCC_APB2ENR_TIM22EN_Pos  = 0x5      // Position of TIM22EN field.
	RCC_APB2ENR_TIM22EN_Msk  = 0x20     // Bit mask of TIM22EN field.
	RCC_APB2ENR_TIM22EN      = 0x20     // Bit TIM22EN.
	RCC_APB2ENR_TIM21EN_Pos  = 0x2      // Position of TIM21EN field.
	RCC_APB2ENR_TIM21EN_Msk  = 0x4      // Bit mask of TIM21EN field.
	RCC_APB2ENR_TIM21EN      = 0x4      // Bit TIM21EN.
	RCC_APB2ENR_SYSCFGEN_Pos = 0x0      // Position of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Msk = 0x1      // Bit mask of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN     = 0x1      // Bit SYSCFGEN.

	// APB1ENR: APB1 peripheral clock enable           register
	RCC_APB1ENR_LPTIM1EN_Pos  = 0x1f       // Position of LPTIM1EN field.
	RCC_APB1ENR_LPTIM1EN_Msk  = 0x80000000 // Bit mask of LPTIM1EN field.
	RCC_APB1ENR_LPTIM1EN      = 0x80000000 // Bit LPTIM1EN.
	RCC_APB1ENR_PWREN_Pos     = 0x1c       // Position of PWREN field.
	RCC_APB1ENR_PWREN_Msk     = 0x10000000 // Bit mask of PWREN field.
	RCC_APB1ENR_PWREN         = 0x10000000 // Bit PWREN.
	RCC_APB1ENR_I2C2EN_Pos    = 0x16       // Position of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Msk    = 0x400000   // Bit mask of I2C2EN field.
	RCC_APB1ENR_I2C2EN        = 0x400000   // Bit I2C2EN.
	RCC_APB1ENR_I2C1EN_Pos    = 0x15       // Position of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Msk    = 0x200000   // Bit mask of I2C1EN field.
	RCC_APB1ENR_I2C1EN        = 0x200000   // Bit I2C1EN.
	RCC_APB1ENR_LPUART1EN_Pos = 0x12       // Position of LPUART1EN field.
	RCC_APB1ENR_LPUART1EN_Msk = 0x40000    // Bit mask of LPUART1EN field.
	RCC_APB1ENR_LPUART1EN     = 0x40000    // Bit LPUART1EN.
	RCC_APB1ENR_USART2EN_Pos  = 0x11       // Position of USART2EN field.
	RCC_APB1ENR_USART2EN_Msk  = 0x20000    // Bit mask of USART2EN field.
	RCC_APB1ENR_USART2EN      = 0x20000    // Bit USART2EN.
	RCC_APB1ENR_SPI2EN_Pos    = 0xe        // Position of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Msk    = 0x4000     // Bit mask of SPI2EN field.
	RCC_APB1ENR_SPI2EN        = 0x4000     // Bit SPI2EN.
	RCC_APB1ENR_WWDGEN_Pos    = 0xb        // Position of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Msk    = 0x800      // Bit mask of WWDGEN field.
	RCC_APB1ENR_WWDGEN        = 0x800      // Bit WWDGEN.
	RCC_APB1ENR_TIM6EN_Pos    = 0x4        // Position of TIM6EN field.
	RCC_APB1ENR_TIM6EN_Msk    = 0x10       // Bit mask of TIM6EN field.
	RCC_APB1ENR_TIM6EN        = 0x10       // Bit TIM6EN.
	RCC_APB1ENR_TIM2EN_Pos    = 0x0        // Position of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Msk    = 0x1        // Bit mask of TIM2EN field.
	RCC_APB1ENR_TIM2EN        = 0x1        // Bit TIM2EN.
	RCC_APB1ENR_TIM3EN_Pos    = 0x2        // Position of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Msk    = 0x4        // Bit mask of TIM3EN field.
	RCC_APB1ENR_TIM3EN        = 0x4        // Bit TIM3EN.
	RCC_APB1ENR_TIM7EN_Pos    = 0x5        // Position of TIM7EN field.
	RCC_APB1ENR_TIM7EN_Msk    = 0x20       // Bit mask of TIM7EN field.
	RCC_APB1ENR_TIM7EN        = 0x20       // Bit TIM7EN.
	RCC_APB1ENR_USART4EN_Pos  = 0x13       // Position of USART4EN field.
	RCC_APB1ENR_USART4EN_Msk  = 0x80000    // Bit mask of USART4EN field.
	RCC_APB1ENR_USART4EN      = 0x80000    // Bit USART4EN.
	RCC_APB1ENR_USART5EN_Pos  = 0x14       // Position of USART5EN field.
	RCC_APB1ENR_USART5EN_Msk  = 0x100000   // Bit mask of USART5EN field.
	RCC_APB1ENR_USART5EN      = 0x100000   // Bit USART5EN.
	RCC_APB1ENR_I2C3EN_Pos    = 0x1e       // Position of I2C3EN field.
	RCC_APB1ENR_I2C3EN_Msk    = 0x40000000 // Bit mask of I2C3EN field.
	RCC_APB1ENR_I2C3EN        = 0x40000000 // Bit I2C3EN.

	// IOPSMEN: GPIO clock enable in sleep mode           register
	RCC_IOPSMEN_IOPHSMEN_Pos = 0x7  // Position of IOPHSMEN field.
	RCC_IOPSMEN_IOPHSMEN_Msk = 0x80 // Bit mask of IOPHSMEN field.
	RCC_IOPSMEN_IOPHSMEN     = 0x80 // Bit IOPHSMEN.
	RCC_IOPSMEN_IOPDSMEN_Pos = 0x3  // Position of IOPDSMEN field.
	RCC_IOPSMEN_IOPDSMEN_Msk = 0x8  // Bit mask of IOPDSMEN field.
	RCC_IOPSMEN_IOPDSMEN     = 0x8  // Bit IOPDSMEN.
	RCC_IOPSMEN_IOPCSMEN_Pos = 0x2  // Position of IOPCSMEN field.
	RCC_IOPSMEN_IOPCSMEN_Msk = 0x4  // Bit mask of IOPCSMEN field.
	RCC_IOPSMEN_IOPCSMEN     = 0x4  // Bit IOPCSMEN.
	RCC_IOPSMEN_IOPBSMEN_Pos = 0x1  // Position of IOPBSMEN field.
	RCC_IOPSMEN_IOPBSMEN_Msk = 0x2  // Bit mask of IOPBSMEN field.
	RCC_IOPSMEN_IOPBSMEN     = 0x2  // Bit IOPBSMEN.
	RCC_IOPSMEN_IOPASMEN_Pos = 0x0  // Position of IOPASMEN field.
	RCC_IOPSMEN_IOPASMEN_Msk = 0x1  // Bit mask of IOPASMEN field.
	RCC_IOPSMEN_IOPASMEN     = 0x1  // Bit IOPASMEN.
	RCC_IOPSMEN_IOPESMEN_Pos = 0x4  // Position of IOPESMEN field.
	RCC_IOPSMEN_IOPESMEN_Msk = 0x10 // Bit mask of IOPESMEN field.
	RCC_IOPSMEN_IOPESMEN     = 0x10 // Bit IOPESMEN.

	// AHBSMENR: AHB peripheral clock enable in sleep mode           register
	RCC_AHBSMENR_CRYPTSMEN_Pos = 0x18      // Position of CRYPTSMEN field.
	RCC_AHBSMENR_CRYPTSMEN_Msk = 0x1000000 // Bit mask of CRYPTSMEN field.
	RCC_AHBSMENR_CRYPTSMEN     = 0x1000000 // Bit CRYPTSMEN.
	RCC_AHBSMENR_CRCSMEN_Pos   = 0xc       // Position of CRCSMEN field.
	RCC_AHBSMENR_CRCSMEN_Msk   = 0x1000    // Bit mask of CRCSMEN field.
	RCC_AHBSMENR_CRCSMEN       = 0x1000    // Bit CRCSMEN.
	RCC_AHBSMENR_SRAMSMEN_Pos  = 0x9       // Position of SRAMSMEN field.
	RCC_AHBSMENR_SRAMSMEN_Msk  = 0x200     // Bit mask of SRAMSMEN field.
	RCC_AHBSMENR_SRAMSMEN      = 0x200     // Bit SRAMSMEN.
	RCC_AHBSMENR_MIFSMEN_Pos   = 0x8       // Position of MIFSMEN field.
	RCC_AHBSMENR_MIFSMEN_Msk   = 0x100     // Bit mask of MIFSMEN field.
	RCC_AHBSMENR_MIFSMEN       = 0x100     // Bit MIFSMEN.
	RCC_AHBSMENR_DMASMEN_Pos   = 0x0       // Position of DMASMEN field.
	RCC_AHBSMENR_DMASMEN_Msk   = 0x1       // Bit mask of DMASMEN field.
	RCC_AHBSMENR_DMASMEN       = 0x1       // Bit DMASMEN.

	// APB2SMENR: APB2 peripheral clock enable in sleep mode           register
	RCC_APB2SMENR_DBGSMEN_Pos    = 0x16     // Position of DBGSMEN field.
	RCC_APB2SMENR_DBGSMEN_Msk    = 0x400000 // Bit mask of DBGSMEN field.
	RCC_APB2SMENR_DBGSMEN        = 0x400000 // Bit DBGSMEN.
	RCC_APB2SMENR_USART1SMEN_Pos = 0xe      // Position of USART1SMEN field.
	RCC_APB2SMENR_USART1SMEN_Msk = 0x4000   // Bit mask of USART1SMEN field.
	RCC_APB2SMENR_USART1SMEN     = 0x4000   // Bit USART1SMEN.
	RCC_APB2SMENR_SPI1SMEN_Pos   = 0xc      // Position of SPI1SMEN field.
	RCC_APB2SMENR_SPI1SMEN_Msk   = 0x1000   // Bit mask of SPI1SMEN field.
	RCC_APB2SMENR_SPI1SMEN       = 0x1000   // Bit SPI1SMEN.
	RCC_APB2SMENR_ADCSMEN_Pos    = 0x9      // Position of ADCSMEN field.
	RCC_APB2SMENR_ADCSMEN_Msk    = 0x200    // Bit mask of ADCSMEN field.
	RCC_APB2SMENR_ADCSMEN        = 0x200    // Bit ADCSMEN.
	RCC_APB2SMENR_TIM22SMEN_Pos  = 0x5      // Position of TIM22SMEN field.
	RCC_APB2SMENR_TIM22SMEN_Msk  = 0x20     // Bit mask of TIM22SMEN field.
	RCC_APB2SMENR_TIM22SMEN      = 0x20     // Bit TIM22SMEN.
	RCC_APB2SMENR_TIM21SMEN_Pos  = 0x2      // Position of TIM21SMEN field.
	RCC_APB2SMENR_TIM21SMEN_Msk  = 0x4      // Bit mask of TIM21SMEN field.
	RCC_APB2SMENR_TIM21SMEN      = 0x4      // Bit TIM21SMEN.
	RCC_APB2SMENR_SYSCFGSMEN_Pos = 0x0      // Position of SYSCFGSMEN field.
	RCC_APB2SMENR_SYSCFGSMEN_Msk = 0x1      // Bit mask of SYSCFGSMEN field.
	RCC_APB2SMENR_SYSCFGSMEN     = 0x1      // Bit SYSCFGSMEN.

	// APB1SMENR: APB1 peripheral clock enable in sleep mode           register
	RCC_APB1SMENR_LPTIM1SMEN_Pos  = 0x1f       // Position of LPTIM1SMEN field.
	RCC_APB1SMENR_LPTIM1SMEN_Msk  = 0x80000000 // Bit mask of LPTIM1SMEN field.
	RCC_APB1SMENR_LPTIM1SMEN      = 0x80000000 // Bit LPTIM1SMEN.
	RCC_APB1SMENR_PWRSMEN_Pos     = 0x1c       // Position of PWRSMEN field.
	RCC_APB1SMENR_PWRSMEN_Msk     = 0x10000000 // Bit mask of PWRSMEN field.
	RCC_APB1SMENR_PWRSMEN         = 0x10000000 // Bit PWRSMEN.
	RCC_APB1SMENR_CRSSMEN_Pos     = 0x1b       // Position of CRSSMEN field.
	RCC_APB1SMENR_CRSSMEN_Msk     = 0x8000000  // Bit mask of CRSSMEN field.
	RCC_APB1SMENR_CRSSMEN         = 0x8000000  // Bit CRSSMEN.
	RCC_APB1SMENR_I2C2SMEN_Pos    = 0x16       // Position of I2C2SMEN field.
	RCC_APB1SMENR_I2C2SMEN_Msk    = 0x400000   // Bit mask of I2C2SMEN field.
	RCC_APB1SMENR_I2C2SMEN        = 0x400000   // Bit I2C2SMEN.
	RCC_APB1SMENR_I2C1SMEN_Pos    = 0x15       // Position of I2C1SMEN field.
	RCC_APB1SMENR_I2C1SMEN_Msk    = 0x200000   // Bit mask of I2C1SMEN field.
	RCC_APB1SMENR_I2C1SMEN        = 0x200000   // Bit I2C1SMEN.
	RCC_APB1SMENR_LPUART1SMEN_Pos = 0x12       // Position of LPUART1SMEN field.
	RCC_APB1SMENR_LPUART1SMEN_Msk = 0x40000    // Bit mask of LPUART1SMEN field.
	RCC_APB1SMENR_LPUART1SMEN     = 0x40000    // Bit LPUART1SMEN.
	RCC_APB1SMENR_USART2SMEN_Pos  = 0x11       // Position of USART2SMEN field.
	RCC_APB1SMENR_USART2SMEN_Msk  = 0x20000    // Bit mask of USART2SMEN field.
	RCC_APB1SMENR_USART2SMEN      = 0x20000    // Bit USART2SMEN.
	RCC_APB1SMENR_SPI2SMEN_Pos    = 0xe        // Position of SPI2SMEN field.
	RCC_APB1SMENR_SPI2SMEN_Msk    = 0x4000     // Bit mask of SPI2SMEN field.
	RCC_APB1SMENR_SPI2SMEN        = 0x4000     // Bit SPI2SMEN.
	RCC_APB1SMENR_WWDGSMEN_Pos    = 0xb        // Position of WWDGSMEN field.
	RCC_APB1SMENR_WWDGSMEN_Msk    = 0x800      // Bit mask of WWDGSMEN field.
	RCC_APB1SMENR_WWDGSMEN        = 0x800      // Bit WWDGSMEN.
	RCC_APB1SMENR_TIM6SMEN_Pos    = 0x4        // Position of TIM6SMEN field.
	RCC_APB1SMENR_TIM6SMEN_Msk    = 0x10       // Bit mask of TIM6SMEN field.
	RCC_APB1SMENR_TIM6SMEN        = 0x10       // Bit TIM6SMEN.
	RCC_APB1SMENR_TIM2SMEN_Pos    = 0x0        // Position of TIM2SMEN field.
	RCC_APB1SMENR_TIM2SMEN_Msk    = 0x1        // Bit mask of TIM2SMEN field.
	RCC_APB1SMENR_TIM2SMEN        = 0x1        // Bit TIM2SMEN.
	RCC_APB1SMENR_TIM3SMEN_Pos    = 0x1        // Position of TIM3SMEN field.
	RCC_APB1SMENR_TIM3SMEN_Msk    = 0x2        // Bit mask of TIM3SMEN field.
	RCC_APB1SMENR_TIM3SMEN        = 0x2        // Bit TIM3SMEN.
	RCC_APB1SMENR_TIM7SMEN_Pos    = 0x5        // Position of TIM7SMEN field.
	RCC_APB1SMENR_TIM7SMEN_Msk    = 0x20       // Bit mask of TIM7SMEN field.
	RCC_APB1SMENR_TIM7SMEN        = 0x20       // Bit TIM7SMEN.
	RCC_APB1SMENR_USART4SMEN_Pos  = 0x13       // Position of USART4SMEN field.
	RCC_APB1SMENR_USART4SMEN_Msk  = 0x80000    // Bit mask of USART4SMEN field.
	RCC_APB1SMENR_USART4SMEN      = 0x80000    // Bit USART4SMEN.
	RCC_APB1SMENR_USART5SMEN_Pos  = 0x14       // Position of USART5SMEN field.
	RCC_APB1SMENR_USART5SMEN_Msk  = 0x100000   // Bit mask of USART5SMEN field.
	RCC_APB1SMENR_USART5SMEN      = 0x100000   // Bit USART5SMEN.
	RCC_APB1SMENR_I2C3SMEN_Pos    = 0x1e       // Position of I2C3SMEN field.
	RCC_APB1SMENR_I2C3SMEN_Msk    = 0x40000000 // Bit mask of I2C3SMEN field.
	RCC_APB1SMENR_I2C3SMEN        = 0x40000000 // Bit I2C3SMEN.

	// CCIPR: Clock configuration register
	RCC_CCIPR_LPTIM1SEL1_Pos  = 0x13    // Position of LPTIM1SEL1 field.
	RCC_CCIPR_LPTIM1SEL1_Msk  = 0x80000 // Bit mask of LPTIM1SEL1 field.
	RCC_CCIPR_LPTIM1SEL1      = 0x80000 // Bit LPTIM1SEL1.
	RCC_CCIPR_LPTIM1SEL0_Pos  = 0x12    // Position of LPTIM1SEL0 field.
	RCC_CCIPR_LPTIM1SEL0_Msk  = 0x40000 // Bit mask of LPTIM1SEL0 field.
	RCC_CCIPR_LPTIM1SEL0      = 0x40000 // Bit LPTIM1SEL0.
	RCC_CCIPR_I2C1SEL1_Pos    = 0xd     // Position of I2C1SEL1 field.
	RCC_CCIPR_I2C1SEL1_Msk    = 0x2000  // Bit mask of I2C1SEL1 field.
	RCC_CCIPR_I2C1SEL1        = 0x2000  // Bit I2C1SEL1.
	RCC_CCIPR_I2C1SEL0_Pos    = 0xc     // Position of I2C1SEL0 field.
	RCC_CCIPR_I2C1SEL0_Msk    = 0x1000  // Bit mask of I2C1SEL0 field.
	RCC_CCIPR_I2C1SEL0        = 0x1000  // Bit I2C1SEL0.
	RCC_CCIPR_LPUART1SEL1_Pos = 0xb     // Position of LPUART1SEL1 field.
	RCC_CCIPR_LPUART1SEL1_Msk = 0x800   // Bit mask of LPUART1SEL1 field.
	RCC_CCIPR_LPUART1SEL1     = 0x800   // Bit LPUART1SEL1.
	RCC_CCIPR_LPUART1SEL0_Pos = 0xa     // Position of LPUART1SEL0 field.
	RCC_CCIPR_LPUART1SEL0_Msk = 0x400   // Bit mask of LPUART1SEL0 field.
	RCC_CCIPR_LPUART1SEL0     = 0x400   // Bit LPUART1SEL0.
	RCC_CCIPR_USART2SEL1_Pos  = 0x3     // Position of USART2SEL1 field.
	RCC_CCIPR_USART2SEL1_Msk  = 0x8     // Bit mask of USART2SEL1 field.
	RCC_CCIPR_USART2SEL1      = 0x8     // Bit USART2SEL1.
	RCC_CCIPR_USART2SEL0_Pos  = 0x2     // Position of USART2SEL0 field.
	RCC_CCIPR_USART2SEL0_Msk  = 0x4     // Bit mask of USART2SEL0 field.
	RCC_CCIPR_USART2SEL0      = 0x4     // Bit USART2SEL0.
	RCC_CCIPR_USART1SEL1_Pos  = 0x1     // Position of USART1SEL1 field.
	RCC_CCIPR_USART1SEL1_Msk  = 0x2     // Bit mask of USART1SEL1 field.
	RCC_CCIPR_USART1SEL1      = 0x2     // Bit USART1SEL1.
	RCC_CCIPR_USART1SEL0_Pos  = 0x0     // Position of USART1SEL0 field.
	RCC_CCIPR_USART1SEL0_Msk  = 0x1     // Bit mask of USART1SEL0 field.
	RCC_CCIPR_USART1SEL0      = 0x1     // Bit USART1SEL0.
	RCC_CCIPR_I2C3SEL0_Pos    = 0x10    // Position of I2C3SEL0 field.
	RCC_CCIPR_I2C3SEL0_Msk    = 0x10000 // Bit mask of I2C3SEL0 field.
	RCC_CCIPR_I2C3SEL0        = 0x10000 // Bit I2C3SEL0.
	RCC_CCIPR_I2C3SEL1_Pos    = 0x11    // Position of I2C3SEL1 field.
	RCC_CCIPR_I2C3SEL1_Msk    = 0x20000 // Bit mask of I2C3SEL1 field.
	RCC_CCIPR_I2C3SEL1        = 0x20000 // Bit I2C3SEL1.

	// CSR: Control and status register
	RCC_CSR_LPWRSTF_Pos   = 0x1f       // Position of LPWRSTF field.
	RCC_CSR_LPWRSTF_Msk   = 0x80000000 // Bit mask of LPWRSTF field.
	RCC_CSR_LPWRSTF       = 0x80000000 // Bit LPWRSTF.
	RCC_CSR_WWDGRSTF_Pos  = 0x1e       // Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk  = 0x40000000 // Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF      = 0x40000000 // Bit WWDGRSTF.
	RCC_CSR_IWDGRSTF_Pos  = 0x1d       // Position of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Msk  = 0x20000000 // Bit mask of IWDGRSTF field.
	RCC_CSR_IWDGRSTF      = 0x20000000 // Bit IWDGRSTF.
	RCC_CSR_SFTRSTF_Pos   = 0x1c       // Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk   = 0x10000000 // Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF       = 0x10000000 // Bit SFTRSTF.
	RCC_CSR_PORRSTF_Pos   = 0x1b       // Position of PORRSTF field.
	RCC_CSR_PORRSTF_Msk   = 0x8000000  // Bit mask of PORRSTF field.
	RCC_CSR_PORRSTF       = 0x8000000  // Bit PORRSTF.
	RCC_CSR_PINRSTF_Pos   = 0x1a       // Position of PINRSTF field.
	RCC_CSR_PINRSTF_Msk   = 0x4000000  // Bit mask of PINRSTF field.
	RCC_CSR_PINRSTF       = 0x4000000  // Bit PINRSTF.
	RCC_CSR_OBLRSTF_Pos   = 0x19       // Position of OBLRSTF field.
	RCC_CSR_OBLRSTF_Msk   = 0x2000000  // Bit mask of OBLRSTF field.
	RCC_CSR_OBLRSTF       = 0x2000000  // Bit OBLRSTF.
	RCC_CSR_FWRSTF_Pos    = 0x18       // Position of FWRSTF field.
	RCC_CSR_FWRSTF_Msk    = 0x1000000  // Bit mask of FWRSTF field.
	RCC_CSR_FWRSTF        = 0x1000000  // Bit FWRSTF.
	RCC_CSR_RTCRST_Pos    = 0x13       // Position of RTCRST field.
	RCC_CSR_RTCRST_Msk    = 0x80000    // Bit mask of RTCRST field.
	RCC_CSR_RTCRST        = 0x80000    // Bit RTCRST.
	RCC_CSR_RTCEN_Pos     = 0x12       // Position of RTCEN field.
	RCC_CSR_RTCEN_Msk     = 0x40000    // Bit mask of RTCEN field.
	RCC_CSR_RTCEN         = 0x40000    // Bit RTCEN.
	RCC_CSR_RTCSEL_Pos    = 0x10       // Position of RTCSEL field.
	RCC_CSR_RTCSEL_Msk    = 0x30000    // Bit mask of RTCSEL field.
	RCC_CSR_CSSLSED_Pos   = 0xe        // Position of CSSLSED field.
	RCC_CSR_CSSLSED_Msk   = 0x4000     // Bit mask of CSSLSED field.
	RCC_CSR_CSSLSED       = 0x4000     // Bit CSSLSED.
	RCC_CSR_CSSLSEON_Pos  = 0xd        // Position of CSSLSEON field.
	RCC_CSR_CSSLSEON_Msk  = 0x2000     // Bit mask of CSSLSEON field.
	RCC_CSR_CSSLSEON      = 0x2000     // Bit CSSLSEON.
	RCC_CSR_LSEDRV_Pos    = 0xb        // Position of LSEDRV field.
	RCC_CSR_LSEDRV_Msk    = 0x1800     // Bit mask of LSEDRV field.
	RCC_CSR_LSEBYP_Pos    = 0xa        // Position of LSEBYP field.
	RCC_CSR_LSEBYP_Msk    = 0x400      // Bit mask of LSEBYP field.
	RCC_CSR_LSEBYP        = 0x400      // Bit LSEBYP.
	RCC_CSR_LSERDY_Pos    = 0x9        // Position of LSERDY field.
	RCC_CSR_LSERDY_Msk    = 0x200      // Bit mask of LSERDY field.
	RCC_CSR_LSERDY        = 0x200      // Bit LSERDY.
	RCC_CSR_LSEON_Pos     = 0x8        // Position of LSEON field.
	RCC_CSR_LSEON_Msk     = 0x100      // Bit mask of LSEON field.
	RCC_CSR_LSEON         = 0x100      // Bit LSEON.
	RCC_CSR_LSIRDY_Pos    = 0x1        // Position of LSIRDY field.
	RCC_CSR_LSIRDY_Msk    = 0x2        // Bit mask of LSIRDY field.
	RCC_CSR_LSIRDY        = 0x2        // Bit LSIRDY.
	RCC_CSR_LSION_Pos     = 0x0        // Position of LSION field.
	RCC_CSR_LSION_Msk     = 0x1        // Bit mask of LSION field.
	RCC_CSR_LSION         = 0x1        // Bit LSION.
	RCC_CSR_LSIIWDGLP_Pos = 0x2        // Position of LSIIWDGLP field.
	RCC_CSR_LSIIWDGLP_Msk = 0x4        // Bit mask of LSIIWDGLP field.
	RCC_CSR_LSIIWDGLP     = 0x4        // Bit LSIIWDGLP.
	RCC_CSR_RMVF_Pos      = 0x17       // Position of RMVF field.
	RCC_CSR_RMVF_Msk      = 0x800000   // Bit mask of RMVF field.
	RCC_CSR_RMVF          = 0x800000   // Bit RMVF.
)

// Bitfields for SYSCFG_COMP: System configuration controller and COMP register
const (
	// CFGR1: SYSCFG configuration register           1
	SYSCFG_CFGR1_BOOT_MODE_Pos = 0x8   // Position of BOOT_MODE field.
	SYSCFG_CFGR1_BOOT_MODE_Msk = 0x300 // Bit mask of BOOT_MODE field.
	SYSCFG_CFGR1_MEM_MODE_Pos  = 0x0   // Position of MEM_MODE field.
	SYSCFG_CFGR1_MEM_MODE_Msk  = 0x3   // Bit mask of MEM_MODE field.

	// CFGR2: SYSCFG configuration register           2
	SYSCFG_CFGR2_I2C2_FMP_Pos    = 0xd    // Position of I2C2_FMP field.
	SYSCFG_CFGR2_I2C2_FMP_Msk    = 0x2000 // Bit mask of I2C2_FMP field.
	SYSCFG_CFGR2_I2C2_FMP        = 0x2000 // Bit I2C2_FMP.
	SYSCFG_CFGR2_I2C1_FMP_Pos    = 0xc    // Position of I2C1_FMP field.
	SYSCFG_CFGR2_I2C1_FMP_Msk    = 0x1000 // Bit mask of I2C1_FMP field.
	SYSCFG_CFGR2_I2C1_FMP        = 0x1000 // Bit I2C1_FMP.
	SYSCFG_CFGR2_I2C_PB9_FMP_Pos = 0xb    // Position of I2C_PB9_FMP field.
	SYSCFG_CFGR2_I2C_PB9_FMP_Msk = 0x800  // Bit mask of I2C_PB9_FMP field.
	SYSCFG_CFGR2_I2C_PB9_FMP     = 0x800  // Bit I2C_PB9_FMP.
	SYSCFG_CFGR2_I2C_PB8_FMP_Pos = 0xa    // Position of I2C_PB8_FMP field.
	SYSCFG_CFGR2_I2C_PB8_FMP_Msk = 0x400  // Bit mask of I2C_PB8_FMP field.
	SYSCFG_CFGR2_I2C_PB8_FMP     = 0x400  // Bit I2C_PB8_FMP.
	SYSCFG_CFGR2_I2C_PB7_FMP_Pos = 0x9    // Position of I2C_PB7_FMP field.
	SYSCFG_CFGR2_I2C_PB7_FMP_Msk = 0x200  // Bit mask of I2C_PB7_FMP field.
	SYSCFG_CFGR2_I2C_PB7_FMP     = 0x200  // Bit I2C_PB7_FMP.
	SYSCFG_CFGR2_I2C_PB6_FMP_Pos = 0x8    // Position of I2C_PB6_FMP field.
	SYSCFG_CFGR2_I2C_PB6_FMP_Msk = 0x100  // Bit mask of I2C_PB6_FMP field.
	SYSCFG_CFGR2_I2C_PB6_FMP     = 0x100  // Bit I2C_PB6_FMP.
	SYSCFG_CFGR2_CAPA_Pos        = 0x1    // Position of CAPA field.
	SYSCFG_CFGR2_CAPA_Msk        = 0xe    // Bit mask of CAPA field.
	SYSCFG_CFGR2_FWDISEN_Pos     = 0x0    // Position of FWDISEN field.
	SYSCFG_CFGR2_FWDISEN_Msk     = 0x1    // Bit mask of FWDISEN field.
	SYSCFG_CFGR2_FWDISEN         = 0x1    // Bit FWDISEN.

	// EXTICR1: external interrupt configuration register           1
	SYSCFG_EXTICR1_EXTI3_Pos = 0xc    // Position of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Msk = 0xf000 // Bit mask of EXTI3 field.
	SYSCFG_EXTICR1_EXTI2_Pos = 0x8    // Position of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Msk = 0xf00  // Bit mask of EXTI2 field.
	SYSCFG_EXTICR1_EXTI1_Pos = 0x4    // Position of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Msk = 0xf0   // Bit mask of EXTI1 field.
	SYSCFG_EXTICR1_EXTI0_Pos = 0x0    // Position of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Msk = 0xf    // Bit mask of EXTI0 field.

	// EXTICR2: external interrupt configuration register           2
	SYSCFG_EXTICR2_EXTI7_Pos = 0xc    // Position of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Msk = 0xf000 // Bit mask of EXTI7 field.
	SYSCFG_EXTICR2_EXTI6_Pos = 0x8    // Position of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Msk = 0xf00  // Bit mask of EXTI6 field.
	SYSCFG_EXTICR2_EXTI5_Pos = 0x4    // Position of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Msk = 0xf0   // Bit mask of EXTI5 field.
	SYSCFG_EXTICR2_EXTI4_Pos = 0x0    // Position of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Msk = 0xf    // Bit mask of EXTI4 field.

	// EXTICR3: external interrupt configuration register           3
	SYSCFG_EXTICR3_EXTI11_Pos = 0xc    // Position of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Msk = 0xf000 // Bit mask of EXTI11 field.
	SYSCFG_EXTICR3_EXTI10_Pos = 0x8    // Position of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Msk = 0xf00  // Bit mask of EXTI10 field.
	SYSCFG_EXTICR3_EXTI9_Pos  = 0x4    // Position of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Msk  = 0xf0   // Bit mask of EXTI9 field.
	SYSCFG_EXTICR3_EXTI8_Pos  = 0x0    // Position of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Msk  = 0xf    // Bit mask of EXTI8 field.

	// EXTICR4: external interrupt configuration register           4
	SYSCFG_EXTICR4_EXTI15_Pos = 0xc    // Position of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Msk = 0xf000 // Bit mask of EXTI15 field.
	SYSCFG_EXTICR4_EXTI14_Pos = 0x8    // Position of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Msk = 0xf00  // Bit mask of EXTI14 field.
	SYSCFG_EXTICR4_EXTI13_Pos = 0x4    // Position of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Msk = 0xf0   // Bit mask of EXTI13 field.
	SYSCFG_EXTICR4_EXTI12_Pos = 0x0    // Position of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Msk = 0xf    // Bit mask of EXTI12 field.

	// COMP1_CTRL: Comparator 1 control and status           register
	SYSCFG_COMP1_CTRL_COMP1EN_Pos       = 0x0        // Position of COMP1EN field.
	SYSCFG_COMP1_CTRL_COMP1EN_Msk       = 0x1        // Bit mask of COMP1EN field.
	SYSCFG_COMP1_CTRL_COMP1EN           = 0x1        // Bit COMP1EN.
	SYSCFG_COMP1_CTRL_COMP1INNSEL_Pos   = 0x4        // Position of COMP1INNSEL field.
	SYSCFG_COMP1_CTRL_COMP1INNSEL_Msk   = 0x30       // Bit mask of COMP1INNSEL field.
	SYSCFG_COMP1_CTRL_COMP1WM_Pos       = 0x8        // Position of COMP1WM field.
	SYSCFG_COMP1_CTRL_COMP1WM_Msk       = 0x100      // Bit mask of COMP1WM field.
	SYSCFG_COMP1_CTRL_COMP1WM           = 0x100      // Bit COMP1WM.
	SYSCFG_COMP1_CTRL_COMP1LPTIMIN1_Pos = 0xc        // Position of COMP1LPTIMIN1 field.
	SYSCFG_COMP1_CTRL_COMP1LPTIMIN1_Msk = 0x1000     // Bit mask of COMP1LPTIMIN1 field.
	SYSCFG_COMP1_CTRL_COMP1LPTIMIN1     = 0x1000     // Bit COMP1LPTIMIN1.
	SYSCFG_COMP1_CTRL_COMP1POLARITY_Pos = 0xf        // Position of COMP1POLARITY field.
	SYSCFG_COMP1_CTRL_COMP1POLARITY_Msk = 0x8000     // Bit mask of COMP1POLARITY field.
	SYSCFG_COMP1_CTRL_COMP1POLARITY     = 0x8000     // Bit COMP1POLARITY.
	SYSCFG_COMP1_CTRL_COMP1VALUE_Pos    = 0x1e       // Position of COMP1VALUE field.
	SYSCFG_COMP1_CTRL_COMP1VALUE_Msk    = 0x40000000 // Bit mask of COMP1VALUE field.
	SYSCFG_COMP1_CTRL_COMP1VALUE        = 0x40000000 // Bit COMP1VALUE.
	SYSCFG_COMP1_CTRL_COMP1LOCK_Pos     = 0x1f       // Position of COMP1LOCK field.
	SYSCFG_COMP1_CTRL_COMP1LOCK_Msk     = 0x80000000 // Bit mask of COMP1LOCK field.
	SYSCFG_COMP1_CTRL_COMP1LOCK         = 0x80000000 // Bit COMP1LOCK.

	// COMP2_CTRL: Comparator 2 control and status           register
	SYSCFG_COMP2_CTRL_COMP2EN_Pos       = 0x0        // Position of COMP2EN field.
	SYSCFG_COMP2_CTRL_COMP2EN_Msk       = 0x1        // Bit mask of COMP2EN field.
	SYSCFG_COMP2_CTRL_COMP2EN           = 0x1        // Bit COMP2EN.
	SYSCFG_COMP2_CTRL_COMP2SPEED_Pos    = 0x3        // Position of COMP2SPEED field.
	SYSCFG_COMP2_CTRL_COMP2SPEED_Msk    = 0x8        // Bit mask of COMP2SPEED field.
	SYSCFG_COMP2_CTRL_COMP2SPEED        = 0x8        // Bit COMP2SPEED.
	SYSCFG_COMP2_CTRL_COMP2INNSEL_Pos   = 0x4        // Position of COMP2INNSEL field.
	SYSCFG_COMP2_CTRL_COMP2INNSEL_Msk   = 0x70       // Bit mask of COMP2INNSEL field.
	SYSCFG_COMP2_CTRL_COMP2INPSEL_Pos   = 0x8        // Position of COMP2INPSEL field.
	SYSCFG_COMP2_CTRL_COMP2INPSEL_Msk   = 0x700      // Bit mask of COMP2INPSEL field.
	SYSCFG_COMP2_CTRL_COMP2LPTIMIN2_Pos = 0xc        // Position of COMP2LPTIMIN2 field.
	SYSCFG_COMP2_CTRL_COMP2LPTIMIN2_Msk = 0x1000     // Bit mask of COMP2LPTIMIN2 field.
	SYSCFG_COMP2_CTRL_COMP2LPTIMIN2     = 0x1000     // Bit COMP2LPTIMIN2.
	SYSCFG_COMP2_CTRL_COMP2LPTIMIN1_Pos = 0xd        // Position of COMP2LPTIMIN1 field.
	SYSCFG_COMP2_CTRL_COMP2LPTIMIN1_Msk = 0x2000     // Bit mask of COMP2LPTIMIN1 field.
	SYSCFG_COMP2_CTRL_COMP2LPTIMIN1     = 0x2000     // Bit COMP2LPTIMIN1.
	SYSCFG_COMP2_CTRL_COMP2POLARITY_Pos = 0xf        // Position of COMP2POLARITY field.
	SYSCFG_COMP2_CTRL_COMP2POLARITY_Msk = 0x8000     // Bit mask of COMP2POLARITY field.
	SYSCFG_COMP2_CTRL_COMP2POLARITY     = 0x8000     // Bit COMP2POLARITY.
	SYSCFG_COMP2_CTRL_COMP2VALUE_Pos    = 0x1e       // Position of COMP2VALUE field.
	SYSCFG_COMP2_CTRL_COMP2VALUE_Msk    = 0x40000000 // Bit mask of COMP2VALUE field.
	SYSCFG_COMP2_CTRL_COMP2VALUE        = 0x40000000 // Bit COMP2VALUE.
	SYSCFG_COMP2_CTRL_COMP2LOCK_Pos     = 0x1f       // Position of COMP2LOCK field.
	SYSCFG_COMP2_CTRL_COMP2LOCK_Msk     = 0x80000000 // Bit mask of COMP2LOCK field.
	SYSCFG_COMP2_CTRL_COMP2LOCK         = 0x80000000 // Bit COMP2LOCK.

	// CFGR3: SYSCFG configuration register           3
	SYSCFG_CFGR3_REF_LOCK_Pos           = 0x1f       // Position of REF_LOCK field.
	SYSCFG_CFGR3_REF_LOCK_Msk           = 0x80000000 // Bit mask of REF_LOCK field.
	SYSCFG_CFGR3_REF_LOCK               = 0x80000000 // Bit REF_LOCK.
	SYSCFG_CFGR3_VREFINT_RDYF_Pos       = 0x1e       // Position of VREFINT_RDYF field.
	SYSCFG_CFGR3_VREFINT_RDYF_Msk       = 0x40000000 // Bit mask of VREFINT_RDYF field.
	SYSCFG_CFGR3_VREFINT_RDYF           = 0x40000000 // Bit VREFINT_RDYF.
	SYSCFG_CFGR3_VREFINT_COMP_RDYF_Pos  = 0x1d       // Position of VREFINT_COMP_RDYF field.
	SYSCFG_CFGR3_VREFINT_COMP_RDYF_Msk  = 0x20000000 // Bit mask of VREFINT_COMP_RDYF field.
	SYSCFG_CFGR3_VREFINT_COMP_RDYF      = 0x20000000 // Bit VREFINT_COMP_RDYF.
	SYSCFG_CFGR3_VREFINT_ADC_RDYF_Pos   = 0x1c       // Position of VREFINT_ADC_RDYF field.
	SYSCFG_CFGR3_VREFINT_ADC_RDYF_Msk   = 0x10000000 // Bit mask of VREFINT_ADC_RDYF field.
	SYSCFG_CFGR3_VREFINT_ADC_RDYF       = 0x10000000 // Bit VREFINT_ADC_RDYF.
	SYSCFG_CFGR3_SENSOR_ADC_RDYF_Pos    = 0x1b       // Position of SENSOR_ADC_RDYF field.
	SYSCFG_CFGR3_SENSOR_ADC_RDYF_Msk    = 0x8000000  // Bit mask of SENSOR_ADC_RDYF field.
	SYSCFG_CFGR3_SENSOR_ADC_RDYF        = 0x8000000  // Bit SENSOR_ADC_RDYF.
	SYSCFG_CFGR3_REF_RC48MHz_RDYF_Pos   = 0x1a       // Position of REF_RC48MHz_RDYF field.
	SYSCFG_CFGR3_REF_RC48MHz_RDYF_Msk   = 0x4000000  // Bit mask of REF_RC48MHz_RDYF field.
	SYSCFG_CFGR3_REF_RC48MHz_RDYF       = 0x4000000  // Bit REF_RC48MHz_RDYF.
	SYSCFG_CFGR3_ENREF_RC48MHz_Pos      = 0xd        // Position of ENREF_RC48MHz field.
	SYSCFG_CFGR3_ENREF_RC48MHz_Msk      = 0x2000     // Bit mask of ENREF_RC48MHz field.
	SYSCFG_CFGR3_ENREF_RC48MHz          = 0x2000     // Bit ENREF_RC48MHz.
	SYSCFG_CFGR3_ENBUF_VREFINT_COMP_Pos = 0xc        // Position of ENBUF_VREFINT_COMP field.
	SYSCFG_CFGR3_ENBUF_VREFINT_COMP_Msk = 0x1000     // Bit mask of ENBUF_VREFINT_COMP field.
	SYSCFG_CFGR3_ENBUF_VREFINT_COMP     = 0x1000     // Bit ENBUF_VREFINT_COMP.
	SYSCFG_CFGR3_ENBUF_SENSOR_ADC_Pos   = 0x9        // Position of ENBUF_SENSOR_ADC field.
	SYSCFG_CFGR3_ENBUF_SENSOR_ADC_Msk   = 0x200      // Bit mask of ENBUF_SENSOR_ADC field.
	SYSCFG_CFGR3_ENBUF_SENSOR_ADC       = 0x200      // Bit ENBUF_SENSOR_ADC.
	SYSCFG_CFGR3_ENBUF_BGAP_ADC_Pos     = 0x8        // Position of ENBUF_BGAP_ADC field.
	SYSCFG_CFGR3_ENBUF_BGAP_ADC_Msk     = 0x100      // Bit mask of ENBUF_BGAP_ADC field.
	SYSCFG_CFGR3_ENBUF_BGAP_ADC         = 0x100      // Bit ENBUF_BGAP_ADC.
	SYSCFG_CFGR3_SEL_VREF_OUT_Pos       = 0x4        // Position of SEL_VREF_OUT field.
	SYSCFG_CFGR3_SEL_VREF_OUT_Msk       = 0x30       // Bit mask of SEL_VREF_OUT field.
	SYSCFG_CFGR3_EN_BGAP_Pos            = 0x0        // Position of EN_BGAP field.
	SYSCFG_CFGR3_EN_BGAP_Msk            = 0x1        // Bit mask of EN_BGAP field.
	SYSCFG_CFGR3_EN_BGAP                = 0x1        // Bit EN_BGAP.
)

// Bitfields for SPI1: Serial peripheral interface
const (
	// CR1: control register 1
	SPI_CR1_BIDIMODE_Pos = 0xf    // Position of BIDIMODE field.
	SPI_CR1_BIDIMODE_Msk = 0x8000 // Bit mask of BIDIMODE field.
	SPI_CR1_BIDIMODE     = 0x8000 // Bit BIDIMODE.
	SPI_CR1_BIDIOE_Pos   = 0xe    // Position of BIDIOE field.
	SPI_CR1_BIDIOE_Msk   = 0x4000 // Bit mask of BIDIOE field.
	SPI_CR1_BIDIOE       = 0x4000 // Bit BIDIOE.
	SPI_CR1_CRCEN_Pos    = 0xd    // Position of CRCEN field.
	SPI_CR1_CRCEN_Msk    = 0x2000 // Bit mask of CRCEN field.
	SPI_CR1_CRCEN        = 0x2000 // Bit CRCEN.
	SPI_CR1_CRCNEXT_Pos  = 0xc    // Position of CRCNEXT field.
	SPI_CR1_CRCNEXT_Msk  = 0x1000 // Bit mask of CRCNEXT field.
	SPI_CR1_CRCNEXT      = 0x1000 // Bit CRCNEXT.
	SPI_CR1_DFF_Pos      = 0xb    // Position of DFF field.
	SPI_CR1_DFF_Msk      = 0x800  // Bit mask of DFF field.
	SPI_CR1_DFF          = 0x800  // Bit DFF.
	SPI_CR1_RXONLY_Pos   = 0xa    // Position of RXONLY field.
	SPI_CR1_RXONLY_Msk   = 0x400  // Bit mask of RXONLY field.
	SPI_CR1_RXONLY       = 0x400  // Bit RXONLY.
	SPI_CR1_SSM_Pos      = 0x9    // Position of SSM field.
	SPI_CR1_SSM_Msk      = 0x200  // Bit mask of SSM field.
	SPI_CR1_SSM          = 0x200  // Bit SSM.
	SPI_CR1_SSI_Pos      = 0x8    // Position of SSI field.
	SPI_CR1_SSI_Msk      = 0x100  // Bit mask of SSI field.
	SPI_CR1_SSI          = 0x100  // Bit SSI.
	SPI_CR1_LSBFIRST_Pos = 0x7    // Position of LSBFIRST field.
	SPI_CR1_LSBFIRST_Msk = 0x80   // Bit mask of LSBFIRST field.
	SPI_CR1_LSBFIRST     = 0x80   // Bit LSBFIRST.
	SPI_CR1_SPE_Pos      = 0x6    // Position of SPE field.
	SPI_CR1_SPE_Msk      = 0x40   // Bit mask of SPE field.
	SPI_CR1_SPE          = 0x40   // Bit SPE.
	SPI_CR1_BR_Pos       = 0x3    // Position of BR field.
	SPI_CR1_BR_Msk       = 0x38   // Bit mask of BR field.
	SPI_CR1_MSTR_Pos     = 0x2    // Position of MSTR field.
	SPI_CR1_MSTR_Msk     = 0x4    // Bit mask of MSTR field.
	SPI_CR1_MSTR         = 0x4    // Bit MSTR.
	SPI_CR1_CPOL_Pos     = 0x1    // Position of CPOL field.
	SPI_CR1_CPOL_Msk     = 0x2    // Bit mask of CPOL field.
	SPI_CR1_CPOL         = 0x2    // Bit CPOL.
	SPI_CR1_CPHA_Pos     = 0x0    // Position of CPHA field.
	SPI_CR1_CPHA_Msk     = 0x1    // Bit mask of CPHA field.
	SPI_CR1_CPHA         = 0x1    // Bit CPHA.

	// CR2: control register 2
	SPI_CR2_RXDMAEN_Pos = 0x0  // Position of RXDMAEN field.
	SPI_CR2_RXDMAEN_Msk = 0x1  // Bit mask of RXDMAEN field.
	SPI_CR2_RXDMAEN     = 0x1  // Bit RXDMAEN.
	SPI_CR2_TXDMAEN_Pos = 0x1  // Position of TXDMAEN field.
	SPI_CR2_TXDMAEN_Msk = 0x2  // Bit mask of TXDMAEN field.
	SPI_CR2_TXDMAEN     = 0x2  // Bit TXDMAEN.
	SPI_CR2_SSOE_Pos    = 0x2  // Position of SSOE field.
	SPI_CR2_SSOE_Msk    = 0x4  // Bit mask of SSOE field.
	SPI_CR2_SSOE        = 0x4  // Bit SSOE.
	SPI_CR2_FRF_Pos     = 0x4  // Position of FRF field.
	SPI_CR2_FRF_Msk     = 0x10 // Bit mask of FRF field.
	SPI_CR2_FRF         = 0x10 // Bit FRF.
	SPI_CR2_ERRIE_Pos   = 0x5  // Position of ERRIE field.
	SPI_CR2_ERRIE_Msk   = 0x20 // Bit mask of ERRIE field.
	SPI_CR2_ERRIE       = 0x20 // Bit ERRIE.
	SPI_CR2_RXNEIE_Pos  = 0x6  // Position of RXNEIE field.
	SPI_CR2_RXNEIE_Msk  = 0x40 // Bit mask of RXNEIE field.
	SPI_CR2_RXNEIE      = 0x40 // Bit RXNEIE.
	SPI_CR2_TXEIE_Pos   = 0x7  // Position of TXEIE field.
	SPI_CR2_TXEIE_Msk   = 0x80 // Bit mask of TXEIE field.
	SPI_CR2_TXEIE       = 0x80 // Bit TXEIE.

	// SR: status register
	SPI_SR_RXNE_Pos   = 0x0   // Position of RXNE field.
	SPI_SR_RXNE_Msk   = 0x1   // Bit mask of RXNE field.
	SPI_SR_RXNE       = 0x1   // Bit RXNE.
	SPI_SR_TXE_Pos    = 0x1   // Position of TXE field.
	SPI_SR_TXE_Msk    = 0x2   // Bit mask of TXE field.
	SPI_SR_TXE        = 0x2   // Bit TXE.
	SPI_SR_CHSIDE_Pos = 0x2   // Position of CHSIDE field.
	SPI_SR_CHSIDE_Msk = 0x4   // Bit mask of CHSIDE field.
	SPI_SR_CHSIDE     = 0x4   // Bit CHSIDE.
	SPI_SR_UDR_Pos    = 0x3   // Position of UDR field.
	SPI_SR_UDR_Msk    = 0x8   // Bit mask of UDR field.
	SPI_SR_UDR        = 0x8   // Bit UDR.
	SPI_SR_CRCERR_Pos = 0x4   // Position of CRCERR field.
	SPI_SR_CRCERR_Msk = 0x10  // Bit mask of CRCERR field.
	SPI_SR_CRCERR     = 0x10  // Bit CRCERR.
	SPI_SR_MODF_Pos   = 0x5   // Position of MODF field.
	SPI_SR_MODF_Msk   = 0x20  // Bit mask of MODF field.
	SPI_SR_MODF       = 0x20  // Bit MODF.
	SPI_SR_OVR_Pos    = 0x6   // Position of OVR field.
	SPI_SR_OVR_Msk    = 0x40  // Bit mask of OVR field.
	SPI_SR_OVR        = 0x40  // Bit OVR.
	SPI_SR_BSY_Pos    = 0x7   // Position of BSY field.
	SPI_SR_BSY_Msk    = 0x80  // Bit mask of BSY field.
	SPI_SR_BSY        = 0x80  // Bit BSY.
	SPI_SR_TIFRFE_Pos = 0x8   // Position of TIFRFE field.
	SPI_SR_TIFRFE_Msk = 0x100 // Bit mask of TIFRFE field.
	SPI_SR_TIFRFE     = 0x100 // Bit TIFRFE.

	// DR: data register
	SPI_DR_DR_Pos = 0x0    // Position of DR field.
	SPI_DR_DR_Msk = 0xffff // Bit mask of DR field.

	// CRCPR: CRC polynomial register
	SPI_CRCPR_CRCPOLY_Pos = 0x0    // Position of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Msk = 0xffff // Bit mask of CRCPOLY field.

	// RXCRCR: RX CRC register
	SPI_RXCRCR_RxCRC_Pos = 0x0    // Position of RxCRC field.
	SPI_RXCRCR_RxCRC_Msk = 0xffff // Bit mask of RxCRC field.

	// TXCRCR: TX CRC register
	SPI_TXCRCR_TxCRC_Pos = 0x0    // Position of TxCRC field.
	SPI_TXCRCR_TxCRC_Msk = 0xffff // Bit mask of TxCRC field.

	// I2SCFGR: I2S configuration register
	SPI_I2SCFGR_I2SMOD_Pos  = 0xb   // Position of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Msk  = 0x800 // Bit mask of I2SMOD field.
	SPI_I2SCFGR_I2SMOD      = 0x800 // Bit I2SMOD.
	SPI_I2SCFGR_I2SE_Pos    = 0xa   // Position of I2SE field.
	SPI_I2SCFGR_I2SE_Msk    = 0x400 // Bit mask of I2SE field.
	SPI_I2SCFGR_I2SE        = 0x400 // Bit I2SE.
	SPI_I2SCFGR_I2SCFG_Pos  = 0x8   // Position of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Msk  = 0x300 // Bit mask of I2SCFG field.
	SPI_I2SCFGR_PCMSYNC_Pos = 0x7   // Position of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Msk = 0x80  // Bit mask of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC     = 0x80  // Bit PCMSYNC.
	SPI_I2SCFGR_I2SSTD_Pos  = 0x4   // Position of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Msk  = 0x30  // Bit mask of I2SSTD field.
	SPI_I2SCFGR_CKPOL_Pos   = 0x3   // Position of CKPOL field.
	SPI_I2SCFGR_CKPOL_Msk   = 0x8   // Bit mask of CKPOL field.
	SPI_I2SCFGR_CKPOL       = 0x8   // Bit CKPOL.
	SPI_I2SCFGR_DATLEN_Pos  = 0x1   // Position of DATLEN field.
	SPI_I2SCFGR_DATLEN_Msk  = 0x6   // Bit mask of DATLEN field.
	SPI_I2SCFGR_CHLEN_Pos   = 0x0   // Position of CHLEN field.
	SPI_I2SCFGR_CHLEN_Msk   = 0x1   // Bit mask of CHLEN field.
	SPI_I2SCFGR_CHLEN       = 0x1   // Bit CHLEN.

	// I2SPR: I2S prescaler register
	SPI_I2SPR_MCKOE_Pos  = 0x9   // Position of MCKOE field.
	SPI_I2SPR_MCKOE_Msk  = 0x200 // Bit mask of MCKOE field.
	SPI_I2SPR_MCKOE      = 0x200 // Bit MCKOE.
	SPI_I2SPR_ODD_Pos    = 0x8   // Position of ODD field.
	SPI_I2SPR_ODD_Msk    = 0x100 // Bit mask of ODD field.
	SPI_I2SPR_ODD        = 0x100 // Bit ODD.
	SPI_I2SPR_I2SDIV_Pos = 0x0   // Position of I2SDIV field.
	SPI_I2SPR_I2SDIV_Msk = 0xff  // Bit mask of I2SDIV field.
)

// Bitfields for I2C1: Inter-integrated circuit
const (
	// CR1: Control register 1
	I2C_CR1_PE_Pos        = 0x0      // Position of PE field.
	I2C_CR1_PE_Msk        = 0x1      // Bit mask of PE field.
	I2C_CR1_PE            = 0x1      // Bit PE.
	I2C_CR1_TXIE_Pos      = 0x1      // Position of TXIE field.
	I2C_CR1_TXIE_Msk      = 0x2      // Bit mask of TXIE field.
	I2C_CR1_TXIE          = 0x2      // Bit TXIE.
	I2C_CR1_RXIE_Pos      = 0x2      // Position of RXIE field.
	I2C_CR1_RXIE_Msk      = 0x4      // Bit mask of RXIE field.
	I2C_CR1_RXIE          = 0x4      // Bit RXIE.
	I2C_CR1_ADDRIE_Pos    = 0x3      // Position of ADDRIE field.
	I2C_CR1_ADDRIE_Msk    = 0x8      // Bit mask of ADDRIE field.
	I2C_CR1_ADDRIE        = 0x8      // Bit ADDRIE.
	I2C_CR1_NACKIE_Pos    = 0x4      // Position of NACKIE field.
	I2C_CR1_NACKIE_Msk    = 0x10     // Bit mask of NACKIE field.
	I2C_CR1_NACKIE        = 0x10     // Bit NACKIE.
	I2C_CR1_STOPIE_Pos    = 0x5      // Position of STOPIE field.
	I2C_CR1_STOPIE_Msk    = 0x20     // Bit mask of STOPIE field.
	I2C_CR1_STOPIE        = 0x20     // Bit STOPIE.
	I2C_CR1_TCIE_Pos      = 0x6      // Position of TCIE field.
	I2C_CR1_TCIE_Msk      = 0x40     // Bit mask of TCIE field.
	I2C_CR1_TCIE          = 0x40     // Bit TCIE.
	I2C_CR1_ERRIE_Pos     = 0x7      // Position of ERRIE field.
	I2C_CR1_ERRIE_Msk     = 0x80     // Bit mask of ERRIE field.
	I2C_CR1_ERRIE         = 0x80     // Bit ERRIE.
	I2C_CR1_DNF_Pos       = 0x8      // Position of DNF field.
	I2C_CR1_DNF_Msk       = 0xf00    // Bit mask of DNF field.
	I2C_CR1_ANFOFF_Pos    = 0xc      // Position of ANFOFF field.
	I2C_CR1_ANFOFF_Msk    = 0x1000   // Bit mask of ANFOFF field.
	I2C_CR1_ANFOFF        = 0x1000   // Bit ANFOFF.
	I2C_CR1_TXDMAEN_Pos   = 0xe      // Position of TXDMAEN field.
	I2C_CR1_TXDMAEN_Msk   = 0x4000   // Bit mask of TXDMAEN field.
	I2C_CR1_TXDMAEN       = 0x4000   // Bit TXDMAEN.
	I2C_CR1_RXDMAEN_Pos   = 0xf      // Position of RXDMAEN field.
	I2C_CR1_RXDMAEN_Msk   = 0x8000   // Bit mask of RXDMAEN field.
	I2C_CR1_RXDMAEN       = 0x8000   // Bit RXDMAEN.
	I2C_CR1_SBC_Pos       = 0x10     // Position of SBC field.
	I2C_CR1_SBC_Msk       = 0x10000  // Bit mask of SBC field.
	I2C_CR1_SBC           = 0x10000  // Bit SBC.
	I2C_CR1_NOSTRETCH_Pos = 0x11     // Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x20000  // Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH     = 0x20000  // Bit NOSTRETCH.
	I2C_CR1_WUPEN_Pos     = 0x12     // Position of WUPEN field.
	I2C_CR1_WUPEN_Msk     = 0x40000  // Bit mask of WUPEN field.
	I2C_CR1_WUPEN         = 0x40000  // Bit WUPEN.
	I2C_CR1_GCEN_Pos      = 0x13     // Position of GCEN field.
	I2C_CR1_GCEN_Msk      = 0x80000  // Bit mask of GCEN field.
	I2C_CR1_GCEN          = 0x80000  // Bit GCEN.
	I2C_CR1_SMBHEN_Pos    = 0x14     // Position of SMBHEN field.
	I2C_CR1_SMBHEN_Msk    = 0x100000 // Bit mask of SMBHEN field.
	I2C_CR1_SMBHEN        = 0x100000 // Bit SMBHEN.
	I2C_CR1_SMBDEN_Pos    = 0x15     // Position of SMBDEN field.
	I2C_CR1_SMBDEN_Msk    = 0x200000 // Bit mask of SMBDEN field.
	I2C_CR1_SMBDEN        = 0x200000 // Bit SMBDEN.
	I2C_CR1_ALERTEN_Pos   = 0x16     // Position of ALERTEN field.
	I2C_CR1_ALERTEN_Msk   = 0x400000 // Bit mask of ALERTEN field.
	I2C_CR1_ALERTEN       = 0x400000 // Bit ALERTEN.
	I2C_CR1_PECEN_Pos     = 0x17     // Position of PECEN field.
	I2C_CR1_PECEN_Msk     = 0x800000 // Bit mask of PECEN field.
	I2C_CR1_PECEN         = 0x800000 // Bit PECEN.

	// CR2: Control register 2
	I2C_CR2_PECBYTE_Pos = 0x1a      // Position of PECBYTE field.
	I2C_CR2_PECBYTE_Msk = 0x4000000 // Bit mask of PECBYTE field.
	I2C_CR2_PECBYTE     = 0x4000000 // Bit PECBYTE.
	I2C_CR2_AUTOEND_Pos = 0x19      // Position of AUTOEND field.
	I2C_CR2_AUTOEND_Msk = 0x2000000 // Bit mask of AUTOEND field.
	I2C_CR2_AUTOEND     = 0x2000000 // Bit AUTOEND.
	I2C_CR2_RELOAD_Pos  = 0x18      // Position of RELOAD field.
	I2C_CR2_RELOAD_Msk  = 0x1000000 // Bit mask of RELOAD field.
	I2C_CR2_RELOAD      = 0x1000000 // Bit RELOAD.
	I2C_CR2_NBYTES_Pos  = 0x10      // Position of NBYTES field.
	I2C_CR2_NBYTES_Msk  = 0xff0000  // Bit mask of NBYTES field.
	I2C_CR2_NACK_Pos    = 0xf       // Position of NACK field.
	I2C_CR2_NACK_Msk    = 0x8000    // Bit mask of NACK field.
	I2C_CR2_NACK        = 0x8000    // Bit NACK.
	I2C_CR2_STOP_Pos    = 0xe       // Position of STOP field.
	I2C_CR2_STOP_Msk    = 0x4000    // Bit mask of STOP field.
	I2C_CR2_STOP        = 0x4000    // Bit STOP.
	I2C_CR2_START_Pos   = 0xd       // Position of START field.
	I2C_CR2_START_Msk   = 0x2000    // Bit mask of START field.
	I2C_CR2_START       = 0x2000    // Bit START.
	I2C_CR2_HEAD10R_Pos = 0xc       // Position of HEAD10R field.
	I2C_CR2_HEAD10R_Msk = 0x1000    // Bit mask of HEAD10R field.
	I2C_CR2_HEAD10R     = 0x1000    // Bit HEAD10R.
	I2C_CR2_ADD10_Pos   = 0xb       // Position of ADD10 field.
	I2C_CR2_ADD10_Msk   = 0x800     // Bit mask of ADD10 field.
	I2C_CR2_ADD10       = 0x800     // Bit ADD10.
	I2C_CR2_RD_WRN_Pos  = 0xa       // Position of RD_WRN field.
	I2C_CR2_RD_WRN_Msk  = 0x400     // Bit mask of RD_WRN field.
	I2C_CR2_RD_WRN      = 0x400     // Bit RD_WRN.
	I2C_CR2_SADD_Pos    = 0x0       // Position of SADD field.
	I2C_CR2_SADD_Msk    = 0x3ff     // Bit mask of SADD field.

	// OAR1: Own address register 1
	I2C_OAR1_OA1_Pos     = 0x0    // Position of OA1 field.
	I2C_OAR1_OA1_Msk     = 0x3ff  // Bit mask of OA1 field.
	I2C_OAR1_OA1MODE_Pos = 0xa    // Position of OA1MODE field.
	I2C_OAR1_OA1MODE_Msk = 0x400  // Bit mask of OA1MODE field.
	I2C_OAR1_OA1MODE     = 0x400  // Bit OA1MODE.
	I2C_OAR1_OA1EN_Pos   = 0xf    // Position of OA1EN field.
	I2C_OAR1_OA1EN_Msk   = 0x8000 // Bit mask of OA1EN field.
	I2C_OAR1_OA1EN       = 0x8000 // Bit OA1EN.

	// OAR2: Own address register 2
	I2C_OAR2_OA2_Pos    = 0x1    // Position of OA2 field.
	I2C_OAR2_OA2_Msk    = 0xfe   // Bit mask of OA2 field.
	I2C_OAR2_OA2MSK_Pos = 0x8    // Position of OA2MSK field.
	I2C_OAR2_OA2MSK_Msk = 0x700  // Bit mask of OA2MSK field.
	I2C_OAR2_OA2EN_Pos  = 0xf    // Position of OA2EN field.
	I2C_OAR2_OA2EN_Msk  = 0x8000 // Bit mask of OA2EN field.
	I2C_OAR2_OA2EN      = 0x8000 // Bit OA2EN.

	// TIMINGR: Timing register
	I2C_TIMINGR_SCLL_Pos   = 0x0        // Position of SCLL field.
	I2C_TIMINGR_SCLL_Msk   = 0xff       // Bit mask of SCLL field.
	I2C_TIMINGR_SCLH_Pos   = 0x8        // Position of SCLH field.
	I2C_TIMINGR_SCLH_Msk   = 0xff00     // Bit mask of SCLH field.
	I2C_TIMINGR_SDADEL_Pos = 0x10       // Position of SDADEL field.
	I2C_TIMINGR_SDADEL_Msk = 0xf0000    // Bit mask of SDADEL field.
	I2C_TIMINGR_SCLDEL_Pos = 0x14       // Position of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Msk = 0xf00000   // Bit mask of SCLDEL field.
	I2C_TIMINGR_PRESC_Pos  = 0x1c       // Position of PRESC field.
	I2C_TIMINGR_PRESC_Msk  = 0xf0000000 // Bit mask of PRESC field.

	// TIMEOUTR: Status register 1
	I2C_TIMEOUTR_TIMEOUTA_Pos = 0x0        // Position of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Msk = 0xfff      // Bit mask of TIMEOUTA field.
	I2C_TIMEOUTR_TIDLE_Pos    = 0xc        // Position of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Msk    = 0x1000     // Bit mask of TIDLE field.
	I2C_TIMEOUTR_TIDLE        = 0x1000     // Bit TIDLE.
	I2C_TIMEOUTR_TIMOUTEN_Pos = 0xf        // Position of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Msk = 0x8000     // Bit mask of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN     = 0x8000     // Bit TIMOUTEN.
	I2C_TIMEOUTR_TIMEOUTB_Pos = 0x10       // Position of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Msk = 0xfff0000  // Bit mask of TIMEOUTB field.
	I2C_TIMEOUTR_TEXTEN_Pos   = 0x1f       // Position of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Msk   = 0x80000000 // Bit mask of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN       = 0x80000000 // Bit TEXTEN.

	// ISR: Interrupt and Status register
	I2C_ISR_ADDCODE_Pos = 0x11     // Position of ADDCODE field.
	I2C_ISR_ADDCODE_Msk = 0xfe0000 // Bit mask of ADDCODE field.
	I2C_ISR_DIR_Pos     = 0x10     // Position of DIR field.
	I2C_ISR_DIR_Msk     = 0x10000  // Bit mask of DIR field.
	I2C_ISR_DIR         = 0x10000  // Bit DIR.
	I2C_ISR_BUSY_Pos    = 0xf      // Position of BUSY field.
	I2C_ISR_BUSY_Msk    = 0x8000   // Bit mask of BUSY field.
	I2C_ISR_BUSY        = 0x8000   // Bit BUSY.
	I2C_ISR_ALERT_Pos   = 0xd      // Position of ALERT field.
	I2C_ISR_ALERT_Msk   = 0x2000   // Bit mask of ALERT field.
	I2C_ISR_ALERT       = 0x2000   // Bit ALERT.
	I2C_ISR_TIMEOUT_Pos = 0xc      // Position of TIMEOUT field.
	I2C_ISR_TIMEOUT_Msk = 0x1000   // Bit mask of TIMEOUT field.
	I2C_ISR_TIMEOUT     = 0x1000   // Bit TIMEOUT.
	I2C_ISR_PECERR_Pos  = 0xb      // Position of PECERR field.
	I2C_ISR_PECERR_Msk  = 0x800    // Bit mask of PECERR field.
	I2C_ISR_PECERR      = 0x800    // Bit PECERR.
	I2C_ISR_OVR_Pos     = 0xa      // Position of OVR field.
	I2C_ISR_OVR_Msk     = 0x400    // Bit mask of OVR field.
	I2C_ISR_OVR         = 0x400    // Bit OVR.
	I2C_ISR_ARLO_Pos    = 0x9      // Position of ARLO field.
	I2C_ISR_ARLO_Msk    = 0x200    // Bit mask of ARLO field.
	I2C_ISR_ARLO        = 0x200    // Bit ARLO.
	I2C_ISR_BERR_Pos    = 0x8      // Position of BERR field.
	I2C_ISR_BERR_Msk    = 0x100    // Bit mask of BERR field.
	I2C_ISR_BERR        = 0x100    // Bit BERR.
	I2C_ISR_TCR_Pos     = 0x7      // Position of TCR field.
	I2C_ISR_TCR_Msk     = 0x80     // Bit mask of TCR field.
	I2C_ISR_TCR         = 0x80     // Bit TCR.
	I2C_ISR_TC_Pos      = 0x6      // Position of TC field.
	I2C_ISR_TC_Msk      = 0x40     // Bit mask of TC field.
	I2C_ISR_TC          = 0x40     // Bit TC.
	I2C_ISR_STOPF_Pos   = 0x5      // Position of STOPF field.
	I2C_ISR_STOPF_Msk   = 0x20     // Bit mask of STOPF field.
	I2C_ISR_STOPF       = 0x20     // Bit STOPF.
	I2C_ISR_NACKF_Pos   = 0x4      // Position of NACKF field.
	I2C_ISR_NACKF_Msk   = 0x10     // Bit mask of NACKF field.
	I2C_ISR_NACKF       = 0x10     // Bit NACKF.
	I2C_ISR_ADDR_Pos    = 0x3      // Position of ADDR field.
	I2C_ISR_ADDR_Msk    = 0x8      // Bit mask of ADDR field.
	I2C_ISR_ADDR        = 0x8      // Bit ADDR.
	I2C_ISR_RXNE_Pos    = 0x2      // Position of RXNE field.
	I2C_ISR_RXNE_Msk    = 0x4      // Bit mask of RXNE field.
	I2C_ISR_RXNE        = 0x4      // Bit RXNE.
	I2C_ISR_TXIS_Pos    = 0x1      // Position of TXIS field.
	I2C_ISR_TXIS_Msk    = 0x2      // Bit mask of TXIS field.
	I2C_ISR_TXIS        = 0x2      // Bit TXIS.
	I2C_ISR_TXE_Pos     = 0x0      // Position of TXE field.
	I2C_ISR_TXE_Msk     = 0x1      // Bit mask of TXE field.
	I2C_ISR_TXE         = 0x1      // Bit TXE.

	// ICR: Interrupt clear register
	I2C_ICR_ALERTCF_Pos  = 0xd    // Position of ALERTCF field.
	I2C_ICR_ALERTCF_Msk  = 0x2000 // Bit mask of ALERTCF field.
	I2C_ICR_ALERTCF      = 0x2000 // Bit ALERTCF.
	I2C_ICR_TIMOUTCF_Pos = 0xc    // Position of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Msk = 0x1000 // Bit mask of TIMOUTCF field.
	I2C_ICR_TIMOUTCF     = 0x1000 // Bit TIMOUTCF.
	I2C_ICR_PECCF_Pos    = 0xb    // Position of PECCF field.
	I2C_ICR_PECCF_Msk    = 0x800  // Bit mask of PECCF field.
	I2C_ICR_PECCF        = 0x800  // Bit PECCF.
	I2C_ICR_OVRCF_Pos    = 0xa    // Position of OVRCF field.
	I2C_ICR_OVRCF_Msk    = 0x400  // Bit mask of OVRCF field.
	I2C_ICR_OVRCF        = 0x400  // Bit OVRCF.
	I2C_ICR_ARLOCF_Pos   = 0x9    // Position of ARLOCF field.
	I2C_ICR_ARLOCF_Msk   = 0x200  // Bit mask of ARLOCF field.
	I2C_ICR_ARLOCF       = 0x200  // Bit ARLOCF.
	I2C_ICR_BERRCF_Pos   = 0x8    // Position of BERRCF field.
	I2C_ICR_BERRCF_Msk   = 0x100  // Bit mask of BERRCF field.
	I2C_ICR_BERRCF       = 0x100  // Bit BERRCF.
	I2C_ICR_STOPCF_Pos   = 0x5    // Position of STOPCF field.
	I2C_ICR_STOPCF_Msk   = 0x20   // Bit mask of STOPCF field.
	I2C_ICR_STOPCF       = 0x20   // Bit STOPCF.
	I2C_ICR_NACKCF_Pos   = 0x4    // Position of NACKCF field.
	I2C_ICR_NACKCF_Msk   = 0x10   // Bit mask of NACKCF field.
	I2C_ICR_NACKCF       = 0x10   // Bit NACKCF.
	I2C_ICR_ADDRCF_Pos   = 0x3    // Position of ADDRCF field.
	I2C_ICR_ADDRCF_Msk   = 0x8    // Bit mask of ADDRCF field.
	I2C_ICR_ADDRCF       = 0x8    // Bit ADDRCF.

	// PECR: PEC register
	I2C_PECR_PEC_Pos = 0x0  // Position of PEC field.
	I2C_PECR_PEC_Msk = 0xff // Bit mask of PEC field.

	// RXDR: Receive data register
	I2C_RXDR_RXDATA_Pos = 0x0  // Position of RXDATA field.
	I2C_RXDR_RXDATA_Msk = 0xff // Bit mask of RXDATA field.

	// TXDR: Transmit data register
	I2C_TXDR_TXDATA_Pos = 0x0  // Position of TXDATA field.
	I2C_TXDR_TXDATA_Msk = 0xff // Bit mask of TXDATA field.
)

// Bitfields for PWR: Power control
const (
	// CR: power control register
	PWR_CR_LPDS_Pos       = 0x0    // Position of LPDS field.
	PWR_CR_LPDS_Msk       = 0x1    // Bit mask of LPDS field.
	PWR_CR_LPDS           = 0x1    // Bit LPDS.
	PWR_CR_PDDS_Pos       = 0x1    // Position of PDDS field.
	PWR_CR_PDDS_Msk       = 0x2    // Bit mask of PDDS field.
	PWR_CR_PDDS           = 0x2    // Bit PDDS.
	PWR_CR_CWUF_Pos       = 0x2    // Position of CWUF field.
	PWR_CR_CWUF_Msk       = 0x4    // Bit mask of CWUF field.
	PWR_CR_CWUF           = 0x4    // Bit CWUF.
	PWR_CR_CSBF_Pos       = 0x3    // Position of CSBF field.
	PWR_CR_CSBF_Msk       = 0x8    // Bit mask of CSBF field.
	PWR_CR_CSBF           = 0x8    // Bit CSBF.
	PWR_CR_PVDE_Pos       = 0x4    // Position of PVDE field.
	PWR_CR_PVDE_Msk       = 0x10   // Bit mask of PVDE field.
	PWR_CR_PVDE           = 0x10   // Bit PVDE.
	PWR_CR_PLS_Pos        = 0x5    // Position of PLS field.
	PWR_CR_PLS_Msk        = 0xe0   // Bit mask of PLS field.
	PWR_CR_DBP_Pos        = 0x8    // Position of DBP field.
	PWR_CR_DBP_Msk        = 0x100  // Bit mask of DBP field.
	PWR_CR_DBP            = 0x100  // Bit DBP.
	PWR_CR_ULP_Pos        = 0x9    // Position of ULP field.
	PWR_CR_ULP_Msk        = 0x200  // Bit mask of ULP field.
	PWR_CR_ULP            = 0x200  // Bit ULP.
	PWR_CR_FWU_Pos        = 0xa    // Position of FWU field.
	PWR_CR_FWU_Msk        = 0x400  // Bit mask of FWU field.
	PWR_CR_FWU            = 0x400  // Bit FWU.
	PWR_CR_VOS_Pos        = 0xb    // Position of VOS field.
	PWR_CR_VOS_Msk        = 0x1800 // Bit mask of VOS field.
	PWR_CR_DS_EE_KOFF_Pos = 0xd    // Position of DS_EE_KOFF field.
	PWR_CR_DS_EE_KOFF_Msk = 0x2000 // Bit mask of DS_EE_KOFF field.
	PWR_CR_DS_EE_KOFF     = 0x2000 // Bit DS_EE_KOFF.
	PWR_CR_LPRUN_Pos      = 0xe    // Position of LPRUN field.
	PWR_CR_LPRUN_Msk      = 0x4000 // Bit mask of LPRUN field.
	PWR_CR_LPRUN          = 0x4000 // Bit LPRUN.

	// CSR: power control/status register
	PWR_CSR_BRE_Pos    = 0x9   // Position of BRE field.
	PWR_CSR_BRE_Msk    = 0x200 // Bit mask of BRE field.
	PWR_CSR_BRE        = 0x200 // Bit BRE.
	PWR_CSR_EWUP_Pos   = 0x8   // Position of EWUP field.
	PWR_CSR_EWUP_Msk   = 0x100 // Bit mask of EWUP field.
	PWR_CSR_EWUP       = 0x100 // Bit EWUP.
	PWR_CSR_BRR_Pos    = 0x3   // Position of BRR field.
	PWR_CSR_BRR_Msk    = 0x8   // Bit mask of BRR field.
	PWR_CSR_BRR        = 0x8   // Bit BRR.
	PWR_CSR_PVDO_Pos   = 0x2   // Position of PVDO field.
	PWR_CSR_PVDO_Msk   = 0x4   // Bit mask of PVDO field.
	PWR_CSR_PVDO       = 0x4   // Bit PVDO.
	PWR_CSR_SBF_Pos    = 0x1   // Position of SBF field.
	PWR_CSR_SBF_Msk    = 0x2   // Bit mask of SBF field.
	PWR_CSR_SBF        = 0x2   // Bit SBF.
	PWR_CSR_WUF_Pos    = 0x0   // Position of WUF field.
	PWR_CSR_WUF_Msk    = 0x1   // Bit mask of WUF field.
	PWR_CSR_WUF        = 0x1   // Bit WUF.
	PWR_CSR_VOSF_Pos   = 0x4   // Position of VOSF field.
	PWR_CSR_VOSF_Msk   = 0x10  // Bit mask of VOSF field.
	PWR_CSR_VOSF       = 0x10  // Bit VOSF.
	PWR_CSR_REGLPF_Pos = 0x5   // Position of REGLPF field.
	PWR_CSR_REGLPF_Msk = 0x20  // Bit mask of REGLPF field.
	PWR_CSR_REGLPF     = 0x20  // Bit REGLPF.
)

// Bitfields for Flash: Flash
const (
	// ACR: Access control register
	Flash_ACR_LATENCY_Pos   = 0x0  // Position of LATENCY field.
	Flash_ACR_LATENCY_Msk   = 0x1  // Bit mask of LATENCY field.
	Flash_ACR_LATENCY       = 0x1  // Bit LATENCY.
	Flash_ACR_PRFTEN_Pos    = 0x1  // Position of PRFTEN field.
	Flash_ACR_PRFTEN_Msk    = 0x2  // Bit mask of PRFTEN field.
	Flash_ACR_PRFTEN        = 0x2  // Bit PRFTEN.
	Flash_ACR_SLEEP_PD_Pos  = 0x3  // Position of SLEEP_PD field.
	Flash_ACR_SLEEP_PD_Msk  = 0x8  // Bit mask of SLEEP_PD field.
	Flash_ACR_SLEEP_PD      = 0x8  // Bit SLEEP_PD.
	Flash_ACR_RUN_PD_Pos    = 0x4  // Position of RUN_PD field.
	Flash_ACR_RUN_PD_Msk    = 0x10 // Bit mask of RUN_PD field.
	Flash_ACR_RUN_PD        = 0x10 // Bit RUN_PD.
	Flash_ACR_DESAB_BUF_Pos = 0x5  // Position of DESAB_BUF field.
	Flash_ACR_DESAB_BUF_Msk = 0x20 // Bit mask of DESAB_BUF field.
	Flash_ACR_DESAB_BUF     = 0x20 // Bit DESAB_BUF.
	Flash_ACR_PRE_READ_Pos  = 0x6  // Position of PRE_READ field.
	Flash_ACR_PRE_READ_Msk  = 0x40 // Bit mask of PRE_READ field.
	Flash_ACR_PRE_READ      = 0x40 // Bit PRE_READ.

	// PECR: Program/erase control register
	Flash_PECR_PELOCK_Pos       = 0x0     // Position of PELOCK field.
	Flash_PECR_PELOCK_Msk       = 0x1     // Bit mask of PELOCK field.
	Flash_PECR_PELOCK           = 0x1     // Bit PELOCK.
	Flash_PECR_PRGLOCK_Pos      = 0x1     // Position of PRGLOCK field.
	Flash_PECR_PRGLOCK_Msk      = 0x2     // Bit mask of PRGLOCK field.
	Flash_PECR_PRGLOCK          = 0x2     // Bit PRGLOCK.
	Flash_PECR_OPTLOCK_Pos      = 0x2     // Position of OPTLOCK field.
	Flash_PECR_OPTLOCK_Msk      = 0x4     // Bit mask of OPTLOCK field.
	Flash_PECR_OPTLOCK          = 0x4     // Bit OPTLOCK.
	Flash_PECR_PROG_Pos         = 0x3     // Position of PROG field.
	Flash_PECR_PROG_Msk         = 0x8     // Bit mask of PROG field.
	Flash_PECR_PROG             = 0x8     // Bit PROG.
	Flash_PECR_DATA_Pos         = 0x4     // Position of DATA field.
	Flash_PECR_DATA_Msk         = 0x10    // Bit mask of DATA field.
	Flash_PECR_DATA             = 0x10    // Bit DATA.
	Flash_PECR_FTDW_Pos         = 0x8     // Position of FTDW field.
	Flash_PECR_FTDW_Msk         = 0x100   // Bit mask of FTDW field.
	Flash_PECR_FTDW             = 0x100   // Bit FTDW.
	Flash_PECR_ERASE_Pos        = 0x9     // Position of ERASE field.
	Flash_PECR_ERASE_Msk        = 0x200   // Bit mask of ERASE field.
	Flash_PECR_ERASE            = 0x200   // Bit ERASE.
	Flash_PECR_FPRG_Pos         = 0xa     // Position of FPRG field.
	Flash_PECR_FPRG_Msk         = 0x400   // Bit mask of FPRG field.
	Flash_PECR_FPRG             = 0x400   // Bit FPRG.
	Flash_PECR_PARALLELBANK_Pos = 0xf     // Position of PARALLELBANK field.
	Flash_PECR_PARALLELBANK_Msk = 0x8000  // Bit mask of PARALLELBANK field.
	Flash_PECR_PARALLELBANK     = 0x8000  // Bit PARALLELBANK.
	Flash_PECR_EOPIE_Pos        = 0x10    // Position of EOPIE field.
	Flash_PECR_EOPIE_Msk        = 0x10000 // Bit mask of EOPIE field.
	Flash_PECR_EOPIE            = 0x10000 // Bit EOPIE.
	Flash_PECR_ERRIE_Pos        = 0x11    // Position of ERRIE field.
	Flash_PECR_ERRIE_Msk        = 0x20000 // Bit mask of ERRIE field.
	Flash_PECR_ERRIE            = 0x20000 // Bit ERRIE.
	Flash_PECR_OBL_LAUNCH_Pos   = 0x12    // Position of OBL_LAUNCH field.
	Flash_PECR_OBL_LAUNCH_Msk   = 0x40000 // Bit mask of OBL_LAUNCH field.
	Flash_PECR_OBL_LAUNCH       = 0x40000 // Bit OBL_LAUNCH.

	// PDKEYR: Power down key register
	Flash_PDKEYR_PDKEYR_Pos = 0x0        // Position of PDKEYR field.
	Flash_PDKEYR_PDKEYR_Msk = 0xffffffff // Bit mask of PDKEYR field.

	// PEKEYR: Program/erase key register
	Flash_PEKEYR_PEKEYR_Pos = 0x0        // Position of PEKEYR field.
	Flash_PEKEYR_PEKEYR_Msk = 0xffffffff // Bit mask of PEKEYR field.

	// PRGKEYR: Program memory key register
	Flash_PRGKEYR_PRGKEYR_Pos = 0x0        // Position of PRGKEYR field.
	Flash_PRGKEYR_PRGKEYR_Msk = 0xffffffff // Bit mask of PRGKEYR field.

	// OPTKEYR: Option byte key register
	Flash_OPTKEYR_OPTKEYR_Pos = 0x0        // Position of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Msk = 0xffffffff // Bit mask of OPTKEYR field.

	// SR: Status register
	Flash_SR_BSY_Pos        = 0x0     // Position of BSY field.
	Flash_SR_BSY_Msk        = 0x1     // Bit mask of BSY field.
	Flash_SR_BSY            = 0x1     // Bit BSY.
	Flash_SR_EOP_Pos        = 0x1     // Position of EOP field.
	Flash_SR_EOP_Msk        = 0x2     // Bit mask of EOP field.
	Flash_SR_EOP            = 0x2     // Bit EOP.
	Flash_SR_ENDHV_Pos      = 0x2     // Position of ENDHV field.
	Flash_SR_ENDHV_Msk      = 0x4     // Bit mask of ENDHV field.
	Flash_SR_ENDHV          = 0x4     // Bit ENDHV.
	Flash_SR_READY_Pos      = 0x3     // Position of READY field.
	Flash_SR_READY_Msk      = 0x8     // Bit mask of READY field.
	Flash_SR_READY          = 0x8     // Bit READY.
	Flash_SR_WRPERR_Pos     = 0x8     // Position of WRPERR field.
	Flash_SR_WRPERR_Msk     = 0x100   // Bit mask of WRPERR field.
	Flash_SR_WRPERR         = 0x100   // Bit WRPERR.
	Flash_SR_PGAERR_Pos     = 0x9     // Position of PGAERR field.
	Flash_SR_PGAERR_Msk     = 0x200   // Bit mask of PGAERR field.
	Flash_SR_PGAERR         = 0x200   // Bit PGAERR.
	Flash_SR_SIZERR_Pos     = 0xa     // Position of SIZERR field.
	Flash_SR_SIZERR_Msk     = 0x400   // Bit mask of SIZERR field.
	Flash_SR_SIZERR         = 0x400   // Bit SIZERR.
	Flash_SR_OPTVERR_Pos    = 0xb     // Position of OPTVERR field.
	Flash_SR_OPTVERR_Msk    = 0x800   // Bit mask of OPTVERR field.
	Flash_SR_OPTVERR        = 0x800   // Bit OPTVERR.
	Flash_SR_RDERR_Pos      = 0xe     // Position of RDERR field.
	Flash_SR_RDERR_Msk      = 0x4000  // Bit mask of RDERR field.
	Flash_SR_RDERR          = 0x4000  // Bit RDERR.
	Flash_SR_NOTZEROERR_Pos = 0x10    // Position of NOTZEROERR field.
	Flash_SR_NOTZEROERR_Msk = 0x10000 // Bit mask of NOTZEROERR field.
	Flash_SR_NOTZEROERR     = 0x10000 // Bit NOTZEROERR.
	Flash_SR_FWWERR_Pos     = 0x11    // Position of FWWERR field.
	Flash_SR_FWWERR_Msk     = 0x20000 // Bit mask of FWWERR field.
	Flash_SR_FWWERR         = 0x20000 // Bit FWWERR.

	// OBR: Option byte register
	Flash_OBR_RDPRT_Pos   = 0x0     // Position of RDPRT field.
	Flash_OBR_RDPRT_Msk   = 0xff    // Bit mask of RDPRT field.
	Flash_OBR_BOR_LEV_Pos = 0x10    // Position of BOR_LEV field.
	Flash_OBR_BOR_LEV_Msk = 0xf0000 // Bit mask of BOR_LEV field.
	Flash_OBR_SPRMOD_Pos  = 0x8     // Position of SPRMOD field.
	Flash_OBR_SPRMOD_Msk  = 0x100   // Bit mask of SPRMOD field.
	Flash_OBR_SPRMOD      = 0x100   // Bit SPRMOD.

	// WRPR: Write protection register
	Flash_WRPR_WRP_Pos = 0x0    // Position of WRP field.
	Flash_WRPR_WRP_Msk = 0xffff // Bit mask of WRP field.
)

// Bitfields for EXTI: External interrupt/event controller
const (
	// IMR: Interrupt mask register           (EXTI_IMR)
	EXTI_IMR_IM0_Pos  = 0x0        // Position of IM0 field.
	EXTI_IMR_IM0_Msk  = 0x1        // Bit mask of IM0 field.
	EXTI_IMR_IM0      = 0x1        // Bit IM0.
	EXTI_IMR_IM1_Pos  = 0x1        // Position of IM1 field.
	EXTI_IMR_IM1_Msk  = 0x2        // Bit mask of IM1 field.
	EXTI_IMR_IM1      = 0x2        // Bit IM1.
	EXTI_IMR_IM2_Pos  = 0x2        // Position of IM2 field.
	EXTI_IMR_IM2_Msk  = 0x4        // Bit mask of IM2 field.
	EXTI_IMR_IM2      = 0x4        // Bit IM2.
	EXTI_IMR_IM3_Pos  = 0x3        // Position of IM3 field.
	EXTI_IMR_IM3_Msk  = 0x8        // Bit mask of IM3 field.
	EXTI_IMR_IM3      = 0x8        // Bit IM3.
	EXTI_IMR_IM4_Pos  = 0x4        // Position of IM4 field.
	EXTI_IMR_IM4_Msk  = 0x10       // Bit mask of IM4 field.
	EXTI_IMR_IM4      = 0x10       // Bit IM4.
	EXTI_IMR_IM5_Pos  = 0x5        // Position of IM5 field.
	EXTI_IMR_IM5_Msk  = 0x20       // Bit mask of IM5 field.
	EXTI_IMR_IM5      = 0x20       // Bit IM5.
	EXTI_IMR_IM6_Pos  = 0x6        // Position of IM6 field.
	EXTI_IMR_IM6_Msk  = 0x40       // Bit mask of IM6 field.
	EXTI_IMR_IM6      = 0x40       // Bit IM6.
	EXTI_IMR_IM7_Pos  = 0x7        // Position of IM7 field.
	EXTI_IMR_IM7_Msk  = 0x80       // Bit mask of IM7 field.
	EXTI_IMR_IM7      = 0x80       // Bit IM7.
	EXTI_IMR_IM8_Pos  = 0x8        // Position of IM8 field.
	EXTI_IMR_IM8_Msk  = 0x100      // Bit mask of IM8 field.
	EXTI_IMR_IM8      = 0x100      // Bit IM8.
	EXTI_IMR_IM9_Pos  = 0x9        // Position of IM9 field.
	EXTI_IMR_IM9_Msk  = 0x200      // Bit mask of IM9 field.
	EXTI_IMR_IM9      = 0x200      // Bit IM9.
	EXTI_IMR_IM10_Pos = 0xa        // Position of IM10 field.
	EXTI_IMR_IM10_Msk = 0x400      // Bit mask of IM10 field.
	EXTI_IMR_IM10     = 0x400      // Bit IM10.
	EXTI_IMR_IM11_Pos = 0xb        // Position of IM11 field.
	EXTI_IMR_IM11_Msk = 0x800      // Bit mask of IM11 field.
	EXTI_IMR_IM11     = 0x800      // Bit IM11.
	EXTI_IMR_IM12_Pos = 0xc        // Position of IM12 field.
	EXTI_IMR_IM12_Msk = 0x1000     // Bit mask of IM12 field.
	EXTI_IMR_IM12     = 0x1000     // Bit IM12.
	EXTI_IMR_IM13_Pos = 0xd        // Position of IM13 field.
	EXTI_IMR_IM13_Msk = 0x2000     // Bit mask of IM13 field.
	EXTI_IMR_IM13     = 0x2000     // Bit IM13.
	EXTI_IMR_IM14_Pos = 0xe        // Position of IM14 field.
	EXTI_IMR_IM14_Msk = 0x4000     // Bit mask of IM14 field.
	EXTI_IMR_IM14     = 0x4000     // Bit IM14.
	EXTI_IMR_IM15_Pos = 0xf        // Position of IM15 field.
	EXTI_IMR_IM15_Msk = 0x8000     // Bit mask of IM15 field.
	EXTI_IMR_IM15     = 0x8000     // Bit IM15.
	EXTI_IMR_IM16_Pos = 0x10       // Position of IM16 field.
	EXTI_IMR_IM16_Msk = 0x10000    // Bit mask of IM16 field.
	EXTI_IMR_IM16     = 0x10000    // Bit IM16.
	EXTI_IMR_IM17_Pos = 0x11       // Position of IM17 field.
	EXTI_IMR_IM17_Msk = 0x20000    // Bit mask of IM17 field.
	EXTI_IMR_IM17     = 0x20000    // Bit IM17.
	EXTI_IMR_IM18_Pos = 0x12       // Position of IM18 field.
	EXTI_IMR_IM18_Msk = 0x40000    // Bit mask of IM18 field.
	EXTI_IMR_IM18     = 0x40000    // Bit IM18.
	EXTI_IMR_IM19_Pos = 0x13       // Position of IM19 field.
	EXTI_IMR_IM19_Msk = 0x80000    // Bit mask of IM19 field.
	EXTI_IMR_IM19     = 0x80000    // Bit IM19.
	EXTI_IMR_IM20_Pos = 0x14       // Position of IM20 field.
	EXTI_IMR_IM20_Msk = 0x100000   // Bit mask of IM20 field.
	EXTI_IMR_IM20     = 0x100000   // Bit IM20.
	EXTI_IMR_IM21_Pos = 0x15       // Position of IM21 field.
	EXTI_IMR_IM21_Msk = 0x200000   // Bit mask of IM21 field.
	EXTI_IMR_IM21     = 0x200000   // Bit IM21.
	EXTI_IMR_IM22_Pos = 0x16       // Position of IM22 field.
	EXTI_IMR_IM22_Msk = 0x400000   // Bit mask of IM22 field.
	EXTI_IMR_IM22     = 0x400000   // Bit IM22.
	EXTI_IMR_IM23_Pos = 0x17       // Position of IM23 field.
	EXTI_IMR_IM23_Msk = 0x800000   // Bit mask of IM23 field.
	EXTI_IMR_IM23     = 0x800000   // Bit IM23.
	EXTI_IMR_IM24_Pos = 0x18       // Position of IM24 field.
	EXTI_IMR_IM24_Msk = 0x1000000  // Bit mask of IM24 field.
	EXTI_IMR_IM24     = 0x1000000  // Bit IM24.
	EXTI_IMR_IM25_Pos = 0x19       // Position of IM25 field.
	EXTI_IMR_IM25_Msk = 0x2000000  // Bit mask of IM25 field.
	EXTI_IMR_IM25     = 0x2000000  // Bit IM25.
	EXTI_IMR_IM26_Pos = 0x1a       // Position of IM26 field.
	EXTI_IMR_IM26_Msk = 0x4000000  // Bit mask of IM26 field.
	EXTI_IMR_IM26     = 0x4000000  // Bit IM26.
	EXTI_IMR_IM28_Pos = 0x1c       // Position of IM28 field.
	EXTI_IMR_IM28_Msk = 0x10000000 // Bit mask of IM28 field.
	EXTI_IMR_IM28     = 0x10000000 // Bit IM28.
	EXTI_IMR_IM29_Pos = 0x1d       // Position of IM29 field.
	EXTI_IMR_IM29_Msk = 0x20000000 // Bit mask of IM29 field.
	EXTI_IMR_IM29     = 0x20000000 // Bit IM29.

	// EMR: Event mask register (EXTI_EMR)
	EXTI_EMR_EM0_Pos  = 0x0        // Position of EM0 field.
	EXTI_EMR_EM0_Msk  = 0x1        // Bit mask of EM0 field.
	EXTI_EMR_EM0      = 0x1        // Bit EM0.
	EXTI_EMR_EM1_Pos  = 0x1        // Position of EM1 field.
	EXTI_EMR_EM1_Msk  = 0x2        // Bit mask of EM1 field.
	EXTI_EMR_EM1      = 0x2        // Bit EM1.
	EXTI_EMR_EM2_Pos  = 0x2        // Position of EM2 field.
	EXTI_EMR_EM2_Msk  = 0x4        // Bit mask of EM2 field.
	EXTI_EMR_EM2      = 0x4        // Bit EM2.
	EXTI_EMR_EM3_Pos  = 0x3        // Position of EM3 field.
	EXTI_EMR_EM3_Msk  = 0x8        // Bit mask of EM3 field.
	EXTI_EMR_EM3      = 0x8        // Bit EM3.
	EXTI_EMR_EM4_Pos  = 0x4        // Position of EM4 field.
	EXTI_EMR_EM4_Msk  = 0x10       // Bit mask of EM4 field.
	EXTI_EMR_EM4      = 0x10       // Bit EM4.
	EXTI_EMR_EM5_Pos  = 0x5        // Position of EM5 field.
	EXTI_EMR_EM5_Msk  = 0x20       // Bit mask of EM5 field.
	EXTI_EMR_EM5      = 0x20       // Bit EM5.
	EXTI_EMR_EM6_Pos  = 0x6        // Position of EM6 field.
	EXTI_EMR_EM6_Msk  = 0x40       // Bit mask of EM6 field.
	EXTI_EMR_EM6      = 0x40       // Bit EM6.
	EXTI_EMR_EM7_Pos  = 0x7        // Position of EM7 field.
	EXTI_EMR_EM7_Msk  = 0x80       // Bit mask of EM7 field.
	EXTI_EMR_EM7      = 0x80       // Bit EM7.
	EXTI_EMR_EM8_Pos  = 0x8        // Position of EM8 field.
	EXTI_EMR_EM8_Msk  = 0x100      // Bit mask of EM8 field.
	EXTI_EMR_EM8      = 0x100      // Bit EM8.
	EXTI_EMR_EM9_Pos  = 0x9        // Position of EM9 field.
	EXTI_EMR_EM9_Msk  = 0x200      // Bit mask of EM9 field.
	EXTI_EMR_EM9      = 0x200      // Bit EM9.
	EXTI_EMR_EM10_Pos = 0xa        // Position of EM10 field.
	EXTI_EMR_EM10_Msk = 0x400      // Bit mask of EM10 field.
	EXTI_EMR_EM10     = 0x400      // Bit EM10.
	EXTI_EMR_EM11_Pos = 0xb        // Position of EM11 field.
	EXTI_EMR_EM11_Msk = 0x800      // Bit mask of EM11 field.
	EXTI_EMR_EM11     = 0x800      // Bit EM11.
	EXTI_EMR_EM12_Pos = 0xc        // Position of EM12 field.
	EXTI_EMR_EM12_Msk = 0x1000     // Bit mask of EM12 field.
	EXTI_EMR_EM12     = 0x1000     // Bit EM12.
	EXTI_EMR_EM13_Pos = 0xd        // Position of EM13 field.
	EXTI_EMR_EM13_Msk = 0x2000     // Bit mask of EM13 field.
	EXTI_EMR_EM13     = 0x2000     // Bit EM13.
	EXTI_EMR_EM14_Pos = 0xe        // Position of EM14 field.
	EXTI_EMR_EM14_Msk = 0x4000     // Bit mask of EM14 field.
	EXTI_EMR_EM14     = 0x4000     // Bit EM14.
	EXTI_EMR_EM15_Pos = 0xf        // Position of EM15 field.
	EXTI_EMR_EM15_Msk = 0x8000     // Bit mask of EM15 field.
	EXTI_EMR_EM15     = 0x8000     // Bit EM15.
	EXTI_EMR_EM16_Pos = 0x10       // Position of EM16 field.
	EXTI_EMR_EM16_Msk = 0x10000    // Bit mask of EM16 field.
	EXTI_EMR_EM16     = 0x10000    // Bit EM16.
	EXTI_EMR_EM17_Pos = 0x11       // Position of EM17 field.
	EXTI_EMR_EM17_Msk = 0x20000    // Bit mask of EM17 field.
	EXTI_EMR_EM17     = 0x20000    // Bit EM17.
	EXTI_EMR_EM18_Pos = 0x12       // Position of EM18 field.
	EXTI_EMR_EM18_Msk = 0x40000    // Bit mask of EM18 field.
	EXTI_EMR_EM18     = 0x40000    // Bit EM18.
	EXTI_EMR_EM19_Pos = 0x13       // Position of EM19 field.
	EXTI_EMR_EM19_Msk = 0x80000    // Bit mask of EM19 field.
	EXTI_EMR_EM19     = 0x80000    // Bit EM19.
	EXTI_EMR_EM20_Pos = 0x14       // Position of EM20 field.
	EXTI_EMR_EM20_Msk = 0x100000   // Bit mask of EM20 field.
	EXTI_EMR_EM20     = 0x100000   // Bit EM20.
	EXTI_EMR_EM21_Pos = 0x15       // Position of EM21 field.
	EXTI_EMR_EM21_Msk = 0x200000   // Bit mask of EM21 field.
	EXTI_EMR_EM21     = 0x200000   // Bit EM21.
	EXTI_EMR_EM22_Pos = 0x16       // Position of EM22 field.
	EXTI_EMR_EM22_Msk = 0x400000   // Bit mask of EM22 field.
	EXTI_EMR_EM22     = 0x400000   // Bit EM22.
	EXTI_EMR_EM23_Pos = 0x17       // Position of EM23 field.
	EXTI_EMR_EM23_Msk = 0x800000   // Bit mask of EM23 field.
	EXTI_EMR_EM23     = 0x800000   // Bit EM23.
	EXTI_EMR_EM24_Pos = 0x18       // Position of EM24 field.
	EXTI_EMR_EM24_Msk = 0x1000000  // Bit mask of EM24 field.
	EXTI_EMR_EM24     = 0x1000000  // Bit EM24.
	EXTI_EMR_EM25_Pos = 0x19       // Position of EM25 field.
	EXTI_EMR_EM25_Msk = 0x2000000  // Bit mask of EM25 field.
	EXTI_EMR_EM25     = 0x2000000  // Bit EM25.
	EXTI_EMR_EM26_Pos = 0x1a       // Position of EM26 field.
	EXTI_EMR_EM26_Msk = 0x4000000  // Bit mask of EM26 field.
	EXTI_EMR_EM26     = 0x4000000  // Bit EM26.
	EXTI_EMR_EM28_Pos = 0x1c       // Position of EM28 field.
	EXTI_EMR_EM28_Msk = 0x10000000 // Bit mask of EM28 field.
	EXTI_EMR_EM28     = 0x10000000 // Bit EM28.
	EXTI_EMR_EM29_Pos = 0x1d       // Position of EM29 field.
	EXTI_EMR_EM29_Msk = 0x20000000 // Bit mask of EM29 field.
	EXTI_EMR_EM29     = 0x20000000 // Bit EM29.

	// RTSR: Rising Trigger selection register           (EXTI_RTSR)
	EXTI_RTSR_RT0_Pos  = 0x0      // Position of RT0 field.
	EXTI_RTSR_RT0_Msk  = 0x1      // Bit mask of RT0 field.
	EXTI_RTSR_RT0      = 0x1      // Bit RT0.
	EXTI_RTSR_RT1_Pos  = 0x1      // Position of RT1 field.
	EXTI_RTSR_RT1_Msk  = 0x2      // Bit mask of RT1 field.
	EXTI_RTSR_RT1      = 0x2      // Bit RT1.
	EXTI_RTSR_RT2_Pos  = 0x2      // Position of RT2 field.
	EXTI_RTSR_RT2_Msk  = 0x4      // Bit mask of RT2 field.
	EXTI_RTSR_RT2      = 0x4      // Bit RT2.
	EXTI_RTSR_RT3_Pos  = 0x3      // Position of RT3 field.
	EXTI_RTSR_RT3_Msk  = 0x8      // Bit mask of RT3 field.
	EXTI_RTSR_RT3      = 0x8      // Bit RT3.
	EXTI_RTSR_RT4_Pos  = 0x4      // Position of RT4 field.
	EXTI_RTSR_RT4_Msk  = 0x10     // Bit mask of RT4 field.
	EXTI_RTSR_RT4      = 0x10     // Bit RT4.
	EXTI_RTSR_RT5_Pos  = 0x5      // Position of RT5 field.
	EXTI_RTSR_RT5_Msk  = 0x20     // Bit mask of RT5 field.
	EXTI_RTSR_RT5      = 0x20     // Bit RT5.
	EXTI_RTSR_RT6_Pos  = 0x6      // Position of RT6 field.
	EXTI_RTSR_RT6_Msk  = 0x40     // Bit mask of RT6 field.
	EXTI_RTSR_RT6      = 0x40     // Bit RT6.
	EXTI_RTSR_RT7_Pos  = 0x7      // Position of RT7 field.
	EXTI_RTSR_RT7_Msk  = 0x80     // Bit mask of RT7 field.
	EXTI_RTSR_RT7      = 0x80     // Bit RT7.
	EXTI_RTSR_RT8_Pos  = 0x8      // Position of RT8 field.
	EXTI_RTSR_RT8_Msk  = 0x100    // Bit mask of RT8 field.
	EXTI_RTSR_RT8      = 0x100    // Bit RT8.
	EXTI_RTSR_RT9_Pos  = 0x9      // Position of RT9 field.
	EXTI_RTSR_RT9_Msk  = 0x200    // Bit mask of RT9 field.
	EXTI_RTSR_RT9      = 0x200    // Bit RT9.
	EXTI_RTSR_RT10_Pos = 0xa      // Position of RT10 field.
	EXTI_RTSR_RT10_Msk = 0x400    // Bit mask of RT10 field.
	EXTI_RTSR_RT10     = 0x400    // Bit RT10.
	EXTI_RTSR_RT11_Pos = 0xb      // Position of RT11 field.
	EXTI_RTSR_RT11_Msk = 0x800    // Bit mask of RT11 field.
	EXTI_RTSR_RT11     = 0x800    // Bit RT11.
	EXTI_RTSR_RT12_Pos = 0xc      // Position of RT12 field.
	EXTI_RTSR_RT12_Msk = 0x1000   // Bit mask of RT12 field.
	EXTI_RTSR_RT12     = 0x1000   // Bit RT12.
	EXTI_RTSR_RT13_Pos = 0xd      // Position of RT13 field.
	EXTI_RTSR_RT13_Msk = 0x2000   // Bit mask of RT13 field.
	EXTI_RTSR_RT13     = 0x2000   // Bit RT13.
	EXTI_RTSR_RT14_Pos = 0xe      // Position of RT14 field.
	EXTI_RTSR_RT14_Msk = 0x4000   // Bit mask of RT14 field.
	EXTI_RTSR_RT14     = 0x4000   // Bit RT14.
	EXTI_RTSR_RT15_Pos = 0xf      // Position of RT15 field.
	EXTI_RTSR_RT15_Msk = 0x8000   // Bit mask of RT15 field.
	EXTI_RTSR_RT15     = 0x8000   // Bit RT15.
	EXTI_RTSR_RT16_Pos = 0x10     // Position of RT16 field.
	EXTI_RTSR_RT16_Msk = 0x10000  // Bit mask of RT16 field.
	EXTI_RTSR_RT16     = 0x10000  // Bit RT16.
	EXTI_RTSR_RT17_Pos = 0x11     // Position of RT17 field.
	EXTI_RTSR_RT17_Msk = 0x20000  // Bit mask of RT17 field.
	EXTI_RTSR_RT17     = 0x20000  // Bit RT17.
	EXTI_RTSR_RT19_Pos = 0x13     // Position of RT19 field.
	EXTI_RTSR_RT19_Msk = 0x80000  // Bit mask of RT19 field.
	EXTI_RTSR_RT19     = 0x80000  // Bit RT19.
	EXTI_RTSR_RT20_Pos = 0x14     // Position of RT20 field.
	EXTI_RTSR_RT20_Msk = 0x100000 // Bit mask of RT20 field.
	EXTI_RTSR_RT20     = 0x100000 // Bit RT20.
	EXTI_RTSR_RT21_Pos = 0x15     // Position of RT21 field.
	EXTI_RTSR_RT21_Msk = 0x200000 // Bit mask of RT21 field.
	EXTI_RTSR_RT21     = 0x200000 // Bit RT21.
	EXTI_RTSR_RT22_Pos = 0x16     // Position of RT22 field.
	EXTI_RTSR_RT22_Msk = 0x400000 // Bit mask of RT22 field.
	EXTI_RTSR_RT22     = 0x400000 // Bit RT22.

	// FTSR: Falling Trigger selection register           (EXTI_FTSR)
	EXTI_FTSR_FT0_Pos  = 0x0      // Position of FT0 field.
	EXTI_FTSR_FT0_Msk  = 0x1      // Bit mask of FT0 field.
	EXTI_FTSR_FT0      = 0x1      // Bit FT0.
	EXTI_FTSR_FT1_Pos  = 0x1      // Position of FT1 field.
	EXTI_FTSR_FT1_Msk  = 0x2      // Bit mask of FT1 field.
	EXTI_FTSR_FT1      = 0x2      // Bit FT1.
	EXTI_FTSR_FT2_Pos  = 0x2      // Position of FT2 field.
	EXTI_FTSR_FT2_Msk  = 0x4      // Bit mask of FT2 field.
	EXTI_FTSR_FT2      = 0x4      // Bit FT2.
	EXTI_FTSR_FT3_Pos  = 0x3      // Position of FT3 field.
	EXTI_FTSR_FT3_Msk  = 0x8      // Bit mask of FT3 field.
	EXTI_FTSR_FT3      = 0x8      // Bit FT3.
	EXTI_FTSR_FT4_Pos  = 0x4      // Position of FT4 field.
	EXTI_FTSR_FT4_Msk  = 0x10     // Bit mask of FT4 field.
	EXTI_FTSR_FT4      = 0x10     // Bit FT4.
	EXTI_FTSR_FT5_Pos  = 0x5      // Position of FT5 field.
	EXTI_FTSR_FT5_Msk  = 0x20     // Bit mask of FT5 field.
	EXTI_FTSR_FT5      = 0x20     // Bit FT5.
	EXTI_FTSR_FT6_Pos  = 0x6      // Position of FT6 field.
	EXTI_FTSR_FT6_Msk  = 0x40     // Bit mask of FT6 field.
	EXTI_FTSR_FT6      = 0x40     // Bit FT6.
	EXTI_FTSR_FT7_Pos  = 0x7      // Position of FT7 field.
	EXTI_FTSR_FT7_Msk  = 0x80     // Bit mask of FT7 field.
	EXTI_FTSR_FT7      = 0x80     // Bit FT7.
	EXTI_FTSR_FT8_Pos  = 0x8      // Position of FT8 field.
	EXTI_FTSR_FT8_Msk  = 0x100    // Bit mask of FT8 field.
	EXTI_FTSR_FT8      = 0x100    // Bit FT8.
	EXTI_FTSR_FT9_Pos  = 0x9      // Position of FT9 field.
	EXTI_FTSR_FT9_Msk  = 0x200    // Bit mask of FT9 field.
	EXTI_FTSR_FT9      = 0x200    // Bit FT9.
	EXTI_FTSR_FT10_Pos = 0xa      // Position of FT10 field.
	EXTI_FTSR_FT10_Msk = 0x400    // Bit mask of FT10 field.
	EXTI_FTSR_FT10     = 0x400    // Bit FT10.
	EXTI_FTSR_FT11_Pos = 0xb      // Position of FT11 field.
	EXTI_FTSR_FT11_Msk = 0x800    // Bit mask of FT11 field.
	EXTI_FTSR_FT11     = 0x800    // Bit FT11.
	EXTI_FTSR_FT12_Pos = 0xc      // Position of FT12 field.
	EXTI_FTSR_FT12_Msk = 0x1000   // Bit mask of FT12 field.
	EXTI_FTSR_FT12     = 0x1000   // Bit FT12.
	EXTI_FTSR_FT13_Pos = 0xd      // Position of FT13 field.
	EXTI_FTSR_FT13_Msk = 0x2000   // Bit mask of FT13 field.
	EXTI_FTSR_FT13     = 0x2000   // Bit FT13.
	EXTI_FTSR_FT14_Pos = 0xe      // Position of FT14 field.
	EXTI_FTSR_FT14_Msk = 0x4000   // Bit mask of FT14 field.
	EXTI_FTSR_FT14     = 0x4000   // Bit FT14.
	EXTI_FTSR_FT15_Pos = 0xf      // Position of FT15 field.
	EXTI_FTSR_FT15_Msk = 0x8000   // Bit mask of FT15 field.
	EXTI_FTSR_FT15     = 0x8000   // Bit FT15.
	EXTI_FTSR_FT16_Pos = 0x10     // Position of FT16 field.
	EXTI_FTSR_FT16_Msk = 0x10000  // Bit mask of FT16 field.
	EXTI_FTSR_FT16     = 0x10000  // Bit FT16.
	EXTI_FTSR_FT17_Pos = 0x11     // Position of FT17 field.
	EXTI_FTSR_FT17_Msk = 0x20000  // Bit mask of FT17 field.
	EXTI_FTSR_FT17     = 0x20000  // Bit FT17.
	EXTI_FTSR_FT19_Pos = 0x13     // Position of FT19 field.
	EXTI_FTSR_FT19_Msk = 0x80000  // Bit mask of FT19 field.
	EXTI_FTSR_FT19     = 0x80000  // Bit FT19.
	EXTI_FTSR_FT20_Pos = 0x14     // Position of FT20 field.
	EXTI_FTSR_FT20_Msk = 0x100000 // Bit mask of FT20 field.
	EXTI_FTSR_FT20     = 0x100000 // Bit FT20.
	EXTI_FTSR_FT21_Pos = 0x15     // Position of FT21 field.
	EXTI_FTSR_FT21_Msk = 0x200000 // Bit mask of FT21 field.
	EXTI_FTSR_FT21     = 0x200000 // Bit FT21.
	EXTI_FTSR_FT22_Pos = 0x16     // Position of FT22 field.
	EXTI_FTSR_FT22_Msk = 0x400000 // Bit mask of FT22 field.
	EXTI_FTSR_FT22     = 0x400000 // Bit FT22.

	// SWIER: Software interrupt event register           (EXTI_SWIER)
	EXTI_SWIER_SWI0_Pos  = 0x0      // Position of SWI0 field.
	EXTI_SWIER_SWI0_Msk  = 0x1      // Bit mask of SWI0 field.
	EXTI_SWIER_SWI0      = 0x1      // Bit SWI0.
	EXTI_SWIER_SWI1_Pos  = 0x1      // Position of SWI1 field.
	EXTI_SWIER_SWI1_Msk  = 0x2      // Bit mask of SWI1 field.
	EXTI_SWIER_SWI1      = 0x2      // Bit SWI1.
	EXTI_SWIER_SWI2_Pos  = 0x2      // Position of SWI2 field.
	EXTI_SWIER_SWI2_Msk  = 0x4      // Bit mask of SWI2 field.
	EXTI_SWIER_SWI2      = 0x4      // Bit SWI2.
	EXTI_SWIER_SWI3_Pos  = 0x3      // Position of SWI3 field.
	EXTI_SWIER_SWI3_Msk  = 0x8      // Bit mask of SWI3 field.
	EXTI_SWIER_SWI3      = 0x8      // Bit SWI3.
	EXTI_SWIER_SWI4_Pos  = 0x4      // Position of SWI4 field.
	EXTI_SWIER_SWI4_Msk  = 0x10     // Bit mask of SWI4 field.
	EXTI_SWIER_SWI4      = 0x10     // Bit SWI4.
	EXTI_SWIER_SWI5_Pos  = 0x5      // Position of SWI5 field.
	EXTI_SWIER_SWI5_Msk  = 0x20     // Bit mask of SWI5 field.
	EXTI_SWIER_SWI5      = 0x20     // Bit SWI5.
	EXTI_SWIER_SWI6_Pos  = 0x6      // Position of SWI6 field.
	EXTI_SWIER_SWI6_Msk  = 0x40     // Bit mask of SWI6 field.
	EXTI_SWIER_SWI6      = 0x40     // Bit SWI6.
	EXTI_SWIER_SWI7_Pos  = 0x7      // Position of SWI7 field.
	EXTI_SWIER_SWI7_Msk  = 0x80     // Bit mask of SWI7 field.
	EXTI_SWIER_SWI7      = 0x80     // Bit SWI7.
	EXTI_SWIER_SWI8_Pos  = 0x8      // Position of SWI8 field.
	EXTI_SWIER_SWI8_Msk  = 0x100    // Bit mask of SWI8 field.
	EXTI_SWIER_SWI8      = 0x100    // Bit SWI8.
	EXTI_SWIER_SWI9_Pos  = 0x9      // Position of SWI9 field.
	EXTI_SWIER_SWI9_Msk  = 0x200    // Bit mask of SWI9 field.
	EXTI_SWIER_SWI9      = 0x200    // Bit SWI9.
	EXTI_SWIER_SWI10_Pos = 0xa      // Position of SWI10 field.
	EXTI_SWIER_SWI10_Msk = 0x400    // Bit mask of SWI10 field.
	EXTI_SWIER_SWI10     = 0x400    // Bit SWI10.
	EXTI_SWIER_SWI11_Pos = 0xb      // Position of SWI11 field.
	EXTI_SWIER_SWI11_Msk = 0x800    // Bit mask of SWI11 field.
	EXTI_SWIER_SWI11     = 0x800    // Bit SWI11.
	EXTI_SWIER_SWI12_Pos = 0xc      // Position of SWI12 field.
	EXTI_SWIER_SWI12_Msk = 0x1000   // Bit mask of SWI12 field.
	EXTI_SWIER_SWI12     = 0x1000   // Bit SWI12.
	EXTI_SWIER_SWI13_Pos = 0xd      // Position of SWI13 field.
	EXTI_SWIER_SWI13_Msk = 0x2000   // Bit mask of SWI13 field.
	EXTI_SWIER_SWI13     = 0x2000   // Bit SWI13.
	EXTI_SWIER_SWI14_Pos = 0xe      // Position of SWI14 field.
	EXTI_SWIER_SWI14_Msk = 0x4000   // Bit mask of SWI14 field.
	EXTI_SWIER_SWI14     = 0x4000   // Bit SWI14.
	EXTI_SWIER_SWI15_Pos = 0xf      // Position of SWI15 field.
	EXTI_SWIER_SWI15_Msk = 0x8000   // Bit mask of SWI15 field.
	EXTI_SWIER_SWI15     = 0x8000   // Bit SWI15.
	EXTI_SWIER_SWI16_Pos = 0x10     // Position of SWI16 field.
	EXTI_SWIER_SWI16_Msk = 0x10000  // Bit mask of SWI16 field.
	EXTI_SWIER_SWI16     = 0x10000  // Bit SWI16.
	EXTI_SWIER_SWI17_Pos = 0x11     // Position of SWI17 field.
	EXTI_SWIER_SWI17_Msk = 0x20000  // Bit mask of SWI17 field.
	EXTI_SWIER_SWI17     = 0x20000  // Bit SWI17.
	EXTI_SWIER_SWI19_Pos = 0x13     // Position of SWI19 field.
	EXTI_SWIER_SWI19_Msk = 0x80000  // Bit mask of SWI19 field.
	EXTI_SWIER_SWI19     = 0x80000  // Bit SWI19.
	EXTI_SWIER_SWI20_Pos = 0x14     // Position of SWI20 field.
	EXTI_SWIER_SWI20_Msk = 0x100000 // Bit mask of SWI20 field.
	EXTI_SWIER_SWI20     = 0x100000 // Bit SWI20.
	EXTI_SWIER_SWI21_Pos = 0x15     // Position of SWI21 field.
	EXTI_SWIER_SWI21_Msk = 0x200000 // Bit mask of SWI21 field.
	EXTI_SWIER_SWI21     = 0x200000 // Bit SWI21.
	EXTI_SWIER_SWI22_Pos = 0x16     // Position of SWI22 field.
	EXTI_SWIER_SWI22_Msk = 0x400000 // Bit mask of SWI22 field.
	EXTI_SWIER_SWI22     = 0x400000 // Bit SWI22.

	// PR: Pending register (EXTI_PR)
	EXTI_PR_PIF0_Pos  = 0x0      // Position of PIF0 field.
	EXTI_PR_PIF0_Msk  = 0x1      // Bit mask of PIF0 field.
	EXTI_PR_PIF0      = 0x1      // Bit PIF0.
	EXTI_PR_PIF1_Pos  = 0x1      // Position of PIF1 field.
	EXTI_PR_PIF1_Msk  = 0x2      // Bit mask of PIF1 field.
	EXTI_PR_PIF1      = 0x2      // Bit PIF1.
	EXTI_PR_PIF2_Pos  = 0x2      // Position of PIF2 field.
	EXTI_PR_PIF2_Msk  = 0x4      // Bit mask of PIF2 field.
	EXTI_PR_PIF2      = 0x4      // Bit PIF2.
	EXTI_PR_PIF3_Pos  = 0x3      // Position of PIF3 field.
	EXTI_PR_PIF3_Msk  = 0x8      // Bit mask of PIF3 field.
	EXTI_PR_PIF3      = 0x8      // Bit PIF3.
	EXTI_PR_PIF4_Pos  = 0x4      // Position of PIF4 field.
	EXTI_PR_PIF4_Msk  = 0x10     // Bit mask of PIF4 field.
	EXTI_PR_PIF4      = 0x10     // Bit PIF4.
	EXTI_PR_PIF5_Pos  = 0x5      // Position of PIF5 field.
	EXTI_PR_PIF5_Msk  = 0x20     // Bit mask of PIF5 field.
	EXTI_PR_PIF5      = 0x20     // Bit PIF5.
	EXTI_PR_PIF6_Pos  = 0x6      // Position of PIF6 field.
	EXTI_PR_PIF6_Msk  = 0x40     // Bit mask of PIF6 field.
	EXTI_PR_PIF6      = 0x40     // Bit PIF6.
	EXTI_PR_PIF7_Pos  = 0x7      // Position of PIF7 field.
	EXTI_PR_PIF7_Msk  = 0x80     // Bit mask of PIF7 field.
	EXTI_PR_PIF7      = 0x80     // Bit PIF7.
	EXTI_PR_PIF8_Pos  = 0x8      // Position of PIF8 field.
	EXTI_PR_PIF8_Msk  = 0x100    // Bit mask of PIF8 field.
	EXTI_PR_PIF8      = 0x100    // Bit PIF8.
	EXTI_PR_PIF9_Pos  = 0x9      // Position of PIF9 field.
	EXTI_PR_PIF9_Msk  = 0x200    // Bit mask of PIF9 field.
	EXTI_PR_PIF9      = 0x200    // Bit PIF9.
	EXTI_PR_PIF10_Pos = 0xa      // Position of PIF10 field.
	EXTI_PR_PIF10_Msk = 0x400    // Bit mask of PIF10 field.
	EXTI_PR_PIF10     = 0x400    // Bit PIF10.
	EXTI_PR_PIF11_Pos = 0xb      // Position of PIF11 field.
	EXTI_PR_PIF11_Msk = 0x800    // Bit mask of PIF11 field.
	EXTI_PR_PIF11     = 0x800    // Bit PIF11.
	EXTI_PR_PIF12_Pos = 0xc      // Position of PIF12 field.
	EXTI_PR_PIF12_Msk = 0x1000   // Bit mask of PIF12 field.
	EXTI_PR_PIF12     = 0x1000   // Bit PIF12.
	EXTI_PR_PIF13_Pos = 0xd      // Position of PIF13 field.
	EXTI_PR_PIF13_Msk = 0x2000   // Bit mask of PIF13 field.
	EXTI_PR_PIF13     = 0x2000   // Bit PIF13.
	EXTI_PR_PIF14_Pos = 0xe      // Position of PIF14 field.
	EXTI_PR_PIF14_Msk = 0x4000   // Bit mask of PIF14 field.
	EXTI_PR_PIF14     = 0x4000   // Bit PIF14.
	EXTI_PR_PIF15_Pos = 0xf      // Position of PIF15 field.
	EXTI_PR_PIF15_Msk = 0x8000   // Bit mask of PIF15 field.
	EXTI_PR_PIF15     = 0x8000   // Bit PIF15.
	EXTI_PR_PIF16_Pos = 0x10     // Position of PIF16 field.
	EXTI_PR_PIF16_Msk = 0x10000  // Bit mask of PIF16 field.
	EXTI_PR_PIF16     = 0x10000  // Bit PIF16.
	EXTI_PR_PIF17_Pos = 0x11     // Position of PIF17 field.
	EXTI_PR_PIF17_Msk = 0x20000  // Bit mask of PIF17 field.
	EXTI_PR_PIF17     = 0x20000  // Bit PIF17.
	EXTI_PR_PIF19_Pos = 0x13     // Position of PIF19 field.
	EXTI_PR_PIF19_Msk = 0x80000  // Bit mask of PIF19 field.
	EXTI_PR_PIF19     = 0x80000  // Bit PIF19.
	EXTI_PR_PIF20_Pos = 0x14     // Position of PIF20 field.
	EXTI_PR_PIF20_Msk = 0x100000 // Bit mask of PIF20 field.
	EXTI_PR_PIF20     = 0x100000 // Bit PIF20.
	EXTI_PR_PIF21_Pos = 0x15     // Position of PIF21 field.
	EXTI_PR_PIF21_Msk = 0x200000 // Bit mask of PIF21 field.
	EXTI_PR_PIF21     = 0x200000 // Bit PIF21.
	EXTI_PR_PIF22_Pos = 0x16     // Position of PIF22 field.
	EXTI_PR_PIF22_Msk = 0x400000 // Bit mask of PIF22 field.
	EXTI_PR_PIF22     = 0x400000 // Bit PIF22.
)

// Bitfields for ADC: Analog-to-digital converter
const (
	// ISR: interrupt and status register
	ADC_ISR_ADRDY_Pos = 0x0   // Position of ADRDY field.
	ADC_ISR_ADRDY_Msk = 0x1   // Bit mask of ADRDY field.
	ADC_ISR_ADRDY     = 0x1   // Bit ADRDY.
	ADC_ISR_EOSMP_Pos = 0x1   // Position of EOSMP field.
	ADC_ISR_EOSMP_Msk = 0x2   // Bit mask of EOSMP field.
	ADC_ISR_EOSMP     = 0x2   // Bit EOSMP.
	ADC_ISR_EOC_Pos   = 0x2   // Position of EOC field.
	ADC_ISR_EOC_Msk   = 0x4   // Bit mask of EOC field.
	ADC_ISR_EOC       = 0x4   // Bit EOC.
	ADC_ISR_EOS_Pos   = 0x3   // Position of EOS field.
	ADC_ISR_EOS_Msk   = 0x8   // Bit mask of EOS field.
	ADC_ISR_EOS       = 0x8   // Bit EOS.
	ADC_ISR_OVR_Pos   = 0x4   // Position of OVR field.
	ADC_ISR_OVR_Msk   = 0x10  // Bit mask of OVR field.
	ADC_ISR_OVR       = 0x10  // Bit OVR.
	ADC_ISR_AWD_Pos   = 0x7   // Position of AWD field.
	ADC_ISR_AWD_Msk   = 0x80  // Bit mask of AWD field.
	ADC_ISR_AWD       = 0x80  // Bit AWD.
	ADC_ISR_EOCAL_Pos = 0xb   // Position of EOCAL field.
	ADC_ISR_EOCAL_Msk = 0x800 // Bit mask of EOCAL field.
	ADC_ISR_EOCAL     = 0x800 // Bit EOCAL.

	// IER: interrupt enable register
	ADC_IER_ADRDYIE_Pos = 0x0   // Position of ADRDYIE field.
	ADC_IER_ADRDYIE_Msk = 0x1   // Bit mask of ADRDYIE field.
	ADC_IER_ADRDYIE     = 0x1   // Bit ADRDYIE.
	ADC_IER_EOSMPIE_Pos = 0x1   // Position of EOSMPIE field.
	ADC_IER_EOSMPIE_Msk = 0x2   // Bit mask of EOSMPIE field.
	ADC_IER_EOSMPIE     = 0x2   // Bit EOSMPIE.
	ADC_IER_EOCIE_Pos   = 0x2   // Position of EOCIE field.
	ADC_IER_EOCIE_Msk   = 0x4   // Bit mask of EOCIE field.
	ADC_IER_EOCIE       = 0x4   // Bit EOCIE.
	ADC_IER_EOSIE_Pos   = 0x3   // Position of EOSIE field.
	ADC_IER_EOSIE_Msk   = 0x8   // Bit mask of EOSIE field.
	ADC_IER_EOSIE       = 0x8   // Bit EOSIE.
	ADC_IER_OVRIE_Pos   = 0x4   // Position of OVRIE field.
	ADC_IER_OVRIE_Msk   = 0x10  // Bit mask of OVRIE field.
	ADC_IER_OVRIE       = 0x10  // Bit OVRIE.
	ADC_IER_AWDIE_Pos   = 0x7   // Position of AWDIE field.
	ADC_IER_AWDIE_Msk   = 0x80  // Bit mask of AWDIE field.
	ADC_IER_AWDIE       = 0x80  // Bit AWDIE.
	ADC_IER_EOCALIE_Pos = 0xb   // Position of EOCALIE field.
	ADC_IER_EOCALIE_Msk = 0x800 // Bit mask of EOCALIE field.
	ADC_IER_EOCALIE     = 0x800 // Bit EOCALIE.

	// CR: control register
	ADC_CR_ADEN_Pos     = 0x0        // Position of ADEN field.
	ADC_CR_ADEN_Msk     = 0x1        // Bit mask of ADEN field.
	ADC_CR_ADEN         = 0x1        // Bit ADEN.
	ADC_CR_ADDIS_Pos    = 0x1        // Position of ADDIS field.
	ADC_CR_ADDIS_Msk    = 0x2        // Bit mask of ADDIS field.
	ADC_CR_ADDIS        = 0x2        // Bit ADDIS.
	ADC_CR_ADSTART_Pos  = 0x2        // Position of ADSTART field.
	ADC_CR_ADSTART_Msk  = 0x4        // Bit mask of ADSTART field.
	ADC_CR_ADSTART      = 0x4        // Bit ADSTART.
	ADC_CR_ADSTP_Pos    = 0x4        // Position of ADSTP field.
	ADC_CR_ADSTP_Msk    = 0x10       // Bit mask of ADSTP field.
	ADC_CR_ADSTP        = 0x10       // Bit ADSTP.
	ADC_CR_ADVREGEN_Pos = 0x1c       // Position of ADVREGEN field.
	ADC_CR_ADVREGEN_Msk = 0x10000000 // Bit mask of ADVREGEN field.
	ADC_CR_ADVREGEN     = 0x10000000 // Bit ADVREGEN.
	ADC_CR_ADCAL_Pos    = 0x1f       // Position of ADCAL field.
	ADC_CR_ADCAL_Msk    = 0x80000000 // Bit mask of ADCAL field.
	ADC_CR_ADCAL        = 0x80000000 // Bit ADCAL.

	// CFGR1: configuration register 1
	ADC_CFGR1_AWDCH_Pos   = 0x1a       // Position of AWDCH field.
	ADC_CFGR1_AWDCH_Msk   = 0x7c000000 // Bit mask of AWDCH field.
	ADC_CFGR1_AWDEN_Pos   = 0x17       // Position of AWDEN field.
	ADC_CFGR1_AWDEN_Msk   = 0x800000   // Bit mask of AWDEN field.
	ADC_CFGR1_AWDEN       = 0x800000   // Bit AWDEN.
	ADC_CFGR1_AWDSGL_Pos  = 0x16       // Position of AWDSGL field.
	ADC_CFGR1_AWDSGL_Msk  = 0x400000   // Bit mask of AWDSGL field.
	ADC_CFGR1_AWDSGL      = 0x400000   // Bit AWDSGL.
	ADC_CFGR1_DISCEN_Pos  = 0x10       // Position of DISCEN field.
	ADC_CFGR1_DISCEN_Msk  = 0x10000    // Bit mask of DISCEN field.
	ADC_CFGR1_DISCEN      = 0x10000    // Bit DISCEN.
	ADC_CFGR1_AUTOFF_Pos  = 0xf        // Position of AUTOFF field.
	ADC_CFGR1_AUTOFF_Msk  = 0x8000     // Bit mask of AUTOFF field.
	ADC_CFGR1_AUTOFF      = 0x8000     // Bit AUTOFF.
	ADC_CFGR1_AUTDLY_Pos  = 0xe        // Position of AUTDLY field.
	ADC_CFGR1_AUTDLY_Msk  = 0x4000     // Bit mask of AUTDLY field.
	ADC_CFGR1_AUTDLY      = 0x4000     // Bit AUTDLY.
	ADC_CFGR1_CONT_Pos    = 0xd        // Position of CONT field.
	ADC_CFGR1_CONT_Msk    = 0x2000     // Bit mask of CONT field.
	ADC_CFGR1_CONT        = 0x2000     // Bit CONT.
	ADC_CFGR1_OVRMOD_Pos  = 0xc        // Position of OVRMOD field.
	ADC_CFGR1_OVRMOD_Msk  = 0x1000     // Bit mask of OVRMOD field.
	ADC_CFGR1_OVRMOD      = 0x1000     // Bit OVRMOD.
	ADC_CFGR1_EXTEN_Pos   = 0xa        // Position of EXTEN field.
	ADC_CFGR1_EXTEN_Msk   = 0xc00      // Bit mask of EXTEN field.
	ADC_CFGR1_EXTSEL_Pos  = 0x6        // Position of EXTSEL field.
	ADC_CFGR1_EXTSEL_Msk  = 0x1c0      // Bit mask of EXTSEL field.
	ADC_CFGR1_ALIGN_Pos   = 0x5        // Position of ALIGN field.
	ADC_CFGR1_ALIGN_Msk   = 0x20       // Bit mask of ALIGN field.
	ADC_CFGR1_ALIGN       = 0x20       // Bit ALIGN.
	ADC_CFGR1_RES_Pos     = 0x3        // Position of RES field.
	ADC_CFGR1_RES_Msk     = 0x18       // Bit mask of RES field.
	ADC_CFGR1_SCANDIR_Pos = 0x2        // Position of SCANDIR field.
	ADC_CFGR1_SCANDIR_Msk = 0x4        // Bit mask of SCANDIR field.
	ADC_CFGR1_SCANDIR     = 0x4        // Bit SCANDIR.
	ADC_CFGR1_DMACFG_Pos  = 0x1        // Position of DMACFG field.
	ADC_CFGR1_DMACFG_Msk  = 0x2        // Bit mask of DMACFG field.
	ADC_CFGR1_DMACFG      = 0x2        // Bit DMACFG.
	ADC_CFGR1_DMAEN_Pos   = 0x0        // Position of DMAEN field.
	ADC_CFGR1_DMAEN_Msk   = 0x1        // Bit mask of DMAEN field.
	ADC_CFGR1_DMAEN       = 0x1        // Bit DMAEN.

	// CFGR2: configuration register 2
	ADC_CFGR2_OVSE_Pos   = 0x0        // Position of OVSE field.
	ADC_CFGR2_OVSE_Msk   = 0x1        // Bit mask of OVSE field.
	ADC_CFGR2_OVSE       = 0x1        // Bit OVSE.
	ADC_CFGR2_OVSR_Pos   = 0x2        // Position of OVSR field.
	ADC_CFGR2_OVSR_Msk   = 0x1c       // Bit mask of OVSR field.
	ADC_CFGR2_OVSS_Pos   = 0x5        // Position of OVSS field.
	ADC_CFGR2_OVSS_Msk   = 0x1e0      // Bit mask of OVSS field.
	ADC_CFGR2_TOVS_Pos   = 0x9        // Position of TOVS field.
	ADC_CFGR2_TOVS_Msk   = 0x200      // Bit mask of TOVS field.
	ADC_CFGR2_TOVS       = 0x200      // Bit TOVS.
	ADC_CFGR2_CKMODE_Pos = 0x1e       // Position of CKMODE field.
	ADC_CFGR2_CKMODE_Msk = 0xc0000000 // Bit mask of CKMODE field.

	// SMPR: sampling time register
	ADC_SMPR_SMPR_Pos = 0x0 // Position of SMPR field.
	ADC_SMPR_SMPR_Msk = 0x7 // Bit mask of SMPR field.

	// TR: watchdog threshold register
	ADC_TR_HT_Pos = 0x10      // Position of HT field.
	ADC_TR_HT_Msk = 0xfff0000 // Bit mask of HT field.
	ADC_TR_LT_Pos = 0x0       // Position of LT field.
	ADC_TR_LT_Msk = 0xfff     // Bit mask of LT field.

	// CHSELR: channel selection register
	ADC_CHSELR_CHSEL18_Pos = 0x12    // Position of CHSEL18 field.
	ADC_CHSELR_CHSEL18_Msk = 0x40000 // Bit mask of CHSEL18 field.
	ADC_CHSELR_CHSEL18     = 0x40000 // Bit CHSEL18.
	ADC_CHSELR_CHSEL17_Pos = 0x11    // Position of CHSEL17 field.
	ADC_CHSELR_CHSEL17_Msk = 0x20000 // Bit mask of CHSEL17 field.
	ADC_CHSELR_CHSEL17     = 0x20000 // Bit CHSEL17.
	ADC_CHSELR_CHSEL16_Pos = 0x10    // Position of CHSEL16 field.
	ADC_CHSELR_CHSEL16_Msk = 0x10000 // Bit mask of CHSEL16 field.
	ADC_CHSELR_CHSEL16     = 0x10000 // Bit CHSEL16.
	ADC_CHSELR_CHSEL15_Pos = 0xf     // Position of CHSEL15 field.
	ADC_CHSELR_CHSEL15_Msk = 0x8000  // Bit mask of CHSEL15 field.
	ADC_CHSELR_CHSEL15     = 0x8000  // Bit CHSEL15.
	ADC_CHSELR_CHSEL14_Pos = 0xe     // Position of CHSEL14 field.
	ADC_CHSELR_CHSEL14_Msk = 0x4000  // Bit mask of CHSEL14 field.
	ADC_CHSELR_CHSEL14     = 0x4000  // Bit CHSEL14.
	ADC_CHSELR_CHSEL13_Pos = 0xd     // Position of CHSEL13 field.
	ADC_CHSELR_CHSEL13_Msk = 0x2000  // Bit mask of CHSEL13 field.
	ADC_CHSELR_CHSEL13     = 0x2000  // Bit CHSEL13.
	ADC_CHSELR_CHSEL12_Pos = 0xc     // Position of CHSEL12 field.
	ADC_CHSELR_CHSEL12_Msk = 0x1000  // Bit mask of CHSEL12 field.
	ADC_CHSELR_CHSEL12     = 0x1000  // Bit CHSEL12.
	ADC_CHSELR_CHSEL11_Pos = 0xb     // Position of CHSEL11 field.
	ADC_CHSELR_CHSEL11_Msk = 0x800   // Bit mask of CHSEL11 field.
	ADC_CHSELR_CHSEL11     = 0x800   // Bit CHSEL11.
	ADC_CHSELR_CHSEL10_Pos = 0xa     // Position of CHSEL10 field.
	ADC_CHSELR_CHSEL10_Msk = 0x400   // Bit mask of CHSEL10 field.
	ADC_CHSELR_CHSEL10     = 0x400   // Bit CHSEL10.
	ADC_CHSELR_CHSEL9_Pos  = 0x9     // Position of CHSEL9 field.
	ADC_CHSELR_CHSEL9_Msk  = 0x200   // Bit mask of CHSEL9 field.
	ADC_CHSELR_CHSEL9      = 0x200   // Bit CHSEL9.
	ADC_CHSELR_CHSEL8_Pos  = 0x8     // Position of CHSEL8 field.
	ADC_CHSELR_CHSEL8_Msk  = 0x100   // Bit mask of CHSEL8 field.
	ADC_CHSELR_CHSEL8      = 0x100   // Bit CHSEL8.
	ADC_CHSELR_CHSEL7_Pos  = 0x7     // Position of CHSEL7 field.
	ADC_CHSELR_CHSEL7_Msk  = 0x80    // Bit mask of CHSEL7 field.
	ADC_CHSELR_CHSEL7      = 0x80    // Bit CHSEL7.
	ADC_CHSELR_CHSEL6_Pos  = 0x6     // Position of CHSEL6 field.
	ADC_CHSELR_CHSEL6_Msk  = 0x40    // Bit mask of CHSEL6 field.
	ADC_CHSELR_CHSEL6      = 0x40    // Bit CHSEL6.
	ADC_CHSELR_CHSEL5_Pos  = 0x5     // Position of CHSEL5 field.
	ADC_CHSELR_CHSEL5_Msk  = 0x20    // Bit mask of CHSEL5 field.
	ADC_CHSELR_CHSEL5      = 0x20    // Bit CHSEL5.
	ADC_CHSELR_CHSEL4_Pos  = 0x4     // Position of CHSEL4 field.
	ADC_CHSELR_CHSEL4_Msk  = 0x10    // Bit mask of CHSEL4 field.
	ADC_CHSELR_CHSEL4      = 0x10    // Bit CHSEL4.
	ADC_CHSELR_CHSEL3_Pos  = 0x3     // Position of CHSEL3 field.
	ADC_CHSELR_CHSEL3_Msk  = 0x8     // Bit mask of CHSEL3 field.
	ADC_CHSELR_CHSEL3      = 0x8     // Bit CHSEL3.
	ADC_CHSELR_CHSEL2_Pos  = 0x2     // Position of CHSEL2 field.
	ADC_CHSELR_CHSEL2_Msk  = 0x4     // Bit mask of CHSEL2 field.
	ADC_CHSELR_CHSEL2      = 0x4     // Bit CHSEL2.
	ADC_CHSELR_CHSEL1_Pos  = 0x1     // Position of CHSEL1 field.
	ADC_CHSELR_CHSEL1_Msk  = 0x2     // Bit mask of CHSEL1 field.
	ADC_CHSELR_CHSEL1      = 0x2     // Bit CHSEL1.
	ADC_CHSELR_CHSEL0_Pos  = 0x0     // Position of CHSEL0 field.
	ADC_CHSELR_CHSEL0_Msk  = 0x1     // Bit mask of CHSEL0 field.
	ADC_CHSELR_CHSEL0      = 0x1     // Bit CHSEL0.

	// DR: data register
	ADC_DR_DATA_Pos = 0x0    // Position of DATA field.
	ADC_DR_DATA_Msk = 0xffff // Bit mask of DATA field.

	// CALFACT: ADC Calibration factor
	ADC_CALFACT_CALFACT_Pos = 0x0  // Position of CALFACT field.
	ADC_CALFACT_CALFACT_Msk = 0x7f // Bit mask of CALFACT field.

	// CCR: ADC common configuration           register
	ADC_CCR_PRESC_Pos  = 0x12      // Position of PRESC field.
	ADC_CCR_PRESC_Msk  = 0x3c0000  // Bit mask of PRESC field.
	ADC_CCR_VREFEN_Pos = 0x16      // Position of VREFEN field.
	ADC_CCR_VREFEN_Msk = 0x400000  // Bit mask of VREFEN field.
	ADC_CCR_VREFEN     = 0x400000  // Bit VREFEN.
	ADC_CCR_TSEN_Pos   = 0x17      // Position of TSEN field.
	ADC_CCR_TSEN_Msk   = 0x800000  // Bit mask of TSEN field.
	ADC_CCR_TSEN       = 0x800000  // Bit TSEN.
	ADC_CCR_VLCDEN_Pos = 0x18      // Position of VLCDEN field.
	ADC_CCR_VLCDEN_Msk = 0x1000000 // Bit mask of VLCDEN field.
	ADC_CCR_VLCDEN     = 0x1000000 // Bit VLCDEN.
	ADC_CCR_LFMEN_Pos  = 0x19      // Position of LFMEN field.
	ADC_CCR_LFMEN_Msk  = 0x2000000 // Bit mask of LFMEN field.
	ADC_CCR_LFMEN      = 0x2000000 // Bit LFMEN.
)

// Bitfields for DBG: Debug support
const (
	// IDCODE: MCU Device ID Code Register
	DBGMCU_IDCODE_DEV_ID_Pos = 0x0        // Position of DEV_ID field.
	DBGMCU_IDCODE_DEV_ID_Msk = 0xfff      // Bit mask of DEV_ID field.
	DBGMCU_IDCODE_REV_ID_Pos = 0x10       // Position of REV_ID field.
	DBGMCU_IDCODE_REV_ID_Msk = 0xffff0000 // Bit mask of REV_ID field.

	// CR: Debug MCU Configuration           Register
	DBGMCU_CR_DBG_STOP_Pos    = 0x1 // Position of DBG_STOP field.
	DBGMCU_CR_DBG_STOP_Msk    = 0x2 // Bit mask of DBG_STOP field.
	DBGMCU_CR_DBG_STOP        = 0x2 // Bit DBG_STOP.
	DBGMCU_CR_DBG_STANDBY_Pos = 0x2 // Position of DBG_STANDBY field.
	DBGMCU_CR_DBG_STANDBY_Msk = 0x4 // Bit mask of DBG_STANDBY field.
	DBGMCU_CR_DBG_STANDBY     = 0x4 // Bit DBG_STANDBY.
	DBGMCU_CR_DBG_SLEEP_Pos   = 0x0 // Position of DBG_SLEEP field.
	DBGMCU_CR_DBG_SLEEP_Msk   = 0x1 // Bit mask of DBG_SLEEP field.
	DBGMCU_CR_DBG_SLEEP       = 0x1 // Bit DBG_SLEEP.

	// APB1_FZ: APB Low Freeze Register
	DBGMCU_APB1_FZ_DBG_TIMER2_STOP_Pos  = 0x0        // Position of DBG_TIMER2_STOP field.
	DBGMCU_APB1_FZ_DBG_TIMER2_STOP_Msk  = 0x1        // Bit mask of DBG_TIMER2_STOP field.
	DBGMCU_APB1_FZ_DBG_TIMER2_STOP      = 0x1        // Bit DBG_TIMER2_STOP.
	DBGMCU_APB1_FZ_DBG_TIMER6_STOP_Pos  = 0x4        // Position of DBG_TIMER6_STOP field.
	DBGMCU_APB1_FZ_DBG_TIMER6_STOP_Msk  = 0x10       // Bit mask of DBG_TIMER6_STOP field.
	DBGMCU_APB1_FZ_DBG_TIMER6_STOP      = 0x10       // Bit DBG_TIMER6_STOP.
	DBGMCU_APB1_FZ_DBG_RTC_STOP_Pos     = 0xa        // Position of DBG_RTC_STOP field.
	DBGMCU_APB1_FZ_DBG_RTC_STOP_Msk     = 0x400      // Bit mask of DBG_RTC_STOP field.
	DBGMCU_APB1_FZ_DBG_RTC_STOP         = 0x400      // Bit DBG_RTC_STOP.
	DBGMCU_APB1_FZ_DBG_WWDG_STOP_Pos    = 0xb        // Position of DBG_WWDG_STOP field.
	DBGMCU_APB1_FZ_DBG_WWDG_STOP_Msk    = 0x800      // Bit mask of DBG_WWDG_STOP field.
	DBGMCU_APB1_FZ_DBG_WWDG_STOP        = 0x800      // Bit DBG_WWDG_STOP.
	DBGMCU_APB1_FZ_DBG_IWDG_STOP_Pos    = 0xc        // Position of DBG_IWDG_STOP field.
	DBGMCU_APB1_FZ_DBG_IWDG_STOP_Msk    = 0x1000     // Bit mask of DBG_IWDG_STOP field.
	DBGMCU_APB1_FZ_DBG_IWDG_STOP        = 0x1000     // Bit DBG_IWDG_STOP.
	DBGMCU_APB1_FZ_DBG_I2C1_STOP_Pos    = 0x15       // Position of DBG_I2C1_STOP field.
	DBGMCU_APB1_FZ_DBG_I2C1_STOP_Msk    = 0x200000   // Bit mask of DBG_I2C1_STOP field.
	DBGMCU_APB1_FZ_DBG_I2C1_STOP        = 0x200000   // Bit DBG_I2C1_STOP.
	DBGMCU_APB1_FZ_DBG_I2C2_STOP_Pos    = 0x16       // Position of DBG_I2C2_STOP field.
	DBGMCU_APB1_FZ_DBG_I2C2_STOP_Msk    = 0x400000   // Bit mask of DBG_I2C2_STOP field.
	DBGMCU_APB1_FZ_DBG_I2C2_STOP        = 0x400000   // Bit DBG_I2C2_STOP.
	DBGMCU_APB1_FZ_DBG_LPTIMER_STOP_Pos = 0x1f       // Position of DBG_LPTIMER_STOP field.
	DBGMCU_APB1_FZ_DBG_LPTIMER_STOP_Msk = 0x80000000 // Bit mask of DBG_LPTIMER_STOP field.
	DBGMCU_APB1_FZ_DBG_LPTIMER_STOP     = 0x80000000 // Bit DBG_LPTIMER_STOP.

	// APB2_FZ: APB High Freeze Register
	DBGMCU_APB2_FZ_DBG_TIMER21_STOP_Pos = 0x2  // Position of DBG_TIMER21_STOP field.
	DBGMCU_APB2_FZ_DBG_TIMER21_STOP_Msk = 0x4  // Bit mask of DBG_TIMER21_STOP field.
	DBGMCU_APB2_FZ_DBG_TIMER21_STOP     = 0x4  // Bit DBG_TIMER21_STOP.
	DBGMCU_APB2_FZ_DBG_TIMER22_STO_Pos  = 0x6  // Position of DBG_TIMER22_STO field.
	DBGMCU_APB2_FZ_DBG_TIMER22_STO_Msk  = 0x40 // Bit mask of DBG_TIMER22_STO field.
	DBGMCU_APB2_FZ_DBG_TIMER22_STO      = 0x40 // Bit DBG_TIMER22_STO.
)

// Bitfields for TIM2: General-purpose-timers
const (
	// CR1: control register 1
	TIM_CR1_CKD_Pos  = 0x8   // Position of CKD field.
	TIM_CR1_CKD_Msk  = 0x300 // Bit mask of CKD field.
	TIM_CR1_ARPE_Pos = 0x7   // Position of ARPE field.
	TIM_CR1_ARPE_Msk = 0x80  // Bit mask of ARPE field.
	TIM_CR1_ARPE     = 0x80  // Bit ARPE.
	TIM_CR1_CMS_Pos  = 0x5   // Position of CMS field.
	TIM_CR1_CMS_Msk  = 0x60  // Bit mask of CMS field.
	TIM_CR1_DIR_Pos  = 0x4   // Position of DIR field.
	TIM_CR1_DIR_Msk  = 0x10  // Bit mask of DIR field.
	TIM_CR1_DIR      = 0x10  // Bit DIR.
	TIM_CR1_OPM_Pos  = 0x3   // Position of OPM field.
	TIM_CR1_OPM_Msk  = 0x8   // Bit mask of OPM field.
	TIM_CR1_OPM      = 0x8   // Bit OPM.
	TIM_CR1_URS_Pos  = 0x2   // Position of URS field.
	TIM_CR1_URS_Msk  = 0x4   // Bit mask of URS field.
	TIM_CR1_URS      = 0x4   // Bit URS.
	TIM_CR1_UDIS_Pos = 0x1   // Position of UDIS field.
	TIM_CR1_UDIS_Msk = 0x2   // Bit mask of UDIS field.
	TIM_CR1_UDIS     = 0x2   // Bit UDIS.
	TIM_CR1_CEN_Pos  = 0x0   // Position of CEN field.
	TIM_CR1_CEN_Msk  = 0x1   // Bit mask of CEN field.
	TIM_CR1_CEN      = 0x1   // Bit CEN.

	// CR2: control register 2
	TIM_CR2_TI1S_Pos = 0x7  // Position of TI1S field.
	TIM_CR2_TI1S_Msk = 0x80 // Bit mask of TI1S field.
	TIM_CR2_TI1S     = 0x80 // Bit TI1S.
	TIM_CR2_MMS_Pos  = 0x4  // Position of MMS field.
	TIM_CR2_MMS_Msk  = 0x70 // Bit mask of MMS field.
	TIM_CR2_CCDS_Pos = 0x3  // Position of CCDS field.
	TIM_CR2_CCDS_Msk = 0x8  // Bit mask of CCDS field.
	TIM_CR2_CCDS     = 0x8  // Bit CCDS.

	// SMCR: slave mode control register
	TIM_SMCR_ETP_Pos  = 0xf    // Position of ETP field.
	TIM_SMCR_ETP_Msk  = 0x8000 // Bit mask of ETP field.
	TIM_SMCR_ETP      = 0x8000 // Bit ETP.
	TIM_SMCR_ECE_Pos  = 0xe    // Position of ECE field.
	TIM_SMCR_ECE_Msk  = 0x4000 // Bit mask of ECE field.
	TIM_SMCR_ECE      = 0x4000 // Bit ECE.
	TIM_SMCR_ETPS_Pos = 0xc    // Position of ETPS field.
	TIM_SMCR_ETPS_Msk = 0x3000 // Bit mask of ETPS field.
	TIM_SMCR_ETF_Pos  = 0x8    // Position of ETF field.
	TIM_SMCR_ETF_Msk  = 0xf00  // Bit mask of ETF field.
	TIM_SMCR_MSM_Pos  = 0x7    // Position of MSM field.
	TIM_SMCR_MSM_Msk  = 0x80   // Bit mask of MSM field.
	TIM_SMCR_MSM      = 0x80   // Bit MSM.
	TIM_SMCR_TS_Pos   = 0x4    // Position of TS field.
	TIM_SMCR_TS_Msk   = 0x70   // Bit mask of TS field.
	TIM_SMCR_SMS_Pos  = 0x0    // Position of SMS field.
	TIM_SMCR_SMS_Msk  = 0x7    // Bit mask of SMS field.

	// DIER: DMA/Interrupt enable register
	TIM_DIER_TDE_Pos   = 0xe    // Position of TDE field.
	TIM_DIER_TDE_Msk   = 0x4000 // Bit mask of TDE field.
	TIM_DIER_TDE       = 0x4000 // Bit TDE.
	TIM_DIER_CC4DE_Pos = 0xc    // Position of CC4DE field.
	TIM_DIER_CC4DE_Msk = 0x1000 // Bit mask of CC4DE field.
	TIM_DIER_CC4DE     = 0x1000 // Bit CC4DE.
	TIM_DIER_CC3DE_Pos = 0xb    // Position of CC3DE field.
	TIM_DIER_CC3DE_Msk = 0x800  // Bit mask of CC3DE field.
	TIM_DIER_CC3DE     = 0x800  // Bit CC3DE.
	TIM_DIER_CC2DE_Pos = 0xa    // Position of CC2DE field.
	TIM_DIER_CC2DE_Msk = 0x400  // Bit mask of CC2DE field.
	TIM_DIER_CC2DE     = 0x400  // Bit CC2DE.
	TIM_DIER_CC1DE_Pos = 0x9    // Position of CC1DE field.
	TIM_DIER_CC1DE_Msk = 0x200  // Bit mask of CC1DE field.
	TIM_DIER_CC1DE     = 0x200  // Bit CC1DE.
	TIM_DIER_UDE_Pos   = 0x8    // Position of UDE field.
	TIM_DIER_UDE_Msk   = 0x100  // Bit mask of UDE field.
	TIM_DIER_UDE       = 0x100  // Bit UDE.
	TIM_DIER_TIE_Pos   = 0x6    // Position of TIE field.
	TIM_DIER_TIE_Msk   = 0x40   // Bit mask of TIE field.
	TIM_DIER_TIE       = 0x40   // Bit TIE.
	TIM_DIER_CC4IE_Pos = 0x4    // Position of CC4IE field.
	TIM_DIER_CC4IE_Msk = 0x10   // Bit mask of CC4IE field.
	TIM_DIER_CC4IE     = 0x10   // Bit CC4IE.
	TIM_DIER_CC3IE_Pos = 0x3    // Position of CC3IE field.
	TIM_DIER_CC3IE_Msk = 0x8    // Bit mask of CC3IE field.
	TIM_DIER_CC3IE     = 0x8    // Bit CC3IE.
	TIM_DIER_CC2IE_Pos = 0x2    // Position of CC2IE field.
	TIM_DIER_CC2IE_Msk = 0x4    // Bit mask of CC2IE field.
	TIM_DIER_CC2IE     = 0x4    // Bit CC2IE.
	TIM_DIER_CC1IE_Pos = 0x1    // Position of CC1IE field.
	TIM_DIER_CC1IE_Msk = 0x2    // Bit mask of CC1IE field.
	TIM_DIER_CC1IE     = 0x2    // Bit CC1IE.
	TIM_DIER_UIE_Pos   = 0x0    // Position of UIE field.
	TIM_DIER_UIE_Msk   = 0x1    // Bit mask of UIE field.
	TIM_DIER_UIE       = 0x1    // Bit UIE.

	// SR: status register
	TIM_SR_CC4OF_Pos = 0xc    // Position of CC4OF field.
	TIM_SR_CC4OF_Msk = 0x1000 // Bit mask of CC4OF field.
	TIM_SR_CC4OF     = 0x1000 // Bit CC4OF.
	TIM_SR_CC3OF_Pos = 0xb    // Position of CC3OF field.
	TIM_SR_CC3OF_Msk = 0x800  // Bit mask of CC3OF field.
	TIM_SR_CC3OF     = 0x800  // Bit CC3OF.
	TIM_SR_CC2OF_Pos = 0xa    // Position of CC2OF field.
	TIM_SR_CC2OF_Msk = 0x400  // Bit mask of CC2OF field.
	TIM_SR_CC2OF     = 0x400  // Bit CC2OF.
	TIM_SR_CC1OF_Pos = 0x9    // Position of CC1OF field.
	TIM_SR_CC1OF_Msk = 0x200  // Bit mask of CC1OF field.
	TIM_SR_CC1OF     = 0x200  // Bit CC1OF.
	TIM_SR_TIF_Pos   = 0x6    // Position of TIF field.
	TIM_SR_TIF_Msk   = 0x40   // Bit mask of TIF field.
	TIM_SR_TIF       = 0x40   // Bit TIF.
	TIM_SR_CC4IF_Pos = 0x4    // Position of CC4IF field.
	TIM_SR_CC4IF_Msk = 0x10   // Bit mask of CC4IF field.
	TIM_SR_CC4IF     = 0x10   // Bit CC4IF.
	TIM_SR_CC3IF_Pos = 0x3    // Position of CC3IF field.
	TIM_SR_CC3IF_Msk = 0x8    // Bit mask of CC3IF field.
	TIM_SR_CC3IF     = 0x8    // Bit CC3IF.
	TIM_SR_CC2IF_Pos = 0x2    // Position of CC2IF field.
	TIM_SR_CC2IF_Msk = 0x4    // Bit mask of CC2IF field.
	TIM_SR_CC2IF     = 0x4    // Bit CC2IF.
	TIM_SR_CC1IF_Pos = 0x1    // Position of CC1IF field.
	TIM_SR_CC1IF_Msk = 0x2    // Bit mask of CC1IF field.
	TIM_SR_CC1IF     = 0x2    // Bit CC1IF.
	TIM_SR_UIF_Pos   = 0x0    // Position of UIF field.
	TIM_SR_UIF_Msk   = 0x1    // Bit mask of UIF field.
	TIM_SR_UIF       = 0x1    // Bit UIF.

	// EGR: event generation register
	TIM_EGR_TG_Pos   = 0x6  // Position of TG field.
	TIM_EGR_TG_Msk   = 0x40 // Bit mask of TG field.
	TIM_EGR_TG       = 0x40 // Bit TG.
	TIM_EGR_CC4G_Pos = 0x4  // Position of CC4G field.
	TIM_EGR_CC4G_Msk = 0x10 // Bit mask of CC4G field.
	TIM_EGR_CC4G     = 0x10 // Bit CC4G.
	TIM_EGR_CC3G_Pos = 0x3  // Position of CC3G field.
	TIM_EGR_CC3G_Msk = 0x8  // Bit mask of CC3G field.
	TIM_EGR_CC3G     = 0x8  // Bit CC3G.
	TIM_EGR_CC2G_Pos = 0x2  // Position of CC2G field.
	TIM_EGR_CC2G_Msk = 0x4  // Bit mask of CC2G field.
	TIM_EGR_CC2G     = 0x4  // Bit CC2G.
	TIM_EGR_CC1G_Pos = 0x1  // Position of CC1G field.
	TIM_EGR_CC1G_Msk = 0x2  // Bit mask of CC1G field.
	TIM_EGR_CC1G     = 0x2  // Bit CC1G.
	TIM_EGR_UG_Pos   = 0x0  // Position of UG field.
	TIM_EGR_UG_Msk   = 0x1  // Bit mask of UG field.
	TIM_EGR_UG       = 0x1  // Bit UG.

	// CCMR1_Output: capture/compare mode register 1 (output           mode)
	TIM_CCMR1_Output_OC2CE_Pos = 0xf    // Position of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Msk = 0x8000 // Bit mask of OC2CE field.
	TIM_CCMR1_Output_OC2CE     = 0x8000 // Bit OC2CE.
	TIM_CCMR1_Output_OC2M_Pos  = 0xc    // Position of OC2M field.
	TIM_CCMR1_Output_OC2M_Msk  = 0x7000 // Bit mask of OC2M field.
	TIM_CCMR1_Output_OC2PE_Pos = 0xb    // Position of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Msk = 0x800  // Bit mask of OC2PE field.
	TIM_CCMR1_Output_OC2PE     = 0x800  // Bit OC2PE.
	TIM_CCMR1_Output_OC2FE_Pos = 0xa    // Position of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Msk = 0x400  // Bit mask of OC2FE field.
	TIM_CCMR1_Output_OC2FE     = 0x400  // Bit OC2FE.
	TIM_CCMR1_Output_CC2S_Pos  = 0x8    // Position of CC2S field.
	TIM_CCMR1_Output_CC2S_Msk  = 0x300  // Bit mask of CC2S field.
	TIM_CCMR1_Output_OC1CE_Pos = 0x7    // Position of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Msk = 0x80   // Bit mask of OC1CE field.
	TIM_CCMR1_Output_OC1CE     = 0x80   // Bit OC1CE.
	TIM_CCMR1_Output_OC1M_Pos  = 0x4    // Position of OC1M field.
	TIM_CCMR1_Output_OC1M_Msk  = 0x70   // Bit mask of OC1M field.
	TIM_CCMR1_Output_OC1PE_Pos = 0x3    // Position of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Msk = 0x8    // Bit mask of OC1PE field.
	TIM_CCMR1_Output_OC1PE     = 0x8    // Bit OC1PE.
	TIM_CCMR1_Output_OC1FE_Pos = 0x2    // Position of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Msk = 0x4    // Bit mask of OC1FE field.
	TIM_CCMR1_Output_OC1FE     = 0x4    // Bit OC1FE.
	TIM_CCMR1_Output_CC1S_Pos  = 0x0    // Position of CC1S field.
	TIM_CCMR1_Output_CC1S_Msk  = 0x3    // Bit mask of CC1S field.

	// CCMR1_Input: capture/compare mode register 1 (input           mode)
	TIM_CCMR1_Input_IC2F_Pos   = 0xc    // Position of IC2F field.
	TIM_CCMR1_Input_IC2F_Msk   = 0xf000 // Bit mask of IC2F field.
	TIM_CCMR1_Input_IC2PSC_Pos = 0xa    // Position of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Msk = 0xc00  // Bit mask of IC2PSC field.
	TIM_CCMR1_Input_CC2S_Pos   = 0x8    // Position of CC2S field.
	TIM_CCMR1_Input_CC2S_Msk   = 0x300  // Bit mask of CC2S field.
	TIM_CCMR1_Input_IC1F_Pos   = 0x4    // Position of IC1F field.
	TIM_CCMR1_Input_IC1F_Msk   = 0xf0   // Bit mask of IC1F field.
	TIM_CCMR1_Input_IC1PSC_Pos = 0x2    // Position of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Msk = 0xc    // Bit mask of IC1PSC field.
	TIM_CCMR1_Input_CC1S_Pos   = 0x0    // Position of CC1S field.
	TIM_CCMR1_Input_CC1S_Msk   = 0x3    // Bit mask of CC1S field.

	// CCMR2_Output: capture/compare mode register 2 (output           mode)
	TIM_CCMR2_Output_OC4CE_Pos = 0xf    // Position of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Msk = 0x8000 // Bit mask of OC4CE field.
	TIM_CCMR2_Output_OC4CE     = 0x8000 // Bit OC4CE.
	TIM_CCMR2_Output_OC4M_Pos  = 0xc    // Position of OC4M field.
	TIM_CCMR2_Output_OC4M_Msk  = 0x7000 // Bit mask of OC4M field.
	TIM_CCMR2_Output_OC4PE_Pos = 0xb    // Position of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Msk = 0x800  // Bit mask of OC4PE field.
	TIM_CCMR2_Output_OC4PE     = 0x800  // Bit OC4PE.
	TIM_CCMR2_Output_OC4FE_Pos = 0xa    // Position of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Msk = 0x400  // Bit mask of OC4FE field.
	TIM_CCMR2_Output_OC4FE     = 0x400  // Bit OC4FE.
	TIM_CCMR2_Output_CC4S_Pos  = 0x8    // Position of CC4S field.
	TIM_CCMR2_Output_CC4S_Msk  = 0x300  // Bit mask of CC4S field.
	TIM_CCMR2_Output_OC3CE_Pos = 0x7    // Position of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Msk = 0x80   // Bit mask of OC3CE field.
	TIM_CCMR2_Output_OC3CE     = 0x80   // Bit OC3CE.
	TIM_CCMR2_Output_OC3M_Pos  = 0x4    // Position of OC3M field.
	TIM_CCMR2_Output_OC3M_Msk  = 0x70   // Bit mask of OC3M field.
	TIM_CCMR2_Output_OC3PE_Pos = 0x3    // Position of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Msk = 0x8    // Bit mask of OC3PE field.
	TIM_CCMR2_Output_OC3PE     = 0x8    // Bit OC3PE.
	TIM_CCMR2_Output_OC3FE_Pos = 0x2    // Position of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Msk = 0x4    // Bit mask of OC3FE field.
	TIM_CCMR2_Output_OC3FE     = 0x4    // Bit OC3FE.
	TIM_CCMR2_Output_CC3S_Pos  = 0x0    // Position of CC3S field.
	TIM_CCMR2_Output_CC3S_Msk  = 0x3    // Bit mask of CC3S field.

	// CCMR2_Input: capture/compare mode register 2 (input           mode)
	TIM_CCMR2_Input_IC4F_Pos   = 0xc    // Position of IC4F field.
	TIM_CCMR2_Input_IC4F_Msk   = 0xf000 // Bit mask of IC4F field.
	TIM_CCMR2_Input_IC4PSC_Pos = 0xa    // Position of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Msk = 0xc00  // Bit mask of IC4PSC field.
	TIM_CCMR2_Input_CC4S_Pos   = 0x8    // Position of CC4S field.
	TIM_CCMR2_Input_CC4S_Msk   = 0x300  // Bit mask of CC4S field.
	TIM_CCMR2_Input_IC3F_Pos   = 0x4    // Position of IC3F field.
	TIM_CCMR2_Input_IC3F_Msk   = 0xf0   // Bit mask of IC3F field.
	TIM_CCMR2_Input_IC3PSC_Pos = 0x2    // Position of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Msk = 0xc    // Bit mask of IC3PSC field.
	TIM_CCMR2_Input_CC3S_Pos   = 0x0    // Position of CC3S field.
	TIM_CCMR2_Input_CC3S_Msk   = 0x3    // Bit mask of CC3S field.

	// CCER: capture/compare enable           register
	TIM_CCER_CC4NP_Pos = 0xf    // Position of CC4NP field.
	TIM_CCER_CC4NP_Msk = 0x8000 // Bit mask of CC4NP field.
	TIM_CCER_CC4NP     = 0x8000 // Bit CC4NP.
	TIM_CCER_CC4P_Pos  = 0xd    // Position of CC4P field.
	TIM_CCER_CC4P_Msk  = 0x2000 // Bit mask of CC4P field.
	TIM_CCER_CC4P      = 0x2000 // Bit CC4P.
	TIM_CCER_CC4E_Pos  = 0xc    // Position of CC4E field.
	TIM_CCER_CC4E_Msk  = 0x1000 // Bit mask of CC4E field.
	TIM_CCER_CC4E      = 0x1000 // Bit CC4E.
	TIM_CCER_CC3NP_Pos = 0xb    // Position of CC3NP field.
	TIM_CCER_CC3NP_Msk = 0x800  // Bit mask of CC3NP field.
	TIM_CCER_CC3NP     = 0x800  // Bit CC3NP.
	TIM_CCER_CC3P_Pos  = 0x9    // Position of CC3P field.
	TIM_CCER_CC3P_Msk  = 0x200  // Bit mask of CC3P field.
	TIM_CCER_CC3P      = 0x200  // Bit CC3P.
	TIM_CCER_CC3E_Pos  = 0x8    // Position of CC3E field.
	TIM_CCER_CC3E_Msk  = 0x100  // Bit mask of CC3E field.
	TIM_CCER_CC3E      = 0x100  // Bit CC3E.
	TIM_CCER_CC2NP_Pos = 0x7    // Position of CC2NP field.
	TIM_CCER_CC2NP_Msk = 0x80   // Bit mask of CC2NP field.
	TIM_CCER_CC2NP     = 0x80   // Bit CC2NP.
	TIM_CCER_CC2P_Pos  = 0x5    // Position of CC2P field.
	TIM_CCER_CC2P_Msk  = 0x20   // Bit mask of CC2P field.
	TIM_CCER_CC2P      = 0x20   // Bit CC2P.
	TIM_CCER_CC2E_Pos  = 0x4    // Position of CC2E field.
	TIM_CCER_CC2E_Msk  = 0x10   // Bit mask of CC2E field.
	TIM_CCER_CC2E      = 0x10   // Bit CC2E.
	TIM_CCER_CC1NP_Pos = 0x3    // Position of CC1NP field.
	TIM_CCER_CC1NP_Msk = 0x8    // Bit mask of CC1NP field.
	TIM_CCER_CC1NP     = 0x8    // Bit CC1NP.
	TIM_CCER_CC1P_Pos  = 0x1    // Position of CC1P field.
	TIM_CCER_CC1P_Msk  = 0x2    // Bit mask of CC1P field.
	TIM_CCER_CC1P      = 0x2    // Bit CC1P.
	TIM_CCER_CC1E_Pos  = 0x0    // Position of CC1E field.
	TIM_CCER_CC1E_Msk  = 0x1    // Bit mask of CC1E field.
	TIM_CCER_CC1E      = 0x1    // Bit CC1E.

	// CNT: counter
	TIM_CNT_CNT_H_Pos = 0x10       // Position of CNT_H field.
	TIM_CNT_CNT_H_Msk = 0xffff0000 // Bit mask of CNT_H field.
	TIM_CNT_CNT_L_Pos = 0x0        // Position of CNT_L field.
	TIM_CNT_CNT_L_Msk = 0xffff     // Bit mask of CNT_L field.

	// PSC: prescaler
	TIM_PSC_PSC_Pos = 0x0    // Position of PSC field.
	TIM_PSC_PSC_Msk = 0xffff // Bit mask of PSC field.

	// ARR: auto-reload register
	TIM_ARR_ARR_H_Pos = 0x10       // Position of ARR_H field.
	TIM_ARR_ARR_H_Msk = 0xffff0000 // Bit mask of ARR_H field.
	TIM_ARR_ARR_L_Pos = 0x0        // Position of ARR_L field.
	TIM_ARR_ARR_L_Msk = 0xffff     // Bit mask of ARR_L field.

	// CCR1: capture/compare register 1
	TIM_CCR1_CCR1_H_Pos = 0x10       // Position of CCR1_H field.
	TIM_CCR1_CCR1_H_Msk = 0xffff0000 // Bit mask of CCR1_H field.
	TIM_CCR1_CCR1_L_Pos = 0x0        // Position of CCR1_L field.
	TIM_CCR1_CCR1_L_Msk = 0xffff     // Bit mask of CCR1_L field.

	// CCR2: capture/compare register 2
	TIM_CCR2_CCR2_H_Pos = 0x10       // Position of CCR2_H field.
	TIM_CCR2_CCR2_H_Msk = 0xffff0000 // Bit mask of CCR2_H field.
	TIM_CCR2_CCR2_L_Pos = 0x0        // Position of CCR2_L field.
	TIM_CCR2_CCR2_L_Msk = 0xffff     // Bit mask of CCR2_L field.

	// CCR3: capture/compare register 3
	TIM_CCR3_CCR3_H_Pos = 0x10       // Position of CCR3_H field.
	TIM_CCR3_CCR3_H_Msk = 0xffff0000 // Bit mask of CCR3_H field.
	TIM_CCR3_CCR3_L_Pos = 0x0        // Position of CCR3_L field.
	TIM_CCR3_CCR3_L_Msk = 0xffff     // Bit mask of CCR3_L field.

	// CCR4: capture/compare register 4
	TIM_CCR4_CCR4_H_Pos = 0x10       // Position of CCR4_H field.
	TIM_CCR4_CCR4_H_Msk = 0xffff0000 // Bit mask of CCR4_H field.
	TIM_CCR4_CCR4_L_Pos = 0x0        // Position of CCR4_L field.
	TIM_CCR4_CCR4_L_Msk = 0xffff     // Bit mask of CCR4_L field.

	// DCR: DMA control register
	TIM_DCR_DBL_Pos = 0x8    // Position of DBL field.
	TIM_DCR_DBL_Msk = 0x1f00 // Bit mask of DBL field.
	TIM_DCR_DBA_Pos = 0x0    // Position of DBA field.
	TIM_DCR_DBA_Msk = 0x1f   // Bit mask of DBA field.

	// DMAR: DMA address for full transfer
	TIM_DMAR_DMAB_Pos = 0x0    // Position of DMAB field.
	TIM_DMAR_DMAB_Msk = 0xffff // Bit mask of DMAB field.

	// OR: TIM2 option register
	TIM_OR_ETR_RMP_Pos = 0x0  // Position of ETR_RMP field.
	TIM_OR_ETR_RMP_Msk = 0x7  // Bit mask of ETR_RMP field.
	TIM_OR_TI4_RMP_Pos = 0x3  // Position of TI4_RMP field.
	TIM_OR_TI4_RMP_Msk = 0x18 // Bit mask of TI4_RMP field.
)

// Bitfields for NVIC: Nested Vectored Interrupt Controller
const (
	// ISER: Interrupt Set Enable Register
	NVIC_ISER_SETENA_Pos = 0x0        // Position of SETENA field.
	NVIC_ISER_SETENA_Msk = 0xffffffff // Bit mask of SETENA field.

	// ICER: Interrupt Clear Enable           Register
	NVIC_ICER_CLRENA_Pos = 0x0        // Position of CLRENA field.
	NVIC_ICER_CLRENA_Msk = 0xffffffff // Bit mask of CLRENA field.

	// ISPR: Interrupt Set-Pending Register
	NVIC_ISPR_SETPEND_Pos = 0x0        // Position of SETPEND field.
	NVIC_ISPR_SETPEND_Msk = 0xffffffff // Bit mask of SETPEND field.

	// ICPR: Interrupt Clear-Pending           Register
	NVIC_ICPR_CLRPEND_Pos = 0x0        // Position of CLRPEND field.
	NVIC_ICPR_CLRPEND_Msk = 0xffffffff // Bit mask of CLRPEND field.

	// IPR0: Interrupt Priority Register 0
	NVIC_IPR0_PRI_0_Pos = 0x0        // Position of PRI_0 field.
	NVIC_IPR0_PRI_0_Msk = 0xff       // Bit mask of PRI_0 field.
	NVIC_IPR0_PRI_1_Pos = 0x8        // Position of PRI_1 field.
	NVIC_IPR0_PRI_1_Msk = 0xff00     // Bit mask of PRI_1 field.
	NVIC_IPR0_PRI_2_Pos = 0x10       // Position of PRI_2 field.
	NVIC_IPR0_PRI_2_Msk = 0xff0000   // Bit mask of PRI_2 field.
	NVIC_IPR0_PRI_3_Pos = 0x18       // Position of PRI_3 field.
	NVIC_IPR0_PRI_3_Msk = 0xff000000 // Bit mask of PRI_3 field.

	// IPR1: Interrupt Priority Register 1
	NVIC_IPR1_PRI_4_Pos = 0x0        // Position of PRI_4 field.
	NVIC_IPR1_PRI_4_Msk = 0xff       // Bit mask of PRI_4 field.
	NVIC_IPR1_PRI_5_Pos = 0x8        // Position of PRI_5 field.
	NVIC_IPR1_PRI_5_Msk = 0xff00     // Bit mask of PRI_5 field.
	NVIC_IPR1_PRI_6_Pos = 0x10       // Position of PRI_6 field.
	NVIC_IPR1_PRI_6_Msk = 0xff0000   // Bit mask of PRI_6 field.
	NVIC_IPR1_PRI_7_Pos = 0x18       // Position of PRI_7 field.
	NVIC_IPR1_PRI_7_Msk = 0xff000000 // Bit mask of PRI_7 field.

	// IPR2: Interrupt Priority Register 2
	NVIC_IPR2_PRI_8_Pos  = 0x0        // Position of PRI_8 field.
	NVIC_IPR2_PRI_8_Msk  = 0xff       // Bit mask of PRI_8 field.
	NVIC_IPR2_PRI_9_Pos  = 0x8        // Position of PRI_9 field.
	NVIC_IPR2_PRI_9_Msk  = 0xff00     // Bit mask of PRI_9 field.
	NVIC_IPR2_PRI_10_Pos = 0x10       // Position of PRI_10 field.
	NVIC_IPR2_PRI_10_Msk = 0xff0000   // Bit mask of PRI_10 field.
	NVIC_IPR2_PRI_11_Pos = 0x18       // Position of PRI_11 field.
	NVIC_IPR2_PRI_11_Msk = 0xff000000 // Bit mask of PRI_11 field.

	// IPR3: Interrupt Priority Register 3
	NVIC_IPR3_PRI_12_Pos = 0x0        // Position of PRI_12 field.
	NVIC_IPR3_PRI_12_Msk = 0xff       // Bit mask of PRI_12 field.
	NVIC_IPR3_PRI_13_Pos = 0x8        // Position of PRI_13 field.
	NVIC_IPR3_PRI_13_Msk = 0xff00     // Bit mask of PRI_13 field.
	NVIC_IPR3_PRI_14_Pos = 0x10       // Position of PRI_14 field.
	NVIC_IPR3_PRI_14_Msk = 0xff0000   // Bit mask of PRI_14 field.
	NVIC_IPR3_PRI_15_Pos = 0x18       // Position of PRI_15 field.
	NVIC_IPR3_PRI_15_Msk = 0xff000000 // Bit mask of PRI_15 field.

	// IPR4: Interrupt Priority Register 4
	NVIC_IPR4_PRI_16_Pos = 0x0        // Position of PRI_16 field.
	NVIC_IPR4_PRI_16_Msk = 0xff       // Bit mask of PRI_16 field.
	NVIC_IPR4_PRI_17_Pos = 0x8        // Position of PRI_17 field.
	NVIC_IPR4_PRI_17_Msk = 0xff00     // Bit mask of PRI_17 field.
	NVIC_IPR4_PRI_18_Pos = 0x10       // Position of PRI_18 field.
	NVIC_IPR4_PRI_18_Msk = 0xff0000   // Bit mask of PRI_18 field.
	NVIC_IPR4_PRI_19_Pos = 0x18       // Position of PRI_19 field.
	NVIC_IPR4_PRI_19_Msk = 0xff000000 // Bit mask of PRI_19 field.

	// IPR5: Interrupt Priority Register 5
	NVIC_IPR5_PRI_20_Pos = 0x0        // Position of PRI_20 field.
	NVIC_IPR5_PRI_20_Msk = 0xff       // Bit mask of PRI_20 field.
	NVIC_IPR5_PRI_21_Pos = 0x8        // Position of PRI_21 field.
	NVIC_IPR5_PRI_21_Msk = 0xff00     // Bit mask of PRI_21 field.
	NVIC_IPR5_PRI_22_Pos = 0x10       // Position of PRI_22 field.
	NVIC_IPR5_PRI_22_Msk = 0xff0000   // Bit mask of PRI_22 field.
	NVIC_IPR5_PRI_23_Pos = 0x18       // Position of PRI_23 field.
	NVIC_IPR5_PRI_23_Msk = 0xff000000 // Bit mask of PRI_23 field.

	// IPR6: Interrupt Priority Register 6
	NVIC_IPR6_PRI_24_Pos = 0x0        // Position of PRI_24 field.
	NVIC_IPR6_PRI_24_Msk = 0xff       // Bit mask of PRI_24 field.
	NVIC_IPR6_PRI_25_Pos = 0x8        // Position of PRI_25 field.
	NVIC_IPR6_PRI_25_Msk = 0xff00     // Bit mask of PRI_25 field.
	NVIC_IPR6_PRI_26_Pos = 0x10       // Position of PRI_26 field.
	NVIC_IPR6_PRI_26_Msk = 0xff0000   // Bit mask of PRI_26 field.
	NVIC_IPR6_PRI_27_Pos = 0x18       // Position of PRI_27 field.
	NVIC_IPR6_PRI_27_Msk = 0xff000000 // Bit mask of PRI_27 field.

	// IPR7: Interrupt Priority Register 7
	NVIC_IPR7_PRI_28_Pos = 0x0        // Position of PRI_28 field.
	NVIC_IPR7_PRI_28_Msk = 0xff       // Bit mask of PRI_28 field.
	NVIC_IPR7_PRI_29_Pos = 0x8        // Position of PRI_29 field.
	NVIC_IPR7_PRI_29_Msk = 0xff00     // Bit mask of PRI_29 field.
	NVIC_IPR7_PRI_30_Pos = 0x10       // Position of PRI_30 field.
	NVIC_IPR7_PRI_30_Msk = 0xff0000   // Bit mask of PRI_30 field.
	NVIC_IPR7_PRI_31_Pos = 0x18       // Position of PRI_31 field.
	NVIC_IPR7_PRI_31_Msk = 0xff000000 // Bit mask of PRI_31 field.
)

// Bitfields for MPU: Memory protection unit
const (
	// MPU_TYPER: MPU type register
	MPU_MPU_TYPER_SEPARATE_Pos = 0x0      // Position of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE_Msk = 0x1      // Bit mask of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE     = 0x1      // Bit SEPARATE.
	MPU_MPU_TYPER_DREGION_Pos  = 0x8      // Position of DREGION field.
	MPU_MPU_TYPER_DREGION_Msk  = 0xff00   // Bit mask of DREGION field.
	MPU_MPU_TYPER_IREGION_Pos  = 0x10     // Position of IREGION field.
	MPU_MPU_TYPER_IREGION_Msk  = 0xff0000 // Bit mask of IREGION field.

	// MPU_CTRL: MPU control register
	MPU_MPU_CTRL_ENABLE_Pos     = 0x0 // Position of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Msk     = 0x1 // Bit mask of ENABLE field.
	MPU_MPU_CTRL_ENABLE         = 0x1 // Bit ENABLE.
	MPU_MPU_CTRL_HFNMIENA_Pos   = 0x1 // Position of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Msk   = 0x2 // Bit mask of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA       = 0x2 // Bit HFNMIENA.
	MPU_MPU_CTRL_PRIVDEFENA_Pos = 0x2 // Position of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Msk = 0x4 // Bit mask of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA     = 0x4 // Bit PRIVDEFENA.

	// MPU_RNR: MPU region number register
	MPU_MPU_RNR_REGION_Pos = 0x0  // Position of REGION field.
	MPU_MPU_RNR_REGION_Msk = 0xff // Bit mask of REGION field.

	// MPU_RBAR: MPU region base address           register
	MPU_MPU_RBAR_REGION_Pos = 0x0        // Position of REGION field.
	MPU_MPU_RBAR_REGION_Msk = 0xf        // Bit mask of REGION field.
	MPU_MPU_RBAR_VALID_Pos  = 0x4        // Position of VALID field.
	MPU_MPU_RBAR_VALID_Msk  = 0x10       // Bit mask of VALID field.
	MPU_MPU_RBAR_VALID      = 0x10       // Bit VALID.
	MPU_MPU_RBAR_ADDR_Pos   = 0x5        // Position of ADDR field.
	MPU_MPU_RBAR_ADDR_Msk   = 0xffffffe0 // Bit mask of ADDR field.

	// MPU_RASR: MPU region attribute and size           register
	MPU_MPU_RASR_ENABLE_Pos = 0x0        // Position of ENABLE field.
	MPU_MPU_RASR_ENABLE_Msk = 0x1        // Bit mask of ENABLE field.
	MPU_MPU_RASR_ENABLE     = 0x1        // Bit ENABLE.
	MPU_MPU_RASR_SIZE_Pos   = 0x1        // Position of SIZE field.
	MPU_MPU_RASR_SIZE_Msk   = 0x3e       // Bit mask of SIZE field.
	MPU_MPU_RASR_SRD_Pos    = 0x8        // Position of SRD field.
	MPU_MPU_RASR_SRD_Msk    = 0xff00     // Bit mask of SRD field.
	MPU_MPU_RASR_B_Pos      = 0x10       // Position of B field.
	MPU_MPU_RASR_B_Msk      = 0x10000    // Bit mask of B field.
	MPU_MPU_RASR_B          = 0x10000    // Bit B.
	MPU_MPU_RASR_C_Pos      = 0x11       // Position of C field.
	MPU_MPU_RASR_C_Msk      = 0x20000    // Bit mask of C field.
	MPU_MPU_RASR_C          = 0x20000    // Bit C.
	MPU_MPU_RASR_S_Pos      = 0x12       // Position of S field.
	MPU_MPU_RASR_S_Msk      = 0x40000    // Bit mask of S field.
	MPU_MPU_RASR_S          = 0x40000    // Bit S.
	MPU_MPU_RASR_TEX_Pos    = 0x13       // Position of TEX field.
	MPU_MPU_RASR_TEX_Msk    = 0x380000   // Bit mask of TEX field.
	MPU_MPU_RASR_AP_Pos     = 0x18       // Position of AP field.
	MPU_MPU_RASR_AP_Msk     = 0x7000000  // Bit mask of AP field.
	MPU_MPU_RASR_XN_Pos     = 0x1c       // Position of XN field.
	MPU_MPU_RASR_XN_Msk     = 0x10000000 // Bit mask of XN field.
	MPU_MPU_RASR_XN         = 0x10000000 // Bit XN.
)

// Bitfields for STK: SysTick timer
const (
	// CSR: SysTick control and status           register
	STK_CSR_ENABLE_Pos    = 0x0     // Position of ENABLE field.
	STK_CSR_ENABLE_Msk    = 0x1     // Bit mask of ENABLE field.
	STK_CSR_ENABLE        = 0x1     // Bit ENABLE.
	STK_CSR_TICKINT_Pos   = 0x1     // Position of TICKINT field.
	STK_CSR_TICKINT_Msk   = 0x2     // Bit mask of TICKINT field.
	STK_CSR_TICKINT       = 0x2     // Bit TICKINT.
	STK_CSR_CLKSOURCE_Pos = 0x2     // Position of CLKSOURCE field.
	STK_CSR_CLKSOURCE_Msk = 0x4     // Bit mask of CLKSOURCE field.
	STK_CSR_CLKSOURCE     = 0x4     // Bit CLKSOURCE.
	STK_CSR_COUNTFLAG_Pos = 0x10    // Position of COUNTFLAG field.
	STK_CSR_COUNTFLAG_Msk = 0x10000 // Bit mask of COUNTFLAG field.
	STK_CSR_COUNTFLAG     = 0x10000 // Bit COUNTFLAG.

	// RVR: SysTick reload value register
	STK_RVR_RELOAD_Pos = 0x0      // Position of RELOAD field.
	STK_RVR_RELOAD_Msk = 0xffffff // Bit mask of RELOAD field.

	// CVR: SysTick current value register
	STK_CVR_CURRENT_Pos = 0x0      // Position of CURRENT field.
	STK_CVR_CURRENT_Msk = 0xffffff // Bit mask of CURRENT field.

	// CALIB: SysTick calibration value           register
	STK_CALIB_TENMS_Pos = 0x0        // Position of TENMS field.
	STK_CALIB_TENMS_Msk = 0xffffff   // Bit mask of TENMS field.
	STK_CALIB_SKEW_Pos  = 0x1e       // Position of SKEW field.
	STK_CALIB_SKEW_Msk  = 0x40000000 // Bit mask of SKEW field.
	STK_CALIB_SKEW      = 0x40000000 // Bit SKEW.
	STK_CALIB_NOREF_Pos = 0x1f       // Position of NOREF field.
	STK_CALIB_NOREF_Msk = 0x80000000 // Bit mask of NOREF field.
	STK_CALIB_NOREF     = 0x80000000 // Bit NOREF.
)

// Bitfields for SCB: System control block
const (
	// CPUID: CPUID base register
	SCB_CPUID_Revision_Pos     = 0x0        // Position of Revision field.
	SCB_CPUID_Revision_Msk     = 0xf        // Bit mask of Revision field.
	SCB_CPUID_PartNo_Pos       = 0x4        // Position of PartNo field.
	SCB_CPUID_PartNo_Msk       = 0xfff0     // Bit mask of PartNo field.
	SCB_CPUID_Architecture_Pos = 0x10       // Position of Architecture field.
	SCB_CPUID_Architecture_Msk = 0xf0000    // Bit mask of Architecture field.
	SCB_CPUID_Variant_Pos      = 0x14       // Position of Variant field.
	SCB_CPUID_Variant_Msk      = 0xf00000   // Bit mask of Variant field.
	SCB_CPUID_Implementer_Pos  = 0x18       // Position of Implementer field.
	SCB_CPUID_Implementer_Msk  = 0xff000000 // Bit mask of Implementer field.

	// ICSR: Interrupt control and state           register
	SCB_ICSR_VECTACTIVE_Pos  = 0x0        // Position of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Msk  = 0x1ff      // Bit mask of VECTACTIVE field.
	SCB_ICSR_RETTOBASE_Pos   = 0xb        // Position of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Msk   = 0x800      // Bit mask of RETTOBASE field.
	SCB_ICSR_RETTOBASE       = 0x800      // Bit RETTOBASE.
	SCB_ICSR_VECTPENDING_Pos = 0xc        // Position of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Msk = 0x7f000    // Bit mask of VECTPENDING field.
	SCB_ICSR_ISRPENDING_Pos  = 0x16       // Position of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Msk  = 0x400000   // Bit mask of ISRPENDING field.
	SCB_ICSR_ISRPENDING      = 0x400000   // Bit ISRPENDING.
	SCB_ICSR_PENDSTCLR_Pos   = 0x19       // Position of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Msk   = 0x2000000  // Bit mask of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR       = 0x2000000  // Bit PENDSTCLR.
	SCB_ICSR_PENDSTSET_Pos   = 0x1a       // Position of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Msk   = 0x4000000  // Bit mask of PENDSTSET field.
	SCB_ICSR_PENDSTSET       = 0x4000000  // Bit PENDSTSET.
	SCB_ICSR_PENDSVCLR_Pos   = 0x1b       // Position of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Msk   = 0x8000000  // Bit mask of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR       = 0x8000000  // Bit PENDSVCLR.
	SCB_ICSR_PENDSVSET_Pos   = 0x1c       // Position of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Msk   = 0x10000000 // Bit mask of PENDSVSET field.
	SCB_ICSR_PENDSVSET       = 0x10000000 // Bit PENDSVSET.
	SCB_ICSR_NMIPENDSET_Pos  = 0x1f       // Position of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET_Msk  = 0x80000000 // Bit mask of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET      = 0x80000000 // Bit NMIPENDSET.

	// VTOR: Vector table offset register
	SCB_VTOR_TBLOFF_Pos = 0x7        // Position of TBLOFF field.
	SCB_VTOR_TBLOFF_Msk = 0xffffff80 // Bit mask of TBLOFF field.

	// AIRCR: Application interrupt and reset control           register
	SCB_AIRCR_VECTCLRACTIVE_Pos = 0x1        // Position of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Msk = 0x2        // Bit mask of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE     = 0x2        // Bit VECTCLRACTIVE.
	SCB_AIRCR_SYSRESETREQ_Pos   = 0x2        // Position of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Msk   = 0x4        // Bit mask of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ       = 0x4        // Bit SYSRESETREQ.
	SCB_AIRCR_ENDIANESS_Pos     = 0xf        // Position of ENDIANESS field.
	SCB_AIRCR_ENDIANESS_Msk     = 0x8000     // Bit mask of ENDIANESS field.
	SCB_AIRCR_ENDIANESS         = 0x8000     // Bit ENDIANESS.
	SCB_AIRCR_VECTKEYSTAT_Pos   = 0x10       // Position of VECTKEYSTAT field.
	SCB_AIRCR_VECTKEYSTAT_Msk   = 0xffff0000 // Bit mask of VECTKEYSTAT field.

	// SCR: System control register
	SCB_SCR_SLEEPONEXIT_Pos = 0x1  // Position of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Msk = 0x2  // Bit mask of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT     = 0x2  // Bit SLEEPONEXIT.
	SCB_SCR_SLEEPDEEP_Pos   = 0x2  // Position of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Msk   = 0x4  // Bit mask of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP       = 0x4  // Bit SLEEPDEEP.
	SCB_SCR_SEVEONPEND_Pos  = 0x4  // Position of SEVEONPEND field.
	SCB_SCR_SEVEONPEND_Msk  = 0x10 // Bit mask of SEVEONPEND field.
	SCB_SCR_SEVEONPEND      = 0x10 // Bit SEVEONPEND.

	// CCR: Configuration and control           register
	SCB_CCR_NONBASETHRDENA_Pos = 0x0   // Position of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA_Msk = 0x1   // Bit mask of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA     = 0x1   // Bit NONBASETHRDENA.
	SCB_CCR_USERSETMPEND_Pos   = 0x1   // Position of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Msk   = 0x2   // Bit mask of USERSETMPEND field.
	SCB_CCR_USERSETMPEND       = 0x2   // Bit USERSETMPEND.
	SCB_CCR_UNALIGN__TRP_Pos   = 0x3   // Position of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP_Msk   = 0x8   // Bit mask of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP       = 0x8   // Bit UNALIGN__TRP.
	SCB_CCR_DIV_0_TRP_Pos      = 0x4   // Position of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Msk      = 0x10  // Bit mask of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP          = 0x10  // Bit DIV_0_TRP.
	SCB_CCR_BFHFNMIGN_Pos      = 0x8   // Position of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Msk      = 0x100 // Bit mask of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN          = 0x100 // Bit BFHFNMIGN.
	SCB_CCR_STKALIGN_Pos       = 0x9   // Position of STKALIGN field.
	SCB_CCR_STKALIGN_Msk       = 0x200 // Bit mask of STKALIGN field.
	SCB_CCR_STKALIGN           = 0x200 // Bit STKALIGN.

	// SHPR2: System handler priority           registers
	SCB_SHPR2_PRI_11_Pos = 0x18       // Position of PRI_11 field.
	SCB_SHPR2_PRI_11_Msk = 0xff000000 // Bit mask of PRI_11 field.

	// SHPR3: System handler priority           registers
	SCB_SHPR3_PRI_14_Pos = 0x10       // Position of PRI_14 field.
	SCB_SHPR3_PRI_14_Msk = 0xff0000   // Bit mask of PRI_14 field.
	SCB_SHPR3_PRI_15_Pos = 0x18       // Position of PRI_15 field.
	SCB_SHPR3_PRI_15_Msk = 0xff000000 // Bit mask of PRI_15 field.
)
