// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from STM32F100xx.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/STMicro

// +build stm32,stm32f100xx

// STM32F100xx
//

package stm32

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "STM32F100xx"
)

// Interrupt numbers.
const (
	IRQ_WWDG_IRQ               = 0  // Window watchdog
	IRQ_PVD_IRQ                = 1  // Power control
	IRQ_TAMPER_STAMP_IRQ       = 2  // EXTI
	IRQ_RTC_WKUP_IRQ           = 3  // Real time clock
	IRQ_FLASH_IRQ              = 4  // FLASH
	IRQ_RCC_IRQ                = 5  // Reset and clock control
	IRQ_EXTI0_IRQ              = 6  // EXTI
	IRQ_EXTI1_IRQ              = 7  // EXTI
	IRQ_EXTI2_IRQ              = 8  // EXTI
	IRQ_EXTI3_IRQ              = 9  // EXTI
	IRQ_EXTI4_IRQ              = 10 // EXTI
	IRQ_DMA1_Channel1_IRQ      = 11 // DMA controller
	IRQ_DMA1_Channel2_IRQ      = 12 // DMA controller
	IRQ_DMA1_Channel3_IRQ      = 13 // DMA controller
	IRQ_DMA1_Channel4_IRQ      = 14 // DMA controller
	IRQ_DMA1_Channel5_IRQ      = 15 // DMA controller
	IRQ_DMA1_Channel6_IRQ      = 16 // DMA controller
	IRQ_DMA1_Channel7_IRQ      = 17 // DMA controller
	IRQ_ADC_IRQ                = 18 // Analog to digital converter
	IRQ_EXTI9_5_IRQ            = 23 // EXTI
	IRQ_TIM1_BRK_TIM15_IRQ     = 24 // Advanced timer // General purpose timers
	IRQ_TIM1_UP_TIM16_IRQ      = 25 // Advanced timer // General-purpose-timers
	IRQ_TIM1_TRG_COM_TIM17_IRQ = 26 // Advanced timer //
	IRQ_TIM1_CC_IRQ            = 27 // Advanced timer
	IRQ_TIM2_IRQ               = 28 // General purpose timer
	IRQ_TIM3_IRQ               = 29 //
	IRQ_TIM4_IRQ               = 30 //
	IRQ_I2C1_EV_IRQ            = 31 // Inter integrated circuit
	IRQ_I2C1_ER_IRQ            = 32 // Inter integrated circuit
	IRQ_I2C2_EV_IRQ            = 33 //
	IRQ_I2C2_ER_IRQ            = 34 //
	IRQ_SPI1_IRQ               = 35 // Serial peripheral interface
	IRQ_SPI2_IRQ               = 36 //
	IRQ_USART1_IRQ             = 37 // Universal synchronous asynchronous receiver transmitter
	IRQ_USART2_IRQ             = 38 //
	IRQ_USART3_IRQ             = 39 //
	IRQ_EXTI15_10_IRQ          = 40 // EXTI
	IRQ_RTCAlarm_IRQ           = 41 // Real time clock
	IRQ_CEC_IRQ                = 42 // HDMI-CEC controller
	IRQ_TIM12_IRQ              = 43 // General purpose timer
	IRQ_TIM13_IRQ              = 44 // General purpose timer //
	IRQ_FSMC_IRQ               = 48 // Flexible static memory controller
	IRQ_TIM5_IRQ               = 50 //
	IRQ_SPI3_IRQ               = 51 //
	IRQ_UART4_IRQ              = 52 // Universal asynchronous receiver transmitter
	IRQ_UART5_IRQ              = 53 // Universal asynchronous receiver transmitter
	IRQ_TIM6_DAC_IRQ           = 54 // Basic timer // Digital to analog converter
	IRQ_TIM7_IRQ               = 55 //
	IRQ_DMA2_Channel1_IRQ      = 56 //
	IRQ_DMA2_Channel2_IRQ      = 57 //
	IRQ_DMA2_Channel3_IRQ      = 58 //
	IRQ_DMA2_Channel4_5_IRQ    = 59 //
	IRQ_max                    = 59 // Highest interrupt number on this device.
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_WWDG_IRQ, "WWDG_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_PVD_IRQ, "PVD_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TAMPER_STAMP_IRQ, "TAMPER_STAMP_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_WKUP_IRQ, "RTC_WKUP_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_FLASH_IRQ, "FLASH_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_RCC_IRQ, "RCC_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI0_IRQ, "EXTI0_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI1_IRQ, "EXTI1_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI2_IRQ, "EXTI2_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI3_IRQ, "EXTI3_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI4_IRQ, "EXTI4_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel1_IRQ, "DMA1_Channel1_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel2_IRQ, "DMA1_Channel2_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel3_IRQ, "DMA1_Channel3_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel4_IRQ, "DMA1_Channel4_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel5_IRQ, "DMA1_Channel5_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel6_IRQ, "DMA1_Channel6_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel7_IRQ, "DMA1_Channel7_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_ADC_IRQ, "ADC_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI9_5_IRQ, "EXTI9_5_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_BRK_TIM15_IRQ, "TIM1_BRK_TIM15_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_UP_TIM16_IRQ, "TIM1_UP_TIM16_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_TRG_COM_TIM17_IRQ, "TIM1_TRG_COM_TIM17_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_CC_IRQ, "TIM1_CC_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TIM2_IRQ, "TIM2_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TIM3_IRQ, "TIM3_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TIM4_IRQ, "TIM4_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1_EV_IRQ, "I2C1_EV_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1_ER_IRQ, "I2C1_ER_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2_EV_IRQ, "I2C2_EV_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2_ER_IRQ, "I2C2_ER_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_SPI1_IRQ, "SPI1_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_SPI2_IRQ, "SPI2_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_USART1_IRQ, "USART1_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_USART2_IRQ, "USART2_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_USART3_IRQ, "USART3_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI15_10_IRQ, "EXTI15_10_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_RTCAlarm_IRQ, "RTCAlarm_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_CEC_IRQ, "CEC_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TIM12_IRQ, "TIM12_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TIM13_IRQ, "TIM13_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_FSMC_IRQ, "FSMC_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TIM5_IRQ, "TIM5_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_SPI3_IRQ, "SPI3_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_UART4_IRQ, "UART4_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_UART5_IRQ, "UART5_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TIM6_DAC_IRQ, "TIM6_DAC_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TIM7_IRQ, "TIM7_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Channel1_IRQ, "DMA2_Channel1_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Channel2_IRQ, "DMA2_Channel2_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Channel3_IRQ, "DMA2_Channel3_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_Channel4_5_IRQ, "DMA2_Channel4_5_IRQ_IRQHandler")
)

// Peripherals.
var (
	FSMC   = (*FSMC_Type)(unsafe.Pointer(uintptr(0xa0000000)))  // Flexible static memory controller
	PWR    = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))   // Power control
	RCC    = (*RCC_Type)(unsafe.Pointer(uintptr(0x40021000)))   // Reset and clock control
	GPIOA  = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40010800)))  // General purpose I/O
	AFIO   = (*AFIO_Type)(unsafe.Pointer(uintptr(0x40010000)))  // Alternate function I/O
	EXTI   = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40010400)))  // EXTI
	DMA1   = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020000)))   // DMA controller
	RTC    = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))   // Real time clock
	BKP    = (*BKP_Type)(unsafe.Pointer(uintptr(0x40006c04)))   // Backup registers
	IWDG   = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))  // Independent watchdog
	WWDG   = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))  // Window watchdog
	TIM1   = (*TIM_Type)(unsafe.Pointer(uintptr(0x40012c00)))   // Advanced timer
	TIM2   = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))   // General purpose timer
	TIM12  = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001800)))   // General purpose timer
	TIM13  = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001c00)))   // General purpose timer
	TIM6   = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))   // Basic timer
	I2C1   = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))   // Inter integrated circuit
	SPI1   = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))   // Serial peripheral interface
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800))) // Universal synchronous asynchronous receiver transmitter
	ADC1   = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012400)))   // Analog to digital converter
	DAC    = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))   // Digital to analog converter
	DBG    = (*DBG_Type)(unsafe.Pointer(uintptr(0xe0042000)))   // Debug support
	UART4  = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00))) // Universal asynchronous receiver transmitter
	UART5  = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000))) // Universal asynchronous receiver transmitter
	CRC    = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))   // CRC calculation unit
	FLASH  = (*FLASH_Type)(unsafe.Pointer(uintptr(0x40022000))) // FLASH
	TIM15  = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014000)))   // General purpose timers
	TIM16  = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))   // General-purpose-timers
	CEC    = (*CEC_Type)(unsafe.Pointer(uintptr(0x40007800)))   // HDMI-CEC controller
	NVIC   = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e000)))  // Nested Vectored Interrupt Controller
	GPIOB  = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40010c00)))  // General purpose I/O
	GPIOC  = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40011000)))  // General purpose I/O
	GPIOD  = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40011400)))  // General purpose I/O
	GPIOE  = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40011800)))  // General purpose I/O
	GPIOF  = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40011c00)))  // General purpose I/O
	GPIOG  = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40012000)))  // General purpose I/O
	DMA2   = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020400)))   // DMA controller
	TIM3   = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))   // General purpose timer
	TIM4   = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000800)))   // General purpose timer
	TIM5   = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000c00)))   // General purpose timer
	TIM14  = (*TIM_Type)(unsafe.Pointer(uintptr(0x40002000)))   // General purpose timer
	TIM7   = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))   // Basic timer
	I2C2   = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))   // Inter integrated circuit
	SPI2   = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))   // Serial peripheral interface
	SPI3   = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))   // Serial peripheral interface
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400))) // Universal synchronous asynchronous receiver transmitter
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800))) // Universal synchronous asynchronous receiver transmitter
	TIM17  = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))   // General-purpose-timers
)

// Flexible static memory controller
type FSMC_Type struct {
	BCR1  volatile.Register32 // 0x0
	BTR1  volatile.Register32 // 0x4
	BCR2  volatile.Register32 // 0x8
	BTR2  volatile.Register32 // 0xC
	BCR3  volatile.Register32 // 0x10
	BTR3  volatile.Register32 // 0x14
	BCR4  volatile.Register32 // 0x18
	BTR4  volatile.Register32 // 0x1C
	_     [228]byte
	BWTR1 volatile.Register32 // 0x104
	_     [4]byte
	BWTR2 volatile.Register32 // 0x10C
	_     [4]byte
	BWTR3 volatile.Register32 // 0x114
	_     [4]byte
	BWTR4 volatile.Register32 // 0x11C
}

// Power control
type PWR_Type struct {
	CR  volatile.Register32 // 0x0
	CSR volatile.Register32 // 0x4
}

// Reset and clock control
type RCC_Type struct {
	CR       volatile.Register32 // 0x0
	CFGR     volatile.Register32 // 0x4
	CIR      volatile.Register32 // 0x8
	APB2RSTR volatile.Register32 // 0xC
	APB1RSTR volatile.Register32 // 0x10
	AHBENR   volatile.Register32 // 0x14
	APB2ENR  volatile.Register32 // 0x18
	APB1ENR  volatile.Register32 // 0x1C
	BDCR     volatile.Register32 // 0x20
	CSR      volatile.Register32 // 0x24
	_        [4]byte
	CFGR2    volatile.Register32 // 0x2C
}

// General purpose I/O
type GPIO_Type struct {
	CRL  volatile.Register32 // 0x0
	CRH  volatile.Register32 // 0x4
	IDR  volatile.Register32 // 0x8
	ODR  volatile.Register32 // 0xC
	BSRR volatile.Register32 // 0x10
	BRR  volatile.Register32 // 0x14
	LCKR volatile.Register32 // 0x18
}

// Alternate function I/O
type AFIO_Type struct {
	EVCR    volatile.Register32 // 0x0
	MAPR    volatile.Register32 // 0x4
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	_       [4]byte
	MAPR2   volatile.Register32 // 0x1C
}

// EXTI
type EXTI_Type struct {
	IMR   volatile.Register32 // 0x0
	EMR   volatile.Register32 // 0x4
	RTSR  volatile.Register32 // 0x8
	FTSR  volatile.Register32 // 0xC
	SWIER volatile.Register32 // 0x10
	PR    volatile.Register32 // 0x14
}

// DMA controller
type DMA_Type struct {
	ISR    volatile.Register32 // 0x0
	IFCR   volatile.Register32 // 0x4
	CCR1   volatile.Register32 // 0x8
	CNDTR1 volatile.Register32 // 0xC
	CPAR1  volatile.Register32 // 0x10
	CMAR1  volatile.Register32 // 0x14
	_      [4]byte
	CCR2   volatile.Register32 // 0x1C
	CNDTR2 volatile.Register32 // 0x20
	CPAR2  volatile.Register32 // 0x24
	CMAR2  volatile.Register32 // 0x28
	_      [4]byte
	CCR3   volatile.Register32 // 0x30
	CNDTR3 volatile.Register32 // 0x34
	CPAR3  volatile.Register32 // 0x38
	CMAR3  volatile.Register32 // 0x3C
	_      [4]byte
	CCR4   volatile.Register32 // 0x44
	CNDTR4 volatile.Register32 // 0x48
	CPAR4  volatile.Register32 // 0x4C
	CMAR4  volatile.Register32 // 0x50
	_      [4]byte
	CCR5   volatile.Register32 // 0x58
	CNDTR5 volatile.Register32 // 0x5C
	CPAR5  volatile.Register32 // 0x60
	CMAR5  volatile.Register32 // 0x64
	_      [4]byte
	CCR6   volatile.Register32 // 0x6C
	CNDTR6 volatile.Register32 // 0x70
	CPAR6  volatile.Register32 // 0x74
	CMAR6  volatile.Register32 // 0x78
	_      [4]byte
	CCR7   volatile.Register32 // 0x80
	CNDTR7 volatile.Register32 // 0x84
	CPAR7  volatile.Register32 // 0x88
	CMAR7  volatile.Register32 // 0x8C
}

// Real time clock
type RTC_Type struct {
	CRH  volatile.Register32 // 0x0
	CRL  volatile.Register32 // 0x4
	PRLH volatile.Register32 // 0x8
	PRLL volatile.Register32 // 0xC
	DIVH volatile.Register32 // 0x10
	DIVL volatile.Register32 // 0x14
	CNTH volatile.Register32 // 0x18
	CNTL volatile.Register32 // 0x1C
	ALRH volatile.Register32 // 0x20
	ALRL volatile.Register32 // 0x24
}

// Backup registers
type BKP_Type struct {
	DR1   volatile.Register32 // 0x0
	DR2   volatile.Register32 // 0x4
	DR3   volatile.Register32 // 0x8
	DR4   volatile.Register32 // 0xC
	DR5   volatile.Register32 // 0x10
	DR6   volatile.Register32 // 0x14
	DR7   volatile.Register32 // 0x18
	DR8   volatile.Register32 // 0x1C
	DR9   volatile.Register32 // 0x20
	DR10  volatile.Register32 // 0x24
	RTCCR volatile.Register32 // 0x28
	CR    volatile.Register32 // 0x2C
	CSR   volatile.Register32 // 0x30
	_     [8]byte
	DR11  volatile.Register32 // 0x3C
	DR12  volatile.Register32 // 0x40
	DR13  volatile.Register32 // 0x44
	DR14  volatile.Register32 // 0x48
	DR15  volatile.Register32 // 0x4C
	DR16  volatile.Register32 // 0x50
	DR17  volatile.Register32 // 0x54
	DR18  volatile.Register32 // 0x58
	DR19  volatile.Register32 // 0x5C
	DR20  volatile.Register32 // 0x60
	DR21  volatile.Register32 // 0x64
	DR22  volatile.Register32 // 0x68
	DR23  volatile.Register32 // 0x6C
	DR24  volatile.Register32 // 0x70
	DR25  volatile.Register32 // 0x74
	DR26  volatile.Register32 // 0x78
	DR27  volatile.Register32 // 0x7C
	DR28  volatile.Register32 // 0x80
	DR29  volatile.Register32 // 0x84
	DR30  volatile.Register32 // 0x88
	DR31  volatile.Register32 // 0x8C
	DR32  volatile.Register32 // 0x90
	DR33  volatile.Register32 // 0x94
	DR34  volatile.Register32 // 0x98
	DR35  volatile.Register32 // 0x9C
	DR36  volatile.Register32 // 0xA0
	DR37  volatile.Register32 // 0xA4
	DR38  volatile.Register32 // 0xA8
	DR39  volatile.Register32 // 0xAC
	DR40  volatile.Register32 // 0xB0
	DR41  volatile.Register32 // 0xB4
	DR42  volatile.Register32 // 0xB8
}

// Independent watchdog
type IWDG_Type struct {
	KR  volatile.Register32 // 0x0
	PR  volatile.Register32 // 0x4
	RLR volatile.Register32 // 0x8
	SR  volatile.Register32 // 0xC
}

// Window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// Advanced timer
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	RCR          volatile.Register32 // 0x30
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	BDTR         volatile.Register32 // 0x44
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
}

// Inter integrated circuit
type I2C_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	OAR1  volatile.Register32 // 0x8
	OAR2  volatile.Register32 // 0xC
	DR    volatile.Register32 // 0x10
	SR1   volatile.Register32 // 0x14
	SR2   volatile.Register32 // 0x18
	CCR   volatile.Register32 // 0x1C
	TRISE volatile.Register32 // 0x20
}

// Serial peripheral interface
type SPI_Type struct {
	CR1    volatile.Register32 // 0x0
	CR2    volatile.Register32 // 0x4
	SR     volatile.Register32 // 0x8
	DR     volatile.Register32 // 0xC
	CRCPR  volatile.Register32 // 0x10
	RXCRCR volatile.Register32 // 0x14
	TXCRCR volatile.Register32 // 0x18
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	SR   volatile.Register32 // 0x0
	DR   volatile.Register32 // 0x4
	BRR  volatile.Register32 // 0x8
	CR1  volatile.Register32 // 0xC
	CR2  volatile.Register32 // 0x10
	CR3  volatile.Register32 // 0x14
	GTPR volatile.Register32 // 0x18
}

// Analog to digital converter
type ADC_Type struct {
	SR    volatile.Register32 // 0x0
	CR1   volatile.Register32 // 0x4
	CR2   volatile.Register32 // 0x8
	SMPR1 volatile.Register32 // 0xC
	SMPR2 volatile.Register32 // 0x10
	JOFR1 volatile.Register32 // 0x14
	JOFR2 volatile.Register32 // 0x18
	JOFR3 volatile.Register32 // 0x1C
	JOFR4 volatile.Register32 // 0x20
	HTR   volatile.Register32 // 0x24
	LTR   volatile.Register32 // 0x28
	SQR1  volatile.Register32 // 0x2C
	SQR2  volatile.Register32 // 0x30
	SQR3  volatile.Register32 // 0x34
	JSQR  volatile.Register32 // 0x38
	JDR1  volatile.Register32 // 0x3C
	JDR2  volatile.Register32 // 0x40
	JDR3  volatile.Register32 // 0x44
	JDR4  volatile.Register32 // 0x48
	DR    volatile.Register32 // 0x4C
}

// Digital to analog converter
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRIGR volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	DHR12R2 volatile.Register32 // 0x14
	DHR12L2 volatile.Register32 // 0x18
	DHR8R2  volatile.Register32 // 0x1C
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	DOR2    volatile.Register32 // 0x30
	SR      volatile.Register32 // 0x34
}

// Debug support
type DBG_Type struct {
	IDCODE volatile.Register32 // 0x0
	CR     volatile.Register32 // 0x4
}

// CRC calculation unit
type CRC_Type struct {
	DR  volatile.Register32 // 0x0
	IDR volatile.Register32 // 0x4
	CR  volatile.Register32 // 0x8
}

// FLASH
type FLASH_Type struct {
	ACR     volatile.Register32 // 0x0
	KEYR    volatile.Register32 // 0x4
	OPTKEYR volatile.Register32 // 0x8
	SR      volatile.Register32 // 0xC
	CR      volatile.Register32 // 0x10
	AR      volatile.Register32 // 0x14
	_       [4]byte
	OBR     volatile.Register32 // 0x1C
	WRPR    volatile.Register32 // 0x20
}

// HDMI-CEC controller
type CEC_Type struct {
	CFGR volatile.Register32 // 0x0
	OAR  volatile.Register32 // 0x4
	PRES volatile.Register32 // 0x8
	ESR  volatile.Register32 // 0xC
	CSR  volatile.Register32 // 0x10
	TXD  volatile.Register32 // 0x14
	RXD  volatile.Register32 // 0x18
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	_     [4]byte
	ICTR  volatile.Register32 // 0x4
	_     [248]byte
	ISER0 volatile.Register32 // 0x100
	ISER1 volatile.Register32 // 0x104
	_     [120]byte
	ICER0 volatile.Register32 // 0x180
	ICER1 volatile.Register32 // 0x184
	_     [120]byte
	ISPR0 volatile.Register32 // 0x200
	ISPR1 volatile.Register32 // 0x204
	_     [120]byte
	ICPR0 volatile.Register32 // 0x280
	ICPR1 volatile.Register32 // 0x284
	_     [120]byte
	IABR0 volatile.Register32 // 0x300
	IABR1 volatile.Register32 // 0x304
	_     [248]byte
	IPR0  volatile.Register32 // 0x400
	IPR1  volatile.Register32 // 0x404
	IPR2  volatile.Register32 // 0x408
	IPR3  volatile.Register32 // 0x40C
	IPR4  volatile.Register32 // 0x410
	IPR5  volatile.Register32 // 0x414
	IPR6  volatile.Register32 // 0x418
	IPR7  volatile.Register32 // 0x41C
	IPR8  volatile.Register32 // 0x420
	IPR9  volatile.Register32 // 0x424
	IPR10 volatile.Register32 // 0x428
	IPR11 volatile.Register32 // 0x42C
	IPR12 volatile.Register32 // 0x430
	IPR13 volatile.Register32 // 0x434
	IPR14 volatile.Register32 // 0x438
	_     [2756]byte
	STIR  volatile.Register32 // 0xF00
}

// Bitfields for FSMC: Flexible static memory controller
const (
	// BCR1: SRAM/NOR-Flash chip-select control register           1
	FSMC_BCR1_CBURSTRW_Pos  = 0x13    // Position of CBURSTRW field.
	FSMC_BCR1_CBURSTRW_Msk  = 0x80000 // Bit mask of CBURSTRW field.
	FSMC_BCR1_CBURSTRW      = 0x80000 // Bit CBURSTRW.
	FSMC_BCR1_ASYNCWAIT_Pos = 0xf     // Position of ASYNCWAIT field.
	FSMC_BCR1_ASYNCWAIT_Msk = 0x8000  // Bit mask of ASYNCWAIT field.
	FSMC_BCR1_ASYNCWAIT     = 0x8000  // Bit ASYNCWAIT.
	FSMC_BCR1_EXTMOD_Pos    = 0xe     // Position of EXTMOD field.
	FSMC_BCR1_EXTMOD_Msk    = 0x4000  // Bit mask of EXTMOD field.
	FSMC_BCR1_EXTMOD        = 0x4000  // Bit EXTMOD.
	FSMC_BCR1_WAITEN_Pos    = 0xd     // Position of WAITEN field.
	FSMC_BCR1_WAITEN_Msk    = 0x2000  // Bit mask of WAITEN field.
	FSMC_BCR1_WAITEN        = 0x2000  // Bit WAITEN.
	FSMC_BCR1_WREN_Pos      = 0xc     // Position of WREN field.
	FSMC_BCR1_WREN_Msk      = 0x1000  // Bit mask of WREN field.
	FSMC_BCR1_WREN          = 0x1000  // Bit WREN.
	FSMC_BCR1_WAITCFG_Pos   = 0xb     // Position of WAITCFG field.
	FSMC_BCR1_WAITCFG_Msk   = 0x800   // Bit mask of WAITCFG field.
	FSMC_BCR1_WAITCFG       = 0x800   // Bit WAITCFG.
	FSMC_BCR1_WAITPOL_Pos   = 0x9     // Position of WAITPOL field.
	FSMC_BCR1_WAITPOL_Msk   = 0x200   // Bit mask of WAITPOL field.
	FSMC_BCR1_WAITPOL       = 0x200   // Bit WAITPOL.
	FSMC_BCR1_BURSTEN_Pos   = 0x8     // Position of BURSTEN field.
	FSMC_BCR1_BURSTEN_Msk   = 0x100   // Bit mask of BURSTEN field.
	FSMC_BCR1_BURSTEN       = 0x100   // Bit BURSTEN.
	FSMC_BCR1_FACCEN_Pos    = 0x6     // Position of FACCEN field.
	FSMC_BCR1_FACCEN_Msk    = 0x40    // Bit mask of FACCEN field.
	FSMC_BCR1_FACCEN        = 0x40    // Bit FACCEN.
	FSMC_BCR1_MWID_Pos      = 0x4     // Position of MWID field.
	FSMC_BCR1_MWID_Msk      = 0x30    // Bit mask of MWID field.
	FSMC_BCR1_MTYP_Pos      = 0x2     // Position of MTYP field.
	FSMC_BCR1_MTYP_Msk      = 0xc     // Bit mask of MTYP field.
	FSMC_BCR1_MUXEN_Pos     = 0x1     // Position of MUXEN field.
	FSMC_BCR1_MUXEN_Msk     = 0x2     // Bit mask of MUXEN field.
	FSMC_BCR1_MUXEN         = 0x2     // Bit MUXEN.
	FSMC_BCR1_MBKEN_Pos     = 0x0     // Position of MBKEN field.
	FSMC_BCR1_MBKEN_Msk     = 0x1     // Bit mask of MBKEN field.
	FSMC_BCR1_MBKEN         = 0x1     // Bit MBKEN.

	// BTR1: SRAM/NOR-Flash chip-select timing register           1
	FSMC_BTR1_ACCMOD_Pos  = 0x1c       // Position of ACCMOD field.
	FSMC_BTR1_ACCMOD_Msk  = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BTR1_DATLAT_Pos  = 0x18       // Position of DATLAT field.
	FSMC_BTR1_DATLAT_Msk  = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BTR1_CLKDIV_Pos  = 0x14       // Position of CLKDIV field.
	FSMC_BTR1_CLKDIV_Msk  = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BTR1_BUSTURN_Pos = 0x10       // Position of BUSTURN field.
	FSMC_BTR1_BUSTURN_Msk = 0xf0000    // Bit mask of BUSTURN field.
	FSMC_BTR1_DATAST_Pos  = 0x8        // Position of DATAST field.
	FSMC_BTR1_DATAST_Msk  = 0xff00     // Bit mask of DATAST field.
	FSMC_BTR1_ADDHLD_Pos  = 0x4        // Position of ADDHLD field.
	FSMC_BTR1_ADDHLD_Msk  = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BTR1_ADDSET_Pos  = 0x0        // Position of ADDSET field.
	FSMC_BTR1_ADDSET_Msk  = 0xf        // Bit mask of ADDSET field.

	// BCR2: SRAM/NOR-Flash chip-select control register           2
	FSMC_BCR2_CBURSTRW_Pos  = 0x13    // Position of CBURSTRW field.
	FSMC_BCR2_CBURSTRW_Msk  = 0x80000 // Bit mask of CBURSTRW field.
	FSMC_BCR2_CBURSTRW      = 0x80000 // Bit CBURSTRW.
	FSMC_BCR2_ASYNCWAIT_Pos = 0xf     // Position of ASYNCWAIT field.
	FSMC_BCR2_ASYNCWAIT_Msk = 0x8000  // Bit mask of ASYNCWAIT field.
	FSMC_BCR2_ASYNCWAIT     = 0x8000  // Bit ASYNCWAIT.
	FSMC_BCR2_EXTMOD_Pos    = 0xe     // Position of EXTMOD field.
	FSMC_BCR2_EXTMOD_Msk    = 0x4000  // Bit mask of EXTMOD field.
	FSMC_BCR2_EXTMOD        = 0x4000  // Bit EXTMOD.
	FSMC_BCR2_WAITEN_Pos    = 0xd     // Position of WAITEN field.
	FSMC_BCR2_WAITEN_Msk    = 0x2000  // Bit mask of WAITEN field.
	FSMC_BCR2_WAITEN        = 0x2000  // Bit WAITEN.
	FSMC_BCR2_WREN_Pos      = 0xc     // Position of WREN field.
	FSMC_BCR2_WREN_Msk      = 0x1000  // Bit mask of WREN field.
	FSMC_BCR2_WREN          = 0x1000  // Bit WREN.
	FSMC_BCR2_WAITCFG_Pos   = 0xb     // Position of WAITCFG field.
	FSMC_BCR2_WAITCFG_Msk   = 0x800   // Bit mask of WAITCFG field.
	FSMC_BCR2_WAITCFG       = 0x800   // Bit WAITCFG.
	FSMC_BCR2_WRAPMOD_Pos   = 0xa     // Position of WRAPMOD field.
	FSMC_BCR2_WRAPMOD_Msk   = 0x400   // Bit mask of WRAPMOD field.
	FSMC_BCR2_WRAPMOD       = 0x400   // Bit WRAPMOD.
	FSMC_BCR2_WAITPOL_Pos   = 0x9     // Position of WAITPOL field.
	FSMC_BCR2_WAITPOL_Msk   = 0x200   // Bit mask of WAITPOL field.
	FSMC_BCR2_WAITPOL       = 0x200   // Bit WAITPOL.
	FSMC_BCR2_BURSTEN_Pos   = 0x8     // Position of BURSTEN field.
	FSMC_BCR2_BURSTEN_Msk   = 0x100   // Bit mask of BURSTEN field.
	FSMC_BCR2_BURSTEN       = 0x100   // Bit BURSTEN.
	FSMC_BCR2_FACCEN_Pos    = 0x6     // Position of FACCEN field.
	FSMC_BCR2_FACCEN_Msk    = 0x40    // Bit mask of FACCEN field.
	FSMC_BCR2_FACCEN        = 0x40    // Bit FACCEN.
	FSMC_BCR2_MWID_Pos      = 0x4     // Position of MWID field.
	FSMC_BCR2_MWID_Msk      = 0x30    // Bit mask of MWID field.
	FSMC_BCR2_MTYP_Pos      = 0x2     // Position of MTYP field.
	FSMC_BCR2_MTYP_Msk      = 0xc     // Bit mask of MTYP field.
	FSMC_BCR2_MUXEN_Pos     = 0x1     // Position of MUXEN field.
	FSMC_BCR2_MUXEN_Msk     = 0x2     // Bit mask of MUXEN field.
	FSMC_BCR2_MUXEN         = 0x2     // Bit MUXEN.
	FSMC_BCR2_MBKEN_Pos     = 0x0     // Position of MBKEN field.
	FSMC_BCR2_MBKEN_Msk     = 0x1     // Bit mask of MBKEN field.
	FSMC_BCR2_MBKEN         = 0x1     // Bit MBKEN.

	// BTR2: SRAM/NOR-Flash chip-select timing register           2
	FSMC_BTR2_ACCMOD_Pos  = 0x1c       // Position of ACCMOD field.
	FSMC_BTR2_ACCMOD_Msk  = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BTR2_DATLAT_Pos  = 0x18       // Position of DATLAT field.
	FSMC_BTR2_DATLAT_Msk  = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BTR2_CLKDIV_Pos  = 0x14       // Position of CLKDIV field.
	FSMC_BTR2_CLKDIV_Msk  = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BTR2_BUSTURN_Pos = 0x10       // Position of BUSTURN field.
	FSMC_BTR2_BUSTURN_Msk = 0xf0000    // Bit mask of BUSTURN field.
	FSMC_BTR2_DATAST_Pos  = 0x8        // Position of DATAST field.
	FSMC_BTR2_DATAST_Msk  = 0xff00     // Bit mask of DATAST field.
	FSMC_BTR2_ADDHLD_Pos  = 0x4        // Position of ADDHLD field.
	FSMC_BTR2_ADDHLD_Msk  = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BTR2_ADDSET_Pos  = 0x0        // Position of ADDSET field.
	FSMC_BTR2_ADDSET_Msk  = 0xf        // Bit mask of ADDSET field.

	// BCR3: SRAM/NOR-Flash chip-select control register           3
	FSMC_BCR3_CBURSTRW_Pos  = 0x13    // Position of CBURSTRW field.
	FSMC_BCR3_CBURSTRW_Msk  = 0x80000 // Bit mask of CBURSTRW field.
	FSMC_BCR3_CBURSTRW      = 0x80000 // Bit CBURSTRW.
	FSMC_BCR3_ASYNCWAIT_Pos = 0xf     // Position of ASYNCWAIT field.
	FSMC_BCR3_ASYNCWAIT_Msk = 0x8000  // Bit mask of ASYNCWAIT field.
	FSMC_BCR3_ASYNCWAIT     = 0x8000  // Bit ASYNCWAIT.
	FSMC_BCR3_EXTMOD_Pos    = 0xe     // Position of EXTMOD field.
	FSMC_BCR3_EXTMOD_Msk    = 0x4000  // Bit mask of EXTMOD field.
	FSMC_BCR3_EXTMOD        = 0x4000  // Bit EXTMOD.
	FSMC_BCR3_WAITEN_Pos    = 0xd     // Position of WAITEN field.
	FSMC_BCR3_WAITEN_Msk    = 0x2000  // Bit mask of WAITEN field.
	FSMC_BCR3_WAITEN        = 0x2000  // Bit WAITEN.
	FSMC_BCR3_WREN_Pos      = 0xc     // Position of WREN field.
	FSMC_BCR3_WREN_Msk      = 0x1000  // Bit mask of WREN field.
	FSMC_BCR3_WREN          = 0x1000  // Bit WREN.
	FSMC_BCR3_WAITCFG_Pos   = 0xb     // Position of WAITCFG field.
	FSMC_BCR3_WAITCFG_Msk   = 0x800   // Bit mask of WAITCFG field.
	FSMC_BCR3_WAITCFG       = 0x800   // Bit WAITCFG.
	FSMC_BCR3_WRAPMOD_Pos   = 0xa     // Position of WRAPMOD field.
	FSMC_BCR3_WRAPMOD_Msk   = 0x400   // Bit mask of WRAPMOD field.
	FSMC_BCR3_WRAPMOD       = 0x400   // Bit WRAPMOD.
	FSMC_BCR3_WAITPOL_Pos   = 0x9     // Position of WAITPOL field.
	FSMC_BCR3_WAITPOL_Msk   = 0x200   // Bit mask of WAITPOL field.
	FSMC_BCR3_WAITPOL       = 0x200   // Bit WAITPOL.
	FSMC_BCR3_BURSTEN_Pos   = 0x8     // Position of BURSTEN field.
	FSMC_BCR3_BURSTEN_Msk   = 0x100   // Bit mask of BURSTEN field.
	FSMC_BCR3_BURSTEN       = 0x100   // Bit BURSTEN.
	FSMC_BCR3_FACCEN_Pos    = 0x6     // Position of FACCEN field.
	FSMC_BCR3_FACCEN_Msk    = 0x40    // Bit mask of FACCEN field.
	FSMC_BCR3_FACCEN        = 0x40    // Bit FACCEN.
	FSMC_BCR3_MWID_Pos      = 0x4     // Position of MWID field.
	FSMC_BCR3_MWID_Msk      = 0x30    // Bit mask of MWID field.
	FSMC_BCR3_MTYP_Pos      = 0x2     // Position of MTYP field.
	FSMC_BCR3_MTYP_Msk      = 0xc     // Bit mask of MTYP field.
	FSMC_BCR3_MUXEN_Pos     = 0x1     // Position of MUXEN field.
	FSMC_BCR3_MUXEN_Msk     = 0x2     // Bit mask of MUXEN field.
	FSMC_BCR3_MUXEN         = 0x2     // Bit MUXEN.
	FSMC_BCR3_MBKEN_Pos     = 0x0     // Position of MBKEN field.
	FSMC_BCR3_MBKEN_Msk     = 0x1     // Bit mask of MBKEN field.
	FSMC_BCR3_MBKEN         = 0x1     // Bit MBKEN.

	// BTR3: SRAM/NOR-Flash chip-select timing register           3
	FSMC_BTR3_ACCMOD_Pos  = 0x1c       // Position of ACCMOD field.
	FSMC_BTR3_ACCMOD_Msk  = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BTR3_DATLAT_Pos  = 0x18       // Position of DATLAT field.
	FSMC_BTR3_DATLAT_Msk  = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BTR3_CLKDIV_Pos  = 0x14       // Position of CLKDIV field.
	FSMC_BTR3_CLKDIV_Msk  = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BTR3_BUSTURN_Pos = 0x10       // Position of BUSTURN field.
	FSMC_BTR3_BUSTURN_Msk = 0xf0000    // Bit mask of BUSTURN field.
	FSMC_BTR3_DATAST_Pos  = 0x8        // Position of DATAST field.
	FSMC_BTR3_DATAST_Msk  = 0xff00     // Bit mask of DATAST field.
	FSMC_BTR3_ADDHLD_Pos  = 0x4        // Position of ADDHLD field.
	FSMC_BTR3_ADDHLD_Msk  = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BTR3_ADDSET_Pos  = 0x0        // Position of ADDSET field.
	FSMC_BTR3_ADDSET_Msk  = 0xf        // Bit mask of ADDSET field.

	// BCR4: SRAM/NOR-Flash chip-select control register           4
	FSMC_BCR4_CBURSTRW_Pos  = 0x13    // Position of CBURSTRW field.
	FSMC_BCR4_CBURSTRW_Msk  = 0x80000 // Bit mask of CBURSTRW field.
	FSMC_BCR4_CBURSTRW      = 0x80000 // Bit CBURSTRW.
	FSMC_BCR4_ASYNCWAIT_Pos = 0xf     // Position of ASYNCWAIT field.
	FSMC_BCR4_ASYNCWAIT_Msk = 0x8000  // Bit mask of ASYNCWAIT field.
	FSMC_BCR4_ASYNCWAIT     = 0x8000  // Bit ASYNCWAIT.
	FSMC_BCR4_EXTMOD_Pos    = 0xe     // Position of EXTMOD field.
	FSMC_BCR4_EXTMOD_Msk    = 0x4000  // Bit mask of EXTMOD field.
	FSMC_BCR4_EXTMOD        = 0x4000  // Bit EXTMOD.
	FSMC_BCR4_WAITEN_Pos    = 0xd     // Position of WAITEN field.
	FSMC_BCR4_WAITEN_Msk    = 0x2000  // Bit mask of WAITEN field.
	FSMC_BCR4_WAITEN        = 0x2000  // Bit WAITEN.
	FSMC_BCR4_WREN_Pos      = 0xc     // Position of WREN field.
	FSMC_BCR4_WREN_Msk      = 0x1000  // Bit mask of WREN field.
	FSMC_BCR4_WREN          = 0x1000  // Bit WREN.
	FSMC_BCR4_WAITCFG_Pos   = 0xb     // Position of WAITCFG field.
	FSMC_BCR4_WAITCFG_Msk   = 0x800   // Bit mask of WAITCFG field.
	FSMC_BCR4_WAITCFG       = 0x800   // Bit WAITCFG.
	FSMC_BCR4_WRAPMOD_Pos   = 0xa     // Position of WRAPMOD field.
	FSMC_BCR4_WRAPMOD_Msk   = 0x400   // Bit mask of WRAPMOD field.
	FSMC_BCR4_WRAPMOD       = 0x400   // Bit WRAPMOD.
	FSMC_BCR4_WAITPOL_Pos   = 0x9     // Position of WAITPOL field.
	FSMC_BCR4_WAITPOL_Msk   = 0x200   // Bit mask of WAITPOL field.
	FSMC_BCR4_WAITPOL       = 0x200   // Bit WAITPOL.
	FSMC_BCR4_BURSTEN_Pos   = 0x8     // Position of BURSTEN field.
	FSMC_BCR4_BURSTEN_Msk   = 0x100   // Bit mask of BURSTEN field.
	FSMC_BCR4_BURSTEN       = 0x100   // Bit BURSTEN.
	FSMC_BCR4_FACCEN_Pos    = 0x6     // Position of FACCEN field.
	FSMC_BCR4_FACCEN_Msk    = 0x40    // Bit mask of FACCEN field.
	FSMC_BCR4_FACCEN        = 0x40    // Bit FACCEN.
	FSMC_BCR4_MWID_Pos      = 0x4     // Position of MWID field.
	FSMC_BCR4_MWID_Msk      = 0x30    // Bit mask of MWID field.
	FSMC_BCR4_MTYP_Pos      = 0x2     // Position of MTYP field.
	FSMC_BCR4_MTYP_Msk      = 0xc     // Bit mask of MTYP field.
	FSMC_BCR4_MUXEN_Pos     = 0x1     // Position of MUXEN field.
	FSMC_BCR4_MUXEN_Msk     = 0x2     // Bit mask of MUXEN field.
	FSMC_BCR4_MUXEN         = 0x2     // Bit MUXEN.
	FSMC_BCR4_MBKEN_Pos     = 0x0     // Position of MBKEN field.
	FSMC_BCR4_MBKEN_Msk     = 0x1     // Bit mask of MBKEN field.
	FSMC_BCR4_MBKEN         = 0x1     // Bit MBKEN.

	// BTR4: SRAM/NOR-Flash chip-select timing register           4
	FSMC_BTR4_ACCMOD_Pos  = 0x1c       // Position of ACCMOD field.
	FSMC_BTR4_ACCMOD_Msk  = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BTR4_DATLAT_Pos  = 0x18       // Position of DATLAT field.
	FSMC_BTR4_DATLAT_Msk  = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BTR4_CLKDIV_Pos  = 0x14       // Position of CLKDIV field.
	FSMC_BTR4_CLKDIV_Msk  = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BTR4_BUSTURN_Pos = 0x10       // Position of BUSTURN field.
	FSMC_BTR4_BUSTURN_Msk = 0xf0000    // Bit mask of BUSTURN field.
	FSMC_BTR4_DATAST_Pos  = 0x8        // Position of DATAST field.
	FSMC_BTR4_DATAST_Msk  = 0xff00     // Bit mask of DATAST field.
	FSMC_BTR4_ADDHLD_Pos  = 0x4        // Position of ADDHLD field.
	FSMC_BTR4_ADDHLD_Msk  = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BTR4_ADDSET_Pos  = 0x0        // Position of ADDSET field.
	FSMC_BTR4_ADDSET_Msk  = 0xf        // Bit mask of ADDSET field.

	// BWTR1: SRAM/NOR-Flash write timing registers           1
	FSMC_BWTR1_ACCMOD_Pos = 0x1c       // Position of ACCMOD field.
	FSMC_BWTR1_ACCMOD_Msk = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BWTR1_DATLAT_Pos = 0x18       // Position of DATLAT field.
	FSMC_BWTR1_DATLAT_Msk = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BWTR1_CLKDIV_Pos = 0x14       // Position of CLKDIV field.
	FSMC_BWTR1_CLKDIV_Msk = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BWTR1_DATAST_Pos = 0x8        // Position of DATAST field.
	FSMC_BWTR1_DATAST_Msk = 0xff00     // Bit mask of DATAST field.
	FSMC_BWTR1_ADDHLD_Pos = 0x4        // Position of ADDHLD field.
	FSMC_BWTR1_ADDHLD_Msk = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BWTR1_ADDSET_Pos = 0x0        // Position of ADDSET field.
	FSMC_BWTR1_ADDSET_Msk = 0xf        // Bit mask of ADDSET field.

	// BWTR2: SRAM/NOR-Flash write timing registers           2
	FSMC_BWTR2_ACCMOD_Pos = 0x1c       // Position of ACCMOD field.
	FSMC_BWTR2_ACCMOD_Msk = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BWTR2_DATLAT_Pos = 0x18       // Position of DATLAT field.
	FSMC_BWTR2_DATLAT_Msk = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BWTR2_CLKDIV_Pos = 0x14       // Position of CLKDIV field.
	FSMC_BWTR2_CLKDIV_Msk = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BWTR2_DATAST_Pos = 0x8        // Position of DATAST field.
	FSMC_BWTR2_DATAST_Msk = 0xff00     // Bit mask of DATAST field.
	FSMC_BWTR2_ADDHLD_Pos = 0x4        // Position of ADDHLD field.
	FSMC_BWTR2_ADDHLD_Msk = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BWTR2_ADDSET_Pos = 0x0        // Position of ADDSET field.
	FSMC_BWTR2_ADDSET_Msk = 0xf        // Bit mask of ADDSET field.

	// BWTR3: SRAM/NOR-Flash write timing registers           3
	FSMC_BWTR3_ACCMOD_Pos = 0x1c       // Position of ACCMOD field.
	FSMC_BWTR3_ACCMOD_Msk = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BWTR3_DATLAT_Pos = 0x18       // Position of DATLAT field.
	FSMC_BWTR3_DATLAT_Msk = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BWTR3_CLKDIV_Pos = 0x14       // Position of CLKDIV field.
	FSMC_BWTR3_CLKDIV_Msk = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BWTR3_DATAST_Pos = 0x8        // Position of DATAST field.
	FSMC_BWTR3_DATAST_Msk = 0xff00     // Bit mask of DATAST field.
	FSMC_BWTR3_ADDHLD_Pos = 0x4        // Position of ADDHLD field.
	FSMC_BWTR3_ADDHLD_Msk = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BWTR3_ADDSET_Pos = 0x0        // Position of ADDSET field.
	FSMC_BWTR3_ADDSET_Msk = 0xf        // Bit mask of ADDSET field.

	// BWTR4: SRAM/NOR-Flash write timing registers           4
	FSMC_BWTR4_ACCMOD_Pos = 0x1c       // Position of ACCMOD field.
	FSMC_BWTR4_ACCMOD_Msk = 0x30000000 // Bit mask of ACCMOD field.
	FSMC_BWTR4_DATLAT_Pos = 0x18       // Position of DATLAT field.
	FSMC_BWTR4_DATLAT_Msk = 0xf000000  // Bit mask of DATLAT field.
	FSMC_BWTR4_CLKDIV_Pos = 0x14       // Position of CLKDIV field.
	FSMC_BWTR4_CLKDIV_Msk = 0xf00000   // Bit mask of CLKDIV field.
	FSMC_BWTR4_DATAST_Pos = 0x8        // Position of DATAST field.
	FSMC_BWTR4_DATAST_Msk = 0xff00     // Bit mask of DATAST field.
	FSMC_BWTR4_ADDHLD_Pos = 0x4        // Position of ADDHLD field.
	FSMC_BWTR4_ADDHLD_Msk = 0xf0       // Bit mask of ADDHLD field.
	FSMC_BWTR4_ADDSET_Pos = 0x0        // Position of ADDSET field.
	FSMC_BWTR4_ADDSET_Msk = 0xf        // Bit mask of ADDSET field.
)

// Bitfields for PWR: Power control
const (
	// CR: Power control register           (PWR_CR)
	PWR_CR_LPDS_Pos = 0x0   // Position of LPDS field.
	PWR_CR_LPDS_Msk = 0x1   // Bit mask of LPDS field.
	PWR_CR_LPDS     = 0x1   // Bit LPDS.
	PWR_CR_PDDS_Pos = 0x1   // Position of PDDS field.
	PWR_CR_PDDS_Msk = 0x2   // Bit mask of PDDS field.
	PWR_CR_PDDS     = 0x2   // Bit PDDS.
	PWR_CR_CWUF_Pos = 0x2   // Position of CWUF field.
	PWR_CR_CWUF_Msk = 0x4   // Bit mask of CWUF field.
	PWR_CR_CWUF     = 0x4   // Bit CWUF.
	PWR_CR_CSBF_Pos = 0x3   // Position of CSBF field.
	PWR_CR_CSBF_Msk = 0x8   // Bit mask of CSBF field.
	PWR_CR_CSBF     = 0x8   // Bit CSBF.
	PWR_CR_PVDE_Pos = 0x4   // Position of PVDE field.
	PWR_CR_PVDE_Msk = 0x10  // Bit mask of PVDE field.
	PWR_CR_PVDE     = 0x10  // Bit PVDE.
	PWR_CR_PLS_Pos  = 0x5   // Position of PLS field.
	PWR_CR_PLS_Msk  = 0xe0  // Bit mask of PLS field.
	PWR_CR_DBP_Pos  = 0x8   // Position of DBP field.
	PWR_CR_DBP_Msk  = 0x100 // Bit mask of DBP field.
	PWR_CR_DBP      = 0x100 // Bit DBP.

	// CSR: Power control register           (PWR_CR)
	PWR_CSR_WUF_Pos  = 0x0   // Position of WUF field.
	PWR_CSR_WUF_Msk  = 0x1   // Bit mask of WUF field.
	PWR_CSR_WUF      = 0x1   // Bit WUF.
	PWR_CSR_SBF_Pos  = 0x1   // Position of SBF field.
	PWR_CSR_SBF_Msk  = 0x2   // Bit mask of SBF field.
	PWR_CSR_SBF      = 0x2   // Bit SBF.
	PWR_CSR_PVDO_Pos = 0x2   // Position of PVDO field.
	PWR_CSR_PVDO_Msk = 0x4   // Bit mask of PVDO field.
	PWR_CSR_PVDO     = 0x4   // Bit PVDO.
	PWR_CSR_EWUP_Pos = 0x8   // Position of EWUP field.
	PWR_CSR_EWUP_Msk = 0x100 // Bit mask of EWUP field.
	PWR_CSR_EWUP     = 0x100 // Bit EWUP.
)

// Bitfields for RCC: Reset and clock control
const (
	// CR: Clock control register
	RCC_CR_HSION_Pos   = 0x0       // Position of HSION field.
	RCC_CR_HSION_Msk   = 0x1       // Bit mask of HSION field.
	RCC_CR_HSION       = 0x1       // Bit HSION.
	RCC_CR_HSIRDY_Pos  = 0x1       // Position of HSIRDY field.
	RCC_CR_HSIRDY_Msk  = 0x2       // Bit mask of HSIRDY field.
	RCC_CR_HSIRDY      = 0x2       // Bit HSIRDY.
	RCC_CR_HSITRIM_Pos = 0x3       // Position of HSITRIM field.
	RCC_CR_HSITRIM_Msk = 0xf8      // Bit mask of HSITRIM field.
	RCC_CR_HSICAL_Pos  = 0x8       // Position of HSICAL field.
	RCC_CR_HSICAL_Msk  = 0xff00    // Bit mask of HSICAL field.
	RCC_CR_HSEON_Pos   = 0x10      // Position of HSEON field.
	RCC_CR_HSEON_Msk   = 0x10000   // Bit mask of HSEON field.
	RCC_CR_HSEON       = 0x10000   // Bit HSEON.
	RCC_CR_HSERDY_Pos  = 0x11      // Position of HSERDY field.
	RCC_CR_HSERDY_Msk  = 0x20000   // Bit mask of HSERDY field.
	RCC_CR_HSERDY      = 0x20000   // Bit HSERDY.
	RCC_CR_HSEBYP_Pos  = 0x12      // Position of HSEBYP field.
	RCC_CR_HSEBYP_Msk  = 0x40000   // Bit mask of HSEBYP field.
	RCC_CR_HSEBYP      = 0x40000   // Bit HSEBYP.
	RCC_CR_CSSON_Pos   = 0x13      // Position of CSSON field.
	RCC_CR_CSSON_Msk   = 0x80000   // Bit mask of CSSON field.
	RCC_CR_CSSON       = 0x80000   // Bit CSSON.
	RCC_CR_PLLON_Pos   = 0x18      // Position of PLLON field.
	RCC_CR_PLLON_Msk   = 0x1000000 // Bit mask of PLLON field.
	RCC_CR_PLLON       = 0x1000000 // Bit PLLON.
	RCC_CR_PLLRDY_Pos  = 0x19      // Position of PLLRDY field.
	RCC_CR_PLLRDY_Msk  = 0x2000000 // Bit mask of PLLRDY field.
	RCC_CR_PLLRDY      = 0x2000000 // Bit PLLRDY.

	// CFGR: Clock configuration register           (RCC_CFGR)
	RCC_CFGR_SW_Pos       = 0x0       // Position of SW field.
	RCC_CFGR_SW_Msk       = 0x3       // Bit mask of SW field.
	RCC_CFGR_SWS_Pos      = 0x2       // Position of SWS field.
	RCC_CFGR_SWS_Msk      = 0xc       // Bit mask of SWS field.
	RCC_CFGR_HPRE_Pos     = 0x4       // Position of HPRE field.
	RCC_CFGR_HPRE_Msk     = 0xf0      // Bit mask of HPRE field.
	RCC_CFGR_PPRE1_Pos    = 0x8       // Position of PPRE1 field.
	RCC_CFGR_PPRE1_Msk    = 0x700     // Bit mask of PPRE1 field.
	RCC_CFGR_PPRE2_Pos    = 0xb       // Position of PPRE2 field.
	RCC_CFGR_PPRE2_Msk    = 0x3800    // Bit mask of PPRE2 field.
	RCC_CFGR_ADCPRE_Pos   = 0xe       // Position of ADCPRE field.
	RCC_CFGR_ADCPRE_Msk   = 0xc000    // Bit mask of ADCPRE field.
	RCC_CFGR_PLLSRC_Pos   = 0x10      // Position of PLLSRC field.
	RCC_CFGR_PLLSRC_Msk   = 0x10000   // Bit mask of PLLSRC field.
	RCC_CFGR_PLLSRC       = 0x10000   // Bit PLLSRC.
	RCC_CFGR_PLLXTPRE_Pos = 0x11      // Position of PLLXTPRE field.
	RCC_CFGR_PLLXTPRE_Msk = 0x20000   // Bit mask of PLLXTPRE field.
	RCC_CFGR_PLLXTPRE     = 0x20000   // Bit PLLXTPRE.
	RCC_CFGR_PLLMUL_Pos   = 0x12      // Position of PLLMUL field.
	RCC_CFGR_PLLMUL_Msk   = 0x3c0000  // Bit mask of PLLMUL field.
	RCC_CFGR_MCO_Pos      = 0x18      // Position of MCO field.
	RCC_CFGR_MCO_Msk      = 0x7000000 // Bit mask of MCO field.

	// CIR: Clock interrupt register           (RCC_CIR)
	RCC_CIR_LSIRDYF_Pos  = 0x0      // Position of LSIRDYF field.
	RCC_CIR_LSIRDYF_Msk  = 0x1      // Bit mask of LSIRDYF field.
	RCC_CIR_LSIRDYF      = 0x1      // Bit LSIRDYF.
	RCC_CIR_LSERDYF_Pos  = 0x1      // Position of LSERDYF field.
	RCC_CIR_LSERDYF_Msk  = 0x2      // Bit mask of LSERDYF field.
	RCC_CIR_LSERDYF      = 0x2      // Bit LSERDYF.
	RCC_CIR_HSIRDYF_Pos  = 0x2      // Position of HSIRDYF field.
	RCC_CIR_HSIRDYF_Msk  = 0x4      // Bit mask of HSIRDYF field.
	RCC_CIR_HSIRDYF      = 0x4      // Bit HSIRDYF.
	RCC_CIR_HSERDYF_Pos  = 0x3      // Position of HSERDYF field.
	RCC_CIR_HSERDYF_Msk  = 0x8      // Bit mask of HSERDYF field.
	RCC_CIR_HSERDYF      = 0x8      // Bit HSERDYF.
	RCC_CIR_PLLRDYF_Pos  = 0x4      // Position of PLLRDYF field.
	RCC_CIR_PLLRDYF_Msk  = 0x10     // Bit mask of PLLRDYF field.
	RCC_CIR_PLLRDYF      = 0x10     // Bit PLLRDYF.
	RCC_CIR_CSSF_Pos     = 0x7      // Position of CSSF field.
	RCC_CIR_CSSF_Msk     = 0x80     // Bit mask of CSSF field.
	RCC_CIR_CSSF         = 0x80     // Bit CSSF.
	RCC_CIR_LSIRDYIE_Pos = 0x8      // Position of LSIRDYIE field.
	RCC_CIR_LSIRDYIE_Msk = 0x100    // Bit mask of LSIRDYIE field.
	RCC_CIR_LSIRDYIE     = 0x100    // Bit LSIRDYIE.
	RCC_CIR_LSERDYIE_Pos = 0x9      // Position of LSERDYIE field.
	RCC_CIR_LSERDYIE_Msk = 0x200    // Bit mask of LSERDYIE field.
	RCC_CIR_LSERDYIE     = 0x200    // Bit LSERDYIE.
	RCC_CIR_HSIRDYIE_Pos = 0xa      // Position of HSIRDYIE field.
	RCC_CIR_HSIRDYIE_Msk = 0x400    // Bit mask of HSIRDYIE field.
	RCC_CIR_HSIRDYIE     = 0x400    // Bit HSIRDYIE.
	RCC_CIR_HSERDYIE_Pos = 0xb      // Position of HSERDYIE field.
	RCC_CIR_HSERDYIE_Msk = 0x800    // Bit mask of HSERDYIE field.
	RCC_CIR_HSERDYIE     = 0x800    // Bit HSERDYIE.
	RCC_CIR_PLLRDYIE_Pos = 0xc      // Position of PLLRDYIE field.
	RCC_CIR_PLLRDYIE_Msk = 0x1000   // Bit mask of PLLRDYIE field.
	RCC_CIR_PLLRDYIE     = 0x1000   // Bit PLLRDYIE.
	RCC_CIR_LSIRDYC_Pos  = 0x10     // Position of LSIRDYC field.
	RCC_CIR_LSIRDYC_Msk  = 0x10000  // Bit mask of LSIRDYC field.
	RCC_CIR_LSIRDYC      = 0x10000  // Bit LSIRDYC.
	RCC_CIR_LSERDYC_Pos  = 0x11     // Position of LSERDYC field.
	RCC_CIR_LSERDYC_Msk  = 0x20000  // Bit mask of LSERDYC field.
	RCC_CIR_LSERDYC      = 0x20000  // Bit LSERDYC.
	RCC_CIR_HSIRDYC_Pos  = 0x12     // Position of HSIRDYC field.
	RCC_CIR_HSIRDYC_Msk  = 0x40000  // Bit mask of HSIRDYC field.
	RCC_CIR_HSIRDYC      = 0x40000  // Bit HSIRDYC.
	RCC_CIR_HSERDYC_Pos  = 0x13     // Position of HSERDYC field.
	RCC_CIR_HSERDYC_Msk  = 0x80000  // Bit mask of HSERDYC field.
	RCC_CIR_HSERDYC      = 0x80000  // Bit HSERDYC.
	RCC_CIR_PLLRDYC_Pos  = 0x14     // Position of PLLRDYC field.
	RCC_CIR_PLLRDYC_Msk  = 0x100000 // Bit mask of PLLRDYC field.
	RCC_CIR_PLLRDYC      = 0x100000 // Bit PLLRDYC.
	RCC_CIR_CSSC_Pos     = 0x17     // Position of CSSC field.
	RCC_CIR_CSSC_Msk     = 0x800000 // Bit mask of CSSC field.
	RCC_CIR_CSSC         = 0x800000 // Bit CSSC.

	// APB2RSTR: APB2 peripheral reset register           (RCC_APB2RSTR)
	RCC_APB2RSTR_AFIORST_Pos   = 0x0     // Position of AFIORST field.
	RCC_APB2RSTR_AFIORST_Msk   = 0x1     // Bit mask of AFIORST field.
	RCC_APB2RSTR_AFIORST       = 0x1     // Bit AFIORST.
	RCC_APB2RSTR_IOPARST_Pos   = 0x2     // Position of IOPARST field.
	RCC_APB2RSTR_IOPARST_Msk   = 0x4     // Bit mask of IOPARST field.
	RCC_APB2RSTR_IOPARST       = 0x4     // Bit IOPARST.
	RCC_APB2RSTR_IOPBRST_Pos   = 0x3     // Position of IOPBRST field.
	RCC_APB2RSTR_IOPBRST_Msk   = 0x8     // Bit mask of IOPBRST field.
	RCC_APB2RSTR_IOPBRST       = 0x8     // Bit IOPBRST.
	RCC_APB2RSTR_IOPCRST_Pos   = 0x4     // Position of IOPCRST field.
	RCC_APB2RSTR_IOPCRST_Msk   = 0x10    // Bit mask of IOPCRST field.
	RCC_APB2RSTR_IOPCRST       = 0x10    // Bit IOPCRST.
	RCC_APB2RSTR_IOPDRST_Pos   = 0x5     // Position of IOPDRST field.
	RCC_APB2RSTR_IOPDRST_Msk   = 0x20    // Bit mask of IOPDRST field.
	RCC_APB2RSTR_IOPDRST       = 0x20    // Bit IOPDRST.
	RCC_APB2RSTR_IOPERST_Pos   = 0x6     // Position of IOPERST field.
	RCC_APB2RSTR_IOPERST_Msk   = 0x40    // Bit mask of IOPERST field.
	RCC_APB2RSTR_IOPERST       = 0x40    // Bit IOPERST.
	RCC_APB2RSTR_IOPFRST_Pos   = 0x7     // Position of IOPFRST field.
	RCC_APB2RSTR_IOPFRST_Msk   = 0x80    // Bit mask of IOPFRST field.
	RCC_APB2RSTR_IOPFRST       = 0x80    // Bit IOPFRST.
	RCC_APB2RSTR_IOPGRST_Pos   = 0x8     // Position of IOPGRST field.
	RCC_APB2RSTR_IOPGRST_Msk   = 0x100   // Bit mask of IOPGRST field.
	RCC_APB2RSTR_IOPGRST       = 0x100   // Bit IOPGRST.
	RCC_APB2RSTR_ADC1RST_Pos   = 0x9     // Position of ADC1RST field.
	RCC_APB2RSTR_ADC1RST_Msk   = 0x200   // Bit mask of ADC1RST field.
	RCC_APB2RSTR_ADC1RST       = 0x200   // Bit ADC1RST.
	RCC_APB2RSTR_TIM1RST_Pos   = 0xb     // Position of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Msk   = 0x800   // Bit mask of TIM1RST field.
	RCC_APB2RSTR_TIM1RST       = 0x800   // Bit TIM1RST.
	RCC_APB2RSTR_SPI1RST_Pos   = 0xc     // Position of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Msk   = 0x1000  // Bit mask of SPI1RST field.
	RCC_APB2RSTR_SPI1RST       = 0x1000  // Bit SPI1RST.
	RCC_APB2RSTR_USART1RST_Pos = 0xe     // Position of USART1RST field.
	RCC_APB2RSTR_USART1RST_Msk = 0x4000  // Bit mask of USART1RST field.
	RCC_APB2RSTR_USART1RST     = 0x4000  // Bit USART1RST.
	RCC_APB2RSTR_TIM15RST_Pos  = 0x10    // Position of TIM15RST field.
	RCC_APB2RSTR_TIM15RST_Msk  = 0x10000 // Bit mask of TIM15RST field.
	RCC_APB2RSTR_TIM15RST      = 0x10000 // Bit TIM15RST.
	RCC_APB2RSTR_TIM16RST_Pos  = 0x11    // Position of TIM16RST field.
	RCC_APB2RSTR_TIM16RST_Msk  = 0x20000 // Bit mask of TIM16RST field.
	RCC_APB2RSTR_TIM16RST      = 0x20000 // Bit TIM16RST.
	RCC_APB2RSTR_TIM17RST_Pos  = 0x12    // Position of TIM17RST field.
	RCC_APB2RSTR_TIM17RST_Msk  = 0x40000 // Bit mask of TIM17RST field.
	RCC_APB2RSTR_TIM17RST      = 0x40000 // Bit TIM17RST.

	// APB1RSTR: APB1 peripheral reset register           (RCC_APB1RSTR)
	RCC_APB1RSTR_TIM2RST_Pos   = 0x0        // Position of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Msk   = 0x1        // Bit mask of TIM2RST field.
	RCC_APB1RSTR_TIM2RST       = 0x1        // Bit TIM2RST.
	RCC_APB1RSTR_TIM3RST_Pos   = 0x1        // Position of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Msk   = 0x2        // Bit mask of TIM3RST field.
	RCC_APB1RSTR_TIM3RST       = 0x2        // Bit TIM3RST.
	RCC_APB1RSTR_TIM4RST_Pos   = 0x2        // Position of TIM4RST field.
	RCC_APB1RSTR_TIM4RST_Msk   = 0x4        // Bit mask of TIM4RST field.
	RCC_APB1RSTR_TIM4RST       = 0x4        // Bit TIM4RST.
	RCC_APB1RSTR_TIM5RST_Pos   = 0x3        // Position of TIM5RST field.
	RCC_APB1RSTR_TIM5RST_Msk   = 0x8        // Bit mask of TIM5RST field.
	RCC_APB1RSTR_TIM5RST       = 0x8        // Bit TIM5RST.
	RCC_APB1RSTR_TIM6RST_Pos   = 0x4        // Position of TIM6RST field.
	RCC_APB1RSTR_TIM6RST_Msk   = 0x10       // Bit mask of TIM6RST field.
	RCC_APB1RSTR_TIM6RST       = 0x10       // Bit TIM6RST.
	RCC_APB1RSTR_TIM7RST_Pos   = 0x5        // Position of TIM7RST field.
	RCC_APB1RSTR_TIM7RST_Msk   = 0x20       // Bit mask of TIM7RST field.
	RCC_APB1RSTR_TIM7RST       = 0x20       // Bit TIM7RST.
	RCC_APB1RSTR_TIM12RST_Pos  = 0x6        // Position of TIM12RST field.
	RCC_APB1RSTR_TIM12RST_Msk  = 0x40       // Bit mask of TIM12RST field.
	RCC_APB1RSTR_TIM12RST      = 0x40       // Bit TIM12RST.
	RCC_APB1RSTR_TIM13RST_Pos  = 0x7        // Position of TIM13RST field.
	RCC_APB1RSTR_TIM13RST_Msk  = 0x80       // Bit mask of TIM13RST field.
	RCC_APB1RSTR_TIM13RST      = 0x80       // Bit TIM13RST.
	RCC_APB1RSTR_TIM14RST_Pos  = 0x8        // Position of TIM14RST field.
	RCC_APB1RSTR_TIM14RST_Msk  = 0x100      // Bit mask of TIM14RST field.
	RCC_APB1RSTR_TIM14RST      = 0x100      // Bit TIM14RST.
	RCC_APB1RSTR_WWDGRST_Pos   = 0xb        // Position of WWDGRST field.
	RCC_APB1RSTR_WWDGRST_Msk   = 0x800      // Bit mask of WWDGRST field.
	RCC_APB1RSTR_WWDGRST       = 0x800      // Bit WWDGRST.
	RCC_APB1RSTR_SPI2RST_Pos   = 0xe        // Position of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Msk   = 0x4000     // Bit mask of SPI2RST field.
	RCC_APB1RSTR_SPI2RST       = 0x4000     // Bit SPI2RST.
	RCC_APB1RSTR_SPI3RST_Pos   = 0xf        // Position of SPI3RST field.
	RCC_APB1RSTR_SPI3RST_Msk   = 0x8000     // Bit mask of SPI3RST field.
	RCC_APB1RSTR_SPI3RST       = 0x8000     // Bit SPI3RST.
	RCC_APB1RSTR_USART2RST_Pos = 0x11       // Position of USART2RST field.
	RCC_APB1RSTR_USART2RST_Msk = 0x20000    // Bit mask of USART2RST field.
	RCC_APB1RSTR_USART2RST     = 0x20000    // Bit USART2RST.
	RCC_APB1RSTR_USART3RST_Pos = 0x12       // Position of USART3RST field.
	RCC_APB1RSTR_USART3RST_Msk = 0x40000    // Bit mask of USART3RST field.
	RCC_APB1RSTR_USART3RST     = 0x40000    // Bit USART3RST.
	RCC_APB1RSTR_USART4RST_Pos = 0x13       // Position of USART4RST field.
	RCC_APB1RSTR_USART4RST_Msk = 0x80000    // Bit mask of USART4RST field.
	RCC_APB1RSTR_USART4RST     = 0x80000    // Bit USART4RST.
	RCC_APB1RSTR_USART5RST_Pos = 0x14       // Position of USART5RST field.
	RCC_APB1RSTR_USART5RST_Msk = 0x100000   // Bit mask of USART5RST field.
	RCC_APB1RSTR_USART5RST     = 0x100000   // Bit USART5RST.
	RCC_APB1RSTR_I2C1RST_Pos   = 0x15       // Position of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Msk   = 0x200000   // Bit mask of I2C1RST field.
	RCC_APB1RSTR_I2C1RST       = 0x200000   // Bit I2C1RST.
	RCC_APB1RSTR_I2C2RST_Pos   = 0x16       // Position of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Msk   = 0x400000   // Bit mask of I2C2RST field.
	RCC_APB1RSTR_I2C2RST       = 0x400000   // Bit I2C2RST.
	RCC_APB1RSTR_BKPRST_Pos    = 0x1b       // Position of BKPRST field.
	RCC_APB1RSTR_BKPRST_Msk    = 0x8000000  // Bit mask of BKPRST field.
	RCC_APB1RSTR_BKPRST        = 0x8000000  // Bit BKPRST.
	RCC_APB1RSTR_PWRRST_Pos    = 0x1c       // Position of PWRRST field.
	RCC_APB1RSTR_PWRRST_Msk    = 0x10000000 // Bit mask of PWRRST field.
	RCC_APB1RSTR_PWRRST        = 0x10000000 // Bit PWRRST.
	RCC_APB1RSTR_DACRST_Pos    = 0x1d       // Position of DACRST field.
	RCC_APB1RSTR_DACRST_Msk    = 0x20000000 // Bit mask of DACRST field.
	RCC_APB1RSTR_DACRST        = 0x20000000 // Bit DACRST.
	RCC_APB1RSTR_CECRST_Pos    = 0x1e       // Position of CECRST field.
	RCC_APB1RSTR_CECRST_Msk    = 0x40000000 // Bit mask of CECRST field.
	RCC_APB1RSTR_CECRST        = 0x40000000 // Bit CECRST.

	// AHBENR: AHB Peripheral Clock enable register           (RCC_AHBENR)
	RCC_AHBENR_DMA1EN_Pos  = 0x0   // Position of DMA1EN field.
	RCC_AHBENR_DMA1EN_Msk  = 0x1   // Bit mask of DMA1EN field.
	RCC_AHBENR_DMA1EN      = 0x1   // Bit DMA1EN.
	RCC_AHBENR_DMA2EN_Pos  = 0x1   // Position of DMA2EN field.
	RCC_AHBENR_DMA2EN_Msk  = 0x2   // Bit mask of DMA2EN field.
	RCC_AHBENR_DMA2EN      = 0x2   // Bit DMA2EN.
	RCC_AHBENR_SRAMEN_Pos  = 0x2   // Position of SRAMEN field.
	RCC_AHBENR_SRAMEN_Msk  = 0x4   // Bit mask of SRAMEN field.
	RCC_AHBENR_SRAMEN      = 0x4   // Bit SRAMEN.
	RCC_AHBENR_FLITFEN_Pos = 0x4   // Position of FLITFEN field.
	RCC_AHBENR_FLITFEN_Msk = 0x10  // Bit mask of FLITFEN field.
	RCC_AHBENR_FLITFEN     = 0x10  // Bit FLITFEN.
	RCC_AHBENR_CRCEN_Pos   = 0x6   // Position of CRCEN field.
	RCC_AHBENR_CRCEN_Msk   = 0x40  // Bit mask of CRCEN field.
	RCC_AHBENR_CRCEN       = 0x40  // Bit CRCEN.
	RCC_AHBENR_FSMCEN_Pos  = 0x8   // Position of FSMCEN field.
	RCC_AHBENR_FSMCEN_Msk  = 0x100 // Bit mask of FSMCEN field.
	RCC_AHBENR_FSMCEN      = 0x100 // Bit FSMCEN.

	// APB2ENR: APB2 peripheral clock enable register           (RCC_APB2ENR)
	RCC_APB2ENR_AFIOEN_Pos   = 0x0     // Position of AFIOEN field.
	RCC_APB2ENR_AFIOEN_Msk   = 0x1     // Bit mask of AFIOEN field.
	RCC_APB2ENR_AFIOEN       = 0x1     // Bit AFIOEN.
	RCC_APB2ENR_IOPAEN_Pos   = 0x2     // Position of IOPAEN field.
	RCC_APB2ENR_IOPAEN_Msk   = 0x4     // Bit mask of IOPAEN field.
	RCC_APB2ENR_IOPAEN       = 0x4     // Bit IOPAEN.
	RCC_APB2ENR_IOPBEN_Pos   = 0x3     // Position of IOPBEN field.
	RCC_APB2ENR_IOPBEN_Msk   = 0x8     // Bit mask of IOPBEN field.
	RCC_APB2ENR_IOPBEN       = 0x8     // Bit IOPBEN.
	RCC_APB2ENR_IOPCEN_Pos   = 0x4     // Position of IOPCEN field.
	RCC_APB2ENR_IOPCEN_Msk   = 0x10    // Bit mask of IOPCEN field.
	RCC_APB2ENR_IOPCEN       = 0x10    // Bit IOPCEN.
	RCC_APB2ENR_IOPDEN_Pos   = 0x5     // Position of IOPDEN field.
	RCC_APB2ENR_IOPDEN_Msk   = 0x20    // Bit mask of IOPDEN field.
	RCC_APB2ENR_IOPDEN       = 0x20    // Bit IOPDEN.
	RCC_APB2ENR_IOPEEN_Pos   = 0x6     // Position of IOPEEN field.
	RCC_APB2ENR_IOPEEN_Msk   = 0x40    // Bit mask of IOPEEN field.
	RCC_APB2ENR_IOPEEN       = 0x40    // Bit IOPEEN.
	RCC_APB2ENR_IOPFEN_Pos   = 0x7     // Position of IOPFEN field.
	RCC_APB2ENR_IOPFEN_Msk   = 0x80    // Bit mask of IOPFEN field.
	RCC_APB2ENR_IOPFEN       = 0x80    // Bit IOPFEN.
	RCC_APB2ENR_IOPGEN_Pos   = 0x8     // Position of IOPGEN field.
	RCC_APB2ENR_IOPGEN_Msk   = 0x100   // Bit mask of IOPGEN field.
	RCC_APB2ENR_IOPGEN       = 0x100   // Bit IOPGEN.
	RCC_APB2ENR_ADC1EN_Pos   = 0x9     // Position of ADC1EN field.
	RCC_APB2ENR_ADC1EN_Msk   = 0x200   // Bit mask of ADC1EN field.
	RCC_APB2ENR_ADC1EN       = 0x200   // Bit ADC1EN.
	RCC_APB2ENR_TIM1EN_Pos   = 0xb     // Position of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Msk   = 0x800   // Bit mask of TIM1EN field.
	RCC_APB2ENR_TIM1EN       = 0x800   // Bit TIM1EN.
	RCC_APB2ENR_SPI1EN_Pos   = 0xc     // Position of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Msk   = 0x1000  // Bit mask of SPI1EN field.
	RCC_APB2ENR_SPI1EN       = 0x1000  // Bit SPI1EN.
	RCC_APB2ENR_USART1EN_Pos = 0xe     // Position of USART1EN field.
	RCC_APB2ENR_USART1EN_Msk = 0x4000  // Bit mask of USART1EN field.
	RCC_APB2ENR_USART1EN     = 0x4000  // Bit USART1EN.
	RCC_APB2ENR_TIM15EN_Pos  = 0x10    // Position of TIM15EN field.
	RCC_APB2ENR_TIM15EN_Msk  = 0x10000 // Bit mask of TIM15EN field.
	RCC_APB2ENR_TIM15EN      = 0x10000 // Bit TIM15EN.
	RCC_APB2ENR_TIM16EN_Pos  = 0x11    // Position of TIM16EN field.
	RCC_APB2ENR_TIM16EN_Msk  = 0x20000 // Bit mask of TIM16EN field.
	RCC_APB2ENR_TIM16EN      = 0x20000 // Bit TIM16EN.
	RCC_APB2ENR_TIM17EN_Pos  = 0x12    // Position of TIM17EN field.
	RCC_APB2ENR_TIM17EN_Msk  = 0x40000 // Bit mask of TIM17EN field.
	RCC_APB2ENR_TIM17EN      = 0x40000 // Bit TIM17EN.

	// APB1ENR: APB1 peripheral clock enable register           (RCC_APB1ENR)
	RCC_APB1ENR_TIM2EN_Pos   = 0x0        // Position of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Msk   = 0x1        // Bit mask of TIM2EN field.
	RCC_APB1ENR_TIM2EN       = 0x1        // Bit TIM2EN.
	RCC_APB1ENR_TIM3EN_Pos   = 0x1        // Position of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Msk   = 0x2        // Bit mask of TIM3EN field.
	RCC_APB1ENR_TIM3EN       = 0x2        // Bit TIM3EN.
	RCC_APB1ENR_TIM4EN_Pos   = 0x2        // Position of TIM4EN field.
	RCC_APB1ENR_TIM4EN_Msk   = 0x4        // Bit mask of TIM4EN field.
	RCC_APB1ENR_TIM4EN       = 0x4        // Bit TIM4EN.
	RCC_APB1ENR_TIM5EN_Pos   = 0x3        // Position of TIM5EN field.
	RCC_APB1ENR_TIM5EN_Msk   = 0x8        // Bit mask of TIM5EN field.
	RCC_APB1ENR_TIM5EN       = 0x8        // Bit TIM5EN.
	RCC_APB1ENR_TIM6EN_Pos   = 0x4        // Position of TIM6EN field.
	RCC_APB1ENR_TIM6EN_Msk   = 0x10       // Bit mask of TIM6EN field.
	RCC_APB1ENR_TIM6EN       = 0x10       // Bit TIM6EN.
	RCC_APB1ENR_TIM7EN_Pos   = 0x5        // Position of TIM7EN field.
	RCC_APB1ENR_TIM7EN_Msk   = 0x20       // Bit mask of TIM7EN field.
	RCC_APB1ENR_TIM7EN       = 0x20       // Bit TIM7EN.
	RCC_APB1ENR_TIM12EN_Pos  = 0x6        // Position of TIM12EN field.
	RCC_APB1ENR_TIM12EN_Msk  = 0x40       // Bit mask of TIM12EN field.
	RCC_APB1ENR_TIM12EN      = 0x40       // Bit TIM12EN.
	RCC_APB1ENR_TIM13EN_Pos  = 0x7        // Position of TIM13EN field.
	RCC_APB1ENR_TIM13EN_Msk  = 0x80       // Bit mask of TIM13EN field.
	RCC_APB1ENR_TIM13EN      = 0x80       // Bit TIM13EN.
	RCC_APB1ENR_TIM14EN_Pos  = 0x8        // Position of TIM14EN field.
	RCC_APB1ENR_TIM14EN_Msk  = 0x100      // Bit mask of TIM14EN field.
	RCC_APB1ENR_TIM14EN      = 0x100      // Bit TIM14EN.
	RCC_APB1ENR_WWDGEN_Pos   = 0xb        // Position of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Msk   = 0x800      // Bit mask of WWDGEN field.
	RCC_APB1ENR_WWDGEN       = 0x800      // Bit WWDGEN.
	RCC_APB1ENR_SPI2EN_Pos   = 0xe        // Position of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Msk   = 0x4000     // Bit mask of SPI2EN field.
	RCC_APB1ENR_SPI2EN       = 0x4000     // Bit SPI2EN.
	RCC_APB1ENR_SPI3EN_Pos   = 0xf        // Position of SPI3EN field.
	RCC_APB1ENR_SPI3EN_Msk   = 0x8000     // Bit mask of SPI3EN field.
	RCC_APB1ENR_SPI3EN       = 0x8000     // Bit SPI3EN.
	RCC_APB1ENR_USART2EN_Pos = 0x11       // Position of USART2EN field.
	RCC_APB1ENR_USART2EN_Msk = 0x20000    // Bit mask of USART2EN field.
	RCC_APB1ENR_USART2EN     = 0x20000    // Bit USART2EN.
	RCC_APB1ENR_USART3EN_Pos = 0x12       // Position of USART3EN field.
	RCC_APB1ENR_USART3EN_Msk = 0x40000    // Bit mask of USART3EN field.
	RCC_APB1ENR_USART3EN     = 0x40000    // Bit USART3EN.
	RCC_APB1ENR_UART4EN_Pos  = 0x13       // Position of UART4EN field.
	RCC_APB1ENR_UART4EN_Msk  = 0x80000    // Bit mask of UART4EN field.
	RCC_APB1ENR_UART4EN      = 0x80000    // Bit UART4EN.
	RCC_APB1ENR_UART5EN_Pos  = 0x14       // Position of UART5EN field.
	RCC_APB1ENR_UART5EN_Msk  = 0x100000   // Bit mask of UART5EN field.
	RCC_APB1ENR_UART5EN      = 0x100000   // Bit UART5EN.
	RCC_APB1ENR_I2C1EN_Pos   = 0x15       // Position of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Msk   = 0x200000   // Bit mask of I2C1EN field.
	RCC_APB1ENR_I2C1EN       = 0x200000   // Bit I2C1EN.
	RCC_APB1ENR_I2C2EN_Pos   = 0x16       // Position of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Msk   = 0x400000   // Bit mask of I2C2EN field.
	RCC_APB1ENR_I2C2EN       = 0x400000   // Bit I2C2EN.
	RCC_APB1ENR_BKPEN_Pos    = 0x1b       // Position of BKPEN field.
	RCC_APB1ENR_BKPEN_Msk    = 0x8000000  // Bit mask of BKPEN field.
	RCC_APB1ENR_BKPEN        = 0x8000000  // Bit BKPEN.
	RCC_APB1ENR_PWREN_Pos    = 0x1c       // Position of PWREN field.
	RCC_APB1ENR_PWREN_Msk    = 0x10000000 // Bit mask of PWREN field.
	RCC_APB1ENR_PWREN        = 0x10000000 // Bit PWREN.
	RCC_APB1ENR_DACEN_Pos    = 0x1d       // Position of DACEN field.
	RCC_APB1ENR_DACEN_Msk    = 0x20000000 // Bit mask of DACEN field.
	RCC_APB1ENR_DACEN        = 0x20000000 // Bit DACEN.
	RCC_APB1ENR_CECEN_Pos    = 0x1e       // Position of CECEN field.
	RCC_APB1ENR_CECEN_Msk    = 0x40000000 // Bit mask of CECEN field.
	RCC_APB1ENR_CECEN        = 0x40000000 // Bit CECEN.

	// BDCR: Backup domain control register           (RCC_BDCR)
	RCC_BDCR_LSEON_Pos  = 0x0     // Position of LSEON field.
	RCC_BDCR_LSEON_Msk  = 0x1     // Bit mask of LSEON field.
	RCC_BDCR_LSEON      = 0x1     // Bit LSEON.
	RCC_BDCR_LSERDY_Pos = 0x1     // Position of LSERDY field.
	RCC_BDCR_LSERDY_Msk = 0x2     // Bit mask of LSERDY field.
	RCC_BDCR_LSERDY     = 0x2     // Bit LSERDY.
	RCC_BDCR_LSEBYP_Pos = 0x2     // Position of LSEBYP field.
	RCC_BDCR_LSEBYP_Msk = 0x4     // Bit mask of LSEBYP field.
	RCC_BDCR_LSEBYP     = 0x4     // Bit LSEBYP.
	RCC_BDCR_RTCSEL_Pos = 0x8     // Position of RTCSEL field.
	RCC_BDCR_RTCSEL_Msk = 0x300   // Bit mask of RTCSEL field.
	RCC_BDCR_RTCEN_Pos  = 0xf     // Position of RTCEN field.
	RCC_BDCR_RTCEN_Msk  = 0x8000  // Bit mask of RTCEN field.
	RCC_BDCR_RTCEN      = 0x8000  // Bit RTCEN.
	RCC_BDCR_BDRST_Pos  = 0x10    // Position of BDRST field.
	RCC_BDCR_BDRST_Msk  = 0x10000 // Bit mask of BDRST field.
	RCC_BDCR_BDRST      = 0x10000 // Bit BDRST.

	// CSR: Control/status register           (RCC_CSR)
	RCC_CSR_LSION_Pos    = 0x0        // Position of LSION field.
	RCC_CSR_LSION_Msk    = 0x1        // Bit mask of LSION field.
	RCC_CSR_LSION        = 0x1        // Bit LSION.
	RCC_CSR_LSIRDY_Pos   = 0x1        // Position of LSIRDY field.
	RCC_CSR_LSIRDY_Msk   = 0x2        // Bit mask of LSIRDY field.
	RCC_CSR_LSIRDY       = 0x2        // Bit LSIRDY.
	RCC_CSR_RMVF_Pos     = 0x18       // Position of RMVF field.
	RCC_CSR_RMVF_Msk     = 0x1000000  // Bit mask of RMVF field.
	RCC_CSR_RMVF         = 0x1000000  // Bit RMVF.
	RCC_CSR_PINRSTF_Pos  = 0x1a       // Position of PINRSTF field.
	RCC_CSR_PINRSTF_Msk  = 0x4000000  // Bit mask of PINRSTF field.
	RCC_CSR_PINRSTF      = 0x4000000  // Bit PINRSTF.
	RCC_CSR_PORRSTF_Pos  = 0x1b       // Position of PORRSTF field.
	RCC_CSR_PORRSTF_Msk  = 0x8000000  // Bit mask of PORRSTF field.
	RCC_CSR_PORRSTF      = 0x8000000  // Bit PORRSTF.
	RCC_CSR_SFTRSTF_Pos  = 0x1c       // Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk  = 0x10000000 // Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF      = 0x10000000 // Bit SFTRSTF.
	RCC_CSR_IWDGRSTF_Pos = 0x1d       // Position of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Msk = 0x20000000 // Bit mask of IWDGRSTF field.
	RCC_CSR_IWDGRSTF     = 0x20000000 // Bit IWDGRSTF.
	RCC_CSR_WWDGRSTF_Pos = 0x1e       // Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk = 0x40000000 // Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF     = 0x40000000 // Bit WWDGRSTF.
	RCC_CSR_LPWRRSTF_Pos = 0x1f       // Position of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Msk = 0x80000000 // Bit mask of LPWRRSTF field.
	RCC_CSR_LPWRRSTF     = 0x80000000 // Bit LPWRRSTF.

	// CFGR2: Clock configuration register 2
	RCC_CFGR2_PREDIV1_Pos = 0x0 // Position of PREDIV1 field.
	RCC_CFGR2_PREDIV1_Msk = 0xf // Bit mask of PREDIV1 field.
)

// Bitfields for GPIOA: General purpose I/O
const (
	// CRL: Port configuration register low           (GPIOn_CRL)
	GPIO_CRL_MODE0_Pos = 0x0        // Position of MODE0 field.
	GPIO_CRL_MODE0_Msk = 0x3        // Bit mask of MODE0 field.
	GPIO_CRL_CNF0_Pos  = 0x2        // Position of CNF0 field.
	GPIO_CRL_CNF0_Msk  = 0xc        // Bit mask of CNF0 field.
	GPIO_CRL_MODE1_Pos = 0x4        // Position of MODE1 field.
	GPIO_CRL_MODE1_Msk = 0x30       // Bit mask of MODE1 field.
	GPIO_CRL_CNF1_Pos  = 0x6        // Position of CNF1 field.
	GPIO_CRL_CNF1_Msk  = 0xc0       // Bit mask of CNF1 field.
	GPIO_CRL_MODE2_Pos = 0x8        // Position of MODE2 field.
	GPIO_CRL_MODE2_Msk = 0x300      // Bit mask of MODE2 field.
	GPIO_CRL_CNF2_Pos  = 0xa        // Position of CNF2 field.
	GPIO_CRL_CNF2_Msk  = 0xc00      // Bit mask of CNF2 field.
	GPIO_CRL_MODE3_Pos = 0xc        // Position of MODE3 field.
	GPIO_CRL_MODE3_Msk = 0x3000     // Bit mask of MODE3 field.
	GPIO_CRL_CNF3_Pos  = 0xe        // Position of CNF3 field.
	GPIO_CRL_CNF3_Msk  = 0xc000     // Bit mask of CNF3 field.
	GPIO_CRL_MODE4_Pos = 0x10       // Position of MODE4 field.
	GPIO_CRL_MODE4_Msk = 0x30000    // Bit mask of MODE4 field.
	GPIO_CRL_CNF4_Pos  = 0x12       // Position of CNF4 field.
	GPIO_CRL_CNF4_Msk  = 0xc0000    // Bit mask of CNF4 field.
	GPIO_CRL_MODE5_Pos = 0x14       // Position of MODE5 field.
	GPIO_CRL_MODE5_Msk = 0x300000   // Bit mask of MODE5 field.
	GPIO_CRL_CNF5_Pos  = 0x16       // Position of CNF5 field.
	GPIO_CRL_CNF5_Msk  = 0xc00000   // Bit mask of CNF5 field.
	GPIO_CRL_MODE6_Pos = 0x18       // Position of MODE6 field.
	GPIO_CRL_MODE6_Msk = 0x3000000  // Bit mask of MODE6 field.
	GPIO_CRL_CNF6_Pos  = 0x1a       // Position of CNF6 field.
	GPIO_CRL_CNF6_Msk  = 0xc000000  // Bit mask of CNF6 field.
	GPIO_CRL_MODE7_Pos = 0x1c       // Position of MODE7 field.
	GPIO_CRL_MODE7_Msk = 0x30000000 // Bit mask of MODE7 field.
	GPIO_CRL_CNF7_Pos  = 0x1e       // Position of CNF7 field.
	GPIO_CRL_CNF7_Msk  = 0xc0000000 // Bit mask of CNF7 field.

	// CRH: Port configuration register high           (GPIOn_CRL)
	GPIO_CRH_MODE8_Pos  = 0x0        // Position of MODE8 field.
	GPIO_CRH_MODE8_Msk  = 0x3        // Bit mask of MODE8 field.
	GPIO_CRH_CNF8_Pos   = 0x2        // Position of CNF8 field.
	GPIO_CRH_CNF8_Msk   = 0xc        // Bit mask of CNF8 field.
	GPIO_CRH_MODE9_Pos  = 0x4        // Position of MODE9 field.
	GPIO_CRH_MODE9_Msk  = 0x30       // Bit mask of MODE9 field.
	GPIO_CRH_CNF9_Pos   = 0x6        // Position of CNF9 field.
	GPIO_CRH_CNF9_Msk   = 0xc0       // Bit mask of CNF9 field.
	GPIO_CRH_MODE10_Pos = 0x8        // Position of MODE10 field.
	GPIO_CRH_MODE10_Msk = 0x300      // Bit mask of MODE10 field.
	GPIO_CRH_CNF10_Pos  = 0xa        // Position of CNF10 field.
	GPIO_CRH_CNF10_Msk  = 0xc00      // Bit mask of CNF10 field.
	GPIO_CRH_MODE11_Pos = 0xc        // Position of MODE11 field.
	GPIO_CRH_MODE11_Msk = 0x3000     // Bit mask of MODE11 field.
	GPIO_CRH_CNF11_Pos  = 0xe        // Position of CNF11 field.
	GPIO_CRH_CNF11_Msk  = 0xc000     // Bit mask of CNF11 field.
	GPIO_CRH_MODE12_Pos = 0x10       // Position of MODE12 field.
	GPIO_CRH_MODE12_Msk = 0x30000    // Bit mask of MODE12 field.
	GPIO_CRH_CNF12_Pos  = 0x12       // Position of CNF12 field.
	GPIO_CRH_CNF12_Msk  = 0xc0000    // Bit mask of CNF12 field.
	GPIO_CRH_MODE13_Pos = 0x14       // Position of MODE13 field.
	GPIO_CRH_MODE13_Msk = 0x300000   // Bit mask of MODE13 field.
	GPIO_CRH_CNF13_Pos  = 0x16       // Position of CNF13 field.
	GPIO_CRH_CNF13_Msk  = 0xc00000   // Bit mask of CNF13 field.
	GPIO_CRH_MODE14_Pos = 0x18       // Position of MODE14 field.
	GPIO_CRH_MODE14_Msk = 0x3000000  // Bit mask of MODE14 field.
	GPIO_CRH_CNF14_Pos  = 0x1a       // Position of CNF14 field.
	GPIO_CRH_CNF14_Msk  = 0xc000000  // Bit mask of CNF14 field.
	GPIO_CRH_MODE15_Pos = 0x1c       // Position of MODE15 field.
	GPIO_CRH_MODE15_Msk = 0x30000000 // Bit mask of MODE15 field.
	GPIO_CRH_CNF15_Pos  = 0x1e       // Position of CNF15 field.
	GPIO_CRH_CNF15_Msk  = 0xc0000000 // Bit mask of CNF15 field.

	// IDR: Port input data register           (GPIOn_IDR)
	GPIO_IDR_IDR0_Pos  = 0x0    // Position of IDR0 field.
	GPIO_IDR_IDR0_Msk  = 0x1    // Bit mask of IDR0 field.
	GPIO_IDR_IDR0      = 0x1    // Bit IDR0.
	GPIO_IDR_IDR1_Pos  = 0x1    // Position of IDR1 field.
	GPIO_IDR_IDR1_Msk  = 0x2    // Bit mask of IDR1 field.
	GPIO_IDR_IDR1      = 0x2    // Bit IDR1.
	GPIO_IDR_IDR2_Pos  = 0x2    // Position of IDR2 field.
	GPIO_IDR_IDR2_Msk  = 0x4    // Bit mask of IDR2 field.
	GPIO_IDR_IDR2      = 0x4    // Bit IDR2.
	GPIO_IDR_IDR3_Pos  = 0x3    // Position of IDR3 field.
	GPIO_IDR_IDR3_Msk  = 0x8    // Bit mask of IDR3 field.
	GPIO_IDR_IDR3      = 0x8    // Bit IDR3.
	GPIO_IDR_IDR4_Pos  = 0x4    // Position of IDR4 field.
	GPIO_IDR_IDR4_Msk  = 0x10   // Bit mask of IDR4 field.
	GPIO_IDR_IDR4      = 0x10   // Bit IDR4.
	GPIO_IDR_IDR5_Pos  = 0x5    // Position of IDR5 field.
	GPIO_IDR_IDR5_Msk  = 0x20   // Bit mask of IDR5 field.
	GPIO_IDR_IDR5      = 0x20   // Bit IDR5.
	GPIO_IDR_IDR6_Pos  = 0x6    // Position of IDR6 field.
	GPIO_IDR_IDR6_Msk  = 0x40   // Bit mask of IDR6 field.
	GPIO_IDR_IDR6      = 0x40   // Bit IDR6.
	GPIO_IDR_IDR7_Pos  = 0x7    // Position of IDR7 field.
	GPIO_IDR_IDR7_Msk  = 0x80   // Bit mask of IDR7 field.
	GPIO_IDR_IDR7      = 0x80   // Bit IDR7.
	GPIO_IDR_IDR8_Pos  = 0x8    // Position of IDR8 field.
	GPIO_IDR_IDR8_Msk  = 0x100  // Bit mask of IDR8 field.
	GPIO_IDR_IDR8      = 0x100  // Bit IDR8.
	GPIO_IDR_IDR9_Pos  = 0x9    // Position of IDR9 field.
	GPIO_IDR_IDR9_Msk  = 0x200  // Bit mask of IDR9 field.
	GPIO_IDR_IDR9      = 0x200  // Bit IDR9.
	GPIO_IDR_IDR10_Pos = 0xa    // Position of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400  // Bit mask of IDR10 field.
	GPIO_IDR_IDR10     = 0x400  // Bit IDR10.
	GPIO_IDR_IDR11_Pos = 0xb    // Position of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800  // Bit mask of IDR11 field.
	GPIO_IDR_IDR11     = 0x800  // Bit IDR11.
	GPIO_IDR_IDR12_Pos = 0xc    // Position of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000 // Bit mask of IDR12 field.
	GPIO_IDR_IDR12     = 0x1000 // Bit IDR12.
	GPIO_IDR_IDR13_Pos = 0xd    // Position of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000 // Bit mask of IDR13 field.
	GPIO_IDR_IDR13     = 0x2000 // Bit IDR13.
	GPIO_IDR_IDR14_Pos = 0xe    // Position of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000 // Bit mask of IDR14 field.
	GPIO_IDR_IDR14     = 0x4000 // Bit IDR14.
	GPIO_IDR_IDR15_Pos = 0xf    // Position of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000 // Bit mask of IDR15 field.
	GPIO_IDR_IDR15     = 0x8000 // Bit IDR15.

	// ODR: Port output data register           (GPIOn_ODR)
	GPIO_ODR_ODR0_Pos  = 0x0    // Position of ODR0 field.
	GPIO_ODR_ODR0_Msk  = 0x1    // Bit mask of ODR0 field.
	GPIO_ODR_ODR0      = 0x1    // Bit ODR0.
	GPIO_ODR_ODR1_Pos  = 0x1    // Position of ODR1 field.
	GPIO_ODR_ODR1_Msk  = 0x2    // Bit mask of ODR1 field.
	GPIO_ODR_ODR1      = 0x2    // Bit ODR1.
	GPIO_ODR_ODR2_Pos  = 0x2    // Position of ODR2 field.
	GPIO_ODR_ODR2_Msk  = 0x4    // Bit mask of ODR2 field.
	GPIO_ODR_ODR2      = 0x4    // Bit ODR2.
	GPIO_ODR_ODR3_Pos  = 0x3    // Position of ODR3 field.
	GPIO_ODR_ODR3_Msk  = 0x8    // Bit mask of ODR3 field.
	GPIO_ODR_ODR3      = 0x8    // Bit ODR3.
	GPIO_ODR_ODR4_Pos  = 0x4    // Position of ODR4 field.
	GPIO_ODR_ODR4_Msk  = 0x10   // Bit mask of ODR4 field.
	GPIO_ODR_ODR4      = 0x10   // Bit ODR4.
	GPIO_ODR_ODR5_Pos  = 0x5    // Position of ODR5 field.
	GPIO_ODR_ODR5_Msk  = 0x20   // Bit mask of ODR5 field.
	GPIO_ODR_ODR5      = 0x20   // Bit ODR5.
	GPIO_ODR_ODR6_Pos  = 0x6    // Position of ODR6 field.
	GPIO_ODR_ODR6_Msk  = 0x40   // Bit mask of ODR6 field.
	GPIO_ODR_ODR6      = 0x40   // Bit ODR6.
	GPIO_ODR_ODR7_Pos  = 0x7    // Position of ODR7 field.
	GPIO_ODR_ODR7_Msk  = 0x80   // Bit mask of ODR7 field.
	GPIO_ODR_ODR7      = 0x80   // Bit ODR7.
	GPIO_ODR_ODR8_Pos  = 0x8    // Position of ODR8 field.
	GPIO_ODR_ODR8_Msk  = 0x100  // Bit mask of ODR8 field.
	GPIO_ODR_ODR8      = 0x100  // Bit ODR8.
	GPIO_ODR_ODR9_Pos  = 0x9    // Position of ODR9 field.
	GPIO_ODR_ODR9_Msk  = 0x200  // Bit mask of ODR9 field.
	GPIO_ODR_ODR9      = 0x200  // Bit ODR9.
	GPIO_ODR_ODR10_Pos = 0xa    // Position of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400  // Bit mask of ODR10 field.
	GPIO_ODR_ODR10     = 0x400  // Bit ODR10.
	GPIO_ODR_ODR11_Pos = 0xb    // Position of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800  // Bit mask of ODR11 field.
	GPIO_ODR_ODR11     = 0x800  // Bit ODR11.
	GPIO_ODR_ODR12_Pos = 0xc    // Position of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000 // Bit mask of ODR12 field.
	GPIO_ODR_ODR12     = 0x1000 // Bit ODR12.
	GPIO_ODR_ODR13_Pos = 0xd    // Position of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000 // Bit mask of ODR13 field.
	GPIO_ODR_ODR13     = 0x2000 // Bit ODR13.
	GPIO_ODR_ODR14_Pos = 0xe    // Position of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000 // Bit mask of ODR14 field.
	GPIO_ODR_ODR14     = 0x4000 // Bit ODR14.
	GPIO_ODR_ODR15_Pos = 0xf    // Position of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000 // Bit mask of ODR15 field.
	GPIO_ODR_ODR15     = 0x8000 // Bit ODR15.

	// BSRR: Port bit set/reset register           (GPIOn_BSRR)
	GPIO_BSRR_BS0_Pos  = 0x0        // Position of BS0 field.
	GPIO_BSRR_BS0_Msk  = 0x1        // Bit mask of BS0 field.
	GPIO_BSRR_BS0      = 0x1        // Bit BS0.
	GPIO_BSRR_BS1_Pos  = 0x1        // Position of BS1 field.
	GPIO_BSRR_BS1_Msk  = 0x2        // Bit mask of BS1 field.
	GPIO_BSRR_BS1      = 0x2        // Bit BS1.
	GPIO_BSRR_BS2_Pos  = 0x2        // Position of BS2 field.
	GPIO_BSRR_BS2_Msk  = 0x4        // Bit mask of BS2 field.
	GPIO_BSRR_BS2      = 0x4        // Bit BS2.
	GPIO_BSRR_BS3_Pos  = 0x3        // Position of BS3 field.
	GPIO_BSRR_BS3_Msk  = 0x8        // Bit mask of BS3 field.
	GPIO_BSRR_BS3      = 0x8        // Bit BS3.
	GPIO_BSRR_BS4_Pos  = 0x4        // Position of BS4 field.
	GPIO_BSRR_BS4_Msk  = 0x10       // Bit mask of BS4 field.
	GPIO_BSRR_BS4      = 0x10       // Bit BS4.
	GPIO_BSRR_BS5_Pos  = 0x5        // Position of BS5 field.
	GPIO_BSRR_BS5_Msk  = 0x20       // Bit mask of BS5 field.
	GPIO_BSRR_BS5      = 0x20       // Bit BS5.
	GPIO_BSRR_BS6_Pos  = 0x6        // Position of BS6 field.
	GPIO_BSRR_BS6_Msk  = 0x40       // Bit mask of BS6 field.
	GPIO_BSRR_BS6      = 0x40       // Bit BS6.
	GPIO_BSRR_BS7_Pos  = 0x7        // Position of BS7 field.
	GPIO_BSRR_BS7_Msk  = 0x80       // Bit mask of BS7 field.
	GPIO_BSRR_BS7      = 0x80       // Bit BS7.
	GPIO_BSRR_BS8_Pos  = 0x8        // Position of BS8 field.
	GPIO_BSRR_BS8_Msk  = 0x100      // Bit mask of BS8 field.
	GPIO_BSRR_BS8      = 0x100      // Bit BS8.
	GPIO_BSRR_BS9_Pos  = 0x9        // Position of BS9 field.
	GPIO_BSRR_BS9_Msk  = 0x200      // Bit mask of BS9 field.
	GPIO_BSRR_BS9      = 0x200      // Bit BS9.
	GPIO_BSRR_BS10_Pos = 0xa        // Position of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400      // Bit mask of BS10 field.
	GPIO_BSRR_BS10     = 0x400      // Bit BS10.
	GPIO_BSRR_BS11_Pos = 0xb        // Position of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800      // Bit mask of BS11 field.
	GPIO_BSRR_BS11     = 0x800      // Bit BS11.
	GPIO_BSRR_BS12_Pos = 0xc        // Position of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000     // Bit mask of BS12 field.
	GPIO_BSRR_BS12     = 0x1000     // Bit BS12.
	GPIO_BSRR_BS13_Pos = 0xd        // Position of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000     // Bit mask of BS13 field.
	GPIO_BSRR_BS13     = 0x2000     // Bit BS13.
	GPIO_BSRR_BS14_Pos = 0xe        // Position of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000     // Bit mask of BS14 field.
	GPIO_BSRR_BS14     = 0x4000     // Bit BS14.
	GPIO_BSRR_BS15_Pos = 0xf        // Position of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000     // Bit mask of BS15 field.
	GPIO_BSRR_BS15     = 0x8000     // Bit BS15.
	GPIO_BSRR_BR0_Pos  = 0x10       // Position of BR0 field.
	GPIO_BSRR_BR0_Msk  = 0x10000    // Bit mask of BR0 field.
	GPIO_BSRR_BR0      = 0x10000    // Bit BR0.
	GPIO_BSRR_BR1_Pos  = 0x11       // Position of BR1 field.
	GPIO_BSRR_BR1_Msk  = 0x20000    // Bit mask of BR1 field.
	GPIO_BSRR_BR1      = 0x20000    // Bit BR1.
	GPIO_BSRR_BR2_Pos  = 0x12       // Position of BR2 field.
	GPIO_BSRR_BR2_Msk  = 0x40000    // Bit mask of BR2 field.
	GPIO_BSRR_BR2      = 0x40000    // Bit BR2.
	GPIO_BSRR_BR3_Pos  = 0x13       // Position of BR3 field.
	GPIO_BSRR_BR3_Msk  = 0x80000    // Bit mask of BR3 field.
	GPIO_BSRR_BR3      = 0x80000    // Bit BR3.
	GPIO_BSRR_BR4_Pos  = 0x14       // Position of BR4 field.
	GPIO_BSRR_BR4_Msk  = 0x100000   // Bit mask of BR4 field.
	GPIO_BSRR_BR4      = 0x100000   // Bit BR4.
	GPIO_BSRR_BR5_Pos  = 0x15       // Position of BR5 field.
	GPIO_BSRR_BR5_Msk  = 0x200000   // Bit mask of BR5 field.
	GPIO_BSRR_BR5      = 0x200000   // Bit BR5.
	GPIO_BSRR_BR6_Pos  = 0x16       // Position of BR6 field.
	GPIO_BSRR_BR6_Msk  = 0x400000   // Bit mask of BR6 field.
	GPIO_BSRR_BR6      = 0x400000   // Bit BR6.
	GPIO_BSRR_BR7_Pos  = 0x17       // Position of BR7 field.
	GPIO_BSRR_BR7_Msk  = 0x800000   // Bit mask of BR7 field.
	GPIO_BSRR_BR7      = 0x800000   // Bit BR7.
	GPIO_BSRR_BR8_Pos  = 0x18       // Position of BR8 field.
	GPIO_BSRR_BR8_Msk  = 0x1000000  // Bit mask of BR8 field.
	GPIO_BSRR_BR8      = 0x1000000  // Bit BR8.
	GPIO_BSRR_BR9_Pos  = 0x19       // Position of BR9 field.
	GPIO_BSRR_BR9_Msk  = 0x2000000  // Bit mask of BR9 field.
	GPIO_BSRR_BR9      = 0x2000000  // Bit BR9.
	GPIO_BSRR_BR10_Pos = 0x1a       // Position of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000  // Bit mask of BR10 field.
	GPIO_BSRR_BR10     = 0x4000000  // Bit BR10.
	GPIO_BSRR_BR11_Pos = 0x1b       // Position of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000  // Bit mask of BR11 field.
	GPIO_BSRR_BR11     = 0x8000000  // Bit BR11.
	GPIO_BSRR_BR12_Pos = 0x1c       // Position of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000 // Bit mask of BR12 field.
	GPIO_BSRR_BR12     = 0x10000000 // Bit BR12.
	GPIO_BSRR_BR13_Pos = 0x1d       // Position of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000 // Bit mask of BR13 field.
	GPIO_BSRR_BR13     = 0x20000000 // Bit BR13.
	GPIO_BSRR_BR14_Pos = 0x1e       // Position of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000 // Bit mask of BR14 field.
	GPIO_BSRR_BR14     = 0x40000000 // Bit BR14.
	GPIO_BSRR_BR15_Pos = 0x1f       // Position of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000 // Bit mask of BR15 field.
	GPIO_BSRR_BR15     = 0x80000000 // Bit BR15.

	// BRR: Port bit reset register           (GPIOn_BRR)
	GPIO_BRR_BR0_Pos  = 0x0    // Position of BR0 field.
	GPIO_BRR_BR0_Msk  = 0x1    // Bit mask of BR0 field.
	GPIO_BRR_BR0      = 0x1    // Bit BR0.
	GPIO_BRR_BR1_Pos  = 0x1    // Position of BR1 field.
	GPIO_BRR_BR1_Msk  = 0x2    // Bit mask of BR1 field.
	GPIO_BRR_BR1      = 0x2    // Bit BR1.
	GPIO_BRR_BR2_Pos  = 0x2    // Position of BR2 field.
	GPIO_BRR_BR2_Msk  = 0x4    // Bit mask of BR2 field.
	GPIO_BRR_BR2      = 0x4    // Bit BR2.
	GPIO_BRR_BR3_Pos  = 0x3    // Position of BR3 field.
	GPIO_BRR_BR3_Msk  = 0x8    // Bit mask of BR3 field.
	GPIO_BRR_BR3      = 0x8    // Bit BR3.
	GPIO_BRR_BR4_Pos  = 0x4    // Position of BR4 field.
	GPIO_BRR_BR4_Msk  = 0x10   // Bit mask of BR4 field.
	GPIO_BRR_BR4      = 0x10   // Bit BR4.
	GPIO_BRR_BR5_Pos  = 0x5    // Position of BR5 field.
	GPIO_BRR_BR5_Msk  = 0x20   // Bit mask of BR5 field.
	GPIO_BRR_BR5      = 0x20   // Bit BR5.
	GPIO_BRR_BR6_Pos  = 0x6    // Position of BR6 field.
	GPIO_BRR_BR6_Msk  = 0x40   // Bit mask of BR6 field.
	GPIO_BRR_BR6      = 0x40   // Bit BR6.
	GPIO_BRR_BR7_Pos  = 0x7    // Position of BR7 field.
	GPIO_BRR_BR7_Msk  = 0x80   // Bit mask of BR7 field.
	GPIO_BRR_BR7      = 0x80   // Bit BR7.
	GPIO_BRR_BR8_Pos  = 0x8    // Position of BR8 field.
	GPIO_BRR_BR8_Msk  = 0x100  // Bit mask of BR8 field.
	GPIO_BRR_BR8      = 0x100  // Bit BR8.
	GPIO_BRR_BR9_Pos  = 0x9    // Position of BR9 field.
	GPIO_BRR_BR9_Msk  = 0x200  // Bit mask of BR9 field.
	GPIO_BRR_BR9      = 0x200  // Bit BR9.
	GPIO_BRR_BR10_Pos = 0xa    // Position of BR10 field.
	GPIO_BRR_BR10_Msk = 0x400  // Bit mask of BR10 field.
	GPIO_BRR_BR10     = 0x400  // Bit BR10.
	GPIO_BRR_BR11_Pos = 0xb    // Position of BR11 field.
	GPIO_BRR_BR11_Msk = 0x800  // Bit mask of BR11 field.
	GPIO_BRR_BR11     = 0x800  // Bit BR11.
	GPIO_BRR_BR12_Pos = 0xc    // Position of BR12 field.
	GPIO_BRR_BR12_Msk = 0x1000 // Bit mask of BR12 field.
	GPIO_BRR_BR12     = 0x1000 // Bit BR12.
	GPIO_BRR_BR13_Pos = 0xd    // Position of BR13 field.
	GPIO_BRR_BR13_Msk = 0x2000 // Bit mask of BR13 field.
	GPIO_BRR_BR13     = 0x2000 // Bit BR13.
	GPIO_BRR_BR14_Pos = 0xe    // Position of BR14 field.
	GPIO_BRR_BR14_Msk = 0x4000 // Bit mask of BR14 field.
	GPIO_BRR_BR14     = 0x4000 // Bit BR14.
	GPIO_BRR_BR15_Pos = 0xf    // Position of BR15 field.
	GPIO_BRR_BR15_Msk = 0x8000 // Bit mask of BR15 field.
	GPIO_BRR_BR15     = 0x8000 // Bit BR15.

	// LCKR: Port configuration lock           register
	GPIO_LCKR_LCK0_Pos  = 0x0     // Position of LCK0 field.
	GPIO_LCKR_LCK0_Msk  = 0x1     // Bit mask of LCK0 field.
	GPIO_LCKR_LCK0      = 0x1     // Bit LCK0.
	GPIO_LCKR_LCK1_Pos  = 0x1     // Position of LCK1 field.
	GPIO_LCKR_LCK1_Msk  = 0x2     // Bit mask of LCK1 field.
	GPIO_LCKR_LCK1      = 0x2     // Bit LCK1.
	GPIO_LCKR_LCK2_Pos  = 0x2     // Position of LCK2 field.
	GPIO_LCKR_LCK2_Msk  = 0x4     // Bit mask of LCK2 field.
	GPIO_LCKR_LCK2      = 0x4     // Bit LCK2.
	GPIO_LCKR_LCK3_Pos  = 0x3     // Position of LCK3 field.
	GPIO_LCKR_LCK3_Msk  = 0x8     // Bit mask of LCK3 field.
	GPIO_LCKR_LCK3      = 0x8     // Bit LCK3.
	GPIO_LCKR_LCK4_Pos  = 0x4     // Position of LCK4 field.
	GPIO_LCKR_LCK4_Msk  = 0x10    // Bit mask of LCK4 field.
	GPIO_LCKR_LCK4      = 0x10    // Bit LCK4.
	GPIO_LCKR_LCK5_Pos  = 0x5     // Position of LCK5 field.
	GPIO_LCKR_LCK5_Msk  = 0x20    // Bit mask of LCK5 field.
	GPIO_LCKR_LCK5      = 0x20    // Bit LCK5.
	GPIO_LCKR_LCK6_Pos  = 0x6     // Position of LCK6 field.
	GPIO_LCKR_LCK6_Msk  = 0x40    // Bit mask of LCK6 field.
	GPIO_LCKR_LCK6      = 0x40    // Bit LCK6.
	GPIO_LCKR_LCK7_Pos  = 0x7     // Position of LCK7 field.
	GPIO_LCKR_LCK7_Msk  = 0x80    // Bit mask of LCK7 field.
	GPIO_LCKR_LCK7      = 0x80    // Bit LCK7.
	GPIO_LCKR_LCK8_Pos  = 0x8     // Position of LCK8 field.
	GPIO_LCKR_LCK8_Msk  = 0x100   // Bit mask of LCK8 field.
	GPIO_LCKR_LCK8      = 0x100   // Bit LCK8.
	GPIO_LCKR_LCK9_Pos  = 0x9     // Position of LCK9 field.
	GPIO_LCKR_LCK9_Msk  = 0x200   // Bit mask of LCK9 field.
	GPIO_LCKR_LCK9      = 0x200   // Bit LCK9.
	GPIO_LCKR_LCK10_Pos = 0xa     // Position of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400   // Bit mask of LCK10 field.
	GPIO_LCKR_LCK10     = 0x400   // Bit LCK10.
	GPIO_LCKR_LCK11_Pos = 0xb     // Position of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800   // Bit mask of LCK11 field.
	GPIO_LCKR_LCK11     = 0x800   // Bit LCK11.
	GPIO_LCKR_LCK12_Pos = 0xc     // Position of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000  // Bit mask of LCK12 field.
	GPIO_LCKR_LCK12     = 0x1000  // Bit LCK12.
	GPIO_LCKR_LCK13_Pos = 0xd     // Position of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000  // Bit mask of LCK13 field.
	GPIO_LCKR_LCK13     = 0x2000  // Bit LCK13.
	GPIO_LCKR_LCK14_Pos = 0xe     // Position of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000  // Bit mask of LCK14 field.
	GPIO_LCKR_LCK14     = 0x4000  // Bit LCK14.
	GPIO_LCKR_LCK15_Pos = 0xf     // Position of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000  // Bit mask of LCK15 field.
	GPIO_LCKR_LCK15     = 0x8000  // Bit LCK15.
	GPIO_LCKR_LCKK_Pos  = 0x10    // Position of LCKK field.
	GPIO_LCKR_LCKK_Msk  = 0x10000 // Bit mask of LCKK field.
	GPIO_LCKR_LCKK      = 0x10000 // Bit LCKK.
)

// Bitfields for AFIO: Alternate function I/O
const (
	// EVCR: Event Control Register           (AFIO_EVCR)
	AFIO_EVCR_PIN_Pos  = 0x0  // Position of PIN field.
	AFIO_EVCR_PIN_Msk  = 0xf  // Bit mask of PIN field.
	AFIO_EVCR_PORT_Pos = 0x4  // Position of PORT field.
	AFIO_EVCR_PORT_Msk = 0x70 // Bit mask of PORT field.
	AFIO_EVCR_EVOE_Pos = 0x7  // Position of EVOE field.
	AFIO_EVCR_EVOE_Msk = 0x80 // Bit mask of EVOE field.
	AFIO_EVCR_EVOE     = 0x80 // Bit EVOE.

	// MAPR: AF remap and debug I/O configuration           register (AFIO_MAPR)
	AFIO_MAPR_SPI1_REMAP_Pos     = 0x0       // Position of SPI1_REMAP field.
	AFIO_MAPR_SPI1_REMAP_Msk     = 0x1       // Bit mask of SPI1_REMAP field.
	AFIO_MAPR_SPI1_REMAP         = 0x1       // Bit SPI1_REMAP.
	AFIO_MAPR_I2C1_REMAP_Pos     = 0x1       // Position of I2C1_REMAP field.
	AFIO_MAPR_I2C1_REMAP_Msk     = 0x2       // Bit mask of I2C1_REMAP field.
	AFIO_MAPR_I2C1_REMAP         = 0x2       // Bit I2C1_REMAP.
	AFIO_MAPR_USART1_REMAP_Pos   = 0x2       // Position of USART1_REMAP field.
	AFIO_MAPR_USART1_REMAP_Msk   = 0x4       // Bit mask of USART1_REMAP field.
	AFIO_MAPR_USART1_REMAP       = 0x4       // Bit USART1_REMAP.
	AFIO_MAPR_USART2_REMAP_Pos   = 0x3       // Position of USART2_REMAP field.
	AFIO_MAPR_USART2_REMAP_Msk   = 0x8       // Bit mask of USART2_REMAP field.
	AFIO_MAPR_USART2_REMAP       = 0x8       // Bit USART2_REMAP.
	AFIO_MAPR_USART3_REMAP_Pos   = 0x4       // Position of USART3_REMAP field.
	AFIO_MAPR_USART3_REMAP_Msk   = 0x30      // Bit mask of USART3_REMAP field.
	AFIO_MAPR_TIM1_REMAP_Pos     = 0x6       // Position of TIM1_REMAP field.
	AFIO_MAPR_TIM1_REMAP_Msk     = 0xc0      // Bit mask of TIM1_REMAP field.
	AFIO_MAPR_TIM2_REMAP_Pos     = 0x8       // Position of TIM2_REMAP field.
	AFIO_MAPR_TIM2_REMAP_Msk     = 0x300     // Bit mask of TIM2_REMAP field.
	AFIO_MAPR_TIM3_REMAP_Pos     = 0xa       // Position of TIM3_REMAP field.
	AFIO_MAPR_TIM3_REMAP_Msk     = 0xc00     // Bit mask of TIM3_REMAP field.
	AFIO_MAPR_TIM4_REMAP_Pos     = 0xc       // Position of TIM4_REMAP field.
	AFIO_MAPR_TIM4_REMAP_Msk     = 0x1000    // Bit mask of TIM4_REMAP field.
	AFIO_MAPR_TIM4_REMAP         = 0x1000    // Bit TIM4_REMAP.
	AFIO_MAPR_PD01_REMAP_Pos     = 0xf       // Position of PD01_REMAP field.
	AFIO_MAPR_PD01_REMAP_Msk     = 0x8000    // Bit mask of PD01_REMAP field.
	AFIO_MAPR_PD01_REMAP         = 0x8000    // Bit PD01_REMAP.
	AFIO_MAPR_TIM5CH4_IREMAP_Pos = 0x10      // Position of TIM5CH4_IREMAP field.
	AFIO_MAPR_TIM5CH4_IREMAP_Msk = 0x10000   // Bit mask of TIM5CH4_IREMAP field.
	AFIO_MAPR_TIM5CH4_IREMAP     = 0x10000   // Bit TIM5CH4_IREMAP.
	AFIO_MAPR_SWJ_CFG_Pos        = 0x18      // Position of SWJ_CFG field.
	AFIO_MAPR_SWJ_CFG_Msk        = 0x7000000 // Bit mask of SWJ_CFG field.

	// EXTICR1: External interrupt configuration register 1           (AFIO_EXTICR1)
	AFIO_EXTICR1_EXTI0_Pos = 0x0    // Position of EXTI0 field.
	AFIO_EXTICR1_EXTI0_Msk = 0xf    // Bit mask of EXTI0 field.
	AFIO_EXTICR1_EXTI1_Pos = 0x4    // Position of EXTI1 field.
	AFIO_EXTICR1_EXTI1_Msk = 0xf0   // Bit mask of EXTI1 field.
	AFIO_EXTICR1_EXTI2_Pos = 0x8    // Position of EXTI2 field.
	AFIO_EXTICR1_EXTI2_Msk = 0xf00  // Bit mask of EXTI2 field.
	AFIO_EXTICR1_EXTI3_Pos = 0xc    // Position of EXTI3 field.
	AFIO_EXTICR1_EXTI3_Msk = 0xf000 // Bit mask of EXTI3 field.

	// EXTICR2: External interrupt configuration register 2           (AFIO_EXTICR2)
	AFIO_EXTICR2_EXTI4_Pos = 0x0    // Position of EXTI4 field.
	AFIO_EXTICR2_EXTI4_Msk = 0xf    // Bit mask of EXTI4 field.
	AFIO_EXTICR2_EXTI5_Pos = 0x4    // Position of EXTI5 field.
	AFIO_EXTICR2_EXTI5_Msk = 0xf0   // Bit mask of EXTI5 field.
	AFIO_EXTICR2_EXTI6_Pos = 0x8    // Position of EXTI6 field.
	AFIO_EXTICR2_EXTI6_Msk = 0xf00  // Bit mask of EXTI6 field.
	AFIO_EXTICR2_EXTI7_Pos = 0xc    // Position of EXTI7 field.
	AFIO_EXTICR2_EXTI7_Msk = 0xf000 // Bit mask of EXTI7 field.

	// EXTICR3: External interrupt configuration register 3           (AFIO_EXTICR3)
	AFIO_EXTICR3_EXTI8_Pos  = 0x0    // Position of EXTI8 field.
	AFIO_EXTICR3_EXTI8_Msk  = 0xf    // Bit mask of EXTI8 field.
	AFIO_EXTICR3_EXTI9_Pos  = 0x4    // Position of EXTI9 field.
	AFIO_EXTICR3_EXTI9_Msk  = 0xf0   // Bit mask of EXTI9 field.
	AFIO_EXTICR3_EXTI10_Pos = 0x8    // Position of EXTI10 field.
	AFIO_EXTICR3_EXTI10_Msk = 0xf00  // Bit mask of EXTI10 field.
	AFIO_EXTICR3_EXTI11_Pos = 0xc    // Position of EXTI11 field.
	AFIO_EXTICR3_EXTI11_Msk = 0xf000 // Bit mask of EXTI11 field.

	// EXTICR4: External interrupt configuration register 4           (AFIO_EXTICR4)
	AFIO_EXTICR4_EXTI12_Pos = 0x0    // Position of EXTI12 field.
	AFIO_EXTICR4_EXTI12_Msk = 0xf    // Bit mask of EXTI12 field.
	AFIO_EXTICR4_EXTI13_Pos = 0x4    // Position of EXTI13 field.
	AFIO_EXTICR4_EXTI13_Msk = 0xf0   // Bit mask of EXTI13 field.
	AFIO_EXTICR4_EXTI14_Pos = 0x8    // Position of EXTI14 field.
	AFIO_EXTICR4_EXTI14_Msk = 0xf00  // Bit mask of EXTI14 field.
	AFIO_EXTICR4_EXTI15_Pos = 0xc    // Position of EXTI15 field.
	AFIO_EXTICR4_EXTI15_Msk = 0xf000 // Bit mask of EXTI15 field.

	// MAPR2: AF remap and debug I/O configuration           register
	AFIO_MAPR2_TIM15_REMAP_Pos         = 0x0    // Position of TIM15_REMAP field.
	AFIO_MAPR2_TIM15_REMAP_Msk         = 0x1    // Bit mask of TIM15_REMAP field.
	AFIO_MAPR2_TIM15_REMAP             = 0x1    // Bit TIM15_REMAP.
	AFIO_MAPR2_TIM16_REMAP_Pos         = 0x1    // Position of TIM16_REMAP field.
	AFIO_MAPR2_TIM16_REMAP_Msk         = 0x2    // Bit mask of TIM16_REMAP field.
	AFIO_MAPR2_TIM16_REMAP             = 0x2    // Bit TIM16_REMAP.
	AFIO_MAPR2_TIM17_REMAP_Pos         = 0x2    // Position of TIM17_REMAP field.
	AFIO_MAPR2_TIM17_REMAP_Msk         = 0x4    // Bit mask of TIM17_REMAP field.
	AFIO_MAPR2_TIM17_REMAP             = 0x4    // Bit TIM17_REMAP.
	AFIO_MAPR2_TIM13_REMAP_Pos         = 0x8    // Position of TIM13_REMAP field.
	AFIO_MAPR2_TIM13_REMAP_Msk         = 0x100  // Bit mask of TIM13_REMAP field.
	AFIO_MAPR2_TIM13_REMAP             = 0x100  // Bit TIM13_REMAP.
	AFIO_MAPR2_TIM14_REMAP_Pos         = 0x9    // Position of TIM14_REMAP field.
	AFIO_MAPR2_TIM14_REMAP_Msk         = 0x200  // Bit mask of TIM14_REMAP field.
	AFIO_MAPR2_TIM14_REMAP             = 0x200  // Bit TIM14_REMAP.
	AFIO_MAPR2_FSMC_NADV_Pos           = 0xa    // Position of FSMC_NADV field.
	AFIO_MAPR2_FSMC_NADV_Msk           = 0x400  // Bit mask of FSMC_NADV field.
	AFIO_MAPR2_FSMC_NADV               = 0x400  // Bit FSMC_NADV.
	AFIO_MAPR2_CEC_REMAP_Pos           = 0x3    // Position of CEC_REMAP field.
	AFIO_MAPR2_CEC_REMAP_Msk           = 0x8    // Bit mask of CEC_REMAP field.
	AFIO_MAPR2_CEC_REMAP               = 0x8    // Bit CEC_REMAP.
	AFIO_MAPR2_TIM1_DMA_REMAP_Pos      = 0x4    // Position of TIM1_DMA_REMAP field.
	AFIO_MAPR2_TIM1_DMA_REMAP_Msk      = 0x10   // Bit mask of TIM1_DMA_REMAP field.
	AFIO_MAPR2_TIM1_DMA_REMAP          = 0x10   // Bit TIM1_DMA_REMAP.
	AFIO_MAPR2_TIM67_DAC_DMA_REMAP_Pos = 0xb    // Position of TIM67_DAC_DMA_REMAP field.
	AFIO_MAPR2_TIM67_DAC_DMA_REMAP_Msk = 0x800  // Bit mask of TIM67_DAC_DMA_REMAP field.
	AFIO_MAPR2_TIM67_DAC_DMA_REMAP     = 0x800  // Bit TIM67_DAC_DMA_REMAP.
	AFIO_MAPR2_TIM12_REMAP_Pos         = 0xc    // Position of TIM12_REMAP field.
	AFIO_MAPR2_TIM12_REMAP_Msk         = 0x1000 // Bit mask of TIM12_REMAP field.
	AFIO_MAPR2_TIM12_REMAP             = 0x1000 // Bit TIM12_REMAP.
	AFIO_MAPR2_MISC_REMAP_Pos          = 0xd    // Position of MISC_REMAP field.
	AFIO_MAPR2_MISC_REMAP_Msk          = 0x2000 // Bit mask of MISC_REMAP field.
	AFIO_MAPR2_MISC_REMAP              = 0x2000 // Bit MISC_REMAP.
)

// Bitfields for EXTI: EXTI
const (
	// IMR: Interrupt mask register           (EXTI_IMR)
	EXTI_IMR_MR0_Pos  = 0x0     // Position of MR0 field.
	EXTI_IMR_MR0_Msk  = 0x1     // Bit mask of MR0 field.
	EXTI_IMR_MR0      = 0x1     // Bit MR0.
	EXTI_IMR_MR1_Pos  = 0x1     // Position of MR1 field.
	EXTI_IMR_MR1_Msk  = 0x2     // Bit mask of MR1 field.
	EXTI_IMR_MR1      = 0x2     // Bit MR1.
	EXTI_IMR_MR2_Pos  = 0x2     // Position of MR2 field.
	EXTI_IMR_MR2_Msk  = 0x4     // Bit mask of MR2 field.
	EXTI_IMR_MR2      = 0x4     // Bit MR2.
	EXTI_IMR_MR3_Pos  = 0x3     // Position of MR3 field.
	EXTI_IMR_MR3_Msk  = 0x8     // Bit mask of MR3 field.
	EXTI_IMR_MR3      = 0x8     // Bit MR3.
	EXTI_IMR_MR4_Pos  = 0x4     // Position of MR4 field.
	EXTI_IMR_MR4_Msk  = 0x10    // Bit mask of MR4 field.
	EXTI_IMR_MR4      = 0x10    // Bit MR4.
	EXTI_IMR_MR5_Pos  = 0x5     // Position of MR5 field.
	EXTI_IMR_MR5_Msk  = 0x20    // Bit mask of MR5 field.
	EXTI_IMR_MR5      = 0x20    // Bit MR5.
	EXTI_IMR_MR6_Pos  = 0x6     // Position of MR6 field.
	EXTI_IMR_MR6_Msk  = 0x40    // Bit mask of MR6 field.
	EXTI_IMR_MR6      = 0x40    // Bit MR6.
	EXTI_IMR_MR7_Pos  = 0x7     // Position of MR7 field.
	EXTI_IMR_MR7_Msk  = 0x80    // Bit mask of MR7 field.
	EXTI_IMR_MR7      = 0x80    // Bit MR7.
	EXTI_IMR_MR8_Pos  = 0x8     // Position of MR8 field.
	EXTI_IMR_MR8_Msk  = 0x100   // Bit mask of MR8 field.
	EXTI_IMR_MR8      = 0x100   // Bit MR8.
	EXTI_IMR_MR9_Pos  = 0x9     // Position of MR9 field.
	EXTI_IMR_MR9_Msk  = 0x200   // Bit mask of MR9 field.
	EXTI_IMR_MR9      = 0x200   // Bit MR9.
	EXTI_IMR_MR10_Pos = 0xa     // Position of MR10 field.
	EXTI_IMR_MR10_Msk = 0x400   // Bit mask of MR10 field.
	EXTI_IMR_MR10     = 0x400   // Bit MR10.
	EXTI_IMR_MR11_Pos = 0xb     // Position of MR11 field.
	EXTI_IMR_MR11_Msk = 0x800   // Bit mask of MR11 field.
	EXTI_IMR_MR11     = 0x800   // Bit MR11.
	EXTI_IMR_MR12_Pos = 0xc     // Position of MR12 field.
	EXTI_IMR_MR12_Msk = 0x1000  // Bit mask of MR12 field.
	EXTI_IMR_MR12     = 0x1000  // Bit MR12.
	EXTI_IMR_MR13_Pos = 0xd     // Position of MR13 field.
	EXTI_IMR_MR13_Msk = 0x2000  // Bit mask of MR13 field.
	EXTI_IMR_MR13     = 0x2000  // Bit MR13.
	EXTI_IMR_MR14_Pos = 0xe     // Position of MR14 field.
	EXTI_IMR_MR14_Msk = 0x4000  // Bit mask of MR14 field.
	EXTI_IMR_MR14     = 0x4000  // Bit MR14.
	EXTI_IMR_MR15_Pos = 0xf     // Position of MR15 field.
	EXTI_IMR_MR15_Msk = 0x8000  // Bit mask of MR15 field.
	EXTI_IMR_MR15     = 0x8000  // Bit MR15.
	EXTI_IMR_MR16_Pos = 0x10    // Position of MR16 field.
	EXTI_IMR_MR16_Msk = 0x10000 // Bit mask of MR16 field.
	EXTI_IMR_MR16     = 0x10000 // Bit MR16.
	EXTI_IMR_MR17_Pos = 0x11    // Position of MR17 field.
	EXTI_IMR_MR17_Msk = 0x20000 // Bit mask of MR17 field.
	EXTI_IMR_MR17     = 0x20000 // Bit MR17.

	// EMR: Event mask register (EXTI_EMR)
	EXTI_EMR_MR0_Pos  = 0x0     // Position of MR0 field.
	EXTI_EMR_MR0_Msk  = 0x1     // Bit mask of MR0 field.
	EXTI_EMR_MR0      = 0x1     // Bit MR0.
	EXTI_EMR_MR1_Pos  = 0x1     // Position of MR1 field.
	EXTI_EMR_MR1_Msk  = 0x2     // Bit mask of MR1 field.
	EXTI_EMR_MR1      = 0x2     // Bit MR1.
	EXTI_EMR_MR2_Pos  = 0x2     // Position of MR2 field.
	EXTI_EMR_MR2_Msk  = 0x4     // Bit mask of MR2 field.
	EXTI_EMR_MR2      = 0x4     // Bit MR2.
	EXTI_EMR_MR3_Pos  = 0x3     // Position of MR3 field.
	EXTI_EMR_MR3_Msk  = 0x8     // Bit mask of MR3 field.
	EXTI_EMR_MR3      = 0x8     // Bit MR3.
	EXTI_EMR_MR4_Pos  = 0x4     // Position of MR4 field.
	EXTI_EMR_MR4_Msk  = 0x10    // Bit mask of MR4 field.
	EXTI_EMR_MR4      = 0x10    // Bit MR4.
	EXTI_EMR_MR5_Pos  = 0x5     // Position of MR5 field.
	EXTI_EMR_MR5_Msk  = 0x20    // Bit mask of MR5 field.
	EXTI_EMR_MR5      = 0x20    // Bit MR5.
	EXTI_EMR_MR6_Pos  = 0x6     // Position of MR6 field.
	EXTI_EMR_MR6_Msk  = 0x40    // Bit mask of MR6 field.
	EXTI_EMR_MR6      = 0x40    // Bit MR6.
	EXTI_EMR_MR7_Pos  = 0x7     // Position of MR7 field.
	EXTI_EMR_MR7_Msk  = 0x80    // Bit mask of MR7 field.
	EXTI_EMR_MR7      = 0x80    // Bit MR7.
	EXTI_EMR_MR8_Pos  = 0x8     // Position of MR8 field.
	EXTI_EMR_MR8_Msk  = 0x100   // Bit mask of MR8 field.
	EXTI_EMR_MR8      = 0x100   // Bit MR8.
	EXTI_EMR_MR9_Pos  = 0x9     // Position of MR9 field.
	EXTI_EMR_MR9_Msk  = 0x200   // Bit mask of MR9 field.
	EXTI_EMR_MR9      = 0x200   // Bit MR9.
	EXTI_EMR_MR10_Pos = 0xa     // Position of MR10 field.
	EXTI_EMR_MR10_Msk = 0x400   // Bit mask of MR10 field.
	EXTI_EMR_MR10     = 0x400   // Bit MR10.
	EXTI_EMR_MR11_Pos = 0xb     // Position of MR11 field.
	EXTI_EMR_MR11_Msk = 0x800   // Bit mask of MR11 field.
	EXTI_EMR_MR11     = 0x800   // Bit MR11.
	EXTI_EMR_MR12_Pos = 0xc     // Position of MR12 field.
	EXTI_EMR_MR12_Msk = 0x1000  // Bit mask of MR12 field.
	EXTI_EMR_MR12     = 0x1000  // Bit MR12.
	EXTI_EMR_MR13_Pos = 0xd     // Position of MR13 field.
	EXTI_EMR_MR13_Msk = 0x2000  // Bit mask of MR13 field.
	EXTI_EMR_MR13     = 0x2000  // Bit MR13.
	EXTI_EMR_MR14_Pos = 0xe     // Position of MR14 field.
	EXTI_EMR_MR14_Msk = 0x4000  // Bit mask of MR14 field.
	EXTI_EMR_MR14     = 0x4000  // Bit MR14.
	EXTI_EMR_MR15_Pos = 0xf     // Position of MR15 field.
	EXTI_EMR_MR15_Msk = 0x8000  // Bit mask of MR15 field.
	EXTI_EMR_MR15     = 0x8000  // Bit MR15.
	EXTI_EMR_MR16_Pos = 0x10    // Position of MR16 field.
	EXTI_EMR_MR16_Msk = 0x10000 // Bit mask of MR16 field.
	EXTI_EMR_MR16     = 0x10000 // Bit MR16.
	EXTI_EMR_MR17_Pos = 0x11    // Position of MR17 field.
	EXTI_EMR_MR17_Msk = 0x20000 // Bit mask of MR17 field.
	EXTI_EMR_MR17     = 0x20000 // Bit MR17.

	// RTSR: Rising Trigger selection register           (EXTI_RTSR)
	EXTI_RTSR_TR0_Pos  = 0x0     // Position of TR0 field.
	EXTI_RTSR_TR0_Msk  = 0x1     // Bit mask of TR0 field.
	EXTI_RTSR_TR0      = 0x1     // Bit TR0.
	EXTI_RTSR_TR1_Pos  = 0x1     // Position of TR1 field.
	EXTI_RTSR_TR1_Msk  = 0x2     // Bit mask of TR1 field.
	EXTI_RTSR_TR1      = 0x2     // Bit TR1.
	EXTI_RTSR_TR2_Pos  = 0x2     // Position of TR2 field.
	EXTI_RTSR_TR2_Msk  = 0x4     // Bit mask of TR2 field.
	EXTI_RTSR_TR2      = 0x4     // Bit TR2.
	EXTI_RTSR_TR3_Pos  = 0x3     // Position of TR3 field.
	EXTI_RTSR_TR3_Msk  = 0x8     // Bit mask of TR3 field.
	EXTI_RTSR_TR3      = 0x8     // Bit TR3.
	EXTI_RTSR_TR4_Pos  = 0x4     // Position of TR4 field.
	EXTI_RTSR_TR4_Msk  = 0x10    // Bit mask of TR4 field.
	EXTI_RTSR_TR4      = 0x10    // Bit TR4.
	EXTI_RTSR_TR5_Pos  = 0x5     // Position of TR5 field.
	EXTI_RTSR_TR5_Msk  = 0x20    // Bit mask of TR5 field.
	EXTI_RTSR_TR5      = 0x20    // Bit TR5.
	EXTI_RTSR_TR6_Pos  = 0x6     // Position of TR6 field.
	EXTI_RTSR_TR6_Msk  = 0x40    // Bit mask of TR6 field.
	EXTI_RTSR_TR6      = 0x40    // Bit TR6.
	EXTI_RTSR_TR7_Pos  = 0x7     // Position of TR7 field.
	EXTI_RTSR_TR7_Msk  = 0x80    // Bit mask of TR7 field.
	EXTI_RTSR_TR7      = 0x80    // Bit TR7.
	EXTI_RTSR_TR8_Pos  = 0x8     // Position of TR8 field.
	EXTI_RTSR_TR8_Msk  = 0x100   // Bit mask of TR8 field.
	EXTI_RTSR_TR8      = 0x100   // Bit TR8.
	EXTI_RTSR_TR9_Pos  = 0x9     // Position of TR9 field.
	EXTI_RTSR_TR9_Msk  = 0x200   // Bit mask of TR9 field.
	EXTI_RTSR_TR9      = 0x200   // Bit TR9.
	EXTI_RTSR_TR10_Pos = 0xa     // Position of TR10 field.
	EXTI_RTSR_TR10_Msk = 0x400   // Bit mask of TR10 field.
	EXTI_RTSR_TR10     = 0x400   // Bit TR10.
	EXTI_RTSR_TR11_Pos = 0xb     // Position of TR11 field.
	EXTI_RTSR_TR11_Msk = 0x800   // Bit mask of TR11 field.
	EXTI_RTSR_TR11     = 0x800   // Bit TR11.
	EXTI_RTSR_TR12_Pos = 0xc     // Position of TR12 field.
	EXTI_RTSR_TR12_Msk = 0x1000  // Bit mask of TR12 field.
	EXTI_RTSR_TR12     = 0x1000  // Bit TR12.
	EXTI_RTSR_TR13_Pos = 0xd     // Position of TR13 field.
	EXTI_RTSR_TR13_Msk = 0x2000  // Bit mask of TR13 field.
	EXTI_RTSR_TR13     = 0x2000  // Bit TR13.
	EXTI_RTSR_TR14_Pos = 0xe     // Position of TR14 field.
	EXTI_RTSR_TR14_Msk = 0x4000  // Bit mask of TR14 field.
	EXTI_RTSR_TR14     = 0x4000  // Bit TR14.
	EXTI_RTSR_TR15_Pos = 0xf     // Position of TR15 field.
	EXTI_RTSR_TR15_Msk = 0x8000  // Bit mask of TR15 field.
	EXTI_RTSR_TR15     = 0x8000  // Bit TR15.
	EXTI_RTSR_TR16_Pos = 0x10    // Position of TR16 field.
	EXTI_RTSR_TR16_Msk = 0x10000 // Bit mask of TR16 field.
	EXTI_RTSR_TR16     = 0x10000 // Bit TR16.
	EXTI_RTSR_TR17_Pos = 0x11    // Position of TR17 field.
	EXTI_RTSR_TR17_Msk = 0x20000 // Bit mask of TR17 field.
	EXTI_RTSR_TR17     = 0x20000 // Bit TR17.

	// FTSR: Falling Trigger selection register           (EXTI_FTSR)
	EXTI_FTSR_TR0_Pos  = 0x0     // Position of TR0 field.
	EXTI_FTSR_TR0_Msk  = 0x1     // Bit mask of TR0 field.
	EXTI_FTSR_TR0      = 0x1     // Bit TR0.
	EXTI_FTSR_TR1_Pos  = 0x1     // Position of TR1 field.
	EXTI_FTSR_TR1_Msk  = 0x2     // Bit mask of TR1 field.
	EXTI_FTSR_TR1      = 0x2     // Bit TR1.
	EXTI_FTSR_TR2_Pos  = 0x2     // Position of TR2 field.
	EXTI_FTSR_TR2_Msk  = 0x4     // Bit mask of TR2 field.
	EXTI_FTSR_TR2      = 0x4     // Bit TR2.
	EXTI_FTSR_TR3_Pos  = 0x3     // Position of TR3 field.
	EXTI_FTSR_TR3_Msk  = 0x8     // Bit mask of TR3 field.
	EXTI_FTSR_TR3      = 0x8     // Bit TR3.
	EXTI_FTSR_TR4_Pos  = 0x4     // Position of TR4 field.
	EXTI_FTSR_TR4_Msk  = 0x10    // Bit mask of TR4 field.
	EXTI_FTSR_TR4      = 0x10    // Bit TR4.
	EXTI_FTSR_TR5_Pos  = 0x5     // Position of TR5 field.
	EXTI_FTSR_TR5_Msk  = 0x20    // Bit mask of TR5 field.
	EXTI_FTSR_TR5      = 0x20    // Bit TR5.
	EXTI_FTSR_TR6_Pos  = 0x6     // Position of TR6 field.
	EXTI_FTSR_TR6_Msk  = 0x40    // Bit mask of TR6 field.
	EXTI_FTSR_TR6      = 0x40    // Bit TR6.
	EXTI_FTSR_TR7_Pos  = 0x7     // Position of TR7 field.
	EXTI_FTSR_TR7_Msk  = 0x80    // Bit mask of TR7 field.
	EXTI_FTSR_TR7      = 0x80    // Bit TR7.
	EXTI_FTSR_TR8_Pos  = 0x8     // Position of TR8 field.
	EXTI_FTSR_TR8_Msk  = 0x100   // Bit mask of TR8 field.
	EXTI_FTSR_TR8      = 0x100   // Bit TR8.
	EXTI_FTSR_TR9_Pos  = 0x9     // Position of TR9 field.
	EXTI_FTSR_TR9_Msk  = 0x200   // Bit mask of TR9 field.
	EXTI_FTSR_TR9      = 0x200   // Bit TR9.
	EXTI_FTSR_TR10_Pos = 0xa     // Position of TR10 field.
	EXTI_FTSR_TR10_Msk = 0x400   // Bit mask of TR10 field.
	EXTI_FTSR_TR10     = 0x400   // Bit TR10.
	EXTI_FTSR_TR11_Pos = 0xb     // Position of TR11 field.
	EXTI_FTSR_TR11_Msk = 0x800   // Bit mask of TR11 field.
	EXTI_FTSR_TR11     = 0x800   // Bit TR11.
	EXTI_FTSR_TR12_Pos = 0xc     // Position of TR12 field.
	EXTI_FTSR_TR12_Msk = 0x1000  // Bit mask of TR12 field.
	EXTI_FTSR_TR12     = 0x1000  // Bit TR12.
	EXTI_FTSR_TR13_Pos = 0xd     // Position of TR13 field.
	EXTI_FTSR_TR13_Msk = 0x2000  // Bit mask of TR13 field.
	EXTI_FTSR_TR13     = 0x2000  // Bit TR13.
	EXTI_FTSR_TR14_Pos = 0xe     // Position of TR14 field.
	EXTI_FTSR_TR14_Msk = 0x4000  // Bit mask of TR14 field.
	EXTI_FTSR_TR14     = 0x4000  // Bit TR14.
	EXTI_FTSR_TR15_Pos = 0xf     // Position of TR15 field.
	EXTI_FTSR_TR15_Msk = 0x8000  // Bit mask of TR15 field.
	EXTI_FTSR_TR15     = 0x8000  // Bit TR15.
	EXTI_FTSR_TR16_Pos = 0x10    // Position of TR16 field.
	EXTI_FTSR_TR16_Msk = 0x10000 // Bit mask of TR16 field.
	EXTI_FTSR_TR16     = 0x10000 // Bit TR16.
	EXTI_FTSR_TR17_Pos = 0x11    // Position of TR17 field.
	EXTI_FTSR_TR17_Msk = 0x20000 // Bit mask of TR17 field.
	EXTI_FTSR_TR17     = 0x20000 // Bit TR17.

	// SWIER: Software interrupt event register           (EXTI_SWIER)
	EXTI_SWIER_SWIER0_Pos  = 0x0     // Position of SWIER0 field.
	EXTI_SWIER_SWIER0_Msk  = 0x1     // Bit mask of SWIER0 field.
	EXTI_SWIER_SWIER0      = 0x1     // Bit SWIER0.
	EXTI_SWIER_SWIER1_Pos  = 0x1     // Position of SWIER1 field.
	EXTI_SWIER_SWIER1_Msk  = 0x2     // Bit mask of SWIER1 field.
	EXTI_SWIER_SWIER1      = 0x2     // Bit SWIER1.
	EXTI_SWIER_SWIER2_Pos  = 0x2     // Position of SWIER2 field.
	EXTI_SWIER_SWIER2_Msk  = 0x4     // Bit mask of SWIER2 field.
	EXTI_SWIER_SWIER2      = 0x4     // Bit SWIER2.
	EXTI_SWIER_SWIER3_Pos  = 0x3     // Position of SWIER3 field.
	EXTI_SWIER_SWIER3_Msk  = 0x8     // Bit mask of SWIER3 field.
	EXTI_SWIER_SWIER3      = 0x8     // Bit SWIER3.
	EXTI_SWIER_SWIER4_Pos  = 0x4     // Position of SWIER4 field.
	EXTI_SWIER_SWIER4_Msk  = 0x10    // Bit mask of SWIER4 field.
	EXTI_SWIER_SWIER4      = 0x10    // Bit SWIER4.
	EXTI_SWIER_SWIER5_Pos  = 0x5     // Position of SWIER5 field.
	EXTI_SWIER_SWIER5_Msk  = 0x20    // Bit mask of SWIER5 field.
	EXTI_SWIER_SWIER5      = 0x20    // Bit SWIER5.
	EXTI_SWIER_SWIER6_Pos  = 0x6     // Position of SWIER6 field.
	EXTI_SWIER_SWIER6_Msk  = 0x40    // Bit mask of SWIER6 field.
	EXTI_SWIER_SWIER6      = 0x40    // Bit SWIER6.
	EXTI_SWIER_SWIER7_Pos  = 0x7     // Position of SWIER7 field.
	EXTI_SWIER_SWIER7_Msk  = 0x80    // Bit mask of SWIER7 field.
	EXTI_SWIER_SWIER7      = 0x80    // Bit SWIER7.
	EXTI_SWIER_SWIER8_Pos  = 0x8     // Position of SWIER8 field.
	EXTI_SWIER_SWIER8_Msk  = 0x100   // Bit mask of SWIER8 field.
	EXTI_SWIER_SWIER8      = 0x100   // Bit SWIER8.
	EXTI_SWIER_SWIER9_Pos  = 0x9     // Position of SWIER9 field.
	EXTI_SWIER_SWIER9_Msk  = 0x200   // Bit mask of SWIER9 field.
	EXTI_SWIER_SWIER9      = 0x200   // Bit SWIER9.
	EXTI_SWIER_SWIER10_Pos = 0xa     // Position of SWIER10 field.
	EXTI_SWIER_SWIER10_Msk = 0x400   // Bit mask of SWIER10 field.
	EXTI_SWIER_SWIER10     = 0x400   // Bit SWIER10.
	EXTI_SWIER_SWIER11_Pos = 0xb     // Position of SWIER11 field.
	EXTI_SWIER_SWIER11_Msk = 0x800   // Bit mask of SWIER11 field.
	EXTI_SWIER_SWIER11     = 0x800   // Bit SWIER11.
	EXTI_SWIER_SWIER12_Pos = 0xc     // Position of SWIER12 field.
	EXTI_SWIER_SWIER12_Msk = 0x1000  // Bit mask of SWIER12 field.
	EXTI_SWIER_SWIER12     = 0x1000  // Bit SWIER12.
	EXTI_SWIER_SWIER13_Pos = 0xd     // Position of SWIER13 field.
	EXTI_SWIER_SWIER13_Msk = 0x2000  // Bit mask of SWIER13 field.
	EXTI_SWIER_SWIER13     = 0x2000  // Bit SWIER13.
	EXTI_SWIER_SWIER14_Pos = 0xe     // Position of SWIER14 field.
	EXTI_SWIER_SWIER14_Msk = 0x4000  // Bit mask of SWIER14 field.
	EXTI_SWIER_SWIER14     = 0x4000  // Bit SWIER14.
	EXTI_SWIER_SWIER15_Pos = 0xf     // Position of SWIER15 field.
	EXTI_SWIER_SWIER15_Msk = 0x8000  // Bit mask of SWIER15 field.
	EXTI_SWIER_SWIER15     = 0x8000  // Bit SWIER15.
	EXTI_SWIER_SWIER16_Pos = 0x10    // Position of SWIER16 field.
	EXTI_SWIER_SWIER16_Msk = 0x10000 // Bit mask of SWIER16 field.
	EXTI_SWIER_SWIER16     = 0x10000 // Bit SWIER16.
	EXTI_SWIER_SWIER17_Pos = 0x11    // Position of SWIER17 field.
	EXTI_SWIER_SWIER17_Msk = 0x20000 // Bit mask of SWIER17 field.
	EXTI_SWIER_SWIER17     = 0x20000 // Bit SWIER17.

	// PR: Pending register (EXTI_PR)
	EXTI_PR_PR0_Pos  = 0x0     // Position of PR0 field.
	EXTI_PR_PR0_Msk  = 0x1     // Bit mask of PR0 field.
	EXTI_PR_PR0      = 0x1     // Bit PR0.
	EXTI_PR_PR1_Pos  = 0x1     // Position of PR1 field.
	EXTI_PR_PR1_Msk  = 0x2     // Bit mask of PR1 field.
	EXTI_PR_PR1      = 0x2     // Bit PR1.
	EXTI_PR_PR2_Pos  = 0x2     // Position of PR2 field.
	EXTI_PR_PR2_Msk  = 0x4     // Bit mask of PR2 field.
	EXTI_PR_PR2      = 0x4     // Bit PR2.
	EXTI_PR_PR3_Pos  = 0x3     // Position of PR3 field.
	EXTI_PR_PR3_Msk  = 0x8     // Bit mask of PR3 field.
	EXTI_PR_PR3      = 0x8     // Bit PR3.
	EXTI_PR_PR4_Pos  = 0x4     // Position of PR4 field.
	EXTI_PR_PR4_Msk  = 0x10    // Bit mask of PR4 field.
	EXTI_PR_PR4      = 0x10    // Bit PR4.
	EXTI_PR_PR5_Pos  = 0x5     // Position of PR5 field.
	EXTI_PR_PR5_Msk  = 0x20    // Bit mask of PR5 field.
	EXTI_PR_PR5      = 0x20    // Bit PR5.
	EXTI_PR_PR6_Pos  = 0x6     // Position of PR6 field.
	EXTI_PR_PR6_Msk  = 0x40    // Bit mask of PR6 field.
	EXTI_PR_PR6      = 0x40    // Bit PR6.
	EXTI_PR_PR7_Pos  = 0x7     // Position of PR7 field.
	EXTI_PR_PR7_Msk  = 0x80    // Bit mask of PR7 field.
	EXTI_PR_PR7      = 0x80    // Bit PR7.
	EXTI_PR_PR8_Pos  = 0x8     // Position of PR8 field.
	EXTI_PR_PR8_Msk  = 0x100   // Bit mask of PR8 field.
	EXTI_PR_PR8      = 0x100   // Bit PR8.
	EXTI_PR_PR9_Pos  = 0x9     // Position of PR9 field.
	EXTI_PR_PR9_Msk  = 0x200   // Bit mask of PR9 field.
	EXTI_PR_PR9      = 0x200   // Bit PR9.
	EXTI_PR_PR10_Pos = 0xa     // Position of PR10 field.
	EXTI_PR_PR10_Msk = 0x400   // Bit mask of PR10 field.
	EXTI_PR_PR10     = 0x400   // Bit PR10.
	EXTI_PR_PR11_Pos = 0xb     // Position of PR11 field.
	EXTI_PR_PR11_Msk = 0x800   // Bit mask of PR11 field.
	EXTI_PR_PR11     = 0x800   // Bit PR11.
	EXTI_PR_PR12_Pos = 0xc     // Position of PR12 field.
	EXTI_PR_PR12_Msk = 0x1000  // Bit mask of PR12 field.
	EXTI_PR_PR12     = 0x1000  // Bit PR12.
	EXTI_PR_PR13_Pos = 0xd     // Position of PR13 field.
	EXTI_PR_PR13_Msk = 0x2000  // Bit mask of PR13 field.
	EXTI_PR_PR13     = 0x2000  // Bit PR13.
	EXTI_PR_PR14_Pos = 0xe     // Position of PR14 field.
	EXTI_PR_PR14_Msk = 0x4000  // Bit mask of PR14 field.
	EXTI_PR_PR14     = 0x4000  // Bit PR14.
	EXTI_PR_PR15_Pos = 0xf     // Position of PR15 field.
	EXTI_PR_PR15_Msk = 0x8000  // Bit mask of PR15 field.
	EXTI_PR_PR15     = 0x8000  // Bit PR15.
	EXTI_PR_PR16_Pos = 0x10    // Position of PR16 field.
	EXTI_PR_PR16_Msk = 0x10000 // Bit mask of PR16 field.
	EXTI_PR_PR16     = 0x10000 // Bit PR16.
	EXTI_PR_PR17_Pos = 0x11    // Position of PR17 field.
	EXTI_PR_PR17_Msk = 0x20000 // Bit mask of PR17 field.
	EXTI_PR_PR17     = 0x20000 // Bit PR17.
)

// Bitfields for DMA1: DMA controller
const (
	// ISR: DMA interrupt status register           (DMA_ISR)
	DMA_ISR_GIF1_Pos  = 0x0       // Position of GIF1 field.
	DMA_ISR_GIF1_Msk  = 0x1       // Bit mask of GIF1 field.
	DMA_ISR_GIF1      = 0x1       // Bit GIF1.
	DMA_ISR_TCIF1_Pos = 0x1       // Position of TCIF1 field.
	DMA_ISR_TCIF1_Msk = 0x2       // Bit mask of TCIF1 field.
	DMA_ISR_TCIF1     = 0x2       // Bit TCIF1.
	DMA_ISR_HTIF1_Pos = 0x2       // Position of HTIF1 field.
	DMA_ISR_HTIF1_Msk = 0x4       // Bit mask of HTIF1 field.
	DMA_ISR_HTIF1     = 0x4       // Bit HTIF1.
	DMA_ISR_TEIF1_Pos = 0x3       // Position of TEIF1 field.
	DMA_ISR_TEIF1_Msk = 0x8       // Bit mask of TEIF1 field.
	DMA_ISR_TEIF1     = 0x8       // Bit TEIF1.
	DMA_ISR_GIF2_Pos  = 0x4       // Position of GIF2 field.
	DMA_ISR_GIF2_Msk  = 0x10      // Bit mask of GIF2 field.
	DMA_ISR_GIF2      = 0x10      // Bit GIF2.
	DMA_ISR_TCIF2_Pos = 0x5       // Position of TCIF2 field.
	DMA_ISR_TCIF2_Msk = 0x20      // Bit mask of TCIF2 field.
	DMA_ISR_TCIF2     = 0x20      // Bit TCIF2.
	DMA_ISR_HTIF2_Pos = 0x6       // Position of HTIF2 field.
	DMA_ISR_HTIF2_Msk = 0x40      // Bit mask of HTIF2 field.
	DMA_ISR_HTIF2     = 0x40      // Bit HTIF2.
	DMA_ISR_TEIF2_Pos = 0x7       // Position of TEIF2 field.
	DMA_ISR_TEIF2_Msk = 0x80      // Bit mask of TEIF2 field.
	DMA_ISR_TEIF2     = 0x80      // Bit TEIF2.
	DMA_ISR_GIF3_Pos  = 0x8       // Position of GIF3 field.
	DMA_ISR_GIF3_Msk  = 0x100     // Bit mask of GIF3 field.
	DMA_ISR_GIF3      = 0x100     // Bit GIF3.
	DMA_ISR_TCIF3_Pos = 0x9       // Position of TCIF3 field.
	DMA_ISR_TCIF3_Msk = 0x200     // Bit mask of TCIF3 field.
	DMA_ISR_TCIF3     = 0x200     // Bit TCIF3.
	DMA_ISR_HTIF3_Pos = 0xa       // Position of HTIF3 field.
	DMA_ISR_HTIF3_Msk = 0x400     // Bit mask of HTIF3 field.
	DMA_ISR_HTIF3     = 0x400     // Bit HTIF3.
	DMA_ISR_TEIF3_Pos = 0xb       // Position of TEIF3 field.
	DMA_ISR_TEIF3_Msk = 0x800     // Bit mask of TEIF3 field.
	DMA_ISR_TEIF3     = 0x800     // Bit TEIF3.
	DMA_ISR_GIF4_Pos  = 0xc       // Position of GIF4 field.
	DMA_ISR_GIF4_Msk  = 0x1000    // Bit mask of GIF4 field.
	DMA_ISR_GIF4      = 0x1000    // Bit GIF4.
	DMA_ISR_TCIF4_Pos = 0xd       // Position of TCIF4 field.
	DMA_ISR_TCIF4_Msk = 0x2000    // Bit mask of TCIF4 field.
	DMA_ISR_TCIF4     = 0x2000    // Bit TCIF4.
	DMA_ISR_HTIF4_Pos = 0xe       // Position of HTIF4 field.
	DMA_ISR_HTIF4_Msk = 0x4000    // Bit mask of HTIF4 field.
	DMA_ISR_HTIF4     = 0x4000    // Bit HTIF4.
	DMA_ISR_TEIF4_Pos = 0xf       // Position of TEIF4 field.
	DMA_ISR_TEIF4_Msk = 0x8000    // Bit mask of TEIF4 field.
	DMA_ISR_TEIF4     = 0x8000    // Bit TEIF4.
	DMA_ISR_GIF5_Pos  = 0x10      // Position of GIF5 field.
	DMA_ISR_GIF5_Msk  = 0x10000   // Bit mask of GIF5 field.
	DMA_ISR_GIF5      = 0x10000   // Bit GIF5.
	DMA_ISR_TCIF5_Pos = 0x11      // Position of TCIF5 field.
	DMA_ISR_TCIF5_Msk = 0x20000   // Bit mask of TCIF5 field.
	DMA_ISR_TCIF5     = 0x20000   // Bit TCIF5.
	DMA_ISR_HTIF5_Pos = 0x12      // Position of HTIF5 field.
	DMA_ISR_HTIF5_Msk = 0x40000   // Bit mask of HTIF5 field.
	DMA_ISR_HTIF5     = 0x40000   // Bit HTIF5.
	DMA_ISR_TEIF5_Pos = 0x13      // Position of TEIF5 field.
	DMA_ISR_TEIF5_Msk = 0x80000   // Bit mask of TEIF5 field.
	DMA_ISR_TEIF5     = 0x80000   // Bit TEIF5.
	DMA_ISR_GIF6_Pos  = 0x14      // Position of GIF6 field.
	DMA_ISR_GIF6_Msk  = 0x100000  // Bit mask of GIF6 field.
	DMA_ISR_GIF6      = 0x100000  // Bit GIF6.
	DMA_ISR_TCIF6_Pos = 0x15      // Position of TCIF6 field.
	DMA_ISR_TCIF6_Msk = 0x200000  // Bit mask of TCIF6 field.
	DMA_ISR_TCIF6     = 0x200000  // Bit TCIF6.
	DMA_ISR_HTIF6_Pos = 0x16      // Position of HTIF6 field.
	DMA_ISR_HTIF6_Msk = 0x400000  // Bit mask of HTIF6 field.
	DMA_ISR_HTIF6     = 0x400000  // Bit HTIF6.
	DMA_ISR_TEIF6_Pos = 0x17      // Position of TEIF6 field.
	DMA_ISR_TEIF6_Msk = 0x800000  // Bit mask of TEIF6 field.
	DMA_ISR_TEIF6     = 0x800000  // Bit TEIF6.
	DMA_ISR_GIF7_Pos  = 0x18      // Position of GIF7 field.
	DMA_ISR_GIF7_Msk  = 0x1000000 // Bit mask of GIF7 field.
	DMA_ISR_GIF7      = 0x1000000 // Bit GIF7.
	DMA_ISR_TCIF7_Pos = 0x19      // Position of TCIF7 field.
	DMA_ISR_TCIF7_Msk = 0x2000000 // Bit mask of TCIF7 field.
	DMA_ISR_TCIF7     = 0x2000000 // Bit TCIF7.
	DMA_ISR_HTIF7_Pos = 0x1a      // Position of HTIF7 field.
	DMA_ISR_HTIF7_Msk = 0x4000000 // Bit mask of HTIF7 field.
	DMA_ISR_HTIF7     = 0x4000000 // Bit HTIF7.
	DMA_ISR_TEIF7_Pos = 0x1b      // Position of TEIF7 field.
	DMA_ISR_TEIF7_Msk = 0x8000000 // Bit mask of TEIF7 field.
	DMA_ISR_TEIF7     = 0x8000000 // Bit TEIF7.

	// IFCR: DMA interrupt flag clear register           (DMA_IFCR)
	DMA_IFCR_CGIF1_Pos  = 0x0       // Position of CGIF1 field.
	DMA_IFCR_CGIF1_Msk  = 0x1       // Bit mask of CGIF1 field.
	DMA_IFCR_CGIF1      = 0x1       // Bit CGIF1.
	DMA_IFCR_CGIF2_Pos  = 0x4       // Position of CGIF2 field.
	DMA_IFCR_CGIF2_Msk  = 0x10      // Bit mask of CGIF2 field.
	DMA_IFCR_CGIF2      = 0x10      // Bit CGIF2.
	DMA_IFCR_CGIF3_Pos  = 0x8       // Position of CGIF3 field.
	DMA_IFCR_CGIF3_Msk  = 0x100     // Bit mask of CGIF3 field.
	DMA_IFCR_CGIF3      = 0x100     // Bit CGIF3.
	DMA_IFCR_CGIF4_Pos  = 0xc       // Position of CGIF4 field.
	DMA_IFCR_CGIF4_Msk  = 0x1000    // Bit mask of CGIF4 field.
	DMA_IFCR_CGIF4      = 0x1000    // Bit CGIF4.
	DMA_IFCR_CGIF5_Pos  = 0x10      // Position of CGIF5 field.
	DMA_IFCR_CGIF5_Msk  = 0x10000   // Bit mask of CGIF5 field.
	DMA_IFCR_CGIF5      = 0x10000   // Bit CGIF5.
	DMA_IFCR_CGIF6_Pos  = 0x14      // Position of CGIF6 field.
	DMA_IFCR_CGIF6_Msk  = 0x100000  // Bit mask of CGIF6 field.
	DMA_IFCR_CGIF6      = 0x100000  // Bit CGIF6.
	DMA_IFCR_CGIF7_Pos  = 0x18      // Position of CGIF7 field.
	DMA_IFCR_CGIF7_Msk  = 0x1000000 // Bit mask of CGIF7 field.
	DMA_IFCR_CGIF7      = 0x1000000 // Bit CGIF7.
	DMA_IFCR_CTCIF1_Pos = 0x1       // Position of CTCIF1 field.
	DMA_IFCR_CTCIF1_Msk = 0x2       // Bit mask of CTCIF1 field.
	DMA_IFCR_CTCIF1     = 0x2       // Bit CTCIF1.
	DMA_IFCR_CTCIF2_Pos = 0x5       // Position of CTCIF2 field.
	DMA_IFCR_CTCIF2_Msk = 0x20      // Bit mask of CTCIF2 field.
	DMA_IFCR_CTCIF2     = 0x20      // Bit CTCIF2.
	DMA_IFCR_CTCIF3_Pos = 0x9       // Position of CTCIF3 field.
	DMA_IFCR_CTCIF3_Msk = 0x200     // Bit mask of CTCIF3 field.
	DMA_IFCR_CTCIF3     = 0x200     // Bit CTCIF3.
	DMA_IFCR_CTCIF4_Pos = 0xd       // Position of CTCIF4 field.
	DMA_IFCR_CTCIF4_Msk = 0x2000    // Bit mask of CTCIF4 field.
	DMA_IFCR_CTCIF4     = 0x2000    // Bit CTCIF4.
	DMA_IFCR_CTCIF5_Pos = 0x11      // Position of CTCIF5 field.
	DMA_IFCR_CTCIF5_Msk = 0x20000   // Bit mask of CTCIF5 field.
	DMA_IFCR_CTCIF5     = 0x20000   // Bit CTCIF5.
	DMA_IFCR_CTCIF6_Pos = 0x15      // Position of CTCIF6 field.
	DMA_IFCR_CTCIF6_Msk = 0x200000  // Bit mask of CTCIF6 field.
	DMA_IFCR_CTCIF6     = 0x200000  // Bit CTCIF6.
	DMA_IFCR_CTCIF7_Pos = 0x19      // Position of CTCIF7 field.
	DMA_IFCR_CTCIF7_Msk = 0x2000000 // Bit mask of CTCIF7 field.
	DMA_IFCR_CTCIF7     = 0x2000000 // Bit CTCIF7.
	DMA_IFCR_CHTIF1_Pos = 0x2       // Position of CHTIF1 field.
	DMA_IFCR_CHTIF1_Msk = 0x4       // Bit mask of CHTIF1 field.
	DMA_IFCR_CHTIF1     = 0x4       // Bit CHTIF1.
	DMA_IFCR_CHTIF2_Pos = 0x6       // Position of CHTIF2 field.
	DMA_IFCR_CHTIF2_Msk = 0x40      // Bit mask of CHTIF2 field.
	DMA_IFCR_CHTIF2     = 0x40      // Bit CHTIF2.
	DMA_IFCR_CHTIF3_Pos = 0xa       // Position of CHTIF3 field.
	DMA_IFCR_CHTIF3_Msk = 0x400     // Bit mask of CHTIF3 field.
	DMA_IFCR_CHTIF3     = 0x400     // Bit CHTIF3.
	DMA_IFCR_CHTIF4_Pos = 0xe       // Position of CHTIF4 field.
	DMA_IFCR_CHTIF4_Msk = 0x4000    // Bit mask of CHTIF4 field.
	DMA_IFCR_CHTIF4     = 0x4000    // Bit CHTIF4.
	DMA_IFCR_CHTIF5_Pos = 0x12      // Position of CHTIF5 field.
	DMA_IFCR_CHTIF5_Msk = 0x40000   // Bit mask of CHTIF5 field.
	DMA_IFCR_CHTIF5     = 0x40000   // Bit CHTIF5.
	DMA_IFCR_CHTIF6_Pos = 0x16      // Position of CHTIF6 field.
	DMA_IFCR_CHTIF6_Msk = 0x400000  // Bit mask of CHTIF6 field.
	DMA_IFCR_CHTIF6     = 0x400000  // Bit CHTIF6.
	DMA_IFCR_CHTIF7_Pos = 0x1a      // Position of CHTIF7 field.
	DMA_IFCR_CHTIF7_Msk = 0x4000000 // Bit mask of CHTIF7 field.
	DMA_IFCR_CHTIF7     = 0x4000000 // Bit CHTIF7.
	DMA_IFCR_CTEIF1_Pos = 0x3       // Position of CTEIF1 field.
	DMA_IFCR_CTEIF1_Msk = 0x8       // Bit mask of CTEIF1 field.
	DMA_IFCR_CTEIF1     = 0x8       // Bit CTEIF1.
	DMA_IFCR_CTEIF2_Pos = 0x7       // Position of CTEIF2 field.
	DMA_IFCR_CTEIF2_Msk = 0x80      // Bit mask of CTEIF2 field.
	DMA_IFCR_CTEIF2     = 0x80      // Bit CTEIF2.
	DMA_IFCR_CTEIF3_Pos = 0xb       // Position of CTEIF3 field.
	DMA_IFCR_CTEIF3_Msk = 0x800     // Bit mask of CTEIF3 field.
	DMA_IFCR_CTEIF3     = 0x800     // Bit CTEIF3.
	DMA_IFCR_CTEIF4_Pos = 0xf       // Position of CTEIF4 field.
	DMA_IFCR_CTEIF4_Msk = 0x8000    // Bit mask of CTEIF4 field.
	DMA_IFCR_CTEIF4     = 0x8000    // Bit CTEIF4.
	DMA_IFCR_CTEIF5_Pos = 0x13      // Position of CTEIF5 field.
	DMA_IFCR_CTEIF5_Msk = 0x80000   // Bit mask of CTEIF5 field.
	DMA_IFCR_CTEIF5     = 0x80000   // Bit CTEIF5.
	DMA_IFCR_CTEIF6_Pos = 0x17      // Position of CTEIF6 field.
	DMA_IFCR_CTEIF6_Msk = 0x800000  // Bit mask of CTEIF6 field.
	DMA_IFCR_CTEIF6     = 0x800000  // Bit CTEIF6.
	DMA_IFCR_CTEIF7_Pos = 0x1b      // Position of CTEIF7 field.
	DMA_IFCR_CTEIF7_Msk = 0x8000000 // Bit mask of CTEIF7 field.
	DMA_IFCR_CTEIF7     = 0x8000000 // Bit CTEIF7.

	// CCR1: DMA channel configuration register           (DMA_CCR)
	DMA_CCR1_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR1_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR1_EN          = 0x1    // Bit EN.
	DMA_CCR1_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR1_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR1_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR1_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR1_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR1_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR1_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR1_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR1_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR1_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR1_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR1_DIR         = 0x10   // Bit DIR.
	DMA_CCR1_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR1_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR1_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR1_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR1_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR1_PINC        = 0x40   // Bit PINC.
	DMA_CCR1_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR1_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR1_MINC        = 0x80   // Bit MINC.
	DMA_CCR1_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR1_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR1_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR1_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR1_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR1_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR1_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR1_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR1_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR1: DMA channel 1 number of data           register
	DMA_CNDTR1_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR1_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR1: DMA channel 1 peripheral address           register
	DMA_CPAR1_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR1_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR1: DMA channel 1 memory address           register
	DMA_CMAR1_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR1_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR2: DMA channel configuration register           (DMA_CCR)
	DMA_CCR2_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR2_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR2_EN          = 0x1    // Bit EN.
	DMA_CCR2_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR2_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR2_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR2_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR2_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR2_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR2_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR2_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR2_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR2_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR2_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR2_DIR         = 0x10   // Bit DIR.
	DMA_CCR2_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR2_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR2_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR2_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR2_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR2_PINC        = 0x40   // Bit PINC.
	DMA_CCR2_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR2_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR2_MINC        = 0x80   // Bit MINC.
	DMA_CCR2_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR2_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR2_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR2_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR2_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR2_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR2_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR2_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR2_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR2: DMA channel 2 number of data           register
	DMA_CNDTR2_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR2_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR2: DMA channel 2 peripheral address           register
	DMA_CPAR2_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR2_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR2: DMA channel 2 memory address           register
	DMA_CMAR2_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR2_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR3: DMA channel configuration register           (DMA_CCR)
	DMA_CCR3_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR3_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR3_EN          = 0x1    // Bit EN.
	DMA_CCR3_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR3_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR3_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR3_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR3_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR3_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR3_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR3_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR3_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR3_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR3_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR3_DIR         = 0x10   // Bit DIR.
	DMA_CCR3_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR3_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR3_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR3_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR3_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR3_PINC        = 0x40   // Bit PINC.
	DMA_CCR3_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR3_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR3_MINC        = 0x80   // Bit MINC.
	DMA_CCR3_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR3_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR3_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR3_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR3_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR3_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR3_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR3_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR3_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR3: DMA channel 3 number of data           register
	DMA_CNDTR3_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR3_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR3: DMA channel 3 peripheral address           register
	DMA_CPAR3_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR3_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR3: DMA channel 3 memory address           register
	DMA_CMAR3_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR3_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR4: DMA channel configuration register           (DMA_CCR)
	DMA_CCR4_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR4_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR4_EN          = 0x1    // Bit EN.
	DMA_CCR4_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR4_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR4_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR4_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR4_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR4_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR4_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR4_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR4_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR4_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR4_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR4_DIR         = 0x10   // Bit DIR.
	DMA_CCR4_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR4_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR4_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR4_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR4_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR4_PINC        = 0x40   // Bit PINC.
	DMA_CCR4_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR4_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR4_MINC        = 0x80   // Bit MINC.
	DMA_CCR4_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR4_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR4_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR4_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR4_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR4_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR4_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR4_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR4_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR4: DMA channel 4 number of data           register
	DMA_CNDTR4_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR4_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR4: DMA channel 4 peripheral address           register
	DMA_CPAR4_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR4_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR4: DMA channel 4 memory address           register
	DMA_CMAR4_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR4_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR5: DMA channel configuration register           (DMA_CCR)
	DMA_CCR5_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR5_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR5_EN          = 0x1    // Bit EN.
	DMA_CCR5_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR5_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR5_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR5_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR5_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR5_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR5_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR5_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR5_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR5_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR5_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR5_DIR         = 0x10   // Bit DIR.
	DMA_CCR5_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR5_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR5_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR5_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR5_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR5_PINC        = 0x40   // Bit PINC.
	DMA_CCR5_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR5_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR5_MINC        = 0x80   // Bit MINC.
	DMA_CCR5_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR5_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR5_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR5_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR5_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR5_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR5_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR5_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR5_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR5: DMA channel 5 number of data           register
	DMA_CNDTR5_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR5_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR5: DMA channel 5 peripheral address           register
	DMA_CPAR5_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR5_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR5: DMA channel 5 memory address           register
	DMA_CMAR5_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR5_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR6: DMA channel configuration register           (DMA_CCR)
	DMA_CCR6_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR6_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR6_EN          = 0x1    // Bit EN.
	DMA_CCR6_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR6_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR6_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR6_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR6_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR6_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR6_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR6_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR6_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR6_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR6_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR6_DIR         = 0x10   // Bit DIR.
	DMA_CCR6_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR6_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR6_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR6_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR6_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR6_PINC        = 0x40   // Bit PINC.
	DMA_CCR6_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR6_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR6_MINC        = 0x80   // Bit MINC.
	DMA_CCR6_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR6_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR6_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR6_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR6_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR6_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR6_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR6_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR6_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR6: DMA channel 6 number of data           register
	DMA_CNDTR6_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR6_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR6: DMA channel 6 peripheral address           register
	DMA_CPAR6_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR6_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR6: DMA channel 6 memory address           register
	DMA_CMAR6_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR6_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR7: DMA channel configuration register           (DMA_CCR)
	DMA_CCR7_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR7_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR7_EN          = 0x1    // Bit EN.
	DMA_CCR7_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR7_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR7_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR7_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR7_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR7_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR7_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR7_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR7_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR7_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR7_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR7_DIR         = 0x10   // Bit DIR.
	DMA_CCR7_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR7_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR7_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR7_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR7_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR7_PINC        = 0x40   // Bit PINC.
	DMA_CCR7_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR7_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR7_MINC        = 0x80   // Bit MINC.
	DMA_CCR7_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR7_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR7_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR7_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR7_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR7_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR7_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR7_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR7_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR7: DMA channel 7 number of data           register
	DMA_CNDTR7_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR7_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR7: DMA channel 7 peripheral address           register
	DMA_CPAR7_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR7_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR7: DMA channel 7 memory address           register
	DMA_CMAR7_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR7_MA_Msk = 0xffffffff // Bit mask of MA field.
)

// Bitfields for RTC: Real time clock
const (
	// CRH: RTC Control Register High
	RTC_CRH_SECIE_Pos = 0x0 // Position of SECIE field.
	RTC_CRH_SECIE_Msk = 0x1 // Bit mask of SECIE field.
	RTC_CRH_SECIE     = 0x1 // Bit SECIE.
	RTC_CRH_ALRIE_Pos = 0x1 // Position of ALRIE field.
	RTC_CRH_ALRIE_Msk = 0x2 // Bit mask of ALRIE field.
	RTC_CRH_ALRIE     = 0x2 // Bit ALRIE.
	RTC_CRH_OWIE_Pos  = 0x2 // Position of OWIE field.
	RTC_CRH_OWIE_Msk  = 0x4 // Bit mask of OWIE field.
	RTC_CRH_OWIE      = 0x4 // Bit OWIE.

	// CRL: RTC Control Register Low
	RTC_CRL_SECF_Pos  = 0x0  // Position of SECF field.
	RTC_CRL_SECF_Msk  = 0x1  // Bit mask of SECF field.
	RTC_CRL_SECF      = 0x1  // Bit SECF.
	RTC_CRL_ALRF_Pos  = 0x1  // Position of ALRF field.
	RTC_CRL_ALRF_Msk  = 0x2  // Bit mask of ALRF field.
	RTC_CRL_ALRF      = 0x2  // Bit ALRF.
	RTC_CRL_OWF_Pos   = 0x2  // Position of OWF field.
	RTC_CRL_OWF_Msk   = 0x4  // Bit mask of OWF field.
	RTC_CRL_OWF       = 0x4  // Bit OWF.
	RTC_CRL_RSF_Pos   = 0x3  // Position of RSF field.
	RTC_CRL_RSF_Msk   = 0x8  // Bit mask of RSF field.
	RTC_CRL_RSF       = 0x8  // Bit RSF.
	RTC_CRL_CNF_Pos   = 0x4  // Position of CNF field.
	RTC_CRL_CNF_Msk   = 0x10 // Bit mask of CNF field.
	RTC_CRL_CNF       = 0x10 // Bit CNF.
	RTC_CRL_RTOFF_Pos = 0x5  // Position of RTOFF field.
	RTC_CRL_RTOFF_Msk = 0x20 // Bit mask of RTOFF field.
	RTC_CRL_RTOFF     = 0x20 // Bit RTOFF.

	// PRLH: RTC Prescaler Load Register           High
	RTC_PRLH_PRLH_Pos = 0x0 // Position of PRLH field.
	RTC_PRLH_PRLH_Msk = 0xf // Bit mask of PRLH field.

	// PRLL: RTC Prescaler Load Register           Low
	RTC_PRLL_PRLL_Pos = 0x0    // Position of PRLL field.
	RTC_PRLL_PRLL_Msk = 0xffff // Bit mask of PRLL field.

	// DIVH: RTC Prescaler Divider Register           High
	RTC_DIVH_DIVH_Pos = 0x0 // Position of DIVH field.
	RTC_DIVH_DIVH_Msk = 0xf // Bit mask of DIVH field.

	// DIVL: RTC Prescaler Divider Register           Low
	RTC_DIVL_DIVL_Pos = 0x0    // Position of DIVL field.
	RTC_DIVL_DIVL_Msk = 0xffff // Bit mask of DIVL field.

	// CNTH: RTC Counter Register High
	RTC_CNTH_CNTH_Pos = 0x0    // Position of CNTH field.
	RTC_CNTH_CNTH_Msk = 0xffff // Bit mask of CNTH field.

	// CNTL: RTC Counter Register Low
	RTC_CNTL_CNTL_Pos = 0x0    // Position of CNTL field.
	RTC_CNTL_CNTL_Msk = 0xffff // Bit mask of CNTL field.

	// ALRH: RTC Alarm Register High
	RTC_ALRH_ALRH_Pos = 0x0    // Position of ALRH field.
	RTC_ALRH_ALRH_Msk = 0xffff // Bit mask of ALRH field.

	// ALRL: RTC Alarm Register Low
	RTC_ALRL_ALRL_Pos = 0x0    // Position of ALRL field.
	RTC_ALRL_ALRL_Msk = 0xffff // Bit mask of ALRL field.
)

// Bitfields for BKP: Backup registers
const (
	// DR1: Backup data register (BKP_DR)
	BKP_DR1_D1_Pos = 0x0    // Position of D1 field.
	BKP_DR1_D1_Msk = 0xffff // Bit mask of D1 field.

	// DR2: Backup data register (BKP_DR)
	BKP_DR2_D2_Pos = 0x0    // Position of D2 field.
	BKP_DR2_D2_Msk = 0xffff // Bit mask of D2 field.

	// DR3: Backup data register (BKP_DR)
	BKP_DR3_D3_Pos = 0x0    // Position of D3 field.
	BKP_DR3_D3_Msk = 0xffff // Bit mask of D3 field.

	// DR4: Backup data register (BKP_DR)
	BKP_DR4_D4_Pos = 0x0    // Position of D4 field.
	BKP_DR4_D4_Msk = 0xffff // Bit mask of D4 field.

	// DR5: Backup data register (BKP_DR)
	BKP_DR5_D5_Pos = 0x0    // Position of D5 field.
	BKP_DR5_D5_Msk = 0xffff // Bit mask of D5 field.

	// DR6: Backup data register (BKP_DR)
	BKP_DR6_D6_Pos = 0x0    // Position of D6 field.
	BKP_DR6_D6_Msk = 0xffff // Bit mask of D6 field.

	// DR7: Backup data register (BKP_DR)
	BKP_DR7_D7_Pos = 0x0    // Position of D7 field.
	BKP_DR7_D7_Msk = 0xffff // Bit mask of D7 field.

	// DR8: Backup data register (BKP_DR)
	BKP_DR8_D8_Pos = 0x0    // Position of D8 field.
	BKP_DR8_D8_Msk = 0xffff // Bit mask of D8 field.

	// DR9: Backup data register (BKP_DR)
	BKP_DR9_D9_Pos = 0x0    // Position of D9 field.
	BKP_DR9_D9_Msk = 0xffff // Bit mask of D9 field.

	// DR10: Backup data register (BKP_DR)
	BKP_DR10_D10_Pos = 0x0    // Position of D10 field.
	BKP_DR10_D10_Msk = 0xffff // Bit mask of D10 field.

	// RTCCR: RTC clock calibration register           (BKP_RTCCR)
	BKP_RTCCR_CAL_Pos  = 0x0   // Position of CAL field.
	BKP_RTCCR_CAL_Msk  = 0x7f  // Bit mask of CAL field.
	BKP_RTCCR_CCO_Pos  = 0x7   // Position of CCO field.
	BKP_RTCCR_CCO_Msk  = 0x80  // Bit mask of CCO field.
	BKP_RTCCR_CCO      = 0x80  // Bit CCO.
	BKP_RTCCR_ASOE_Pos = 0x8   // Position of ASOE field.
	BKP_RTCCR_ASOE_Msk = 0x100 // Bit mask of ASOE field.
	BKP_RTCCR_ASOE     = 0x100 // Bit ASOE.
	BKP_RTCCR_ASOS_Pos = 0x9   // Position of ASOS field.
	BKP_RTCCR_ASOS_Msk = 0x200 // Bit mask of ASOS field.
	BKP_RTCCR_ASOS     = 0x200 // Bit ASOS.

	// CR: Backup control register           (BKP_CR)
	BKP_CR_TPE_Pos  = 0x0 // Position of TPE field.
	BKP_CR_TPE_Msk  = 0x1 // Bit mask of TPE field.
	BKP_CR_TPE      = 0x1 // Bit TPE.
	BKP_CR_TPAL_Pos = 0x1 // Position of TPAL field.
	BKP_CR_TPAL_Msk = 0x2 // Bit mask of TPAL field.
	BKP_CR_TPAL     = 0x2 // Bit TPAL.

	// CSR: BKP_CSR control/status register           (BKP_CSR)
	BKP_CSR_CTE_Pos  = 0x0   // Position of CTE field.
	BKP_CSR_CTE_Msk  = 0x1   // Bit mask of CTE field.
	BKP_CSR_CTE      = 0x1   // Bit CTE.
	BKP_CSR_CTI_Pos  = 0x1   // Position of CTI field.
	BKP_CSR_CTI_Msk  = 0x2   // Bit mask of CTI field.
	BKP_CSR_CTI      = 0x2   // Bit CTI.
	BKP_CSR_TPIE_Pos = 0x2   // Position of TPIE field.
	BKP_CSR_TPIE_Msk = 0x4   // Bit mask of TPIE field.
	BKP_CSR_TPIE     = 0x4   // Bit TPIE.
	BKP_CSR_TEF_Pos  = 0x8   // Position of TEF field.
	BKP_CSR_TEF_Msk  = 0x100 // Bit mask of TEF field.
	BKP_CSR_TEF      = 0x100 // Bit TEF.
	BKP_CSR_TIF_Pos  = 0x9   // Position of TIF field.
	BKP_CSR_TIF_Msk  = 0x200 // Bit mask of TIF field.
	BKP_CSR_TIF      = 0x200 // Bit TIF.

	// DR11: Backup data register (BKP_DR)
	BKP_DR11_DR11_Pos = 0x0    // Position of DR11 field.
	BKP_DR11_DR11_Msk = 0xffff // Bit mask of DR11 field.

	// DR12: Backup data register (BKP_DR)
	BKP_DR12_DR12_Pos = 0x0    // Position of DR12 field.
	BKP_DR12_DR12_Msk = 0xffff // Bit mask of DR12 field.

	// DR13: Backup data register (BKP_DR)
	BKP_DR13_DR13_Pos = 0x0    // Position of DR13 field.
	BKP_DR13_DR13_Msk = 0xffff // Bit mask of DR13 field.

	// DR14: Backup data register (BKP_DR)
	BKP_DR14_D14_Pos = 0x0    // Position of D14 field.
	BKP_DR14_D14_Msk = 0xffff // Bit mask of D14 field.

	// DR15: Backup data register (BKP_DR)
	BKP_DR15_D15_Pos = 0x0    // Position of D15 field.
	BKP_DR15_D15_Msk = 0xffff // Bit mask of D15 field.

	// DR16: Backup data register (BKP_DR)
	BKP_DR16_D16_Pos = 0x0    // Position of D16 field.
	BKP_DR16_D16_Msk = 0xffff // Bit mask of D16 field.

	// DR17: Backup data register (BKP_DR)
	BKP_DR17_D17_Pos = 0x0    // Position of D17 field.
	BKP_DR17_D17_Msk = 0xffff // Bit mask of D17 field.

	// DR18: Backup data register (BKP_DR)
	BKP_DR18_D18_Pos = 0x0    // Position of D18 field.
	BKP_DR18_D18_Msk = 0xffff // Bit mask of D18 field.

	// DR19: Backup data register (BKP_DR)
	BKP_DR19_D19_Pos = 0x0    // Position of D19 field.
	BKP_DR19_D19_Msk = 0xffff // Bit mask of D19 field.

	// DR20: Backup data register (BKP_DR)
	BKP_DR20_D20_Pos = 0x0    // Position of D20 field.
	BKP_DR20_D20_Msk = 0xffff // Bit mask of D20 field.

	// DR21: Backup data register (BKP_DR)
	BKP_DR21_D21_Pos = 0x0    // Position of D21 field.
	BKP_DR21_D21_Msk = 0xffff // Bit mask of D21 field.

	// DR22: Backup data register (BKP_DR)
	BKP_DR22_D22_Pos = 0x0    // Position of D22 field.
	BKP_DR22_D22_Msk = 0xffff // Bit mask of D22 field.

	// DR23: Backup data register (BKP_DR)
	BKP_DR23_D23_Pos = 0x0    // Position of D23 field.
	BKP_DR23_D23_Msk = 0xffff // Bit mask of D23 field.

	// DR24: Backup data register (BKP_DR)
	BKP_DR24_D24_Pos = 0x0    // Position of D24 field.
	BKP_DR24_D24_Msk = 0xffff // Bit mask of D24 field.

	// DR25: Backup data register (BKP_DR)
	BKP_DR25_D25_Pos = 0x0    // Position of D25 field.
	BKP_DR25_D25_Msk = 0xffff // Bit mask of D25 field.

	// DR26: Backup data register (BKP_DR)
	BKP_DR26_D26_Pos = 0x0    // Position of D26 field.
	BKP_DR26_D26_Msk = 0xffff // Bit mask of D26 field.

	// DR27: Backup data register (BKP_DR)
	BKP_DR27_D27_Pos = 0x0    // Position of D27 field.
	BKP_DR27_D27_Msk = 0xffff // Bit mask of D27 field.

	// DR28: Backup data register (BKP_DR)
	BKP_DR28_D28_Pos = 0x0    // Position of D28 field.
	BKP_DR28_D28_Msk = 0xffff // Bit mask of D28 field.

	// DR29: Backup data register (BKP_DR)
	BKP_DR29_D29_Pos = 0x0    // Position of D29 field.
	BKP_DR29_D29_Msk = 0xffff // Bit mask of D29 field.

	// DR30: Backup data register (BKP_DR)
	BKP_DR30_D30_Pos = 0x0    // Position of D30 field.
	BKP_DR30_D30_Msk = 0xffff // Bit mask of D30 field.

	// DR31: Backup data register (BKP_DR)
	BKP_DR31_D31_Pos = 0x0    // Position of D31 field.
	BKP_DR31_D31_Msk = 0xffff // Bit mask of D31 field.

	// DR32: Backup data register (BKP_DR)
	BKP_DR32_D32_Pos = 0x0    // Position of D32 field.
	BKP_DR32_D32_Msk = 0xffff // Bit mask of D32 field.

	// DR33: Backup data register (BKP_DR)
	BKP_DR33_D33_Pos = 0x0    // Position of D33 field.
	BKP_DR33_D33_Msk = 0xffff // Bit mask of D33 field.

	// DR34: Backup data register (BKP_DR)
	BKP_DR34_D34_Pos = 0x0    // Position of D34 field.
	BKP_DR34_D34_Msk = 0xffff // Bit mask of D34 field.

	// DR35: Backup data register (BKP_DR)
	BKP_DR35_D35_Pos = 0x0    // Position of D35 field.
	BKP_DR35_D35_Msk = 0xffff // Bit mask of D35 field.

	// DR36: Backup data register (BKP_DR)
	BKP_DR36_D36_Pos = 0x0    // Position of D36 field.
	BKP_DR36_D36_Msk = 0xffff // Bit mask of D36 field.

	// DR37: Backup data register (BKP_DR)
	BKP_DR37_D37_Pos = 0x0    // Position of D37 field.
	BKP_DR37_D37_Msk = 0xffff // Bit mask of D37 field.

	// DR38: Backup data register (BKP_DR)
	BKP_DR38_D38_Pos = 0x0    // Position of D38 field.
	BKP_DR38_D38_Msk = 0xffff // Bit mask of D38 field.

	// DR39: Backup data register (BKP_DR)
	BKP_DR39_D39_Pos = 0x0    // Position of D39 field.
	BKP_DR39_D39_Msk = 0xffff // Bit mask of D39 field.

	// DR40: Backup data register (BKP_DR)
	BKP_DR40_D40_Pos = 0x0    // Position of D40 field.
	BKP_DR40_D40_Msk = 0xffff // Bit mask of D40 field.

	// DR41: Backup data register (BKP_DR)
	BKP_DR41_D41_Pos = 0x0    // Position of D41 field.
	BKP_DR41_D41_Msk = 0xffff // Bit mask of D41 field.

	// DR42: Backup data register (BKP_DR)
	BKP_DR42_D42_Pos = 0x0    // Position of D42 field.
	BKP_DR42_D42_Msk = 0xffff // Bit mask of D42 field.
)

// Bitfields for IWDG: Independent watchdog
const (
	// KR: Key register (IWDG_KR)
	IWDG_KR_KEY_Pos = 0x0    // Position of KEY field.
	IWDG_KR_KEY_Msk = 0xffff // Bit mask of KEY field.

	// PR: Prescaler register (IWDG_PR)
	IWDG_PR_PR_Pos = 0x0 // Position of PR field.
	IWDG_PR_PR_Msk = 0x7 // Bit mask of PR field.

	// RLR: Reload register (IWDG_RLR)
	IWDG_RLR_RL_Pos = 0x0   // Position of RL field.
	IWDG_RLR_RL_Msk = 0xfff // Bit mask of RL field.

	// SR: Status register (IWDG_SR)
	IWDG_SR_PVU_Pos = 0x0 // Position of PVU field.
	IWDG_SR_PVU_Msk = 0x1 // Bit mask of PVU field.
	IWDG_SR_PVU     = 0x1 // Bit PVU.
	IWDG_SR_RVU_Pos = 0x1 // Position of RVU field.
	IWDG_SR_RVU_Msk = 0x2 // Bit mask of RVU field.
	IWDG_SR_RVU     = 0x2 // Bit RVU.
)

// Bitfields for WWDG: Window watchdog
const (
	// CR: Control register (WWDG_CR)
	WWDG_CR_T_Pos    = 0x0  // Position of T field.
	WWDG_CR_T_Msk    = 0x7f // Bit mask of T field.
	WWDG_CR_WDGA_Pos = 0x7  // Position of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80 // Bit mask of WDGA field.
	WWDG_CR_WDGA     = 0x80 // Bit WDGA.

	// CFR: Configuration register           (WWDG_CFR)
	WWDG_CFR_W_Pos     = 0x0   // Position of W field.
	WWDG_CFR_W_Msk     = 0x7f  // Bit mask of W field.
	WWDG_CFR_WDGTB_Pos = 0x7   // Position of WDGTB field.
	WWDG_CFR_WDGTB_Msk = 0x180 // Bit mask of WDGTB field.
	WWDG_CFR_EWI_Pos   = 0x9   // Position of EWI field.
	WWDG_CFR_EWI_Msk   = 0x200 // Bit mask of EWI field.
	WWDG_CFR_EWI       = 0x200 // Bit EWI.

	// SR: Status register (WWDG_SR)
	WWDG_SR_EWI_Pos = 0x0 // Position of EWI field.
	WWDG_SR_EWI_Msk = 0x1 // Bit mask of EWI field.
	WWDG_SR_EWI     = 0x1 // Bit EWI.
)

// Bitfields for TIM1: Advanced timer
const (
	// CR1: control register 1
	TIM_CR1_CKD_Pos  = 0x8   // Position of CKD field.
	TIM_CR1_CKD_Msk  = 0x300 // Bit mask of CKD field.
	TIM_CR1_ARPE_Pos = 0x7   // Position of ARPE field.
	TIM_CR1_ARPE_Msk = 0x80  // Bit mask of ARPE field.
	TIM_CR1_ARPE     = 0x80  // Bit ARPE.
	TIM_CR1_CMS_Pos  = 0x5   // Position of CMS field.
	TIM_CR1_CMS_Msk  = 0x60  // Bit mask of CMS field.
	TIM_CR1_DIR_Pos  = 0x4   // Position of DIR field.
	TIM_CR1_DIR_Msk  = 0x10  // Bit mask of DIR field.
	TIM_CR1_DIR      = 0x10  // Bit DIR.
	TIM_CR1_OPM_Pos  = 0x3   // Position of OPM field.
	TIM_CR1_OPM_Msk  = 0x8   // Bit mask of OPM field.
	TIM_CR1_OPM      = 0x8   // Bit OPM.
	TIM_CR1_URS_Pos  = 0x2   // Position of URS field.
	TIM_CR1_URS_Msk  = 0x4   // Bit mask of URS field.
	TIM_CR1_URS      = 0x4   // Bit URS.
	TIM_CR1_UDIS_Pos = 0x1   // Position of UDIS field.
	TIM_CR1_UDIS_Msk = 0x2   // Bit mask of UDIS field.
	TIM_CR1_UDIS     = 0x2   // Bit UDIS.
	TIM_CR1_CEN_Pos  = 0x0   // Position of CEN field.
	TIM_CR1_CEN_Msk  = 0x1   // Bit mask of CEN field.
	TIM_CR1_CEN      = 0x1   // Bit CEN.

	// CR2: control register 2
	TIM_CR2_OIS4_Pos  = 0xe    // Position of OIS4 field.
	TIM_CR2_OIS4_Msk  = 0x4000 // Bit mask of OIS4 field.
	TIM_CR2_OIS4      = 0x4000 // Bit OIS4.
	TIM_CR2_OIS3N_Pos = 0xd    // Position of OIS3N field.
	TIM_CR2_OIS3N_Msk = 0x2000 // Bit mask of OIS3N field.
	TIM_CR2_OIS3N     = 0x2000 // Bit OIS3N.
	TIM_CR2_OIS3_Pos  = 0xc    // Position of OIS3 field.
	TIM_CR2_OIS3_Msk  = 0x1000 // Bit mask of OIS3 field.
	TIM_CR2_OIS3      = 0x1000 // Bit OIS3.
	TIM_CR2_OIS2N_Pos = 0xb    // Position of OIS2N field.
	TIM_CR2_OIS2N_Msk = 0x800  // Bit mask of OIS2N field.
	TIM_CR2_OIS2N     = 0x800  // Bit OIS2N.
	TIM_CR2_OIS2_Pos  = 0xa    // Position of OIS2 field.
	TIM_CR2_OIS2_Msk  = 0x400  // Bit mask of OIS2 field.
	TIM_CR2_OIS2      = 0x400  // Bit OIS2.
	TIM_CR2_OIS1N_Pos = 0x9    // Position of OIS1N field.
	TIM_CR2_OIS1N_Msk = 0x200  // Bit mask of OIS1N field.
	TIM_CR2_OIS1N     = 0x200  // Bit OIS1N.
	TIM_CR2_OIS1_Pos  = 0x8    // Position of OIS1 field.
	TIM_CR2_OIS1_Msk  = 0x100  // Bit mask of OIS1 field.
	TIM_CR2_OIS1      = 0x100  // Bit OIS1.
	TIM_CR2_TI1S_Pos  = 0x7    // Position of TI1S field.
	TIM_CR2_TI1S_Msk  = 0x80   // Bit mask of TI1S field.
	TIM_CR2_TI1S      = 0x80   // Bit TI1S.
	TIM_CR2_MMS_Pos   = 0x4    // Position of MMS field.
	TIM_CR2_MMS_Msk   = 0x70   // Bit mask of MMS field.
	TIM_CR2_CCDS_Pos  = 0x3    // Position of CCDS field.
	TIM_CR2_CCDS_Msk  = 0x8    // Bit mask of CCDS field.
	TIM_CR2_CCDS      = 0x8    // Bit CCDS.
	TIM_CR2_CCUS_Pos  = 0x2    // Position of CCUS field.
	TIM_CR2_CCUS_Msk  = 0x4    // Bit mask of CCUS field.
	TIM_CR2_CCUS      = 0x4    // Bit CCUS.
	TIM_CR2_CCPC_Pos  = 0x0    // Position of CCPC field.
	TIM_CR2_CCPC_Msk  = 0x1    // Bit mask of CCPC field.
	TIM_CR2_CCPC      = 0x1    // Bit CCPC.

	// SMCR: slave mode control register
	TIM_SMCR_ETP_Pos  = 0xf    // Position of ETP field.
	TIM_SMCR_ETP_Msk  = 0x8000 // Bit mask of ETP field.
	TIM_SMCR_ETP      = 0x8000 // Bit ETP.
	TIM_SMCR_ECE_Pos  = 0xe    // Position of ECE field.
	TIM_SMCR_ECE_Msk  = 0x4000 // Bit mask of ECE field.
	TIM_SMCR_ECE      = 0x4000 // Bit ECE.
	TIM_SMCR_ETPS_Pos = 0xc    // Position of ETPS field.
	TIM_SMCR_ETPS_Msk = 0x3000 // Bit mask of ETPS field.
	TIM_SMCR_ETF_Pos  = 0x8    // Position of ETF field.
	TIM_SMCR_ETF_Msk  = 0xf00  // Bit mask of ETF field.
	TIM_SMCR_MSM_Pos  = 0x7    // Position of MSM field.
	TIM_SMCR_MSM_Msk  = 0x80   // Bit mask of MSM field.
	TIM_SMCR_MSM      = 0x80   // Bit MSM.
	TIM_SMCR_TS_Pos   = 0x4    // Position of TS field.
	TIM_SMCR_TS_Msk   = 0x70   // Bit mask of TS field.
	TIM_SMCR_SMS_Pos  = 0x0    // Position of SMS field.
	TIM_SMCR_SMS_Msk  = 0x7    // Bit mask of SMS field.

	// DIER: DMA/Interrupt enable register
	TIM_DIER_UIE_Pos   = 0x0    // Position of UIE field.
	TIM_DIER_UIE_Msk   = 0x1    // Bit mask of UIE field.
	TIM_DIER_UIE       = 0x1    // Bit UIE.
	TIM_DIER_CC1IE_Pos = 0x1    // Position of CC1IE field.
	TIM_DIER_CC1IE_Msk = 0x2    // Bit mask of CC1IE field.
	TIM_DIER_CC1IE     = 0x2    // Bit CC1IE.
	TIM_DIER_CC2IE_Pos = 0x2    // Position of CC2IE field.
	TIM_DIER_CC2IE_Msk = 0x4    // Bit mask of CC2IE field.
	TIM_DIER_CC2IE     = 0x4    // Bit CC2IE.
	TIM_DIER_CC3IE_Pos = 0x3    // Position of CC3IE field.
	TIM_DIER_CC3IE_Msk = 0x8    // Bit mask of CC3IE field.
	TIM_DIER_CC3IE     = 0x8    // Bit CC3IE.
	TIM_DIER_CC4IE_Pos = 0x4    // Position of CC4IE field.
	TIM_DIER_CC4IE_Msk = 0x10   // Bit mask of CC4IE field.
	TIM_DIER_CC4IE     = 0x10   // Bit CC4IE.
	TIM_DIER_COMIE_Pos = 0x5    // Position of COMIE field.
	TIM_DIER_COMIE_Msk = 0x20   // Bit mask of COMIE field.
	TIM_DIER_COMIE     = 0x20   // Bit COMIE.
	TIM_DIER_TIE_Pos   = 0x6    // Position of TIE field.
	TIM_DIER_TIE_Msk   = 0x40   // Bit mask of TIE field.
	TIM_DIER_TIE       = 0x40   // Bit TIE.
	TIM_DIER_BIE_Pos   = 0x7    // Position of BIE field.
	TIM_DIER_BIE_Msk   = 0x80   // Bit mask of BIE field.
	TIM_DIER_BIE       = 0x80   // Bit BIE.
	TIM_DIER_UDE_Pos   = 0x8    // Position of UDE field.
	TIM_DIER_UDE_Msk   = 0x100  // Bit mask of UDE field.
	TIM_DIER_UDE       = 0x100  // Bit UDE.
	TIM_DIER_CC1DE_Pos = 0x9    // Position of CC1DE field.
	TIM_DIER_CC1DE_Msk = 0x200  // Bit mask of CC1DE field.
	TIM_DIER_CC1DE     = 0x200  // Bit CC1DE.
	TIM_DIER_CC2DE_Pos = 0xa    // Position of CC2DE field.
	TIM_DIER_CC2DE_Msk = 0x400  // Bit mask of CC2DE field.
	TIM_DIER_CC2DE     = 0x400  // Bit CC2DE.
	TIM_DIER_CC3DE_Pos = 0xb    // Position of CC3DE field.
	TIM_DIER_CC3DE_Msk = 0x800  // Bit mask of CC3DE field.
	TIM_DIER_CC3DE     = 0x800  // Bit CC3DE.
	TIM_DIER_CC4DE_Pos = 0xc    // Position of CC4DE field.
	TIM_DIER_CC4DE_Msk = 0x1000 // Bit mask of CC4DE field.
	TIM_DIER_CC4DE     = 0x1000 // Bit CC4DE.
	TIM_DIER_COMDE_Pos = 0xd    // Position of COMDE field.
	TIM_DIER_COMDE_Msk = 0x2000 // Bit mask of COMDE field.
	TIM_DIER_COMDE     = 0x2000 // Bit COMDE.
	TIM_DIER_TDE_Pos   = 0xe    // Position of TDE field.
	TIM_DIER_TDE_Msk   = 0x4000 // Bit mask of TDE field.
	TIM_DIER_TDE       = 0x4000 // Bit TDE.

	// SR: status register
	TIM_SR_CC4OF_Pos = 0xc    // Position of CC4OF field.
	TIM_SR_CC4OF_Msk = 0x1000 // Bit mask of CC4OF field.
	TIM_SR_CC4OF     = 0x1000 // Bit CC4OF.
	TIM_SR_CC3OF_Pos = 0xb    // Position of CC3OF field.
	TIM_SR_CC3OF_Msk = 0x800  // Bit mask of CC3OF field.
	TIM_SR_CC3OF     = 0x800  // Bit CC3OF.
	TIM_SR_CC2OF_Pos = 0xa    // Position of CC2OF field.
	TIM_SR_CC2OF_Msk = 0x400  // Bit mask of CC2OF field.
	TIM_SR_CC2OF     = 0x400  // Bit CC2OF.
	TIM_SR_CC1OF_Pos = 0x9    // Position of CC1OF field.
	TIM_SR_CC1OF_Msk = 0x200  // Bit mask of CC1OF field.
	TIM_SR_CC1OF     = 0x200  // Bit CC1OF.
	TIM_SR_BIF_Pos   = 0x7    // Position of BIF field.
	TIM_SR_BIF_Msk   = 0x80   // Bit mask of BIF field.
	TIM_SR_BIF       = 0x80   // Bit BIF.
	TIM_SR_TIF_Pos   = 0x6    // Position of TIF field.
	TIM_SR_TIF_Msk   = 0x40   // Bit mask of TIF field.
	TIM_SR_TIF       = 0x40   // Bit TIF.
	TIM_SR_COMIF_Pos = 0x5    // Position of COMIF field.
	TIM_SR_COMIF_Msk = 0x20   // Bit mask of COMIF field.
	TIM_SR_COMIF     = 0x20   // Bit COMIF.
	TIM_SR_CC4IF_Pos = 0x4    // Position of CC4IF field.
	TIM_SR_CC4IF_Msk = 0x10   // Bit mask of CC4IF field.
	TIM_SR_CC4IF     = 0x10   // Bit CC4IF.
	TIM_SR_CC3IF_Pos = 0x3    // Position of CC3IF field.
	TIM_SR_CC3IF_Msk = 0x8    // Bit mask of CC3IF field.
	TIM_SR_CC3IF     = 0x8    // Bit CC3IF.
	TIM_SR_CC2IF_Pos = 0x2    // Position of CC2IF field.
	TIM_SR_CC2IF_Msk = 0x4    // Bit mask of CC2IF field.
	TIM_SR_CC2IF     = 0x4    // Bit CC2IF.
	TIM_SR_CC1IF_Pos = 0x1    // Position of CC1IF field.
	TIM_SR_CC1IF_Msk = 0x2    // Bit mask of CC1IF field.
	TIM_SR_CC1IF     = 0x2    // Bit CC1IF.
	TIM_SR_UIF_Pos   = 0x0    // Position of UIF field.
	TIM_SR_UIF_Msk   = 0x1    // Bit mask of UIF field.
	TIM_SR_UIF       = 0x1    // Bit UIF.

	// EGR: event generation register
	TIM_EGR_BG_Pos   = 0x7  // Position of BG field.
	TIM_EGR_BG_Msk   = 0x80 // Bit mask of BG field.
	TIM_EGR_BG       = 0x80 // Bit BG.
	TIM_EGR_TG_Pos   = 0x6  // Position of TG field.
	TIM_EGR_TG_Msk   = 0x40 // Bit mask of TG field.
	TIM_EGR_TG       = 0x40 // Bit TG.
	TIM_EGR_COMG_Pos = 0x5  // Position of COMG field.
	TIM_EGR_COMG_Msk = 0x20 // Bit mask of COMG field.
	TIM_EGR_COMG     = 0x20 // Bit COMG.
	TIM_EGR_CC4G_Pos = 0x4  // Position of CC4G field.
	TIM_EGR_CC4G_Msk = 0x10 // Bit mask of CC4G field.
	TIM_EGR_CC4G     = 0x10 // Bit CC4G.
	TIM_EGR_CC3G_Pos = 0x3  // Position of CC3G field.
	TIM_EGR_CC3G_Msk = 0x8  // Bit mask of CC3G field.
	TIM_EGR_CC3G     = 0x8  // Bit CC3G.
	TIM_EGR_CC2G_Pos = 0x2  // Position of CC2G field.
	TIM_EGR_CC2G_Msk = 0x4  // Bit mask of CC2G field.
	TIM_EGR_CC2G     = 0x4  // Bit CC2G.
	TIM_EGR_CC1G_Pos = 0x1  // Position of CC1G field.
	TIM_EGR_CC1G_Msk = 0x2  // Bit mask of CC1G field.
	TIM_EGR_CC1G     = 0x2  // Bit CC1G.
	TIM_EGR_UG_Pos   = 0x0  // Position of UG field.
	TIM_EGR_UG_Msk   = 0x1  // Bit mask of UG field.
	TIM_EGR_UG       = 0x1  // Bit UG.

	// CCMR1_Output: capture/compare mode register (output           mode)
	TIM_CCMR1_Output_OC2CE_Pos = 0xf    // Position of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Msk = 0x8000 // Bit mask of OC2CE field.
	TIM_CCMR1_Output_OC2CE     = 0x8000 // Bit OC2CE.
	TIM_CCMR1_Output_OC2M_Pos  = 0xc    // Position of OC2M field.
	TIM_CCMR1_Output_OC2M_Msk  = 0x7000 // Bit mask of OC2M field.
	TIM_CCMR1_Output_OC2PE_Pos = 0xb    // Position of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Msk = 0x800  // Bit mask of OC2PE field.
	TIM_CCMR1_Output_OC2PE     = 0x800  // Bit OC2PE.
	TIM_CCMR1_Output_OC2FE_Pos = 0xa    // Position of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Msk = 0x400  // Bit mask of OC2FE field.
	TIM_CCMR1_Output_OC2FE     = 0x400  // Bit OC2FE.
	TIM_CCMR1_Output_CC2S_Pos  = 0x8    // Position of CC2S field.
	TIM_CCMR1_Output_CC2S_Msk  = 0x300  // Bit mask of CC2S field.
	TIM_CCMR1_Output_OC1CE_Pos = 0x7    // Position of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Msk = 0x80   // Bit mask of OC1CE field.
	TIM_CCMR1_Output_OC1CE     = 0x80   // Bit OC1CE.
	TIM_CCMR1_Output_OC1M_Pos  = 0x4    // Position of OC1M field.
	TIM_CCMR1_Output_OC1M_Msk  = 0x70   // Bit mask of OC1M field.
	TIM_CCMR1_Output_OC1PE_Pos = 0x3    // Position of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Msk = 0x8    // Bit mask of OC1PE field.
	TIM_CCMR1_Output_OC1PE     = 0x8    // Bit OC1PE.
	TIM_CCMR1_Output_OC1FE_Pos = 0x2    // Position of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Msk = 0x4    // Bit mask of OC1FE field.
	TIM_CCMR1_Output_OC1FE     = 0x4    // Bit OC1FE.
	TIM_CCMR1_Output_CC1S_Pos  = 0x0    // Position of CC1S field.
	TIM_CCMR1_Output_CC1S_Msk  = 0x3    // Bit mask of CC1S field.

	// CCMR1_Input: capture/compare mode register 1 (input           mode)
	TIM_CCMR1_Input_IC2F_Pos   = 0xf     // Position of IC2F field.
	TIM_CCMR1_Input_IC2F_Msk   = 0x78000 // Bit mask of IC2F field.
	TIM_CCMR1_Input_IC2PCS_Pos = 0xa     // Position of IC2PCS field.
	TIM_CCMR1_Input_IC2PCS_Msk = 0xc00   // Bit mask of IC2PCS field.
	TIM_CCMR1_Input_CC2S_Pos   = 0x8     // Position of CC2S field.
	TIM_CCMR1_Input_CC2S_Msk   = 0x300   // Bit mask of CC2S field.
	TIM_CCMR1_Input_IC1F_Pos   = 0x4     // Position of IC1F field.
	TIM_CCMR1_Input_IC1F_Msk   = 0xf0    // Bit mask of IC1F field.
	TIM_CCMR1_Input_ICPCS_Pos  = 0x2     // Position of ICPCS field.
	TIM_CCMR1_Input_ICPCS_Msk  = 0xc     // Bit mask of ICPCS field.
	TIM_CCMR1_Input_CC1S_Pos   = 0x0     // Position of CC1S field.
	TIM_CCMR1_Input_CC1S_Msk   = 0x3     // Bit mask of CC1S field.

	// CCMR2_Output: capture/compare mode register (output           mode)
	TIM_CCMR2_Output_OC4CE_Pos = 0xf    // Position of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Msk = 0x8000 // Bit mask of OC4CE field.
	TIM_CCMR2_Output_OC4CE     = 0x8000 // Bit OC4CE.
	TIM_CCMR2_Output_OC4M_Pos  = 0xc    // Position of OC4M field.
	TIM_CCMR2_Output_OC4M_Msk  = 0x7000 // Bit mask of OC4M field.
	TIM_CCMR2_Output_OC4PE_Pos = 0xb    // Position of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Msk = 0x800  // Bit mask of OC4PE field.
	TIM_CCMR2_Output_OC4PE     = 0x800  // Bit OC4PE.
	TIM_CCMR2_Output_OC4FE_Pos = 0xa    // Position of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Msk = 0x400  // Bit mask of OC4FE field.
	TIM_CCMR2_Output_OC4FE     = 0x400  // Bit OC4FE.
	TIM_CCMR2_Output_CC4S_Pos  = 0x8    // Position of CC4S field.
	TIM_CCMR2_Output_CC4S_Msk  = 0x300  // Bit mask of CC4S field.
	TIM_CCMR2_Output_OC3CE_Pos = 0x7    // Position of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Msk = 0x80   // Bit mask of OC3CE field.
	TIM_CCMR2_Output_OC3CE     = 0x80   // Bit OC3CE.
	TIM_CCMR2_Output_OC3M_Pos  = 0x4    // Position of OC3M field.
	TIM_CCMR2_Output_OC3M_Msk  = 0x70   // Bit mask of OC3M field.
	TIM_CCMR2_Output_OC3PE_Pos = 0x3    // Position of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Msk = 0x8    // Bit mask of OC3PE field.
	TIM_CCMR2_Output_OC3PE     = 0x8    // Bit OC3PE.
	TIM_CCMR2_Output_OC3FE_Pos = 0x2    // Position of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Msk = 0x4    // Bit mask of OC3FE field.
	TIM_CCMR2_Output_OC3FE     = 0x4    // Bit OC3FE.
	TIM_CCMR2_Output_CC3S_Pos  = 0x0    // Position of CC3S field.
	TIM_CCMR2_Output_CC3S_Msk  = 0x3    // Bit mask of CC3S field.

	// CCMR2_Input: capture/compare mode register 2 (input           mode)
	TIM_CCMR2_Input_IC4F_Pos   = 0xf     // Position of IC4F field.
	TIM_CCMR2_Input_IC4F_Msk   = 0x78000 // Bit mask of IC4F field.
	TIM_CCMR2_Input_IC4PSC_Pos = 0xa     // Position of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Msk = 0xc00   // Bit mask of IC4PSC field.
	TIM_CCMR2_Input_CC4S_Pos   = 0x8     // Position of CC4S field.
	TIM_CCMR2_Input_CC4S_Msk   = 0x300   // Bit mask of CC4S field.
	TIM_CCMR2_Input_IC3F_Pos   = 0x4     // Position of IC3F field.
	TIM_CCMR2_Input_IC3F_Msk   = 0xf0    // Bit mask of IC3F field.
	TIM_CCMR2_Input_IC3PSC_Pos = 0x2     // Position of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Msk = 0xc     // Bit mask of IC3PSC field.
	TIM_CCMR2_Input_CC3S_Pos   = 0x0     // Position of CC3S field.
	TIM_CCMR2_Input_CC3S_Msk   = 0x3     // Bit mask of CC3S field.

	// CCER: capture/compare enable           register
	TIM_CCER_CC4P_Pos  = 0xd    // Position of CC4P field.
	TIM_CCER_CC4P_Msk  = 0x2000 // Bit mask of CC4P field.
	TIM_CCER_CC4P      = 0x2000 // Bit CC4P.
	TIM_CCER_CC4E_Pos  = 0xc    // Position of CC4E field.
	TIM_CCER_CC4E_Msk  = 0x1000 // Bit mask of CC4E field.
	TIM_CCER_CC4E      = 0x1000 // Bit CC4E.
	TIM_CCER_CC3NP_Pos = 0xb    // Position of CC3NP field.
	TIM_CCER_CC3NP_Msk = 0x800  // Bit mask of CC3NP field.
	TIM_CCER_CC3NP     = 0x800  // Bit CC3NP.
	TIM_CCER_CC3NE_Pos = 0xa    // Position of CC3NE field.
	TIM_CCER_CC3NE_Msk = 0x400  // Bit mask of CC3NE field.
	TIM_CCER_CC3NE     = 0x400  // Bit CC3NE.
	TIM_CCER_CC3P_Pos  = 0x9    // Position of CC3P field.
	TIM_CCER_CC3P_Msk  = 0x200  // Bit mask of CC3P field.
	TIM_CCER_CC3P      = 0x200  // Bit CC3P.
	TIM_CCER_CC3E_Pos  = 0x8    // Position of CC3E field.
	TIM_CCER_CC3E_Msk  = 0x100  // Bit mask of CC3E field.
	TIM_CCER_CC3E      = 0x100  // Bit CC3E.
	TIM_CCER_CC2NP_Pos = 0x7    // Position of CC2NP field.
	TIM_CCER_CC2NP_Msk = 0x80   // Bit mask of CC2NP field.
	TIM_CCER_CC2NP     = 0x80   // Bit CC2NP.
	TIM_CCER_CC2NE_Pos = 0x6    // Position of CC2NE field.
	TIM_CCER_CC2NE_Msk = 0x40   // Bit mask of CC2NE field.
	TIM_CCER_CC2NE     = 0x40   // Bit CC2NE.
	TIM_CCER_CC2P_Pos  = 0x5    // Position of CC2P field.
	TIM_CCER_CC2P_Msk  = 0x20   // Bit mask of CC2P field.
	TIM_CCER_CC2P      = 0x20   // Bit CC2P.
	TIM_CCER_CC2E_Pos  = 0x4    // Position of CC2E field.
	TIM_CCER_CC2E_Msk  = 0x10   // Bit mask of CC2E field.
	TIM_CCER_CC2E      = 0x10   // Bit CC2E.
	TIM_CCER_CC1NP_Pos = 0x3    // Position of CC1NP field.
	TIM_CCER_CC1NP_Msk = 0x8    // Bit mask of CC1NP field.
	TIM_CCER_CC1NP     = 0x8    // Bit CC1NP.
	TIM_CCER_CC1NE_Pos = 0x2    // Position of CC1NE field.
	TIM_CCER_CC1NE_Msk = 0x4    // Bit mask of CC1NE field.
	TIM_CCER_CC1NE     = 0x4    // Bit CC1NE.
	TIM_CCER_CC1P_Pos  = 0x1    // Position of CC1P field.
	TIM_CCER_CC1P_Msk  = 0x2    // Bit mask of CC1P field.
	TIM_CCER_CC1P      = 0x2    // Bit CC1P.
	TIM_CCER_CC1E_Pos  = 0x0    // Position of CC1E field.
	TIM_CCER_CC1E_Msk  = 0x1    // Bit mask of CC1E field.
	TIM_CCER_CC1E      = 0x1    // Bit CC1E.

	// CNT: counter
	TIM_CNT_CNT_Pos = 0x0    // Position of CNT field.
	TIM_CNT_CNT_Msk = 0xffff // Bit mask of CNT field.

	// PSC: prescaler
	TIM_PSC_PSC_Pos = 0x0    // Position of PSC field.
	TIM_PSC_PSC_Msk = 0xffff // Bit mask of PSC field.

	// ARR: auto-reload register
	TIM_ARR_ARR_Pos = 0x0    // Position of ARR field.
	TIM_ARR_ARR_Msk = 0xffff // Bit mask of ARR field.

	// RCR: repetition counter register
	TIM_RCR_REP_Pos = 0x0  // Position of REP field.
	TIM_RCR_REP_Msk = 0xff // Bit mask of REP field.

	// CCR1: capture/compare register 1
	TIM_CCR1_CCR1_Pos = 0x0    // Position of CCR1 field.
	TIM_CCR1_CCR1_Msk = 0xffff // Bit mask of CCR1 field.

	// CCR2: capture/compare register 2
	TIM_CCR2_CCR2_Pos = 0x0    // Position of CCR2 field.
	TIM_CCR2_CCR2_Msk = 0xffff // Bit mask of CCR2 field.

	// CCR3: capture/compare register 3
	TIM_CCR3_CCR3_Pos = 0x0    // Position of CCR3 field.
	TIM_CCR3_CCR3_Msk = 0xffff // Bit mask of CCR3 field.

	// CCR4: capture/compare register 4
	TIM_CCR4_CCR4_Pos = 0x0    // Position of CCR4 field.
	TIM_CCR4_CCR4_Msk = 0xffff // Bit mask of CCR4 field.

	// BDTR: break and dead-time register
	TIM_BDTR_MOE_Pos  = 0xf    // Position of MOE field.
	TIM_BDTR_MOE_Msk  = 0x8000 // Bit mask of MOE field.
	TIM_BDTR_MOE      = 0x8000 // Bit MOE.
	TIM_BDTR_AOE_Pos  = 0xe    // Position of AOE field.
	TIM_BDTR_AOE_Msk  = 0x4000 // Bit mask of AOE field.
	TIM_BDTR_AOE      = 0x4000 // Bit AOE.
	TIM_BDTR_BKP_Pos  = 0xd    // Position of BKP field.
	TIM_BDTR_BKP_Msk  = 0x2000 // Bit mask of BKP field.
	TIM_BDTR_BKP      = 0x2000 // Bit BKP.
	TIM_BDTR_BKE_Pos  = 0xc    // Position of BKE field.
	TIM_BDTR_BKE_Msk  = 0x1000 // Bit mask of BKE field.
	TIM_BDTR_BKE      = 0x1000 // Bit BKE.
	TIM_BDTR_OSSR_Pos = 0xb    // Position of OSSR field.
	TIM_BDTR_OSSR_Msk = 0x800  // Bit mask of OSSR field.
	TIM_BDTR_OSSR     = 0x800  // Bit OSSR.
	TIM_BDTR_OSSI_Pos = 0xa    // Position of OSSI field.
	TIM_BDTR_OSSI_Msk = 0x400  // Bit mask of OSSI field.
	TIM_BDTR_OSSI     = 0x400  // Bit OSSI.
	TIM_BDTR_LOCK_Pos = 0x8    // Position of LOCK field.
	TIM_BDTR_LOCK_Msk = 0x300  // Bit mask of LOCK field.
	TIM_BDTR_DTG_Pos  = 0x0    // Position of DTG field.
	TIM_BDTR_DTG_Msk  = 0xff   // Bit mask of DTG field.

	// DCR: DMA control register
	TIM_DCR_DBL_Pos = 0x8    // Position of DBL field.
	TIM_DCR_DBL_Msk = 0x1f00 // Bit mask of DBL field.
	TIM_DCR_DBA_Pos = 0x0    // Position of DBA field.
	TIM_DCR_DBA_Msk = 0x1f   // Bit mask of DBA field.

	// DMAR: DMA address for full transfer
	TIM_DMAR_DMAB_Pos = 0x0    // Position of DMAB field.
	TIM_DMAR_DMAB_Msk = 0xffff // Bit mask of DMAB field.
)

// Bitfields for I2C1: Inter integrated circuit
const (
	// CR1: Control register 1
	I2C_CR1_SWRST_Pos     = 0xf    // Position of SWRST field.
	I2C_CR1_SWRST_Msk     = 0x8000 // Bit mask of SWRST field.
	I2C_CR1_SWRST         = 0x8000 // Bit SWRST.
	I2C_CR1_ALERT_Pos     = 0xd    // Position of ALERT field.
	I2C_CR1_ALERT_Msk     = 0x2000 // Bit mask of ALERT field.
	I2C_CR1_ALERT         = 0x2000 // Bit ALERT.
	I2C_CR1_PEC_Pos       = 0xc    // Position of PEC field.
	I2C_CR1_PEC_Msk       = 0x1000 // Bit mask of PEC field.
	I2C_CR1_PEC           = 0x1000 // Bit PEC.
	I2C_CR1_POS_Pos       = 0xb    // Position of POS field.
	I2C_CR1_POS_Msk       = 0x800  // Bit mask of POS field.
	I2C_CR1_POS           = 0x800  // Bit POS.
	I2C_CR1_ACK_Pos       = 0xa    // Position of ACK field.
	I2C_CR1_ACK_Msk       = 0x400  // Bit mask of ACK field.
	I2C_CR1_ACK           = 0x400  // Bit ACK.
	I2C_CR1_STOP_Pos      = 0x9    // Position of STOP field.
	I2C_CR1_STOP_Msk      = 0x200  // Bit mask of STOP field.
	I2C_CR1_STOP          = 0x200  // Bit STOP.
	I2C_CR1_START_Pos     = 0x8    // Position of START field.
	I2C_CR1_START_Msk     = 0x100  // Bit mask of START field.
	I2C_CR1_START         = 0x100  // Bit START.
	I2C_CR1_NOSTRETCH_Pos = 0x7    // Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x80   // Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH     = 0x80   // Bit NOSTRETCH.
	I2C_CR1_ENGC_Pos      = 0x6    // Position of ENGC field.
	I2C_CR1_ENGC_Msk      = 0x40   // Bit mask of ENGC field.
	I2C_CR1_ENGC          = 0x40   // Bit ENGC.
	I2C_CR1_ENPEC_Pos     = 0x5    // Position of ENPEC field.
	I2C_CR1_ENPEC_Msk     = 0x20   // Bit mask of ENPEC field.
	I2C_CR1_ENPEC         = 0x20   // Bit ENPEC.
	I2C_CR1_ENARP_Pos     = 0x4    // Position of ENARP field.
	I2C_CR1_ENARP_Msk     = 0x10   // Bit mask of ENARP field.
	I2C_CR1_ENARP         = 0x10   // Bit ENARP.
	I2C_CR1_SMBTYPE_Pos   = 0x3    // Position of SMBTYPE field.
	I2C_CR1_SMBTYPE_Msk   = 0x8    // Bit mask of SMBTYPE field.
	I2C_CR1_SMBTYPE       = 0x8    // Bit SMBTYPE.
	I2C_CR1_SMBUS_Pos     = 0x1    // Position of SMBUS field.
	I2C_CR1_SMBUS_Msk     = 0x2    // Bit mask of SMBUS field.
	I2C_CR1_SMBUS         = 0x2    // Bit SMBUS.
	I2C_CR1_PE_Pos        = 0x0    // Position of PE field.
	I2C_CR1_PE_Msk        = 0x1    // Bit mask of PE field.
	I2C_CR1_PE            = 0x1    // Bit PE.

	// CR2: Control register 2
	I2C_CR2_LAST_Pos    = 0xc    // Position of LAST field.
	I2C_CR2_LAST_Msk    = 0x1000 // Bit mask of LAST field.
	I2C_CR2_LAST        = 0x1000 // Bit LAST.
	I2C_CR2_DMAEN_Pos   = 0xb    // Position of DMAEN field.
	I2C_CR2_DMAEN_Msk   = 0x800  // Bit mask of DMAEN field.
	I2C_CR2_DMAEN       = 0x800  // Bit DMAEN.
	I2C_CR2_ITBUFEN_Pos = 0xa    // Position of ITBUFEN field.
	I2C_CR2_ITBUFEN_Msk = 0x400  // Bit mask of ITBUFEN field.
	I2C_CR2_ITBUFEN     = 0x400  // Bit ITBUFEN.
	I2C_CR2_ITEVTEN_Pos = 0x9    // Position of ITEVTEN field.
	I2C_CR2_ITEVTEN_Msk = 0x200  // Bit mask of ITEVTEN field.
	I2C_CR2_ITEVTEN     = 0x200  // Bit ITEVTEN.
	I2C_CR2_ITERREN_Pos = 0x8    // Position of ITERREN field.
	I2C_CR2_ITERREN_Msk = 0x100  // Bit mask of ITERREN field.
	I2C_CR2_ITERREN     = 0x100  // Bit ITERREN.
	I2C_CR2_FREQ_Pos    = 0x0    // Position of FREQ field.
	I2C_CR2_FREQ_Msk    = 0x3f   // Bit mask of FREQ field.

	// OAR1: Own address register 1
	I2C_OAR1_ADDMODE_Pos = 0xf    // Position of ADDMODE field.
	I2C_OAR1_ADDMODE_Msk = 0x8000 // Bit mask of ADDMODE field.
	I2C_OAR1_ADDMODE     = 0x8000 // Bit ADDMODE.
	I2C_OAR1_ADD10_Pos   = 0x8    // Position of ADD10 field.
	I2C_OAR1_ADD10_Msk   = 0x300  // Bit mask of ADD10 field.
	I2C_OAR1_ADD7_Pos    = 0x1    // Position of ADD7 field.
	I2C_OAR1_ADD7_Msk    = 0xfe   // Bit mask of ADD7 field.
	I2C_OAR1_ADD0_Pos    = 0x0    // Position of ADD0 field.
	I2C_OAR1_ADD0_Msk    = 0x1    // Bit mask of ADD0 field.
	I2C_OAR1_ADD0        = 0x1    // Bit ADD0.

	// OAR2: Own address register 2
	I2C_OAR2_ADD2_Pos   = 0x1  // Position of ADD2 field.
	I2C_OAR2_ADD2_Msk   = 0xfe // Bit mask of ADD2 field.
	I2C_OAR2_ENDUAL_Pos = 0x0  // Position of ENDUAL field.
	I2C_OAR2_ENDUAL_Msk = 0x1  // Bit mask of ENDUAL field.
	I2C_OAR2_ENDUAL     = 0x1  // Bit ENDUAL.

	// DR: Data register
	I2C_DR_DR_Pos = 0x0  // Position of DR field.
	I2C_DR_DR_Msk = 0xff // Bit mask of DR field.

	// SR1: Status register 1
	I2C_SR1_SMBALERT_Pos = 0xf    // Position of SMBALERT field.
	I2C_SR1_SMBALERT_Msk = 0x8000 // Bit mask of SMBALERT field.
	I2C_SR1_SMBALERT     = 0x8000 // Bit SMBALERT.
	I2C_SR1_TIMEOUT_Pos  = 0xe    // Position of TIMEOUT field.
	I2C_SR1_TIMEOUT_Msk  = 0x4000 // Bit mask of TIMEOUT field.
	I2C_SR1_TIMEOUT      = 0x4000 // Bit TIMEOUT.
	I2C_SR1_PECERR_Pos   = 0xc    // Position of PECERR field.
	I2C_SR1_PECERR_Msk   = 0x1000 // Bit mask of PECERR field.
	I2C_SR1_PECERR       = 0x1000 // Bit PECERR.
	I2C_SR1_OVR_Pos      = 0xb    // Position of OVR field.
	I2C_SR1_OVR_Msk      = 0x800  // Bit mask of OVR field.
	I2C_SR1_OVR          = 0x800  // Bit OVR.
	I2C_SR1_AF_Pos       = 0xa    // Position of AF field.
	I2C_SR1_AF_Msk       = 0x400  // Bit mask of AF field.
	I2C_SR1_AF           = 0x400  // Bit AF.
	I2C_SR1_ARLO_Pos     = 0x9    // Position of ARLO field.
	I2C_SR1_ARLO_Msk     = 0x200  // Bit mask of ARLO field.
	I2C_SR1_ARLO         = 0x200  // Bit ARLO.
	I2C_SR1_BERR_Pos     = 0x8    // Position of BERR field.
	I2C_SR1_BERR_Msk     = 0x100  // Bit mask of BERR field.
	I2C_SR1_BERR         = 0x100  // Bit BERR.
	I2C_SR1_TxE_Pos      = 0x7    // Position of TxE field.
	I2C_SR1_TxE_Msk      = 0x80   // Bit mask of TxE field.
	I2C_SR1_TxE          = 0x80   // Bit TxE.
	I2C_SR1_RxNE_Pos     = 0x6    // Position of RxNE field.
	I2C_SR1_RxNE_Msk     = 0x40   // Bit mask of RxNE field.
	I2C_SR1_RxNE         = 0x40   // Bit RxNE.
	I2C_SR1_STOPF_Pos    = 0x4    // Position of STOPF field.
	I2C_SR1_STOPF_Msk    = 0x10   // Bit mask of STOPF field.
	I2C_SR1_STOPF        = 0x10   // Bit STOPF.
	I2C_SR1_ADD10_Pos    = 0x3    // Position of ADD10 field.
	I2C_SR1_ADD10_Msk    = 0x8    // Bit mask of ADD10 field.
	I2C_SR1_ADD10        = 0x8    // Bit ADD10.
	I2C_SR1_BTF_Pos      = 0x2    // Position of BTF field.
	I2C_SR1_BTF_Msk      = 0x4    // Bit mask of BTF field.
	I2C_SR1_BTF          = 0x4    // Bit BTF.
	I2C_SR1_ADDR_Pos     = 0x1    // Position of ADDR field.
	I2C_SR1_ADDR_Msk     = 0x2    // Bit mask of ADDR field.
	I2C_SR1_ADDR         = 0x2    // Bit ADDR.
	I2C_SR1_SB_Pos       = 0x0    // Position of SB field.
	I2C_SR1_SB_Msk       = 0x1    // Bit mask of SB field.
	I2C_SR1_SB           = 0x1    // Bit SB.

	// SR2: Status register 2
	I2C_SR2_PEC_Pos        = 0x8    // Position of PEC field.
	I2C_SR2_PEC_Msk        = 0xff00 // Bit mask of PEC field.
	I2C_SR2_DUALF_Pos      = 0x7    // Position of DUALF field.
	I2C_SR2_DUALF_Msk      = 0x80   // Bit mask of DUALF field.
	I2C_SR2_DUALF          = 0x80   // Bit DUALF.
	I2C_SR2_SMBHOST_Pos    = 0x6    // Position of SMBHOST field.
	I2C_SR2_SMBHOST_Msk    = 0x40   // Bit mask of SMBHOST field.
	I2C_SR2_SMBHOST        = 0x40   // Bit SMBHOST.
	I2C_SR2_SMBDEFAULT_Pos = 0x5    // Position of SMBDEFAULT field.
	I2C_SR2_SMBDEFAULT_Msk = 0x20   // Bit mask of SMBDEFAULT field.
	I2C_SR2_SMBDEFAULT     = 0x20   // Bit SMBDEFAULT.
	I2C_SR2_GENCALL_Pos    = 0x4    // Position of GENCALL field.
	I2C_SR2_GENCALL_Msk    = 0x10   // Bit mask of GENCALL field.
	I2C_SR2_GENCALL        = 0x10   // Bit GENCALL.
	I2C_SR2_TRA_Pos        = 0x2    // Position of TRA field.
	I2C_SR2_TRA_Msk        = 0x4    // Bit mask of TRA field.
	I2C_SR2_TRA            = 0x4    // Bit TRA.
	I2C_SR2_BUSY_Pos       = 0x1    // Position of BUSY field.
	I2C_SR2_BUSY_Msk       = 0x2    // Bit mask of BUSY field.
	I2C_SR2_BUSY           = 0x2    // Bit BUSY.
	I2C_SR2_MSL_Pos        = 0x0    // Position of MSL field.
	I2C_SR2_MSL_Msk        = 0x1    // Bit mask of MSL field.
	I2C_SR2_MSL            = 0x1    // Bit MSL.

	// CCR: Clock control register
	I2C_CCR_F_S_Pos  = 0xf    // Position of F_S field.
	I2C_CCR_F_S_Msk  = 0x8000 // Bit mask of F_S field.
	I2C_CCR_F_S      = 0x8000 // Bit F_S.
	I2C_CCR_DUTY_Pos = 0xe    // Position of DUTY field.
	I2C_CCR_DUTY_Msk = 0x4000 // Bit mask of DUTY field.
	I2C_CCR_DUTY     = 0x4000 // Bit DUTY.
	I2C_CCR_CCR_Pos  = 0x0    // Position of CCR field.
	I2C_CCR_CCR_Msk  = 0xfff  // Bit mask of CCR field.

	// TRISE: TRISE register
	I2C_TRISE_TRISE_Pos = 0x0  // Position of TRISE field.
	I2C_TRISE_TRISE_Msk = 0x3f // Bit mask of TRISE field.
)

// Bitfields for SPI1: Serial peripheral interface
const (
	// CR1: control register 1
	SPI_CR1_BIDIMODE_Pos = 0xf    // Position of BIDIMODE field.
	SPI_CR1_BIDIMODE_Msk = 0x8000 // Bit mask of BIDIMODE field.
	SPI_CR1_BIDIMODE     = 0x8000 // Bit BIDIMODE.
	SPI_CR1_BIDIOE_Pos   = 0xe    // Position of BIDIOE field.
	SPI_CR1_BIDIOE_Msk   = 0x4000 // Bit mask of BIDIOE field.
	SPI_CR1_BIDIOE       = 0x4000 // Bit BIDIOE.
	SPI_CR1_CRCEN_Pos    = 0xd    // Position of CRCEN field.
	SPI_CR1_CRCEN_Msk    = 0x2000 // Bit mask of CRCEN field.
	SPI_CR1_CRCEN        = 0x2000 // Bit CRCEN.
	SPI_CR1_CRCNEXT_Pos  = 0xc    // Position of CRCNEXT field.
	SPI_CR1_CRCNEXT_Msk  = 0x1000 // Bit mask of CRCNEXT field.
	SPI_CR1_CRCNEXT      = 0x1000 // Bit CRCNEXT.
	SPI_CR1_DFF_Pos      = 0xb    // Position of DFF field.
	SPI_CR1_DFF_Msk      = 0x800  // Bit mask of DFF field.
	SPI_CR1_DFF          = 0x800  // Bit DFF.
	SPI_CR1_RXONLY_Pos   = 0xa    // Position of RXONLY field.
	SPI_CR1_RXONLY_Msk   = 0x400  // Bit mask of RXONLY field.
	SPI_CR1_RXONLY       = 0x400  // Bit RXONLY.
	SPI_CR1_SSM_Pos      = 0x9    // Position of SSM field.
	SPI_CR1_SSM_Msk      = 0x200  // Bit mask of SSM field.
	SPI_CR1_SSM          = 0x200  // Bit SSM.
	SPI_CR1_SSI_Pos      = 0x8    // Position of SSI field.
	SPI_CR1_SSI_Msk      = 0x100  // Bit mask of SSI field.
	SPI_CR1_SSI          = 0x100  // Bit SSI.
	SPI_CR1_LSBFIRST_Pos = 0x7    // Position of LSBFIRST field.
	SPI_CR1_LSBFIRST_Msk = 0x80   // Bit mask of LSBFIRST field.
	SPI_CR1_LSBFIRST     = 0x80   // Bit LSBFIRST.
	SPI_CR1_SPE_Pos      = 0x6    // Position of SPE field.
	SPI_CR1_SPE_Msk      = 0x40   // Bit mask of SPE field.
	SPI_CR1_SPE          = 0x40   // Bit SPE.
	SPI_CR1_BR_Pos       = 0x3    // Position of BR field.
	SPI_CR1_BR_Msk       = 0x38   // Bit mask of BR field.
	SPI_CR1_MSTR_Pos     = 0x2    // Position of MSTR field.
	SPI_CR1_MSTR_Msk     = 0x4    // Bit mask of MSTR field.
	SPI_CR1_MSTR         = 0x4    // Bit MSTR.
	SPI_CR1_CPOL_Pos     = 0x1    // Position of CPOL field.
	SPI_CR1_CPOL_Msk     = 0x2    // Bit mask of CPOL field.
	SPI_CR1_CPOL         = 0x2    // Bit CPOL.
	SPI_CR1_CPHA_Pos     = 0x0    // Position of CPHA field.
	SPI_CR1_CPHA_Msk     = 0x1    // Bit mask of CPHA field.
	SPI_CR1_CPHA         = 0x1    // Bit CPHA.

	// CR2: control register 2
	SPI_CR2_TXEIE_Pos   = 0x7  // Position of TXEIE field.
	SPI_CR2_TXEIE_Msk   = 0x80 // Bit mask of TXEIE field.
	SPI_CR2_TXEIE       = 0x80 // Bit TXEIE.
	SPI_CR2_RXNEIE_Pos  = 0x6  // Position of RXNEIE field.
	SPI_CR2_RXNEIE_Msk  = 0x40 // Bit mask of RXNEIE field.
	SPI_CR2_RXNEIE      = 0x40 // Bit RXNEIE.
	SPI_CR2_ERRIE_Pos   = 0x5  // Position of ERRIE field.
	SPI_CR2_ERRIE_Msk   = 0x20 // Bit mask of ERRIE field.
	SPI_CR2_ERRIE       = 0x20 // Bit ERRIE.
	SPI_CR2_SSOE_Pos    = 0x2  // Position of SSOE field.
	SPI_CR2_SSOE_Msk    = 0x4  // Bit mask of SSOE field.
	SPI_CR2_SSOE        = 0x4  // Bit SSOE.
	SPI_CR2_TXDMAEN_Pos = 0x1  // Position of TXDMAEN field.
	SPI_CR2_TXDMAEN_Msk = 0x2  // Bit mask of TXDMAEN field.
	SPI_CR2_TXDMAEN     = 0x2  // Bit TXDMAEN.
	SPI_CR2_RXDMAEN_Pos = 0x0  // Position of RXDMAEN field.
	SPI_CR2_RXDMAEN_Msk = 0x1  // Bit mask of RXDMAEN field.
	SPI_CR2_RXDMAEN     = 0x1  // Bit RXDMAEN.

	// SR: status register
	SPI_SR_BSY_Pos    = 0x7  // Position of BSY field.
	SPI_SR_BSY_Msk    = 0x80 // Bit mask of BSY field.
	SPI_SR_BSY        = 0x80 // Bit BSY.
	SPI_SR_OVR_Pos    = 0x6  // Position of OVR field.
	SPI_SR_OVR_Msk    = 0x40 // Bit mask of OVR field.
	SPI_SR_OVR        = 0x40 // Bit OVR.
	SPI_SR_MODF_Pos   = 0x5  // Position of MODF field.
	SPI_SR_MODF_Msk   = 0x20 // Bit mask of MODF field.
	SPI_SR_MODF       = 0x20 // Bit MODF.
	SPI_SR_CRCERR_Pos = 0x4  // Position of CRCERR field.
	SPI_SR_CRCERR_Msk = 0x10 // Bit mask of CRCERR field.
	SPI_SR_CRCERR     = 0x10 // Bit CRCERR.
	SPI_SR_TXE_Pos    = 0x1  // Position of TXE field.
	SPI_SR_TXE_Msk    = 0x2  // Bit mask of TXE field.
	SPI_SR_TXE        = 0x2  // Bit TXE.
	SPI_SR_RXNE_Pos   = 0x0  // Position of RXNE field.
	SPI_SR_RXNE_Msk   = 0x1  // Bit mask of RXNE field.
	SPI_SR_RXNE       = 0x1  // Bit RXNE.

	// DR: data register
	SPI_DR_DR_Pos = 0x0    // Position of DR field.
	SPI_DR_DR_Msk = 0xffff // Bit mask of DR field.

	// CRCPR: CRC polynomial register
	SPI_CRCPR_CRCPOLY_Pos = 0x0    // Position of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Msk = 0xffff // Bit mask of CRCPOLY field.

	// RXCRCR: RX CRC register
	SPI_RXCRCR_RxCRC_Pos = 0x0    // Position of RxCRC field.
	SPI_RXCRCR_RxCRC_Msk = 0xffff // Bit mask of RxCRC field.

	// TXCRCR: TX CRC register
	SPI_TXCRCR_TxCRC_Pos = 0x0    // Position of TxCRC field.
	SPI_TXCRCR_TxCRC_Msk = 0xffff // Bit mask of TxCRC field.
)

// Bitfields for USART1: Universal synchronous asynchronous receiver transmitter
const (
	// SR: Status register
	USART_SR_CTS_Pos  = 0x9   // Position of CTS field.
	USART_SR_CTS_Msk  = 0x200 // Bit mask of CTS field.
	USART_SR_CTS      = 0x200 // Bit CTS.
	USART_SR_LBD_Pos  = 0x8   // Position of LBD field.
	USART_SR_LBD_Msk  = 0x100 // Bit mask of LBD field.
	USART_SR_LBD      = 0x100 // Bit LBD.
	USART_SR_TXE_Pos  = 0x7   // Position of TXE field.
	USART_SR_TXE_Msk  = 0x80  // Bit mask of TXE field.
	USART_SR_TXE      = 0x80  // Bit TXE.
	USART_SR_TC_Pos   = 0x6   // Position of TC field.
	USART_SR_TC_Msk   = 0x40  // Bit mask of TC field.
	USART_SR_TC       = 0x40  // Bit TC.
	USART_SR_RXNE_Pos = 0x5   // Position of RXNE field.
	USART_SR_RXNE_Msk = 0x20  // Bit mask of RXNE field.
	USART_SR_RXNE     = 0x20  // Bit RXNE.
	USART_SR_IDLE_Pos = 0x4   // Position of IDLE field.
	USART_SR_IDLE_Msk = 0x10  // Bit mask of IDLE field.
	USART_SR_IDLE     = 0x10  // Bit IDLE.
	USART_SR_ORE_Pos  = 0x3   // Position of ORE field.
	USART_SR_ORE_Msk  = 0x8   // Bit mask of ORE field.
	USART_SR_ORE      = 0x8   // Bit ORE.
	USART_SR_NE_Pos   = 0x2   // Position of NE field.
	USART_SR_NE_Msk   = 0x4   // Bit mask of NE field.
	USART_SR_NE       = 0x4   // Bit NE.
	USART_SR_FE_Pos   = 0x1   // Position of FE field.
	USART_SR_FE_Msk   = 0x2   // Bit mask of FE field.
	USART_SR_FE       = 0x2   // Bit FE.
	USART_SR_PE_Pos   = 0x0   // Position of PE field.
	USART_SR_PE_Msk   = 0x1   // Bit mask of PE field.
	USART_SR_PE       = 0x1   // Bit PE.

	// DR: Data register
	USART_DR_DR_Pos = 0x0   // Position of DR field.
	USART_DR_DR_Msk = 0x1ff // Bit mask of DR field.

	// BRR: Baud rate register
	USART_BRR_DIV_Mantissa_Pos = 0x4    // Position of DIV_Mantissa field.
	USART_BRR_DIV_Mantissa_Msk = 0xfff0 // Bit mask of DIV_Mantissa field.
	USART_BRR_DIV_Fraction_Pos = 0x0    // Position of DIV_Fraction field.
	USART_BRR_DIV_Fraction_Msk = 0xf    // Bit mask of DIV_Fraction field.

	// CR1: Control register 1
	USART_CR1_UE_Pos     = 0xd    // Position of UE field.
	USART_CR1_UE_Msk     = 0x2000 // Bit mask of UE field.
	USART_CR1_UE         = 0x2000 // Bit UE.
	USART_CR1_M_Pos      = 0xc    // Position of M field.
	USART_CR1_M_Msk      = 0x1000 // Bit mask of M field.
	USART_CR1_M          = 0x1000 // Bit M.
	USART_CR1_WAKE_Pos   = 0xb    // Position of WAKE field.
	USART_CR1_WAKE_Msk   = 0x800  // Bit mask of WAKE field.
	USART_CR1_WAKE       = 0x800  // Bit WAKE.
	USART_CR1_PCE_Pos    = 0xa    // Position of PCE field.
	USART_CR1_PCE_Msk    = 0x400  // Bit mask of PCE field.
	USART_CR1_PCE        = 0x400  // Bit PCE.
	USART_CR1_PS_Pos     = 0x9    // Position of PS field.
	USART_CR1_PS_Msk     = 0x200  // Bit mask of PS field.
	USART_CR1_PS         = 0x200  // Bit PS.
	USART_CR1_PEIE_Pos   = 0x8    // Position of PEIE field.
	USART_CR1_PEIE_Msk   = 0x100  // Bit mask of PEIE field.
	USART_CR1_PEIE       = 0x100  // Bit PEIE.
	USART_CR1_TXEIE_Pos  = 0x7    // Position of TXEIE field.
	USART_CR1_TXEIE_Msk  = 0x80   // Bit mask of TXEIE field.
	USART_CR1_TXEIE      = 0x80   // Bit TXEIE.
	USART_CR1_TCIE_Pos   = 0x6    // Position of TCIE field.
	USART_CR1_TCIE_Msk   = 0x40   // Bit mask of TCIE field.
	USART_CR1_TCIE       = 0x40   // Bit TCIE.
	USART_CR1_RXNEIE_Pos = 0x5    // Position of RXNEIE field.
	USART_CR1_RXNEIE_Msk = 0x20   // Bit mask of RXNEIE field.
	USART_CR1_RXNEIE     = 0x20   // Bit RXNEIE.
	USART_CR1_IDLEIE_Pos = 0x4    // Position of IDLEIE field.
	USART_CR1_IDLEIE_Msk = 0x10   // Bit mask of IDLEIE field.
	USART_CR1_IDLEIE     = 0x10   // Bit IDLEIE.
	USART_CR1_TE_Pos     = 0x3    // Position of TE field.
	USART_CR1_TE_Msk     = 0x8    // Bit mask of TE field.
	USART_CR1_TE         = 0x8    // Bit TE.
	USART_CR1_RE_Pos     = 0x2    // Position of RE field.
	USART_CR1_RE_Msk     = 0x4    // Bit mask of RE field.
	USART_CR1_RE         = 0x4    // Bit RE.
	USART_CR1_RWU_Pos    = 0x1    // Position of RWU field.
	USART_CR1_RWU_Msk    = 0x2    // Bit mask of RWU field.
	USART_CR1_RWU        = 0x2    // Bit RWU.
	USART_CR1_SBK_Pos    = 0x0    // Position of SBK field.
	USART_CR1_SBK_Msk    = 0x1    // Bit mask of SBK field.
	USART_CR1_SBK        = 0x1    // Bit SBK.

	// CR2: Control register 2
	USART_CR2_LINEN_Pos = 0xe    // Position of LINEN field.
	USART_CR2_LINEN_Msk = 0x4000 // Bit mask of LINEN field.
	USART_CR2_LINEN     = 0x4000 // Bit LINEN.
	USART_CR2_STOP_Pos  = 0xc    // Position of STOP field.
	USART_CR2_STOP_Msk  = 0x3000 // Bit mask of STOP field.
	USART_CR2_CLKEN_Pos = 0xb    // Position of CLKEN field.
	USART_CR2_CLKEN_Msk = 0x800  // Bit mask of CLKEN field.
	USART_CR2_CLKEN     = 0x800  // Bit CLKEN.
	USART_CR2_CPOL_Pos  = 0xa    // Position of CPOL field.
	USART_CR2_CPOL_Msk  = 0x400  // Bit mask of CPOL field.
	USART_CR2_CPOL      = 0x400  // Bit CPOL.
	USART_CR2_CPHA_Pos  = 0x9    // Position of CPHA field.
	USART_CR2_CPHA_Msk  = 0x200  // Bit mask of CPHA field.
	USART_CR2_CPHA      = 0x200  // Bit CPHA.
	USART_CR2_LBCL_Pos  = 0x8    // Position of LBCL field.
	USART_CR2_LBCL_Msk  = 0x100  // Bit mask of LBCL field.
	USART_CR2_LBCL      = 0x100  // Bit LBCL.
	USART_CR2_LBDIE_Pos = 0x6    // Position of LBDIE field.
	USART_CR2_LBDIE_Msk = 0x40   // Bit mask of LBDIE field.
	USART_CR2_LBDIE     = 0x40   // Bit LBDIE.
	USART_CR2_LBDL_Pos  = 0x5    // Position of LBDL field.
	USART_CR2_LBDL_Msk  = 0x20   // Bit mask of LBDL field.
	USART_CR2_LBDL      = 0x20   // Bit LBDL.
	USART_CR2_ADD_Pos   = 0x0    // Position of ADD field.
	USART_CR2_ADD_Msk   = 0xf    // Bit mask of ADD field.

	// CR3: Control register 3
	USART_CR3_CTSIE_Pos = 0xa   // Position of CTSIE field.
	USART_CR3_CTSIE_Msk = 0x400 // Bit mask of CTSIE field.
	USART_CR3_CTSIE     = 0x400 // Bit CTSIE.
	USART_CR3_CTSE_Pos  = 0x9   // Position of CTSE field.
	USART_CR3_CTSE_Msk  = 0x200 // Bit mask of CTSE field.
	USART_CR3_CTSE      = 0x200 // Bit CTSE.
	USART_CR3_RTSE_Pos  = 0x8   // Position of RTSE field.
	USART_CR3_RTSE_Msk  = 0x100 // Bit mask of RTSE field.
	USART_CR3_RTSE      = 0x100 // Bit RTSE.
	USART_CR3_DMAT_Pos  = 0x7   // Position of DMAT field.
	USART_CR3_DMAT_Msk  = 0x80  // Bit mask of DMAT field.
	USART_CR3_DMAT      = 0x80  // Bit DMAT.
	USART_CR3_DMAR_Pos  = 0x6   // Position of DMAR field.
	USART_CR3_DMAR_Msk  = 0x40  // Bit mask of DMAR field.
	USART_CR3_DMAR      = 0x40  // Bit DMAR.
	USART_CR3_SCEN_Pos  = 0x5   // Position of SCEN field.
	USART_CR3_SCEN_Msk  = 0x20  // Bit mask of SCEN field.
	USART_CR3_SCEN      = 0x20  // Bit SCEN.
	USART_CR3_NACK_Pos  = 0x4   // Position of NACK field.
	USART_CR3_NACK_Msk  = 0x10  // Bit mask of NACK field.
	USART_CR3_NACK      = 0x10  // Bit NACK.
	USART_CR3_HDSEL_Pos = 0x3   // Position of HDSEL field.
	USART_CR3_HDSEL_Msk = 0x8   // Bit mask of HDSEL field.
	USART_CR3_HDSEL     = 0x8   // Bit HDSEL.
	USART_CR3_IRLP_Pos  = 0x2   // Position of IRLP field.
	USART_CR3_IRLP_Msk  = 0x4   // Bit mask of IRLP field.
	USART_CR3_IRLP      = 0x4   // Bit IRLP.
	USART_CR3_IREN_Pos  = 0x1   // Position of IREN field.
	USART_CR3_IREN_Msk  = 0x2   // Bit mask of IREN field.
	USART_CR3_IREN      = 0x2   // Bit IREN.
	USART_CR3_EIE_Pos   = 0x0   // Position of EIE field.
	USART_CR3_EIE_Msk   = 0x1   // Bit mask of EIE field.
	USART_CR3_EIE       = 0x1   // Bit EIE.

	// GTPR: Guard time and prescaler           register
	USART_GTPR_GT_Pos  = 0x8    // Position of GT field.
	USART_GTPR_GT_Msk  = 0xff00 // Bit mask of GT field.
	USART_GTPR_PSC_Pos = 0x0    // Position of PSC field.
	USART_GTPR_PSC_Msk = 0xff   // Bit mask of PSC field.
)

// Bitfields for ADC1: Analog to digital converter
const (
	// SR: status register
	ADC_SR_STRT_Pos  = 0x4  // Position of STRT field.
	ADC_SR_STRT_Msk  = 0x10 // Bit mask of STRT field.
	ADC_SR_STRT      = 0x10 // Bit STRT.
	ADC_SR_JSTRT_Pos = 0x3  // Position of JSTRT field.
	ADC_SR_JSTRT_Msk = 0x8  // Bit mask of JSTRT field.
	ADC_SR_JSTRT     = 0x8  // Bit JSTRT.
	ADC_SR_JEOC_Pos  = 0x2  // Position of JEOC field.
	ADC_SR_JEOC_Msk  = 0x4  // Bit mask of JEOC field.
	ADC_SR_JEOC      = 0x4  // Bit JEOC.
	ADC_SR_EOC_Pos   = 0x1  // Position of EOC field.
	ADC_SR_EOC_Msk   = 0x2  // Bit mask of EOC field.
	ADC_SR_EOC       = 0x2  // Bit EOC.
	ADC_SR_AWD_Pos   = 0x0  // Position of AWD field.
	ADC_SR_AWD_Msk   = 0x1  // Bit mask of AWD field.
	ADC_SR_AWD       = 0x1  // Bit AWD.

	// CR1: control register 1
	ADC_CR1_AWDEN_Pos   = 0x17     // Position of AWDEN field.
	ADC_CR1_AWDEN_Msk   = 0x800000 // Bit mask of AWDEN field.
	ADC_CR1_AWDEN       = 0x800000 // Bit AWDEN.
	ADC_CR1_JAWDEN_Pos  = 0x16     // Position of JAWDEN field.
	ADC_CR1_JAWDEN_Msk  = 0x400000 // Bit mask of JAWDEN field.
	ADC_CR1_JAWDEN      = 0x400000 // Bit JAWDEN.
	ADC_CR1_DISCNUM_Pos = 0xd      // Position of DISCNUM field.
	ADC_CR1_DISCNUM_Msk = 0xe000   // Bit mask of DISCNUM field.
	ADC_CR1_JDISCEN_Pos = 0xc      // Position of JDISCEN field.
	ADC_CR1_JDISCEN_Msk = 0x1000   // Bit mask of JDISCEN field.
	ADC_CR1_JDISCEN     = 0x1000   // Bit JDISCEN.
	ADC_CR1_DISCEN_Pos  = 0xb      // Position of DISCEN field.
	ADC_CR1_DISCEN_Msk  = 0x800    // Bit mask of DISCEN field.
	ADC_CR1_DISCEN      = 0x800    // Bit DISCEN.
	ADC_CR1_JAUTO_Pos   = 0xa      // Position of JAUTO field.
	ADC_CR1_JAUTO_Msk   = 0x400    // Bit mask of JAUTO field.
	ADC_CR1_JAUTO       = 0x400    // Bit JAUTO.
	ADC_CR1_AWDSGL_Pos  = 0x9      // Position of AWDSGL field.
	ADC_CR1_AWDSGL_Msk  = 0x200    // Bit mask of AWDSGL field.
	ADC_CR1_AWDSGL      = 0x200    // Bit AWDSGL.
	ADC_CR1_SCAN_Pos    = 0x8      // Position of SCAN field.
	ADC_CR1_SCAN_Msk    = 0x100    // Bit mask of SCAN field.
	ADC_CR1_SCAN        = 0x100    // Bit SCAN.
	ADC_CR1_JEOCIE_Pos  = 0x7      // Position of JEOCIE field.
	ADC_CR1_JEOCIE_Msk  = 0x80     // Bit mask of JEOCIE field.
	ADC_CR1_JEOCIE      = 0x80     // Bit JEOCIE.
	ADC_CR1_AWDIE_Pos   = 0x6      // Position of AWDIE field.
	ADC_CR1_AWDIE_Msk   = 0x40     // Bit mask of AWDIE field.
	ADC_CR1_AWDIE       = 0x40     // Bit AWDIE.
	ADC_CR1_EOCIE_Pos   = 0x5      // Position of EOCIE field.
	ADC_CR1_EOCIE_Msk   = 0x20     // Bit mask of EOCIE field.
	ADC_CR1_EOCIE       = 0x20     // Bit EOCIE.
	ADC_CR1_AWDCH_Pos   = 0x0      // Position of AWDCH field.
	ADC_CR1_AWDCH_Msk   = 0x1f     // Bit mask of AWDCH field.

	// CR2: control register 2
	ADC_CR2_TSVREFE_Pos  = 0x17     // Position of TSVREFE field.
	ADC_CR2_TSVREFE_Msk  = 0x800000 // Bit mask of TSVREFE field.
	ADC_CR2_TSVREFE      = 0x800000 // Bit TSVREFE.
	ADC_CR2_SWSTART_Pos  = 0x16     // Position of SWSTART field.
	ADC_CR2_SWSTART_Msk  = 0x400000 // Bit mask of SWSTART field.
	ADC_CR2_SWSTART      = 0x400000 // Bit SWSTART.
	ADC_CR2_JSWSTART_Pos = 0x15     // Position of JSWSTART field.
	ADC_CR2_JSWSTART_Msk = 0x200000 // Bit mask of JSWSTART field.
	ADC_CR2_JSWSTART     = 0x200000 // Bit JSWSTART.
	ADC_CR2_EXTTRIG_Pos  = 0x14     // Position of EXTTRIG field.
	ADC_CR2_EXTTRIG_Msk  = 0x100000 // Bit mask of EXTTRIG field.
	ADC_CR2_EXTTRIG      = 0x100000 // Bit EXTTRIG.
	ADC_CR2_EXTSEL_Pos   = 0x11     // Position of EXTSEL field.
	ADC_CR2_EXTSEL_Msk   = 0xe0000  // Bit mask of EXTSEL field.
	ADC_CR2_JEXTTRIG_Pos = 0xf      // Position of JEXTTRIG field.
	ADC_CR2_JEXTTRIG_Msk = 0x8000   // Bit mask of JEXTTRIG field.
	ADC_CR2_JEXTTRIG     = 0x8000   // Bit JEXTTRIG.
	ADC_CR2_JEXTSEL_Pos  = 0xc      // Position of JEXTSEL field.
	ADC_CR2_JEXTSEL_Msk  = 0x7000   // Bit mask of JEXTSEL field.
	ADC_CR2_ALIGN_Pos    = 0xb      // Position of ALIGN field.
	ADC_CR2_ALIGN_Msk    = 0x800    // Bit mask of ALIGN field.
	ADC_CR2_ALIGN        = 0x800    // Bit ALIGN.
	ADC_CR2_DMA_Pos      = 0x8      // Position of DMA field.
	ADC_CR2_DMA_Msk      = 0x100    // Bit mask of DMA field.
	ADC_CR2_DMA          = 0x100    // Bit DMA.
	ADC_CR2_RSTCAL_Pos   = 0x3      // Position of RSTCAL field.
	ADC_CR2_RSTCAL_Msk   = 0x8      // Bit mask of RSTCAL field.
	ADC_CR2_RSTCAL       = 0x8      // Bit RSTCAL.
	ADC_CR2_CAL_Pos      = 0x2      // Position of CAL field.
	ADC_CR2_CAL_Msk      = 0x4      // Bit mask of CAL field.
	ADC_CR2_CAL          = 0x4      // Bit CAL.
	ADC_CR2_CONT_Pos     = 0x1      // Position of CONT field.
	ADC_CR2_CONT_Msk     = 0x2      // Bit mask of CONT field.
	ADC_CR2_CONT         = 0x2      // Bit CONT.
	ADC_CR2_ADON_Pos     = 0x0      // Position of ADON field.
	ADC_CR2_ADON_Msk     = 0x1      // Bit mask of ADON field.
	ADC_CR2_ADON         = 0x1      // Bit ADON.

	// SMPR1: sample time register 1
	ADC_SMPR1_SMP10_Pos = 0x0      // Position of SMP10 field.
	ADC_SMPR1_SMP10_Msk = 0x7      // Bit mask of SMP10 field.
	ADC_SMPR1_SMP11_Pos = 0x3      // Position of SMP11 field.
	ADC_SMPR1_SMP11_Msk = 0x38     // Bit mask of SMP11 field.
	ADC_SMPR1_SMP12_Pos = 0x6      // Position of SMP12 field.
	ADC_SMPR1_SMP12_Msk = 0x1c0    // Bit mask of SMP12 field.
	ADC_SMPR1_SMP13_Pos = 0x9      // Position of SMP13 field.
	ADC_SMPR1_SMP13_Msk = 0xe00    // Bit mask of SMP13 field.
	ADC_SMPR1_SMP14_Pos = 0xc      // Position of SMP14 field.
	ADC_SMPR1_SMP14_Msk = 0x7000   // Bit mask of SMP14 field.
	ADC_SMPR1_SMP15_Pos = 0xf      // Position of SMP15 field.
	ADC_SMPR1_SMP15_Msk = 0x38000  // Bit mask of SMP15 field.
	ADC_SMPR1_SMP16_Pos = 0x12     // Position of SMP16 field.
	ADC_SMPR1_SMP16_Msk = 0x1c0000 // Bit mask of SMP16 field.
	ADC_SMPR1_SMP17_Pos = 0x15     // Position of SMP17 field.
	ADC_SMPR1_SMP17_Msk = 0xe00000 // Bit mask of SMP17 field.

	// SMPR2: sample time register 2
	ADC_SMPR2_SMP0_Pos = 0x0        // Position of SMP0 field.
	ADC_SMPR2_SMP0_Msk = 0x7        // Bit mask of SMP0 field.
	ADC_SMPR2_SMP1_Pos = 0x3        // Position of SMP1 field.
	ADC_SMPR2_SMP1_Msk = 0x38       // Bit mask of SMP1 field.
	ADC_SMPR2_SMP2_Pos = 0x6        // Position of SMP2 field.
	ADC_SMPR2_SMP2_Msk = 0x1c0      // Bit mask of SMP2 field.
	ADC_SMPR2_SMP3_Pos = 0x9        // Position of SMP3 field.
	ADC_SMPR2_SMP3_Msk = 0xe00      // Bit mask of SMP3 field.
	ADC_SMPR2_SMP4_Pos = 0xc        // Position of SMP4 field.
	ADC_SMPR2_SMP4_Msk = 0x7000     // Bit mask of SMP4 field.
	ADC_SMPR2_SMP5_Pos = 0xf        // Position of SMP5 field.
	ADC_SMPR2_SMP5_Msk = 0x38000    // Bit mask of SMP5 field.
	ADC_SMPR2_SMP6_Pos = 0x12       // Position of SMP6 field.
	ADC_SMPR2_SMP6_Msk = 0x1c0000   // Bit mask of SMP6 field.
	ADC_SMPR2_SMP7_Pos = 0x15       // Position of SMP7 field.
	ADC_SMPR2_SMP7_Msk = 0xe00000   // Bit mask of SMP7 field.
	ADC_SMPR2_SMP8_Pos = 0x18       // Position of SMP8 field.
	ADC_SMPR2_SMP8_Msk = 0x7000000  // Bit mask of SMP8 field.
	ADC_SMPR2_SMP9_Pos = 0x1b       // Position of SMP9 field.
	ADC_SMPR2_SMP9_Msk = 0x38000000 // Bit mask of SMP9 field.

	// JOFR1: injected channel data offset register           x
	ADC_JOFR1_JOFFSET1_Pos = 0x0   // Position of JOFFSET1 field.
	ADC_JOFR1_JOFFSET1_Msk = 0xfff // Bit mask of JOFFSET1 field.

	// JOFR2: injected channel data offset register           x
	ADC_JOFR2_JOFFSET2_Pos = 0x0   // Position of JOFFSET2 field.
	ADC_JOFR2_JOFFSET2_Msk = 0xfff // Bit mask of JOFFSET2 field.

	// JOFR3: injected channel data offset register           x
	ADC_JOFR3_JOFFSET3_Pos = 0x0   // Position of JOFFSET3 field.
	ADC_JOFR3_JOFFSET3_Msk = 0xfff // Bit mask of JOFFSET3 field.

	// JOFR4: injected channel data offset register           x
	ADC_JOFR4_JOFFSET4_Pos = 0x0   // Position of JOFFSET4 field.
	ADC_JOFR4_JOFFSET4_Msk = 0xfff // Bit mask of JOFFSET4 field.

	// HTR: watchdog higher threshold           register
	ADC_HTR_HT_Pos = 0x0   // Position of HT field.
	ADC_HTR_HT_Msk = 0xfff // Bit mask of HT field.

	// LTR: watchdog lower threshold           register
	ADC_LTR_LT_Pos = 0x0   // Position of LT field.
	ADC_LTR_LT_Msk = 0xfff // Bit mask of LT field.

	// SQR1: regular sequence register 1
	ADC_SQR1_L_Pos    = 0x14     // Position of L field.
	ADC_SQR1_L_Msk    = 0xf00000 // Bit mask of L field.
	ADC_SQR1_SQ16_Pos = 0xf      // Position of SQ16 field.
	ADC_SQR1_SQ16_Msk = 0xf8000  // Bit mask of SQ16 field.
	ADC_SQR1_SQ15_Pos = 0xa      // Position of SQ15 field.
	ADC_SQR1_SQ15_Msk = 0x7c00   // Bit mask of SQ15 field.
	ADC_SQR1_SQ14_Pos = 0x5      // Position of SQ14 field.
	ADC_SQR1_SQ14_Msk = 0x3e0    // Bit mask of SQ14 field.
	ADC_SQR1_SQ13_Pos = 0x0      // Position of SQ13 field.
	ADC_SQR1_SQ13_Msk = 0x1f     // Bit mask of SQ13 field.

	// SQR2: regular sequence register 2
	ADC_SQR2_SQ12_Pos = 0x19       // Position of SQ12 field.
	ADC_SQR2_SQ12_Msk = 0x3e000000 // Bit mask of SQ12 field.
	ADC_SQR2_SQ11_Pos = 0x14       // Position of SQ11 field.
	ADC_SQR2_SQ11_Msk = 0x1f00000  // Bit mask of SQ11 field.
	ADC_SQR2_SQ10_Pos = 0xf        // Position of SQ10 field.
	ADC_SQR2_SQ10_Msk = 0xf8000    // Bit mask of SQ10 field.
	ADC_SQR2_SQ9_Pos  = 0xa        // Position of SQ9 field.
	ADC_SQR2_SQ9_Msk  = 0x7c00     // Bit mask of SQ9 field.
	ADC_SQR2_SQ8_Pos  = 0x5        // Position of SQ8 field.
	ADC_SQR2_SQ8_Msk  = 0x3e0      // Bit mask of SQ8 field.
	ADC_SQR2_SQ7_Pos  = 0x0        // Position of SQ7 field.
	ADC_SQR2_SQ7_Msk  = 0x1f       // Bit mask of SQ7 field.

	// SQR3: regular sequence register 3
	ADC_SQR3_SQ6_Pos = 0x19       // Position of SQ6 field.
	ADC_SQR3_SQ6_Msk = 0x3e000000 // Bit mask of SQ6 field.
	ADC_SQR3_SQ5_Pos = 0x14       // Position of SQ5 field.
	ADC_SQR3_SQ5_Msk = 0x1f00000  // Bit mask of SQ5 field.
	ADC_SQR3_SQ4_Pos = 0xf        // Position of SQ4 field.
	ADC_SQR3_SQ4_Msk = 0xf8000    // Bit mask of SQ4 field.
	ADC_SQR3_SQ3_Pos = 0xa        // Position of SQ3 field.
	ADC_SQR3_SQ3_Msk = 0x7c00     // Bit mask of SQ3 field.
	ADC_SQR3_SQ2_Pos = 0x5        // Position of SQ2 field.
	ADC_SQR3_SQ2_Msk = 0x3e0      // Bit mask of SQ2 field.
	ADC_SQR3_SQ1_Pos = 0x0        // Position of SQ1 field.
	ADC_SQR3_SQ1_Msk = 0x1f       // Bit mask of SQ1 field.

	// JSQR: injected sequence register
	ADC_JSQR_JL_Pos   = 0x14     // Position of JL field.
	ADC_JSQR_JL_Msk   = 0x300000 // Bit mask of JL field.
	ADC_JSQR_JSQ4_Pos = 0xf      // Position of JSQ4 field.
	ADC_JSQR_JSQ4_Msk = 0xf8000  // Bit mask of JSQ4 field.
	ADC_JSQR_JSQ3_Pos = 0xa      // Position of JSQ3 field.
	ADC_JSQR_JSQ3_Msk = 0x7c00   // Bit mask of JSQ3 field.
	ADC_JSQR_JSQ2_Pos = 0x5      // Position of JSQ2 field.
	ADC_JSQR_JSQ2_Msk = 0x3e0    // Bit mask of JSQ2 field.
	ADC_JSQR_JSQ1_Pos = 0x0      // Position of JSQ1 field.
	ADC_JSQR_JSQ1_Msk = 0x1f     // Bit mask of JSQ1 field.

	// JDR1: injected data register x
	ADC_JDR1_JDATA_Pos = 0x0    // Position of JDATA field.
	ADC_JDR1_JDATA_Msk = 0xffff // Bit mask of JDATA field.

	// JDR2: injected data register x
	ADC_JDR2_JDATA_Pos = 0x0    // Position of JDATA field.
	ADC_JDR2_JDATA_Msk = 0xffff // Bit mask of JDATA field.

	// JDR3: injected data register x
	ADC_JDR3_JDATA_Pos = 0x0    // Position of JDATA field.
	ADC_JDR3_JDATA_Msk = 0xffff // Bit mask of JDATA field.

	// JDR4: injected data register x
	ADC_JDR4_JDATA_Pos = 0x0    // Position of JDATA field.
	ADC_JDR4_JDATA_Msk = 0xffff // Bit mask of JDATA field.

	// DR: regular data register
	ADC_DR_DATA_Pos = 0x0    // Position of DATA field.
	ADC_DR_DATA_Msk = 0xffff // Bit mask of DATA field.
)

// Bitfields for DAC: Digital to analog converter
const (
	// CR: Control register (DAC_CR)
	DAC_CR_EN1_Pos       = 0x0        // Position of EN1 field.
	DAC_CR_EN1_Msk       = 0x1        // Bit mask of EN1 field.
	DAC_CR_EN1           = 0x1        // Bit EN1.
	DAC_CR_BOFF1_Pos     = 0x1        // Position of BOFF1 field.
	DAC_CR_BOFF1_Msk     = 0x2        // Bit mask of BOFF1 field.
	DAC_CR_BOFF1         = 0x2        // Bit BOFF1.
	DAC_CR_TEN1_Pos      = 0x2        // Position of TEN1 field.
	DAC_CR_TEN1_Msk      = 0x4        // Bit mask of TEN1 field.
	DAC_CR_TEN1          = 0x4        // Bit TEN1.
	DAC_CR_TSEL1_Pos     = 0x3        // Position of TSEL1 field.
	DAC_CR_TSEL1_Msk     = 0x38       // Bit mask of TSEL1 field.
	DAC_CR_WAVE1_Pos     = 0x6        // Position of WAVE1 field.
	DAC_CR_WAVE1_Msk     = 0xc0       // Bit mask of WAVE1 field.
	DAC_CR_MAMP1_Pos     = 0x8        // Position of MAMP1 field.
	DAC_CR_MAMP1_Msk     = 0xf00      // Bit mask of MAMP1 field.
	DAC_CR_DMAEN1_Pos    = 0xc        // Position of DMAEN1 field.
	DAC_CR_DMAEN1_Msk    = 0x1000     // Bit mask of DMAEN1 field.
	DAC_CR_DMAEN1        = 0x1000     // Bit DMAEN1.
	DAC_CR_EN2_Pos       = 0x10       // Position of EN2 field.
	DAC_CR_EN2_Msk       = 0x10000    // Bit mask of EN2 field.
	DAC_CR_EN2           = 0x10000    // Bit EN2.
	DAC_CR_BOFF2_Pos     = 0x11       // Position of BOFF2 field.
	DAC_CR_BOFF2_Msk     = 0x20000    // Bit mask of BOFF2 field.
	DAC_CR_BOFF2         = 0x20000    // Bit BOFF2.
	DAC_CR_TEN2_Pos      = 0x12       // Position of TEN2 field.
	DAC_CR_TEN2_Msk      = 0x40000    // Bit mask of TEN2 field.
	DAC_CR_TEN2          = 0x40000    // Bit TEN2.
	DAC_CR_TSEL2_Pos     = 0x13       // Position of TSEL2 field.
	DAC_CR_TSEL2_Msk     = 0x380000   // Bit mask of TSEL2 field.
	DAC_CR_WAVE2_Pos     = 0x16       // Position of WAVE2 field.
	DAC_CR_WAVE2_Msk     = 0xc00000   // Bit mask of WAVE2 field.
	DAC_CR_MAMP2_Pos     = 0x18       // Position of MAMP2 field.
	DAC_CR_MAMP2_Msk     = 0xf000000  // Bit mask of MAMP2 field.
	DAC_CR_DMAEN2_Pos    = 0x1c       // Position of DMAEN2 field.
	DAC_CR_DMAEN2_Msk    = 0x10000000 // Bit mask of DMAEN2 field.
	DAC_CR_DMAEN2        = 0x10000000 // Bit DMAEN2.
	DAC_CR_DMAUDRIE1_Pos = 0xd        // Position of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Msk = 0x2000     // Bit mask of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1     = 0x2000     // Bit DMAUDRIE1.
	DAC_CR_DMAUDRIE2_Pos = 0x1d       // Position of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Msk = 0x20000000 // Bit mask of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2     = 0x20000000 // Bit DMAUDRIE2.

	// SWTRIGR: DAC software trigger register           (DAC_SWTRIGR)
	DAC_SWTRIGR_SWTRIG1_Pos = 0x0 // Position of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Msk = 0x1 // Bit mask of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1     = 0x1 // Bit SWTRIG1.
	DAC_SWTRIGR_SWTRIG2_Pos = 0x1 // Position of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2_Msk = 0x2 // Bit mask of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2     = 0x2 // Bit SWTRIG2.

	// DHR12R1: DAC channel1 12-bit right-aligned data           holding register(DAC_DHR12R1)
	DAC_DHR12R1_DACC1DHR_Pos = 0x0   // Position of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Msk = 0xfff // Bit mask of DACC1DHR field.

	// DHR12L1: DAC channel1 12-bit left aligned data           holding register (DAC_DHR12L1)
	DAC_DHR12L1_DACC1DHR_Pos = 0x4    // Position of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Msk = 0xfff0 // Bit mask of DACC1DHR field.

	// DHR8R1: DAC channel1 8-bit right aligned data           holding register (DAC_DHR8R1)
	DAC_DHR8R1_DACC1DHR_Pos = 0x0  // Position of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Msk = 0xff // Bit mask of DACC1DHR field.

	// DHR12R2: DAC channel2 12-bit right aligned data           holding register (DAC_DHR12R2)
	DAC_DHR12R2_DACC2DHR_Pos = 0x0   // Position of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Msk = 0xfff // Bit mask of DACC2DHR field.

	// DHR12L2: DAC channel2 12-bit left aligned data           holding register (DAC_DHR12L2)
	DAC_DHR12L2_DACC2DHR_Pos = 0x4    // Position of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Msk = 0xfff0 // Bit mask of DACC2DHR field.

	// DHR8R2: DAC channel2 8-bit right-aligned data           holding register (DAC_DHR8R2)
	DAC_DHR8R2_DACC2DHR_Pos = 0x0  // Position of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Msk = 0xff // Bit mask of DACC2DHR field.

	// DHR12RD: Dual DAC 12-bit right-aligned data holding           register (DAC_DHR12RD), Bits 31:28 Reserved, Bits 15:12           Reserved
	DAC_DHR12RD_DACC1DHR_Pos = 0x0       // Position of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Msk = 0xfff     // Bit mask of DACC1DHR field.
	DAC_DHR12RD_DACC2DHR_Pos = 0x10      // Position of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Msk = 0xfff0000 // Bit mask of DACC2DHR field.

	// DHR12LD: DUAL DAC 12-bit left aligned data holding           register (DAC_DHR12LD), Bits 19:16 Reserved, Bits 3:0           Reserved
	DAC_DHR12LD_DACC1DHR_Pos = 0x4        // Position of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Msk = 0xfff0     // Bit mask of DACC1DHR field.
	DAC_DHR12LD_DACC2DHR_Pos = 0x14       // Position of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Msk = 0xfff00000 // Bit mask of DACC2DHR field.

	// DHR8RD: DUAL DAC 8-bit right aligned data holding           register (DAC_DHR8RD), Bits 31:16 Reserved
	DAC_DHR8RD_DACC1DHR_Pos = 0x0    // Position of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Msk = 0xff   // Bit mask of DACC1DHR field.
	DAC_DHR8RD_DACC2DHR_Pos = 0x8    // Position of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Msk = 0xff00 // Bit mask of DACC2DHR field.

	// DOR1: DAC channel1 data output register           (DAC_DOR1)
	DAC_DOR1_DACC1DOR_Pos = 0x0   // Position of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Msk = 0xfff // Bit mask of DACC1DOR field.

	// DOR2: DAC channel2 data output register           (DAC_DOR2)
	DAC_DOR2_DACC2DOR_Pos = 0x0   // Position of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Msk = 0xfff // Bit mask of DACC2DOR field.

	// SR: DAC status register
	DAC_SR_DMAUDR1_Pos = 0xd        // Position of DMAUDR1 field.
	DAC_SR_DMAUDR1_Msk = 0x2000     // Bit mask of DMAUDR1 field.
	DAC_SR_DMAUDR1     = 0x2000     // Bit DMAUDR1.
	DAC_SR_DMAUDR2_Pos = 0x1d       // Position of DMAUDR2 field.
	DAC_SR_DMAUDR2_Msk = 0x20000000 // Bit mask of DMAUDR2 field.
	DAC_SR_DMAUDR2     = 0x20000000 // Bit DMAUDR2.
)

// Bitfields for DBG: Debug support
const (
	// IDCODE: DBGMCU_IDCODE
	DBG_IDCODE_DEV_ID_Pos = 0x0        // Position of DEV_ID field.
	DBG_IDCODE_DEV_ID_Msk = 0xfff      // Bit mask of DEV_ID field.
	DBG_IDCODE_REV_ID_Pos = 0x10       // Position of REV_ID field.
	DBG_IDCODE_REV_ID_Msk = 0xffff0000 // Bit mask of REV_ID field.

	// CR: DBGMCU_CR
	DBG_CR_DBG_SLEEP_Pos              = 0x0       // Position of DBG_SLEEP field.
	DBG_CR_DBG_SLEEP_Msk              = 0x1       // Bit mask of DBG_SLEEP field.
	DBG_CR_DBG_SLEEP                  = 0x1       // Bit DBG_SLEEP.
	DBG_CR_DBG_STOP_Pos               = 0x1       // Position of DBG_STOP field.
	DBG_CR_DBG_STOP_Msk               = 0x2       // Bit mask of DBG_STOP field.
	DBG_CR_DBG_STOP                   = 0x2       // Bit DBG_STOP.
	DBG_CR_DBG_STANDBY_Pos            = 0x2       // Position of DBG_STANDBY field.
	DBG_CR_DBG_STANDBY_Msk            = 0x4       // Bit mask of DBG_STANDBY field.
	DBG_CR_DBG_STANDBY                = 0x4       // Bit DBG_STANDBY.
	DBG_CR_TRACE_IOEN_Pos             = 0x5       // Position of TRACE_IOEN field.
	DBG_CR_TRACE_IOEN_Msk             = 0x20      // Bit mask of TRACE_IOEN field.
	DBG_CR_TRACE_IOEN                 = 0x20      // Bit TRACE_IOEN.
	DBG_CR_TRACE_MODE_Pos             = 0x6       // Position of TRACE_MODE field.
	DBG_CR_TRACE_MODE_Msk             = 0xc0      // Bit mask of TRACE_MODE field.
	DBG_CR_DBG_IWDG_STOP_Pos          = 0x8       // Position of DBG_IWDG_STOP field.
	DBG_CR_DBG_IWDG_STOP_Msk          = 0x100     // Bit mask of DBG_IWDG_STOP field.
	DBG_CR_DBG_IWDG_STOP              = 0x100     // Bit DBG_IWDG_STOP.
	DBG_CR_DBG_WWDG_STOP_Pos          = 0x9       // Position of DBG_WWDG_STOP field.
	DBG_CR_DBG_WWDG_STOP_Msk          = 0x200     // Bit mask of DBG_WWDG_STOP field.
	DBG_CR_DBG_WWDG_STOP              = 0x200     // Bit DBG_WWDG_STOP.
	DBG_CR_DBG_TIM1_STOP_Pos          = 0xa       // Position of DBG_TIM1_STOP field.
	DBG_CR_DBG_TIM1_STOP_Msk          = 0x400     // Bit mask of DBG_TIM1_STOP field.
	DBG_CR_DBG_TIM1_STOP              = 0x400     // Bit DBG_TIM1_STOP.
	DBG_CR_DBG_TIM2_STOP_Pos          = 0xb       // Position of DBG_TIM2_STOP field.
	DBG_CR_DBG_TIM2_STOP_Msk          = 0x800     // Bit mask of DBG_TIM2_STOP field.
	DBG_CR_DBG_TIM2_STOP              = 0x800     // Bit DBG_TIM2_STOP.
	DBG_CR_DBG_TIM3_STOP_Pos          = 0xc       // Position of DBG_TIM3_STOP field.
	DBG_CR_DBG_TIM3_STOP_Msk          = 0x1000    // Bit mask of DBG_TIM3_STOP field.
	DBG_CR_DBG_TIM3_STOP              = 0x1000    // Bit DBG_TIM3_STOP.
	DBG_CR_DBG_TIM4_STOP_Pos          = 0xd       // Position of DBG_TIM4_STOP field.
	DBG_CR_DBG_TIM4_STOP_Msk          = 0x2000    // Bit mask of DBG_TIM4_STOP field.
	DBG_CR_DBG_TIM4_STOP              = 0x2000    // Bit DBG_TIM4_STOP.
	DBG_CR_DBG_I2C1_SMBUS_TIMEOUT_Pos = 0xf       // Position of DBG_I2C1_SMBUS_TIMEOUT field.
	DBG_CR_DBG_I2C1_SMBUS_TIMEOUT_Msk = 0x8000    // Bit mask of DBG_I2C1_SMBUS_TIMEOUT field.
	DBG_CR_DBG_I2C1_SMBUS_TIMEOUT     = 0x8000    // Bit DBG_I2C1_SMBUS_TIMEOUT.
	DBG_CR_DBG_I2C2_SMBUS_TIMEOUT_Pos = 0x10      // Position of DBG_I2C2_SMBUS_TIMEOUT field.
	DBG_CR_DBG_I2C2_SMBUS_TIMEOUT_Msk = 0x10000   // Bit mask of DBG_I2C2_SMBUS_TIMEOUT field.
	DBG_CR_DBG_I2C2_SMBUS_TIMEOUT     = 0x10000   // Bit DBG_I2C2_SMBUS_TIMEOUT.
	DBG_CR_DBG_TIM5_STOP_Pos          = 0x12      // Position of DBG_TIM5_STOP field.
	DBG_CR_DBG_TIM5_STOP_Msk          = 0x40000   // Bit mask of DBG_TIM5_STOP field.
	DBG_CR_DBG_TIM5_STOP              = 0x40000   // Bit DBG_TIM5_STOP.
	DBG_CR_DBG_TIM6_STOP_Pos          = 0x13      // Position of DBG_TIM6_STOP field.
	DBG_CR_DBG_TIM6_STOP_Msk          = 0x80000   // Bit mask of DBG_TIM6_STOP field.
	DBG_CR_DBG_TIM6_STOP              = 0x80000   // Bit DBG_TIM6_STOP.
	DBG_CR_DBG_TIM7_STOP_Pos          = 0x14      // Position of DBG_TIM7_STOP field.
	DBG_CR_DBG_TIM7_STOP_Msk          = 0x100000  // Bit mask of DBG_TIM7_STOP field.
	DBG_CR_DBG_TIM7_STOP              = 0x100000  // Bit DBG_TIM7_STOP.
	DBG_CR_DBG_TIM15_STOP_Pos         = 0x16      // Position of DBG_TIM15_STOP field.
	DBG_CR_DBG_TIM15_STOP_Msk         = 0x400000  // Bit mask of DBG_TIM15_STOP field.
	DBG_CR_DBG_TIM15_STOP             = 0x400000  // Bit DBG_TIM15_STOP.
	DBG_CR_DBG_TIM16_STOP_Pos         = 0x17      // Position of DBG_TIM16_STOP field.
	DBG_CR_DBG_TIM16_STOP_Msk         = 0x800000  // Bit mask of DBG_TIM16_STOP field.
	DBG_CR_DBG_TIM16_STOP             = 0x800000  // Bit DBG_TIM16_STOP.
	DBG_CR_DBG_TIM17_STOP_Pos         = 0x18      // Position of DBG_TIM17_STOP field.
	DBG_CR_DBG_TIM17_STOP_Msk         = 0x1000000 // Bit mask of DBG_TIM17_STOP field.
	DBG_CR_DBG_TIM17_STOP             = 0x1000000 // Bit DBG_TIM17_STOP.
	DBG_CR_DBG_TIM12_STOP_Pos         = 0x19      // Position of DBG_TIM12_STOP field.
	DBG_CR_DBG_TIM12_STOP_Msk         = 0x2000000 // Bit mask of DBG_TIM12_STOP field.
	DBG_CR_DBG_TIM12_STOP             = 0x2000000 // Bit DBG_TIM12_STOP.
	DBG_CR_DBG_TIM13_STOP_Pos         = 0x1a      // Position of DBG_TIM13_STOP field.
	DBG_CR_DBG_TIM13_STOP_Msk         = 0x4000000 // Bit mask of DBG_TIM13_STOP field.
	DBG_CR_DBG_TIM13_STOP             = 0x4000000 // Bit DBG_TIM13_STOP.
	DBG_CR_DBG_TIM14_STOP_Pos         = 0x1b      // Position of DBG_TIM14_STOP field.
	DBG_CR_DBG_TIM14_STOP_Msk         = 0x8000000 // Bit mask of DBG_TIM14_STOP field.
	DBG_CR_DBG_TIM14_STOP             = 0x8000000 // Bit DBG_TIM14_STOP.
)

// Bitfields for CRC: CRC calculation unit
const (
	// DR: Data register
	CRC_DR_DR_Pos = 0x0        // Position of DR field.
	CRC_DR_DR_Msk = 0xffffffff // Bit mask of DR field.

	// IDR: Independent Data register
	CRC_IDR_IDR_Pos = 0x0  // Position of IDR field.
	CRC_IDR_IDR_Msk = 0xff // Bit mask of IDR field.

	// CR: Control register
	CRC_CR_RESET_Pos = 0x0 // Position of RESET field.
	CRC_CR_RESET_Msk = 0x1 // Bit mask of RESET field.
	CRC_CR_RESET     = 0x1 // Bit RESET.
)

// Bitfields for FLASH: FLASH
const (
	// ACR: Flash access control register
	FLASH_ACR_HLFCYA_Pos = 0x3 // Position of HLFCYA field.
	FLASH_ACR_HLFCYA_Msk = 0x8 // Bit mask of HLFCYA field.
	FLASH_ACR_HLFCYA     = 0x8 // Bit HLFCYA.

	// KEYR: Flash key register
	FLASH_KEYR_KEY_Pos = 0x0        // Position of KEY field.
	FLASH_KEYR_KEY_Msk = 0xffffffff // Bit mask of KEY field.

	// OPTKEYR: Flash option key register
	FLASH_OPTKEYR_OPTKEY_Pos = 0x0        // Position of OPTKEY field.
	FLASH_OPTKEYR_OPTKEY_Msk = 0xffffffff // Bit mask of OPTKEY field.

	// SR: Status register
	FLASH_SR_EOP_Pos      = 0x5  // Position of EOP field.
	FLASH_SR_EOP_Msk      = 0x20 // Bit mask of EOP field.
	FLASH_SR_EOP          = 0x20 // Bit EOP.
	FLASH_SR_WRPRTERR_Pos = 0x4  // Position of WRPRTERR field.
	FLASH_SR_WRPRTERR_Msk = 0x10 // Bit mask of WRPRTERR field.
	FLASH_SR_WRPRTERR     = 0x10 // Bit WRPRTERR.
	FLASH_SR_PGERR_Pos    = 0x2  // Position of PGERR field.
	FLASH_SR_PGERR_Msk    = 0x4  // Bit mask of PGERR field.
	FLASH_SR_PGERR        = 0x4  // Bit PGERR.
	FLASH_SR_BSY_Pos      = 0x0  // Position of BSY field.
	FLASH_SR_BSY_Msk      = 0x1  // Bit mask of BSY field.
	FLASH_SR_BSY          = 0x1  // Bit BSY.

	// CR: Control register
	FLASH_CR_PG_Pos     = 0x0    // Position of PG field.
	FLASH_CR_PG_Msk     = 0x1    // Bit mask of PG field.
	FLASH_CR_PG         = 0x1    // Bit PG.
	FLASH_CR_PER_Pos    = 0x1    // Position of PER field.
	FLASH_CR_PER_Msk    = 0x2    // Bit mask of PER field.
	FLASH_CR_PER        = 0x2    // Bit PER.
	FLASH_CR_MER_Pos    = 0x2    // Position of MER field.
	FLASH_CR_MER_Msk    = 0x4    // Bit mask of MER field.
	FLASH_CR_MER        = 0x4    // Bit MER.
	FLASH_CR_OPTPG_Pos  = 0x4    // Position of OPTPG field.
	FLASH_CR_OPTPG_Msk  = 0x10   // Bit mask of OPTPG field.
	FLASH_CR_OPTPG      = 0x10   // Bit OPTPG.
	FLASH_CR_OPTER_Pos  = 0x5    // Position of OPTER field.
	FLASH_CR_OPTER_Msk  = 0x20   // Bit mask of OPTER field.
	FLASH_CR_OPTER      = 0x20   // Bit OPTER.
	FLASH_CR_STRT_Pos   = 0x6    // Position of STRT field.
	FLASH_CR_STRT_Msk   = 0x40   // Bit mask of STRT field.
	FLASH_CR_STRT       = 0x40   // Bit STRT.
	FLASH_CR_LOCK_Pos   = 0x7    // Position of LOCK field.
	FLASH_CR_LOCK_Msk   = 0x80   // Bit mask of LOCK field.
	FLASH_CR_LOCK       = 0x80   // Bit LOCK.
	FLASH_CR_OPTWRE_Pos = 0x9    // Position of OPTWRE field.
	FLASH_CR_OPTWRE_Msk = 0x200  // Bit mask of OPTWRE field.
	FLASH_CR_OPTWRE     = 0x200  // Bit OPTWRE.
	FLASH_CR_ERRIE_Pos  = 0xa    // Position of ERRIE field.
	FLASH_CR_ERRIE_Msk  = 0x400  // Bit mask of ERRIE field.
	FLASH_CR_ERRIE      = 0x400  // Bit ERRIE.
	FLASH_CR_EOPIE_Pos  = 0xc    // Position of EOPIE field.
	FLASH_CR_EOPIE_Msk  = 0x1000 // Bit mask of EOPIE field.
	FLASH_CR_EOPIE      = 0x1000 // Bit EOPIE.

	// AR: Flash address register
	FLASH_AR_FAR_Pos = 0x0        // Position of FAR field.
	FLASH_AR_FAR_Msk = 0xffffffff // Bit mask of FAR field.

	// OBR: Option byte register
	FLASH_OBR_OPTERR_Pos     = 0x0       // Position of OPTERR field.
	FLASH_OBR_OPTERR_Msk     = 0x1       // Bit mask of OPTERR field.
	FLASH_OBR_OPTERR         = 0x1       // Bit OPTERR.
	FLASH_OBR_RDPRT_Pos      = 0x1       // Position of RDPRT field.
	FLASH_OBR_RDPRT_Msk      = 0x2       // Bit mask of RDPRT field.
	FLASH_OBR_RDPRT          = 0x2       // Bit RDPRT.
	FLASH_OBR_WDG_SW_Pos     = 0x2       // Position of WDG_SW field.
	FLASH_OBR_WDG_SW_Msk     = 0x4       // Bit mask of WDG_SW field.
	FLASH_OBR_WDG_SW         = 0x4       // Bit WDG_SW.
	FLASH_OBR_NRST_STOP_Pos  = 0x3       // Position of NRST_STOP field.
	FLASH_OBR_NRST_STOP_Msk  = 0x8       // Bit mask of NRST_STOP field.
	FLASH_OBR_NRST_STOP      = 0x8       // Bit NRST_STOP.
	FLASH_OBR_NRST_STDBY_Pos = 0x4       // Position of NRST_STDBY field.
	FLASH_OBR_NRST_STDBY_Msk = 0x10      // Bit mask of NRST_STDBY field.
	FLASH_OBR_NRST_STDBY     = 0x10      // Bit NRST_STDBY.
	FLASH_OBR_Data0_Pos      = 0xa       // Position of Data0 field.
	FLASH_OBR_Data0_Msk      = 0x3fc00   // Bit mask of Data0 field.
	FLASH_OBR_Data1_Pos      = 0x12      // Position of Data1 field.
	FLASH_OBR_Data1_Msk      = 0x3fc0000 // Bit mask of Data1 field.

	// WRPR: Write protection register
	FLASH_WRPR_WRP_Pos = 0x0        // Position of WRP field.
	FLASH_WRPR_WRP_Msk = 0xffffffff // Bit mask of WRP field.
)

// Bitfields for CEC: HDMI-CEC controller
const (
	// CFGR: configuration register
	CEC_CFGR_PE_Pos   = 0x0 // Position of PE field.
	CEC_CFGR_PE_Msk   = 0x1 // Bit mask of PE field.
	CEC_CFGR_PE       = 0x1 // Bit PE.
	CEC_CFGR_IE_Pos   = 0x1 // Position of IE field.
	CEC_CFGR_IE_Msk   = 0x2 // Bit mask of IE field.
	CEC_CFGR_IE       = 0x2 // Bit IE.
	CEC_CFGR_BTEM_Pos = 0x2 // Position of BTEM field.
	CEC_CFGR_BTEM_Msk = 0x4 // Bit mask of BTEM field.
	CEC_CFGR_BTEM     = 0x4 // Bit BTEM.
	CEC_CFGR_BPEM_Pos = 0x3 // Position of BPEM field.
	CEC_CFGR_BPEM_Msk = 0x8 // Bit mask of BPEM field.
	CEC_CFGR_BPEM     = 0x8 // Bit BPEM.

	// OAR: CEC own address register
	CEC_OAR_OA_Pos = 0x0 // Position of OA field.
	CEC_OAR_OA_Msk = 0xf // Bit mask of OA field.

	// PRES: Rx Data Register
	CEC_PRES_PRESC_Pos = 0x0    // Position of PRESC field.
	CEC_PRES_PRESC_Msk = 0x3fff // Bit mask of PRESC field.

	// ESR: CEC error status register
	CEC_ESR_BTE_Pos   = 0x0  // Position of BTE field.
	CEC_ESR_BTE_Msk   = 0x1  // Bit mask of BTE field.
	CEC_ESR_BTE       = 0x1  // Bit BTE.
	CEC_ESR_BPE_Pos   = 0x1  // Position of BPE field.
	CEC_ESR_BPE_Msk   = 0x2  // Bit mask of BPE field.
	CEC_ESR_BPE       = 0x2  // Bit BPE.
	CEC_ESR_RBTFE_Pos = 0x2  // Position of RBTFE field.
	CEC_ESR_RBTFE_Msk = 0x4  // Bit mask of RBTFE field.
	CEC_ESR_RBTFE     = 0x4  // Bit RBTFE.
	CEC_ESR_SBE_Pos   = 0x3  // Position of SBE field.
	CEC_ESR_SBE_Msk   = 0x8  // Bit mask of SBE field.
	CEC_ESR_SBE       = 0x8  // Bit SBE.
	CEC_ESR_ACKE_Pos  = 0x4  // Position of ACKE field.
	CEC_ESR_ACKE_Msk  = 0x10 // Bit mask of ACKE field.
	CEC_ESR_ACKE      = 0x10 // Bit ACKE.
	CEC_ESR_LINE_Pos  = 0x5  // Position of LINE field.
	CEC_ESR_LINE_Msk  = 0x20 // Bit mask of LINE field.
	CEC_ESR_LINE      = 0x20 // Bit LINE.
	CEC_ESR_TBTFE_Pos = 0x6  // Position of TBTFE field.
	CEC_ESR_TBTFE_Msk = 0x40 // Bit mask of TBTFE field.
	CEC_ESR_TBTFE     = 0x40 // Bit TBTFE.

	// CSR: CEC control and status           register
	CEC_CSR_TSOM_Pos  = 0x0  // Position of TSOM field.
	CEC_CSR_TSOM_Msk  = 0x1  // Bit mask of TSOM field.
	CEC_CSR_TSOM      = 0x1  // Bit TSOM.
	CEC_CSR_TEOM_Pos  = 0x1  // Position of TEOM field.
	CEC_CSR_TEOM_Msk  = 0x2  // Bit mask of TEOM field.
	CEC_CSR_TEOM      = 0x2  // Bit TEOM.
	CEC_CSR_TERR_Pos  = 0x2  // Position of TERR field.
	CEC_CSR_TERR_Msk  = 0x4  // Bit mask of TERR field.
	CEC_CSR_TERR      = 0x4  // Bit TERR.
	CEC_CSR_TBTRF_Pos = 0x3  // Position of TBTRF field.
	CEC_CSR_TBTRF_Msk = 0x8  // Bit mask of TBTRF field.
	CEC_CSR_TBTRF     = 0x8  // Bit TBTRF.
	CEC_CSR_RSOM_Pos  = 0x4  // Position of RSOM field.
	CEC_CSR_RSOM_Msk  = 0x10 // Bit mask of RSOM field.
	CEC_CSR_RSOM      = 0x10 // Bit RSOM.
	CEC_CSR_REOM_Pos  = 0x5  // Position of REOM field.
	CEC_CSR_REOM_Msk  = 0x20 // Bit mask of REOM field.
	CEC_CSR_REOM      = 0x20 // Bit REOM.
	CEC_CSR_RERR_Pos  = 0x6  // Position of RERR field.
	CEC_CSR_RERR_Msk  = 0x40 // Bit mask of RERR field.
	CEC_CSR_RERR      = 0x40 // Bit RERR.
	CEC_CSR_RBTF_Pos  = 0x7  // Position of RBTF field.
	CEC_CSR_RBTF_Msk  = 0x80 // Bit mask of RBTF field.
	CEC_CSR_RBTF      = 0x80 // Bit RBTF.

	// TXD: CEC Tx data register
	CEC_TXD_TXD_Pos = 0x0  // Position of TXD field.
	CEC_TXD_TXD_Msk = 0xff // Bit mask of TXD field.

	// RXD: CEC Rx data register
	CEC_RXD_RXD_Pos = 0x0  // Position of RXD field.
	CEC_RXD_RXD_Msk = 0xff // Bit mask of RXD field.
)

// Bitfields for NVIC: Nested Vectored Interrupt Controller
const (
	// ICTR: Interrupt Controller Type           Register
	NVIC_ICTR_INTLINESNUM_Pos = 0x0 // Position of INTLINESNUM field.
	NVIC_ICTR_INTLINESNUM_Msk = 0xf // Bit mask of INTLINESNUM field.

	// ISER0: Interrupt Set-Enable Register
	NVIC_ISER0_SETENA_Pos = 0x0        // Position of SETENA field.
	NVIC_ISER0_SETENA_Msk = 0xffffffff // Bit mask of SETENA field.

	// ISER1: Interrupt Set-Enable Register
	NVIC_ISER1_SETENA_Pos = 0x0        // Position of SETENA field.
	NVIC_ISER1_SETENA_Msk = 0xffffffff // Bit mask of SETENA field.

	// ICER0: Interrupt Clear-Enable           Register
	NVIC_ICER0_CLRENA_Pos = 0x0        // Position of CLRENA field.
	NVIC_ICER0_CLRENA_Msk = 0xffffffff // Bit mask of CLRENA field.

	// ICER1: Interrupt Clear-Enable           Register
	NVIC_ICER1_CLRENA_Pos = 0x0        // Position of CLRENA field.
	NVIC_ICER1_CLRENA_Msk = 0xffffffff // Bit mask of CLRENA field.

	// ISPR0: Interrupt Set-Pending Register
	NVIC_ISPR0_SETPEND_Pos = 0x0        // Position of SETPEND field.
	NVIC_ISPR0_SETPEND_Msk = 0xffffffff // Bit mask of SETPEND field.

	// ISPR1: Interrupt Set-Pending Register
	NVIC_ISPR1_SETPEND_Pos = 0x0        // Position of SETPEND field.
	NVIC_ISPR1_SETPEND_Msk = 0xffffffff // Bit mask of SETPEND field.

	// ICPR0: Interrupt Clear-Pending           Register
	NVIC_ICPR0_CLRPEND_Pos = 0x0        // Position of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Msk = 0xffffffff // Bit mask of CLRPEND field.

	// ICPR1: Interrupt Clear-Pending           Register
	NVIC_ICPR1_CLRPEND_Pos = 0x0        // Position of CLRPEND field.
	NVIC_ICPR1_CLRPEND_Msk = 0xffffffff // Bit mask of CLRPEND field.

	// IABR0: Interrupt Active Bit Register
	NVIC_IABR0_ACTIVE_Pos = 0x0        // Position of ACTIVE field.
	NVIC_IABR0_ACTIVE_Msk = 0xffffffff // Bit mask of ACTIVE field.

	// IABR1: Interrupt Active Bit Register
	NVIC_IABR1_ACTIVE_Pos = 0x0        // Position of ACTIVE field.
	NVIC_IABR1_ACTIVE_Msk = 0xffffffff // Bit mask of ACTIVE field.

	// IPR0: Interrupt Priority Register
	NVIC_IPR0_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR0_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR0_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR0_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR1: Interrupt Priority Register
	NVIC_IPR1_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR1_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR1_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR1_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR2: Interrupt Priority Register
	NVIC_IPR2_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR2_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR2_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR2_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR3: Interrupt Priority Register
	NVIC_IPR3_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR3_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR3_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR3_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR4: Interrupt Priority Register
	NVIC_IPR4_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR4_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR4_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR4_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR5: Interrupt Priority Register
	NVIC_IPR5_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR5_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR5_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR5_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR6: Interrupt Priority Register
	NVIC_IPR6_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR6_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR6_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR6_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR7: Interrupt Priority Register
	NVIC_IPR7_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR7_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR7_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR7_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR8: Interrupt Priority Register
	NVIC_IPR8_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR8_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR8_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR8_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR9: Interrupt Priority Register
	NVIC_IPR9_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR9_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR9_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR9_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR9_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR9_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR9_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR9_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR10: Interrupt Priority Register
	NVIC_IPR10_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR10_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR10_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR10_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR10_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR10_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR10_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR10_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR11: Interrupt Priority Register
	NVIC_IPR11_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR11_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR11_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR11_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR11_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR11_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR11_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR11_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR12: Interrupt Priority Register
	NVIC_IPR12_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR12_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR12_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR12_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR12_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR12_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR12_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR12_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR13: Interrupt Priority Register
	NVIC_IPR13_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR13_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR13_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR13_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR13_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR13_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR13_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR13_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR14: Interrupt Priority Register
	NVIC_IPR14_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR14_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR14_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR14_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR14_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR14_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR14_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR14_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// STIR: Software Triggered Interrupt           Register
	NVIC_STIR_INTID_Pos = 0x0   // Position of INTID field.
	NVIC_STIR_INTID_Msk = 0x1ff // Bit mask of INTID field.
)
