/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.StackOverflowPreventedException;
import com.intellij.reference.SoftReference;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecursionManager {
    private static final Logger LOG = Logger.getInstance(RecursionManager.class);
    private static final ThreadLocal<CalculationStack> ourStack = ThreadLocal.withInitial(() -> new CalculationStack());
    private static final AtomicBoolean ourAssertOnPrevention = new AtomicBoolean();
    private static final AtomicBoolean ourAssertOnMissedCache = new AtomicBoolean();
    private static final String[] toleratedFrames = new String[]{"com.intellij.psi.impl.source.xml.XmlAttributeImpl.getDescriptor(", "com.intellij.lang.aspectj.psi.impl.PsiInterTypeReferenceImpl.", "com.intellij.psi.impl.search.JavaDirectInheritorsSearcher.processConcurrentlyIfTooMany(", "com.intellij.lang.javascript.psi.resolve.JSEvaluatorComplexityTracker.doRunTask(", "com.intellij.lang.javascript.ecmascript6.types.JSTypeSignatureChooser.chooseOverload(", "com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator.getElementType(", "com.intellij.lang.ecmascript6.psi.impl.ES6ImportSpecifierImpl.multiResolve(", "com.intellij.lang.javascript.psi.types.JSTypeBaseImpl.substitute(", "org.jetbrains.plugins.groovy.intentions.style.inference.InferenceProcessKt.runInferenceProcess(", "com.intellij.psi.infos.MethodCandidateInfo.getPertinentApplicabilityLevel(", "com.intellij.psi.ThreadLocalTypes.performWithTypes(", "com.intellij.xml.impl.schema.XmlNSDescriptorImpl.getRedefinedElementDescriptor(", "com.intellij.psi.impl.source.xml.XmlTagImpl.getDescriptor(", "com.intellij.psi.impl.source.xml.XmlTagDelegate.getNSDescriptor(", "com.intellij.xml.impl.schema.XmlNSDescriptorImpl.findTypeDescriptor(", "com.intellij.psi.impl.source.xml.XmlEntityRefImpl.doResolveEntity(", "com.intellij.xml.impl.dtd.XmlNSDescriptorImpl.getElementDescriptor(", "com.jetbrains.python.psi.PyKnownDecoratorUtil.resolveDecorator(", "com.jetbrains.python.psi.impl.references.PyReferenceImpl.multiResolve("};

    @Nullable
    public static <T> T doPreventingRecursion(@NotNull Object key, boolean memoize, Computable<T> computation) {
        if (key == null) {
            RecursionManager.$$$reportNull$$$0(0);
        }
        return RecursionManager.createGuard(computation.getClass().getName()).doPreventingRecursion(key, memoize, computation);
    }

    @NotNull
    public static <Key> RecursionGuard<Key> createGuard(final @NonNls String id) {
        return new RecursionGuard<Key>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <T> T doPreventingRecursion(@NotNull Key key, boolean memoize, @NotNull Computable<T> computation) {
                MemoizedValue memoized;
                if (key == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (computation == null) {
                    1.$$$reportNull$$$0(1);
                }
                MyKey realKey = new MyKey(id, key, true);
                CalculationStack stack = (CalculationStack)ourStack.get();
                if (stack.checkReentrancy(realKey)) {
                    if (ourAssertOnPrevention.get()) {
                        throw new StackOverflowPreventedException("Endless recursion prevention occurred on " + key);
                    }
                    return null;
                }
                if (memoize && (memoized = stack.getMemoizedValue(realKey)) != null) {
                    for (MyKey noCacheUntil : memoized.dependencies) {
                        stack.prohibitResultCaching(noCacheUntil);
                    }
                    return (T)memoized.value;
                }
                realKey = new MyKey(id, key, false);
                int sizeBefore = stack.progressMap.size();
                stack.beforeComputation(realKey);
                int sizeAfter = stack.progressMap.size();
                THashSet preventionsBefore = memoize ? new THashSet(stack.preventions.keySet()) : Collections.emptySet();
                try {
                    T result2 = computation.compute();
                    if (memoize) {
                        stack.maybeMemoize(realKey, result2, (Set<MyKey>)preventionsBefore);
                    }
                    T t = result2;
                    return t;
                }
                finally {
                    try {
                        stack.afterComputation(realKey, sizeBefore, sizeAfter);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("Throwable in afterComputation", e);
                    }
                    stack.checkDepth("4");
                }
            }

            @Override
            @NotNull
            public List<Key> currentStack() {
                ArrayList<Object> result2 = new ArrayList<Object>();
                LinkedHashMap map2 = ((CalculationStack)ourStack.get()).progressMap;
                for (MyKey pair : map2.keySet()) {
                    if (!pair.guardId.equals(id)) continue;
                    result2.add(pair.userObject);
                }
                List list2 = Collections.unmodifiableList(result2);
                if (list2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return list2;
            }

            @Override
            public void prohibitResultCaching(@NotNull Object since) {
                if (since == null) {
                    1.$$$reportNull$$$0(3);
                }
                MyKey realKey = new MyKey(id, since, false);
                CalculationStack stack = (CalculationStack)ourStack.get();
                stack.prohibitResultCaching(realKey);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "computation";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/util/RecursionManager$1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "since";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/util/RecursionManager$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "currentStack";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doPreventingRecursion";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "prohibitResultCaching";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public static RecursionGuard.StackStamp markStack() {
        final int stamp = ourStack.get().reentrancyCount;
        return new RecursionGuard.StackStamp(){

            @Override
            public boolean mayCacheNow() {
                boolean result2;
                CalculationStack stack = (CalculationStack)ourStack.get();
                boolean bl = result2 = stamp == stack.reentrancyCount;
                if (!result2 && ourAssertOnMissedCache.get() && !stack.isCurrentNonCachingStillTolerated()) {
                    throw new CachingPreventedException(stack.preventions);
                }
                return result2;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/util/RecursionManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doPreventingRecursion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "assertOnRecursionPrevention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setFlag";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "disableAssertOnRecursionPrevention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "disableMissedCacheAssertions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "assertOnMissedCache";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class CachingPreventedException
    extends RuntimeException {
        CachingPreventedException(Map<MyKey, Throwable> preventions) {
            super("Caching disabled due to recursion prevention, please get rid of cyclic dependencies. Preventions: " + new ArrayList<MyKey>(preventions.keySet()), ContainerUtil.getFirstItem(preventions.values()));
        }
    }

    private static class MemoizedValue {
        final Object value;
        final MyKey[] dependencies;

        MemoizedValue(Object value2, MyKey[] dependencies2) {
            this.value = value2;
            this.dependencies = dependencies2;
        }

        boolean isActual(CalculationStack stack) {
            return Stream.of(this.dependencies).allMatch(stack.progressMap::containsKey);
        }
    }

    private static class CalculationStack {
        private int reentrancyCount;
        private int depth;
        private final LinkedHashMap<MyKey, Integer> progressMap = new LinkedHashMap();
        private final Map<MyKey, Throwable> preventions = ContainerUtil.newIdentityTroveMap();
        private final Map<MyKey, List<SoftReference<MemoizedValue>>> intermediateCache = ContainerUtil.createSoftMap();
        private int enters;
        private int exits;

        private CalculationStack() {
        }

        boolean checkReentrancy(MyKey realKey) {
            if (this.progressMap.containsKey(realKey)) {
                this.prohibitResultCaching(realKey);
                return true;
            }
            return false;
        }

        @Nullable
        MemoizedValue getMemoizedValue(MyKey realKey) {
            List<SoftReference<MemoizedValue>> refs = this.intermediateCache.get(realKey);
            if (refs != null) {
                for (SoftReference<MemoizedValue> ref : refs) {
                    MemoizedValue value2 = SoftReference.dereference(ref);
                    if (value2 == null || !value2.isActual(this)) continue;
                    return value2;
                }
            }
            return null;
        }

        final void beforeComputation(MyKey realKey) {
            ++this.enters;
            if (this.progressMap.isEmpty()) assert (this.reentrancyCount == 0) : "Non-zero stamp with empty stack: " + this.reentrancyCount;
            this.checkDepth("1");
            int sizeBefore = this.progressMap.size();
            this.progressMap.put(realKey, this.reentrancyCount);
            ++this.depth;
            this.checkDepth("2");
            int sizeAfter = this.progressMap.size();
            if (sizeAfter != sizeBefore + 1) {
                LOG.error("Key doesn't lead to the map size increase: " + sizeBefore + " " + sizeAfter + " " + realKey.userObject);
            }
        }

        void maybeMemoize(MyKey realKey, @Nullable Object result2, Set<MyKey> preventionsBefore) {
            if (this.preventions.size() > preventionsBefore.size()) {
                List<MyKey> added = ContainerUtil.findAll(this.preventions.keySet(), key -> key != realKey && !preventionsBefore.contains(key));
                this.intermediateCache.computeIfAbsent(realKey, __ -> new SmartList()).add(new SoftReference<MemoizedValue>(new MemoizedValue(result2, added.toArray(new MyKey[0]))));
            }
        }

        final void afterComputation(MyKey realKey, int sizeBefore, int sizeAfter) {
            ++this.exits;
            if (sizeAfter != this.progressMap.size()) {
                LOG.error("Map size changed: " + this.progressMap.size() + " " + sizeAfter + " " + realKey.userObject);
            }
            if (this.depth != this.progressMap.size()) {
                LOG.error("Inconsistent depth after computation; depth=" + this.depth + "; map=" + this.progressMap);
            }
            Integer value2 = (Integer)this.progressMap.remove(realKey);
            --this.depth;
            if (!this.preventions.isEmpty()) {
                this.preventions.remove(realKey);
            }
            if (this.depth == 0) {
                this.intermediateCache.clear();
            }
            if (sizeBefore != this.progressMap.size()) {
                LOG.error("Map size doesn't decrease: " + this.progressMap.size() + " " + sizeBefore + " " + realKey.userObject);
            }
            this.reentrancyCount = value2;
        }

        private void prohibitResultCaching(MyKey realKey) {
            ++this.reentrancyCount;
            ArrayList<Map.Entry<MyKey, Integer>> stack = new ArrayList<Map.Entry<MyKey, Integer>>(this.progressMap.entrySet());
            int loopStart = ContainerUtil.indexOf(stack, entry -> ((MyKey)entry.getKey()).equals(realKey));
            if (loopStart >= 0) {
                MyKey loopStartKey = (MyKey)((Map.Entry)stack.get(loopStart)).getKey();
                if (!this.preventions.containsKey(loopStartKey)) {
                    this.preventions.put(loopStartKey, ourAssertOnMissedCache.get() ? new StackOverflowPreventedException(null) : null);
                }
                for (int i = loopStart + 1; i < stack.size(); ++i) {
                    ((Map.Entry)stack.get(i)).setValue(this.reentrancyCount);
                }
                if (LOG.isDebugEnabled() && loopStart < stack.size() - 1) {
                    LOG.debug("Recursion prevented for " + realKey + ", caching disabled for " + ContainerUtil.map(stack.subList(loopStart, stack.size()), Map.Entry::getKey));
                }
            }
        }

        private void checkDepth(String s) {
            int oldDepth = this.depth;
            if (oldDepth != this.progressMap.size()) {
                this.depth = this.progressMap.size();
                throw new AssertionError((Object)("_Inconsistent depth " + s + "; depth=" + oldDepth + "; enters=" + this.enters + "; exits=" + this.exits + "; map=" + this.progressMap));
            }
        }

        boolean isCurrentNonCachingStillTolerated() {
            return CalculationStack.isCurrentNonCachingStillTolerated(new Throwable()) || ContainerUtil.exists(this.preventions.values(), CalculationStack::isCurrentNonCachingStillTolerated);
        }

        private static boolean isCurrentNonCachingStillTolerated(Throwable t) {
            String trace = ExceptionUtil.getThrowableText(t);
            return ContainerUtil.exists(toleratedFrames, trace::contains);
        }
    }

    private static class MyKey {
        final String guardId;
        final Object userObject;
        private final int myHashCode;
        private final boolean myCallEquals;

        MyKey(String guardId, @NotNull Object userObject, boolean mayCallEquals) {
            if (userObject == null) {
                MyKey.$$$reportNull$$$0(0);
            }
            this.guardId = guardId;
            this.userObject = userObject;
            LOG.assertTrue(!userObject.getClass().isArray(), "Arrays use the default hashCode/equals implementation");
            this.myHashCode = guardId.hashCode() * 31 + userObject.hashCode();
            this.myCallEquals = mayCallEquals;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MyKey) || !this.guardId.equals(((MyKey)obj).guardId)) {
                return false;
            }
            if (this.userObject == ((MyKey)obj).userObject) {
                return true;
            }
            if (this.myCallEquals || ((MyKey)obj).myCallEquals) {
                return this.userObject.equals(((MyKey)obj).userObject);
            }
            return false;
        }

        public int hashCode() {
            return this.myHashCode;
        }

        public String toString() {
            return this.guardId + "->" + this.userObject;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userObject", "com/intellij/openapi/util/RecursionManager$MyKey", "<init>"));
        }
    }
}

