/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js;

import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AbstractAnalyzerWithCompilerReport;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataVersion;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.CreatePhaseConfigKt;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.extensions.ScriptEvaluationExtension;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.js.K2JsIrCompilerKt;
import org.jetbrains.kotlin.cli.js.ProduceKind;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalNextRoundChecker;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.ir.backend.js.CompilerKt;
import org.jetbrains.kotlin.ir.backend.js.CompilerResult;
import org.jetbrains.kotlin.ir.backend.js.JsCode;
import org.jetbrains.kotlin.ir.backend.js.JsIrCompilationError;
import org.jetbrains.kotlin.ir.backend.js.JsLibraryResolverKt;
import org.jetbrains.kotlin.ir.backend.js.JsLoweringPhasesKt;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.MainModule;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.persistent.PersistentIrFactory;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.js.config.ErrorTolerancePolicy;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.resolver.KotlinLibraryResolveResult;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.StringsKt;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u001a\u0010\u001c\u001a\u00020\u0019*\b\u0012\u0004\u0012\u00020\u00170\u001d2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/cli/js/K2JsIrCompiler;", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "()V", "performanceManager", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "getPerformanceManager", "()Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "createArguments", "createMetadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "versionArray", "", "doExecute", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "arguments", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "rootDisposable", "Lcom/intellij/openapi/Disposable;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "executableScriptFileName", "", "setupPlatformSpecificArgumentsAndServices", "", "services", "Lorg/jetbrains/kotlin/config/Services;", "addPlatformOptions", "", "Companion", "cli-js"})
public final class K2JsIrCompiler
extends CLICompiler<K2JSCompilerArguments> {
    private final CommonCompilerPerformanceManager performanceManager = new CommonCompilerPerformanceManager("Kotlin to JS (IR) Compiler"){};
    private static final Map<String, ModuleKind> moduleKindMap;
    private static final Map<String, SourceMapSourceEmbedding> sourceMapContentEmbeddingMap;
    private static final Map<String, ProduceKind> produceMap;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    protected CommonCompilerPerformanceManager getPerformanceManager() {
        return this.performanceManager;
    }

    @Override
    @NotNull
    public K2JSCompilerArguments createArguments() {
        return new K2JSCompilerArguments();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JSCompilerArguments arguments2, @NotNull CompilerConfiguration configuration, @NotNull Disposable rootDisposable, @Nullable KotlinPaths paths) {
        boolean bl;
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        Intrinsics.checkNotNullParameter(rootDisposable, "rootDisposable");
        MessageCollector messageCollector = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue(messageCollector, "configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        MessageCollector messageCollector2 = messageCollector;
        ExitCode pluginLoadResult = this.loadPlugins(paths, (CommonCompilerArguments)arguments2, configuration);
        if (pluginLoadResult != ExitCode.OK) {
            return pluginLoadResult;
        }
        if (arguments2.getScript()) {
            Object v2;
            KotlinCoreEnvironment.ProjectEnvironment projectEnv;
            block38: {
                if (!arguments2.getEnableJsScripting()) {
                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Script for K/JS should be enabled explicitly, see -Xenable-js-scripting", null, 4, null);
                    return ExitCode.COMPILATION_ERROR;
                }
                configuration.put(CommonConfigurationKeys.MODULE_NAME, "repl.kts");
                KotlinCoreApplicationEnvironment environment = KotlinCoreEnvironment.Companion.getOrCreateApplicationEnvironmentForProduction(rootDisposable, configuration);
                projectEnv = new KotlinCoreEnvironment.ProjectEnvironment(rootDisposable, environment);
                projectEnv.registerExtensionsFromPlugins(configuration);
                MockProject mockProject = projectEnv.getProject();
                Intrinsics.checkNotNullExpressionValue(mockProject, "projectEnv.project");
                List scriptingEvaluators = ScriptEvaluationExtension.Companion.getInstances(mockProject);
                Iterable iterable = scriptingEvaluators;
                boolean bl2 = false;
                Iterable iterable2 = iterable;
                boolean bl3 = false;
                for (Object t : iterable2) {
                    ScriptEvaluationExtension it = (ScriptEvaluationExtension)t;
                    boolean bl4 = false;
                    if (!it.isAccepted(arguments2)) continue;
                    v2 = t;
                    break block38;
                }
                v2 = null;
            }
            ScriptEvaluationExtension scriptingEvaluator = v2;
            if (scriptingEvaluator == null) {
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Unable to evaluate script, no scripting plugin loaded", null, 4, null);
                return ExitCode.COMPILATION_ERROR;
            }
            return scriptingEvaluator.eval(arguments2, configuration, projectEnv);
        }
        if (arguments2.getFreeArgs().isEmpty() && !IncrementalCompilation.isEnabledForJs()) {
            if (arguments2.getVersion()) {
                return ExitCode.OK;
            }
            CharSequence environment = arguments2.getIncludes();
            boolean projectEnv = false;
            boolean scriptingEvaluators = false;
            if (environment == null || environment.length() == 0) {
                messageCollector2.report(CompilerMessageSeverity.ERROR, "Specify at least one source file or directory", null);
                return ExitCode.COMPILATION_ERROR;
            }
        }
        List<String> libraries = CollectionsKt.plus((Collection)K2JsIrCompiler.Companion.configureLibraries(arguments2.getLibraries()), (Iterable)CollectionsKt.listOfNotNull(arguments2.getIncludes()));
        List friendLibraries = K2JsIrCompiler.Companion.configureLibraries(arguments2.getFriendModules());
        configuration.put(JSConfigurationKeys.LIBRARIES, libraries);
        configuration.put(JSConfigurationKeys.TRANSITIVE_LIBRARIES, libraries);
        String[] commonSourcesArray = arguments2.getCommonSources();
        Object object = commonSourcesArray;
        if (commonSourcesArray == null || (object = ArraysKt.toSet(object)) == null) {
            object = SetsKt.emptySet();
        }
        Object commonSources = object;
        for (String arg : arguments2.getFreeArgs()) {
            ContentRootsKt.addKotlinSourceRoot(configuration, arg, commonSources.contains(arg));
        }
        KotlinCoreEnvironment environmentForJS = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration, EnvironmentConfigFiles.JS_CONFIG_FILES);
        Project projectJs = environmentForJS.getProject();
        CompilerConfiguration configurationJs = environmentForJS.getConfiguration();
        List<KtFile> sourcesFiles = environmentForJS.getSourceFiles();
        configurationJs.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments2.getAllowKotlinPackage());
        if (!UtilsKt.checkKotlinPackageUsage(environmentForJS, (Collection<? extends KtFile>)sourcesFiles)) {
            return ExitCode.COMPILATION_ERROR;
        }
        String outputFilePath = arguments2.getOutputFile();
        if (outputFilePath == null) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "IR: Specify output file via -output", null);
            return ExitCode.COMPILATION_ERROR;
        }
        if (messageCollector2.hasErrors()) {
            return ExitCode.COMPILATION_ERROR;
        }
        if (sourcesFiles.isEmpty() && !IncrementalCompilation.isEnabledForJs()) {
            CharSequence charSequence = arguments2.getIncludes();
            boolean it = false;
            boolean bl4 = false;
            if (charSequence == null || charSequence.length() == 0) {
                messageCollector2.report(CompilerMessageSeverity.ERROR, "No source files", null);
                return ExitCode.COMPILATION_ERROR;
            }
        }
        if (arguments2.getVerbose()) {
            K2JsIrCompiler.Companion.reportCompiledSourcesList(messageCollector2, sourcesFiles);
        }
        File outputFile = new File(outputFilePath);
        String string2 = arguments2.getIrModuleName();
        if (string2 == null) {
            String string3 = FileUtil.getNameWithoutExtension(outputFile);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "FileUtil.getNameWithoutExtension(outputFile)");
        }
        configurationJs.put(CommonConfigurationKeys.MODULE_NAME, string2);
        JsConfig config = new JsConfig(projectJs, configurationJs);
        File file2 = outputFile.getParentFile();
        if (file2 == null) {
            File file3 = outputFile.getAbsoluteFile();
            Intrinsics.checkNotNullExpressionValue(file3, "outputFile.absoluteFile");
            File file4 = file3.getParentFile();
            file2 = file4;
            Intrinsics.checkNotNull(file4);
        }
        File outputDir2 = file2;
        try {
            config.getConfiguration().put(JSConfigurationKeys.OUTPUT_DIR, outputDir2.getCanonicalFile());
        }
        catch (IOException e) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Could not resolve output directory", null);
            return ExitCode.COMPILATION_ERROR;
        }
        List mainCallArguments = Intrinsics.areEqual("noCall", arguments2.getMain()) ? null : CollectionsKt.emptyList();
        MessageCollector messageCollector3 = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (messageCollector3 == null) {
            String string4 = "Could not find message collector";
            boolean bl5 = false;
            throw (Throwable)new IllegalStateException(string4.toString());
        }
        Intrinsics.checkNotNullExpressionValue(messageCollector3, "configuration[CLIConfigu\u2026 find message collector\")");
        KotlinLibraryResolveResult resolvedLibraries = JsLibraryResolverKt.jsResolveLibraries(libraries, K2JsIrCompilerKt.messageCollectorLogger(messageCollector3));
        Iterable $this$map$iv = friendLibraries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string5 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl6 = false;
            String string6 = new File((String)it).getAbsolutePath();
            collection.add(string6);
        }
        List friendAbsolutePaths = (List)destination$iv$iv;
        Iterable $this$filter$iv = KotlinLibraryResolveResult.DefaultImpls.getFullList$default(resolvedLibraries, null, 1, null);
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinLibrary it = (KotlinLibrary)element$iv$iv;
            bl = false;
            if (!friendAbsolutePaths.contains(it.getLibraryFile().getAbsolutePath())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List friendDependencies = (List)destination$iv$iv2;
        if (arguments2.getIrProduceKlibDir() || arguments2.getIrProduceKlibFile()) {
            String outputKlibPath = arguments2.getIrProduceKlibDir() ? new File(outputFilePath).getParent() : outputFilePath;
            try {
                Project project = config.getProject();
                Intrinsics.checkNotNullExpressionValue(project, "config.project");
                CompilerConfiguration compilerConfiguration = config.getConfiguration();
                Intrinsics.checkNotNullExpressionValue(compilerConfiguration, "config.configuration");
                AbstractAnalyzerWithCompilerReport abstractAnalyzerWithCompilerReport = new AnalyzerWithCompilerReport(compilerConfiguration);
                CompilerConfiguration compilerConfiguration2 = config.getConfiguration();
                Intrinsics.checkNotNullExpressionValue(compilerConfiguration2, "config.configuration");
                IrFactory irFactory = PersistentIrFactory.INSTANCE;
                String string7 = outputKlibPath;
                Intrinsics.checkNotNullExpressionValue(string7, "outputKlibPath");
                KlibKt.generateKLib(project, sourcesFiles, abstractAnalyzerWithCompilerReport, compilerConfiguration2, resolvedLibraries, friendDependencies, irFactory, string7, arguments2.getIrProduceKlibDir());
            }
            catch (JsIrCompilationError e) {
                return ExitCode.COMPILATION_ERROR;
            }
        }
        if (arguments2.getIrProduceJs()) {
            JsCode jsCode;
            CompilerResult mainLib2;
            MainModule mainModule;
            Object it;
            PhaseConfig phaseConfig = CreatePhaseConfigKt.createPhaseConfig((CompilerPhase)JsLoweringPhasesKt.getJsPhases(), arguments2, messageCollector2);
            String includes = arguments2.getIncludes();
            if (includes != null) {
                Object v16;
                block39: {
                    Object item$iv$iv;
                    destination$iv$iv2 = sourcesFiles;
                    $i$f$filterTo = false;
                    if (!destination$iv$iv2.isEmpty()) {
                        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Source files are not supported when -Xinclude is present", null, 4, null);
                    }
                    List allLibraries = KotlinLibraryResolveResult.DefaultImpls.getFullList$default(resolvedLibraries, null, 1, null);
                    item$iv$iv = allLibraries;
                    boolean element$iv$iv = false;
                    Object object2 = item$iv$iv;
                    bl = false;
                    Iterator iterator2 = object2.iterator();
                    while (iterator2.hasNext()) {
                        Object t = iterator2.next();
                        it = (KotlinLibrary)t;
                        boolean bl7 = false;
                        if (!Intrinsics.areEqual(it.getLibraryFile().getAbsolutePath(), new File(includes).getAbsolutePath())) continue;
                        v16 = t;
                        break block39;
                    }
                    v16 = null;
                }
                Intrinsics.checkNotNull(v16);
                KotlinLibrary mainLib2 = v16;
                mainModule = new MainModule.Klib(mainLib2);
            } else {
                mainModule = new MainModule.SourceFiles(sourcesFiles);
            }
            MainModule mainModule2 = mainModule;
            try {
                CompilerConfiguration compilerConfiguration = config.getConfiguration();
                Intrinsics.checkNotNullExpressionValue(compilerConfiguration, "config.configuration");
                AbstractAnalyzerWithCompilerReport abstractAnalyzerWithCompilerReport = new AnalyzerWithCompilerReport(compilerConfiguration);
                CompilerConfiguration compilerConfiguration3 = config.getConfiguration();
                Intrinsics.checkNotNullExpressionValue(compilerConfiguration3, "config.configuration");
                mainLib2 = CompilerKt.compile$default(projectJs, mainModule2, abstractAnalyzerWithCompilerReport, compilerConfiguration3, phaseConfig, resolvedLibraries, friendDependencies, mainCallArguments, null, !arguments2.getIrDce(), arguments2.getIrDce(), arguments2.getIrDceDriven(), false, arguments2.getIrPerModule(), true, 4352, null);
            }
            catch (JsIrCompilationError e) {
                return ExitCode.COMPILATION_ERROR;
            }
            CompilerResult compiledModule = mainLib2;
            if (arguments2.getIrDce() && !arguments2.getIrDceDriven()) {
                JsCode jsCode2 = compiledModule.getDceJsCode();
                jsCode = jsCode2;
                Intrinsics.checkNotNull(jsCode2);
            } else {
                JsCode jsCode3 = compiledModule.getJsCode();
                jsCode = jsCode3;
                Intrinsics.checkNotNull(jsCode3);
            }
            JsCode jsCode4 = jsCode;
            FilesKt.writeText$default(outputFile, jsCode4.getMainModule(), null, 2, null);
            Iterable<Pair<String, String>> $this$forEach$iv = jsCode4.getDependencies();
            boolean $i$f$forEach = false;
            Iterator<Pair<String, String>> iterator3 = $this$forEach$iv.iterator();
            while (iterator3.hasNext()) {
                void name;
                Pair<String, String> element$iv;
                Pair<String, String> $dstr$name$content = element$iv = iterator3.next();
                boolean bl8 = false;
                it = $dstr$name$content.component1();
                String content = $dstr$name$content.component2();
                FilesKt.writeText$default(FilesKt.resolveSibling(outputFile, (String)name + ".js"), content, null, 2, null);
            }
            if (arguments2.getGenerateDts()) {
                File file5 = FileUtilsKt.withReplacedExtensionOrNull(outputFile, FilesKt.getExtension(outputFile), "d.ts");
                Intrinsics.checkNotNull(file5);
                File dtsFile = file5;
                String string8 = compiledModule.getTsDefinitions();
                if (string8 == null) {
                    String string9 = "No ts definitions";
                    boolean bl9 = false;
                    throw (Throwable)new IllegalStateException(string9.toString());
                }
                FilesKt.writeText$default(dtsFile, string8, null, 2, null);
            }
        }
        return ExitCode.OK;
    }

    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull K2JSCompilerArguments arguments2, @NotNull Services services) {
        String sourceMapEmbedContentString;
        SourceMapSourceEmbedding sourceMapContentEmbedding;
        ErrorTolerancePolicy errorTolerancePolicy;
        String moduleKindName;
        ModuleKind moduleKind;
        String $this$filterNotTo$iv$iv;
        boolean $i$f$filterNotTo;
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(services, "services");
        MessageCollector messageCollector = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue(messageCollector, "configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        MessageCollector messageCollector2 = messageCollector;
        if (arguments2.getTarget() != null) {
            boolean bl = Intrinsics.areEqual("v5", arguments2.getTarget());
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22 = false;
                StringBuilder stringBuilder2 = new StringBuilder().append("Unsupported ECMA version: ");
                String string2 = arguments2.getTarget();
                Intrinsics.checkNotNull(string2);
                String $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22 = stringBuilder2.append(string2).toString();
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22));
            }
        }
        configuration.put(JSConfigurationKeys.TARGET, EcmaVersion.defaultVersion());
        if (arguments2.getSourceMap()) {
            messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map argument is not supported yet", null);
        } else {
            if (arguments2.getSourceMapPrefix() != null) {
                messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-prefix argument has no effect without source map", null);
            }
            if (arguments2.getSourceMapBaseDirs() != null) {
                messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-source-root argument has no effect without source map", null);
            }
        }
        if (arguments2.getMetaInfo()) {
            configuration.put(JSConfigurationKeys.META_INFO, true);
        }
        configuration.put(JSConfigurationKeys.TYPED_ARRAYS_ENABLED, arguments2.getTypedArrays());
        configuration.put(JSConfigurationKeys.FRIEND_PATHS_DISABLED, arguments2.getFriendModulesDisabled());
        String friendModules = arguments2.getFriendModules();
        if (!arguments2.getFriendModulesDisabled() && friendModules != null) {
            List list2;
            Object object;
            CharSequence $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22 = friendModules;
            String string3 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue(string3, "File.pathSeparator");
            Object object2 = string3;
            int n = 0;
            object2 = new Regex((String)object2);
            n = 0;
            boolean bl = false;
            List<String> $this$dropLastWhile$iv = ((Regex)object2).split($i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator<String> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = iterator$iv.previous();
                    boolean bl3 = false;
                    object = it;
                    boolean bl4 = false;
                    if (object.length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            Iterable $this$filterNot$iv = list2;
            boolean $i$f$filterNot = false;
            Iterable iterator$iv = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            $i$f$filterNotTo = false;
            object = $this$filterNotTo$iv$iv.iterator();
            while (object.hasNext()) {
                Object element$iv$iv = object.next();
                String it = (String)element$iv$iv;
                boolean bl5 = false;
                CharSequence charSequence = it;
                boolean bl6 = false;
                if (charSequence.length() == 0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List friendPaths = (List)destination$iv$iv;
            configuration.put(JSConfigurationKeys.FRIEND_PATHS, friendPaths);
        }
        ModuleKind moduleKind2 = moduleKind = (moduleKindName = arguments2.getModuleKind()) != null ? moduleKindMap.get(moduleKindName) : ModuleKind.PLAIN;
        if (moduleKind == null) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Unknown module kind: " + moduleKindName + ". Valid values are: plain, amd, commonjs, umd", null);
            moduleKind = ModuleKind.PLAIN;
        }
        configuration.put(JSConfigurationKeys.MODULE_KIND, moduleKind);
        configuration.putIfNotNull(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER, services.get(IncrementalDataProvider.class));
        configuration.putIfNotNull(JSConfigurationKeys.INCREMENTAL_RESULTS_CONSUMER, services.get(IncrementalResultsConsumer.class));
        configuration.putIfNotNull(JSConfigurationKeys.INCREMENTAL_NEXT_ROUND_CHECKER, services.get(IncrementalNextRoundChecker.class));
        configuration.putIfNotNull(CommonConfigurationKeys.LOOKUP_TRACKER, services.get(LookupTracker.class));
        configuration.putIfNotNull(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER, services.get(ExpectActualTracker.class));
        String string4 = arguments2.getErrorTolerancePolicy();
        if (string4 != null) {
            $this$filterNotTo$iv$iv = string4;
            boolean destination$iv$iv = false;
            $i$f$filterNotTo = false;
            String it = $this$filterNotTo$iv$iv;
            boolean bl = false;
            errorTolerancePolicy = ErrorTolerancePolicy.Companion.resolvePolicy(it);
        } else {
            errorTolerancePolicy = null;
        }
        ErrorTolerancePolicy errorTolerancePolicy2 = errorTolerancePolicy;
        configuration.putIfNotNull(JSConfigurationKeys.ERROR_TOLERANCE_POLICY, errorTolerancePolicy2);
        ErrorTolerancePolicy errorTolerancePolicy3 = errorTolerancePolicy2;
        if (errorTolerancePolicy3 != null) {
            if (errorTolerancePolicy3.getAllowErrors()) {
                configuration.put(JSConfigurationKeys.DEVELOPER_MODE, true);
            }
        }
        SourceMapSourceEmbedding sourceMapSourceEmbedding = sourceMapContentEmbedding = (sourceMapEmbedContentString = arguments2.getSourceMapEmbedSources()) != null ? sourceMapContentEmbeddingMap.get(sourceMapEmbedContentString) : SourceMapSourceEmbedding.INLINING;
        if (sourceMapContentEmbedding == null) {
            String message2 = "Unknown source map source embedding mode: " + sourceMapEmbedContentString + ". Valid values are: " + StringUtil.join((Collection<String>)sourceMapContentEmbeddingMap.keySet(), ", ");
            messageCollector2.report(CompilerMessageSeverity.ERROR, message2, null);
            sourceMapContentEmbedding = SourceMapSourceEmbedding.INLINING;
        }
        configuration.put(JSConfigurationKeys.SOURCE_MAP_EMBED_SOURCES, sourceMapContentEmbedding);
        if (!arguments2.getSourceMap() && sourceMapEmbedContentString != null) {
            messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-embed-sources argument has no effect without source map", null);
        }
        configuration.put(JSConfigurationKeys.PRINT_REACHABILITY_INFO, arguments2.getIrDcePrintReachabilityInfo());
        configuration.put(JSConfigurationKeys.DISABLE_FAKE_OVERRIDE_VALIDATOR, arguments2.getDisableFakeOverrideValidator());
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        String string2 = "Provide a proper way to run the compiler with IR BE";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @NotNull
    protected BinaryVersion createMetadataVersion(@NotNull int[] versionArray) {
        Intrinsics.checkNotNullParameter(versionArray, "versionArray");
        return new KlibMetadataVersion(Arrays.copyOf(versionArray, versionArray.length));
    }

    @Override
    protected void addPlatformOptions(@NotNull List<String> $this$addPlatformOptions, @NotNull K2JSCompilerArguments arguments2) {
        Intrinsics.checkNotNullParameter($this$addPlatformOptions, "$this$addPlatformOptions");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
    }

    static {
        Companion = new Companion(null);
        moduleKindMap = MapsKt.mapOf(TuplesKt.to("plain", ModuleKind.PLAIN), TuplesKt.to("commonjs", ModuleKind.COMMON_JS), TuplesKt.to("amd", ModuleKind.AMD), TuplesKt.to("umd", ModuleKind.UMD));
        sourceMapContentEmbeddingMap = MapsKt.mapOf(TuplesKt.to("always", SourceMapSourceEmbedding.ALWAYS), TuplesKt.to("never", SourceMapSourceEmbedding.NEVER), TuplesKt.to("inlining", SourceMapSourceEmbedding.INLINING));
        produceMap = MapsKt.mapOf(TuplesKt.to(null, ProduceKind.DEFAULT), TuplesKt.to("js", ProduceKind.JS), TuplesKt.to("klib", ProduceKind.KLIB));
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0002J\u001b\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\fH\u0002J\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\f*\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/cli/js/K2JsIrCompiler$Companion;", "", "()V", "moduleKindMap", "", "", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "produceMap", "Lorg/jetbrains/kotlin/cli/js/ProduceKind;", "sourceMapContentEmbeddingMap", "Lorg/jetbrains/kotlin/js/config/SourceMapSourceEmbedding;", "configureLibraries", "", "libraryString", "main", "", "args", "", "([Ljava/lang/String;)V", "reportCompiledSourcesList", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "sourceFiles", "Lorg/jetbrains/kotlin/psi/KtFile;", "splitByPathSeparator", "cli-js"})
    public static final class Companion {
        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter(args, "args");
            CLITool.Companion.doMain(new K2JsIrCompiler(), args);
        }

        /*
         * WARNING - void declaration
         */
        private final void reportCompiledSourcesList(MessageCollector messageCollector, List<? extends KtFile> sourceFiles2) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = sourceFiles2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void file2;
                KtFile ktFile = (KtFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                VirtualFile virtualFile2 = file2.getVirtualFile();
                String string2 = virtualFile2 != null ? MessageUtil.virtualFileToPath(virtualFile2) : file2.getName() + " (no virtual file)";
                collection.add(string2);
            }
            List fileNames = (List)destination$iv$iv;
            messageCollector.report(CompilerMessageSeverity.LOGGING, "Compiling source files: " + StringsKt.join(fileNames, ", "), null);
        }

        private final List<String> configureLibraries(String libraryString) {
            Object object = libraryString;
            if (object == null || (object = this.splitByPathSeparator((String)object)) == null) {
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> splitByPathSeparator(String $this$splitByPathSeparator) {
            void $this$filterNotTo$iv$iv;
            List list2;
            CharSequence charSequence = $this$splitByPathSeparator;
            String string2 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue(string2, "File.pathSeparator");
            Object object = string2;
            int n = 0;
            object = new Regex((String)object);
            n = 0;
            boolean bl = false;
            List<String> $this$dropLastWhile$iv = ((Regex)object).split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator<String> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = iterator$iv.previous();
                    boolean bl2 = false;
                    CharSequence charSequence2 = it;
                    int n2 = 0;
                    if (charSequence2.length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            String[] $this$toTypedArray$iv = (String[])list2;
            boolean $i$f$toTypedArray = false;
            String[] thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] $this$filterNot$iv = stringArray;
            boolean $i$f$filterNot = false;
            thisCollection$iv = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (CharSequence element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                CharSequence charSequence3 = it;
                boolean bl4 = false;
                if (charSequence3.length() == 0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

