/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsForIn;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.inline.clean.WhileConditionFolding;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\bJ\u001a\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/WhileConditionFolding;", "", "body", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;)V", "getBody", "()Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "changed", "", "apply", "hasContinue", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "label", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "js.translator"})
public final class WhileConditionFolding {
    private boolean changed;
    private final JsBlock body;

    public final boolean apply() {
        this.body.accept(new RecursiveJsVisitor(this){
            final /* synthetic */ WhileConditionFolding this$0;

            public void visitLabel(@NotNull JsLabel x) {
                JsStatement innerStatement;
                Intrinsics.checkNotNullParameter(x, "x");
                JsStatement jsStatement = innerStatement = x.getStatement();
                if (jsStatement instanceof JsWhile) {
                    this.process((JsWhile)innerStatement, x.getName());
                } else if (jsStatement instanceof JsDoWhile) {
                    this.process((JsDoWhile)innerStatement, x.getName());
                } else {
                    super.visitLabel(x);
                }
            }

            public void visitWhile(@NotNull JsWhile x) {
                Intrinsics.checkNotNullParameter(x, "x");
                this.process(x, null);
            }

            public void visitDoWhile(@NotNull JsDoWhile x) {
                Intrinsics.checkNotNullParameter(x, "x");
                this.process(x, null);
            }

            private final void process(JsWhile statement2, JsName name) {
                this.process(statement2, name, (Function1<? super JsStatement, ? extends JsStatement>)new Function1<JsStatement, JsStatement>(this){
                    final /* synthetic */ apply.1 this$0;

                    @NotNull
                    public final JsStatement invoke(@NotNull JsStatement it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return apply.1.access$first(this.this$0, it);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }, (Function1<? super JsStatement, ? extends JsStatement>)new Function1<JsStatement, JsStatement>(this){
                    final /* synthetic */ apply.1 this$0;

                    @NotNull
                    public final JsStatement invoke(@NotNull JsStatement it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return apply.1.access$removeFirst(this.this$0, it);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }, apply.process.3.INSTANCE);
            }

            private final void process(JsDoWhile statement2, JsName name) {
                JsStatement jsStatement = statement2.getBody();
                Intrinsics.checkNotNullExpressionValue(jsStatement, "statement.body");
                if (!WhileConditionFolding.access$hasContinue(this.this$0, jsStatement, name)) {
                    this.process(statement2, name, (Function1<? super JsStatement, ? extends JsStatement>)new Function1<JsStatement, JsStatement>(this){
                        final /* synthetic */ apply.1 this$0;

                        @NotNull
                        public final JsStatement invoke(@NotNull JsStatement it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            return apply.1.access$last(this.this$0, it);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }, (Function1<? super JsStatement, ? extends JsStatement>)new Function1<JsStatement, JsStatement>(this){
                        final /* synthetic */ apply.1 this$0;

                        @NotNull
                        public final JsStatement invoke(@NotNull JsStatement it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            return apply.1.access$removeLast(this.this$0, it);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }, apply.process.6.INSTANCE);
                }
            }

            private final void process(JsWhile statement2, JsName name, Function1<? super JsStatement, ? extends JsStatement> find2, Function1<? super JsStatement, ? extends JsStatement> remove, Function2<? super JsExpression, ? super JsExpression, ? extends JsExpression> combine) {
                boolean optimized;
                statement2.getBody().accept(this);
                do {
                    JsExpression jsExpression;
                    optimized = false;
                    JsStatement jsStatement = statement2.getBody();
                    Intrinsics.checkNotNullExpressionValue(jsStatement, "statement.body");
                    JsStatement first = find2.invoke(jsStatement);
                    JsExpression condition = this.extractCondition(first, name);
                    if (condition == null) continue;
                    JsStatement jsStatement2 = statement2.getBody();
                    Intrinsics.checkNotNullExpressionValue(jsStatement2, "statement.body");
                    statement2.setBody(remove.invoke(jsStatement2));
                    JsExpression existingCondition = statement2.getCondition();
                    if (JsBooleanLiteral.isTrue(existingCondition)) {
                        jsExpression = condition;
                    } else {
                        JsExpression jsExpression2 = existingCondition;
                        Intrinsics.checkNotNullExpressionValue(jsExpression2, "existingCondition");
                        jsExpression = combine.invoke(jsExpression2, condition);
                    }
                    statement2.setCondition(jsExpression);
                    WhileConditionFolding.access$setChanged$p(this.this$0, true);
                    optimized = true;
                } while (optimized);
            }

            private final JsExpression extractCondition(JsStatement statement2, JsName label) {
                JsExpression jsExpression;
                JsStatement jsStatement = statement2;
                if (jsStatement instanceof JsBreak) {
                    JsNameRef jsNameRef = ((JsBreak)statement2).getLabel();
                    JsName target = jsNameRef != null ? jsNameRef.getName() : null;
                    jsExpression = Intrinsics.areEqual(label, target) ? new JsBooleanLiteral(false) : null;
                } else if (jsStatement instanceof JsIf) {
                    JsStatement jsStatement2 = ((JsIf)statement2).getThenStatement();
                    Intrinsics.checkNotNullExpressionValue(jsStatement2, "statement.thenStatement");
                    JsStatement then2 = jsStatement2;
                    if (((JsIf)statement2).getElseStatement() == null) {
                        JsExpression result2;
                        JsExpression nextCondition = this.extractCondition(then2, label);
                        jsExpression = result2 = nextCondition == null ? null : (JsBooleanLiteral.isFalse(nextCondition) ? JsAstUtils.notOptimized(((JsIf)statement2).getIfExpression()) : (JsExpression)JsAstUtils.or(JsAstUtils.notOptimized(((JsIf)statement2).getIfExpression()), nextCondition));
                    } else {
                        jsExpression = null;
                    }
                } else if (jsStatement instanceof JsBlock) {
                    if (((JsBlock)statement2).getStatements().size() == 1) {
                        JsStatement jsStatement3 = ((JsBlock)statement2).getStatements().get(0);
                        Intrinsics.checkNotNullExpressionValue(jsStatement3, "statement.statements[0]");
                        jsExpression = this.extractCondition(jsStatement3, label);
                    } else {
                        jsExpression = null;
                    }
                } else {
                    jsExpression = null;
                }
                return jsExpression;
            }

            private final JsStatement first(JsStatement statement2) {
                JsStatement jsStatement;
                JsStatement jsStatement2 = statement2;
                if (jsStatement2 instanceof JsBlock) {
                    List<JsStatement> list2 = ((JsBlock)statement2).getStatements();
                    Intrinsics.checkNotNullExpressionValue(list2, "statement.statements");
                    jsStatement = CollectionsKt.firstOrNull(list2);
                    if (jsStatement == null) {
                        jsStatement = statement2;
                    }
                } else {
                    jsStatement = statement2;
                }
                return jsStatement;
            }

            private final JsBlock removeFirst(JsStatement statement2) {
                JsBlock jsBlock;
                JsStatement jsStatement = statement2;
                if (jsStatement instanceof JsBlock) {
                    List<JsStatement> list2 = ((JsBlock)statement2).getStatements();
                    Intrinsics.checkNotNullExpressionValue(list2, "statement.statements");
                    List<JsStatement> statements2 = list2;
                    Collection collection = statements2;
                    boolean bl = false;
                    if (!collection.isEmpty()) {
                        statements2.remove(0);
                    }
                    jsBlock = (JsBlock)statement2;
                } else {
                    jsBlock = new JsBlock();
                }
                return jsBlock;
            }

            private final JsStatement last(JsStatement statement2) {
                JsStatement jsStatement;
                JsStatement jsStatement2 = statement2;
                if (jsStatement2 instanceof JsBlock) {
                    List<JsStatement> list2 = ((JsBlock)statement2).getStatements();
                    Intrinsics.checkNotNullExpressionValue(list2, "statement.statements");
                    jsStatement = CollectionsKt.lastOrNull(list2);
                    if (jsStatement == null) {
                        jsStatement = statement2;
                    }
                } else {
                    jsStatement = statement2;
                }
                return jsStatement;
            }

            private final JsBlock removeLast(JsStatement statement2) {
                JsBlock jsBlock;
                JsStatement jsStatement = statement2;
                if (jsStatement instanceof JsBlock) {
                    List<JsStatement> list2 = ((JsBlock)statement2).getStatements();
                    Intrinsics.checkNotNullExpressionValue(list2, "statement.statements");
                    List<JsStatement> statements2 = list2;
                    Collection collection = statements2;
                    boolean bl = false;
                    if (!collection.isEmpty()) {
                        statements2.remove(CollectionsKt.getLastIndex(statements2));
                    }
                    jsBlock = (JsBlock)statement2;
                } else {
                    jsBlock = new JsBlock();
                }
                return jsBlock;
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkNotNullParameter(x, "x");
            }
            {
                this.this$0 = this$0;
            }

            public static final /* synthetic */ JsStatement access$first(apply.1 $this, JsStatement statement2) {
                return $this.first(statement2);
            }

            public static final /* synthetic */ JsBlock access$removeFirst(apply.1 $this, JsStatement statement2) {
                return $this.removeFirst(statement2);
            }

            public static final /* synthetic */ JsStatement access$last(apply.1 $this, JsStatement statement2) {
                return $this.last(statement2);
            }

            public static final /* synthetic */ JsBlock access$removeLast(apply.1 $this, JsStatement statement2) {
                return $this.removeLast(statement2);
            }
        });
        return this.changed;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasContinue(JsStatement statement2, JsName label) {
        void found2;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        statement2.accept(new RecursiveJsVisitor((Ref.BooleanRef)found2, label){
            private int level;
            final /* synthetic */ Ref.BooleanRef $found;
            final /* synthetic */ JsName $label;

            public void visitContinue(@NotNull JsContinue x) {
                JsName name;
                Intrinsics.checkNotNullParameter(x, "x");
                JsNameRef jsNameRef = x.getLabel();
                JsName jsName = name = jsNameRef != null ? jsNameRef.getName() : null;
                if (name == null) {
                    if (this.level == 0) {
                        this.$found.element = true;
                    }
                } else if (Intrinsics.areEqual(name, this.$label)) {
                    this.$found.element = true;
                }
            }

            public void visitFor(@NotNull JsFor x) {
                Intrinsics.checkNotNullParameter(x, "x");
                int n = this.level;
                this.level = n + 1;
                super.visitFor(x);
                n = this.level;
                this.level = n + -1;
            }

            public void visitWhile(@NotNull JsWhile x) {
                Intrinsics.checkNotNullParameter(x, "x");
                int n = this.level;
                this.level = n + 1;
                super.visitWhile(x);
                n = this.level;
                this.level = n + -1;
            }

            public void visitDoWhile(@NotNull JsDoWhile x) {
                Intrinsics.checkNotNullParameter(x, "x");
                int n = this.level;
                this.level = n + 1;
                super.visitDoWhile(x);
                n = this.level;
                this.level = n + -1;
            }

            public void visitForIn(@NotNull JsForIn x) {
                Intrinsics.checkNotNullParameter(x, "x");
                int n = this.level;
                this.level = n + 1;
                super.visitForIn(x);
                n = this.level;
                this.level = n + -1;
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkNotNullParameter(x, "x");
            }

            protected void visitElement(@NotNull JsNode node) {
                Intrinsics.checkNotNullParameter(node, "node");
                if (!this.$found.element) {
                    super.visitElement(node);
                }
            }
            {
                this.$found = $captured_local_variable$0;
                this.$label = $captured_local_variable$1;
            }
        });
        return found2.element;
    }

    @NotNull
    public final JsBlock getBody() {
        return this.body;
    }

    public WhileConditionFolding(@NotNull JsBlock body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        this.body = body2;
    }

    public static final /* synthetic */ boolean access$hasContinue(WhileConditionFolding $this, JsStatement statement2, JsName label) {
        return $this.hasContinue(statement2, label);
    }

    public static final /* synthetic */ boolean access$getChanged$p(WhileConditionFolding $this) {
        return $this.changed;
    }

    public static final /* synthetic */ void access$setChanged$p(WhileConditionFolding $this, boolean bl) {
        $this.changed = bl;
    }
}

