"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * A Matrix event.
 * @category Matrix events
 */
class MatrixEvent {
    constructor(event) {
        this.event = event;
    }
    /**
     * The user ID who sent this event.
     */
    get sender() {
        return this.event['sender'];
    }
    /**
     * The type of this event.
     */
    get type() {
        return this.event['type'];
    }
    /**
     * The content for this event. May have no properties.
     */
    get content() {
        return this.event['content'] || {};
    }
}
exports.MatrixEvent = MatrixEvent;
