/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public abstract class AbstractRed
implements CachableRed {
    protected Rectangle bounds;
    protected Vector srcs;
    protected Map props;
    protected SampleModel sm;
    protected ColorModel cm;
    protected int tileGridXOff;
    protected int tileGridYOff;
    protected int tileWidth;
    protected int tileHeight;
    protected int minTileX;
    protected int minTileY;
    protected int numXTiles;
    protected int numYTiles;

    protected AbstractRed() {
    }

    protected AbstractRed(Rectangle rectangle, Map map) {
        this.init((CachableRed)null, rectangle, null, null, rectangle.x, rectangle.y, map);
    }

    protected AbstractRed(CachableRed cachableRed, Map map) {
        this.init(cachableRed, cachableRed.getBounds(), cachableRed.getColorModel(), cachableRed.getSampleModel(), cachableRed.getTileGridXOffset(), cachableRed.getTileGridYOffset(), map);
    }

    protected AbstractRed(CachableRed cachableRed, Rectangle rectangle, Map map) {
        this.init(cachableRed, rectangle, cachableRed.getColorModel(), cachableRed.getSampleModel(), cachableRed.getTileGridXOffset(), cachableRed.getTileGridYOffset(), map);
    }

    protected AbstractRed(CachableRed cachableRed, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, Map map) {
        this.init(cachableRed, rectangle, colorModel, sampleModel, cachableRed == null ? 0 : cachableRed.getTileGridXOffset(), cachableRed == null ? 0 : cachableRed.getTileGridYOffset(), map);
    }

    protected AbstractRed(CachableRed cachableRed, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n, int n2, Map map) {
        this.init(cachableRed, rectangle, colorModel, sampleModel, n, n2, map);
    }

    protected void init(CachableRed cachableRed, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n, int n2, Map map) {
        this.srcs = new Vector(1);
        if (cachableRed != null) {
            this.srcs.add(cachableRed);
            if (rectangle == null) {
                rectangle = cachableRed.getBounds();
            }
            if (colorModel == null) {
                colorModel = cachableRed.getColorModel();
            }
            if (sampleModel == null) {
                sampleModel = cachableRed.getSampleModel();
            }
        }
        this.bounds = rectangle;
        this.tileGridXOff = n;
        this.tileGridYOff = n2;
        this.props = new HashMap();
        if (map != null) {
            this.props.putAll(map);
        }
        if (colorModel == null) {
            colorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
        }
        this.cm = colorModel;
        if (sampleModel == null) {
            sampleModel = colorModel.createCompatibleSampleModel(rectangle.width, rectangle.height);
        }
        this.sm = sampleModel;
        this.updateTileGridInfo();
    }

    protected AbstractRed(List list, Rectangle rectangle, Map map) {
        this.init(list, rectangle, null, null, rectangle.x, rectangle.y, map);
    }

    protected AbstractRed(List list, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, Map map) {
        this.init(list, rectangle, colorModel, sampleModel, rectangle.x, rectangle.y, map);
    }

    protected AbstractRed(List list, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n, int n2, Map map) {
        this.init(list, rectangle, colorModel, sampleModel, n, n2, map);
    }

    protected void init(List list, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n, int n2, Map map) {
        this.srcs = new Vector();
        if (list != null) {
            this.srcs.addAll(list);
        }
        if (list.size() != 0) {
            CachableRed cachableRed = (CachableRed)list.get(0);
            if (rectangle == null) {
                rectangle = cachableRed.getBounds();
            }
            if (colorModel == null) {
                colorModel = cachableRed.getColorModel();
            }
            if (sampleModel == null) {
                sampleModel = cachableRed.getSampleModel();
            }
        }
        this.bounds = rectangle;
        this.tileGridXOff = n;
        this.tileGridYOff = n2;
        this.props = new HashMap();
        if (map != null) {
            this.props.putAll(map);
        }
        if (colorModel == null) {
            colorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
        }
        this.cm = colorModel;
        if (sampleModel == null) {
            sampleModel = colorModel.createCompatibleSampleModel(rectangle.width, rectangle.height);
        }
        this.sm = sampleModel;
        this.updateTileGridInfo();
    }

    protected void updateTileGridInfo() {
        this.tileWidth = this.sm.getWidth();
        this.tileHeight = this.sm.getHeight();
        this.minTileX = this.getXTile(this.bounds.x);
        this.minTileY = this.getYTile(this.bounds.y);
        int n = this.bounds.x + this.bounds.width - 1;
        int n2 = this.getXTile(n);
        this.numXTiles = n2 - this.minTileX + 1;
        int n3 = this.bounds.y + this.bounds.height - 1;
        int n4 = this.getYTile(n3);
        this.numYTiles = n4 - this.minTileY + 1;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight());
    }

    public Vector getSources() {
        return this.srcs;
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public SampleModel getSampleModel() {
        return this.sm;
    }

    public int getMinX() {
        return this.bounds.x;
    }

    public int getMinY() {
        return this.bounds.y;
    }

    public int getWidth() {
        return this.bounds.width;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getTileGridXOffset() {
        return this.tileGridXOff;
    }

    public int getTileGridYOffset() {
        return this.tileGridYOff;
    }

    public int getMinTileX() {
        return this.minTileX;
    }

    public int getMinTileY() {
        return this.minTileY;
    }

    public int getNumXTiles() {
        return this.numXTiles;
    }

    public int getNumYTiles() {
        return this.numYTiles;
    }

    public Object getProperty(String string) {
        Object object = this.props.get(string);
        if (object != null) {
            return object;
        }
        Iterator iterator = this.srcs.iterator();
        while (iterator.hasNext()) {
            RenderedImage renderedImage = (RenderedImage)iterator.next();
            object = renderedImage.getProperty(string);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public String[] getPropertyNames() {
        Set set = this.props.keySet();
        String[] stringArray = new String[set.size()];
        set.toArray(stringArray);
        Iterator iterator = this.srcs.iterator();
        while (iterator.hasNext()) {
            RenderedImage renderedImage = (RenderedImage)iterator.next();
            String[] stringArray2 = renderedImage.getPropertyNames();
            if (stringArray2.length == 0) continue;
            String[] stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
            stringArray = stringArray3;
        }
        return stringArray;
    }

    public Shape getDependencyRegion(int n, Rectangle rectangle) {
        if (n < 0 || n > this.srcs.size()) {
            throw new IndexOutOfBoundsException("Nonexistant source requested.");
        }
        if (!rectangle.intersects(this.bounds)) {
            return new Rectangle();
        }
        return rectangle.intersection(this.bounds);
    }

    public Shape getDirtyRegion(int n, Rectangle rectangle) {
        if (n != 0) {
            throw new IndexOutOfBoundsException("Nonexistant source requested.");
        }
        if (!rectangle.intersects(this.bounds)) {
            return new Rectangle();
        }
        return rectangle.intersection(this.bounds);
    }

    public Raster getTile(int n, int n2) {
        WritableRaster writableRaster = this.makeTile(n, n2);
        return this.copyData(writableRaster);
    }

    public Raster getData() {
        return this.getData(this.bounds);
    }

    public Raster getData(Rectangle rectangle) {
        SampleModel sampleModel = this.sm.createCompatibleSampleModel(rectangle.width, rectangle.height);
        Point point = new Point(rectangle.x, rectangle.y);
        WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, point);
        return this.copyData(writableRaster);
    }

    public final int getXTile(int n) {
        int n2 = n - this.tileGridXOff;
        if (n2 >= 0) {
            return n2 / this.tileWidth;
        }
        return (n2 - this.tileWidth + 1) / this.tileWidth;
    }

    public final int getYTile(int n) {
        int n2 = n - this.tileGridYOff;
        if (n2 >= 0) {
            return n2 / this.tileHeight;
        }
        return (n2 - this.tileHeight + 1) / this.tileHeight;
    }

    public void copyToRaster(WritableRaster writableRaster) {
        int n = this.getXTile(writableRaster.getMinX());
        int n2 = this.getYTile(writableRaster.getMinY());
        int n3 = this.getXTile(writableRaster.getMinX() + writableRaster.getWidth() - 1);
        int n4 = this.getYTile(writableRaster.getMinY() + writableRaster.getHeight() - 1);
        if (n < this.minTileX) {
            n = this.minTileX;
        }
        if (n2 < this.minTileY) {
            n2 = this.minTileY;
        }
        if (n3 >= this.minTileX + this.numXTiles) {
            n3 = this.minTileX + this.numXTiles - 1;
        }
        if (n4 >= this.minTileY + this.numYTiles) {
            n4 = this.minTileY + this.numYTiles - 1;
        }
        boolean bl = GraphicsUtil.is_INT_PACK_Data(this.getSampleModel(), false);
        for (int i = n2; i <= n4; ++i) {
            for (int j = n; j <= n3; ++j) {
                Raster raster = this.getTile(j, i);
                if (bl) {
                    GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
                    continue;
                }
                GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
            }
        }
    }

    public WritableRaster makeTile(int n, int n2) {
        if (n < this.minTileX || n >= this.minTileX + this.numXTiles || n2 < this.minTileY || n2 >= this.minTileY + this.numYTiles) {
            throw new IndexOutOfBoundsException("Requested Tile (" + n + ',' + n2 + ") lies outside the bounds of image");
        }
        Point point = new Point(this.tileGridXOff + n * this.tileWidth, this.tileGridYOff + n2 * this.tileHeight);
        WritableRaster writableRaster = Raster.createWritableRaster(this.sm, point);
        int n3 = writableRaster.getMinX();
        int n4 = writableRaster.getMinY();
        int n5 = n3 + writableRaster.getWidth() - 1;
        int n6 = n4 + writableRaster.getHeight() - 1;
        if (n3 < this.bounds.x || n5 >= this.bounds.x + this.bounds.width || n4 < this.bounds.y || n6 >= this.bounds.y + this.bounds.height) {
            if (n3 < this.bounds.x) {
                n3 = this.bounds.x;
            }
            if (n4 < this.bounds.y) {
                n4 = this.bounds.y;
            }
            if (n5 >= this.bounds.x + this.bounds.width) {
                n5 = this.bounds.x + this.bounds.width - 1;
            }
            if (n6 >= this.bounds.y + this.bounds.height) {
                n6 = this.bounds.y + this.bounds.height - 1;
            }
            writableRaster = writableRaster.createWritableChild(n3, n4, n5 - n3 + 1, n6 - n4 + 1, n3, n4, null);
        }
        return writableRaster;
    }

    public static void copyBand(Raster raster, int n, WritableRaster writableRaster, int n2) {
        Rectangle rectangle = new Rectangle(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight());
        Rectangle rectangle2 = new Rectangle(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight());
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        int[] nArray = null;
        for (int i = rectangle3.y; i < rectangle3.y + rectangle3.height; ++i) {
            nArray = raster.getSamples(rectangle3.x, i, rectangle3.width, 1, n, nArray);
            writableRaster.setSamples(rectangle3.x, i, rectangle3.width, 1, n2, nArray);
        }
    }
}

