set -l subcommands help version login logout passwd target api auth apps app \
    push scale delete rename start stop restart restage restart-app-instance \
    run-task tasks terminate-task events files logs env set-env unset-env stacks \
    stack copy-source create-app-manifest get-health-check set-health-check \
    enable-ssh disable-ssh ssh-enabled ssh marketplace services service \
    create-service update-service delete-service rename-service \
    create-service-key service-keys service-key delete-service-key bind-service \
    unbind-service bind-route-service unbind-route-service \
    create-user-provided-service update-user-provided-service orgs org \
    create-org delete-org rename-org spaces space create-space delete-space \
    rename-space allow-space-ssh disallow-space-ssh space-ssh-allowed domains \
    create-domain delete-domain create-shared-domain delete-shared-domain \
    router-groups routes create-route check-route map-route unmap-route \
    delete-route delete-orphaned-routes network-policies add-network-policy \
    remove-network-policy buildpacks create-buildpack update-buildpack \
    rename-buildpack delete-buildpack create-user delete-user org-users \
    set-org-role unset-org-role space-users set-space-role unset-space-role \
    quotas quota set-quota create-quota delete-quota update-quota \
    share-private-domain unshare-private-domain space-quotas space-quota \
    create-space-quota update-space-quota delete-space-quota set-space-quota \
    unset-space-quota service-auth-tokens create-service-auth-token \
    update-service-auth-token delete-service-auth-token service-brokers \
    create-service-broker update-service-broker delete-service-broker \
    rename-service-broker migrate-service-instances purge-service-offering \
    purge-service-instance service-access enable-service-access \
    disable-service-access security-group security-groups create-security-group \
    update-security-group delete-security-group bind-security-group \
    unbind-security-group bind-staging-security-group staging-security-groups \
    unbind-staging-security-group bind-running-security-group \
    running-security-groups unbind-running-security-group \
    running-environment-variable-group staging-environment-variable-group \
    set-staging-environment-variable-group set-running-environment-variable-group \
    isolation-segments create-isolation-segment delete-isolation-segment \
    enable-org-isolation disable-org-isolation set-org-default-isolation-segment \
    reset-org-default-isolation-segment set-space-isolation-segment \
    reset-space-isolation-segment feature-flags feature-flag enable-feature-flag \
    disable-feature-flag curl config oauth-token ssh-code add-plugin-repo \
    remove-plugin-repo list-plugin-repos repo-plugins plugins install-plugin \
    uninstall-plugin

complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'help' --description "Show help"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'version' --description "Print the version"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'login' --description "Log user in"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'logout' --description "Log user out"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'passwd' --description "Change user password"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'target' --description "Set or view the targeted org or space"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'api' --description "Set or view target api url"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'auth' --description "Authenticate user non-interactively"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'apps' --description "List all apps in the target space"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'app' --description "Display health and status for an app"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'push' --description "Push a new app or sync changes to an existing app"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'scale' --description "Change or view the instance count, disk space limit, and memory limit for an app"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'delete' --description "Delete an app"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'rename' --description "Rename an app"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'start' --description "Start an app"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'stop' --description "Stop an app"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'restart' --description "Stop all instances of the app, then start them again. This causes downtime."
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'restage' --description "Recreate the app's executable artifact using the latest pushed app files and the latest environment (variables, service bindings, buildpack, stack, etc.)"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'restart-app-instance' --description "Terminate, then restart an app instance"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'run-task' --description "Run a one-off task on an app"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'tasks' --description "List tasks of an app"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'terminate-task' --description "Terminate a running task of an app"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'events' --description "Show recent app events"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'files' --description "Print out a list of files in a directory or the contents of a specific file of an app running on the DEA backend"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'logs' --description "Tail or show recent logs for an app"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'env' --description "Show all env variables for an app"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'set-env' --description "Set an env variable for an app"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'unset-env' --description "Remove an env variable"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'stacks' --description "List all stacks (a stack is a pre-built file system, including an operating system, that can run apps)"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'stack' --description "Show information for a stack (a stack is a pre-built file system, including an operating system, that can run apps)"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'copy-source' --description "Copies the source code of an application to another existing application (and restarts that application)"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'create-app-manifest' --description "Create an app manifest for an app that has been pushed successfully"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'get-health-check' --description "Show the type of health check performed on an app"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'set-health-check' --description "Change type of health check performed on an app"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'enable-ssh' --description "Enable ssh for the application"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'disable-ssh' --description "Disable ssh for the application"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'ssh-enabled' --description "Reports whether SSH is enabled on an application container instance"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'ssh' --description "SSH to an application container instance"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'marketplace' --description "List available offerings in the marketplace"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'services' --description "List all service instances in the target space"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'service' --description "Show service instance info"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'create-service' --description "Create a service instance"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'update-service' --description "Update a service instance"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'delete-service' --description "Delete a service instance"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'rename-service' --description "Rename a service instance"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'create-service-key' --description "Create key for a service instance"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'service-keys' --description "List keys for a service instance"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'service-key' --description "Show service key info"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'delete-service-key' --description "Delete a service key"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'bind-service' --description "Bind a service instance to an app"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'unbind-service' --description "Unbind a service instance from an app"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'bind-route-service' --description "Bind a service instance to an HTTP route"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'unbind-route-service' --description "Unbind a service instance from an HTTP route"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'create-user-provided-service' --description "Make a user-provided service instance available to CF apps"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'update-user-provided-service' --description "Update user-provided service instance"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'orgs' --description "List all orgs"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'org' --description "Show org info"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'create-org' --description "Create an org"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'delete-org' --description "Delete an org"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'rename-org' --description "Rename an org"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'spaces' --description "List all spaces in an org"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'space' --description "Show space info"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'create-space' --description "Create a space"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'delete-space' --description "Delete a space"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'rename-space' --description "Rename a space"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'allow-space-ssh' --description "Allow SSH access for the space"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'disallow-space-ssh' --description "Disallow SSH access for the space"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'space-ssh-allowed' --description "Reports whether SSH is allowed in a space"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'domains' --description "List domains in the target org"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'create-domain' --description "Create a domain in an org for later use"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'delete-domain' --description "Delete a domain"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'create-shared-domain' --description "Create a domain that can be used by all orgs (admin-only)"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'delete-shared-domain' --description "Delete a shared domain"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'router-groups' --description "List router groups"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'routes' --description "List all routes in the current space or the current organization"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'create-route' --description "Create a url route in a space for later use"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'check-route' --description "Perform a simple check to determine whether a route currently exists or not"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'map-route' --description "Add a url route to an app"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'unmap-route' --description "Remove a url route from an app"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'delete-route' --description "Delete a route"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'delete-orphaned-routes' --description "Delete all orphaned routes (i.e. those that are not mapped to an app)"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'network-policies' --description "List direct network traffic policies"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'add-network-policy' --description "Create policy to allow direct network traffic from one app to another"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'remove-network-policy' --description "Remove network traffic policy of an app"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'buildpacks' --description "List all buildpacks"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'create-buildpack' --description "Create a buildpack"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'update-buildpack' --description "Update a buildpack"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'rename-buildpack' --description "Rename a buildpack"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'delete-buildpack' --description "Delete a buildpack"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'create-user' --description "Create a new user"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'delete-user' --description "Delete a user"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'org-users' --description "Show org users by role"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'set-org-role' --description "Assign an org role to a user"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'unset-org-role' --description "Remove an org role from a user"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'space-users' --description "Show space users by role"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'set-space-role' --description "Assign a space role to a user"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'unset-space-role' --description "Remove a space role from a user"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'quotas' --description "List available usage quotas"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'quota' --description "Show quota info"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'set-quota' --description "Assign a quota to an org"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'create-quota' --description "Define a new resource quota"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'delete-quota' --description "Delete a quota"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'update-quota' --description "Update an existing resource quota"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'share-private-domain' --description "Share a private domain with an org"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'unshare-private-domain' --description "Unshare a private domain with an org"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'space-quotas' --description "List available space resource quotas"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'space-quota' --description "Show space quota info"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'create-space-quota' --description "Define a new space resource quota"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'update-space-quota' --description "Update an existing space quota"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'delete-space-quota' --description "Delete a space quota definition and unassign the space quota from all spaces"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'set-space-quota' --description "Assign a space quota definition to a space"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'unset-space-quota' --description "Unassign a quota from a space"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'service-auth-tokens' --description "List service auth tokens"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'create-service-auth-token' --description "Create a service auth token"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'update-service-auth-token' --description "Update a service auth token"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'delete-service-auth-token' --description "Delete a service auth token"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'service-brokers' --description "List service brokers"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'create-service-broker' --description "Create a service broker"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'update-service-broker' --description "Update a service broker"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'delete-service-broker' --description "Delete a service broker"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'rename-service-broker' --description "Rename a service broker"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'migrate-service-instances' --description "Migrate service instances from one service plan to another"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'purge-service-offering' --description "Recursively remove a service and child objects from Cloud Foundry database without making requests to a service broker"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'purge-service-instance' --description "Recursively remove a service instance and child objects from Cloud Foundry database without making requests to a service broker"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'service-access' --description "List service access settings"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'enable-service-access' --description "Enable access to a service or service plan for one or all orgs"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'disable-service-access' --description "Disable access to a service or service plan for one or all orgs"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'security-group' --description "Show a single security group"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'security-groups' --description "List all security groups"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'create-security-group' --description "Create a security group"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'update-security-group' --description "Update a security group"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'delete-security-group' --description "Deletes a security group"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'bind-security-group' --description "Bind a security group to a particular space, or all existing spaces of an org"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'unbind-security-group' --description "Unbind a security group from a space"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'bind-staging-security-group' --description "Bind a security group to the list of security groups to be used for staging applications"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'staging-security-groups' --description "List security groups in the staging set for applications"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'unbind-staging-security-group' --description "Unbind a security group from the set of security groups for staging applications"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'bind-running-security-group' --description "Bind a security group to the list of security groups to be used for running applications"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'running-security-groups' --description "List security groups in the set of security groups for running applications"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'unbind-running-security-group' --description "Unbind a security group from the set of security groups for running applications"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'running-environment-variable-group' --description "Retrieve the contents of the running environment variable group"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'staging-environment-variable-group' --description "Retrieve the contents of the staging environment variable group"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'set-staging-environment-variable-group' --description "Pass parameters as JSON to create a staging environment variable group"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'set-running-environment-variable-group' --description "Pass parameters as JSON to create a running environment variable group"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'isolation-segments' --description "List all isolation segments"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'create-isolation-segment' --description "Create an isolation segment"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'delete-isolation-segment' --description "Delete an isolation segment"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'enable-org-isolation' --description "Entitle an organization to an isolation segment"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'disable-org-isolation' --description "Revoke an organization's entitlement to an isolation segment"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'set-org-default-isolation-segment' --description "Set the default isolation segment used for apps in spaces in an org"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'reset-org-default-isolation-segment' --description "Reset the default isolation segment used for apps in spaces of an org"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'set-space-isolation-segment' --description "Assign the isolation segment for a space"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'reset-space-isolation-segment' --description "Reset the space's isolation segment to the org default"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'feature-flags' --description "Retrieve list of feature flags with status"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'feature-flag' --description "Retrieve an individual feature flag with status"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'enable-feature-flag' --description "Allow use of a feature"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'disable-feature-flag' --description "Prevent use of a feature"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'curl' --description "Executes a request to the targeted API endpoint"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'config' --description "Write default values to the config"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'oauth-token' --description "Retrieve and display the OAuth token for the current session"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'ssh-code' --description "Get a one time password for ssh clients"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'add-plugin-repo' --description "Add a new plugin repository"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'remove-plugin-repo' --description "Remove a plugin repository"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'list-plugin-repos' --description "List all the added plugin repositories"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'repo-plugins' --description "List all available plugins in specified repository or in all added repositories"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'plugins' --description "List commands of installed plugins"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'install-plugin' --description "Install CLI plugin"
complete -f -n "__fish_use_subcommand $subcommands" -c cf -a 'uninstall-plugin' --description "Uninstall CLI plugin"
