/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.anno;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jruby.RubyModule;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.internal.runtime.methods.DumpingInvocationMethodFactory;
import org.jruby.util.ClassDefiningJRubyClassLoader;

public class InvokerGenerator {
    private static final boolean DEBUG = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args2) throws Exception {
        FileReader fileReader;
        try {
            fileReader = new FileReader(args2[0]);
        }
        catch (FileNotFoundException e) {
            System.err.println(args2[0] + " - not found. skip generator.");
            return;
        }
        ArrayList<String> classNames = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(fileReader);){
            String line;
            while ((line = br.readLine()) != null) {
                classNames.add(line);
            }
        }
        DumpingInvocationMethodFactory dumper = new DumpingInvocationMethodFactory(args2[1], new ClassDefiningJRubyClassLoader(ClassLoader.getSystemClassLoader()));
        for (String name2 : classNames) {
            RubyModule.MethodClumper clumper = new RubyModule.MethodClumper();
            try {
                Class<?> cls = Class.forName(name2, false, InvokerGenerator.class.getClassLoader());
                clumper.clump(cls);
                for (Map.Entry<String, List<JavaMethodDescriptor>> entry : clumper.getStaticAnnotatedMethods().entrySet()) {
                    dumper.getAnnotatedMethodClass(entry.getValue());
                }
                for (Map.Entry<String, List<JavaMethodDescriptor>> entry : clumper.getAnnotatedMethods().entrySet()) {
                    dumper.getAnnotatedMethodClass(entry.getValue());
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
        }
        new File(args2[0]).delete();
    }
}

