/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mac;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import mediathek.daten.DatenDownload;
import mediathek.tool.javafx.FXErrorDialog;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpotlightCommentWriter {
    private static final Logger logger = LogManager.getLogger(SpotlightCommentWriter.class);

    private void logUnofficialMacAppUse() {
        logger.error("MediathekView macOS: OFFICIAL DMG APP IS NOT USED!");
    }

    public void writeComment(DatenDownload datenDownload) {
        if (datenDownload.film == null) {
            return;
        }
        Path filmPath = Paths.get(datenDownload.arr[31], new String[0]);
        if (Files.exists(filmPath, new LinkOption[0])) {
            String strFilePath = filmPath.toString();
            String strComment = datenDownload.film.getDescription();
            if (strComment != null) {
                if (strComment.isEmpty()) {
                    return;
                }
                strComment = StringUtils.replace(strComment, "\"", "\\\"");
                String script = "tell application \"Finder\"\nset my_file to POSIX file \"" + strFilePath + "\" as alias\nset comment of my_file to \"" + strComment + "\"\nend tell\n";
                try {
                    logger.trace("Writing spotlight comment");
                    ProcessBuilder builder = new ProcessBuilder("/usr/bin/osascript", "-e");
                    builder.command().add(script);
                    builder.start().waitFor(5L, TimeUnit.SECONDS);
                    logger.trace("Spotlight writing finished");
                }
                catch (Exception ex) {
                    Platform.runLater(() -> FXErrorDialog.showErrorDialog("Fehler", "Fehler beim Schreiben des Spotlight-Kommentars", "Es trat ein Fehler beim Schreiben des Spotlight-Kommentars auf.\nSollte dieser h\u00e4ufiger auftreten kontaktieren Sie bitte das Entwicklerteam.", ex));
                    logger.error("Fehler beim Spotlight schreiben: {}", (Object)filmPath.toString(), (Object)ex);
                    try {
                        if (!System.getProperty("OSX_OFFICIAL_APP").equalsIgnoreCase("true")) {
                            this.logUnofficialMacAppUse();
                        }
                    }
                    catch (NullPointerException ignored) {
                        this.logUnofficialMacAppUse();
                    }
                }
            }
        }
    }
}

