/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.ArrayList;
import java.util.List;
import org.apache.jasper.compiler.SmapStratum;

public class SmapGenerator {
    private String outputFileName;
    private String defaultStratum = "Java";
    private final List<SmapStratum> strata = new ArrayList<SmapStratum>();
    private final List<String> embedded = new ArrayList<String>();
    private boolean doEmbedded = true;

    public synchronized void setOutputFileName(String string) {
        this.outputFileName = string;
    }

    public synchronized void setStratum(SmapStratum smapStratum) {
        this.addStratum(smapStratum, true);
    }

    @Deprecated
    public synchronized void addStratum(SmapStratum smapStratum, boolean bl) {
        this.strata.add(smapStratum);
        if (bl) {
            this.defaultStratum = smapStratum.getStratumName();
        }
    }

    @Deprecated
    public synchronized void addSmap(String string, String string2) {
        this.embedded.add("*O " + string2 + "\n" + string + "*C " + string2 + "\n");
    }

    @Deprecated
    public void setDoEmbedded(boolean bl) {
        this.doEmbedded = bl;
    }

    public synchronized String getString() {
        int n;
        int n2;
        if (this.outputFileName == null) {
            throw new IllegalStateException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SMAP\n");
        stringBuilder.append(this.outputFileName + '\n');
        stringBuilder.append(this.defaultStratum + '\n');
        if (this.doEmbedded) {
            n2 = this.embedded.size();
            for (n = 0; n < n2; ++n) {
                stringBuilder.append(this.embedded.get(n));
            }
        }
        n2 = this.strata.size();
        for (n = 0; n < n2; ++n) {
            SmapStratum smapStratum = this.strata.get(n);
            stringBuilder.append(smapStratum.getString());
        }
        stringBuilder.append("*E\n");
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getString();
    }

    public static void main(String[] stringArray) {
        SmapGenerator smapGenerator = new SmapGenerator();
        smapGenerator.setOutputFileName("foo.java");
        SmapStratum smapStratum = new SmapStratum();
        smapStratum.addFile("foo.jsp");
        smapStratum.addFile("bar.jsp", "/foo/foo/bar.jsp");
        smapStratum.addLineData(1, "foo.jsp", 1, 1, 1);
        smapStratum.addLineData(2, "foo.jsp", 1, 6, 1);
        smapStratum.addLineData(3, "foo.jsp", 2, 10, 5);
        smapStratum.addLineData(20, "bar.jsp", 1, 30, 1);
        smapGenerator.addStratum(smapStratum, true);
        System.out.print(smapGenerator);
        System.out.println("---");
        SmapGenerator smapGenerator2 = new SmapGenerator();
        smapGenerator2.setOutputFileName("blargh.tier2");
        smapStratum = new SmapStratum("Tier2");
        smapStratum.addFile("1.tier2");
        smapStratum.addLineData(1, "1.tier2", 1, 1, 1);
        smapGenerator2.addStratum(smapStratum, true);
        smapGenerator.addSmap(smapGenerator2.toString(), "JSP");
        System.out.println(smapGenerator);
    }
}

