/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.locks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.global.TransactionalSupport;
import org.netbeans.lib.profiler.results.BaseCallGraphBuilder;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUProfilingResultListener;
import org.netbeans.lib.profiler.results.locks.LockCCTProvider;
import org.netbeans.lib.profiler.results.locks.LockProfilingResultListener;
import org.netbeans.lib.profiler.results.locks.LockRuntimeCCTNode;
import org.netbeans.lib.profiler.results.locks.MonitorInfo;
import org.netbeans.lib.profiler.results.locks.ThreadInfo;
import org.netbeans.lib.profiler.results.locks.ThreadInfos;
import org.netbeans.lib.profiler.results.memory.MemoryProfilingResultsListener;

public class LockGraphBuilder
extends BaseCallGraphBuilder
implements LockProfilingResultListener,
LockCCTProvider {
    static final Logger LOG = Logger.getLogger(LockGraphBuilder.class.getName());
    private final ThreadInfos threadInfos = new ThreadInfos();
    private Map<Integer, MonitorInfo> monitorInfos = new HashMap<Integer, MonitorInfo>();
    private final TransactionalSupport transaction = new TransactionalSupport();

    @Override
    protected RuntimeCCTNode getAppRootNode() {
        HashMap<ThreadInfo, List<List<ThreadInfo.MonitorDetail>>> hashMap = new HashMap<ThreadInfo, List<List<ThreadInfo.MonitorDetail>>>(this.threadInfos.threadInfos.length);
        HashMap<MonitorInfo, List<List<MonitorInfo.ThreadDetail>>> hashMap2 = new HashMap<MonitorInfo, List<List<MonitorInfo.ThreadDetail>>>(this.monitorInfos.size());
        for (ThreadInfo threadInfo : this.threadInfos.threadInfos) {
            if (threadInfo == null) continue;
            ArrayList<List<ThreadInfo.MonitorDetail>> arrayList = new ArrayList<List<ThreadInfo.MonitorDetail>>(2);
            if (threadInfo.isEmpty()) continue;
            arrayList.add(threadInfo.cloneWaitMonitorDetails());
            arrayList.add(threadInfo.cloneOwnerMonitorDetails());
            hashMap.put(threadInfo, arrayList);
        }
        for (MonitorInfo monitorInfo : this.monitorInfos.values()) {
            ArrayList<List<MonitorInfo.ThreadDetail>> arrayList = new ArrayList<List<MonitorInfo.ThreadDetail>>(2);
            arrayList.add(monitorInfo.cloneWaitThreadDetails());
            arrayList.add(monitorInfo.cloneOwnerThreadDetails());
            hashMap2.put(monitorInfo, arrayList);
        }
        return new LockRuntimeCCTNode(hashMap, hashMap2);
    }

    @Override
    protected void doBatchStart() {
        this.transaction.beginTrans(true);
    }

    @Override
    protected void doBatchStop() {
        this.transaction.endTrans();
    }

    @Override
    protected void doReset() {
        boolean bl;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Do Reset called");
        }
        if (bl = this.transaction.beginTrans(true, true)) {
            try {
                this.threadInfos.reset();
                this.monitorInfos = new HashMap<Integer, MonitorInfo>();
            }
            finally {
                this.transaction.endTrans();
            }
        }
    }

    @Override
    protected void doShutdown() {
        this.threadInfos.reset();
        this.monitorInfos = new HashMap<Integer, MonitorInfo>();
    }

    @Override
    protected void doStartup(ProfilerClient profilerClient) {
    }

    @Override
    public void monitorEntry(int n, long l, long l2, int n2, int n3) {
        ThreadInfo threadInfo = this.getThreadInfo(n);
        if (threadInfo == null) {
            return;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Monitor entry thread id = {0}, mId = {1}, owner id = {2}", new Object[]{n, Integer.toHexString(n2), n3});
        }
        MonitorInfo monitorInfo = this.getMonitorInfo(n2);
        ThreadInfo threadInfo2 = this.getThreadInfo(n3);
        assert (threadInfo2 != null);
        threadInfo.openMonitor(threadInfo2, monitorInfo, l);
        monitorInfo.openThread(threadInfo, threadInfo2, l);
    }

    @Override
    public void monitorExit(int n, long l, long l2, int n2) {
        ThreadInfo threadInfo = this.getThreadInfo(n);
        if (threadInfo == null) {
            return;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Monitor exit thread id = {0}, mId = {1}", new Object[]{n, Integer.toHexString(n2)});
        }
        MonitorInfo monitorInfo = this.getMonitorInfo(n2);
        threadInfo.closeMonitor(monitorInfo, l);
        monitorInfo.closeThread(threadInfo, l);
        this.batchNotEmpty = true;
    }

    @Override
    public void newThread(int n, String string, String string2) {
        if (!this.isReady()) {
            return;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "New thread creation for thread id = {0}, name = {1}", new Object[]{n, string});
        }
        this.threadInfos.newThreadInfo(n, string, string2);
    }

    @Override
    public void newMonitor(int n, String string) {
        if (!this.isReady()) {
            return;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "New monitor creation, mId = {0}, className = {1}", new Object[]{Integer.toHexString(n), string});
        }
        this.registerNewMonitor(n, string);
    }

    @Override
    public void profilingPoint(int n, int n2, long l) {
    }

    @Override
    public void timeAdjust(int n, long l, long l2) {
        ThreadInfo threadInfo = this.getThreadInfo(n);
        if (threadInfo == null) {
            return;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Time adjust thread id = {0}, time = {1}, CPU time = {2}", new Object[]{n, l, l2});
        }
        threadInfo.timeAdjust(l);
    }

    private boolean isReady() {
        return this.status != null;
    }

    private ThreadInfo getThreadInfo(int n) {
        if (!this.isReady()) {
            return null;
        }
        return this.threadInfos.getThreadInfo(n);
    }

    private MonitorInfo getMonitorInfo(int n) {
        Integer n2 = new Integer(n);
        MonitorInfo monitorInfo = this.monitorInfos.get(n2);
        if (monitorInfo == null) {
            monitorInfo = new MonitorInfo(n);
            this.monitorInfos.put(n2, monitorInfo);
        }
        return monitorInfo;
    }

    private void registerNewMonitor(int n, String string) {
        Integer n2 = new Integer(n);
        MonitorInfo monitorInfo = this.monitorInfos.get(n2);
        if (monitorInfo == null) {
            monitorInfo = new MonitorInfo(n, string);
            this.monitorInfos.put(n2, monitorInfo);
        } else {
            monitorInfo.setClassName(string);
        }
    }

    public static final class MemoryLockGraphBuilder
    extends LockGraphBuilder
    implements MemoryProfilingResultsListener {
        @Override
        public void onAllocStackTrace(char c, long l, int[] nArray) {
        }

        @Override
        public void onGcPerformed(char c, long l, int n) {
        }

        @Override
        public void onLivenessStackTrace(char c, long l, int n, long l2, int[] nArray) {
        }
    }

    public static final class CPULockGraphBuilder
    extends LockGraphBuilder
    implements CPUProfilingResultListener {
        @Override
        public void methodEntry(int n, int n2, int n3, long l, long l2, List list, int[] nArray) {
        }

        @Override
        public void methodEntryUnstamped(int n, int n2, int n3, List list, int[] nArray) {
        }

        @Override
        public void methodExit(int n, int n2, int n3, long l, long l2, Object object) {
        }

        @Override
        public void methodExitUnstamped(int n, int n2, int n3) {
        }

        @Override
        public void servletRequest(int n, int n2, String string, int n3) {
        }

        @Override
        public void sleepEntry(int n, long l, long l2) {
        }

        @Override
        public void sleepExit(int n, long l, long l2) {
        }

        @Override
        public void threadsResume(long l, long l2) {
        }

        @Override
        public void threadsSuspend(long l, long l2) {
        }

        @Override
        public void waitEntry(int n, long l, long l2) {
        }

        @Override
        public void waitExit(int n, long l, long l2) {
        }

        @Override
        public void parkEntry(int n, long l, long l2) {
        }

        @Override
        public void parkExit(int n, long l, long l2) {
        }
    }
}

