/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.util;

import com.topografix.gpx._1._0.BoundsType;
import com.topografix.gpx._1._0.Gpx;
import com.topografix.gpx._1._0.ObjectFactory;
import java.math.BigDecimal;
import junit.framework.TestCase;
import org.fibs.geotag.util.BoundsTypeUtil;

public class BoundsTypeUtilTest
extends TestCase {
    private static final int WIDTH = 4000;
    private static final int HEIGHT = 3000;
    private static final int DIAGONAL = 5000;
    private static final double SOUTH = 51.0;
    private static final double NORTH = 52.0;
    private static final double EAST = -1.0;
    private static final double WEST = 1.0;
    private static final double DELTA = 0.1;

    public void testPixeldistance() {
        ObjectFactory objectFactory = new ObjectFactory();
        int width = 4000;
        int height = 3000;
        BoundsType mapBounds = objectFactory.createBoundsType();
        mapBounds.setMinlat(new BigDecimal(51.0));
        mapBounds.setMaxlat(new BigDecimal(52.0));
        mapBounds.setMinlon(new BigDecimal(-1.0));
        mapBounds.setMaxlon(new BigDecimal(1.0));
        Gpx.Trk.Trkseg.Trkpt point1 = objectFactory.createGpxTrkTrksegTrkpt();
        point1.setLat(new BigDecimal(52.0));
        point1.setLon(new BigDecimal(-1.0));
        Gpx.Trk.Trkseg.Trkpt point2 = objectFactory.createGpxTrkTrksegTrkpt();
        point2.setLat(new BigDecimal(51.0));
        point2.setLon(new BigDecimal(1.0));
        double distanceInPixels = BoundsTypeUtil.pixelDistance(point1, point2, mapBounds, width, height);
        BoundsTypeUtilTest.assertEquals((double)5000.0, (double)distanceInPixels, (double)0.1);
    }
}

