/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class CheckNoMutatedEs6Exports
implements NodeTraversal.Callback,
CompilerPass {
    public static final DiagnosticType MUTATED_EXPORT = DiagnosticType.warning("JSC_MUTATED_EXPORT", "The name \"{0}\" is exported and should not be mutated outside of module initialization. Mutable exports are generally difficult to reason about. You can work around this by exporting getter/setter functions, or an object with mutable properties instead.");
    private final AbstractCompiler compiler;
    private final Multimap<String, Node> mutatedNames = MultimapBuilder.hashKeys().hashSetValues().build();
    private final Set<String> exportedLocalNames = new HashSet<String>();

    public CheckNoMutatedEs6Exports(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    private void checkNoMutations() {
        Sets.SetView<String> mutatedExports = Sets.intersection(this.mutatedNames.keySet(), this.exportedLocalNames);
        for (String mutatedExport : mutatedExports) {
            for (Node mutation : this.mutatedNames.get(mutatedExport)) {
                this.compiler.report(JSError.make(mutation, MUTATED_EXPORT, mutatedExport));
            }
        }
        this.mutatedNames.clear();
        this.exportedLocalNames.clear();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isModuleBody()) {
            this.checkNoMutations();
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case SCRIPT: {
                return n.getBooleanProp(Node.ES6_MODULE);
            }
            case EXPORT: {
                this.visitExport(n);
                return true;
            }
            case NAME: {
                this.visitName(t, n);
                return true;
            }
        }
        return true;
    }

    private void visitExport(Node export) {
        if (export.hasOneChild() && export.getFirstChild().getToken() == Token.EXPORT_SPECS) {
            for (Node exportSpec : export.getFirstChild().children()) {
                Preconditions.checkState(exportSpec.hasTwoChildren());
                this.exportedLocalNames.add(exportSpec.getFirstChild().getString());
            }
        } else if (export.hasOneChild() && !export.getBooleanProp(Node.EXPORT_ALL_FROM)) {
            Node declaration = export.getFirstChild();
            if (NodeUtil.isNameDeclaration(declaration)) {
                List<Node> lhsNodes = NodeUtil.findLhsNodesInNode(declaration);
                for (Node lhs : lhsNodes) {
                    Preconditions.checkState(lhs.isName());
                    this.exportedLocalNames.add(lhs.getString());
                }
            } else if (export.getBooleanProp(Node.EXPORT_DEFAULT)) {
                if (!declaration.isClass() && !declaration.isFunction()) {
                    return;
                }
                Node nameNode = declaration.getFirstChild();
                if (!nameNode.isEmpty() && !nameNode.getString().isEmpty()) {
                    this.exportedLocalNames.add(nameNode.getString());
                }
            } else {
                Preconditions.checkState(declaration.isClass() || declaration.isFunction());
                Node nameNode = declaration.getFirstChild();
                this.exportedLocalNames.add(nameNode.getString());
            }
        }
    }

    private void visitName(NodeTraversal t, Node name) {
        Var var;
        Scope scope = t.getScope();
        if (NodeUtil.isLValue(name) && !((Scope)scope.getClosestHoistScope()).isModuleScope() && (var = (Var)scope.getVar(name.getString())) != null && ((Scope)var.getScope()).isModuleScope()) {
            this.mutatedNames.put(name.getString(), name);
        }
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }
}

