/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.CipherSuite;
import org.bouncycastle.tls.ClientHello;
import org.bouncycastle.tls.DTLSProtocol;
import org.bouncycastle.tls.DTLSRecordLayer;
import org.bouncycastle.tls.DTLSReliableHandshake;
import org.bouncycastle.tls.DTLSTransport;
import org.bouncycastle.tls.DatagramTransport;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.HeartbeatExtension;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.ServerHello;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientContextImpl;
import org.bouncycastle.tls.TlsCloseable;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsHeartbeat;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.util.Arrays;

public class DTLSClientProtocol
extends DTLSProtocol {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DTLSTransport connect(TlsClient tlsClient, DatagramTransport datagramTransport) throws IOException {
        Object object;
        Object object2;
        if (tlsClient == null) {
            throw new IllegalArgumentException("'client' cannot be null");
        }
        if (datagramTransport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        ClientHandshakeState clientHandshakeState = new ClientHandshakeState();
        clientHandshakeState.client = tlsClient;
        clientHandshakeState.clientContext = new TlsClientContextImpl(tlsClient.getCrypto());
        tlsClient.init(clientHandshakeState.clientContext);
        clientHandshakeState.clientContext.handshakeBeginning(tlsClient);
        SecurityParameters securityParameters = clientHandshakeState.clientContext.getSecurityParametersHandshake();
        securityParameters.extendedPadding = tlsClient.shouldUseExtendedPadding();
        TlsSession tlsSession = clientHandshakeState.client.getSessionToResume();
        if (tlsSession != null && tlsSession.isResumable() && (object2 = tlsSession.exportSessionParameters()) != null && (((SessionParameters)object2).isExtendedMasterSecret() || !clientHandshakeState.client.requiresExtendedMasterSecret() && clientHandshakeState.client.allowLegacyResumption())) {
            object = ((SessionParameters)object2).getMasterSecret();
            TlsSecret tlsSecret = object;
            synchronized (tlsSecret) {
                if (object.isAlive()) {
                    clientHandshakeState.tlsSession = tlsSession;
                    clientHandshakeState.sessionParameters = object2;
                    clientHandshakeState.sessionMasterSecret = clientHandshakeState.clientContext.getCrypto().adoptSecret((TlsSecret)object);
                }
            }
        }
        object2 = new DTLSRecordLayer(clientHandshakeState.clientContext, clientHandshakeState.client, datagramTransport);
        tlsClient.notifyCloseHandle((TlsCloseable)object2);
        try {
            object = this.clientHandshake(clientHandshakeState, (DTLSRecordLayer)object2);
            return object;
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.abortClientHandshake(clientHandshakeState, (DTLSRecordLayer)object2, tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.abortClientHandshake(clientHandshakeState, (DTLSRecordLayer)object2, (short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.abortClientHandshake(clientHandshakeState, (DTLSRecordLayer)object2, (short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
        finally {
            securityParameters.clear();
        }
    }

    protected void abortClientHandshake(ClientHandshakeState clientHandshakeState, DTLSRecordLayer dTLSRecordLayer, short s) {
        dTLSRecordLayer.fail(s);
        this.invalidateSession(clientHandshakeState);
    }

    protected DTLSTransport clientHandshake(ClientHandshakeState clientHandshakeState, DTLSRecordLayer dTLSRecordLayer) throws IOException {
        Object object;
        Object object2;
        Object object3;
        SecurityParameters securityParameters = clientHandshakeState.clientContext.getSecurityParametersHandshake();
        DTLSReliableHandshake dTLSReliableHandshake = new DTLSReliableHandshake(clientHandshakeState.clientContext, dTLSRecordLayer, clientHandshakeState.client.getHandshakeTimeoutMillis(), null);
        byte[] byArray = this.generateClientHello(clientHandshakeState);
        dTLSRecordLayer.setWriteVersion(ProtocolVersion.DTLSv10);
        dTLSReliableHandshake.sendMessage((short)1, byArray);
        DTLSReliableHandshake.Message message = dTLSReliableHandshake.receiveMessage();
        while (message.getType() == 3) {
            object3 = dTLSRecordLayer.getReadVersion();
            if (!((ProtocolVersion)object3).isEqualOrEarlierVersionOf((ProtocolVersion)(object2 = clientHandshakeState.clientContext.getClientVersion()))) {
                throw new TlsFatalAlert(47);
            }
            dTLSRecordLayer.setReadVersion(null);
            object = this.processHelloVerifyRequest(clientHandshakeState, message.getBody());
            byte[] byArray2 = DTLSClientProtocol.patchClientHelloWithCookie(byArray, object);
            dTLSReliableHandshake.resetAfterHelloVerifyRequestClient();
            dTLSReliableHandshake.sendMessage((short)1, byArray2);
            message = dTLSReliableHandshake.receiveMessage();
        }
        if (message.getType() != 2) {
            throw new TlsFatalAlert(10);
        }
        object3 = dTLSRecordLayer.getReadVersion();
        this.reportServerVersion(clientHandshakeState, (ProtocolVersion)object3);
        dTLSRecordLayer.setWriteVersion((ProtocolVersion)object3);
        this.processServerHello(clientHandshakeState, message.getBody());
        dTLSReliableHandshake.getHandshakeHash().notifyPRFDetermined();
        DTLSClientProtocol.applyMaxFragmentLengthExtension(dTLSRecordLayer, securityParameters.getMaxFragmentLength());
        if (clientHandshakeState.resumedSession) {
            securityParameters.masterSecret = clientHandshakeState.sessionMasterSecret;
            dTLSRecordLayer.initPendingEpoch(TlsUtils.initCipher(clientHandshakeState.clientContext));
            securityParameters.peerVerifyData = DTLSClientProtocol.createVerifyData(clientHandshakeState.clientContext, dTLSReliableHandshake, true);
            this.processFinished(dTLSReliableHandshake.receiveMessageBody((short)20), securityParameters.getPeerVerifyData());
            securityParameters.localVerifyData = DTLSClientProtocol.createVerifyData(clientHandshakeState.clientContext, dTLSReliableHandshake, false);
            dTLSReliableHandshake.sendMessage((short)20, securityParameters.getLocalVerifyData());
            dTLSReliableHandshake.finish();
            if (securityParameters.isExtendedMasterSecret()) {
                securityParameters.tlsUnique = securityParameters.getPeerVerifyData();
            }
            clientHandshakeState.clientContext.handshakeComplete(clientHandshakeState.client, clientHandshakeState.tlsSession);
            dTLSRecordLayer.initHeartbeat(clientHandshakeState.heartbeat, 1 == clientHandshakeState.heartbeatPolicy);
            return new DTLSTransport(dTLSRecordLayer);
        }
        this.invalidateSession(clientHandshakeState);
        clientHandshakeState.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
        clientHandshakeState.sessionParameters = null;
        clientHandshakeState.sessionMasterSecret = null;
        message = dTLSReliableHandshake.receiveMessage();
        if (message.getType() == 23) {
            this.processServerSupplementalData(clientHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        } else {
            clientHandshakeState.client.processServerSupplementalData(null);
        }
        clientHandshakeState.keyExchange = TlsUtils.initKeyExchangeClient(clientHandshakeState.clientContext, clientHandshakeState.client);
        if (message.getType() == 11) {
            this.processServerCertificate(clientHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        } else {
            clientHandshakeState.authentication = null;
        }
        if (message.getType() == 22) {
            this.processCertificateStatus(clientHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        }
        TlsUtils.processServerCertificate(clientHandshakeState.clientContext, clientHandshakeState.client, clientHandshakeState.certificateStatus, clientHandshakeState.keyExchange, clientHandshakeState.authentication, clientHandshakeState.clientExtensions, clientHandshakeState.serverExtensions);
        if (message.getType() == 12) {
            this.processServerKeyExchange(clientHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        } else {
            clientHandshakeState.keyExchange.skipServerKeyExchange();
        }
        if (message.getType() == 13) {
            this.processCertificateRequest(clientHandshakeState, message.getBody());
            clientHandshakeState.certificateRequest = TlsUtils.validateCertificateRequest(clientHandshakeState.certificateRequest, clientHandshakeState.keyExchange);
            TlsUtils.establishServerSigAlgs(securityParameters, clientHandshakeState.certificateRequest);
            TlsUtils.trackHashAlgorithms(dTLSReliableHandshake.getHandshakeHash(), securityParameters.getServerSigAlgs());
            message = dTLSReliableHandshake.receiveMessage();
        }
        if (message.getType() == 14) {
            if (message.getBody().length != 0) {
                throw new TlsFatalAlert(50);
            }
        } else {
            throw new TlsFatalAlert(10);
        }
        object3 = clientHandshakeState.client.getClientSupplementalData();
        if (object3 != null) {
            object2 = DTLSClientProtocol.generateSupplementalData((Vector)object3);
            dTLSReliableHandshake.sendMessage((short)23, (byte[])object2);
        }
        if (null != clientHandshakeState.certificateRequest) {
            clientHandshakeState.clientCredentials = TlsUtils.establishClientCredentials(clientHandshakeState.authentication, clientHandshakeState.certificateRequest);
            object2 = null;
            if (null != clientHandshakeState.clientCredentials) {
                object2 = clientHandshakeState.clientCredentials.getCertificate();
            }
            DTLSClientProtocol.sendCertificateMessage(clientHandshakeState.clientContext, dTLSReliableHandshake, (Certificate)object2, null);
        }
        object2 = null;
        object = null;
        if (null != clientHandshakeState.clientCredentials) {
            clientHandshakeState.keyExchange.processClientCredentials(clientHandshakeState.clientCredentials);
            if (clientHandshakeState.clientCredentials instanceof TlsCredentialedSigner) {
                object2 = (TlsCredentialedSigner)clientHandshakeState.clientCredentials;
                object = object2.getStreamSigner();
            }
        } else {
            clientHandshakeState.keyExchange.skipClientCredentials();
        }
        boolean bl = object != null;
        TlsUtils.sealHandshakeHash(clientHandshakeState.clientContext, dTLSReliableHandshake.getHandshakeHash(), bl);
        byte[] byArray3 = this.generateClientKeyExchange(clientHandshakeState);
        dTLSReliableHandshake.sendMessage((short)16, byArray3);
        securityParameters.sessionHash = TlsUtils.getCurrentPRFHash(dTLSReliableHandshake.getHandshakeHash());
        TlsProtocol.establishMasterSecret(clientHandshakeState.clientContext, clientHandshakeState.keyExchange);
        dTLSRecordLayer.initPendingEpoch(TlsUtils.initCipher(clientHandshakeState.clientContext));
        if (object2 != null) {
            DigitallySigned digitallySigned = TlsUtils.generateCertificateVerify(clientHandshakeState.clientContext, (TlsCredentialedSigner)object2, (TlsStreamSigner)object, dTLSReliableHandshake.getHandshakeHash());
            byte[] byArray4 = this.generateCertificateVerify(clientHandshakeState, digitallySigned);
            dTLSReliableHandshake.sendMessage((short)15, byArray4);
        }
        dTLSReliableHandshake.prepareToFinish();
        securityParameters.localVerifyData = DTLSClientProtocol.createVerifyData(clientHandshakeState.clientContext, dTLSReliableHandshake, false);
        dTLSReliableHandshake.sendMessage((short)20, securityParameters.getLocalVerifyData());
        if (clientHandshakeState.expectSessionTicket) {
            message = dTLSReliableHandshake.receiveMessage();
            if (message.getType() == 4) {
                this.processNewSessionTicket(clientHandshakeState, message.getBody());
            } else {
                throw new TlsFatalAlert(10);
            }
        }
        securityParameters.peerVerifyData = DTLSClientProtocol.createVerifyData(clientHandshakeState.clientContext, dTLSReliableHandshake, true);
        this.processFinished(dTLSReliableHandshake.receiveMessageBody((short)20), securityParameters.getPeerVerifyData());
        dTLSReliableHandshake.finish();
        clientHandshakeState.sessionMasterSecret = securityParameters.getMasterSecret();
        clientHandshakeState.sessionParameters = new SessionParameters.Builder().setCipherSuite(securityParameters.getCipherSuite()).setCompressionAlgorithm(securityParameters.getCompressionAlgorithm()).setExtendedMasterSecret(securityParameters.isExtendedMasterSecret()).setLocalCertificate(securityParameters.getLocalCertificate()).setMasterSecret(clientHandshakeState.clientContext.getCrypto().adoptSecret(clientHandshakeState.sessionMasterSecret)).setNegotiatedVersion(securityParameters.getNegotiatedVersion()).setPeerCertificate(securityParameters.getPeerCertificate()).setPSKIdentity(securityParameters.getPSKIdentity()).setSRPIdentity(securityParameters.getSRPIdentity()).setServerExtensions(clientHandshakeState.serverExtensions).build();
        clientHandshakeState.tlsSession = TlsUtils.importSession(clientHandshakeState.tlsSession.getSessionID(), clientHandshakeState.sessionParameters);
        securityParameters.tlsUnique = securityParameters.getLocalVerifyData();
        clientHandshakeState.clientContext.handshakeComplete(clientHandshakeState.client, clientHandshakeState.tlsSession);
        dTLSRecordLayer.initHeartbeat(clientHandshakeState.heartbeat, 1 == clientHandshakeState.heartbeatPolicy);
        return new DTLSTransport(dTLSRecordLayer);
    }

    protected byte[] generateCertificateVerify(ClientHandshakeState clientHandshakeState, DigitallySigned digitallySigned) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        digitallySigned.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateClientHello(ClientHandshakeState clientHandshakeState) throws IOException {
        boolean bl;
        TlsClientContextImpl tlsClientContextImpl = clientHandshakeState.clientContext;
        SecurityParameters securityParameters = tlsClientContextImpl.getSecurityParametersHandshake();
        tlsClientContextImpl.setClientSupportedVersions(clientHandshakeState.client.getProtocolVersions());
        ProtocolVersion protocolVersion = ProtocolVersion.getLatestDTLS(tlsClientContextImpl.getClientSupportedVersions());
        if (!ProtocolVersion.isSupportedDTLSVersion(protocolVersion)) {
            throw new TlsFatalAlert(80);
        }
        tlsClientContextImpl.setClientVersion(protocolVersion);
        byte[] byArray = TlsUtils.getSessionID(clientHandshakeState.tlsSession);
        boolean bl2 = clientHandshakeState.client.isFallback();
        clientHandshakeState.offeredCipherSuites = clientHandshakeState.client.getCipherSuites();
        if (!(byArray.length <= 0 || clientHandshakeState.sessionParameters == null || Arrays.contains((int[])clientHandshakeState.offeredCipherSuites, (int)clientHandshakeState.sessionParameters.getCipherSuite()) && 0 == clientHandshakeState.sessionParameters.getCompressionAlgorithm())) {
            byArray = TlsUtils.EMPTY_BYTES;
        }
        clientHandshakeState.clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(clientHandshakeState.client.getClientExtensions());
        ProtocolVersion protocolVersion2 = protocolVersion;
        if (protocolVersion.isLaterVersionOf(ProtocolVersion.DTLSv12)) {
            protocolVersion2 = ProtocolVersion.DTLSv12;
            TlsExtensionsUtils.addSupportedVersionsExtensionClient(clientHandshakeState.clientExtensions, tlsClientContextImpl.getClientSupportedVersions());
        }
        tlsClientContextImpl.setRSAPreMasterSecretVersion(protocolVersion2);
        securityParameters.clientServerNames = TlsExtensionsUtils.getServerNameExtensionClient(clientHandshakeState.clientExtensions);
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion)) {
            TlsUtils.establishClientSigAlgs(securityParameters, clientHandshakeState.clientExtensions);
        }
        securityParameters.clientSupportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(clientHandshakeState.clientExtensions);
        clientHandshakeState.clientAgreements = TlsUtils.addEarlyKeySharesToClientHello(clientHandshakeState.clientContext, clientHandshakeState.client, clientHandshakeState.clientExtensions);
        if (clientHandshakeState.client.shouldUseExtendedMasterSecret()) {
            TlsExtensionsUtils.addExtendedMasterSecretExtension(clientHandshakeState.clientExtensions);
        } else if (clientHandshakeState.client.requiresExtendedMasterSecret()) {
            throw new TlsFatalAlert(80);
        }
        securityParameters.clientRandom = TlsProtocol.createRandomBlock(clientHandshakeState.client.shouldUseGMTUnixTime(), clientHandshakeState.clientContext);
        boolean bl3 = null == TlsUtils.getExtensionData(clientHandshakeState.clientExtensions, TlsProtocol.EXT_RenegotiationInfo);
        boolean bl4 = bl = !Arrays.contains((int[])clientHandshakeState.offeredCipherSuites, (int)255);
        if (bl3 && bl) {
            clientHandshakeState.offeredCipherSuites = Arrays.append((int[])clientHandshakeState.offeredCipherSuites, (int)255);
        }
        if (bl2 && !Arrays.contains((int[])clientHandshakeState.offeredCipherSuites, (int)22016)) {
            clientHandshakeState.offeredCipherSuites = Arrays.append((int[])clientHandshakeState.offeredCipherSuites, (int)22016);
        }
        clientHandshakeState.heartbeat = clientHandshakeState.client.getHeartbeat();
        clientHandshakeState.heartbeatPolicy = clientHandshakeState.client.getHeartbeatPolicy();
        if (null != clientHandshakeState.heartbeat || 1 == clientHandshakeState.heartbeatPolicy) {
            TlsExtensionsUtils.addHeartbeatExtension(clientHandshakeState.clientExtensions, new HeartbeatExtension(clientHandshakeState.heartbeatPolicy));
        }
        ClientHello clientHello = new ClientHello(protocolVersion2, securityParameters.getClientRandom(), byArray, TlsUtils.EMPTY_BYTES, clientHandshakeState.offeredCipherSuites, clientHandshakeState.clientExtensions);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        clientHello.encode(clientHandshakeState.clientContext, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateClientKeyExchange(ClientHandshakeState clientHandshakeState) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        clientHandshakeState.keyExchange.generateClientKeyExchange(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected void invalidateSession(ClientHandshakeState clientHandshakeState) {
        if (clientHandshakeState.sessionMasterSecret != null) {
            clientHandshakeState.sessionMasterSecret.destroy();
            clientHandshakeState.sessionMasterSecret = null;
        }
        if (clientHandshakeState.sessionParameters != null) {
            clientHandshakeState.sessionParameters.clear();
            clientHandshakeState.sessionParameters = null;
        }
        if (clientHandshakeState.tlsSession != null) {
            clientHandshakeState.tlsSession.invalidate();
            clientHandshakeState.tlsSession = null;
        }
    }

    protected void processCertificateRequest(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        if (clientHandshakeState.authentication == null) {
            throw new TlsFatalAlert(40);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        clientHandshakeState.certificateRequest = CertificateRequest.parse(clientHandshakeState.clientContext, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
    }

    protected void processCertificateStatus(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        if (!clientHandshakeState.allowCertificateStatus) {
            throw new TlsFatalAlert(10);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        clientHandshakeState.certificateStatus = CertificateStatus.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
    }

    protected byte[] processHelloVerifyRequest(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        int n = ProtocolVersion.DTLSv12.isEqualOrEarlierVersionOf(protocolVersion) ? 255 : 32;
        byte[] byArray2 = TlsUtils.readOpaque8(byteArrayInputStream, 0, n);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        if (!protocolVersion.isEqualOrEarlierVersionOf(clientHandshakeState.clientContext.getClientVersion())) {
            throw new TlsFatalAlert(47);
        }
        return byArray2;
    }

    protected void processNewSessionTicket(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        clientHandshakeState.client.notifyNewSessionTicket(newSessionTicket);
    }

    protected void processServerCertificate(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        TlsUtils.receiveServerCertificate(clientHandshakeState.clientContext, new ByteArrayInputStream(byArray));
        clientHandshakeState.authentication = clientHandshakeState.client.getAuthentication();
        if (null == clientHandshakeState.authentication) {
            throw new TlsFatalAlert(80);
        }
    }

    protected void processServerHello(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        Object object;
        Serializable serializable;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ServerHello serverHello = ServerHello.parse(byteArrayInputStream);
        ProtocolVersion protocolVersion = serverHello.getVersion();
        clientHandshakeState.serverExtensions = serverHello.getExtensions();
        SecurityParameters securityParameters = clientHandshakeState.clientContext.getSecurityParametersHandshake();
        this.reportServerVersion(clientHandshakeState, protocolVersion);
        securityParameters.serverRandom = serverHello.getRandom();
        if (!clientHandshakeState.clientContext.getClientVersion().equals(protocolVersion)) {
            TlsUtils.checkDowngradeMarker(protocolVersion, securityParameters.getServerRandom());
        }
        byte[] byArray2 = serverHello.getSessionID();
        securityParameters.sessionID = byArray2;
        clientHandshakeState.client.notifySessionID(byArray2);
        clientHandshakeState.resumedSession = byArray2.length > 0 && clientHandshakeState.tlsSession != null && Arrays.areEqual((byte[])byArray2, (byte[])clientHandshakeState.tlsSession.getSessionID());
        int n = serverHello.getCipherSuite();
        if (!Arrays.contains((int[])clientHandshakeState.offeredCipherSuites, (int)n) || n == 0 || CipherSuite.isSCSV(n) || !TlsUtils.isValidCipherSuiteForVersion(n, clientHandshakeState.clientContext.getServerVersion())) {
            throw new TlsFatalAlert(47);
        }
        securityParameters.cipherSuite = DTLSClientProtocol.validateSelectedCipherSuite(n, (short)47);
        TlsUtils.negotiatedCipherSuite(clientHandshakeState.clientContext);
        clientHandshakeState.client.notifySelectedCipherSuite(n);
        n = TlsExtensionsUtils.hasExtendedMasterSecretExtension(clientHandshakeState.serverExtensions) ? 1 : 0;
        if (n != 0 ? protocolVersion.isSSL() || !clientHandshakeState.resumedSession && !clientHandshakeState.client.shouldUseExtendedMasterSecret() : clientHandshakeState.client.requiresExtendedMasterSecret() || clientHandshakeState.resumedSession && !clientHandshakeState.client.allowLegacyResumption()) {
            throw new TlsFatalAlert(40);
        }
        securityParameters.extendedMasterSecret = n;
        if (clientHandshakeState.serverExtensions != null) {
            Enumeration enumeration = clientHandshakeState.serverExtensions.keys();
            while (enumeration.hasMoreElements()) {
                serializable = (Integer)enumeration.nextElement();
                if (((Integer)serializable).equals(TlsProtocol.EXT_RenegotiationInfo)) continue;
                if (null == TlsUtils.getExtensionData(clientHandshakeState.clientExtensions, (Integer)serializable)) {
                    throw new TlsFatalAlert(110);
                }
                if (!clientHandshakeState.resumedSession) continue;
            }
        }
        if ((object = TlsUtils.getExtensionData(clientHandshakeState.serverExtensions, TlsProtocol.EXT_RenegotiationInfo)) != null) {
            securityParameters.secureRenegotiation = true;
            if (!Arrays.constantTimeAreEqual((byte[])object, (byte[])TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        clientHandshakeState.client.notifySecureRenegotiation(securityParameters.isSecureRenegotiation());
        securityParameters.applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer(clientHandshakeState.serverExtensions);
        securityParameters.applicationProtocolSet = true;
        object = TlsExtensionsUtils.getHeartbeatExtension(clientHandshakeState.serverExtensions);
        if (null == object) {
            clientHandshakeState.heartbeat = null;
            clientHandshakeState.heartbeatPolicy = (short)2;
        } else if (1 != ((HeartbeatExtension)object).getMode()) {
            clientHandshakeState.heartbeat = null;
        }
        object = clientHandshakeState.clientExtensions;
        serializable = clientHandshakeState.serverExtensions;
        if (clientHandshakeState.resumedSession) {
            if (securityParameters.getCipherSuite() != clientHandshakeState.sessionParameters.getCipherSuite() || 0 != clientHandshakeState.sessionParameters.getCompressionAlgorithm() || !protocolVersion.equals(clientHandshakeState.sessionParameters.getNegotiatedVersion())) {
                throw new TlsFatalAlert(47);
            }
            object = null;
            serializable = clientHandshakeState.sessionParameters.readServerExtensions();
        }
        if (serializable != null && !((Hashtable)serializable).isEmpty()) {
            boolean bl = TlsExtensionsUtils.hasEncryptThenMACExtension((Hashtable)serializable);
            if (bl && !TlsUtils.isBlockCipherSuite(securityParameters.getCipherSuite())) {
                throw new TlsFatalAlert(47);
            }
            securityParameters.encryptThenMAC = bl;
            securityParameters.maxFragmentLength = DTLSClientProtocol.evaluateMaxFragmentLengthExtension(clientHandshakeState.resumedSession, (Hashtable)object, (Hashtable)serializable, (short)47);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension((Hashtable)serializable);
            clientHandshakeState.allowCertificateStatus = !clientHandshakeState.resumedSession && TlsUtils.hasExpectedEmptyExtensionData((Hashtable)serializable, TlsExtensionsUtils.EXT_status_request, (short)47);
            boolean bl2 = clientHandshakeState.expectSessionTicket = !clientHandshakeState.resumedSession && TlsUtils.hasExpectedEmptyExtensionData((Hashtable)serializable, TlsProtocol.EXT_SessionTicket, (short)47);
        }
        if (object != null) {
            clientHandshakeState.client.processServerExtensions((Hashtable)serializable);
        }
        securityParameters.prfAlgorithm = TlsProtocol.getPRFAlgorithm(clientHandshakeState.clientContext, securityParameters.getCipherSuite());
        securityParameters.verifyDataLength = 12;
    }

    protected void processServerKeyExchange(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        clientHandshakeState.keyExchange.processServerKeyExchange(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
    }

    protected void processServerSupplementalData(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector vector = TlsProtocol.readSupplementalDataMessage(byteArrayInputStream);
        clientHandshakeState.client.processServerSupplementalData(vector);
    }

    protected void reportServerVersion(ClientHandshakeState clientHandshakeState, ProtocolVersion protocolVersion) throws IOException {
        TlsClientContextImpl tlsClientContextImpl = clientHandshakeState.clientContext;
        SecurityParameters securityParameters = tlsClientContextImpl.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion2 = securityParameters.getNegotiatedVersion();
        if (null != protocolVersion2) {
            if (!protocolVersion2.equals(protocolVersion)) {
                throw new TlsFatalAlert(47);
            }
            return;
        }
        if (!ProtocolVersion.isSupportedDTLSVersion(protocolVersion) || !ProtocolVersion.contains(tlsClientContextImpl.getClientSupportedVersions(), protocolVersion)) {
            throw new TlsFatalAlert(47);
        }
        securityParameters.negotiatedVersion = protocolVersion;
        TlsUtils.negotiatedVersion(tlsClientContextImpl);
        clientHandshakeState.client.notifyServerVersion(protocolVersion);
    }

    protected static byte[] patchClientHelloWithCookie(byte[] byArray, byte[] byArray2) throws IOException {
        int n = 34;
        short s = TlsUtils.readUint8(byArray, n);
        int n2 = n + 1 + s;
        int n3 = n2 + 1;
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        TlsUtils.checkUint8(byArray2.length);
        TlsUtils.writeUint8(byArray2.length, byArray3, n2);
        System.arraycopy(byArray2, 0, byArray3, n3, byArray2.length);
        System.arraycopy(byArray, n3, byArray3, n3 + byArray2.length, byArray.length - n3);
        return byArray3;
    }

    protected static class ClientHandshakeState {
        TlsClient client = null;
        TlsClientContextImpl clientContext = null;
        TlsSession tlsSession = null;
        SessionParameters sessionParameters = null;
        TlsSecret sessionMasterSecret = null;
        SessionParameters.Builder sessionParametersBuilder = null;
        int[] offeredCipherSuites = null;
        Hashtable clientExtensions = null;
        Hashtable serverExtensions = null;
        boolean resumedSession = false;
        boolean allowCertificateStatus = false;
        boolean expectSessionTicket = false;
        Hashtable clientAgreements = null;
        TlsKeyExchange keyExchange = null;
        TlsAuthentication authentication = null;
        CertificateStatus certificateStatus = null;
        CertificateRequest certificateRequest = null;
        TlsCredentials clientCredentials = null;
        TlsHeartbeat heartbeat = null;
        short heartbeatPolicy = (short)2;

        protected ClientHandshakeState() {
        }
    }
}

