/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.library;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.protege.editor.core.ui.util.JOptionPaneEx;
import org.protege.editor.owl.model.library.CatalogEntryManager;
import org.protege.editor.owl.ui.library.NewEntryPanel;
import org.protege.xmlcatalog.XMLCatalog;
import org.protege.xmlcatalog.entry.Entry;
import org.slf4j.LoggerFactory;

public class AddEntryDialog
extends JPanel {
    private List<CatalogEntryManager> entryManagers;
    private XMLCatalog catalog;
    private JTabbedPane tabs;

    @Nullable
    public static Entry askUserForRepository(JComponent parent, XMLCatalog catalog, List<CatalogEntryManager> entryManagers) {
        AddEntryDialog dialog = new AddEntryDialog(entryManagers, catalog);
        int ret = JOptionPaneEx.showConfirmDialog((Component)parent, (String)"Add catalog entry", (JComponent)dialog, (int)-1, (int)2, null);
        if (ret != 0) {
            return null;
        }
        Entry e = dialog.getEntry();
        if (e == null) {
            return e;
        }
        catalog.addEntry(0, e);
        for (CatalogEntryManager entryManager : entryManagers) {
            if (!entryManager.isSuitable(e)) continue;
            try {
                entryManager.update(e);
            }
            catch (IOException ex) {
                LoggerFactory.getLogger(AddEntryDialog.class).error("An error occurred whilst adding a catalog entry: ", (Throwable)ex);
            }
        }
        return e;
    }

    private AddEntryDialog(List<CatalogEntryManager> entryManagers, XMLCatalog catalog) {
        this.entryManagers = entryManagers;
        this.catalog = catalog;
        this.setLayout(new BorderLayout());
        this.add((Component)this.createTabbedPane(), "Center");
        this.repaint();
    }

    private JTabbedPane createTabbedPane() {
        this.tabs = new JTabbedPane();
        for (CatalogEntryManager entryManager : this.entryManagers) {
            NewEntryPanel panel = entryManager.newEntryPanel(this.catalog);
            if (panel == null) continue;
            panel.setAlignmentY(0.5f);
            this.tabs.addTab(entryManager.getDescription(), panel);
        }
        return this.tabs;
    }

    public Entry getEntry() {
        NewEntryPanel panel = (NewEntryPanel)this.tabs.getSelectedComponent();
        return panel.getEntry();
    }
}

