/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction.data;

import java.util.function.Consumer;
import org.apache.solr.analytics.function.reduction.data.ReductionData;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.stream.reservation.LongReservation;
import org.apache.solr.analytics.stream.reservation.ReductionDataReservation;
import org.apache.solr.analytics.value.AnalyticsValueStream;

public abstract class CountCollector
extends ReductionDataCollector<CountData> {
    public static final String name = "count";
    private final String exprStr;
    private long count;
    private long docCount;

    public CountCollector(String exprStr) {
        this.exprStr = exprStr;
    }

    public long count() {
        return this.count;
    }

    public long docCount() {
        return this.docCount;
    }

    @Override
    public CountData newData() {
        CountData data = new CountData();
        data.count = 0L;
        data.missing = 0L;
        data.docCount = 0L;
        return data;
    }

    @Override
    public void submitReservations(Consumer<ReductionDataReservation<?, ?>> consumer) {
        consumer.accept(new LongReservation(value -> ((CountData)this.ioData).count += value, () -> ((CountData)this.ioData).count));
        consumer.accept(new LongReservation(value -> ((CountData)this.ioData).docCount += value, () -> ((CountData)this.ioData).docCount));
    }

    @Override
    public void setMergedData(ReductionData data) {
        this.count = ((CountData)data).count;
        this.docCount = ((CountData)data).docCount;
    }

    @Override
    public void setData(ReductionData data) {
        this.count = ((CountData)data).count;
        this.docCount = ((CountData)data).docCount;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    public static class CountData
    extends ReductionData {
        long count;
        long missing;
        long docCount;
    }

    public static class TotalCountCollector
    extends CountCollector {
        public TotalCountCollector() {
            super(AnalyticsValueStream.createExpressionString(CountCollector.name, new AnalyticsValueStream[0]));
        }

        @Override
        protected void apply(CountData data) {
            ++data.count;
            ++data.docCount;
        }
    }

    public static class ExpressionCountCollector
    extends CountCollector {
        private final AnalyticsValueStream param;
        private long missing;
        long tempCount;
        int tempMissing;
        int tempDocCount;

        public ExpressionCountCollector(AnalyticsValueStream param) {
            super(AnalyticsValueStream.createExpressionString(CountCollector.name, param));
            this.param = param;
        }

        public long missing() {
            return this.missing;
        }

        @Override
        public void setMergedData(ReductionData data) {
            super.setMergedData(data);
            this.missing = ((CountData)data).missing;
        }

        @Override
        public void setData(ReductionData data) {
            super.setData(data);
            this.missing = ((CountData)data).missing;
        }

        @Override
        public void collect() {
            this.tempCount = 0L;
            this.param.streamObjects(obj -> ++this.tempCount);
            this.tempMissing = this.tempCount == 0L ? 1 : 0;
            this.tempDocCount = this.tempCount > 0L ? 1 : 0;
        }

        @Override
        protected void apply(CountData data) {
            data.count += this.tempCount;
            data.missing += (long)this.tempMissing;
            data.docCount += (long)this.tempDocCount;
        }

        @Override
        public void submitReservations(Consumer<ReductionDataReservation<?, ?>> consumer) {
            super.submitReservations(consumer);
            consumer.accept(new LongReservation(value -> ((CountData)this.ioData).missing += value, () -> ((CountData)this.ioData).missing));
        }
    }
}

