/*
 * Decompiled with CFR 0.152.
 */
package com.pff;

import com.pff.PSTAppointment;
import com.pff.PSTAppointmentException;
import com.pff.PSTAttachment;
import com.pff.PSTMessage;
import com.pff.PSTObject;
import com.pff.PSTTimeZone;
import java.util.Calendar;
import java.util.Date;
import java.util.SimpleTimeZone;

public class PSTAppointmentRecurrence {
    private final short RecurFrequency;
    private final short PatternType;
    private final short CalendarType;
    private final int FirstDateTime;
    private final int Period;
    private final int SlidingFlag;
    private int PatternSpecific;
    private int PatternSpecificNth;
    private final int EndType;
    private final int OccurrenceCount;
    private final int FirstDOW;
    private final int DeletedInstanceCount;
    private Calendar[] DeletedInstanceDates = null;
    private final int ModifiedInstanceCount;
    private Calendar[] ModifiedInstanceDates = null;
    private final int StartDate;
    private final int EndDate;
    private final int writerVersion2;
    private final int StartTimeOffset;
    private final int EndTimeOffset;
    private final short ExceptionCount;
    private PSTAppointmentException[] Exceptions = null;
    private PSTTimeZone RecurrenceTimeZone = null;

    public short getExceptionCount() {
        return this.ExceptionCount;
    }

    public PSTAppointmentException getException(int i) {
        if (i < 0 || i >= this.ExceptionCount) {
            return null;
        }
        return this.Exceptions[i];
    }

    public Calendar[] getDeletedInstanceDates() {
        return this.DeletedInstanceDates;
    }

    public Calendar[] getModifiedInstanceDates() {
        return this.ModifiedInstanceDates;
    }

    public short getCalendarType() {
        return this.CalendarType;
    }

    public short getPatternType() {
        return this.PatternType;
    }

    public int getPeriod() {
        return this.Period;
    }

    public int getPatternSpecific() {
        return this.PatternSpecific;
    }

    public int getFirstDOW() {
        return this.FirstDOW;
    }

    public int getPatternSpecificNth() {
        return this.PatternSpecificNth;
    }

    public int getFirstDateTime() {
        return this.FirstDateTime;
    }

    public int getEndType() {
        return this.EndType;
    }

    public int getOccurrenceCount() {
        return this.OccurrenceCount;
    }

    public int getEndDate() {
        return this.EndDate;
    }

    public int getStartTimeOffset() {
        return this.StartTimeOffset;
    }

    public PSTTimeZone getTimeZone() {
        return this.RecurrenceTimeZone;
    }

    public int getRecurFrequency() {
        return this.RecurFrequency;
    }

    public int getSlidingFlag() {
        return this.SlidingFlag;
    }

    public int getStartDate() {
        return this.StartDate;
    }

    public int getEndTimeOffset() {
        return this.EndTimeOffset;
    }

    public PSTAppointmentRecurrence(byte[] recurrencePattern, PSTAppointment appt, PSTTimeZone tz) {
        int i;
        this.RecurrenceTimeZone = tz;
        SimpleTimeZone stz = this.RecurrenceTimeZone.getSimpleTimeZone();
        this.RecurFrequency = (short)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, 4, 6);
        this.PatternType = (short)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, 6, 8);
        this.CalendarType = (short)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, 8, 10);
        this.FirstDateTime = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, 10, 14);
        this.Period = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, 14, 18);
        this.SlidingFlag = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, 18, 22);
        int offset = 22;
        if (this.PatternType != 0) {
            this.PatternSpecific = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4);
            offset += 4;
            if (this.PatternType == 3 || this.PatternType == 11) {
                this.PatternSpecificNth = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4);
                offset += 4;
            }
        }
        this.EndType = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4);
        this.OccurrenceCount = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 4, offset + 4);
        this.FirstDOW = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 4, offset + 4);
        this.DeletedInstanceCount = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 4, offset + 4);
        offset += 4;
        this.DeletedInstanceDates = new Calendar[this.DeletedInstanceCount];
        for (i = 0; i < this.DeletedInstanceCount; ++i) {
            this.DeletedInstanceDates[i] = PSTObject.apptTimeToUTC((int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4), this.RecurrenceTimeZone);
            offset += 4;
        }
        this.ModifiedInstanceCount = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4);
        offset += 4;
        this.ModifiedInstanceDates = new Calendar[this.ModifiedInstanceCount];
        for (i = 0; i < this.ModifiedInstanceCount; ++i) {
            this.ModifiedInstanceDates[i] = PSTObject.apptTimeToUTC((int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4), this.RecurrenceTimeZone);
            offset += 4;
        }
        this.StartDate = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4);
        this.EndDate = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 4, offset + 4);
        this.writerVersion2 = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 8, offset + 4);
        this.StartTimeOffset = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 4, offset + 4);
        this.EndTimeOffset = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 4, offset + 4);
        this.ExceptionCount = (short)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 4, offset + 2);
        offset += 2;
        this.Exceptions = new PSTAppointmentException[this.ExceptionCount];
        for (i = 0; i < this.ExceptionCount; ++i) {
            this.Exceptions[i] = new PSTAppointmentException(recurrencePattern, offset, this.writerVersion2, appt);
            offset += this.Exceptions[i].getLength();
        }
        if (offset + 4 <= recurrencePattern.length) {
            int ReservedBlock1Size = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4);
            offset += 4 + ReservedBlock1Size * 4;
        }
        for (i = 0; i < this.ExceptionCount; ++i) {
            this.Exceptions[i].ExtendedException(recurrencePattern, offset);
            offset += this.Exceptions[i].getExtendedLength();
        }
        PSTAttachment[] attachments = new PSTAttachment[appt.getNumberOfAttachments()];
        for (int i2 = 0; i2 < attachments.length; ++i2) {
            try {
                attachments[i2] = appt.getAttachment(i2);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                attachments[i2] = null;
            }
        }
        PSTAppointment embeddedMessage = null;
        block9: for (int i3 = 0; i3 < this.ExceptionCount; ++i3) {
            try {
                for (PSTAttachment attachment : attachments) {
                    PSTMessage message;
                    if (attachment == null || !((message = attachment.getEmbeddedPSTMessage()) instanceof PSTAppointment)) continue;
                    embeddedMessage = (PSTAppointment)message;
                    Date replaceTime = embeddedMessage.getRecurrenceBase();
                    Calendar c = Calendar.getInstance(stz);
                    c.setTime(replaceTime);
                    if (c.get(1) != this.ModifiedInstanceDates[i3].get(1) || c.get(2) != this.ModifiedInstanceDates[i3].get(2) || c.get(5) != this.ModifiedInstanceDates[i3].get(5)) continue;
                    this.Exceptions[i3].setEmbeddedMessage(embeddedMessage);
                    continue block9;
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        attachments = null;
    }
}

