/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.cloud.OverseerSolrResponseSerializer;
import org.apache.solr.cloud.OverseerTaskQueue;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkConfigManager;
import org.apache.solr.common.cloud.ZkMaintenanceUtils;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.ConfigSetParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSetsHandler
extends RequestHandlerBase
implements PermissionNameProvider {
    public static final Boolean DISABLE_CREATE_AUTH_CHECKS = Boolean.getBoolean("solr.disableConfigSetsCreateAuthChecks");
    public static final String DEFAULT_CONFIGSET_NAME = "_default";
    public static final String AUTOCREATED_CONFIGSET_SUFFIX = ".AUTOCREATED";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final CoreContainer coreContainer;
    public static long DEFAULT_ZK_TIMEOUT = 300000L;

    public ConfigSetsHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    public static String getSuffixedNameForAutoGeneratedConfigSet(String configName) {
        return configName + AUTOCREATED_CONFIGSET_SUFFIX;
    }

    public static boolean isAutoGeneratedConfigSet(String configName) {
        return configName != null && configName.endsWith(AUTOCREATED_CONFIGSET_SUFFIX);
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        ConfigSetParams.ConfigSetAction action;
        this.checkErrors();
        SolrParams params = req.getParams();
        String a = params.get("action");
        if (a != null) {
            action = ConfigSetParams.ConfigSetAction.get((String)a);
            if (action == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown action: " + a);
            }
            if (action == ConfigSetParams.ConfigSetAction.UPLOAD) {
                this.handleConfigUploadRequest(req, rsp);
                return;
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "action is a required param");
        }
        this.invokeAction(req, rsp, action);
        rsp.setHttpCaching(false);
    }

    protected void checkErrors() {
        if (this.coreContainer == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
        }
        if (!this.coreContainer.isZooKeeperAware()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Solr instance is not running in SolrCloud mode.");
        }
    }

    void invokeAction(SolrQueryRequest req, SolrQueryResponse rsp, ConfigSetParams.ConfigSetAction action) throws Exception {
        ConfigSetOperation operation = ConfigSetOperation.get(action);
        if (log.isInfoEnabled()) {
            log.info("Invoked ConfigSet Action :{} with params {} ", (Object)action.toLower(), (Object)req.getParamString());
        }
        Map<String, Object> result = operation.call(req, rsp, this);
        this.sendToZk(rsp, operation, result);
    }

    protected void sendToZk(SolrQueryResponse rsp, ConfigSetOperation operation, Map<String, Object> result) throws KeeperException, InterruptedException {
        if (result != null) {
            result.put("operation", "configsets:" + operation.action.toLower());
            ZkNodeProps props = new ZkNodeProps(result);
            this.handleResponse(operation.action.toLower(), props, rsp, DEFAULT_ZK_TIMEOUT);
        }
    }

    private void handleConfigUploadRequest(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        if (!"true".equals(System.getProperty("configset.upload.enabled", "true"))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Configset upload feature is disabled. To enable this, start Solr with '-Dconfigset.upload.enabled=true'.");
        }
        String configSetName = req.getParams().get("name");
        if (StringUtils.isBlank((CharSequence)configSetName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The configuration name should be provided in the \"name\" parameter");
        }
        SolrZkClient zkClient = this.coreContainer.getZkController().getZkClient();
        String configPathInZk = "/configs/" + configSetName;
        boolean overwritesExisting = zkClient.exists(configPathInZk, true);
        boolean requestIsTrusted = ConfigSetsHandler.isTrusted(req, this.coreContainer.getAuthenticationPlugin());
        String singleFilePath = req.getParams().get("filePath", "");
        boolean allowOverwrite = req.getParams().getBool("overwrite", false);
        boolean cleanup = req.getParams().getBool("cleanup", false);
        Iterator<ContentStream> contentStreamsIterator = req.getContentStreams().iterator();
        if (!contentStreamsIterator.hasNext()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No stream found for the config data to be uploaded");
        }
        InputStream inputStream = contentStreamsIterator.next().getStream();
        if (!singleFilePath.isEmpty()) {
            String fixedSingleFilePath = singleFilePath;
            if (fixedSingleFilePath.charAt(0) == '/') {
                fixedSingleFilePath = fixedSingleFilePath.substring(1);
            }
            if (fixedSingleFilePath.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The filePath provided for upload, '" + singleFilePath + "', is not valid.");
            }
            if (cleanup) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ConfigSet uploads do not allow cleanup=true when filePath is used.");
            }
            try {
                this.createBaseZnode(zkClient, overwritesExisting, requestIsTrusted, configPathInZk);
                String filePathInZk = configPathInZk + "/" + fixedSingleFilePath;
                zkClient.makePath(filePathInZk, IOUtils.toByteArray((InputStream)inputStream), CreateMode.PERSISTENT, null, !allowOverwrite, true);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The path " + singleFilePath + " for configSet " + configSetName + " already exists. In order to overwrite, provide overwrite=true.");
            }
            return;
        }
        if (overwritesExisting && !allowOverwrite) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The configuration " + configSetName + " already exists in zookeeper");
        }
        Set<String> filesToDelete = overwritesExisting && cleanup ? this.getAllConfigsetFiles(zkClient, configPathInZk) : Collections.emptySet();
        this.createBaseZnode(zkClient, overwritesExisting, requestIsTrusted, configPathInZk);
        ZipInputStream zis = new ZipInputStream(inputStream, StandardCharsets.UTF_8);
        ZipEntry zipEntry = null;
        while ((zipEntry = zis.getNextEntry()) != null) {
            String filePathInZk = configPathInZk + "/" + zipEntry.getName();
            if (filePathInZk.endsWith("/")) {
                filesToDelete.remove(filePathInZk.substring(0, filePathInZk.length() - 1));
            } else {
                filesToDelete.remove(filePathInZk);
            }
            if (zipEntry.isDirectory()) {
                zkClient.makePath(filePathInZk, false, true);
                continue;
            }
            this.createZkNodeIfNotExistsAndSetData(zkClient, filePathInZk, IOUtils.toByteArray((InputStream)zis));
        }
        zis.close();
        this.deleteUnusedFiles(zkClient, filesToDelete);
        if (cleanup && requestIsTrusted && overwritesExisting && !ConfigSetsHandler.isCurrentlyTrusted(zkClient, configPathInZk)) {
            byte[] baseZnodeData = "{\"trusted\": true}".getBytes(StandardCharsets.UTF_8);
            zkClient.setData(configPathInZk, baseZnodeData, true);
        }
    }

    private void createBaseZnode(SolrZkClient zkClient, boolean overwritesExisting, boolean requestIsTrusted, String configPathInZk) throws KeeperException, InterruptedException {
        byte[] baseZnodeData = ("{\"trusted\": " + Boolean.toString(requestIsTrusted) + "}").getBytes(StandardCharsets.UTF_8);
        if (overwritesExisting) {
            if (!requestIsTrusted) {
                this.ensureOverwritingUntrustedConfigSet(zkClient, configPathInZk);
            }
        } else {
            zkClient.makePath(configPathInZk, baseZnodeData, true);
        }
    }

    private void deleteUnusedFiles(SolrZkClient zkClient, Set<String> filesToDelete) throws InterruptedException, KeeperException {
        if (!filesToDelete.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info("Cleaning up {} unused files", (Object)filesToDelete.size());
            }
            if (log.isDebugEnabled()) {
                log.debug("Cleaning up unused files: {}", filesToDelete);
            }
            for (String f : filesToDelete) {
                try {
                    zkClient.delete(f, -1, true);
                }
                catch (KeeperException.NoNodeException noNodeException) {}
            }
        }
    }

    private Set<String> getAllConfigsetFiles(SolrZkClient zkClient, String configPathInZk) throws KeeperException, InterruptedException {
        HashSet<String> files = new HashSet<String>();
        if (!configPathInZk.startsWith("/configs/")) {
            throw new IllegalArgumentException("\"" + configPathInZk + "\" not recognized as a configset path");
        }
        ZkMaintenanceUtils.traverseZkTree((SolrZkClient)zkClient, (String)configPathInZk, (ZkMaintenanceUtils.VISIT_ORDER)ZkMaintenanceUtils.VISIT_ORDER.VISIT_POST, files::add);
        files.remove(configPathInZk);
        return files;
    }

    private void ensureOverwritingUntrustedConfigSet(SolrZkClient zkClient, String configSetZkPath) {
        boolean isCurrentlyTrusted = ConfigSetsHandler.isCurrentlyTrusted(zkClient, configSetZkPath);
        if (isCurrentlyTrusted) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Trying to make an unstrusted ConfigSet update on a trusted configSet");
        }
    }

    private static boolean isCurrentlyTrusted(SolrZkClient zkClient, String configSetZkPath) {
        byte[] configSetNodeContent;
        try {
            configSetNodeContent = zkClient.getData(configSetZkPath, null, null, true);
            if (configSetNodeContent == null || configSetNodeContent.length == 0) {
                return true;
            }
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception while fetching current configSet at " + configSetZkPath, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted while fetching current configSet at " + configSetZkPath, (Throwable)e);
        }
        Map contentMap = (Map)Utils.fromJSON((byte[])configSetNodeContent);
        return contentMap.getOrDefault("trusted", true);
    }

    static boolean isTrusted(SolrQueryRequest req, AuthenticationPlugin authPlugin) {
        if (authPlugin != null && req.getUserPrincipal() != null) {
            log.debug("Trusted configset request");
            return true;
        }
        log.debug("Untrusted configset request");
        return false;
    }

    private void createZkNodeIfNotExistsAndSetData(SolrZkClient zkClient, String filePathInZk, byte[] data) throws Exception {
        if (!zkClient.exists(filePathInZk, true).booleanValue()) {
            zkClient.create(filePathInZk, data, CreateMode.PERSISTENT, true);
        } else {
            zkClient.setData(filePathInZk, data, true);
        }
    }

    private void handleResponse(String operation, ZkNodeProps m, SolrQueryResponse rsp, long timeout) throws KeeperException, InterruptedException {
        long time = System.nanoTime();
        OverseerTaskQueue.QueueEvent event = this.coreContainer.getZkController().getOverseerConfigSetQueue().offer(Utils.toJSON((Object)m), timeout);
        if (event.getBytes() != null) {
            OverseerSolrResponse response = OverseerSolrResponseSerializer.deserialize(event.getBytes());
            rsp.getValues().addAll(response.getResponse());
            SimpleOrderedMap exp = (SimpleOrderedMap)response.getResponse().get("exception");
            if (exp != null) {
                Integer code = (Integer)exp.get("rspCode");
                rsp.setException((Exception)((Object)new SolrException(code != null && code != -1 ? SolrException.ErrorCode.getErrorCode((int)code) : SolrException.ErrorCode.SERVER_ERROR, (String)exp.get("msg"))));
            }
        } else {
            if (System.nanoTime() - time >= TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the configset time out:" + timeout / 1000L + "s");
            }
            if (event.getWatchedEvent() != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the configset error [Watcher fired on path: " + event.getWatchedEvent().getPath() + " state: " + event.getWatchedEvent().getState() + " type " + event.getWatchedEvent().getType() + "]");
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the configset unknown case");
        }
    }

    private static Map<String, Object> copyPropertiesWithPrefix(SolrParams params, Map<String, Object> props, String prefix) {
        Iterator iter = params.getParameterNamesIterator();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            if (!param.startsWith(prefix)) continue;
            props.put(param, params.get(param));
        }
        props.put("immutable", "false");
        return props;
    }

    @Override
    public String getDescription() {
        return "Manage SolrCloud ConfigSets";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext ctx) {
        String a = ctx.getParams().get("action");
        if (a != null) {
            ConfigSetParams.ConfigSetAction action = ConfigSetParams.ConfigSetAction.get((String)a);
            if (action == ConfigSetParams.ConfigSetAction.CREATE || action == ConfigSetParams.ConfigSetAction.DELETE || action == ConfigSetParams.ConfigSetAction.UPLOAD) {
                return PermissionNameProvider.Name.CONFIG_EDIT_PERM;
            }
            if (action == ConfigSetParams.ConfigSetAction.LIST) {
                return PermissionNameProvider.Name.CONFIG_READ_PERM;
            }
        }
        return null;
    }

    public static enum ConfigSetOperation {
        CREATE_OP(ConfigSetParams.ConfigSetAction.CREATE){

            @Override
            public Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, ConfigSetsHandler h) throws Exception {
                String baseConfigSetName = req.getParams().get("baseConfigSet", ConfigSetsHandler.DEFAULT_CONFIGSET_NAME);
                String newConfigSetName = req.getParams().get("name");
                if (newConfigSetName == null || newConfigSetName.length() == 0) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ConfigSet name not specified");
                }
                ZkConfigManager zkConfigManager = new ZkConfigManager(h.coreContainer.getZkController().getZkStateReader().getZkClient());
                if (zkConfigManager.configExists(newConfigSetName).booleanValue()) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ConfigSet already exists: " + newConfigSetName);
                }
                if (!zkConfigManager.configExists(baseConfigSetName).booleanValue()) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Base ConfigSet does not exist: " + baseConfigSetName);
                }
                Map<String, Object> props = CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "name");
                props.put("baseConfigSet", baseConfigSetName);
                if (!DISABLE_CREATE_AUTH_CHECKS.booleanValue() && !ConfigSetsHandler.isTrusted(req, h.coreContainer.getAuthenticationPlugin()) && ConfigSetsHandler.isCurrentlyTrusted(h.coreContainer.getZkController().getZkClient(), "/configs/" + baseConfigSetName)) {
                    throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, "Can't create a configset with an unauthenticated request from a trusted baseConfigSet");
                }
                return ConfigSetsHandler.copyPropertiesWithPrefix(req.getParams(), props, "configSetProp.");
            }
        }
        ,
        DELETE_OP(ConfigSetParams.ConfigSetAction.DELETE){

            @Override
            public Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, ConfigSetsHandler h) throws Exception {
                return CollectionsHandler.copy((SolrParams)req.getParams().required(), null, "name");
            }
        }
        ,
        LIST_OP(ConfigSetParams.ConfigSetAction.LIST){

            @Override
            public Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, ConfigSetsHandler h) throws Exception {
                NamedList results = new NamedList();
                SolrZkClient zk = h.coreContainer.getZkController().getZkStateReader().getZkClient();
                ZkConfigManager zkConfigManager = new ZkConfigManager(zk);
                List configSetsList = zkConfigManager.listConfigs();
                results.add("configSets", (Object)configSetsList);
                OverseerSolrResponse response = new OverseerSolrResponse(results);
                rsp.getValues().addAll(response.getResponse());
                return null;
            }
        };

        ConfigSetParams.ConfigSetAction action;

        private ConfigSetOperation(ConfigSetParams.ConfigSetAction action) {
            this.action = action;
        }

        public abstract Map<String, Object> call(SolrQueryRequest var1, SolrQueryResponse var2, ConfigSetsHandler var3) throws Exception;

        public static ConfigSetOperation get(ConfigSetParams.ConfigSetAction action) {
            for (ConfigSetOperation op : ConfigSetOperation.values()) {
                if (op.action != action) continue;
                return op;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No such action" + action);
        }
    }
}

