/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.SortedSetFieldSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.QueryBuilder;
import org.apache.solr.common.SolrException;
import org.apache.solr.parser.SolrQueryParserBase;
import org.apache.solr.query.SolrRangeQuery;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.uninverting.UninvertingReader;

public class TextField
extends FieldType {
    protected boolean autoGeneratePhraseQueries;
    protected boolean enableGraphQueries;
    protected SolrQueryParserBase.SynonymQueryStyle synonymQueryStyle;
    protected Analyzer multiTermAnalyzer = null;
    private boolean isExplicitMultiTermAnalyzer = false;

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        this.properties |= 2;
        if (schema.getVersion() > 1.1f && 0 == (this.trueProperties & 0x20)) {
            this.properties &= 0xFFFFFFDF;
        }
        this.autoGeneratePhraseQueries = !(schema.getVersion() > 1.3f);
        String autoGeneratePhraseQueriesStr = args.remove("autoGeneratePhraseQueries");
        if (autoGeneratePhraseQueriesStr != null) {
            this.autoGeneratePhraseQueries = Boolean.parseBoolean(autoGeneratePhraseQueriesStr);
        }
        this.synonymQueryStyle = SolrQueryParserBase.SynonymQueryStyle.AS_SAME_TERM;
        String synonymQueryStyle = args.remove("synonymQueryStyle");
        if (synonymQueryStyle != null) {
            this.synonymQueryStyle = SolrQueryParserBase.SynonymQueryStyle.valueOf(synonymQueryStyle.toUpperCase(Locale.ROOT));
        }
        this.enableGraphQueries = true;
        String enableGraphQueriesStr = args.remove("enableGraphQueries");
        if (enableGraphQueriesStr != null) {
            this.enableGraphQueries = Boolean.parseBoolean(enableGraphQueriesStr);
        }
        super.init(schema, args);
    }

    public Analyzer getMultiTermAnalyzer() {
        return this.multiTermAnalyzer;
    }

    public void setMultiTermAnalyzer(Analyzer analyzer) {
        this.multiTermAnalyzer = analyzer;
    }

    public boolean getAutoGeneratePhraseQueries() {
        return this.autoGeneratePhraseQueries;
    }

    public boolean getEnableGraphQueries() {
        return this.enableGraphQueries;
    }

    public SolrQueryParserBase.SynonymQueryStyle getSynonymQueryStyle() {
        return this.synonymQueryStyle;
    }

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        return TextField.getSortedSetSortField(field, SortedSetSelector.Type.MIN, reverse, SortField.STRING_FIRST, SortField.STRING_LAST);
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        return new SortedSetFieldSource(field.getName());
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        return UninvertingReader.Type.SORTED_SET_BINARY;
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeStr(name, this.toExternal(f), true);
    }

    @Override
    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        return TextField.parseFieldQuery(parser, this.getQueryAnalyzer(), field.getName(), externalVal);
    }

    @Override
    public Object toObject(SchemaField sf, BytesRef term) {
        return term.utf8ToString();
    }

    @Override
    protected boolean supportsAnalyzers() {
        return true;
    }

    @Override
    protected Query getSpecializedRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        Analyzer multiAnalyzer = this.getMultiTermAnalyzer();
        BytesRef lower = TextField.analyzeMultiTerm(field.getName(), part1, multiAnalyzer);
        BytesRef upper = TextField.analyzeMultiTerm(field.getName(), part2, multiAnalyzer);
        return new SolrRangeQuery(field.getName(), lower, upper, minInclusive, maxInclusive);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BytesRef analyzeMultiTerm(String field, String part, Analyzer analyzerIn) {
        if (part == null) return null;
        if (analyzerIn == null) {
            return null;
        }
        try (TokenStream source = analyzerIn.tokenStream(field, part);){
            source.reset();
            TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)source.getAttribute(TermToBytesRefAttribute.class);
            if (!source.incrementToken()) {
                BytesRef bytesRef2 = null;
                return bytesRef2;
            }
            BytesRef bytes = BytesRef.deepCopyOf((BytesRef)termAtt.getBytesRef());
            if (source.incrementToken()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "analyzer returned too many terms for multiTerm term: " + part);
            }
            source.end();
            BytesRef bytesRef = bytes;
            return bytesRef;
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "error analyzing range part: " + part, (Throwable)e);
        }
    }

    static Query parseFieldQuery(QParser parser, Analyzer analyzer, String field, String queryText) {
        return new QueryBuilder(analyzer).createPhraseQuery(field, queryText);
    }

    public void setIsExplicitMultiTermAnalyzer(boolean isExplicitMultiTermAnalyzer) {
        this.isExplicitMultiTermAnalyzer = isExplicitMultiTermAnalyzer;
    }

    public boolean isExplicitMultiTermAnalyzer() {
        return this.isExplicitMultiTermAnalyzer;
    }

    @Override
    public Object marshalSortValue(Object value) {
        return TextField.marshalStringSortValue(value);
    }

    @Override
    public Object unmarshalSortValue(Object value) {
        return TextField.unmarshalStringSortValue(value);
    }

    @Override
    public boolean isUtf8Field() {
        return true;
    }
}

