crystal_doc_search_index_callback({"repository_name":"Crystal","body":"# Crystal\n\n[![Linux CI](https://github.com/crystal-lang/crystal/workflows/Linux%20CI/badge.svg)](https://github.com/crystal-lang/crystal/actions?query=workflow%3A%22Linux+CI%22+event%3Apush+branch%3Amaster)\n[![macOS CI](https://github.com/crystal-lang/crystal/workflows/macOS%20CI/badge.svg)](https://github.com/crystal-lang/crystal/actions?query=workflow%3A%22macOS+CI%22+event%3Apush+branch%3Amaster)\n[![AArch64 CI](https://github.com/crystal-lang/crystal/workflows/AArch64%20CI/badge.svg)](https://github.com/crystal-lang/crystal/actions?query=workflow%3A%22AArch64+CI%22+event%3Apush+branch%3Amaster)\n[![Windows CI](https://github.com/crystal-lang/crystal/workflows/Windows%20CI/badge.svg)](https://github.com/crystal-lang/crystal/actions?query=workflow%3A%22Windows+CI%22+event%3Apush+branch%3Amaster)\n[![CircleCI Build Status](https://circleci.com/gh/crystal-lang/crystal/tree/master.svg?style=shield)](https://circleci.com/gh/crystal-lang/crystal)\n[![Join the chat at https://gitter.im/crystal-lang/crystal](https://badges.gitter.im/crystal-lang/crystal.svg)](https://gitter.im/crystal-lang/crystal)\n[![Code Triagers Badge](https://www.codetriage.com/crystal-lang/crystal/badges/users.svg)](https://www.codetriage.com/crystal-lang/crystal)\n\n---\n\n[![born-and-raised](https://cloud.githubusercontent.com/assets/209371/13291809/022e2360-daf8-11e5-8be7-d02c1c8b38fb.png)](https://manas.tech/)\n\nCrystal is a programming language with the following goals:\n\n* Have a syntax similar to Ruby (but compatibility with it is not a goal)\n* Statically type-checked but without having to specify the type of variables or method arguments.\n* Be able to call C code by writing bindings to it in Crystal.\n* Have compile-time evaluation and generation of code, to avoid boilerplate code.\n* Compile to efficient native code.\n\nWhy?\n----\n\nWe love Ruby's efficiency for writing code.\n\nWe love C's efficiency for running code.\n\nWe want the best of both worlds.\n\nWe want the compiler to understand what we mean without having to specify types everywhere.\n\nWe want full OOP.\n\nOh, and we don't want to write C code to make the code run faster.\n\nProject Status\n--------------\n\nCrystal is still under heavy development. There can be breaking changes but we're trying to keep them as minimum as possible.\n\nThe development is possible thanks to the community's effort and the continued support of [84codes](https://www.84codes.com/), [Nikola Motor Company](https://nikolamotor.com/) and every other [sponsor](https://crystal-lang.org/sponsors).\n\nInstalling\n----------\n\n[Follow these instructions](https://crystal-lang.org/install)\n\nTry it online\n-------------\n\n[play.crystal-lang.org](https://play.crystal-lang.org/)\n\nDocumentation\n-------------\n\n* [Language Reference](http://crystal-lang.org/reference)\n* [Standard library API](https://crystal-lang.org/api)\n* [Roadmap](https://github.com/crystal-lang/crystal/wiki/Roadmap)\n\nCommunity\n---------\n\nQuestions or suggestions? Ask on the [Crystal Forum](https://forum.crystal-lang.org), on our [Gitter channel](https://gitter.im/crystal-lang/crystal) or IRC channel [#crystal-lang](http://webchat.freenode.net/?channels=#crystal-lang) at chat.freenode.net, or on Stack Overflow under the [crystal-lang](http://stackoverflow.com/questions/tagged/crystal-lang) tag. There is also an archived [Google Group](https://groups.google.com/forum/?fromgroups#!forum/crystal-lang).\n\nContributing\n------------\n\nThe Crystal repository is hosted at [crystal-lang/crystal](https://github.com/crystal-lang/crystal) on GitHub.\n\nRead the general [Contributing guide](https://github.com/crystal-lang/crystal/blob/master/CONTRIBUTING.md), and then:\n\n1. Fork it (<https://github.com/crystal-lang/crystal/fork>)\n2. Create your feature branch (`git checkout -b my-new-feature`)\n3. Commit your changes (`git commit -am 'Add some feature'`)\n4. Push to the branch (`git push origin my-new-feature`)\n5. Create a new Pull Request\n","program":{"html_id":"Crystal/toplevel","path":"toplevel.html","kind":"module","full_name":"Top Level Namespace","name":"Top Level Namespace","abstract":false,"superclass":null,"ancestors":[{"html_id":"Crystal/Spec/Methods","kind":"module","full_name":"Spec::Methods","name":"Methods"},{"html_id":"Crystal/Spec/Expectations","kind":"module","full_name":"Spec::Expectations","name":"Expectations"}],"locations":[],"repository_name":"Crystal","program":true,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[{"id":"ARGF","name":"ARGF","value":"IO::ARGF.new(ARGV, STDIN)","doc":"An `IO` for reading files from `ARGV`.\n\nUsage example:\n\n`program.cr`:\n```\nputs ARGF.gets_to_end\n```\n\nA file to read from: (`file`)\n```text\n123\n```\n\n```text\n$ crystal build program.cr\n$ ./program file\n123\n$ ./program file file\n123123\n$ # If ARGV is empty, ARGF reads from STDIN instead:\n$ echo \"hello\" | ./program\nhello\n$ ./program unknown\nUnhandled exception: Error opening file with mode 'r': 'unknown': No such file or directory (File::NotFoundError)\n...\n```\n\nAfter a file from `ARGV` has been read, it's removed from `ARGV`.\n\nYou can manipulate `ARGV` yourself to control what `ARGF` operates on.\nIf you remove a file from `ARGV`, it is ignored by `ARGF`; if you add files to `ARGV`, `ARGF` will read from it.\n\n```\nARGV.replace [\"file1\"]\nARGF.gets_to_end # => Content of file1\nARGV             # => []\nARGV << \"file2\"\nARGF.gets_to_end # => Content of file2\n```","summary":"<p>An <code><a href=\"IO.html\">IO</a></code> for reading files from <code><a href=\"toplevel.html#ARGV\">ARGV</a></code>.</p>"},{"id":"ARGV","name":"ARGV","value":"Array.new(ARGC_UNSAFE - 1) do |i|\n  String.new(ARGV_UNSAFE[1 + i])\nend","doc":"An array of arguments passed to the program.","summary":"<p>An array of arguments passed to the program.</p>"},{"id":"PROGRAM_NAME","name":"PROGRAM_NAME","value":"String.new(ARGV_UNSAFE.value)","doc":"The name, the program was called with.","summary":"<p>The name, the program was called with.</p>"},{"id":"STDERR","name":"STDERR","value":"IO::FileDescriptor.from_stdio(2)","doc":"The standard error file descriptor.\n\nTypically used to output error messages and diagnostics.\n\nAt the start of the program STDERR is configured like this:\n- if it's a TTY device (like the console) then `sync` is `true`,\n  meaning that output will be outputted as soon as it is written\n  to STDERR. This is so users can see real time output data.\n- if it's not a TTY device (like a file, or because the output\n  was piped to a file) then `sync` is `false` but `flush_on_newline`\n  is `true`. This is so that if you pipe the output to a file, and,\n  for example, you `tail -f`, you can see data on a line-per-line basis.\n  This is convenient but slower than with `flush_on_newline` set to `false`.\n  If you need a bit more performance and you don't care about near real-time\n  output you can do `STDERR.flush_on_newline = false`.","summary":"<p>The standard error file descriptor.</p>"},{"id":"STDIN","name":"STDIN","value":"IO::FileDescriptor.from_stdio(0)","doc":"The standard input file descriptor. Contains data piped to the program.","summary":"<p>The standard input file descriptor.</p>"},{"id":"STDOUT","name":"STDOUT","value":"IO::FileDescriptor.from_stdio(1)","doc":"The standard output file descriptor.\n\nTypically used to output data and information.\n\nAt the start of the program STDOUT is configured like this:\n- if it's a TTY device (like the console) then `sync` is `true`,\n  meaning that output will be outputted as soon as it is written\n  to STDOUT. This is so users can see real time output data.\n- if it's not a TTY device (like a file, or because the output\n  was piped to a file) then `sync` is `false` but `flush_on_newline`\n  is `true`. This is so that if you pipe the output to a file, and,\n  for example, you `tail -f`, you can see data on a line-per-line basis.\n  This is convenient but slower than with `flush_on_newline` set to `false`.\n  If you need a bit more performance and you don't care about near real-time\n  output you can do `STDOUT.flush_on_newline = false`.","summary":"<p>The standard output file descriptor.</p>"}],"included_modules":[{"html_id":"Crystal/Spec/Expectations","kind":"module","full_name":"Spec::Expectations","name":"Expectations"},{"html_id":"Crystal/Spec/Methods","kind":"module","full_name":"Spec::Methods","name":"Methods"}],"extended_modules":[{"html_id":"Crystal/Spec/Expectations","kind":"module","full_name":"Spec::Expectations","name":"Expectations"},{"html_id":"Crystal/Spec/Methods","kind":"module","full_name":"Spec::Methods","name":"Methods"}],"subclasses":[],"including_types":[],"namespace":null,"doc":null,"summary":null,"class_methods":[{"id":"`(command):String-class-method","html_id":"`(command):String-class-method","name":"`","doc":"Returns the standard output of executing *command* in a subshell.\nStandard input, and error are inherited.\nThe special `$?` variable is set to a `Process::Status` associated with this execution.\n\nExample:\n\n```\n`echo hi` # => \"hi\\n\"\n```","summary":"<p>Returns the standard output of executing <em>command</em> in a subshell.</p>","abstract":false,"args":[{"name":"command","doc":null,"default_value":"","external_name":"command","restriction":""}],"args_string":"(command) : String","args_html":"(command) : <a href=\"String.html\">String</a>","location":{"filename":"src/process.cr","line_number":446,"url":null},"def":{"name":"`","args":[{"name":"command","doc":null,"default_value":"","external_name":"command","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"process = Process.new(command, shell: true, input: Process::Redirect::Inherit, output: Process::Redirect::Pipe, error: Process::Redirect::Inherit)\noutput = process.output.gets_to_end\nstatus = process.wait\n$? = status\noutput\n"}},{"id":"abort(message=nil,status=1):NoReturn-class-method","html_id":"abort(message=nil,status=1):NoReturn-class-method","name":"abort","doc":"Terminates execution immediately, printing *message* to `STDERR` and\nthen calling `exit(status)`.","summary":"<p>Terminates execution immediately, printing <em>message</em> to <code><a href=\"toplevel.html#STDERR\">STDERR</a></code> and then calling <code><a href=\"toplevel.html#exit(status=0):NoReturn-class-method\">exit(status)</a></code>.</p>","abstract":false,"args":[{"name":"message","doc":null,"default_value":"nil","external_name":"message","restriction":""},{"name":"status","doc":null,"default_value":"1","external_name":"status","restriction":""}],"args_string":"(message = <span class=\"n\">nil</span>, status = <span class=\"n\">1</span>) : NoReturn","args_html":"(message = <span class=\"n\">nil</span>, status = <span class=\"n\">1</span>) : NoReturn","location":{"filename":"src/kernel.cr","line_number":502,"url":null},"def":{"name":"abort","args":[{"name":"message","doc":null,"default_value":"nil","external_name":"message","restriction":""},{"name":"status","doc":null,"default_value":"1","external_name":"status","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NoReturn","visibility":"Public","body":"if message\n  Crystal.ignore_stdio_errors do\n    STDERR.puts(message)\n  end\nend\nexit(status)\n"}},{"id":"at_exit(&handler:Int32,Exception?->):Nil-class-method","html_id":"at_exit(&handler:Int32,Exception?->):Nil-class-method","name":"at_exit","doc":"Registers the given `Proc` for execution when the program exits.\nIf multiple handlers are registered, they are executed in reverse order of registration.\n\n```\ndef do_at_exit(str1)\n  at_exit { print str1 }\nend\n\nat_exit { puts \"cruel world\" }\ndo_at_exit(\"goodbye \")\nexit\n```\n\nProduces:\n\n```text\ngoodbye cruel world\n```\n\nThe exit status code that will be returned by this program is passed to\nthe block as its first argument. In case of any unhandled exception, it is\npassed as the second argument to the block, if the program terminates\nnormally or `exit(status)` is called explicitly, then the second argument\nwill be `nil`.\n\nNOTE: If `at_exit` is called inside an `at_exit` handler, it will be called\nright after the current `at_exit` handler ends, and then other handlers\nwill be invoked.","summary":"<p>Registers the given <code><a href=\"Proc.html\">Proc</a></code> for execution when the program exits.</p>","abstract":false,"args":[],"args_string":"(&handler : Int32, Exception? -> ) : Nil","args_html":"(&handler : <a href=\"Int32.html\">Int32</a>, <a href=\"Exception.html\">Exception</a>? -> ) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/kernel.cr","line_number":485,"url":null},"def":{"name":"at_exit","args":[],"double_splat":null,"splat_index":null,"yields":2,"block_arg":{"name":"handler","doc":null,"default_value":"","external_name":"handler","restriction":"(Int32, Exception | ::Nil -> )"},"return_type":"Nil","visibility":"Public","body":"Crystal::AtExitHandlers.add(handler)"}},{"id":"caller:Array(String)-class-method","html_id":"caller:Array(String)-class-method","name":"caller","doc":"Returns the current execution stack as an array containing strings\nusually in the form file:line:column or file:line:column in 'method'.","summary":"<p>Returns the current execution stack as an array containing strings usually in the form file:line:column or file:line:column in 'method'.</p>","abstract":false,"args":[],"args_string":" : Array(String)","args_html":" : <a href=\"Array.html\">Array</a>(<a href=\"String.html\">String</a>)","location":{"filename":"src/exception/call_stack.cr","line_number":16,"url":null},"def":{"name":"caller","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Array(String)","visibility":"Public","body":"Exception::CallStack.new.printable_backtrace"}},{"id":"exit(status=0):NoReturn-class-method","html_id":"exit(status=0):NoReturn-class-method","name":"exit","doc":"Terminates execution immediately, returning the given status code\nto the invoking environment.\n\nRegistered `at_exit` procs are executed.","summary":"<p>Terminates execution immediately, returning the given status code to the invoking environment.</p>","abstract":false,"args":[{"name":"status","doc":null,"default_value":"0","external_name":"status","restriction":""}],"args_string":"(status = <span class=\"n\">0</span>) : NoReturn","args_html":"(status = <span class=\"n\">0</span>) : NoReturn","location":{"filename":"src/kernel.cr","line_number":493,"url":null},"def":{"name":"exit","args":[{"name":"status","doc":null,"default_value":"0","external_name":"status","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NoReturn","visibility":"Public","body":"status = Crystal::AtExitHandlers.run(status)\nCrystal.ignore_stdio_errors do\n  STDOUT.flush\nend\nCrystal.ignore_stdio_errors do\n  STDERR.flush\nend\nProcess.exit(status)\n"}},{"id":"gets(*args,**options)-class-method","html_id":"gets(*args,**options)-class-method","name":"gets","doc":"Reads a line from `STDIN`.\n\nSee also: `IO#gets`.","summary":"<p>Reads a line from <code><a href=\"toplevel.html#STDIN\">STDIN</a></code>.</p>","abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/kernel.cr","line_number":110,"url":null},"def":{"name":"gets","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"STDIN.gets(*args, **options)"}},{"id":"instance_sizeof(type:Class):Int32-class-method","html_id":"instance_sizeof(type:Class):Int32-class-method","name":"instance_sizeof","doc":"Returns the instance size of the given class as number of bytes.\n\n*type* must be a constant or `typeof()` expression. It cannot be evaluated at runtime.\n\n```\ninstance_sizeof(String)    # => 16\ninstance_sizeof(Exception) # => 48\n```\n\nSee `sizeof` for determining the size of value types.\nNOTE: This is a pseudo-method provided directly by the Crystal compiler.\nIt cannot be redefined nor overridden.","summary":"<p>Returns the instance size of the given class as number of bytes.</p>","abstract":false,"args":[{"name":"type","doc":null,"default_value":"","external_name":"type","restriction":"Class"}],"args_string":"(type : Class) : Int32","args_html":"(type : <a href=\"Class.html\">Class</a>) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/docs_pseudo_methods.cr","line_number":61,"url":null},"def":{"name":"__crystal_pseudo_instance_sizeof","args":[{"name":"type","doc":null,"default_value":"","external_name":"type","restriction":"Class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":""}},{"id":"loop(&)-class-method","html_id":"loop(&)-class-method","name":"loop","doc":"Repeatedly executes the block.\n\n```\nloop do\n  line = gets\n  break unless line\n  # ...\nend\n```","summary":"<p>Repeatedly executes the block.</p>","abstract":false,"args":[],"args_string":"(&)","args_html":"(&)","location":{"filename":"src/kernel.cr","line_number":101,"url":null},"def":{"name":"loop","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"","visibility":"Public","body":"while true\n  yield\nend"}},{"id":"main(argc:Int32,argv:Pointer(Pointer(UInt8)))-class-method","html_id":"main(argc:Int32,argv:Pointer(Pointer(UInt8)))-class-method","name":"main","doc":"Main function that acts as C's main function.\nInvokes `Crystal.main`.\n\nCan be redefined. See `Crystal.main` for examples.","summary":"<p>Main function that acts as C's main function.</p>","abstract":false,"args":[{"name":"argc","doc":null,"default_value":"","external_name":"argc","restriction":""},{"name":"argv","doc":null,"default_value":"","external_name":"argv","restriction":""}],"args_string":"(argc : Int32, argv : Pointer(Pointer(UInt8)))","args_html":"(argc : <a href=\"Int32.html\">Int32</a>, argv : <a href=\"Pointer.html\">Pointer</a>(<a href=\"Pointer.html\">Pointer</a>(<a href=\"UInt8.html\">UInt8</a>)))","location":{"filename":"src/crystal/main.cr","line_number":118,"url":null},"def":{"name":"main","args":[{"name":"argc","doc":null,"default_value":"","external_name":"argc","restriction":""},{"name":"argv","doc":null,"default_value":"","external_name":"argv","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Crystal.main(argc, argv)"}},{"id":"offsetof(type:Class,offset):Int32-class-method","html_id":"offsetof(type:Class,offset):Int32-class-method","name":"offsetof","doc":"Returns the byte offset of an instance variable in a struct or class type.\n\n*type* must be a constant or `typeof()` expression. It cannot be evaluated at runtime.\n*offset*  must be the name of an instance variable of *type*, prefixed by `@`,\nor the index of an element in a Tuple, starting from 0, if *type* is a `Tuple`.\n```\noffsetof(String, @bytesize)       # => 4\noffsetof(Exception, @message)     # => 8\noffsetof(Time, @location)         # => 16\noffsetof({Int32, Int8, Int32}, 0) # => 0\noffsetof({Int32, Int8, Int32}, 1) # => 4\noffsetof({Int32, Int8, Int32}, 2) # => 8\n```\nNOTE: This is a pseudo-method provided directly by the Crystal compiler.\nIt cannot be redefined nor overridden.","summary":"<p>Returns the byte offset of an instance variable in a struct or class type.</p>","abstract":false,"args":[{"name":"type","doc":null,"default_value":"","external_name":"type","restriction":"Class"},{"name":"offset","doc":null,"default_value":"","external_name":"offset","restriction":""}],"args_string":"(type : Class, offset) : Int32","args_html":"(type : <a href=\"Class.html\">Class</a>, offset) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/docs_pseudo_methods.cr","line_number":91,"url":null},"def":{"name":"__crystal_pseudo_offsetof","args":[{"name":"type","doc":null,"default_value":"","external_name":"type","restriction":"Class"},{"name":"offset","doc":null,"default_value":"","external_name":"offset","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":""}},{"id":"p(object)-class-method","html_id":"p(object)-class-method","name":"p","doc":"Inspects *object* to `STDOUT` followed\nby a newline. Returns *object*.\n\nSee also: `Object#inspect(io)`.","summary":"<p>Inspects <em>object</em> to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code> followed by a newline.</p>","abstract":false,"args":[{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":""}],"args_string":"(object)","args_html":"(object)","location":{"filename":"src/kernel.cr","line_number":395,"url":null},"def":{"name":"p","args":[{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"object.inspect(STDOUT)\nputs\nobject\n"}},{"id":"p(*objects)-class-method","html_id":"p(*objects)-class-method","name":"p","doc":"Inspects each object in *objects* to `STDOUT`, followed\nby a newline. Returns *objects*.\n\nSee also: `Object#inspect(io)`.","summary":"<p>Inspects each object in <em>objects</em> to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code>, followed by a newline.</p>","abstract":false,"args":[{"name":"objects","doc":null,"default_value":"","external_name":"objects","restriction":""}],"args_string":"(*objects)","args_html":"(*objects)","location":{"filename":"src/kernel.cr","line_number":405,"url":null},"def":{"name":"p","args":[{"name":"objects","doc":null,"default_value":"","external_name":"objects","restriction":""}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"objects.each do |obj|\n  p(obj)\nend\nobjects\n"}},{"id":"p(**objects)-class-method","html_id":"p(**objects)-class-method","name":"p","doc":"Inspects *objects* to `STDOUT`, followed\nby a newline. Returns *objects*.\n\n```\np foo: 23, bar: 42 # => {foo: 23, bar: 42}\n```\n\nSee `Object#inspect(io)`","summary":"<p>Inspects <em>objects</em> to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code>, followed by a newline.</p>","abstract":false,"args":[],"args_string":"(**objects)","args_html":"(**objects)","location":{"filename":"src/kernel.cr","line_number":420,"url":null},"def":{"name":"p","args":[],"double_splat":{"name":"objects","doc":null,"default_value":"","external_name":"objects","restriction":""},"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if objects.empty?\nelse\n  p(objects)\nend"}},{"id":"pointerof(variable:T):Pointer(T)forallT-class-method","html_id":"pointerof(variable:T):Pointer(T)forallT-class-method","name":"pointerof","doc":"Returns a `Pointer` to the contents of a variable.\n\n*variable* must be a variable (local, instance, class or library).\n\n```\na = 1\nptr = pointerof(a)\nptr.value = 2\n\na # => 2\n```\nNOTE: This is a pseudo-method provided directly by the Crystal compiler.\nIt cannot be redefined nor overridden.","summary":"<p>Returns a <code><a href=\"Pointer.html\">Pointer</a></code> to the contents of a variable.</p>","abstract":false,"args":[{"name":"variable","doc":null,"default_value":"","external_name":"variable","restriction":"T"}],"args_string":"(variable : T) : Pointer(T) forall T","args_html":"(variable : T) : <a href=\"Pointer.html\">Pointer</a>(T) forall T","location":{"filename":"src/docs_pseudo_methods.cr","line_number":75,"url":null},"def":{"name":"__crystal_pseudo_pointerof","args":[{"name":"variable","doc":null,"default_value":"","external_name":"variable","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Pointer(T)","visibility":"Public","body":""}},{"id":"pp(object)-class-method","html_id":"pp(object)-class-method","name":"pp","doc":"Pretty prints *object* to `STDOUT` followed\nby a newline. Returns *object*.\n\nSee also: `Object#pretty_print(pp)`.","summary":"<p>Pretty prints <em>object</em> to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code> followed by a newline.</p>","abstract":false,"args":[{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":""}],"args_string":"(object)","args_html":"(object)","location":{"filename":"src/kernel.cr","line_number":428,"url":null},"def":{"name":"pp","args":[{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"PrettyPrint.format(object, STDOUT, 79)\nputs\nobject\n"}},{"id":"pp(**objects)-class-method","html_id":"pp(**objects)-class-method","name":"pp","doc":"Pretty prints *objects* to `STDOUT`, followed\nby a newline. Returns *objects*.\n\n```\np foo: 23, bar: 42 # => {foo: 23, bar: 42}\n```\n\nSee `Object#pretty_print(pp)`","summary":"<p>Pretty prints <em>objects</em> to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code>, followed by a newline.</p>","abstract":false,"args":[],"args_string":"(**objects)","args_html":"(**objects)","location":{"filename":"src/kernel.cr","line_number":453,"url":null},"def":{"name":"pp","args":[],"double_splat":{"name":"objects","doc":null,"default_value":"","external_name":"objects","restriction":""},"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if objects.empty?\nelse\n  pp(objects)\nend"}},{"id":"pp(*objects)-class-method","html_id":"pp(*objects)-class-method","name":"pp","doc":"Pretty prints each object in *objects* to `STDOUT`, followed\nby a newline. Returns *objects*.\n\nSee also: `Object#pretty_print(pp)`.","summary":"<p>Pretty prints each object in <em>objects</em> to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code>, followed by a newline.</p>","abstract":false,"args":[{"name":"objects","doc":null,"default_value":"","external_name":"objects","restriction":""}],"args_string":"(*objects)","args_html":"(*objects)","location":{"filename":"src/kernel.cr","line_number":438,"url":null},"def":{"name":"pp","args":[{"name":"objects","doc":null,"default_value":"","external_name":"objects","restriction":""}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"objects.each do |obj|\n  pp(obj)\nend\nobjects\n"}},{"id":"print(*objects:_):Nil-class-method","html_id":"print(*objects:_):Nil-class-method","name":"print","doc":"Prints objects to `STDOUT` and then invokes `STDOUT.flush`.\n\nSee also: `IO#print`.","summary":"<p>Prints objects to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code> and then invokes <code>STDOUT.flush</code>.</p>","abstract":false,"args":[{"name":"objects","doc":null,"default_value":"","external_name":"objects","restriction":"_"}],"args_string":"(*objects : _) : Nil","args_html":"(*objects : _) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/kernel.cr","line_number":124,"url":null},"def":{"name":"print","args":[{"name":"objects","doc":null,"default_value":"","external_name":"objects","restriction":"_"}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"STDOUT.print(*objects)"}},{"id":"printf(format_string,args:Array|Tuple):Nil-class-method","html_id":"printf(format_string,args:Array|Tuple):Nil-class-method","name":"printf","doc":"Prints a formatted string to `STDOUT`.\n\nFor details on the format string, see `sprintf`.","summary":"<p>Prints a formatted string to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code>.</p>","abstract":false,"args":[{"name":"format_string","doc":null,"default_value":"","external_name":"format_string","restriction":""},{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":"Array | Tuple"}],"args_string":"(format_string, args : Array | Tuple) : Nil","args_html":"(format_string, args : <a href=\"Array.html\">Array</a> | <a href=\"Tuple.html\">Tuple</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/kernel.cr","line_number":136,"url":null},"def":{"name":"printf","args":[{"name":"format_string","doc":null,"default_value":"","external_name":"format_string","restriction":""},{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":"Array | Tuple"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"STDOUT.printf(format_string, args)"}},{"id":"printf(format_string,*args):Nil-class-method","html_id":"printf(format_string,*args):Nil-class-method","name":"printf","doc":"Prints a formatted string to `STDOUT`.\n\nFor details on the format string, see `sprintf`.","summary":"<p>Prints a formatted string to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code>.</p>","abstract":false,"args":[{"name":"format_string","doc":null,"default_value":"","external_name":"format_string","restriction":""},{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(format_string, *args) : Nil","args_html":"(format_string, *args) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/kernel.cr","line_number":131,"url":null},"def":{"name":"printf","args":[{"name":"format_string","doc":null,"default_value":"","external_name":"format_string","restriction":""},{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":null,"splat_index":1,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"printf(format_string, args)"}},{"id":"puts(*objects):Nil-class-method","html_id":"puts(*objects):Nil-class-method","name":"puts","doc":"Prints objects to `STDOUT`, each followed by a newline.\n\nIf the string representation of an object ends with a newline, no additional\nnewline is printed for that object.\n\nSee also: `IO#puts`.","summary":"<p>Prints objects to <code><a href=\"toplevel.html#STDOUT\">STDOUT</a></code>, each followed by a newline.</p>","abstract":false,"args":[{"name":"objects","doc":null,"default_value":"","external_name":"objects","restriction":""}],"args_string":"(*objects) : Nil","args_html":"(*objects) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/kernel.cr","line_number":387,"url":null},"def":{"name":"puts","args":[{"name":"objects","doc":null,"default_value":"","external_name":"objects","restriction":""}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"STDOUT.puts(*objects)"}},{"id":"raise(message:String):NoReturn-class-method","html_id":"raise(message:String):NoReturn-class-method","name":"raise","doc":"Raises an Exception with the *message*.","summary":"<p>Raises an Exception with the <em>message</em>.</p>","abstract":false,"args":[{"name":"message","doc":null,"default_value":"","external_name":"message","restriction":"String"}],"args_string":"(message : String) : NoReturn","args_html":"(message : <a href=\"String.html\">String</a>) : NoReturn","location":{"filename":"src/raise.cr","line_number":229,"url":null},"def":{"name":"raise","args":[{"name":"message","doc":null,"default_value":"","external_name":"message","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NoReturn","visibility":"Public","body":"raise(Exception.new(message))"}},{"id":"raise(exception:Exception):NoReturn-class-method","html_id":"raise(exception:Exception):NoReturn-class-method","name":"raise","doc":"Raises the *exception*.\n\nThis will set the exception's callstack if it hasn't been already.\nRe-raising a previously caught exception won't replace the callstack.","summary":"<p>Raises the <em>exception</em>.</p>","abstract":false,"args":[{"name":"exception","doc":null,"default_value":"","external_name":"exception","restriction":"Exception"}],"args_string":"(exception : Exception) : NoReturn","args_html":"(exception : <a href=\"Exception.html\">Exception</a>) : NoReturn","location":{"filename":"src/raise.cr","line_number":191,"url":null},"def":{"name":"raise","args":[{"name":"exception","doc":null,"default_value":"","external_name":"exception","restriction":"Exception"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"NoReturn","visibility":"Public","body":"exception.callstack || (exception.callstack = Exception::CallStack.new)\nunwind_ex = Pointer(LibUnwind::Exception).malloc\nunwind_ex.value.exception_class = LibC::SizeT.zero\nunwind_ex.value.exception_cleanup = LibC::SizeT.zero\nunwind_ex.value.exception_object = exception.as(::Pointer(Void))\nunwind_ex.value.exception_type_id = exception.crystal_type_id\n__crystal_raise(unwind_ex)\n"}},{"id":"rand-class-method","html_id":"rand-class-method","name":"rand","doc":"See `Random#rand`.","summary":"<p>See <code>Random#rand</code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/random.cr","line_number":418,"url":null},"def":{"name":"rand","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Random.rand"}},{"id":"rand(x)-class-method","html_id":"rand(x)-class-method","name":"rand","doc":"See `Random#rand(x)`.","summary":"<p>See <code>Random#rand(x)</code>.</p>","abstract":false,"args":[{"name":"x","doc":null,"default_value":"","external_name":"x","restriction":""}],"args_string":"(x)","args_html":"(x)","location":{"filename":"src/random.cr","line_number":423,"url":null},"def":{"name":"rand","args":[{"name":"x","doc":null,"default_value":"","external_name":"x","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Random.rand(x)"}},{"id":"read_line(*args,**options)-class-method","html_id":"read_line(*args,**options)-class-method","name":"read_line","doc":"Reads a line from `STDIN`.\n\nSee also: `IO#read_line`.","summary":"<p>Reads a line from <code><a href=\"toplevel.html#STDIN\">STDIN</a></code>.</p>","abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/kernel.cr","line_number":117,"url":null},"def":{"name":"read_line","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"STDIN.read_line(*args, **options)"}},{"id":"sizeof(type:Class):Int32-class-method","html_id":"sizeof(type:Class):Int32-class-method","name":"sizeof","doc":"Returns the size of the given type as number of bytes.\n\n*type* must be a constant or `typeof()` expression. It cannot be evaluated\nat runtime.\n\n```\nsizeof(Int32)        # => 4\nsizeof(Int64)        # => 8\nsizeof(typeof(true)) # => 1\n```\n\nFor `Reference` types, the size is the same as the size of a pointer:\n\n```\n# On a 64 bits machine\nsizeof(Pointer(Int32)) # => 8\nsizeof(String)         # => 8\n```\n\nThis is because a `Reference`'s memory is allocated on the heap and a pointer\nto it is passed around. The size of a class on the heap can be determined\nusing `#instance_sizeof`.\nNOTE: This is a pseudo-method provided directly by the Crystal compiler.\nIt cannot be redefined nor overridden.","summary":"<p>Returns the size of the given type as number of bytes.</p>","abstract":false,"args":[{"name":"type","doc":null,"default_value":"","external_name":"type","restriction":"Class"}],"args_string":"(type : Class) : Int32","args_html":"(type : <a href=\"Class.html\">Class</a>) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/docs_pseudo_methods.cr","line_number":48,"url":null},"def":{"name":"__crystal_pseudo_sizeof","args":[{"name":"type","doc":null,"default_value":"","external_name":"type","restriction":"Class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":""}},{"id":"sleep(seconds:Number)-class-method","html_id":"sleep(seconds:Number)-class-method","name":"sleep","doc":"Blocks the current fiber for the specified number of seconds.\n\nWhile this fiber is waiting this time, other ready-to-execute\nfibers might start their execution.","summary":"<p>Blocks the current fiber for the specified number of seconds.</p>","abstract":false,"args":[{"name":"seconds","doc":null,"default_value":"","external_name":"seconds","restriction":"Number"}],"args_string":"(seconds : Number)","args_html":"(seconds : <a href=\"Number.html\">Number</a>)","location":{"filename":"src/concurrent.cr","line_number":9,"url":null},"def":{"name":"sleep","args":[{"name":"seconds","doc":null,"default_value":"","external_name":"seconds","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if seconds < 0\n  raise(ArgumentError.new(\"Sleep seconds must be positive\"))\nend\nCrystal::Scheduler.sleep(seconds.seconds)\n"}},{"id":"sleep(time:Time::Span)-class-method","html_id":"sleep(time:Time::Span)-class-method","name":"sleep","doc":"Blocks the current Fiber for the specified time span.\n\nWhile this fiber is waiting this time, other ready-to-execute\nfibers might start their execution.","summary":"<p>Blocks the current Fiber for the specified time span.</p>","abstract":false,"args":[{"name":"time","doc":null,"default_value":"","external_name":"time","restriction":"Time::Span"}],"args_string":"(time : Time::Span)","args_html":"(time : <a href=\"Time/Span.html\">Time::Span</a>)","location":{"filename":"src/concurrent.cr","line_number":21,"url":null},"def":{"name":"sleep","args":[{"name":"time","doc":null,"default_value":"","external_name":"time","restriction":"Time::Span"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Crystal::Scheduler.sleep(time)"}},{"id":"sleep-class-method","html_id":"sleep-class-method","name":"sleep","doc":"Blocks the current fiber forever.\n\nMeanwhile, other ready-to-execute fibers might start their execution.","summary":"<p>Blocks the current fiber forever.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/concurrent.cr","line_number":28,"url":null},"def":{"name":"sleep","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Crystal::Scheduler.reschedule"}},{"id":"spawn(*,name:String?=nil,same_thread=false,&block)-class-method","html_id":"spawn(*,name:String?=nil,same_thread=false,&block)-class-method","name":"spawn","doc":"Spawns a new fiber.\n\nThe newly created fiber doesn't run as soon as spawned.\n\nExample:\n```\n# Write \"1\" every 1 second and \"2\" every 2 seconds for 6 seconds.\n\nch = Channel(Nil).new\n\nspawn do\n  6.times do\n    sleep 1\n    puts 1\n  end\n  ch.send(nil)\nend\n\nspawn do\n  3.times do\n    sleep 2\n    puts 2\n  end\n  ch.send(nil)\nend\n\n2.times { ch.receive }\n```","summary":"<p>Spawns a new fiber.</p>","abstract":false,"args":[{"name":"","doc":null,"default_value":"","external_name":"","restriction":""},{"name":"name","doc":null,"default_value":"nil","external_name":"name","restriction":"String | ::Nil"},{"name":"same_thread","doc":null,"default_value":"false","external_name":"same_thread","restriction":""}],"args_string":"(*, name : String? = <span class=\"n\">nil</span>, same_thread = <span class=\"n\">false</span>, &block)","args_html":"(*, name : <a href=\"String.html\">String</a>? = <span class=\"n\">nil</span>, same_thread = <span class=\"n\">false</span>, &block)","location":{"filename":"src/concurrent.cr","line_number":60,"url":null},"def":{"name":"spawn","args":[{"name":"","doc":null,"default_value":"","external_name":"","restriction":""},{"name":"name","doc":null,"default_value":"nil","external_name":"name","restriction":"String | ::Nil"},{"name":"same_thread","doc":null,"default_value":"false","external_name":"same_thread","restriction":""}],"double_splat":null,"splat_index":0,"yields":0,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":""},"return_type":"","visibility":"Public","body":"fiber = Fiber.new(name, &block)\nif same_thread\n  (fiber.@current_thread).set(Thread.current)\nend\nCrystal::Scheduler.enqueue(fiber)\nfiber\n"}},{"id":"sprintf(format_string,args:Array|Tuple):String-class-method","html_id":"sprintf(format_string,args:Array|Tuple):String-class-method","name":"sprintf","doc":"Returns a formatted string.\nThe string is produced according to the *format_string* with format specifiers\nbeing replaced by values from *args* formatted according to the specifier.\n\nWithin the format string, any characters other than format specifiers\n(specifiers beginning with `%`) are copied to the result.\nThe formatter supports positional format specifiers (`%.1f`),\nformatted substitution (`%<name>.1f`) and plain substitution (`%{name}`).\n\nSubstitutions expect the first argument to be a `Hash` or `NamedTuple` to\nresolve substitution names.\nPositional specifiers correspond to the positional values in the method\narguments, or the array supplied as first argument.\n\nA simple format specifier consists of a percent sign, followed by optional flags,\nwidth, and precision indicators, then terminated with a field type\ncharacter.\n\n```text\n%[flags][width][.precision]type\n```\n\nA formatted substitution is similar but after the percent sign follows the\nmandatory name of the substitution wrapped in angle brackets.\n\n```text\n%<name>[flags][width][.precision]type\n```\n\nThe field type controls how the corresponding argument value is to be\ninterpreted, while the flags modify that interpretation.\n\nThe field type characters are:\n\n```text\nField | Integer Format\n------+------------------------------------------------------------------\n  b   | Formats argument as a binary number.\n  d   | Formats argument as a decimal number.\n  i   | Same as d.\n  o   | Formats argument as an octal number.\n  x   | Formats argument as a hexadecimal number using lowercase letters.\n  X   | Same as x, but uses uppercase letters.\n\nField | Float Format\n------+---------------------------------------------------------------\n  e   | Formats floating point argument into exponential notation\n      | with one digit before the decimal point as [-]d.dddddde[+-]dd.\n      | The precision specifies the number of digits after the decimal\n      | point (defaulting to six).\n  E   | Equivalent to e, but uses an uppercase E to indicate\n      | the exponent.\n  f   | Formats floating point argument as [-]ddd.dddddd,\n      | where the precision specifies the number of digits after\n      | the decimal point.\n  g   | Formats a floating point number using exponential form\n      | if the exponent is less than -4 or greater than or\n      | equal to the precision, or in dd.dddd form otherwise.\n      | The precision specifies the number of significant digits.\n  G   | Equivalent to g, but use an uppercase E in exponent form.\n  a   | Formats floating point argument as [-]0xh.hhhhp[+-]dd,\n      | which consists of an optional sign, \"0x\", fraction part\n      | as hexadecimal, \"p\", and exponential part as decimal.\n  A   | Equivalent to a, but uses uppercase X and P.\n\nField | Other Format\n------+------------------------------------------------------------\n  c   | Argument is a single character itself.\n  s   | Argument is a string to be substituted. If the format\n      | sequence contains a precision, at most that many characters\n      | will be copied.\n  %   | A percent sign itself will be displayed. No argument taken.\n```\n\nFlags modify the behavior of the format specifiers:\n\n```text\nFlag     | Applies to    | Meaning\n---------+---------------+--------------------------------------------\nspace    | bdiouxX       | Add a leading space character to\n         | aAeEfgG       | non-negative numbers.\n         | (numeric fmt) | For o, x, X, b, use\n         |               | a minus sign with absolute value for\n         |               | negative values.\n---------+---------------+--------------------------------------------\n+        | bdiouxX       | Add a leading plus sign to non-negative\n         | aAeEfgG       | numbers.\n         | (numeric fmt) | For o, x, X, b, use\n         |               | a minus sign with absolute value for\n         |               | negative values.\n---------+---------------+--------------------------------------------\n-        | all           | Left-justify the result of this conversion.\n---------+---------------+--------------------------------------------\n0 (zero) | bdiouxX       | Pad with zeros, not spaces.\n         | aAeEfgG       | For o, x, X, b, radix-1\n         | (numeric fmt) | is used for negative numbers formatted as\n         |               | complements.\n```\n\nExamples of flags:\n\nDecimal number conversion:\n```\nsprintf \"%d\", 123  # => \"123\"\nsprintf \"%+d\", 123 # => \"+123\"\nsprintf \"% d\", 123 # => \" 123\"\n```\n\nOctal number conversion:\n```\nsprintf \"%o\", 123   # => \"173\"\nsprintf \"%+o\", 123  # => \"+173\"\nsprintf \"%o\", -123  # => \"-173\"\nsprintf \"%+o\", -123 # => \"-173\"\n```\n\nHexadecimal number conversion:\n```\nsprintf \"%x\", 123   # => \"7b\"\nsprintf \"%+x\", 123  # => \"+7b\"\nsprintf \"%x\", -123  # => \"-7b\"\nsprintf \"%+x\", -123 # => \"-7b\"\nsprintf \"%#x\", 0    # => \"0\"\nsprintf \"% x\", 123  # => \" 7b\"\nsprintf \"% x\", -123 # => \"-7b\"\nsprintf \"%X\", 123   # => \"7B\"\nsprintf \"%#X\", -123 # => \"-7B\"\n```\n\nBinary number conversion:\n```\nsprintf \"%b\", 123    # => \"1111011\"\nsprintf \"%+b\", 123   # => \"+1111011\"\nsprintf \"%+b\", -123  # => \"-1111011\"\nsprintf \"%b\", -123   # => \"-1111011\"\nsprintf \"%#b\", 0     # => \"0\"\nsprintf \"% b\", 123   # => \" 1111011\"\nsprintf \"%+ b\", 123  # => \"+ 1111011\"\nsprintf \"% b\", -123  # => \"-1111011\"\nsprintf \"%+ b\", -123 # => \"-1111011\"\n```\n\nFloating point conversion:\n```\nsprintf \"%a\", 123 # => \"0x1.ecp+6\"\nsprintf \"%A\", 123 # => \"0X1.ECP+6\"\n```\n\nExponential form conversion:\n```\nsprintf \"%g\", 123.4          # => \"123.4\"\nsprintf \"%g\", 123.4567       # => \"123.457\"\nsprintf \"%20.8g\", 1234.56789 # => \"           1234.5679\"\nsprintf \"%20.8g\", 123456789  # => \"       1.2345679e+08\"\nsprintf \"%20.8G\", 123456789  # => \"       1.2345679E+08\"\nsprintf \"%20.8g\", -123456789 # => \"      -1.2345679e+08\"\nsprintf \"%20.8G\", -123456789 # => \"      -1.2345679E+08\"\n```\n\nThe field width is an optional integer, followed optionally by a\nperiod and a precision. The width specifies the minimum number of\ncharacters that will be written to the result for this field.\n\nExamples of width:\n```\nsprintf \"%20d\", 123   # => \"                 123\"\nsprintf \"%+20d\", 123  # => \"                +123\"\nsprintf \"%020d\", 123  # => \"00000000000000000123\"\nsprintf \"%+020d\", 123 # => \"+0000000000000000123\"\nsprintf \"% 020d\", 123 # => \" 0000000000000000123\"\nsprintf \"%-20d\", 123  # => \"123                 \"\nsprintf \"%-+20d\", 123 # => \"+123                \"\nsprintf \"%- 20d\", 123 # => \" 123                \"\nsprintf \"%020x\", -123 # => \"00000000000000000-7b\"\nsprintf \"%020X\", -123 # => \"00000000000000000-7B\"\n```\n\nFor numeric fields, the precision controls the number of decimal places\ndisplayed.\n\nFor string fields, the precision determines the maximum\nnumber of characters to be copied from the string.\n\nExamples of precisions:\n\nPrecision for `d`, `o`, `x` and `b` is\nminimum number of digits:\n```\nsprintf \"%20.8d\", 123   # => \"                 123\"\nsprintf \"%020.8d\", 123  # => \"00000000000000000123\"\nsprintf \"%20.8o\", 123   # => \"                 173\"\nsprintf \"%020.8o\", 123  # => \"00000000000000000173\"\nsprintf \"%20.8x\", 123   # => \"                  7b\"\nsprintf \"%020.8x\", 123  # => \"0000000000000000007b\"\nsprintf \"%20.8b\", 123   # => \"             1111011\"\nsprintf \"%20.8d\", -123  # => \"                -123\"\nsprintf \"%020.8d\", -123 # => \"0000000000000000-123\"\nsprintf \"%20.8o\", -123  # => \"                -173\"\nsprintf \"%20.8x\", -123  # => \"                 -7b\"\nsprintf \"%20.8b\", -11   # => \"               -1011\"\n```\n\nPrecision for `e` is number of digits after the decimal point:\n```\nsprintf \"%20.8e\", 1234.56789 # => \"      1.23456789e+03\"\n```\n\nPrecision for `f` is number of digits after the decimal point:\n```\nsprintf \"%20.8f\", 1234.56789 # => \"       1234.56789000\"\n```\n\nPrecision for `g` is number of significant digits:\n```\nsprintf \"%20.8g\", 1234.56789 # => \"           1234.5679\"\nsprintf \"%20.8g\", 123456789  # => \"       1.2345679e+08\"\nsprintf \"%-20.8g\", 123456789 # => \"1.2345679e+08       \"\n```\n\nPrecision for `s` is maximum number of characters:\n```\nsprintf \"%20.8s\", \"string test\" # => \"            string t\"\n```\n\nAdditional examples:\n```\nsprintf \"%d %04x\", 123, 123             # => \"123 007b\"\nsprintf \"%08b '%4s'\", 123, 123          # => \"01111011 ' 123'\"\nsprintf \"%+g:% g:%-g\", 1.23, 1.23, 1.23 # => \"+1.23: 1.23:1.23\"\n```","summary":"<p>Returns a formatted string.</p>","abstract":false,"args":[{"name":"format_string","doc":null,"default_value":"","external_name":"format_string","restriction":""},{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":"Array | Tuple"}],"args_string":"(format_string, args : Array | Tuple) : String","args_html":"(format_string, args : <a href=\"Array.html\">Array</a> | <a href=\"Tuple.html\">Tuple</a>) : <a href=\"String.html\">String</a>","location":{"filename":"src/kernel.cr","line_number":375,"url":null},"def":{"name":"sprintf","args":[{"name":"format_string","doc":null,"default_value":"","external_name":"format_string","restriction":""},{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":"Array | Tuple"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"String.build(format_string.bytesize) do |str|\n  (String::Formatter(typeof(args)).new(format_string, args, str)).format\nend"}},{"id":"sprintf(format_string,*args):String-class-method","html_id":"sprintf(format_string,*args):String-class-method","name":"sprintf","doc":"Returns a formatted string.\nThe string is produced according to the *format_string* with format specifiers\nbeing replaced by values from *args* formatted according to the specifier.\n\nWithin the format string, any characters other than format specifiers\n(specifiers beginning with `%`) are copied to the result.\nThe formatter supports positional format specifiers (`%.1f`),\nformatted substitution (`%<name>.1f`) and plain substitution (`%{name}`).\n\nSubstitutions expect the first argument to be a `Hash` or `NamedTuple` to\nresolve substitution names.\nPositional specifiers correspond to the positional values in the method\narguments, or the array supplied as first argument.\n\nA simple format specifier consists of a percent sign, followed by optional flags,\nwidth, and precision indicators, then terminated with a field type\ncharacter.\n\n```text\n%[flags][width][.precision]type\n```\n\nA formatted substitution is similar but after the percent sign follows the\nmandatory name of the substitution wrapped in angle brackets.\n\n```text\n%<name>[flags][width][.precision]type\n```\n\nThe field type controls how the corresponding argument value is to be\ninterpreted, while the flags modify that interpretation.\n\nThe field type characters are:\n\n```text\nField | Integer Format\n------+------------------------------------------------------------------\n  b   | Formats argument as a binary number.\n  d   | Formats argument as a decimal number.\n  i   | Same as d.\n  o   | Formats argument as an octal number.\n  x   | Formats argument as a hexadecimal number using lowercase letters.\n  X   | Same as x, but uses uppercase letters.\n\nField | Float Format\n------+---------------------------------------------------------------\n  e   | Formats floating point argument into exponential notation\n      | with one digit before the decimal point as [-]d.dddddde[+-]dd.\n      | The precision specifies the number of digits after the decimal\n      | point (defaulting to six).\n  E   | Equivalent to e, but uses an uppercase E to indicate\n      | the exponent.\n  f   | Formats floating point argument as [-]ddd.dddddd,\n      | where the precision specifies the number of digits after\n      | the decimal point.\n  g   | Formats a floating point number using exponential form\n      | if the exponent is less than -4 or greater than or\n      | equal to the precision, or in dd.dddd form otherwise.\n      | The precision specifies the number of significant digits.\n  G   | Equivalent to g, but use an uppercase E in exponent form.\n  a   | Formats floating point argument as [-]0xh.hhhhp[+-]dd,\n      | which consists of an optional sign, \"0x\", fraction part\n      | as hexadecimal, \"p\", and exponential part as decimal.\n  A   | Equivalent to a, but uses uppercase X and P.\n\nField | Other Format\n------+------------------------------------------------------------\n  c   | Argument is a single character itself.\n  s   | Argument is a string to be substituted. If the format\n      | sequence contains a precision, at most that many characters\n      | will be copied.\n  %   | A percent sign itself will be displayed. No argument taken.\n```\n\nFlags modify the behavior of the format specifiers:\n\n```text\nFlag     | Applies to    | Meaning\n---------+---------------+--------------------------------------------\nspace    | bdiouxX       | Add a leading space character to\n         | aAeEfgG       | non-negative numbers.\n         | (numeric fmt) | For o, x, X, b, use\n         |               | a minus sign with absolute value for\n         |               | negative values.\n---------+---------------+--------------------------------------------\n+        | bdiouxX       | Add a leading plus sign to non-negative\n         | aAeEfgG       | numbers.\n         | (numeric fmt) | For o, x, X, b, use\n         |               | a minus sign with absolute value for\n         |               | negative values.\n---------+---------------+--------------------------------------------\n-        | all           | Left-justify the result of this conversion.\n---------+---------------+--------------------------------------------\n0 (zero) | bdiouxX       | Pad with zeros, not spaces.\n         | aAeEfgG       | For o, x, X, b, radix-1\n         | (numeric fmt) | is used for negative numbers formatted as\n         |               | complements.\n```\n\nExamples of flags:\n\nDecimal number conversion:\n```\nsprintf \"%d\", 123  # => \"123\"\nsprintf \"%+d\", 123 # => \"+123\"\nsprintf \"% d\", 123 # => \" 123\"\n```\n\nOctal number conversion:\n```\nsprintf \"%o\", 123   # => \"173\"\nsprintf \"%+o\", 123  # => \"+173\"\nsprintf \"%o\", -123  # => \"-173\"\nsprintf \"%+o\", -123 # => \"-173\"\n```\n\nHexadecimal number conversion:\n```\nsprintf \"%x\", 123   # => \"7b\"\nsprintf \"%+x\", 123  # => \"+7b\"\nsprintf \"%x\", -123  # => \"-7b\"\nsprintf \"%+x\", -123 # => \"-7b\"\nsprintf \"%#x\", 0    # => \"0\"\nsprintf \"% x\", 123  # => \" 7b\"\nsprintf \"% x\", -123 # => \"-7b\"\nsprintf \"%X\", 123   # => \"7B\"\nsprintf \"%#X\", -123 # => \"-7B\"\n```\n\nBinary number conversion:\n```\nsprintf \"%b\", 123    # => \"1111011\"\nsprintf \"%+b\", 123   # => \"+1111011\"\nsprintf \"%+b\", -123  # => \"-1111011\"\nsprintf \"%b\", -123   # => \"-1111011\"\nsprintf \"%#b\", 0     # => \"0\"\nsprintf \"% b\", 123   # => \" 1111011\"\nsprintf \"%+ b\", 123  # => \"+ 1111011\"\nsprintf \"% b\", -123  # => \"-1111011\"\nsprintf \"%+ b\", -123 # => \"-1111011\"\n```\n\nFloating point conversion:\n```\nsprintf \"%a\", 123 # => \"0x1.ecp+6\"\nsprintf \"%A\", 123 # => \"0X1.ECP+6\"\n```\n\nExponential form conversion:\n```\nsprintf \"%g\", 123.4          # => \"123.4\"\nsprintf \"%g\", 123.4567       # => \"123.457\"\nsprintf \"%20.8g\", 1234.56789 # => \"           1234.5679\"\nsprintf \"%20.8g\", 123456789  # => \"       1.2345679e+08\"\nsprintf \"%20.8G\", 123456789  # => \"       1.2345679E+08\"\nsprintf \"%20.8g\", -123456789 # => \"      -1.2345679e+08\"\nsprintf \"%20.8G\", -123456789 # => \"      -1.2345679E+08\"\n```\n\nThe field width is an optional integer, followed optionally by a\nperiod and a precision. The width specifies the minimum number of\ncharacters that will be written to the result for this field.\n\nExamples of width:\n```\nsprintf \"%20d\", 123   # => \"                 123\"\nsprintf \"%+20d\", 123  # => \"                +123\"\nsprintf \"%020d\", 123  # => \"00000000000000000123\"\nsprintf \"%+020d\", 123 # => \"+0000000000000000123\"\nsprintf \"% 020d\", 123 # => \" 0000000000000000123\"\nsprintf \"%-20d\", 123  # => \"123                 \"\nsprintf \"%-+20d\", 123 # => \"+123                \"\nsprintf \"%- 20d\", 123 # => \" 123                \"\nsprintf \"%020x\", -123 # => \"00000000000000000-7b\"\nsprintf \"%020X\", -123 # => \"00000000000000000-7B\"\n```\n\nFor numeric fields, the precision controls the number of decimal places\ndisplayed.\n\nFor string fields, the precision determines the maximum\nnumber of characters to be copied from the string.\n\nExamples of precisions:\n\nPrecision for `d`, `o`, `x` and `b` is\nminimum number of digits:\n```\nsprintf \"%20.8d\", 123   # => \"                 123\"\nsprintf \"%020.8d\", 123  # => \"00000000000000000123\"\nsprintf \"%20.8o\", 123   # => \"                 173\"\nsprintf \"%020.8o\", 123  # => \"00000000000000000173\"\nsprintf \"%20.8x\", 123   # => \"                  7b\"\nsprintf \"%020.8x\", 123  # => \"0000000000000000007b\"\nsprintf \"%20.8b\", 123   # => \"             1111011\"\nsprintf \"%20.8d\", -123  # => \"                -123\"\nsprintf \"%020.8d\", -123 # => \"0000000000000000-123\"\nsprintf \"%20.8o\", -123  # => \"                -173\"\nsprintf \"%20.8x\", -123  # => \"                 -7b\"\nsprintf \"%20.8b\", -11   # => \"               -1011\"\n```\n\nPrecision for `e` is number of digits after the decimal point:\n```\nsprintf \"%20.8e\", 1234.56789 # => \"      1.23456789e+03\"\n```\n\nPrecision for `f` is number of digits after the decimal point:\n```\nsprintf \"%20.8f\", 1234.56789 # => \"       1234.56789000\"\n```\n\nPrecision for `g` is number of significant digits:\n```\nsprintf \"%20.8g\", 1234.56789 # => \"           1234.5679\"\nsprintf \"%20.8g\", 123456789  # => \"       1.2345679e+08\"\nsprintf \"%-20.8g\", 123456789 # => \"1.2345679e+08       \"\n```\n\nPrecision for `s` is maximum number of characters:\n```\nsprintf \"%20.8s\", \"string test\" # => \"            string t\"\n```\n\nAdditional examples:\n```\nsprintf \"%d %04x\", 123, 123             # => \"123 007b\"\nsprintf \"%08b '%4s'\", 123, 123          # => \"01111011 ' 123'\"\nsprintf \"%+g:% g:%-g\", 1.23, 1.23, 1.23 # => \"+1.23: 1.23:1.23\"\n```","summary":"<p>Returns a formatted string.</p>","abstract":false,"args":[{"name":"format_string","doc":null,"default_value":"","external_name":"format_string","restriction":""},{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(format_string, *args) : String","args_html":"(format_string, *args) : <a href=\"String.html\">String</a>","location":{"filename":"src/kernel.cr","line_number":370,"url":null},"def":{"name":"sprintf","args":[{"name":"format_string","doc":null,"default_value":"","external_name":"format_string","restriction":""},{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":null,"splat_index":1,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"sprintf(format_string, args)"}},{"id":"system(command:String,args=nil):Bool-class-method","html_id":"system(command:String,args=nil):Bool-class-method","name":"system","doc":"Executes the given command in a subshell.\nStandard input, output and error are inherited.\nReturns `true` if the command gives zero exit code, `false` otherwise.\nThe special `$?` variable is set to a `Process::Status` associated with this execution.\n\nIf *command* contains no spaces and *args* is given, it will become\nits argument list.\n\nIf *command* contains spaces and *args* is given, *command* must include\n`\"${@}\"` (including the quotes) to receive the argument list.\n\nNo shell interpretation is done in *args*.\n\nExample:\n\n```\nsystem(\"echo *\")\n```\n\nProduces:\n\n```text\nLICENSE shard.yml Readme.md spec src\n```","summary":"<p>Executes the given command in a subshell.</p>","abstract":false,"args":[{"name":"command","doc":null,"default_value":"","external_name":"command","restriction":"String"},{"name":"args","doc":null,"default_value":"nil","external_name":"args","restriction":""}],"args_string":"(command : String, args = <span class=\"n\">nil</span>) : Bool","args_html":"(command : <a href=\"String.html\">String</a>, args = <span class=\"n\">nil</span>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/process.cr","line_number":431,"url":null},"def":{"name":"system","args":[{"name":"command","doc":null,"default_value":"","external_name":"command","restriction":"String"},{"name":"args","doc":null,"default_value":"nil","external_name":"args","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"status = Process.run(command, args, shell: true, input: Process::Redirect::Inherit, output: Process::Redirect::Inherit, error: Process::Redirect::Inherit)\n$? = status\nstatus.success?\n"}},{"id":"timeout_select_action(timeout:Time::Span)-class-method","html_id":"timeout_select_action(timeout:Time::Span)-class-method","name":"timeout_select_action","doc":"Timeout keyword for use in `select`.\n\n```\nselect\nwhen x = ch.receive\n  puts \"got #{x}\"\nwhen timeout(1.seconds)\n  puts \"timeout\"\nend\n```\n\nNOTE: It won't trigger if the `select` has an `else` case (i.e.: a non-blocking select).","summary":"<p>Timeout keyword for use in <code>select</code>.</p>","abstract":false,"args":[{"name":"timeout","doc":null,"default_value":"","external_name":"timeout","restriction":"Time::Span"}],"args_string":"(timeout : Time::Span)","args_html":"(timeout : <a href=\"Time/Span.html\">Time::Span</a>)","location":{"filename":"src/channel.cr","line_number":736,"url":null},"def":{"name":"timeout_select_action","args":[{"name":"timeout","doc":null,"default_value":"","external_name":"timeout","restriction":"Time::Span"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Channel::TimeoutAction.new(timeout)"}},{"id":"typeof(*expression):Class-class-method","html_id":"typeof(*expression):Class-class-method","name":"typeof","doc":"Returns the type of an expression.\n\n```\ntypeof(1) # => Int32\n```\n\nIt accepts multiple arguments, and the result is the union of the expression types:\n\n```\ntypeof(1, \"a\", 'a') # => (Int32 | String | Char)\n```\n\nThe expressions passed as arguments to `typeof` do not evaluate. The compiler\nonly analyzes their return type.\nNOTE: This is a pseudo-method provided directly by the Crystal compiler.\nIt cannot be redefined nor overridden.","summary":"<p>Returns the type of an expression.</p>","abstract":false,"args":[{"name":"expression","doc":null,"default_value":"","external_name":"expression","restriction":""}],"args_string":"(*expression) : Class","args_html":"(*expression) : <a href=\"Class.html\">Class</a>","location":{"filename":"src/docs_pseudo_methods.cr","line_number":23,"url":null},"def":{"name":"__crystal_pseudo_typeof","args":[{"name":"expression","doc":null,"default_value":"","external_name":"expression","restriction":""}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"Class","visibility":"Public","body":""}}],"constructors":[],"instance_methods":[],"macros":[{"id":"debugger-macro","html_id":"debugger-macro","name":"debugger","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","location":{"filename":"src/intrinsics.cr","line_number":173,"url":null},"def":{"name":"debugger","args":[],"double_splat":null,"splat_index":null,"block_arg":null,"visibility":"Public","body":"  Intrinsics.debugtrap\n"}},{"id":"p!(*exps)-macro","html_id":"p!(*exps)-macro","name":"p!","doc":"Prints a series of expressions together with their inspected values.\nUseful for print style debugging.\n\n```\na = 1\np! a # => \"a # => 1\"\n\np! [1, 2, 3].map(&.to_s) # => \"[1, 2, 3].map(&.to_s) # => [\"1\", \"2\", \"3\"]\"\n```\n\nSee also: `p`, `Object#inspect`.","summary":"<p>Prints a series of expressions together with their inspected values.</p>","abstract":false,"args":[{"name":"exps","doc":null,"default_value":"","external_name":"exps","restriction":""}],"args_string":"(*exps)","location":{"filename":"src/macros.cr","line_number":166,"url":null},"def":{"name":"p!","args":[{"name":"exps","doc":null,"default_value":"","external_name":"exps","restriction":""}],"double_splat":null,"splat_index":0,"block_arg":null,"visibility":"Public","body":"  \n{% if exps.size == 0 %}\n    # Nothing\n  {% else %}{% if exps.size == 1 %}\n    {% exp = exps.first %}\n    %prefix = \"#{{{ exp.stringify }}} # => \"\n    ::print %prefix\n    ::p({{ exp }})\n  {% else %}\n    %names = { {{ *exps.map(&.stringify) }} }\n    %max_size = %names.max_of &.size\n    {\n      {% for exp, i in exps %}\n        begin\n          %prefix = \"#{%names[{{ i }}].ljust(%max_size)} # => \"\n          ::print %prefix\n          ::p({{ exp }})\n        end,\n      {% end %}\n    }\n  {% end %}{% end %}\n\n\n"}},{"id":"pp!(*exps)-macro","html_id":"pp!(*exps)-macro","name":"pp!","doc":"Prints a series of expressions together with their pretty printed values.\nUseful for print style debugging.\n\n```\na = 1\npp! a # => \"a # => 1\"\n\npp! [1, 2, 3].map(&.to_s) # => \"[1, 2, 3].map(&.to_s) # => [\"1\", \"2\", \"3\"]\"\n```\n\nSee also: `pp`, `Object#pretty_inspect`.","summary":"<p>Prints a series of expressions together with their pretty printed values.</p>","abstract":false,"args":[{"name":"exps","doc":null,"default_value":"","external_name":"exps","restriction":""}],"args_string":"(*exps)","location":{"filename":"src/macros.cr","line_number":132,"url":null},"def":{"name":"pp!","args":[{"name":"exps","doc":null,"default_value":"","external_name":"exps","restriction":""}],"double_splat":null,"splat_index":0,"block_arg":null,"visibility":"Public","body":"  \n{% if exps.size == 0 %}\n    # Nothing\n  {% else %}{% if exps.size == 1 %}\n    {% exp = exps.first %}\n    %prefix = \"#{{{ exp.stringify }}} # => \"\n    ::print %prefix\n    ::pp({{ exp }})\n  {% else %}\n    %names = { {{ *exps.map(&.stringify) }} }\n    %max_size = %names.max_of &.size\n    {\n      {% for exp, i in exps %}\n        begin\n          %prefix = \"#{%names[{{ i }}].ljust(%max_size)} # => \"\n          ::print %prefix\n          ::pp({{ exp }})\n        end,\n      {% end %}\n    }\n  {% end %}{% end %}\n\n\n"}},{"id":"record(name,*properties)-macro","html_id":"record(name,*properties)-macro","name":"record","doc":"Defines a **`Struct`** with the given name and properties.\n\nThe generated struct has a constructor with the given properties\nin the same order as declared. The struct only provides getters,\nnot setters, making it immutable by default.\n\nThe properties can be type declarations or assignments.\n\nYou can pass a block to this macro, that will be inserted inside\nthe struct definition.\n\n```\nrecord Point, x : Int32, y : Int32\n\nPoint.new 1, 2 # => #<Point(@x=1, @y=2)>\n```\n\nAn example with the block version:\n\n```\nrecord Person, first_name : String, last_name : String do\n  def full_name\n    \"#{first_name} #{last_name}\"\n  end\nend\n\nperson = Person.new \"John\", \"Doe\"\nperson.full_name # => \"John Doe\"\n```\n\nAn example with type declarations and default values:\n\n```\nrecord Point, x : Int32 = 0, y : Int32 = 0\n\nPoint.new      # => #<Point(@x=0, @y=0)>\nPoint.new y: 2 # => #<Point(@x=0, @y=2)>\n```\n\nAn example with assignments (in this case the compiler must be able to\ninfer the types from the default values):\n\n```\nrecord Point, x = 0, y = 0\n\nPoint.new      # => #<Point(@x=0, @y=0)>\nPoint.new y: 2 # => #<Point(@x=0, @y=2)>\n```\n\nThis macro also provides a `copy_with` method which returns\na copy of the record with the provided properties altered.\n\n```\nrecord Point, x = 0, y = 0\n\np = Point.new y: 2 # => #<Point(@x=0, @y=2)>\np.copy_with x: 3   # => #<Point(@x=3, @y=2)>\np                  # => #<Point(@x=0, @y=2)>\n```","summary":"<p>Defines a <strong><code><a href=\"Struct.html\">Struct</a></code></strong> with the given name and properties.</p>","abstract":false,"args":[{"name":"name","doc":null,"default_value":"","external_name":"name","restriction":""},{"name":"properties","doc":null,"default_value":"","external_name":"properties","restriction":""}],"args_string":"(name, *properties)","location":{"filename":"src/macros.cr","line_number":60,"url":null},"def":{"name":"record","args":[{"name":"name","doc":null,"default_value":"","external_name":"name","restriction":""},{"name":"properties","doc":null,"default_value":"","external_name":"properties","restriction":""}],"double_splat":null,"splat_index":1,"block_arg":null,"visibility":"Public","body":"  struct \n{{ name.id }}\n\n    \n{% for property in properties %}\n      {% if property.is_a?(Assign) %}\n        getter {{ property.target.id }}\n      {% else %}{% if property.is_a?(TypeDeclaration) %}\n        getter {{ property }}\n      {% else %}\n        getter :{{ property.id }}\n      {% end %}{% end %}\n    {% end %}\n\n\n    def initialize(\n{{ *properties.map do |field|\n  \"@#{field.id}\".id\nend }}\n)\n    \nend\n\n    \n{{ yield }}\n\n\n    def copy_with(\n{{ *properties.map do |property|\n  if property.is_a?(Assign)\n    \"#{property.target.id} _#{property.target.id} = @#{property.target.id}\".id\n  else\n    if property.is_a?(TypeDeclaration)\n      \"#{property.var.id} _#{property.var.id} = @#{property.var.id}\".id\n    else\n      \"#{property.id} _#{property.id} = @#{property.id}\".id\n    end\n  end\nend }}\n)\n      self.class.new(\n{{ *properties.map do |property|\n  if property.is_a?(Assign)\n    \"_#{property.target.id}\".id\n  else\n    if property.is_a?(TypeDeclaration)\n      \"_#{property.var.id}\".id\n    else\n      \"_#{property.id}\".id\n    end\n  end\nend }}\n)\n    \nend\n\n    def clone\n      self.class.new(\n{{ *properties.map do |property|\n  if property.is_a?(Assign)\n    \"@#{property.target.id}.clone\".id\n  else\n    if property.is_a?(TypeDeclaration)\n      \"@#{property.var.id}.clone\".id\n    else\n      \"@#{property.id}.clone\".id\n    end\n  end\nend }}\n)\n    \nend\n  \nend\n\n"}},{"id":"spawn(call,*,name=nil,same_thread=false,&block)-macro","html_id":"spawn(call,*,name=nil,same_thread=false,&amp;block)-macro","name":"spawn","doc":"Spawns a fiber by first creating a `Proc`, passing the *call*'s\nexpressions to it, and letting the `Proc` finally invoke the *call*.\n\nCompare this:\n\n```\ni = 0\nwhile i < 5\n  spawn { print(i) }\n  i += 1\nend\nFiber.yield\n# Output: 55555\n```\n\nTo this:\n\n```\ni = 0\nwhile i < 5\n  spawn print(i)\n  i += 1\nend\nFiber.yield\n# Output: 01234\n```\n\nThis is because in the first case all spawned fibers refer to\nthe same local variable, while in the second example copies of\n*i* are passed to a `Proc` that eventually invokes the call.","summary":"<p>Spawns a fiber by first creating a <code><a href=\"Proc.html\">Proc</a></code>, passing the <em>call</em>'s expressions to it, and letting the <code><a href=\"Proc.html\">Proc</a></code> finally invoke the <em>call</em>.</p>","abstract":false,"args":[{"name":"call","doc":null,"default_value":"","external_name":"call","restriction":""},{"name":"","doc":null,"default_value":"","external_name":"","restriction":""},{"name":"name","doc":null,"default_value":"nil","external_name":"name","restriction":""},{"name":"same_thread","doc":null,"default_value":"false","external_name":"same_thread","restriction":""}],"args_string":"(call, *, name = <span class=\"n\">nil</span>, same_thread = <span class=\"n\">false</span>, &block)","location":{"filename":"src/concurrent.cr","line_number":99,"url":null},"def":{"name":"spawn","args":[{"name":"call","doc":null,"default_value":"","external_name":"call","restriction":""},{"name":"","doc":null,"default_value":"","external_name":"","restriction":""},{"name":"name","doc":null,"default_value":"nil","external_name":"name","restriction":""},{"name":"same_thread","doc":null,"default_value":"false","external_name":"same_thread","restriction":""}],"double_splat":null,"splat_index":1,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":""},"visibility":"Public","body":"  \n{% if block %}\n    {% raise(\"`spawn(call)` can't be invoked with a block, did you mean `spawn(name: ...) { ... }`?\") %}\n  {% end %}\n\n\n  \n{% if call.is_a?(Call) %}\n    ->(\n      {% for arg, i in call.args %}\n        __arg{{ i }} : typeof({{ arg.is_a?(Splat) ? arg.exp : arg }}),\n      {% end %}\n      {% if call.named_args %}\n        {% for narg, i in call.named_args %}\n          __narg{{ i }} : typeof({{ narg.value }}),\n        {% end %}\n      {% end %}\n      ) {\n      spawn(name: {{ name }}, same_thread: {{ same_thread }}) do\n        {% if call.receiver %}{{ call.receiver }}.{% end %}{{ call.name }}(\n          {% for arg, i in call.args %}\n            {% if arg.is_a?(Splat) %}*{% end %}__arg{{ i }},\n          {% end %}\n          {% if call.named_args %}\n            {% for narg, i in call.named_args %}\n              {{ narg.name }}: __narg{{ i }},\n            {% end %}\n          {% end %}\n        )\n      end\n      }.call(\n        {% for arg in call.args %}\n          {{ arg.is_a?(Splat) ? arg.exp : arg }},\n        {% end %}\n        {% if call.named_args %}\n          {{ call.named_args.map(&.value).splat }}\n        {% end %}\n      )\n  {% else %}\n    spawn do\n      {{ call }}\n    end\n  {% end %}\n\n\n"}}],"types":[{"html_id":"Crystal/ArgumentError","path":"ArgumentError.html","kind":"class","full_name":"ArgumentError","name":"ArgumentError","abstract":false,"superclass":{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},"ancestors":[{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"Raised when the arguments are wrong and there isn't a more specific `Exception` class.\n\n```\n[1, 2, 3].first(-4) # raises ArgumentError (attempt to take negative size)\n```","summary":"<p>Raised when the arguments are wrong and there isn't a more specific <code><a href=\"Exception.html\">Exception</a></code> class.</p>","class_methods":[],"constructors":[{"id":"new(message=&quot;Argumenterror&quot;)-class-method","html_id":"new(message=&quot;Argumenterror&quot;)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"message","doc":null,"default_value":"\"Argument error\"","external_name":"message","restriction":""}],"args_string":"(message = <span class=\"s\">&quot;Argument error&quot;</span>)","args_html":"(message = <span class=\"s\">&quot;Argument error&quot;</span>)","location":{"filename":"src/exception.cr","line_number":93,"url":null},"def":{"name":"new","args":[{"name":"message","doc":null,"default_value":"\"Argument error\"","external_name":"message","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(message)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[],"macros":[],"types":[]},{"html_id":"Crystal/Array","path":"Array.html","kind":"class","full_name":"Array(T)","name":"Array","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Indexable","kind":"module","full_name":"Indexable","name":"Indexable"},{"html_id":"Crystal/Enumerable","kind":"module","full_name":"Enumerable","name":"Enumerable"},{"html_id":"Crystal/Iterable","kind":"module","full_name":"Iterable","name":"Iterable"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Indexable","kind":"module","full_name":"Indexable","name":"Indexable"}],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"An `Array` is an ordered, integer-indexed collection of objects of type T.\n\nArray indexing starts at 0. A negative index is assumed to be\nrelative to the end of the array: -1 indicates the last element,\n-2 is the next to last element, and so on.\n\nAn `Array` can be created using the usual `new` method (several are provided), or with an array literal:\n\n```\nArray(Int32).new  # => []\n[1, 2, 3]         # Array(Int32)\n[1, \"hello\", 'x'] # Array(Int32 | String | Char)\n```\n\nAn `Array` can have mixed types, meaning T will be a union of types, but these are determined\nwhen the array is created, either by specifying T or by using an array literal. In the latter\ncase, T will be set to the union of the array literal elements' types.\n\nWhen creating an empty array you must always specify T:\n\n```\n[] of Int32 # same as Array(Int32)\n[]          # syntax error\n```\n\nAn `Array` is implemented using an internal buffer of some capacity\nand is reallocated when elements are pushed to it when more capacity\nis needed. This is normally known as a [dynamic array](http://en.wikipedia.org/wiki/Dynamic_array).\n\nYou can use a special array literal syntax with other types too, as long as they define an argless\n`new` method and a `<<` method. `Set` is one such type:\n\n```\nset = Set{1, 2, 3} # => Set{1, 2, 3}\nset.class          # => Set(Int32)\n```\n\nThe above is the same as this:\n\n```\nset = Set(typeof(1, 2, 3)).new\nset << 1\nset << 2\nset << 3\n```","summary":"<p>An <code><a href=\"Array.html\">Array</a></code> is an ordered, integer-indexed collection of objects of type T.</p>","class_methods":[{"id":"each_product(arrays:Array(Array),reuse=false,&)-class-method","html_id":"each_product(arrays:Array(Array),reuse=false,&)-class-method","name":"each_product","doc":null,"summary":null,"abstract":false,"args":[{"name":"arrays","doc":null,"default_value":"","external_name":"arrays","restriction":"Array(Array)"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"args_string":"(arrays : Array(Array), reuse = <span class=\"n\">false</span>, &)","args_html":"(arrays : <a href=\"Array.html\">Array</a>(<a href=\"Array.html\">Array</a>), reuse = <span class=\"n\">false</span>, &)","location":{"filename":"src/array.cr","line_number":1277,"url":null},"def":{"name":"each_product","args":[{"name":"arrays","doc":null,"default_value":"","external_name":"arrays","restriction":"Array(Array)"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"lens = arrays.map(&.size)\nif lens.any?(&.==(0))\n  return\nend\npool = arrays.map(&.first)\nn = arrays.size\nindices = Array.new(n, 0)\nif reuse\n  if reuse.is_a?(Array)\n  else\n    reuse = (typeof(pool)).new(n)\n  end\nelse\n  reuse = nil\nend\nyield pool_slice(pool, n, reuse)\nwhile true\n  i = n - 1\n  __temp_13 = i\n  indices[__temp_13] = indices[__temp_13] + 1\n  while indices[i] >= lens[i]\n    indices[i] = 0\n    pool[i] = arrays[i][indices[i]]\n    i = i - 1\n    if i < 0\n      return\n    end\n    __temp_15 = i\n    indices[__temp_15] = indices[__temp_15] + 1\n  end\n  pool[i] = arrays[i][indices[i]]\n  yield pool_slice(pool, n, reuse)\nend\n"}},{"id":"each_product(*arrays:Array,reuse=false,&)-class-method","html_id":"each_product(*arrays:Array,reuse=false,&)-class-method","name":"each_product","doc":null,"summary":null,"abstract":false,"args":[{"name":"arrays","doc":null,"default_value":"","external_name":"arrays","restriction":"Array"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"args_string":"(*arrays : Array, reuse = <span class=\"n\">false</span>, &)","args_html":"(*arrays : <a href=\"Array.html\">Array</a>, reuse = <span class=\"n\">false</span>, &)","location":{"filename":"src/array.cr","line_number":1312,"url":null},"def":{"name":"each_product","args":[{"name":"arrays","doc":null,"default_value":"","external_name":"arrays","restriction":"Array"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"double_splat":null,"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"each_product(arrays.to_a, reuse: reuse) do |result|\n  yield result\nend"}},{"id":"from_json(string_or_io,&):Nil-class-method","html_id":"from_json(string_or_io,&):Nil-class-method","name":"from_json","doc":"Parses a `String` or `IO` denoting a JSON array, yielding\neach of its elements to the given block. This is useful\nfor decoding an array and processing its elements without\ncreating an Array in memory, which might be expensive.\n\n```\nrequire \"json\"\n\nArray(Int32).from_json(\"[1, 2, 3]\") do |element|\n  puts element\nend\n```\n\nOutput:\n\n```text\n1\n2\n3\n```\n\nTo parse and get an `Array`, use the block-less overload.","summary":"<p>Parses a <code><a href=\"String.html\">String</a></code> or <code><a href=\"IO.html\">IO</a></code> denoting a JSON array, yielding each of its elements to the given block.</p>","abstract":false,"args":[{"name":"string_or_io","doc":null,"default_value":"","external_name":"string_or_io","restriction":""}],"args_string":"(string_or_io, &) : Nil","args_html":"(string_or_io, &) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/json/from_json.cr","line_number":53,"url":null},"def":{"name":"from_json","args":[{"name":"string_or_io","doc":null,"default_value":"","external_name":"string_or_io","restriction":""}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"parser = JSON::PullParser.new(string_or_io)\nnew(parser) do |element|\n  yield element\nend\nnil\n"}},{"id":"from_yaml(string_or_io:String|IO,&)-class-method","html_id":"from_yaml(string_or_io:String|IO,&)-class-method","name":"from_yaml","doc":null,"summary":null,"abstract":false,"args":[{"name":"string_or_io","doc":null,"default_value":"","external_name":"string_or_io","restriction":"String | IO"}],"args_string":"(string_or_io : String | IO, &)","args_html":"(string_or_io : <a href=\"String.html\">String</a> | <a href=\"IO.html\">IO</a>, &)","location":{"filename":"src/yaml/from_yaml.cr","line_number":15,"url":null},"def":{"name":"from_yaml","args":[{"name":"string_or_io","doc":null,"default_value":"","external_name":"string_or_io","restriction":"String | IO"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"new(YAML::ParseContext.new, parse_yaml(string_or_io)) do |element|\n  yield element\nend"}},{"id":"product(arrays)-class-method","html_id":"product(arrays)-class-method","name":"product","doc":null,"summary":null,"abstract":false,"args":[{"name":"arrays","doc":null,"default_value":"","external_name":"arrays","restriction":""}],"args_string":"(arrays)","args_html":"(arrays)","location":{"filename":"src/array.cr","line_number":1265,"url":null},"def":{"name":"product","args":[{"name":"arrays","doc":null,"default_value":"","external_name":"arrays","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"result = [] of Array(typeof(arrays.first.first))\neach_product(arrays) do |product|\n  result << product\nend\nresult\n"}},{"id":"product(*arrays:Array)-class-method","html_id":"product(*arrays:Array)-class-method","name":"product","doc":null,"summary":null,"abstract":false,"args":[{"name":"arrays","doc":null,"default_value":"","external_name":"arrays","restriction":"Array"}],"args_string":"(*arrays : Array)","args_html":"(*arrays : <a href=\"Array.html\">Array</a>)","location":{"filename":"src/array.cr","line_number":1273,"url":null},"def":{"name":"product","args":[{"name":"arrays","doc":null,"default_value":"","external_name":"arrays","restriction":"Array"}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"product(arrays.to_a)"}}],"constructors":[{"id":"additive_identity:self-class-method","html_id":"additive_identity:self-class-method","name":"additive_identity","doc":"Returns the additive identity of this type.\n\nThis is an empty array.","summary":"<p>Returns the additive identity of this type.</p>","abstract":false,"args":[],"args_string":" : <span class=\"k\">self</span>","args_html":" : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":340,"url":null},"def":{"name":"additive_identity","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"self","visibility":"Public","body":"self.new"}},{"id":"build(capacity:Int,&):self-class-method","html_id":"build(capacity:Int,&):self-class-method","name":"build","doc":"Creates a new `Array`, allocating an internal buffer with the given *capacity*,\nand yielding that buffer. The given block must return the desired size of the array.\n\nThis method is **unsafe**, but is usually used to initialize the buffer\nby passing it to a C function.\n\n```\nArray.build(3) do |buffer|\n  LibSome.fill_buffer_and_return_number_of_elements_filled(buffer)\nend\n```","summary":"<p>Creates a new <code><a href=\"Array.html\">Array</a></code>, allocating an internal buffer with the given <em>capacity</em>, and yielding that buffer.</p>","abstract":false,"args":[{"name":"capacity","doc":null,"default_value":"","external_name":"capacity","restriction":"Int"}],"args_string":"(capacity : Int, &) : <span class=\"k\">self</span>","args_html":"(capacity : <a href=\"Int.html\">Int</a>, &) : <span class=\"k\">self</span>","location":{"filename":"src/array.cr","line_number":174,"url":null},"def":{"name":"build","args":[{"name":"capacity","doc":null,"default_value":"","external_name":"capacity","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"self","visibility":"Public","body":"ary = Array(T).new(capacity)\nary.size = (yield ary.to_unsafe).to_i\nary\n"}},{"id":"new(size:Int,value:T)-class-method","html_id":"new(size:Int,value:T)-class-method","name":"new","doc":"Creates a new `Array` of the given *size* filled with the same *value* in each position.\n\n```\nArray.new(3, 'a') # => ['a', 'a', 'a']\n\nary = Array.new(3, [1])\nary # => [[1], [1], [1]]\nary[0][0] = 2\nary # => [[2], [2], [2]]\n```","summary":"<p>Creates a new <code><a href=\"Array.html\">Array</a></code> of the given <em>size</em> filled with the same <em>value</em> in each position.</p>","abstract":false,"args":[{"name":"size","doc":null,"default_value":"","external_name":"size","restriction":"Int"},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(size : Int, value : T)","args_html":"(size : <a href=\"Int.html\">Int</a>, value : T)","location":{"filename":"src/array.cr","line_number":128,"url":null},"def":{"name":"new","args":[{"name":"size","doc":null,"default_value":"","external_name":"size","restriction":"Int"},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = Array(T).allocate\n_.initialize(size, value)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(ctx:YAML::ParseContext,node:YAML::Nodes::Node)-class-method","html_id":"new(ctx:YAML::ParseContext,node:YAML::Nodes::Node)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"ctx","doc":null,"default_value":"","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","doc":null,"default_value":"","external_name":"node","restriction":"YAML::Nodes::Node"}],"args_string":"(ctx : YAML::ParseContext, node : YAML::Nodes::Node)","args_html":"(ctx : <a href=\"YAML/ParseContext.html\">YAML::ParseContext</a>, node : <a href=\"YAML/Nodes/Node.html\">YAML::Nodes::Node</a>)","location":{"filename":"src/yaml/from_yaml.cr","line_number":91,"url":null},"def":{"name":"new","args":[{"name":"ctx","doc":null,"default_value":"","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","doc":null,"default_value":"","external_name":"node","restriction":"YAML::Nodes::Node"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ctx.read_alias(node, self) do |obj|\n  return obj\nend\nary = new\nctx.record_anchor(node, ary)\nnew(ctx, node) do |element|\n  ary << element\nend\nary\n"}},{"id":"new(initial_capacity:Int)-class-method","html_id":"new(initial_capacity:Int)-class-method","name":"new","doc":"Creates a new empty `Array` backed by a buffer that is initially\n`initial_capacity` big.\n\nThe *initial_capacity* is useful to avoid unnecessary reallocations\nof the internal buffer in case of growth. If you have an estimate\nof the maximum number of elements an array will hold, the array should\nbe initialized with that capacity for improved performance.\n\n```\nary = Array(Int32).new(5)\nary.size # => 0\n```","summary":"<p>Creates a new empty <code><a href=\"Array.html\">Array</a></code> backed by a buffer that is initially <code>initial_capacity</code> big.</p>","abstract":false,"args":[{"name":"initial_capacity","doc":null,"default_value":"","external_name":"initial_capacity","restriction":"Int"}],"args_string":"(initial_capacity : Int)","args_html":"(initial_capacity : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/array.cr","line_number":104,"url":null},"def":{"name":"new","args":[{"name":"initial_capacity","doc":null,"default_value":"","external_name":"initial_capacity","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = Array(T).allocate\n_.initialize(initial_capacity)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(pull:JSON::PullParser)-class-method","html_id":"new(pull:JSON::PullParser)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"pull","doc":null,"default_value":"","external_name":"pull","restriction":"JSON::PullParser"}],"args_string":"(pull : JSON::PullParser)","args_html":"(pull : <a href=\"JSON/PullParser.html\">JSON::PullParser</a>)","location":{"filename":"src/json/from_json.cr","line_number":143,"url":null},"def":{"name":"new","args":[{"name":"pull","doc":null,"default_value":"","external_name":"pull","restriction":"JSON::PullParser"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ary = new\nnew(pull) do |element|\n  ary << element\nend\nary\n"}},{"id":"new-class-method","html_id":"new-class-method","name":"new","doc":"Creates a new empty `Array`.","summary":"<p>Creates a new empty <code><a href=\"Array.html\">Array</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/array.cr","line_number":86,"url":null},"def":{"name":"new","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = Array(T).allocate\n_.initialize\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(ctx:YAML::ParseContext,node:YAML::Nodes::Node,&)-class-method","html_id":"new(ctx:YAML::ParseContext,node:YAML::Nodes::Node,&)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"ctx","doc":null,"default_value":"","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","doc":null,"default_value":"","external_name":"node","restriction":"YAML::Nodes::Node"}],"args_string":"(ctx : YAML::ParseContext, node : YAML::Nodes::Node, &)","args_html":"(ctx : <a href=\"YAML/ParseContext.html\">YAML::ParseContext</a>, node : <a href=\"YAML/Nodes/Node.html\">YAML::Nodes::Node</a>, &)","location":{"filename":"src/yaml/from_yaml.cr","line_number":106,"url":null},"def":{"name":"new","args":[{"name":"ctx","doc":null,"default_value":"","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","doc":null,"default_value":"","external_name":"node","restriction":"YAML::Nodes::Node"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"if node.is_a?(YAML::Nodes::Sequence)\nelse\n  node.raise(\"Expected sequence, not #{node.class}\")\nend\nnode.each do |value|\n  yield T.new(ctx, value)\nend\n"}},{"id":"new(size:Int,&block:Int32->T)-class-method","html_id":"new(size:Int,&block:Int32->T)-class-method","name":"new","doc":"Creates a new `Array` of the given *size* and invokes the given block once\nfor each index of `self`, assigning the block's value in that index.\n\n```\nArray.new(3) { |i| (i + 1) ** 2 } # => [1, 4, 9]\n\nary = Array.new(3) { [1] }\nary # => [[1], [1], [1]]\nary[0][0] = 2\nary # => [[2], [1], [1]]\n```","summary":"<p>Creates a new <code><a href=\"Array.html\">Array</a></code> of the given <em>size</em> and invokes the given block once for each index of <code>self</code>, assigning the block's value in that index.</p>","abstract":false,"args":[{"name":"size","doc":null,"default_value":"","external_name":"size","restriction":"Int"}],"args_string":"(size : Int, &block : Int32 -> T)","args_html":"(size : <a href=\"Int.html\">Int</a>, &block : <a href=\"Int32.html\">Int32</a> -> T)","location":{"filename":"src/array.cr","line_number":154,"url":null},"def":{"name":"new","args":[{"name":"size","doc":null,"default_value":"","external_name":"size","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":"(Int32 -> T)"},"return_type":"","visibility":"Public","body":"Array(T).build(size) do |buffer|\n  size.to_i.times do |i|\n    buffer[i] = yield i\n  end\n  size\nend"}},{"id":"new(pull:JSON::PullParser,&)-class-method","html_id":"new(pull:JSON::PullParser,&)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"pull","doc":null,"default_value":"","external_name":"pull","restriction":"JSON::PullParser"}],"args_string":"(pull : JSON::PullParser, &)","args_html":"(pull : <a href=\"JSON/PullParser.html\">JSON::PullParser</a>, &)","location":{"filename":"src/json/from_json.cr","line_number":151,"url":null},"def":{"name":"new","args":[{"name":"pull","doc":null,"default_value":"","external_name":"pull","restriction":"JSON::PullParser"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"pull.read_array do\n  yield T.new(pull)\nend"}}],"instance_methods":[{"id":"&(other:Array(U))forallU-instance-method","html_id":"&(other:Array(U))forallU-instance-method","name":"&","doc":"Set intersection: returns a new `Array` containing elements common to `self`\nand *other*, excluding any duplicates. The order is preserved from `self`.\n\n```\n[1, 1, 3, 5] & [1, 2, 3]               # => [ 1, 3 ]\n['a', 'b', 'b', 'z'] & ['a', 'b', 'c'] # => [ 'a', 'b' ]\n```\n\nSee also: `#uniq`.","summary":"<p>Set intersection: returns a new <code><a href=\"Array.html\">Array</a></code> containing elements common to <code>self</code> and <em>other</em>, excluding any duplicates.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array(U)"}],"args_string":"(other : Array(U)) forall U","args_html":"(other : <a href=\"Array.html\">Array</a>(U)) forall U","location":{"filename":"src/array.cr","line_number":248,"url":null},"def":{"name":"&","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array(U)"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if self.empty? || other.empty?\n  return Array(T).new\nend\nif (self.size + other.size) <= (SMALL_ARRAY_SIZE * 2)\n  ary = Array(T).new\n  each do |elem|\n    if (!(ary.includes?(elem))) && (other.includes?(elem))\n      ary << elem\n    end\n  end\n  return ary\nend\nhash = other.to_lookup_hash\nhash_size = hash.size\nArray(T).build(Math.min(size, other.size)) do |buffer|\n  i = 0\n  each do |obj|\n    hash.delete(obj)\n    new_hash_size = hash.size\n    if hash_size != new_hash_size\n      hash_size = new_hash_size\n      buffer[i] = obj\n      i = i + 1\n    end\n  end\n  i\nend\n"}},{"id":"*(times:Int)-instance-method","html_id":"*(times:Int)-instance-method","name":"*","doc":"Repetition: Returns a new `Array` built by concatenating *times* copies of `self`.\n\n```\n[\"a\", \"b\", \"c\"] * 2 # => [ \"a\", \"b\", \"c\", \"a\", \"b\", \"c\" ]\n```","summary":"<p>Repetition: Returns a new <code><a href=\"Array.html\">Array</a></code> built by concatenating <em>times</em> copies of <code>self</code>.</p>","abstract":false,"args":[{"name":"times","doc":null,"default_value":"","external_name":"times","restriction":"Int"}],"args_string":"(times : Int)","args_html":"(times : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/array.cr","line_number":374,"url":null},"def":{"name":"*","args":[{"name":"times","doc":null,"default_value":"","external_name":"times","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if (times == 0) || empty?\n  return Array(T).new\nend\nif times == 1\n  return dup\nend\nif size == 1\n  return Array(T).new(times, first)\nend\nnew_size = size * times\nArray(T).build(new_size) do |buffer|\n  buffer.copy_from(to_unsafe, size)\n  n = size\n  while n <= (new_size // 2)\n    (buffer + n).copy_from(buffer, n)\n    n = n * 2\n  end\n  (buffer + n).copy_from(buffer, new_size - n)\n  new_size\nend\n"}},{"id":"+(other:Array(U))forallU-instance-method","html_id":"+(other:Array(U))forallU-instance-method","name":"+","doc":"Concatenation. Returns a new `Array` built by concatenating `self` and *other*.\nThe type of the new array is the union of the types of both the original arrays.\n\n```\n[1, 2] + [\"a\"]  # => [1,2,\"a\"] of (Int32 | String)\n[1, 2] + [2, 3] # => [1,2,2,3]\n```","summary":"<p>Concatenation.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array(U)"}],"args_string":"(other : Array(U)) forall U","args_html":"(other : <a href=\"Array.html\">Array</a>(U)) forall U","location":{"filename":"src/array.cr","line_number":328,"url":null},"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array(U)"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"new_size = size + other.size\nArray(T | U).build(new_size) do |buffer|\n  buffer.copy_from(@buffer, size)\n  (buffer + size).copy_from(other.to_unsafe, other.size)\n  new_size\nend\n"}},{"id":"-(other:Array(U))forallU-instance-method","html_id":"-(other:Array(U))forallU-instance-method","name":"-","doc":"Difference. Returns a new `Array` that is a copy of `self`, removing any items\nthat appear in *other*. The order of `self` is preserved.\n\n```\n[1, 2, 3] - [2, 1] # => [3]\n```","summary":"<p>Difference.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array(U)"}],"args_string":"(other : Array(U)) forall U","args_html":"(other : <a href=\"Array.html\">Array</a>(U)) forall U","location":{"filename":"src/array.cr","line_number":350,"url":null},"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array(U)"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if size <= SMALL_ARRAY_SIZE || other.size <= SMALL_ARRAY_SIZE\n  ary = Array(T).new\n  each do |elem|\n    if other.includes?(elem)\n    else\n      ary << elem\n    end\n  end\n  return ary\nend\nary = Array(T).new(Math.max(size - other.size, 0))\nhash = other.to_lookup_hash\neach do |obj|\n  if hash.has_key?(obj)\n  else\n    ary << obj\n  end\nend\nary\n"}},{"id":"<<(value:T)-instance-method","html_id":"<<(value:T)-instance-method","name":"<<","doc":"Append. Alias for `push`.\n\n```\na = [1, 2]\na << 3 # => [1,2,3]\n```","summary":"<p>Append.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","args_html":"(value : T)","location":{"filename":"src/array.cr","line_number":408,"url":null},"def":{"name":"<<","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"push(value)"}},{"id":"(other:Array)-instance-method","html_id":"(other:Array)-instance-method","name":"<=>","doc":"Combined comparison operator.\n\nReturns `-1`, `0` or `1` depending on whether `self` is less than *other*, equals *other*\nor is greater than *other*.\n\nIt compares the elements of both arrays in the same position using the\n`<=>` operator. As soon as one of such comparisons returns a non-zero\nvalue, that result is the return value of the comparison.\n\nIf all elements are equal, the comparison is based on the size of the arrays.\n\n```\n[8] <=> [1, 2, 3] # => 1\n[2] <=> [4, 2, 3] # => -1\n[1, 2] <=> [1, 2] # => 0\n```","summary":"<p>Combined comparison operator.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array"}],"args_string":"(other : Array)","args_html":"(other : <a href=\"Array.html\">Array</a>)","location":{"filename":"src/array.cr","line_number":230,"url":null},"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"min_size = Math.min(size, other.size)\n0.upto(min_size - 1) do |i|\n  n = @buffer[i] <=> other.to_unsafe[i]\n  if n != 0\n    return n\n  end\nend\nsize <=> other.size\n"}},{"id":"==(other:Array)-instance-method","html_id":"==(other:Array)-instance-method","name":"==","doc":"Equality. Returns `true` if each element in `self` is equal to each\ncorresponding element in *other*.\n\n```\nary = [1, 2, 3]\nary == [1, 2, 3] # => true\nary == [2, 3]    # => false\n```","summary":"<p>Equality.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array"}],"args_string":"(other : Array)","args_html":"(other : <a href=\"Array.html\">Array</a>)","location":{"filename":"src/array.cr","line_number":205,"url":null},"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"equals?(other) do |x, y|\n  x == y\nend"}},{"id":"==(other:JSON::Any)-instance-method","html_id":"==(other:JSON::Any)-instance-method","name":"==","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"JSON::Any"}],"args_string":"(other : JSON::Any)","args_html":"(other : <a href=\"JSON/Any.html\">JSON::Any</a>)","location":{"filename":"src/json/any.cr","line_number":315,"url":null},"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"JSON::Any"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == other.raw"}},{"id":"==(other:YAML::Any)-instance-method","html_id":"==(other:YAML::Any)-instance-method","name":"==","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"YAML::Any"}],"args_string":"(other : YAML::Any)","args_html":"(other : <a href=\"YAML/Any.html\">YAML::Any</a>)","location":{"filename":"src/yaml/any.cr","line_number":363,"url":null},"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"YAML::Any"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == other.raw"}},{"id":"[](range:Range)-instance-method","html_id":"[](range:Range)-instance-method","name":"[]","doc":"Returns all elements that are within the given range.\n\nNegative indices count backward from the end of the array (-1 is the last\nelement). Additionally, an empty array is returned when the starting index\nfor an element range is at the end of the array.\n\nRaises `IndexError` if the range's start is out of range.\n\n```\na = [\"a\", \"b\", \"c\", \"d\", \"e\"]\na[1..3]    # => [\"b\", \"c\", \"d\"]\na[4..7]    # => [\"e\"]\na[6..10]   # raise IndexError\na[5..10]   # => []\na[-2...-1] # => [\"d\"]\na[2..]     # => [\"c\", \"d\", \"e\"]\n```","summary":"<p>Returns all elements that are within the given range.</p>","abstract":false,"args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"args_string":"(range : Range)","args_html":"(range : <a href=\"Range.html\">Range</a>)","location":{"filename":"src/array.cr","line_number":606,"url":null},"def":{"name":"[]","args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self[*(Indexable.range_to_index_and_count(range, size)) || (raise(IndexError.new))]"}},{"id":"[](start:Int,count:Int)-instance-method","html_id":"[](start:Int,count:Int)-instance-method","name":"[]","doc":"Returns count or less (if there aren't enough) elements starting at the\ngiven start index.\n\nNegative indices count backward from the end of the array (-1 is the last\nelement). Additionally, an empty array is returned when the starting index\nfor an element range is at the end of the array.\n\nRaises `IndexError` if the *start* index is out of range.\n\nRaises `ArgumentError` if *count* is negative.\n\n```\na = [\"a\", \"b\", \"c\", \"d\", \"e\"]\na[-3, 3] # => [\"c\", \"d\", \"e\"]\na[1, 2]  # => [\"b\", \"c\"]\na[5, 1]  # => []\na[6, 1]  # raises IndexError\n```","summary":"<p>Returns count or less (if there aren't enough) elements starting at the given start index.</p>","abstract":false,"args":[{"name":"start","doc":null,"default_value":"","external_name":"start","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"args_string":"(start : Int, count : Int)","args_html":"(start : <a href=\"Int.html\">Int</a>, count : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/array.cr","line_number":639,"url":null},"def":{"name":"[]","args":[{"name":"start","doc":null,"default_value":"","external_name":"start","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self[start, count]? || (raise(IndexError.new))"}},{"id":"[]=(range:Range,values:Array(T))-instance-method","html_id":"[]=(range:Range,values:Array(T))-instance-method","name":"[]=","doc":"Replaces a subrange with the elements of the given array.\n\n```\na = [1, 2, 3, 4, 5]\na[1..3] = [6, 7, 8]\na # => [1, 6, 7, 8, 5]\n\na = [1, 2, 3, 4, 5]\na[1..3] = [6, 7]\na # => [1, 6, 7, 5]\n\na = [1, 2, 3, 4, 5]\na[1..3] = [6, 7, 8, 9, 10]\na # => [1, 6, 7, 8, 9, 10, 5]\n\na = [1, 2, 3, 4, 5]\na[2..] = [6, 7, 8, 9, 10]\na # => [1, 2, 6, 7, 8, 9, 10]\n```","summary":"<p>Replaces a subrange with the elements of the given array.</p>","abstract":false,"args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"},{"name":"values","doc":null,"default_value":"","external_name":"values","restriction":"Array(T)"}],"args_string":"(range : Range, values : Array(T))","args_html":"(range : <a href=\"Range.html\">Range</a>, values : <a href=\"Array.html\">Array</a>(T))","location":{"filename":"src/array.cr","line_number":585,"url":null},"def":{"name":"[]=","args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"},{"name":"values","doc":null,"default_value":"","external_name":"values","restriction":"Array(T)"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self[*(Indexable.range_to_index_and_count(range, size)) || (raise(IndexError.new))] = values"}},{"id":"[]=(range:Range,value:T)-instance-method","html_id":"[]=(range:Range,value:T)-instance-method","name":"[]=","doc":"Replaces a subrange with a single value.\n\n```\na = [1, 2, 3, 4, 5]\na[1..3] = 6\na # => [1, 6, 5]\n\na = [1, 2, 3, 4, 5]\na[1...1] = 6\na # => [1, 6, 2, 3, 4, 5]\n\na = [1, 2, 3, 4, 5]\na[2...] = 6\na # => [1, 2, 6]\n```","summary":"<p>Replaces a subrange with a single value.</p>","abstract":false,"args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(range : Range, value : T)","args_html":"(range : <a href=\"Range.html\">Range</a>, value : T)","location":{"filename":"src/array.cr","line_number":513,"url":null},"def":{"name":"[]=","args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self[*(Indexable.range_to_index_and_count(range, size)) || (raise(IndexError.new))] = value"}},{"id":"[]=(index:Int,value:T)-instance-method","html_id":"[]=(index:Int,value:T)-instance-method","name":"[]=","doc":"Sets the given value at the given index.\n\nNegative indices can be used to start counting from the end of the array.\nRaises `IndexError` if trying to set an element outside the array's range.\n\n```\nary = [1, 2, 3]\nary[0] = 5\np ary # => [5,2,3]\n\nary[3] = 5 # raises IndexError\n```","summary":"<p>Sets the given value at the given index.</p>","abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(index : Int, value : T)","args_html":"(index : <a href=\"Int.html\">Int</a>, value : T)","location":{"filename":"src/array.cr","line_number":425,"url":null},"def":{"name":"[]=","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"index = check_index_out_of_bounds(index)\n@buffer[index] = value\n"}},{"id":"[]=(index:Int,count:Int,value:T)-instance-method","html_id":"[]=(index:Int,count:Int,value:T)-instance-method","name":"[]=","doc":"Replaces a subrange with a single value. All elements in the range\n`index...index+count` are removed and replaced by a single element\n*value*.\n\nIf *count* is zero, *value* is inserted at *index*.\n\nNegative values of *index* count from the end of the array.\n\n```\na = [1, 2, 3, 4, 5]\na[1, 3] = 6\na # => [1, 6, 5]\n\na = [1, 2, 3, 4, 5]\na[1, 0] = 6\na # => [1, 6, 2, 3, 4, 5]\n```","summary":"<p>Replaces a subrange with a single value.</p>","abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(index : Int, count : Int, value : T)","args_html":"(index : <a href=\"Int.html\">Int</a>, count : <a href=\"Int.html\">Int</a>, value : T)","location":{"filename":"src/array.cr","line_number":447,"url":null},"def":{"name":"[]=","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if count < 0\n  raise(ArgumentError.new(\"Negative count: #{count}\"))\nend\nif index < 0\n  index = index + size\nend\nif 0 <= index && index <= size\nelse\n  raise(IndexError.new)\nend\ncount = (index + count) <= size ? count : size - index\ncase count\nwhen 0\n  insert(index, value)\nwhen 1\n  @buffer[index] = value\nelse\n  diff = count - 1\n  if index == 0\n    @buffer.clear(diff)\n    shift_buffer_by(diff)\n    @buffer.value = value\n  else\n    ((@buffer + index) + 1).move_from((@buffer + index) + count, (size - index) - count)\n    ((@buffer + @size) - diff).clear(diff)\n    @buffer[index] = value\n  end\n  @size = @size - diff\nend\nvalue\n"}},{"id":"[]=(index:Int,count:Int,values:Array(T))-instance-method","html_id":"[]=(index:Int,count:Int,values:Array(T))-instance-method","name":"[]=","doc":"Replaces a subrange with the elements of the given array.\n\n```\na = [1, 2, 3, 4, 5]\na[1, 3] = [6, 7, 8]\na # => [1, 6, 7, 8, 5]\n\na = [1, 2, 3, 4, 5]\na[1, 3] = [6, 7]\na # => [1, 6, 7, 5]\n\na = [1, 2, 3, 4, 5]\na[1, 3] = [6, 7, 8, 9, 10]\na # => [1, 6, 7, 8, 9, 10, 5]\n```","summary":"<p>Replaces a subrange with the elements of the given array.</p>","abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"},{"name":"values","doc":null,"default_value":"","external_name":"values","restriction":"Array(T)"}],"args_string":"(index : Int, count : Int, values : Array(T))","args_html":"(index : <a href=\"Int.html\">Int</a>, count : <a href=\"Int.html\">Int</a>, values : <a href=\"Array.html\">Array</a>(T))","location":{"filename":"src/array.cr","line_number":532,"url":null},"def":{"name":"[]=","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"},{"name":"values","doc":null,"default_value":"","external_name":"values","restriction":"Array(T)"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if count < 0\n  raise(ArgumentError.new(\"Negative count: #{count}\"))\nend\nif index < 0\n  index = index + size\nend\nif 0 <= index && index <= size\nelse\n  raise(IndexError.new)\nend\ncount = (index + count) <= size ? count : size - index\ndiff = values.size - count\nif diff == 0\n  (@buffer + index).copy_from(values.to_unsafe, values.size)\nelse\n  if diff < 0\n    diff = -diff\n    (@buffer + index).copy_from(values.to_unsafe, values.size)\n    ((@buffer + index) + values.size).move_from((@buffer + index) + count, (size - index) - count)\n    ((@buffer + @size) - diff).clear(diff)\n    @size = @size - diff\n  else\n    resize_to_capacity(Math.pw2ceil(@size + diff))\n    ((@buffer + index) + values.size).move_from((@buffer + index) + count, (size - index) - count)\n    (@buffer + index).copy_from(values.to_unsafe, values.size)\n    @size = @size + diff\n  end\nend\nvalues\n"}},{"id":"[]?(start:Int,count:Int)-instance-method","html_id":"[]?(start:Int,count:Int)-instance-method","name":"[]?","doc":"Like `#[Int, Int]` but returns `nil` if the *start* index is out of range.","summary":"<p>Like <code>#[Int, <a href=\"Int.html\">Int</a>]</code> but returns <code>nil</code> if the <em>start</em> index is out of range.</p>","abstract":false,"args":[{"name":"start","doc":null,"default_value":"","external_name":"start","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"args_string":"(start : Int, count : Int)","args_html":"(start : <a href=\"Int.html\">Int</a>, count : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/array.cr","line_number":644,"url":null},"def":{"name":"[]?","args":[{"name":"start","doc":null,"default_value":"","external_name":"start","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if count < 0\n  raise(ArgumentError.new(\"Negative count: #{count}\"))\nend\nif start == size\n  return Array(T).new\nend\nif start < 0\n  start = start + size\nend\nif 0 <= start && start <= size\n  if count == 0\n    return Array(T).new\n  end\n  count = Math.min(count, size - start)\n  Array(T).build(count) do |buffer|\n    buffer.copy_from(@buffer + start, count)\n    count\n  end\nend\n"}},{"id":"[]?(range:Range)-instance-method","html_id":"[]?(range:Range)-instance-method","name":"[]?","doc":"Like `#[Range]`, but returns `nil` if the range's start is out of range.\n\n```\na = [\"a\", \"b\", \"c\", \"d\", \"e\"]\na[6..10]? # => nil\na[6..]?   # => nil\n```","summary":"<p>Like <code>#[Range]</code>, but returns <code>nil</code> if the range's start is out of range.</p>","abstract":false,"args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"args_string":"(range : Range)","args_html":"(range : <a href=\"Range.html\">Range</a>)","location":{"filename":"src/array.cr","line_number":617,"url":null},"def":{"name":"[]?","args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self[*(Indexable.range_to_index_and_count(range, size)) || (return nil)]?"}},{"id":"clear-instance-method","html_id":"clear-instance-method","name":"clear","doc":"Removes all elements from self.\n\n```\na = [\"a\", \"b\", \"c\", \"d\", \"e\"]\na.clear # => []\n```","summary":"<p>Removes all elements from self.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/array.cr","line_number":673,"url":null},"def":{"name":"clear","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@buffer.clear(@size)\n@size = 0\nself\n"}},{"id":"clone-instance-method","html_id":"clone-instance-method","name":"clone","doc":"Returns a new `Array` that has `self`'s elements cloned.\nThat is, it returns a deep copy of `self`.\n\nUse `#dup` if you want a shallow copy.\n\n```\nary = [[1, 2], [3, 4]]\nary2 = ary.clone\nary[0][0] = 5\nary  # => [[5, 2], [3, 4]]\nary2 # => [[1, 2], [3, 4]]\n\nary2 << [7, 8]\nary  # => [[5, 2], [3, 4]]\nary2 # => [[1, 2], [3, 4], [7, 8]]\n```","summary":"<p>Returns a new <code><a href=\"Array.html\">Array</a></code> that has <code>self</code>'s elements cloned.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/array.cr","line_number":695,"url":null},"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% if ((((T == ::Bool) || (T == ::Char)) || (T == ::String)) || (T == ::Symbol)) || T < ::Number::Primitive %}\n      Array(T).new(size) { |i| @buffer[i].clone.as(T) }\n    {% else %}\n      exec_recursive_clone do |hash|\n        clone = Array(T).new(size)\n        hash[object_id] = clone.object_id\n        each do |element|\n          clone << element.clone.as(T)\n        end\n        clone\n      end\n    {% end %}"}},{"id":"compact-instance-method","html_id":"compact-instance-method","name":"compact","doc":"Returns a copy of `self` with all `nil` elements removed.\n\n```\n[\"a\", nil, \"b\", nil, \"c\", nil].compact # => [\"a\", \"b\", \"c\"]\n```","summary":"<p>Returns a copy of <code>self</code> with all <code>nil</code> elements removed.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/array.cr","line_number":715,"url":null},"def":{"name":"compact","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"compact_map(&.itself)"}},{"id":"compact!-instance-method","html_id":"compact!-instance-method","name":"compact!","doc":"Removes all `nil` elements from `self` and returns `self`.\n\n```\nary = [\"a\", nil, \"b\", nil, \"c\"]\nary.compact!\nary # => [\"a\", \"b\", \"c\"]\n```","summary":"<p>Removes all <code>nil</code> elements from <code>self</code> and returns <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/array.cr","line_number":726,"url":null},"def":{"name":"compact!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"reject! do |__arg1|\n  __arg1.nil?\nend"}},{"id":"concat(other:Array)-instance-method","html_id":"concat(other:Array)-instance-method","name":"concat","doc":"Appends the elements of *other* to `self`, and returns `self`.\n\n```\nary = [\"a\", \"b\"]\nary.concat([\"c\", \"d\"])\nary # => [\"a\", \"b\", \"c\", \"d\"]\n```","summary":"<p>Appends the elements of <em>other</em> to <code>self</code>, and returns <code>self</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array"}],"args_string":"(other : Array)","args_html":"(other : <a href=\"Array.html\">Array</a>)","location":{"filename":"src/array.cr","line_number":737,"url":null},"def":{"name":"concat","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"other_size = other.size\nresize_if_cant_insert(other_size)\n(@buffer + @size).copy_from(other.to_unsafe, other_size)\n@size = @size + other_size\nself\n"}},{"id":"concat(other:Enumerable)-instance-method","html_id":"concat(other:Enumerable)-instance-method","name":"concat","doc":"Appends the elements of *other* to `self`, and returns `self`.\n\n```\nary = [\"a\", \"b\"]\nary.concat([\"c\", \"d\"])\nary # => [\"a\", \"b\", \"c\", \"d\"]\n```","summary":"<p>Appends the elements of <em>other</em> to <code>self</code>, and returns <code>self</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Enumerable"}],"args_string":"(other : Enumerable)","args_html":"(other : <a href=\"Enumerable.html\">Enumerable</a>)","location":{"filename":"src/array.cr","line_number":750,"url":null},"def":{"name":"concat","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Enumerable"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"left_before_resize = remaining_capacity - @size\nlen = @size\nbuf = @buffer + len\nother.each do |elem|\n  if left_before_resize == 0\n    double_capacity\n    left_before_resize = remaining_capacity - len\n    buf = @buffer + len\n  end\n  buf.value = elem\n  buf = buf + 1\n  len = len + 1\n  left_before_resize = left_before_resize - 1\nend\n@size = len\nself\n"}},{"id":"delete(obj)-instance-method","html_id":"delete(obj)-instance-method","name":"delete","doc":"Removes all items from `self` that are equal to *obj*.\n\nReturns the last found element that was equal to *obj*,\nif any, or `nil` if not found.\n\n```\na = [\"a\", \"b\", \"b\", \"b\", \"c\"]\na.delete(\"b\") # => \"b\"\na             # => [\"a\", \"c\"]\n\na.delete(\"x\") # => nil\na             # => [\"a\", \"c\"]\n```","summary":"<p>Removes all items from <code>self</code> that are equal to <em>obj</em>.</p>","abstract":false,"args":[{"name":"obj","doc":null,"default_value":"","external_name":"obj","restriction":""}],"args_string":"(obj)","args_html":"(obj)","location":{"filename":"src/array.cr","line_number":784,"url":null},"def":{"name":"delete","args":[{"name":"obj","doc":null,"default_value":"","external_name":"obj","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"internal_delete do |e|\n  e == obj\nend[1]"}},{"id":"delete_at(range:Range)-instance-method","html_id":"delete_at(range:Range)-instance-method","name":"delete_at","doc":"Removes all elements within the given *range*.\nReturns an array of the removed elements with the original order of `self` preserved.\nRaises `IndexError` if the index is out of range.\n\n```\na = [\"ant\", \"bat\", \"cat\", \"dog\"]\na.delete_at(1..2)    # => [\"bat\", \"cat\"]\na                    # => [\"ant\", \"dog\"]\na.delete_at(99..100) # raises IndexError\n```","summary":"<p>Removes all elements within the given <em>range</em>.</p>","abstract":false,"args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"args_string":"(range : Range)","args_html":"(range : <a href=\"Range.html\">Range</a>)","location":{"filename":"src/array.cr","line_number":822,"url":null},"def":{"name":"delete_at","args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"index, count = (Indexable.range_to_index_and_count(range, self.size)) || (raise(IndexError.new))\ndelete_at(index, count)\n"}},{"id":"delete_at(index:Int)-instance-method","html_id":"delete_at(index:Int)-instance-method","name":"delete_at","doc":"Removes the element at *index*, returning that element.\nRaises `IndexError` if *index* is out of range.\n\n```\na = [\"ant\", \"bat\", \"cat\", \"dog\"]\na.delete_at(2)  # => \"cat\"\na               # => [\"ant\", \"bat\", \"dog\"]\na.delete_at(99) # raises IndexError\n```","summary":"<p>Removes the element at <em>index</em>, returning that element.</p>","abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"}],"args_string":"(index : Int)","args_html":"(index : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/array.cr","line_number":797,"url":null},"def":{"name":"delete_at","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"index = check_index_out_of_bounds(index)\nif index == 0\n  return shift_when_not_empty\nend\nelem = @buffer[index]\n(@buffer + index).move_from((@buffer + index) + 1, (size - index) - 1)\n@size = @size - 1\n(@buffer + @size).clear\nelem\n"}},{"id":"delete_at(index:Int,count:Int)-instance-method","html_id":"delete_at(index:Int,count:Int)-instance-method","name":"delete_at","doc":"Removes *count* elements from `self` starting at *index*.\nIf the size of `self` is less than *count*, removes values to the end of the array without error.\nReturns an array of the removed elements with the original order of `self` preserved.\nRaises `IndexError` if *index* is out of range.\n\n```\na = [\"ant\", \"bat\", \"cat\", \"dog\"]\na.delete_at(1, 2)  # => [\"bat\", \"cat\"]\na                  # => [\"ant\", \"dog\"]\na.delete_at(99, 1) # raises IndexError\n```","summary":"<p>Removes <em>count</em> elements from <code>self</code> starting at <em>index</em>.</p>","abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"args_string":"(index : Int, count : Int)","args_html":"(index : <a href=\"Int.html\">Int</a>, count : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/array.cr","line_number":838,"url":null},"def":{"name":"delete_at","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if index < 0\n  index = index + size\nend\nif 0 <= index && index <= size\nelse\n  raise(IndexError.new)\nend\nval = self[index, count]\ncount = (index + count) <= size ? count : size - index\n(@buffer + index).move_from((@buffer + index) + count, (size - index) - count)\n@size = @size - count\n(@buffer + @size).clear(count)\nval\n"}},{"id":"dup-instance-method","html_id":"dup-instance-method","name":"dup","doc":"Returns a new `Array` that has exactly `self`'s elements.\nThat is, it returns a shallow copy of `self`.\n\nUse `#clone` if you want a deep copy.\n\n```\nary = [[1, 2], [3, 4]]\nary2 = ary.dup\nary[0][0] = 5\nary  # => [[5, 2], [3, 4]]\nary2 # => [[5, 2], [3, 4]]\n\nary2 << [7, 8]\nary  # => [[5, 2], [3, 4]]\nary2 # => [[5, 2], [3, 4], [7, 8]]\n```","summary":"<p>Returns a new <code><a href=\"Array.html\">Array</a></code> that has exactly <code>self</code>'s elements.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/array.cr","line_number":868,"url":null},"def":{"name":"dup","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Array(T).build(@size) do |buffer|\n  buffer.copy_from(@buffer, size)\n  size\nend"}},{"id":"each_repeated_permutation(size:Int=self.size,reuse=false,&):Nil-instance-method","html_id":"each_repeated_permutation(size:Int=self.size,reuse=false,&):Nil-instance-method","name":"each_repeated_permutation","doc":null,"summary":null,"abstract":false,"args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"args_string":"(size : Int = <span class=\"k\">self</span>.size, reuse = <span class=\"n\">false</span>, &) : Nil","args_html":"(size : <a href=\"Int.html\">Int</a> = <span class=\"k\">self</span>.size, reuse = <span class=\"n\">false</span>, &) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/array.cr","line_number":1326,"url":null},"def":{"name":"each_repeated_permutation","args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"},{"name":"reuse","doc":null,"default_value":"false","external_name":"reuse","restriction":""}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"n = self.size\nif (size != 0) && (n == 0)\n  return\nend\nif size < 0\n  raise(ArgumentError.new(\"Size must be positive\"))\nend\nif size == 0\n  yield [] of T\nelse\n  Array.each_product(Array.new(size, self), reuse: reuse) do |r|\n    yield r\n  end\nend\n"}},{"id":"fill(value:T,from:Int,count:Int)-instance-method","html_id":"fill(value:T,from:Int,count:Int)-instance-method","name":"fill","doc":"Replaces every element in `self`, starting at *from* and only *count* times,\nwith the given *value*. Returns `self`.\n\nNegative values of *from* count from the end of the array.\n\n```\na = [1, 2, 3, 4, 5]\na.fill(9, 2, 2) # => [1, 2, 9, 9, 5]\n```","summary":"<p>Replaces every element in <code>self</code>, starting at <em>from</em> and only <em>count</em> times, with the given <em>value</em>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"},{"name":"from","doc":null,"default_value":"","external_name":"from","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"args_string":"(value : T, from : Int, count : Int)","args_html":"(value : T, from : <a href=\"Int.html\">Int</a>, count : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/array.cr","line_number":999,"url":null},"def":{"name":"fill","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"},{"name":"from","doc":null,"default_value":"","external_name":"from","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% if (Int::Primitive.union_types.includes?(T)) || (Float::Primitive.union_types.includes?(T)) %}\n      if value == 0\n        return self if count <= 0\n\n        from += size if from < 0\n\n        raise IndexError.new unless 0 <= from < size && from + count <= size\n\n        (to_unsafe + from).clear(count)\n\n        self\n      else\n        fill(from, count) { value }\n      end\n    {% else %}\n      fill(from, count) { value }\n    {% end %}"}},{"id":"fill(value:T)-instance-method","html_id":"fill(value:T)-instance-method","name":"fill","doc":"Replaces every element in `self` with the given *value*. Returns `self`.\n\n```\na = [1, 2, 3]\na.fill(9) # => [9, 9, 9]\n```","summary":"<p>Replaces every element in <code>self</code> with the given <em>value</em>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","args_html":"(value : T)","location":{"filename":"src/array.cr","line_number":953,"url":null},"def":{"name":"fill","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% if (Int::Primitive.union_types.includes?(T)) || (Float::Primitive.union_types.includes?(T)) %}\n      if value == 0\n        to_unsafe.clear(size)\n        return self\n      end\n    {% end %}\nfill do\n  value\nend\n"}},{"id":"fill(value:T,range:Range)-instance-method","html_id":"fill(value:T,range:Range)-instance-method","name":"fill","doc":"Replaces every element in *range* with *value*. Returns `self`.\n\nNegative values of *from* count from the end of the array.\n\n```\na = [1, 2, 3, 4, 5]\na.fill(9, 2..3) # => [1, 2, 9, 9, 5]\n```","summary":"<p>Replaces every element in <em>range</em> with <em>value</em>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"},{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"args_string":"(value : T, range : Range)","args_html":"(value : T, range : <a href=\"Range.html\">Range</a>)","location":{"filename":"src/array.cr","line_number":1027,"url":null},"def":{"name":"fill","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"},{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% if (Int::Primitive.union_types.includes?(T)) || (Float::Primitive.union_types.includes?(T)) %}\n      if value == 0\n        fill(value, *Indexable.range_to_index_and_count(range, size) || raise IndexError.new)\n\n        self\n      else\n        fill(range) { value }\n      end\n    {% else %}\n      fill(range) { value }\n    {% end %}"}},{"id":"fill(value:T,from:Int)-instance-method","html_id":"fill(value:T,from:Int)-instance-method","name":"fill","doc":"Replaces every element in `self`, starting at *from*, with the given *value*. Returns `self`.\n\nNegative values of *from* count from the end of the array.\n\n```\na = [1, 2, 3, 4, 5]\na.fill(9, 2) # => [1, 2, 9, 9, 9]\n```","summary":"<p>Replaces every element in <code>self</code>, starting at <em>from</em>, with the given <em>value</em>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"},{"name":"from","doc":null,"default_value":"","external_name":"from","restriction":"Int"}],"args_string":"(value : T, from : Int)","args_html":"(value : T, from : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/array.cr","line_number":972,"url":null},"def":{"name":"fill","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"},{"name":"from","doc":null,"default_value":"","external_name":"from","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% if (Int::Primitive.union_types.includes?(T)) || (Float::Primitive.union_types.includes?(T)) %}\n      if value == 0\n        from += size if from < 0\n\n        raise IndexError.new unless 0 <= from < size\n\n        (to_unsafe + from).clear(size - from)\n\n        self\n      else\n        fill(from) { value }\n      end\n    {% else %}\n      fill(from) { value }\n    {% end %}"}},{"id":"fill(&)-instance-method","html_id":"fill(&)-instance-method","name":"fill","doc":"Yields each index of `self` to the given block and then assigns\nthe block's value in that position. Returns `self`.\n\n```\na = [1, 2, 3, 4]\na.fill { |i| i * i } # => [0, 1, 4, 9]\n```","summary":"<p>Yields each index of <code>self</code> to the given block and then assigns the block's value in that position.</p>","abstract":false,"args":[],"args_string":"(&)","args_html":"(&)","location":{"filename":"src/array.cr","line_number":882,"url":null},"def":{"name":"fill","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"each_index do |i|\n  @buffer[i] = yield i\nend\nself\n"}},{"id":"fill(range:Range,&)-instance-method","html_id":"fill(range:Range,&)-instance-method","name":"fill","doc":"Yields each index of `self`, in the given *range*, to the given block and then assigns\nthe block's value in that position. Returns `self`.\n\n```\na = [1, 2, 3, 4, 5, 6]\na.fill(2..3) { |i| i * i } # => [1, 2, 4, 9, 5, 6]\n```","summary":"<p>Yields each index of <code>self</code>, in the given <em>range</em>, to the given block and then assigns the block's value in that position.</p>","abstract":false,"args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"args_string":"(range : Range, &)","args_html":"(range : <a href=\"Range.html\">Range</a>, &)","location":{"filename":"src/array.cr","line_number":941,"url":null},"def":{"name":"fill","args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"fill(*(Indexable.range_to_index_and_count(range, size)) || (raise(IndexError.new))) do |i|\n  yield i\nend"}},{"id":"fill(from:Int,&)-instance-method","html_id":"fill(from:Int,&)-instance-method","name":"fill","doc":"Yields each index of `self`, starting at *from*, to the given block and then assigns\nthe block's value in that position. Returns `self`.\n\nNegative values of *from* count from the end of the array.\n\nRaises `IndexError` if *from* is outside the array range.\n\n```\na = [1, 2, 3, 4]\na.fill(2) { |i| i * i } # => [1, 2, 4, 9]\n```","summary":"<p>Yields each index of <code>self</code>, starting at <em>from</em>, to the given block and then assigns the block's value in that position.</p>","abstract":false,"args":[{"name":"from","doc":null,"default_value":"","external_name":"from","restriction":"Int"}],"args_string":"(from : Int, &)","args_html":"(from : <a href=\"Int.html\">Int</a>, &)","location":{"filename":"src/array.cr","line_number":899,"url":null},"def":{"name":"fill","args":[{"name":"from","doc":null,"default_value":"","external_name":"from","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"if from < 0\n  from = from + size\nend\nif 0 <= from && from < size\nelse\n  raise(IndexError.new)\nend\nfrom.upto(size - 1) do |i|\n  @buffer[i] = yield i\nend\nself\n"}},{"id":"fill(from:Int,count:Int,&)-instance-method","html_id":"fill(from:Int,count:Int,&)-instance-method","name":"fill","doc":"Yields each index of `self`, starting at *from* and just *count* times,\nto the given block and then assigns the block's value in that position. Returns `self`.\n\nNegative values of *from* count from the end of the array.\n\nRaises `IndexError` if *from* is outside the array range.\n\nHas no effect if *count* is zero or negative.\n\n```\na = [1, 2, 3, 4, 5, 6]\na.fill(2, 2) { |i| i * i } # => [1, 2, 4, 9, 5, 6]\n```","summary":"<p>Yields each index of <code>self</code>, starting at <em>from</em> and just <em>count</em> times, to the given block and then assigns the block's value in that position.</p>","abstract":false,"args":[{"name":"from","doc":null,"default_value":"","external_name":"from","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"args_string":"(from : Int, count : Int, &)","args_html":"(from : <a href=\"Int.html\">Int</a>, count : <a href=\"Int.html\">Int</a>, &)","location":{"filename":"src/array.cr","line_number":922,"url":null},"def":{"name":"fill","args":[{"name":"from","doc":null,"default_value":"","external_name":"from","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"if count <= 0\n  return self\nend\nif from < 0\n  from = from + size\nend\nif (0 <= from && from < size) && (from + count) <= size\nelse\n  raise(IndexError.new)\nend\nfrom.upto((from + count) - 1) do |i|\n  @buffer[i] = yield i\nend\nself\n"}},{"id":"first(n:Int)-instance-method","html_id":"first(n:Int)-instance-method","name":"first","doc":"Returns the first *n* elements of the array.\n\n```\n[1, 2, 3].first(2) # => [1, 2]\n[1, 2, 3].first(4) # => [1, 2, 3]\n```","summary":"<p>Returns the first <em>n</em> elements of the array.</p>","abstract":false,"args":[{"name":"n","doc":null,"default_value":"","external_name":"n","restriction":"Int"}],"args_string":"(n : Int)","args_html":"(n : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/array.cr","line_number":1047,"url":null},"def":{"name":"first","args":[{"name":"n","doc":null,"default_value":"","external_name":"n","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self[0, n]"}},{"id":"flatten-instance-method","html_id":"flatten-instance-method","name":"flatten","doc":"Returns a new `Array` that is a one-dimensional flattening of `self` (recursively).\n\nThat is, for every element that is an array or an iterator, extract its elements into the new array.\n\n```\ns = [1, 2, 3]          # => [1, 2, 3]\nt = [4, 5, 6, [7, 8]]  # => [4, 5, 6, [7, 8]]\nu = [9, [10, 11].each] # => [9, #<Indexable::ItemIterator>]\na = [s, t, u, 12, 13]  # => [[1, 2, 3], [4, 5, 6, [7, 8]], 9, #<Indexable::ItemIterator>, 12, 13]\na.flatten              # => [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13]\n```","summary":"<p>Returns a new <code><a href=\"Array.html\">Array</a></code> that is a one-dimensional flattening of <code>self</code> (recursively).</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/array.cr","line_number":1261,"url":null},"def":{"name":"flatten","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"FlattenHelper(typeof(FlattenHelper.element_type(self))).flatten(self)"}},{"id":"insert(index:Int,object:T)-instance-method","html_id":"insert(index:Int,object:T)-instance-method","name":"insert","doc":"Insert *object* before the element at *index* and shifting successive elements, if any.\nReturns `self`.\n\nNegative values of *index* count from the end of the array.\n\n```\na = [\"a\", \"b\", \"c\"]\na.insert(0, \"x\")  # => [\"x\", \"a\", \"b\", \"c\"]\na.insert(2, \"y\")  # => [\"x\", \"a\", \"y\", \"b\", \"c\"]\na.insert(-1, \"z\") # => [\"x\", \"a\", \"y\", \"b\", \"c\", \"z\"]\n```","summary":"<p>Insert <em>object</em> before the element at <em>index</em> and shifting successive elements, if any.</p>","abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"},{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":"T"}],"args_string":"(index : Int, object : T)","args_html":"(index : <a href=\"Int.html\">Int</a>, object : T)","location":{"filename":"src/array.cr","line_number":1062,"url":null},"def":{"name":"insert","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"},{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if index == 0\n  return unshift(object)\nend\nif index < 0\n  index = index + (size + 1)\nend\nif 0 <= index && index <= size\nelse\n  raise(IndexError.new)\nend\ncheck_needs_resize\n((@buffer + index) + 1).move_from(@buffer + index, size - index)\n@buffer[index] = object\n@size = @size + 1\nself\n"}},{"id":"last(n:Int)-instance-method","html_id":"last(n:Int)-instance-method","name":"last","doc":"Returns the last *n* elements of the array.\n\n```\n[1, 2, 3].last(2) # => [2, 3]\n[1, 2, 3].last(4) # => [1, 2, 3]\n```","summary":"<p>Returns the last <em>n</em> elements of the array.</p>","abstract":false,"args":[{"name":"n","doc":null,"default_value":"","external_name":"n","restriction":"Int"}],"args_string":"(n : Int)","args_html":"(n : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/array.cr","line_number":1095,"url":null},"def":{"name":"last","args":[{"name":"n","doc":null,"default_value":"","external_name":"n","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if n < @size\n  self[@size - n, n]\nelse\n  dup\nend"}},{"id":"map(&block:T->U)forallU-instance-method","html_id":"map(&block:T->U)forallU-instance-method","name":"map","doc":"Optimized version of `Enumerable#map`.","summary":"<p>Optimized version of <code><a href=\"Enumerable.html#map(&block:T-%3EU)forallU-instance-method\">Enumerable#map</a></code>.</p>","abstract":false,"args":[],"args_string":"(&block : T -> U) forall U","args_html":"(&block : T -> U) forall U","location":{"filename":"src/array.cr","line_number":1109,"url":null},"def":{"name":"map","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":"(T -> U)"},"return_type":"","visibility":"Public","body":"Array(U).new(size) do |i|\n  yield @buffer[i]\nend"}},{"id":"map!(&)-instance-method","html_id":"map!(&)-instance-method","name":"map!","doc":"Invokes the given block for each element of `self`, replacing the element\nwith the value returned by the block. Returns `self`.\n\n```\na = [1, 2, 3]\na.map! { |x| x * x }\na # => [1, 4, 9]\n```","summary":"<p>Invokes the given block for each element of <code>self</code>, replacing the element with the value returned by the block.</p>","abstract":false,"args":[],"args_string":"(&)","args_html":"(&)","location":{"filename":"src/array.cr","line_number":1121,"url":null},"def":{"name":"map!","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"@buffer.map!(size) do |e|\n  yield e\nend\nself\n"}},{"id":"map_with_index(offset=0,&block:T,Int32->U)forallU-instance-method","html_id":"map_with_index(offset=0,&block:T,Int32->U)forallU-instance-method","name":"map_with_index","doc":"Optimized version of `Enumerable#map_with_index`.\n\nAccepts an optional *offset* parameter, which tells it to start counting\nfrom there.","summary":"<p>Optimized version of <code><a href=\"Enumerable.html#map_with_index(offset=0,&block:T,Int32-%3EU)forallU-instance-method\">Enumerable#map_with_index</a></code>.</p>","abstract":false,"args":[{"name":"offset","doc":null,"default_value":"0","external_name":"offset","restriction":""}],"args_string":"(offset = <span class=\"n\">0</span>, &block : T, Int32 -> U) forall U","args_html":"(offset = <span class=\"n\">0</span>, &block : T, <a href=\"Int32.html\">Int32</a> -> U) forall U","location":{"filename":"src/array.cr","line_number":1219,"url":null},"def":{"name":"map_with_index","args":[{"name":"offset","doc":null,"default_value":"0","external_name":"offset","restriction":""}],"double_splat":null,"splat_index":null,"yields":2,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":"(T, Int32 -> U)"},"return_type":"","visibility":"Public","body":"Array(U).new(size) do |i|\n  yield @buffer[i], offset + i\nend"}},{"id":"map_with_index!(offset=0,&block:T,Int32->T)-instance-method","html_id":"map_with_index!(offset=0,&block:T,Int32->T)-instance-method","name":"map_with_index!","doc":"Like `map_with_index`, but mutates `self` instead of allocating a new object.\n\nAccepts an optional *offset* parameter, which tells it to start counting\nfrom there.","summary":"<p>Like <code><a href=\"Array.html#map_with_index(offset=0,&block:T,Int32-%3EU)forallU-instance-method\">#map_with_index</a></code>, but mutates <code>self</code> instead of allocating a new object.</p>","abstract":false,"args":[{"name":"offset","doc":null,"default_value":"0","external_name":"offset","restriction":""}],"args_string":"(offset = <span class=\"n\">0</span>, &block : T, Int32 -> T)","args_html":"(offset = <span class=\"n\">0</span>, &block : T, <a href=\"Int32.html\">Int32</a> -> T)","location":{"filename":"src/array.cr","line_number":1227,"url":null},"def":{"name":"map_with_index!","args":[{"name":"offset","doc":null,"default_value":"0","external_name":"offset","restriction":""}],"double_splat":null,"splat_index":null,"yields":2,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":"(T, Int32 -> T)"},"return_type":"","visibility":"Public","body":"to_unsafe.map_with_index!(size) do |e, i|\n  yield e, offset + i\nend\nself\n"}},{"id":"pop(&)-instance-method","html_id":"pop(&)-instance-method","name":"pop","doc":"Removes the last value from `self`.\nIf the array is empty, the given block is called.\n\n```\na = [1]\na.pop { \"Testing\" } # => 1\na.pop { \"Testing\" } # => \"Testing\"\n```","summary":"<p>Removes the last value from <code>self</code>.</p>","abstract":false,"args":[],"args_string":"(&)","args_html":"(&)","location":{"filename":"src/array.cr","line_number":1359,"url":null},"def":{"name":"pop","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"","visibility":"Public","body":"if @size == 0\n  yield\nelse\n  @size = @size - 1\n  value = @buffer[@size]\n  (@buffer + @size).clear\n  if empty? && (@offset_to_buffer != 0)\n    reset_buffer_to_root_buffer\n  end\n  value\nend"}},{"id":"pop-instance-method","html_id":"pop-instance-method","name":"pop","doc":"Removes the last value from `self`, at index *size - 1*.\nThis method returns the removed value.\nRaises `IndexError` if array is of 0 size.\n\n```\na = [\"a\", \"b\", \"c\"]\na.pop # => \"c\"\na     # => [\"a\", \"b\"]\n```","summary":"<p>Removes the last value from <code>self</code>, at index <em>size - 1</em>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/array.cr","line_number":1347,"url":null},"def":{"name":"pop","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"pop do\n  raise(IndexError.new)\nend"}},{"id":"pop(n:Int)-instance-method","html_id":"pop(n:Int)-instance-method","name":"pop","doc":"Removes the last *n* values from `self`, at index *size - 1*.\nThis method returns an array of the removed values, with the original order preserved.\n\nIf *n* is greater than the size of `self`, all values will be removed from `self`\nwithout raising an error.\n\n```\na = [\"a\", \"b\", \"c\"]\na.pop(2) # => [\"b\", \"c\"]\na        # => [\"a\"]\n\na = [\"a\", \"b\", \"c\"]\na.pop(4) # => [\"a\", \"b\", \"c\"]\na        # => []\n```","summary":"<p>Removes the last <em>n</em> values from <code>self</code>, at index <em>size - 1</em>.</p>","abstract":false,"args":[{"name":"n","doc":null,"default_value":"","external_name":"n","restriction":"Int"}],"args_string":"(n : Int)","args_html":"(n : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/array.cr","line_number":1392,"url":null},"def":{"name":"pop","args":[{"name":"n","doc":null,"default_value":"","external_name":"n","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if n < 0\n  raise(ArgumentError.new(\"Can't pop negative count\"))\nend\nn = Math.min(n, @size)\nary = Array(T).new(n) do |i|\n  @buffer[(@size - n) + i]\nend\n@size = @size - n\n(@buffer + @size).clear(n)\nary\n"}},{"id":"pop?-instance-method","html_id":"pop?-instance-method","name":"pop?","doc":"Like `pop`, but returns `nil` if `self` is empty.","summary":"<p>Like <code><a href=\"Array.html#pop(&)-instance-method\">#pop</a></code>, but returns <code>nil</code> if <code>self</code> is empty.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/array.cr","line_number":1407,"url":null},"def":{"name":"pop?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"pop do\n  nil\nend"}},{"id":"pretty_print(pp):Nil-instance-method","html_id":"pretty_print(pp):Nil-instance-method","name":"pretty_print","doc":null,"summary":null,"abstract":false,"args":[{"name":"pp","doc":null,"default_value":"","external_name":"pp","restriction":""}],"args_string":"(pp) : Nil","args_html":"(pp) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/array.cr","line_number":1804,"url":null},"def":{"name":"pretty_print","args":[{"name":"pp","doc":null,"default_value":"","external_name":"pp","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"executed = exec_recursive(:pretty_print) do\n  pp.list(\"[\", self, \"]\")\nend\nif executed\nelse\n  pp.text(\"[...]\")\nend\n"}},{"id":"product(ary:Array(U))forallU-instance-method","html_id":"product(ary:Array(U))forallU-instance-method","name":"product","doc":null,"summary":null,"abstract":false,"args":[{"name":"ary","doc":null,"default_value":"","external_name":"ary","restriction":"Array(U)"}],"args_string":"(ary : Array(U)) forall U","args_html":"(ary : <a href=\"Array.html\">Array</a>(U)) forall U","location":{"filename":"src/array.cr","line_number":1411,"url":null},"def":{"name":"product","args":[{"name":"ary","doc":null,"default_value":"","external_name":"ary","restriction":"Array(U)"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"result = Array(::Tuple(T, U)).new(size * ary.size)\nproduct(ary) do |x, y|\n  result << {x, y}\nend\nresult\n"}},{"id":"product(enumerable:Enumerable,&)-instance-method","html_id":"product(enumerable:Enumerable,&)-instance-method","name":"product","doc":null,"summary":null,"abstract":false,"args":[{"name":"enumerable","doc":null,"default_value":"","external_name":"enumerable","restriction":"Enumerable"}],"args_string":"(enumerable : Enumerable, &)","args_html":"(enumerable : <a href=\"Enumerable.html\">Enumerable</a>, &)","location":{"filename":"src/array.cr","line_number":1419,"url":null},"def":{"name":"product","args":[{"name":"enumerable","doc":null,"default_value":"","external_name":"enumerable","restriction":"Enumerable"}],"double_splat":null,"splat_index":null,"yields":2,"block_arg":null,"return_type":"","visibility":"Public","body":"self.each do |a|\n  enumerable.each do |b|\n    yield a, b\n  end\nend"}},{"id":"push(*values:T)-instance-method","html_id":"push(*values:T)-instance-method","name":"push","doc":"Append multiple values. The same as `push`, but takes an arbitrary number\nof values to push into `self`. Returns `self`.\n\n```\na = [\"a\"]\na.push(\"b\", \"c\") # => [\"a\", \"b\", \"c\"]\n```","summary":"<p>Append multiple values.</p>","abstract":false,"args":[{"name":"values","doc":null,"default_value":"","external_name":"values","restriction":"T"}],"args_string":"(*values : T)","args_html":"(*values : T)","location":{"filename":"src/array.cr","line_number":1451,"url":null},"def":{"name":"push","args":[{"name":"values","doc":null,"default_value":"","external_name":"values","restriction":"T"}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"new_size = @size + values.size\nresize_if_cant_insert(values.size)\nvalues.each_with_index do |value, i|\n  @buffer[@size + i] = value\nend\n@size = @size + values.size\nself\n"}},{"id":"push(value:T)-instance-method","html_id":"push(value:T)-instance-method","name":"push","doc":"Append. Pushes one value to the end of `self`, given that the type of the value is *T*\n(which might be a single type or a union of types).\nThis method returns `self`, so several calls can be chained.\nSee `pop` for the opposite effect.\n\n```\na = [\"a\", \"b\"]\na.push(\"c\") # => [\"a\", \"b\", \"c\"]\na.push(1)   # Errors, because the array only accepts String.\n\na = [\"a\", \"b\"] of (Int32 | String)\na.push(\"c\") # => [\"a\", \"b\", \"c\"]\na.push(1)   # => [\"a\", \"b\", \"c\", 1]\n```","summary":"<p>Append.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","args_html":"(value : T)","location":{"filename":"src/array.cr","line_number":1437,"url":null},"def":{"name":"push","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"check_needs_resize\n@buffer[@size] = value\n@size = @size + 1\nself\n"}},{"id":"reject!(&)-instance-method","html_id":"reject!(&)-instance-method","name":"reject!","doc":"Modifies `self`, deleting the elements in the collection for which the\npassed block returns `true`. Returns `self`.\n\n```\nary = [1, 6, 2, 4, 8]\nary.reject! { |x| x > 3 }\nary # => [1, 2]\n```\n\nSee also: `Array#reject`.","summary":"<p>Modifies <code>self</code>, deleting the elements in the collection for which the passed block returns <code>true</code>.</p>","abstract":false,"args":[],"args_string":"(&)","args_html":"(&)","location":{"filename":"src/array.cr","line_number":1164,"url":null},"def":{"name":"reject!","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"internal_delete do |e|\n  yield e\nend\nself\n"}},{"id":"reject!(pattern)-instance-method","html_id":"reject!(pattern)-instance-method","name":"reject!","doc":"Modifies `self`, deleting the elements in the collection for which\n`pattern === element`.\n\n```\nary = [1, 6, 2, 4, 8]\nary.reject!(3..7)\nary # => [1, 2, 8]\n```\n\nSee also: `Array#select!`.","summary":"<p>Modifies <code>self</code>, deleting the elements in the collection for which <code>pattern === element</code>.</p>","abstract":false,"args":[{"name":"pattern","doc":null,"default_value":"","external_name":"pattern","restriction":""}],"args_string":"(pattern)","args_html":"(pattern)","location":{"filename":"src/array.cr","line_number":1179,"url":null},"def":{"name":"reject!","args":[{"name":"pattern","doc":null,"default_value":"","external_name":"pattern","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"reject! do |elem|\n  pattern === elem\nend\nself\n"}},{"id":"remaining_capacity-instance-method","html_id":"remaining_capacity-instance-method","name":"remaining_capacity","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/array.cr","line_number":2063,"url":null},"def":{"name":"remaining_capacity","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@capacity - @offset_to_buffer"}},{"id":"repeated_permutations(size:Int=self.size)-instance-method","html_id":"repeated_permutations(size:Int=self.size)-instance-method","name":"repeated_permutations","doc":null,"summary":null,"abstract":false,"args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"}],"args_string":"(size : Int = <span class=\"k\">self</span>.size)","args_html":"(size : <a href=\"Int.html\">Int</a> = <span class=\"k\">self</span>.size)","location":{"filename":"src/array.cr","line_number":1318,"url":null},"def":{"name":"repeated_permutations","args":[{"name":"size","doc":null,"default_value":"self.size","external_name":"size","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ary = [] of Array(T)\neach_repeated_permutation(size) do |a|\n  ary << a\nend\nary\n"}},{"id":"replace(other:Array)-instance-method","html_id":"replace(other:Array)-instance-method","name":"replace","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array"}],"args_string":"(other : Array)","args_html":"(other : <a href=\"Array.html\">Array</a>)","location":{"filename":"src/array.cr","line_number":1463,"url":null},"def":{"name":"replace","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@size = other.size\nif @size > @capacity\n  resize_to_capacity(Math.pw2ceil(@size))\nend\n@buffer.copy_from(other.to_unsafe, other.size)\nself\n"}},{"id":"reverse-instance-method","html_id":"reverse-instance-method","name":"reverse","doc":"Returns an array with all the elements in the collection reversed.\n\n```\na = [1, 2, 3]\na.reverse # => [3, 2, 1]\n```","summary":"<p>Returns an array with all the elements in the collection reversed.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/array.cr","line_number":1476,"url":null},"def":{"name":"reverse","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Array(T).new(size) do |i|\n  @buffer[(size - i) - 1]\nend"}},{"id":"reverse!-instance-method","html_id":"reverse!-instance-method","name":"reverse!","doc":"Reverses in-place all the elements of `self`.","summary":"<p>Reverses in-place all the elements of <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/array.cr","line_number":1481,"url":null},"def":{"name":"reverse!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(Slice.new(@buffer, size)).reverse!\nself\n"}},{"id":"rotate(n=1)-instance-method","html_id":"rotate(n=1)-instance-method","name":"rotate","doc":"Returns an array with all the elements shifted `n` times.\n\n```\na = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]\na.rotate    # => [1, 2, 3, 4, 5, 6, 7, 8, 9, 0]\na.rotate(1) # => [1, 2, 3, 4, 5, 6, 7, 8, 9, 0]\na.rotate(3) # => [3, 4, 5, 6, 7, 8, 9, 0, 1, 2]\na           # => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]\n```","summary":"<p>Returns an array with all the elements shifted <code>n</code> times.</p>","abstract":false,"args":[{"name":"n","doc":null,"default_value":"1","external_name":"n","restriction":""}],"args_string":"(n = <span class=\"n\">1</span>)","args_html":"(n = <span class=\"n\">1</span>)","location":{"filename":"src/array.cr","line_number":1545,"url":null},"def":{"name":"rotate","args":[{"name":"n","doc":null,"default_value":"1","external_name":"n","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if size == 0\n  return self\nend\nn = n % size\nif n == 0\n  return self\nend\nres = Array(T).new(size)\nres.to_unsafe.copy_from(@buffer + n, size - n)\n((res.to_unsafe + size) - n).copy_from(@buffer, n)\nres.size = size\nres\n"}},{"id":"rotate!(n=1)-instance-method","html_id":"rotate!(n=1)-instance-method","name":"rotate!","doc":"Returns `self` with all the elements shifted `n` times.\n\n```\na1 = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]\na2 = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]\na3 = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]\n\na1.rotate!\na2.rotate!(1)\na3.rotate!(3)\n\na1 # => [1, 2, 3, 4, 5, 6, 7, 8, 9, 0]\na2 # => [1, 2, 3, 4, 5, 6, 7, 8, 9, 0]\na3 # => [3, 4, 5, 6, 7, 8, 9, 0, 1, 2]\n```","summary":"<p>Returns <code>self</code> with all the elements shifted <code>n</code> times.</p>","abstract":false,"args":[{"name":"n","doc":null,"default_value":"1","external_name":"n","restriction":""}],"args_string":"(n = <span class=\"n\">1</span>)","args_html":"(n = <span class=\"n\">1</span>)","location":{"filename":"src/array.cr","line_number":1501,"url":null},"def":{"name":"rotate!","args":[{"name":"n","doc":null,"default_value":"1","external_name":"n","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if size == 0\n  return self\nend\nn = n % size\nif n == 0\nelse\n  if n == 1\n    tmp = self[0]\n    @buffer.move_from(@buffer + n, size - n)\n    self[-1] = tmp\n  else\n    if n == (size - 1)\n      tmp = self[-1]\n      ((@buffer + size) - n).move_from(@buffer, n)\n      self[0] = tmp\n    else\n      if n <= SMALL_ARRAY_SIZE\n        tmp_buffer = uninitialized StaticArray(T, SMALL_ARRAY_SIZE)\n        tmp_buffer.to_unsafe.copy_from(@buffer, n)\n        @buffer.move_from(@buffer + n, size - n)\n        ((@buffer + size) - n).copy_from(tmp_buffer.to_unsafe, n)\n      else\n        if (size - n) <= SMALL_ARRAY_SIZE\n          tmp_buffer = uninitialized StaticArray(T, SMALL_ARRAY_SIZE)\n          tmp_buffer.to_unsafe.copy_from(@buffer + n, size - n)\n          ((@buffer + size) - n).move_from(@buffer, n)\n          @buffer.copy_from(tmp_buffer.to_unsafe, size - n)\n        else\n          if n <= (size // 2)\n            tmp = self[0..n]\n            @buffer.move_from(@buffer + n, size - n)\n            ((@buffer + size) - n).copy_from(tmp.to_unsafe, n)\n          else\n            tmp = self[n..-1]\n            ((@buffer + size) - n).move_from(@buffer, n)\n            @buffer.copy_from(tmp.to_unsafe, size - n)\n          end\n        end\n      end\n    end\n  end\nend\nself\n"}},{"id":"select!(&)-instance-method","html_id":"select!(&)-instance-method","name":"select!","doc":"Modifies `self`, keeping only the elements in the collection for which the\npassed block returns `true`. Returns `self`.\n\n```\nary = [1, 6, 2, 4, 8]\nary.select! { |x| x > 3 }\nary # => [6, 4, 8]\n```\n\nSee also: `Array#select`.","summary":"<p>Modifies <code>self</code>, keeping only the elements in the collection for which the passed block returns <code>true</code>.</p>","abstract":false,"args":[],"args_string":"(&)","args_html":"(&)","location":{"filename":"src/array.cr","line_number":1136,"url":null},"def":{"name":"select!","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"reject! do |elem|\n  !(yield elem)\nend"}},{"id":"select!(pattern)-instance-method","html_id":"select!(pattern)-instance-method","name":"select!","doc":"Modifies `self`, keeping only the elements in the collection for which\n`pattern === element`.\n\n```\nary = [1, 6, 2, 4, 8]\nary.select!(3..7)\nary # => [6, 4]\n```\n\nSee also: `Array#reject!`.","summary":"<p>Modifies <code>self</code>, keeping only the elements in the collection for which <code>pattern === element</code>.</p>","abstract":false,"args":[{"name":"pattern","doc":null,"default_value":"","external_name":"pattern","restriction":""}],"args_string":"(pattern)","args_html":"(pattern)","location":{"filename":"src/array.cr","line_number":1150,"url":null},"def":{"name":"select!","args":[{"name":"pattern","doc":null,"default_value":"","external_name":"pattern","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self.select! do |elem|\n  pattern === elem\nend"}},{"id":"shift(n:Int)-instance-method","html_id":"shift(n:Int)-instance-method","name":"shift","doc":"Removes the first *n* values of `self`, starting at index 0.\nThis method returns an array of the removed values.\n\nIf *n* is greater than the size of `self`, all values will be removed from `self`\nwithout raising an error.\n\n```\na = [\"a\", \"b\", \"c\"]\na.shift # => \"a\"\na       # => [\"b\", \"c\"]\n\na = [\"a\", \"b\", \"c\"]\na.shift(4) # => [\"a\", \"b\", \"c\"]\na          # => []\n```","summary":"<p>Removes the first <em>n</em> values of <code>self</code>, starting at index 0.</p>","abstract":false,"args":[{"name":"n","doc":null,"default_value":"","external_name":"n","restriction":"Int"}],"args_string":"(n : Int)","args_html":"(n : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/array.cr","line_number":1617,"url":null},"def":{"name":"shift","args":[{"name":"n","doc":null,"default_value":"","external_name":"n","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if n < 0\n  raise(ArgumentError.new(\"Can't shift negative count\"))\nend\nn = Math.min(n, @size)\nary = Array(T).new(n) do |i|\n  @buffer[i]\nend\n@size = @size - n\n@buffer.clear(n)\nif empty?\n  reset_buffer_to_root_buffer\nelse\n  shift_buffer_by(n)\nend\nary\n"}},{"id":"shift-instance-method","html_id":"shift-instance-method","name":"shift","doc":"Removes the first value of `self`, at index 0. This method returns the removed value.\nIf the array is empty, it raises `IndexError`.\n\n```\na = [\"a\", \"b\", \"c\"]\na.shift # => \"a\"\na       # => [\"b\", \"c\"]\n```","summary":"<p>Removes the first value of <code>self</code>, at index 0.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/array.cr","line_number":1564,"url":null},"def":{"name":"shift","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"shift do\n  raise(IndexError.new)\nend"}},{"id":"shift(&)-instance-method","html_id":"shift(&)-instance-method","name":"shift","doc":"Removes the first value of `self`, at index 0, or otherwise invokes the given block.\nThis method returns the removed value.\nIf the array is empty, it invokes the given block and returns its value.\n\n```\na = [\"a\"]\na.shift { \"empty!\" } # => \"a\"\na                    # => []\na.shift { \"empty!\" } # => \"empty!\"\na                    # => []\n```","summary":"<p>Removes the first value of <code>self</code>, at index 0, or otherwise invokes the given block.</p>","abstract":false,"args":[],"args_string":"(&)","args_html":"(&)","location":{"filename":"src/array.cr","line_number":1579,"url":null},"def":{"name":"shift","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"","visibility":"Public","body":"if @size == 0\n  yield\nelse\n  shift_when_not_empty\nend"}},{"id":"shift?-instance-method","html_id":"shift?-instance-method","name":"shift?","doc":"Removes the first value of `self`, at index 0. This method returns the removed value.\nIf the array is empty, it returns `nil` without raising any error.\n\n```\na = [\"a\", \"b\"]\na.shift? # => \"a\"\na        # => [\"b\"]\na.shift? # => \"b\"\na        # => []\na.shift? # => nil\na        # => []\n```","summary":"<p>Removes the first value of <code>self</code>, at index 0.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/array.cr","line_number":1650,"url":null},"def":{"name":"shift?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"shift do\n  nil\nend"}},{"id":"shuffle(random=Random::DEFAULT)-instance-method","html_id":"shuffle(random=Random::DEFAULT)-instance-method","name":"shuffle","doc":"Returns an array with all the elements in the collection randomized\nusing the given *random* number generator.","summary":"<p>Returns an array with all the elements in the collection randomized using the given <em>random</em> number generator.</p>","abstract":false,"args":[{"name":"random","doc":null,"default_value":"Random::DEFAULT","external_name":"random","restriction":""}],"args_string":"(random = <span class=\"t\">Random</span><span class=\"t\">::</span><span class=\"t\">DEFAULT</span>)","args_html":"(random = <span class=\"t\">Random</span><span class=\"t\">::</span><span class=\"t\">DEFAULT</span>)","location":{"filename":"src/array.cr","line_number":1656,"url":null},"def":{"name":"shuffle","args":[{"name":"random","doc":null,"default_value":"Random::DEFAULT","external_name":"random","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"dup.shuffle!(random)"}},{"id":"shuffle!(random=Random::DEFAULT)-instance-method","html_id":"shuffle!(random=Random::DEFAULT)-instance-method","name":"shuffle!","doc":"Modifies `self` by randomizing the order of elements in the collection\nusing the given *random* number generator. Returns `self`.","summary":"<p>Modifies <code>self</code> by randomizing the order of elements in the collection using the given <em>random</em> number generator.</p>","abstract":false,"args":[{"name":"random","doc":null,"default_value":"Random::DEFAULT","external_name":"random","restriction":""}],"args_string":"(random = <span class=\"t\">Random</span><span class=\"t\">::</span><span class=\"t\">DEFAULT</span>)","args_html":"(random = <span class=\"t\">Random</span><span class=\"t\">::</span><span class=\"t\">DEFAULT</span>)","location":{"filename":"src/array.cr","line_number":1662,"url":null},"def":{"name":"shuffle!","args":[{"name":"random","doc":null,"default_value":"Random::DEFAULT","external_name":"random","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@buffer.shuffle!(size, random)\nself\n"}},{"id":"size:Int32-instance-method","html_id":"size:Int32-instance-method","name":"size","doc":"Returns the number of elements in the array.\n\n```\n[:foo, :bar].size # => 2\n```","summary":"<p>Returns the number of elements in the array.</p>","abstract":false,"args":[],"args_string":" : Int32","args_html":" : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/array.cr","line_number":195,"url":null},"def":{"name":"size","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":"@size"}},{"id":"skip(count:Int):Array(T)-instance-method","html_id":"skip(count:Int):Array(T)-instance-method","name":"skip","doc":"Returns an `Array` with the first *count* elements removed\nfrom the original array.\n\nIf *count* is bigger than the number of elements in the array, returns an empty array.\n\n```\n[1, 2, 3, 4, 5, 6].skip(3) # => [4, 5, 6]\n```","summary":"<p>Returns an <code><a href=\"Array.html\">Array</a></code> with the first <em>count</em> elements removed from the original array.</p>","abstract":false,"args":[{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"args_string":"(count : Int) : Array(T)","args_html":"(count : <a href=\"Int.html\">Int</a>) : <a href=\"Array.html\">Array</a>(T)","location":{"filename":"src/array.cr","line_number":1240,"url":null},"def":{"name":"skip","args":[{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Array(T)","visibility":"Public","body":"if count < 0\n  raise(ArgumentError.new(\"Attempt to skip negative size\"))\nend\nnew_size = Math.max(size - count, 0)\nArray(T).build(new_size) do |buffer|\n  buffer.copy_from(to_unsafe + count, new_size)\n  new_size\nend\n"}},{"id":"sort:Array(T)-instance-method","html_id":"sort:Array(T)-instance-method","name":"sort","doc":"Returns a new array with all elements sorted based on the return value of\ntheir comparison method `#<=>`\n\n```\na = [3, 1, 2]\na.sort # => [1, 2, 3]\na      # => [3, 1, 2]\n```","summary":"<p>Returns a new array with all elements sorted based on the return value of their comparison method <code><a href=\"Array.html#(other:Array)-instance-method\">#<=></a></code></p>","abstract":false,"args":[],"args_string":" : Array(T)","args_html":" : <a href=\"Array.html\">Array</a>(T)","location":{"filename":"src/array.cr","line_number":1675,"url":null},"def":{"name":"sort","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Array(T)","visibility":"Public","body":"dup.sort!"}},{"id":"sort(&block:T,T->U):Array(T)forallU-instance-method","html_id":"sort(&block:T,T->U):Array(T)forallU-instance-method","name":"sort","doc":"Returns a new array with all elements sorted based on the comparator in the\ngiven block.\n\nThe block must implement a comparison between two elements *a* and *b*,\nwhere `a < b` returns `-1`, `a == b` returns `0`, and `a > b` returns `1`.\nThe comparison operator `<=>` can be used for this.\n\n```\na = [3, 1, 2]\nb = a.sort { |a, b| b <=> a }\n\nb # => [3, 2, 1]\na # => [3, 1, 2]\n```","summary":"<p>Returns a new array with all elements sorted based on the comparator in the given block.</p>","abstract":false,"args":[],"args_string":"(&block : T, T -> U) : Array(T) forall U","args_html":"(&block : T, T -> U) : <a href=\"Array.html\">Array</a>(T) forall U","location":{"filename":"src/array.cr","line_number":1693,"url":null},"def":{"name":"sort","args":[],"double_splat":null,"splat_index":null,"yields":2,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":"(T, T -> U)"},"return_type":"Array(T)","visibility":"Public","body":"{% if U <= ::Union(Int32, ::Nil) %}{% else %}\n      {% raise(\"expected block to return Int32 or Nil, not #{U}\") %}\n    {% end %}\ndup.sort!(&block)\n"}},{"id":"sort!:Array(T)-instance-method","html_id":"sort!:Array(T)-instance-method","name":"sort!","doc":"Modifies `self` by sorting all elements based on the return value of their\ncomparison method `#<=>`\n\n```\na = [3, 1, 2]\na.sort!\na # => [1, 2, 3]\n```","summary":"<p>Modifies <code>self</code> by sorting all elements based on the return value of their comparison method <code><a href=\"Array.html#(other:Array)-instance-method\">#<=></a></code></p>","abstract":false,"args":[],"args_string":" : Array(T)","args_html":" : <a href=\"Array.html\">Array</a>(T)","location":{"filename":"src/array.cr","line_number":1709,"url":null},"def":{"name":"sort!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Array(T)","visibility":"Public","body":"(Slice.new(to_unsafe, size)).sort!\nself\n"}},{"id":"sort!(&block:T,T->U):Array(T)forallU-instance-method","html_id":"sort!(&block:T,T->U):Array(T)forallU-instance-method","name":"sort!","doc":"Modifies `self` by sorting all elements based on the comparator in the given\nblock.\n\nThe given block must implement a comparison between two elements\n*a* and *b*, where `a < b` returns `-1`, `a == b` returns `0`,\nand `a > b` returns `1`.\nThe comparison operator `<=>` can be used for this.\n\n```\na = [3, 1, 2]\na.sort! { |a, b| b <=> a }\na # => [3, 2, 1]\n```","summary":"<p>Modifies <code>self</code> by sorting all elements based on the comparator in the given block.</p>","abstract":false,"args":[],"args_string":"(&block : T, T -> U) : Array(T) forall U","args_html":"(&block : T, T -> U) : <a href=\"Array.html\">Array</a>(T) forall U","location":{"filename":"src/array.cr","line_number":1727,"url":null},"def":{"name":"sort!","args":[],"double_splat":null,"splat_index":null,"yields":2,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":"(T, T -> U)"},"return_type":"Array(T)","visibility":"Public","body":"{% if U <= ::Union(Int32, ::Nil) %}{% else %}\n      {% raise(\"expected block to return Int32 or Nil, not #{U}\") %}\n    {% end %}\n(Slice.new(to_unsafe, size)).sort!(&block)\nself\n"}},{"id":"sort_by(&block:T->_):Array(T)-instance-method","html_id":"sort_by(&block:T->_):Array(T)-instance-method","name":"sort_by","doc":"Returns a new array with all elements sorted. The given block is called for\neach element, then the comparison method #<=> is called on the object\nreturned from the block to determine sort order.\n\n```\na = %w(apple pear fig)\nb = a.sort_by { |word| word.size }\nb # => [\"fig\", \"pear\", \"apple\"]\na # => [\"apple\", \"pear\", \"fig\"]\n```","summary":"<p>Returns a new array with all elements sorted.</p>","abstract":false,"args":[],"args_string":"(&block : T -> _) : Array(T)","args_html":"(&block : T -> _) : <a href=\"Array.html\">Array</a>(T)","location":{"filename":"src/array.cr","line_number":1746,"url":null},"def":{"name":"sort_by","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":"(T -> _)"},"return_type":"Array(T)","visibility":"Public","body":"dup.sort_by! do |e|\n  yield e\nend"}},{"id":"sort_by!(&block:T->_):Array(T)-instance-method","html_id":"sort_by!(&block:T->_):Array(T)-instance-method","name":"sort_by!","doc":"Modifies `self` by sorting all elements. The given block is called for\neach element, then the comparison method #<=> is called on the object\nreturned from the block to determine sort order.\n\n```\na = %w(apple pear fig)\na.sort_by! { |word| word.size }\na # => [\"fig\", \"pear\", \"apple\"]\n```","summary":"<p>Modifies <code>self</code> by sorting all elements.</p>","abstract":false,"args":[],"args_string":"(&block : T -> _) : Array(T)","args_html":"(&block : T -> _) : <a href=\"Array.html\">Array</a>(T)","location":{"filename":"src/array.cr","line_number":1759,"url":null},"def":{"name":"sort_by!","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":"(T -> _)"},"return_type":"Array(T)","visibility":"Public","body":"sorted = map do |e|\n  {e, yield e}\nend.sort! do |x, y|\n  x[1] <=> y[1]\nend\n@size.times do |i|\n  @buffer[i] = sorted.to_unsafe[i][0]\nend\nself\n"}},{"id":"swap(index0,index1):Array(T)-instance-method","html_id":"swap(index0,index1):Array(T)-instance-method","name":"swap","doc":"Swaps the elements at *index0* and *index1* and returns `self`.\nRaises an `IndexError` if either index is out of bounds.\n\n```\na = [\"first\", \"second\", \"third\"]\na.swap(1, 2)  # => [\"first\", \"third\", \"second\"]\na             # => [\"first\", \"third\", \"second\"]\na.swap(0, -1) # => [\"second\", \"third\", \"first\"]\na             # => [\"second\", \"third\", \"first\"]\na.swap(2, 3)  # => raises \"Index out of bounds (IndexError)\"\n```","summary":"<p>Swaps the elements at <em>index0</em> and <em>index1</em> and returns <code>self</code>.</p>","abstract":false,"args":[{"name":"index0","doc":null,"default_value":"","external_name":"index0","restriction":""},{"name":"index1","doc":null,"default_value":"","external_name":"index1","restriction":""}],"args_string":"(index0, index1) : Array(T)","args_html":"(index0, index1) : <a href=\"Array.html\">Array</a>(T)","location":{"filename":"src/array.cr","line_number":1778,"url":null},"def":{"name":"swap","args":[{"name":"index0","doc":null,"default_value":"","external_name":"index0","restriction":""},{"name":"index1","doc":null,"default_value":"","external_name":"index1","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Array(T)","visibility":"Public","body":"if index0 < 0\n  index0 = index0 + size\nend\nif index1 < 0\n  index1 = index1 + size\nend\nif (0 <= index0 && index0 < size) && (0 <= index1 && index1 < size)\nelse\n  raise(IndexError.new)\nend\n@buffer[index0], @buffer[index1] = @buffer[index1], @buffer[index0]\nself\n"}},{"id":"to_a-instance-method","html_id":"to_a-instance-method","name":"to_a","doc":"Returns an `Array` with all the elements in the collection.\n\n```\n{1, 2, 3}.to_a # => [1, 2, 3]\n```","summary":"<p>Returns an <code><a href=\"Array.html\">Array</a></code> with all the elements in the collection.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/array.cr","line_number":1791,"url":null},"def":{"name":"to_a","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"to_json(json:JSON::Builder)-instance-method","html_id":"to_json(json:JSON::Builder)-instance-method","name":"to_json","doc":null,"summary":null,"abstract":false,"args":[{"name":"json","doc":null,"default_value":"","external_name":"json","restriction":"JSON::Builder"}],"args_string":"(json : JSON::Builder)","args_html":"(json : <a href=\"JSON/Builder.html\">JSON::Builder</a>)","location":{"filename":"src/json/to_json.cr","line_number":94,"url":null},"def":{"name":"to_json","args":[{"name":"json","doc":null,"default_value":"","external_name":"json","restriction":"JSON::Builder"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"json.array do\n  each(&.to_json(json))\nend"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Appends a short String representation of this object\nwhich includes its class name and its object address.\n\n```\nclass Person\n  def initialize(@name : String, @age : Int32)\n  end\nend\n\nPerson.new(\"John\", 32).to_s # => #<Person:0x10a199f20>\n```","summary":"<p>Appends a short String representation of this object which includes its class name and its object address.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/array.cr","line_number":1795,"url":null},"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"executed = exec_recursive(:to_s) do\n  io << '['\n  join(io, \", \", &.inspect(io))\n  io << ']'\nend\nif executed\nelse\n  io << \"[...]\"\nend\n"}},{"id":"to_unsafe:Pointer(T)-instance-method","html_id":"to_unsafe:Pointer(T)-instance-method","name":"to_unsafe","doc":"Returns a pointer to the internal buffer where `self`'s elements are stored.\n\nThis method is **unsafe** because it returns a pointer, and the pointed might eventually\nnot be that of `self` if the array grows and its internal buffer is reallocated.\n\n```\nary = [1, 2, 3]\nary.to_unsafe[0] # => 1\n```","summary":"<p>Returns a pointer to the internal buffer where <code>self</code>'s elements are stored.</p>","abstract":false,"args":[],"args_string":" : Pointer(T)","args_html":" : <a href=\"Pointer.html\">Pointer</a>(T)","location":{"filename":"src/array.cr","line_number":1820,"url":null},"def":{"name":"to_unsafe","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Pointer(T)","visibility":"Public","body":"@buffer"}},{"id":"to_yaml(yaml:YAML::Nodes::Builder)-instance-method","html_id":"to_yaml(yaml:YAML::Nodes::Builder)-instance-method","name":"to_yaml","doc":null,"summary":null,"abstract":false,"args":[{"name":"yaml","doc":null,"default_value":"","external_name":"yaml","restriction":"YAML::Nodes::Builder"}],"args_string":"(yaml : YAML::Nodes::Builder)","args_html":"(yaml : <a href=\"YAML/Nodes/Builder.html\">YAML::Nodes::Builder</a>)","location":{"filename":"src/yaml/to_yaml.cr","line_number":35,"url":null},"def":{"name":"to_yaml","args":[{"name":"yaml","doc":null,"default_value":"","external_name":"yaml","restriction":"YAML::Nodes::Builder"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"yaml.sequence(reference: self) do\n  each(&.to_yaml(yaml))\nend"}},{"id":"transpose-instance-method","html_id":"transpose-instance-method","name":"transpose","doc":"Assumes that `self` is an array of arrays and transposes the rows and columns.\n\n```\na = [[:a, :b], [:c, :d], [:e, :f]]\na.transpose # => [[:a, :c, :e], [:b, :d, :f]]\na           # => [[:a, :b], [:c, :d], [:e, :f]]\n```","summary":"<p>Assumes that <code>self</code> is an array of arrays and transposes the rows and columns.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/array.cr","line_number":1831,"url":null},"def":{"name":"transpose","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if empty?\n  return Array(Array(typeof(first.first))).new\nend\nlen = self[0].size\n(1...@size).each do |i|\n  l = self[i].size\n  if len != l\n    raise(IndexError.new)\n  end\nend\nArray(Array(typeof(first.first))).new(len) do |i|\n  Array(typeof(first.first)).new(@size) do |j|\n    self[j][i]\n  end\nend\n"}},{"id":"uniq-instance-method","html_id":"uniq-instance-method","name":"uniq","doc":"Returns a new `Array` by removing duplicate values in `self`.\n\n```\na = [\"a\", \"a\", \"b\", \"b\", \"c\"]\na.uniq # => [\"a\", \"b\", \"c\"]\na      # => [ \"a\", \"a\", \"b\", \"b\", \"c\" ]\n```","summary":"<p>Returns a new <code><a href=\"Array.html\">Array</a></code> by removing duplicate values in <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/array.cr","line_number":1854,"url":null},"def":{"name":"uniq","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if size <= 1\n  return dup\nend\nif size <= SMALL_ARRAY_SIZE\n  ary = Array(T).new\n  each do |elem|\n    if ary.includes?(elem)\n    else\n      ary << elem\n    end\n  end\n  return ary\nend\nto_lookup_hash.values\n"}},{"id":"uniq(&block:T->_)-instance-method","html_id":"uniq(&block:T->_)-instance-method","name":"uniq","doc":"Returns a new `Array` by removing duplicate values in `self`, using the block's\nvalue for comparison.\n\n```\na = [{\"student\", \"sam\"}, {\"student\", \"george\"}, {\"teacher\", \"matz\"}]\na.uniq { |s| s[0] } # => [{\"student\", \"sam\"}, {\"teacher\", \"matz\"}]\na                   # => [{\"student\", \"sam\"}, {\"student\", \"george\"}, {\"teacher\", \"matz\"}]\n```","summary":"<p>Returns a new <code><a href=\"Array.html\">Array</a></code> by removing duplicate values in <code>self</code>, using the block's value for comparison.</p>","abstract":false,"args":[],"args_string":"(&block : T -> _)","args_html":"(&block : T -> _)","location":{"filename":"src/array.cr","line_number":1881,"url":null},"def":{"name":"uniq","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":"(T -> _)"},"return_type":"","visibility":"Public","body":"if size <= 1\n  dup\nelse\n  hash = to_lookup_hash do |elem|\n    yield elem\n  end\n  hash.values\nend"}},{"id":"uniq!-instance-method","html_id":"uniq!-instance-method","name":"uniq!","doc":"Removes duplicate elements from `self`. Returns `self`.\n\n```\na = [\"a\", \"a\", \"b\", \"b\", \"c\"]\na.uniq! # => [\"a\", \"b\", \"c\"]\na       # => [\"a\", \"b\", \"c\"]\n```","summary":"<p>Removes duplicate elements from <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/array.cr","line_number":1897,"url":null},"def":{"name":"uniq!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if size <= 1\n  return self\nend\nif size <= SMALL_ARRAY_SIZE\n  internal_delete do |elem, index|\n    (0...index).any? do |subindex|\n      elem == to_unsafe[subindex]\n    end\n  end\n  return self\nend\nuniq!(&.itself)\n"}},{"id":"uniq!(&)-instance-method","html_id":"uniq!(&)-instance-method","name":"uniq!","doc":"Removes duplicate elements from `self`, using the block's value for comparison. Returns `self`.\n\n```\na = [{\"student\", \"sam\"}, {\"student\", \"george\"}, {\"teacher\", \"matz\"}]\na.uniq! { |s| s[0] } # => [{\"student\", \"sam\"}, {\"teacher\", \"matz\"}]\na                    # => [{\"student\", \"sam\"}, {\"teacher\", \"matz\"}]\n```","summary":"<p>Removes duplicate elements from <code>self</code>, using the block's value for comparison.</p>","abstract":false,"args":[],"args_string":"(&)","args_html":"(&)","location":{"filename":"src/array.cr","line_number":1922,"url":null},"def":{"name":"uniq!","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"if size <= 1\n  return self\nend\nhash = to_lookup_hash do |elem|\n  yield elem\nend\nif size == hash.size\n  return self\nend\nold_size = @size\n@size = hash.size\nremoved = old_size - @size\nif removed == 0\n  return self\nend\nptr = @buffer\nhash.each do |k, v|\n  ptr.value = v\n  ptr = ptr + 1\nend\n(@buffer + @size).clear(removed)\nself\n"}},{"id":"unsafe_fetch(index:Int)-instance-method","html_id":"unsafe_fetch(index:Int)-instance-method","name":"unsafe_fetch","doc":"Returns the element at the given *index*, without doing any bounds check.\n\n`Indexable` makes sure to invoke this method with *index* in `0...size`,\nso converting negative indices to positive ones is not needed here.\n\nClients never invoke this method directly. Instead, they access\nelements with `#[](index)` and `#[]?(index)`.\n\nThis method should only be directly invoked if you are absolutely\nsure the index is in bounds, to avoid a bounds check for a small boost\nof performance.","summary":"<p>Returns the element at the given <em>index</em>, without doing any bounds check.</p>","abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"}],"args_string":"(index : Int)","args_html":"(index : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/array.cr","line_number":663,"url":null},"def":{"name":"unsafe_fetch","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@buffer[index]"}},{"id":"unshift(object:T)-instance-method","html_id":"unshift(object:T)-instance-method","name":"unshift","doc":"Prepend. Adds *object* to the beginning of `self`, given that the type of the value is *T*\n(which might be a single type or a union of types).\nThis method returns `self`, so several calls can be chained.\nSee `shift` for the opposite effect.\n\n```\na = [\"a\", \"b\"]\na.unshift(\"c\") # => [\"c\", \"a\", \"b\"]\na.unshift(1)   # Errors, because the array only accepts String.\n\na = [\"a\", \"b\"] of (Int32 | String)\na.unshift(\"c\") # => [\"c\", \"a\", \"b\"]\na.unshift(1)   # => [1, \"c\", \"a\", \"b\"]\n```","summary":"<p>Prepend.</p>","abstract":false,"args":[{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":"T"}],"args_string":"(object : T)","args_html":"(object : T)","location":{"filename":"src/array.cr","line_number":1962,"url":null},"def":{"name":"unshift","args":[{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if @offset_to_buffer == 0\n  double_capacity_for_unshift\nend\nshift_buffer_by(-1)\n@buffer.value = object\n@size = @size + 1\nself\n"}},{"id":"unshift(*values:T)-instance-method","html_id":"unshift(*values:T)-instance-method","name":"unshift","doc":"Prepend multiple values. The same as `unshift`, but takes an arbitrary number\nof values to add to the array. Returns `self`.","summary":"<p>Prepend multiple values.</p>","abstract":false,"args":[{"name":"values","doc":null,"default_value":"","external_name":"values","restriction":"T"}],"args_string":"(*values : T)","args_html":"(*values : T)","location":{"filename":"src/array.cr","line_number":1983,"url":null},"def":{"name":"unshift","args":[{"name":"values","doc":null,"default_value":"","external_name":"values","restriction":"T"}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"values.reverse_each do |value|\n  unshift(value)\nend\nself\n"}},{"id":"update(index:Int,&)-instance-method","html_id":"update(index:Int,&)-instance-method","name":"update","doc":null,"summary":null,"abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"}],"args_string":"(index : Int, &)","args_html":"(index : <a href=\"Int.html\">Int</a>, &)","location":{"filename":"src/array.cr","line_number":1990,"url":null},"def":{"name":"update","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"index = check_index_out_of_bounds(index)\n@buffer[index] = yield @buffer[index]\n"}},{"id":"|(other:Array(U))forallU-instance-method","html_id":"|(other:Array(U))forallU-instance-method","name":"|","doc":"Set union: returns a new `Array` by joining `self` with *other*, excluding\nany duplicates, and preserving the order from `self`.\n\n```\n[\"a\", \"b\", \"c\"] | [\"c\", \"d\", \"a\"] # => [ \"a\", \"b\", \"c\", \"d\" ]\n```\n\nSee also: `#uniq`.","summary":"<p>Set union: returns a new <code><a href=\"Array.html\">Array</a></code> by joining <code>self</code> with <em>other</em>, excluding any duplicates, and preserving the order from <code>self</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array(U)"}],"args_string":"(other : Array(U)) forall U","args_html":"(other : <a href=\"Array.html\">Array</a>(U)) forall U","location":{"filename":"src/array.cr","line_number":286,"url":null},"def":{"name":"|","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Array(U)"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if (size + other.size) <= SMALL_ARRAY_SIZE\n  ary = Array(T | U).new\n  each do |elem|\n    if ary.includes?(elem)\n    else\n      ary << elem\n    end\n  end\n  other.each do |elem|\n    if ary.includes?(elem)\n    else\n      ary << elem\n    end\n  end\n  return ary\nend\nArray(T | U).build(size + other.size) do |buffer|\n  hash = Hash(T, Bool).new\n  i = 0\n  each do |obj|\n    if hash.has_key?(obj)\n    else\n      buffer[i] = obj\n      hash[obj] = true\n      i = i + 1\n    end\n  end\n  other.each do |obj|\n    if hash.has_key?(obj)\n    else\n      buffer[i] = obj\n      hash[obj] = true\n      i = i + 1\n    end\n  end\n  i\nend\n"}}],"macros":[],"types":[]},{"html_id":"Crystal/Atomic","path":"Atomic.html","kind":"struct","full_name":"Atomic(T)","name":"Atomic","abstract":false,"superclass":{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"A value that may be updated atomically.\n\nOnly primitive integer types, reference types or nilable reference types\ncan be used with an Atomic type.","summary":"<p>A value that may be updated atomically.</p>","class_methods":[],"constructors":[{"id":"new(value:T)-class-method","html_id":"new(value:T)-class-method","name":"new","doc":"Creates an Atomic with the given initial value.","summary":"<p>Creates an Atomic with the given initial value.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","args_html":"(value : T)","location":{"filename":"src/atomic.cr","line_number":7,"url":null},"def":{"name":"new","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = Atomic(T).allocate\n_.initialize(value)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"add(value:T)-instance-method","html_id":"add(value:T)-instance-method","name":"add","doc":"Performs `atomic_value += value`. Returns the old value.\n\n```\natomic = Atomic.new(1)\natomic.add(2) # => 1\natomic.get    # => 3\n```","summary":"<p>Performs <code>atomic_value += value</code>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","args_html":"(value : T)","location":{"filename":"src/atomic.cr","line_number":55,"url":null},"def":{"name":"add","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Ops.atomicrmw(:add, pointerof(@value), value, :sequentially_consistent, false)"}},{"id":"and(value:T)-instance-method","html_id":"and(value:T)-instance-method","name":"and","doc":"Performs `atomic_value &= value`. Returns the old value.\n\n```\natomic = Atomic.new(5)\natomic.and(3) # => 5\natomic.get    # => 1\n```","summary":"<p>Performs <code>atomic_value &= value</code>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","args_html":"(value : T)","location":{"filename":"src/atomic.cr","line_number":77,"url":null},"def":{"name":"and","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Ops.atomicrmw(:and, pointerof(@value), value, :sequentially_consistent, false)"}},{"id":"compare_and_set(cmp:T,new:T):Tuple(T,Bool)-instance-method","html_id":"compare_and_set(cmp:T,new:T):Tuple(T,Bool)-instance-method","name":"compare_and_set","doc":"Compares this atomic's value with *cmp*:\n\n* if they are equal, sets the value to *new*, and returns `{old_value, true}`\n* if they are not equal the value remains the same, and returns `{old_value, false}`\n\n```\natomic = Atomic.new(1)\n\natomic.compare_and_set(2, 3) # => {1, false}\natomic.get                   # => 1\n\natomic.compare_and_set(1, 3) # => {1, true}\natomic.get                   # => 3\n```","summary":"<p>Compares this atomic's value with <em>cmp</em>:</p>","abstract":false,"args":[{"name":"cmp","doc":null,"default_value":"","external_name":"cmp","restriction":"T"},{"name":"new","doc":null,"default_value":"","external_name":"new","restriction":"T"}],"args_string":"(cmp : T, new : T) : Tuple(T, Bool)","args_html":"(cmp : T, new : T) : <a href=\"Tuple.html\">Tuple</a>(T, <a href=\"Bool.html\">Bool</a>)","location":{"filename":"src/atomic.cr","line_number":31,"url":null},"def":{"name":"compare_and_set","args":[{"name":"cmp","doc":null,"default_value":"","external_name":"cmp","restriction":"T"},{"name":"new","doc":null,"default_value":"","external_name":"new","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"::Tuple(T, Bool)","visibility":"Public","body":"{% if T.union? && T.union_types.all? do |t|\n  (t == Nil) || t < Reference\nend %}\n      # If so, use addresses because LLVM < 3.9 doesn't support cmpxchg with pointers\n      address, success = Ops.cmpxchg(pointerof(@value).as(LibC::SizeT*), LibC::SizeT.new(cmp.as(T).object_id), LibC::SizeT.new(new.as(T).object_id), :sequentially_consistent, :sequentially_consistent)\n      {address == 0 ? nil : Pointer(T).new(address).as(T), success}\n      # Check if it's a reference type\n    {% else %}{% if T < Reference %}\n      # Use addresses again (but this can't return nil)\n      address, success = Ops.cmpxchg(pointerof(@value).as(LibC::SizeT*), LibC::SizeT.new(cmp.as(T).object_id), LibC::SizeT.new(new.as(T).object_id), :sequentially_consistent, :sequentially_consistent)\n      {Pointer(T).new(address).as(T), success}\n    {% else %}\n      # Otherwise, this is an integer type\n      Ops.cmpxchg(pointerof(@value), cmp, new, :sequentially_consistent, :sequentially_consistent)\n    {% end %}{% end %}"}},{"id":"get-instance-method","html_id":"get-instance-method","name":"get","doc":"Atomically returns this atomic's value.","summary":"<p>Atomically returns this atomic's value.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/atomic.cr","line_number":191,"url":null},"def":{"name":"get","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Ops.load(pointerof(@value), :sequentially_consistent, true)"}},{"id":"lazy_get-instance-method","html_id":"lazy_get-instance-method","name":"lazy_get","doc":"**Non-atomically** returns this atomic's value.","summary":"<p><strong>Non-atomically</strong> returns this atomic's value.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/atomic.cr","line_number":196,"url":null},"def":{"name":"lazy_get","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@value"}},{"id":"lazy_set(value:T)-instance-method","html_id":"lazy_set(value:T)-instance-method","name":"lazy_set","doc":"**Non-atomically** sets this atomic's value to *value*. Returns the **new** value.\n\n```\natomic = Atomic.new(5)\natomic.lazy_set(10) # => 10\natomic.get          # => 10\n```","summary":"<p><strong>Non-atomically</strong> sets this atomic's value to <em>value</em>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","args_html":"(value : T)","location":{"filename":"src/atomic.cr","line_number":187,"url":null},"def":{"name":"lazy_set","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@value = value"}},{"id":"max(value:T)-instance-method","html_id":"max(value:T)-instance-method","name":"max","doc":"Performs `atomic_value = max(atomic_value, value)`. Returns the old value.\n\n```\natomic = Atomic.new(5)\n\natomic.max(3) # => 5\natomic.get    # => 5\n\natomic.max(10) # => 5\natomic.get     # => 10\n```","summary":"<p>Performs <code>atomic_value = max(atomic_value, value)</code>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","args_html":"(value : T)","location":{"filename":"src/atomic.cr","line_number":125,"url":null},"def":{"name":"max","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% if T < Int::Signed %}\n      Ops.atomicrmw(:max, pointerof(@value), value, :sequentially_consistent, false)\n    {% else %}\n      Ops.atomicrmw(:umax, pointerof(@value), value, :sequentially_consistent, false)\n    {% end %}"}},{"id":"min(value:T)-instance-method","html_id":"min(value:T)-instance-method","name":"min","doc":"Performs `atomic_value = min(atomic_value, value)`. Returns the old value.\n\n```\natomic = Atomic.new(5)\n\natomic.min(10) # => 5\natomic.get     # => 5\n\natomic.min(3) # => 5\natomic.get    # => 3\n```","summary":"<p>Performs <code>atomic_value = min(atomic_value, value)</code>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","args_html":"(value : T)","location":{"filename":"src/atomic.cr","line_number":144,"url":null},"def":{"name":"min","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% if T < Int::Signed %}\n      Ops.atomicrmw(:min, pointerof(@value), value, :sequentially_consistent, false)\n    {% else %}\n      Ops.atomicrmw(:umin, pointerof(@value), value, :sequentially_consistent, false)\n    {% end %}"}},{"id":"nand(value:T)-instance-method","html_id":"nand(value:T)-instance-method","name":"nand","doc":"Performs `atomic_value = ~(atomic_value & value)`. Returns the old value.\n\n```\natomic = Atomic.new(5)\natomic.nand(3) # => 5\natomic.get     # => -2\n```","summary":"<p>Performs <code>atomic_value = ~(atomic_value & value)</code>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","args_html":"(value : T)","location":{"filename":"src/atomic.cr","line_number":88,"url":null},"def":{"name":"nand","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Ops.atomicrmw(:nand, pointerof(@value), value, :sequentially_consistent, false)"}},{"id":"or(value:T)-instance-method","html_id":"or(value:T)-instance-method","name":"or","doc":"Performs `atomic_value |= value`. Returns the old value.\n\n```\natomic = Atomic.new(5)\natomic.or(2) # => 5\natomic.get   # => 7\n```","summary":"<p>Performs <code>atomic_value |= value</code>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","args_html":"(value : T)","location":{"filename":"src/atomic.cr","line_number":99,"url":null},"def":{"name":"or","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Ops.atomicrmw(:or, pointerof(@value), value, :sequentially_consistent, false)"}},{"id":"set(value:T)-instance-method","html_id":"set(value:T)-instance-method","name":"set","doc":"Atomically sets this atomic's value to *value*. Returns the **new** value.\n\n```\natomic = Atomic.new(5)\natomic.set(10) # => 10\natomic.get     # => 10\n```","summary":"<p>Atomically sets this atomic's value to <em>value</em>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","args_html":"(value : T)","location":{"filename":"src/atomic.cr","line_number":175,"url":null},"def":{"name":"set","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Ops.store(pointerof(@value), value.as(T), :sequentially_consistent, true)\nvalue\n"}},{"id":"sub(value:T)-instance-method","html_id":"sub(value:T)-instance-method","name":"sub","doc":"Performs `atomic_value -= value`. Returns the old value.\n\n```\natomic = Atomic.new(9)\natomic.sub(2) # => 9\natomic.get    # => 7\n```","summary":"<p>Performs <code>atomic_value -= value</code>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","args_html":"(value : T)","location":{"filename":"src/atomic.cr","line_number":66,"url":null},"def":{"name":"sub","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Ops.atomicrmw(:sub, pointerof(@value), value, :sequentially_consistent, false)"}},{"id":"swap(value:T)-instance-method","html_id":"swap(value:T)-instance-method","name":"swap","doc":"Atomically sets this atomic's value to *value*. Returns the **old** value.\n\n```\natomic = Atomic.new(5)\natomic.swap(10) # => 5\natomic.get      # => 10\n```","summary":"<p>Atomically sets this atomic's value to <em>value</em>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","args_html":"(value : T)","location":{"filename":"src/atomic.cr","line_number":159,"url":null},"def":{"name":"swap","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% if (T.union? && T.union_types.all? do |t|\n  (t == Nil) || t < Reference\nend) || T < Reference %}\n      address = Ops.atomicrmw(:xchg, pointerof(@value).as(LibC::SizeT*), LibC::SizeT.new(value.as(T).object_id), :sequentially_consistent, false)\n      Pointer(T).new(address).as(T)\n    {% else %}\n      Ops.atomicrmw(:xchg, pointerof(@value), value, :sequentially_consistent, false)\n    {% end %}"}},{"id":"xor(value:T)-instance-method","html_id":"xor(value:T)-instance-method","name":"xor","doc":"Performs `atomic_value ^= value`. Returns the old value.\n\n```\natomic = Atomic.new(5)\natomic.xor(3) # => 5\natomic.get    # => 6\n```","summary":"<p>Performs <code>atomic_value ^= value</code>.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","args_html":"(value : T)","location":{"filename":"src/atomic.cr","line_number":110,"url":null},"def":{"name":"xor","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Ops.atomicrmw(:xor, pointerof(@value), value, :sequentially_consistent, false)"}}],"macros":[],"types":[{"html_id":"Crystal/Atomic/Flag","path":"Atomic/Flag.html","kind":"struct","full_name":"Atomic::Flag","name":"Flag","abstract":false,"superclass":{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Atomic","kind":"struct","full_name":"Atomic(T)","name":"Atomic"},"doc":"An atomic flag, that can be set or not.\n\nConcurrency safe. If many fibers try to set the atomic in parallel, only one\nwill succeed.\n\nExample:\n```\nflag = Atomic::Flag.new\nflag.test_and_set # => true\nflag.test_and_set # => false\nflag.clear\nflag.test_and_set # => true\n```","summary":"<p>An atomic flag, that can be set or not.</p>","class_methods":[],"constructors":[{"id":"new-class-method","html_id":"new-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/atomic.cr","line_number":240,"url":null},"def":{"name":"new","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"clear:Nil-instance-method","html_id":"clear:Nil-instance-method","name":"clear","doc":"Atomically clears the flag.","summary":"<p>Atomically clears the flag.</p>","abstract":false,"args":[],"args_string":" : Nil","args_html":" : <a href=\"../Nil.html\">Nil</a>","location":{"filename":"src/atomic.cr","line_number":251,"url":null},"def":{"name":"clear","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"Atomic::Ops.store(pointerof(@value), 0_u8, :sequentially_consistent, true)"}},{"id":"test_and_set:Bool-instance-method","html_id":"test_and_set:Bool-instance-method","name":"test_and_set","doc":"Atomically tries to set the flag. Only succeeds and returns `true` if the\nflag wasn't previously set; returns `false` otherwise.","summary":"<p>Atomically tries to set the flag.</p>","abstract":false,"args":[],"args_string":" : Bool","args_html":" : <a href=\"../Bool.html\">Bool</a>","location":{"filename":"src/atomic.cr","line_number":246,"url":null},"def":{"name":"test_and_set","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"(Atomic::Ops.atomicrmw(:xchg, pointerof(@value), 1_u8, :sequentially_consistent, false)) == 0_u8"}}],"macros":[],"types":[]}]},{"html_id":"Crystal/Base64","path":"Base64.html","kind":"module","full_name":"Base64","name":"Base64","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[{"html_id":"Crystal/Base64","kind":"module","full_name":"Base64","name":"Base64"}],"subclasses":[],"including_types":[],"namespace":null,"doc":"The `Base64` module provides for the encoding (`encode`, `strict_encode`,\n`urlsafe_encode`) and decoding (`decode`)\nof binary data using a base64 representation.\n\n### Example\n\nA simple encoding and decoding.\n\n```\nrequire \"base64\"\n\nenc = Base64.encode(\"Send reinforcements\") # => \"U2VuZCByZWluZm9yY2VtZW50cw==\\n\"\nplain = Base64.decode_string(enc)          # => \"Send reinforcements\"\n```\n\nThe purpose of using base64 to encode data is that it translates any binary\ndata into purely printable characters.","summary":"<p>The <code><a href=\"Base64.html\">Base64</a></code> module provides for the encoding (<code><a href=\"Base64.html#encode(data,io:IO)-instance-method\">#encode</a></code>, <code><a href=\"Base64.html#strict_encode(data,io:IO)-instance-method\">#strict_encode</a></code>, <code><a href=\"Base64.html#urlsafe_encode(data,io:IO)-instance-method\">#urlsafe_encode</a></code>) and decoding (<code><a href=\"Base64.html#decode(data,io:IO)-instance-method\">#decode</a></code>) of binary data using a base64 representation.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"decode(data,io:IO)-instance-method","html_id":"decode(data,io:IO)-instance-method","name":"decode","doc":"Writes the base64-decoded version of *data* to *io*.\nThis will decode either the normal or urlsafe alphabets.","summary":"<p>Writes the base64-decoded version of <em>data</em> to <em>io</em>.</p>","abstract":false,"args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(data, io : IO)","args_html":"(data, io : <a href=\"IO.html\">IO</a>)","location":{"filename":"src/base64.cr","line_number":171,"url":null},"def":{"name":"decode","args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"count = 0\nfrom_base64(data.to_slice) do |byte|\n  io.write_byte(byte)\n  count = count + 1\nend\nio.flush\ncount\n"}},{"id":"decode(data):Bytes-instance-method","html_id":"decode(data):Bytes-instance-method","name":"decode","doc":"Returns the base64-decoded version of *data* as a `Bytes`.\nThis will decode either the normal or urlsafe alphabets.","summary":"<p>Returns the base64-decoded version of <em>data</em> as a <code><a href=\"Bytes.html\">Bytes</a></code>.</p>","abstract":false,"args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""}],"args_string":"(data) : Bytes","args_html":"(data) : <a href=\"Bytes.html\">Bytes</a>","location":{"filename":"src/base64.cr","line_number":161,"url":null},"def":{"name":"decode","args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bytes","visibility":"Public","body":"slice = data.to_slice\nbuf = Pointer(UInt8).malloc(decode_size(slice.size))\nappender = buf.appender\nfrom_base64(slice) do |byte|\n  appender << byte\nend\nSlice.new(buf, appender.size.to_i32)\n"}},{"id":"decode_string(data):String-instance-method","html_id":"decode_string(data):String-instance-method","name":"decode_string","doc":"Returns the base64-decoded version of *data* as a string.\nThis will decode either the normal or urlsafe alphabets.","summary":"<p>Returns the base64-decoded version of <em>data</em> as a string.</p>","abstract":false,"args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""}],"args_string":"(data) : String","args_html":"(data) : <a href=\"String.html\">String</a>","location":{"filename":"src/base64.cr","line_number":183,"url":null},"def":{"name":"decode_string","args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"slice = data.to_slice\nString.new(decode_size(slice.size)) do |buf|\n  appender = buf.appender\n  from_base64(slice) do |byte|\n    appender << byte\n  end\n  {appender.size, 0}\nend\n"}},{"id":"encode(data,io:IO)-instance-method","html_id":"encode(data,io:IO)-instance-method","name":"encode","doc":"Writes the base64-encoded version of *data* to *io*.\nThis method complies with [RFC 2045](https://tools.ietf.org/html/rfc2045).\nLine feeds are added to every 60 encoded characters.\n\n```\nBase64.encode(\"Now is the time for all good coders\\nto learn Crystal\", STDOUT)\n```","summary":"<p>Writes the base64-encoded version of <em>data</em> to <em>io</em>.</p>","abstract":false,"args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(data, io : IO)","args_html":"(data, io : <a href=\"IO.html\">IO</a>)","location":{"filename":"src/base64.cr","line_number":61,"url":null},"def":{"name":"encode","args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"count = 0\nencode_with_new_lines(data.to_slice) do |byte|\n  io.write_byte(byte)\n  count = count + 1\nend\nio.flush\ncount\n"}},{"id":"encode(data):String-instance-method","html_id":"encode(data):String-instance-method","name":"encode","doc":"Returns the base64-encoded version of *data*.\nThis method complies with [RFC 2045](https://tools.ietf.org/html/rfc2045).\nLine feeds are added to every 60 encoded characters.\n\n```\nputs Base64.encode(\"Now is the time for all good coders\\nto learn Crystal\")\n```\n\nGenerates:\n\n```text\nTm93IGlzIHRoZSB0aW1lIGZvciBhbGwgZ29vZCBjb2RlcnMKdG8gbGVhcm4g\nQ3J5c3RhbA==\n```","summary":"<p>Returns the base64-encoded version of <em>data</em>.</p>","abstract":false,"args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""}],"args_string":"(data) : String","args_html":"(data) : <a href=\"String.html\">String</a>","location":{"filename":"src/base64.cr","line_number":44,"url":null},"def":{"name":"encode","args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"slice = data.to_slice\nString.new(encode_size(slice.size, new_lines: true)) do |buf|\n  appender = buf.appender\n  encode_with_new_lines(slice) do |byte|\n    appender << byte\n  end\n  size = appender.size\n  {size, size}\nend\n"}},{"id":"strict_encode(data,io:IO)-instance-method","html_id":"strict_encode(data,io:IO)-instance-method","name":"strict_encode","doc":"Writes the base64-encoded version of *data* with no newlines to *io*.\nThis method complies with [RFC 4648](https://tools.ietf.org/html/rfc4648).\n\n```\nBase64.strict_encode(\"Now is the time for all good coders\\nto learn Crystal\", STDOUT)\n```","summary":"<p>Writes the base64-encoded version of <em>data</em> with no newlines to <em>io</em>.</p>","abstract":false,"args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(data, io : IO)","args_html":"(data, io : <a href=\"IO.html\">IO</a>)","location":{"filename":"src/base64.cr","line_number":118,"url":null},"def":{"name":"strict_encode","args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"strict_encode_to_io_internal(data, io, CHARS_STD, pad: true)"}},{"id":"strict_encode(data):String-instance-method","html_id":"strict_encode(data):String-instance-method","name":"strict_encode","doc":"Returns the base64-encoded version of *data* with no newlines.\nThis method complies with [RFC 4648](https://tools.ietf.org/html/rfc4648).\n\n```\nputs Base64.strict_encode(\"Now is the time for all good coders\\nto learn Crystal\")\n```\n\nGenerates:\n\n```text\nTm93IGlzIHRoZSB0aW1lIGZvciBhbGwgZ29vZCBjb2RlcnMKdG8gbGVhcm4gQ3J5c3RhbA==\n```","summary":"<p>Returns the base64-encoded version of <em>data</em> with no newlines.</p>","abstract":false,"args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""}],"args_string":"(data) : String","args_html":"(data) : <a href=\"String.html\">String</a>","location":{"filename":"src/base64.cr","line_number":98,"url":null},"def":{"name":"strict_encode","args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"strict_encode(data, CHARS_STD, pad: true)"}},{"id":"urlsafe_encode(data,io:IO)-instance-method","html_id":"urlsafe_encode(data,io:IO)-instance-method","name":"urlsafe_encode","doc":"Writes the base64-encoded version of *data* using a urlsafe alphabet to *io*.\nThis method complies with \"Base 64 Encoding with URL and Filename Safe\nAlphabet\" in [RFC 4648](https://tools.ietf.org/html/rfc4648).\n\nThe alphabet uses `'-'` instead of `'+'` and `'_'` instead of `'/'`.","summary":"<p>Writes the base64-encoded version of <em>data</em> using a urlsafe alphabet to <em>io</em>.</p>","abstract":false,"args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(data, io : IO)","args_html":"(data, io : <a href=\"IO.html\">IO</a>)","location":{"filename":"src/base64.cr","line_number":155,"url":null},"def":{"name":"urlsafe_encode","args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"strict_encode_to_io_internal(data, io, CHARS_SAFE, pad: true)"}},{"id":"urlsafe_encode(data,padding=true):String-instance-method","html_id":"urlsafe_encode(data,padding=true):String-instance-method","name":"urlsafe_encode","doc":"Returns the base64-encoded version of *data* using a urlsafe alphabet.\nThis method complies with \"Base 64 Encoding with URL and Filename Safe\nAlphabet\" in [RFC 4648](https://tools.ietf.org/html/rfc4648).\n\nThe alphabet uses `'-'` instead of `'+'` and `'_'` instead of `'/'`.\n\nThe *padding* parameter defaults to `true`. When `false`, enough `=` characters\nare not added to make the output divisible by 4.","summary":"<p>Returns the base64-encoded version of <em>data</em> using a urlsafe alphabet.</p>","abstract":false,"args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"padding","doc":null,"default_value":"true","external_name":"padding","restriction":""}],"args_string":"(data, padding = <span class=\"n\">true</span>) : String","args_html":"(data, padding = <span class=\"n\">true</span>) : <a href=\"String.html\">String</a>","location":{"filename":"src/base64.cr","line_number":140,"url":null},"def":{"name":"urlsafe_encode","args":[{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":""},{"name":"padding","doc":null,"default_value":"true","external_name":"padding","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"slice = data.to_slice\nString.new(encode_size(slice.size)) do |buf|\n  appender = buf.appender\n  to_base64(slice, CHARS_SAFE, pad: padding) do |byte|\n    appender << byte\n  end\n  size = appender.size\n  {size, size}\nend\n"}}],"macros":[],"types":[{"html_id":"Crystal/Base64/Error","path":"Base64/Error.html","kind":"class","full_name":"Base64::Error","name":"Error","abstract":false,"superclass":{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},"ancestors":[{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Base64","kind":"module","full_name":"Base64","name":"Base64"},"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]}]},{"html_id":"Crystal/Benchmark","path":"Benchmark.html","kind":"module","full_name":"Benchmark","name":"Benchmark","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[{"html_id":"Crystal/Benchmark","kind":"module","full_name":"Benchmark","name":"Benchmark"}],"subclasses":[],"including_types":[],"namespace":null,"doc":"The Benchmark module provides methods for benchmarking Crystal code, giving\ndetailed reports on the time and memory taken for each task.\n\n### Measure the number of iterations per second of each task\n\n```\nrequire \"benchmark\"\n\nBenchmark.ips do |x|\n  x.report(\"short sleep\") { sleep 0.01 }\n  x.report(\"shorter sleep\") { sleep 0.001 }\nend\n```\n\nThis generates the following output showing the mean iterations per second,\nthe mean times per iteration, the standard deviation relative to the mean, and a comparison:\n\n```text\n  short sleep   88.7  ( 11.27ms) (± 3.33%)  8.90× slower\nshorter sleep  789.7  (  1.27ms) (± 3.02%)       fastest\n```\n\n`Benchmark::IPS` defaults to 2 seconds of warmup time and 5 seconds of\ncalculation time. This can be configured:\n\n```\nrequire \"benchmark\"\n\nBenchmark.ips(warmup: 4, calculation: 10) do |x|\n  x.report(\"sleep\") { sleep 0.01 }\nend\n```\n\nMake sure to always benchmark code by compiling with the `--release` flag.\n\n### Measure the time to construct the string given by the expression: `\"a\"*1_000_000_000`\n\n```\nrequire \"benchmark\"\n\nputs Benchmark.measure { \"a\"*1_000_000_000 }\n```\n\nThis generates the following output:\n\n```text\n 0.190000   0.220000   0.410000 (  0.420185)\n```\n\nThis report shows the user CPU time, system CPU time, the sum of\nthe user and system CPU times, and the elapsed real time. The unit\nof time is seconds.\n\n### Do some experiments sequentially using the `#bm` method:\n\n```\nrequire \"benchmark\"\n\nn = 5000000\nBenchmark.bm do |x|\n  x.report(\"times:\") do\n    n.times do\n      a = \"1\"\n    end\n  end\n  x.report(\"upto:\") do\n    1.upto(n) do\n      a = \"1\"\n    end\n  end\nend\n```\n\nThe result:\n\n```text\n           user     system      total        real\ntimes:   0.010000   0.000000   0.010000 (  0.008976)\nupto:    0.010000   0.000000   0.010000 (  0.010466)\n```\n\nMake sure to always benchmark code by compiling with the `--release` flag.","summary":"<p>The Benchmark module provides methods for benchmarking Crystal code, giving detailed reports on the time and memory taken for each task.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"bm(&)-instance-method","html_id":"bm(&)-instance-method","name":"bm","doc":"Main interface of the `Benchmark` module. Yields a `Job` to which\none can report the benchmarks. See the module's description.","summary":"<p>Main interface of the <code><a href=\"Benchmark.html\">Benchmark</a></code> module.</p>","abstract":false,"args":[],"args_string":"(&)","args_html":"(&)","location":{"filename":"src/benchmark.cr","line_number":90,"url":null},"def":{"name":"bm","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"{% if !(flag?(:release)) %}\n      puts \"Warning: benchmarking without the `--release` flag won't yield useful results\"\n    {% end %}\nreport = BM::Job.new\nyield report\nreport.execute\nreport\n"}},{"id":"ips(calculation=5,warmup=2,interactive=STDOUT.tty?,&)-instance-method","html_id":"ips(calculation=5,warmup=2,interactive=STDOUT.tty?,&)-instance-method","name":"ips","doc":"Instruction per second interface of the `Benchmark` module. Yields a `Job`\nto which one can report the benchmarks. See the module's description.\n\nThe optional parameters *calculation* and *warmup* set the duration of\nthose stages in seconds. For more detail on these stages see\n`Benchmark::IPS`. When the *interactive* parameter is `true`, results are\ndisplayed and updated as they are calculated, otherwise all at once.","summary":"<p>Instruction per second interface of the <code><a href=\"Benchmark.html\">Benchmark</a></code> module.</p>","abstract":false,"args":[{"name":"calculation","doc":null,"default_value":"5","external_name":"calculation","restriction":""},{"name":"warmup","doc":null,"default_value":"2","external_name":"warmup","restriction":""},{"name":"interactive","doc":null,"default_value":"STDOUT.tty?","external_name":"interactive","restriction":""}],"args_string":"(calculation = <span class=\"n\">5</span>, warmup = <span class=\"n\">2</span>, interactive = <span class=\"t\">STDOUT</span>.tty?, &)","args_html":"(calculation = <span class=\"n\">5</span>, warmup = <span class=\"n\">2</span>, interactive = <span class=\"t\">STDOUT</span>.tty?, &)","location":{"filename":"src/benchmark.cr","line_number":108,"url":null},"def":{"name":"ips","args":[{"name":"calculation","doc":null,"default_value":"5","external_name":"calculation","restriction":""},{"name":"warmup","doc":null,"default_value":"2","external_name":"warmup","restriction":""},{"name":"interactive","doc":null,"default_value":"STDOUT.tty?","external_name":"interactive","restriction":""}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"{% if !(flag?(:release)) %}\n      puts \"Warning: benchmarking without the `--release` flag won't yield useful results\"\n    {% end %}\njob = IPS::Job.new(calculation, warmup, interactive)\nyield job\njob.execute\njob.report\njob\n"}},{"id":"measure(label=&quot;&quot;,&):BM::Tms-instance-method","html_id":"measure(label=&quot;&quot;,&):BM::Tms-instance-method","name":"measure","doc":"Returns the time used to execute the given block.","summary":"<p>Returns the time used to execute the given block.</p>","abstract":false,"args":[{"name":"label","doc":null,"default_value":"\"\"","external_name":"label","restriction":""}],"args_string":"(label = <span class=\"s\">&quot;&quot;</span>, &) : BM::Tms","args_html":"(label = <span class=\"s\">&quot;&quot;</span>, &) : <a href=\"Benchmark/BM/Tms.html\">BM::Tms</a>","location":{"filename":"src/benchmark.cr","line_number":121,"url":null},"def":{"name":"measure","args":[{"name":"label","doc":null,"default_value":"\"\"","external_name":"label","restriction":""}],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"BM::Tms","visibility":"Public","body":"t0, r0 = Process.times, Time.monotonic\nyield\nt1, r1 = Process.times, Time.monotonic\nBM::Tms.new(t1.utime - t0.utime, t1.stime - t0.stime, t1.cutime - t0.cutime, t1.cstime - t0.cstime, (r1 - r0).total_seconds, label)\n"}},{"id":"memory(&)-instance-method","html_id":"memory(&)-instance-method","name":"memory","doc":"Returns the memory in bytes that the given block consumes.\n\n```\nBenchmark.memory { Array(Int32).new } # => 32\n```","summary":"<p>Returns the memory in bytes that the given block consumes.</p>","abstract":false,"args":[],"args_string":"(&)","args_html":"(&)","location":{"filename":"src/benchmark.cr","line_number":147,"url":null},"def":{"name":"memory","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"","visibility":"Public","body":"bytes_before_measure = GC.stats.total_bytes\nyield\n(GC.stats.total_bytes - bytes_before_measure).to_i64\n"}},{"id":"realtime(&):Time::Span-instance-method","html_id":"realtime(&):Time::Span-instance-method","name":"realtime","doc":"Returns the elapsed real time used to execute the given block.\n\n```\nBenchmark.realtime { \"a\" * 100_000 } # => 00:00:00.0005840\n```","summary":"<p>Returns the elapsed real time used to execute the given block.</p>","abstract":false,"args":[],"args_string":"(&) : Time::Span","args_html":"(&) : <a href=\"Time/Span.html\">Time::Span</a>","location":{"filename":"src/benchmark.cr","line_number":138,"url":null},"def":{"name":"realtime","args":[],"double_splat":null,"splat_index":null,"yields":0,"block_arg":null,"return_type":"Time::Span","visibility":"Public","body":"Time.measure do\n  yield\nend"}}],"macros":[],"types":[{"html_id":"Crystal/Benchmark/BM","path":"Benchmark/BM.html","kind":"module","full_name":"Benchmark::BM","name":"BM","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Benchmark","kind":"module","full_name":"Benchmark","name":"Benchmark"},"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[{"html_id":"Crystal/Benchmark/BM/Job","path":"Benchmark/BM/Job.html","kind":"class","full_name":"Benchmark::BM::Job","name":"Job","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Benchmark/BM","kind":"module","full_name":"Benchmark::BM","name":"BM"},"doc":"Yielded by `Benchmark#bm`, use `#report` to report benchmarks.","summary":"<p>Yielded by <code><a href=\"../../Benchmark.html#bm(&)-instance-method\">Benchmark#bm</a></code>, use <code><a href=\"../../Benchmark/BM/Job.html#report(label=&quot;&quot;,&block)-instance-method\">#report</a></code> to report benchmarks.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"report(label=&quot;&quot;,&block)-instance-method","html_id":"report(label=&quot;&quot;,&block)-instance-method","name":"report","doc":"Reports a single benchmark unit.","summary":"<p>Reports a single benchmark unit.</p>","abstract":false,"args":[{"name":"label","doc":null,"default_value":"\" \"","external_name":"label","restriction":""}],"args_string":"(label = <span class=\"s\">&quot; &quot;</span>, &block)","args_html":"(label = <span class=\"s\">&quot; &quot;</span>, &block)","location":{"filename":"src/benchmark/bm.cr","line_number":47,"url":null},"def":{"name":"report","args":[{"name":"label","doc":null,"default_value":"\" \"","external_name":"label","restriction":""}],"double_splat":null,"splat_index":null,"yields":0,"block_arg":{"name":"block","doc":null,"default_value":"","external_name":"block","restriction":""},"return_type":"","visibility":"Public","body":"if label.size > @label_width\n  @label_width = label.size\nend\n@reports << {label, block}\n"}}],"macros":[],"types":[]},{"html_id":"Crystal/Benchmark/BM/Tms","path":"Benchmark/BM/Tms.html","kind":"class","full_name":"Benchmark::BM::Tms","name":"Tms","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Benchmark/BM","kind":"module","full_name":"Benchmark::BM","name":"BM"},"doc":"A data object, representing the times associated with a benchmark measurement.","summary":"<p>A data object, representing the times associated with a benchmark measurement.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"cstime:Float64-instance-method","html_id":"cstime:Float64-instance-method","name":"cstime","doc":"System CPU time of children","summary":"<p>System CPU time of children</p>","abstract":false,"args":[],"args_string":" : Float64","args_html":" : <a href=\"../../Float64.html\">Float64</a>","location":{"filename":"src/benchmark/bm.cr","line_number":15,"url":null},"def":{"name":"cstime","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64","visibility":"Public","body":"@cstime"}},{"id":"cutime:Float64-instance-method","html_id":"cutime:Float64-instance-method","name":"cutime","doc":"User CPU time of children","summary":"<p>User CPU time of children</p>","abstract":false,"args":[],"args_string":" : Float64","args_html":" : <a href=\"../../Float64.html\">Float64</a>","location":{"filename":"src/benchmark/bm.cr","line_number":12,"url":null},"def":{"name":"cutime","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64","visibility":"Public","body":"@cutime"}},{"id":"label:String-instance-method","html_id":"label:String-instance-method","name":"label","doc":"The label associated with this measure","summary":"<p>The label associated with this measure</p>","abstract":false,"args":[],"args_string":" : String","args_html":" : <a href=\"../../String.html\">String</a>","location":{"filename":"src/benchmark/bm.cr","line_number":21,"url":null},"def":{"name":"label","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"@label"}},{"id":"real:Float64-instance-method","html_id":"real:Float64-instance-method","name":"real","doc":"Elapsed real time","summary":"<p>Elapsed real time</p>","abstract":false,"args":[],"args_string":" : Float64","args_html":" : <a href=\"../../Float64.html\">Float64</a>","location":{"filename":"src/benchmark/bm.cr","line_number":18,"url":null},"def":{"name":"real","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64","visibility":"Public","body":"@real"}},{"id":"stime:Float64-instance-method","html_id":"stime:Float64-instance-method","name":"stime","doc":"System CPU time","summary":"<p>System CPU time</p>","abstract":false,"args":[],"args_string":" : Float64","args_html":" : <a href=\"../../Float64.html\">Float64</a>","location":{"filename":"src/benchmark/bm.cr","line_number":9,"url":null},"def":{"name":"stime","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64","visibility":"Public","body":"@stime"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Prints *utime*, *stime*, *total* and *real* to the given IO.","summary":"<p>Prints <em>utime</em>, <em>stime</em>, <em>total</em> and <em>real</em> to the given IO.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../../IO.html\">IO</a>) : <a href=\"../../Nil.html\">Nil</a>","location":{"filename":"src/benchmark/bm.cr","line_number":33,"url":null},"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io.printf(\"  %.6f   %.6f   %.6f (  %.6f)\", utime, stime, total, real)"}},{"id":"total-instance-method","html_id":"total-instance-method","name":"total","doc":"Total time, that is utime + stime + cutime + cstime","summary":"<p>Total time, that is utime + stime + cutime + cstime</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/benchmark/bm.cr","line_number":28,"url":null},"def":{"name":"total","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"((utime + stime) + cutime) + cstime"}},{"id":"utime:Float64-instance-method","html_id":"utime:Float64-instance-method","name":"utime","doc":"User CPU time","summary":"<p>User CPU time</p>","abstract":false,"args":[],"args_string":" : Float64","args_html":" : <a href=\"../../Float64.html\">Float64</a>","location":{"filename":"src/benchmark/bm.cr","line_number":6,"url":null},"def":{"name":"utime","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64","visibility":"Public","body":"@utime"}}],"macros":[],"types":[]}]},{"html_id":"Crystal/Benchmark/IPS","path":"Benchmark/IPS.html","kind":"module","full_name":"Benchmark::IPS","name":"IPS","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Benchmark","kind":"module","full_name":"Benchmark","name":"Benchmark"},"doc":"Benchmark IPS calculates the number of iterations per second for a given\nblock of code. The strategy is to use two stages: a warmup stage and a\ncalculation stage.\n\nThe warmup phase defaults to 2 seconds. During this stage we figure out how\nmany cycles are needed to run the block for roughly 100ms, and record it.\n\nThe calculation defaults to 5 seconds. During this stage we run the block\nin sets of the size calculated in the warmup stage. The measurements for\nthose sets are then used to calculate the mean and standard deviation,\nwhich are then reported. Additionally we compare the means to that of the\nfastest.","summary":"<p>Benchmark IPS calculates the number of iterations per second for a given block of code.</p>","class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[{"html_id":"Crystal/Benchmark/IPS/Entry","path":"Benchmark/IPS/Entry.html","kind":"class","full_name":"Benchmark::IPS::Entry","name":"Entry","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Benchmark/IPS","kind":"module","full_name":"Benchmark::IPS","name":"IPS"},"doc":null,"summary":null,"class_methods":[],"constructors":[{"id":"new(label:String,action:->)-class-method","html_id":"new(label:String,action:->)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"label","doc":null,"default_value":"","external_name":"label","restriction":"String"},{"name":"action","doc":null,"default_value":"","external_name":"action","restriction":"(-> )"}],"args_string":"(label : String, action :  -> )","args_html":"(label : <a href=\"../../String.html\">String</a>, action :  -> )","location":{"filename":"src/benchmark/ips.cr","line_number":160,"url":null},"def":{"name":"new","args":[{"name":"label","doc":null,"default_value":"","external_name":"label","restriction":"String"},{"name":"action","doc":null,"default_value":"","external_name":"action","restriction":"(-> )"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(label, action)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"action:->-instance-method","html_id":"action:->-instance-method","name":"action","doc":"Code to be benchmarked","summary":"<p>Code to be benchmarked</p>","abstract":false,"args":[],"args_string":" :  -> ","args_html":" :  -> ","location":{"filename":"src/benchmark/ips.cr","line_number":130,"url":null},"def":{"name":"action","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"(-> )","visibility":"Public","body":"@action"}},{"id":"action=(action:->)-instance-method","html_id":"action=(action:->)-instance-method","name":"action=","doc":"Code to be benchmarked","summary":"<p>Code to be benchmarked</p>","abstract":false,"args":[{"name":"action","doc":null,"default_value":"","external_name":"action","restriction":"(-> )"}],"args_string":"(action :  -> )","args_html":"(action :  -> )","location":{"filename":"src/benchmark/ips.cr","line_number":130,"url":null},"def":{"name":"action=","args":[{"name":"action","doc":null,"default_value":"","external_name":"action","restriction":"(-> )"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@action = action"}},{"id":"bytes_per_op:UInt64-instance-method","html_id":"bytes_per_op:UInt64-instance-method","name":"bytes_per_op","doc":"Number of bytes allocated per operation","summary":"<p>Number of bytes allocated per operation</p>","abstract":false,"args":[],"args_string":" : UInt64","args_html":" : <a href=\"../../UInt64.html\">UInt64</a>","location":null,"def":{"name":"bytes_per_op","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt64","visibility":"Public","body":"if (value = @bytes_per_op).nil?\n  ::raise(NilAssertionError.new(\"Benchmark::IPS::Entry#bytes_per_op cannot be nil\"))\nelse\n  value\nend"}},{"id":"bytes_per_op=(bytes_per_op:UInt64)-instance-method","html_id":"bytes_per_op=(bytes_per_op:UInt64)-instance-method","name":"bytes_per_op=","doc":"Number of bytes allocated per operation","summary":"<p>Number of bytes allocated per operation</p>","abstract":false,"args":[{"name":"bytes_per_op","doc":null,"default_value":"","external_name":"bytes_per_op","restriction":"UInt64"}],"args_string":"(bytes_per_op : UInt64)","args_html":"(bytes_per_op : <a href=\"../../UInt64.html\">UInt64</a>)","location":{"filename":"src/benchmark/ips.cr","line_number":155,"url":null},"def":{"name":"bytes_per_op=","args":[{"name":"bytes_per_op","doc":null,"default_value":"","external_name":"bytes_per_op","restriction":"UInt64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@bytes_per_op = bytes_per_op"}},{"id":"bytes_per_op?:UInt64?-instance-method","html_id":"bytes_per_op?:UInt64?-instance-method","name":"bytes_per_op?","doc":"Number of bytes allocated per operation","summary":"<p>Number of bytes allocated per operation</p>","abstract":false,"args":[],"args_string":" : UInt64?","args_html":" : <a href=\"../../UInt64.html\">UInt64</a>?","location":null,"def":{"name":"bytes_per_op?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt64 | ::Nil","visibility":"Public","body":"@bytes_per_op"}},{"id":"calculate_stats(samples)-instance-method","html_id":"calculate_stats(samples)-instance-method","name":"calculate_stats","doc":null,"summary":null,"abstract":false,"args":[{"name":"samples","doc":null,"default_value":"","external_name":"samples","restriction":""}],"args_string":"(samples)","args_html":"(samples)","location":{"filename":"src/benchmark/ips.cr","line_number":180,"url":null},"def":{"name":"calculate_stats","args":[{"name":"samples","doc":null,"default_value":"","external_name":"samples","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@ran = true\n@size = samples.size\n@mean = samples.sum.to_f / size.to_f\n@variance = (samples.reduce(0) do |acc, i|\n  acc + ((i - mean) ** 2)\nend).to_f / size.to_f\n@stddev = Math.sqrt(variance)\n@relative_stddev = 100.0 * (stddev / mean)\n"}},{"id":"call-instance-method","html_id":"call-instance-method","name":"call","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/benchmark/ips.cr","line_number":167,"url":null},"def":{"name":"call","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"action.call"}},{"id":"call_for_100ms-instance-method","html_id":"call_for_100ms-instance-method","name":"call_for_100ms","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/benchmark/ips.cr","line_number":171,"url":null},"def":{"name":"call_for_100ms","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"cycles.times do\n  action.call\nend"}},{"id":"cycles:Int32-instance-method","html_id":"cycles:Int32-instance-method","name":"cycles","doc":"Number of cycles needed to run for approx 100ms\nCalculated during the warmup stage","summary":"<p>Number of cycles needed to run for approx 100ms Calculated during the warmup stage</p>","abstract":false,"args":[],"args_string":" : Int32","args_html":" : <a href=\"../../Int32.html\">Int32</a>","location":null,"def":{"name":"cycles","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":"if (value = @cycles).nil?\n  ::raise(NilAssertionError.new(\"Benchmark::IPS::Entry#cycles cannot be nil\"))\nelse\n  value\nend"}},{"id":"cycles=(cycles:Int32)-instance-method","html_id":"cycles=(cycles:Int32)-instance-method","name":"cycles=","doc":"Number of cycles needed to run for approx 100ms\nCalculated during the warmup stage","summary":"<p>Number of cycles needed to run for approx 100ms Calculated during the warmup stage</p>","abstract":false,"args":[{"name":"cycles","doc":null,"default_value":"","external_name":"cycles","restriction":"Int32"}],"args_string":"(cycles : Int32)","args_html":"(cycles : <a href=\"../../Int32.html\">Int32</a>)","location":{"filename":"src/benchmark/ips.cr","line_number":134,"url":null},"def":{"name":"cycles=","args":[{"name":"cycles","doc":null,"default_value":"","external_name":"cycles","restriction":"Int32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@cycles = cycles"}},{"id":"cycles?:Int32?-instance-method","html_id":"cycles?:Int32?-instance-method","name":"cycles?","doc":"Number of cycles needed to run for approx 100ms\nCalculated during the warmup stage","summary":"<p>Number of cycles needed to run for approx 100ms Calculated during the warmup stage</p>","abstract":false,"args":[],"args_string":" : Int32?","args_html":" : <a href=\"../../Int32.html\">Int32</a>?","location":null,"def":{"name":"cycles?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32 | ::Nil","visibility":"Public","body":"@cycles"}},{"id":"human_compare-instance-method","html_id":"human_compare-instance-method","name":"human_compare","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/benchmark/ips.cr","line_number":202,"url":null},"def":{"name":"human_compare","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if slower == 1.0\n  \"fastest\"\nelse\n  sprintf(\"%5.2f× slower\", slower)\nend"}},{"id":"human_iteration_time-instance-method","html_id":"human_iteration_time-instance-method","name":"human_iteration_time","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/benchmark/ips.cr","line_number":193,"url":null},"def":{"name":"human_iteration_time","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"iteration_time = 1.0 / mean\niteration_time.humanize(precision: 2, significant: false) do |magnitude, _|\n  magnitude = (Number.prefix_index(magnitude)).clamp(-9..0)\n  {magnitude, magnitude == 0 ? \"s \" : \"#{Number.si_prefix(magnitude)}s\"}\nend.rjust(8)\n"}},{"id":"human_mean-instance-method","html_id":"human_mean-instance-method","name":"human_mean","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/benchmark/ips.cr","line_number":189,"url":null},"def":{"name":"human_mean","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"mean.humanize(precision: 2, significant: false, prefixes: Number::SI_PREFIXES_PADDED).rjust(7)"}},{"id":"label:String-instance-method","html_id":"label:String-instance-method","name":"label","doc":"Label of the benchmark","summary":"<p>Label of the benchmark</p>","abstract":false,"args":[],"args_string":" : String","args_html":" : <a href=\"../../String.html\">String</a>","location":{"filename":"src/benchmark/ips.cr","line_number":127,"url":null},"def":{"name":"label","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"@label"}},{"id":"label=(label:String)-instance-method","html_id":"label=(label:String)-instance-method","name":"label=","doc":"Label of the benchmark","summary":"<p>Label of the benchmark</p>","abstract":false,"args":[{"name":"label","doc":null,"default_value":"","external_name":"label","restriction":"String"}],"args_string":"(label : String)","args_html":"(label : <a href=\"../../String.html\">String</a>)","location":{"filename":"src/benchmark/ips.cr","line_number":127,"url":null},"def":{"name":"label=","args":[{"name":"label","doc":null,"default_value":"","external_name":"label","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@label = label"}},{"id":"mean:Float64-instance-method","html_id":"mean:Float64-instance-method","name":"mean","doc":"Statistical mean from calculation stage","summary":"<p>Statistical mean from calculation stage</p>","abstract":false,"args":[],"args_string":" : Float64","args_html":" : <a href=\"../../Float64.html\">Float64</a>","location":null,"def":{"name":"mean","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64","visibility":"Public","body":"if (value = @mean).nil?\n  ::raise(NilAssertionError.new(\"Benchmark::IPS::Entry#mean cannot be nil\"))\nelse\n  value\nend"}},{"id":"mean=(mean:Float64)-instance-method","html_id":"mean=(mean:Float64)-instance-method","name":"mean=","doc":"Statistical mean from calculation stage","summary":"<p>Statistical mean from calculation stage</p>","abstract":false,"args":[{"name":"mean","doc":null,"default_value":"","external_name":"mean","restriction":"Float64"}],"args_string":"(mean : Float64)","args_html":"(mean : <a href=\"../../Float64.html\">Float64</a>)","location":{"filename":"src/benchmark/ips.cr","line_number":140,"url":null},"def":{"name":"mean=","args":[{"name":"mean","doc":null,"default_value":"","external_name":"mean","restriction":"Float64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@mean = mean"}},{"id":"mean?:Float64?-instance-method","html_id":"mean?:Float64?-instance-method","name":"mean?","doc":"Statistical mean from calculation stage","summary":"<p>Statistical mean from calculation stage</p>","abstract":false,"args":[],"args_string":" : Float64?","args_html":" : <a href=\"../../Float64.html\">Float64</a>?","location":null,"def":{"name":"mean?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64 | ::Nil","visibility":"Public","body":"@mean"}},{"id":"ran?:Bool-instance-method","html_id":"ran?:Bool-instance-method","name":"ran?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Bool","args_html":" : <a href=\"../../Bool.html\">Bool</a>","location":{"filename":"src/benchmark/ips.cr","line_number":163,"url":null},"def":{"name":"ran?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@ran"}},{"id":"relative_stddev:Float64-instance-method","html_id":"relative_stddev:Float64-instance-method","name":"relative_stddev","doc":"Relative standard deviation as a percentage","summary":"<p>Relative standard deviation as a percentage</p>","abstract":false,"args":[],"args_string":" : Float64","args_html":" : <a href=\"../../Float64.html\">Float64</a>","location":null,"def":{"name":"relative_stddev","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64","visibility":"Public","body":"if (value = @relative_stddev).nil?\n  ::raise(NilAssertionError.new(\"Benchmark::IPS::Entry#relative_stddev cannot be nil\"))\nelse\n  value\nend"}},{"id":"relative_stddev=(relative_stddev:Float64)-instance-method","html_id":"relative_stddev=(relative_stddev:Float64)-instance-method","name":"relative_stddev=","doc":"Relative standard deviation as a percentage","summary":"<p>Relative standard deviation as a percentage</p>","abstract":false,"args":[{"name":"relative_stddev","doc":null,"default_value":"","external_name":"relative_stddev","restriction":"Float64"}],"args_string":"(relative_stddev : Float64)","args_html":"(relative_stddev : <a href=\"../../Float64.html\">Float64</a>)","location":{"filename":"src/benchmark/ips.cr","line_number":149,"url":null},"def":{"name":"relative_stddev=","args":[{"name":"relative_stddev","doc":null,"default_value":"","external_name":"relative_stddev","restriction":"Float64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@relative_stddev = relative_stddev"}},{"id":"relative_stddev?:Float64?-instance-method","html_id":"relative_stddev?:Float64?-instance-method","name":"relative_stddev?","doc":"Relative standard deviation as a percentage","summary":"<p>Relative standard deviation as a percentage</p>","abstract":false,"args":[],"args_string":" : Float64?","args_html":" : <a href=\"../../Float64.html\">Float64</a>?","location":null,"def":{"name":"relative_stddev?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64 | ::Nil","visibility":"Public","body":"@relative_stddev"}},{"id":"set_cycles(duration,iterations)-instance-method","html_id":"set_cycles(duration,iterations)-instance-method","name":"set_cycles","doc":null,"summary":null,"abstract":false,"args":[{"name":"duration","doc":null,"default_value":"","external_name":"duration","restriction":""},{"name":"iterations","doc":null,"default_value":"","external_name":"iterations","restriction":""}],"args_string":"(duration, iterations)","args_html":"(duration, iterations)","location":{"filename":"src/benchmark/ips.cr","line_number":175,"url":null},"def":{"name":"set_cycles","args":[{"name":"duration","doc":null,"default_value":"","external_name":"duration","restriction":""},{"name":"iterations","doc":null,"default_value":"","external_name":"iterations","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@cycles = ((iterations / duration.total_milliseconds) * 100).to_i\nif cycles <= 0\n  @cycles = 1\nend\n"}},{"id":"size:Int32-instance-method","html_id":"size:Int32-instance-method","name":"size","doc":"Number of 100ms runs during the calculation stage","summary":"<p>Number of 100ms runs during the calculation stage</p>","abstract":false,"args":[],"args_string":" : Int32","args_html":" : <a href=\"../../Int32.html\">Int32</a>","location":null,"def":{"name":"size","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":"if (value = @size).nil?\n  ::raise(NilAssertionError.new(\"Benchmark::IPS::Entry#size cannot be nil\"))\nelse\n  value\nend"}},{"id":"size=(size:Int32)-instance-method","html_id":"size=(size:Int32)-instance-method","name":"size=","doc":"Number of 100ms runs during the calculation stage","summary":"<p>Number of 100ms runs during the calculation stage</p>","abstract":false,"args":[{"name":"size","doc":null,"default_value":"","external_name":"size","restriction":"Int32"}],"args_string":"(size : Int32)","args_html":"(size : <a href=\"../../Int32.html\">Int32</a>)","location":{"filename":"src/benchmark/ips.cr","line_number":137,"url":null},"def":{"name":"size=","args":[{"name":"size","doc":null,"default_value":"","external_name":"size","restriction":"Int32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@size = size"}},{"id":"size?:Int32?-instance-method","html_id":"size?:Int32?-instance-method","name":"size?","doc":"Number of 100ms runs during the calculation stage","summary":"<p>Number of 100ms runs during the calculation stage</p>","abstract":false,"args":[],"args_string":" : Int32?","args_html":" : <a href=\"../../Int32.html\">Int32</a>?","location":null,"def":{"name":"size?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32 | ::Nil","visibility":"Public","body":"@size"}},{"id":"slower:Float64-instance-method","html_id":"slower:Float64-instance-method","name":"slower","doc":"Multiple slower than the fastest entry","summary":"<p>Multiple slower than the fastest entry</p>","abstract":false,"args":[],"args_string":" : Float64","args_html":" : <a href=\"../../Float64.html\">Float64</a>","location":null,"def":{"name":"slower","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64","visibility":"Public","body":"if (value = @slower).nil?\n  ::raise(NilAssertionError.new(\"Benchmark::IPS::Entry#slower cannot be nil\"))\nelse\n  value\nend"}},{"id":"slower=(slower:Float64)-instance-method","html_id":"slower=(slower:Float64)-instance-method","name":"slower=","doc":"Multiple slower than the fastest entry","summary":"<p>Multiple slower than the fastest entry</p>","abstract":false,"args":[{"name":"slower","doc":null,"default_value":"","external_name":"slower","restriction":"Float64"}],"args_string":"(slower : Float64)","args_html":"(slower : <a href=\"../../Float64.html\">Float64</a>)","location":{"filename":"src/benchmark/ips.cr","line_number":152,"url":null},"def":{"name":"slower=","args":[{"name":"slower","doc":null,"default_value":"","external_name":"slower","restriction":"Float64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@slower = slower"}},{"id":"slower?:Float64?-instance-method","html_id":"slower?:Float64?-instance-method","name":"slower?","doc":"Multiple slower than the fastest entry","summary":"<p>Multiple slower than the fastest entry</p>","abstract":false,"args":[],"args_string":" : Float64?","args_html":" : <a href=\"../../Float64.html\">Float64</a>?","location":null,"def":{"name":"slower?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64 | ::Nil","visibility":"Public","body":"@slower"}},{"id":"stddev:Float64-instance-method","html_id":"stddev:Float64-instance-method","name":"stddev","doc":"Statistical standard deviation from calculation stage","summary":"<p>Statistical standard deviation from calculation stage</p>","abstract":false,"args":[],"args_string":" : Float64","args_html":" : <a href=\"../../Float64.html\">Float64</a>","location":null,"def":{"name":"stddev","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64","visibility":"Public","body":"if (value = @stddev).nil?\n  ::raise(NilAssertionError.new(\"Benchmark::IPS::Entry#stddev cannot be nil\"))\nelse\n  value\nend"}},{"id":"stddev=(stddev:Float64)-instance-method","html_id":"stddev=(stddev:Float64)-instance-method","name":"stddev=","doc":"Statistical standard deviation from calculation stage","summary":"<p>Statistical standard deviation from calculation stage</p>","abstract":false,"args":[{"name":"stddev","doc":null,"default_value":"","external_name":"stddev","restriction":"Float64"}],"args_string":"(stddev : Float64)","args_html":"(stddev : <a href=\"../../Float64.html\">Float64</a>)","location":{"filename":"src/benchmark/ips.cr","line_number":146,"url":null},"def":{"name":"stddev=","args":[{"name":"stddev","doc":null,"default_value":"","external_name":"stddev","restriction":"Float64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@stddev = stddev"}},{"id":"stddev?:Float64?-instance-method","html_id":"stddev?:Float64?-instance-method","name":"stddev?","doc":"Statistical standard deviation from calculation stage","summary":"<p>Statistical standard deviation from calculation stage</p>","abstract":false,"args":[],"args_string":" : Float64?","args_html":" : <a href=\"../../Float64.html\">Float64</a>?","location":null,"def":{"name":"stddev?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64 | ::Nil","visibility":"Public","body":"@stddev"}},{"id":"variance:Float64-instance-method","html_id":"variance:Float64-instance-method","name":"variance","doc":"Statistical variance from calculation stage","summary":"<p>Statistical variance from calculation stage</p>","abstract":false,"args":[],"args_string":" : Float64","args_html":" : <a href=\"../../Float64.html\">Float64</a>","location":null,"def":{"name":"variance","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64","visibility":"Public","body":"if (value = @variance).nil?\n  ::raise(NilAssertionError.new(\"Benchmark::IPS::Entry#variance cannot be nil\"))\nelse\n  value\nend"}},{"id":"variance=(variance:Float64)-instance-method","html_id":"variance=(variance:Float64)-instance-method","name":"variance=","doc":"Statistical variance from calculation stage","summary":"<p>Statistical variance from calculation stage</p>","abstract":false,"args":[{"name":"variance","doc":null,"default_value":"","external_name":"variance","restriction":"Float64"}],"args_string":"(variance : Float64)","args_html":"(variance : <a href=\"../../Float64.html\">Float64</a>)","location":{"filename":"src/benchmark/ips.cr","line_number":143,"url":null},"def":{"name":"variance=","args":[{"name":"variance","doc":null,"default_value":"","external_name":"variance","restriction":"Float64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@variance = variance"}},{"id":"variance?:Float64?-instance-method","html_id":"variance?:Float64?-instance-method","name":"variance?","doc":"Statistical variance from calculation stage","summary":"<p>Statistical variance from calculation stage</p>","abstract":false,"args":[],"args_string":" : Float64?","args_html":" : <a href=\"../../Float64.html\">Float64</a>?","location":null,"def":{"name":"variance?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64 | ::Nil","visibility":"Public","body":"@variance"}}],"macros":[],"types":[]},{"html_id":"Crystal/Benchmark/IPS/Job","path":"Benchmark/IPS/Job.html","kind":"class","full_name":"Benchmark::IPS::Job","name":"Job","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Benchmark/IPS","kind":"module","full_name":"Benchmark::IPS","name":"IPS"},"doc":null,"summary":null,"class_methods":[],"constructors":[{"id":"new(calculation=5,warmup=2,interactive=STDOUT.tty?)-class-method","html_id":"new(calculation=5,warmup=2,interactive=STDOUT.tty?)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"calculation","doc":null,"default_value":"5","external_name":"calculation","restriction":""},{"name":"warmup","doc":null,"default_value":"2","external_name":"warmup","restriction":""},{"name":"interactive","doc":null,"default_value":"STDOUT.tty?","external_name":"interactive","restriction":""}],"args_string":"(calculation = <span class=\"n\">5</span>, warmup = <span class=\"n\">2</span>, interactive = <span class=\"t\">STDOUT</span>.tty?)","args_html":"(calculation = <span class=\"n\">5</span>, warmup = <span class=\"n\">2</span>, interactive = <span class=\"t\">STDOUT</span>.tty?)","location":{"filename":"src/benchmark/ips.cr","line_number":23,"url":null},"def":{"name":"new","args":[{"name":"calculation","doc":null,"default_value":"5","external_name":"calculation","restriction":""},{"name":"warmup","doc":null,"default_value":"2","external_name":"warmup","restriction":""},{"name":"interactive","doc":null,"default_value":"STDOUT.tty?","external_name":"interactive","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(calculation, warmup, interactive)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"execute-instance-method","html_id":"execute-instance-method","name":"execute","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/benchmark/ips.cr","line_number":37,"url":null},"def":{"name":"execute","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"run_warmup\nrun_calculation\nrun_comparison\n"}},{"id":"items:Array(Entry)-instance-method","html_id":"items:Array(Entry)-instance-method","name":"items","doc":"List of all entries in the benchmark.\nAfter #execute, these are populated with the resulting statistics.","summary":"<p>List of all entries in the benchmark.</p>","abstract":false,"args":[],"args_string":" : Array(Entry)","args_html":" : <a href=\"../../Array.html\">Array</a>(<a href=\"../../Benchmark/IPS/Entry.html\">Entry</a>)","location":{"filename":"src/benchmark/ips.cr","line_number":18,"url":null},"def":{"name":"items","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Array(Entry)","visibility":"Public","body":"@items"}},{"id":"items=(items:Array(Entry))-instance-method","html_id":"items=(items:Array(Entry))-instance-method","name":"items=","doc":"List of all entries in the benchmark.\nAfter #execute, these are populated with the resulting statistics.","summary":"<p>List of all entries in the benchmark.</p>","abstract":false,"args":[{"name":"items","doc":null,"default_value":"","external_name":"items","restriction":"Array(Entry)"}],"args_string":"(items : Array(Entry))","args_html":"(items : <a href=\"../../Array.html\">Array</a>(<a href=\"../../Benchmark/IPS/Entry.html\">Entry</a>))","location":{"filename":"src/benchmark/ips.cr","line_number":18,"url":null},"def":{"name":"items=","args":[{"name":"items","doc":null,"default_value":"","external_name":"items","restriction":"Array(Entry)"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@items = items"}},{"id":"report(label=&quot;&quot;,&action)-instance-method","html_id":"report(label=&quot;&quot;,&action)-instance-method","name":"report","doc":"Adds code to be benchmarked","summary":"<p>Adds code to be benchmarked</p>","abstract":false,"args":[{"name":"label","doc":null,"default_value":"\"\"","external_name":"label","restriction":""}],"args_string":"(label = <span class=\"s\">&quot;&quot;</span>, &action)","args_html":"(label = <span class=\"s\">&quot;&quot;</span>, &action)","location":{"filename":"src/benchmark/ips.cr","line_number":31,"url":null},"def":{"name":"report","args":[{"name":"label","doc":null,"default_value":"\"\"","external_name":"label","restriction":""}],"double_splat":null,"splat_index":null,"yields":0,"block_arg":{"name":"action","doc":null,"default_value":"","external_name":"action","restriction":""},"return_type":"","visibility":"Public","body":"item = Entry.new(label, action)\n@items << item\nitem\n"}},{"id":"report-instance-method","html_id":"report-instance-method","name":"report","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/benchmark/ips.cr","line_number":43,"url":null},"def":{"name":"report","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"max_label = ran_items.max_of do |__arg0|\n  __arg0.label.size\nend\nmax_compare = ran_items.max_of do |__arg1|\n  __arg1.human_compare.size\nend\nmax_bytes_per_op = ran_items.max_of do |__arg2|\n  __arg2.bytes_per_op.humanize(base: 1024).size\nend\nran_items.each do |item|\n  printf(\"%s %s (%s) (±%5.2f%%)  %sB/op  %s\\n\", item.label.rjust(max_label), item.human_mean, item.human_iteration_time, item.relative_stddev, item.bytes_per_op.humanize(base: 1024).rjust(max_bytes_per_op), item.human_compare.rjust(max_compare))\nend\n"}}],"macros":[],"types":[]}]}]},{"html_id":"Crystal/BigDecimal","path":"BigDecimal.html","kind":"struct","full_name":"BigDecimal","name":"BigDecimal","abstract":false,"superclass":{"html_id":"Crystal/Number","kind":"struct","full_name":"Number","name":"Number"},"ancestors":[{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Number","kind":"struct","full_name":"Number","name":"Number"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[{"id":"DEFAULT_MAX_DIV_ITERATIONS","name":"DEFAULT_MAX_DIV_ITERATIONS","value":"100_u64","doc":null,"summary":null},{"id":"TEN","name":"TEN","value":"BigInt.new(10)","doc":null,"summary":null},{"id":"ZERO","name":"ZERO","value":"BigInt.new(0)","doc":null,"summary":null}],"included_modules":[{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"}],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"A `BigDecimal` can represent arbitrarily large precision decimals.\n\nIt is internally represented by a pair of `BigInt` and `UInt64`: value and scale.\nValue contains the actual value, and scale tells the decimal point place.\nE.g. when value is `1234` and scale `2`, the result is `12.34`.\n\nThe general idea and some of the arithmetic algorithms were adapted from\nthe MIT/APACHE-licensed [bigdecimal-rs](https://github.com/akubera/bigdecimal-rs).","summary":"<p>A <code><a href=\"BigDecimal.html\">BigDecimal</a></code> can represent arbitrarily large precision decimals.</p>","class_methods":[],"constructors":[{"id":"new(value:BigInt,scale:UInt64)-class-method","html_id":"new(value:BigInt,scale:UInt64)-class-method","name":"new","doc":"Creates a new `BigDecimal` from `BigInt` *value* and `UInt64` *scale*,\nwhich matches the internal representation.","summary":"<p>Creates a new <code><a href=\"BigDecimal.html\">BigDecimal</a></code> from <code><a href=\"BigInt.html\">BigInt</a></code> <em>value</em> and <code><a href=\"UInt64.html\">UInt64</a></code> <em>scale</em>, which matches the internal representation.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"BigInt"},{"name":"scale","doc":null,"default_value":"","external_name":"scale","restriction":"UInt64"}],"args_string":"(value : BigInt, scale : UInt64)","args_html":"(value : <a href=\"BigInt.html\">BigInt</a>, scale : <a href=\"UInt64.html\">UInt64</a>)","location":{"filename":"src/big/big_decimal.cr","line_number":54,"url":null},"def":{"name":"new","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"BigInt"},{"name":"scale","doc":null,"default_value":"","external_name":"scale","restriction":"UInt64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(value, scale)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:Float)-class-method","html_id":"new(num:Float)-class-method","name":"new","doc":"Creates a new `BigDecimal` from `Float`.\n\nNOTE: Floats are fundamentally less precise than BigDecimals,\nwhich makes initialization from them risky.","summary":"<p>Creates a new <code><a href=\"BigDecimal.html\">BigDecimal</a></code> from <code><a href=\"Float.html\">Float</a></code>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Float"}],"args_string":"(num : Float)","args_html":"(num : <a href=\"Float.html\">Float</a>)","location":{"filename":"src/big/big_decimal.cr","line_number":34,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Float"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"new(num.to_s)"}},{"id":"new(num:BigRational)-class-method","html_id":"new(num:BigRational)-class-method","name":"new","doc":"Creates a new `BigDecimal` from `BigRational`.\n\nNOTE: BigRational are fundamentally more precise than BigDecimals,\nwhich makes initialization from them risky.","summary":"<p>Creates a new <code><a href=\"BigDecimal.html\">BigDecimal</a></code> from <code><a href=\"BigRational.html\">BigRational</a></code>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigRational"}],"args_string":"(num : BigRational)","args_html":"(num : <a href=\"BigRational.html\">BigRational</a>)","location":{"filename":"src/big/big_decimal.cr","line_number":42,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"num.numerator.to_big_d / num.denominator.to_big_d"}},{"id":"new(num:BigDecimal)-class-method","html_id":"new(num:BigDecimal)-class-method","name":"new","doc":"Returns *num*. Useful for generic code that does `T.new(...)` with `T`\nbeing a `Number`.","summary":"<p>Returns <em>num</em>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigDecimal"}],"args_string":"(num : BigDecimal)","args_html":"(num : <a href=\"BigDecimal.html\">BigDecimal</a>)","location":{"filename":"src/big/big_decimal.cr","line_number":48,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"num"}},{"id":"new(num:Int=0,scale:Int=0)-class-method","html_id":"new(num:Int=0,scale:Int=0)-class-method","name":"new","doc":"Creates a new `BigDecimal` from `Int`.","summary":"<p>Creates a new <code><a href=\"BigDecimal.html\">BigDecimal</a></code> from <code><a href=\"Int.html\">Int</a></code>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"0","external_name":"num","restriction":"Int"},{"name":"scale","doc":null,"default_value":"0","external_name":"scale","restriction":"Int"}],"args_string":"(num : Int = <span class=\"n\">0</span>, scale : Int = <span class=\"n\">0</span>)","args_html":"(num : <a href=\"Int.html\">Int</a> = <span class=\"n\">0</span>, scale : <a href=\"Int.html\">Int</a> = <span class=\"n\">0</span>)","location":{"filename":"src/big/big_decimal.cr","line_number":58,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"0","external_name":"num","restriction":"Int"},{"name":"scale","doc":null,"default_value":"0","external_name":"scale","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num, scale)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(str:String)-class-method","html_id":"new(str:String)-class-method","name":"new","doc":"Creates a new `BigDecimal` from a `String`.\n\nAllows only valid number strings with an optional negative sign.","summary":"<p>Creates a new <code><a href=\"BigDecimal.html\">BigDecimal</a></code> from a <code><a href=\"String.html\">String</a></code>.</p>","abstract":false,"args":[{"name":"str","doc":null,"default_value":"","external_name":"str","restriction":"String"}],"args_string":"(str : String)","args_html":"(str : <a href=\"String.html\">String</a>)","location":{"filename":"src/big/big_decimal.cr","line_number":65,"url":null},"def":{"name":"new","args":[{"name":"str","doc":null,"default_value":"","external_name":"str","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(str)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"*(other:BigDecimal):BigDecimal-instance-method","html_id":"*(other:BigDecimal):BigDecimal-instance-method","name":"*","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : BigDecimal","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":184,"url":null},"def":{"name":"*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"BigDecimal.new(@value * other.value, @scale + other.scale)"}},{"id":"*(other:Int)-instance-method","html_id":"*(other:Int)-instance-method","name":"*","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int)","args_html":"(other : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/big/big_decimal.cr","line_number":188,"url":null},"def":{"name":"*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self * (BigDecimal.new(other))"}},{"id":"**(other:Int):BigDecimal-instance-method","html_id":"**(other:Int):BigDecimal-instance-method","name":"**","doc":"Raises the decimal to the *other*th power\n\n```\nrequire \"big\"\n\nBigDecimal.new(1234, 2) ** 2 # => 152.2756\n```","summary":"<p>Raises the decimal to the <em>other</em>th power</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigDecimal","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":285,"url":null},"def":{"name":"**","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"if other < 0\n  raise(ArgumentError.new(\"Negative exponent isn't supported\"))\nend\nBigDecimal.new(@value ** other, @scale * other)\n"}},{"id":"+(other:BigDecimal):BigDecimal-instance-method","html_id":"+(other:BigDecimal):BigDecimal-instance-method","name":"+","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : BigDecimal","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":152,"url":null},"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"if @scale > other.scale\n  scaled = other.scale_to(self)\n  BigDecimal.new(@value + scaled.value, @scale)\nelse\n  if @scale < other.scale\n    scaled = scale_to(other)\n    BigDecimal.new(scaled.value + other.value, other.scale)\n  else\n    BigDecimal.new(@value + other.value, @scale)\n  end\nend"}},{"id":"+(other:Int)-instance-method","html_id":"+(other:Int)-instance-method","name":"+","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int)","args_html":"(other : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/big/big_decimal.cr","line_number":164,"url":null},"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self + (BigDecimal.new(other))"}},{"id":"-(other:BigDecimal):BigDecimal-instance-method","html_id":"-(other:BigDecimal):BigDecimal-instance-method","name":"-","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : BigDecimal","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":168,"url":null},"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"if @scale > other.scale\n  scaled = other.scale_to(self)\n  BigDecimal.new(@value - scaled.value, @scale)\nelse\n  if @scale < other.scale\n    scaled = scale_to(other)\n    BigDecimal.new(scaled.value - other.value, other.scale)\n  else\n    BigDecimal.new(@value - other.value, @scale)\n  end\nend"}},{"id":"-(other:Int)-instance-method","html_id":"-(other:Int)-instance-method","name":"-","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int)","args_html":"(other : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/big/big_decimal.cr","line_number":180,"url":null},"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self - (BigDecimal.new(other))"}},{"id":"-:BigDecimal-instance-method","html_id":"-:BigDecimal-instance-method","name":"-","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : BigDecimal","args_html":" : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":148,"url":null},"def":{"name":"-","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"BigDecimal.new(-@value, @scale)"}},{"id":"/(other:UInt16):BigDecimal-instance-method","html_id":"/(other:UInt16):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt16"}],"args_string":"(other : UInt16) : BigDecimal","args_html":"(other : <a href=\"UInt16.html\">UInt16</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":26,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt16"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:Float32):BigDecimal-instance-method","html_id":"/(other:Float32):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32"}],"args_string":"(other : Float32) : BigDecimal","args_html":"(other : <a href=\"Float32.html\">Float32</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":27,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:UInt128):BigDecimal-instance-method","html_id":"/(other:UInt128):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt128"}],"args_string":"(other : UInt128) : BigDecimal","args_html":"(other : <a href=\"UInt128.html\">UInt128</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":26,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt128"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:Int128):BigDecimal-instance-method","html_id":"/(other:Int128):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int128"}],"args_string":"(other : Int128) : BigDecimal","args_html":"(other : <a href=\"Int128.html\">Int128</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":26,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int128"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:UInt64):BigDecimal-instance-method","html_id":"/(other:UInt64):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt64"}],"args_string":"(other : UInt64) : BigDecimal","args_html":"(other : <a href=\"UInt64.html\">UInt64</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":26,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:Int64):BigDecimal-instance-method","html_id":"/(other:Int64):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int64"}],"args_string":"(other : Int64) : BigDecimal","args_html":"(other : <a href=\"Int64.html\">Int64</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":26,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:UInt32):BigDecimal-instance-method","html_id":"/(other:UInt32):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt32"}],"args_string":"(other : UInt32) : BigDecimal","args_html":"(other : <a href=\"UInt32.html\">UInt32</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":26,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:Int32):BigDecimal-instance-method","html_id":"/(other:Int32):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int32"}],"args_string":"(other : Int32) : BigDecimal","args_html":"(other : <a href=\"Int32.html\">Int32</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":26,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:Int16):BigDecimal-instance-method","html_id":"/(other:Int16):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int16"}],"args_string":"(other : Int16) : BigDecimal","args_html":"(other : <a href=\"Int16.html\">Int16</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":26,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int16"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:UInt8):BigDecimal-instance-method","html_id":"/(other:UInt8):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt8"}],"args_string":"(other : UInt8) : BigDecimal","args_html":"(other : <a href=\"UInt8.html\">UInt8</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":26,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt8"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:Int8):BigDecimal-instance-method","html_id":"/(other:Int8):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int8"}],"args_string":"(other : Int8) : BigDecimal","args_html":"(other : <a href=\"Int8.html\">Int8</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":26,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int8"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:BigRational):BigRational-instance-method","html_id":"/(other:BigRational):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational) : BigRational","args_html":"(other : <a href=\"BigRational.html\">BigRational</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_decimal.cr","line_number":197,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:BigFloat):BigDecimal-instance-method","html_id":"/(other:BigFloat):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigFloat"}],"args_string":"(other : BigFloat) : BigDecimal","args_html":"(other : <a href=\"BigFloat.html\">BigFloat</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":196,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigFloat"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:BigInt):BigDecimal-instance-method","html_id":"/(other:BigInt):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigDecimal","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":196,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:BigDecimal):BigDecimal-instance-method","html_id":"/(other:BigDecimal):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : BigDecimal","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":192,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"div(other)"}},{"id":"/(other:Float64):BigDecimal-instance-method","html_id":"/(other:Float64):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float64"}],"args_string":"(other : Float64) : BigDecimal","args_html":"(other : <a href=\"Float64.html\">Float64</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/number.cr","line_number":27,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"(other:BigDecimal):Int32-instance-method","html_id":"(other:BigDecimal):Int32-instance-method","name":"<=>","doc":"The comparison operator. Returns `0` if the two objects are equal,\na negative number if this object is considered less than *other*,\na positive number if this object is considered greater than *other*,\nor `nil` if the two objects are not comparable.\n\nSubclasses define this method to provide class-specific ordering.\n\nThe comparison operator is usually used to sort values:\n\n```\n# Sort in a descending way:\n[3, 1, 2].sort { |x, y| y <=> x } # => [3, 2, 1]\n\n# Sort in an ascending way:\n[3, 1, 2].sort { |x, y| x <=> y } # => [1, 2, 3]\n```","summary":"<p>The comparison operator.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : Int32","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/big/big_decimal.cr","line_number":230,"url":null},"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":"if @scale > other.scale\n  @value <=> (other.scale_to(self)).value\nelse\n  if @scale < other.scale\n    (scale_to(other)).value <=> other.value\n  else\n    @value <=> other.value\n  end\nend"}},{"id":"(other:Int|Float|BigRational)-instance-method","html_id":"(other:Int|Float|BigRational)-instance-method","name":"<=>","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int | Float | BigRational"}],"args_string":"(other : Int | Float | BigRational)","args_html":"(other : <a href=\"Int.html\">Int</a> | <a href=\"Float.html\">Float</a> | <a href=\"BigRational.html\">BigRational</a>)","location":{"filename":"src/big/big_decimal.cr","line_number":240,"url":null},"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int | Float | BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self <=> (BigDecimal.new(other))"}},{"id":"==(other:BigDecimal):Bool-instance-method","html_id":"==(other:BigDecimal):Bool-instance-method","name":"==","doc":"Compares this object to *other* based on the receiver’s `<=>` method,\nreturning `true` if it returns `0`.\n\nAlso returns `true` if this and *other* are the same object.","summary":"<p>Compares this object to <em>other</em> based on the receiver’s <code><a href=\"BigDecimal.html#(other:BigDecimal):Int32-instance-method\">#<=></a></code> method, returning <code>true</code> if it returns <code>0</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : Bool","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/big/big_decimal.cr","line_number":244,"url":null},"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"case @scale\nwhen  > other.scale\n  scaled = other.value * (power_ten_to(@scale - other.scale))\n  @value == scaled\nwhen  < other.scale\n  scaled = @value * (power_ten_to(other.scale - @scale))\n  scaled == other.value\nelse\n  @value == other.value\nend"}},{"id":"ceil:BigDecimal-instance-method","html_id":"ceil:BigDecimal-instance-method","name":"ceil","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : BigDecimal","args_html":" : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":292,"url":null},"def":{"name":"ceil","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"mask = power_ten_to(@scale)\ndiff = (mask - (@value % mask)) % mask\nvalue = self + (BigDecimal.new(diff, @scale))\nvalue.in_scale(0)\n"}},{"id":"clone-instance-method","html_id":"clone-instance-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":523,"url":null},"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"div(other:BigDecimal,max_div_iterations=DEFAULT_MAX_DIV_ITERATIONS):BigDecimal-instance-method","html_id":"div(other:BigDecimal,max_div_iterations=DEFAULT_MAX_DIV_ITERATIONS):BigDecimal-instance-method","name":"div","doc":"Divides `self` with another `BigDecimal`, with a optionally configurable *max_div_iterations*, which\ndefines a maximum number of iterations in case the division is not exact.\n\n```\nBigDecimal.new(1).div(BigDecimal.new(2))    # => BigDecimal(@value=5, @scale=2)\nBigDecimal.new(1).div(BigDecimal.new(3), 5) # => BigDecimal(@value=33333, @scale=5)\n```","summary":"<p>Divides <code>self</code> with another <code><a href=\"BigDecimal.html\">BigDecimal</a></code>, with a optionally configurable <em>max_div_iterations</em>, which defines a maximum number of iterations in case the division is not exact.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"},{"name":"max_div_iterations","doc":null,"default_value":"DEFAULT_MAX_DIV_ITERATIONS","external_name":"max_div_iterations","restriction":""}],"args_string":"(other : BigDecimal, max_div_iterations = <span class=\"t\">DEFAULT_MAX_DIV_ITERATIONS</span>) : BigDecimal","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>, max_div_iterations = <span class=\"t\">DEFAULT_MAX_DIV_ITERATIONS</span>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":206,"url":null},"def":{"name":"div","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"},{"name":"max_div_iterations","doc":null,"default_value":"DEFAULT_MAX_DIV_ITERATIONS","external_name":"max_div_iterations","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"check_division_by_zero(other)\nother.factor_powers_of_ten\nscale = @scale - other.scale\nnumerator, denominator = @value, other.@value\nquotient, remainder = numerator.divmod(denominator)\nif remainder == ZERO\n  return BigDecimal.new(normalize_quotient(other, quotient), scale)\nend\nremainder = remainder * TEN\ni = 0\nwhile (remainder != ZERO) && i < max_div_iterations\n  inner_quotient, inner_remainder = remainder.divmod(denominator)\n  quotient = (quotient * TEN) + inner_quotient\n  remainder = inner_remainder * TEN\n  i = i + 1\nend\nBigDecimal.new(normalize_quotient(other, quotient), scale + i)\n"}},{"id":"floor:BigDecimal-instance-method","html_id":"floor:BigDecimal-instance-method","name":"floor","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : BigDecimal","args_html":" : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":299,"url":null},"def":{"name":"floor","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"in_scale(0)"}},{"id":"hash(hasher)-instance-method","html_id":"hash(hasher)-instance-method","name":"hash","doc":"Appends this object's value to *hasher*, and returns the modified *hasher*.\n\nUsually the macro `def_hash` can be used to generate this method.\nOtherwise, invoke `hash(hasher)` on each object's instance variables to\naccumulate the result:\n\n```\ndef hash(hasher)\n  hasher = @some_ivar.hash(hasher)\n  hasher = @some_other_ivar.hash(hasher)\n  hasher\nend\n```","summary":"<p>Appends this object's value to <em>hasher</em>, and returns the modified <em>hasher</em>.</p>","abstract":false,"args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"args_string":"(hasher)","args_html":"(hasher)","location":{"filename":"src/big/big_decimal.cr","line_number":527,"url":null},"def":{"name":"hash","args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"hasher.string(to_s)"}},{"id":"normalize_quotient(other:BigDecimal,quotient:BigInt):BigInt-instance-method","html_id":"normalize_quotient(other:BigDecimal,quotient:BigInt):BigInt-instance-method","name":"normalize_quotient","doc":"Returns the *quotient* as absolutely negative if `self` and *other* have\ndifferent signs, otherwise returns the *quotient*.","summary":"<p>Returns the <em>quotient</em> as absolutely negative if <code>self</code> and <em>other</em> have different signs, otherwise returns the <em>quotient</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"},{"name":"quotient","doc":null,"default_value":"","external_name":"quotient","restriction":"BigInt"}],"args_string":"(other : BigDecimal, quotient : BigInt) : BigInt","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>, quotient : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_decimal.cr","line_number":533,"url":null},"def":{"name":"normalize_quotient","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"},{"name":"quotient","doc":null,"default_value":"","external_name":"quotient","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"if (@value < 0 && other.value > 0) || (other.value < 0 && @value > 0)\n  -quotient.abs\nelse\n  quotient\nend"}},{"id":"scale:UInt64-instance-method","html_id":"scale:UInt64-instance-method","name":"scale","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : UInt64","args_html":" : <a href=\"UInt64.html\">UInt64</a>","location":{"filename":"src/big/big_decimal.cr","line_number":28,"url":null},"def":{"name":"scale","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt64","visibility":"Public","body":"@scale"}},{"id":"scale_to(new_scale:BigDecimal):BigDecimal-instance-method","html_id":"scale_to(new_scale:BigDecimal):BigDecimal-instance-method","name":"scale_to","doc":"Scales a `BigDecimal` to another `BigDecimal`, so they can be\ncomputed easier.","summary":"<p>Scales a <code><a href=\"BigDecimal.html\">BigDecimal</a></code> to another <code><a href=\"BigDecimal.html\">BigDecimal</a></code>, so they can be computed easier.</p>","abstract":false,"args":[{"name":"new_scale","doc":null,"default_value":"","external_name":"new_scale","restriction":"BigDecimal"}],"args_string":"(new_scale : BigDecimal) : BigDecimal","args_html":"(new_scale : <a href=\"BigDecimal.html\">BigDecimal</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":259,"url":null},"def":{"name":"scale_to","args":[{"name":"new_scale","doc":null,"default_value":"","external_name":"new_scale","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"in_scale(new_scale.scale)"}},{"id":"to_big_d-instance-method","html_id":"to_big_d-instance-method","name":"to_big_d","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":345,"url":null},"def":{"name":"to_big_d","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"to_big_f-instance-method","html_id":"to_big_f-instance-method","name":"to_big_f","doc":"Converts to `BigFloat`.","summary":"<p>Converts to <code><a href=\"BigFloat.html\">BigFloat</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":341,"url":null},"def":{"name":"to_big_f","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new(to_s)"}},{"id":"to_big_i-instance-method","html_id":"to_big_i-instance-method","name":"to_big_i","doc":"Converts to `BigInt`. Truncates anything on the right side of the decimal point.","summary":"<p>Converts to <code><a href=\"BigInt.html\">BigInt</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":336,"url":null},"def":{"name":"to_big_i","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"trunc.value"}},{"id":"to_big_r-instance-method","html_id":"to_big_r-instance-method","name":"to_big_r","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":349,"url":null},"def":{"name":"to_big_r","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigRational.new(self.value, BigDecimal::TEN ** self.scale)"}},{"id":"to_f-instance-method","html_id":"to_f-instance-method","name":"to_f","doc":"Converts to `Float64`.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Float64.html\">Float64</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":501,"url":null},"def":{"name":"to_f","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64"}},{"id":"to_f!-instance-method","html_id":"to_f!-instance-method","name":"to_f!","doc":"Converts to `Float64`.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Float64.html\">Float64</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":519,"url":null},"def":{"name":"to_f!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64!"}},{"id":"to_f32-instance-method","html_id":"to_f32-instance-method","name":"to_f32","doc":"Converts to `Float32`.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Float32.html\">Float32</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":495,"url":null},"def":{"name":"to_f32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_f32"}},{"id":"to_f32!-instance-method","html_id":"to_f32!-instance-method","name":"to_f32!","doc":"Converts to `Float32`.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Float32.html\">Float32</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":507,"url":null},"def":{"name":"to_f32!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_f32!"}},{"id":"to_f64-instance-method","html_id":"to_f64-instance-method","name":"to_f64","doc":"Converts to `Float64`.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Float64.html\">Float64</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":489,"url":null},"def":{"name":"to_f64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_s.to_f64"}},{"id":"to_f64!-instance-method","html_id":"to_f64!-instance-method","name":"to_f64!","doc":"Converts to `Float64`.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Float64.html\">Float64</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":513,"url":null},"def":{"name":"to_f64!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64"}},{"id":"to_i-instance-method","html_id":"to_i-instance-method","name":"to_i","doc":"Converts to `Int32`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Int32.html\">Int32</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":379,"url":null},"def":{"name":"to_i","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i32"}},{"id":"to_i!-instance-method","html_id":"to_i!-instance-method","name":"to_i!","doc":"Converts to `Int32`. Truncates anything on the right side of the decimal point.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Int32.html\">Int32</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":409,"url":null},"def":{"name":"to_i!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i32!"}},{"id":"to_i16-instance-method","html_id":"to_i16-instance-method","name":"to_i16","doc":"Converts to `Int16`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Int16.html\">Int16</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":367,"url":null},"def":{"name":"to_i16","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_i.to_i16"}},{"id":"to_i16!-instance-method","html_id":"to_i16!-instance-method","name":"to_i16!","doc":"Converts to `Int16`. Truncates anything on the right side of the decimal point.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Int16.html\">Int16</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":391,"url":null},"def":{"name":"to_i16!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_i.to_i16!"}},{"id":"to_i32-instance-method","html_id":"to_i32-instance-method","name":"to_i32","doc":"Converts to `Int32`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Int32.html\">Int32</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":361,"url":null},"def":{"name":"to_i32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_i.to_i32"}},{"id":"to_i32!-instance-method","html_id":"to_i32!-instance-method","name":"to_i32!","doc":"Converts to `Int32`. Truncates anything on the right side of the decimal point.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Int32.html\">Int32</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":397,"url":null},"def":{"name":"to_i32!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_i.to_i32!"}},{"id":"to_i64-instance-method","html_id":"to_i64-instance-method","name":"to_i64","doc":"Converts to `Int64`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Int64.html\">Int64</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":355,"url":null},"def":{"name":"to_i64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_i.to_i64"}},{"id":"to_i64!-instance-method","html_id":"to_i64!-instance-method","name":"to_i64!","doc":"Converts to `Int64`. Truncates anything on the right side of the decimal point.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Int64.html\">Int64</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":403,"url":null},"def":{"name":"to_i64!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_i.to_i64!"}},{"id":"to_i8-instance-method","html_id":"to_i8-instance-method","name":"to_i8","doc":"Converts to `Int8`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"Int8.html\">Int8</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":373,"url":null},"def":{"name":"to_i8","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_i.to_i8"}},{"id":"to_i8!-instance-method","html_id":"to_i8!-instance-method","name":"to_i8!","doc":"Converts to `Int8`. Truncates anything on the right side of the decimal point.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"Int8.html\">Int8</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":385,"url":null},"def":{"name":"to_i8!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_i.to_i8!"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Appends a `String` representation of this object\nto the given `IO` object.\n\nAn object must never append itself to the io argument,\nas this will in turn call `to_s(io)` on it.","summary":"<p>Appends a <code><a href=\"String.html\">String</a></code> representation of this object to the given <code><a href=\"IO.html\">IO</a></code> object.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/big_decimal.cr","line_number":307,"url":null},"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"factor_powers_of_ten\ns = @value.to_s\nif @scale == 0\n  io << s\n  return\nend\nif @scale >= s.size && @value >= 0\n  io << \"0.\"\n  (@scale - s.size).times do\n    io << '0'\n  end\n  io << s\nelse\n  if @scale >= s.size && @value < 0\n    io << \"-0.0\"\n    (@scale - s.size).times do\n      io << '0'\n    end\n    io << s[1..-1]\n  else\n    if ((offset = s.size - @scale) == 1) && @value < 0\n      (io << \"-0.\") << s[offset..-1]\n    else\n      ((io << s[0...offset]) << '.') << s[offset..-1]\n    end\n  end\nend\n"}},{"id":"to_u-instance-method","html_id":"to_u-instance-method","name":"to_u","doc":"Converts to `UInt32`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"UInt32.html\">UInt32</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":448,"url":null},"def":{"name":"to_u","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u32"}},{"id":"to_u!-instance-method","html_id":"to_u!-instance-method","name":"to_u!","doc":"Converts to `UInt32`. Truncates anything on the right side of the decimal point,\nconverting negative to positive.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"UInt32.html\">UInt32</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":483,"url":null},"def":{"name":"to_u!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u32!"}},{"id":"to_u16-instance-method","html_id":"to_u16-instance-method","name":"to_u16","doc":"Converts to `UInt16`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"UInt16.html\">UInt16</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":436,"url":null},"def":{"name":"to_u16","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_u.to_u16"}},{"id":"to_u16!-instance-method","html_id":"to_u16!-instance-method","name":"to_u16!","doc":"Converts to `UInt16`. Truncates anything on the right side of the decimal point,\nconverting negative to positive.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"UInt16.html\">UInt16</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":462,"url":null},"def":{"name":"to_u16!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_u!.to_u16!"}},{"id":"to_u32-instance-method","html_id":"to_u32-instance-method","name":"to_u32","doc":"Converts to `UInt32`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"UInt32.html\">UInt32</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":430,"url":null},"def":{"name":"to_u32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_u.to_u32"}},{"id":"to_u32!-instance-method","html_id":"to_u32!-instance-method","name":"to_u32!","doc":"Converts to `UInt32`. Truncates anything on the right side of the decimal point,\nconverting negative to positive.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"UInt32.html\">UInt32</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":469,"url":null},"def":{"name":"to_u32!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_u!.to_u32!"}},{"id":"to_u64-instance-method","html_id":"to_u64-instance-method","name":"to_u64","doc":"Converts to `UInt64`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"UInt64.html\">UInt64</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":424,"url":null},"def":{"name":"to_u64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_u.to_u64"}},{"id":"to_u64!-instance-method","html_id":"to_u64!-instance-method","name":"to_u64!","doc":"Converts to `UInt64`. Truncates anything on the right side of the decimal point,\nconverting negative to positive.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"UInt64.html\">UInt64</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":476,"url":null},"def":{"name":"to_u64!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_u!.to_u64!"}},{"id":"to_u8-instance-method","html_id":"to_u8-instance-method","name":"to_u8","doc":"Converts to `UInt8`. Truncates anything on the right side of the decimal point.\nRaises `OverflowError` in case of overflow.","summary":"<p>Converts to <code><a href=\"UInt8.html\">UInt8</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":442,"url":null},"def":{"name":"to_u8","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_u.to_u8"}},{"id":"to_u8!-instance-method","html_id":"to_u8!-instance-method","name":"to_u8!","doc":"Converts to `UInt8`. Truncates anything on the right side of the decimal point,\nconverting negative to positive.\nIn case of overflow a wrapping is performed.","summary":"<p>Converts to <code><a href=\"UInt8.html\">UInt8</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":455,"url":null},"def":{"name":"to_u8!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_u!.to_u8!"}},{"id":"trunc:BigDecimal-instance-method","html_id":"trunc:BigDecimal-instance-method","name":"trunc","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : BigDecimal","args_html":" : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_decimal.cr","line_number":303,"url":null},"def":{"name":"trunc","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"self < 0 ? ceil : floor"}},{"id":"value:BigInt-instance-method","html_id":"value:BigInt-instance-method","name":"value","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : BigInt","args_html":" : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_decimal.cr","line_number":27,"url":null},"def":{"name":"value","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"@value"}}],"macros":[],"types":[]},{"html_id":"Crystal/BigFloat","path":"BigFloat.html","kind":"struct","full_name":"BigFloat","name":"BigFloat","abstract":false,"superclass":{"html_id":"Crystal/Float","kind":"struct","full_name":"Float","name":"Float"},"ancestors":[{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Float","kind":"struct","full_name":"Float","name":"Float"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Number","kind":"struct","full_name":"Number","name":"Number"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"}],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"A `BigFloat` can represent arbitrarily large floats.\n\nIt is implemented under the hood with [GMP](https://gmplib.org/).","summary":"<p>A <code><a href=\"BigFloat.html\">BigFloat</a></code> can represent arbitrarily large floats.</p>","class_methods":[{"id":"default_precision-class-method","html_id":"default_precision-class-method","name":"default_precision","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":88,"url":null},"def":{"name":"default_precision","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpf_get_default_prec"}},{"id":"default_precision=(prec:Int)-class-method","html_id":"default_precision=(prec:Int)-class-method","name":"default_precision=","doc":null,"summary":null,"abstract":false,"args":[{"name":"prec","doc":null,"default_value":"","external_name":"prec","restriction":"Int"}],"args_string":"(prec : Int)","args_html":"(prec : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/big/big_float.cr","line_number":92,"url":null},"def":{"name":"default_precision=","args":[{"name":"prec","doc":null,"default_value":"","external_name":"prec","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpf_set_default_prec(prec.to_u64)"}}],"constructors":[{"id":"new(num:Float,precision:Int)-class-method","html_id":"new(num:Float,precision:Int)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Float"},{"name":"precision","doc":null,"default_value":"","external_name":"precision","restriction":"Int"}],"args_string":"(num : Float, precision : Int)","args_html":"(num : <a href=\"Float.html\">Float</a>, precision : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/big/big_float.cr","line_number":71,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Float"},{"name":"precision","doc":null,"default_value":"","external_name":"precision","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num, precision)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(str:String)-class-method","html_id":"new(str:String)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"str","doc":null,"default_value":"","external_name":"str","restriction":"String"}],"args_string":"(str : String)","args_html":"(str : <a href=\"String.html\">String</a>)","location":{"filename":"src/big/big_float.cr","line_number":16,"url":null},"def":{"name":"new","args":[{"name":"str","doc":null,"default_value":"","external_name":"str","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(str)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:BigInt)-class-method","html_id":"new(num:BigInt)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigInt"}],"args_string":"(num : BigInt)","args_html":"(num : <a href=\"BigInt.html\">BigInt</a>)","location":{"filename":"src/big/big_float.cr","line_number":26,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:BigRational)-class-method","html_id":"new(num:BigRational)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigRational"}],"args_string":"(num : BigRational)","args_html":"(num : <a href=\"BigRational.html\">BigRational</a>)","location":{"filename":"src/big/big_float.cr","line_number":31,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:BigFloat)-class-method","html_id":"new(num:BigFloat)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigFloat"}],"args_string":"(num : BigFloat)","args_html":"(num : <a href=\"BigFloat.html\">BigFloat</a>)","location":{"filename":"src/big/big_float.cr","line_number":36,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigFloat"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:Int8|Int16|Int32)-class-method","html_id":"new(num:Int8|Int16|Int32)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Int8 | Int16 | Int32"}],"args_string":"(num : Int8 | Int16 | Int32)","args_html":"(num : <a href=\"Int8.html\">Int8</a> | <a href=\"Int16.html\">Int16</a> | <a href=\"Int32.html\">Int32</a>)","location":{"filename":"src/big/big_float.cr","line_number":41,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Int8 | Int16 | Int32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:UInt8|UInt16|UInt32)-class-method","html_id":"new(num:UInt8|UInt16|UInt32)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"UInt8 | UInt16 | UInt32"}],"args_string":"(num : UInt8 | UInt16 | UInt32)","args_html":"(num : <a href=\"UInt8.html\">UInt8</a> | <a href=\"UInt16.html\">UInt16</a> | <a href=\"UInt32.html\">UInt32</a>)","location":{"filename":"src/big/big_float.cr","line_number":45,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"UInt8 | UInt16 | UInt32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:Int64)-class-method","html_id":"new(num:Int64)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Int64"}],"args_string":"(num : Int64)","args_html":"(num : <a href=\"Int64.html\">Int64</a>)","location":{"filename":"src/big/big_float.cr","line_number":49,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Int64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:UInt64)-class-method","html_id":"new(num:UInt64)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"UInt64"}],"args_string":"(num : UInt64)","args_html":"(num : <a href=\"UInt64.html\">UInt64</a>)","location":{"filename":"src/big/big_float.cr","line_number":58,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"UInt64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:Number)-class-method","html_id":"new(num:Number)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Number"}],"args_string":"(num : Number)","args_html":"(num : <a href=\"Number.html\">Number</a>)","location":{"filename":"src/big/big_float.cr","line_number":67,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(mpf:LibGMP::MPF)-class-method","html_id":"new(mpf:LibGMP::MPF)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"mpf","doc":null,"default_value":"","external_name":"mpf","restriction":"LibGMP::MPF"}],"args_string":"(mpf : LibGMP::MPF)","args_html":"(mpf : LibGMP::MPF)","location":{"filename":"src/big/big_float.cr","line_number":76,"url":null},"def":{"name":"new","args":[{"name":"mpf","doc":null,"default_value":"","external_name":"mpf","restriction":"LibGMP::MPF"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(mpf)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new-class-method","html_id":"new-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":12,"url":null},"def":{"name":"new","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(&)-class-method","html_id":"new(&)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"(&)","args_html":"(&)","location":{"filename":"src/big/big_float.cr","line_number":79,"url":null},"def":{"name":"new","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpf_init(out mpf)\nyield pointerof(mpf)\nnew(mpf)\n"}}],"instance_methods":[{"id":"*(other:Number)-instance-method","html_id":"*(other:Number)-instance-method","name":"*","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"args_string":"(other : Number)","args_html":"(other : <a href=\"Number.html\">Number</a>)","location":{"filename":"src/big/big_float.cr","line_number":130,"url":null},"def":{"name":"*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new do |mpf|\n  LibGMP.mpf_mul(mpf, self, other.to_big_f)\nend"}},{"id":"**(other:Int)-instance-method","html_id":"**(other:Int)-instance-method","name":"**","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int)","args_html":"(other : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/big/big_float.cr","line_number":144,"url":null},"def":{"name":"**","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new do |mpf|\n  LibGMP.mpf_pow_ui(mpf, self, other.to_u64)\nend"}},{"id":"+(other:Number)-instance-method","html_id":"+(other:Number)-instance-method","name":"+","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"args_string":"(other : Number)","args_html":"(other : <a href=\"Number.html\">Number</a>)","location":{"filename":"src/big/big_float.cr","line_number":122,"url":null},"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new do |mpf|\n  LibGMP.mpf_add(mpf, self, other.to_big_f)\nend"}},{"id":"-(other:Number)-instance-method","html_id":"-(other:Number)-instance-method","name":"-","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"args_string":"(other : Number)","args_html":"(other : <a href=\"Number.html\">Number</a>)","location":{"filename":"src/big/big_float.cr","line_number":126,"url":null},"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new do |mpf|\n  LibGMP.mpf_sub(mpf, self, other.to_big_f)\nend"}},{"id":"--instance-method","html_id":"--instance-method","name":"-","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":118,"url":null},"def":{"name":"-","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new do |mpf|\n  LibGMP.mpf_neg(mpf, self)\nend"}},{"id":"/(other:Int8):BigFloat-instance-method","html_id":"/(other:Int8):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int8"}],"args_string":"(other : Int8) : BigFloat","args_html":"(other : <a href=\"Int8.html\">Int8</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":21,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int8"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Float64):BigFloat-instance-method","html_id":"/(other:Float64):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float64"}],"args_string":"(other : Float64) : BigFloat","args_html":"(other : <a href=\"Float64.html\">Float64</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":22,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Float32):BigFloat-instance-method","html_id":"/(other:Float32):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32"}],"args_string":"(other : Float32) : BigFloat","args_html":"(other : <a href=\"Float32.html\">Float32</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":22,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:UInt128):BigFloat-instance-method","html_id":"/(other:UInt128):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt128"}],"args_string":"(other : UInt128) : BigFloat","args_html":"(other : <a href=\"UInt128.html\">UInt128</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":21,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt128"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Int128):BigFloat-instance-method","html_id":"/(other:Int128):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int128"}],"args_string":"(other : Int128) : BigFloat","args_html":"(other : <a href=\"Int128.html\">Int128</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":21,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int128"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Int64):BigFloat-instance-method","html_id":"/(other:Int64):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int64"}],"args_string":"(other : Int64) : BigFloat","args_html":"(other : <a href=\"Int64.html\">Int64</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":21,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Int32):BigFloat-instance-method","html_id":"/(other:Int32):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int32"}],"args_string":"(other : Int32) : BigFloat","args_html":"(other : <a href=\"Int32.html\">Int32</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":21,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Int16):BigFloat-instance-method","html_id":"/(other:Int16):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int16"}],"args_string":"(other : Int16) : BigFloat","args_html":"(other : <a href=\"Int16.html\">Int16</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":21,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int16"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:UInt8|UInt16|UInt32|UInt64)-instance-method","html_id":"/(other:UInt8|UInt16|UInt32|UInt64)-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt8 | UInt16 | UInt32 | UInt64"}],"args_string":"(other : UInt8 | UInt16 | UInt32 | UInt64)","args_html":"(other : <a href=\"UInt8.html\">UInt8</a> | <a href=\"UInt16.html\">UInt16</a> | <a href=\"UInt32.html\">UInt32</a> | <a href=\"UInt64.html\">UInt64</a>)","location":{"filename":"src/big/number.cr","line_number":11,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt8 | UInt16 | UInt32 | UInt64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if other == 0\n  raise(DivisionByZeroError.new)\nend\nif other.is_a?(UInt8 | UInt16 | UInt32) || ((LibGMP::ULong == UInt64) && other.is_a?(UInt64))\n  BigFloat.new do |mpf|\n    LibGMP.mpf_div_ui(mpf, self, other)\n  end\nelse\n  BigFloat.new do |mpf|\n    LibGMP.mpf_div(mpf, self, other.to_big_f)\n  end\nend\n"}},{"id":"/(other:BigRational):BigRational-instance-method","html_id":"/(other:BigRational):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational) : BigRational","args_html":"(other : <a href=\"BigRational.html\">BigRational</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_float.cr","line_number":142,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:BigDecimal):BigDecimal-instance-method","html_id":"/(other:BigDecimal):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : BigDecimal","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_float.cr","line_number":141,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:BigInt):BigFloat-instance-method","html_id":"/(other:BigInt):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigFloat","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/big_float.cr","line_number":140,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:BigFloat)-instance-method","html_id":"/(other:BigFloat)-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigFloat"}],"args_string":"(other : BigFloat)","args_html":"(other : <a href=\"BigFloat.html\">BigFloat</a>)","location":{"filename":"src/big/big_float.cr","line_number":134,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigFloat"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if other == 0\n  raise(DivisionByZeroError.new)\nend\nBigFloat.new do |mpf|\n  LibGMP.mpf_div(mpf, self, other)\nend\n"}},{"id":"(other:Number)-instance-method","html_id":"(other:Number)-instance-method","name":"<=>","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"args_string":"(other : Number)","args_html":"(other : <a href=\"Number.html\">Number</a>)","location":{"filename":"src/big/big_float.cr","line_number":108,"url":null},"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if other.is_a?(Int8 | Int16 | Int32) || ((LibGMP::Long == Int64) && other.is_a?(Int64))\n  LibGMP.mpf_cmp_si(self, other)\nelse\n  if other.is_a?(UInt8 | UInt16 | UInt32) || ((LibGMP::ULong == UInt64) && other.is_a?(UInt64))\n    LibGMP.mpf_cmp_ui(self, other)\n  else\n    LibGMP.mpf_cmp(self, other.to_big_f)\n  end\nend"}},{"id":"(other:Float32|Float64)-instance-method","html_id":"(other:Float32|Float64)-instance-method","name":"<=>","doc":"The comparison operator. Returns `0` if the two objects are equal,\na negative number if this object is considered less than *other*,\na positive number if this object is considered greater than *other*,\nor `nil` if the two objects are not comparable.\n\nSubclasses define this method to provide class-specific ordering.\n\nThe comparison operator is usually used to sort values:\n\n```\n# Sort in a descending way:\n[3, 1, 2].sort { |x, y| y <=> x } # => [3, 2, 1]\n\n# Sort in an ascending way:\n[3, 1, 2].sort { |x, y| x <=> y } # => [1, 2, 3]\n```","summary":"<p>The comparison operator.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32 | Float64"}],"args_string":"(other : Float32 | Float64)","args_html":"(other : <a href=\"Float32.html\">Float32</a> | <a href=\"Float64.html\">Float64</a>)","location":{"filename":"src/big/big_float.cr","line_number":104,"url":null},"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32 | Float64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpf_cmp_d(self, other.to_f64)"}},{"id":"(other:BigInt)-instance-method","html_id":"(other:BigInt)-instance-method","name":"<=>","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt)","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>)","location":{"filename":"src/big/big_float.cr","line_number":100,"url":null},"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpf_cmp_z(self, other)"}},{"id":"(other:BigFloat)-instance-method","html_id":"(other:BigFloat)-instance-method","name":"<=>","doc":"The comparison operator. Returns `0` if the two objects are equal,\na negative number if this object is considered less than *other*,\na positive number if this object is considered greater than *other*,\nor `nil` if the two objects are not comparable.\n\nSubclasses define this method to provide class-specific ordering.\n\nThe comparison operator is usually used to sort values:\n\n```\n# Sort in a descending way:\n[3, 1, 2].sort { |x, y| y <=> x } # => [3, 2, 1]\n\n# Sort in an ascending way:\n[3, 1, 2].sort { |x, y| x <=> y } # => [1, 2, 3]\n```","summary":"<p>The comparison operator.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigFloat"}],"args_string":"(other : BigFloat)","args_html":"(other : <a href=\"BigFloat.html\">BigFloat</a>)","location":{"filename":"src/big/big_float.cr","line_number":96,"url":null},"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigFloat"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpf_cmp(self, other)"}},{"id":"abs-instance-method","html_id":"abs-instance-method","name":"abs","doc":"Returns the absolute value of this number.\n\n```\n123.abs  # => 123\n-123.abs # => 123\n```","summary":"<p>Returns the absolute value of this number.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":148,"url":null},"def":{"name":"abs","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new do |mpf|\n  LibGMP.mpf_abs(mpf, self)\nend"}},{"id":"ceil-instance-method","html_id":"ceil-instance-method","name":"ceil","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":152,"url":null},"def":{"name":"ceil","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new do |mpf|\n  LibGMP.mpf_ceil(mpf, self)\nend"}},{"id":"clone-instance-method","html_id":"clone-instance-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":308,"url":null},"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"fdiv(other:Number::Primitive):self-instance-method","html_id":"fdiv(other:Number::Primitive):self-instance-method","name":"fdiv","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number::Primitive"}],"args_string":"(other : Number::Primitive) : <span class=\"k\">self</span>","args_html":"(other : <a href=\"Number/Primitive.html\">Number::Primitive</a>) : <span class=\"k\">self</span>","location":{"filename":"src/big/number.cr","line_number":7,"url":null},"def":{"name":"fdiv","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number::Primitive"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"self","visibility":"Public","body":"self.class.new(self / other)"}},{"id":"floor-instance-method","html_id":"floor-instance-method","name":"floor","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":156,"url":null},"def":{"name":"floor","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new do |mpf|\n  LibGMP.mpf_floor(mpf, self)\nend"}},{"id":"hash(hasher)-instance-method","html_id":"hash(hasher)-instance-method","name":"hash","doc":"TODO: improve this","summary":"<p><span class=\"flag orange\">TODO</span>  improve this</p>","abstract":false,"args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"args_string":"(hasher)","args_html":"(hasher)","location":{"filename":"src/big/big_float.cr","line_number":86,"url":null},"def":{"name":"hash","args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"hasher = to_f64.hash(hasher)\nhasher\n"}},{"id":"to_big_f-instance-method","html_id":"to_big_f-instance-method","name":"to_big_f","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":188,"url":null},"def":{"name":"to_big_f","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"to_big_i-instance-method","html_id":"to_big_i-instance-method","name":"to_big_i","doc":"Returns a `BigInt` representing this float (rounded using `floor`).\n```\nrequire \"big\"\n\n1212341515125412412412421.0.to_big_i\n```","summary":"<p>Returns a <code><a href=\"BigInt.html\">BigInt</a></code> representing this float (rounded using <code><a href=\"BigFloat.html#floor-instance-method\">#floor</a></code>).</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":192,"url":null},"def":{"name":"to_big_i","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.set_f(mpz, mpf)\nend"}},{"id":"to_f-instance-method","html_id":"to_f-instance-method","name":"to_f","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":172,"url":null},"def":{"name":"to_f","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64"}},{"id":"to_f!-instance-method","html_id":"to_f!-instance-method","name":"to_f!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":184,"url":null},"def":{"name":"to_f!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64!"}},{"id":"to_f32-instance-method","html_id":"to_f32-instance-method","name":"to_f32","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":168,"url":null},"def":{"name":"to_f32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_f32"}},{"id":"to_f32!-instance-method","html_id":"to_f32!-instance-method","name":"to_f32!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":176,"url":null},"def":{"name":"to_f32!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_f32!"}},{"id":"to_f64-instance-method","html_id":"to_f64-instance-method","name":"to_f64","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":164,"url":null},"def":{"name":"to_f64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpf_get_d(self)"}},{"id":"to_f64!-instance-method","html_id":"to_f64!-instance-method","name":"to_f64!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":180,"url":null},"def":{"name":"to_f64!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64"}},{"id":"to_i-instance-method","html_id":"to_i-instance-method","name":"to_i","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":212,"url":null},"def":{"name":"to_i","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i32"}},{"id":"to_i!-instance-method","html_id":"to_i!-instance-method","name":"to_i!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":216,"url":null},"def":{"name":"to_i!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i32!"}},{"id":"to_i16-instance-method","html_id":"to_i16-instance-method","name":"to_i16","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":204,"url":null},"def":{"name":"to_i16","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i64.to_i16"}},{"id":"to_i16!-instance-method","html_id":"to_i16!-instance-method","name":"to_i16!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":224,"url":null},"def":{"name":"to_i16!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.mpf_get_si(self)).to_i16!"}},{"id":"to_i32-instance-method","html_id":"to_i32-instance-method","name":"to_i32","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":200,"url":null},"def":{"name":"to_i32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i64.to_i32"}},{"id":"to_i32!-instance-method","html_id":"to_i32!-instance-method","name":"to_i32!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":228,"url":null},"def":{"name":"to_i32!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.mpf_get_si(self)).to_i32!"}},{"id":"to_i64-instance-method","html_id":"to_i64-instance-method","name":"to_i64","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":196,"url":null},"def":{"name":"to_i64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpf_get_si(self)"}},{"id":"to_i64!-instance-method","html_id":"to_i64!-instance-method","name":"to_i64!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":232,"url":null},"def":{"name":"to_i64!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpf_get_si(self)"}},{"id":"to_i8-instance-method","html_id":"to_i8-instance-method","name":"to_i8","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":208,"url":null},"def":{"name":"to_i8","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i64.to_i8"}},{"id":"to_i8!-instance-method","html_id":"to_i8!-instance-method","name":"to_i8!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":220,"url":null},"def":{"name":"to_i8!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.mpf_get_si(self)).to_i8!"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Appends a `String` representation of this object\nto the given `IO` object.\n\nAn object must never append itself to the io argument,\nas this will in turn call `to_s(io)` on it.","summary":"<p>Appends a <code><a href=\"String.html\">String</a></code> representation of this object to the given <code><a href=\"IO.html\">IO</a></code> object.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/big_float.cr","line_number":281,"url":null},"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"cstr = LibGMP.mpf_get_str(nil, out expptr, 10, 0, self)\nlength = LibC.strlen(cstr)\ndecimal_set = false\nif self < 0\n  io << '-'\nend\nif expptr == 0\n  io << 0\nelse\n  if expptr < 0\n    (io << 0) << '.'\n    decimal_set = true\n    expptr.abs.times do\n      io << 0\n    end\n  end\nend\nif self < 0\n  expptr = expptr + 1\nend\nlength.times do |i|\n  if cstr[i] == 45\n    next\n  end\n  if i == expptr\n    io << '.'\n    decimal_set = true\n  end\n  io << cstr[i].unsafe_chr\nend\nif expptr > 0\n  (expptr - length).times do\n    io << 0\n  end\nend\nif !decimal_set\n  io << \".0\"\nend\n"}},{"id":"to_u-instance-method","html_id":"to_u-instance-method","name":"to_u","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":253,"url":null},"def":{"name":"to_u","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u32"}},{"id":"to_u!-instance-method","html_id":"to_u!-instance-method","name":"to_u!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":257,"url":null},"def":{"name":"to_u!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u32!"}},{"id":"to_u16-instance-method","html_id":"to_u16-instance-method","name":"to_u16","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":245,"url":null},"def":{"name":"to_u16","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u64.to_u16"}},{"id":"to_u16!-instance-method","html_id":"to_u16!-instance-method","name":"to_u16!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":265,"url":null},"def":{"name":"to_u16!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.mpf_get_ui(self)).to_u16!"}},{"id":"to_u32-instance-method","html_id":"to_u32-instance-method","name":"to_u32","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":241,"url":null},"def":{"name":"to_u32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u64.to_u32"}},{"id":"to_u32!-instance-method","html_id":"to_u32!-instance-method","name":"to_u32!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":269,"url":null},"def":{"name":"to_u32!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.mpf_get_ui(self)).to_u32!"}},{"id":"to_u64-instance-method","html_id":"to_u64-instance-method","name":"to_u64","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":236,"url":null},"def":{"name":"to_u64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if self < 0\n  raise(OverflowError.new)\nend\nLibGMP.mpf_get_ui(self)\n"}},{"id":"to_u64!-instance-method","html_id":"to_u64!-instance-method","name":"to_u64!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":273,"url":null},"def":{"name":"to_u64!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpf_get_ui(self)"}},{"id":"to_u8-instance-method","html_id":"to_u8-instance-method","name":"to_u8","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":249,"url":null},"def":{"name":"to_u8","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u64.to_u8"}},{"id":"to_u8!-instance-method","html_id":"to_u8!-instance-method","name":"to_u8!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":261,"url":null},"def":{"name":"to_u8!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.mpf_get_ui(self)).to_u8!"}},{"id":"to_unsafe-instance-method","html_id":"to_unsafe-instance-method","name":"to_unsafe","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":277,"url":null},"def":{"name":"to_unsafe","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"mpf"}},{"id":"trunc-instance-method","html_id":"trunc-instance-method","name":"trunc","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_float.cr","line_number":160,"url":null},"def":{"name":"trunc","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new do |mpf|\n  LibGMP.mpf_trunc(mpf, self)\nend"}}],"macros":[],"types":[]},{"html_id":"Crystal/BigInt","path":"BigInt.html","kind":"struct","full_name":"BigInt","name":"BigInt","abstract":false,"superclass":{"html_id":"Crystal/Int","kind":"struct","full_name":"Int","name":"Int"},"ancestors":[{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Int","kind":"struct","full_name":"Int","name":"Int"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Number","kind":"struct","full_name":"Number","name":"Number"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"}],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"A `BigInt` can represent arbitrarily large integers.\n\nIt is implemented under the hood with [GMP](https://gmplib.org/).","summary":"<p>A <code><a href=\"BigInt.html\">BigInt</a></code> can represent arbitrarily large integers.</p>","class_methods":[],"constructors":[{"id":"new(str:String,base=10)-class-method","html_id":"new(str:String,base=10)-class-method","name":"new","doc":"Creates a `BigInt` with the value denoted by *str* in the given *base*.\n\nRaises `ArgumentError` if the string doesn't denote a valid integer.\n\n```\nrequire \"big\"\n\nBigInt.new(\"123456789123456789123456789123456789\") # => 123456789123456789123456789123456789\nBigInt.new(\"123_456_789_123_456_789_123_456_789\")  # => 123456789123456789123456789\nBigInt.new(\"1234567890ABCDEF\", base: 16)           # => 1311768467294899695\n```","summary":"<p>Creates a <code><a href=\"BigInt.html\">BigInt</a></code> with the value denoted by <em>str</em> in the given <em>base</em>.</p>","abstract":false,"args":[{"name":"str","doc":null,"default_value":"","external_name":"str","restriction":"String"},{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":""}],"args_string":"(str : String, base = <span class=\"n\">10</span>)","args_html":"(str : <a href=\"String.html\">String</a>, base = <span class=\"n\">10</span>)","location":{"filename":"src/big/big_int.cr","line_number":36,"url":null},"def":{"name":"new","args":[{"name":"str","doc":null,"default_value":"","external_name":"str","restriction":"String"},{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(str, base)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:Int::Signed)-class-method","html_id":"new(num:Int::Signed)-class-method","name":"new","doc":"Creates a `BigInt` from the given *num*.","summary":"<p>Creates a <code><a href=\"BigInt.html\">BigInt</a></code> from the given <em>num</em>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Int::Signed"}],"args_string":"(num : Int::Signed)","args_html":"(num : <a href=\"Int/Signed.html\">Int::Signed</a>)","location":{"filename":"src/big/big_int.cr","line_number":48,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Int::Signed"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:Int::Unsigned)-class-method","html_id":"new(num:Int::Unsigned)-class-method","name":"new","doc":"Creates a `BigInt` from the given *num*.","summary":"<p>Creates a <code><a href=\"BigInt.html\">BigInt</a></code> from the given <em>num</em>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Int::Unsigned"}],"args_string":"(num : Int::Unsigned)","args_html":"(num : <a href=\"Int/Unsigned.html\">Int::Unsigned</a>)","location":{"filename":"src/big/big_int.cr","line_number":57,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Int::Unsigned"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:Float::Primitive)-class-method","html_id":"new(num:Float::Primitive)-class-method","name":"new","doc":"Creates a `BigInt` from the given *num*.","summary":"<p>Creates a <code><a href=\"BigInt.html\">BigInt</a></code> from the given <em>num</em>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Float::Primitive"}],"args_string":"(num : Float::Primitive)","args_html":"(num : <a href=\"Float/Primitive.html\">Float::Primitive</a>)","location":{"filename":"src/big/big_int.cr","line_number":66,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Float::Primitive"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:BigFloat)-class-method","html_id":"new(num:BigFloat)-class-method","name":"new","doc":"Creates a `BigInt` from the given *num*.","summary":"<p>Creates a <code><a href=\"BigInt.html\">BigInt</a></code> from the given <em>num</em>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigFloat"}],"args_string":"(num : BigFloat)","args_html":"(num : <a href=\"BigFloat.html\">BigFloat</a>)","location":{"filename":"src/big/big_int.cr","line_number":71,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigFloat"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"num.to_big_i"}},{"id":"new(num:BigDecimal)-class-method","html_id":"new(num:BigDecimal)-class-method","name":"new","doc":"Creates a `BigInt` from the given *num*.","summary":"<p>Creates a <code><a href=\"BigInt.html\">BigInt</a></code> from the given <em>num</em>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigDecimal"}],"args_string":"(num : BigDecimal)","args_html":"(num : <a href=\"BigDecimal.html\">BigDecimal</a>)","location":{"filename":"src/big/big_int.cr","line_number":76,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"num.to_big_i"}},{"id":"new(num:BigRational)-class-method","html_id":"new(num:BigRational)-class-method","name":"new","doc":"Creates a `BigInt` from the given *num*.","summary":"<p>Creates a <code><a href=\"BigInt.html\">BigInt</a></code> from the given <em>num</em>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigRational"}],"args_string":"(num : BigRational)","args_html":"(num : <a href=\"BigRational.html\">BigRational</a>)","location":{"filename":"src/big/big_int.cr","line_number":81,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"num.to_big_i"}},{"id":"new(num:BigInt)-class-method","html_id":"new(num:BigInt)-class-method","name":"new","doc":"Returns *num*. Useful for generic code that does `T.new(...)` with `T`\nbeing a `Number`.","summary":"<p>Returns <em>num</em>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigInt"}],"args_string":"(num : BigInt)","args_html":"(num : <a href=\"BigInt.html\">BigInt</a>)","location":{"filename":"src/big/big_int.cr","line_number":87,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"num"}},{"id":"new-class-method","html_id":"new-class-method","name":"new","doc":"Creates a `BigInt` with the value zero.\n\n```\nrequire \"big\"\n\nBigInt.new # => 0\n```","summary":"<p>Creates a <code><a href=\"BigInt.html\">BigInt</a></code> with the value zero.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":21,"url":null},"def":{"name":"new","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"%(other:Int):BigInt-instance-method","html_id":"%(other:Int):BigInt-instance-method","name":"%","doc":"Returns `self` modulo *other*.\n\nThis uses floored division.\n\nSee `Int#/` for more details.","summary":"<p>Returns <code>self</code> modulo <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":252,"url":null},"def":{"name":"%","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"check_division_by_zero(other)\nif other < 0\n  -((-self).unsafe_floored_mod(-other))\nelse\n  unsafe_floored_mod(other)\nend\n"}},{"id":"&(other:Int):BigInt-instance-method","html_id":"&(other:Int):BigInt-instance-method","name":"&","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":351,"url":null},"def":{"name":"&","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.and(mpz, self, other.to_big_i)\nend"}},{"id":"&*(other):BigInt-instance-method","html_id":"&*(other):BigInt-instance-method","name":"&*","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"args_string":"(other) : BigInt","args_html":"(other) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":195,"url":null},"def":{"name":"&*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"self * other"}},{"id":"&+(other):BigInt-instance-method","html_id":"&+(other):BigInt-instance-method","name":"&+","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"args_string":"(other) : BigInt","args_html":"(other) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":140,"url":null},"def":{"name":"&+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"self + other"}},{"id":"&-(other):BigInt-instance-method","html_id":"&-(other):BigInt-instance-method","name":"&-","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"args_string":"(other) : BigInt","args_html":"(other) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":158,"url":null},"def":{"name":"&-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"self - other"}},{"id":"*(other:Int):BigInt-instance-method","html_id":"*(other:Int):BigInt-instance-method","name":"*","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":191,"url":null},"def":{"name":"*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"self * other.to_big_i"}},{"id":"*(other:LibGMP::IntPrimitiveUnsigned):BigInt-instance-method","html_id":"*(other:LibGMP::IntPrimitiveUnsigned):BigInt-instance-method","name":"*","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"LibGMP::IntPrimitiveUnsigned"}],"args_string":"(other : LibGMP::IntPrimitiveUnsigned) : BigInt","args_html":"(other : LibGMP::IntPrimitiveUnsigned) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":187,"url":null},"def":{"name":"*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"LibGMP::IntPrimitiveUnsigned"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.mul_ui(mpz, self, other)\nend"}},{"id":"*(other:LibGMP::IntPrimitiveSigned):BigInt-instance-method","html_id":"*(other:LibGMP::IntPrimitiveSigned):BigInt-instance-method","name":"*","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"LibGMP::IntPrimitiveSigned"}],"args_string":"(other : LibGMP::IntPrimitiveSigned) : BigInt","args_html":"(other : LibGMP::IntPrimitiveSigned) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":183,"url":null},"def":{"name":"*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"LibGMP::IntPrimitiveSigned"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.mul_si(mpz, self, other)\nend"}},{"id":"*(other:BigInt):BigInt-instance-method","html_id":"*(other:BigInt):BigInt-instance-method","name":"*","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":179,"url":null},"def":{"name":"*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.mul(mpz, self, other)\nend"}},{"id":"**(other:Int):BigInt-instance-method","html_id":"**(other:Int):BigInt-instance-method","name":"**","doc":"Returns the value of raising `self` to the power of *exponent*.\n\nRaises `ArgumentError` if *exponent* is negative: if this is needed,\neither use a float base or a float exponent.\n\nRaises `OverflowError` in case of overflow.\n\n```\n2 ** 3  # => 8\n2 ** 0  # => 1\n2 ** -1 # ArgumentError\n```","summary":"<p>Returns the value of raising <code>self</code> to the power of <em>exponent</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":378,"url":null},"def":{"name":"**","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"if other < 0\n  raise(ArgumentError.new(\"Negative exponent isn't supported\"))\nend\nBigInt.new do |mpz|\n  LibGMP.pow_ui(mpz, self, other)\nend\n"}},{"id":"+(other:Int):BigInt-instance-method","html_id":"+(other:Int):BigInt-instance-method","name":"+","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":130,"url":null},"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"if other < 0\n  self - other.abs\nelse\n  if other <= LibGMP::ULong::MAX\n    BigInt.new do |mpz|\n      LibGMP.add_ui(mpz, self, other)\n    end\n  else\n    self + other.to_big_i\n  end\nend"}},{"id":"+(other:BigInt):BigInt-instance-method","html_id":"+(other:BigInt):BigInt-instance-method","name":"+","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":126,"url":null},"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.add(mpz, self, other)\nend"}},{"id":"-:BigInt-instance-method","html_id":"-:BigInt-instance-method","name":"-","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : BigInt","args_html":" : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":162,"url":null},"def":{"name":"-","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.neg(mpz, self)\nend"}},{"id":"-(other:Int):BigInt-instance-method","html_id":"-(other:Int):BigInt-instance-method","name":"-","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":148,"url":null},"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"if other < 0\n  self + other.abs\nelse\n  if other <= LibGMP::ULong::MAX\n    BigInt.new do |mpz|\n      LibGMP.sub_ui(mpz, self, other)\n    end\n  else\n    self - other.to_big_i\n  end\nend"}},{"id":"-(other:BigInt):BigInt-instance-method","html_id":"-(other:BigInt):BigInt-instance-method","name":"-","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":144,"url":null},"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.sub(mpz, self, other)\nend"}},{"id":"/(other:UInt128):BigFloat-instance-method","html_id":"/(other:UInt128):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt128"}],"args_string":"(other : UInt128) : BigFloat","args_html":"(other : <a href=\"UInt128.html\">UInt128</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":2,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt128"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Int128):BigFloat-instance-method","html_id":"/(other:Int128):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int128"}],"args_string":"(other : Int128) : BigFloat","args_html":"(other : <a href=\"Int128.html\">Int128</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":2,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int128"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Float32):BigFloat-instance-method","html_id":"/(other:Float32):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32"}],"args_string":"(other : Float32) : BigFloat","args_html":"(other : <a href=\"Float32.html\">Float32</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":3,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:UInt64):BigFloat-instance-method","html_id":"/(other:UInt64):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt64"}],"args_string":"(other : UInt64) : BigFloat","args_html":"(other : <a href=\"UInt64.html\">UInt64</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":2,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Int64):BigFloat-instance-method","html_id":"/(other:Int64):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int64"}],"args_string":"(other : Int64) : BigFloat","args_html":"(other : <a href=\"Int64.html\">Int64</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":2,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:UInt32):BigFloat-instance-method","html_id":"/(other:UInt32):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt32"}],"args_string":"(other : UInt32) : BigFloat","args_html":"(other : <a href=\"UInt32.html\">UInt32</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":2,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Int32):BigFloat-instance-method","html_id":"/(other:Int32):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int32"}],"args_string":"(other : Int32) : BigFloat","args_html":"(other : <a href=\"Int32.html\">Int32</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":2,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:UInt16):BigFloat-instance-method","html_id":"/(other:UInt16):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt16"}],"args_string":"(other : UInt16) : BigFloat","args_html":"(other : <a href=\"UInt16.html\">UInt16</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":2,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt16"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Int16):BigFloat-instance-method","html_id":"/(other:Int16):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int16"}],"args_string":"(other : Int16) : BigFloat","args_html":"(other : <a href=\"Int16.html\">Int16</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":2,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int16"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Int8):BigFloat-instance-method","html_id":"/(other:Int8):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int8"}],"args_string":"(other : Int8) : BigFloat","args_html":"(other : <a href=\"Int8.html\">Int8</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":2,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int8"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:BigRational):BigRational-instance-method","html_id":"/(other:BigRational):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational) : BigRational","args_html":"(other : <a href=\"BigRational.html\">BigRational</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_int.cr","line_number":201,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:BigDecimal):BigDecimal-instance-method","html_id":"/(other:BigDecimal):BigDecimal-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : BigDecimal","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>) : <a href=\"BigDecimal.html\">BigDecimal</a>","location":{"filename":"src/big/big_int.cr","line_number":200,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigDecimal","visibility":"Public","body":"(BigDecimal.new(self)) / (BigDecimal.new(other))"}},{"id":"/(other:BigInt):BigFloat-instance-method","html_id":"/(other:BigInt):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigFloat","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/big_int.cr","line_number":199,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:UInt8):BigFloat-instance-method","html_id":"/(other:UInt8):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt8"}],"args_string":"(other : UInt8) : BigFloat","args_html":"(other : <a href=\"UInt8.html\">UInt8</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":2,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt8"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"/(other:Float64):BigFloat-instance-method","html_id":"/(other:Float64):BigFloat-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float64"}],"args_string":"(other : Float64) : BigFloat","args_html":"(other : <a href=\"Float64.html\">Float64</a>) : <a href=\"BigFloat.html\">BigFloat</a>","location":{"filename":"src/big/number.cr","line_number":3,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigFloat","visibility":"Public","body":"(BigFloat.new(self)) / (BigFloat.new(other))"}},{"id":"//(other:Int::Unsigned):BigInt-instance-method","html_id":"//(other:Int::Unsigned):BigInt-instance-method","name":"//","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int::Unsigned"}],"args_string":"(other : Int::Unsigned) : BigInt","args_html":"(other : <a href=\"Int/Unsigned.html\">Int::Unsigned</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":203,"url":null},"def":{"name":"//","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int::Unsigned"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"check_division_by_zero(other)\nunsafe_floored_div(other)\n"}},{"id":"//(other:Int):BigInt-instance-method","html_id":"//(other:Int):BigInt-instance-method","name":"//","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":208,"url":null},"def":{"name":"//","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"check_division_by_zero(other)\nif other < 0\n  (-self).unsafe_floored_div(-other)\nelse\n  unsafe_floored_div(other)\nend\n"}},{"id":"<<(other:Int):BigInt-instance-method","html_id":"<<(other:Int):BigInt-instance-method","name":"<<","doc":"Returns the result of shifting this number's bits *count* positions to the left.\n\n* If *count* is greater than the number of bits of this integer, returns 0\n* If *count* is negative, a right shift is performed\n\n```\n8000 << 1  # => 16000\n8000 << 2  # => 32000\n8000 << 32 # => 0\n8000 << -1 # => 4000\n```","summary":"<p>Returns the result of shifting this number's bits <em>count</em> positions to the left.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":374,"url":null},"def":{"name":"<<","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.mul_2exp(mpz, self, other)\nend"}},{"id":"(other:BigInt)-instance-method","html_id":"(other:BigInt)-instance-method","name":"<=>","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt)","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>)","location":{"filename":"src/big/big_int.cr","line_number":102,"url":null},"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.cmp(mpz, other)"}},{"id":"(other:Float)-instance-method","html_id":"(other:Float)-instance-method","name":"<=>","doc":"The comparison operator. Returns `0` if the two objects are equal,\na negative number if this object is considered less than *other*,\na positive number if this object is considered greater than *other*,\nor `nil` if the two objects are not comparable.\n\nSubclasses define this method to provide class-specific ordering.\n\nThe comparison operator is usually used to sort values:\n\n```\n# Sort in a descending way:\n[3, 1, 2].sort { |x, y| y <=> x } # => [3, 2, 1]\n\n# Sort in an ascending way:\n[3, 1, 2].sort { |x, y| x <=> y } # => [1, 2, 3]\n```","summary":"<p>The comparison operator.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float"}],"args_string":"(other : Float)","args_html":"(other : <a href=\"Float.html\">Float</a>)","location":{"filename":"src/big/big_int.cr","line_number":122,"url":null},"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.cmp_d(mpz, other)"}},{"id":"(other:Int::Unsigned)-instance-method","html_id":"(other:Int::Unsigned)-instance-method","name":"<=>","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int::Unsigned"}],"args_string":"(other : Int::Unsigned)","args_html":"(other : <a href=\"Int/Unsigned.html\">Int::Unsigned</a>)","location":{"filename":"src/big/big_int.cr","line_number":114,"url":null},"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int::Unsigned"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if other <= LibC::ULong::MAX\n  LibGMP.cmp_ui(mpz, other)\nelse\n  self <=> (BigInt.new(other))\nend"}},{"id":"(other:Int::Signed)-instance-method","html_id":"(other:Int::Signed)-instance-method","name":"<=>","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int::Signed"}],"args_string":"(other : Int::Signed)","args_html":"(other : <a href=\"Int/Signed.html\">Int::Signed</a>)","location":{"filename":"src/big/big_int.cr","line_number":106,"url":null},"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int::Signed"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if LibC::Long::MIN <= other && other <= LibC::Long::MAX\n  LibGMP.cmp_si(mpz, other)\nelse\n  self <=> (BigInt.new(other))\nend"}},{"id":">>(other:Int):BigInt-instance-method","html_id":">>(other:Int):BigInt-instance-method","name":">>","doc":"Returns the result of shifting this number's bits *count* positions to the right.\nAlso known as arithmetic right shift.\n\n* If *count* is greater than the number of bits of this integer, returns 0\n* If *count* is negative, a left shift is performed\n\n```\n8000 >> 1  # => 4000\n8000 >> 2  # => 2000\n8000 >> 32 # => 0\n8000 >> -1 # => 16000\n\n-8000 >> 1 # => -4000\n```","summary":"<p>Returns the result of shifting this number's bits <em>count</em> positions to the right.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":363,"url":null},"def":{"name":">>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.fdiv_q_2exp(mpz, self, other)\nend"}},{"id":"^(other:Int):BigInt-instance-method","html_id":"^(other:Int):BigInt-instance-method","name":"^","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":359,"url":null},"def":{"name":"^","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.xor(mpz, self, other.to_big_i)\nend"}},{"id":"abs:BigInt-instance-method","html_id":"abs:BigInt-instance-method","name":"abs","doc":"Returns the absolute value of this number.\n\n```\n123.abs  # => 123\n-123.abs # => 123\n```","summary":"<p>Returns the absolute value of this number.</p>","abstract":false,"args":[],"args_string":" : BigInt","args_html":" : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":166,"url":null},"def":{"name":"abs","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.abs(mpz, self)\nend"}},{"id":"bit_length:Int32-instance-method","html_id":"bit_length:Int32-instance-method","name":"bit_length","doc":"Returns the number of bits of this int value.\n\n“The number of bits” means that the bit position of the highest bit\nwhich is different to the sign bit.\n(The bit position of the bit 2**n is n+1.)\nIf there is no such bit (zero or minus one), zero is returned.\n\nI.e. This method returns `ceil(log2(self < 0 ? -self : self + 1))`.\n\n```\n0.bit_length # => 0\n1.bit_length # => 1\n2.bit_length # => 2\n3.bit_length # => 2\n4.bit_length # => 3\n5.bit_length # => 3\n\n# The above is the same as\n0b0.bit_length   # => 0\n0b1.bit_length   # => 1\n0b10.bit_length  # => 2\n0b11.bit_length  # => 2\n0b100.bit_length # => 3\n0b101.bit_length # => 3\n```","summary":"<p>Returns the number of bits of this int value.</p>","abstract":false,"args":[],"args_string":" : Int32","args_html":" : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/big/big_int.cr","line_number":406,"url":null},"def":{"name":"bit_length","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":"(LibGMP.sizeinbase(self, 2)).to_i"}},{"id":"clone-instance-method","html_id":"clone-instance-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":595,"url":null},"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"divmod(number:Int::Unsigned)-instance-method","html_id":"divmod(number:Int::Unsigned)-instance-method","name":"divmod","doc":null,"summary":null,"abstract":false,"args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"Int::Unsigned"}],"args_string":"(number : Int::Unsigned)","args_html":"(number : <a href=\"Int/Unsigned.html\">Int::Unsigned</a>)","location":{"filename":"src/big/big_int.cr","line_number":288,"url":null},"def":{"name":"divmod","args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"Int::Unsigned"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"check_division_by_zero(number)\nif number <= LibC::ULong::MAX\n  unsafe_floored_divmod(LibGMP::ULong.new(number))\nelse\n  divmod(number.to_big_i)\nend\n"}},{"id":"divmod(number:Int::Signed)-instance-method","html_id":"divmod(number:Int::Signed)-instance-method","name":"divmod","doc":null,"summary":null,"abstract":false,"args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"Int::Signed"}],"args_string":"(number : Int::Signed)","args_html":"(number : <a href=\"Int/Signed.html\">Int::Signed</a>)","location":{"filename":"src/big/big_int.cr","line_number":279,"url":null},"def":{"name":"divmod","args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"Int::Signed"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"check_division_by_zero(number)\nif number > 0 && number <= LibC::Long::MAX\n  unsafe_floored_divmod(LibGMP::ULong.new(number))\nelse\n  divmod(number.to_big_i)\nend\n"}},{"id":"divmod(number:LibGMP::ULong)-instance-method","html_id":"divmod(number:LibGMP::ULong)-instance-method","name":"divmod","doc":null,"summary":null,"abstract":false,"args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"LibGMP::ULong"}],"args_string":"(number : LibGMP::ULong)","args_html":"(number : LibGMP::ULong)","location":{"filename":"src/big/big_int.cr","line_number":274,"url":null},"def":{"name":"divmod","args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"LibGMP::ULong"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"check_division_by_zero(number)\nunsafe_floored_divmod(number)\n"}},{"id":"divmod(number:BigInt)-instance-method","html_id":"divmod(number:BigInt)-instance-method","name":"divmod","doc":null,"summary":null,"abstract":false,"args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"BigInt"}],"args_string":"(number : BigInt)","args_html":"(number : <a href=\"BigInt.html\">BigInt</a>)","location":{"filename":"src/big/big_int.cr","line_number":268,"url":null},"def":{"name":"divmod","args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"check_division_by_zero(number)\nunsafe_floored_divmod(number)\n"}},{"id":"factorial:BigInt-instance-method","html_id":"factorial:BigInt-instance-method","name":"factorial","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : BigInt","args_html":" : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":170,"url":null},"def":{"name":"factorial","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"if self < 0\n  raise(ArgumentError.new(\"Factorial not defined for negative values\"))\nelse\n  if self > LibGMP::ULong::MAX\n    raise(ArgumentError.new(\"Factorial not supported for numbers bigger than 2^64\"))\n  end\nend\nBigInt.new do |mpz|\n  LibGMP.fac_ui(mpz, self)\nend\n"}},{"id":"gcd(other:Int):Int-instance-method","html_id":"gcd(other:Int):Int-instance-method","name":"gcd","doc":"Returns the greatest common divisor of `self` and *other*.","summary":"<p>Returns the greatest common divisor of <code>self</code> and <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : Int","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"Int.html\">Int</a>","location":{"filename":"src/big/big_int.cr","line_number":391,"url":null},"def":{"name":"gcd","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int","visibility":"Public","body":"result = LibGMP.gcd_ui(nil, self, other.abs.to_u64)\nresult == 0 ? self : result\n"}},{"id":"gcd(other:BigInt):BigInt-instance-method","html_id":"gcd(other:BigInt):BigInt-instance-method","name":"gcd","doc":"Returns the greatest common divisor of `self` and *other*.","summary":"<p>Returns the greatest common divisor of <code>self</code> and <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":386,"url":null},"def":{"name":"gcd","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.gcd(mpz, self, other)\nend"}},{"id":"hash(hasher)-instance-method","html_id":"hash(hasher)-instance-method","name":"hash","doc":"TODO: check hash equality for numbers >= 2**63","summary":"<p><span class=\"flag orange\">TODO</span>  check hash equality for numbers >= 2**63</p>","abstract":false,"args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"args_string":"(hasher)","args_html":"(hasher)","location":{"filename":"src/big/big_int.cr","line_number":411,"url":null},"def":{"name":"hash","args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"hasher = to_i64!.hash(hasher)\nhasher\n"}},{"id":"lcm(other:Int):BigInt-instance-method","html_id":"lcm(other:Int):BigInt-instance-method","name":"lcm","doc":"Returns the least common multiple of `self` and *other*.","summary":"<p>Returns the least common multiple of <code>self</code> and <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":402,"url":null},"def":{"name":"lcm","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.lcm_ui(mpz, self, other.abs.to_u64)\nend"}},{"id":"lcm(other:BigInt):BigInt-instance-method","html_id":"lcm(other:BigInt):BigInt-instance-method","name":"lcm","doc":"Returns the least common multiple of `self` and *other*.","summary":"<p>Returns the least common multiple of <code>self</code> and <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":397,"url":null},"def":{"name":"lcm","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.lcm(mpz, self, other)\nend"}},{"id":"popcount-instance-method","html_id":"popcount-instance-method","name":"popcount","doc":"Counts `1`-bits in the binary representation of this integer.\n\n```\n5.popcount   # => 2\n-15.popcount # => 29\n```","summary":"<p>Counts <code>1</code>-bits in the binary representation of this integer.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":457,"url":null},"def":{"name":"popcount","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.popcount(self)"}},{"id":"remainder(other:Int):BigInt-instance-method","html_id":"remainder(other:Int):BigInt-instance-method","name":"remainder","doc":"Returns `self` remainder *other*.\n\nThis uses truncated division.\n\nSee `Int#tdiv` for more details.","summary":"<p>Returns <code>self</code> remainder <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":262,"url":null},"def":{"name":"remainder","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"check_division_by_zero(other)\nunsafe_truncated_mod(other)\n"}},{"id":"tdiv(other:Int):BigInt-instance-method","html_id":"tdiv(other:Int):BigInt-instance-method","name":"tdiv","doc":"Divides `self` by *other* using truncated division.\n\nIn truncated division, given two integers x and y:\n* `q = x.tdiv(y)` is rounded toward zero\n* `r = x.remainder(y)` has the sign of the first argument\n* `x == q*y + r`\n\nFor example:\n\n```text\n x     y     x / y     x % y\n 5     3       1         2\n-5     3      -1        -2\n 5    -3      -1         2\n-5    -3       1        -2\n```\n\nRaises if *other* is `0`, or if *other* is `-1` and\n`self` is signed and is the minimum value for that\ninteger type.","summary":"<p>Divides <code>self</code> by <em>other</em> using truncated division.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":218,"url":null},"def":{"name":"tdiv","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"check_division_by_zero(other)\nunsafe_truncated_div(other)\n"}},{"id":"to_big_d-instance-method","html_id":"to_big_d-instance-method","name":"to_big_d","doc":"Converts `self` to `BigDecimal`.\n```\nrequire \"big\"\n12123415151254124124.to_big_d\n```","summary":"<p>Converts <code>self</code> to <code><a href=\"BigDecimal.html\">BigDecimal</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":587,"url":null},"def":{"name":"to_big_d","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigDecimal.new(self)"}},{"id":"to_big_f-instance-method","html_id":"to_big_f-instance-method","name":"to_big_f","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":583,"url":null},"def":{"name":"to_big_f","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new do |mpf|\n  LibGMP.mpf_set_z(mpf, mpz)\nend"}},{"id":"to_big_i-instance-method","html_id":"to_big_i-instance-method","name":"to_big_i","doc":"Returns a `BigInt` representing this integer.\n```\nrequire \"big\"\n\n123.to_big_i\n```","summary":"<p>Returns a <code><a href=\"BigInt.html\">BigInt</a></code> representing this integer.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":579,"url":null},"def":{"name":"to_big_i","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"to_big_r-instance-method","html_id":"to_big_r-instance-method","name":"to_big_r","doc":"Returns a `BigRational` representing this integer.\n```\nrequire \"big\"\n\n123.to_big_r\n```","summary":"<p>Returns a <code><a href=\"BigRational.html\">BigRational</a></code> representing this integer.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":591,"url":null},"def":{"name":"to_big_r","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigRational.new(self)"}},{"id":"to_f-instance-method","html_id":"to_f-instance-method","name":"to_f","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":555,"url":null},"def":{"name":"to_f","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64"}},{"id":"to_f!-instance-method","html_id":"to_f!-instance-method","name":"to_f!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":567,"url":null},"def":{"name":"to_f!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64!"}},{"id":"to_f32-instance-method","html_id":"to_f32-instance-method","name":"to_f32","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":559,"url":null},"def":{"name":"to_f32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_f32"}},{"id":"to_f32!-instance-method","html_id":"to_f32!-instance-method","name":"to_f32!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":571,"url":null},"def":{"name":"to_f32!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.get_d(self)).to_f32!"}},{"id":"to_f64-instance-method","html_id":"to_f64-instance-method","name":"to_f64","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":563,"url":null},"def":{"name":"to_f64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.get_d(self)"}},{"id":"to_f64!-instance-method","html_id":"to_f64!-instance-method","name":"to_f64!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":575,"url":null},"def":{"name":"to_f64!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.get_d(self)"}},{"id":"to_i-instance-method","html_id":"to_i-instance-method","name":"to_i","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":465,"url":null},"def":{"name":"to_i","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i32"}},{"id":"to_i!-instance-method","html_id":"to_i!-instance-method","name":"to_i!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":489,"url":null},"def":{"name":"to_i!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i32!"}},{"id":"to_i16-instance-method","html_id":"to_i16-instance-method","name":"to_i16","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":473,"url":null},"def":{"name":"to_i16","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i32.to_i16"}},{"id":"to_i16!-instance-method","html_id":"to_i16!-instance-method","name":"to_i16!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":497,"url":null},"def":{"name":"to_i16!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.get_si(self)).to_i16!"}},{"id":"to_i32-instance-method","html_id":"to_i32-instance-method","name":"to_i32","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":477,"url":null},"def":{"name":"to_i32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.get_si(self)).to_i32"}},{"id":"to_i32!-instance-method","html_id":"to_i32!-instance-method","name":"to_i32!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":501,"url":null},"def":{"name":"to_i32!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.get_si(self)).to_i32!"}},{"id":"to_i64-instance-method","html_id":"to_i64-instance-method","name":"to_i64","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":481,"url":null},"def":{"name":"to_i64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if LibGMP::Long::MIN <= self && self <= LibGMP::Long::MAX\n  (LibGMP.get_si(self)).to_i64\nelse\n  to_s.to_i64 do\n    raise(OverflowError.new)\n  end\nend"}},{"id":"to_i64!-instance-method","html_id":"to_i64!-instance-method","name":"to_i64!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":505,"url":null},"def":{"name":"to_i64!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(self % BITS64).to_u64.to_i64!"}},{"id":"to_i8-instance-method","html_id":"to_i8-instance-method","name":"to_i8","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":469,"url":null},"def":{"name":"to_i8","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i32.to_i8"}},{"id":"to_i8!-instance-method","html_id":"to_i8!-instance-method","name":"to_i8!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":493,"url":null},"def":{"name":"to_i8!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.get_si(self)).to_i8!"}},{"id":"to_s:String-instance-method","html_id":"to_s:String-instance-method","name":"to_s","doc":"Returns a string representation of self.\n\n```\nrequire \"big\"\n\nBigInt.new(\"123456789101101987654321\").to_s # => 123456789101101987654321\n```","summary":"<p>Returns a string representation of self.</p>","abstract":false,"args":[],"args_string":" : String","args_html":" : <a href=\"String.html\">String</a>","location":{"filename":"src/big/big_int.cr","line_number":420,"url":null},"def":{"name":"to_s","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"String.new(to_cstr)"}},{"id":"to_s(base:Int):String-instance-method","html_id":"to_s(base:Int):String-instance-method","name":"to_s","doc":"Returns a string containing the representation of big radix base (2 through 36).\n\n```\nrequire \"big\"\n\nBigInt.new(\"123456789101101987654321\").to_s(8)  # => \"32111154373025463465765261\"\nBigInt.new(\"123456789101101987654321\").to_s(16) # => \"1a249b1f61599cd7eab1\"\nBigInt.new(\"123456789101101987654321\").to_s(36) # => \"k3qmt029k48nmpd\"\n```","summary":"<p>Returns a string containing the representation of big radix base (2 through 36).</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"","external_name":"base","restriction":"Int"}],"args_string":"(base : Int) : String","args_html":"(base : <a href=\"Int.html\">Int</a>) : <a href=\"String.html\">String</a>","location":{"filename":"src/big/big_int.cr","line_number":439,"url":null},"def":{"name":"to_s","args":[{"name":"base","doc":null,"default_value":"","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"if 2 <= base && base <= 36\nelse\n  raise(ArgumentError.new(\"Invalid base #{base}\"))\nend\ncstr = LibGMP.get_str(nil, base, self)\nString.new(cstr)\n"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Returns a string representation of self.\n\n```\nrequire \"big\"\n\nBigInt.new(\"123456789101101987654321\").to_s # => 123456789101101987654321\n```","summary":"<p>Returns a string representation of self.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/big_int.cr","line_number":425,"url":null},"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"str = to_cstr\nio.write_utf8(Slice.new(str, LibC.strlen(str)))\n"}},{"id":"to_u-instance-method","html_id":"to_u-instance-method","name":"to_u","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":509,"url":null},"def":{"name":"to_u","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u32"}},{"id":"to_u!-instance-method","html_id":"to_u!-instance-method","name":"to_u!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":533,"url":null},"def":{"name":"to_u!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u32!"}},{"id":"to_u16-instance-method","html_id":"to_u16-instance-method","name":"to_u16","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":517,"url":null},"def":{"name":"to_u16","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u32.to_u16"}},{"id":"to_u16!-instance-method","html_id":"to_u16!-instance-method","name":"to_u16!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":541,"url":null},"def":{"name":"to_u16!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.get_ui(self)).to_u16!"}},{"id":"to_u32-instance-method","html_id":"to_u32-instance-method","name":"to_u32","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":521,"url":null},"def":{"name":"to_u32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u64.to_u32"}},{"id":"to_u32!-instance-method","html_id":"to_u32!-instance-method","name":"to_u32!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":545,"url":null},"def":{"name":"to_u32!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.get_ui(self)).to_u32!"}},{"id":"to_u64-instance-method","html_id":"to_u64-instance-method","name":"to_u64","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":525,"url":null},"def":{"name":"to_u64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if LibGMP::ULong::MIN <= self && self <= LibGMP::ULong::MAX\n  (LibGMP.get_ui(self)).to_u64\nelse\n  to_s.to_u64 do\n    raise(OverflowError.new)\n  end\nend"}},{"id":"to_u64!-instance-method","html_id":"to_u64!-instance-method","name":"to_u64!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":549,"url":null},"def":{"name":"to_u64!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(self % BITS64).to_u64"}},{"id":"to_u8-instance-method","html_id":"to_u8-instance-method","name":"to_u8","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":513,"url":null},"def":{"name":"to_u8","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u32.to_u8"}},{"id":"to_u8!-instance-method","html_id":"to_u8!-instance-method","name":"to_u8!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":537,"url":null},"def":{"name":"to_u8!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(LibGMP.get_ui(self)).to_u8!"}},{"id":"to_unsafe-instance-method","html_id":"to_unsafe-instance-method","name":"to_unsafe","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":613,"url":null},"def":{"name":"to_unsafe","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"mpz"}},{"id":"trailing_zeros_count-instance-method","html_id":"trailing_zeros_count-instance-method","name":"trailing_zeros_count","doc":"Returns the number of trailing `0`-bits.","summary":"<p>Returns the number of trailing <code>0</code>-bits.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_int.cr","line_number":461,"url":null},"def":{"name":"trailing_zeros_count","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.scan1(self, 0)"}},{"id":"unsafe_floored_div(other:BigInt):BigInt-instance-method","html_id":"unsafe_floored_div(other:BigInt):BigInt-instance-method","name":"unsafe_floored_div","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":224,"url":null},"def":{"name":"unsafe_floored_div","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.fdiv_q(mpz, self, other)\nend"}},{"id":"unsafe_floored_div(other:Int):BigInt-instance-method","html_id":"unsafe_floored_div(other:Int):BigInt-instance-method","name":"unsafe_floored_div","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":228,"url":null},"def":{"name":"unsafe_floored_div","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"if (LibGMP::ULong == UInt32) && (other < Int32::MIN || other > UInt32::MAX)\n  unsafe_floored_div(other.to_big_i)\nelse\n  if other < 0\n    -BigInt.new do |mpz|\n      LibGMP.fdiv_q_ui(mpz, self, other.abs)\n    end\n  else\n    BigInt.new do |mpz|\n      LibGMP.fdiv_q_ui(mpz, self, other)\n    end\n  end\nend"}},{"id":"unsafe_floored_divmod(number:LibGMP::ULong)-instance-method","html_id":"unsafe_floored_divmod(number:LibGMP::ULong)-instance-method","name":"unsafe_floored_divmod","doc":null,"summary":null,"abstract":false,"args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"LibGMP::ULong"}],"args_string":"(number : LibGMP::ULong)","args_html":"(number : LibGMP::ULong)","location":{"filename":"src/big/big_int.cr","line_number":329,"url":null},"def":{"name":"unsafe_floored_divmod","args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"LibGMP::ULong"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"the_q = BigInt.new\nthe_r = BigInt.new do |r|\n  LibGMP.fdiv_qr_ui(the_q, r, self, number)\nend\n{the_q, the_r}\n"}},{"id":"unsafe_floored_divmod(number:BigInt)-instance-method","html_id":"unsafe_floored_divmod(number:BigInt)-instance-method","name":"unsafe_floored_divmod","doc":null,"summary":null,"abstract":false,"args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"BigInt"}],"args_string":"(number : BigInt)","args_html":"(number : <a href=\"BigInt.html\">BigInt</a>)","location":{"filename":"src/big/big_int.cr","line_number":323,"url":null},"def":{"name":"unsafe_floored_divmod","args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"the_q = BigInt.new\nthe_r = BigInt.new do |r|\n  LibGMP.fdiv_qr(the_q, r, self, number)\nend\n{the_q, the_r}\n"}},{"id":"unsafe_floored_mod(other:Int):BigInt-instance-method","html_id":"unsafe_floored_mod(other:Int):BigInt-instance-method","name":"unsafe_floored_mod","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":301,"url":null},"def":{"name":"unsafe_floored_mod","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"if (other < LibGMP::Long::MIN || other > LibGMP::ULong::MAX)\n  unsafe_floored_mod(other.to_big_i)\nelse\n  if other < 0\n    -BigInt.new do |mpz|\n      LibGMP.fdiv_r_ui(mpz, self, other.abs)\n    end\n  else\n    BigInt.new do |mpz|\n      LibGMP.fdiv_r_ui(mpz, self, other)\n    end\n  end\nend"}},{"id":"unsafe_floored_mod(other:BigInt):BigInt-instance-method","html_id":"unsafe_floored_mod(other:BigInt):BigInt-instance-method","name":"unsafe_floored_mod","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":297,"url":null},"def":{"name":"unsafe_floored_mod","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.fdiv_r(mpz, self, other)\nend"}},{"id":"unsafe_truncated_div(other:Int):BigInt-instance-method","html_id":"unsafe_truncated_div(other:Int):BigInt-instance-method","name":"unsafe_truncated_div","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":242,"url":null},"def":{"name":"unsafe_truncated_div","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"if (LibGMP::ULong == UInt32) && (other < Int32::MIN || other > UInt32::MAX)\n  unsafe_truncated_div(other.to_big_i)\nelse\n  if other < 0\n    -BigInt.new do |mpz|\n      LibGMP.tdiv_q_ui(mpz, self, other.abs)\n    end\n  else\n    BigInt.new do |mpz|\n      LibGMP.tdiv_q_ui(mpz, self, other)\n    end\n  end\nend"}},{"id":"unsafe_truncated_div(other:BigInt):BigInt-instance-method","html_id":"unsafe_truncated_div(other:BigInt):BigInt-instance-method","name":"unsafe_truncated_div","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":238,"url":null},"def":{"name":"unsafe_truncated_div","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.tdiv_q(mpz, self, other)\nend"}},{"id":"unsafe_truncated_divmod(number:BigInt)-instance-method","html_id":"unsafe_truncated_divmod(number:BigInt)-instance-method","name":"unsafe_truncated_divmod","doc":null,"summary":null,"abstract":false,"args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"BigInt"}],"args_string":"(number : BigInt)","args_html":"(number : <a href=\"BigInt.html\">BigInt</a>)","location":{"filename":"src/big/big_int.cr","line_number":335,"url":null},"def":{"name":"unsafe_truncated_divmod","args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"the_q = BigInt.new\nthe_r = BigInt.new do |r|\n  LibGMP.tdiv_qr(the_q, r, self, number)\nend\n{the_q, the_r}\n"}},{"id":"unsafe_truncated_divmod(number:LibGMP::ULong)-instance-method","html_id":"unsafe_truncated_divmod(number:LibGMP::ULong)-instance-method","name":"unsafe_truncated_divmod","doc":null,"summary":null,"abstract":false,"args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"LibGMP::ULong"}],"args_string":"(number : LibGMP::ULong)","args_html":"(number : LibGMP::ULong)","location":{"filename":"src/big/big_int.cr","line_number":341,"url":null},"def":{"name":"unsafe_truncated_divmod","args":[{"name":"number","doc":null,"default_value":"","external_name":"number","restriction":"LibGMP::ULong"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"the_q = BigInt.new\nthe_r = BigInt.new do |r|\n  LibGMP.tdiv_qr_ui(the_q, r, self, number)\nend\n{the_q, the_r}\n"}},{"id":"unsafe_truncated_mod(other:Int):BigInt-instance-method","html_id":"unsafe_truncated_mod(other:Int):BigInt-instance-method","name":"unsafe_truncated_mod","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":319,"url":null},"def":{"name":"unsafe_truncated_mod","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.tdiv_r_ui(mpz, self, other.abs.to_big_i)\nend"}},{"id":"unsafe_truncated_mod(other:BigInt):BigInt-instance-method","html_id":"unsafe_truncated_mod(other:BigInt):BigInt-instance-method","name":"unsafe_truncated_mod","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigInt","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":311,"url":null},"def":{"name":"unsafe_truncated_mod","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.tdiv_r(mpz, self, other)\nend"}},{"id":"unsafe_truncated_mod(other:LibGMP::IntPrimitive):BigInt-instance-method","html_id":"unsafe_truncated_mod(other:LibGMP::IntPrimitive):BigInt-instance-method","name":"unsafe_truncated_mod","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"LibGMP::IntPrimitive"}],"args_string":"(other : LibGMP::IntPrimitive) : BigInt","args_html":"(other : LibGMP::IntPrimitive) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":315,"url":null},"def":{"name":"unsafe_truncated_mod","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"LibGMP::IntPrimitive"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.tdiv_r_ui(mpz, self, other.abs)\nend"}},{"id":"|(other:Int):BigInt-instance-method","html_id":"|(other:Int):BigInt-instance-method","name":"|","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigInt","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":355,"url":null},"def":{"name":"|","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.ior(mpz, self, other.to_big_i)\nend"}},{"id":"~:BigInt-instance-method","html_id":"~:BigInt-instance-method","name":"~","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : BigInt","args_html":" : <a href=\"BigInt.html\">BigInt</a>","location":{"filename":"src/big/big_int.cr","line_number":347,"url":null},"def":{"name":"~","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigInt","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.com(mpz, self)\nend"}}],"macros":[],"types":[]},{"html_id":"Crystal/BigRational","path":"BigRational.html","kind":"struct","full_name":"BigRational","name":"BigRational","abstract":false,"superclass":{"html_id":"Crystal/Number","kind":"struct","full_name":"Number","name":"Number"},"ancestors":[{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Number","kind":"struct","full_name":"Number","name":"Number"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"}],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"Rational numbers are represented as the quotient of arbitrarily large\nnumerators and denominators. Rationals are canonicalized such that the\ndenominator and the numerator have no common factors, and that the\ndenominator is positive. Zero has the unique representation 0/1.\n\n```\nrequire \"big\"\n\nr = BigRational.new(7.to_big_i, 3.to_big_i)\nr.to_s # => \"7/3\"\n\nr = BigRational.new(3, -9)\nr.to_s # => \"-1/3\"\n```\n\nIt is implemented under the hood with [GMP](https://gmplib.org/).","summary":"<p>Rational numbers are represented as the quotient of arbitrarily large numerators and denominators.</p>","class_methods":[],"constructors":[{"id":"new(numerator:Int,denominator:Int)-class-method","html_id":"new(numerator:Int,denominator:Int)-class-method","name":"new","doc":"Creates a new `BigRational`.\n\nIf *denominator* is 0, this will raise an exception.","summary":"<p>Creates a new <code><a href=\"BigRational.html\">BigRational</a></code>.</p>","abstract":false,"args":[{"name":"numerator","doc":null,"default_value":"","external_name":"numerator","restriction":"Int"},{"name":"denominator","doc":null,"default_value":"","external_name":"denominator","restriction":"Int"}],"args_string":"(numerator : Int, denominator : Int)","args_html":"(numerator : <a href=\"Int.html\">Int</a>, denominator : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/big/big_rational.cr","line_number":30,"url":null},"def":{"name":"new","args":[{"name":"numerator","doc":null,"default_value":"","external_name":"numerator","restriction":"Int"},{"name":"denominator","doc":null,"default_value":"","external_name":"denominator","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(numerator, denominator)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:Int)-class-method","html_id":"new(num:Int)-class-method","name":"new","doc":"Creates a new `BigRational` with *num* as the numerator and 1 for denominator.","summary":"<p>Creates a new <code><a href=\"BigRational.html\">BigRational</a></code> with <em>num</em> as the numerator and 1 for denominator.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Int"}],"args_string":"(num : Int)","args_html":"(num : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/big/big_rational.cr","line_number":43,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:Float)-class-method","html_id":"new(num:Float)-class-method","name":"new","doc":"Creates a exact representation of float as rational.","summary":"<p>Creates a exact representation of float as rational.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Float"}],"args_string":"(num : Float)","args_html":"(num : <a href=\"Float.html\">Float</a>)","location":{"filename":"src/big/big_rational.cr","line_number":48,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"Float"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(num)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(num:BigRational)-class-method","html_id":"new(num:BigRational)-class-method","name":"new","doc":"Creates a `BigRational` from the given *num*.","summary":"<p>Creates a <code><a href=\"BigRational.html\">BigRational</a></code> from the given <em>num</em>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigRational"}],"args_string":"(num : BigRational)","args_html":"(num : <a href=\"BigRational.html\">BigRational</a>)","location":{"filename":"src/big/big_rational.cr","line_number":63,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"num"}},{"id":"new(num:BigDecimal)-class-method","html_id":"new(num:BigDecimal)-class-method","name":"new","doc":"Creates a `BigRational` from the given *num*.","summary":"<p>Creates a <code><a href=\"BigRational.html\">BigRational</a></code> from the given <em>num</em>.</p>","abstract":false,"args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigDecimal"}],"args_string":"(num : BigDecimal)","args_html":"(num : <a href=\"BigDecimal.html\">BigDecimal</a>)","location":{"filename":"src/big/big_rational.cr","line_number":68,"url":null},"def":{"name":"new","args":[{"name":"num","doc":null,"default_value":"","external_name":"num","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"num.to_big_r"}}],"instance_methods":[{"id":"*(other:Int)-instance-method","html_id":"*(other:Int)-instance-method","name":"*","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int)","args_html":"(other : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/big/big_rational.cr","line_number":127,"url":null},"def":{"name":"*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self * other.to_big_r"}},{"id":"*(other:BigRational)-instance-method","html_id":"*(other:BigRational)-instance-method","name":"*","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational)","args_html":"(other : <a href=\"BigRational.html\">BigRational</a>)","location":{"filename":"src/big/big_rational.cr","line_number":123,"url":null},"def":{"name":"*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigRational.new do |mpq|\n  LibGMP.mpq_mul(mpq, self, other)\nend"}},{"id":"**(other:Int):BigRational-instance-method","html_id":"**(other:Int):BigRational-instance-method","name":"**","doc":"Raises the rational to the *other*th power\n\nThis will raise `DivisionByZeroError` if rational is 0 and *other* is negative.\n\n```\nrequire \"big\"\n\nBigRational.new(2, 3) ** 2  # => 4/9\nBigRational.new(2, 3) ** -1 # => 3/2\n```","summary":"<p>Raises the rational to the <em>other</em>th power</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : BigRational","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":187,"url":null},"def":{"name":"**","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"if other < 0\n  return (self ** (-other)).inv\nend\nBigRational.new(numerator ** other, denominator ** other)\n"}},{"id":"+(other:Int)-instance-method","html_id":"+(other:Int)-instance-method","name":"+","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int)","args_html":"(other : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/big/big_rational.cr","line_number":111,"url":null},"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self + other.to_big_r"}},{"id":"+(other:BigRational)-instance-method","html_id":"+(other:BigRational)-instance-method","name":"+","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational)","args_html":"(other : <a href=\"BigRational.html\">BigRational</a>)","location":{"filename":"src/big/big_rational.cr","line_number":107,"url":null},"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigRational.new do |mpq|\n  LibGMP.mpq_add(mpq, self, other)\nend"}},{"id":"--instance-method","html_id":"--instance-method","name":"-","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_rational.cr","line_number":173,"url":null},"def":{"name":"-","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigRational.new do |mpq|\n  LibGMP.mpq_neg(mpq, self)\nend"}},{"id":"-(other:Int)-instance-method","html_id":"-(other:Int)-instance-method","name":"-","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int)","args_html":"(other : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/big/big_rational.cr","line_number":119,"url":null},"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self - other.to_big_r"}},{"id":"-(other:BigRational)-instance-method","html_id":"-(other:BigRational)-instance-method","name":"-","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational)","args_html":"(other : <a href=\"BigRational.html\">BigRational</a>)","location":{"filename":"src/big/big_rational.cr","line_number":115,"url":null},"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigRational.new do |mpq|\n  LibGMP.mpq_sub(mpq, self, other)\nend"}},{"id":"/(other:Int64):BigRational-instance-method","html_id":"/(other:Int64):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int64"}],"args_string":"(other : Int64) : BigRational","args_html":"(other : <a href=\"Int64.html\">Int64</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":31,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:UInt64):BigRational-instance-method","html_id":"/(other:UInt64):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt64"}],"args_string":"(other : UInt64) : BigRational","args_html":"(other : <a href=\"UInt64.html\">UInt64</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":31,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:Int128):BigRational-instance-method","html_id":"/(other:Int128):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int128"}],"args_string":"(other : Int128) : BigRational","args_html":"(other : <a href=\"Int128.html\">Int128</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":31,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int128"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:UInt128):BigRational-instance-method","html_id":"/(other:UInt128):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt128"}],"args_string":"(other : UInt128) : BigRational","args_html":"(other : <a href=\"UInt128.html\">UInt128</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":31,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt128"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:Float32):BigRational-instance-method","html_id":"/(other:Float32):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32"}],"args_string":"(other : Float32) : BigRational","args_html":"(other : <a href=\"Float32.html\">Float32</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":32,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:Float64):BigRational-instance-method","html_id":"/(other:Float64):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float64"}],"args_string":"(other : Float64) : BigRational","args_html":"(other : <a href=\"Float64.html\">Float64</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":32,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:UInt32):BigRational-instance-method","html_id":"/(other:UInt32):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt32"}],"args_string":"(other : UInt32) : BigRational","args_html":"(other : <a href=\"UInt32.html\">UInt32</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":31,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:Int32):BigRational-instance-method","html_id":"/(other:Int32):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int32"}],"args_string":"(other : Int32) : BigRational","args_html":"(other : <a href=\"Int32.html\">Int32</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":31,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:UInt16):BigRational-instance-method","html_id":"/(other:UInt16):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt16"}],"args_string":"(other : UInt16) : BigRational","args_html":"(other : <a href=\"UInt16.html\">UInt16</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":31,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt16"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:Int16):BigRational-instance-method","html_id":"/(other:Int16):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int16"}],"args_string":"(other : Int16) : BigRational","args_html":"(other : <a href=\"Int16.html\">Int16</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":31,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int16"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:UInt8):BigRational-instance-method","html_id":"/(other:UInt8):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt8"}],"args_string":"(other : UInt8) : BigRational","args_html":"(other : <a href=\"UInt8.html\">UInt8</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":31,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"UInt8"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:Int8):BigRational-instance-method","html_id":"/(other:Int8):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int8"}],"args_string":"(other : Int8) : BigRational","args_html":"(other : <a href=\"Int8.html\">Int8</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/number.cr","line_number":31,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int8"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:BigDecimal):BigRational-instance-method","html_id":"/(other:BigDecimal):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal) : BigRational","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":136,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:BigFloat):BigRational-instance-method","html_id":"/(other:BigFloat):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigFloat"}],"args_string":"(other : BigFloat) : BigRational","args_html":"(other : <a href=\"BigFloat.html\">BigFloat</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":136,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigFloat"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:BigInt):BigRational-instance-method","html_id":"/(other:BigInt):BigRational-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"args_string":"(other : BigInt) : BigRational","args_html":"(other : <a href=\"BigInt.html\">BigInt</a>) : <a href=\"BigRational.html\">BigRational</a>","location":{"filename":"src/big/big_rational.cr","line_number":136,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigInt"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"BigRational","visibility":"Public","body":"(BigRational.new(self)) / (BigRational.new(other))"}},{"id":"/(other:BigRational)-instance-method","html_id":"/(other:BigRational)-instance-method","name":"/","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational)","args_html":"(other : <a href=\"BigRational.html\">BigRational</a>)","location":{"filename":"src/big/big_rational.cr","line_number":131,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"check_division_by_zero(other)\nBigRational.new do |mpq|\n  LibGMP.mpq_div(mpq, self, other)\nend\n"}},{"id":"<<(other:Int)-instance-method","html_id":"<<(other:Int)-instance-method","name":"<<","doc":"Multiplies the rational by (2 ** *other*)\n\n```\nrequire \"big\"\n\nBigRational.new(2, 3) << 2 # => 8/3\n```","summary":"<p>Multiplies the rational by (2 ** <em>other</em>)</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int)","args_html":"(other : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/big/big_rational.cr","line_number":169,"url":null},"def":{"name":"<<","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigRational.new do |mpq|\n  LibGMP.mpq_mul_2exp(mpq, self, other)\nend"}},{"id":"(other:BigDecimal)-instance-method","html_id":"(other:BigDecimal)-instance-method","name":"<=>","doc":"The comparison operator. Returns `0` if the two objects are equal,\na negative number if this object is considered less than *other*,\na positive number if this object is considered greater than *other*,\nor `nil` if the two objects are not comparable.\n\nSubclasses define this method to provide class-specific ordering.\n\nThe comparison operator is usually used to sort values:\n\n```\n# Sort in a descending way:\n[3, 1, 2].sort { |x, y| y <=> x } # => [3, 2, 1]\n\n# Sort in an ascending way:\n[3, 1, 2].sort { |x, y| x <=> y } # => [1, 2, 3]\n```","summary":"<p>The comparison operator.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"args_string":"(other : BigDecimal)","args_html":"(other : <a href=\"BigDecimal.html\">BigDecimal</a>)","location":{"filename":"src/big/big_decimal.cr","line_number":614,"url":null},"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigDecimal"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_d <=> other"}},{"id":"(other:Int)-instance-method","html_id":"(other:Int)-instance-method","name":"<=>","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int)","args_html":"(other : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/big/big_rational.cr","line_number":103,"url":null},"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpq_cmp(mpq, other.to_big_r)"}},{"id":"(other:Float)-instance-method","html_id":"(other:Float)-instance-method","name":"<=>","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float"}],"args_string":"(other : Float)","args_html":"(other : <a href=\"Float.html\">Float</a>)","location":{"filename":"src/big/big_rational.cr","line_number":99,"url":null},"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_big_f <=> other.to_big_f"}},{"id":"(other:Float32|Float64)-instance-method","html_id":"(other:Float32|Float64)-instance-method","name":"<=>","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32 | Float64"}],"args_string":"(other : Float32 | Float64)","args_html":"(other : <a href=\"Float32.html\">Float32</a> | <a href=\"Float64.html\">Float64</a>)","location":{"filename":"src/big/big_rational.cr","line_number":95,"url":null},"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Float32 | Float64"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self <=> (BigRational.new(other))"}},{"id":"(other:BigRational)-instance-method","html_id":"(other:BigRational)-instance-method","name":"<=>","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"args_string":"(other : BigRational)","args_html":"(other : <a href=\"BigRational.html\">BigRational</a>)","location":{"filename":"src/big/big_rational.cr","line_number":91,"url":null},"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BigRational"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpq_cmp(mpq, other)"}},{"id":">>(other:Int)-instance-method","html_id":">>(other:Int)-instance-method","name":">>","doc":"Divides the rational by (2 ** *other*)\n\n```\nrequire \"big\"\n\nBigRational.new(2, 3) >> 2 # => 1/6\n```","summary":"<p>Divides the rational by (2 ** <em>other</em>)</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int)","args_html":"(other : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/big/big_rational.cr","line_number":158,"url":null},"def":{"name":">>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigRational.new do |mpq|\n  LibGMP.mpq_div_2exp(mpq, self, other)\nend"}},{"id":"abs-instance-method","html_id":"abs-instance-method","name":"abs","doc":"Returns the absolute value of this number.\n\n```\n123.abs  # => 123\n-123.abs # => 123\n```","summary":"<p>Returns the absolute value of this number.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_rational.cr","line_number":202,"url":null},"def":{"name":"abs","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigRational.new do |mpq|\n  LibGMP.mpq_abs(mpq, self)\nend"}},{"id":"ceil-instance-method","html_id":"ceil-instance-method","name":"ceil","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_rational.cr","line_number":138,"url":null},"def":{"name":"ceil","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"diff = (denominator - (numerator % denominator)) % denominator\nBigRational.new(numerator + diff, denominator)\n"}},{"id":"clone-instance-method","html_id":"clone-instance-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_rational.cr","line_number":273,"url":null},"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"denominator-instance-method","html_id":"denominator-instance-method","name":"denominator","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_rational.cr","line_number":87,"url":null},"def":{"name":"denominator","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.mpq_get_den(mpz, self)\nend"}},{"id":"floor-instance-method","html_id":"floor-instance-method","name":"floor","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_rational.cr","line_number":143,"url":null},"def":{"name":"floor","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigRational.new(numerator - (numerator % denominator), denominator)"}},{"id":"hash(hasher)-instance-method","html_id":"hash(hasher)-instance-method","name":"hash","doc":"TODO: improve this","summary":"<p><span class=\"flag orange\">TODO</span>  improve this</p>","abstract":false,"args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"args_string":"(hasher)","args_html":"(hasher)","location":{"filename":"src/big/big_rational.cr","line_number":207,"url":null},"def":{"name":"hash","args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"hasher = to_f64.hash(hasher)\nhasher\n"}},{"id":"inspect:String-instance-method","html_id":"inspect:String-instance-method","name":"inspect","doc":"Returns a `String` representation of this object suitable\nto be embedded inside other expressions, sometimes providing\nmore information about this object.\n\n`#inspect` (and `#inspect(io)`) are the methods used when\nyou invoke `#to_s` or `#inspect` on an object that holds\nother objects and wants to show them. For example when you\ninvoke `Array#to_s`, `#inspect` will be invoked on each element:\n\n```\nary = [\"one\", \"two\", \"three, etc.\"]\nary.inspect # => [\"one\", \"two\", \"three, etc.\"]\n```\n\nNote that if Array invoked `#to_s` on each of the elements\nabove, the output would have been this:\n\n```\nary = [\"one\", \"two\", \"three, etc.\"]\n# If inspect invoked to_s on each element...\nary.inspect # => [one, two, three, etc.]\n```\n\nNote that it's not clear how many elements the array has,\nor which are they, because `#to_s` doesn't guarantee that\nthe string representation is clearly delimited (in the case\nof `String` the quotes are not shown).\n\nAlso note that sometimes the output of `#inspect` will look\nlike a Crystal expression that will compile, but this isn't\nalways the case, nor is it necessary. Notably, `Reference#inspect`\nand `Struct#inspect` return values that don't compile.\n\nClasses must usually **not** override this method. Instead,\nthey must override `inspect(io)`, which must append to the\ngiven `IO` object.","summary":"<p>Returns a <code><a href=\"String.html\">String</a></code> representation of this object suitable to be embedded inside other expressions, sometimes providing more information about this object.</p>","abstract":false,"args":[],"args_string":" : String","args_html":" : <a href=\"String.html\">String</a>","location":{"filename":"src/big/big_rational.cr","line_number":265,"url":null},"def":{"name":"inspect","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"to_s"}},{"id":"inspect(io:IO):Nil-instance-method","html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Appends a string representation of this object\nto the given `IO` object.\n\nSimilar to `to_s(io)`, but usually appends more information\nabout this object.\nSee `#inspect`.","summary":"<p>Appends a string representation of this object to the given <code><a href=\"IO.html\">IO</a></code> object.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/big_rational.cr","line_number":269,"url":null},"def":{"name":"inspect","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"to_s(io)"}},{"id":"inv-instance-method","html_id":"inv-instance-method","name":"inv","doc":"Returns a new `BigRational` as 1/r.\n\nThis will raise an exception if rational is 0.","summary":"<p>Returns a new <code><a href=\"BigRational.html\">BigRational</a></code> as 1/r.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_rational.cr","line_number":197,"url":null},"def":{"name":"inv","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"check_division_by_zero(self)\nBigRational.new do |mpq|\n  LibGMP.mpq_inv(mpq, self)\nend\n"}},{"id":"numerator-instance-method","html_id":"numerator-instance-method","name":"numerator","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_rational.cr","line_number":83,"url":null},"def":{"name":"numerator","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.mpq_get_num(mpz, self)\nend"}},{"id":"to_big_d-instance-method","html_id":"to_big_d-instance-method","name":"to_big_d","doc":"Converts `self` to `BigDecimal`.","summary":"<p>Converts <code>self</code> to <code><a href=\"BigDecimal.html\">BigDecimal</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_decimal.cr","line_number":619,"url":null},"def":{"name":"to_big_d","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigDecimal.new(self)"}},{"id":"to_big_f-instance-method","html_id":"to_big_f-instance-method","name":"to_big_f","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_rational.cr","line_number":236,"url":null},"def":{"name":"to_big_f","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigFloat.new do |mpf|\n  LibGMP.mpf_set_q(mpf, mpq)\nend"}},{"id":"to_big_i-instance-method","html_id":"to_big_i-instance-method","name":"to_big_i","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_rational.cr","line_number":240,"url":null},"def":{"name":"to_big_i","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"BigInt.new do |mpz|\n  LibGMP.set_q(mpz, mpq)\nend"}},{"id":"to_f-instance-method","html_id":"to_f-instance-method","name":"to_f","doc":"Returns the `Float64` representing this rational.","summary":"<p>Returns the <code><a href=\"Float64.html\">Float64</a></code> representing this rational.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_rational.cr","line_number":210,"url":null},"def":{"name":"to_f","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64"}},{"id":"to_f!-instance-method","html_id":"to_f!-instance-method","name":"to_f!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_rational.cr","line_number":230,"url":null},"def":{"name":"to_f!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64!"}},{"id":"to_f32-instance-method","html_id":"to_f32-instance-method","name":"to_f32","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_rational.cr","line_number":214,"url":null},"def":{"name":"to_f32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_f32"}},{"id":"to_f32!-instance-method","html_id":"to_f32!-instance-method","name":"to_f32!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_rational.cr","line_number":222,"url":null},"def":{"name":"to_f32!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_f32!"}},{"id":"to_f64-instance-method","html_id":"to_f64-instance-method","name":"to_f64","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_rational.cr","line_number":218,"url":null},"def":{"name":"to_f64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"LibGMP.mpq_get_d(mpq)"}},{"id":"to_f64!-instance-method","html_id":"to_f64!-instance-method","name":"to_f64!","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_rational.cr","line_number":226,"url":null},"def":{"name":"to_f64!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64"}},{"id":"to_i16(*args,**options)-instance-method","html_id":"to_i16(*args,**options)-instance-method","name":"to_i16","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/big/big_rational.cr","line_number":234,"url":null},"def":{"name":"to_i16","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_i16(*args, **options)"}},{"id":"to_i16(*args,**options,&)-instance-method","html_id":"to_i16(*args,**options,&)-instance-method","name":"to_i16","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/big/big_rational.cr","line_number":234,"url":null},"def":{"name":"to_i16","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_i16(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_i32(*args,**options)-instance-method","html_id":"to_i32(*args,**options)-instance-method","name":"to_i32","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/big/big_rational.cr","line_number":234,"url":null},"def":{"name":"to_i32","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_i32(*args, **options)"}},{"id":"to_i32(*args,**options,&)-instance-method","html_id":"to_i32(*args,**options,&)-instance-method","name":"to_i32","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/big/big_rational.cr","line_number":234,"url":null},"def":{"name":"to_i32","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_i32(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_i64(*args,**options)-instance-method","html_id":"to_i64(*args,**options)-instance-method","name":"to_i64","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/big/big_rational.cr","line_number":234,"url":null},"def":{"name":"to_i64","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_i64(*args, **options)"}},{"id":"to_i64(*args,**options,&)-instance-method","html_id":"to_i64(*args,**options,&)-instance-method","name":"to_i64","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/big/big_rational.cr","line_number":234,"url":null},"def":{"name":"to_i64","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_i64(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_i8(*args,**options,&)-instance-method","html_id":"to_i8(*args,**options,&)-instance-method","name":"to_i8","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/big/big_rational.cr","line_number":234,"url":null},"def":{"name":"to_i8","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_i8(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_i8(*args,**options)-instance-method","html_id":"to_i8(*args,**options)-instance-method","name":"to_i8","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/big/big_rational.cr","line_number":234,"url":null},"def":{"name":"to_i8","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_i8(*args, **options)"}},{"id":"to_s(io:IO,base:Int=10):Nil-instance-method","html_id":"to_s(io:IO,base:Int=10):Nil-instance-method","name":"to_s","doc":"Appends a `String` representation of this object\nto the given `IO` object.\n\nAn object must never append itself to the io argument,\nas this will in turn call `to_s(io)` on it.","summary":"<p>Appends a <code><a href=\"String.html\">String</a></code> representation of this object to the given <code><a href=\"IO.html\">IO</a></code> object.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(io : IO, base : Int = <span class=\"n\">10</span>) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>, base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/big/big_rational.cr","line_number":260,"url":null},"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"str = to_cstr(base)\nio.write_utf8(Slice.new(str, LibC.strlen(str)))\n"}},{"id":"to_s(base:Int=10):String-instance-method","html_id":"to_s(base:Int=10):String-instance-method","name":"to_s","doc":"Returns the string representing this rational.\n\nOptionally takes a radix base (2 through 36).\n\n```\nrequire \"big\"\n\nr = BigRational.new(8243243, 562828882)\nr.to_s     # => \"8243243/562828882\"\nr.to_s(16) # => \"7dc82b/218c1652\"\nr.to_s(36) # => \"4woiz/9b3djm\"\n```","summary":"<p>Returns the string representing this rational.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>) : String","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>) : <a href=\"String.html\">String</a>","location":{"filename":"src/big/big_rational.cr","line_number":256,"url":null},"def":{"name":"to_s","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"String.new(to_cstr(base))"}},{"id":"to_u16(*args,**options)-instance-method","html_id":"to_u16(*args,**options)-instance-method","name":"to_u16","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/big/big_rational.cr","line_number":234,"url":null},"def":{"name":"to_u16","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_u16(*args, **options)"}},{"id":"to_u16(*args,**options,&)-instance-method","html_id":"to_u16(*args,**options,&)-instance-method","name":"to_u16","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/big/big_rational.cr","line_number":234,"url":null},"def":{"name":"to_u16","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_u16(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_u32(*args,**options)-instance-method","html_id":"to_u32(*args,**options)-instance-method","name":"to_u32","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/big/big_rational.cr","line_number":234,"url":null},"def":{"name":"to_u32","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_u32(*args, **options)"}},{"id":"to_u32(*args,**options,&)-instance-method","html_id":"to_u32(*args,**options,&)-instance-method","name":"to_u32","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/big/big_rational.cr","line_number":234,"url":null},"def":{"name":"to_u32","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_u32(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_u64(*args,**options,&)-instance-method","html_id":"to_u64(*args,**options,&)-instance-method","name":"to_u64","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/big/big_rational.cr","line_number":234,"url":null},"def":{"name":"to_u64","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_u64(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_u64(*args,**options)-instance-method","html_id":"to_u64(*args,**options)-instance-method","name":"to_u64","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/big/big_rational.cr","line_number":234,"url":null},"def":{"name":"to_u64","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_u64(*args, **options)"}},{"id":"to_u8(*args,**options,&)-instance-method","html_id":"to_u8(*args,**options,&)-instance-method","name":"to_u8","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/big/big_rational.cr","line_number":234,"url":null},"def":{"name":"to_u8","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_u8(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_u8(*args,**options)-instance-method","html_id":"to_u8(*args,**options)-instance-method","name":"to_u8","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/big/big_rational.cr","line_number":234,"url":null},"def":{"name":"to_u8","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_u8(*args, **options)"}},{"id":"to_unsafe-instance-method","html_id":"to_unsafe-instance-method","name":"to_unsafe","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_rational.cr","line_number":281,"url":null},"def":{"name":"to_unsafe","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"mpq"}},{"id":"trunc-instance-method","html_id":"trunc-instance-method","name":"trunc","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/big/big_rational.cr","line_number":147,"url":null},"def":{"name":"trunc","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self < 0 ? ceil : floor"}}],"macros":[],"types":[]},{"html_id":"Crystal/BitArray","path":"BitArray.html","kind":"struct","full_name":"BitArray","name":"BitArray","abstract":false,"superclass":{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"Crystal/Indexable","kind":"module","full_name":"Indexable","name":"Indexable"},{"html_id":"Crystal/Enumerable","kind":"module","full_name":"Enumerable","name":"Enumerable"},{"html_id":"Crystal/Iterable","kind":"module","full_name":"Iterable","name":"Iterable"},{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[{"html_id":"Crystal/Indexable","kind":"module","full_name":"Indexable","name":"Indexable"}],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"`BitArray` is an array data structure that compactly stores bits.\n\nBits externally represented as `Bool`s are stored internally as\n`UInt32`s. The total number of bits stored is set at creation and is\nimmutable.\n\n### Example\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(12) # => \"BitArray[000000000000]\"\nba[2]                 # => false\n0.upto(5) { |i| ba[i * 2] = true }\nba    # => \"BitArray[101010101010]\"\nba[2] # => true\n```","summary":"<p><code><a href=\"BitArray.html\">BitArray</a></code> is an array data structure that compactly stores bits.</p>","class_methods":[],"constructors":[{"id":"new(size,initial:Bool=false)-class-method","html_id":"new(size,initial:Bool=false)-class-method","name":"new","doc":"Creates a new `BitArray` of *size* bits.\n\n*initial* optionally sets the starting value, `true` or `false`, for all bits\nin the array.","summary":"<p>Creates a new <code><a href=\"BitArray.html\">BitArray</a></code> of <em>size</em> bits.</p>","abstract":false,"args":[{"name":"size","doc":null,"default_value":"","external_name":"size","restriction":""},{"name":"initial","doc":null,"default_value":"false","external_name":"initial","restriction":"Bool"}],"args_string":"(size, initial : Bool = <span class=\"n\">false</span>)","args_html":"(size, initial : <a href=\"Bool.html\">Bool</a> = <span class=\"n\">false</span>)","location":{"filename":"src/bit_array.cr","line_number":28,"url":null},"def":{"name":"new","args":[{"name":"size","doc":null,"default_value":"","external_name":"size","restriction":""},{"name":"initial","doc":null,"default_value":"false","external_name":"initial","restriction":"Bool"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(size, initial)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"==(other:BitArray)-instance-method","html_id":"==(other:BitArray)-instance-method","name":"==","doc":null,"summary":null,"abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BitArray"}],"args_string":"(other : BitArray)","args_html":"(other : <a href=\"BitArray.html\">BitArray</a>)","location":{"filename":"src/bit_array.cr","line_number":34,"url":null},"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"BitArray"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if size != other.size\n  return false\nend\nreturn (LibC.memcmp(@bits, other.@bits, bytesize)) == 0\n"}},{"id":"[](start:Int,count:Int)-instance-method","html_id":"[](start:Int,count:Int)-instance-method","name":"[]","doc":"Returns count or less (if there aren't enough) elements starting at the\ngiven start index.\n\nNegative indices count backward from the end of the array (-1 is the last\nelement). Additionally, an empty array is returned when the starting index\nfor an element range is at the end of the array.\n\nRaises `IndexError` if the starting index is out of range.\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(5)\nba[0] = true; ba[2] = true; ba[4] = true\nba # => BitArray[10101]\n\nba[-3, 3] # => BitArray[101]\nba[6, 1]  # raise indexError\nba[1, 2]  # => BitArray[01]\nba[5, 1]  # => BitArray[]\n```","summary":"<p>Returns count or less (if there aren't enough) elements starting at the given start index.</p>","abstract":false,"args":[{"name":"start","doc":null,"default_value":"","external_name":"start","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"args_string":"(start : Int, count : Int)","args_html":"(start : <a href=\"Int.html\">Int</a>, count : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/bit_array.cr","line_number":112,"url":null},"def":{"name":"[]","args":[{"name":"start","doc":null,"default_value":"","external_name":"start","restriction":"Int"},{"name":"count","doc":null,"default_value":"","external_name":"count","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if count < 0\n  raise(ArgumentError.new(\"Negative count: #{count}\"))\nend\nif start == size\n  return BitArray.new(0)\nend\nif start < 0\n  start = start + size\nend\nif 0 <= start && start <= size\nelse\n  raise(IndexError.new)\nend\nif count == 0\n  return BitArray.new(0)\nend\ncount = Math.min(count, size - start)\nif size <= 32\n  bits = @bits[0]\n  bits = bits >> start\n  bits = bits & ((1 << count) - 1)\n  (BitArray.new(count)).tap do |ba|\n    (ba.@bits)[0] = bits\n  end\nelse\n  if size <= 64\n    bits = (@bits.as(::Pointer(UInt64)))[0]\n    bits = bits >> start\n    bits = bits & ((1 << count) - 1)\n    if count <= 32\n      (BitArray.new(count)).tap do |ba|\n        (ba.@bits)[0] = bits.to_u32\n      end\n    else\n      (BitArray.new(count)).tap do |ba|\n        ((ba.@bits).as(::Pointer(UInt64)))[0] = bits\n      end\n    end\n  else\n    ba = BitArray.new(count)\n    start_bit_index, start_sub_index = start.divmod(32)\n    end_bit_index = (start + count) // 32\n    i = 0\n    bits = @bits[start_bit_index]\n    while (start_bit_index + i) <= end_bit_index\n      low_bits = bits\n      low_bits = low_bits >> start_sub_index\n      bits = @bits[(start_bit_index + i) + 1]\n      high_bits = bits\n      high_bits = high_bits & ((1 << start_sub_index) - 1)\n      high_bits = high_bits << (32 - start_sub_index)\n      (ba.@bits)[i] = low_bits | high_bits\n      i = i + 1\n    end\n    ba.clear_unused_bits\n    ba\n  end\nend\n"}},{"id":"[](range:Range)-instance-method","html_id":"[](range:Range)-instance-method","name":"[]","doc":"Returns all elements that are within the given range.\n\nNegative indices count backward from the end of the array (-1 is the last\nelement). Additionally, an empty array is returned when the starting index\nfor an element range is at the end of the array.\n\nRaises `IndexError` if the starting index is out of range.\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(5)\nba[0] = true; ba[2] = true; ba[4] = true\nba # => BitArray[10101]\n\nba[1..3]    # => BitArray[010]\nba[4..7]    # => BitArray[1]\nba[6..10]   # raise IndexError\nba[5..10]   # => BitArray[]\nba[-2...-1] # => BitArray[0]\n```","summary":"<p>Returns all elements that are within the given range.</p>","abstract":false,"args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"args_string":"(range : Range)","args_html":"(range : <a href=\"Range.html\">Range</a>)","location":{"filename":"src/bit_array.cr","line_number":87,"url":null},"def":{"name":"[]","args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self[*(Indexable.range_to_index_and_count(range, size)) || (raise(IndexError.new))]"}},{"id":"[]=(index,value:Bool)-instance-method","html_id":"[]=(index,value:Bool)-instance-method","name":"[]=","doc":"Sets the bit at the given *index*.\nNegative indices can be used to start counting from the end of the array.\nRaises `IndexError` if trying to access a bit outside the array's range.\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(5)\nba[3] = true\n```","summary":"<p>Sets the bit at the given <em>index</em>.</p>","abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":""},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"Bool"}],"args_string":"(index, value : Bool)","args_html":"(index, value : <a href=\"Bool.html\">Bool</a>)","location":{"filename":"src/bit_array.cr","line_number":57,"url":null},"def":{"name":"[]=","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":""},{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"Bool"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"bit_index, sub_index = bit_index_and_sub_index(index)\nif value\n  __temp_62 = bit_index\n  @bits[__temp_62] = @bits[__temp_62] | (1 << sub_index)\nelse\n  __temp_64 = bit_index\n  @bits[__temp_64] = @bits[__temp_64] & (~(1 << sub_index))\nend\n"}},{"id":"dup-instance-method","html_id":"dup-instance-method","name":"dup","doc":"Returns a new `BitArray` with all of the same elements.","summary":"<p>Returns a new <code><a href=\"BitArray.html\">BitArray</a></code> with all of the same elements.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/bit_array.cr","line_number":251,"url":null},"def":{"name":"dup","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"bit_array = BitArray.new(@size)\n@bits.copy_to(bit_array.@bits, malloc_size)\nbit_array\n"}},{"id":"hash(hasher)-instance-method","html_id":"hash(hasher)-instance-method","name":"hash","doc":"See `Object#hash(hasher)`","summary":"<p>See <code><a href=\"Object.html#hash(hasher)-instance-method\">Object#hash(hasher)</a></code></p>","abstract":false,"args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"args_string":"(hasher)","args_html":"(hasher)","location":{"filename":"src/bit_array.cr","line_number":244,"url":null},"def":{"name":"hash","args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"hasher = size.hash(hasher)\nhasher = to_slice.hash(hasher)\nhasher\n"}},{"id":"inspect(io:IO):Nil-instance-method","html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Creates a string representation of self.\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(5)\nba.to_s # => \"BitArray[00000]\"\n```","summary":"<p>Creates a string representation of self.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/bit_array.cr","line_number":229,"url":null},"def":{"name":"inspect","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"to_s(io)"}},{"id":"invert-instance-method","html_id":"invert-instance-method","name":"invert","doc":"Inverts all bits in the array. Falses become `true` and vice versa.\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(5)\nba[2] = true; ba[3] = true\nba # => BitArray[00110]\nba.invert\nba # => BitArray[11001]\n```","summary":"<p>Inverts all bits in the array.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/bit_array.cr","line_number":205,"url":null},"def":{"name":"invert","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"malloc_size.times do |i|\n  @bits[i] = ~@bits[i]\nend\nclear_unused_bits\n"}},{"id":"size:Int32-instance-method","html_id":"size:Int32-instance-method","name":"size","doc":"The number of bits the BitArray stores","summary":"<p>The number of bits the BitArray stores</p>","abstract":false,"args":[],"args_string":" : Int32","args_html":" : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/bit_array.cr","line_number":22,"url":null},"def":{"name":"size","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":"@size"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Creates a string representation of self.\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(5)\nba.to_s # => \"BitArray[00000]\"\n```","summary":"<p>Creates a string representation of self.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/bit_array.cr","line_number":220,"url":null},"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << \"BitArray[\"\neach do |value|\n  io << (value ? '1' : '0')\nend\nio << ']'\n"}},{"id":"to_slice:Bytes-instance-method","html_id":"to_slice:Bytes-instance-method","name":"to_slice","doc":"Returns a `Bytes` able to read and write bytes from a buffer.\nThe slice will be long enough to hold all the bits groups in bytes despite the `UInt32` internal representation.\nIt's useful for reading and writing a bit array from a byte buffer directly.\n\nWARNING: It is undefined behaviour to set any of the unused bits of a bit array to\n`true` via a slice.","summary":"<p>Returns a <code><a href=\"Bytes.html\">Bytes</a></code> able to read and write bytes from a buffer.</p>","abstract":false,"args":[],"args_string":" : Bytes","args_html":" : <a href=\"Bytes.html\">Bytes</a>","location":{"filename":"src/bit_array.cr","line_number":239,"url":null},"def":{"name":"to_slice","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bytes","visibility":"Public","body":"Slice.new(@bits.as(Pointer(UInt8)), bytesize)"}},{"id":"toggle(index)-instance-method","html_id":"toggle(index)-instance-method","name":"toggle","doc":"Toggles the bit at the given *index*. A false bit becomes a `true` bit, and\nvice versa.\nNegative indices can be used to start counting from the end of the array.\nRaises `IndexError` if trying to access a bit outside the array's range.\n\n```\nrequire \"bit_array\"\n\nba = BitArray.new(5)\nba[3] # => false\nba.toggle(3)\nba[3] # => true\n```","summary":"<p>Toggles the bit at the given <em>index</em>.</p>","abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":""}],"args_string":"(index)","args_html":"(index)","location":{"filename":"src/bit_array.cr","line_number":189,"url":null},"def":{"name":"toggle","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"bit_index, sub_index = bit_index_and_sub_index(index)\n__temp_66 = bit_index\n@bits[__temp_66] = @bits[__temp_66] ^ (1 << sub_index)\n"}},{"id":"unsafe_fetch(index:Int)-instance-method","html_id":"unsafe_fetch(index:Int)-instance-method","name":"unsafe_fetch","doc":"Returns the element at the given *index*, without doing any bounds check.\n\n`Indexable` makes sure to invoke this method with *index* in `0...size`,\nso converting negative indices to positive ones is not needed here.\n\nClients never invoke this method directly. Instead, they access\nelements with `#[](index)` and `#[]?(index)`.\n\nThis method should only be directly invoked if you are absolutely\nsure the index is in bounds, to avoid a bounds check for a small boost\nof performance.","summary":"<p>Returns the element at the given <em>index</em>, without doing any bounds check.</p>","abstract":false,"args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"}],"args_string":"(index : Int)","args_html":"(index : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/bit_array.cr","line_number":42,"url":null},"def":{"name":"unsafe_fetch","args":[{"name":"index","doc":null,"default_value":"","external_name":"index","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"bit_index, sub_index = index.divmod(32)\n(@bits[bit_index] & (1 << sub_index)) > 0\n"}}],"macros":[],"types":[]},{"html_id":"Crystal/Bool","path":"Bool.html","kind":"struct","full_name":"Bool","name":"Bool","abstract":false,"superclass":{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},"ancestors":[{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"Bool has only two possible values: `true` and `false`. They are constructed using these literals:\n\n```\ntrue  # A Bool that is true\nfalse # A Bool that is false\n```","summary":"<p>Bool has only two possible values: <code>true</code> and <code>false</code>.</p>","class_methods":[],"constructors":[{"id":"new(ctx:YAML::ParseContext,node:YAML::Nodes::Node)-class-method","html_id":"new(ctx:YAML::ParseContext,node:YAML::Nodes::Node)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"ctx","doc":null,"default_value":"","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","doc":null,"default_value":"","external_name":"node","restriction":"YAML::Nodes::Node"}],"args_string":"(ctx : YAML::ParseContext, node : YAML::Nodes::Node)","args_html":"(ctx : <a href=\"YAML/ParseContext.html\">YAML::ParseContext</a>, node : <a href=\"YAML/Nodes/Node.html\">YAML::Nodes::Node</a>)","location":{"filename":"src/yaml/from_yaml.cr","line_number":55,"url":null},"def":{"name":"new","args":[{"name":"ctx","doc":null,"default_value":"","external_name":"ctx","restriction":"YAML::ParseContext"},{"name":"node","doc":null,"default_value":"","external_name":"node","restriction":"YAML::Nodes::Node"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"parse_scalar(ctx, node, self)"}},{"id":"new(pull:JSON::PullParser)-class-method","html_id":"new(pull:JSON::PullParser)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"pull","doc":null,"default_value":"","external_name":"pull","restriction":"JSON::PullParser"}],"args_string":"(pull : JSON::PullParser)","args_html":"(pull : <a href=\"JSON/PullParser.html\">JSON::PullParser</a>)","location":{"filename":"src/json/from_json.cr","line_number":72,"url":null},"def":{"name":"new","args":[{"name":"pull","doc":null,"default_value":"","external_name":"pull","restriction":"JSON::PullParser"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"pull.read_bool"}}],"instance_methods":[{"id":"!=(other:Bool):Bool-instance-method","html_id":"!=(other:Bool):Bool-instance-method","name":"!=","doc":"Returns `true` if `self` is not equal to *other*.","summary":"<p>Returns <code>true</code> if <code>self</code> is not equal to <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Bool"}],"args_string":"(other : Bool) : Bool","args_html":"(other : <a href=\"Bool.html\">Bool</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/primitives.cr","line_number":69,"url":null},"def":{"name":"!=","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Bool"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"# primitive: binary"}},{"id":"&(other:Bool):Bool-instance-method","html_id":"&(other:Bool):Bool-instance-method","name":"&","doc":"Bitwise AND. Returns `true` if this bool and *other* are `true`, otherwise returns `false`.\n\n```\nfalse & false # => false\nfalse & true  # => false\ntrue & false  # => false\ntrue & true   # => true\n```","summary":"<p>Bitwise AND.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Bool"}],"args_string":"(other : Bool) : Bool","args_html":"(other : <a href=\"Bool.html\">Bool</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/bool.cr","line_number":28,"url":null},"def":{"name":"&","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Bool"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"self ? other : false"}},{"id":"==(other:Bool):Bool-instance-method","html_id":"==(other:Bool):Bool-instance-method","name":"==","doc":"Returns `true` if `self` is equal to *other*.","summary":"<p>Returns <code>true</code> if <code>self</code> is equal to <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Bool"}],"args_string":"(other : Bool) : Bool","args_html":"(other : <a href=\"Bool.html\">Bool</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/primitives.cr","line_number":64,"url":null},"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Bool"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"# primitive: binary"}},{"id":"^(other:Bool):Bool-instance-method","html_id":"^(other:Bool):Bool-instance-method","name":"^","doc":"Exclusive OR. Returns `true` if this bool is different from *other*, otherwise returns `false`.\n\n```\nfalse ^ false # => false\nfalse ^ true  # => true\ntrue ^ false  # => true\ntrue ^ true   # => false\n```","summary":"<p>Exclusive OR.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Bool"}],"args_string":"(other : Bool) : Bool","args_html":"(other : <a href=\"Bool.html\">Bool</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/bool.cr","line_number":40,"url":null},"def":{"name":"^","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Bool"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"self != other"}},{"id":"clone:Bool-instance-method","html_id":"clone:Bool-instance-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Bool","args_html":" : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/bool.cr","line_number":66,"url":null},"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"self"}},{"id":"hash(hasher)-instance-method","html_id":"hash(hasher)-instance-method","name":"hash","doc":"See `Object#hash(hasher)`","summary":"<p>See <code><a href=\"Object.html#hash(hasher)-instance-method\">Object#hash(hasher)</a></code></p>","abstract":false,"args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"args_string":"(hasher)","args_html":"(hasher)","location":{"filename":"src/bool.cr","line_number":45,"url":null},"def":{"name":"hash","args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"hasher.bool(self)"}},{"id":"to_json(json:JSON::Builder)-instance-method","html_id":"to_json(json:JSON::Builder)-instance-method","name":"to_json","doc":null,"summary":null,"abstract":false,"args":[{"name":"json","doc":null,"default_value":"","external_name":"json","restriction":"JSON::Builder"}],"args_string":"(json : JSON::Builder)","args_html":"(json : <a href=\"JSON/Builder.html\">JSON::Builder</a>)","location":{"filename":"src/json/to_json.cr","line_number":38,"url":null},"def":{"name":"to_json","args":[{"name":"json","doc":null,"default_value":"","external_name":"json","restriction":"JSON::Builder"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"json.bool(self)"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Appends `\"true\"` for `true` and `\"false\"` for `false` to the given IO.","summary":"<p>Appends <code>\"true\"</code> for <code>true</code> and <code>\"false\"</code> for <code>false</code> to the given IO.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/bool.cr","line_number":62,"url":null},"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << to_s"}},{"id":"to_s:String-instance-method","html_id":"to_s:String-instance-method","name":"to_s","doc":"Returns `\"true\"` for `true` and `\"false\"` for `false`.","summary":"<p>Returns <code>\"true\"</code> for <code>true</code> and <code>\"false\"</code> for <code>false</code>.</p>","abstract":false,"args":[],"args_string":" : String","args_html":" : <a href=\"String.html\">String</a>","location":{"filename":"src/bool.cr","line_number":57,"url":null},"def":{"name":"to_s","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"self ? \"true\" : \"false\""}},{"id":"to_unsafe:LibC::Int-instance-method","html_id":"to_unsafe:LibC::Int-instance-method","name":"to_unsafe","doc":"Returns an integer derived from the boolean value, for interoperability with C-style booleans.\n\nThe value is `1` for `true` and `0` for `false`.","summary":"<p>Returns an integer derived from the boolean value, for interoperability with C-style booleans.</p>","abstract":false,"args":[],"args_string":" : LibC::Int","args_html":" : LibC::Int","location":{"filename":"src/bool.cr","line_number":52,"url":null},"def":{"name":"to_unsafe","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"LibC::Int","visibility":"Public","body":"LibC::Int.new(self ? 1 : 0)"}},{"id":"to_yaml(yaml:YAML::Nodes::Builder)-instance-method","html_id":"to_yaml(yaml:YAML::Nodes::Builder)-instance-method","name":"to_yaml","doc":null,"summary":null,"abstract":false,"args":[{"name":"yaml","doc":null,"default_value":"","external_name":"yaml","restriction":"YAML::Nodes::Builder"}],"args_string":"(yaml : YAML::Nodes::Builder)","args_html":"(yaml : <a href=\"YAML/Nodes/Builder.html\">YAML::Nodes::Builder</a>)","location":{"filename":"src/yaml/to_yaml.cr","line_number":105,"url":null},"def":{"name":"to_yaml","args":[{"name":"yaml","doc":null,"default_value":"","external_name":"yaml","restriction":"YAML::Nodes::Builder"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"yaml.scalar(self)"}},{"id":"|(other:Bool):Bool-instance-method","html_id":"|(other:Bool):Bool-instance-method","name":"|","doc":"Bitwise OR. Returns `true` if this bool or *other* is `true`, otherwise returns `false`.\n\n```\nfalse | false # => false\nfalse | true  # => true\ntrue | false  # => true\ntrue | true   # => true\n```","summary":"<p>Bitwise OR.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Bool"}],"args_string":"(other : Bool) : Bool","args_html":"(other : <a href=\"Bool.html\">Bool</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/bool.cr","line_number":16,"url":null},"def":{"name":"|","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Bool"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"self ? true : other"}}],"macros":[],"types":[]},{"html_id":"Crystal/Box","path":"Box.html","kind":"class","full_name":"Box(T)","name":"Box","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"A Box allows turning any object to a `Void*` and back.\n\nA Box's purpose is passing data to C as a `Void*` and then converting that\nback to the original data type.\n\nFor an example usage, see `Proc`'s explanation about sending Procs to C.","summary":"<p>A Box allows turning any object to a <code>Void*</code> and back.</p>","class_methods":[{"id":"box(r:Reference?):Pointer(Void)-class-method","html_id":"box(r:Reference?):Pointer(Void)-class-method","name":"box","doc":"Creates a Box for a reference type (or `nil`) and returns the same pointer (or `NULL`)","summary":"<p>Creates a Box for a reference type (or <code>nil</code>) and returns the same pointer (or <code>NULL</code>)</p>","abstract":false,"args":[{"name":"r","doc":null,"default_value":"","external_name":"r","restriction":"Reference | ::Nil"}],"args_string":"(r : Reference?) : Pointer(Void)","args_html":"(r : <a href=\"Reference.html\">Reference</a>?) : <a href=\"Pointer.html\">Pointer</a>(Void)","location":{"filename":"src/box.cr","line_number":18,"url":null},"def":{"name":"box","args":[{"name":"r","doc":null,"default_value":"","external_name":"r","restriction":"Reference | ::Nil"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"::Pointer(Void)","visibility":"Public","body":"r.as(::Pointer(Void))"}},{"id":"box(object):Pointer(Void)-class-method","html_id":"box(object):Pointer(Void)-class-method","name":"box","doc":"Creates a Box for an object and returns it as a `Void*`.","summary":"<p>Creates a Box for an object and returns it as a <code>Void*</code>.</p>","abstract":false,"args":[{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":""}],"args_string":"(object) : Pointer(Void)","args_html":"(object) : <a href=\"Pointer.html\">Pointer</a>(Void)","location":{"filename":"src/box.cr","line_number":23,"url":null},"def":{"name":"box","args":[{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"::Pointer(Void)","visibility":"Public","body":"(new(object)).as(::Pointer(Void))"}},{"id":"unbox(pointer:Pointer(Void)):T-class-method","html_id":"unbox(pointer:Pointer(Void)):T-class-method","name":"unbox","doc":"Unboxes a `Void*` into an object of type `T`. Note that for this you must\nspecify T: `Box(T).unbox(data)`.","summary":"<p>Unboxes a <code>Void*</code> into an object of type <code>T</code>.</p>","abstract":false,"args":[{"name":"pointer","doc":null,"default_value":"","external_name":"pointer","restriction":"::Pointer(Void)"}],"args_string":"(pointer : Pointer(Void)) : T","args_html":"(pointer : <a href=\"Pointer.html\">Pointer</a>(Void)) : T","location":{"filename":"src/box.cr","line_number":29,"url":null},"def":{"name":"unbox","args":[{"name":"pointer","doc":null,"default_value":"","external_name":"pointer","restriction":"::Pointer(Void)"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"T","visibility":"Public","body":"{% if T <= Reference || (T == Nil) %}\n      pointer.as(T)\n    {% else %}\n      pointer.as(self).object\n    {% end %}"}}],"constructors":[{"id":"new(object:T)-class-method","html_id":"new(object:T)-class-method","name":"new","doc":"Creates a `Box` with the given object.\n\nThis method isn't usually used directly. Instead, `Box.box` is used.","summary":"<p>Creates a <code><a href=\"Box.html\">Box</a></code> with the given object.</p>","abstract":false,"args":[{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":"T"}],"args_string":"(object : T)","args_html":"(object : T)","location":{"filename":"src/box.cr","line_number":14,"url":null},"def":{"name":"new","args":[{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = Box(T).allocate\n_.initialize(object)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"object:T-instance-method","html_id":"object:T-instance-method","name":"object","doc":"Returns the original object","summary":"<p>Returns the original object</p>","abstract":false,"args":[],"args_string":" : T","args_html":" : T","location":{"filename":"src/box.cr","line_number":9,"url":null},"def":{"name":"object","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"T","visibility":"Public","body":"@object"}}],"macros":[],"types":[]},{"html_id":"Crystal/Bytes","path":"Bytes.html","kind":"alias","full_name":"Bytes","name":"Bytes","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":true,"aliased":"Slice(UInt8)","aliased_html":"<a href=\"Slice.html\">Slice</a>(<a href=\"UInt8.html\">UInt8</a>)","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"A convenient alias for the most common slice type,\na slice of bytes, used for example in `IO#read` and `IO#write`.","summary":"<p>A convenient alias for the most common slice type, a slice of bytes, used for example in <code><a href=\"IO.html#read(slice:Bytes)-instance-method\">IO#read</a></code> and <code><a href=\"IO.html#write(slice:Bytes):Nil-instance-method\">IO#write</a></code>.</p>","class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"Crystal/Channel","path":"Channel.html","kind":"class","full_name":"Channel(T)","name":"Channel","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"A `Channel` enables concurrent communication between fibers.\n\nThey allow communicating data between fibers without sharing memory and without having to worry about locks, semaphores or other special structures.\n\n```\nchannel = Channel(Int32).new\n\nspawn do\n  channel.send(0)\n  channel.send(1)\nend\n\nchannel.receive # => 0\nchannel.receive # => 1\n```\n\nNOTE: Although a `Channel(Nil)` or any other nilable types like `Channel(Int32?)` are valid\nthey are discouraged since from certain methods or constructs it receiving a `nil` as data\nwill be indistinguishable from a closed channel.\n","summary":"<p>A <code><a href=\"Channel.html\">Channel</a></code> enables concurrent communication between fibers.</p>","class_methods":[{"id":"receive_first(channels:Tuple|Array)-class-method","html_id":"receive_first(channels:Tuple|Array)-class-method","name":"receive_first","doc":null,"summary":null,"abstract":false,"args":[{"name":"channels","doc":null,"default_value":"","external_name":"channels","restriction":"Tuple | Array"}],"args_string":"(channels : Tuple | Array)","args_html":"(channels : <a href=\"Tuple.html\">Tuple</a> | <a href=\"Array.html\">Array</a>)","location":{"filename":"src/channel.cr","line_number":387,"url":null},"def":{"name":"receive_first","args":[{"name":"channels","doc":null,"default_value":"","external_name":"channels","restriction":"Tuple | Array"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_, value = self.select(channels.map(&.receive_select_action))\nvalue\n"}},{"id":"receive_first(*channels)-class-method","html_id":"receive_first(*channels)-class-method","name":"receive_first","doc":null,"summary":null,"abstract":false,"args":[{"name":"channels","doc":null,"default_value":"","external_name":"channels","restriction":""}],"args_string":"(*channels)","args_html":"(*channels)","location":{"filename":"src/channel.cr","line_number":383,"url":null},"def":{"name":"receive_first","args":[{"name":"channels","doc":null,"default_value":"","external_name":"channels","restriction":""}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"receive_first(channels)"}},{"id":"send_first(value,channels:Tuple|Array)-class-method","html_id":"send_first(value,channels:Tuple|Array)-class-method","name":"send_first","doc":null,"summary":null,"abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":""},{"name":"channels","doc":null,"default_value":"","external_name":"channels","restriction":"Tuple | Array"}],"args_string":"(value, channels : Tuple | Array)","args_html":"(value, channels : <a href=\"Tuple.html\">Tuple</a> | <a href=\"Array.html\">Array</a>)","location":{"filename":"src/channel.cr","line_number":396,"url":null},"def":{"name":"send_first","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":""},{"name":"channels","doc":null,"default_value":"","external_name":"channels","restriction":"Tuple | Array"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self.select(channels.map(&.send_select_action(value)))\nnil\n"}},{"id":"send_first(value,*channels)-class-method","html_id":"send_first(value,*channels)-class-method","name":"send_first","doc":null,"summary":null,"abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":""},{"name":"channels","doc":null,"default_value":"","external_name":"channels","restriction":""}],"args_string":"(value, *channels)","args_html":"(value, *channels)","location":{"filename":"src/channel.cr","line_number":392,"url":null},"def":{"name":"send_first","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":""},{"name":"channels","doc":null,"default_value":"","external_name":"channels","restriction":""}],"double_splat":null,"splat_index":1,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"send_first(value, channels)"}}],"constructors":[{"id":"new(capacity=0)-class-method","html_id":"new(capacity=0)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"capacity","doc":null,"default_value":"0","external_name":"capacity","restriction":""}],"args_string":"(capacity = <span class=\"n\">0</span>)","args_html":"(capacity = <span class=\"n\">0</span>)","location":{"filename":"src/channel.cr","line_number":171,"url":null},"def":{"name":"new","args":[{"name":"capacity","doc":null,"default_value":"0","external_name":"capacity","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = Channel(T).allocate\n_.initialize(capacity)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"close:Bool-instance-method","html_id":"close:Bool-instance-method","name":"close","doc":"Closes the channel.\nThe method prevents any new value from being sent to / received from the channel.\nAll fibers blocked in `send` or `receive` will be awakened with `Channel::ClosedError`\n\nBoth awaiting and subsequent calls to `#send` will consider the channel closed.\nAll items successfully sent to the channel can be received, before `#receive` considers the channel closed.\nCalling `#close` on a closed channel does not have any effect.\n\nIt returns `true` when the channel was successfully closed, or `false` if it was already closed.","summary":"<p>Closes the channel.</p>","abstract":false,"args":[],"args_string":" : Bool","args_html":" : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/channel.cr","line_number":191,"url":null},"def":{"name":"close","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"sender_list = Crystal::PointerLinkedList(Sender(T)).new\nreceiver_list = Crystal::PointerLinkedList(Receiver(T)).new\n@lock.sync do\n  if @closed\n    return false\n  end\n  @closed = true\n  @senders, sender_list = sender_list, @senders\n  @receivers, receiver_list = receiver_list, @receivers\nend\nsender_list.each do |__arg0|\n  __arg0.value.close\nend\nreceiver_list.each do |__arg1|\n  __arg1.value.close\nend\ntrue\n"}},{"id":"closed?-instance-method","html_id":"closed?-instance-method","name":"closed?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/channel.cr","line_number":208,"url":null},"def":{"name":"closed?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@closed"}},{"id":"inspect(io:IO):Nil-instance-method","html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Appends a String representation of this object\nwhich includes its class name, its object address\nand the values of all instance variables.\n\n```\nclass Person\n  def initialize(@name : String, @age : Int32)\n  end\nend\n\nPerson.new(\"John\", 32).inspect # => #<Person:0x10fd31f20 @name=\"John\", @age=32>\n```","summary":"<p>Appends a String representation of this object which includes its class name, its object address and the values of all instance variables.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/channel.cr","line_number":375,"url":null},"def":{"name":"inspect","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"to_s(io)"}},{"id":"pretty_print(pp)-instance-method","html_id":"pretty_print(pp)-instance-method","name":"pretty_print","doc":null,"summary":null,"abstract":false,"args":[{"name":"pp","doc":null,"default_value":"","external_name":"pp","restriction":""}],"args_string":"(pp)","args_html":"(pp)","location":{"filename":"src/channel.cr","line_number":379,"url":null},"def":{"name":"pretty_print","args":[{"name":"pp","doc":null,"default_value":"","external_name":"pp","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"pp.text(inspect)"}},{"id":"receive:T-instance-method","html_id":"receive:T-instance-method","name":"receive","doc":"Receives a value from the channel.\nIf there is a value waiting, then it is returned immediately. Otherwise, this method blocks until a value is sent to the channel.\n\nRaises `ClosedError` if the channel is closed or closes while waiting for receive.\n\n```\nchannel = Channel(Int32).new\nspawn do\n  channel.send(1)\nend\nchannel.receive # => 1\n```","summary":"<p>Receives a value from the channel.</p>","abstract":false,"args":[],"args_string":" : T","args_html":" : T","location":{"filename":"src/channel.cr","line_number":279,"url":null},"def":{"name":"receive","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"T","visibility":"Public","body":"receive_impl do\n  raise(ClosedError.new)\nend"}},{"id":"receive?:T?-instance-method","html_id":"receive?:T?-instance-method","name":"receive?","doc":"Receives a value from the channel.\nIf there is a value waiting, it is returned immediately. Otherwise, this method blocks until a value is sent to the channel.\n\nReturns `nil` if the channel is closed or closes while waiting for receive.","summary":"<p>Receives a value from the channel.</p>","abstract":false,"args":[],"args_string":" : T?","args_html":" : T?","location":{"filename":"src/channel.cr","line_number":287,"url":null},"def":{"name":"receive?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"T | ::Nil","visibility":"Public","body":"receive_impl do\n  return nil\nend"}},{"id":"send(value:T)-instance-method","html_id":"send(value:T)-instance-method","name":"send","doc":"Sends a value to the channel.\nIf the channel has spare capacity, then the method returns immediately.\nOtherwise, this method blocks the calling fiber until another fiber calls `#receive` on the channel.\n\nRaises `ClosedError` if the channel is closed or closes while waiting on a full channel.","summary":"<p>Sends a value to the channel.</p>","abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"args_string":"(value : T)","args_html":"(value : T)","location":{"filename":"src/channel.cr","line_number":217,"url":null},"def":{"name":"send","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"sender = Sender(T).new\n@lock.lock\ncase send_internal(value)\nin .delivered?\n  @lock.unlock\nin .closed?\n  @lock.unlock\n  raise(ClosedError.new)\nin .none?\n  sender.fiber = Fiber.current\n  sender.data = value\n  @senders.push(pointerof(sender))\n  @lock.unlock\n  Crystal::Scheduler.reschedule\n  case sender.state\n  in .delivered?\n  in .closed?\n    raise(ClosedError.new)\n  in .none?\n    raise(\"BUG: Fiber was awaken without channel delivery state set\")\n  end\nend\nself\n"}}],"macros":[],"types":[{"html_id":"Crystal/Channel/ClosedError","path":"Channel/ClosedError.html","kind":"class","full_name":"Channel::ClosedError","name":"ClosedError","abstract":false,"superclass":{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},"ancestors":[{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Channel","kind":"class","full_name":"Channel(T)","name":"Channel"},"doc":null,"summary":null,"class_methods":[],"constructors":[{"id":"new(msg=&quot;Channelisclosed&quot;)-class-method","html_id":"new(msg=&quot;Channelisclosed&quot;)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"msg","doc":null,"default_value":"\"Channel is closed\"","external_name":"msg","restriction":""}],"args_string":"(msg = <span class=\"s\">&quot;Channel is closed&quot;</span>)","args_html":"(msg = <span class=\"s\">&quot;Channel is closed&quot;</span>)","location":{"filename":"src/channel.cr","line_number":118,"url":null},"def":{"name":"new","args":[{"name":"msg","doc":null,"default_value":"\"Channel is closed\"","external_name":"msg","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(msg)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[],"macros":[],"types":[]}]},{"html_id":"Crystal/Char","path":"Char.html","kind":"struct","full_name":"Char","name":"Char","abstract":false,"superclass":{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},"ancestors":[{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[{"id":"MAX","name":"MAX","value":"1114111.unsafe_chr","doc":"The maximum character.","summary":"<p>The maximum character.</p>"},{"id":"MAX_CODEPOINT","name":"MAX_CODEPOINT","value":"1114111","doc":"The maximum valid codepoint for a character.","summary":"<p>The maximum valid codepoint for a character.</p>"},{"id":"REPLACEMENT","name":"REPLACEMENT","value":"'�'","doc":"The replacement character, used on invalid UTF-8 byte sequences.","summary":"<p>The replacement character, used on invalid UTF-8 byte sequences.</p>"},{"id":"ZERO","name":"ZERO","value":"'\\u{0}'","doc":"The character representing the end of a C string.","summary":"<p>The character representing the end of a C string.</p>"}],"included_modules":[{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"}],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"A `Char` represents a [Unicode](http://en.wikipedia.org/wiki/Unicode) [code point](http://en.wikipedia.org/wiki/Code_point).\nIt occupies 32 bits.\n\nIt is created by enclosing an UTF-8 character in single quotes.\n\n```\n'a'\n'z'\n'0'\n'_'\n'あ'\n```\n\nYou can use a backslash to denote some characters:\n\n```\n'\\'' # single quote\n'\\\\' # backslash\n'\\e' # escape\n'\\f' # form feed\n'\\n' # newline\n'\\r' # carriage return\n'\\t' # tab\n'\\v' # vertical tab\n```\n\nYou can use a backslash followed by an *u* and four hexadecimal characters to denote a unicode codepoint written:\n\n```\n'\\u0041' # == 'A'\n```\n\nOr you can use curly braces and specify up to four hexadecimal numbers:\n\n```\n'\\u{41}' # == 'A'\n```","summary":"<p>A <code><a href=\"Char.html\">Char</a></code> represents a <a href=\"http://en.wikipedia.org/wiki/Unicode\">Unicode</a> <a href=\"http://en.wikipedia.org/wiki/Code_point\">code point</a>.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"!=(other:Char):Bool-instance-method","html_id":"!=(other:Char):Bool-instance-method","name":"!=","doc":"Returns `true` if `self`'s codepoint is not equal to *other*'s codepoint.","summary":"<p>Returns <code>true</code> if <code>self</code>'s codepoint is not equal to <em>other</em>'s codepoint.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"args_string":"(other : Char) : Bool","args_html":"(other : <a href=\"Char.html\">Char</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/primitives.cr","line_number":93,"url":null},"def":{"name":"!=","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"# primitive: binary"}},{"id":"+(str:String)-instance-method","html_id":"+(str:String)-instance-method","name":"+","doc":"Concatenates this char and *string*.\n\n```\n'f' + \"oo\" # => \"foo\"\n```","summary":"<p>Concatenates this char and <em>string</em>.</p>","abstract":false,"args":[{"name":"str","doc":null,"default_value":"","external_name":"str","restriction":"String"}],"args_string":"(str : String)","args_html":"(str : <a href=\"String.html\">String</a>)","location":{"filename":"src/char.cr","line_number":71,"url":null},"def":{"name":"+","args":[{"name":"str","doc":null,"default_value":"","external_name":"str","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"bytesize = str.bytesize + self.bytesize\nString.new(bytesize) do |buffer|\n  count = 0\n  each_byte do |byte|\n    buffer[count] = byte\n    count = count + 1\n  end\n  (buffer + count).copy_from(str.to_unsafe, str.bytesize)\n  {bytesize, str.size + 1}\nend\n"}},{"id":"+(other:Int):Char-instance-method","html_id":"+(other:Int):Char-instance-method","name":"+","doc":"Returns a char that has this char's codepoint plus *other*.\n\n```\n'a' + 1 # => 'b'\n'a' + 2 # => 'c'\n```","summary":"<p>Returns a char that has this char's codepoint plus <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : Char","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"Char.html\">Char</a>","location":{"filename":"src/char.cr","line_number":92,"url":null},"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Char","visibility":"Public","body":"(ord + other).chr"}},{"id":"-(other:Char)-instance-method","html_id":"-(other:Char)-instance-method","name":"-","doc":"Returns the difference of the codepoint values of this char and *other*.\n\n```\n'a' - 'a' # => 0\n'b' - 'a' # => 1\n'c' - 'a' # => 2\n```","summary":"<p>Returns the difference of the codepoint values of this char and <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"args_string":"(other : Char)","args_html":"(other : <a href=\"Char.html\">Char</a>)","location":{"filename":"src/char.cr","line_number":62,"url":null},"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ord - other.ord"}},{"id":"-(other:Int):Char-instance-method","html_id":"-(other:Int):Char-instance-method","name":"-","doc":"Returns a char that has this char's codepoint minus *other*.\n\n```\n'c' - 1 # => 'b'\n'c' - 2 # => 'a'\n```","summary":"<p>Returns a char that has this char's codepoint minus <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"args_string":"(other : Int) : Char","args_html":"(other : <a href=\"Int.html\">Int</a>) : <a href=\"Char.html\">Char</a>","location":{"filename":"src/char.cr","line_number":102,"url":null},"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Char","visibility":"Public","body":"(ord - other).chr"}},{"id":"<(other:Char):Bool-instance-method","html_id":"<(other:Char):Bool-instance-method","name":"<","doc":"Returns `true` if `self`'s codepoint is less than *other*'s codepoint.","summary":"<p>Returns <code>true</code> if <code>self</code>'s codepoint is less than <em>other</em>'s codepoint.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"args_string":"(other : Char) : Bool","args_html":"(other : <a href=\"Char.html\">Char</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/primitives.cr","line_number":93,"url":null},"def":{"name":"<","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"# primitive: binary"}},{"id":"<=(other:Char):Bool-instance-method","html_id":"<=(other:Char):Bool-instance-method","name":"<=","doc":"Returns `true` if `self`'s codepoint is less than or equal to *other*'s codepoint.","summary":"<p>Returns <code>true</code> if <code>self</code>'s codepoint is less than or equal to <em>other</em>'s codepoint.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"args_string":"(other : Char) : Bool","args_html":"(other : <a href=\"Char.html\">Char</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/primitives.cr","line_number":93,"url":null},"def":{"name":"<=","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"# primitive: binary"}},{"id":"(other:Char)-instance-method","html_id":"(other:Char)-instance-method","name":"<=>","doc":"The comparison operator.\n\nReturns the difference of the codepoint values of `self` and *other*.\nThe result is either negative, `0` or positive based on whether `other`'s codepoint is\nless, equal, or greater than `self`'s codepoint.\n\n```\n'a' <=> 'c' # => -2\n'z' <=> 'z' # => 0\n'c' <=> 'a' # => 2\n```","summary":"<p>The comparison operator.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"args_string":"(other : Char)","args_html":"(other : <a href=\"Char.html\">Char</a>)","location":{"filename":"src/char.cr","line_number":117,"url":null},"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self - other"}},{"id":"==(other:Char):Bool-instance-method","html_id":"==(other:Char):Bool-instance-method","name":"==","doc":"Returns `true` if `self`'s codepoint is equal to *other*'s codepoint.","summary":"<p>Returns <code>true</code> if <code>self</code>'s codepoint is equal to <em>other</em>'s codepoint.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"args_string":"(other : Char) : Bool","args_html":"(other : <a href=\"Char.html\">Char</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/primitives.cr","line_number":93,"url":null},"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"# primitive: binary"}},{"id":"===(byte:Int)-instance-method","html_id":"===(byte:Int)-instance-method","name":"===","doc":"Returns `true` if the codepoint is equal to *byte* ignoring the type.\n\n```\n'c'.ord       # => 99\n'c' === 99_u8 # => true\n'c' === 99    # => true\n'z' === 99    # => false\n```","summary":"<p>Returns <code>true</code> if the codepoint is equal to <em>byte</em> ignoring the type.</p>","abstract":false,"args":[{"name":"byte","doc":null,"default_value":"","external_name":"byte","restriction":"Int"}],"args_string":"(byte : Int)","args_html":"(byte : <a href=\"Int.html\">Int</a>)","location":{"filename":"src/char.cr","line_number":794,"url":null},"def":{"name":"===","args":[{"name":"byte","doc":null,"default_value":"","external_name":"byte","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ord === byte"}},{"id":">(other:Char):Bool-instance-method","html_id":">(other:Char):Bool-instance-method","name":">","doc":"Returns `true` if `self`'s codepoint is greater than *other*'s codepoint.","summary":"<p>Returns <code>true</code> if <code>self</code>'s codepoint is greater than <em>other</em>'s codepoint.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"args_string":"(other : Char) : Bool","args_html":"(other : <a href=\"Char.html\">Char</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/primitives.cr","line_number":93,"url":null},"def":{"name":">","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"# primitive: binary"}},{"id":">=(other:Char):Bool-instance-method","html_id":">=(other:Char):Bool-instance-method","name":">=","doc":"Returns `true` if `self`'s codepoint is greater than or equal to *other*'s codepoint.","summary":"<p>Returns <code>true</code> if <code>self</code>'s codepoint is greater than or equal to <em>other</em>'s codepoint.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"args_string":"(other : Char) : Bool","args_html":"(other : <a href=\"Char.html\">Char</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/primitives.cr","line_number":93,"url":null},"def":{"name":">=","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Char"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"# primitive: binary"}},{"id":"alphanumeric?-instance-method","html_id":"alphanumeric?-instance-method","name":"alphanumeric?","doc":"Returns `true` if this char is a letter or a number according to unicode.\n\n```\n'c'.alphanumeric? # => true\n'8'.alphanumeric? # => true\n'.'.alphanumeric? # => false\n```","summary":"<p>Returns <code>true</code> if this char is a letter or a number according to unicode.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":238,"url":null},"def":{"name":"alphanumeric?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"letter? || number?"}},{"id":"ascii?-instance-method","html_id":"ascii?-instance-method","name":"ascii?","doc":"Returns `true` if this char is an ASCII character\n(codepoint is in (0..127))","summary":"<p>Returns <code>true</code> if this char is an ASCII character (codepoint is in (0..127))</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":123,"url":null},"def":{"name":"ascii?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ord < 128"}},{"id":"ascii_alphanumeric?-instance-method","html_id":"ascii_alphanumeric?-instance-method","name":"ascii_alphanumeric?","doc":"Returns `true` if this char is an ASCII letter or number ('0' to '9', 'a' to 'z', 'A' to 'Z').\n\n```\n'c'.ascii_alphanumeric? # => true\n'8'.ascii_alphanumeric? # => true\n'.'.ascii_alphanumeric? # => false\n```","summary":"<p>Returns <code>true</code> if this char is an ASCII letter or number ('0' to '9', 'a' to 'z', 'A' to 'Z').</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":227,"url":null},"def":{"name":"ascii_alphanumeric?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ascii_letter? || ascii_number?"}},{"id":"ascii_control?-instance-method","html_id":"ascii_control?-instance-method","name":"ascii_control?","doc":"Returns `true` if this char is an ASCII control character.\n\n```\n('\\u0000'..'\\u0019').each do |char|\n  char.control? # => true\nend\n\n('\\u007F'..'\\u009F').each do |char|\n  char.control? # => true\nend\n```","summary":"<p>Returns <code>true</code> if this char is an ASCII control character.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":452,"url":null},"def":{"name":"ascii_control?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ord < 32 || (127 <= (__temp_18 = ord) && __temp_18 <= 159)"}},{"id":"ascii_letter?-instance-method","html_id":"ascii_letter?-instance-method","name":"ascii_letter?","doc":"Returns `true` if this char is an ASCII letter ('a' to 'z', 'A' to 'Z').\n\n```\n'c'.ascii_letter? # => true\n'á'.ascii_letter? # => false\n'8'.ascii_letter? # => false\n```","summary":"<p>Returns <code>true</code> if this char is an ASCII letter ('a' to 'z', 'A' to 'Z').</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":205,"url":null},"def":{"name":"ascii_letter?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ascii_lowercase? || ascii_uppercase?"}},{"id":"ascii_lowercase?-instance-method","html_id":"ascii_lowercase?-instance-method","name":"ascii_lowercase?","doc":"Returns `true` if this char is a lowercase ASCII letter.\n\n```\n'c'.ascii_lowercase? # => true\n'ç'.lowercase?       # => true\n'G'.ascii_lowercase? # => false\n'.'.ascii_lowercase? # => false\n```","summary":"<p>Returns <code>true</code> if this char is a lowercase ASCII letter.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":158,"url":null},"def":{"name":"ascii_lowercase?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"'a' <= self && self <= 'z'"}},{"id":"ascii_number?(base:Int=10)-instance-method","html_id":"ascii_number?(base:Int=10)-instance-method","name":"ascii_number?","doc":"Returns `true` if this char is an ASCII number in specified base.\n\nBase can be from 0 to 36 with digits from '0' to '9' and 'a' to 'z' or 'A' to 'Z'.\n\n```\n'4'.ascii_number?     # => true\n'z'.ascii_number?     # => false\n'z'.ascii_number?(36) # => true\n```","summary":"<p>Returns <code>true</code> if this char is an ASCII number in specified base.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":136,"url":null},"def":{"name":"ascii_number?","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"!(!(to_i?(base)))"}},{"id":"ascii_uppercase?-instance-method","html_id":"ascii_uppercase?-instance-method","name":"ascii_uppercase?","doc":"Returns `true` if this char is an ASCII uppercase letter.\n\n```\n'H'.ascii_uppercase? # => true\n'Á'.ascii_uppercase? # => false\n'c'.ascii_uppercase? # => false\n'.'.ascii_uppercase? # => false\n```","summary":"<p>Returns <code>true</code> if this char is an ASCII uppercase letter.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":182,"url":null},"def":{"name":"ascii_uppercase?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"'A' <= self && self <= 'Z'"}},{"id":"ascii_whitespace?-instance-method","html_id":"ascii_whitespace?-instance-method","name":"ascii_whitespace?","doc":"Returns `true` if this char is an ASCII whitespace.\n\n```\n' '.ascii_whitespace?  # => true\n'\\t'.ascii_whitespace? # => true\n'b'.ascii_whitespace?  # => false\n```","summary":"<p>Returns <code>true</code> if this char is an ASCII whitespace.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":249,"url":null},"def":{"name":"ascii_whitespace?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(self == ' ') || (9 <= (__temp_17 = ord) && __temp_17 <= 13)"}},{"id":"bytes-instance-method","html_id":"bytes-instance-method","name":"bytes","doc":"Returns this char bytes as encoded by UTF-8, as an `Array(UInt8)`.\n\n```\n'a'.bytes # => [97]\n'あ'.bytes # => [227, 129, 130]\n```","summary":"<p>Returns this char bytes as encoded by UTF-8, as an <code><a href=\"Array.html\">Array</a>(<a href=\"UInt8.html\">UInt8</a>)</code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":740,"url":null},"def":{"name":"bytes","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"bytes = [] of UInt8\neach_byte do |byte|\n  bytes << byte\nend\nbytes\n"}},{"id":"bytesize-instance-method","html_id":"bytesize-instance-method","name":"bytesize","doc":"Returns the number of UTF-8 bytes in this char.\n\n```\n'a'.bytesize # => 1\n'好'.bytesize # => 3\n```","summary":"<p>Returns the number of UTF-8 bytes in this char.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":713,"url":null},"def":{"name":"bytesize","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"c = ord\nif c < 128\n  1\nelse\n  if c <= 2047\n    2\n  else\n    if c <= 65535\n      3\n    else\n      if c <= MAX_CODEPOINT\n        4\n      else\n        raise(InvalidByteSequenceError.new(\"Invalid char value #{dump}\"))\n      end\n    end\n  end\nend\n"}},{"id":"clone-instance-method","html_id":"clone-instance-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":798,"url":null},"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"control?-instance-method","html_id":"control?-instance-method","name":"control?","doc":"Returns `true` if this char is a control character according to unicode.","summary":"<p>Returns <code>true</code> if this char is a control character according to unicode.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":457,"url":null},"def":{"name":"control?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ascii? ? ascii_control? : Unicode.control?(self)"}},{"id":"downcase(options=Unicode::CaseOptions::None)-instance-method","html_id":"downcase(options=Unicode::CaseOptions::None)-instance-method","name":"downcase","doc":"Returns the downcase equivalent of this char.\n\nNote that this only works for characters whose downcase\nequivalent yields a single codepoint. There are a few\ncharacters, like 'İ', than when downcased result in multiple\ncharacters (in this case: 'I' and the dot mark).\n\nFor a more correct method see the method that receives a block.\n\n```\n'Z'.downcase # => 'z'\n'x'.downcase # => 'x'\n'.'.downcase # => '.'\n```","summary":"<p>Returns the downcase equivalent of this char.</p>","abstract":false,"args":[{"name":"options","doc":null,"default_value":"Unicode::CaseOptions::None","external_name":"options","restriction":""}],"args_string":"(options = <span class=\"t\">Unicode</span><span class=\"t\">::</span><span class=\"t\">CaseOptions</span><span class=\"t\">::</span><span class=\"t\">None</span>)","args_html":"(options = <span class=\"t\">Unicode</span><span class=\"t\">::</span><span class=\"t\">CaseOptions</span><span class=\"t\">::</span><span class=\"t\">None</span>)","location":{"filename":"src/char.cr","line_number":369,"url":null},"def":{"name":"downcase","args":[{"name":"options","doc":null,"default_value":"Unicode::CaseOptions::None","external_name":"options","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Unicode.downcase(self, options)"}},{"id":"downcase(options=Unicode::CaseOptions::None,&)-instance-method","html_id":"downcase(options=Unicode::CaseOptions::None,&)-instance-method","name":"downcase","doc":"Yields each char for the downcase equivalent of this char.\n\nThis method takes into account the possibility that an downcase\nversion of a char might result in multiple chars, like for\n'İ', which results in 'i' and a dot mark.","summary":"<p>Yields each char for the downcase equivalent of this char.</p>","abstract":false,"args":[{"name":"options","doc":null,"default_value":"Unicode::CaseOptions::None","external_name":"options","restriction":""}],"args_string":"(options = <span class=\"t\">Unicode</span><span class=\"t\">::</span><span class=\"t\">CaseOptions</span><span class=\"t\">::</span><span class=\"t\">None</span>, &)","args_html":"(options = <span class=\"t\">Unicode</span><span class=\"t\">::</span><span class=\"t\">CaseOptions</span><span class=\"t\">::</span><span class=\"t\">None</span>, &)","location":{"filename":"src/char.cr","line_number":378,"url":null},"def":{"name":"downcase","args":[{"name":"options","doc":null,"default_value":"Unicode::CaseOptions::None","external_name":"options","restriction":""}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"Unicode.downcase(self, options) do |char|\n  yield char\nend"}},{"id":"dump-instance-method","html_id":"dump-instance-method","name":"dump","doc":"Returns this char as a string that contains a char literal as written in Crystal,\nwith characters with a codepoint greater than `0x79` written as `\\u{...}`.\n\n```\n'a'.dump      # => \"'a'\"\n'\\t'.dump     # => \"'\\\\t'\"\n'あ'.dump      # => \"'\\\\u{3042}'\"\n'\\u0012'.dump # => \"'\\\\u{12}'\"\n```","summary":"<p>Returns this char as a string that contains a char literal as written in Crystal, with characters with a codepoint greater than <code>0x79</code> written as <code>\\u{...}</code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":502,"url":null},"def":{"name":"dump","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"dump_or_inspect do |io|\n  if ascii_control? || ord >= 128\n    io << \"\\\\u{\"\n    ord.to_s(io, 16)\n    io << '}'\n  else\n    to_s(io)\n  end\nend"}},{"id":"dump(io)-instance-method","html_id":"dump(io)-instance-method","name":"dump","doc":"Appends this char as a string that contains a char literal to the given `IO`.\n\nSee also: `#dump`.","summary":"<p>Appends this char as a string that contains a char literal to the given <code><a href=\"IO.html\">IO</a></code>.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":""}],"args_string":"(io)","args_html":"(io)","location":{"filename":"src/char.cr","line_number":517,"url":null},"def":{"name":"dump","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"io << '\\''\nio << dump\nio << '\\''\n"}},{"id":"each_byte(&):Nil-instance-method","html_id":"each_byte(&):Nil-instance-method","name":"each_byte","doc":"Yields each of the bytes of this char as encoded by UTF-8.\n\n```\nputs \"'a'\"\n'a'.each_byte do |byte|\n  puts byte\nend\nputs\n\nputs \"'あ'\"\n'あ'.each_byte do |byte|\n  puts byte\nend\n```\n\nOutput:\n\n```text\n'a'\n97\n\n'あ'\n227\n129\n130\n```","summary":"<p>Yields each of the bytes of this char as encoded by UTF-8.</p>","abstract":false,"args":[],"args_string":"(&) : Nil","args_html":"(&) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/char.cr","line_number":680,"url":null},"def":{"name":"each_byte","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"c = ord\nif c < 128\n  yield c.to_u8\nelse\n  if c <= 2047\n    yield (192 | (c >> 6)).to_u8\n    yield (128 | (c & 63)).to_u8\n  else\n    if c <= 65535\n      yield (224 | (c >> 12)).to_u8\n      yield (128 | ((c >> 6) & 63)).to_u8\n      yield (128 | (c & 63)).to_u8\n    else\n      if c <= MAX_CODEPOINT\n        yield (240 | (c >> 18)).to_u8\n        yield (128 | ((c >> 12) & 63)).to_u8\n        yield (128 | ((c >> 6) & 63)).to_u8\n        yield (128 | (c & 63)).to_u8\n      else\n        raise(InvalidByteSequenceError.new(\"Invalid char value #{dump}\"))\n      end\n    end\n  end\nend\n"}},{"id":"hash(hasher)-instance-method","html_id":"hash(hasher)-instance-method","name":"hash","doc":"See `Object#hash(hasher)`","summary":"<p>See <code><a href=\"Object.html#hash(hasher)-instance-method\">Object#hash(hasher)</a></code></p>","abstract":false,"args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"args_string":"(hasher)","args_html":"(hasher)","location":{"filename":"src/char.cr","line_number":415,"url":null},"def":{"name":"hash","args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"hasher.char(self)"}},{"id":"hex?-instance-method","html_id":"hex?-instance-method","name":"hex?","doc":"Returns `true` if this char is an ASCII hex digit ('0' to '9', 'a' to 'f', 'A' to 'F').\n\n```\n'5'.hex? # => true\n'a'.hex? # => true\n'F'.hex? # => true\n'g'.hex? # => false\n```","summary":"<p>Returns <code>true</code> if this char is an ASCII hex digit ('0' to '9', 'a' to 'f', 'A' to 'F').</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":272,"url":null},"def":{"name":"hex?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ascii_number?(16)"}},{"id":"in_set?(*sets:String)-instance-method","html_id":"in_set?(*sets:String)-instance-method","name":"in_set?","doc":"Returns `true` if this char is matched by the given *sets*.\n\nEach parameter defines a set, the character is matched against\nthe intersection of those, in other words it needs to\nmatch all sets.\n\nIf a set starts with a ^, it is negated. The sequence c1-c2\nmeans all characters between and including c1 and c2\nand is known as a range.\n\nThe backslash character \\ can be used to escape ^ or - and\nis otherwise ignored unless it appears at the end of a range\nor set.\n\n```\n'l'.in_set? \"lo\"          # => true\n'l'.in_set? \"lo\", \"o\"     # => false\n'l'.in_set? \"hello\", \"^l\" # => false\n'l'.in_set? \"j-m\"         # => true\n\n'^'.in_set? \"\\\\^aeiou\" # => true\n'-'.in_set? \"a\\\\-eo\"   # => true\n\n'\\\\'.in_set? \"\\\\\"    # => true\n'\\\\'.in_set? \"\\\\A\"   # => false\n'\\\\'.in_set? \"X-\\\\w\" # => true\n```","summary":"<p>Returns <code>true</code> if this char is matched by the given <em>sets</em>.</p>","abstract":false,"args":[{"name":"sets","doc":null,"default_value":"","external_name":"sets","restriction":"String"}],"args_string":"(*sets : String)","args_html":"(*sets : <a href=\"String.html\">String</a>)","location":{"filename":"src/char.cr","line_number":303,"url":null},"def":{"name":"in_set?","args":[{"name":"sets","doc":null,"default_value":"","external_name":"sets","restriction":"String"}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if sets.size > 1\n  return sets.all? do |set|\n    in_set?(set)\n  end\nend\nset = sets.first\nnot_negated = true\nrange = false\nprevious = nil\nset.each_char do |char|\n  case char\n  when '^'\n    if previous\n    else\n      not_negated = false\n      previous = char\n      next\n    end\n  when '-'\n    if previous && (previous != '\\\\')\n      range = true\n      if previous == '^'\n        previous = '^'\n        not_negated = true\n      end\n      next\n    else\n      if self == char\n        return not_negated\n      end\n    end\n  end\n  if range && previous\n    if previous > char\n      raise(ArgumentError.new(\"Invalid range #{previous}-#{char}\"))\n    end\n    if previous <= self && self <= char\n      return not_negated\n    end\n    range = false\n  else\n    if char != '\\\\'\n      if self == char\n        return not_negated\n      end\n    end\n  end\n  previous = char\nend\nif range && (self == '-')\n  return not_negated\nend\nif (previous == '\\\\') && (self == previous)\n  return not_negated\nend\n!not_negated\n"}},{"id":"inspect:String-instance-method","html_id":"inspect:String-instance-method","name":"inspect","doc":"Returns this char as a string that contains a char literal.\n\n```\n'a'.inspect      # => \"'a'\"\n'\\t'.inspect     # => \"'\\\\t'\"\n'あ'.inspect      # => \"'あ'\"\n'\\u0012'.inspect # => \"'\\\\u{12}'\"\n```","summary":"<p>Returns this char as a string that contains a char literal.</p>","abstract":false,"args":[],"args_string":" : String","args_html":" : <a href=\"String.html\">String</a>","location":{"filename":"src/char.cr","line_number":474,"url":null},"def":{"name":"inspect","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"dump_or_inspect do |io|\n  if ascii_control?\n    io << \"\\\\u{\"\n    ord.to_s(io, 16)\n    io << '}'\n  else\n    to_s(io)\n  end\nend"}},{"id":"inspect(io:IO):Nil-instance-method","html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Appends this char as a string that contains a char literal to the given `IO`.\n\nSee also: `#inspect`.","summary":"<p>Appends this char as a string that contains a char literal to the given <code><a href=\"IO.html\">IO</a></code>.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/char.cr","line_number":489,"url":null},"def":{"name":"inspect","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << inspect"}},{"id":"letter?-instance-method","html_id":"letter?-instance-method","name":"letter?","doc":"Returns `true` if this char is a letter.\n\n```\n'c'.letter? # => true\n'á'.letter? # => true\n'8'.letter? # => false\n```","summary":"<p>Returns <code>true</code> if this char is a letter.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":216,"url":null},"def":{"name":"letter?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ascii? ? ascii_letter? : Unicode.letter?(self)"}},{"id":"lowercase?-instance-method","html_id":"lowercase?-instance-method","name":"lowercase?","doc":"Returns `true` if this char is a lowercase letter.\n\n```\n'c'.lowercase? # => true\n'ç'.lowercase? # => true\n'G'.lowercase? # => false\n'.'.lowercase? # => false\n```","summary":"<p>Returns <code>true</code> if this char is a lowercase letter.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":170,"url":null},"def":{"name":"lowercase?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ascii? ? ascii_lowercase? : Unicode.lowercase?(self)"}},{"id":"mark?-instance-method","html_id":"mark?-instance-method","name":"mark?","doc":"Returns `true` if this is char is a mark character according to unicode.","summary":"<p>Returns <code>true</code> if this is char is a mark character according to unicode.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":462,"url":null},"def":{"name":"mark?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Unicode.mark?(self)"}},{"id":"number?-instance-method","html_id":"number?-instance-method","name":"number?","doc":"Returns `true` if this char is a number according to unicode.\n\n```\n'1'.number? # => true\n'a'.number? # => false\n```","summary":"<p>Returns <code>true</code> if this char is a number according to unicode.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":146,"url":null},"def":{"name":"number?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ascii? ? ascii_number? : Unicode.number?(self)"}},{"id":"ord:Int32-instance-method","html_id":"ord:Int32-instance-method","name":"ord","doc":"Returns the codepoint of this char.\n\nThe codepoint is the integer representation.\nThe Universal Coded Character Set (UCS) standard, commonly known as Unicode,\nassigns names and meanings to numbers, these numbers are called codepoints.\n\nFor values below and including 127 this matches the ASCII codes\nand thus its byte representation.\n\n```\n'a'.ord      # => 97\n'\\0'.ord     # => 0\n'\\u007f'.ord # => 127\n'☃'.ord      # => 9731\n```","summary":"<p>Returns the codepoint of this char.</p>","abstract":false,"args":[],"args_string":" : Int32","args_html":" : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/primitives.cr","line_number":90,"url":null},"def":{"name":"ord","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":"# primitive: convert"}},{"id":"pred-instance-method","html_id":"pred-instance-method","name":"pred","doc":"Returns a Char that is one codepoint smaller than this char's codepoint.\n\n```\n'b'.pred # => 'a'\n'ぃ'.pred # => 'あ'\n```","summary":"<p>Returns a Char that is one codepoint smaller than this char's codepoint.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":437,"url":null},"def":{"name":"pred","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(ord - 1).chr"}},{"id":"succ-instance-method","html_id":"succ-instance-method","name":"succ","doc":"Returns a Char that is one codepoint bigger than this char's codepoint.\n\n```\n'a'.succ # => 'b'\n'あ'.succ # => 'ぃ'\n```\n\nThis method allows creating a `Range` of chars.","summary":"<p>Returns a Char that is one codepoint bigger than this char's codepoint.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":427,"url":null},"def":{"name":"succ","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(ord + 1).chr"}},{"id":"to_f-instance-method","html_id":"to_f-instance-method","name":"to_f","doc":"Returns the integer value of this char as a float if it's an ASCII char denoting a digit,\nraises otherwise.\n\n```\n'1'.to_f # => 1.0\n'8'.to_f # => 8.0\n'c'.to_f # raises ArgumentError\n```","summary":"<p>Returns the integer value of this char as a float if it's an ASCII char denoting a digit, raises otherwise.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":618,"url":null},"def":{"name":"to_f","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64"}},{"id":"to_f32-instance-method","html_id":"to_f32-instance-method","name":"to_f32","doc":"See also: `to_f`.","summary":"<p>See also: <code><a href=\"Char.html#to_f-instance-method\">#to_f</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":635,"url":null},"def":{"name":"to_f32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i.to_f32"}},{"id":"to_f32?-instance-method","html_id":"to_f32?-instance-method","name":"to_f32?","doc":"See also: `to_f?`.","summary":"<p>See also: <code><a href=\"Char.html#to_f?-instance-method\">#to_f?</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":640,"url":null},"def":{"name":"to_f32?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i?.try(&.to_f32)"}},{"id":"to_f64-instance-method","html_id":"to_f64-instance-method","name":"to_f64","doc":"Same as `to_f`.","summary":"<p>Same as <code><a href=\"Char.html#to_f-instance-method\">#to_f</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":645,"url":null},"def":{"name":"to_f64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i.to_f64"}},{"id":"to_f64?-instance-method","html_id":"to_f64?-instance-method","name":"to_f64?","doc":"Same as `to_f?`.","summary":"<p>Same as <code><a href=\"Char.html#to_f?-instance-method\">#to_f?</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":650,"url":null},"def":{"name":"to_f64?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i?.try(&.to_f64)"}},{"id":"to_f?-instance-method","html_id":"to_f?-instance-method","name":"to_f?","doc":"Returns the integer value of this char as a float if it's an ASCII char denoting a digit,\n`nil` otherwise.\n\n```\n'1'.to_f? # => 1.0\n'8'.to_f? # => 8.0\n'c'.to_f? # => nil\n```","summary":"<p>Returns the integer value of this char as a float if it's an ASCII char denoting a digit, <code>nil</code> otherwise.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":630,"url":null},"def":{"name":"to_f?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64?"}},{"id":"to_i(base:Int=10):Int32-instance-method","html_id":"to_i(base:Int=10):Int32-instance-method","name":"to_i","doc":"Returns the integer value of this char if it's an ASCII char denoting a digit\nin *base*, raises otherwise.\n\n```\n'1'.to_i     # => 1\n'8'.to_i     # => 8\n'c'.to_i     # raises ArgumentError\n'1'.to_i(16) # => 1\n'a'.to_i(16) # => 10\n'f'.to_i(16) # => 15\n'z'.to_i(16) # raises ArgumentError\n```","summary":"<p>Returns the integer value of this char if it's an ASCII char denoting a digit in <em>base</em>, raises otherwise.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>) : Int32","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/char.cr","line_number":556,"url":null},"def":{"name":"to_i","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":"(to_i?(base)) || (raise(ArgumentError.new(\"Invalid integer: #{self}\")))"}},{"id":"to_i16(base:Int=10)-instance-method","html_id":"to_i16(base:Int=10)-instance-method","name":"to_i16","doc":"See also: `to_i`.","summary":"<p>See also: <code><a href=\"Char.html#to_i(base:Int=10):Int32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":598,"url":null},"def":{"name":"to_i16","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i(base)).to_i16"}},{"id":"to_i16?(base:Int=10)-instance-method","html_id":"to_i16?(base:Int=10)-instance-method","name":"to_i16?","doc":"See also: `to_i?`.","summary":"<p>See also: <code><a href=\"Char.html#to_i?(base:Int=10):Int32?-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":598,"url":null},"def":{"name":"to_i16?","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i?(base)).try(&.to_i16)"}},{"id":"to_i32(base:Int=10):Int32-instance-method","html_id":"to_i32(base:Int=10):Int32-instance-method","name":"to_i32","doc":"Same as `to_i`.","summary":"<p>Same as <code><a href=\"Char.html#to_i(base:Int=10):Int32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>) : Int32","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>) : <a href=\"Int32.html\">Int32</a>","location":{"filename":"src/char.cr","line_number":589,"url":null},"def":{"name":"to_i32","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":"to_i(base)"}},{"id":"to_i32?(base:Int=10):Int32?-instance-method","html_id":"to_i32?(base:Int=10):Int32?-instance-method","name":"to_i32?","doc":"Same as `to_i?`.","summary":"<p>Same as <code><a href=\"Char.html#to_i?(base:Int=10):Int32?-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>) : Int32?","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>) : <a href=\"Int32.html\">Int32</a>?","location":{"filename":"src/char.cr","line_number":594,"url":null},"def":{"name":"to_i32?","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32 | ::Nil","visibility":"Public","body":"to_i?(base)"}},{"id":"to_i64(base:Int=10)-instance-method","html_id":"to_i64(base:Int=10)-instance-method","name":"to_i64","doc":"See also: `to_i`.","summary":"<p>See also: <code><a href=\"Char.html#to_i(base:Int=10):Int32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":598,"url":null},"def":{"name":"to_i64","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i(base)).to_i64"}},{"id":"to_i64?(base:Int=10)-instance-method","html_id":"to_i64?(base:Int=10)-instance-method","name":"to_i64?","doc":"See also: `to_i?`.","summary":"<p>See also: <code><a href=\"Char.html#to_i?(base:Int=10):Int32?-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":598,"url":null},"def":{"name":"to_i64?","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i?(base)).try(&.to_i64)"}},{"id":"to_i8(base:Int=10)-instance-method","html_id":"to_i8(base:Int=10)-instance-method","name":"to_i8","doc":"See also: `to_i`.","summary":"<p>See also: <code><a href=\"Char.html#to_i(base:Int=10):Int32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":598,"url":null},"def":{"name":"to_i8","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i(base)).to_i8"}},{"id":"to_i8?(base:Int=10)-instance-method","html_id":"to_i8?(base:Int=10)-instance-method","name":"to_i8?","doc":"See also: `to_i?`.","summary":"<p>See also: <code><a href=\"Char.html#to_i?(base:Int=10):Int32?-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":598,"url":null},"def":{"name":"to_i8?","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i?(base)).try(&.to_i8)"}},{"id":"to_i?(base:Int=10):Int32?-instance-method","html_id":"to_i?(base:Int=10):Int32?-instance-method","name":"to_i?","doc":"Returns the integer value of this char if it's an ASCII char denoting a digit\nin *base*, `nil` otherwise.\n\n```\n'1'.to_i?     # => 1\n'8'.to_i?     # => 8\n'c'.to_i?     # => nil\n'1'.to_i?(16) # => 1\n'a'.to_i?(16) # => 10\n'f'.to_i?(16) # => 15\n'z'.to_i?(16) # => nil\n```","summary":"<p>Returns the integer value of this char if it's an ASCII char denoting a digit in <em>base</em>, <code>nil</code> otherwise.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>) : Int32?","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>) : <a href=\"Int32.html\">Int32</a>?","location":{"filename":"src/char.cr","line_number":572,"url":null},"def":{"name":"to_i?","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32 | ::Nil","visibility":"Public","body":"if 2 <= base && base <= 36\nelse\n  raise(ArgumentError.new(\"Invalid base #{base}, expected 2 to 36\"))\nend\nif base == 10\n  if '0' <= self && self <= '9'\n  else\n    return\n  end\n  self - '0'\nelse\n  ord = ord()\n  if 0 <= ord && ord < 256\n    digit = String::CHAR_TO_DIGIT.to_unsafe[ord]\n    if (digit == -1) || digit >= base\n      return\n    end\n    digit.to_i32\n  end\nend\n"}},{"id":"to_s:String-instance-method","html_id":"to_s:String-instance-method","name":"to_s","doc":"Returns this char as a string containing this char as a single character.\n\n```\n'a'.to_s # => \"a\"\n'あ'.to_s # => \"あ\"\n```","summary":"<p>Returns this char as a string containing this char as a single character.</p>","abstract":false,"args":[],"args_string":" : String","args_html":" : <a href=\"String.html\">String</a>","location":{"filename":"src/char.cr","line_number":754,"url":null},"def":{"name":"to_s","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"String.new(4) do |buffer|\n  appender = buffer.appender\n  each_byte do |byte|\n    appender << byte\n  end\n  {appender.size, 1}\nend"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Appends this char to the given `IO`.\n\nThis appends this char's bytes as encoded by UTF-8 to the given `IO`.","summary":"<p>Appends this char to the given <code><a href=\"IO.html\">IO</a></code>.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/char.cr","line_number":765,"url":null},"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"if ascii?\n  byte = ord.to_u8\n  if io.has_non_utf8_encoding?\n    io.write_utf8(Slice.new(pointerof(byte), 1))\n  else\n    io.write_byte(byte)\n  end\nelse\n  chars = uninitialized ::StaticArray(UInt8, 4)\n  i = 0\n  each_byte do |byte|\n    chars[i] = byte\n    i = i + 1\n  end\n  io.write_utf8(chars.to_slice[0, i])\nend"}},{"id":"to_u16(base:Int=10)-instance-method","html_id":"to_u16(base:Int=10)-instance-method","name":"to_u16","doc":"See also: `to_i`.","summary":"<p>See also: <code><a href=\"Char.html#to_i(base:Int=10):Int32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":598,"url":null},"def":{"name":"to_u16","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i(base)).to_u16"}},{"id":"to_u16?(base:Int=10)-instance-method","html_id":"to_u16?(base:Int=10)-instance-method","name":"to_u16?","doc":"See also: `to_i?`.","summary":"<p>See also: <code><a href=\"Char.html#to_i?(base:Int=10):Int32?-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":598,"url":null},"def":{"name":"to_u16?","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i?(base)).try(&.to_u16)"}},{"id":"to_u32(base:Int=10)-instance-method","html_id":"to_u32(base:Int=10)-instance-method","name":"to_u32","doc":"See also: `to_i`.","summary":"<p>See also: <code><a href=\"Char.html#to_i(base:Int=10):Int32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":598,"url":null},"def":{"name":"to_u32","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i(base)).to_u32"}},{"id":"to_u32?(base:Int=10)-instance-method","html_id":"to_u32?(base:Int=10)-instance-method","name":"to_u32?","doc":"See also: `to_i?`.","summary":"<p>See also: <code><a href=\"Char.html#to_i?(base:Int=10):Int32?-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":598,"url":null},"def":{"name":"to_u32?","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i?(base)).try(&.to_u32)"}},{"id":"to_u64(base:Int=10)-instance-method","html_id":"to_u64(base:Int=10)-instance-method","name":"to_u64","doc":"See also: `to_i`.","summary":"<p>See also: <code><a href=\"Char.html#to_i(base:Int=10):Int32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":598,"url":null},"def":{"name":"to_u64","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i(base)).to_u64"}},{"id":"to_u64?(base:Int=10)-instance-method","html_id":"to_u64?(base:Int=10)-instance-method","name":"to_u64?","doc":"See also: `to_i?`.","summary":"<p>See also: <code><a href=\"Char.html#to_i?(base:Int=10):Int32?-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":598,"url":null},"def":{"name":"to_u64?","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i?(base)).try(&.to_u64)"}},{"id":"to_u8(base:Int=10)-instance-method","html_id":"to_u8(base:Int=10)-instance-method","name":"to_u8","doc":"See also: `to_i`.","summary":"<p>See also: <code><a href=\"Char.html#to_i(base:Int=10):Int32-instance-method\">#to_i</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":598,"url":null},"def":{"name":"to_u8","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i(base)).to_u8"}},{"id":"to_u8?(base:Int=10)-instance-method","html_id":"to_u8?(base:Int=10)-instance-method","name":"to_u8?","doc":"See also: `to_i?`.","summary":"<p>See also: <code><a href=\"Char.html#to_i?(base:Int=10):Int32?-instance-method\">#to_i?</a></code>.</p>","abstract":false,"args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"args_string":"(base : Int = <span class=\"n\">10</span>)","args_html":"(base : <a href=\"Int.html\">Int</a> = <span class=\"n\">10</span>)","location":{"filename":"src/char.cr","line_number":598,"url":null},"def":{"name":"to_u8?","args":[{"name":"base","doc":null,"default_value":"10","external_name":"base","restriction":"Int"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(to_i?(base)).try(&.to_u8)"}},{"id":"upcase(options=Unicode::CaseOptions::None,&)-instance-method","html_id":"upcase(options=Unicode::CaseOptions::None,&)-instance-method","name":"upcase","doc":"Yields each char for the upcase equivalent of this char.\n\nThis method takes into account the possibility that an upcase\nversion of a char might result in multiple chars, like for\n'ﬄ', which results in 'F', 'F' and 'L'.\n\n```\n'z'.upcase { |v| puts v } # prints 'Z'\n'ﬄ'.upcase { |v| puts v } # prints 'F', 'F', 'L'\n```","summary":"<p>Yields each char for the upcase equivalent of this char.</p>","abstract":false,"args":[{"name":"options","doc":null,"default_value":"Unicode::CaseOptions::None","external_name":"options","restriction":""}],"args_string":"(options = <span class=\"t\">Unicode</span><span class=\"t\">::</span><span class=\"t\">CaseOptions</span><span class=\"t\">::</span><span class=\"t\">None</span>, &)","args_html":"(options = <span class=\"t\">Unicode</span><span class=\"t\">::</span><span class=\"t\">CaseOptions</span><span class=\"t\">::</span><span class=\"t\">None</span>, &)","location":{"filename":"src/char.cr","line_number":410,"url":null},"def":{"name":"upcase","args":[{"name":"options","doc":null,"default_value":"Unicode::CaseOptions::None","external_name":"options","restriction":""}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"Unicode.upcase(self, options) do |char|\n  yield char\nend"}},{"id":"upcase(options=Unicode::CaseOptions::None)-instance-method","html_id":"upcase(options=Unicode::CaseOptions::None)-instance-method","name":"upcase","doc":"Returns the upcase equivalent of this char.\n\nNote that this only works for characters whose upcase\nequivalent yields a single codepoint. There are a few\ncharacters, like 'ﬄ', than when upcased result in multiple\ncharacters (in this case: 'F', 'F', 'L').\n\nFor a more correct method see the method that receives a block.\n\n```\n'z'.upcase # => 'Z'\n'X'.upcase # => 'X'\n'.'.upcase # => '.'\n```","summary":"<p>Returns the upcase equivalent of this char.</p>","abstract":false,"args":[{"name":"options","doc":null,"default_value":"Unicode::CaseOptions::None","external_name":"options","restriction":""}],"args_string":"(options = <span class=\"t\">Unicode</span><span class=\"t\">::</span><span class=\"t\">CaseOptions</span><span class=\"t\">::</span><span class=\"t\">None</span>)","args_html":"(options = <span class=\"t\">Unicode</span><span class=\"t\">::</span><span class=\"t\">CaseOptions</span><span class=\"t\">::</span><span class=\"t\">None</span>)","location":{"filename":"src/char.cr","line_number":396,"url":null},"def":{"name":"upcase","args":[{"name":"options","doc":null,"default_value":"Unicode::CaseOptions::None","external_name":"options","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Unicode.upcase(self, options)"}},{"id":"uppercase?-instance-method","html_id":"uppercase?-instance-method","name":"uppercase?","doc":"Returns `true` if this char is an uppercase letter.\n\n```\n'H'.uppercase? # => true\n'Á'.uppercase? # => true\n'c'.uppercase? # => false\n'.'.uppercase? # => false\n```","summary":"<p>Returns <code>true</code> if this char is an uppercase letter.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":194,"url":null},"def":{"name":"uppercase?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ascii? ? ascii_uppercase? : Unicode.uppercase?(self)"}},{"id":"whitespace?-instance-method","html_id":"whitespace?-instance-method","name":"whitespace?","doc":"Returns `true` if this char is a whitespace according to unicode.\n\n```\n' '.whitespace?  # => true\n'\\t'.whitespace? # => true\n'b'.whitespace?  # => false\n```","summary":"<p>Returns <code>true</code> if this char is a whitespace according to unicode.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char.cr","line_number":260,"url":null},"def":{"name":"whitespace?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"ascii? ? ascii_whitespace? : Unicode.whitespace?(self)"}}],"macros":[],"types":[{"html_id":"Crystal/Char/Reader","path":"Char/Reader.html","kind":"struct","full_name":"Char::Reader","name":"Reader","abstract":false,"superclass":{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"Crystal/Enumerable","kind":"module","full_name":"Enumerable","name":"Enumerable"},{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[{"html_id":"Crystal/Enumerable","kind":"module","full_name":"Enumerable","name":"Enumerable"}],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Char","kind":"struct","full_name":"Char","name":"Char"},"doc":"A `Char::Reader` allows iterating a `String` by Chars.\n\nAs soon as you instantiate a `Char::Reader` it will decode the first\nchar in the `String`, which can be accessed by invoking `current_char`.\nAt this point `pos`, the current position in the string, will equal zero.\nSuccessive calls to `next_char` return the next chars in the string,\nadvancing `pos`.\n\nNote that the null character `'\\0'` will be returned in `current_char` when\nthe end is reached (as well as when the string is empty). Thus, `has_next?`\nwill return `false` only when `pos` is equal to the string's bytesize, in which\ncase `current_char` will always be `'\\0'`.","summary":"<p>A <code><a href=\"../Char/Reader.html\">Char::Reader</a></code> allows iterating a <code><a href=\"../String.html\">String</a></code> by Chars.</p>","class_methods":[],"constructors":[{"id":"new(string:String,pos=0)-class-method","html_id":"new(string:String,pos=0)-class-method","name":"new","doc":"Creates a reader with the specified *string* positioned at\nbyte index *pos*.","summary":"<p>Creates a reader with the specified <em>string</em> positioned at byte index <em>pos</em>.</p>","abstract":false,"args":[{"name":"string","doc":null,"default_value":"","external_name":"string","restriction":"String"},{"name":"pos","doc":null,"default_value":"0","external_name":"pos","restriction":""}],"args_string":"(string : String, pos = <span class=\"n\">0</span>)","args_html":"(string : <a href=\"../String.html\">String</a>, pos = <span class=\"n\">0</span>)","location":{"filename":"src/char/reader.cr","line_number":58,"url":null},"def":{"name":"new","args":[{"name":"string","doc":null,"default_value":"","external_name":"string","restriction":"String"},{"name":"pos","doc":null,"default_value":"0","external_name":"pos","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(string, pos)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(*,at_endstring:String)-class-method","html_id":"new(*,at_endstring:String)-class-method","name":"new","doc":"Creates a reader that will be positioned at the last char\nof the given string.","summary":"<p>Creates a reader that will be positioned at the last char of the given string.</p>","abstract":false,"args":[{"name":"","doc":null,"default_value":"","external_name":"","restriction":""},{"name":"string","doc":null,"default_value":"","external_name":"at_end","restriction":"String"}],"args_string":"(*, at_end string : String)","args_html":"(*, at_end string : <a href=\"../String.html\">String</a>)","location":{"filename":"src/char/reader.cr","line_number":68,"url":null},"def":{"name":"new","args":[{"name":"","doc":null,"default_value":"","external_name":"","restriction":""},{"name":"string","doc":null,"default_value":"","external_name":"at_end","restriction":"String"}],"double_splat":null,"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(at_end: string)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"current_char:Char-instance-method","html_id":"current_char:Char-instance-method","name":"current_char","doc":"Returns the current character.\n\n```\nreader = Char::Reader.new(\"ab\")\nreader.current_char # => 'a'\nreader.next_char\nreader.current_char # => 'b'\n```","summary":"<p>Returns the current character.</p>","abstract":false,"args":[],"args_string":" : Char","args_html":" : <a href=\"../Char.html\">Char</a>","location":{"filename":"src/char/reader.cr","line_number":28,"url":null},"def":{"name":"current_char","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Char","visibility":"Public","body":"@current_char"}},{"id":"current_char_width:Int32-instance-method","html_id":"current_char_width:Int32-instance-method","name":"current_char_width","doc":"Returns the size of the `#current_char` (in bytes) as if it were encoded in UTF-8.\n\n```\nreader = Char::Reader.new(\"aé\")\nreader.current_char_width # => 1\nreader.next_char\nreader.current_char_width # => 2\n```","summary":"<p>Returns the size of the <code><a href=\"../Char/Reader.html#current_char:Char-instance-method\">#current_char</a></code> (in bytes) as if it were encoded in UTF-8.</p>","abstract":false,"args":[],"args_string":" : Int32","args_html":" : <a href=\"../Int32.html\">Int32</a>","location":{"filename":"src/char/reader.cr","line_number":38,"url":null},"def":{"name":"current_char_width","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":"@current_char_width"}},{"id":"each(&):Nil-instance-method","html_id":"each(&):Nil-instance-method","name":"each","doc":"Yields successive characters from `#string` starting from `#pos`.\n\n```\nreader = Char::Reader.new(\"abc\")\nreader.next_char\nreader.each do |c|\n  puts c.upcase\nend\n```\n\n``` text\nB\nC\n```","summary":"<p>Yields successive characters from <code><a href=\"../Char/Reader.html#string:String-instance-method\">#string</a></code> starting from <code><a href=\"../Char/Reader.html#pos:Int32-instance-method\">#pos</a></code>.</p>","abstract":false,"args":[],"args_string":"(&) : Nil","args_html":"(&) : <a href=\"../Nil.html\">Nil</a>","location":{"filename":"src/char/reader.cr","line_number":179,"url":null},"def":{"name":"each","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"while has_next?\n  yield current_char\n  @pos = @pos + @current_char_width\n  decode_current_char\nend"}},{"id":"error:UInt8?-instance-method","html_id":"error:UInt8?-instance-method","name":"error","doc":"If there was an error decoding the current char because\nof an invalid UTF-8 byte sequence, returns the byte\nthat produced the invalid encoding. Returns `0` if the char would've been\nout of bounds. Otherwise returns `nil`.","summary":"<p>If there was an error decoding the current char because of an invalid UTF-8 byte sequence, returns the byte that produced the invalid encoding.</p>","abstract":false,"args":[],"args_string":" : UInt8?","args_html":" : <a href=\"../UInt8.html\">UInt8</a>?","location":{"filename":"src/char/reader.cr","line_number":54,"url":null},"def":{"name":"error","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt8 | ::Nil","visibility":"Public","body":"@error"}},{"id":"has_next?-instance-method","html_id":"has_next?-instance-method","name":"has_next?","doc":"Returns `true` if there is a character left to read.\nThe terminating byte `'\\0'` is considered a valid character\nby this method.\n\n```\nreader = Char::Reader.new(\"a\")\nreader.has_next?      # => true\nreader.peek_next_char # => '\\0'\n```","summary":"<p>Returns <code>true</code> if there is a character left to read.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char/reader.cr","line_number":85,"url":null},"def":{"name":"has_next?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"!@end"}},{"id":"has_previous?-instance-method","html_id":"has_previous?-instance-method","name":"has_previous?","doc":"Returns `true` if there are characters before\nthe current one.","summary":"<p>Returns <code>true</code> if there are characters before the current one.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char/reader.cr","line_number":130,"url":null},"def":{"name":"has_previous?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@pos > 0"}},{"id":"next_char-instance-method","html_id":"next_char-instance-method","name":"next_char","doc":"Reads the next character in the string,\n`#pos` is incremented. Raises `IndexError` if the reader is\nat the end of the `#string`.\n\n```\nreader = Char::Reader.new(\"ab\")\nreader.next_char # => 'b'\n```","summary":"<p>Reads the next character in the string, <code><a href=\"../Char/Reader.html#pos:Int32-instance-method\">#pos</a></code> is incremented.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char/reader.cr","line_number":97,"url":null},"def":{"name":"next_char","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@pos = @pos + @current_char_width\nif @pos > @string.bytesize\n  raise(IndexError.new)\nend\ndecode_current_char\n"}},{"id":"peek_next_char-instance-method","html_id":"peek_next_char-instance-method","name":"peek_next_char","doc":"Returns the next character in the `#string`\nwithout incrementing `#pos`.\nRaises `IndexError` if the reader is at\nthe end of the `#string`.\n\n```\nreader = Char::Reader.new(\"ab\")\nreader.peek_next_char # => 'b'\nreader.current_char   # => 'a'\n```","summary":"<p>Returns the next character in the <code><a href=\"../Char/Reader.html#string:String-instance-method\">#string</a></code> without incrementing <code><a href=\"../Char/Reader.html#pos:Int32-instance-method\">#pos</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/char/reader.cr","line_number":116,"url":null},"def":{"name":"peek_next_char","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"next_pos = @pos + @current_char_width\nif next_pos > @string.bytesize\n  raise(IndexError.new)\nend\ndecode_char_at(next_pos) do |code_point|\n  code_point.unsafe_chr\nend\n"}},{"id":"pos:Int32-instance-method","html_id":"pos:Int32-instance-method","name":"pos","doc":"Returns the position of the current character.\n\n```\nreader = Char::Reader.new(\"ab\")\nreader.pos # => 0\nreader.next_char\nreader.pos # => 1\n```","summary":"<p>Returns the position of the current character.</p>","abstract":false,"args":[],"args_string":" : Int32","args_html":" : <a href=\"../Int32.html\">Int32</a>","location":{"filename":"src/char/reader.cr","line_number":48,"url":null},"def":{"name":"pos","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":"@pos"}},{"id":"pos=(pos)-instance-method","html_id":"pos=(pos)-instance-method","name":"pos=","doc":"Sets `#pos` to *pos*.\n\n```\nreader = Char::Reader.new(\"abc\")\nreader.next_char\nreader.next_char\nreader.pos = 0\nreader.current_char # => 'a'\n```","summary":"<p>Sets <code><a href=\"../Char/Reader.html#pos:Int32-instance-method\">#pos</a></code> to <em>pos</em>.</p>","abstract":false,"args":[{"name":"pos","doc":null,"default_value":"","external_name":"pos","restriction":""}],"args_string":"(pos)","args_html":"(pos)","location":{"filename":"src/char/reader.cr","line_number":155,"url":null},"def":{"name":"pos=","args":[{"name":"pos","doc":null,"default_value":"","external_name":"pos","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if pos > @string.bytesize\n  raise(IndexError.new)\nend\n@pos = pos\ndecode_current_char\npos\n"}},{"id":"previous_char:Char-instance-method","html_id":"previous_char:Char-instance-method","name":"previous_char","doc":"Returns the previous character, `#pos`\nis decremented.\nRaises `IndexError` if the reader is at the beginning of\nthe `#string`","summary":"<p>Returns the previous character, <code><a href=\"../Char/Reader.html#pos:Int32-instance-method\">#pos</a></code> is decremented.</p>","abstract":false,"args":[],"args_string":" : Char","args_html":" : <a href=\"../Char.html\">Char</a>","location":{"filename":"src/char/reader.cr","line_number":138,"url":null},"def":{"name":"previous_char","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Char","visibility":"Public","body":"if has_previous?\nelse\n  raise(IndexError.new)\nend\ndecode_previous_char.as(Char)\n"}},{"id":"string:String-instance-method","html_id":"string:String-instance-method","name":"string","doc":"Returns the reader's String.","summary":"<p>Returns the reader's String.</p>","abstract":false,"args":[],"args_string":" : String","args_html":" : <a href=\"../String.html\">String</a>","location":{"filename":"src/char/reader.cr","line_number":18,"url":null},"def":{"name":"string","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"@string"}}],"macros":[],"types":[]}]},{"html_id":"Crystal/Class","path":"Class.html","kind":"class","full_name":"Class","name":"Class","abstract":true,"superclass":{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},"ancestors":[{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":null,"summary":null,"class_methods":[{"id":"T.class):BoolforallT-class-method","html_id":"T.class):BoolforallT-class-method","name":"<","doc":"Returns whether this class inherits or includes *other*.\n\n```\nInt32 < Number  # => true\nInt32 < Value   # => true\nInt32 < Int32   # => false\nInt32 <= String # => false\n```","summary":"<p>Returns whether this class inherits or includes <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"args_string":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) : Bool forall T","args_html":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) : <a href=\"Bool.html\">Bool</a> forall T","location":{"filename":"src/class.cr","line_number":29,"url":null},"def":{"name":"<","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"{% @type %}\nother._gt(self)\n"}},{"id":"T.class):BoolforallT-class-method","html_id":"T.class):BoolforallT-class-method","name":"<=","doc":"Returns whether this class inherits or includes *other*, or\nis equal to *other*.\n\n```\nInt32 < Number  # => true\nInt32 < Value   # => true\nInt32 <= Int32  # => true\nInt32 <= String # => false\n```","summary":"<p>Returns whether this class inherits or includes <em>other</em>, or is equal to <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"args_string":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) : Bool forall T","args_html":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) : <a href=\"Bool.html\">Bool</a> forall T","location":{"filename":"src/class.cr","line_number":44,"url":null},"def":{"name":"<=","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"{% @type %}\nother._gte(self)\n"}},{"id":"==(other:Class):Bool-class-method","html_id":"==(other:Class):Bool-class-method","name":"==","doc":"Returns whether this class is the same as *other*.\n\n```\nInt32 == Int32  # => true\nInt32 == String # => false\n```","summary":"<p>Returns whether this class is the same as <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Class"}],"args_string":"(other : Class) : Bool","args_html":"(other : <a href=\"Class.html\">Class</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/class.cr","line_number":17,"url":null},"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"crystal_type_id == other.crystal_type_id"}},{"id":"===(other)-class-method","html_id":"===(other)-class-method","name":"===","doc":"Case equality.\n\nThe `===` method is used in a `case ... when ... end` expression.\n\nFor example, this code:\n\n```\ncase value\nwhen x\n  # something when x\nwhen y\n  # something when y\nend\n```\n\nIs equivalent to this code:\n\n```\nif x === value\n  # something when x\nelsif y === value\n  # something when y\nend\n```\n\nObject simply implements `===` by invoking `==`, but subclasses\n(notably `Regex`) can override it to provide meaningful case-equality semantics.","summary":"<p>Case equality.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"args_string":"(other)","args_html":"(other)","location":{"filename":"src/class.cr","line_number":97,"url":null},"def":{"name":"===","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"other.is_a?(self)"}},{"id":">(other:T.class)forallT-class-method","html_id":">(other:T.class)forallT-class-method","name":">","doc":"Returns whether *other* inherits or includes `self`.\n\n```\nNumber > Int32  # => true\nNumber > Number # => false\nNumber > Object # => false\n```","summary":"<p>Returns whether <em>other</em> inherits or includes <code>self</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"args_string":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) forall T","args_html":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) forall T","location":{"filename":"src/class.cr","line_number":57,"url":null},"def":{"name":">","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% @type %}\nother._lt(self)\n"}},{"id":">=(other:T.class)forallT-class-method","html_id":">=(other:T.class)forallT-class-method","name":">=","doc":"Returns whether *other* inherits or includes `self`, or is equal\nto `self`.\n\n```\nNumber >= Int32  # => true\nNumber >= Number # => true\nNumber >= Object # => false\n```","summary":"<p>Returns whether <em>other</em> inherits or includes <code>self</code>, or is equal to <code>self</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"args_string":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) forall T","args_html":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) forall T","location":{"filename":"src/class.cr","line_number":71,"url":null},"def":{"name":">=","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% @type %}\nother._lte(self)\n"}},{"id":"clone-class-method","html_id":"clone-class-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/class.cr","line_number":156,"url":null},"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"dup-class-method","html_id":"dup-class-method","name":"dup","doc":"Returns a shallow copy of this object.\n\nBecause `Value` is a value type, this method returns `self`,\nwhich already involves a shallow copy of this object because\nvalue types are passed by value.","summary":"<p>Returns a shallow copy of this object.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/class.cr","line_number":152,"url":null},"def":{"name":"dup","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"hash(hasher)-class-method","html_id":"hash(hasher)-class-method","name":"hash","doc":"See `Object#hash(hasher)`","summary":"<p>See <code><a href=\"Object.html#hash(hasher)-instance-method\">Object#hash(hasher)</a></code></p>","abstract":false,"args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"args_string":"(hasher)","args_html":"(hasher)","location":{"filename":"src/class.cr","line_number":7,"url":null},"def":{"name":"hash","args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"hasher.class(self)"}},{"id":"inspect(io:IO):Nil-class-method","html_id":"inspect(io:IO):Nil-class-method","name":"inspect","doc":"Appends a string representation of this object\nto the given `IO` object.\n\nSimilar to `to_s(io)`, but usually appends more information\nabout this object.\nSee `#inspect`.","summary":"<p>Appends a string representation of this object to the given <code><a href=\"IO.html\">IO</a></code> object.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/class.cr","line_number":2,"url":null},"def":{"name":"inspect","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"to_s(io)"}},{"id":"name:String-class-method","html_id":"name:String-class-method","name":"name","doc":"Returns the name of this class.\n\n```\nString.name # => \"String\"\n```","summary":"<p>Returns the name of this class.</p>","abstract":false,"args":[],"args_string":" : String","args_html":" : <a href=\"String.html\">String</a>","location":{"filename":"src/class.cr","line_number":106,"url":null},"def":{"name":"name","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"{{ @type.name.stringify }}"}},{"id":"nilable?-class-method","html_id":"nilable?-class-method","name":"nilable?","doc":"Returns `true` if this class is `Nil`.\n\n```\nInt32.nilable? # => false\nNil.nilable?   # => true\n```","summary":"<p>Returns <code>true</code> if this class is <code><a href=\"Nil.html\">Nil</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/class.cr","line_number":144,"url":null},"def":{"name":"nilable?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == ::Nil"}},{"id":"to_s(io:IO):Nil-class-method","html_id":"to_s(io:IO):Nil-class-method","name":"to_s","doc":"Appends a `String` representation of this object\nto the given `IO` object.\n\nAn object must never append itself to the io argument,\nas this will in turn call `to_s(io)` on it.","summary":"<p>Appends a <code><a href=\"String.html\">String</a></code> representation of this object to the given <code><a href=\"IO.html\">IO</a></code> object.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/class.cr","line_number":148,"url":null},"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << ({{ @type.name.stringify }})"}},{"id":"|(other:U.class)forallU-class-method","html_id":"|(other:U.class)forallU-class-method","name":"|","doc":"Returns the union type of `self` and *other*.\n\n```\nInt32 | Char # => (Int32 | Char)\n```","summary":"<p>Returns the union type of <code>self</code> and <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"U.class"}],"args_string":"(other : <span class=\"t\">U</span>.<span class=\"k\">class</span>) forall U","args_html":"(other : <span class=\"t\">U</span>.<span class=\"k\">class</span>) forall U","location":{"filename":"src/class.cr","line_number":132,"url":null},"def":{"name":"|","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"U.class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"t = uninitialized self\nu = uninitialized U\ntypeof(t, u)\n"}}],"constructors":[{"id":"cast(other):self-class-method","html_id":"cast(other):self-class-method","name":"cast","doc":"Casts *other* to this class.\n\nThis is the same as using `as`, but allows the class to be passed around as\nan argument. See the\n[documentation on as](//crystal-lang.org/docs/syntax_and_semantics/as.html)\nfor more information.\n\n```\nklass = Int32\nnumber = [99, \"str\"][0]\ntypeof(number)             # => (String | Int32)\ntypeof(klass.cast(number)) # => Int32\n```","summary":"<p>Casts <em>other</em> to this class.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"args_string":"(other) : <span class=\"k\">self</span>","args_html":"(other) : <span class=\"k\">self</span>","location":{"filename":"src/class.cr","line_number":123,"url":null},"def":{"name":"cast","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"self","visibility":"Public","body":"other.as(self)"}}],"instance_methods":[{"id":"T.class):BoolforallT-instance-method","html_id":"T.class):BoolforallT-instance-method","name":"<","doc":"Returns whether this class inherits or includes *other*.\n\n```\nInt32 < Number  # => true\nInt32 < Value   # => true\nInt32 < Int32   # => false\nInt32 <= String # => false\n```","summary":"<p>Returns whether this class inherits or includes <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"args_string":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) : Bool forall T","args_html":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) : <a href=\"Bool.html\">Bool</a> forall T","location":{"filename":"src/class.cr","line_number":29,"url":null},"def":{"name":"<","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"{% @type %}\nother._gt(self)\n"}},{"id":"T.class):BoolforallT-instance-method","html_id":"T.class):BoolforallT-instance-method","name":"<=","doc":"Returns whether this class inherits or includes *other*, or\nis equal to *other*.\n\n```\nInt32 < Number  # => true\nInt32 < Value   # => true\nInt32 <= Int32  # => true\nInt32 <= String # => false\n```","summary":"<p>Returns whether this class inherits or includes <em>other</em>, or is equal to <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"args_string":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) : Bool forall T","args_html":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) : <a href=\"Bool.html\">Bool</a> forall T","location":{"filename":"src/class.cr","line_number":44,"url":null},"def":{"name":"<=","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"{% @type %}\nother._gte(self)\n"}},{"id":"==(other:Class):Bool-instance-method","html_id":"==(other:Class):Bool-instance-method","name":"==","doc":"Returns whether this class is the same as *other*.\n\n```\nInt32 == Int32  # => true\nInt32 == String # => false\n```","summary":"<p>Returns whether this class is the same as <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Class"}],"args_string":"(other : Class) : Bool","args_html":"(other : <a href=\"Class.html\">Class</a>) : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/class.cr","line_number":17,"url":null},"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"crystal_type_id == other.crystal_type_id"}},{"id":"===(other)-instance-method","html_id":"===(other)-instance-method","name":"===","doc":"Case equality.\n\nThe `===` method is used in a `case ... when ... end` expression.\n\nFor example, this code:\n\n```\ncase value\nwhen x\n  # something when x\nwhen y\n  # something when y\nend\n```\n\nIs equivalent to this code:\n\n```\nif x === value\n  # something when x\nelsif y === value\n  # something when y\nend\n```\n\nObject simply implements `===` by invoking `==`, but subclasses\n(notably `Regex`) can override it to provide meaningful case-equality semantics.","summary":"<p>Case equality.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"args_string":"(other)","args_html":"(other)","location":{"filename":"src/class.cr","line_number":97,"url":null},"def":{"name":"===","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"other.is_a?(self)"}},{"id":">(other:T.class)forallT-instance-method","html_id":">(other:T.class)forallT-instance-method","name":">","doc":"Returns whether *other* inherits or includes `self`.\n\n```\nNumber > Int32  # => true\nNumber > Number # => false\nNumber > Object # => false\n```","summary":"<p>Returns whether <em>other</em> inherits or includes <code>self</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"args_string":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) forall T","args_html":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) forall T","location":{"filename":"src/class.cr","line_number":57,"url":null},"def":{"name":">","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% @type %}\nother._lt(self)\n"}},{"id":">=(other:T.class)forallT-instance-method","html_id":">=(other:T.class)forallT-instance-method","name":">=","doc":"Returns whether *other* inherits or includes `self`, or is equal\nto `self`.\n\n```\nNumber >= Int32  # => true\nNumber >= Number # => true\nNumber >= Object # => false\n```","summary":"<p>Returns whether <em>other</em> inherits or includes <code>self</code>, or is equal to <code>self</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"args_string":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) forall T","args_html":"(other : <span class=\"t\">T</span>.<span class=\"k\">class</span>) forall T","location":{"filename":"src/class.cr","line_number":71,"url":null},"def":{"name":">=","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T.class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% @type %}\nother._lte(self)\n"}},{"id":"cast(other):self-instance-method","html_id":"cast(other):self-instance-method","name":"cast","doc":"Casts *other* to this class.\n\nThis is the same as using `as`, but allows the class to be passed around as\nan argument. See the\n[documentation on as](//crystal-lang.org/docs/syntax_and_semantics/as.html)\nfor more information.\n\n```\nklass = Int32\nnumber = [99, \"str\"][0]\ntypeof(number)             # => (String | Int32)\ntypeof(klass.cast(number)) # => Int32\n```","summary":"<p>Casts <em>other</em> to this class.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"args_string":"(other) : <span class=\"k\">self</span>","args_html":"(other) : <span class=\"k\">self</span>","location":{"filename":"src/class.cr","line_number":123,"url":null},"def":{"name":"cast","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"self","visibility":"Public","body":"other.as(self)"}},{"id":"clone-instance-method","html_id":"clone-instance-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/class.cr","line_number":156,"url":null},"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"dup-instance-method","html_id":"dup-instance-method","name":"dup","doc":"Returns a shallow copy of this object.\n\nBecause `Value` is a value type, this method returns `self`,\nwhich already involves a shallow copy of this object because\nvalue types are passed by value.","summary":"<p>Returns a shallow copy of this object.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/class.cr","line_number":152,"url":null},"def":{"name":"dup","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"hash(hasher)-instance-method","html_id":"hash(hasher)-instance-method","name":"hash","doc":"See `Object#hash(hasher)`","summary":"<p>See <code><a href=\"Object.html#hash(hasher)-instance-method\">Object#hash(hasher)</a></code></p>","abstract":false,"args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"args_string":"(hasher)","args_html":"(hasher)","location":{"filename":"src/class.cr","line_number":7,"url":null},"def":{"name":"hash","args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"hasher.class(self)"}},{"id":"inspect(io:IO):Nil-instance-method","html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Appends a string representation of this object\nto the given `IO` object.\n\nSimilar to `to_s(io)`, but usually appends more information\nabout this object.\nSee `#inspect`.","summary":"<p>Appends a string representation of this object to the given <code><a href=\"IO.html\">IO</a></code> object.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/class.cr","line_number":2,"url":null},"def":{"name":"inspect","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"to_s(io)"}},{"id":"name:String-instance-method","html_id":"name:String-instance-method","name":"name","doc":"Returns the name of this class.\n\n```\nString.name # => \"String\"\n```","summary":"<p>Returns the name of this class.</p>","abstract":false,"args":[],"args_string":" : String","args_html":" : <a href=\"String.html\">String</a>","location":{"filename":"src/class.cr","line_number":106,"url":null},"def":{"name":"name","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"{{ @type.name.stringify }}"}},{"id":"nilable?-instance-method","html_id":"nilable?-instance-method","name":"nilable?","doc":"Returns `true` if this class is `Nil`.\n\n```\nInt32.nilable? # => false\nNil.nilable?   # => true\n```","summary":"<p>Returns <code>true</code> if this class is <code><a href=\"Nil.html\">Nil</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/class.cr","line_number":144,"url":null},"def":{"name":"nilable?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == ::Nil"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Appends a `String` representation of this object\nto the given `IO` object.\n\nAn object must never append itself to the io argument,\nas this will in turn call `to_s(io)` on it.","summary":"<p>Appends a <code><a href=\"String.html\">String</a></code> representation of this object to the given <code><a href=\"IO.html\">IO</a></code> object.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/class.cr","line_number":148,"url":null},"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << ({{ @type.name.stringify }})"}},{"id":"|(other:U.class)forallU-instance-method","html_id":"|(other:U.class)forallU-instance-method","name":"|","doc":"Returns the union type of `self` and *other*.\n\n```\nInt32 | Char # => (Int32 | Char)\n```","summary":"<p>Returns the union type of <code>self</code> and <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"U.class"}],"args_string":"(other : <span class=\"t\">U</span>.<span class=\"k\">class</span>) forall U","args_html":"(other : <span class=\"t\">U</span>.<span class=\"k\">class</span>) forall U","location":{"filename":"src/class.cr","line_number":132,"url":null},"def":{"name":"|","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"U.class"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"t = uninitialized self\nu = uninitialized U\ntypeof(t, u)\n"}}],"macros":[],"types":[]},{"html_id":"Crystal/Colorize","path":"Colorize.html","kind":"module","full_name":"Colorize","name":"Colorize","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"With Colorize you can change the fore- and background colors and text decorations when rendering text\non terminals supporting ANSI escape codes. It adds the `colorize` method to `Object` and thus all classes\nas its main interface, which calls `to_s` and surrounds it with the necessary escape codes\nwhen it comes to obtaining a string representation of the object.\n\nIts first argument changes the foreground color:\n```\nrequire \"colorize\"\n\n\"foo\".colorize(:green)\n100.colorize(:red)\n[1, 2, 3].colorize(:blue)\n```\n\nThere are alternative ways to change the foreground color:\n```\nrequire \"colorize\"\n\n\"foo\".colorize.fore(:green)\n\"foo\".colorize.green\n```\n\nTo change the background color, the following methods are available:\n```\nrequire \"colorize\"\n\n\"foo\".colorize.back(:green)\n\"foo\".colorize.on(:green)\n\"foo\".colorize.on_green\n```\n\nYou can also pass an RGB color to `colorize`:\n```\nrequire \"colorize\"\n\n\"foo\".colorize(Colorize::ColorRGB.new(0, 255, 255)) # => \"foo\" in aqua\n```\n\nOr an 8-bit color:\n```\nrequire \"colorize\"\n\n\"foo\".colorize(Colorize::Color256.new(208)) # => \"foo\" in orange\n```\n\nIt's also possible to change the text decoration:\n```\nrequire \"colorize\"\n\n\"foo\".colorize.mode(:underline)\n\"foo\".colorize.underline\n```\n\nThe `colorize` method returns a `Colorize::Object` instance,\nwhich allows chaining methods together:\n```\nrequire \"colorize\"\n\n\"foo\".colorize.fore(:yellow).back(:blue).mode(:underline)\n```\n\nWith the `toggle` method you can temporarily disable adding the escape codes.\nSettings of the instance are preserved however and can be turned back on later:\n```\nrequire \"colorize\"\n\n\"foo\".colorize(:red).toggle(false)              # => \"foo\" without color\n\"foo\".colorize(:red).toggle(false).toggle(true) # => \"foo\" in red\n```\n\nThe color `:default` will just leave the object as it is (but it's an `Colorize::Object(String)` then).\nThat's handy in for example conditions:\n```\nrequire \"colorize\"\n\n\"foo\".colorize(some_bool ? :green : :default)\n```\n\nAvailable colors are:\n```\n:default\n:black\n:red\n:green\n:yellow\n:blue\n:magenta\n:cyan\n:light_gray\n:dark_gray\n:light_red\n:light_green\n:light_yellow\n:light_blue\n:light_magenta\n:light_cyan\n:white\n```\n\nAvailable text decorations are:\n```\n:bold\n:bright\n:dim\n:underline\n:blink\n:reverse\n:hidden\n```","summary":"<p>With Colorize you can change the fore- and background colors and text decorations when rendering text on terminals supporting ANSI escape codes.</p>","class_methods":[{"id":"enabled=(enabled:Bool)-class-method","html_id":"enabled=(enabled:Bool)-class-method","name":"enabled=","doc":"If this value is `true`, `Colorize::Object` is enabled by default.\nBut if this value is `false`, `Colorize::Object` is disabled.\n\nThe default value is `true`.\n\n```\nrequire \"colorize\"\n\nColorize.enabled = true\n\"hello\".colorize.red.to_s # => \"\\e[31mhello\\e[0m\"\n\nColorize.enabled = false\n\"hello\".colorize.red.to_s # => \"hello\"\n```","summary":"<p>If this value is <code>true</code>, <code><a href=\"Colorize/Object.html\">Colorize::Object</a></code> is enabled by default.</p>","abstract":false,"args":[{"name":"enabled","doc":null,"default_value":"","external_name":"enabled","restriction":"Bool"}],"args_string":"(enabled : Bool)","args_html":"(enabled : <a href=\"Bool.html\">Bool</a>)","location":{"filename":"src/colorize.cr","line_number":125,"url":null},"def":{"name":"enabled=","args":[{"name":"enabled","doc":null,"default_value":"","external_name":"enabled","restriction":"Bool"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@@enabled = enabled"}},{"id":"enabled?:Bool-class-method","html_id":"enabled?:Bool-class-method","name":"enabled?","doc":"If this value is `true`, `Colorize::Object` is enabled by default.\nBut if this value is `false`, `Colorize::Object` is disabled.\n\nThe default value is `true`.\n\n```\nrequire \"colorize\"\n\nColorize.enabled = true\n\"hello\".colorize.red.to_s # => \"\\e[31mhello\\e[0m\"\n\nColorize.enabled = false\n\"hello\".colorize.red.to_s # => \"hello\"\n```","summary":"<p>If this value is <code>true</code>, <code><a href=\"Colorize/Object.html\">Colorize::Object</a></code> is enabled by default.</p>","abstract":false,"args":[],"args_string":" : Bool","args_html":" : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/colorize.cr","line_number":125,"url":null},"def":{"name":"enabled?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"@@enabled"}},{"id":"on_tty_only!-class-method","html_id":"on_tty_only!-class-method","name":"on_tty_only!","doc":"Makes `Colorize.enabled` `true` if and only if both of `STDOUT.tty?`\nand `STDERR.tty?` are `true` and the tty is not considered a dumb terminal.\nThis is determined by the environment variable called `TERM`.\nIf `TERM=dumb`, color won't be enabled.","summary":"<p>Makes <code>Colorize.enabled</code> <code>true</code> if and only if both of <code>STDOUT.tty?</code> and <code>STDERR.tty?</code> are <code>true</code> and the tty is not considered a dumb terminal.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":131,"url":null},"def":{"name":"on_tty_only!","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self.enabled = (STDOUT.tty? && STDERR.tty?) && (ENV[\"TERM\"]? != \"dumb\")"}},{"id":"reset(io=STDOUT)-class-method","html_id":"reset(io=STDOUT)-class-method","name":"reset","doc":null,"summary":null,"abstract":false,"args":[{"name":"io","doc":null,"default_value":"STDOUT","external_name":"io","restriction":""}],"args_string":"(io = <span class=\"t\">STDOUT</span>)","args_html":"(io = <span class=\"t\">STDOUT</span>)","location":{"filename":"src/colorize.cr","line_number":135,"url":null},"def":{"name":"reset","args":[{"name":"io","doc":null,"default_value":"STDOUT","external_name":"io","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if enabled?\n  io << \"\\e[0m\"\nend"}},{"id":"with-class-method","html_id":"with-class-method","name":"with","doc":"Helper method to use colorize with `IO`.\n\n```\nio = IO::Memory.new\nio << \"not-green\"\nColorize.with.green.bold.surround(io) do\n  io << \"green and bold if Colorize.enabled\"\nend\n```","summary":"<p>Helper method to use colorize with <code><a href=\"IO.html\">IO</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":148,"url":null},"def":{"name":"with","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"\"\".colorize"}}],"constructors":[],"instance_methods":[],"macros":[],"types":[{"html_id":"Crystal/Colorize/Color","path":"Colorize/Color.html","kind":"alias","full_name":"Colorize::Color","name":"Color","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":true,"aliased":"(Colorize::Color256 | Colorize::ColorANSI | Colorize::ColorRGB)","aliased_html":"<a href=\"../Colorize/Color256.html\">Colorize::Color256</a> | <a href=\"../Colorize/ColorANSI.html\">Colorize::ColorANSI</a> | <a href=\"../Colorize/ColorRGB.html\">Colorize::ColorRGB</a>","const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Colorize","kind":"module","full_name":"Colorize","name":"Colorize"},"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"Crystal/Colorize/Color256","path":"Colorize/Color256.html","kind":"struct","full_name":"Colorize::Color256","name":"Color256","abstract":false,"superclass":{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Colorize","kind":"module","full_name":"Colorize","name":"Colorize"},"doc":null,"summary":null,"class_methods":[],"constructors":[{"id":"new(value:UInt8)-class-method","html_id":"new(value:UInt8)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"UInt8"}],"args_string":"(value : UInt8)","args_html":"(value : <a href=\"../UInt8.html\">UInt8</a>)","location":{"filename":"src/colorize.cr","line_number":198,"url":null},"def":{"name":"new","args":[{"name":"value","doc":null,"default_value":"","external_name":"value","restriction":"UInt8"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(value)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"back(io:IO):Nil-instance-method","html_id":"back(io:IO):Nil-instance-method","name":"back","doc":null,"summary":null,"abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../IO.html\">IO</a>) : <a href=\"../Nil.html\">Nil</a>","location":{"filename":"src/colorize.cr","line_number":205,"url":null},"def":{"name":"back","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << \"48;5;\"\nvalue.to_s(io)\n"}},{"id":"clone-instance-method","html_id":"clone-instance-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":198,"url":null},"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self.class.new(@value.clone)"}},{"id":"copy_with(value_value=@value)-instance-method","html_id":"copy_with(value_value=@value)-instance-method","name":"copy_with","doc":null,"summary":null,"abstract":false,"args":[{"name":"_value","doc":null,"default_value":"@value","external_name":"value","restriction":""}],"args_string":"(value _value = @value)","args_html":"(value _value = @value)","location":{"filename":"src/colorize.cr","line_number":198,"url":null},"def":{"name":"copy_with","args":[{"name":"_value","doc":null,"default_value":"@value","external_name":"value","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self.class.new(_value)"}},{"id":"fore(io:IO):Nil-instance-method","html_id":"fore(io:IO):Nil-instance-method","name":"fore","doc":null,"summary":null,"abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../IO.html\">IO</a>) : <a href=\"../Nil.html\">Nil</a>","location":{"filename":"src/colorize.cr","line_number":200,"url":null},"def":{"name":"fore","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << \"38;5;\"\nvalue.to_s(io)\n"}},{"id":"value:UInt8-instance-method","html_id":"value:UInt8-instance-method","name":"value","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : UInt8","args_html":" : <a href=\"../UInt8.html\">UInt8</a>","location":null,"def":{"name":"value","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt8","visibility":"Public","body":"@value"}}],"macros":[],"types":[]},{"html_id":"Crystal/Colorize/ColorANSI","path":"Colorize/ColorANSI.html","kind":"enum","full_name":"Colorize::ColorANSI","name":"ColorANSI","abstract":false,"superclass":null,"ancestors":[{"html_id":"Crystal/Enum","kind":"struct","full_name":"Enum","name":"Enum"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":true,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[{"id":"Default","name":"Default","value":"39","doc":null,"summary":null},{"id":"Black","name":"Black","value":"30","doc":null,"summary":null},{"id":"Red","name":"Red","value":"31","doc":null,"summary":null},{"id":"Green","name":"Green","value":"32","doc":null,"summary":null},{"id":"Yellow","name":"Yellow","value":"33","doc":null,"summary":null},{"id":"Blue","name":"Blue","value":"34","doc":null,"summary":null},{"id":"Magenta","name":"Magenta","value":"35","doc":null,"summary":null},{"id":"Cyan","name":"Cyan","value":"36","doc":null,"summary":null},{"id":"LightGray","name":"LightGray","value":"37","doc":null,"summary":null},{"id":"DarkGray","name":"DarkGray","value":"90","doc":null,"summary":null},{"id":"LightRed","name":"LightRed","value":"91","doc":null,"summary":null},{"id":"LightGreen","name":"LightGreen","value":"92","doc":null,"summary":null},{"id":"LightYellow","name":"LightYellow","value":"93","doc":null,"summary":null},{"id":"LightBlue","name":"LightBlue","value":"94","doc":null,"summary":null},{"id":"LightMagenta","name":"LightMagenta","value":"95","doc":null,"summary":null},{"id":"LightCyan","name":"LightCyan","value":"96","doc":null,"summary":null},{"id":"White","name":"White","value":"97","doc":null,"summary":null}],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Colorize","kind":"module","full_name":"Colorize","name":"Colorize"},"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[{"id":"back(io:IO):Nil-instance-method","html_id":"back(io:IO):Nil-instance-method","name":"back","doc":null,"summary":null,"abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../IO.html\">IO</a>) : <a href=\"../Nil.html\">Nil</a>","location":{"filename":"src/colorize.cr","line_number":193,"url":null},"def":{"name":"back","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"(to_i + 10).to_s(io)"}},{"id":"black?-instance-method","html_id":"black?-instance-method","name":"black?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":172,"url":null},"def":{"name":"black?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == Black"}},{"id":"blue?-instance-method","html_id":"blue?-instance-method","name":"blue?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":176,"url":null},"def":{"name":"blue?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == Blue"}},{"id":"cyan?-instance-method","html_id":"cyan?-instance-method","name":"cyan?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":178,"url":null},"def":{"name":"cyan?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == Cyan"}},{"id":"dark_gray?-instance-method","html_id":"dark_gray?-instance-method","name":"dark_gray?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":180,"url":null},"def":{"name":"dark_gray?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == DarkGray"}},{"id":"default?-instance-method","html_id":"default?-instance-method","name":"default?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":171,"url":null},"def":{"name":"default?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == Default"}},{"id":"fore(io:IO):Nil-instance-method","html_id":"fore(io:IO):Nil-instance-method","name":"fore","doc":null,"summary":null,"abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../IO.html\">IO</a>) : <a href=\"../Nil.html\">Nil</a>","location":{"filename":"src/colorize.cr","line_number":189,"url":null},"def":{"name":"fore","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"to_i.to_s(io)"}},{"id":"green?-instance-method","html_id":"green?-instance-method","name":"green?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":174,"url":null},"def":{"name":"green?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == Green"}},{"id":"light_blue?-instance-method","html_id":"light_blue?-instance-method","name":"light_blue?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":184,"url":null},"def":{"name":"light_blue?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == LightBlue"}},{"id":"light_cyan?-instance-method","html_id":"light_cyan?-instance-method","name":"light_cyan?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":186,"url":null},"def":{"name":"light_cyan?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == LightCyan"}},{"id":"light_gray?-instance-method","html_id":"light_gray?-instance-method","name":"light_gray?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":179,"url":null},"def":{"name":"light_gray?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == LightGray"}},{"id":"light_green?-instance-method","html_id":"light_green?-instance-method","name":"light_green?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":182,"url":null},"def":{"name":"light_green?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == LightGreen"}},{"id":"light_magenta?-instance-method","html_id":"light_magenta?-instance-method","name":"light_magenta?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":185,"url":null},"def":{"name":"light_magenta?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == LightMagenta"}},{"id":"light_red?-instance-method","html_id":"light_red?-instance-method","name":"light_red?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":181,"url":null},"def":{"name":"light_red?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == LightRed"}},{"id":"light_yellow?-instance-method","html_id":"light_yellow?-instance-method","name":"light_yellow?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":183,"url":null},"def":{"name":"light_yellow?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == LightYellow"}},{"id":"magenta?-instance-method","html_id":"magenta?-instance-method","name":"magenta?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":177,"url":null},"def":{"name":"magenta?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == Magenta"}},{"id":"red?-instance-method","html_id":"red?-instance-method","name":"red?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":173,"url":null},"def":{"name":"red?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == Red"}},{"id":"white?-instance-method","html_id":"white?-instance-method","name":"white?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":187,"url":null},"def":{"name":"white?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == White"}},{"id":"yellow?-instance-method","html_id":"yellow?-instance-method","name":"yellow?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":175,"url":null},"def":{"name":"yellow?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == Yellow"}}],"macros":[],"types":[]},{"html_id":"Crystal/Colorize/ColorRGB","path":"Colorize/ColorRGB.html","kind":"struct","full_name":"Colorize::ColorRGB","name":"ColorRGB","abstract":false,"superclass":{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Colorize","kind":"module","full_name":"Colorize","name":"Colorize"},"doc":null,"summary":null,"class_methods":[],"constructors":[{"id":"new(red:UInt8,green:UInt8,blue:UInt8)-class-method","html_id":"new(red:UInt8,green:UInt8,blue:UInt8)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"red","doc":null,"default_value":"","external_name":"red","restriction":"UInt8"},{"name":"green","doc":null,"default_value":"","external_name":"green","restriction":"UInt8"},{"name":"blue","doc":null,"default_value":"","external_name":"blue","restriction":"UInt8"}],"args_string":"(red : UInt8, green : UInt8, blue : UInt8)","args_html":"(red : <a href=\"../UInt8.html\">UInt8</a>, green : <a href=\"../UInt8.html\">UInt8</a>, blue : <a href=\"../UInt8.html\">UInt8</a>)","location":{"filename":"src/colorize.cr","line_number":211,"url":null},"def":{"name":"new","args":[{"name":"red","doc":null,"default_value":"","external_name":"red","restriction":"UInt8"},{"name":"green","doc":null,"default_value":"","external_name":"green","restriction":"UInt8"},{"name":"blue","doc":null,"default_value":"","external_name":"blue","restriction":"UInt8"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(red, green, blue)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"back(io:IO):Nil-instance-method","html_id":"back(io:IO):Nil-instance-method","name":"back","doc":null,"summary":null,"abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../IO.html\">IO</a>) : <a href=\"../Nil.html\">Nil</a>","location":{"filename":"src/colorize.cr","line_number":222,"url":null},"def":{"name":"back","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << \"48;2;\"\n(io << red) << \";\"\n(io << green) << \";\"\nio << blue\n"}},{"id":"blue:UInt8-instance-method","html_id":"blue:UInt8-instance-method","name":"blue","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : UInt8","args_html":" : <a href=\"../UInt8.html\">UInt8</a>","location":null,"def":{"name":"blue","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt8","visibility":"Public","body":"@blue"}},{"id":"clone-instance-method","html_id":"clone-instance-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":211,"url":null},"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self.class.new(@red.clone, @green.clone, @blue.clone)"}},{"id":"copy_with(red_red=@red,green_green=@green,blue_blue=@blue)-instance-method","html_id":"copy_with(red_red=@red,green_green=@green,blue_blue=@blue)-instance-method","name":"copy_with","doc":null,"summary":null,"abstract":false,"args":[{"name":"_red","doc":null,"default_value":"@red","external_name":"red","restriction":""},{"name":"_green","doc":null,"default_value":"@green","external_name":"green","restriction":""},{"name":"_blue","doc":null,"default_value":"@blue","external_name":"blue","restriction":""}],"args_string":"(red _red = @red, green _green = @green, blue _blue = @blue)","args_html":"(red _red = @red, green _green = @green, blue _blue = @blue)","location":{"filename":"src/colorize.cr","line_number":211,"url":null},"def":{"name":"copy_with","args":[{"name":"_red","doc":null,"default_value":"@red","external_name":"red","restriction":""},{"name":"_green","doc":null,"default_value":"@green","external_name":"green","restriction":""},{"name":"_blue","doc":null,"default_value":"@blue","external_name":"blue","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self.class.new(_red, _green, _blue)"}},{"id":"fore(io:IO):Nil-instance-method","html_id":"fore(io:IO):Nil-instance-method","name":"fore","doc":null,"summary":null,"abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../IO.html\">IO</a>) : <a href=\"../Nil.html\">Nil</a>","location":{"filename":"src/colorize.cr","line_number":215,"url":null},"def":{"name":"fore","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << \"38;2;\"\n(io << red) << \";\"\n(io << green) << \";\"\nio << blue\n"}},{"id":"green:UInt8-instance-method","html_id":"green:UInt8-instance-method","name":"green","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : UInt8","args_html":" : <a href=\"../UInt8.html\">UInt8</a>","location":null,"def":{"name":"green","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt8","visibility":"Public","body":"@green"}},{"id":"red:UInt8-instance-method","html_id":"red:UInt8-instance-method","name":"red","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : UInt8","args_html":" : <a href=\"../UInt8.html\">UInt8</a>","location":null,"def":{"name":"red","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt8","visibility":"Public","body":"@red"}}],"macros":[],"types":[]},{"html_id":"Crystal/Colorize/Object","path":"Colorize/Object.html","kind":"struct","full_name":"Colorize::Object(T)","name":"Object","abstract":false,"superclass":{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Colorize","kind":"module","full_name":"Colorize","name":"Colorize"},"doc":null,"summary":null,"class_methods":[],"constructors":[{"id":"new(object:T)-class-method","html_id":"new(object:T)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":"T"}],"args_string":"(object : T)","args_html":"(object : T)","location":{"filename":"src/colorize.cr","line_number":255,"url":null},"def":{"name":"new","args":[{"name":"object","doc":null,"default_value":"","external_name":"object","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = Object(T).allocate\n_.initialize(object)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"back(color:Symbol)-instance-method","html_id":"back(color:Symbol)-instance-method","name":"back","doc":null,"summary":null,"abstract":false,"args":[{"name":"color","doc":null,"default_value":"","external_name":"color","restriction":"Symbol"}],"args_string":"(color : Symbol)","args_html":"(color : <a href=\"../Symbol.html\">Symbol</a>)","location":{"filename":"src/colorize.cr","line_number":296,"url":null},"def":{"name":"back","args":[{"name":"color","doc":null,"default_value":"","external_name":"color","restriction":"Symbol"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% for name in COLORS %}\n      if color == :{{ name.id }}\n        @back = ColorANSI::{{ name.camelcase.id }}\n        return self\n      end\n    {% end %}\nraise(ArgumentError.new(\"Unknown color: #{color}\"))\n"}},{"id":"back(back:Color)-instance-method","html_id":"back(back:Color)-instance-method","name":"back","doc":null,"summary":null,"abstract":false,"args":[{"name":"back","doc":null,"default_value":"","external_name":"back","restriction":"Color"}],"args_string":"(back : Color)","args_html":"(back : <a href=\"../Colorize/Color.html\">Color</a>)","location":{"filename":"src/colorize.cr","line_number":307,"url":null},"def":{"name":"back","args":[{"name":"back","doc":null,"default_value":"","external_name":"back","restriction":"Color"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = back\nself\n"}},{"id":"black-instance-method","html_id":"black-instance-method","name":"black","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"black","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::Black\nself\n"}},{"id":"blink-instance-method","html_id":"blink-instance-method","name":"blink","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":274,"url":null},"def":{"name":"blink","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@mode = @mode | MODE_BLINK_FLAG\nself\n"}},{"id":"blue-instance-method","html_id":"blue-instance-method","name":"blue","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"blue","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::Blue\nself\n"}},{"id":"bold-instance-method","html_id":"bold-instance-method","name":"bold","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":274,"url":null},"def":{"name":"bold","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@mode = @mode | MODE_BOLD_FLAG\nself\n"}},{"id":"bright-instance-method","html_id":"bright-instance-method","name":"bright","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":274,"url":null},"def":{"name":"bright","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@mode = @mode | MODE_BRIGHT_FLAG\nself\n"}},{"id":"cyan-instance-method","html_id":"cyan-instance-method","name":"cyan","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"cyan","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::Cyan\nself\n"}},{"id":"dark_gray-instance-method","html_id":"dark_gray-instance-method","name":"dark_gray","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"dark_gray","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::DarkGray\nself\n"}},{"id":"default-instance-method","html_id":"default-instance-method","name":"default","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"default","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::Default\nself\n"}},{"id":"dim-instance-method","html_id":"dim-instance-method","name":"dim","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":274,"url":null},"def":{"name":"dim","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@mode = @mode | MODE_DIM_FLAG\nself\n"}},{"id":"fore(color:Symbol)-instance-method","html_id":"fore(color:Symbol)-instance-method","name":"fore","doc":null,"summary":null,"abstract":false,"args":[{"name":"color","doc":null,"default_value":"","external_name":"color","restriction":"Symbol"}],"args_string":"(color : Symbol)","args_html":"(color : <a href=\"../Symbol.html\">Symbol</a>)","location":{"filename":"src/colorize.cr","line_number":281,"url":null},"def":{"name":"fore","args":[{"name":"color","doc":null,"default_value":"","external_name":"color","restriction":"Symbol"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% for name in COLORS %}\n      if color == :{{ name.id }}\n        @fore = ColorANSI::{{ name.camelcase.id }}\n        return self\n      end\n    {% end %}\nraise(ArgumentError.new(\"Unknown color: #{color}\"))\n"}},{"id":"fore(fore:Color)-instance-method","html_id":"fore(fore:Color)-instance-method","name":"fore","doc":null,"summary":null,"abstract":false,"args":[{"name":"fore","doc":null,"default_value":"","external_name":"fore","restriction":"Color"}],"args_string":"(fore : Color)","args_html":"(fore : <a href=\"../Colorize/Color.html\">Color</a>)","location":{"filename":"src/colorize.cr","line_number":292,"url":null},"def":{"name":"fore","args":[{"name":"fore","doc":null,"default_value":"","external_name":"fore","restriction":"Color"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = fore\nself\n"}},{"id":"green-instance-method","html_id":"green-instance-method","name":"green","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"green","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::Green\nself\n"}},{"id":"hidden-instance-method","html_id":"hidden-instance-method","name":"hidden","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":274,"url":null},"def":{"name":"hidden","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@mode = @mode | MODE_HIDDEN_FLAG\nself\n"}},{"id":"inspect(io:IO):Nil-instance-method","html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Appends this struct's name and instance variables names and values\nto the given IO.\n\n```\nstruct Point\n  def initialize(@x : Int32, @y : Int32)\n  end\nend\n\np1 = Point.new 1, 2\np1.to_s    # \"Point(@x=1, @y=2)\"\np1.inspect # \"Point(@x=1, @y=2)\"\n```","summary":"<p>Appends this struct's name and instance variables names and values to the given IO.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../IO.html\">IO</a>) : <a href=\"../Nil.html\">Nil</a>","location":{"filename":"src/colorize.cr","line_number":337,"url":null},"def":{"name":"inspect","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"surround(io) do\n  @object.inspect(io)\nend"}},{"id":"light_blue-instance-method","html_id":"light_blue-instance-method","name":"light_blue","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"light_blue","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::LightBlue\nself\n"}},{"id":"light_cyan-instance-method","html_id":"light_cyan-instance-method","name":"light_cyan","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"light_cyan","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::LightCyan\nself\n"}},{"id":"light_gray-instance-method","html_id":"light_gray-instance-method","name":"light_gray","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"light_gray","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::LightGray\nself\n"}},{"id":"light_green-instance-method","html_id":"light_green-instance-method","name":"light_green","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"light_green","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::LightGreen\nself\n"}},{"id":"light_magenta-instance-method","html_id":"light_magenta-instance-method","name":"light_magenta","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"light_magenta","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::LightMagenta\nself\n"}},{"id":"light_red-instance-method","html_id":"light_red-instance-method","name":"light_red","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"light_red","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::LightRed\nself\n"}},{"id":"light_yellow-instance-method","html_id":"light_yellow-instance-method","name":"light_yellow","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"light_yellow","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::LightYellow\nself\n"}},{"id":"magenta-instance-method","html_id":"magenta-instance-method","name":"magenta","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"magenta","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::Magenta\nself\n"}},{"id":"mode(mode:Symbol)-instance-method","html_id":"mode(mode:Symbol)-instance-method","name":"mode","doc":null,"summary":null,"abstract":false,"args":[{"name":"mode","doc":null,"default_value":"","external_name":"mode","restriction":"Symbol"}],"args_string":"(mode : Symbol)","args_html":"(mode : <a href=\"../Symbol.html\">Symbol</a>)","location":{"filename":"src/colorize.cr","line_number":311,"url":null},"def":{"name":"mode","args":[{"name":"mode","doc":null,"default_value":"","external_name":"mode","restriction":"Symbol"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{% for name in MODES %}\n      if mode == :{{ name.id }}\n        @mode |= MODE_{{ name.upcase.id }}_FLAG\n        return self\n      end\n    {% end %}\nraise(ArgumentError.new(\"Unknown mode: #{mode}\"))\n"}},{"id":"on(color:Symbol)-instance-method","html_id":"on(color:Symbol)-instance-method","name":"on","doc":null,"summary":null,"abstract":false,"args":[{"name":"color","doc":null,"default_value":"","external_name":"color","restriction":"Symbol"}],"args_string":"(color : Symbol)","args_html":"(color : <a href=\"../Symbol.html\">Symbol</a>)","location":{"filename":"src/colorize.cr","line_number":322,"url":null},"def":{"name":"on","args":[{"name":"color","doc":null,"default_value":"","external_name":"color","restriction":"Symbol"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"back(color)"}},{"id":"on_black-instance-method","html_id":"on_black-instance-method","name":"on_black","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"on_black","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::Black\nself\n"}},{"id":"on_blue-instance-method","html_id":"on_blue-instance-method","name":"on_blue","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"on_blue","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::Blue\nself\n"}},{"id":"on_cyan-instance-method","html_id":"on_cyan-instance-method","name":"on_cyan","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"on_cyan","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::Cyan\nself\n"}},{"id":"on_dark_gray-instance-method","html_id":"on_dark_gray-instance-method","name":"on_dark_gray","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"on_dark_gray","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::DarkGray\nself\n"}},{"id":"on_default-instance-method","html_id":"on_default-instance-method","name":"on_default","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"on_default","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::Default\nself\n"}},{"id":"on_green-instance-method","html_id":"on_green-instance-method","name":"on_green","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"on_green","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::Green\nself\n"}},{"id":"on_light_blue-instance-method","html_id":"on_light_blue-instance-method","name":"on_light_blue","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"on_light_blue","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::LightBlue\nself\n"}},{"id":"on_light_cyan-instance-method","html_id":"on_light_cyan-instance-method","name":"on_light_cyan","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"on_light_cyan","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::LightCyan\nself\n"}},{"id":"on_light_gray-instance-method","html_id":"on_light_gray-instance-method","name":"on_light_gray","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"on_light_gray","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::LightGray\nself\n"}},{"id":"on_light_green-instance-method","html_id":"on_light_green-instance-method","name":"on_light_green","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"on_light_green","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::LightGreen\nself\n"}},{"id":"on_light_magenta-instance-method","html_id":"on_light_magenta-instance-method","name":"on_light_magenta","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"on_light_magenta","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::LightMagenta\nself\n"}},{"id":"on_light_red-instance-method","html_id":"on_light_red-instance-method","name":"on_light_red","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"on_light_red","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::LightRed\nself\n"}},{"id":"on_light_yellow-instance-method","html_id":"on_light_yellow-instance-method","name":"on_light_yellow","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"on_light_yellow","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::LightYellow\nself\n"}},{"id":"on_magenta-instance-method","html_id":"on_magenta-instance-method","name":"on_magenta","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"on_magenta","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::Magenta\nself\n"}},{"id":"on_red-instance-method","html_id":"on_red-instance-method","name":"on_red","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"on_red","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::Red\nself\n"}},{"id":"on_white-instance-method","html_id":"on_white-instance-method","name":"on_white","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"on_white","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::White\nself\n"}},{"id":"on_yellow-instance-method","html_id":"on_yellow-instance-method","name":"on_yellow","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"on_yellow","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@back = ColorANSI::Yellow\nself\n"}},{"id":"red-instance-method","html_id":"red-instance-method","name":"red","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"red","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::Red\nself\n"}},{"id":"reverse-instance-method","html_id":"reverse-instance-method","name":"reverse","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":274,"url":null},"def":{"name":"reverse","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@mode = @mode | MODE_REVERSE_FLAG\nself\n"}},{"id":"surround(io=STDOUT,&)-instance-method","html_id":"surround(io=STDOUT,&)-instance-method","name":"surround","doc":null,"summary":null,"abstract":false,"args":[{"name":"io","doc":null,"default_value":"STDOUT","external_name":"io","restriction":""}],"args_string":"(io = <span class=\"t\">STDOUT</span>, &)","args_html":"(io = <span class=\"t\">STDOUT</span>, &)","location":{"filename":"src/colorize.cr","line_number":343,"url":null},"def":{"name":"surround","args":[{"name":"io","doc":null,"default_value":"STDOUT","external_name":"io","restriction":""}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"if @enabled\nelse\n  return yield io\nend\nObject.surround(io, to_named_tuple) do |io|\n  yield io\nend\n"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Same as `#inspect(io)`.","summary":"<p>Same as <code><a href=\"../Colorize/Object.html#inspect(io:IO):Nil-instance-method\">#inspect(io)</a></code>.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../IO.html\">IO</a>) : <a href=\"../Nil.html\">Nil</a>","location":{"filename":"src/colorize.cr","line_number":331,"url":null},"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"surround(io) do\n  io << @object\nend"}},{"id":"toggle(flag)-instance-method","html_id":"toggle(flag)-instance-method","name":"toggle","doc":null,"summary":null,"abstract":false,"args":[{"name":"flag","doc":null,"default_value":"","external_name":"flag","restriction":""}],"args_string":"(flag)","args_html":"(flag)","location":{"filename":"src/colorize.cr","line_number":326,"url":null},"def":{"name":"toggle","args":[{"name":"flag","doc":null,"default_value":"","external_name":"flag","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@enabled = !(!flag)\nself\n"}},{"id":"underline-instance-method","html_id":"underline-instance-method","name":"underline","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":274,"url":null},"def":{"name":"underline","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@mode = @mode | MODE_UNDERLINE_FLAG\nself\n"}},{"id":"white-instance-method","html_id":"white-instance-method","name":"white","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"white","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::White\nself\n"}},{"id":"yellow-instance-method","html_id":"yellow-instance-method","name":"yellow","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":262,"url":null},"def":{"name":"yellow","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@fore = ColorANSI::Yellow\nself\n"}}],"macros":[],"types":[]},{"html_id":"Crystal/Colorize/ObjectExtensions","path":"Colorize/ObjectExtensions.html","kind":"module","full_name":"Colorize::ObjectExtensions","name":"ObjectExtensions","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"namespace":{"html_id":"Crystal/Colorize","kind":"module","full_name":"Colorize","name":"Colorize"},"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[{"id":"colorize(fore)-instance-method","html_id":"colorize(fore)-instance-method","name":"colorize","doc":null,"summary":null,"abstract":false,"args":[{"name":"fore","doc":null,"default_value":"","external_name":"fore","restriction":""}],"args_string":"(fore)","args_html":"(fore)","location":{"filename":"src/colorize.cr","line_number":158,"url":null},"def":{"name":"colorize","args":[{"name":"fore","doc":null,"default_value":"","external_name":"fore","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(Colorize::Object.new(self)).fore(fore)"}},{"id":"colorize-instance-method","html_id":"colorize-instance-method","name":"colorize","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/colorize.cr","line_number":154,"url":null},"def":{"name":"colorize","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Colorize::Object.new(self)"}}],"macros":[],"types":[]}]},{"html_id":"Crystal/Comparable","path":"Comparable.html","kind":"module","full_name":"Comparable(T)","name":"Comparable","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[{"html_id":"Crystal/Array","kind":"class","full_name":"Array(T)","name":"Array"},{"html_id":"Crystal/BigDecimal","kind":"struct","full_name":"BigDecimal","name":"BigDecimal"},{"html_id":"Crystal/BigFloat","kind":"struct","full_name":"BigFloat","name":"BigFloat"},{"html_id":"Crystal/BigInt","kind":"struct","full_name":"BigInt","name":"BigInt"},{"html_id":"Crystal/BigRational","kind":"struct","full_name":"BigRational","name":"BigRational"},{"html_id":"Crystal/Char","kind":"struct","full_name":"Char","name":"Char"},{"html_id":"Crystal/Enum","kind":"struct","full_name":"Enum","name":"Enum"},{"html_id":"Crystal/Float","kind":"struct","full_name":"Float","name":"Float"},{"html_id":"Crystal/Int","kind":"struct","full_name":"Int","name":"Int"},{"html_id":"Crystal/Number","kind":"struct","full_name":"Number","name":"Number"},{"html_id":"Crystal/Path","kind":"struct","full_name":"Path","name":"Path"},{"html_id":"Crystal/Pointer","kind":"struct","full_name":"Pointer(T)","name":"Pointer"},{"html_id":"Crystal/SemanticVersion","kind":"struct","full_name":"SemanticVersion","name":"SemanticVersion"},{"html_id":"Crystal/SemanticVersion/Prerelease","kind":"struct","full_name":"SemanticVersion::Prerelease","name":"Prerelease"},{"html_id":"Crystal/Slice","kind":"struct","full_name":"Slice(T)","name":"Slice"},{"html_id":"Crystal/String","kind":"class","full_name":"String","name":"String"},{"html_id":"Crystal/Symbol","kind":"struct","full_name":"Symbol","name":"Symbol"},{"html_id":"Crystal/Time","kind":"struct","full_name":"Time","name":"Time"},{"html_id":"Crystal/Time/Span","kind":"struct","full_name":"Time::Span","name":"Span"},{"html_id":"Crystal/Tuple","kind":"struct","full_name":"Tuple(*T)","name":"Tuple"}],"namespace":null,"doc":"The `Comparable` mixin is used by classes whose objects may be ordered.\n\nIncluding types must provide an `<=>` method, which compares the receiver against\nanother object, returning:\n- a negative number if `self` is less than the other object\n- a positive number if `self` is greater than the other object\n- `0` if `self` is equal to the other object\n- `nil` if `self` and the other object are not comparable\n\n`Comparable` uses `<=>` to implement the conventional comparison operators\n(`<`, `<=`, `==`, `>=`, and `>`). All of these return `false` when `<=>`\nreturns `nil`.\n\nNote that returning `nil` is only useful when defining a partial comparable\nrelationship. One such example is float values: they are generally comparable,\nexcept for `NaN`. If none of the values of a type are comparable between each\nother, `Comparable` shouldn't be included.\n\nNOTE: When `nil` is returned from `<=>`, `Array#sort` and related sorting\nmethods will perform slightly slower.","summary":"<p>The <code><a href=\"Comparable.html\">Comparable</a></code> mixin is used by classes whose objects may be ordered.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"<(other:T)-instance-method","html_id":"<(other:T)-instance-method","name":"<","doc":"Compares this object to *other* based on the receiver’s `<=>` method,\nreturning `true` if it returns a negative number.","summary":"<p>Compares this object to <em>other</em> based on the receiver’s <code><a href=\"Comparable.html#(other:T)-instance-method\">#<=></a></code> method, returning <code>true</code> if it returns a negative number.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"args_string":"(other : T)","args_html":"(other : T)","location":{"filename":"src/comparable.cr","line_number":24,"url":null},"def":{"name":"<","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"cmp = self <=> other\ncmp ? cmp < 0 : false\n"}},{"id":"<=(other:T)-instance-method","html_id":"<=(other:T)-instance-method","name":"<=","doc":"Compares this object to *other* based on the receiver’s `<=>` method,\nreturning `true` if it returns a value equal or less then `0`.","summary":"<p>Compares this object to <em>other</em> based on the receiver’s <code><a href=\"Comparable.html#(other:T)-instance-method\">#<=></a></code> method, returning <code>true</code> if it returns a value equal or less then <code>0</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"args_string":"(other : T)","args_html":"(other : T)","location":{"filename":"src/comparable.cr","line_number":31,"url":null},"def":{"name":"<=","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"cmp = self <=> other\ncmp ? cmp <= 0 : false\n"}},{"id":"(other:T)-instance-method","html_id":"(other:T)-instance-method","name":"<=>","doc":"The comparison operator. Returns `0` if the two objects are equal,\na negative number if this object is considered less than *other*,\na positive number if this object is considered greater than *other*,\nor `nil` if the two objects are not comparable.\n\nSubclasses define this method to provide class-specific ordering.\n\nThe comparison operator is usually used to sort values:\n\n```\n# Sort in a descending way:\n[3, 1, 2].sort { |x, y| y <=> x } # => [3, 2, 1]\n\n# Sort in an ascending way:\n[3, 1, 2].sort { |x, y| x <=> y } # => [1, 2, 3]\n```","summary":"<p>The comparison operator.</p>","abstract":true,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"args_string":"(other : T)","args_html":"(other : T)","location":{"filename":"src/comparable.cr","line_number":83,"url":null},"def":{"name":"<=>","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":""}},{"id":"==(other:T)-instance-method","html_id":"==(other:T)-instance-method","name":"==","doc":"Compares this object to *other* based on the receiver’s `<=>` method,\nreturning `true` if it returns `0`.\n\nAlso returns `true` if this and *other* are the same object.","summary":"<p>Compares this object to <em>other</em> based on the receiver’s <code><a href=\"Comparable.html#(other:T)-instance-method\">#<=></a></code> method, returning <code>true</code> if it returns <code>0</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"args_string":"(other : T)","args_html":"(other : T)","location":{"filename":"src/comparable.cr","line_number":40,"url":null},"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if self.is_a?(Reference)\n  if other.is_a?(Reference) && (self.same?(other))\n    return true\n  end\n  if other.is_a?(Nil) && (self.same?(other))\n    return true\n  end\nend\ncmp = self <=> other\ncmp ? cmp == 0 : false\n"}},{"id":">(other:T)-instance-method","html_id":">(other:T)-instance-method","name":">","doc":"Compares this object to *other* based on the receiver’s `<=>` method,\nreturning `true` if it returns a value greater then `0`.","summary":"<p>Compares this object to <em>other</em> based on the receiver’s <code><a href=\"Comparable.html#(other:T)-instance-method\">#<=></a></code> method, returning <code>true</code> if it returns a value greater then <code>0</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"args_string":"(other : T)","args_html":"(other : T)","location":{"filename":"src/comparable.cr","line_number":55,"url":null},"def":{"name":">","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"cmp = self <=> other\ncmp ? cmp > 0 : false\n"}},{"id":">=(other:T)-instance-method","html_id":">=(other:T)-instance-method","name":">=","doc":"Compares this object to *other* based on the receiver’s `<=>` method,\nreturning `true` if it returns a value equal or greater than `0`.","summary":"<p>Compares this object to <em>other</em> based on the receiver’s <code><a href=\"Comparable.html#(other:T)-instance-method\">#<=></a></code> method, returning <code>true</code> if it returns a value equal or greater than <code>0</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"args_string":"(other : T)","args_html":"(other : T)","location":{"filename":"src/comparable.cr","line_number":62,"url":null},"def":{"name":">=","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"T"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"cmp = self <=> other\ncmp ? cmp >= 0 : false\n"}},{"id":"clamp(min,max)-instance-method","html_id":"clamp(min,max)-instance-method","name":"clamp","doc":"Clamps a value between *min* and *max*.\n\n```\n5.clamp(10, 100)   # => 10\n50.clamp(10, 100)  # => 50\n500.clamp(10, 100) # => 100\n\n5.clamp(10, nil)  # => 10\n50.clamp(10, nil) # => 50\n\n5.clamp(nil, 10)  # => 5\n50.clamp(nil, 10) # => 10\n```","summary":"<p>Clamps a value between <em>min</em> and <em>max</em>.</p>","abstract":false,"args":[{"name":"min","doc":null,"default_value":"","external_name":"min","restriction":""},{"name":"max","doc":null,"default_value":"","external_name":"max","restriction":""}],"args_string":"(min, max)","args_html":"(min, max)","location":{"filename":"src/comparable.cr","line_number":116,"url":null},"def":{"name":"clamp","args":[{"name":"min","doc":null,"default_value":"","external_name":"min","restriction":""},{"name":"max","doc":null,"default_value":"","external_name":"max","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if (!max.nil?) && self > max\n  return max\nend\nif (!min.nil?) && self < min\n  return min\nend\nself\n"}},{"id":"clamp(range:Range)-instance-method","html_id":"clamp(range:Range)-instance-method","name":"clamp","doc":"Clamps a value within *range*.\n\n```\n5.clamp(10..100)   # => 10\n50.clamp(10..100)  # => 50\n500.clamp(10..100) # => 100\n\n5.clamp(10..)  # => 10\n50.clamp(10..) # => 50\n\n5.clamp(..10)  # => 5\n50.clamp(..10) # => 10\n```","summary":"<p>Clamps a value within <em>range</em>.</p>","abstract":false,"args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"args_string":"(range : Range)","args_html":"(range : <a href=\"Range.html\">Range</a>)","location":{"filename":"src/comparable.cr","line_number":98,"url":null},"def":{"name":"clamp","args":[{"name":"range","doc":null,"default_value":"","external_name":"range","restriction":"Range"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if (!range.end.nil?) && range.exclusive?\n  raise(ArgumentError.new(\"Can't clamp an exclusive range\"))\nend\nclamp(range.begin, range.end)\n"}}],"macros":[],"types":[]},{"html_id":"Crystal/Complex","path":"Complex.html","kind":"struct","full_name":"Complex","name":"Complex","abstract":false,"superclass":{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},"ancestors":[{"html_id":"Crystal/Struct","kind":"struct","full_name":"Struct","name":"Struct"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":"A complex number is a number represented in the form a + bi. In this form,\na and b are real numbers, and i is an imaginary number such as i² = -1.\nThe a is the real part of the number, and the b is the imaginary part of\nthe number.\n\n```\nrequire \"complex\"\n\nComplex.new(1, 0)   # => 1.0 + 0.0i\nComplex.new(5, -12) # => 5.0 - 12.0i\n\n1.to_c # => 1.0 + 0.0i\n1.i    # => 0.0 + 1.0i\n```","summary":"<p>A complex number is a number represented in the form a + bi.</p>","class_methods":[],"constructors":[{"id":"additive_identity:self-class-method","html_id":"additive_identity:self-class-method","name":"additive_identity","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : <span class=\"k\">self</span>","args_html":" : <span class=\"k\">self</span>","location":{"filename":"src/complex.cr","line_number":258,"url":null},"def":{"name":"additive_identity","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"self","visibility":"Public","body":"zero"}},{"id":"new(real:Number,imag:Number=0)-class-method","html_id":"new(real:Number,imag:Number=0)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"real","doc":null,"default_value":"","external_name":"real","restriction":"Number"},{"name":"imag","doc":null,"default_value":"0","external_name":"imag","restriction":"Number"}],"args_string":"(real : Number, imag : Number = <span class=\"n\">0</span>)","args_html":"(real : <a href=\"Number.html\">Number</a>, imag : <a href=\"Number.html\">Number</a> = <span class=\"n\">0</span>)","location":{"filename":"src/complex.cr","line_number":22,"url":null},"def":{"name":"new","args":[{"name":"real","doc":null,"default_value":"","external_name":"real","restriction":"Number"},{"name":"imag","doc":null,"default_value":"0","external_name":"imag","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(real, imag)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(c:Complex)-class-method","html_id":"new(c:Complex)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"c","doc":null,"default_value":"","external_name":"c","restriction":"Complex"}],"args_string":"(c : Complex)","args_html":"(c : <a href=\"Complex.html\">Complex</a>)","location":{"filename":"src/complex.cr","line_number":27,"url":null},"def":{"name":"new","args":[{"name":"c","doc":null,"default_value":"","external_name":"c","restriction":"Complex"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"c"}},{"id":"zero:Complex-class-method","html_id":"zero:Complex-class-method","name":"zero","doc":"Returns the number `0` in complex form.","summary":"<p>Returns the number <code>0</code> in complex form.</p>","abstract":false,"args":[],"args_string":" : Complex","args_html":" : <a href=\"Complex.html\">Complex</a>","location":{"filename":"src/complex.cr","line_number":250,"url":null},"def":{"name":"zero","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Complex","visibility":"Public","body":"new(0, 0)"}}],"instance_methods":[{"id":"*(other:Complex)-instance-method","html_id":"*(other:Complex)-instance-method","name":"*","doc":"Multiplies `self` by *other*.","summary":"<p>Multiplies <code>self</code> by <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Complex"}],"args_string":"(other : Complex)","args_html":"(other : <a href=\"Complex.html\">Complex</a>)","location":{"filename":"src/complex.cr","line_number":211,"url":null},"def":{"name":"*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Complex"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Complex.new((@real * other.real) - (@imag * other.imag), (@real * other.imag) + (@imag * other.real))"}},{"id":"*(other:Number)-instance-method","html_id":"*(other:Number)-instance-method","name":"*","doc":"Multiplies `self` by *other*.","summary":"<p>Multiplies <code>self</code> by <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"args_string":"(other : Number)","args_html":"(other : <a href=\"Number.html\">Number</a>)","location":{"filename":"src/complex.cr","line_number":216,"url":null},"def":{"name":"*","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Complex.new(@real * other, @imag * other)"}},{"id":"+(other:Complex)-instance-method","html_id":"+(other:Complex)-instance-method","name":"+","doc":"Adds the value of `self` to *other*.","summary":"<p>Adds the value of <code>self</code> to <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Complex"}],"args_string":"(other : Complex)","args_html":"(other : <a href=\"Complex.html\">Complex</a>)","location":{"filename":"src/complex.cr","line_number":186,"url":null},"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Complex"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Complex.new(@real + other.real, @imag + other.imag)"}},{"id":"+(other:Number)-instance-method","html_id":"+(other:Number)-instance-method","name":"+","doc":"Adds the value of `self` to *other*.","summary":"<p>Adds the value of <code>self</code> to <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"args_string":"(other : Number)","args_html":"(other : <a href=\"Number.html\">Number</a>)","location":{"filename":"src/complex.cr","line_number":191,"url":null},"def":{"name":"+","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Complex.new(@real + other, @imag)"}},{"id":"+-instance-method","html_id":"+-instance-method","name":"+","doc":"Returns `self`.","summary":"<p>Returns <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/complex.cr","line_number":181,"url":null},"def":{"name":"+","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"--instance-method","html_id":"--instance-method","name":"-","doc":"Returns the opposite of `self`.","summary":"<p>Returns the opposite of <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/complex.cr","line_number":196,"url":null},"def":{"name":"-","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Complex.new(-@real, -@imag)"}},{"id":"-(other:Complex)-instance-method","html_id":"-(other:Complex)-instance-method","name":"-","doc":"Removes the value of *other* from `self`.","summary":"<p>Removes the value of <em>other</em> from <code>self</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Complex"}],"args_string":"(other : Complex)","args_html":"(other : <a href=\"Complex.html\">Complex</a>)","location":{"filename":"src/complex.cr","line_number":201,"url":null},"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Complex"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Complex.new(@real - other.real, @imag - other.imag)"}},{"id":"-(other:Number)-instance-method","html_id":"-(other:Number)-instance-method","name":"-","doc":"Removes the value of *other* from `self`.","summary":"<p>Removes the value of <em>other</em> from <code>self</code>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"args_string":"(other : Number)","args_html":"(other : <a href=\"Number.html\">Number</a>)","location":{"filename":"src/complex.cr","line_number":206,"url":null},"def":{"name":"-","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Complex.new(@real - other, @imag)"}},{"id":"/(other:Complex)-instance-method","html_id":"/(other:Complex)-instance-method","name":"/","doc":"Divides `self` by *other*.","summary":"<p>Divides <code>self</code> by <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Complex"}],"args_string":"(other : Complex)","args_html":"(other : <a href=\"Complex.html\">Complex</a>)","location":{"filename":"src/complex.cr","line_number":221,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Complex"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if other.real <= other.imag\n  r = other.real / other.imag\n  d = other.imag + (r * other.real)\n  Complex.new(((@real * r) + @imag) / d, ((@imag * r) - @real) / d)\nelse\n  r = other.imag / other.real\n  d = other.real + (r * other.imag)\n  Complex.new((@real + (@imag * r)) / d, (@imag - (@real * r)) / d)\nend"}},{"id":"/(other:Number)-instance-method","html_id":"/(other:Number)-instance-method","name":"/","doc":"Divides `self` by *other*.","summary":"<p>Divides <code>self</code> by <em>other</em>.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"args_string":"(other : Number)","args_html":"(other : <a href=\"Number.html\">Number</a>)","location":{"filename":"src/complex.cr","line_number":234,"url":null},"def":{"name":"/","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Complex.new(@real / other, @imag / other)"}},{"id":"==(other)-instance-method","html_id":"==(other)-instance-method","name":"==","doc":"Determines whether `self` equals *other* or not.","summary":"<p>Determines whether <code>self</code> equals <em>other</em> or not.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"args_string":"(other)","args_html":"(other)","location":{"filename":"src/complex.cr","line_number":42,"url":null},"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"false"}},{"id":"==(other:Number)-instance-method","html_id":"==(other:Number)-instance-method","name":"==","doc":"Determines whether `self` equals *other* or not.","summary":"<p>Determines whether <code>self</code> equals <em>other</em> or not.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"args_string":"(other : Number)","args_html":"(other : <a href=\"Number.html\">Number</a>)","location":{"filename":"src/complex.cr","line_number":37,"url":null},"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Number"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == other.to_c"}},{"id":"==(other:Complex)-instance-method","html_id":"==(other:Complex)-instance-method","name":"==","doc":"Determines whether `self` equals *other* or not.","summary":"<p>Determines whether <code>self</code> equals <em>other</em> or not.</p>","abstract":false,"args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Complex"}],"args_string":"(other : Complex)","args_html":"(other : <a href=\"Complex.html\">Complex</a>)","location":{"filename":"src/complex.cr","line_number":32,"url":null},"def":{"name":"==","args":[{"name":"other","doc":null,"default_value":"","external_name":"other","restriction":"Complex"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(@real == other.real) && (@imag == other.imag)"}},{"id":"abs-instance-method","html_id":"abs-instance-method","name":"abs","doc":"Returns the absolute value of this complex number in a\nnumber form, using the Pythagorean theorem.\n\n```\nrequire \"complex\"\n\nComplex.new(42, 2).abs  # => 42.04759208325728\nComplex.new(-42, 2).abs # => 42.04759208325728\n```","summary":"<p>Returns the absolute value of this complex number in a number form, using the Pythagorean theorem.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/complex.cr","line_number":128,"url":null},"def":{"name":"abs","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Math.hypot(@real, @imag)"}},{"id":"abs2-instance-method","html_id":"abs2-instance-method","name":"abs2","doc":"Returns the square of absolute value in a number form.\n\n```\nrequire \"complex\"\n\nComplex.new(42, 2).abs2 # => 1768\n```","summary":"<p>Returns the square of absolute value in a number form.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/complex.cr","line_number":139,"url":null},"def":{"name":"abs2","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(@real * @real) + (@imag * @imag)"}},{"id":"clone-instance-method","html_id":"clone-instance-method","name":"clone","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/complex.cr","line_number":238,"url":null},"def":{"name":"clone","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"conj-instance-method","html_id":"conj-instance-method","name":"conj","doc":"Returns the conjugate of `self`.\n\n```\nrequire \"complex\"\n\nComplex.new(42, 2).conj  # => 42.0 - 2.0i\nComplex.new(42, -2).conj # => 42.0 + 2.0i\n```","summary":"<p>Returns the conjugate of <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/complex.cr","line_number":171,"url":null},"def":{"name":"conj","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Complex.new(@real, -@imag)"}},{"id":"hash(hasher)-instance-method","html_id":"hash(hasher)-instance-method","name":"hash","doc":"See `Object#hash(hasher)`","summary":"<p>See <code><a href=\"Object.html#hash(hasher)-instance-method\">Object#hash(hasher)</a></code></p>","abstract":false,"args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"args_string":"(hasher)","args_html":"(hasher)","location":{"filename":"src/complex.cr","line_number":243,"url":null},"def":{"name":"hash","args":[{"name":"hasher","doc":null,"default_value":"","external_name":"hasher","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"hasher = real.hash(hasher)\nif imag.zero?\nelse\n  hasher = imag.hash(hasher)\nend\nhasher\n"}},{"id":"imag:Float64-instance-method","html_id":"imag:Float64-instance-method","name":"imag","doc":"Returns the imaginary part.","summary":"<p>Returns the imaginary part.</p>","abstract":false,"args":[],"args_string":" : Float64","args_html":" : <a href=\"Float64.html\">Float64</a>","location":{"filename":"src/complex.cr","line_number":20,"url":null},"def":{"name":"imag","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64","visibility":"Public","body":"@imag"}},{"id":"inspect(io:IO):Nil-instance-method","html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Writes this complex object to an *io*, surrounded by parentheses.\n\n```\nrequire \"complex\"\n\nComplex.new(42, 2).inspect # => \"(42.0 + 2.0i)\"\n```","summary":"<p>Writes this complex object to an <em>io</em>, surrounded by parentheses.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/complex.cr","line_number":113,"url":null},"def":{"name":"inspect","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << '('\nto_s(io)\nio << ')'\n"}},{"id":"inv-instance-method","html_id":"inv-instance-method","name":"inv","doc":"Returns the inverse of `self`.","summary":"<p>Returns the inverse of <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/complex.cr","line_number":176,"url":null},"def":{"name":"inv","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"conj / abs2"}},{"id":"multiplicative_identity:self-instance-method","html_id":"multiplicative_identity:self-instance-method","name":"multiplicative_identity","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : <span class=\"k\">self</span>","args_html":" : <span class=\"k\">self</span>","location":{"filename":"src/complex.cr","line_number":262,"url":null},"def":{"name":"multiplicative_identity","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"self","visibility":"Public","body":"new(1, 0)"}},{"id":"phase-instance-method","html_id":"phase-instance-method","name":"phase","doc":"Returns the phase of `self`.","summary":"<p>Returns the phase of <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/complex.cr","line_number":148,"url":null},"def":{"name":"phase","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Math.atan2(@imag, @real)"}},{"id":"polar-instance-method","html_id":"polar-instance-method","name":"polar","doc":"Returns a `Tuple` with the `abs` value and the `phase`.\n\n```\nrequire \"complex\"\n\nComplex.new(42, 2).polar # => {42.047592083257278, 0.047583103276983396}\n```","summary":"<p>Returns a <code><a href=\"Tuple.html\">Tuple</a></code> with the <code><a href=\"Complex.html#abs-instance-method\">#abs</a></code> value and the <code><a href=\"Complex.html#phase-instance-method\">#phase</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/complex.cr","line_number":159,"url":null},"def":{"name":"polar","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"{abs, phase}"}},{"id":"real:Float64-instance-method","html_id":"real:Float64-instance-method","name":"real","doc":"Returns the real part.","summary":"<p>Returns the real part.</p>","abstract":false,"args":[],"args_string":" : Float64","args_html":" : <a href=\"Float64.html\">Float64</a>","location":{"filename":"src/complex.cr","line_number":17,"url":null},"def":{"name":"real","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Float64","visibility":"Public","body":"@real"}},{"id":"round(digits=0)-instance-method","html_id":"round(digits=0)-instance-method","name":"round","doc":"Rounds to the nearest *digits*.","summary":"<p>Rounds to the nearest <em>digits</em>.</p>","abstract":false,"args":[{"name":"digits","doc":null,"default_value":"0","external_name":"digits","restriction":""}],"args_string":"(digits = <span class=\"n\">0</span>)","args_html":"(digits = <span class=\"n\">0</span>)","location":{"filename":"src/complex.cr","line_number":267,"url":null},"def":{"name":"round","args":[{"name":"digits","doc":null,"default_value":"0","external_name":"digits","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"Complex.new(@real.round(digits), @imag.round(digits))"}},{"id":"sign-instance-method","html_id":"sign-instance-method","name":"sign","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/complex.cr","line_number":143,"url":null},"def":{"name":"sign","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self / abs"}},{"id":"to_c-instance-method","html_id":"to_c-instance-method","name":"to_c","doc":"Returns `self`.","summary":"<p>Returns <code>self</code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/complex.cr","line_number":47,"url":null},"def":{"name":"to_c","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self"}},{"id":"to_f-instance-method","html_id":"to_f-instance-method","name":"to_f","doc":"See `#to_f64`.","summary":"<p>See <code><a href=\"Complex.html#to_f64-instance-method\">#to_f64</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/complex.cr","line_number":67,"url":null},"def":{"name":"to_f","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64"}},{"id":"to_f32-instance-method","html_id":"to_f32-instance-method","name":"to_f32","doc":"Returns the value as a `Float32` if possible (the imaginary part should be exactly zero),\nraises otherwise.","summary":"<p>Returns the value as a <code><a href=\"Float32.html\">Float32</a></code> if possible (the imaginary part should be exactly zero), raises otherwise.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/complex.cr","line_number":62,"url":null},"def":{"name":"to_f32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_f32"}},{"id":"to_f64-instance-method","html_id":"to_f64-instance-method","name":"to_f64","doc":"Returns the value as a `Float64` if possible (the imaginary part should be exactly zero),\nraises otherwise.","summary":"<p>Returns the value as a <code><a href=\"Float64.html\">Float64</a></code> if possible (the imaginary part should be exactly zero), raises otherwise.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/complex.cr","line_number":53,"url":null},"def":{"name":"to_f64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if @imag.zero?\nelse\n  raise(Exception.new(\"Complex number with non-zero imaginary part can't be converted to real number\"))\nend\n@real\n"}},{"id":"to_i-instance-method","html_id":"to_i-instance-method","name":"to_i","doc":"See `#to_i32`.","summary":"<p>See <code><a href=\"Complex.html#to_i32(*args,**options)-instance-method\">#to_i32</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/complex.cr","line_number":88,"url":null},"def":{"name":"to_i","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i32"}},{"id":"to_i16(*args,**options)-instance-method","html_id":"to_i16(*args,**options)-instance-method","name":"to_i16","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/complex.cr","line_number":77,"url":null},"def":{"name":"to_i16","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i64.to_i16(*args, **options)"}},{"id":"to_i16(*args,**options,&)-instance-method","html_id":"to_i16(*args,**options,&)-instance-method","name":"to_i16","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/complex.cr","line_number":77,"url":null},"def":{"name":"to_i16","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i64.to_i16(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_i32(*args,**options)-instance-method","html_id":"to_i32(*args,**options)-instance-method","name":"to_i32","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/complex.cr","line_number":77,"url":null},"def":{"name":"to_i32","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i64.to_i32(*args, **options)"}},{"id":"to_i32(*args,**options,&)-instance-method","html_id":"to_i32(*args,**options,&)-instance-method","name":"to_i32","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/complex.cr","line_number":77,"url":null},"def":{"name":"to_i32","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i64.to_i32(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_i64-instance-method","html_id":"to_i64-instance-method","name":"to_i64","doc":"Returns the value as an `Int64` if possible (the imaginary part should be exactly zero),\nraises otherwise.","summary":"<p>Returns the value as an <code><a href=\"Int64.html\">Int64</a></code> if possible (the imaginary part should be exactly zero), raises otherwise.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/complex.cr","line_number":73,"url":null},"def":{"name":"to_i64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_i64"}},{"id":"to_i8(*args,**options)-instance-method","html_id":"to_i8(*args,**options)-instance-method","name":"to_i8","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/complex.cr","line_number":77,"url":null},"def":{"name":"to_i8","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i64.to_i8(*args, **options)"}},{"id":"to_i8(*args,**options,&)-instance-method","html_id":"to_i8(*args,**options,&)-instance-method","name":"to_i8","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/complex.cr","line_number":77,"url":null},"def":{"name":"to_i8","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_i64.to_i8(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Writes this complex object to an *io*.\n\n```\nrequire \"complex\"\n\nComplex.new(42, 2).to_s # => \"42.0 + 2.0i\"\n```","summary":"<p>Writes this complex object to an <em>io</em>.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"IO.html\">IO</a>) : <a href=\"Nil.html\">Nil</a>","location":{"filename":"src/complex.cr","line_number":99,"url":null},"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << @real\nio << (@imag >= 0 ? \" + \" : \" - \")\nio << @imag.abs\nio << 'i'\n"}},{"id":"to_u16(*args,**options)-instance-method","html_id":"to_u16(*args,**options)-instance-method","name":"to_u16","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/complex.cr","line_number":85,"url":null},"def":{"name":"to_u16","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u64.to_u16(*args, **options)"}},{"id":"to_u16(*args,**options,&)-instance-method","html_id":"to_u16(*args,**options,&)-instance-method","name":"to_u16","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/complex.cr","line_number":85,"url":null},"def":{"name":"to_u16","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u64.to_u16(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_u32(*args,**options)-instance-method","html_id":"to_u32(*args,**options)-instance-method","name":"to_u32","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/complex.cr","line_number":85,"url":null},"def":{"name":"to_u32","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u64.to_u32(*args, **options)"}},{"id":"to_u32(*args,**options,&)-instance-method","html_id":"to_u32(*args,**options,&)-instance-method","name":"to_u32","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/complex.cr","line_number":85,"url":null},"def":{"name":"to_u32","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u64.to_u32(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"to_u64-instance-method","html_id":"to_u64-instance-method","name":"to_u64","doc":"Returns the value as an `UInt64` if possible (the imaginary part should be exactly zero),\nraises otherwise.","summary":"<p>Returns the value as an <code><a href=\"UInt64.html\">UInt64</a></code> if possible (the imaginary part should be exactly zero), raises otherwise.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/complex.cr","line_number":81,"url":null},"def":{"name":"to_u64","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_f64.to_u64"}},{"id":"to_u8(*args,**options)-instance-method","html_id":"to_u8(*args,**options)-instance-method","name":"to_u8","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/complex.cr","line_number":85,"url":null},"def":{"name":"to_u8","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u64.to_u8(*args, **options)"}},{"id":"to_u8(*args,**options,&)-instance-method","html_id":"to_u8(*args,**options,&)-instance-method","name":"to_u8","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/complex.cr","line_number":85,"url":null},"def":{"name":"to_u8","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_u64.to_u8(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}},{"id":"zero?:Bool-instance-method","html_id":"zero?:Bool-instance-method","name":"zero?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Bool","args_html":" : <a href=\"Bool.html\">Bool</a>","location":{"filename":"src/complex.cr","line_number":254,"url":null},"def":{"name":"zero?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"(@real == 0) && (@imag == 0)"}}],"macros":[],"types":[]},{"html_id":"Crystal/Compress","path":"Compress.html","kind":"module","full_name":"Compress","name":"Compress","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[{"html_id":"Crystal/Compress/Deflate","path":"Compress/Deflate.html","kind":"module","full_name":"Compress::Deflate","name":"Deflate","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[{"id":"BEST_COMPRESSION","name":"BEST_COMPRESSION","value":"9","doc":null,"summary":null},{"id":"BEST_SPEED","name":"BEST_SPEED","value":"1","doc":null,"summary":null},{"id":"DEFAULT_COMPRESSION","name":"DEFAULT_COMPRESSION","value":"-1","doc":null,"summary":null},{"id":"NO_COMPRESSION","name":"NO_COMPRESSION","value":"0","doc":null,"summary":null}],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Compress","kind":"module","full_name":"Compress","name":"Compress"},"doc":"The Deflate module contains readers and writers of DEFLATE format compressed\ndata, as specified in [RFC 1951](https://www.ietf.org/rfc/rfc1951.txt).\n\nSee `Gzip`, `Zip` and `Zlib` for modules that provide access\nto DEFLATE-based file formats.","summary":"<p>The Deflate module contains readers and writers of DEFLATE format compressed data, as specified in <a href=\"https://www.ietf.org/rfc/rfc1951.txt\">RFC 1951</a>.</p>","class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[{"html_id":"Crystal/Compress/Deflate/Error","path":"Compress/Deflate/Error.html","kind":"class","full_name":"Compress::Deflate::Error","name":"Error","abstract":false,"superclass":{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},"ancestors":[{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Compress/Deflate","kind":"module","full_name":"Compress::Deflate","name":"Deflate"},"doc":null,"summary":null,"class_methods":[],"constructors":[{"id":"new(ret,stream)-class-method","html_id":"new(ret,stream)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"ret","doc":null,"default_value":"","external_name":"ret","restriction":""},{"name":"stream","doc":null,"default_value":"","external_name":"stream","restriction":""}],"args_string":"(ret, stream)","args_html":"(ret, stream)","location":{"filename":"src/compress/deflate/deflate.cr","line_number":24,"url":null},"def":{"name":"new","args":[{"name":"ret","doc":null,"default_value":"","external_name":"ret","restriction":""},{"name":"stream","doc":null,"default_value":"","external_name":"stream","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(ret, stream)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[],"macros":[],"types":[]},{"html_id":"Crystal/Compress/Deflate/Reader","path":"Compress/Deflate/Reader.html","kind":"class","full_name":"Compress::Deflate::Reader","name":"Reader","abstract":false,"superclass":{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},"ancestors":[{"html_id":"Crystal/IO/Buffered","kind":"module","full_name":"IO::Buffered","name":"Buffered"},{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[{"html_id":"Crystal/IO/Buffered","kind":"module","full_name":"IO::Buffered","name":"Buffered"}],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Compress/Deflate","kind":"module","full_name":"Compress::Deflate","name":"Deflate"},"doc":"A read-only `IO` object to decompress data in the DEFLATE format.\n\nInstances of this class wrap another IO object. When you read from this instance\ninstance, it reads data from the underlying IO, decompresses it, and returns\nit to the caller.","summary":"<p>A read-only <code><a href=\"../../IO.html\">IO</a></code> object to decompress data in the DEFLATE format.</p>","class_methods":[{"id":"gzip(input,sync_close:Bool=false,&)-class-method","html_id":"gzip(input,sync_close:Bool=false,&)-class-method","name":"gzip","doc":"Creates an instance of Flate::Reader for the gzip format, yields it to the given block, and closes\nit at its end.","summary":"<p>Creates an instance of Flate::Reader for the gzip format, yields it to the given block, and closes it at its end.</p>","abstract":false,"args":[{"name":"input","doc":null,"default_value":"","external_name":"input","restriction":""},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":"Bool"}],"args_string":"(input, sync_close : Bool = <span class=\"n\">false</span>, &)","args_html":"(input, sync_close : <a href=\"../../Bool.html\">Bool</a> = <span class=\"n\">false</span>, &)","location":{"filename":"src/compress/deflate/reader.cr","line_number":49,"url":null},"def":{"name":"gzip","args":[{"name":"input","doc":null,"default_value":"","external_name":"input","restriction":""},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":"Bool"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"reader = gzip(input, sync_close: sync_close)\nbegin\n  yield reader\nensure\n  reader.close\nend\n"}},{"id":"open(io:IO,sync_close:Bool=false,dict:Bytes?=nil,&)-class-method","html_id":"open(io:IO,sync_close:Bool=false,dict:Bytes?=nil,&)-class-method","name":"open","doc":"Creates a new reader from the given *io*, yields it to the given block,\nand closes it at its end.","summary":"<p>Creates a new reader from the given <em>io</em>, yields it to the given block, and closes it at its end.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":"Bool"},{"name":"dict","doc":null,"default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"args_string":"(io : IO, sync_close : Bool = <span class=\"n\">false</span>, dict : Bytes? = <span class=\"n\">nil</span>, &)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close : <a href=\"../../Bool.html\">Bool</a> = <span class=\"n\">false</span>, dict : <a href=\"../../Bytes.html\">Bytes</a>? = <span class=\"n\">nil</span>, &)","location":{"filename":"src/compress/deflate/reader.cr","line_number":36,"url":null},"def":{"name":"open","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":"Bool"},{"name":"dict","doc":null,"default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"reader = new(io, sync_close: sync_close, dict: dict)\nbegin\n  yield reader\nensure\n  reader.close\nend\n"}}],"constructors":[{"id":"gzip(input,sync_close:Bool=false):self-class-method","html_id":"gzip(input,sync_close:Bool=false):self-class-method","name":"gzip","doc":"Creates an instance of Flate::Reader for the gzip format.\nhas written.","summary":"<p>Creates an instance of Flate::Reader for the gzip format.</p>","abstract":false,"args":[{"name":"input","doc":null,"default_value":"","external_name":"input","restriction":""},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":"Bool"}],"args_string":"(input, sync_close : Bool = <span class=\"n\">false</span>) : <span class=\"k\">self</span>","args_html":"(input, sync_close : <a href=\"../../Bool.html\">Bool</a> = <span class=\"n\">false</span>) : <span class=\"k\">self</span>","location":{"filename":"src/compress/deflate/reader.cr","line_number":43,"url":null},"def":{"name":"gzip","args":[{"name":"input","doc":null,"default_value":"","external_name":"input","restriction":""},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":"Bool"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"self","visibility":"Public","body":"new(input, wbits: GZIP, sync_close: sync_close)"}},{"id":"new(io:IO,sync_close:Bool=false,dict:Bytes?=nil)-class-method","html_id":"new(io:IO,sync_close:Bool=false,dict:Bytes?=nil)-class-method","name":"new","doc":"Creates an instance of Flate::Reader.","summary":"<p>Creates an instance of Flate::Reader.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":"Bool"},{"name":"dict","doc":null,"default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"args_string":"(io : IO, sync_close : Bool = <span class=\"n\">false</span>, dict : Bytes? = <span class=\"n\">nil</span>)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close : <a href=\"../../Bool.html\">Bool</a> = <span class=\"n\">false</span>, dict : <a href=\"../../Bytes.html\">Bytes</a>? = <span class=\"n\">nil</span>)","location":{"filename":"src/compress/deflate/reader.cr","line_number":22,"url":null},"def":{"name":"new","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":"Bool"},{"name":"dict","doc":null,"default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(io, sync_close, dict)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"closed?:Bool-instance-method","html_id":"closed?:Bool-instance-method","name":"closed?","doc":"Returns `true` if this reader is closed.","summary":"<p>Returns <code>true</code> if this reader is closed.</p>","abstract":false,"args":[],"args_string":" : Bool","args_html":" : <a href=\"../../Bool.html\">Bool</a>","location":{"filename":"src/compress/deflate/reader.cr","line_number":13,"url":null},"def":{"name":"closed?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@closed"}},{"id":"dict:Bytes?-instance-method","html_id":"dict:Bytes?-instance-method","name":"dict","doc":"Dictionary passed in the constructor","summary":"<p>Dictionary passed in the constructor</p>","abstract":false,"args":[],"args_string":" : Bytes?","args_html":" : <a href=\"../../Bytes.html\">Bytes</a>?","location":{"filename":"src/compress/deflate/reader.cr","line_number":16,"url":null},"def":{"name":"dict","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bytes | ::Nil","visibility":"Public","body":"@dict"}},{"id":"sync_close=(sync_close:Bool)-instance-method","html_id":"sync_close=(sync_close:Bool)-instance-method","name":"sync_close=","doc":"If `#sync_close?` is `true`, closing this IO will close the underlying IO.","summary":"<p>If <code><a href=\"../../Compress/Deflate/Reader.html#sync_close?:Bool-instance-method\">#sync_close?</a></code> is <code>true</code>, closing this IO will close the underlying IO.</p>","abstract":false,"args":[{"name":"sync_close","doc":null,"default_value":"","external_name":"sync_close","restriction":"Bool"}],"args_string":"(sync_close : Bool)","args_html":"(sync_close : <a href=\"../../Bool.html\">Bool</a>)","location":{"filename":"src/compress/deflate/reader.cr","line_number":10,"url":null},"def":{"name":"sync_close=","args":[{"name":"sync_close","doc":null,"default_value":"","external_name":"sync_close","restriction":"Bool"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@sync_close = sync_close"}},{"id":"sync_close?:Bool-instance-method","html_id":"sync_close?:Bool-instance-method","name":"sync_close?","doc":"If `#sync_close?` is `true`, closing this IO will close the underlying IO.","summary":"<p>If <code><a href=\"../../Compress/Deflate/Reader.html#sync_close?:Bool-instance-method\">#sync_close?</a></code> is <code>true</code>, closing this IO will close the underlying IO.</p>","abstract":false,"args":[],"args_string":" : Bool","args_html":" : <a href=\"../../Bool.html\">Bool</a>","location":{"filename":"src/compress/deflate/reader.cr","line_number":10,"url":null},"def":{"name":"sync_close?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"@sync_close"}},{"id":"unbuffered_close-instance-method","html_id":"unbuffered_close-instance-method","name":"unbuffered_close","doc":"Closes this reader.","summary":"<p>Closes this reader.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/deflate/reader.cr","line_number":133,"url":null},"def":{"name":"unbuffered_close","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if @closed\n  return\nend\n@closed = true\nret = LibZ.inflateEnd(pointerof(@stream))\nif ret.ok?\nelse\n  raise(Compress::Deflate::Error.new(ret, @stream))\nend\nif @sync_close\n  @io.close\nend\n"}},{"id":"unbuffered_flush-instance-method","html_id":"unbuffered_flush-instance-method","name":"unbuffered_flush","doc":"Flushes the wrapped `IO`.","summary":"<p>Flushes the wrapped <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/deflate/reader.cr","line_number":128,"url":null},"def":{"name":"unbuffered_flush","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"raise(IO::Error.new(\"Can't flush Compress::Deflate::Reader\"))"}},{"id":"unbuffered_read(slice:Bytes)-instance-method","html_id":"unbuffered_read(slice:Bytes)-instance-method","name":"unbuffered_read","doc":"See `IO#read`.","summary":"<p>See <code><a href=\"../../IO.html#read(slice:Bytes)-instance-method\">IO#read</a></code>.</p>","abstract":false,"args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes)","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>)","location":{"filename":"src/compress/deflate/reader.cr","line_number":60,"url":null},"def":{"name":"unbuffered_read","args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"check_open\nif slice.empty?\n  return 0\nend\nif @end\n  return 0\nend\nwhile true\n  if @stream.avail_in == 0\n    @peek = @io.peek\n    if peek = @peek\n      @stream.next_in = peek\n      @stream.avail_in = peek.size\n    else\n      @stream.next_in = @buf.to_unsafe\n      @stream.avail_in = (@io.read(@buf.to_slice)).to_u32\n    end\n  end\n  old_avail_in = @stream.avail_in\n  @stream.avail_out = slice.size.to_u32\n  @stream.next_out = slice.to_unsafe\n  ret = LibZ.inflate(pointerof(@stream), LibZ::Flush::NO_FLUSH)\n  read_bytes = slice.size - @stream.avail_out\n  avail_in_diff = old_avail_in - @stream.avail_in\n  if @peek && avail_in_diff > 0\n    @io.skip(avail_in_diff)\n  end\n  case ret\n  when .need_dict?\n    if dict = @dict\n      ret = LibZ.inflateSetDictionary(pointerof(@stream), dict, dict.size)\n      if ret.ok?\n        next\n      end\n    end\n    raise(Compress::Deflate::Error.new(ret, @stream))\n  when .errno?, .data_error?, .mem_error?, .buf_error?, .version_error?\n    raise(Compress::Deflate::Error.new(ret, @stream))\n  when .stream_end?\n    @end = true\n    return read_bytes\n  else\n    if read_bytes == 0\n      next\n    else\n      return read_bytes\n    end\n  end\nend\n"}},{"id":"unbuffered_rewind-instance-method","html_id":"unbuffered_rewind-instance-method","name":"unbuffered_rewind","doc":"Rewinds the wrapped `IO`.","summary":"<p>Rewinds the wrapped <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/deflate/reader.cr","line_number":143,"url":null},"def":{"name":"unbuffered_rewind","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"check_open\n@io.rewind\ninitialize(@io, @sync_close, @dict)\n"}},{"id":"unbuffered_write(slice:Bytes)-instance-method","html_id":"unbuffered_write(slice:Bytes)-instance-method","name":"unbuffered_write","doc":"Always raises `IO::Error` because this is a read-only `IO`.","summary":"<p>Always raises <code><a href=\"../../IO/Error.html\">IO::Error</a></code> because this is a read-only <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes)","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>)","location":{"filename":"src/compress/deflate/reader.cr","line_number":55,"url":null},"def":{"name":"unbuffered_write","args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"raise(IO::Error.new(\"Can't write to Compress::Deflate::Reader\"))"}}],"macros":[],"types":[]},{"html_id":"Crystal/Compress/Deflate/Strategy","path":"Compress/Deflate/Strategy.html","kind":"enum","full_name":"Compress::Deflate::Strategy","name":"Strategy","abstract":false,"superclass":null,"ancestors":[{"html_id":"Crystal/Enum","kind":"struct","full_name":"Enum","name":"Enum"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":true,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[{"id":"FILTERED","name":"FILTERED","value":"1","doc":null,"summary":null},{"id":"HUFFMAN_ONLY","name":"HUFFMAN_ONLY","value":"2","doc":null,"summary":null},{"id":"RLE","name":"RLE","value":"3","doc":null,"summary":null},{"id":"FIXED","name":"FIXED","value":"4","doc":null,"summary":null},{"id":"DEFAULT","name":"DEFAULT","value":"0","doc":null,"summary":null}],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Compress/Deflate","kind":"module","full_name":"Compress::Deflate","name":"Deflate"},"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[{"id":"default?-instance-method","html_id":"default?-instance-method","name":"default?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/deflate/deflate.cr","line_number":20,"url":null},"def":{"name":"default?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == DEFAULT"}},{"id":"filtered?-instance-method","html_id":"filtered?-instance-method","name":"filtered?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/deflate/deflate.cr","line_number":16,"url":null},"def":{"name":"filtered?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == FILTERED"}},{"id":"fixed?-instance-method","html_id":"fixed?-instance-method","name":"fixed?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/deflate/deflate.cr","line_number":19,"url":null},"def":{"name":"fixed?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == FIXED"}},{"id":"huffman_only?-instance-method","html_id":"huffman_only?-instance-method","name":"huffman_only?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/deflate/deflate.cr","line_number":17,"url":null},"def":{"name":"huffman_only?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == HUFFMAN_ONLY"}},{"id":"rle?-instance-method","html_id":"rle?-instance-method","name":"rle?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/deflate/deflate.cr","line_number":18,"url":null},"def":{"name":"rle?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == RLE"}}],"macros":[],"types":[]},{"html_id":"Crystal/Compress/Deflate/Writer","path":"Compress/Deflate/Writer.html","kind":"class","full_name":"Compress::Deflate::Writer","name":"Writer","abstract":false,"superclass":{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},"ancestors":[{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Compress/Deflate","kind":"module","full_name":"Compress::Deflate","name":"Deflate"},"doc":"A write-only `IO` object to compress data in the DEFLATE format.\n\nInstances of this class wrap another IO object. When you write to this\ninstance, it compresses the data and writes it to the underlying IO.\n\nNOTE: unless created with a block, `close` must be invoked after all\ndata has been written to a Flate::Writer instance.","summary":"<p>A write-only <code><a href=\"../../IO.html\">IO</a></code> object to compress data in the DEFLATE format.</p>","class_methods":[{"id":"open(io:IO,level:Int32=Compress::Deflate::DEFAULT_COMPRESSION,strategy:Compress::Deflate::Strategy=Compress::Deflate::Strategy::DEFAULT,sync_close:Bool=false,dict:Bytes?=nil,&)-class-method","html_id":"open(io:IO,level:Int32=Compress::Deflate::DEFAULT_COMPRESSION,strategy:Compress::Deflate::Strategy=Compress::Deflate::Strategy::DEFAULT,sync_close:Bool=false,dict:Bytes?=nil,&)-class-method","name":"open","doc":"Creates a new writer for the given *io*, yields it to the given block,\nand closes it at its end.","summary":"<p>Creates a new writer for the given <em>io</em>, yields it to the given block, and closes it at its end.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"level","doc":null,"default_value":"Compress::Deflate::DEFAULT_COMPRESSION","external_name":"level","restriction":"Int32"},{"name":"strategy","doc":null,"default_value":"Compress::Deflate::Strategy::DEFAULT","external_name":"strategy","restriction":"Compress::Deflate::Strategy"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":"Bool"},{"name":"dict","doc":null,"default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"args_string":"(io : IO, level : Int32 = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Deflate</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, strategy : Compress::Deflate::Strategy = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Deflate</span><span class=\"t\">::</span><span class=\"t\">Strategy</span><span class=\"t\">::</span><span class=\"t\">DEFAULT</span>, sync_close : Bool = <span class=\"n\">false</span>, dict : Bytes? = <span class=\"n\">nil</span>, &)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, level : <a href=\"../../Int32.html\">Int32</a> = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Deflate</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, strategy : <a href=\"../../Compress/Deflate/Strategy.html\">Compress::Deflate::Strategy</a> = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Deflate</span><span class=\"t\">::</span><span class=\"t\">Strategy</span><span class=\"t\">::</span><span class=\"t\">DEFAULT</span>, sync_close : <a href=\"../../Bool.html\">Bool</a> = <span class=\"n\">false</span>, dict : <a href=\"../../Bytes.html\">Bytes</a>? = <span class=\"n\">nil</span>, &)","location":{"filename":"src/compress/deflate/writer.cr","line_number":33,"url":null},"def":{"name":"open","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"level","doc":null,"default_value":"Compress::Deflate::DEFAULT_COMPRESSION","external_name":"level","restriction":"Int32"},{"name":"strategy","doc":null,"default_value":"Compress::Deflate::Strategy::DEFAULT","external_name":"strategy","restriction":"Compress::Deflate::Strategy"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":"Bool"},{"name":"dict","doc":null,"default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"writer = new(io, level: level, strategy: strategy, sync_close: sync_close, dict: dict)\nbegin\n  yield writer\nensure\n  writer.close\nend\n"}}],"constructors":[{"id":"new(output:IO,level:Int32=Compress::Deflate::DEFAULT_COMPRESSION,strategy:Compress::Deflate::Strategy=Compress::Deflate::Strategy::DEFAULT,sync_close:Bool=false,dict:Bytes?=nil)-class-method","html_id":"new(output:IO,level:Int32=Compress::Deflate::DEFAULT_COMPRESSION,strategy:Compress::Deflate::Strategy=Compress::Deflate::Strategy::DEFAULT,sync_close:Bool=false,dict:Bytes?=nil)-class-method","name":"new","doc":"Creates an instance of Flate::Writer. `close` must be invoked after all data\nhas written.","summary":"<p>Creates an instance of Flate::Writer.</p>","abstract":false,"args":[{"name":"output","doc":null,"default_value":"","external_name":"output","restriction":"IO"},{"name":"level","doc":null,"default_value":"Compress::Deflate::DEFAULT_COMPRESSION","external_name":"level","restriction":"Int32"},{"name":"strategy","doc":null,"default_value":"Compress::Deflate::Strategy::DEFAULT","external_name":"strategy","restriction":"Compress::Deflate::Strategy"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":"Bool"},{"name":"dict","doc":null,"default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"args_string":"(output : IO, level : Int32 = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Deflate</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, strategy : Compress::Deflate::Strategy = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Deflate</span><span class=\"t\">::</span><span class=\"t\">Strategy</span><span class=\"t\">::</span><span class=\"t\">DEFAULT</span>, sync_close : Bool = <span class=\"n\">false</span>, dict : Bytes? = <span class=\"n\">nil</span>)","args_html":"(output : <a href=\"../../IO.html\">IO</a>, level : <a href=\"../../Int32.html\">Int32</a> = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Deflate</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, strategy : <a href=\"../../Compress/Deflate/Strategy.html\">Compress::Deflate::Strategy</a> = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Deflate</span><span class=\"t\">::</span><span class=\"t\">Strategy</span><span class=\"t\">::</span><span class=\"t\">DEFAULT</span>, sync_close : <a href=\"../../Bool.html\">Bool</a> = <span class=\"n\">false</span>, dict : <a href=\"../../Bytes.html\">Bytes</a>? = <span class=\"n\">nil</span>)","location":{"filename":"src/compress/deflate/writer.cr","line_number":14,"url":null},"def":{"name":"new","args":[{"name":"output","doc":null,"default_value":"","external_name":"output","restriction":"IO"},{"name":"level","doc":null,"default_value":"Compress::Deflate::DEFAULT_COMPRESSION","external_name":"level","restriction":"Int32"},{"name":"strategy","doc":null,"default_value":"Compress::Deflate::Strategy::DEFAULT","external_name":"strategy","restriction":"Compress::Deflate::Strategy"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":"Bool"},{"name":"dict","doc":null,"default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(output, level, strategy, sync_close, dict)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"close-instance-method","html_id":"close-instance-method","name":"close","doc":"Closes this writer. Must be invoked after all data has been written.","summary":"<p>Closes this writer.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/deflate/writer.cr","line_number":65,"url":null},"def":{"name":"close","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if @closed\n  return\nend\n@closed = true\n@stream.avail_in = 0\n@stream.next_in = Pointer(UInt8).null\nconsume_output(LibZ::Flush::FINISH)\nret = LibZ.deflateEnd(pointerof(@stream))\nif ret.ok?\nelse\n  raise(Compress::Deflate::Error.new(ret, @stream))\nend\nif @sync_close\n  @output.close\nend\n"}},{"id":"closed?:Bool-instance-method","html_id":"closed?:Bool-instance-method","name":"closed?","doc":"Returns `true` if this IO is closed.","summary":"<p>Returns <code>true</code> if this IO is closed.</p>","abstract":false,"args":[],"args_string":" : Bool","args_html":" : <a href=\"../../Bool.html\">Bool</a>","location":{"filename":"src/compress/deflate/writer.cr","line_number":80,"url":null},"def":{"name":"closed?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@closed"}},{"id":"flush-instance-method","html_id":"flush-instance-method","name":"flush","doc":"See `IO#flush`.","summary":"<p>See <code><a href=\"../../IO.html#flush-instance-method\">IO#flush</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/deflate/writer.cr","line_number":57,"url":null},"def":{"name":"flush","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if @closed\n  return\nend\nconsume_output(LibZ::Flush::SYNC_FLUSH)\n@output.flush\n"}},{"id":"read(slice:Bytes)-instance-method","html_id":"read(slice:Bytes)-instance-method","name":"read","doc":"Always raises `IO::Error` because this is a write-only `IO`.","summary":"<p>Always raises <code><a href=\"../../IO/Error.html\">IO::Error</a></code> because this is a write-only <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes)","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>)","location":{"filename":"src/compress/deflate/writer.cr","line_number":41,"url":null},"def":{"name":"read","args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"raise(\"Can't read from Flate::Writer\")"}},{"id":"sync_close=(sync_close:Bool)-instance-method","html_id":"sync_close=(sync_close:Bool)-instance-method","name":"sync_close=","doc":"If `#sync_close?` is `true`, closing this IO will close the underlying IO.","summary":"<p>If <code><a href=\"../../Compress/Deflate/Writer.html#sync_close?:Bool-instance-method\">#sync_close?</a></code> is <code>true</code>, closing this IO will close the underlying IO.</p>","abstract":false,"args":[{"name":"sync_close","doc":null,"default_value":"","external_name":"sync_close","restriction":"Bool"}],"args_string":"(sync_close : Bool)","args_html":"(sync_close : <a href=\"../../Bool.html\">Bool</a>)","location":{"filename":"src/compress/deflate/writer.cr","line_number":10,"url":null},"def":{"name":"sync_close=","args":[{"name":"sync_close","doc":null,"default_value":"","external_name":"sync_close","restriction":"Bool"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@sync_close = sync_close"}},{"id":"sync_close?:Bool-instance-method","html_id":"sync_close?:Bool-instance-method","name":"sync_close?","doc":"If `#sync_close?` is `true`, closing this IO will close the underlying IO.","summary":"<p>If <code><a href=\"../../Compress/Deflate/Writer.html#sync_close?:Bool-instance-method\">#sync_close?</a></code> is <code>true</code>, closing this IO will close the underlying IO.</p>","abstract":false,"args":[],"args_string":" : Bool","args_html":" : <a href=\"../../Bool.html\">Bool</a>","location":{"filename":"src/compress/deflate/writer.cr","line_number":10,"url":null},"def":{"name":"sync_close?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"@sync_close"}},{"id":"write(slice:Bytes):Nil-instance-method","html_id":"write(slice:Bytes):Nil-instance-method","name":"write","doc":"See `IO#write`.","summary":"<p>See <code><a href=\"../../IO.html#write(slice:Bytes):Nil-instance-method\">IO#write</a></code>.</p>","abstract":false,"args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes) : Nil","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>) : <a href=\"../../Nil.html\">Nil</a>","location":{"filename":"src/compress/deflate/writer.cr","line_number":46,"url":null},"def":{"name":"write","args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"check_open\nif slice.empty?\n  return\nend\n@stream.avail_in = slice.size\n@stream.next_in = slice\nconsume_output(LibZ::Flush::NO_FLUSH)\n"}}],"macros":[],"types":[]}]},{"html_id":"Crystal/Compress/Gzip","path":"Compress/Gzip.html","kind":"module","full_name":"Compress::Gzip","name":"Gzip","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[{"id":"BEST_COMPRESSION","name":"BEST_COMPRESSION","value":"Compress::Deflate::BEST_COMPRESSION","doc":null,"summary":null},{"id":"BEST_SPEED","name":"BEST_SPEED","value":"Compress::Deflate::BEST_SPEED","doc":null,"summary":null},{"id":"DEFAULT_COMPRESSION","name":"DEFAULT_COMPRESSION","value":"Compress::Deflate::DEFAULT_COMPRESSION","doc":null,"summary":null},{"id":"NO_COMPRESSION","name":"NO_COMPRESSION","value":"Compress::Deflate::NO_COMPRESSION","doc":null,"summary":null}],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Compress","kind":"module","full_name":"Compress","name":"Compress"},"doc":"The Gzip module contains readers and writers of gzip format compressed\ndata, as specified in [RFC 1952](https://www.ietf.org/rfc/rfc1952.txt).","summary":"<p>The Gzip module contains readers and writers of gzip format compressed data, as specified in <a href=\"https://www.ietf.org/rfc/rfc1952.txt\">RFC 1952</a>.</p>","class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[{"html_id":"Crystal/Compress/Gzip/Error","path":"Compress/Gzip/Error.html","kind":"class","full_name":"Compress::Gzip::Error","name":"Error","abstract":false,"superclass":{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},"ancestors":[{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Compress/Gzip","kind":"module","full_name":"Compress::Gzip","name":"Gzip"},"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"Crystal/Compress/Gzip/Header","path":"Compress/Gzip/Header.html","kind":"class","full_name":"Compress::Gzip::Header","name":"Header","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Compress/Gzip","kind":"module","full_name":"Compress::Gzip","name":"Gzip"},"doc":"A header in a gzip stream.","summary":"<p>A header in a gzip stream.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"comment:String?-instance-method","html_id":"comment:String?-instance-method","name":"comment","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : String?","args_html":" : <a href=\"../../String.html\">String</a>?","location":{"filename":"src/compress/gzip/header.cr","line_number":7,"url":null},"def":{"name":"comment","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String | ::Nil","visibility":"Public","body":"@comment"}},{"id":"comment=(comment:String?)-instance-method","html_id":"comment=(comment:String?)-instance-method","name":"comment=","doc":null,"summary":null,"abstract":false,"args":[{"name":"comment","doc":null,"default_value":"","external_name":"comment","restriction":"String | ::Nil"}],"args_string":"(comment : String?)","args_html":"(comment : <a href=\"../../String.html\">String</a>?)","location":{"filename":"src/compress/gzip/header.cr","line_number":7,"url":null},"def":{"name":"comment=","args":[{"name":"comment","doc":null,"default_value":"","external_name":"comment","restriction":"String | ::Nil"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@comment = comment"}},{"id":"extra:Slice(UInt8)-instance-method","html_id":"extra:Slice(UInt8)-instance-method","name":"extra","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Slice(UInt8)","args_html":" : <a href=\"../../Slice.html\">Slice</a>(<a href=\"../../UInt8.html\">UInt8</a>)","location":{"filename":"src/compress/gzip/header.cr","line_number":5,"url":null},"def":{"name":"extra","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@extra"}},{"id":"extra=(extra)-instance-method","html_id":"extra=(extra)-instance-method","name":"extra=","doc":null,"summary":null,"abstract":false,"args":[{"name":"extra","doc":null,"default_value":"","external_name":"extra","restriction":""}],"args_string":"(extra)","args_html":"(extra)","location":{"filename":"src/compress/gzip/header.cr","line_number":5,"url":null},"def":{"name":"extra=","args":[{"name":"extra","doc":null,"default_value":"","external_name":"extra","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@extra = extra"}},{"id":"modification_time:Time-instance-method","html_id":"modification_time:Time-instance-method","name":"modification_time","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Time","args_html":" : <a href=\"../../Time.html\">Time</a>","location":{"filename":"src/compress/gzip/header.cr","line_number":3,"url":null},"def":{"name":"modification_time","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Time","visibility":"Public","body":"@modification_time"}},{"id":"modification_time=(modification_time:Time)-instance-method","html_id":"modification_time=(modification_time:Time)-instance-method","name":"modification_time=","doc":null,"summary":null,"abstract":false,"args":[{"name":"modification_time","doc":null,"default_value":"","external_name":"modification_time","restriction":"Time"}],"args_string":"(modification_time : Time)","args_html":"(modification_time : <a href=\"../../Time.html\">Time</a>)","location":{"filename":"src/compress/gzip/header.cr","line_number":3,"url":null},"def":{"name":"modification_time=","args":[{"name":"modification_time","doc":null,"default_value":"","external_name":"modification_time","restriction":"Time"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@modification_time = modification_time"}},{"id":"name:String?-instance-method","html_id":"name:String?-instance-method","name":"name","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : String?","args_html":" : <a href=\"../../String.html\">String</a>?","location":{"filename":"src/compress/gzip/header.cr","line_number":6,"url":null},"def":{"name":"name","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String | ::Nil","visibility":"Public","body":"@name"}},{"id":"name=(name:String?)-instance-method","html_id":"name=(name:String?)-instance-method","name":"name=","doc":null,"summary":null,"abstract":false,"args":[{"name":"name","doc":null,"default_value":"","external_name":"name","restriction":"String | ::Nil"}],"args_string":"(name : String?)","args_html":"(name : <a href=\"../../String.html\">String</a>?)","location":{"filename":"src/compress/gzip/header.cr","line_number":6,"url":null},"def":{"name":"name=","args":[{"name":"name","doc":null,"default_value":"","external_name":"name","restriction":"String | ::Nil"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@name = name"}},{"id":"os:UInt8-instance-method","html_id":"os:UInt8-instance-method","name":"os","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : UInt8","args_html":" : <a href=\"../../UInt8.html\">UInt8</a>","location":{"filename":"src/compress/gzip/header.cr","line_number":4,"url":null},"def":{"name":"os","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt8","visibility":"Public","body":"@os"}},{"id":"os=(os:UInt8)-instance-method","html_id":"os=(os:UInt8)-instance-method","name":"os=","doc":null,"summary":null,"abstract":false,"args":[{"name":"os","doc":null,"default_value":"","external_name":"os","restriction":"UInt8"}],"args_string":"(os : UInt8)","args_html":"(os : <a href=\"../../UInt8.html\">UInt8</a>)","location":{"filename":"src/compress/gzip/header.cr","line_number":4,"url":null},"def":{"name":"os=","args":[{"name":"os","doc":null,"default_value":"","external_name":"os","restriction":"UInt8"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@os = os"}}],"macros":[],"types":[]},{"html_id":"Crystal/Compress/Gzip/Reader","path":"Compress/Gzip/Reader.html","kind":"class","full_name":"Compress::Gzip::Reader","name":"Reader","abstract":false,"superclass":{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},"ancestors":[{"html_id":"Crystal/IO/Buffered","kind":"module","full_name":"IO::Buffered","name":"Buffered"},{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[{"html_id":"Crystal/IO/Buffered","kind":"module","full_name":"IO::Buffered","name":"Buffered"}],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Compress/Gzip","kind":"module","full_name":"Compress::Gzip","name":"Gzip"},"doc":"A read-only `IO` object to decompress data in the gzip format.\n\nInstances of this class wrap another IO object. When you read from this instance\ninstance, it reads data from the underlying IO, decompresses it, and returns\nit to the caller.\n\nNOTE: A gzip stream can contain zero or more members. If it contains\nno members, `header` will be `nil`. If it contains one or more\nmembers, only the first header will be recorded here. This is\nbecause gzipping multiple members is not common as one usually\ncombines gzip with tar. If, however, multiple members are present\nthen reading from this reader will return the concatenation of\nall the members.\n\n### Example: decompress a gzip file\n\n```\nrequire \"compress/gzip\"\n\nFile.write(\"file.gzip\", Bytes[31, 139, 8, 0, 0, 0, 0, 0, 0, 3, 75, 76, 74, 6, 0, 194, 65, 36, 53, 3, 0, 0, 0])\n\nstring = File.open(\"file.gzip\") do |file|\n  Compress::Gzip::Reader.open(file) do |gzip|\n    gzip.gets_to_end\n  end\nend\nstring # => \"abc\"\n```","summary":"<p>A read-only <code><a href=\"../../IO.html\">IO</a></code> object to decompress data in the gzip format.</p>","class_methods":[{"id":"open(io:IO,sync_close=false,&)-class-method","html_id":"open(io:IO,sync_close=false,&)-class-method","name":"open","doc":"Creates a new reader from the given *io*, yields it to the given block,\nand closes it at the end.","summary":"<p>Creates a new reader from the given <em>io</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""}],"args_string":"(io : IO, sync_close = <span class=\"n\">false</span>, &)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close = <span class=\"n\">false</span>, &)","location":{"filename":"src/compress/gzip/reader.cr","line_number":68,"url":null},"def":{"name":"open","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"reader = new(io, sync_close: sync_close)\nbegin\n  yield reader\nensure\n  reader.close\nend\n"}},{"id":"open(filename:String,&)-class-method","html_id":"open(filename:String,&)-class-method","name":"open","doc":"Creates a new reader from the given *filename*, yields it to the given block,\nand closes it at the end.","summary":"<p>Creates a new reader from the given <em>filename</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"}],"args_string":"(filename : String, &)","args_html":"(filename : <a href=\"../../String.html\">String</a>, &)","location":{"filename":"src/compress/gzip/reader.cr","line_number":75,"url":null},"def":{"name":"open","args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"reader = new(filename)\nbegin\n  yield reader\nensure\n  reader.close\nend\n"}}],"constructors":[{"id":"new(io:IO,sync_close=false)-class-method","html_id":"new(io:IO,sync_close=false)-class-method","name":"new","doc":"Creates a new reader from the given *io*.","summary":"<p>Creates a new reader from the given <em>io</em>.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""}],"args_string":"(io : IO, sync_close = <span class=\"n\">false</span>)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close = <span class=\"n\">false</span>)","location":{"filename":"src/compress/gzip/reader.cr","line_number":44,"url":null},"def":{"name":"new","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(io, sync_close)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(filename:String)-class-method","html_id":"new(filename:String)-class-method","name":"new","doc":"Creates a new reader from the given *filename*.","summary":"<p>Creates a new reader from the given <em>filename</em>.</p>","abstract":false,"args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"}],"args_string":"(filename : String)","args_html":"(filename : <a href=\"../../String.html\">String</a>)","location":{"filename":"src/compress/gzip/reader.cr","line_number":62,"url":null},"def":{"name":"new","args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"new(::File.new(filename), sync_close: true)"}}],"instance_methods":[{"id":"closed?:Bool-instance-method","html_id":"closed?:Bool-instance-method","name":"closed?","doc":"Returns `true` if this reader is closed.","summary":"<p>Returns <code>true</code> if this reader is closed.</p>","abstract":false,"args":[],"args_string":" : Bool","args_html":" : <a href=\"../../Bool.html\">Bool</a>","location":{"filename":"src/compress/gzip/reader.cr","line_number":36,"url":null},"def":{"name":"closed?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@closed"}},{"id":"header:Header?-instance-method","html_id":"header:Header?-instance-method","name":"header","doc":"Returns the first header in the gzip stream, if any.","summary":"<p>Returns the first header in the gzip stream, if any.</p>","abstract":false,"args":[],"args_string":" : Header?","args_html":" : <a href=\"../../Compress/Gzip/Header.html\">Header</a>?","location":{"filename":"src/compress/gzip/reader.cr","line_number":39,"url":null},"def":{"name":"header","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Header | ::Nil","visibility":"Public","body":"@header"}},{"id":"sync_close=(sync_close)-instance-method","html_id":"sync_close=(sync_close)-instance-method","name":"sync_close=","doc":"Whether to close the enclosed `IO` when closing this reader.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this reader.</p>","abstract":false,"args":[{"name":"sync_close","doc":null,"default_value":"","external_name":"sync_close","restriction":""}],"args_string":"(sync_close)","args_html":"(sync_close)","location":{"filename":"src/compress/gzip/reader.cr","line_number":33,"url":null},"def":{"name":"sync_close=","args":[{"name":"sync_close","doc":null,"default_value":"","external_name":"sync_close","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@sync_close = sync_close"}},{"id":"sync_close?:Bool-instance-method","html_id":"sync_close?:Bool-instance-method","name":"sync_close?","doc":"Whether to close the enclosed `IO` when closing this reader.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this reader.</p>","abstract":false,"args":[],"args_string":" : Bool","args_html":" : <a href=\"../../Bool.html\">Bool</a>","location":{"filename":"src/compress/gzip/reader.cr","line_number":33,"url":null},"def":{"name":"sync_close?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@sync_close"}},{"id":"unbuffered_close-instance-method","html_id":"unbuffered_close-instance-method","name":"unbuffered_close","doc":"Closes this reader.","summary":"<p>Closes this reader.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/gzip/reader.cr","line_number":141,"url":null},"def":{"name":"unbuffered_close","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if @closed\n  return\nend\n@closed = true\n@flate_io.try(&.close)\nif @sync_close\n  @io.close\nend\n"}},{"id":"unbuffered_flush-instance-method","html_id":"unbuffered_flush-instance-method","name":"unbuffered_flush","doc":"Flushes the wrapped `IO`.","summary":"<p>Flushes the wrapped <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/gzip/reader.cr","line_number":136,"url":null},"def":{"name":"unbuffered_flush","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"raise(IO::Error.new(\"Can't flush Compress::Gzip::Reader\"))"}},{"id":"unbuffered_read(slice:Bytes)-instance-method","html_id":"unbuffered_read(slice:Bytes)-instance-method","name":"unbuffered_read","doc":"See `IO#read`.","summary":"<p>See <code><a href=\"../../IO.html#read(slice:Bytes)-instance-method\">IO#read</a></code>.</p>","abstract":false,"args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes)","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>)","location":{"filename":"src/compress/gzip/reader.cr","line_number":81,"url":null},"def":{"name":"unbuffered_read","args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"check_open\nif slice.empty?\n  return 0\nend\nwhile true\n  flate_io = @flate_io\n  if flate_io\n  else\n    return 0\n  end\n  read_bytes = flate_io.read(slice)\n  if read_bytes == 0\n    crc32 = @io.read_bytes(UInt32, IO::ByteFormat::LittleEndian)\n    isize = @io.read_bytes(UInt32, IO::ByteFormat::LittleEndian)\n    if crc32 != @crc32\n      raise(Compress::Gzip::Error.new(\"CRC32 checksum mismatch\"))\n    end\n    if isize != @isize\n      raise(Compress::Gzip::Error.new(\"isize mismatch\"))\n    end\n    @crc32 = ::Digest::CRC32.initial\n    @isize = 0_u32\n    first_byte = @io.read_byte\n    if first_byte\n      Header.new(first_byte, @io)\n      @flate_io = Compress::Deflate::Reader.new(@io)\n    else\n      @flate_io = nil\n      break\n    end\n  else\n    @crc32 = ::Digest::CRC32.update(slice[0, read_bytes], @crc32)\n    @isize = @isize &+ read_bytes\n    break\n  end\nend\nread_bytes\n"}},{"id":"unbuffered_rewind-instance-method","html_id":"unbuffered_rewind-instance-method","name":"unbuffered_rewind","doc":"Rewinds the wrapped `IO`.","summary":"<p>Rewinds the wrapped <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/gzip/reader.cr","line_number":149,"url":null},"def":{"name":"unbuffered_rewind","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"check_open\n@io.rewind\n@header = nil\n@flate_io = nil\ninitialize(@io, @sync_close)\n"}},{"id":"unbuffered_write(slice:Bytes):Nil-instance-method","html_id":"unbuffered_write(slice:Bytes):Nil-instance-method","name":"unbuffered_write","doc":"Always raises `IO::Error` because this is a read-only `IO`.","summary":"<p>Always raises <code><a href=\"../../IO/Error.html\">IO::Error</a></code> because this is a read-only <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes) : Nil","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>) : <a href=\"../../Nil.html\">Nil</a>","location":{"filename":"src/compress/gzip/reader.cr","line_number":132,"url":null},"def":{"name":"unbuffered_write","args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"raise(IO::Error.new(\"Can't write to Compress::Gzip::Reader\"))"}}],"macros":[],"types":[]},{"html_id":"Crystal/Compress/Gzip/Writer","path":"Compress/Gzip/Writer.html","kind":"class","full_name":"Compress::Gzip::Writer","name":"Writer","abstract":false,"superclass":{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},"ancestors":[{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Compress/Gzip","kind":"module","full_name":"Compress::Gzip","name":"Gzip"},"doc":"A write-only `IO` object to compress data in the gzip format.\n\nInstances of this class wrap another `IO` object. When you write to this\ninstance, it compresses the data and writes it to the underlying `IO`.\n\nNOTE: unless created with a block, `close` must be invoked after all\ndata has been written to a `Gzip::Writer` instance.\n\n### Example: compress a file\n\n```\nrequire \"compress/gzip\"\n\nFile.write(\"file.txt\", \"abc\")\n\nFile.open(\"./file.txt\", \"r\") do |input_file|\n  File.open(\"./file.gzip\", \"w\") do |output_file|\n    Compress::Gzip::Writer.open(output_file) do |gzip|\n      IO.copy(input_file, gzip)\n    end\n  end\nend\n```","summary":"<p>A write-only <code><a href=\"../../IO.html\">IO</a></code> object to compress data in the gzip format.</p>","class_methods":[{"id":"open(io:IO,level=Compress::Gzip::DEFAULT_COMPRESSION,sync_close=false,&)-class-method","html_id":"open(io:IO,level=Compress::Gzip::DEFAULT_COMPRESSION,sync_close=false,&)-class-method","name":"open","doc":"Creates a new writer to the given *io*, yields it to the given block,\nand closes it at the end.","summary":"<p>Creates a new writer to the given <em>io</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"level","doc":null,"default_value":"Compress::Gzip::DEFAULT_COMPRESSION","external_name":"level","restriction":""},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""}],"args_string":"(io : IO, level = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Gzip</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, sync_close = <span class=\"n\">false</span>, &)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, level = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Gzip</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, sync_close = <span class=\"n\">false</span>, &)","location":{"filename":"src/compress/gzip/writer.cr","line_number":53,"url":null},"def":{"name":"open","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"level","doc":null,"default_value":"Compress::Gzip::DEFAULT_COMPRESSION","external_name":"level","restriction":""},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"writer = new(io, level: level, sync_close: sync_close)\nbegin\n  yield writer\nensure\n  writer.close\nend\n"}},{"id":"open(filename:String,level=Compress::Gzip::DEFAULT_COMPRESSION,&)-class-method","html_id":"open(filename:String,level=Compress::Gzip::DEFAULT_COMPRESSION,&)-class-method","name":"open","doc":"Creates a new writer to the given *filename*, yields it to the given block,\nand closes it at the end.","summary":"<p>Creates a new writer to the given <em>filename</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"},{"name":"level","doc":null,"default_value":"Compress::Gzip::DEFAULT_COMPRESSION","external_name":"level","restriction":""}],"args_string":"(filename : String, level = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Gzip</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, &)","args_html":"(filename : <a href=\"../../String.html\">String</a>, level = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Gzip</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, &)","location":{"filename":"src/compress/gzip/writer.cr","line_number":60,"url":null},"def":{"name":"open","args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"},{"name":"level","doc":null,"default_value":"Compress::Gzip::DEFAULT_COMPRESSION","external_name":"level","restriction":""}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"writer = new(filename, level: level)\nbegin\n  yield writer\nensure\n  writer.close\nend\n"}}],"constructors":[{"id":"new(io:IO,level=Compress::Gzip::DEFAULT_COMPRESSION,sync_close=false)-class-method","html_id":"new(io:IO,level=Compress::Gzip::DEFAULT_COMPRESSION,sync_close=false)-class-method","name":"new","doc":"Creates a new writer to the given *io*.","summary":"<p>Creates a new writer to the given <em>io</em>.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"level","doc":null,"default_value":"Compress::Gzip::DEFAULT_COMPRESSION","external_name":"level","restriction":""},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""}],"args_string":"(io : IO, level = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Gzip</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, sync_close = <span class=\"n\">false</span>)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, level = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Gzip</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, sync_close = <span class=\"n\">false</span>)","location":{"filename":"src/compress/gzip/writer.cr","line_number":38,"url":null},"def":{"name":"new","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"level","doc":null,"default_value":"Compress::Gzip::DEFAULT_COMPRESSION","external_name":"level","restriction":""},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(io, level, sync_close)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(filename:String,level=Compress::Gzip::DEFAULT_COMPRESSION)-class-method","html_id":"new(filename:String,level=Compress::Gzip::DEFAULT_COMPRESSION)-class-method","name":"new","doc":"Creates a new writer to the given *filename*.","summary":"<p>Creates a new writer to the given <em>filename</em>.</p>","abstract":false,"args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"},{"name":"level","doc":null,"default_value":"Compress::Gzip::DEFAULT_COMPRESSION","external_name":"level","restriction":""}],"args_string":"(filename : String, level = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Gzip</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>)","args_html":"(filename : <a href=\"../../String.html\">String</a>, level = <span class=\"t\">Compress</span><span class=\"t\">::</span><span class=\"t\">Gzip</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>)","location":{"filename":"src/compress/gzip/writer.cr","line_number":47,"url":null},"def":{"name":"new","args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"},{"name":"level","doc":null,"default_value":"Compress::Gzip::DEFAULT_COMPRESSION","external_name":"level","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"new(::File.new(filename, \"w\"), level: level, sync_close: true)"}}],"instance_methods":[{"id":"close-instance-method","html_id":"close-instance-method","name":"close","doc":"Closes this writer. Must be invoked after all data has been written.","summary":"<p>Closes this writer.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/gzip/writer.cr","line_number":99,"url":null},"def":{"name":"close","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if @closed\n  return\nend\n@closed = true\nflate_io = write_header\nflate_io.close\n@io.write_bytes(@crc32, IO::ByteFormat::LittleEndian)\n@io.write_bytes(@isize, IO::ByteFormat::LittleEndian)\nif @sync_close\n  @io.close\nend\n"}},{"id":"closed?:Bool-instance-method","html_id":"closed?:Bool-instance-method","name":"closed?","doc":"Returns `true` if this writer is closed.","summary":"<p>Returns <code>true</code> if this writer is closed.</p>","abstract":false,"args":[],"args_string":" : Bool","args_html":" : <a href=\"../../Bool.html\">Bool</a>","location":{"filename":"src/compress/gzip/writer.cr","line_number":29,"url":null},"def":{"name":"closed?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@closed"}},{"id":"flush-instance-method","html_id":"flush-instance-method","name":"flush","doc":"Flushes data, forcing writing the gzip header if no\ndata has been written yet.\n\nSee `IO#flush`.","summary":"<p>Flushes data, forcing writing the gzip header if no data has been written yet.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/gzip/writer.cr","line_number":91,"url":null},"def":{"name":"flush","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"check_open\nflate_io = write_header\nflate_io.flush\n"}},{"id":"header:Compress::Gzip::Header-instance-method","html_id":"header:Compress::Gzip::Header-instance-method","name":"header","doc":"The header to write to the gzip stream. It will be\nwritten just before the first write to this writer.\nChanges to the header after the first write are\nignored.","summary":"<p>The header to write to the gzip stream.</p>","abstract":false,"args":[],"args_string":" : Compress::Gzip::Header","args_html":" : <a href=\"../../Compress/Gzip/Header.html\">Compress::Gzip::Header</a>","location":{"filename":"src/compress/gzip/writer.cr","line_number":35,"url":null},"def":{"name":"header","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@header"}},{"id":"read(slice:Bytes)-instance-method","html_id":"read(slice:Bytes)-instance-method","name":"read","doc":"Always raises `IO::Error` because this is a write-only `IO`.","summary":"<p>Always raises <code><a href=\"../../IO/Error.html\">IO::Error</a></code> because this is a write-only <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes)","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>)","location":{"filename":"src/compress/gzip/writer.cr","line_number":66,"url":null},"def":{"name":"read","args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"raise(IO::Error.new(\"Can't read from Gzip::Writer\"))"}},{"id":"sync_close=(sync_close)-instance-method","html_id":"sync_close=(sync_close)-instance-method","name":"sync_close=","doc":"Whether to close the enclosed `IO` when closing this writer.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this writer.</p>","abstract":false,"args":[{"name":"sync_close","doc":null,"default_value":"","external_name":"sync_close","restriction":""}],"args_string":"(sync_close)","args_html":"(sync_close)","location":{"filename":"src/compress/gzip/writer.cr","line_number":26,"url":null},"def":{"name":"sync_close=","args":[{"name":"sync_close","doc":null,"default_value":"","external_name":"sync_close","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@sync_close = sync_close"}},{"id":"sync_close?:Bool-instance-method","html_id":"sync_close?:Bool-instance-method","name":"sync_close?","doc":"Whether to close the enclosed `IO` when closing this writer.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this writer.</p>","abstract":false,"args":[],"args_string":" : Bool","args_html":" : <a href=\"../../Bool.html\">Bool</a>","location":{"filename":"src/compress/gzip/writer.cr","line_number":26,"url":null},"def":{"name":"sync_close?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@sync_close"}},{"id":"write(slice:Bytes):Nil-instance-method","html_id":"write(slice:Bytes):Nil-instance-method","name":"write","doc":"See `IO#write`.","summary":"<p>See <code><a href=\"../../IO.html#write(slice:Bytes):Nil-instance-method\">IO#write</a></code>.</p>","abstract":false,"args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes) : Nil","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>) : <a href=\"../../Nil.html\">Nil</a>","location":{"filename":"src/compress/gzip/writer.cr","line_number":71,"url":null},"def":{"name":"write","args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"check_open\nif slice.empty?\n  return\nend\nflate_io = write_header\nflate_io.write(slice)\n@crc32 = ::Digest::CRC32.update(slice, @crc32)\n@isize = @isize &+ slice.size\n"}}],"macros":[],"types":[]}]},{"html_id":"Crystal/Compress/Zip","path":"Compress/Zip.html","kind":"module","full_name":"Compress::Zip","name":"Zip","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[{"id":"CENTRAL_DIRECTORY_HEADER_SIGNATURE","name":"CENTRAL_DIRECTORY_HEADER_SIGNATURE","value":"33639248","doc":null,"summary":null},{"id":"END_OF_CENTRAL_DIRECTORY_HEADER_SIGNATURE","name":"END_OF_CENTRAL_DIRECTORY_HEADER_SIGNATURE","value":"101010256","doc":null,"summary":null},{"id":"VERSION","name":"VERSION","value":"20_u16","doc":null,"summary":null}],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Compress","kind":"module","full_name":"Compress","name":"Compress"},"doc":"The Compress::Zip module contains readers and writers of the zip\nfile format, described at [PKWARE's site](https://pkware.cachefly.net/webdocs/APPNOTE/APPNOTE-6.3.3.TXT).\n\n### Reading zip files\n\nTwo types are provided to read from zip files:\n* `Compress::Zip::File`: can read zip entries from a `File` or from an `IO::Memory`\nand provides random read access to its entries.\n* `Compress::Zip::Reader`: can only read zip entries sequentially from any `IO`.\n\n`Compress::Zip::File` is the preferred method to read zip files if you\ncan provide a `File`, because it's a bit more flexible and provides\nmore complete information for zip entries (such as comments).\n\nWhen reading zip files, CRC32 checksum values are automatically\nverified when finishing reading an entry, and `Compress::Zip::Error` will\nbe raised if the computed CRC32 checksum does not match.\n\n### Writer zip files\n\nUse `Compress::Zip::Writer`, which writes zip entries sequentially to\nany `IO`.\n\nNOTE: only compression methods 0 (STORED) and 8 (DEFLATED) are\nsupported. Additionally, ZIP64 is not yet supported.","summary":"<p>The Compress::Zip module contains readers and writers of the zip file format, described at <a href=\"https://pkware.cachefly.net/webdocs/APPNOTE/APPNOTE-6.3.3.TXT\">PKWARE's site</a>.</p>","class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[{"html_id":"Crystal/Compress/Zip/CompressionMethod","path":"Compress/Zip/CompressionMethod.html","kind":"enum","full_name":"Compress::Zip::CompressionMethod","name":"CompressionMethod","abstract":false,"superclass":null,"ancestors":[{"html_id":"Crystal/Enum","kind":"struct","full_name":"Enum","name":"Enum"},{"html_id":"Crystal/Comparable","kind":"module","full_name":"Comparable","name":"Comparable"},{"html_id":"Crystal/Value","kind":"struct","full_name":"Value","name":"Value"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":true,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[{"id":"STORED","name":"STORED","value":"0_u16","doc":null,"summary":null},{"id":"DEFLATED","name":"DEFLATED","value":"8_u16","doc":null,"summary":null}],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Compress/Zip","kind":"module","full_name":"Compress::Zip","name":"Zip"},"doc":"Supported compression methods in the current implementation.","summary":"<p>Supported compression methods in the current implementation.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"deflated?-instance-method","html_id":"deflated?-instance-method","name":"deflated?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/zip/compression_method.cr","line_number":4,"url":null},"def":{"name":"deflated?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == DEFLATED"}},{"id":"stored?-instance-method","html_id":"stored?-instance-method","name":"stored?","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/zip/compression_method.cr","line_number":3,"url":null},"def":{"name":"stored?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"self == STORED"}}],"macros":[],"types":[]},{"html_id":"Crystal/Compress/Zip/Error","path":"Compress/Zip/Error.html","kind":"class","full_name":"Compress::Zip::Error","name":"Error","abstract":false,"superclass":{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},"ancestors":[{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Compress/Zip","kind":"module","full_name":"Compress::Zip","name":"Zip"},"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"Crystal/Compress/Zip/File","path":"Compress/Zip/File.html","kind":"class","full_name":"Compress::Zip::File","name":"File","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Compress/Zip","kind":"module","full_name":"Compress::Zip","name":"Zip"},"doc":"Provides random read access to zip file entries stores inside\na `File` or an `IO::Memory`.\n\n### Example\n\n```\nrequire \"compress/zip\"\n\nCompress::Zip::File.open(\"./file.zip\") do |file|\n  # Iterate through all entries printing their filename and contents\n  file.entries.each do |entry|\n    p entry.filename\n    entry.open do |io|\n      p io.gets_to_end\n    end\n  end\n\n  # Random access to entries by filename is also provided\n  entry = file[\"some_file.txt\"]\n  entry.open do |io|\n    p io.gets_to_end\n  end\nend\n```","summary":"<p>Provides random read access to zip file entries stores inside a <code><a href=\"../../Compress/Zip/File.html\">File</a></code> or an <code><a href=\"../../IO/Memory.html\">IO::Memory</a></code>.</p>","class_methods":[{"id":"open(io:IO,sync_close=false,&)-class-method","html_id":"open(io:IO,sync_close=false,&)-class-method","name":"open","doc":"Opens a `Zip::File` for reading from the given *io*, yields\nit to the given block, and closes it at the end.","summary":"<p>Opens a <code><a href=\"../../Compress/Zip/File.html\">Zip::File</a></code> for reading from the given <em>io</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""}],"args_string":"(io : IO, sync_close = <span class=\"n\">false</span>, &)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close = <span class=\"n\">false</span>, &)","location":{"filename":"src/compress/zip/file.cr","line_number":53,"url":null},"def":{"name":"open","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"zip = new(io, sync_close)\nbegin\n  yield zip\nensure\n  zip.close\nend\n"}},{"id":"open(filename:String,&)-class-method","html_id":"open(filename:String,&)-class-method","name":"open","doc":"Opens a `Zip::File` for reading from the given *filename*, yields\nit to the given block, and closes it at the end.","summary":"<p>Opens a <code><a href=\"../../Compress/Zip/File.html\">Zip::File</a></code> for reading from the given <em>filename</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"}],"args_string":"(filename : String, &)","args_html":"(filename : <a href=\"../../String.html\">String</a>, &)","location":{"filename":"src/compress/zip/file.cr","line_number":60,"url":null},"def":{"name":"open","args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"zip = new(filename)\nbegin\n  yield zip\nensure\n  zip.close\nend\n"}}],"constructors":[{"id":"new(io:IO,sync_close=false)-class-method","html_id":"new(io:IO,sync_close=false)-class-method","name":"new","doc":"Opens a `Zip::File` for reading from the given *io*.","summary":"<p>Opens a <code><a href=\"../../Compress/Zip/File.html\">Zip::File</a></code> for reading from the given <em>io</em>.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""}],"args_string":"(io : IO, sync_close = <span class=\"n\">false</span>)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close = <span class=\"n\">false</span>)","location":{"filename":"src/compress/zip/file.cr","line_number":38,"url":null},"def":{"name":"new","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(io, sync_close)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(filename:String)-class-method","html_id":"new(filename:String)-class-method","name":"new","doc":"Opens a `Zip::File` for reading from the given *filename*.","summary":"<p>Opens a <code><a href=\"../../Compress/Zip/File.html\">Zip::File</a></code> for reading from the given <em>filename</em>.</p>","abstract":false,"args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"}],"args_string":"(filename : String)","args_html":"(filename : <a href=\"../../String.html\">String</a>)","location":{"filename":"src/compress/zip/file.cr","line_number":47,"url":null},"def":{"name":"new","args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"new(::File.new(filename), sync_close: true)"}}],"instance_methods":[{"id":"[](filename:String):Entry-instance-method","html_id":"[](filename:String):Entry-instance-method","name":"[]","doc":"Returns the entry that has the given filename, or\nraises `KeyError` if no such entry exists.","summary":"<p>Returns the entry that has the given filename, or raises <code><a href=\"../../KeyError.html\">KeyError</a></code> if no such entry exists.</p>","abstract":false,"args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"}],"args_string":"(filename : String) : Entry","args_html":"(filename : <a href=\"../../String.html\">String</a>) : <a href=\"../../Compress/Zip/File/Entry.html\">Entry</a>","location":{"filename":"src/compress/zip/file.cr","line_number":67,"url":null},"def":{"name":"[]","args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Entry","visibility":"Public","body":"self[filename]? || (raise(KeyError.new(\"Missing zip entry: #{filename}\")))"}},{"id":"[]?(filename:String):Entry?-instance-method","html_id":"[]?(filename:String):Entry?-instance-method","name":"[]?","doc":"Returns the entry that has the given filename, or\n`nil` if no such entry exists.","summary":"<p>Returns the entry that has the given filename, or <code>nil</code> if no such entry exists.</p>","abstract":false,"args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"}],"args_string":"(filename : String) : Entry?","args_html":"(filename : <a href=\"../../String.html\">String</a>) : <a href=\"../../Compress/Zip/File/Entry.html\">Entry</a>?","location":{"filename":"src/compress/zip/file.cr","line_number":73,"url":null},"def":{"name":"[]?","args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Entry | ::Nil","visibility":"Public","body":"@entries_by_filename[filename]?"}},{"id":"close-instance-method","html_id":"close-instance-method","name":"close","doc":"Closes this zip file.","summary":"<p>Closes this zip file.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/zip/file.cr","line_number":78,"url":null},"def":{"name":"close","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if @closed\n  return\nend\n@closed = true\nif @sync_close\n  @io.close\nend\n"}},{"id":"closed?:Bool-instance-method","html_id":"closed?:Bool-instance-method","name":"closed?","doc":"Returns `true` if this zip file is closed.","summary":"<p>Returns <code>true</code> if this zip file is closed.</p>","abstract":false,"args":[],"args_string":" : Bool","args_html":" : <a href=\"../../Bool.html\">Bool</a>","location":{"filename":"src/compress/zip/file.cr","line_number":32,"url":null},"def":{"name":"closed?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@closed"}},{"id":"comment:String-instance-method","html_id":"comment:String-instance-method","name":"comment","doc":"Returns the zip file comment.","summary":"<p>Returns the zip file comment.</p>","abstract":false,"args":[],"args_string":" : String","args_html":" : <a href=\"../../String.html\">String</a>","location":{"filename":"src/compress/zip/file.cr","line_number":35,"url":null},"def":{"name":"comment","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@comment"}},{"id":"entries:Array(Entry)-instance-method","html_id":"entries:Array(Entry)-instance-method","name":"entries","doc":"Returns all entries inside this zip file.","summary":"<p>Returns all entries inside this zip file.</p>","abstract":false,"args":[],"args_string":" : Array(Entry)","args_html":" : <a href=\"../../Array.html\">Array</a>(<a href=\"../../Compress/Zip/File/Entry.html\">Entry</a>)","location":{"filename":"src/compress/zip/file.cr","line_number":29,"url":null},"def":{"name":"entries","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Array(Entry)","visibility":"Public","body":"@entries"}}],"macros":[],"types":[{"html_id":"Crystal/Compress/Zip/File/Entry","path":"Compress/Zip/File/Entry.html","kind":"class","full_name":"Compress::Zip::File::Entry","name":"Entry","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Compress/Zip/FileInfo","kind":"module","full_name":"Compress::Zip::FileInfo","name":"FileInfo"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[{"html_id":"Crystal/Compress/Zip/FileInfo","kind":"module","full_name":"Compress::Zip::FileInfo","name":"FileInfo"}],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Compress/Zip/File","kind":"class","full_name":"Compress::Zip::File","name":"File"},"doc":"An entry inside a `Zip::File`.\n\nUse the `open` method to read from it.","summary":"<p>An entry inside a <code><a href=\"../../../Compress/Zip/File.html\">Zip::File</a></code>.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"open(&)-instance-method","html_id":"open(&)-instance-method","name":"open","doc":"Yields an `IO` to read this entry's contents.\nMultiple entries can be opened and read concurrently.","summary":"<p>Yields an <code><a href=\"../../../IO.html\">IO</a></code> to read this entry's contents.</p>","abstract":false,"args":[],"args_string":"(&)","args_html":"(&)","location":{"filename":"src/compress/zip/file.cr","line_number":169,"url":null},"def":{"name":"open","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"@io.read_at(data_offset.to_i32, compressed_size.to_i32) do |io|\n  io = decompressor_for(io, is_sized: true)\n  checksum_reader = ChecksumReader.new(io, filename, verify: crc32)\n  yield checksum_reader\nend"}}],"macros":[],"types":[]}]},{"html_id":"Crystal/Compress/Zip/FileInfo","path":"Compress/Zip/FileInfo.html","kind":"module","full_name":"Compress::Zip::FileInfo","name":"FileInfo","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[{"id":"DATA_DESCRIPTOR_SIGNATURE","name":"DATA_DESCRIPTOR_SIGNATURE","value":"134695760","doc":null,"summary":null},{"id":"DEFLATE_END_SIGNATURE","name":"DEFLATE_END_SIGNATURE","value":"Bytes[80, 75, 7, 8, read_only: true]","doc":null,"summary":null},{"id":"SIGNATURE","name":"SIGNATURE","value":"67324752","doc":null,"summary":null}],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[{"html_id":"Crystal/Compress/Zip/File/Entry","kind":"class","full_name":"Compress::Zip::File::Entry","name":"Entry"},{"html_id":"Crystal/Compress/Zip/Reader/Entry","kind":"class","full_name":"Compress::Zip::Reader::Entry","name":"Entry"},{"html_id":"Crystal/Compress/Zip/Writer/Entry","kind":"class","full_name":"Compress::Zip::Writer::Entry","name":"Entry"}],"namespace":{"html_id":"Crystal/Compress/Zip","kind":"module","full_name":"Compress::Zip","name":"Zip"},"doc":"Base type for file information related to zip entries.","summary":"<p>Base type for file information related to zip entries.</p>","class_methods":[],"constructors":[{"id":"new(filename:String,time=Time.utc,comment=&quot;&quot;,extra=Bytes.empty)-class-method","html_id":"new(filename:String,time=Time.utc,comment=&quot;&quot;,extra=Bytes.empty)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"},{"name":"time","doc":null,"default_value":"Time.utc","external_name":"time","restriction":""},{"name":"comment","doc":null,"default_value":"\"\"","external_name":"comment","restriction":""},{"name":"extra","doc":null,"default_value":"Bytes.empty","external_name":"extra","restriction":""}],"args_string":"(filename : String, time = <span class=\"t\">Time</span>.utc, comment = <span class=\"s\">&quot;&quot;</span>, extra = <span class=\"t\">Bytes</span>.empty)","args_html":"(filename : <a href=\"../../String.html\">String</a>, time = <span class=\"t\">Time</span>.utc, comment = <span class=\"s\">&quot;&quot;</span>, extra = <span class=\"t\">Bytes</span>.empty)","location":{"filename":"src/compress/zip/file_info.cr","line_number":68,"url":null},"def":{"name":"new","args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"},{"name":"time","doc":null,"default_value":"Time.utc","external_name":"time","restriction":""},{"name":"comment","doc":null,"default_value":"\"\"","external_name":"comment","restriction":""},{"name":"extra","doc":null,"default_value":"Bytes.empty","external_name":"extra","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(filename, time, comment, extra)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"comment-instance-method","html_id":"comment-instance-method","name":"comment","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/zip/file_info.cr","line_number":17,"url":null},"def":{"name":"comment","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@comment"}},{"id":"comment=(comment)-instance-method","html_id":"comment=(comment)-instance-method","name":"comment=","doc":null,"summary":null,"abstract":false,"args":[{"name":"comment","doc":null,"default_value":"","external_name":"comment","restriction":""}],"args_string":"(comment)","args_html":"(comment)","location":{"filename":"src/compress/zip/file_info.cr","line_number":17,"url":null},"def":{"name":"comment=","args":[{"name":"comment","doc":null,"default_value":"","external_name":"comment","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@comment = comment"}},{"id":"compressed_size-instance-method","html_id":"compressed_size-instance-method","name":"compressed_size","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/zip/file_info.cr","line_number":13,"url":null},"def":{"name":"compressed_size","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@compressed_size"}},{"id":"compressed_size=(compressed_size)-instance-method","html_id":"compressed_size=(compressed_size)-instance-method","name":"compressed_size=","doc":null,"summary":null,"abstract":false,"args":[{"name":"compressed_size","doc":null,"default_value":"","external_name":"compressed_size","restriction":""}],"args_string":"(compressed_size)","args_html":"(compressed_size)","location":{"filename":"src/compress/zip/file_info.cr","line_number":13,"url":null},"def":{"name":"compressed_size=","args":[{"name":"compressed_size","doc":null,"default_value":"","external_name":"compressed_size","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@compressed_size = compressed_size"}},{"id":"compression_method-instance-method","html_id":"compression_method-instance-method","name":"compression_method","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/zip/file_info.cr","line_number":10,"url":null},"def":{"name":"compression_method","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@compression_method"}},{"id":"compression_method=(compression_method)-instance-method","html_id":"compression_method=(compression_method)-instance-method","name":"compression_method=","doc":null,"summary":null,"abstract":false,"args":[{"name":"compression_method","doc":null,"default_value":"","external_name":"compression_method","restriction":""}],"args_string":"(compression_method)","args_html":"(compression_method)","location":{"filename":"src/compress/zip/file_info.cr","line_number":10,"url":null},"def":{"name":"compression_method=","args":[{"name":"compression_method","doc":null,"default_value":"","external_name":"compression_method","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@compression_method = compression_method"}},{"id":"crc32-instance-method","html_id":"crc32-instance-method","name":"crc32","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/zip/file_info.cr","line_number":12,"url":null},"def":{"name":"crc32","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@crc32"}},{"id":"crc32=(crc32)-instance-method","html_id":"crc32=(crc32)-instance-method","name":"crc32=","doc":null,"summary":null,"abstract":false,"args":[{"name":"crc32","doc":null,"default_value":"","external_name":"crc32","restriction":""}],"args_string":"(crc32)","args_html":"(crc32)","location":{"filename":"src/compress/zip/file_info.cr","line_number":12,"url":null},"def":{"name":"crc32=","args":[{"name":"crc32","doc":null,"default_value":"","external_name":"crc32","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@crc32 = crc32"}},{"id":"dir?-instance-method","html_id":"dir?-instance-method","name":"dir?","doc":"Returns `true` if this entry is a directory.","summary":"<p>Returns <code>true</code> if this entry is a directory.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/zip/file_info.cr","line_number":72,"url":null},"def":{"name":"dir?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"filename.ends_with?('/')"}},{"id":"extra-instance-method","html_id":"extra-instance-method","name":"extra","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/zip/file_info.cr","line_number":16,"url":null},"def":{"name":"extra","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@extra"}},{"id":"extra=(extra)-instance-method","html_id":"extra=(extra)-instance-method","name":"extra=","doc":null,"summary":null,"abstract":false,"args":[{"name":"extra","doc":null,"default_value":"","external_name":"extra","restriction":""}],"args_string":"(extra)","args_html":"(extra)","location":{"filename":"src/compress/zip/file_info.cr","line_number":16,"url":null},"def":{"name":"extra=","args":[{"name":"extra","doc":null,"default_value":"","external_name":"extra","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@extra = extra"}},{"id":"file?-instance-method","html_id":"file?-instance-method","name":"file?","doc":"Returns `true` if this entry is a file.","summary":"<p>Returns <code>true</code> if this entry is a file.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/zip/file_info.cr","line_number":77,"url":null},"def":{"name":"file?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"!dir?"}},{"id":"filename-instance-method","html_id":"filename-instance-method","name":"filename","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/zip/file_info.cr","line_number":15,"url":null},"def":{"name":"filename","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@filename"}},{"id":"filename=(filename)-instance-method","html_id":"filename=(filename)-instance-method","name":"filename=","doc":null,"summary":null,"abstract":false,"args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":""}],"args_string":"(filename)","args_html":"(filename)","location":{"filename":"src/compress/zip/file_info.cr","line_number":15,"url":null},"def":{"name":"filename=","args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@filename = filename"}},{"id":"general_purpose_bit_flag-instance-method","html_id":"general_purpose_bit_flag-instance-method","name":"general_purpose_bit_flag","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/zip/file_info.cr","line_number":9,"url":null},"def":{"name":"general_purpose_bit_flag","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@general_purpose_bit_flag"}},{"id":"general_purpose_bit_flag=(general_purpose_bit_flag)-instance-method","html_id":"general_purpose_bit_flag=(general_purpose_bit_flag)-instance-method","name":"general_purpose_bit_flag=","doc":null,"summary":null,"abstract":false,"args":[{"name":"general_purpose_bit_flag","doc":null,"default_value":"","external_name":"general_purpose_bit_flag","restriction":""}],"args_string":"(general_purpose_bit_flag)","args_html":"(general_purpose_bit_flag)","location":{"filename":"src/compress/zip/file_info.cr","line_number":9,"url":null},"def":{"name":"general_purpose_bit_flag=","args":[{"name":"general_purpose_bit_flag","doc":null,"default_value":"","external_name":"general_purpose_bit_flag","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@general_purpose_bit_flag = general_purpose_bit_flag"}},{"id":"offset-instance-method","html_id":"offset-instance-method","name":"offset","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/zip/file_info.cr","line_number":18,"url":null},"def":{"name":"offset","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@offset"}},{"id":"offset=(offset)-instance-method","html_id":"offset=(offset)-instance-method","name":"offset=","doc":null,"summary":null,"abstract":false,"args":[{"name":"offset","doc":null,"default_value":"","external_name":"offset","restriction":""}],"args_string":"(offset)","args_html":"(offset)","location":{"filename":"src/compress/zip/file_info.cr","line_number":18,"url":null},"def":{"name":"offset=","args":[{"name":"offset","doc":null,"default_value":"","external_name":"offset","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@offset = offset"}},{"id":"time:Time-instance-method","html_id":"time:Time-instance-method","name":"time","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Time","args_html":" : <a href=\"../../Time.html\">Time</a>","location":{"filename":"src/compress/zip/file_info.cr","line_number":11,"url":null},"def":{"name":"time","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Time","visibility":"Public","body":"@time"}},{"id":"time=(time:Time)-instance-method","html_id":"time=(time:Time)-instance-method","name":"time=","doc":null,"summary":null,"abstract":false,"args":[{"name":"time","doc":null,"default_value":"","external_name":"time","restriction":"Time"}],"args_string":"(time : Time)","args_html":"(time : <a href=\"../../Time.html\">Time</a>)","location":{"filename":"src/compress/zip/file_info.cr","line_number":11,"url":null},"def":{"name":"time=","args":[{"name":"time","doc":null,"default_value":"","external_name":"time","restriction":"Time"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@time = time"}},{"id":"uncompressed_size-instance-method","html_id":"uncompressed_size-instance-method","name":"uncompressed_size","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/zip/file_info.cr","line_number":14,"url":null},"def":{"name":"uncompressed_size","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@uncompressed_size"}},{"id":"uncompressed_size=(uncompressed_size)-instance-method","html_id":"uncompressed_size=(uncompressed_size)-instance-method","name":"uncompressed_size=","doc":null,"summary":null,"abstract":false,"args":[{"name":"uncompressed_size","doc":null,"default_value":"","external_name":"uncompressed_size","restriction":""}],"args_string":"(uncompressed_size)","args_html":"(uncompressed_size)","location":{"filename":"src/compress/zip/file_info.cr","line_number":14,"url":null},"def":{"name":"uncompressed_size=","args":[{"name":"uncompressed_size","doc":null,"default_value":"","external_name":"uncompressed_size","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@uncompressed_size = uncompressed_size"}},{"id":"version:UInt16-instance-method","html_id":"version:UInt16-instance-method","name":"version","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : UInt16","args_html":" : <a href=\"../../UInt16.html\">UInt16</a>","location":{"filename":"src/compress/zip/file_info.cr","line_number":8,"url":null},"def":{"name":"version","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"UInt16","visibility":"Public","body":"@version"}},{"id":"version=(version:UInt16)-instance-method","html_id":"version=(version:UInt16)-instance-method","name":"version=","doc":null,"summary":null,"abstract":false,"args":[{"name":"version","doc":null,"default_value":"","external_name":"version","restriction":"UInt16"}],"args_string":"(version : UInt16)","args_html":"(version : <a href=\"../../UInt16.html\">UInt16</a>)","location":{"filename":"src/compress/zip/file_info.cr","line_number":8,"url":null},"def":{"name":"version=","args":[{"name":"version","doc":null,"default_value":"","external_name":"version","restriction":"UInt16"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@version = version"}}],"macros":[],"types":[]},{"html_id":"Crystal/Compress/Zip/Reader","path":"Compress/Zip/Reader.html","kind":"class","full_name":"Compress::Zip::Reader","name":"Reader","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Compress/Zip","kind":"module","full_name":"Compress::Zip","name":"Zip"},"doc":"Reads zip file entries sequentially from an `IO`.\n\nNOTE: Entries might not have correct values\nfor crc32, compressed_size, uncompressed_size and comment,\nbecause when reading a zip file directly from a stream this\ninformation might be stored later in the zip stream.\nIf you need this information, consider using `Zip::File`.\n\n### Example\n\n```\nrequire \"compress/zip\"\n\nCompress::Zip::Reader.open(\"./file.zip\") do |zip|\n  zip.each_entry do |entry|\n    p entry.filename\n    p entry.file?\n    p entry.dir?\n    p entry.io.gets_to_end\n  end\nend\n```","summary":"<p>Reads zip file entries sequentially from an <code><a href=\"../../IO.html\">IO</a></code>.</p>","class_methods":[{"id":"open(io:IO,sync_close=false,&)-class-method","html_id":"open(io:IO,sync_close=false,&)-class-method","name":"open","doc":"Creates a new reader from the given *io*, yields it to the given block,\nand closes it at the end.","summary":"<p>Creates a new reader from the given <em>io</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""}],"args_string":"(io : IO, sync_close = <span class=\"n\">false</span>, &)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close = <span class=\"n\">false</span>, &)","location":{"filename":"src/compress/zip/reader.cr","line_number":45,"url":null},"def":{"name":"open","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"reader = new(io, sync_close: sync_close)\nbegin\n  yield reader\nensure\n  reader.close\nend\n"}},{"id":"open(filename:String,&)-class-method","html_id":"open(filename:String,&)-class-method","name":"open","doc":"Creates a new reader from the given *filename*, yields it to the given block,\nand closes it at the end.","summary":"<p>Creates a new reader from the given <em>filename</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"}],"args_string":"(filename : String, &)","args_html":"(filename : <a href=\"../../String.html\">String</a>, &)","location":{"filename":"src/compress/zip/reader.cr","line_number":52,"url":null},"def":{"name":"open","args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"reader = new(filename)\nbegin\n  yield reader\nensure\n  reader.close\nend\n"}}],"constructors":[{"id":"new(io:IO,sync_close=false)-class-method","html_id":"new(io:IO,sync_close=false)-class-method","name":"new","doc":"Creates a new reader from the given *io*.","summary":"<p>Creates a new reader from the given <em>io</em>.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""}],"args_string":"(io : IO, sync_close = <span class=\"n\">false</span>)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close = <span class=\"n\">false</span>)","location":{"filename":"src/compress/zip/reader.cr","line_number":33,"url":null},"def":{"name":"new","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(io, sync_close)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(filename:String)-class-method","html_id":"new(filename:String)-class-method","name":"new","doc":"Creates a new reader from the given *filename*.","summary":"<p>Creates a new reader from the given <em>filename</em>.</p>","abstract":false,"args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"}],"args_string":"(filename : String)","args_html":"(filename : <a href=\"../../String.html\">String</a>)","location":{"filename":"src/compress/zip/reader.cr","line_number":39,"url":null},"def":{"name":"new","args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"new(::File.new(filename), sync_close: true)"}}],"instance_methods":[{"id":"close-instance-method","html_id":"close-instance-method","name":"close","doc":"Closes this zip reader.","summary":"<p>Closes this zip reader.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/zip/reader.cr","line_number":104,"url":null},"def":{"name":"close","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if @closed\n  return\nend\n@closed = true\nif @sync_close\n  @io.close\nend\n"}},{"id":"closed?:Bool-instance-method","html_id":"closed?:Bool-instance-method","name":"closed?","doc":"Returns `true` if this reader is closed.","summary":"<p>Returns <code>true</code> if this reader is closed.</p>","abstract":false,"args":[],"args_string":" : Bool","args_html":" : <a href=\"../../Bool.html\">Bool</a>","location":{"filename":"src/compress/zip/reader.cr","line_number":30,"url":null},"def":{"name":"closed?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@closed"}},{"id":"each_entry(&)-instance-method","html_id":"each_entry(&)-instance-method","name":"each_entry","doc":"Yields each entry in the zip to the given block.","summary":"<p>Yields each entry in the zip to the given block.</p>","abstract":false,"args":[],"args_string":"(&)","args_html":"(&)","location":{"filename":"src/compress/zip/reader.cr","line_number":97,"url":null},"def":{"name":"each_entry","args":[],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"while entry = next_entry\n  yield entry\nend"}},{"id":"next_entry:Entry?-instance-method","html_id":"next_entry:Entry?-instance-method","name":"next_entry","doc":"Reads the next entry in the zip, or `nil` if there\nare no more entries.\n\nAfter reading a next entry, previous entries can no\nlonger be read (their `IO` will be closed.)","summary":"<p>Reads the next entry in the zip, or <code>nil</code> if there are no more entries.</p>","abstract":false,"args":[],"args_string":" : Entry?","args_html":" : <a href=\"../../Compress/Zip/Reader/Entry.html\">Entry</a>?","location":{"filename":"src/compress/zip/reader.cr","line_number":62,"url":null},"def":{"name":"next_entry","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Entry | ::Nil","visibility":"Public","body":"if @reached_end\n  return nil\nend\nif last_entry = @last_entry\n  last_entry.close\n  skip_data_descriptor(last_entry)\nend\nwhile true\n  signature = read(UInt32)\n  case signature\n  when FileInfo::SIGNATURE\n    break\n  when FileInfo::DATA_DESCRIPTOR_SIGNATURE\n    if last_entry && (!@read_data_descriptor)\n      read_data_descriptor(last_entry)\n      next\n    else\n      raise(Error.new(\"Unexpected data descriptor when reading zip\"))\n    end\n  else\n    @reached_end = true\n    return nil\n  end\nend\n@last_entry = Entry.new(@io)\n"}},{"id":"sync_close=(sync_close)-instance-method","html_id":"sync_close=(sync_close)-instance-method","name":"sync_close=","doc":"Whether to close the enclosed `IO` when closing this reader.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this reader.</p>","abstract":false,"args":[{"name":"sync_close","doc":null,"default_value":"","external_name":"sync_close","restriction":""}],"args_string":"(sync_close)","args_html":"(sync_close)","location":{"filename":"src/compress/zip/reader.cr","line_number":27,"url":null},"def":{"name":"sync_close=","args":[{"name":"sync_close","doc":null,"default_value":"","external_name":"sync_close","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@sync_close = sync_close"}},{"id":"sync_close?:Bool-instance-method","html_id":"sync_close?:Bool-instance-method","name":"sync_close?","doc":"Whether to close the enclosed `IO` when closing this reader.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this reader.</p>","abstract":false,"args":[],"args_string":" : Bool","args_html":" : <a href=\"../../Bool.html\">Bool</a>","location":{"filename":"src/compress/zip/reader.cr","line_number":27,"url":null},"def":{"name":"sync_close?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@sync_close"}}],"macros":[],"types":[{"html_id":"Crystal/Compress/Zip/Reader/Entry","path":"Compress/Zip/Reader/Entry.html","kind":"class","full_name":"Compress::Zip::Reader::Entry","name":"Entry","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Compress/Zip/FileInfo","kind":"module","full_name":"Compress::Zip::FileInfo","name":"FileInfo"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[{"html_id":"Crystal/Compress/Zip/FileInfo","kind":"module","full_name":"Compress::Zip::FileInfo","name":"FileInfo"}],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Compress/Zip/Reader","kind":"class","full_name":"Compress::Zip::Reader","name":"Reader"},"doc":"A entry inside a `Zip::Reader`.\n\nUse the `io` method to read from it.","summary":"<p>A entry inside a <code><a href=\"../../../Compress/Zip/Reader.html\">Zip::Reader</a></code>.</p>","class_methods":[],"constructors":[],"instance_methods":[{"id":"io:IO-instance-method","html_id":"io:IO-instance-method","name":"io","doc":"Returns an `IO` to the entry's data.","summary":"<p>Returns an <code><a href=\"../../../IO.html\">IO</a></code> to the entry's data.</p>","abstract":false,"args":[],"args_string":" : IO","args_html":" : <a href=\"../../../IO.html\">IO</a>","location":{"filename":"src/compress/zip/reader.cr","line_number":159,"url":null},"def":{"name":"io","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"IO","visibility":"Public","body":"@io"}}],"macros":[],"types":[]}]},{"html_id":"Crystal/Compress/Zip/Writer","path":"Compress/Zip/Writer.html","kind":"class","full_name":"Compress::Zip::Writer","name":"Writer","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Compress/Zip","kind":"module","full_name":"Compress::Zip","name":"Zip"},"doc":"Writes (streams) zip entries to an `IO`.\n\n### Example\n\n```\nrequire \"compress/zip\"\n\nFile.open(\"./file.zip\", \"w\") do |file|\n  Compress::Zip::Writer.open(file) do |zip|\n    # Add a file with a String content\n    zip.add \"foo.txt\", \"contents of foo\"\n\n    # Add a file and write data to it through an IO\n    zip.add(\"bar.txt\") do |io|\n      io << \"contents of bar\"\n    end\n\n    # Add a file by referencing a file in the filesystem\n    # (the file is automatically closed after this call)\n    zip.add(\"baz.txt\", File.open(\"./some_file.txt\"))\n  end\nend\n```","summary":"<p>Writes (streams) zip entries to an <code><a href=\"../../IO.html\">IO</a></code>.</p>","class_methods":[{"id":"open(io:IO,sync_close=false,&)-class-method","html_id":"open(io:IO,sync_close=false,&)-class-method","name":"open","doc":"Creates a new writer to the given *io*, yields it to the given block,\nand closes it at the end.","summary":"<p>Creates a new writer to the given <em>io</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""}],"args_string":"(io : IO, sync_close = <span class=\"n\">false</span>, &)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close = <span class=\"n\">false</span>, &)","location":{"filename":"src/compress/zip/writer.cr","line_number":54,"url":null},"def":{"name":"open","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"writer = new(io, sync_close: sync_close)\nbegin\n  yield writer\nensure\n  writer.close\nend\n"}},{"id":"open(filename:String,&)-class-method","html_id":"open(filename:String,&)-class-method","name":"open","doc":"Creates a new writer to the given *filename*, yields it to the given block,\nand closes it at the end.","summary":"<p>Creates a new writer to the given <em>filename</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"}],"args_string":"(filename : String, &)","args_html":"(filename : <a href=\"../../String.html\">String</a>, &)","location":{"filename":"src/compress/zip/writer.cr","line_number":61,"url":null},"def":{"name":"open","args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"writer = new(filename)\nbegin\n  yield writer\nensure\n  writer.close\nend\n"}}],"constructors":[{"id":"new(io:IO,sync_close=false)-class-method","html_id":"new(io:IO,sync_close=false)-class-method","name":"new","doc":"Creates a new writer to the given *io*.","summary":"<p>Creates a new writer to the given <em>io</em>.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""}],"args_string":"(io : IO, sync_close = <span class=\"n\">false</span>)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close = <span class=\"n\">false</span>)","location":{"filename":"src/compress/zip/writer.cr","line_number":37,"url":null},"def":{"name":"new","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(io, sync_close)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(filename:String)-class-method","html_id":"new(filename:String)-class-method","name":"new","doc":"Creates a new writer to the given *filename*.","summary":"<p>Creates a new writer to the given <em>filename</em>.</p>","abstract":false,"args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"}],"args_string":"(filename : String)","args_html":"(filename : <a href=\"../../String.html\">String</a>)","location":{"filename":"src/compress/zip/writer.cr","line_number":48,"url":null},"def":{"name":"new","args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"new(::File.new(filename, \"w\"), sync_close: true)"}}],"instance_methods":[{"id":"add(filename:String,&)-instance-method","html_id":"add(filename:String,&)-instance-method","name":"add","doc":"Adds an entry that will have the given *filename* and current\ntime (`Time.utc`) and yields an `IO` to write that entry's\ncontents.","summary":"<p>Adds an entry that will have the given <em>filename</em> and current time (<code><a href=\"../../Time.html#utc:Time-class-method\">Time.utc</a></code>) and yields an <code><a href=\"../../IO.html\">IO</a></code> to write that entry's contents.</p>","abstract":false,"args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"}],"args_string":"(filename : String, &)","args_html":"(filename : <a href=\"../../String.html\">String</a>, &)","location":{"filename":"src/compress/zip/writer.cr","line_number":69,"url":null},"def":{"name":"add","args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"add(Entry.new(filename)) do |io|\n  yield io\nend"}},{"id":"add(entry:Entry,&)-instance-method","html_id":"add(entry:Entry,&)-instance-method","name":"add","doc":"Adds an entry and yields `IO` to write that entry's contents.\n\nYou can choose the Entry's compression method before adding it.\n\n* If the STORED compression method is used, its crc32, compressed\nsize and uncompressed size **must** be set and be correct with\nrespect to the data that will be written to the yielded `IO`.\n* If the DEFLATED compression method is used, crc32, compressed\nsize and uncompressed size will be computed from the data\nwritten to the yielded IO.\n\nYou can also set the Entry's time (which is `Time.utc` by default)\n and extra data before adding it to the zip stream.","summary":"<p>Adds an entry and yields <code><a href=\"../../IO.html\">IO</a></code> to write that entry's contents.</p>","abstract":false,"args":[{"name":"entry","doc":null,"default_value":"","external_name":"entry","restriction":"Entry"}],"args_string":"(entry : Entry, &)","args_html":"(entry : <a href=\"../../Compress/Zip/Writer/Entry.html\">Entry</a>, &)","location":{"filename":"src/compress/zip/writer.cr","line_number":88,"url":null},"def":{"name":"add","args":[{"name":"entry","doc":null,"default_value":"","external_name":"entry","restriction":"Entry"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"entry.general_purpose_bit_flag = entry.general_purpose_bit_flag | (1 << 3)\nentry.general_purpose_bit_flag = entry.general_purpose_bit_flag | (1 << 11)\nentry.offset = @written\n@written = @written + (entry.to_io(@io))\ncase entry.compression_method\nwhen .stored?\n  if entry.compressed_size != entry.uncompressed_size\n    raise(Error.new(\"Entry compressed size (#{entry.compressed_size}) is not equal to its uncompressed size (#{entry.uncompressed_size})\"))\n  end\n  @uncompressed_size_counter.io = @io\n  yield @uncompressed_size_counter\nwhen .deflated?\n  @compressed_size_counter.io = @io\n  io = Compress::Deflate::Writer.new(@compressed_size_counter)\n  @uncompressed_size_counter.io = io\n  yield @uncompressed_size_counter\n  io.close\nelse\n  raise(\"Unsupported compression method: #{entry.compression_method}\")\nend\nif entry.compression_method.stored?\n  @written = @written + @uncompressed_size_counter.count\nelse\n  @written = @written + @compressed_size_counter.count\nend\ncrc32 = @uncompressed_size_counter.crc32.to_u32\nuncompressed_size = @uncompressed_size_counter.count\nif entry.compression_method.stored?\n  compressed_size = uncompressed_size\nelse\n  compressed_size = @compressed_size_counter.count\nend\nif entry.compression_method.stored?\n  if entry.crc32 != crc32\n    raise(Error.new(\"Entry CRC32 mismatch (#{entry.crc32} given but was #{crc32})\"))\n  end\n  if entry.uncompressed_size != uncompressed_size\n    raise(Error.new(\"Entry uncompressed size mismatch (#{entry.uncompressed_size} given but was #{uncompressed_size})\"))\n  end\nelse\n  entry.crc32 = crc32\n  entry.compressed_size = compressed_size\n  entry.uncompressed_size = uncompressed_size\nend\nif entry.compression_method.stored?\nelse\n  @written = @written + (entry.write_data_descriptor(@io))\nend\n@entries << entry\n"}},{"id":"add(filename_or_entry:String|Entry,string:String)-instance-method","html_id":"add(filename_or_entry:String|Entry,string:String)-instance-method","name":"add","doc":"Adds an entry that will have *string* as its contents.","summary":"<p>Adds an entry that will have <em>string</em> as its contents.</p>","abstract":false,"args":[{"name":"filename_or_entry","doc":null,"default_value":"","external_name":"filename_or_entry","restriction":"String | Entry"},{"name":"string","doc":null,"default_value":"","external_name":"string","restriction":"String"}],"args_string":"(filename_or_entry : String | Entry, string : String)","args_html":"(filename_or_entry : <a href=\"../../String.html\">String</a> | <a href=\"../../Compress/Zip/Writer/Entry.html\">Entry</a>, string : <a href=\"../../String.html\">String</a>)","location":{"filename":"src/compress/zip/writer.cr","line_number":154,"url":null},"def":{"name":"add","args":[{"name":"filename_or_entry","doc":null,"default_value":"","external_name":"filename_or_entry","restriction":"String | Entry"},{"name":"string","doc":null,"default_value":"","external_name":"string","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"add(filename_or_entry) do |io|\n  io << string\nend"}},{"id":"add(filename_or_entry:String|Entry,bytes:Bytes)-instance-method","html_id":"add(filename_or_entry:String|Entry,bytes:Bytes)-instance-method","name":"add","doc":"Adds an entry that will have *bytes* as its contents.","summary":"<p>Adds an entry that will have <em>bytes</em> as its contents.</p>","abstract":false,"args":[{"name":"filename_or_entry","doc":null,"default_value":"","external_name":"filename_or_entry","restriction":"String | Entry"},{"name":"bytes","doc":null,"default_value":"","external_name":"bytes","restriction":"Bytes"}],"args_string":"(filename_or_entry : String | Entry, bytes : Bytes)","args_html":"(filename_or_entry : <a href=\"../../String.html\">String</a> | <a href=\"../../Compress/Zip/Writer/Entry.html\">Entry</a>, bytes : <a href=\"../../Bytes.html\">Bytes</a>)","location":{"filename":"src/compress/zip/writer.cr","line_number":161,"url":null},"def":{"name":"add","args":[{"name":"filename_or_entry","doc":null,"default_value":"","external_name":"filename_or_entry","restriction":"String | Entry"},{"name":"bytes","doc":null,"default_value":"","external_name":"bytes","restriction":"Bytes"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"add(filename_or_entry) do |io|\n  io.write(bytes)\nend"}},{"id":"add(filename_or_entry:String|Entry,data:IO)-instance-method","html_id":"add(filename_or_entry:String|Entry,data:IO)-instance-method","name":"add","doc":"Adds an entry that will have its data copied from the given *data*.\nIf the given *data* is a `::File`, it is automatically closed\nafter data is copied from it.","summary":"<p>Adds an entry that will have its data copied from the given <em>data</em>.</p>","abstract":false,"args":[{"name":"filename_or_entry","doc":null,"default_value":"","external_name":"filename_or_entry","restriction":"String | Entry"},{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":"IO"}],"args_string":"(filename_or_entry : String | Entry, data : IO)","args_html":"(filename_or_entry : <a href=\"../../String.html\">String</a> | <a href=\"../../Compress/Zip/Writer/Entry.html\">Entry</a>, data : <a href=\"../../IO.html\">IO</a>)","location":{"filename":"src/compress/zip/writer.cr","line_number":170,"url":null},"def":{"name":"add","args":[{"name":"filename_or_entry","doc":null,"default_value":"","external_name":"filename_or_entry","restriction":"String | Entry"},{"name":"data","doc":null,"default_value":"","external_name":"data","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"add(filename_or_entry) do |io|\n  IO.copy(data, io)\n  if data.is_a?(::File)\n    data.close\n  end\nend"}},{"id":"add_dir(name)-instance-method","html_id":"add_dir(name)-instance-method","name":"add_dir","doc":"Adds a directory entry that will have the given *name*.","summary":"<p>Adds a directory entry that will have the given <em>name</em>.</p>","abstract":false,"args":[{"name":"name","doc":null,"default_value":"","external_name":"name","restriction":""}],"args_string":"(name)","args_html":"(name)","location":{"filename":"src/compress/zip/writer.cr","line_number":178,"url":null},"def":{"name":"add_dir","args":[{"name":"name","doc":null,"default_value":"","external_name":"name","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if name.ends_with?('/')\nelse\n  name = name + '/'\nend\nadd(Entry.new(name)) do\nend\n"}},{"id":"close-instance-method","html_id":"close-instance-method","name":"close","doc":"Closes this zip writer.","summary":"<p>Closes this zip writer.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/zip/writer.cr","line_number":184,"url":null},"def":{"name":"close","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if @closed\n  return\nend\n@closed = true\nstart_offset = @written\nwrite_central_directory\nwrite_end_of_central_directory(start_offset, @written - start_offset)\nif @sync_close\n  @io.close\nend\n"}},{"id":"closed?:Bool-instance-method","html_id":"closed?:Bool-instance-method","name":"closed?","doc":"Returns `true` if this writer is closed.","summary":"<p>Returns <code>true</code> if this writer is closed.</p>","abstract":false,"args":[],"args_string":" : Bool","args_html":" : <a href=\"../../Bool.html\">Bool</a>","location":{"filename":"src/compress/zip/writer.cr","line_number":31,"url":null},"def":{"name":"closed?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@closed"}},{"id":"comment=(comment)-instance-method","html_id":"comment=(comment)-instance-method","name":"comment=","doc":"Sets the zip file comment","summary":"<p>Sets the zip file comment</p>","abstract":false,"args":[{"name":"comment","doc":null,"default_value":"","external_name":"comment","restriction":""}],"args_string":"(comment)","args_html":"(comment)","location":{"filename":"src/compress/zip/writer.cr","line_number":34,"url":null},"def":{"name":"comment=","args":[{"name":"comment","doc":null,"default_value":"","external_name":"comment","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@comment = comment"}},{"id":"sync_close=(sync_close)-instance-method","html_id":"sync_close=(sync_close)-instance-method","name":"sync_close=","doc":"Whether to close the enclosed `IO` when closing this writer.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this writer.</p>","abstract":false,"args":[{"name":"sync_close","doc":null,"default_value":"","external_name":"sync_close","restriction":""}],"args_string":"(sync_close)","args_html":"(sync_close)","location":{"filename":"src/compress/zip/writer.cr","line_number":28,"url":null},"def":{"name":"sync_close=","args":[{"name":"sync_close","doc":null,"default_value":"","external_name":"sync_close","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@sync_close = sync_close"}},{"id":"sync_close?:Bool-instance-method","html_id":"sync_close?:Bool-instance-method","name":"sync_close?","doc":"Whether to close the enclosed `IO` when closing this writer.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this writer.</p>","abstract":false,"args":[],"args_string":" : Bool","args_html":" : <a href=\"../../Bool.html\">Bool</a>","location":{"filename":"src/compress/zip/writer.cr","line_number":28,"url":null},"def":{"name":"sync_close?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@sync_close"}}],"macros":[],"types":[{"html_id":"Crystal/Compress/Zip/Writer/Entry","path":"Compress/Zip/Writer/Entry.html","kind":"class","full_name":"Compress::Zip::Writer::Entry","name":"Entry","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Compress/Zip/FileInfo","kind":"module","full_name":"Compress::Zip::FileInfo","name":"FileInfo"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[{"html_id":"Crystal/Compress/Zip/FileInfo","kind":"module","full_name":"Compress::Zip::FileInfo","name":"FileInfo"}],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Compress/Zip/Writer","kind":"class","full_name":"Compress::Zip::Writer","name":"Writer"},"doc":"An entry to write into a `Zip::Writer`.","summary":"<p>An entry to write into a <code><a href=\"../../../Compress/Zip/Writer.html\">Zip::Writer</a></code>.</p>","class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]}]}]},{"html_id":"Crystal/Compress/Zlib","path":"Compress/Zlib.html","kind":"module","full_name":"Compress::Zlib","name":"Zlib","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[{"id":"BEST_COMPRESSION","name":"BEST_COMPRESSION","value":"Compress::Deflate::BEST_COMPRESSION","doc":null,"summary":null},{"id":"BEST_SPEED","name":"BEST_SPEED","value":"Compress::Deflate::BEST_SPEED","doc":null,"summary":null},{"id":"DEFAULT_COMPRESSION","name":"DEFAULT_COMPRESSION","value":"Compress::Deflate::DEFAULT_COMPRESSION","doc":null,"summary":null},{"id":"NO_COMPRESSION","name":"NO_COMPRESSION","value":"Compress::Deflate::NO_COMPRESSION","doc":null,"summary":null}],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Compress","kind":"module","full_name":"Compress","name":"Compress"},"doc":"The Compress::Zlib module contains readers and writers of zlib format compressed\ndata, as specified in [RFC 1950](https://www.ietf.org/rfc/rfc1950.txt).","summary":"<p>The Compress::Zlib module contains readers and writers of zlib format compressed data, as specified in <a href=\"https://www.ietf.org/rfc/rfc1950.txt\">RFC 1950</a>.</p>","class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[{"html_id":"Crystal/Compress/Zlib/Error","path":"Compress/Zlib/Error.html","kind":"class","full_name":"Compress::Zlib::Error","name":"Error","abstract":false,"superclass":{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},"ancestors":[{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Compress/Zlib","kind":"module","full_name":"Compress::Zlib","name":"Zlib"},"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"Crystal/Compress/Zlib/Reader","path":"Compress/Zlib/Reader.html","kind":"class","full_name":"Compress::Zlib::Reader","name":"Reader","abstract":false,"superclass":{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},"ancestors":[{"html_id":"Crystal/IO/Buffered","kind":"module","full_name":"IO::Buffered","name":"Buffered"},{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[{"html_id":"Crystal/IO/Buffered","kind":"module","full_name":"IO::Buffered","name":"Buffered"}],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Compress/Zlib","kind":"module","full_name":"Compress::Zlib","name":"Zlib"},"doc":"A read-only `IO` object to decompress data in the zlib format.\n\nInstances of this class wrap another IO object. When you read from this instance\ninstance, it reads data from the underlying IO, decompresses it, and returns\nit to the caller.","summary":"<p>A read-only <code><a href=\"../../IO.html\">IO</a></code> object to decompress data in the zlib format.</p>","class_methods":[{"id":"open(io:IO,sync_close=false,dict:Bytes?=nil,&)-class-method","html_id":"open(io:IO,sync_close=false,dict:Bytes?=nil,&)-class-method","name":"open","doc":"Creates a new reader from the given *io*, yields it to the given block,\nand closes it at the end.","summary":"<p>Creates a new reader from the given <em>io</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""},{"name":"dict","doc":null,"default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"args_string":"(io : IO, sync_close = <span class=\"n\">false</span>, dict : Bytes? = <span class=\"n\">nil</span>, &)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close = <span class=\"n\">false</span>, dict : <a href=\"../../Bytes.html\">Bytes</a>? = <span class=\"n\">nil</span>, &)","location":{"filename":"src/compress/zlib/reader.cr","line_number":25,"url":null},"def":{"name":"open","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""},{"name":"dict","doc":null,"default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"reader = new(io, sync_close: sync_close, dict: dict)\nbegin\n  yield reader\nensure\n  reader.close\nend\n"}}],"constructors":[{"id":"new(io:IO,sync_close=false,dict:Bytes?=nil)-class-method","html_id":"new(io:IO,sync_close=false,dict:Bytes?=nil)-class-method","name":"new","doc":"Creates a new reader from the given *io*.","summary":"<p>Creates a new reader from the given <em>io</em>.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""},{"name":"dict","doc":null,"default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"args_string":"(io : IO, sync_close = <span class=\"n\">false</span>, dict : Bytes? = <span class=\"n\">nil</span>)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, sync_close = <span class=\"n\">false</span>, dict : <a href=\"../../Bytes.html\">Bytes</a>? = <span class=\"n\">nil</span>)","location":{"filename":"src/compress/zlib/reader.cr","line_number":16,"url":null},"def":{"name":"new","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""},{"name":"dict","doc":null,"default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(io, sync_close, dict)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"closed?:Bool-instance-method","html_id":"closed?:Bool-instance-method","name":"closed?","doc":"Returns `true` if this reader is closed.","summary":"<p>Returns <code>true</code> if this reader is closed.</p>","abstract":false,"args":[],"args_string":" : Bool","args_html":" : <a href=\"../../Bool.html\">Bool</a>","location":{"filename":"src/compress/zlib/reader.cr","line_number":13,"url":null},"def":{"name":"closed?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@closed"}},{"id":"sync_close=(sync_close)-instance-method","html_id":"sync_close=(sync_close)-instance-method","name":"sync_close=","doc":"Whether to close the enclosed `IO` when closing this reader.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this reader.</p>","abstract":false,"args":[{"name":"sync_close","doc":null,"default_value":"","external_name":"sync_close","restriction":""}],"args_string":"(sync_close)","args_html":"(sync_close)","location":{"filename":"src/compress/zlib/reader.cr","line_number":10,"url":null},"def":{"name":"sync_close=","args":[{"name":"sync_close","doc":null,"default_value":"","external_name":"sync_close","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@sync_close = sync_close"}},{"id":"sync_close?:Bool-instance-method","html_id":"sync_close?:Bool-instance-method","name":"sync_close?","doc":"Whether to close the enclosed `IO` when closing this reader.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this reader.</p>","abstract":false,"args":[],"args_string":" : Bool","args_html":" : <a href=\"../../Bool.html\">Bool</a>","location":{"filename":"src/compress/zlib/reader.cr","line_number":10,"url":null},"def":{"name":"sync_close?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@sync_close"}},{"id":"unbuffered_close-instance-method","html_id":"unbuffered_close-instance-method","name":"unbuffered_close","doc":"Closes the wrapped `IO`.","summary":"<p>Closes the wrapped <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/zlib/reader.cr","line_number":92,"url":null},"def":{"name":"unbuffered_close","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if @closed\n  return\nend\n@closed = true\n@flate_io.close\nif @sync_close\n  @io.close\nend\n"}},{"id":"unbuffered_flush-instance-method","html_id":"unbuffered_flush-instance-method","name":"unbuffered_flush","doc":"Flushes the wrapped `IO`.","summary":"<p>Flushes the wrapped <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/zlib/reader.cr","line_number":88,"url":null},"def":{"name":"unbuffered_flush","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"raise(IO::Error.new(\"Can't flush Compress::Zlib::Reader\"))"}},{"id":"unbuffered_read(slice:Bytes)-instance-method","html_id":"unbuffered_read(slice:Bytes)-instance-method","name":"unbuffered_read","doc":"See `IO#read`.","summary":"<p>See <code><a href=\"../../IO.html#read(slice:Bytes)-instance-method\">IO#read</a></code>.</p>","abstract":false,"args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes)","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>)","location":{"filename":"src/compress/zlib/reader.cr","line_number":61,"url":null},"def":{"name":"unbuffered_read","args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"check_open\nif slice.empty?\n  return 0\nend\nif @end\n  return 0\nend\nread_bytes = @flate_io.read(slice)\nif read_bytes == 0\n  @end = true\n  @flate_io.close\n  adler32 = @io.read_bytes(UInt32, IO::ByteFormat::BigEndian)\n  if adler32 != @adler32\n    raise(Compress::Zlib::Error.new(\"ADLER-32 checksum mismatch\"))\n  end\nelse\n  @adler32 = ::Digest::Adler32.update(slice[0, read_bytes], @adler32)\nend\nread_bytes\n"}},{"id":"unbuffered_rewind-instance-method","html_id":"unbuffered_rewind-instance-method","name":"unbuffered_rewind","doc":"Rewinds the wrapped `IO`.","summary":"<p>Rewinds the wrapped <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/zlib/reader.cr","line_number":100,"url":null},"def":{"name":"unbuffered_rewind","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"check_open\n@io.rewind\ninitialize(@io, @sync_close, @flate_io.dict)\n"}},{"id":"unbuffered_write(slice:Bytes)-instance-method","html_id":"unbuffered_write(slice:Bytes)-instance-method","name":"unbuffered_write","doc":"Always raises `IO::Error` because this is a read-only `IO`.","summary":"<p>Always raises <code><a href=\"../../IO/Error.html\">IO::Error</a></code> because this is a read-only <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes)","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>)","location":{"filename":"src/compress/zlib/reader.cr","line_number":84,"url":null},"def":{"name":"unbuffered_write","args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"raise(IO::Error.new(\"Can't write to Compress::Zlib::Reader\"))"}}],"macros":[],"types":[]},{"html_id":"Crystal/Compress/Zlib/Writer","path":"Compress/Zlib/Writer.html","kind":"class","full_name":"Compress::Zlib::Writer","name":"Writer","abstract":false,"superclass":{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},"ancestors":[{"html_id":"Crystal/IO","kind":"class","full_name":"IO","name":"IO"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Compress/Zlib","kind":"module","full_name":"Compress::Zlib","name":"Zlib"},"doc":"A write-only `IO` object to compress data in the zlib format.\n\nInstances of this class wrap another IO object. When you write to this\ninstance, it compresses the data and writes it to the underlying IO.\n\nNOTE: unless created with a block, `close` must be invoked after all\ndata has been written to a Zlib::Writer instance.","summary":"<p>A write-only <code><a href=\"../../IO.html\">IO</a></code> object to compress data in the zlib format.</p>","class_methods":[{"id":"open(io:IO,level=Zlib::DEFAULT_COMPRESSION,sync_close=false,dict:Bytes?=nil,&)-class-method","html_id":"open(io:IO,level=Zlib::DEFAULT_COMPRESSION,sync_close=false,dict:Bytes?=nil,&)-class-method","name":"open","doc":"Creates a new writer to the given *io*, yields it to the given block,\nand closes it at the end.","summary":"<p>Creates a new writer to the given <em>io</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"level","doc":null,"default_value":"Zlib::DEFAULT_COMPRESSION","external_name":"level","restriction":""},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""},{"name":"dict","doc":null,"default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"args_string":"(io : IO, level = <span class=\"t\">Zlib</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, sync_close = <span class=\"n\">false</span>, dict : Bytes? = <span class=\"n\">nil</span>, &)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, level = <span class=\"t\">Zlib</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, sync_close = <span class=\"n\">false</span>, dict : <a href=\"../../Bytes.html\">Bytes</a>? = <span class=\"n\">nil</span>, &)","location":{"filename":"src/compress/zlib/writer.cr","line_number":29,"url":null},"def":{"name":"open","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"level","doc":null,"default_value":"Zlib::DEFAULT_COMPRESSION","external_name":"level","restriction":""},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""},{"name":"dict","doc":null,"default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"writer = new(io, level: level, sync_close: sync_close, dict: dict)\nbegin\n  yield writer\nensure\n  writer.close\nend\n"}},{"id":"open(filename:String,level=Zlib::DEFAULT_COMPRESSION,dict:Bytes?=nil,&)-class-method","html_id":"open(filename:String,level=Zlib::DEFAULT_COMPRESSION,dict:Bytes?=nil,&)-class-method","name":"open","doc":"Creates a new writer to the given *filename*, yields it to the given block,\nand closes it at the end.","summary":"<p>Creates a new writer to the given <em>filename</em>, yields it to the given block, and closes it at the end.</p>","abstract":false,"args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"},{"name":"level","doc":null,"default_value":"Zlib::DEFAULT_COMPRESSION","external_name":"level","restriction":""},{"name":"dict","doc":null,"default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"args_string":"(filename : String, level = <span class=\"t\">Zlib</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, dict : Bytes? = <span class=\"n\">nil</span>, &)","args_html":"(filename : <a href=\"../../String.html\">String</a>, level = <span class=\"t\">Zlib</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, dict : <a href=\"../../Bytes.html\">Bytes</a>? = <span class=\"n\">nil</span>, &)","location":{"filename":"src/compress/zlib/writer.cr","line_number":36,"url":null},"def":{"name":"open","args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"},{"name":"level","doc":null,"default_value":"Zlib::DEFAULT_COMPRESSION","external_name":"level","restriction":""},{"name":"dict","doc":null,"default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"double_splat":null,"splat_index":null,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"writer = new(filename, level: level, dict: dict)\nbegin\n  yield writer\nensure\n  writer.close\nend\n"}}],"constructors":[{"id":"new(io:IO,level=Zlib::DEFAULT_COMPRESSION,sync_close=false,dict:Bytes?=nil)-class-method","html_id":"new(io:IO,level=Zlib::DEFAULT_COMPRESSION,sync_close=false,dict:Bytes?=nil)-class-method","name":"new","doc":"Creates a new writer to the given *io*.","summary":"<p>Creates a new writer to the given <em>io</em>.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"level","doc":null,"default_value":"Zlib::DEFAULT_COMPRESSION","external_name":"level","restriction":""},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""},{"name":"dict","doc":null,"default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"args_string":"(io : IO, level = <span class=\"t\">Zlib</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, sync_close = <span class=\"n\">false</span>, dict : Bytes? = <span class=\"n\">nil</span>)","args_html":"(io : <a href=\"../../IO.html\">IO</a>, level = <span class=\"t\">Zlib</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, sync_close = <span class=\"n\">false</span>, dict : <a href=\"../../Bytes.html\">Bytes</a>? = <span class=\"n\">nil</span>)","location":{"filename":"src/compress/zlib/writer.cr","line_number":16,"url":null},"def":{"name":"new","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"},{"name":"level","doc":null,"default_value":"Zlib::DEFAULT_COMPRESSION","external_name":"level","restriction":""},{"name":"sync_close","doc":null,"default_value":"false","external_name":"sync_close","restriction":""},{"name":"dict","doc":null,"default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(io, level, sync_close, dict)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}},{"id":"new(filename:String,level=Zlib::DEFAULT_COMPRESSION,dict:Bytes?=nil)-class-method","html_id":"new(filename:String,level=Zlib::DEFAULT_COMPRESSION,dict:Bytes?=nil)-class-method","name":"new","doc":"Creates a new writer to the given *filename*.","summary":"<p>Creates a new writer to the given <em>filename</em>.</p>","abstract":false,"args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"},{"name":"level","doc":null,"default_value":"Zlib::DEFAULT_COMPRESSION","external_name":"level","restriction":""},{"name":"dict","doc":null,"default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"args_string":"(filename : String, level = <span class=\"t\">Zlib</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, dict : Bytes? = <span class=\"n\">nil</span>)","args_html":"(filename : <a href=\"../../String.html\">String</a>, level = <span class=\"t\">Zlib</span><span class=\"t\">::</span><span class=\"t\">DEFAULT_COMPRESSION</span>, dict : <a href=\"../../Bytes.html\">Bytes</a>? = <span class=\"n\">nil</span>)","location":{"filename":"src/compress/zlib/writer.cr","line_number":23,"url":null},"def":{"name":"new","args":[{"name":"filename","doc":null,"default_value":"","external_name":"filename","restriction":"String"},{"name":"level","doc":null,"default_value":"Zlib::DEFAULT_COMPRESSION","external_name":"level","restriction":""},{"name":"dict","doc":null,"default_value":"nil","external_name":"dict","restriction":"Bytes | ::Nil"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"new(::File.new(filename, \"w\"), level: level, sync_close: true, dict: dict)"}}],"instance_methods":[{"id":"close-instance-method","html_id":"close-instance-method","name":"close","doc":"Closes this writer. Must be invoked after all data has been written.","summary":"<p>Closes this writer.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/zlib/writer.cr","line_number":70,"url":null},"def":{"name":"close","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"if @closed\n  return\nend\n@closed = true\nif @wrote_header\nelse\n  write_header\nend\n@flate_io.close\n@io.write_bytes(@adler32, IO::ByteFormat::BigEndian)\nif @sync_close\n  @io.close\nend\n"}},{"id":"closed?:Bool-instance-method","html_id":"closed?:Bool-instance-method","name":"closed?","doc":"Returns `true` if this writer is closed.","summary":"<p>Returns <code>true</code> if this writer is closed.</p>","abstract":false,"args":[],"args_string":" : Bool","args_html":" : <a href=\"../../Bool.html\">Bool</a>","location":{"filename":"src/compress/zlib/writer.cr","line_number":13,"url":null},"def":{"name":"closed?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@closed"}},{"id":"flush-instance-method","html_id":"flush-instance-method","name":"flush","doc":"Flushes data, forcing writing the zlib header if no\ndata has been written yet.\n\nSee `IO#flush`.","summary":"<p>Flushes data, forcing writing the zlib header if no data has been written yet.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/compress/zlib/writer.cr","line_number":62,"url":null},"def":{"name":"flush","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"check_open\nif @wrote_header\nelse\n  write_header\nend\n@flate_io.flush\n"}},{"id":"read(slice:Bytes)-instance-method","html_id":"read(slice:Bytes)-instance-method","name":"read","doc":"Always raises `IO::Error` because this is a write-only `IO`.","summary":"<p>Always raises <code><a href=\"../../IO/Error.html\">IO::Error</a></code> because this is a write-only <code><a href=\"../../IO.html\">IO</a></code>.</p>","abstract":false,"args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes)","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>)","location":{"filename":"src/compress/zlib/writer.cr","line_number":42,"url":null},"def":{"name":"read","args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"raise(IO::Error.new(\"Can't read from Gzip::Writer\"))"}},{"id":"sync_close=(sync_close)-instance-method","html_id":"sync_close=(sync_close)-instance-method","name":"sync_close=","doc":"Whether to close the enclosed `IO` when closing this writer.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this writer.</p>","abstract":false,"args":[{"name":"sync_close","doc":null,"default_value":"","external_name":"sync_close","restriction":""}],"args_string":"(sync_close)","args_html":"(sync_close)","location":{"filename":"src/compress/zlib/writer.cr","line_number":10,"url":null},"def":{"name":"sync_close=","args":[{"name":"sync_close","doc":null,"default_value":"","external_name":"sync_close","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@sync_close = sync_close"}},{"id":"sync_close?:Bool-instance-method","html_id":"sync_close?:Bool-instance-method","name":"sync_close?","doc":"Whether to close the enclosed `IO` when closing this writer.","summary":"<p>Whether to close the enclosed <code><a href=\"../../IO.html\">IO</a></code> when closing this writer.</p>","abstract":false,"args":[],"args_string":" : Bool","args_html":" : <a href=\"../../Bool.html\">Bool</a>","location":{"filename":"src/compress/zlib/writer.cr","line_number":10,"url":null},"def":{"name":"sync_close?","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@sync_close"}},{"id":"write(slice:Bytes):Nil-instance-method","html_id":"write(slice:Bytes):Nil-instance-method","name":"write","doc":"See `IO#write`.","summary":"<p>See <code><a href=\"../../IO.html#write(slice:Bytes):Nil-instance-method\">IO#write</a></code>.</p>","abstract":false,"args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"args_string":"(slice : Bytes) : Nil","args_html":"(slice : <a href=\"../../Bytes.html\">Bytes</a>) : <a href=\"../../Nil.html\">Nil</a>","location":{"filename":"src/compress/zlib/writer.cr","line_number":47,"url":null},"def":{"name":"write","args":[{"name":"slice","doc":null,"default_value":"","external_name":"slice","restriction":"Bytes"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"check_open\nif slice.empty?\n  return\nend\nif @wrote_header\nelse\n  write_header\nend\n@flate_io.write(slice)\n@adler32 = ::Digest::Adler32.update(slice, @adler32)\n"}}],"macros":[],"types":[]}]}]},{"html_id":"Crystal/Crypto","path":"Crypto.html","kind":"module","full_name":"Crypto","name":"Crypto","abstract":false,"superclass":null,"ancestors":[],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":null,"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[{"html_id":"Crystal/Crypto/Bcrypt","path":"Crypto/Bcrypt.html","kind":"class","full_name":"Crypto::Bcrypt","name":"Bcrypt","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[{"id":"COST_RANGE","name":"COST_RANGE","value":"4..31","doc":null,"summary":null},{"id":"DEFAULT_COST","name":"DEFAULT_COST","value":"11","doc":null,"summary":null},{"id":"PASSWORD_RANGE","name":"PASSWORD_RANGE","value":"1..72","doc":null,"summary":null},{"id":"SALT_SIZE","name":"SALT_SIZE","value":"16","doc":null,"summary":null}],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Crypto","kind":"module","full_name":"Crypto","name":"Crypto"},"doc":"Pure Crystal implementation of the Bcrypt algorithm by Niels Provos and David\nMazières, as [presented at USENIX in\n1999](https://www.usenix.org/legacy/events/usenix99/provos/provos_html/index.html).\n\nThe algorithm has a maximum password length limit of 71 characters (see\n[this comment](https://security.stackexchange.com/questions/39849/does-bcrypt-have-a-maximum-password-length#answer-39851)\non stackoverflow).\n\nRefer to `Crypto::Bcrypt::Password` for a higher level interface.\n\nAbout the Cost\n\nBcrypt, like the PBKDF2 or scrypt ciphers, are designed to be slow, so\ngenerating rainbow tables or cracking passwords is nearly impossible. Yet,\ncomputers are always getting faster and faster, so the actual cost must be\nincremented every once in a while.\nAlways use the maximum cost that is tolerable, performance wise, for your\napplication. Be sure to test and select this based on your server, not your\nhome computer.\n\nThis implementation of Bcrypt is currently 50% slower than pure C solutions,\nso keep this in mind when selecting your cost. It may be wise to test with\nRuby's [bcrypt gem](https://github.com/codahale/bcrypt-ruby)\nwhich is a binding to OpenBSD's implementation.\n\nLast but not least: beware of denial of services! Always protect your\napplication using an external strategy (eg: rate limiting), otherwise\nendpoints that verifies bcrypt hashes will be an easy target.","summary":"<p>Pure Crystal implementation of the Bcrypt algorithm by Niels Provos and David Mazières, as <a href=\"https://www.usenix.org/legacy/events/usenix99/provos/provos_html/index.html\">presented at USENIX in 1999</a>.</p>","class_methods":[{"id":"hash_secret(password,cost=DEFAULT_COST):String-class-method","html_id":"hash_secret(password,cost=DEFAULT_COST):String-class-method","name":"hash_secret","doc":null,"summary":null,"abstract":false,"args":[{"name":"password","doc":null,"default_value":"","external_name":"password","restriction":""},{"name":"cost","doc":null,"default_value":"DEFAULT_COST","external_name":"cost","restriction":""}],"args_string":"(password, cost = <span class=\"t\">DEFAULT_COST</span>) : String","args_html":"(password, cost = <span class=\"t\">DEFAULT_COST</span>) : <a href=\"../String.html\">String</a>","location":{"filename":"src/crypto/bcrypt.cr","line_number":50,"url":null},"def":{"name":"hash_secret","args":[{"name":"password","doc":null,"default_value":"","external_name":"password","restriction":""},{"name":"cost","doc":null,"default_value":"DEFAULT_COST","external_name":"cost","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"passwordb = (password.to_unsafe.to_slice(password.bytesize + 1)).clone\nsaltb = Random::Secure.random_bytes(SALT_SIZE)\n(new(passwordb, saltb, cost)).to_s\n"}}],"constructors":[{"id":"new(password:String,salt:String,cost=DEFAULT_COST)-class-method","html_id":"new(password:String,salt:String,cost=DEFAULT_COST)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"password","doc":null,"default_value":"","external_name":"password","restriction":"String"},{"name":"salt","doc":null,"default_value":"","external_name":"salt","restriction":"String"},{"name":"cost","doc":null,"default_value":"DEFAULT_COST","external_name":"cost","restriction":""}],"args_string":"(password : String, salt : String, cost = <span class=\"t\">DEFAULT_COST</span>)","args_html":"(password : <a href=\"../String.html\">String</a>, salt : <a href=\"../String.html\">String</a>, cost = <span class=\"t\">DEFAULT_COST</span>)","location":{"filename":"src/crypto/bcrypt.cr","line_number":57,"url":null},"def":{"name":"new","args":[{"name":"password","doc":null,"default_value":"","external_name":"password","restriction":"String"},{"name":"salt","doc":null,"default_value":"","external_name":"salt","restriction":"String"},{"name":"cost","doc":null,"default_value":"DEFAULT_COST","external_name":"cost","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"passwordb = (password.to_unsafe.to_slice(password.bytesize + 1)).clone\nsaltb = Base64.decode(salt, SALT_SIZE)\nnew(passwordb, saltb, cost)\n"}},{"id":"new(password:Bytes,salt:Bytes,cost=DEFAULT_COST)-class-method","html_id":"new(password:Bytes,salt:Bytes,cost=DEFAULT_COST)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"password","doc":null,"default_value":"","external_name":"password","restriction":"Bytes"},{"name":"salt","doc":null,"default_value":"","external_name":"salt","restriction":"Bytes"},{"name":"cost","doc":null,"default_value":"DEFAULT_COST","external_name":"cost","restriction":""}],"args_string":"(password : Bytes, salt : Bytes, cost = <span class=\"t\">DEFAULT_COST</span>)","args_html":"(password : <a href=\"../Bytes.html\">Bytes</a>, salt : <a href=\"../Bytes.html\">Bytes</a>, cost = <span class=\"t\">DEFAULT_COST</span>)","location":{"filename":"src/crypto/bcrypt.cr","line_number":68,"url":null},"def":{"name":"new","args":[{"name":"password","doc":null,"default_value":"","external_name":"password","restriction":"Bytes"},{"name":"salt","doc":null,"default_value":"","external_name":"salt","restriction":"Bytes"},{"name":"cost","doc":null,"default_value":"DEFAULT_COST","external_name":"cost","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(password, salt, cost)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"cost:Int32-instance-method","html_id":"cost:Int32-instance-method","name":"cost","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Int32","args_html":" : <a href=\"../Int32.html\">Int32</a>","location":{"filename":"src/crypto/bcrypt.cr","line_number":66,"url":null},"def":{"name":"cost","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":"@cost"}},{"id":"digest-instance-method","html_id":"digest-instance-method","name":"digest","doc":null,"summary":null,"abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/crypto/bcrypt.cr","line_number":76,"url":null},"def":{"name":"digest","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@digest || (@digest = hash_password)"}},{"id":"inspect(io:IO):Nil-instance-method","html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Appends a String representation of this object\nwhich includes its class name, its object address\nand the values of all instance variables.\n\n```\nclass Person\n  def initialize(@name : String, @age : Int32)\n  end\nend\n\nPerson.new(\"John\", 32).inspect # => #<Person:0x10fd31f20 @name=\"John\", @age=32>\n```","summary":"<p>Appends a String representation of this object which includes its class name, its object address and the values of all instance variables.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../IO.html\">IO</a>) : <a href=\"../Nil.html\">Nil</a>","location":{"filename":"src/crypto/bcrypt.cr","line_number":94,"url":null},"def":{"name":"inspect","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"to_s(io)"}},{"id":"password:Bytes-instance-method","html_id":"password:Bytes-instance-method","name":"password","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Bytes","args_html":" : <a href=\"../Bytes.html\">Bytes</a>","location":{"filename":"src/crypto/bcrypt.cr","line_number":64,"url":null},"def":{"name":"password","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bytes","visibility":"Public","body":"@password"}},{"id":"salt:Bytes-instance-method","html_id":"salt:Bytes-instance-method","name":"salt","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Bytes","args_html":" : <a href=\"../Bytes.html\">Bytes</a>","location":{"filename":"src/crypto/bcrypt.cr","line_number":65,"url":null},"def":{"name":"salt","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bytes","visibility":"Public","body":"@salt"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Appends a short String representation of this object\nwhich includes its class name and its object address.\n\n```\nclass Person\n  def initialize(@name : String, @age : Int32)\n  end\nend\n\nPerson.new(\"John\", 32).to_s # => #<Person:0x10a199f20>\n```","summary":"<p>Appends a short String representation of this object which includes its class name and its object address.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../IO.html\">IO</a>) : <a href=\"../Nil.html\">Nil</a>","location":{"filename":"src/crypto/bcrypt.cr","line_number":90,"url":null},"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << to_s"}},{"id":"to_s-instance-method","html_id":"to_s-instance-method","name":"to_s","doc":"Returns a string representation of this object.\n\nDescendants must usually **not** override this method. Instead,\nthey must override `to_s(io)`, which must append to the given\nIO object.","summary":"<p>Returns a string representation of this object.</p>","abstract":false,"args":[],"args_string":"","args_html":"","location":{"filename":"src/crypto/bcrypt.cr","line_number":82,"url":null},"def":{"name":"to_s","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"@hash || (@hash = (begin\n  salt64 = Base64.encode(salt, salt.size)\n  digest64 = Base64.encode(digest, digest.size - 1)\n  \"$2a$%02d$%s%s\" % {cost, salt64, digest64}\nend))"}},{"id":"to_slice(*args,**options)-instance-method","html_id":"to_slice(*args,**options)-instance-method","name":"to_slice","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options)","args_html":"(*args, **options)","location":{"filename":"src/crypto/bcrypt.cr","line_number":98,"url":null},"def":{"name":"to_slice","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"to_s.to_slice(*args, **options)"}},{"id":"to_slice(*args,**options,&)-instance-method","html_id":"to_slice(*args,**options,&)-instance-method","name":"to_slice","doc":null,"summary":null,"abstract":false,"args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"args_string":"(*args, **options, &)","args_html":"(*args, **options, &)","location":{"filename":"src/crypto/bcrypt.cr","line_number":98,"url":null},"def":{"name":"to_slice","args":[{"name":"args","doc":null,"default_value":"","external_name":"args","restriction":""}],"double_splat":{"name":"options","doc":null,"default_value":"","external_name":"options","restriction":""},"splat_index":0,"yields":1,"block_arg":null,"return_type":"","visibility":"Public","body":"to_s.to_slice(*args, **options) do |*yield_args|\n  yield *yield_args\nend"}}],"macros":[],"types":[{"html_id":"Crystal/Crypto/Bcrypt/Error","path":"Crypto/Bcrypt/Error.html","kind":"class","full_name":"Crypto::Bcrypt::Error","name":"Error","abstract":false,"superclass":{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},"ancestors":[{"html_id":"Crystal/Exception","kind":"class","full_name":"Exception","name":"Exception"},{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Crypto/Bcrypt","kind":"class","full_name":"Crypto::Bcrypt","name":"Bcrypt"},"doc":null,"summary":null,"class_methods":[],"constructors":[],"instance_methods":[],"macros":[],"types":[]},{"html_id":"Crystal/Crypto/Bcrypt/Password","path":"Crypto/Bcrypt/Password.html","kind":"class","full_name":"Crypto::Bcrypt::Password","name":"Password","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Crypto/Bcrypt","kind":"class","full_name":"Crypto::Bcrypt","name":"Bcrypt"},"doc":"Generate, read and verify `Crypto::Bcrypt` hashes.\n\n```\nrequire \"crypto/bcrypt/password\"\n\npassword = Crypto::Bcrypt::Password.create(\"super secret\", cost: 10)\n# => $2a$10$rI4xRiuAN2fyiKwynO6PPuorfuoM4L2PVv6hlnVJEmNLjqcibAfHq\n\npassword.verify(\"wrong secret\") # => false\npassword.verify(\"super secret\") # => true\n```\n\nSee `Crypto::Bcrypt` for hints to select the cost when generating hashes.","summary":"<p>Generate, read and verify <code><a href=\"../../Crypto/Bcrypt.html\">Crypto::Bcrypt</a></code> hashes.</p>","class_methods":[],"constructors":[{"id":"create(password,cost=DEFAULT_COST):self-class-method","html_id":"create(password,cost=DEFAULT_COST):self-class-method","name":"create","doc":"Hashes a password.\n\n```\nrequire \"crypto/bcrypt/password\"\n\npassword = Crypto::Bcrypt::Password.create(\"super secret\", cost: 10)\n# => $2a$10$rI4xRiuAN2fyiKwynO6PPuorfuoM4L2PVv6hlnVJEmNLjqcibAfHq\n```","summary":"<p>Hashes a password.</p>","abstract":false,"args":[{"name":"password","doc":null,"default_value":"","external_name":"password","restriction":""},{"name":"cost","doc":null,"default_value":"DEFAULT_COST","external_name":"cost","restriction":""}],"args_string":"(password, cost = <span class=\"t\">DEFAULT_COST</span>) : <span class=\"k\">self</span>","args_html":"(password, cost = <span class=\"t\">DEFAULT_COST</span>) : <span class=\"k\">self</span>","location":{"filename":"src/crypto/bcrypt/password.cr","line_number":26,"url":null},"def":{"name":"create","args":[{"name":"password","doc":null,"default_value":"","external_name":"password","restriction":""},{"name":"cost","doc":null,"default_value":"DEFAULT_COST","external_name":"cost","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"self","visibility":"Public","body":"new((Bcrypt.hash_secret(password, cost)).to_s)"}},{"id":"new(raw_hash:String)-class-method","html_id":"new(raw_hash:String)-class-method","name":"new","doc":"Loads a bcrypt hash.\n\n```\nrequire \"crypto/bcrypt/password\"\n\npassword = Crypto::Bcrypt::Password.new(\"$2a$10$X6rw/jDiLBuzHV./JjBNXe8/Po4wTL0fhdDNdAdjcKN/Fup8tGCya\")\npassword.version # => \"2a\"\npassword.salt    # => \"X6rw/jDiLBuzHV./JjBNXe\"\npassword.digest  # => \"8/Po4wTL0fhdDNdAdjcKN/Fup8tGCya\"\n```","summary":"<p>Loads a bcrypt hash.</p>","abstract":false,"args":[{"name":"raw_hash","doc":null,"default_value":"","external_name":"raw_hash","restriction":"String"}],"args_string":"(raw_hash : String)","args_html":"(raw_hash : <a href=\"../../String.html\">String</a>)","location":{"filename":"src/crypto/bcrypt/password.cr","line_number":45,"url":null},"def":{"name":"new","args":[{"name":"raw_hash","doc":null,"default_value":"","external_name":"raw_hash","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(raw_hash)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"cost:Int32-instance-method","html_id":"cost:Int32-instance-method","name":"cost","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : Int32","args_html":" : <a href=\"../../Int32.html\">Int32</a>","location":{"filename":"src/crypto/bcrypt/password.cr","line_number":31,"url":null},"def":{"name":"cost","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Int32","visibility":"Public","body":"@cost"}},{"id":"digest:String-instance-method","html_id":"digest:String-instance-method","name":"digest","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : String","args_html":" : <a href=\"../../String.html\">String</a>","location":{"filename":"src/crypto/bcrypt/password.cr","line_number":33,"url":null},"def":{"name":"digest","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"@digest"}},{"id":"inspect(io:IO):Nil-instance-method","html_id":"inspect(io:IO):Nil-instance-method","name":"inspect","doc":"Appends a String representation of this object\nwhich includes its class name, its object address\nand the values of all instance variables.\n\n```\nclass Person\n  def initialize(@name : String, @age : Int32)\n  end\nend\n\nPerson.new(\"John\", 32).inspect # => #<Person:0x10fd31f20 @name=\"John\", @age=32>\n```","summary":"<p>Appends a String representation of this object which includes its class name, its object address and the values of all instance variables.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../../IO.html\">IO</a>) : <a href=\"../../Nil.html\">Nil</a>","location":{"filename":"src/crypto/bcrypt/password.cr","line_number":77,"url":null},"def":{"name":"inspect","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"to_s(io)"}},{"id":"salt:String-instance-method","html_id":"salt:String-instance-method","name":"salt","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : String","args_html":" : <a href=\"../../String.html\">String</a>","location":{"filename":"src/crypto/bcrypt/password.cr","line_number":32,"url":null},"def":{"name":"salt","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"@salt"}},{"id":"to_s(io:IO):Nil-instance-method","html_id":"to_s(io:IO):Nil-instance-method","name":"to_s","doc":"Appends a short String representation of this object\nwhich includes its class name and its object address.\n\n```\nclass Person\n  def initialize(@name : String, @age : Int32)\n  end\nend\n\nPerson.new(\"John\", 32).to_s # => #<Person:0x10a199f20>\n```","summary":"<p>Appends a short String representation of this object which includes its class name and its object address.</p>","abstract":false,"args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"args_string":"(io : IO) : Nil","args_html":"(io : <a href=\"../../IO.html\">IO</a>) : <a href=\"../../Nil.html\">Nil</a>","location":{"filename":"src/crypto/bcrypt/password.cr","line_number":73,"url":null},"def":{"name":"to_s","args":[{"name":"io","doc":null,"default_value":"","external_name":"io","restriction":"IO"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Nil","visibility":"Public","body":"io << @raw_hash"}},{"id":"verify(password:String):Bool-instance-method","html_id":"verify(password:String):Bool-instance-method","name":"verify","doc":"Verifies a password against the hash.\n\n```\nrequire \"crypto/bcrypt/password\"\n\npassword = Crypto::Bcrypt::Password.create(\"super secret\")\npassword.verify(\"wrong secret\") # => false\npassword.verify(\"super secret\") # => true\n```","summary":"<p>Verifies a password against the hash.</p>","abstract":false,"args":[{"name":"password","doc":null,"default_value":"","external_name":"password","restriction":"String"}],"args_string":"(password : String) : Bool","args_html":"(password : <a href=\"../../String.html\">String</a>) : <a href=\"../../Bool.html\">Bool</a>","location":{"filename":"src/crypto/bcrypt/password.cr","line_number":68,"url":null},"def":{"name":"verify","args":[{"name":"password","doc":null,"default_value":"","external_name":"password","restriction":"String"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"Bool","visibility":"Public","body":"hashed_password = Bcrypt.new(password, salt, cost)\nCrypto::Subtle.constant_time_compare(@raw_hash, hashed_password)\n"}},{"id":"version:String-instance-method","html_id":"version:String-instance-method","name":"version","doc":null,"summary":null,"abstract":false,"args":[],"args_string":" : String","args_html":" : <a href=\"../../String.html\">String</a>","location":{"filename":"src/crypto/bcrypt/password.cr","line_number":30,"url":null},"def":{"name":"version","args":[],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"String","visibility":"Public","body":"@version"}}],"macros":[],"types":[]}]},{"html_id":"Crystal/Crypto/Blowfish","path":"Crypto/Blowfish.html","kind":"class","full_name":"Crypto::Blowfish","name":"Blowfish","abstract":false,"superclass":{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},"ancestors":[{"html_id":"Crystal/Reference","kind":"class","full_name":"Reference","name":"Reference"},{"html_id":"Crystal/Object","kind":"class","full_name":"Object","name":"Object"}],"locations":[],"repository_name":"Crystal","program":false,"enum":false,"alias":false,"aliased":null,"aliased_html":null,"const":false,"constants":[{"id":"DEFAULT_ROUNDS","name":"DEFAULT_ROUNDS","value":"16","doc":null,"summary":null}],"included_modules":[],"extended_modules":[],"subclasses":[],"including_types":[],"namespace":{"html_id":"Crystal/Crypto","kind":"module","full_name":"Crypto","name":"Crypto"},"doc":null,"summary":null,"class_methods":[],"constructors":[{"id":"new(rounds=DEFAULT_ROUNDS)-class-method","html_id":"new(rounds=DEFAULT_ROUNDS)-class-method","name":"new","doc":null,"summary":null,"abstract":false,"args":[{"name":"rounds","doc":null,"default_value":"DEFAULT_ROUNDS","external_name":"rounds","restriction":""}],"args_string":"(rounds = <span class=\"t\">DEFAULT_ROUNDS</span>)","args_html":"(rounds = <span class=\"t\">DEFAULT_ROUNDS</span>)","location":{"filename":"src/crypto/blowfish.cr","line_number":10,"url":null},"def":{"name":"new","args":[{"name":"rounds","doc":null,"default_value":"DEFAULT_ROUNDS","external_name":"rounds","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"_ = allocate\n_.initialize(rounds)\nif _.responds_to?(:finalize)\n  ::GC.add_finalizer(_)\nend\n_\n"}}],"instance_methods":[{"id":"decrypt_pair(l:UInt32,r:UInt32)-instance-method","html_id":"decrypt_pair(l:UInt32,r:UInt32)-instance-method","name":"decrypt_pair","doc":null,"summary":null,"abstract":false,"args":[{"name":"l","doc":null,"default_value":"","external_name":"l","restriction":"UInt32"},{"name":"r","doc":null,"default_value":"","external_name":"r","restriction":"UInt32"}],"args_string":"(l : UInt32, r : UInt32)","args_html":"(l : <a href=\"../UInt32.html\">UInt32</a>, r : <a href=\"../UInt32.html\">UInt32</a>)","location":{"filename":"src/crypto/blowfish.cr","line_number":55,"url":null},"def":{"name":"decrypt_pair","args":[{"name":"l","doc":null,"default_value":"","external_name":"l","restriction":"UInt32"},{"name":"r","doc":null,"default_value":"","external_name":"r","restriction":"UInt32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"(@rounds + 1).downto(2) do |i|\n  l = l ^ @p.to_unsafe[i]\n  r = r ^ (f(l))\n  l, r = r, l\nend\nl, r = r, l\nr = r ^ @p.to_unsafe[1]\nl = l ^ @p.to_unsafe[0]\n{l, r}\n"}},{"id":"encrypt_pair(l:UInt32,r:UInt32)-instance-method","html_id":"encrypt_pair(l:UInt32,r:UInt32)-instance-method","name":"encrypt_pair","doc":null,"summary":null,"abstract":false,"args":[{"name":"l","doc":null,"default_value":"","external_name":"l","restriction":"UInt32"},{"name":"r","doc":null,"default_value":"","external_name":"r","restriction":"UInt32"}],"args_string":"(l : UInt32, r : UInt32)","args_html":"(l : <a href=\"../UInt32.html\">UInt32</a>, r : <a href=\"../UInt32.html\">UInt32</a>)","location":{"filename":"src/crypto/blowfish.cr","line_number":40,"url":null},"def":{"name":"encrypt_pair","args":[{"name":"l","doc":null,"default_value":"","external_name":"l","restriction":"UInt32"},{"name":"r","doc":null,"default_value":"","external_name":"r","restriction":"UInt32"}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"0.upto(@rounds - 1) do |i|\n  l = l ^ @p.to_unsafe[i]\n  r = r ^ (f(l))\n  l, r = r, l\nend\nl, r = r, l\nr = r ^ @p.to_unsafe[@rounds]\nl = l ^ @p.to_unsafe[@rounds + 1]\n{l, r}\n"}},{"id":"expand_key(key)-instance-method","html_id":"expand_key(key)-instance-method","name":"expand_key","doc":null,"summary":null,"abstract":false,"args":[{"name":"key","doc":null,"default_value":"","external_name":"key","restriction":""}],"args_string":"(key)","args_html":"(key)","location":{"filename":"src/crypto/blowfish.cr","line_number":18,"url":null},"def":{"name":"expand_key","args":[{"name":"key","doc":null,"default_value":"","external_name":"key","restriction":""}],"double_splat":null,"splat_index":null,"yields":null,"block_arg":null,"return_type":"","visibility":"Public","body":"pos = 0\n0.upto(17) do |i|\n  __temp_26 = i\n  __temp_27 = @p.to_unsafe\n  __temp_27[__temp_26] = __temp_27[__temp_26] ^ (next_word(key, pointerof(pos)))\nend\nl, r = 0_u32, 0_u32\n(0..17).step(2) do |i|\n  l, r = encrypt_pair(l, r)\n  @p.to_unsafe[i] = l\n  @p.to_unsafe[i + 1] = r\nend\n(0..1023).step(2) do |i|\n  l, r = encrypt_pair(l, r)\n  @s.to_unsafe[i] = l\n  @s.to_unsafe[i + 1] = r\nend\n"}}],"macros":[],"types":[]},{"html_id":"Crystal/Crypto/Subtle",