/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nullable;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class ServiceListHandler
extends DefaultHandler {
    public static final ServiceManager.Descriptor[] EMPTY_DESCRIPTORS = new ServiceManager.Descriptor[0];
    private final PluginJAR plugin;
    private URL uri;
    private String serviceName;
    private String serviceClass;
    private final StringBuilder code;
    private final Stack<String> stateStack;
    private final List<ServiceManager.Descriptor> cachedServices;

    ServiceListHandler(PluginJAR pluginJAR, URL uRL) {
        this.plugin = pluginJAR;
        this.uri = uRL;
        this.code = new StringBuilder();
        this.stateStack = new Stack();
        this.cachedServices = new LinkedList<ServiceManager.Descriptor>();
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        return XMLUtilities.findEntity(string2, "services.dtd", this.getClass());
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        String string = this.peekElement();
        if ("SERVICE".equals(string)) {
            this.code.append(cArray, n, n2);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        this.pushElement(string3);
        this.serviceName = attributes.getValue("NAME");
        this.serviceClass = attributes.getValue("CLASS");
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        String string4 = this.peekElement();
        if (string3.equals(string4)) {
            if ("SERVICE".equals(string4)) {
                ServiceManager.Descriptor descriptor = new ServiceManager.Descriptor(this.serviceClass, this.serviceName, this.code.toString(), this.plugin);
                ServiceManager.registerService(descriptor);
                this.cachedServices.add(descriptor);
                this.code.setLength(0);
            }
        } else {
            throw new InternalError();
        }
        this.popElement();
    }

    @Override
    public void startDocument() {
        this.pushElement(null);
    }

    public ServiceManager.Descriptor[] getCachedServices() {
        return this.cachedServices.toArray(EMPTY_DESCRIPTORS);
    }

    private void pushElement(String string) {
        this.stateStack.push(string);
    }

    @Nullable
    private String peekElement() {
        return this.stateStack.peek();
    }

    private String popElement() {
        return this.stateStack.pop();
    }
}

