/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.InnerClassesLoweringKt;
import org.jetbrains.kotlin.backend.common.lower.InnerClassesSupport;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.VariableRemapper;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.PersistentApiKt;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "innerClassesSupport", "Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "lowerConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "irConstructor", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "ir.backend.common"})
public final class InnerClassesLowering
implements DeclarationTransformer {
    private final BackendContext context;
    private final InnerClassesSupport innerClassesSupport;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        LowerKt.toFileLoweringPass(LowerKt.runPostfix(this, true)).lower(irFile);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        if (declaration2 instanceof IrClass && ((IrClass)declaration2).isInner()) {
            PersistentApiKt.getStageController().unrestrictDeclarationListsAccess((Function0)new Function0<Unit>(this, declaration2){
                final /* synthetic */ InnerClassesLowering this$0;
                final /* synthetic */ IrDeclaration $declaration;

                public final void invoke() {
                    Collection collection = ((IrClass)this.$declaration).getDeclarations();
                    IrField irField = InnerClassesLowering.access$getInnerClassesSupport$p(this.this$0).getOuterThisField((IrClass)this.$declaration);
                    boolean bl = false;
                    collection.add(irField);
                }
                {
                    this.this$0 = innerClassesLowering;
                    this.$declaration = irDeclaration2;
                    super(0);
                }
            });
        } else if (declaration2 instanceof IrConstructor) {
            IrClass irClass2 = IrUtilsKt.getParentAsClass(declaration2);
            if (!irClass2.isInner()) {
                return null;
            }
            IrConstructor newConstructor2 = this.lowerConstructor((IrConstructor)declaration2);
            Map oldConstructorParameterToNew = InnerClassesLoweringKt.access$primaryConstructorParameterMap(this.innerClassesSupport, (IrConstructor)declaration2);
            for (Map.Entry entry : oldConstructorParameterToNew.entrySet()) {
                IrExpressionBody irExpressionBody;
                void oldParam;
                IrValueParameter newParam;
                Object object = entry;
                boolean bl = false;
                IrValueParameter irValueParameter = (IrValueParameter)object.getKey();
                object = entry;
                bl = false;
                IrValueParameter irValueParameter2 = newParam = (IrValueParameter)object.getValue();
                IrExpressionBody irExpressionBody2 = oldParam.getDefaultValue();
                if (irExpressionBody2 != null) {
                    void oldDefault;
                    object = irExpressionBody2;
                    bl = false;
                    boolean bl2 = false;
                    Object object2 = object;
                    IrValueParameter irValueParameter3 = irValueParameter2;
                    boolean bl3 = false;
                    IrExpressionBody irExpressionBody3 = this.context.getIrFactory().createExpressionBody(oldDefault.getStartOffset(), oldDefault.getEndOffset(), (Function1<? super IrExpressionBody, Unit>)new Function1<IrExpressionBody, Unit>((IrExpressionBody)oldDefault, this, newConstructor2){
                        final /* synthetic */ IrExpressionBody $oldDefault;
                        final /* synthetic */ InnerClassesLowering this$0;
                        final /* synthetic */ IrConstructor $newConstructor$inlined;
                        {
                            this.$oldDefault = irExpressionBody;
                            this.this$0 = innerClassesLowering;
                            this.$newConstructor$inlined = irConstructor2;
                            super(1);
                        }

                        public final void invoke(@NotNull IrExpressionBody $this$createExpressionBody) {
                            Intrinsics.checkNotNullParameter($this$createExpressionBody, "$receiver");
                            $this$createExpressionBody.setExpression((IrExpression)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)this.$oldDefault.getExpression(), this.$newConstructor$inlined));
                        }
                    });
                    irValueParameter2 = irValueParameter3;
                    irExpressionBody = irExpressionBody3;
                } else {
                    irExpressionBody = null;
                }
                irValueParameter2.setDefaultValue(irExpressionBody);
            }
            return CollectionsKt.listOf(newConstructor2);
        }
        return null;
    }

    private final IrConstructor lowerConstructor(IrConstructor irConstructor2) {
        IrConstructor loweredConstructor = this.innerClassesSupport.getInnerClassConstructorWithOuterThisParameter(irConstructor2);
        IrValueParameter outerThisParameter = loweredConstructor.getValueParameters().get(0);
        IrClass irClass2 = IrUtilsKt.getParentAsClass(irConstructor2);
        IrField parentThisField = this.innerClassesSupport.getOuterThisField(irClass2);
        IrBody irBody = irConstructor2.getBody();
        if (!(irBody instanceof IrBlockBody)) {
            irBody = null;
        }
        IrBlockBody irBlockBody2 = (IrBlockBody)irBody;
        if (irBlockBody2 == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected constructor body: " + irConstructor2.getBody())));
        }
        IrBlockBody blockBody = irBlockBody2;
        loweredConstructor.setBody(this.context.getIrFactory().createBlockBody(blockBody.getStartOffset(), blockBody.getEndOffset(), (Function1<? super IrBlockBody, Unit>)new Function1<IrBlockBody, Unit>(this, irConstructor2, irClass2, parentThisField, outerThisParameter, blockBody, loweredConstructor){
            final /* synthetic */ InnerClassesLowering this$0;
            final /* synthetic */ IrConstructor $irConstructor;
            final /* synthetic */ IrClass $irClass;
            final /* synthetic */ IrField $parentThisField;
            final /* synthetic */ IrValueParameter $outerThisParameter;
            final /* synthetic */ IrBlockBody $blockBody;
            final /* synthetic */ IrConstructor $loweredConstructor;

            public final void invoke(@NotNull IrBlockBody $this$createBlockBody) {
                Object v4;
                block4: {
                    Intrinsics.checkNotNullParameter($this$createBlockBody, "$receiver");
                    Object object = LowerUtilsKt.createIrBuilder(this.this$0.getContext(), this.$irConstructor.getSymbol(), this.$irConstructor.getStartOffset(), this.$irConstructor.getEndOffset());
                    boolean bl = false;
                    boolean bl2 = false;
                    DeclarationIrBuilder $this$apply = object;
                    boolean $i$a$-apply-InnerClassesLowering$lowerConstructor$1$22 = false;
                    List<IrStatement> list2 = $this$createBlockBody.getStatements();
                    IrBuilderWithScope irBuilderWithScope = $this$apply;
                    IrBuilderWithScope irBuilderWithScope2 = $this$apply;
                    IrValueParameter irValueParameter = this.$irClass.getThisReceiver();
                    Intrinsics.checkNotNull(irValueParameter);
                    list2.add(0, ExpressionHelpersKt.irSetField(irBuilderWithScope, ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter), this.$parentThisField, ExpressionHelpersKt.irGet($this$apply, this.$outerThisParameter)));
                    $this$createBlockBody.getStatements().addAll((Collection<IrStatement>)this.$blockBody.getStatements());
                    object = $this$createBlockBody.getStatements();
                    bl = false;
                    Object object2 = object;
                    boolean bl3 = false;
                    Iterator<T> $i$a$-apply-InnerClassesLowering$lowerConstructor$1$22 = object2.iterator();
                    while ($i$a$-apply-InnerClassesLowering$lowerConstructor$1$22.hasNext()) {
                        T t = $i$a$-apply-InnerClassesLowering$lowerConstructor$1$22.next();
                        IrStatement it = (IrStatement)t;
                        boolean bl4 = false;
                        if (!(it instanceof IrInstanceInitializerCall)) continue;
                        v4 = t;
                        break block4;
                    }
                    v4 = null;
                }
                if (v4 == null) {
                    Object v5;
                    boolean bl;
                    Object object;
                    block5: {
                        object = $this$createBlockBody.getStatements();
                        bl = false;
                        Iterable iterable = object;
                        boolean $i$a$-apply-InnerClassesLowering$lowerConstructor$1$22 = false;
                        for (E e : iterable) {
                            IrStatement it = (IrStatement)e;
                            boolean bl5 = false;
                            if (!(it instanceof IrDelegatingConstructorCall)) continue;
                            v5 = e;
                            break block5;
                        }
                        v5 = null;
                    }
                    IrDelegatingConstructorCall irDelegatingConstructorCall = v5;
                    if (irDelegatingConstructorCall == null) {
                        throw (Throwable)((Object)new AssertionError((Object)("Delegating constructor call expected: " + DumpIrTreeKt.dump$default(this.$irConstructor, false, 1, null))));
                    }
                    IrDelegatingConstructorCall delegatingConstructorCall = irDelegatingConstructorCall;
                    object = delegatingConstructorCall;
                    bl = false;
                    boolean bl6 = false;
                    Object $this$apply = object;
                    boolean bl7 = false;
                    ((IrMemberAccessExpression)$this$apply).setDispatchReceiver(new IrGetValueImpl($this$apply.getStartOffset(), $this$apply.getEndOffset(), this.$outerThisParameter.getSymbol(), null, 8, null));
                }
                PatchDeclarationParentsKt.patchDeclarationParents((IrElement)$this$createBlockBody, this.$loweredConstructor);
                Map oldConstructorParameterToNew = InnerClassesLoweringKt.access$primaryConstructorParameterMap(InnerClassesLowering.access$getInnerClassesSupport$p(this.this$0), this.$irConstructor);
                IrElementTransformerVoidKt.transformChildrenVoid($this$createBlockBody, new VariableRemapper(oldConstructorParameterToNew));
            }
            {
                this.this$0 = innerClassesLowering;
                this.$irConstructor = irConstructor2;
                this.$irClass = irClass2;
                this.$parentThisField = irField;
                this.$outerThisParameter = irValueParameter;
                this.$blockBody = irBlockBody2;
                this.$loweredConstructor = irConstructor3;
                super(1);
            }
        }));
        return loweredConstructor;
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    public InnerClassesLowering(@NotNull BackendContext context2, @NotNull InnerClassesSupport innerClassesSupport) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(innerClassesSupport, "innerClassesSupport");
        this.context = context2;
        this.innerClassesSupport = innerClassesSupport;
    }

    public static final /* synthetic */ InnerClassesSupport access$getInnerClassesSupport$p(InnerClassesLowering $this) {
        return $this.innerClassesSupport;
    }
}

