/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.pdftk_java;

import com.gitlab.pdftk_java.ErrorCode;
import com.gitlab.pdftk_java.InputPdf;
import com.gitlab.pdftk_java.PageRange;
import com.gitlab.pdftk_java.PageRef;
import com.gitlab.pdftk_java.PageRotate;
import com.gitlab.pdftk_java.attachments;
import com.gitlab.pdftk_java.burst;
import com.gitlab.pdftk_java.cat;
import com.gitlab.pdftk_java.filter;
import com.gitlab.pdftk_java.keyword;
import com.gitlab.pdftk_java.passwords;
import com.gitlab.pdftk_java.pdftk;
import com.gitlab.pdftk_java.report;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.text.WordUtils;
import pdftk.com.lowagie.text.DocumentException;
import pdftk.com.lowagie.text.pdf.FdfWriter;
import pdftk.com.lowagie.text.pdf.PdfDictionary;
import pdftk.com.lowagie.text.pdf.PdfName;
import pdftk.com.lowagie.text.pdf.PdfNumber;
import pdftk.com.lowagie.text.pdf.PdfReader;
import pdftk.com.lowagie.text.pdf.PdfWriter;

class TK_Session {
    boolean m_valid_b = false;
    boolean m_authorized_b = true;
    boolean m_input_pdf_readers_opened_b = false;
    boolean m_verbose_reporting_b = false;
    boolean m_ask_about_warnings_b = false;
    static final String creator = "pdftk-java 3.2.2";
    ArrayList<InputPdf> m_input_pdf = new ArrayList();
    HashMap<String, Integer> m_input_pdf_index = new HashMap();
    ArrayList<String> m_input_attach_file_filename = new ArrayList();
    int m_input_attach_file_pagenum = 0;
    String m_input_attach_file_relation = "Unspecified";
    String m_update_info_filename = "";
    boolean m_update_info_utf8_b = false;
    String m_update_xmp_filename = "";
    keyword m_operation = keyword.none_k;
    ArrayList<ArrayList<PageRef>> m_page_seq = new ArrayList();
    String m_form_data_filename = "";
    String m_background_filename = "";
    String m_stamp_filename = "";
    String m_output_filename = "";
    boolean m_output_utf8_b = false;
    String m_output_owner_pw = "";
    String m_output_user_pw = "";
    int m_output_user_perms = 0;
    boolean m_multistamp_b = false;
    boolean m_multibackground_b = false;
    boolean m_output_uncompress_b = false;
    boolean m_output_compress_b = false;
    boolean m_output_flatten_b = false;
    boolean m_output_need_appearances_b = false;
    boolean m_output_drop_xfa_b = false;
    boolean m_output_drop_xmp_b = false;
    boolean m_output_keep_first_id_b = false;
    boolean m_output_keep_final_id_b = false;
    boolean m_cat_full_pdfs_b = true;
    encryption_strength m_output_encryption_strength = encryption_strength.none_enc;
    byte[] m_output_owner_pw_pdfdoc = new byte[0];
    byte[] m_output_user_pw_pdfdoc = new byte[0];

    TK_Session() {
    }

    InputPdf.PagesReader add_reader(InputPdf input_pdf_p, boolean keep_artifacts_b) {
        InputPdf.PagesReader ret_val = input_pdf_p.add_reader(keep_artifacts_b, this.m_ask_about_warnings_b);
        this.m_authorized_b = this.m_authorized_b && input_pdf_p.m_authorized_b;
        return ret_val;
    }

    InputPdf.PagesReader add_reader(InputPdf input_pdf_p) {
        return this.add_reader(input_pdf_p, false);
    }

    boolean open_input_pdf_readers() {
        boolean open_success_b = true;
        if (!this.m_input_pdf_readers_opened_b) {
            if (this.m_operation == keyword.filter_k && this.m_input_pdf.size() == 1) {
                open_success_b = this.add_reader(this.m_input_pdf.get(0), true) != null;
            } else {
                for (InputPdf it : this.m_input_pdf) {
                    open_success_b = this.add_reader(it) != null && open_success_b;
                }
            }
            this.m_input_pdf_readers_opened_b = open_success_b;
        }
        return open_success_b;
    }

    void parse(String[] args) {
        new Parser().parse(args);
    }

    boolean is_valid() {
        return !(!this.m_valid_b || this.m_operation != keyword.dump_data_k && this.m_operation != keyword.dump_data_fields_k && this.m_operation != keyword.dump_data_annots_k && this.m_operation != keyword.generate_fdf_k && !this.m_authorized_b || this.m_input_pdf.isEmpty() || !this.m_input_pdf_readers_opened_b || this.m_operation != keyword.cat_k && this.m_operation != keyword.shuffle_k && this.m_operation != keyword.burst_k && this.m_operation != keyword.filter_k && this.m_operation != keyword.dump_data_k && this.m_operation != keyword.dump_data_utf8_k && this.m_operation != keyword.dump_data_fields_k && this.m_operation != keyword.dump_data_fields_utf8_k && this.m_operation != keyword.dump_data_annots_k && this.m_operation != keyword.generate_fdf_k && this.m_operation != keyword.unpack_files_k || (this.m_operation == keyword.burst_k || this.m_operation == keyword.filter_k) && this.m_input_pdf.size() != 1 || this.m_operation != keyword.burst_k && this.m_operation != keyword.dump_data_k && this.m_operation != keyword.dump_data_fields_k && this.m_operation != keyword.dump_data_annots_k && this.m_operation != keyword.generate_fdf_k && this.m_operation != keyword.unpack_files_k && this.m_output_filename.isEmpty());
    }

    void dump_session_data() {
        if (!this.m_verbose_reporting_b) {
            return;
        }
        if (!this.m_input_pdf_readers_opened_b) {
            System.out.println("Input PDF Open Errors");
            return;
        }
        if (this.is_valid()) {
            System.out.println("Command Line Data is valid.");
        } else {
            System.out.println("Command Line Data is NOT valid.");
        }
        System.out.println();
        System.out.println("Input PDF Filenames & Passwords in Order\n( <filename>[, <password>] ) ");
        if (this.m_input_pdf.isEmpty()) {
            System.out.println("   No input PDF filenames have been given.");
        } else {
            for (InputPdf it : this.m_input_pdf) {
                System.out.print("   " + it.m_filename);
                if (!it.m_password.isEmpty()) {
                    System.out.print(", " + it.m_password);
                }
                if (!it.m_authorized_b) {
                    System.out.print(", OWNER OR USER PASSWORD REQUIRED, but not given (or incorrect)");
                }
                System.out.println();
            }
        }
        System.out.println();
        System.out.println("The operation to be performed: ");
        switch (this.m_operation) {
            case cat_k: {
                System.out.println("   cat - Catenate given page ranges into a new PDF.");
                break;
            }
            case shuffle_k: {
                System.out.println("   shuffle - Interleave given page ranges into a new PDF.");
                break;
            }
            case burst_k: {
                System.out.println("   burst - Split a single, input PDF into individual pages.");
                break;
            }
            case filter_k: {
                System.out.println("   filter - Apply 'filters' to a single, input PDF based on output args.");
                System.out.println("      (When the operation is omitted, this is the default.)");
                break;
            }
            case dump_data_k: {
                System.out.println("   dump_data - Report statistics on a single, input PDF.");
                break;
            }
            case dump_data_fields_k: {
                System.out.println("   dump_data_fields - Report form field data on a single, input PDF.");
                break;
            }
            case dump_data_annots_k: {
                System.out.println("   dump_data_annots - Report annotation data on a single, input PDF.");
                break;
            }
            case generate_fdf_k: {
                System.out.println("   generate_fdf - Generate a dummy FDF file from a PDF.");
                break;
            }
            case unpack_files_k: {
                System.out.println("   unpack_files - Copy PDF file attachments into given directory.");
                break;
            }
            case none_k: {
                System.out.println("   NONE - No operation has been given.  See usage instructions.");
                break;
            }
            default: {
                System.out.println("   INTERNAL ERROR - An unexpected operation has been given.");
            }
        }
        System.out.println();
        System.out.println("The output file will be named:");
        if (this.m_output_filename.isEmpty()) {
            System.out.println("   No output filename has been given.");
        } else {
            System.out.println("   " + this.m_output_filename);
        }
        System.out.println();
        boolean output_encrypted_b = this.m_output_encryption_strength != encryption_strength.none_enc || !this.m_output_user_pw.isEmpty() || !this.m_output_owner_pw.isEmpty();
        System.out.println("Output PDF encryption settings:");
        if (output_encrypted_b) {
            System.out.println("   Output PDF will be encrypted.");
            switch (this.m_output_encryption_strength) {
                case none_enc: {
                    System.out.println("   Encryption strength not given. Defaulting to: AES 128 bits.");
                    break;
                }
                case rc4_40_enc: {
                    System.out.println("   Given output encryption strength: AES 40 bits");
                    break;
                }
                case rc4_128_enc: {
                    System.out.println("   Given output encryption strength: RC4 128 bits");
                    break;
                }
                case aes128_enc: {
                    System.out.println("   Given output encryption strength: AES 128 bits");
                }
            }
            System.out.println();
            if (this.m_output_user_pw.isEmpty()) {
                System.out.println("   No user password given.");
            } else {
                System.out.println("   Given user password: " + this.m_output_user_pw);
            }
            if (this.m_output_owner_pw.isEmpty()) {
                System.out.println("   No owner password given.");
            } else {
                System.out.println("   Given owner password: " + this.m_output_owner_pw);
            }
            if ((this.m_output_user_perms & 0x804) == 2052) {
                System.out.println("   ALLOW Top Quality Printing");
            } else if ((this.m_output_user_perms & 0x804) == 4) {
                System.out.println("   ALLOW Degraded Printing (Top-Quality Printing NOT Allowed)");
            } else {
                System.out.println("   Printing NOT Allowed");
            }
            if ((this.m_output_user_perms & 8) == 8) {
                System.out.println("   ALLOW Modifying of Contents");
            } else {
                System.out.println("   Modifying of Contents NOT Allowed");
            }
            if ((this.m_output_user_perms & 0x10) == 16) {
                System.out.println("   ALLOW Copying of Contents");
            } else {
                System.out.println("   Copying of Contents NOT Allowed");
            }
            if ((this.m_output_user_perms & 0x20) == 32) {
                System.out.println("   ALLOW Modifying of Annotations");
            } else {
                System.out.println("   Modifying of Annotations NOT Allowed");
            }
            if ((this.m_output_user_perms & 0x100) == 256) {
                System.out.println("   ALLOW Fill-In");
            } else {
                System.out.println("   Fill-In NOT Allowed");
            }
            if ((this.m_output_user_perms & 0x200) == 512) {
                System.out.println("   ALLOW Screen Readers");
            } else {
                System.out.println("   Screen Readers NOT Allowed");
            }
            if ((this.m_output_user_perms & 0x400) == 1024) {
                System.out.println("   ALLOW Assembly");
            } else {
                System.out.println("   Assembly NOT Allowed");
            }
        } else {
            System.out.println("   Output PDF will not be encrypted.");
        }
        System.out.println();
        if (this.m_operation != keyword.filter_k || output_encrypted_b || !this.m_output_compress_b && !this.m_output_uncompress_b) {
            System.out.println("No compression or uncompression being performed on output.");
        } else if (this.m_output_compress_b) {
            System.out.println("Compression will be applied to some PDF streams.");
        } else {
            System.out.println("Some PDF streams will be uncompressed.");
        }
    }

    static void apply_rotation_to_page(PdfReader reader_p, int page_num, int rotation, boolean absolute) {
        PdfDictionary page_p = reader_p.getPageN(page_num);
        if (!absolute) {
            rotation = reader_p.getPageRotation(page_num) + rotation;
        }
        page_p.remove(PdfName.ROTATE);
        if ((rotation %= 360) != PageRotate.NORTH.value) {
            page_p.put(PdfName.ROTATE, new PdfNumber(rotation));
        }
    }

    char prepare_writer(PdfWriter writer_p) throws DocumentException {
        if (this.m_output_uncompress_b) {
            writer_p.filterStreams = true;
            writer_p.compressStreams = false;
        } else if (this.m_output_compress_b) {
            writer_p.filterStreams = false;
            writer_p.compressStreams = true;
        }
        if (this.m_output_encryption_strength != encryption_strength.none_enc || !this.m_output_owner_pw.isEmpty() || !this.m_output_user_pw.isEmpty()) {
            if (this.m_output_encryption_strength == encryption_strength.none_enc) {
                this.m_output_encryption_strength = encryption_strength.aes128_enc;
            }
            int encryption_type = this.m_output_encryption_strength.value;
            writer_p.setEncryption(this.m_output_user_pw_pdfdoc, this.m_output_owner_pw_pdfdoc, this.m_output_user_perms, this.m_output_encryption_strength.value);
        }
        return this.m_output_encryption_strength.pdf_version;
    }

    ErrorCode create_output() {
        if (!this.is_valid()) {
            return ErrorCode.ERROR;
        }
        if (this.m_verbose_reporting_b) {
            System.out.println();
            System.out.println("Creating Output ...");
        }
        if (this.m_output_owner_pw.equals("PROMPT")) {
            this.m_output_owner_pw = pdftk.prompt_for_password("owner", "the output PDF");
        }
        if (this.m_output_user_pw.equals("PROMPT")) {
            this.m_output_user_pw = pdftk.prompt_for_password("user", "the output PDF");
        }
        if (!this.m_output_owner_pw.isEmpty()) {
            this.m_output_owner_pw_pdfdoc = passwords.utf8_password_to_pdfdoc(this.m_output_owner_pw, true);
            if (this.m_output_owner_pw_pdfdoc == null) {
                System.err.println("Error: Owner password used to encrypt output PDF includes");
                System.err.println("   invalid characters.");
                return ErrorCode.ERROR;
            }
        }
        if (!this.m_output_user_pw.isEmpty()) {
            this.m_output_user_pw_pdfdoc = passwords.utf8_password_to_pdfdoc(this.m_output_user_pw, true);
            if (this.m_output_user_pw_pdfdoc == null) {
                System.err.println("Error: User password used to encrypt output PDF includes");
                System.err.println("   invalid characters.");
                return ErrorCode.ERROR;
            }
        }
        switch (this.m_operation) {
            case burst_k: 
            case dump_data_k: 
            case dump_data_fields_k: 
            case dump_data_annots_k: 
            case generate_fdf_k: 
            case unpack_files_k: {
                if (1 >= this.m_input_pdf.size()) break;
                System.err.println("Error: Only one input PDF file may be used for the " + (Object)((Object)this.m_operation) + " operation");
                return ErrorCode.ERROR;
            }
        }
        try {
            switch (this.m_operation) {
                case cat_k: 
                case shuffle_k: {
                    cat cat2 = new cat(this);
                    return cat2.create_output_cat();
                }
                case burst_k: {
                    burst burst2 = new burst(this);
                    return burst2.create_output_burst();
                }
                case filter_k: {
                    filter filter2 = new filter(this);
                    return filter2.create_output_filter();
                }
                case dump_data_k: 
                case dump_data_fields_k: 
                case dump_data_annots_k: {
                    PdfReader input_reader_p = this.m_input_pdf.get((int)0).m_readers.get((int)0).second;
                    try {
                        PrintStream ofs = pdftk.get_print_stream(this.m_output_filename, this.m_output_utf8_b);
                        if (this.m_operation == keyword.dump_data_k) {
                            report.ReportOnPdf(ofs, input_reader_p, this.m_output_utf8_b);
                            break;
                        }
                        if (this.m_operation == keyword.dump_data_fields_k) {
                            report.ReportAcroFormFields(ofs, input_reader_p, this.m_output_utf8_b);
                            break;
                        }
                        if (this.m_operation == keyword.dump_data_annots_k) {
                            report.ReportAnnots(ofs, input_reader_p, this.m_output_utf8_b);
                        }
                        break;
                    }
                    catch (FileNotFoundException e) {
                        System.err.println("Error: unable to open file for output: " + this.m_output_filename);
                        return ErrorCode.ERROR;
                    }
                }
                case generate_fdf_k: {
                    PdfReader input_reader_p = this.m_input_pdf.get((int)0).m_readers.get((int)0).second;
                    OutputStream ofs_p = pdftk.get_output_stream(this.m_output_filename, this.m_ask_about_warnings_b);
                    if (ofs_p != null) {
                        FdfWriter writer_p = new FdfWriter();
                        input_reader_p.getAcroFields().exportAsFdf(writer_p);
                        writer_p.writeTo(ofs_p);
                        break;
                    }
                    return ErrorCode.ERROR;
                }
                case unpack_files_k: {
                    PdfReader input_reader_p = this.m_input_pdf.get((int)0).m_readers.get((int)0).second;
                    attachments attachments2 = new attachments(this);
                    attachments2.unpack_files(input_reader_p);
                    break;
                }
                default: {
                    System.err.println("Unexpected pdftk Error in create_output()");
                    return ErrorCode.BUG;
                }
            }
        }
        catch (NoClassDefFoundError error) {
            pdftk.describe_missing_library(error);
            return ErrorCode.ERROR;
        }
        catch (Throwable t_p) {
            System.err.println("Unhandled Java Exception in create_output():");
            t_p.printStackTrace();
            return ErrorCode.BUG;
        }
        return ErrorCode.NO_ERROR;
    }

    private boolean handle_some_output_options(keyword kw, ArgStateMutable arg_state_p) {
        switch (kw) {
            case output_k: {
                arg_state_p.value = ArgState.output_filename_e;
                break;
            }
            case owner_pw_k: {
                arg_state_p.value = ArgState.output_owner_pw_e;
                break;
            }
            case user_pw_k: {
                arg_state_p.value = ArgState.output_user_pw_e;
                break;
            }
            case user_perms_k: {
                arg_state_p.value = ArgState.output_user_perms_e;
                break;
            }
            case encrypt_40bit_k: {
                this.m_output_encryption_strength = encryption_strength.rc4_40_enc;
                break;
            }
            case encrypt_128bit_k: {
                this.m_output_encryption_strength = encryption_strength.rc4_128_enc;
                break;
            }
            case encrypt_aes128_k: {
                this.m_output_encryption_strength = encryption_strength.aes128_enc;
            }
            case filt_uncompress_k: {
                this.m_output_uncompress_b = true;
                break;
            }
            case filt_compress_k: {
                this.m_output_compress_b = true;
                break;
            }
            case flatten_k: {
                this.m_output_flatten_b = true;
                break;
            }
            case need_appearances_k: {
                this.m_output_need_appearances_b = true;
                break;
            }
            case drop_xfa_k: {
                this.m_output_drop_xfa_b = true;
                break;
            }
            case drop_xmp_k: {
                this.m_output_drop_xmp_b = true;
                break;
            }
            case keep_first_id_k: {
                this.m_output_keep_first_id_b = true;
                break;
            }
            case keep_final_id_k: {
                this.m_output_keep_final_id_b = true;
                break;
            }
            case verbose_k: {
                this.m_verbose_reporting_b = true;
                break;
            }
            case dont_ask_k: {
                this.m_ask_about_warnings_b = false;
                break;
            }
            case do_ask_k: {
                this.m_ask_about_warnings_b = true;
                break;
            }
            case background_k: {
                if (this.m_operation != keyword.filter_k) {
                    System.err.println("Warning: the \"background\" output option works only in filter mode.");
                    System.err.println("  This means it won't work in combination with \"cat\", \"burst\",");
                    System.err.println("  \"attach_file\", etc.  To run pdftk in filter mode, simply omit");
                    System.err.println("  the operation, e.g.: pdftk in.pdf output out.pdf background back.pdf");
                    System.err.println("  Or, use background as an operation; this is the preferred technique:");
                    System.err.println("    pdftk in.pdf background back.pdf output out.pdf");
                }
                arg_state_p.value = ArgState.background_filename_e;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    class ArgStateMutable {
        ArgState value;

        ArgStateMutable() {
        }
    }

    static enum encryption_strength {
        none_enc(-1, '2'),
        rc4_40_enc(0, '3'),
        rc4_128_enc(1, '4'),
        aes128_enc(2, '6');

        final int value;
        final char pdf_version;

        private encryption_strength(int value, char pdf_version) {
            this.value = value;
            this.pdf_version = pdf_version;
        }
    }

    class Parser {
        ArgState arg_state = ArgState.input_files_e;
        String argv;
        keyword arg_keyword = keyword.none_k;
        boolean password_using_handles_not_b = false;
        boolean password_using_handles_b = false;
        int password_input_pdf_index = 0;
        boolean fail_b = false;

        Parser() {
        }

        void parse(String[] args) {
            for (String argv : args) {
                keyword kw = keyword.is_keyword(argv);
                if (kw == keyword.dont_ask_k) {
                    TK_Session.this.m_ask_about_warnings_b = false;
                    continue;
                }
                if (kw != keyword.do_ask_k) continue;
                TK_Session.this.m_ask_about_warnings_b = true;
            }
            String[] stringArray = args;
            int n = stringArray.length;
            block18: for (int i = 0; i < n; ++i) {
                String arg;
                this.argv = arg = stringArray[i];
                if (this.fail_b || this.arg_state == ArgState.done_e) break;
                this.arg_keyword = keyword.is_keyword(this.argv);
                if (this.arg_keyword == keyword.even_k || this.arg_keyword == keyword.odd_k) {
                    this.arg_keyword = keyword.none_k;
                }
                switch (this.arg_state) {
                    case input_files_e: 
                    case input_pw_e: {
                        this.parse_state_input();
                        continue block18;
                    }
                    case page_seq_e: {
                        this.parse_state_page_seq();
                        continue block18;
                    }
                    case form_data_filename_e: {
                        this.parse_state_form_data_filename();
                        continue block18;
                    }
                    case attach_file_filename_e: {
                        this.parse_state_attach_file_filename();
                        continue block18;
                    }
                    case attach_file_pagenum_e: {
                        this.parse_state_attach_file_pagenum();
                        continue block18;
                    }
                    case attach_file_relation_e: {
                        this.parse_state_attach_file_relation();
                        continue block18;
                    }
                    case update_info_filename_e: {
                        this.parse_state_update_info_filename();
                        continue block18;
                    }
                    case output_e: {
                        this.parse_state_output();
                        continue block18;
                    }
                    case output_filename_e: {
                        this.parse_state_output_filename();
                        continue block18;
                    }
                    case output_args_e: {
                        this.parse_state_output_args();
                        continue block18;
                    }
                    case output_owner_pw_e: {
                        this.parse_state_output_owner_pw();
                        continue block18;
                    }
                    case output_user_pw_e: {
                        this.parse_state_output_user_pw();
                        continue block18;
                    }
                    case output_user_perms_e: {
                        this.parse_state_output_user_perms();
                        continue block18;
                    }
                    case background_filename_e: {
                        this.parse_state_background_filename();
                        continue block18;
                    }
                    case stamp_filename_e: {
                        this.parse_state_stamp_filename();
                        continue block18;
                    }
                    default: {
                        System.err.println("Internal Error: Unexpected arg_state.  Exiting.");
                        this.fail_b = true;
                    }
                }
            }
            if (this.fail_b) {
                System.err.println("Errors encountered.  No output created.");
                TK_Session.this.m_valid_b = false;
                TK_Session.this.m_input_pdf.clear();
            } else {
                TK_Session.this.m_valid_b = true;
                if (!TK_Session.this.m_input_pdf_readers_opened_b) {
                    TK_Session.this.open_input_pdf_readers();
                }
            }
        }

        void parse_state_input() {
            if (this.arg_keyword == keyword.input_pw_k) {
                this.arg_state = ArgState.input_pw_e;
            } else if (this.arg_keyword == keyword.cat_k) {
                TK_Session.this.m_operation = keyword.cat_k;
                this.arg_state = ArgState.page_seq_e;
            } else if (this.arg_keyword == keyword.shuffle_k) {
                TK_Session.this.m_operation = keyword.shuffle_k;
                this.arg_state = ArgState.page_seq_e;
            } else if (this.arg_keyword == keyword.burst_k) {
                TK_Session.this.m_operation = keyword.burst_k;
                this.arg_state = ArgState.output_args_e;
            } else if (this.arg_keyword == keyword.filter_k) {
                TK_Session.this.m_operation = keyword.filter_k;
                this.arg_state = ArgState.output_e;
            } else if (this.arg_keyword == keyword.dump_data_k) {
                TK_Session.this.m_operation = keyword.dump_data_k;
                this.arg_state = ArgState.output_e;
            } else if (this.arg_keyword == keyword.dump_data_utf8_k) {
                TK_Session.this.m_operation = keyword.dump_data_k;
                TK_Session.this.m_output_utf8_b = true;
                this.arg_state = ArgState.output_e;
            } else if (this.arg_keyword == keyword.dump_data_fields_k) {
                TK_Session.this.m_operation = keyword.dump_data_fields_k;
                this.arg_state = ArgState.output_e;
            } else if (this.arg_keyword == keyword.dump_data_fields_utf8_k) {
                TK_Session.this.m_operation = keyword.dump_data_fields_k;
                TK_Session.this.m_output_utf8_b = true;
                this.arg_state = ArgState.output_e;
            } else if (this.arg_keyword == keyword.dump_data_k) {
                TK_Session.this.m_operation = keyword.dump_data_k;
                this.arg_state = ArgState.output_e;
            } else if (this.arg_keyword == keyword.dump_data_annots_k) {
                TK_Session.this.m_operation = keyword.dump_data_annots_k;
                this.arg_state = ArgState.output_e;
            } else if (this.arg_keyword == keyword.generate_fdf_k) {
                TK_Session.this.m_operation = keyword.generate_fdf_k;
                TK_Session.this.m_output_utf8_b = true;
                this.arg_state = ArgState.output_e;
            } else if (this.arg_keyword == keyword.fill_form_k) {
                TK_Session.this.m_operation = keyword.filter_k;
                this.arg_state = ArgState.form_data_filename_e;
            } else if (this.arg_keyword == keyword.attach_file_k) {
                TK_Session.this.m_operation = keyword.filter_k;
                this.arg_state = ArgState.attach_file_filename_e;
            } else if (this.arg_keyword == keyword.attach_file_to_page_k) {
                this.arg_state = ArgState.attach_file_pagenum_e;
            } else if (this.arg_keyword == keyword.attach_file_relation_k) {
                this.arg_state = ArgState.attach_file_relation_e;
            } else if (this.arg_keyword == keyword.unpack_files_k) {
                TK_Session.this.m_operation = keyword.unpack_files_k;
                this.arg_state = ArgState.output_e;
            } else if (this.arg_keyword == keyword.update_info_k) {
                TK_Session.this.m_operation = keyword.filter_k;
                TK_Session.this.m_update_info_utf8_b = false;
                this.arg_state = ArgState.update_info_filename_e;
            } else if (this.arg_keyword == keyword.update_info_utf8_k) {
                TK_Session.this.m_operation = keyword.filter_k;
                TK_Session.this.m_update_info_utf8_b = true;
                this.arg_state = ArgState.update_info_filename_e;
            } else if (this.arg_keyword == keyword.background_k) {
                TK_Session.this.m_operation = keyword.filter_k;
                this.arg_state = ArgState.background_filename_e;
            } else if (this.arg_keyword == keyword.multibackground_k) {
                TK_Session.this.m_operation = keyword.filter_k;
                TK_Session.this.m_multibackground_b = true;
                this.arg_state = ArgState.background_filename_e;
            } else if (this.arg_keyword == keyword.stamp_k) {
                TK_Session.this.m_operation = keyword.filter_k;
                this.arg_state = ArgState.stamp_filename_e;
            } else if (this.arg_keyword == keyword.multistamp_k) {
                TK_Session.this.m_operation = keyword.filter_k;
                TK_Session.this.m_multistamp_b = true;
                this.arg_state = ArgState.stamp_filename_e;
            } else if (this.arg_keyword == keyword.rotate_k) {
                TK_Session.this.m_operation = keyword.filter_k;
                this.arg_state = ArgState.page_seq_e;
            } else if (this.arg_keyword == keyword.output_k) {
                this.arg_state = ArgState.output_filename_e;
            } else if (this.arg_keyword == keyword.none_k) {
                Pattern p = Pattern.compile("(?:([A-Z]+)=)?(.*)", 32);
                Matcher m = p.matcher(this.argv);
                m.matches();
                String handle = m.group(1);
                String data = m.group(2);
                if (this.arg_state == ArgState.input_files_e) {
                    this.parse_state_input_files(handle, data);
                } else if (this.arg_state == ArgState.input_pw_e) {
                    this.parse_state_input_pw(handle, data);
                } else {
                    System.err.println("Error: Internal error: unexpected arg_state.  Exiting.");
                    this.fail_b = true;
                }
            } else {
                System.err.println("Error: Unexpected command-line data: ");
                System.err.println("      " + this.argv);
                if (this.arg_state == ArgState.input_files_e) {
                    System.err.println("   where we were expecting an input PDF filename,");
                    System.err.println("   operation (e.g. \"cat\") or \"input_pw\".  Exiting.");
                } else {
                    System.err.println("   where we were expecting an input PDF password");
                    System.err.println("   or operation (e.g. \"cat\").  Exiting.");
                }
                this.fail_b = true;
            }
        }

        void parse_state_input_files(String handle, String data) {
            InputPdf input_pdf = new InputPdf();
            input_pdf.m_filename = data;
            if (handle == null) {
                TK_Session.this.m_input_pdf.add(input_pdf);
            } else {
                Integer it = TK_Session.this.m_input_pdf_index.get(handle);
                if (it != null) {
                    System.err.println("Error: Handle given here: ");
                    System.err.println("      " + this.argv);
                    System.err.println("   is already associated with: ");
                    System.err.println("      " + TK_Session.this.m_input_pdf.get((int)it.intValue()).m_filename);
                    System.err.println("   Exiting.");
                    this.fail_b = true;
                } else {
                    TK_Session.this.m_input_pdf.add(input_pdf);
                    TK_Session.this.m_input_pdf_index.put(handle, TK_Session.this.m_input_pdf.size() - 1);
                }
            }
        }

        void parse_state_input_pw(String handle, String data) {
            if (TK_Session.this.m_input_pdf_index.size() == 0) {
                handle = null;
                data = this.argv;
            }
            if (handle == null) {
                if (this.password_using_handles_b) {
                    System.err.println("Error: Expected a user-supplied handle for this input");
                    System.err.println("   PDF password: " + this.argv);
                    System.err.println();
                    System.err.println("   Handles must be supplied with ~all~ input");
                    System.err.println("   PDF passwords, or with ~no~ input PDF passwords.");
                    System.err.println("   If no handles are supplied, then passwords are applied");
                    System.err.println("   according to input PDF order.");
                    System.err.println();
                    System.err.println("   Handles are given like this: <handle>=<password>, and");
                    System.err.println("   they must be one or more upper-case letters.");
                    this.fail_b = true;
                } else {
                    this.password_using_handles_not_b = true;
                    if (this.password_input_pdf_index < TK_Session.this.m_input_pdf.size()) {
                        pdftk.warn_if_argument_is_password(this.argv);
                        TK_Session.this.m_input_pdf.get((int)this.password_input_pdf_index).m_password = this.argv;
                        ++this.password_input_pdf_index;
                    } else {
                        System.err.println("Error: more input passwords than input PDF documents.");
                        System.err.println("   Exiting.");
                        this.fail_b = true;
                    }
                }
            } else if (this.password_using_handles_not_b) {
                System.err.println("Error: Expected ~no~ user-supplied handle for this input");
                System.err.println("   PDF password: " + this.argv);
                System.err.println();
                System.err.println("   Handles must be supplied with ~all~ input");
                System.err.println("   PDF passwords, or with ~no~ input PDF passwords.");
                System.err.println("   If no handles are supplied, then passwords are applied");
                System.err.println("   according to input PDF order.");
                System.err.println();
                System.err.println("   Handles are given like this: <handle>=<password>, and");
                System.err.println("   they must be one or more upper-case letters.");
                this.fail_b = true;
            } else {
                this.password_using_handles_b = true;
                Integer it = TK_Session.this.m_input_pdf_index.get(handle);
                if (it != null) {
                    if (TK_Session.this.m_input_pdf.get((int)it.intValue()).m_password.isEmpty()) {
                        pdftk.warn_if_argument_is_password(data);
                        TK_Session.this.m_input_pdf.get((int)it.intValue()).m_password = data;
                    } else {
                        System.err.println("Error: Handle given here: ");
                        System.err.println("      " + this.argv);
                        System.err.println("   is already associated with this password: ");
                        System.err.println("      " + TK_Session.this.m_input_pdf.get((int)it.intValue()).m_password);
                        System.err.println("   Exiting.");
                        this.fail_b = true;
                    }
                } else {
                    System.err.println("Error: Password handle: " + this.argv);
                    System.err.println("   is not associated with an input PDF file.");
                    System.err.println("   Exiting.");
                    this.fail_b = true;
                }
            }
        }

        void parse_state_page_seq() {
            if (TK_Session.this.m_page_seq.isEmpty()) {
                if (TK_Session.this.m_input_pdf.isEmpty()) {
                    System.err.println("Error: No input files.  Exiting.");
                    this.fail_b = true;
                    return;
                }
                if (!TK_Session.this.open_input_pdf_readers()) {
                    this.fail_b = true;
                    return;
                }
            }
            if (this.arg_keyword == keyword.output_k) {
                this.arg_state = ArgState.output_filename_e;
            } else if (this.arg_keyword == keyword.none_k) {
                boolean reverse_sequence_b;
                PageRange page_num;
                boolean even_pages_b = false;
                boolean odd_pages_b = false;
                Pattern p = Pattern.compile("([A-Z]*)(r?)(end|[0-9]*)(-(r?)(end|[0-9]*))?(.*)", 32);
                Matcher m = p.matcher(this.argv);
                m.matches();
                String handle = m.group(1);
                String pre_reverse = m.group(2);
                String pre_range = m.group(3);
                String hyphen = m.group(4);
                String post_reverse = m.group(5);
                String post_range = m.group(6);
                String keywords = m.group(7);
                int range_pdf_index = 0;
                if (!handle.isEmpty()) {
                    Integer it = TK_Session.this.m_input_pdf_index.get(handle);
                    if (it == null) {
                        System.err.println("Error: Given handle has no associated file: ");
                        System.err.println("   " + handle + ", used here: " + this.argv);
                        System.err.println("   Exiting.");
                        this.fail_b = true;
                        return;
                    }
                    range_pdf_index = it;
                }
                if (!(page_num = new PageRange(TK_Session.this.m_input_pdf.get((int)range_pdf_index).m_num_pages, this.argv)).parse(pre_reverse, pre_range, post_reverse, post_range)) {
                    this.fail_b = true;
                    return;
                }
                PageRotate page_rotate = PageRotate.NORTH;
                boolean page_rotate_absolute = false;
                StringBuilder trailing_keywords = new StringBuilder(keywords);
                while (trailing_keywords.length() > 0) {
                    this.arg_keyword = keyword.consume_keyword(trailing_keywords);
                    if (this.arg_keyword == keyword.even_k) {
                        even_pages_b = true;
                        continue;
                    }
                    if (this.arg_keyword == keyword.odd_k) {
                        odd_pages_b = true;
                        continue;
                    }
                    if (this.arg_keyword == keyword.rot_north_k) {
                        page_rotate = PageRotate.NORTH;
                        page_rotate_absolute = true;
                        continue;
                    }
                    if (this.arg_keyword == keyword.rot_east_k) {
                        page_rotate = PageRotate.EAST;
                        page_rotate_absolute = true;
                        continue;
                    }
                    if (this.arg_keyword == keyword.rot_south_k) {
                        page_rotate = PageRotate.SOUTH;
                        page_rotate_absolute = true;
                        continue;
                    }
                    if (this.arg_keyword == keyword.rot_west_k) {
                        page_rotate = PageRotate.WEST;
                        page_rotate_absolute = true;
                        continue;
                    }
                    if (this.arg_keyword == keyword.rot_left_k) {
                        page_rotate = PageRotate.WEST;
                        page_rotate_absolute = false;
                        continue;
                    }
                    if (this.arg_keyword == keyword.rot_right_k) {
                        page_rotate = PageRotate.EAST;
                        page_rotate_absolute = false;
                        continue;
                    }
                    if (this.arg_keyword == keyword.rot_upside_down_k) {
                        page_rotate = PageRotate.SOUTH;
                        page_rotate_absolute = false;
                        continue;
                    }
                    System.err.println("Error: Unexpected text in page range end, here: ");
                    System.err.println("   " + this.argv);
                    System.err.println("   Exiting.");
                    System.err.println("   Acceptable keywords, for example: \"even\" or \"odd\".");
                    System.err.println("   To rotate pages, use: \"north\" \"south\" \"east\"");
                    System.err.println("       \"west\" \"left\" \"right\" or \"down\"");
                    this.fail_b = true;
                    return;
                }
                if (page_num.beg == 0 && page_num.end == 0) {
                    page_num.beg = 1;
                    page_num.end = TK_Session.this.m_input_pdf.get((int)range_pdf_index).m_num_pages;
                    TK_Session.this.m_cat_full_pdfs_b = TK_Session.this.m_cat_full_pdfs_b && !even_pages_b && !odd_pages_b;
                } else {
                    if (page_num.beg == 0 || page_num.end == 0) {
                        System.err.println("Error: Input page numbers include 0 (zero)");
                        System.err.println("   The first PDF page is 1 (one)");
                        System.err.println("   Exiting.");
                        this.fail_b = true;
                        return;
                    }
                    TK_Session.this.m_cat_full_pdfs_b = false;
                }
                ArrayList<PageRef> temp_page_seq = new ArrayList<PageRef>();
                boolean bl = reverse_sequence_b = page_num.end < page_num.beg;
                if (reverse_sequence_b) {
                    int temp = page_num.end;
                    page_num.end = page_num.beg;
                    page_num.beg = temp;
                }
                for (int kk = page_num.beg; kk <= page_num.end; ++kk) {
                    if (even_pages_b && kk % 2 != 0 || odd_pages_b && kk % 2 != 1) continue;
                    if (kk <= TK_Session.this.m_input_pdf.get((int)range_pdf_index).m_num_pages) {
                        boolean associated = false;
                        for (InputPdf.PagesReader it : TK_Session.this.m_input_pdf.get((int)range_pdf_index).m_readers) {
                            if (it.first.contains(kk)) continue;
                            it.first.add(kk);
                            associated = true;
                            break;
                        }
                        if (!associated) {
                            InputPdf.PagesReader new_reader = TK_Session.this.add_reader(TK_Session.this.m_input_pdf.get(range_pdf_index));
                            if (new_reader != null) {
                                new_reader.first.add(kk);
                            } else {
                                System.err.println("Internal Error: unable to add reader");
                                this.fail_b = true;
                                break;
                            }
                        }
                        temp_page_seq.add(new PageRef(range_pdf_index, kk, page_rotate, page_rotate_absolute));
                        continue;
                    }
                    System.err.println("Error: Page number: " + kk);
                    System.err.println("   does not exist in file: " + TK_Session.this.m_input_pdf.get((int)range_pdf_index).m_filename);
                    this.fail_b = true;
                }
                if (this.fail_b) {
                    return;
                }
                if (reverse_sequence_b) {
                    Collections.reverse(temp_page_seq);
                }
                TK_Session.this.m_page_seq.add(temp_page_seq);
            } else {
                System.err.println("Error: expecting page ranges.  Instead, I got:");
                System.err.println("   " + this.argv);
                this.fail_b = true;
                return;
            }
        }

        void parse_state_form_data_filename() {
            if (this.arg_keyword == keyword.none_k) {
                if (!TK_Session.this.m_form_data_filename.isEmpty()) {
                    System.err.println("Error: Multiple fill_form filenames given: ");
                    System.err.println("   " + TK_Session.this.m_form_data_filename + " and " + this.argv);
                    System.err.println("Exiting.");
                    this.fail_b = true;
                    return;
                }
                TK_Session.this.m_form_data_filename = this.argv;
            } else {
                System.err.println("Error: expecting a form data filename,");
                System.err.println("   instead I got this keyword: " + this.argv);
                System.err.println("Exiting.");
                this.fail_b = true;
                return;
            }
            this.arg_state = ArgState.output_e;
        }

        void parse_state_attach_file_filename() {
            if (this.arg_keyword == keyword.attach_file_to_page_k) {
                this.arg_state = ArgState.attach_file_pagenum_e;
            } else if (this.arg_keyword == keyword.attach_file_relation_k) {
                this.arg_state = ArgState.attach_file_relation_e;
            } else if (this.arg_keyword == keyword.output_k) {
                this.arg_state = ArgState.output_filename_e;
            } else if (this.arg_keyword == keyword.none_k) {
                TK_Session.this.m_input_attach_file_filename.add(this.argv);
            } else {
                System.err.println("Error: expecting an attachment filename,");
                System.err.println("   instead I got this keyword: " + this.argv);
                System.err.println("Exiting.");
                this.fail_b = true;
                return;
            }
        }

        void parse_state_attach_file_pagenum() {
            if (this.argv.equals("PROMPT")) {
                TK_Session.this.m_input_attach_file_pagenum = -1;
            } else if (this.argv.equals("end")) {
                TK_Session.this.m_input_attach_file_pagenum = -2;
            } else {
                try {
                    TK_Session.this.m_input_attach_file_pagenum = Integer.parseInt(this.argv);
                }
                catch (NumberFormatException e) {
                    System.err.println("Error: expecting a (1-based) page number.  Instead, I got:");
                    System.err.println("   " + this.argv);
                    System.err.println("Exiting.");
                    this.fail_b = true;
                }
            }
            this.arg_state = ArgState.output_e;
        }

        void parse_state_attach_file_relation() {
            if (this.argv.matches("(?i)Source|Data|Alternative|Supplement|Unspecified")) {
                this.argv = WordUtils.capitalizeFully((String)this.argv);
            } else {
                System.err.println("Warning: non-standard attachment relationship: " + this.argv + ".");
            }
            TK_Session.this.m_input_attach_file_relation = this.argv;
            this.arg_state = ArgState.output_e;
        }

        void parse_state_update_info_filename() {
            if (this.arg_keyword == keyword.none_k) {
                if (!TK_Session.this.m_update_info_filename.isEmpty()) {
                    System.err.println("Error: Multiple update_info filenames given: ");
                    System.err.println("   " + TK_Session.this.m_update_info_filename + " and " + this.argv);
                    System.err.println("Exiting.");
                    this.fail_b = true;
                    return;
                }
            } else {
                System.err.println("Error: expecting an INFO file filename,");
                System.err.println("   instead I got this keyword: " + this.argv);
                System.err.println("Exiting.");
                this.fail_b = true;
                return;
            }
            TK_Session.this.m_update_info_filename = this.argv;
            this.arg_state = ArgState.output_e;
        }

        void parse_state_output() {
            if (TK_Session.this.m_input_pdf.isEmpty()) {
                System.err.println("Error: No input files.  Exiting.");
                this.fail_b = true;
                return;
            }
            if (this.arg_keyword != keyword.output_k) {
                System.err.println("Error: expecting \"output\" keyword.  Instead, I got:");
                System.err.println("   " + this.argv);
                this.fail_b = true;
                return;
            }
            this.arg_state = ArgState.output_filename_e;
        }

        void parse_state_output_filename() {
            if (TK_Session.this.m_operation == keyword.none_k) {
                TK_Session.this.m_operation = 1 < TK_Session.this.m_input_pdf.size() ? keyword.cat_k : keyword.filter_k;
            }
            if (!TK_Session.this.open_input_pdf_readers()) {
                this.fail_b = true;
                return;
            }
            if ((TK_Session.this.m_operation == keyword.cat_k || TK_Session.this.m_operation == keyword.shuffle_k) && TK_Session.this.m_page_seq.isEmpty()) {
                for (int ii = 0; ii < TK_Session.this.m_input_pdf.size(); ++ii) {
                    InputPdf input_pdf = TK_Session.this.m_input_pdf.get(ii);
                    ArrayList<PageRef> temp_page_seq = new ArrayList<PageRef>();
                    for (int jj = 1; jj <= input_pdf.m_num_pages; ++jj) {
                        temp_page_seq.add(new PageRef(ii, jj));
                        input_pdf.m_readers.get((int)(input_pdf.m_readers.size() - 1)).first.add(jj);
                    }
                    TK_Session.this.m_page_seq.add(temp_page_seq);
                }
            }
            if (TK_Session.this.m_output_filename.isEmpty()) {
                TK_Session.this.m_output_filename = this.argv;
                if (!TK_Session.this.m_output_filename.equals("-")) {
                    for (InputPdf it : TK_Session.this.m_input_pdf) {
                        if (!it.m_filename.equals(TK_Session.this.m_output_filename)) continue;
                        System.err.println("Error: The given output filename: " + TK_Session.this.m_output_filename);
                        System.err.println("   matches an input filename.  Exiting.");
                        this.fail_b = true;
                        break;
                    }
                }
            } else {
                System.err.println("Error: Multiple output filenames given: ");
                System.err.println("   " + TK_Session.this.m_output_filename + " and " + this.argv);
                System.err.println("Exiting.");
                this.fail_b = true;
                return;
            }
            this.arg_state = ArgState.output_args_e;
        }

        void parse_state_output_args() {
            ArgStateMutable arg_state_m = new ArgStateMutable();
            arg_state_m.value = this.arg_state;
            if (!TK_Session.this.handle_some_output_options(this.arg_keyword, arg_state_m)) {
                System.err.println("Error: Unexpected data in output section: ");
                System.err.println("      " + this.argv);
                System.err.println("Exiting.");
                this.fail_b = true;
                return;
            }
            this.arg_state = arg_state_m.value;
        }

        void parse_state_output_owner_pw() {
            if (TK_Session.this.m_output_owner_pw.isEmpty()) {
                if (!this.argv.equals("PROMPT") && this.argv.equals(TK_Session.this.m_output_user_pw)) {
                    System.err.println("Error: The user and owner passwords are the same.");
                    System.err.println("   PDF Viewers interpret this to mean your PDF has");
                    System.err.println("   no owner password, so they must be different.");
                    System.err.println("   Or, supply no owner password to pdftk if this is");
                    System.err.println("   what you desire.");
                    System.err.println("Exiting.");
                    this.fail_b = true;
                    return;
                }
            } else {
                System.err.println("Error: Multiple output owner passwords given: ");
                System.err.println("   " + TK_Session.this.m_output_owner_pw + " and " + this.argv);
                System.err.println("Exiting.");
                this.fail_b = true;
                return;
            }
            pdftk.warn_if_argument_is_password(this.argv);
            TK_Session.this.m_output_owner_pw = this.argv;
            this.arg_state = ArgState.output_args_e;
        }

        void parse_state_output_user_pw() {
            if (TK_Session.this.m_output_user_pw.isEmpty()) {
                if (!this.argv.equals("PROMPT") && TK_Session.this.m_output_owner_pw.equals(this.argv)) {
                    System.err.println("Error: The user and owner passwords are the same.");
                    System.err.println("   PDF Viewers interpret this to mean your PDF has");
                    System.err.println("   no owner password, so they must be different.");
                    System.err.println("   Or, supply no owner password to pdftk if this is");
                    System.err.println("   what you desire.");
                    System.err.println("Exiting.");
                    this.fail_b = true;
                    return;
                }
            } else {
                System.err.println("Error: Multiple output user passwords given: ");
                System.err.println("   " + TK_Session.this.m_output_user_pw + " and " + this.argv);
                System.err.println("Exiting.");
                this.fail_b = true;
                return;
            }
            pdftk.warn_if_argument_is_password(this.argv);
            TK_Session.this.m_output_user_pw = this.argv;
            this.arg_state = ArgState.output_args_e;
        }

        void parse_state_output_user_perms() {
            ArgStateMutable arg_state_m = new ArgStateMutable();
            arg_state_m.value = this.arg_state;
            if (TK_Session.this.handle_some_output_options(this.arg_keyword, arg_state_m)) {
                this.arg_state = arg_state_m.value;
                return;
            }
            switch (this.arg_keyword) {
                case perm_printing_k: {
                    TK_Session.this.m_output_user_perms |= 0x804;
                    break;
                }
                case perm_modify_contents_k: {
                    TK_Session.this.m_output_user_perms |= 0x408;
                    break;
                }
                case perm_copy_contents_k: {
                    TK_Session.this.m_output_user_perms |= 0x210;
                    break;
                }
                case perm_modify_annotations_k: {
                    TK_Session.this.m_output_user_perms |= 0x120;
                    break;
                }
                case perm_fillin_k: {
                    TK_Session.this.m_output_user_perms |= 0x100;
                    break;
                }
                case perm_screen_readers_k: {
                    TK_Session.this.m_output_user_perms |= 0x200;
                    break;
                }
                case perm_assembly_k: {
                    TK_Session.this.m_output_user_perms |= 0x400;
                    break;
                }
                case perm_degraded_printing_k: {
                    TK_Session.this.m_output_user_perms |= 4;
                    break;
                }
                case perm_all_k: {
                    TK_Session.this.m_output_user_perms = 3900;
                    break;
                }
                default: {
                    System.err.println("Error: Unexpected data in output section: ");
                    System.err.println("      " + this.argv);
                    System.err.println("Exiting.");
                    this.fail_b = true;
                }
            }
        }

        void parse_state_background_filename() {
            if (this.arg_keyword == keyword.none_k) {
                if (!TK_Session.this.m_background_filename.isEmpty()) {
                    System.err.println("Error: Multiple background filenames given: ");
                    System.err.println("   " + TK_Session.this.m_background_filename + " and " + this.argv);
                    System.err.println("Exiting.");
                    this.fail_b = true;
                    return;
                }
            } else {
                System.err.println("Error: expecting a PDF filename for background operation,");
                System.err.println("   instead I got this keyword: " + this.argv);
                System.err.println("Exiting.");
                this.fail_b = true;
                return;
            }
            TK_Session.this.m_background_filename = this.argv;
            this.arg_state = ArgState.output_args_e;
        }

        void parse_state_stamp_filename() {
            if (this.arg_keyword == keyword.none_k) {
                if (!TK_Session.this.m_stamp_filename.isEmpty()) {
                    System.err.println("Error: Multiple stamp filenames given: ");
                    System.err.println("   " + TK_Session.this.m_stamp_filename + " and " + this.argv);
                    System.err.println("Exiting.");
                    this.fail_b = true;
                    return;
                }
            } else {
                System.err.println("Error: expecting a PDF filename for stamp operation,");
                System.err.println("   instead I got this keyword: " + this.argv);
                System.err.println("Exiting.");
                this.fail_b = true;
                return;
            }
            TK_Session.this.m_stamp_filename = this.argv;
            this.arg_state = ArgState.output_e;
        }
    }

    private static enum ArgState {
        input_files_e,
        input_pw_e,
        page_seq_e,
        form_data_filename_e,
        attach_file_filename_e,
        attach_file_pagenum_e,
        attach_file_relation_e,
        update_info_filename_e,
        update_xmp_filename_e,
        output_e,
        output_filename_e,
        output_args_e,
        output_owner_pw_e,
        output_user_pw_e,
        output_user_perms_e,
        background_filename_e,
        stamp_filename_e,
        done_e;

    }
}

