/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.Annotated;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.DisplayPositionned;
import net.sourceforge.plantuml.cucadiagram.DisplaySection;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.svek.DecorateEntityImage;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class AnnotatedWorker {
    private final Annotated annotated;
    private final ISkinParam skinParam;
    private final StringBounder stringBounder;

    public AnnotatedWorker(Annotated annotated, ISkinParam skinParam, StringBounder stringBounder) {
        this.annotated = annotated;
        this.skinParam = skinParam;
        this.stringBounder = stringBounder;
    }

    public TextBlockBackcolored addAdd(TextBlock result) {
        result = this.addFrame(result);
        result = this.addLegend(result);
        result = this.addTitle(result);
        result = this.addCaption(result);
        result = this.addHeaderAndFooter(result);
        return (TextBlockBackcolored)result;
    }

    public boolean hasMainFrame() {
        return this.annotated.getMainFrame() != null;
    }

    public TextBlock addFrame(final TextBlock original) {
        Display mainFrame = this.annotated.getMainFrame();
        if (mainFrame == null) {
            return original;
        }
        double x1 = 5.0;
        double x2 = 7.0;
        double y1 = 10.0;
        double y2 = 10.0;
        final SymbolContext symbolContext = new SymbolContext(this.getBackgroundColor(), HColorUtils.BLACK).withShadow(this.getSkinParam().shadowing(null) ? 3.0 : 0.0);
        final MinMax originalMinMax = TextBlockUtils.getMinMax(original, this.stringBounder, false);
        TextBlock title = mainFrame.create(new FontConfiguration(this.getSkinParam(), FontParam.CAPTION, null), HorizontalAlignment.CENTER, this.getSkinParam());
        final Dimension2D dimTitle = title.calculateDimension(this.stringBounder);
        double width = 5.0 + Math.max(originalMinMax.getWidth(), dimTitle.getWidth()) + 7.0;
        double height = dimTitle.getHeight() + 10.0 + originalMinMax.getHeight() + 10.0;
        final TextBlock frame = USymbol.FRAME.asBig(title, HorizontalAlignment.LEFT, TextBlockUtils.empty(0.0, 0.0), width, height, symbolContext, this.skinParam.getStereotypeAlignment());
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                frame.drawU(ug.apply(UTranslate.dx(originalMinMax.getMinX())));
                original.drawU(ug.apply(new UTranslate(5.0, 10.0 + dimTitle.getHeight())));
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                return TextBlockUtils.getMinMax(this, stringBounder, false);
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                Rectangle2D rect = original.getInnerPosition(member, stringBounder, strategy);
                return new Rectangle2D.Double(rect.getX() + 5.0, rect.getY() + 10.0 + dimTitle.getHeight(), rect.getWidth(), rect.getHeight());
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return original.calculateDimension(stringBounder);
            }

            @Override
            public HColor getBackcolor() {
                return symbolContext.getBackColor();
            }
        };
    }

    private HColor getBackgroundColor() {
        return this.getSkinParam().getBackgroundColor(false);
    }

    private TextBlock addLegend(TextBlock original) {
        DisplayPositionned legend = this.annotated.getLegend();
        if (legend.isNull()) {
            return original;
        }
        TextBlock text = EntityImageLegend.create(legend.getDisplay(), this.getSkinParam());
        return DecorateEntityImage.add(original, text, legend.getHorizontalAlignment(), legend.getVerticalAlignment());
    }

    private ISkinParam getSkinParam() {
        return this.skinParam;
    }

    private TextBlock addCaption(TextBlock original) {
        DisplayPositionned caption = this.annotated.getCaption();
        if (caption.isNull()) {
            return original;
        }
        TextBlock text = this.getCaption();
        return DecorateEntityImage.addBottom(original, text, HorizontalAlignment.CENTER);
    }

    public TextBlock getCaption() {
        DisplayPositionned caption = this.annotated.getCaption();
        if (caption.isNull()) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        if (UseStyle.useBetaStyle()) {
            Style style = StyleSignature.of(SName.root, SName.caption).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
            return style.createTextBlockBordered(caption.getDisplay(), this.skinParam.getIHtmlColorSet(), this.skinParam);
        }
        return caption.getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.CAPTION, null), HorizontalAlignment.CENTER, this.getSkinParam());
    }

    private TextBlock addTitle(TextBlock original) {
        TextBlock block;
        DisplayPositionned title = this.annotated.getTitle();
        if (title.isNull()) {
            return original;
        }
        if (UseStyle.useBetaStyle()) {
            Style style = StyleSignature.of(SName.root, SName.title).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
            block = style.createTextBlockBordered(title.getDisplay(), this.skinParam.getIHtmlColorSet(), this.skinParam);
        } else {
            ISkinParam skinParam = this.getSkinParam();
            FontConfiguration fontConfiguration = new FontConfiguration(skinParam, FontParam.TITLE, null);
            block = TextBlockUtils.title(fontConfiguration, title.getDisplay(), skinParam);
        }
        return DecorateEntityImage.addTop(original, block, HorizontalAlignment.CENTER);
    }

    private TextBlock addHeaderAndFooter(TextBlock original) {
        DisplaySection footer = this.annotated.getFooter();
        DisplaySection header = this.annotated.getHeader();
        if (footer.isNull() && header.isNull()) {
            return original;
        }
        TextBlock textFooter = null;
        if (!footer.isNull()) {
            textFooter = footer.createRibbon(new FontConfiguration(this.getSkinParam(), FontParam.FOOTER, null), this.getSkinParam());
        }
        TextBlock textHeader = null;
        if (!header.isNull()) {
            textHeader = header.createRibbon(new FontConfiguration(this.getSkinParam(), FontParam.HEADER, null), this.getSkinParam());
        }
        return DecorateEntityImage.addTopAndBottom(original, textHeader, header.getHorizontalAlignment(), textFooter, footer.getHorizontalAlignment());
    }
}

