/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.geom.LineSegmentDouble;

public abstract class AbstractLineSegment
extends Line2D {
    public final boolean equals(Object obj) {
        AbstractLineSegment other = (AbstractLineSegment)obj;
        return this.getP1().equals(other.getP1()) && this.getP2().equals(other.getP2());
    }

    public final int hashCode() {
        int result = 7;
        int multiplier = 17;
        result = result * 17 + this.getP1().hashCode();
        result = result * 17 + this.getP2().hashCode();
        return result;
    }

    public final double getLength() {
        return Math.sqrt((this.getP2().getX() - this.getP1().getX()) * (this.getP2().getX() - this.getP1().getX()) + (this.getP2().getY() - this.getP1().getY()) * (this.getP2().getY() - this.getP1().getY()));
    }

    protected final Point2D.Double getPoint2D(double u) {
        double x = this.getP1().getX() + u * (this.getP2().getX() - this.getP1().getX());
        double y = this.getP1().getY() + u * (this.getP2().getY() - this.getP1().getY());
        return new Point2D.Double(x, y);
    }

    public final double getDistance(Point2D f) {
        return this.ptSegDist(f);
    }

    public Point2D getSegIntersection(AbstractLineSegment other) {
        double u;
        if (other.isVertical()) {
            u = this.getIntersectionVertical(other.getP1().getX());
        } else if (other.isHorizontal()) {
            u = this.getIntersectionHorizontal(other.getP1().getY());
        } else {
            return this.getDichoIntersection(other);
        }
        if (Double.isNaN(u) || u < 0.0 || u > 1.0) {
            return null;
        }
        Point2D.Double result = this.getPoint2D(u);
        if (AbstractLineSegment.isBetween(result, other.getP1(), other.getP2())) {
            return result;
        }
        return null;
    }

    private Point2D getDichoIntersection(AbstractLineSegment other) {
        if (!this.doesIntersect(other)) {
            return null;
        }
        if (other.getLength() < 0.01) {
            return other.getMiddle();
        }
        LineSegmentDouble p1 = new LineSegmentDouble(other.getP1(), other.getMiddle());
        LineSegmentDouble p2 = new LineSegmentDouble(other.getMiddle(), other.getP2());
        if (this.doesIntersect(p1)) {
            return this.getDichoIntersection(p1);
        }
        if (this.doesIntersect(p2)) {
            return this.getDichoIntersection(p2);
        }
        throw new IllegalStateException();
    }

    private Point2D.Double getMiddle() {
        return this.getPoint2D(0.5);
    }

    private static boolean isBetween(double value, double v1, double v2) {
        if (v1 < v2) {
            return value >= v1 && value <= v2;
        }
        assert (v2 <= v1);
        return value >= v2 && value <= v1;
    }

    static boolean isBetween(Point2D toTest, Point2D pos1, Point2D pos2) {
        return AbstractLineSegment.isBetween(toTest.getX(), pos1.getX(), pos2.getX()) && AbstractLineSegment.isBetween(toTest.getY(), pos1.getY(), pos2.getY());
    }

    public double getIntersectionVertical(double xOther) {
        double coef = this.getP2().getX() - this.getP1().getX();
        if (coef == 0.0) {
            return Double.NaN;
        }
        return (xOther - this.getP1().getX()) / coef;
    }

    public double getIntersectionHorizontal(double yOther) {
        double coef = this.getP2().getY() - this.getP1().getY();
        if (coef == 0.0) {
            return Double.NaN;
        }
        return (yOther - this.getP1().getY()) / coef;
    }

    @Override
    public final void setLine(double x1, double y1, double x2, double y2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Rectangle2D getBounds2D() {
        double h;
        double y;
        double w;
        double x;
        if (this.getX1() < this.getX2()) {
            x = this.getX1();
            w = this.getX2() - this.getX1();
        } else {
            x = this.getX2();
            w = this.getX1() - this.getX2();
        }
        if (this.getY1() < this.getY2()) {
            y = this.getY1();
            h = this.getY2() - this.getY1();
        } else {
            y = this.getY2();
            h = this.getY1() - this.getY2();
        }
        return new Rectangle2D.Double(x, y, w, h);
    }

    public final boolean isHorizontal() {
        return this.getP1().getY() == this.getP2().getY();
    }

    public final boolean isVertical() {
        return this.getP1().getX() == this.getP2().getX();
    }

    public final double getDistance(AbstractLineSegment other) {
        double result = this.getDistanceInternal(other);
        assert (this.equals(result, other.getDistanceInternal(this)));
        return result;
    }

    private boolean equals(double a1, double a2) {
        return Math.abs(a1 - a2) < 1.0E-4;
    }

    public boolean isPointOnSegment(Point2D pt) {
        return this.equals(pt.distance(this.getP1()) + pt.distance(this.getP2()), this.getLength());
    }

    private double getDistanceInternal(AbstractLineSegment other) {
        double result = this.getDistance(other.getP1());
        result += this.getDistance(other.getP2());
        result += other.getDistance(this.getP1());
        return result += other.getDistance(this.getP2());
    }

    public final double getAngle() {
        return Math.atan2(this.getP2().getY() - this.getP1().getY(), this.getP2().getX() - this.getP1().getX());
    }

    public final double getOppositeAngle() {
        return Math.atan2(this.getP1().getY() - this.getP2().getY(), this.getP1().getX() - this.getP2().getX());
    }

    public final Point2D.Double startTranslatedAsVector(double u) {
        double pour = 1.0 * u / 100.0;
        double x = this.getP1().getX() + pour * (this.getP2().getX() - this.getP1().getX());
        double y = this.getP1().getY() + pour * (this.getP2().getY() - this.getP1().getY());
        return new Point2D.Double(x, y);
    }

    public boolean doesIntersect(AbstractLineSegment other) {
        boolean result = this.doesIntersectInternal(other);
        assert (result == other.doesIntersectInternal(this));
        return result;
    }

    private boolean doesIntersectInternal(AbstractLineSegment other) {
        boolean result;
        double d1 = AbstractLineSegment.direction(other.getP1(), other.getP2(), this.getP1());
        double d2 = AbstractLineSegment.direction(other.getP1(), other.getP2(), this.getP2());
        double d3 = AbstractLineSegment.direction(this.getP1(), this.getP2(), other.getP1());
        double d4 = AbstractLineSegment.direction(this.getP1(), this.getP2(), other.getP2());
        if (d1 == 0.0 && AbstractLineSegment.isBetween(this.getP1(), other.getP1(), other.getP2())) {
            return true;
        }
        if (d2 == 0.0 && AbstractLineSegment.isBetween(this.getP2(), other.getP1(), other.getP2())) {
            return true;
        }
        if (d3 == 0.0 && AbstractLineSegment.isBetween(other.getP1(), this.getP1(), this.getP2())) {
            return true;
        }
        if (d4 == 0.0 && AbstractLineSegment.isBetween(other.getP2(), this.getP1(), this.getP2())) {
            return true;
        }
        boolean bl = result = AbstractLineSegment.signDiffers(d1, d2) && AbstractLineSegment.signDiffers(d3, d4);
        assert (this.intersectsLine(other) == result);
        return result;
    }

    private static double direction(Point2D origin, Point2D point1, Point2D point2) {
        return AbstractLineSegment.determinant(point2.getX() - origin.getX(), point2.getY() - origin.getY(), point1.getX() - origin.getX(), point1.getY() - origin.getY());
    }

    private static boolean signDiffers(double a, double b) {
        if (a > 0.0 && b < 0.0) {
            return true;
        }
        return a < 0.0 && b > 0.0;
    }

    public double determinant(AbstractLineSegment other) {
        return AbstractLineSegment.determinant(this.getP1().getX() - this.getP2().getX(), this.getP1().getY() - this.getP2().getY(), other.getP1().getX() - other.getP2().getX(), other.getP1().getY() - other.getP2().getY());
    }

    private static double determinant(double x1, double y1, double x2, double y2) {
        return x1 * y2 - x2 * y1;
    }

    public double side(Point2D point) {
        return AbstractLineSegment.direction(this.getP1(), this.getP2(), point);
    }
}

