/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.url;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.ivy.plugins.repository.AbstractRepository;
import org.apache.ivy.plugins.repository.RepositoryCopyProgressListener;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.url.ApacheURLLister;

public final class URLRepository
extends AbstractRepository {
    private RepositoryCopyProgressListener progress = new RepositoryCopyProgressListener(this);
    private Map resourcesCache = new HashMap();
    private ApacheURLLister lister = new ApacheURLLister();

    @Override
    public final Resource getResource(String string) {
        Resource resource = (Resource)this.resourcesCache.get(string);
        if (resource == null) {
            resource = new URLResource(new URL(string));
            this.resourcesCache.put(string, resource);
        }
        return resource;
    }

    @Override
    public final void get(String string, File file2) {
        this.fireTransferInitiated$553fe46a(this.getResource(string));
        try {
            long l = this.getResource(string).getContentLength();
            if (l > 0L) {
                this.progress.setTotalLength(new Long(l));
            }
            FileUtil.copy(new URL(string), file2, (CopyProgressListener)this.progress);
            return;
        }
        catch (IOException iOException) {
            this.fireTransferError$698b7e31();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.fireTransferError$698b7e31();
            throw runtimeException;
        }
        finally {
            this.progress.setTotalLength(null);
        }
    }

    @Override
    public final List list(String string) {
        if (string.startsWith("http")) {
            List list = ApacheURLLister.listAll(new URL(string));
            if (list != null) {
                ArrayList<String> arrayList = new ArrayList<String>(list.size());
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    URL uRL = (URL)listIterator.next();
                    arrayList.add(uRL.toExternalForm());
                }
                return arrayList;
            }
        } else if (string.startsWith("file")) {
            String string2;
            Comparable<URI> comparable;
            try {
                comparable = new URI(string);
                string2 = ((URI)comparable).isOpaque() ? ((URI)comparable).getSchemeSpecificPart() : ((URI)comparable).getPath();
            }
            catch (URISyntaxException uRISyntaxException) {
                IOException iOException = new IOException("Couldn't list content of '" + string + "'");
                iOException.initCause(uRISyntaxException);
                throw iOException;
            }
            comparable = new File(string2);
            if (((File)comparable).exists() && ((File)comparable).isDirectory()) {
                String[] stringArray = ((File)comparable).list();
                ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
                URL uRL = string2.endsWith("/") ? new URL(string) : new URL(string + "/");
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList.add(new URL(uRL, stringArray[i]).toExternalForm());
                }
                return arrayList;
            }
            return Collections.EMPTY_LIST;
        }
        return null;
    }
}

